/*
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (C) 2024 Bernd Moessner
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _XPARAMETERS_PS_H_
#define _XPARAMETERS_PS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define XPAR_SCUGIC_0_DIST_BASEADDR 0xF8F01000U
#define XPS_SYS_CTRL_BASEADDR		0xF8000000U

#define XPAR_XEMACPS_NUM_INSTANCES 2

#define XPAR_PS7_ETHERNET_0_DEVICE_ID 0
#define XPAR_PS7_ETHERNET_0_BASEADDR 0xE000B000
#define XPAR_PS7_ETHERNET_0_HIGHADDR 0xE000BFFF
#define XPAR_PS7_ETHERNET_0_ENET_CLK_FREQ_HZ 125000000
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_1000MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_1000MBPS_DIV1 1
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_100MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_100MBPS_DIV1 5
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_10MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_10MBPS_DIV1 50
#define XPAR_PS7_ETHERNET_0_ENET_TSU_CLK_FREQ_HZ 0

#define XPAR_PS7_ETHERNET_0_IS_CACHE_COHERENT 0
#define XPAR_XEMACPS_0_IS_CACHE_COHERENT 0

#define XPAR_XEMACPS_0_DEVICE_ID XPAR_PS7_ETHERNET_0_DEVICE_ID
#define XPAR_XEMACPS_0_BASEADDR 0xE000B000
#define XPAR_XEMACPS_0_HIGHADDR 0xE000BFFF
#define XPAR_XEMACPS_0_ENET_CLK_FREQ_HZ 125000000
#define XPAR_XEMACPS_0_ENET_SLCR_1000Mbps_DIV0 8
#define XPAR_XEMACPS_0_ENET_SLCR_1000Mbps_DIV1 1
#define XPAR_XEMACPS_0_ENET_SLCR_100Mbps_DIV0 8
#define XPAR_XEMACPS_0_ENET_SLCR_100Mbps_DIV1 5
#define XPAR_XEMACPS_0_ENET_SLCR_10Mbps_DIV0 8
#define XPAR_XEMACPS_0_ENET_SLCR_10Mbps_DIV1 50
#define XPAR_XEMACPS_0_ENET_TSU_CLK_FREQ_HZ 0

#define XPAR_PS7_ETHERNET_1_DEVICE_ID 1
#define XPAR_PS7_ETHERNET_1_BASEADDR 0xE000C000
#define XPAR_PS7_ETHERNET_1_HIGHADDR 0xE000CFFF
#define XPAR_PS7_ETHERNET_1_ENET_CLK_FREQ_HZ 125000000
#define XPAR_PS7_ETHERNET_1_ENET_SLCR_1000MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_1_ENET_SLCR_1000MBPS_DIV1 1
#define XPAR_PS7_ETHERNET_1_ENET_SLCR_100MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_1_ENET_SLCR_100MBPS_DIV1 5
#define XPAR_PS7_ETHERNET_1_ENET_SLCR_10MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_1_ENET_SLCR_10MBPS_DIV1 50
#define XPAR_PS7_ETHERNET_1_ENET_TSU_CLK_FREQ_HZ 0

#define XPAR_PS7_ETHERNET_1_IS_CACHE_COHERENT 0
#define XPAR_XEMACPS_1_IS_CACHE_COHERENT 0

#define XPAR_XEMACPS_1_DEVICE_ID XPAR_PS7_ETHERNET_1_DEVICE_ID
#define XPAR_XEMACPS_1_BASEADDR 0xE000C000
#define XPAR_XEMACPS_1_HIGHADDR 0xE000CFFF
#define XPAR_XEMACPS_1_ENET_CLK_FREQ_HZ 125000000
#define XPAR_XEMACPS_1_ENET_SLCR_1000Mbps_DIV0 8
#define XPAR_XEMACPS_1_ENET_SLCR_1000Mbps_DIV1 1
#define XPAR_XEMACPS_1_ENET_SLCR_100Mbps_DIV0 8
#define XPAR_XEMACPS_1_ENET_SLCR_100Mbps_DIV1 5
#define XPAR_XEMACPS_1_ENET_SLCR_10Mbps_DIV0 8
#define XPAR_XEMACPS_1_ENET_SLCR_10Mbps_DIV1 50
#define XPAR_XEMACPS_1_ENET_TSU_CLK_FREQ_HZ 0

#ifdef __cplusplus
}
#endif

#endif
