/* SPDX-License-Identifier: BSD-2-Clause */

/**
 *  @file
 *  @brief makecontext() API Conformance Test
 */

/*
 * Copyright (C) 2018 Jacob Shin
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define _XOPEN_SOURCE_EXTENDED 1

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <ucontext.h>
#include <stdlib.h>

#define STACK_SIZE (1<<15) // 32KiB

int test( void );
void func( void );

int test( void )
{
  ucontext_t context;
  context.uc_stack.ss_sp = (char *) malloc(STACK_SIZE);
  context.uc_stack.ss_size = STACK_SIZE;
  context.uc_link = 0;
  context.uc_stack.ss_flags = 0;
  ucontext_t *ucp = &context;
  getcontext(ucp);

  makecontext(ucp, (void *)func, 0);

  setcontext(ucp);
  abort();
  return 0;
}

void func( void )
{
	return;
}
