/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSImplDoxygen
 *
 * @brief This header file defines high level Doxygen groups.
 */

/*
 * Copyright (C) 2019, 2023 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @defgroup RTEMSAPI API
 *
 * @brief This group contains the Application Programming Interfaces (APIs) of
 *   RTEMS.
 */

/**
 * @defgroup RTEMSAPISystemLibrary System Library
 *
 * @ingroup RTEMSAPI
 *
 * @brief This group contains the system library APIs of RTEMS.
 */

/**
 * @defgroup RTEMSDeviceDrivers Device Drivers
 *
 * @brief This group contains the device drivers.
 */

/**
 * @defgroup RTEMSDeviceConsole Console Drivers
 *
 * @ingroup RTEMSDeviceDrivers
 *
 * @brief This group contains the console drivers.
 */

/**
 * @defgroup RTEMSImpl Implementation
 *
 * @brief This group contains the RTEMS implementation components.
 */

/**
 * @defgroup RTEMSImplDoxygen Doxygen Support
 *
 * @ingroup RTEMSImpl
 */

/**
 * @defgroup RTEMSImplFreeBSDKernel FreeBSD Kernel Space Support
 *
 * @ingroup RTEMSImpl
 *
 * @brief This group contains the interfaces used by FreeBSD kernel space
 *   components ported to RTEMS.
 */

/**
 * @defgroup RTEMSTestSuites Test Suites
 *
 * @brief This group contains the test suites.
 */

/**
 * @defgroup RTEMSTestSuitesFilesystem Filesystem Test Suites
 *
 * @ingroup RTEMSTestSuites
 *
 * @brief This group contains the test suites related to filesystem tests.
 */

/**
 * @defgroup RTEMSTestSuitesUnit Unit Test Suites
 *
 * @ingroup RTEMSTestSuites
 *
 * @brief This group contains the test suites related to unit tests.
 */

/**
 * @defgroup RTEMSTestSuitesValidation Validation Test Suites
 *
 * @ingroup RTEMSTestSuites
 *
 * @brief This group contains the test suites related to validation tests.
 */
