/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSBSPsM68kGenMCF548X
 *
 * @brief Initializes variable tables of different types of tasks.
 *
 * @warning Do not edit!
 */

/*
 * Copyright (C) 2009 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <mcf548x/MCD_dma.h>
#include <mcf548x/MCD_tasksInit.h>

extern dmaRegs *MCD_dmaBar;

/*
 * Task 0
 */

void  MCD_startDmaChainNoEu(int *currBD, short srcIncr, short destIncr, int xferSize, short xferSizeIncr, int *cSave, volatile TaskTableEntry *taskTable, int channel)
{

    MCD_SET_VAR(taskTable+channel, 2, (u32)currBD); /* var[2] */
    MCD_SET_VAR(taskTable+channel, 25, (u32)(0xe000 << 16) | (0xffff & srcIncr));   /* inc[1] */
    MCD_SET_VAR(taskTable+channel, 24, (u32)(0xe000 << 16) | (0xffff & destIncr));  /* inc[0] */
    MCD_SET_VAR(taskTable+channel, 11, (u32)xferSize);  /* var[11] */
    MCD_SET_VAR(taskTable+channel, 26, (u32)(0x2000 << 16) | (0xffff & xferSizeIncr));  /* inc[2] */
    MCD_SET_VAR(taskTable+channel, 0, (u32)cSave);  /* var[0] */
    MCD_SET_VAR(taskTable+channel, 1, (u32)0x00000000); /* var[1] */
    MCD_SET_VAR(taskTable+channel, 3, (u32)0x00000000); /* var[3] */
    MCD_SET_VAR(taskTable+channel, 4, (u32)0x00000000); /* var[4] */
    MCD_SET_VAR(taskTable+channel, 5, (u32)0x00000000); /* var[5] */
    MCD_SET_VAR(taskTable+channel, 6, (u32)0x00000000); /* var[6] */
    MCD_SET_VAR(taskTable+channel, 7, (u32)0x00000000); /* var[7] */
    MCD_SET_VAR(taskTable+channel, 8, (u32)0x00000000); /* var[8] */
    MCD_SET_VAR(taskTable+channel, 9, (u32)0x00000000); /* var[9] */
    MCD_SET_VAR(taskTable+channel, 10, (u32)0x00000000);    /* var[10] */
    MCD_SET_VAR(taskTable+channel, 12, (u32)0x00000000);    /* var[12] */
    MCD_SET_VAR(taskTable+channel, 13, (u32)0x80000000);    /* var[13] */
    MCD_SET_VAR(taskTable+channel, 14, (u32)0x00000010);    /* var[14] */
    MCD_SET_VAR(taskTable+channel, 15, (u32)0x00000004);    /* var[15] */
    MCD_SET_VAR(taskTable+channel, 16, (u32)0x08000000);    /* var[16] */
    MCD_SET_VAR(taskTable+channel, 27, (u32)0x00000000);    /* inc[3] */
    MCD_SET_VAR(taskTable+channel, 28, (u32)0x80000000);    /* inc[4] */
    MCD_SET_VAR(taskTable+channel, 29, (u32)0x80000001);    /* inc[5] */
    MCD_SET_VAR(taskTable+channel, 30, (u32)0x40000000);    /* inc[6] */

    /* Set the task's Enable bit in its Task Control Register */
    MCD_dmaBar->taskControl[channel] |= (u16)0x8000;
}


/*
 * Task 1
 */

void  MCD_startDmaSingleNoEu(char *srcAddr, short srcIncr, char *destAddr, short destIncr, int dmaSize, short xferSizeIncr, int flags, int *currBD, int *cSave, volatile TaskTableEntry *taskTable, int channel)
{

    MCD_SET_VAR(taskTable+channel, 7, (u32)srcAddr);    /* var[7] */
    MCD_SET_VAR(taskTable+channel, 25, (u32)(0xe000 << 16) | (0xffff & srcIncr));   /* inc[1] */
    MCD_SET_VAR(taskTable+channel, 2, (u32)destAddr);   /* var[2] */
    MCD_SET_VAR(taskTable+channel, 24, (u32)(0xe000 << 16) | (0xffff & destIncr));  /* inc[0] */
    MCD_SET_VAR(taskTable+channel, 3, (u32)dmaSize);    /* var[3] */
    MCD_SET_VAR(taskTable+channel, 26, (u32)(0x2000 << 16) | (0xffff & xferSizeIncr));  /* inc[2] */
    MCD_SET_VAR(taskTable+channel, 5, (u32)flags);  /* var[5] */
    MCD_SET_VAR(taskTable+channel, 1, (u32)currBD); /* var[1] */
    MCD_SET_VAR(taskTable+channel, 0, (u32)cSave);  /* var[0] */
    MCD_SET_VAR(taskTable+channel, 4, (u32)0x00000000); /* var[4] */
    MCD_SET_VAR(taskTable+channel, 6, (u32)0x00000000); /* var[6] */
    MCD_SET_VAR(taskTable+channel, 8, (u32)0x00000000); /* var[8] */
    MCD_SET_VAR(taskTable+channel, 9, (u32)0x00000004); /* var[9] */
    MCD_SET_VAR(taskTable+channel, 10, (u32)0x08000000);    /* var[10] */
    MCD_SET_VAR(taskTable+channel, 27, (u32)0x00000000);    /* inc[3] */
    MCD_SET_VAR(taskTable+channel, 28, (u32)0x80000001);    /* inc[4] */
    MCD_SET_VAR(taskTable+channel, 29, (u32)0x40000000);    /* inc[5] */

    /* Set the task's Enable bit in its Task Control Register */
    MCD_dmaBar->taskControl[channel] |= (u16)0x8000;
}


/*
 * Task 2
 */

void  MCD_startDmaChainEu(int *currBD, short srcIncr, short destIncr, int xferSize, short xferSizeIncr, int *cSave, volatile TaskTableEntry *taskTable, int channel)
{

    MCD_SET_VAR(taskTable+channel, 3, (u32)currBD); /* var[3] */
    MCD_SET_VAR(taskTable+channel, 25, (u32)(0xe000 << 16) | (0xffff & srcIncr));   /* inc[1] */
    MCD_SET_VAR(taskTable+channel, 24, (u32)(0xe000 << 16) | (0xffff & destIncr));  /* inc[0] */
    MCD_SET_VAR(taskTable+channel, 12, (u32)xferSize);  /* var[12] */
    MCD_SET_VAR(taskTable+channel, 26, (u32)(0x2000 << 16) | (0xffff & xferSizeIncr));  /* inc[2] */
    MCD_SET_VAR(taskTable+channel, 0, (u32)cSave);  /* var[0] */
    MCD_SET_VAR(taskTable+channel, 1, (u32)0x00000000); /* var[1] */
    MCD_SET_VAR(taskTable+channel, 2, (u32)0x00000000); /* var[2] */
    MCD_SET_VAR(taskTable+channel, 4, (u32)0x00000000); /* var[4] */
    MCD_SET_VAR(taskTable+channel, 5, (u32)0x00000000); /* var[5] */
    MCD_SET_VAR(taskTable+channel, 6, (u32)0x00000000); /* var[6] */
    MCD_SET_VAR(taskTable+channel, 7, (u32)0x00000000); /* var[7] */
    MCD_SET_VAR(taskTable+channel, 8, (u32)0x00000000); /* var[8] */
    MCD_SET_VAR(taskTable+channel, 9, (u32)0x00000000); /* var[9] */
    MCD_SET_VAR(taskTable+channel, 10, (u32)0x00000000);    /* var[10] */
    MCD_SET_VAR(taskTable+channel, 11, (u32)0x00000000);    /* var[11] */
    MCD_SET_VAR(taskTable+channel, 13, (u32)0x00000000);    /* var[13] */
    MCD_SET_VAR(taskTable+channel, 14, (u32)0x80000000);    /* var[14] */
    MCD_SET_VAR(taskTable+channel, 15, (u32)0x00000010);    /* var[15] */
    MCD_SET_VAR(taskTable+channel, 16, (u32)0x00000001);    /* var[16] */
    MCD_SET_VAR(taskTable+channel, 17, (u32)0x00000004);    /* var[17] */
    MCD_SET_VAR(taskTable+channel, 18, (u32)0x08000000);    /* var[18] */
    MCD_SET_VAR(taskTable+channel, 27, (u32)0x00000000);    /* inc[3] */
    MCD_SET_VAR(taskTable+channel, 28, (u32)0x80000000);    /* inc[4] */
    MCD_SET_VAR(taskTable+channel, 29, (u32)0xc0000000);    /* inc[5] */
    MCD_SET_VAR(taskTable+channel, 30, (u32)0x80000001);    /* inc[6] */
    MCD_SET_VAR(taskTable+channel, 31, (u32)0x40000000);    /* inc[7] */

    /* Set the task's Enable bit in its Task Control Register */
    MCD_dmaBar->taskControl[channel] |= (u16)0x8000;
}


/*
 * Task 3
 */

void  MCD_startDmaSingleEu(char *srcAddr, short srcIncr, char *destAddr, short destIncr, int dmaSize, short xferSizeIncr, int flags, int *currBD, int *cSave, volatile TaskTableEntry *taskTable, int channel)
{

    MCD_SET_VAR(taskTable+channel, 8, (u32)srcAddr);    /* var[8] */
    MCD_SET_VAR(taskTable+channel, 25, (u32)(0xe000 << 16) | (0xffff & srcIncr));   /* inc[1] */
    MCD_SET_VAR(taskTable+channel, 3, (u32)destAddr);   /* var[3] */
    MCD_SET_VAR(taskTable+channel, 24, (u32)(0xe000 << 16) | (0xffff & destIncr));  /* inc[0] */
    MCD_SET_VAR(taskTable+channel, 4, (u32)dmaSize);    /* var[4] */
    MCD_SET_VAR(taskTable+channel, 26, (u32)(0x2000 << 16) | (0xffff & xferSizeIncr));  /* inc[2] */
    MCD_SET_VAR(taskTable+channel, 6, (u32)flags);  /* var[6] */
    MCD_SET_VAR(taskTable+channel, 2, (u32)currBD); /* var[2] */
    MCD_SET_VAR(taskTable+channel, 0, (u32)cSave);  /* var[0] */
    MCD_SET_VAR(taskTable+channel, 1, (u32)0x00000000); /* var[1] */
    MCD_SET_VAR(taskTable+channel, 5, (u32)0x00000000); /* var[5] */
    MCD_SET_VAR(taskTable+channel, 7, (u32)0x00000000); /* var[7] */
    MCD_SET_VAR(taskTable+channel, 9, (u32)0x00000000); /* var[9] */
    MCD_SET_VAR(taskTable+channel, 10, (u32)0x00000001);    /* var[10] */
    MCD_SET_VAR(taskTable+channel, 11, (u32)0x00000004);    /* var[11] */
    MCD_SET_VAR(taskTable+channel, 12, (u32)0x08000000);    /* var[12] */
    MCD_SET_VAR(taskTable+channel, 27, (u32)0x00000000);    /* inc[3] */
    MCD_SET_VAR(taskTable+channel, 28, (u32)0xc0000000);    /* inc[4] */
    MCD_SET_VAR(taskTable+channel, 29, (u32)0x80000000);    /* inc[5] */
    MCD_SET_VAR(taskTable+channel, 30, (u32)0x80000001);    /* inc[6] */
    MCD_SET_VAR(taskTable+channel, 31, (u32)0x40000000);    /* inc[7] */

    /* Set the task's Enable bit in its Task Control Register */
    MCD_dmaBar->taskControl[channel] |= (u16)0x8000;
}


/*
 * Task 4
 */

void  MCD_startDmaENetRcv(char *bDBase, char *currBD, char *rcvFifoPtr, volatile TaskTableEntry *taskTable, int channel)
{

    MCD_SET_VAR(taskTable+channel, 0, (u32)bDBase); /* var[0] */
    MCD_SET_VAR(taskTable+channel, 3, (u32)currBD); /* var[3] */
    MCD_SET_VAR(taskTable+channel, 6, (u32)rcvFifoPtr); /* var[6] */
    MCD_SET_VAR(taskTable+channel, 1, (u32)0x00000000); /* var[1] */
    MCD_SET_VAR(taskTable+channel, 2, (u32)0x00000000); /* var[2] */
    MCD_SET_VAR(taskTable+channel, 4, (u32)0x00000000); /* var[4] */
    MCD_SET_VAR(taskTable+channel, 5, (u32)0x00000000); /* var[5] */
    MCD_SET_VAR(taskTable+channel, 7, (u32)0x00000000); /* var[7] */
    MCD_SET_VAR(taskTable+channel, 8, (u32)0x00000000); /* var[8] */
    MCD_SET_VAR(taskTable+channel, 9, (u32)0x0000ffff); /* var[9] */
    MCD_SET_VAR(taskTable+channel, 10, (u32)0x30000000);    /* var[10] */
    MCD_SET_VAR(taskTable+channel, 11, (u32)0x0fffffff);    /* var[11] */
    MCD_SET_VAR(taskTable+channel, 12, (u32)0x00000008);    /* var[12] */
    MCD_SET_VAR(taskTable+channel, 24, (u32)0x00000000);    /* inc[0] */
    MCD_SET_VAR(taskTable+channel, 25, (u32)0x60000000);    /* inc[1] */
    MCD_SET_VAR(taskTable+channel, 26, (u32)0x20000004);    /* inc[2] */
    MCD_SET_VAR(taskTable+channel, 27, (u32)0x40000000);    /* inc[3] */

    /* Set the task's Enable bit in its Task Control Register */
    MCD_dmaBar->taskControl[channel] |= (u16)0x8000;
}


/*
 * Task 5
 */

void  MCD_startDmaENetXmit(char *bDBase, char *currBD, char *xmitFifoPtr, volatile TaskTableEntry *taskTable, int channel)
{

    MCD_SET_VAR(taskTable+channel, 0, (u32)bDBase); /* var[0] */
    MCD_SET_VAR(taskTable+channel, 3, (u32)currBD); /* var[3] */
    MCD_SET_VAR(taskTable+channel, 11, (u32)xmitFifoPtr);   /* var[11] */
    MCD_SET_VAR(taskTable+channel, 1, (u32)0x00000000); /* var[1] */
    MCD_SET_VAR(taskTable+channel, 2, (u32)0x00000000); /* var[2] */
    MCD_SET_VAR(taskTable+channel, 4, (u32)0x00000000); /* var[4] */
    MCD_SET_VAR(taskTable+channel, 5, (u32)0x00000000); /* var[5] */
    MCD_SET_VAR(taskTable+channel, 6, (u32)0x00000000); /* var[6] */
    MCD_SET_VAR(taskTable+channel, 7, (u32)0x00000000); /* var[7] */
    MCD_SET_VAR(taskTable+channel, 8, (u32)0x00000000); /* var[8] */
    MCD_SET_VAR(taskTable+channel, 9, (u32)0x00000000); /* var[9] */
    MCD_SET_VAR(taskTable+channel, 10, (u32)0x00000000);    /* var[10] */
    MCD_SET_VAR(taskTable+channel, 12, (u32)0x00000000);    /* var[12] */
    MCD_SET_VAR(taskTable+channel, 13, (u32)0x0000ffff);    /* var[13] */
    MCD_SET_VAR(taskTable+channel, 14, (u32)0xffffffff);    /* var[14] */
    MCD_SET_VAR(taskTable+channel, 15, (u32)0x00000004);    /* var[15] */
    MCD_SET_VAR(taskTable+channel, 16, (u32)0x00000008);    /* var[16] */
    MCD_SET_VAR(taskTable+channel, 24, (u32)0x00000000);    /* inc[0] */
    MCD_SET_VAR(taskTable+channel, 25, (u32)0x60000000);    /* inc[1] */
    MCD_SET_VAR(taskTable+channel, 26, (u32)0x40000000);    /* inc[2] */
    MCD_SET_VAR(taskTable+channel, 27, (u32)0xc000fffc);    /* inc[3] */
    MCD_SET_VAR(taskTable+channel, 28, (u32)0xe0000004);    /* inc[4] */
    MCD_SET_VAR(taskTable+channel, 29, (u32)0x80000000);    /* inc[5] */
    MCD_SET_VAR(taskTable+channel, 30, (u32)0x4000ffff);    /* inc[6] */
    MCD_SET_VAR(taskTable+channel, 31, (u32)0xe0000001);    /* inc[7] */

    /* Set the task's Enable bit in its Task Control Register */
    MCD_dmaBar->taskControl[channel] |= (u16)0x8000;
}
