/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 * @ingroup stm32_usart
 * @brief STM32 USART support
 */

/*
 * Copyright (C) 2012 Sebastian Huber
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIBBSP_ARM_STM32F4_STM32_USART_H
#define LIBBSP_ARM_STM32F4_STM32_USART_H

#include <bsp/utility.h>

/**
 * @defgroup stm32_usart STM32 USART Support
 * @ingroup stm32f4_usart
 * @brief STM32 USART Support
 * @{
 */

typedef struct {
	uint32_t sr;
#define STM32F4_USART_SR_CTS BSP_BIT32(9)
#define STM32F4_USART_SR_LBD BSP_BIT32(8)
#define STM32F4_USART_SR_TXE BSP_BIT32(7)
#define STM32F4_USART_SR_TC BSP_BIT32(6)
#define STM32F4_USART_SR_RXNE BSP_BIT32(5)
#define STM32F4_USART_SR_IDLE BSP_BIT32(4)
#define STM32F4_USART_SR_ORE BSP_BIT32(3)
#define STM32F4_USART_SR_NF BSP_BIT32(2)
#define STM32F4_USART_SR_FE BSP_BIT32(1)
#define STM32F4_USART_SR_PE BSP_BIT32(0)
	uint32_t dr;
#define STM32F4_USART_DR(val) BSP_FLD32(val, 0, 7)
#define STM32F4_USART_DR_GET(reg) BSP_FLD32GET(reg, 0, 7)
#define STM32F4_USART_DR_SET(reg, val) BSP_FLD32SET(reg, val, 0, 7)
	uint32_t bbr;
#define STM32F4_USART_BBR_DIV_MANTISSA(val) BSP_FLD32(val, 4, 15)
#define STM32F4_USART_BBR_DIV_MANTISSA_GET(reg) BSP_FLD32GET(reg, 4, 15)
#define STM32F4_USART_BBR_DIV_MANTISSA_SET(reg, val) BSP_FLD32SET(reg, val, 4, 15)
#define STM32F4_USART_BBR_DIV_FRACTION(val) BSP_FLD32(val, 0, 3)
#define STM32F4_USART_BBR_DIV_FRACTION_GET(reg) BSP_FLD32GET(reg, 0, 3)
#define STM32F4_USART_BBR_DIV_FRACTION_SET(reg, val) BSP_FLD32SET(reg, val, 0, 3)
	uint32_t cr1;
#define STM32F4_USART_CR1_OVER8 BSP_BIT32(15)
#define STM32F4_USART_CR1_UE BSP_BIT32(13)
#define STM32F4_USART_CR1_M BSP_BIT32(12)
#define STM32F4_USART_CR1_WAKE BSP_BIT32(11)
#define STM32F4_USART_CR1_PCE BSP_BIT32(10)
#define STM32F4_USART_CR1_PS BSP_BIT32(9)
#define STM32F4_USART_CR1_PEIE BSP_BIT32(8)
#define STM32F4_USART_CR1_TXEIE BSP_BIT32(7)
#define STM32F4_USART_CR1_TCIE BSP_BIT32(6)
#define STM32F4_USART_CR1_RXNEIE BSP_BIT32(5)
#define STM32F4_USART_CR1_IDLEIE BSP_BIT32(4)
#define STM32F4_USART_CR1_TE BSP_BIT32(3)
#define STM32F4_USART_CR1_RE BSP_BIT32(2)
#define STM32F4_USART_CR1_RWU BSP_BIT32(1)
#define STM32F4_USART_CR1_SBK BSP_BIT32(0)
	uint32_t cr2;
#define STM32F4_USART_CR2_LINEN BSP_BIT32(14)
#define STM32F4_USART_CR2_STOP(val) BSP_FLD32(val, 12, 13)
#define STM32F4_USART_CR2_STOP_GET(reg) BSP_FLD32GET(reg, 12, 13)
#define STM32F4_USART_CR2_STOP_SET(reg, val) BSP_FLD32SET(reg, val, 12, 13)
#define STM32F4_USART_CR2_CLKEN BSP_BIT32(11)
#define STM32F4_USART_CR2_CPOL BSP_BIT32(10)
#define STM32F4_USART_CR2_CPHA BSP_BIT32(9)
#define STM32F4_USART_CR2_LBCL BSP_BIT32(8)
#define STM32F4_USART_CR2_LBDIE BSP_BIT32(6)
#define STM32F4_USART_CR2_LBDL BSP_BIT32(5)
#define STM32F4_USART_CR2_ADD(val) BSP_FLD32(val, 0, 3)
#define STM32F4_USART_CR2_ADD_GET(reg) BSP_FLD32GET(reg, 0, 3)
#define STM32F4_USART_CR2_ADD_SET(reg, val) BSP_FLD32SET(reg, val, 0, 3)
	uint32_t cr3;
#define STM32F4_USART_CR3_ONEBIT BSP_BIT32(11)
#define STM32F4_USART_CR3_CTSIE BSP_BIT32(10)
#define STM32F4_USART_CR3_CTSE BSP_BIT32(9)
#define STM32F4_USART_CR3_RTSE BSP_BIT32(8)
#define STM32F4_USART_CR3_DMAT BSP_BIT32(7)
#define STM32F4_USART_CR3_DMAR BSP_BIT32(6)
#define STM32F4_USART_CR3_SCEN BSP_BIT32(5)
#define STM32F4_USART_CR3_NACK BSP_BIT32(4)
#define STM32F4_USART_CR3_HDSEL BSP_BIT32(3)
#define STM32F4_USART_CR3_IRLP BSP_BIT32(2)
#define STM32F4_USART_CR3_IREN BSP_BIT32(1)
#define STM32F4_USART_CR3_EIE BSP_BIT32(0)
	uint32_t gtpr;
#define STM32F4_USART_GTPR_GT(val) BSP_FLD32(val, 8, 15)
#define STM32F4_USART_GTPR_GT_GET(reg) BSP_FLD32GET(reg, 8, 15)
#define STM32F4_USART_GTPR_GT_SET(reg, val) BSP_FLD32SET(reg, val, 8, 15)
#define STM32F4_USART_GTPR_PSC(val) BSP_FLD32(val, 0, 7)
#define STM32F4_USART_GTPR_PSC_GET(reg) BSP_FLD32GET(reg, 0, 7)
#define STM32F4_USART_GTPR_PSC_SET(reg, val) BSP_FLD32SET(reg, val, 0, 7)
} stm32f4_usart;

/** @} */

#endif /* LIBBSP_ARM_STM32F4_STM32_USART_H */
