/* SPDX-License-Identifier: BSD-3-Clause */

/**
 * @file
 *
 * @ingroup RTEMSBSPsARMimxrt
 *
 * @brief Pin function definitions for i.MXRT1166.
 *
 * Note: This file is basically a reformatted version of the fsl_iomuxc.h. RTEMS
 * uses a driver based on the FreeBSD iomux driver for the i.mx6. That driver
 * expects a different order of the values.
 */

/*
 * Copyright 2016 Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * Copyright (C) 2023 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIBBSP_ARM_IMXRT_IMXRT1166_PINFUNC_H
#define LIBBSP_ARM_IMXRT_IMXRT1166_PINFUNC_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*
 * Order of registers:
 * muxRegister, configRegister, inputRegister, muxMode, inputDaisy
 */

/* LPSR pins. Base address is 0x40c08000 */

#define IMXRT_PAD_GPIO_LPSR_00_FLEXCAN3_TX           0x40c08000 0x40c08040 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_00_MIC_CLK               0x40c08000 0x40c08040 0          0x1 0
#define IMXRT_PAD_GPIO_LPSR_00_MQS_RIGHT             0x40c08000 0x40c08040 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_00_ARM_CM4_EVENTO        0x40c08000 0x40c08040 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_00_GPIO_MUX6_IO00        0x40c08000 0x40c08040 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_00_LPUART12_TXD          0x40c08000 0x40c08040 0x40c080B0 0x6 0
#define IMXRT_PAD_GPIO_LPSR_00_SAI4_MCLK             0x40c08000 0x40c08040 0x40c080C8 0x7 0
#define IMXRT_PAD_GPIO_LPSR_00_GPIO12_IO00           0x40c08000 0x40c08040 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_01_FLEXCAN3_RX           0x40c08004 0x40c08044 0x40c08080 0x0 0
#define IMXRT_PAD_GPIO_LPSR_01_MIC_BITSTREAM0        0x40c08004 0x40c08044 0x40c080B4 0x1 0
#define IMXRT_PAD_GPIO_LPSR_01_MQS_LEFT              0x40c08004 0x40c08044 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_01_ARM_CM4_EVENTI        0x40c08004 0x40c08044 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_01_GPIO_MUX6_IO01        0x40c08004 0x40c08044 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_01_LPUART12_RXD          0x40c08004 0x40c08044 0x40c080AC 0x6 0
#define IMXRT_PAD_GPIO_LPSR_01_GPIO12_IO01           0x40c08004 0x40c08044 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_02_GPIO12_IO02           0x40c08008 0x40c08048 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_02_SRC_BOOT_MODE00       0x40c08008 0x40c08048 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_02_LPSPI5_SCK            0x40c08008 0x40c08048 0x40c08098 0x1 0
#define IMXRT_PAD_GPIO_LPSR_02_SAI4_TX_DATA          0x40c08008 0x40c08048 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_02_MQS_RIGHT             0x40c08008 0x40c08048 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_02_GPIO_MUX6_IO02        0x40c08008 0x40c08048 0          0x5 0

#define IMXRT_PAD_GPIO_LPSR_03_SRC_BOOT_MODE01       0x40c0800C 0x40c0804C 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_03_LPSPI5_PCS0           0x40c0800C 0x40c0804C 0x40c08094 0x1 0
#define IMXRT_PAD_GPIO_LPSR_03_SAI4_TX_SYNC          0x40c0800C 0x40c0804C 0x40c080DC 0x2 0
#define IMXRT_PAD_GPIO_LPSR_03_MQS_LEFT              0x40c0800C 0x40c0804C 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_03_GPIO_MUX6_IO03        0x40c0800C 0x40c0804C 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_03_GPIO12_IO03           0x40c0800C 0x40c0804C 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_04_LPI2C5_SDA            0x40c08010 0x40c08050 0x40c08088 0x0 0
#define IMXRT_PAD_GPIO_LPSR_04_LPSPI5_SOUT           0x40c08010 0x40c08050 0x40c080A0 0x1 0
#define IMXRT_PAD_GPIO_LPSR_04_SAI4_TX_BCLK          0x40c08010 0x40c08050 0x40c080D8 0x2 0
#define IMXRT_PAD_GPIO_LPSR_04_LPUART12_RTS_B        0x40c08010 0x40c08050 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_04_GPIO_MUX6_IO04        0x40c08010 0x40c08050 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_04_LPUART11_TXD          0x40c08010 0x40c08050 0x40c080A8 0x6 0
#define IMXRT_PAD_GPIO_LPSR_04_GPIO12_IO04           0x40c08010 0x40c08050 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_05_GPIO12_IO05           0x40c08014 0x40c08054 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_05_LPI2C5_SCL            0x40c08014 0x40c08054 0x40c08084 0x0 0
#define IMXRT_PAD_GPIO_LPSR_05_LPSPI5_SIN            0x40c08014 0x40c08054 0x40c0809C 0x1 0
#define IMXRT_PAD_GPIO_LPSR_05_SAI4_MCLK             0x40c08014 0x40c08054 0x40c080C8 0x2 1
#define IMXRT_PAD_GPIO_LPSR_05_LPUART12_CTS_B        0x40c08014 0x40c08054 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_05_GPIO_MUX6_IO05        0x40c08014 0x40c08054 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_05_LPUART11_RXD          0x40c08014 0x40c08054 0x40c080A4 0x6 0
#define IMXRT_PAD_GPIO_LPSR_05_NMI_GLUE_NMI          0x40c08014 0x40c08054 0x40c080C4 0x7 0

#define IMXRT_PAD_GPIO_LPSR_06_LPI2C6_SDA            0x40c08018 0x40c08058 0x40c08090 0x0 0
#define IMXRT_PAD_GPIO_LPSR_06_SAI4_RX_DATA          0x40c08018 0x40c08058 0x40c080D0 0x2 0
#define IMXRT_PAD_GPIO_LPSR_06_LPUART12_TXD          0x40c08018 0x40c08058 0x40c080B0 0x3 1
#define IMXRT_PAD_GPIO_LPSR_06_LPSPI6_PCS3           0x40c08018 0x40c08058 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_06_GPIO_MUX6_IO06        0x40c08018 0x40c08058 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_06_FLEXCAN3_TX           0x40c08018 0x40c08058 0          0x6 0
#define IMXRT_PAD_GPIO_LPSR_06_PIT2_TRIGGER3         0x40c08018 0x40c08058 0          0x7 0
#define IMXRT_PAD_GPIO_LPSR_06_LPSPI5_PCS1           0x40c08018 0x40c08058 0          0x8 0
#define IMXRT_PAD_GPIO_LPSR_06_GPIO12_IO06           0x40c08018 0x40c08058 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_07_LPI2C6_SCL            0x40c0801C 0x40c0805C 0x40c0808C 0x0 0
#define IMXRT_PAD_GPIO_LPSR_07_SAI4_RX_BCLK          0x40c0801C 0x40c0805C 0x40c080CC 0x2 0
#define IMXRT_PAD_GPIO_LPSR_07_LPUART12_RXD          0x40c0801C 0x40c0805C 0x40c080AC 0x3 1
#define IMXRT_PAD_GPIO_LPSR_07_LPSPI6_PCS2           0x40c0801C 0x40c0805C 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_07_GPIO_MUX6_IO07        0x40c0801C 0x40c0805C 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_07_FLEXCAN3_RX           0x40c0801C 0x40c0805C 0x40c08080 0x6 1
#define IMXRT_PAD_GPIO_LPSR_07_PIT2_TRIGGER2         0x40c0801C 0x40c0805C 0          0x7 0
#define IMXRT_PAD_GPIO_LPSR_07_LPSPI5_PCS2           0x40c0801C 0x40c0805C 0          0x8 0
#define IMXRT_PAD_GPIO_LPSR_07_GPIO12_IO07           0x40c0801C 0x40c0805C 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_08_GPIO12_IO08           0x40c08020 0x40c08060 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_08_LPUART11_TXD          0x40c08020 0x40c08060 0x40c080A8 0x0 1
#define IMXRT_PAD_GPIO_LPSR_08_FLEXCAN3_TX           0x40c08020 0x40c08060 0          0x1 0
#define IMXRT_PAD_GPIO_LPSR_08_SAI4_RX_SYNC          0x40c08020 0x40c08060 0x40c080D4 0x2 0
#define IMXRT_PAD_GPIO_LPSR_08_MIC_CLK               0x40c08020 0x40c08060 0          0x3 0
#define IMXRT_PAD_GPIO_LPSR_08_LPSPI6_PCS1           0x40c08020 0x40c08060 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_08_GPIO_MUX6_IO08        0x40c08020 0x40c08060 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_08_LPI2C5_SDA            0x40c08020 0x40c08060 0x40c08088 0x6 1
#define IMXRT_PAD_GPIO_LPSR_08_PIT2_TRIGGER1         0x40c08020 0x40c08060 0          0x7 0
#define IMXRT_PAD_GPIO_LPSR_08_LPSPI5_PCS3           0x40c08020 0x40c08060 0          0x8 0

#define IMXRT_PAD_GPIO_LPSR_09_GPIO12_IO09           0x40c08024 0x40c08064 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_09_LPUART11_RXD          0x40c08024 0x40c08064 0x40c080A4 0x0 1
#define IMXRT_PAD_GPIO_LPSR_09_FLEXCAN3_RX           0x40c08024 0x40c08064 0x40c08080 0x1 2
#define IMXRT_PAD_GPIO_LPSR_09_PIT2_TRIGGER0         0x40c08024 0x40c08064 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_09_MIC_BITSTREAM0        0x40c08024 0x40c08064 0x40c080B4 0x3 1
#define IMXRT_PAD_GPIO_LPSR_09_LPSPI6_PCS0           0x40c08024 0x40c08064 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_09_GPIO_MUX6_IO09        0x40c08024 0x40c08064 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_09_LPI2C5_SCL            0x40c08024 0x40c08064 0x40c08084 0x6 1
#define IMXRT_PAD_GPIO_LPSR_09_SAI4_TX_DATA          0x40c08024 0x40c08064 0          0x7 0

#define IMXRT_PAD_GPIO_LPSR_10_GPIO12_IO10           0x40c08028 0x40c08068 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_10_JTAG_MUX_TRSTB        0x40c08028 0x40c08068 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_10_LPUART11_CTS_B        0x40c08028 0x40c08068 0          0x1 0
#define IMXRT_PAD_GPIO_LPSR_10_LPI2C6_SDA            0x40c08028 0x40c08068 0x40c08090 0x2 1
#define IMXRT_PAD_GPIO_LPSR_10_MIC_BITSTREAM1        0x40c08028 0x40c08068 0x40c080B8 0x3 0
#define IMXRT_PAD_GPIO_LPSR_10_LPSPI6_SCK            0x40c08028 0x40c08068 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_10_GPIO_MUX6_IO10        0x40c08028 0x40c08068 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_10_LPI2C5_SCLS           0x40c08028 0x40c08068 0          0x6 0
#define IMXRT_PAD_GPIO_LPSR_10_SAI4_TX_SYNC          0x40c08028 0x40c08068 0x40c080DC 0x7 1
#define IMXRT_PAD_GPIO_LPSR_10_LPUART12_TXD          0x40c08028 0x40c08068 0x40c080B0 0x8 2

#define IMXRT_PAD_GPIO_LPSR_11_JTAG_MUX_TDO          0x40c0802C 0x40c0806C 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_11_LPUART11_RTS_B        0x40c0802C 0x40c0806C 0          0x1 0
#define IMXRT_PAD_GPIO_LPSR_11_LPI2C6_SCL            0x40c0802C 0x40c0806C 0x40c0808C 0x2 1
#define IMXRT_PAD_GPIO_LPSR_11_MIC_BITSTREAM2        0x40c0802C 0x40c0806C 0x40c080BC 0x3 0
#define IMXRT_PAD_GPIO_LPSR_11_LPSPI6_SOUT           0x40c0802C 0x40c0806C 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_11_GPIO_MUX6_IO11        0x40c0802C 0x40c0806C 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_11_LPI2C5_SDAS           0x40c0802C 0x40c0806C 0          0x6 0
#define IMXRT_PAD_GPIO_LPSR_11_ARM_TRACE_SWO         0x40c0802C 0x40c0806C 0          0x7 0
#define IMXRT_PAD_GPIO_LPSR_11_LPUART12_RXD          0x40c0802C 0x40c0806C 0x40c080AC 0x8 2
#define IMXRT_PAD_GPIO_LPSR_11_GPIO12_IO11           0x40c0802C 0x40c0806C 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_12_GPIO12_IO12           0x40c08030 0x40c08070 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_12_JTAG_MUX_TDI          0x40c08030 0x40c08070 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_12_PIT2_TRIGGER0         0x40c08030 0x40c08070 0          0x1 0
#define IMXRT_PAD_GPIO_LPSR_12_MIC_BITSTREAM3        0x40c08030 0x40c08070 0x40c080C0 0x3 0
#define IMXRT_PAD_GPIO_LPSR_12_LPSPI6_SIN            0x40c08030 0x40c08070 0          0x4 0
#define IMXRT_PAD_GPIO_LPSR_12_GPIO_MUX6_IO12        0x40c08030 0x40c08070 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_12_LPI2C5_HREQ           0x40c08030 0x40c08070 0          0x6 0
#define IMXRT_PAD_GPIO_LPSR_12_SAI4_TX_BCLK          0x40c08030 0x40c08070 0x40c080D8 0x7 1
#define IMXRT_PAD_GPIO_LPSR_12_LPSPI5_SCK            0x40c08030 0x40c08070 0x40c08098 0x8 1

#define IMXRT_PAD_GPIO_LPSR_13_GPIO12_IO13           0x40c08034 0x40c08074 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_13_JTAG_MUX_MOD          0x40c08034 0x40c08074 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_13_MIC_BITSTREAM1        0x40c08034 0x40c08074 0x40c080B8 0x1 1
#define IMXRT_PAD_GPIO_LPSR_13_PIT2_TRIGGER1         0x40c08034 0x40c08074 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_13_GPIO_MUX6_IO13        0x40c08034 0x40c08074 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_13_SAI4_RX_DATA          0x40c08034 0x40c08074 0x40c080D0 0x7 1
#define IMXRT_PAD_GPIO_LPSR_13_LPSPI5_PCS0           0x40c08034 0x40c08074 0x40c08094 0x8 1

#define IMXRT_PAD_GPIO_LPSR_14_JTAG_MUX_TCK          0x40c08038 0x40c08078 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_14_MIC_BITSTREAM2        0x40c08038 0x40c08078 0x40c080BC 0x1 1
#define IMXRT_PAD_GPIO_LPSR_14_PIT2_TRIGGER2         0x40c08038 0x40c08078 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_14_GPIO_MUX6_IO14        0x40c08038 0x40c08078 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_14_SAI4_RX_BCLK          0x40c08038 0x40c08078 0x40c080CC 0x7 1
#define IMXRT_PAD_GPIO_LPSR_14_LPSPI5_SOUT           0x40c08038 0x40c08078 0x40c080A0 0x8 1
#define IMXRT_PAD_GPIO_LPSR_14_GPIO12_IO14           0x40c08038 0x40c08078 0          0xA 0

#define IMXRT_PAD_GPIO_LPSR_15_GPIO12_IO15           0x40c0803C 0x40c0807C 0          0xA 0
#define IMXRT_PAD_GPIO_LPSR_15_JTAG_MUX_TMS          0x40c0803C 0x40c0807C 0          0x0 0
#define IMXRT_PAD_GPIO_LPSR_15_MIC_BITSTREAM3        0x40c0803C 0x40c0807C 0x40c080C0 0x1 1
#define IMXRT_PAD_GPIO_LPSR_15_PIT2_TRIGGER3         0x40c0803C 0x40c0807C 0          0x2 0
#define IMXRT_PAD_GPIO_LPSR_15_GPIO_MUX6_IO15        0x40c0803C 0x40c0807C 0          0x5 0
#define IMXRT_PAD_GPIO_LPSR_15_SAI4_RX_SYNC          0x40c0803C 0x40c0807C 0x40c080D4 0x7 1
#define IMXRT_PAD_GPIO_LPSR_15_LPSPI5_SIN            0x40c0803C 0x40c0807C 0x40c0809C 0x8 1

/* SNVS pins. Base address is 0x40c94000 */

#define IMXRT_PAD_WAKEUP_DIG_GPIO13_IO00               0x40c94000 0x40c94040 0 0x5 0
#define IMXRT_PAD_WAKEUP_DIG_NMI_GLUE_NMI              0x40c94000 0x40c94040 0x40C080C4 0x7 1

#define IMXRT_PAD_PMIC_ON_REQ_DIG_SNVS_LP_PMIC_ON_REQ  0x40c94004 0x40c94044 0 0x0 0
#define IMXRT_PAD_PMIC_ON_REQ_DIG_GPIO13_IO01          0x40c94004 0x40c94044 0 0x5 0

#define IMXRT_PAD_PMIC_STBY_REQ_DIG_CCM_PMIC_VSTBY_REQ 0x40c94008 0x40c94048 0 0x0 0
#define IMXRT_PAD_PMIC_STBY_REQ_DIG_GPIO13_IO02        0x40c94008 0x40c94048 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_00_DIG_SNVS_TAMPER0        0x40c9400C 0x40c9404C 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_00_DIG_GPIO13_IO03         0x40c9400C 0x40c9404C 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_01_DIG_SNVS_TAMPER1        0x40c94010 0x40c94050 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_01_DIG_GPIO13_IO04         0x40c94010 0x40c94050 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_02_DIG_SNVS_TAMPER2        0x40c94014 0x40c94054 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_02_DIG_GPIO13_IO05         0x40c94014 0x40c94054 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_03_DIG_SNVS_TAMPER3        0x40c94018 0x40c94058 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_03_DIG_GPIO13_IO06         0x40c94018 0x40c94058 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_04_DIG_SNVS_TAMPER4        0x40c9401C 0x40c9405C 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_04_DIG_GPIO13_IO07         0x40c9401C 0x40c9405C 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_05_DIG_SNVS_TAMPER5        0x40c94020 0x40c94060 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_05_DIG_GPIO13_IO08         0x40c94020 0x40c94060 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_06_DIG_SNVS_TAMPER6        0x40c94024 0x40c94064 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_06_DIG_GPIO13_IO09         0x40c94024 0x40c94064 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_07_DIG_SNVS_TAMPER7        0x40c94028 0x40c94068 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_07_DIG_GPIO13_IO10         0x40c94028 0x40c94068 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_08_DIG_SNVS_TAMPER8        0x40c9402C 0x40c9406C 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_08_DIG_GPIO13_IO11         0x40c9402C 0x40c9406C 0 0x5 0

#define IMXRT_PAD_GPIO_SNVS_09_DIG_SNVS_TAMPER9        0x40c94030 0x40c94070 0 0x0 0
#define IMXRT_PAD_GPIO_SNVS_09_DIG_GPIO13_IO12         0x40c94030 0x40c94070 0 0x5 0

#define IMXRT_PAD_TEST_MODE_DIG                        0          0x40c94034 0 0   0

#define IMXRT_PAD_POR_B_DIG                            0          0x40c94038 0 0   0

#define IMXRT_PAD_ONOFF_DIG                            0          0x40c9403C 0 0   0

/* Normal pins. Base address is 0x400e8000 */

#define IMXRT_PAD_GPIO_EMC_B1_00_SEMC_DATA00                   0x400e8010 0x400e8254 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_00_FLEXPWM4_PWM0_A               0x400e8010 0x400e8254 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_00_GPIO_MUX1_IO00                0x400e8010 0x400e8254 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_00_FLEXIO1_D00                   0x400e8010 0x400e8254 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_00_GPIO7_IO00                    0x400e8010 0x400e8254 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_01_GPIO7_IO01                    0x400e8014 0x400e8258 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_01_SEMC_DATA01                   0x400e8014 0x400e8258 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_01_FLEXPWM4_PWM0_B               0x400e8014 0x400e8258 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_01_GPIO_MUX1_IO01                0x400e8014 0x400e8258 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_01_FLEXIO1_D01                   0x400e8014 0x400e8258 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_02_SEMC_DATA02                   0x400e8018 0x400e825C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_02_FLEXPWM4_PWM1_A               0x400e8018 0x400e825C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_02_GPIO_MUX1_IO02                0x400e8018 0x400e825C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_02_FLEXIO1_D02                   0x400e8018 0x400e825C 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_02_GPIO7_IO02                    0x400e8018 0x400e825C 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_03_SEMC_DATA03                   0x400e801C 0x400e8260 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_03_FLEXPWM4_PWM1_B               0x400e801C 0x400e8260 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_03_GPIO_MUX1_IO03                0x400e801C 0x400e8260 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_03_FLEXIO1_D03                   0x400e801C 0x400e8260 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_03_GPIO7_IO03                    0x400e801C 0x400e8260 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_04_GPIO7_IO04                    0x400e8020 0x400e8264 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_04_SEMC_DATA04                   0x400e8020 0x400e8264 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_04_FLEXPWM4_PWM2_A               0x400e8020 0x400e8264 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_04_GPIO_MUX1_IO04                0x400e8020 0x400e8264 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_04_FLEXIO1_D04                   0x400e8020 0x400e8264 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_05_SEMC_DATA05                   0x400e8024 0x400e8268 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_05_FLEXPWM4_PWM2_B               0x400e8024 0x400e8268 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_05_GPIO_MUX1_IO05                0x400e8024 0x400e8268 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_05_FLEXIO1_D05                   0x400e8024 0x400e8268 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_05_GPIO7_IO05                    0x400e8024 0x400e8268 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_06_SEMC_DATA06                   0x400e8028 0x400e826C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_06_FLEXPWM2_PWM0_A               0x400e8028 0x400e826C 0x400e8518 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_06_GPIO_MUX1_IO06                0x400e8028 0x400e826C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_06_FLEXIO1_D06                   0x400e8028 0x400e826C 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_06_GPIO7_IO06                    0x400e8028 0x400e826C 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_07_GPIO7_IO07                    0x400e802C 0x400e8270 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_07_SEMC_DATA07                   0x400e802C 0x400e8270 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_07_FLEXPWM2_PWM0_B               0x400e802C 0x400e8270 0x400e8524 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_07_GPIO_MUX1_IO07                0x400e802C 0x400e8270 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_07_FLEXIO1_D07                   0x400e802C 0x400e8270 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_08_SEMC_DM00                     0x400e8030 0x400e8274 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_08_FLEXPWM2_PWM1_A               0x400e8030 0x400e8274 0x400e851C 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_08_GPIO_MUX1_IO08                0x400e8030 0x400e8274 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_08_FLEXIO1_D08                   0x400e8030 0x400e8274 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_08_GPIO7_IO08                    0x400e8030 0x400e8274 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_09_SEMC_ADDR00                   0x400e8034 0x400e8278 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_09_FLEXPWM2_PWM1_B               0x400e8034 0x400e8278 0x400e8528 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_09_GPT5_CAPTURE1                 0x400e8034 0x400e8278 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_09_GPIO_MUX1_IO09                0x400e8034 0x400e8278 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_09_FLEXIO1_D09                   0x400e8034 0x400e8278 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_09_GPIO7_IO09                    0x400e8034 0x400e8278 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_10_SEMC_ADDR01                   0x400e8038 0x400e827C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_10_FLEXPWM2_PWM2_A               0x400e8038 0x400e827C 0x400e8520 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_10_GPT5_CAPTURE2                 0x400e8038 0x400e827C 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_10_GPIO_MUX1_IO10                0x400e8038 0x400e827C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_10_FLEXIO1_D10                   0x400e8038 0x400e827C 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_10_GPIO7_IO10                    0x400e8038 0x400e827C 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_11_GPIO7_IO11                    0x400e803C 0x400e8280 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_11_SEMC_ADDR02                   0x400e803C 0x400e8280 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_11_FLEXPWM2_PWM2_B               0x400e803C 0x400e8280 0x400e852C 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_11_GPT5_COMPARE1                 0x400e803C 0x400e8280 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_11_GPIO_MUX1_IO11                0x400e803C 0x400e8280 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_11_FLEXIO1_D11                   0x400e803C 0x400e8280 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_12_SEMC_ADDR03                   0x400e8040 0x400e8284 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_12_XBAR1_INOUT04                 0x400e8040 0x400e8284 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_12_GPT5_COMPARE2                 0x400e8040 0x400e8284 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_12_GPIO_MUX1_IO12                0x400e8040 0x400e8284 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_12_FLEXIO1_D12                   0x400e8040 0x400e8284 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_12_GPIO7_IO12                    0x400e8040 0x400e8284 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_13_SEMC_ADDR04                   0x400e8044 0x400e8288 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_13_XBAR1_INOUT05                 0x400e8044 0x400e8288 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_13_GPT5_COMPARE3                 0x400e8044 0x400e8288 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_13_GPIO_MUX1_IO13                0x400e8044 0x400e8288 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_13_FLEXIO1_D13                   0x400e8044 0x400e8288 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_13_GPIO7_IO13                    0x400e8044 0x400e8288 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_14_GPIO7_IO14                    0x400e8048 0x400e828C 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_14_SEMC_ADDR05                   0x400e8048 0x400e828C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_14_XBAR1_INOUT06                 0x400e8048 0x400e828C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_14_GPT5_CLK                      0x400e8048 0x400e828C 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_14_GPIO_MUX1_IO14                0x400e8048 0x400e828C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_14_FLEXIO1_D14                   0x400e8048 0x400e828C 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_15_SEMC_ADDR06                   0x400e804C 0x400e8290 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_15_XBAR1_INOUT07                 0x400e804C 0x400e8290 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_15_GPIO_MUX1_IO15                0x400e804C 0x400e8290 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_15_FLEXIO1_D15                   0x400e804C 0x400e8290 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_15_GPIO7_IO15                    0x400e804C 0x400e8290 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_16_SEMC_ADDR07                   0x400e8050 0x400e8294 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_16_XBAR1_INOUT08                 0x400e8050 0x400e8294 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_16_GPIO_MUX1_IO16                0x400e8050 0x400e8294 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_16_FLEXIO1_D16                   0x400e8050 0x400e8294 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_16_GPIO7_IO16                    0x400e8050 0x400e8294 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_17_GPIO7_IO17                    0x400e8054 0x400e8298 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_17_SEMC_ADDR08                   0x400e8054 0x400e8298 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_17_FLEXPWM4_PWM3_A               0x400e8054 0x400e8298 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_17_TMR1_TIMER0                   0x400e8054 0x400e8298 0x400e863C 0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_17_GPIO_MUX1_IO17                0x400e8054 0x400e8298 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_17_FLEXIO1_D17                   0x400e8054 0x400e8298 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_18_SEMC_ADDR09                   0x400e8058 0x400e829C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_18_FLEXPWM4_PWM3_B               0x400e8058 0x400e829C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_18_TMR2_TIMER0                   0x400e8058 0x400e829C 0x400e8648 0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_18_GPIO_MUX1_IO18                0x400e8058 0x400e829C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_18_FLEXIO1_D18                   0x400e8058 0x400e829C 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_18_GPIO7_IO18                    0x400e8058 0x400e829C 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_19_SEMC_ADDR11                   0x400e805C 0x400e82A0 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_19_FLEXPWM2_PWM3_A               0x400e805C 0x400e82A0 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_19_TMR3_TIMER0                   0x400e805C 0x400e82A0 0x400e8654 0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_19_GPIO_MUX1_IO19                0x400e805C 0x400e82A0 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_19_FLEXIO1_D19                   0x400e805C 0x400e82A0 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_19_GPIO7_IO19                    0x400e805C 0x400e82A0 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_20_SEMC_ADDR12                   0x400e8060 0x400e82A4 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_20_FLEXPWM2_PWM3_B               0x400e8060 0x400e82A4 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_20_TMR4_TIMER0                   0x400e8060 0x400e82A4 0x400e8660 0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_20_GPIO_MUX1_IO20                0x400e8060 0x400e82A4 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_20_FLEXIO1_D20                   0x400e8060 0x400e82A4 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_20_GPIO7_IO20                    0x400e8060 0x400e82A4 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_21_GPIO7_IO21                    0x400e8064 0x400e82A8 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_21_SEMC_BA0                      0x400e8064 0x400e82A8 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_21_FLEXPWM3_PWM3_A               0x400e8064 0x400e82A8 0x400e853C 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_21_GPIO_MUX1_IO21                0x400e8064 0x400e82A8 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_21_FLEXIO1_D21                   0x400e8064 0x400e82A8 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_22_GPIO7_IO22                    0x400e8068 0x400e82AC 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_22_SEMC_BA1                      0x400e8068 0x400e82AC 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_22_FLEXPWM3_PWM3_B               0x400e8068 0x400e82AC 0x400e854C 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_22_GPIO_MUX1_IO22                0x400e8068 0x400e82AC 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_22_FLEXIO1_D22                   0x400e8068 0x400e82AC 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_23_SEMC_ADDR10                   0x400e806C 0x400e82B0 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_23_FLEXPWM1_PWM0_A               0x400e806C 0x400e82B0 0x400e8500 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_23_GPIO_MUX1_IO23                0x400e806C 0x400e82B0 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_23_FLEXIO1_D23                   0x400e806C 0x400e82B0 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_23_GPIO7_IO23                    0x400e806C 0x400e82B0 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_24_GPIO7_IO24                    0x400e8070 0x400e82B4 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_24_SEMC_CAS                      0x400e8070 0x400e82B4 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_24_FLEXPWM1_PWM0_B               0x400e8070 0x400e82B4 0x400e850C 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_24_GPIO_MUX1_IO24                0x400e8070 0x400e82B4 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_24_FLEXIO1_D24                   0x400e8070 0x400e82B4 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_25_GPIO7_IO25                    0x400e8074 0x400e82B8 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_25_SEMC_RAS                      0x400e8074 0x400e82B8 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_25_FLEXPWM1_PWM1_A               0x400e8074 0x400e82B8 0x400e8504 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_25_GPIO_MUX1_IO25                0x400e8074 0x400e82B8 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_25_FLEXIO1_D25                   0x400e8074 0x400e82B8 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_26_SEMC_CLK                      0x400e8078 0x400e82BC 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_26_FLEXPWM1_PWM1_B               0x400e8078 0x400e82BC 0x400e8510 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_26_GPIO_MUX1_IO26                0x400e8078 0x400e82BC 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_26_FLEXIO1_D26                   0x400e8078 0x400e82BC 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_26_GPIO7_IO26                    0x400e8078 0x400e82BC 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_27_GPIO7_IO27                    0x400e807C 0x400e82C0 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_27_SEMC_CKE                      0x400e807C 0x400e82C0 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_27_FLEXPWM1_PWM2_A               0x400e807C 0x400e82C0 0x400e8508 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_27_GPIO_MUX1_IO27                0x400e807C 0x400e82C0 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_27_FLEXIO1_D27                   0x400e807C 0x400e82C0 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_28_GPIO7_IO28                    0x400e8080 0x400e82C4 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_28_SEMC_WE                       0x400e8080 0x400e82C4 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_28_FLEXPWM1_PWM2_B               0x400e8080 0x400e82C4 0x400e8514 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_28_GPIO_MUX1_IO28                0x400e8080 0x400e82C4 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_28_FLEXIO1_D28                   0x400e8080 0x400e82C4 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_29_SEMC_CS0                      0x400e8084 0x400e82C8 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_29_FLEXPWM3_PWM0_A               0x400e8084 0x400e82C8 0x400e8530 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_29_GPIO_MUX1_IO29                0x400e8084 0x400e82C8 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_29_FLEXIO1_D29                   0x400e8084 0x400e82C8 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_29_GPIO7_IO29                    0x400e8084 0x400e82C8 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_30_SEMC_DATA08                   0x400e8088 0x400e82CC 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_30_FLEXPWM3_PWM0_B               0x400e8088 0x400e82CC 0x400e8540 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_30_GPIO_MUX1_IO30                0x400e8088 0x400e82CC 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_30_FLEXIO1_D30                   0x400e8088 0x400e82CC 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B1_30_GPIO7_IO30                    0x400e8088 0x400e82CC 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_31_GPIO7_IO31                    0x400e808C 0x400e82D0 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_31_SEMC_DATA09                   0x400e808C 0x400e82D0 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_31_FLEXPWM3_PWM1_A               0x400e808C 0x400e82D0 0x400e8534 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_31_GPIO_MUX1_IO31                0x400e808C 0x400e82D0 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_31_FLEXIO1_D31                   0x400e808C 0x400e82D0 0          0x8 0

#define IMXRT_PAD_GPIO_EMC_B1_32_GPIO8_IO00                    0x400e8090 0x400e82D4 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_32_SEMC_DATA10                   0x400e8090 0x400e82D4 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_32_FLEXPWM3_PWM1_B               0x400e8090 0x400e82D4 0x400e8544 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_32_GPIO_MUX2_IO00                0x400e8090 0x400e82D4 0          0x5 0

#define IMXRT_PAD_GPIO_EMC_B1_33_SEMC_DATA11                   0x400e8094 0x400e82D8 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_33_FLEXPWM3_PWM2_A               0x400e8094 0x400e82D8 0x400e8538 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_33_GPIO_MUX2_IO01                0x400e8094 0x400e82D8 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_33_GPIO8_IO01                    0x400e8094 0x400e82D8 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_34_GPIO8_IO02                    0x400e8098 0x400e82DC 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_34_SEMC_DATA12                   0x400e8098 0x400e82DC 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_34_FLEXPWM3_PWM2_B               0x400e8098 0x400e82DC 0x400e8548 0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_34_GPIO_MUX2_IO02                0x400e8098 0x400e82DC 0          0x5 0

#define IMXRT_PAD_GPIO_EMC_B1_35_GPIO8_IO03                    0x400e809C 0x400e82E0 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_35_SEMC_DATA13                   0x400e809C 0x400e82E0 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_35_XBAR1_INOUT09                 0x400e809C 0x400e82E0 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_35_GPIO_MUX2_IO03                0x400e809C 0x400e82E0 0          0x5 0

#define IMXRT_PAD_GPIO_EMC_B1_36_SEMC_DATA14                   0x400e80A0 0x400e82E4 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_36_XBAR1_INOUT10                 0x400e80A0 0x400e82E4 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_36_GPIO_MUX2_IO04                0x400e80A0 0x400e82E4 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_36_GPIO8_IO04                    0x400e80A0 0x400e82E4 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_37_GPIO8_IO05                    0x400e80A4 0x400e82E8 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_37_SEMC_DATA15                   0x400e80A4 0x400e82E8 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_37_XBAR1_INOUT11                 0x400e80A4 0x400e82E8 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_37_GPIO_MUX2_IO05                0x400e80A4 0x400e82E8 0          0x5 0

#define IMXRT_PAD_GPIO_EMC_B1_38_GPIO8_IO06                    0x400e80A8 0x400e82EC 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_38_SEMC_DM01                     0x400e80A8 0x400e82EC 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_38_FLEXPWM1_PWM3_A               0x400e80A8 0x400e82EC 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_38_TMR1_TIMER1                   0x400e80A8 0x400e82EC 0x400e8640 0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_38_GPIO_MUX2_IO06                0x400e80A8 0x400e82EC 0          0x5 0

#define IMXRT_PAD_GPIO_EMC_B1_39_SEMC_DQS                      0x400e80AC 0x400e82F0 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_39_FLEXPWM1_PWM3_B               0x400e80AC 0x400e82F0 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_39_TMR2_TIMER1                   0x400e80AC 0x400e82F0 0x400e864C 0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_39_GPIO_MUX2_IO07                0x400e80AC 0x400e82F0 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_39_GPIO8_IO07                    0x400e80AC 0x400e82F0 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_40_SEMC_RDY                      0x400e80B0 0x400e82F4 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_40_XBAR1_INOUT12                 0x400e80B0 0x400e82F4 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_40_MQS_RIGHT                     0x400e80B0 0x400e82F4 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_40_LPUART6_TXD                   0x400e80B0 0x400e82F4 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B1_40_GPIO_MUX2_IO08                0x400e80B0 0x400e82F4 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_40_ENET_1G_MDC                   0x400e80B0 0x400e82F4 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B1_40_CCM_CLKO1                     0x400e80B0 0x400e82F4 0          0x9 0
#define IMXRT_PAD_GPIO_EMC_B1_40_GPIO8_IO08                    0x400e80B0 0x400e82F4 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B1_41_GPIO8_IO09                    0x400e80B4 0x400e82F8 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B1_41_SEMC_CSX00                    0x400e80B4 0x400e82F8 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B1_41_XBAR1_INOUT13                 0x400e80B4 0x400e82F8 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B1_41_MQS_LEFT                      0x400e80B4 0x400e82F8 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B1_41_LPUART6_RXD                   0x400e80B4 0x400e82F8 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B1_41_FLEXSPI2_B_DATA07             0x400e80B4 0x400e82F8 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B1_41_GPIO_MUX2_IO09                0x400e80B4 0x400e82F8 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B1_41_ENET_1G_MDIO                  0x400e80B4 0x400e82F8 0x400e84C8 0x7 0
#define IMXRT_PAD_GPIO_EMC_B1_41_CCM_CLKO2                     0x400e80B4 0x400e82F8 0          0x9 0

#define IMXRT_PAD_GPIO_EMC_B2_00_SEMC_DATA16                   0x400e80B8 0x400e82FC 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_00_CCM_ENET_REF_CLK_25M          0x400e80B8 0x400e82FC 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_00_TMR3_TIMER1                   0x400e80B8 0x400e82FC 0x400e8658 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_00_LPUART6_CTS_B                 0x400e80B8 0x400e82FC 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_00_FLEXSPI2_B_DATA06             0x400e80B8 0x400e82FC 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_00_GPIO_MUX2_IO10                0x400e80B8 0x400e82FC 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_00_XBAR1_INOUT20                 0x400e80B8 0x400e82FC 0x400e86D8 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_00_ENET_QOS_1588_EVENT1_OUT      0x400e80B8 0x400e82FC 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_00_LPSPI1_SCK                    0x400e80B8 0x400e82FC 0x400e85D0 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_00_LPI2C2_SCL                    0x400e80B8 0x400e82FC 0x400e85B4 0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_00_GPIO8_IO10                    0x400e80B8 0x400e82FC 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_00_FLEXPWM3_PWM0_A               0x400e80B8 0x400e82FC 0x400e8530 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_01_SEMC_DATA17                   0x400e80BC 0x400e8300 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_01_USDHC2_CD_B                   0x400e80BC 0x400e8300 0x400e86D0 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_01_TMR4_TIMER1                   0x400e80BC 0x400e8300 0x400e8664 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_01_LPUART6_RTS_B                 0x400e80BC 0x400e8300 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_01_FLEXSPI2_B_DATA05             0x400e80BC 0x400e8300 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_01_GPIO_MUX2_IO11                0x400e80BC 0x400e8300 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_01_XBAR1_INOUT21                 0x400e80BC 0x400e8300 0x400e86DC 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_01_ENET_QOS_1588_EVENT1_IN       0x400e80BC 0x400e8300 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_01_LPSPI1_PCS0                   0x400e80BC 0x400e8300 0x400e85CC 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_01_LPI2C2_SDA                    0x400e80BC 0x400e8300 0x400e85B8 0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_01_GPIO8_IO11                    0x400e80BC 0x400e8300 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_01_FLEXPWM3_PWM0_B               0x400e80BC 0x400e8300 0x400e8540 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_02_SEMC_DATA18                   0x400e80C0 0x400e8304 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_02_USDHC2_WP                     0x400e80C0 0x400e8304 0x400e86D4 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_02_VIDEO_MUX_CSI_DATA23          0x400e80C0 0x400e8304 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_02_FLEXSPI2_B_DATA04             0x400e80C0 0x400e8304 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_02_GPIO_MUX2_IO12                0x400e80C0 0x400e8304 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_02_XBAR1_INOUT22                 0x400e80C0 0x400e8304 0x400e86E0 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_02_ENET_QOS_1588_EVENT1_AUX_IN   0x400e80C0 0x400e8304 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_02_LPSPI1_SOUT                   0x400e80C0 0x400e8304 0x400e85D8 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_02_GPIO8_IO12                    0x400e80C0 0x400e8304 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_02_FLEXPWM3_PWM1_A               0x400e80C0 0x400e8304 0x400e8534 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_03_SEMC_DATA19                   0x400e80C4 0x400e8308 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_03_USDHC2_VSELECT                0x400e80C4 0x400e8308 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_03_VIDEO_MUX_CSI_DATA22          0x400e80C4 0x400e8308 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_03_FLEXSPI2_B_DATA03             0x400e80C4 0x400e8308 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_03_GPIO_MUX2_IO13                0x400e80C4 0x400e8308 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_03_XBAR1_INOUT23                 0x400e80C4 0x400e8308 0x400e86E4 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_03_ENET_1G_TX_DATA03             0x400e80C4 0x400e8308 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_03_LPSPI1_SIN                    0x400e80C4 0x400e8308 0x400e85D4 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_03_GPIO8_IO13                    0x400e80C4 0x400e8308 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_03_FLEXPWM3_PWM1_B               0x400e80C4 0x400e8308 0x400e8544 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_04_SEMC_DATA20                   0x400e80C8 0x400e830C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_04_USDHC2_RESET_B                0x400e80C8 0x400e830C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_04_SAI2_MCLK                     0x400e80C8 0x400e830C 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_04_VIDEO_MUX_CSI_DATA21          0x400e80C8 0x400e830C 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_04_FLEXSPI2_B_DATA02             0x400e80C8 0x400e830C 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_04_GPIO_MUX2_IO14                0x400e80C8 0x400e830C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_04_XBAR1_INOUT24                 0x400e80C8 0x400e830C 0x400e86E8 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_04_ENET_1G_TX_DATA02             0x400e80C8 0x400e830C 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_04_LPSPI3_SCK                    0x400e80C8 0x400e830C 0x400e8600 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_04_GPIO8_IO14                    0x400e80C8 0x400e830C 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_04_FLEXPWM3_PWM2_A               0x400e80C8 0x400e830C 0x400e8538 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_05_SEMC_DATA21                   0x400e80CC 0x400e8310 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_05_GPT3_CLK                      0x400e80CC 0x400e8310 0x400e8598 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_05_SAI2_RX_SYNC                  0x400e80CC 0x400e8310 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_05_VIDEO_MUX_CSI_DATA20          0x400e80CC 0x400e8310 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_05_FLEXSPI2_B_DATA01             0x400e80CC 0x400e8310 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_05_GPIO_MUX2_IO15                0x400e80CC 0x400e8310 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_05_XBAR1_INOUT25                 0x400e80CC 0x400e8310 0x400e86EC 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_05_ENET_1G_RX_CLK                0x400e80CC 0x400e8310 0x400e84CC 0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_05_LPSPI3_PCS0                   0x400e80CC 0x400e8310 0x400e85F0 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_05_PIT1_TRIGGER0                 0x400e80CC 0x400e8310 0          0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_05_GPIO8_IO15                    0x400e80CC 0x400e8310 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_05_FLEXPWM3_PWM2_B               0x400e80CC 0x400e8310 0x400e8548 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_06_SEMC_DATA22                   0x400e80D0 0x400e8314 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_06_GPT3_CAPTURE1                 0x400e80D0 0x400e8314 0x400e8590 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_06_GPIO8_IO16                    0x400e80D0 0x400e8314 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_06_SAI2_RX_BCLK                  0x400e80D0 0x400e8314 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_06_FLEXPWM3_PWM3_A               0x400e80D0 0x400e8314 0x400e853C 0xB 1
#define IMXRT_PAD_GPIO_EMC_B2_06_VIDEO_MUX_CSI_DATA19          0x400e80D0 0x400e8314 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_06_FLEXSPI2_B_DATA00             0x400e80D0 0x400e8314 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_06_GPIO_MUX2_IO16                0x400e80D0 0x400e8314 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_06_XBAR1_INOUT26                 0x400e80D0 0x400e8314 0x400e86F0 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_06_ENET_1G_TX_ER                 0x400e80D0 0x400e8314 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_06_LPSPI3_SOUT                   0x400e80D0 0x400e8314 0x400e8608 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_06_PIT1_TRIGGER1                 0x400e80D0 0x400e8314 0          0x9 0

#define IMXRT_PAD_GPIO_EMC_B2_07_SEMC_DATA23                   0x400e80D4 0x400e8318 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_07_GPT3_CAPTURE2                 0x400e80D4 0x400e8318 0x400e8594 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_07_SAI2_RX_DATA                  0x400e80D4 0x400e8318 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_07_VIDEO_MUX_CSI_DATA18          0x400e80D4 0x400e8318 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_07_FLEXSPI2_B_DQS                0x400e80D4 0x400e8318 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_07_GPIO_MUX2_IO17                0x400e80D4 0x400e8318 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_07_XBAR1_INOUT27                 0x400e80D4 0x400e8318 0x400e86F4 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_07_ENET_1G_RX_DATA03             0x400e80D4 0x400e8318 0x400e84DC 0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_07_LPSPI3_SIN                    0x400e80D4 0x400e8318 0x400e8604 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_07_PIT1_TRIGGER2                 0x400e80D4 0x400e8318 0          0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_07_GPIO8_IO17                    0x400e80D4 0x400e8318 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_07_FLEXPWM3_PWM3_B               0x400e80D4 0x400e8318 0x400e854C 0xB 1

#define IMXRT_PAD_GPIO_EMC_B2_08_SEMC_DM02                     0x400e80D8 0x400e831C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_08_GPT3_COMPARE1                 0x400e80D8 0x400e831C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_08_SAI2_TX_DATA                  0x400e80D8 0x400e831C 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_08_VIDEO_MUX_CSI_DATA17          0x400e80D8 0x400e831C 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_08_FLEXSPI2_B_SS0_B              0x400e80D8 0x400e831C 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_08_GPIO_MUX2_IO18                0x400e80D8 0x400e831C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_08_XBAR1_INOUT28                 0x400e80D8 0x400e831C 0x400e86F8 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_08_ENET_1G_RX_DATA02             0x400e80D8 0x400e831C 0x400e84D8 0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_08_LPSPI3_PCS1                   0x400e80D8 0x400e831C 0x400e85F4 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_08_PIT1_TRIGGER3                 0x400e80D8 0x400e831C 0          0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_08_GPIO8_IO18                    0x400e80D8 0x400e831C 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_09_GPIO8_IO19                    0x400e80DC 0x400e8320 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_09_SEMC_DATA24                   0x400e80DC 0x400e8320 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_09_GPT3_COMPARE2                 0x400e80DC 0x400e8320 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_09_SAI2_TX_BCLK                  0x400e80DC 0x400e8320 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_09_VIDEO_MUX_CSI_DATA16          0x400e80DC 0x400e8320 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_09_FLEXSPI2_B_SCLK               0x400e80DC 0x400e8320 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_09_GPIO_MUX2_IO19                0x400e80DC 0x400e8320 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_09_XBAR1_INOUT29                 0x400e80DC 0x400e8320 0x400e86FC 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_09_ENET_1G_CRS                   0x400e80DC 0x400e8320 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_09_LPSPI3_PCS2                   0x400e80DC 0x400e8320 0x400e85F8 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_09_TMR1_TIMER0                   0x400e80DC 0x400e8320 0x400e863C 0x9 1

#define IMXRT_PAD_GPIO_EMC_B2_10_GPIO8_IO20                    0x400e80E0 0x400e8324 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_10_SEMC_DATA25                   0x400e80E0 0x400e8324 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_10_GPT3_COMPARE3                 0x400e80E0 0x400e8324 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_10_SAI2_TX_SYNC                  0x400e80E0 0x400e8324 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_10_VIDEO_MUX_CSI_FIELD           0x400e80E0 0x400e8324 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_10_FLEXSPI2_A_SCLK               0x400e80E0 0x400e8324 0x400e858C 0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_10_GPIO_MUX2_IO20                0x400e80E0 0x400e8324 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_10_XBAR1_INOUT30                 0x400e80E0 0x400e8324 0x400e8700 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_10_ENET_1G_COL                   0x400e80E0 0x400e8324 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_10_LPSPI3_PCS3                   0x400e80E0 0x400e8324 0x400e85FC 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_10_TMR1_TIMER1                   0x400e80E0 0x400e8324 0x400e8640 0x9 1

#define IMXRT_PAD_GPIO_EMC_B2_11_SEMC_DATA26                   0x400e80E4 0x400e8328 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_11_SPDIF_IN                      0x400e80E4 0x400e8328 0x400e86B4 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_11_ENET_1G_TX_DATA00             0x400e80E4 0x400e8328 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_11_SAI3_RX_SYNC                  0x400e80E4 0x400e8328 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_11_FLEXSPI2_A_SS0_B              0x400e80E4 0x400e8328 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_11_GPIO_MUX2_IO21                0x400e80E4 0x400e8328 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_11_XBAR1_INOUT31                 0x400e80E4 0x400e8328 0x400e8704 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_11_EMVSIM1_IO                    0x400e80E4 0x400e8328 0x400e869C 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_11_TMR1_TIMER2                   0x400e80E4 0x400e8328 0x400e8644 0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_11_GPIO8_IO21                    0x400e80E4 0x400e8328 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_12_SEMC_DATA27                   0x400e80E8 0x400e832C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_12_SPDIF_OUT                     0x400e80E8 0x400e832C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_12_ENET_1G_TX_DATA01             0x400e80E8 0x400e832C 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_12_SAI3_RX_BCLK                  0x400e80E8 0x400e832C 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_12_FLEXSPI2_A_DQS                0x400e80E8 0x400e832C 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_12_GPIO_MUX2_IO22                0x400e80E8 0x400e832C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_12_XBAR1_INOUT32                 0x400e80E8 0x400e832C 0x400e8708 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_12_EMVSIM1_CLK                   0x400e80E8 0x400e832C 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_12_TMR1_TIMER3                   0x400e80E8 0x400e832C 0          0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_12_GPIO8_IO22                    0x400e80E8 0x400e832C 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_13_GPIO8_IO23                    0x400e80EC 0x400e8330 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_13_SEMC_DATA28                   0x400e80EC 0x400e8330 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_13_ENET_1G_TX_EN                 0x400e80EC 0x400e8330 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_13_SAI3_RX_DATA                  0x400e80EC 0x400e8330 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_13_FLEXSPI2_A_DATA00             0x400e80EC 0x400e8330 0x400e857C 0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_13_GPIO_MUX2_IO23                0x400e80EC 0x400e8330 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_13_XBAR1_INOUT33                 0x400e80EC 0x400e8330 0x400e870C 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_13_EMVSIM1_RST                   0x400e80EC 0x400e8330 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_13_TMR2_TIMER0                   0x400e80EC 0x400e8330 0x400e8648 0x9 1

#define IMXRT_PAD_GPIO_EMC_B2_14_SEMC_DATA29                   0x400e80F0 0x400e8334 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_14_ENET_1G_TX_CLK_IO             0x400e80F0 0x400e8334 0x400e84E8 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_14_SAI3_TX_DATA                  0x400e80F0 0x400e8334 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_14_FLEXSPI2_A_DATA01             0x400e80F0 0x400e8334 0x400e8580 0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_14_GPIO_MUX2_IO24                0x400e80F0 0x400e8334 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_14_XBAR1_INOUT34                 0x400e80F0 0x400e8334 0x400e8710 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_14_SFA_ipp_do_atx_clk_under_test 0x400e80F0 0x400e8334 0          0x7 0
#define IMXRT_PAD_GPIO_EMC_B2_14_EMVSIM1_SVEN                  0x400e80F0 0x400e8334 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_14_TMR2_TIMER1                   0x400e80F0 0x400e8334 0x400e864C 0x9 1
#define IMXRT_PAD_GPIO_EMC_B2_14_GPIO8_IO24                    0x400e80F0 0x400e8334 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_15_SEMC_DATA30                   0x400e80F4 0x400e8338 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_15_ENET_1G_RX_DATA00             0x400e80F4 0x400e8338 0x400e84D0 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_15_SAI3_TX_BCLK                  0x400e80F4 0x400e8338 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_15_FLEXSPI2_A_DATA02             0x400e80F4 0x400e8338 0x400e8584 0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_15_GPIO_MUX2_IO25                0x400e80F4 0x400e8338 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_15_XBAR1_INOUT35                 0x400e80F4 0x400e8338 0x400e8714 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_15_EMVSIM1_PD                    0x400e80F4 0x400e8338 0x400e86A0 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_15_TMR2_TIMER2                   0x400e80F4 0x400e8338 0x400e8650 0x9 0
#define IMXRT_PAD_GPIO_EMC_B2_15_GPIO8_IO25                    0x400e80F4 0x400e8338 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_16_GPIO8_IO26                    0x400e80F8 0x400e833C 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_16_SEMC_DATA31                   0x400e80F8 0x400e833C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_16_XBAR1_INOUT14                 0x400e80F8 0x400e833C 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_16_ENET_1G_RX_DATA01             0x400e80F8 0x400e833C 0x400e84D4 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_16_SAI3_TX_SYNC                  0x400e80F8 0x400e833C 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_16_FLEXSPI2_A_DATA03             0x400e80F8 0x400e833C 0x400e8588 0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_16_GPIO_MUX2_IO26                0x400e80F8 0x400e833C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_16_EMVSIM1_POWER_FAIL            0x400e80F8 0x400e833C 0x400e86A4 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_16_TMR2_TIMER3                   0x400e80F8 0x400e833C 0          0x9 0

#define IMXRT_PAD_GPIO_EMC_B2_17_SEMC_DM03                     0x400e80FC 0x400e8340 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_17_XBAR1_INOUT15                 0x400e80FC 0x400e8340 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_17_ENET_1G_RX_EN                 0x400e80FC 0x400e8340 0x400e84E0 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_17_SAI3_MCLK                     0x400e80FC 0x400e8340 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_17_FLEXSPI2_A_DATA04             0x400e80FC 0x400e8340 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_17_GPIO_MUX2_IO27                0x400e80FC 0x400e8340 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_17_WDOG1_ANY                     0x400e80FC 0x400e8340 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_17_TMR3_TIMER0                   0x400e80FC 0x400e8340 0x400e8654 0x9 1
#define IMXRT_PAD_GPIO_EMC_B2_17_GPIO8_IO27                    0x400e80FC 0x400e8340 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_18_SEMC_DQS4                     0x400e8100 0x400e8344 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_18_XBAR1_INOUT16                 0x400e8100 0x400e8344 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_18_ENET_1G_RX_ER                 0x400e8100 0x400e8344 0x400e84E4 0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_18_EWM_OUT_B                     0x400e8100 0x400e8344 0          0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_18_FLEXSPI2_A_DATA05             0x400e8100 0x400e8344 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_18_GPIO_MUX2_IO28                0x400e8100 0x400e8344 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_18_FLEXSPI1_A_DQS                0x400e8100 0x400e8344 0x400e8550 0x6 0
#define IMXRT_PAD_GPIO_EMC_B2_18_WDOG1_B                       0x400e8100 0x400e8344 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_18_TMR3_TIMER1                   0x400e8100 0x400e8344 0x400e8658 0x9 1
#define IMXRT_PAD_GPIO_EMC_B2_18_GPIO8_IO28                    0x400e8100 0x400e8344 0          0xA 0

#define IMXRT_PAD_GPIO_EMC_B2_19_GPIO8_IO29                    0x400e8104 0x400e8348 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_19_SEMC_CLKX00                   0x400e8104 0x400e8348 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_19_ENET_MDC                      0x400e8104 0x400e8348 0          0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_19_ENET_1G_MDC                   0x400e8104 0x400e8348 0          0x2 0
#define IMXRT_PAD_GPIO_EMC_B2_19_ENET_1G_REF_CLK               0x400e8104 0x400e8348 0x400e84C4 0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_19_FLEXSPI2_A_DATA06             0x400e8104 0x400e8348 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_19_GPIO_MUX2_IO29                0x400e8104 0x400e8348 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_19_ENET_QOS_MDC                  0x400e8104 0x400e8348 0          0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_19_TMR3_TIMER2                   0x400e8104 0x400e8348 0x400e865C 0x9 0

#define IMXRT_PAD_GPIO_EMC_B2_20_GPIO8_IO30                    0x400e8108 0x400e834C 0          0xA 0
#define IMXRT_PAD_GPIO_EMC_B2_20_SEMC_CLKX01                   0x400e8108 0x400e834C 0          0x0 0
#define IMXRT_PAD_GPIO_EMC_B2_20_ENET_MDIO                     0x400e8108 0x400e834C 0x400e84AC 0x1 0
#define IMXRT_PAD_GPIO_EMC_B2_20_ENET_1G_MDIO                  0x400e8108 0x400e834C 0x400e84C8 0x2 1
#define IMXRT_PAD_GPIO_EMC_B2_20_ENET_QOS_REF_CLK              0x400e8108 0x400e834C 0x400e84A0 0x3 0
#define IMXRT_PAD_GPIO_EMC_B2_20_FLEXSPI2_A_DATA07             0x400e8108 0x400e834C 0          0x4 0
#define IMXRT_PAD_GPIO_EMC_B2_20_GPIO_MUX2_IO30                0x400e8108 0x400e834C 0          0x5 0
#define IMXRT_PAD_GPIO_EMC_B2_20_ENET_QOS_MDIO                 0x400e8108 0x400e834C 0x400e84EC 0x8 0
#define IMXRT_PAD_GPIO_EMC_B2_20_TMR3_TIMER3                   0x400e8108 0x400e834C 0          0x9 0

#define IMXRT_PAD_GPIO_AD_00_GPIO8_IO31                        0x400e810C 0x400e8350 0          0xA 0
#define IMXRT_PAD_GPIO_AD_00_EMVSIM1_IO                        0x400e810C 0x400e8350 0x400e869C 0x0 1
#define IMXRT_PAD_GPIO_AD_00_FLEXCAN2_TX                       0x400e810C 0x400e8350 0          0x1 0
#define IMXRT_PAD_GPIO_AD_00_ENET_1G_1588_EVENT1_IN            0x400e810C 0x400e8350 0          0x2 0
#define IMXRT_PAD_GPIO_AD_00_GPT2_CAPTURE1                     0x400e810C 0x400e8350 0          0x3 0
#define IMXRT_PAD_GPIO_AD_00_FLEXPWM1_PWM0_A                   0x400e810C 0x400e8350 0x400e8500 0x4 1
#define IMXRT_PAD_GPIO_AD_00_GPIO_MUX2_IO31                    0x400e810C 0x400e8350 0          0x5 0
#define IMXRT_PAD_GPIO_AD_00_LPUART7_TXD                       0x400e810C 0x400e8350 0x400e8630 0x6 0
#define IMXRT_PAD_GPIO_AD_00_FLEXIO2_D00                       0x400e810C 0x400e8350 0          0x8 0
#define IMXRT_PAD_GPIO_AD_00_FLEXSPI2_B_SS1_B                  0x400e810C 0x400e8350 0          0x9 0

#define IMXRT_PAD_GPIO_AD_01_GPIO9_IO00                        0x400e8110 0x400e8354 0          0xA 0
#define IMXRT_PAD_GPIO_AD_01_EMVSIM1_CLK                       0x400e8110 0x400e8354 0          0x0 0
#define IMXRT_PAD_GPIO_AD_01_FLEXCAN2_RX                       0x400e8110 0x400e8354 0x400e849C 0x1 0
#define IMXRT_PAD_GPIO_AD_01_ENET_1G_1588_EVENT1_OUT           0x400e8110 0x400e8354 0          0x2 0
#define IMXRT_PAD_GPIO_AD_01_GPT2_CAPTURE2                     0x400e8110 0x400e8354 0          0x3 0
#define IMXRT_PAD_GPIO_AD_01_FLEXPWM1_PWM0_B                   0x400e8110 0x400e8354 0x400e850C 0x4 1
#define IMXRT_PAD_GPIO_AD_01_GPIO_MUX3_IO00                    0x400e8110 0x400e8354 0          0x5 0
#define IMXRT_PAD_GPIO_AD_01_LPUART7_RXD                       0x400e8110 0x400e8354 0x400e862C 0x6 0
#define IMXRT_PAD_GPIO_AD_01_FLEXIO2_D01                       0x400e8110 0x400e8354 0          0x8 0
#define IMXRT_PAD_GPIO_AD_01_FLEXSPI2_A_SS1_B                  0x400e8110 0x400e8354 0          0x9 0

#define IMXRT_PAD_GPIO_AD_02_GPIO9_IO01                        0x400e8114 0x400e8358 0          0xA 0
#define IMXRT_PAD_GPIO_AD_02_EMVSIM1_RST                       0x400e8114 0x400e8358 0          0x0 0
#define IMXRT_PAD_GPIO_AD_02_LPUART7_CTS_B                     0x400e8114 0x400e8358 0          0x1 0
#define IMXRT_PAD_GPIO_AD_02_ENET_1G_1588_EVENT2_IN            0x400e8114 0x400e8358 0          0x2 0
#define IMXRT_PAD_GPIO_AD_02_GPT2_COMPARE1                     0x400e8114 0x400e8358 0          0x3 0
#define IMXRT_PAD_GPIO_AD_02_FLEXPWM1_PWM1_A                   0x400e8114 0x400e8358 0x400e8504 0x4 1
#define IMXRT_PAD_GPIO_AD_02_GPIO_MUX3_IO01                    0x400e8114 0x400e8358 0          0x5 0
#define IMXRT_PAD_GPIO_AD_02_LPUART8_TXD                       0x400e8114 0x400e8358 0x400e8638 0x6 0
#define IMXRT_PAD_GPIO_AD_02_FLEXIO2_D02                       0x400e8114 0x400e8358 0          0x8 0
#define IMXRT_PAD_GPIO_AD_02_VIDEO_MUX_EXT_DCIC1               0x400e8114 0x400e8358 0          0x9 0

#define IMXRT_PAD_GPIO_AD_03_GPIO9_IO02                        0x400e8118 0x400e835C 0          0xA 0
#define IMXRT_PAD_GPIO_AD_03_EMVSIM1_SVEN                      0x400e8118 0x400e835C 0          0x0 0
#define IMXRT_PAD_GPIO_AD_03_LPUART7_RTS_B                     0x400e8118 0x400e835C 0          0x1 0
#define IMXRT_PAD_GPIO_AD_03_ENET_1G_1588_EVENT2_OUT           0x400e8118 0x400e835C 0          0x2 0
#define IMXRT_PAD_GPIO_AD_03_GPT2_COMPARE2                     0x400e8118 0x400e835C 0          0x3 0
#define IMXRT_PAD_GPIO_AD_03_FLEXPWM1_PWM1_B                   0x400e8118 0x400e835C 0x400e8510 0x4 1
#define IMXRT_PAD_GPIO_AD_03_GPIO_MUX3_IO02                    0x400e8118 0x400e835C 0          0x5 0
#define IMXRT_PAD_GPIO_AD_03_LPUART8_RXD                       0x400e8118 0x400e835C 0x400e8634 0x6 0
#define IMXRT_PAD_GPIO_AD_03_FLEXIO2_D03                       0x400e8118 0x400e835C 0          0x8 0
#define IMXRT_PAD_GPIO_AD_03_VIDEO_MUX_EXT_DCIC2               0x400e8118 0x400e835C 0          0x9 0

#define IMXRT_PAD_GPIO_AD_04_EMVSIM1_PD                        0x400e811C 0x400e8360 0x400e86A0 0x0 1
#define IMXRT_PAD_GPIO_AD_04_LPUART8_CTS_B                     0x400e811C 0x400e8360 0          0x1 0
#define IMXRT_PAD_GPIO_AD_04_ENET_1G_1588_EVENT3_IN            0x400e811C 0x400e8360 0          0x2 0
#define IMXRT_PAD_GPIO_AD_04_GPT2_COMPARE3                     0x400e811C 0x400e8360 0          0x3 0
#define IMXRT_PAD_GPIO_AD_04_FLEXPWM1_PWM2_A                   0x400e811C 0x400e8360 0x400e8508 0x4 1
#define IMXRT_PAD_GPIO_AD_04_GPIO_MUX3_IO03                    0x400e811C 0x400e8360 0          0x5 0
#define IMXRT_PAD_GPIO_AD_04_WDOG1_B                           0x400e811C 0x400e8360 0          0x6 0
#define IMXRT_PAD_GPIO_AD_04_FLEXIO2_D04                       0x400e811C 0x400e8360 0          0x8 0
#define IMXRT_PAD_GPIO_AD_04_TMR4_TIMER0                       0x400e811C 0x400e8360 0x400e8660 0x9 1
#define IMXRT_PAD_GPIO_AD_04_GPIO9_IO03                        0x400e811C 0x400e8360 0          0xA 0

#define IMXRT_PAD_GPIO_AD_05_EMVSIM1_POWER_FAIL                0x400e8120 0x400e8364 0x400e86A4 0x0 1
#define IMXRT_PAD_GPIO_AD_05_LPUART8_RTS_B                     0x400e8120 0x400e8364 0          0x1 0
#define IMXRT_PAD_GPIO_AD_05_ENET_1G_1588_EVENT3_OUT           0x400e8120 0x400e8364 0          0x2 0
#define IMXRT_PAD_GPIO_AD_05_GPT2_CLK                          0x400e8120 0x400e8364 0          0x3 0
#define IMXRT_PAD_GPIO_AD_05_FLEXPWM1_PWM2_B                   0x400e8120 0x400e8364 0x400e8514 0x4 1
#define IMXRT_PAD_GPIO_AD_05_GPIO_MUX3_IO04                    0x400e8120 0x400e8364 0          0x5 0
#define IMXRT_PAD_GPIO_AD_05_WDOG2_B                           0x400e8120 0x400e8364 0          0x6 0
#define IMXRT_PAD_GPIO_AD_05_FLEXIO2_D05                       0x400e8120 0x400e8364 0          0x8 0
#define IMXRT_PAD_GPIO_AD_05_TMR4_TIMER1                       0x400e8120 0x400e8364 0x400e8664 0x9 1
#define IMXRT_PAD_GPIO_AD_05_GPIO9_IO04                        0x400e8120 0x400e8364 0          0xA 0

#define IMXRT_PAD_GPIO_AD_06_USB_OTG2_OC                       0x400e8124 0x400e8368 0x400e86B8 0x0 0
#define IMXRT_PAD_GPIO_AD_06_FLEXCAN1_TX                       0x400e8124 0x400e8368 0          0x1 0
#define IMXRT_PAD_GPIO_AD_06_EMVSIM2_IO                        0x400e8124 0x400e8368 0x400e86A8 0x2 0
#define IMXRT_PAD_GPIO_AD_06_GPT3_CAPTURE1                     0x400e8124 0x400e8368 0x400e8590 0x3 1
#define IMXRT_PAD_GPIO_AD_06_VIDEO_MUX_CSI_DATA15              0x400e8124 0x400e8368 0          0x4 0
#define IMXRT_PAD_GPIO_AD_06_GPIO_MUX3_IO05                    0x400e8124 0x400e8368 0          0x5 0
#define IMXRT_PAD_GPIO_AD_06_ENET_1588_EVENT1_IN               0x400e8124 0x400e8368 0          0x6 0
#define IMXRT_PAD_GPIO_AD_06_FLEXIO2_D06                       0x400e8124 0x400e8368 0          0x8 0
#define IMXRT_PAD_GPIO_AD_06_TMR4_TIMER2                       0x400e8124 0x400e8368 0x400e8668 0x9 0
#define IMXRT_PAD_GPIO_AD_06_GPIO9_IO05                        0x400e8124 0x400e8368 0          0xA 0
#define IMXRT_PAD_GPIO_AD_06_FLEXPWM1_PWM0_X                   0x400e8124 0x400e8368 0          0xB 0

#define IMXRT_PAD_GPIO_AD_07_USB_OTG2_PWR                      0x400e8128 0x400e836C 0          0x0 0
#define IMXRT_PAD_GPIO_AD_07_FLEXCAN1_RX                       0x400e8128 0x400e836C 0x400e8498 0x1 0
#define IMXRT_PAD_GPIO_AD_07_EMVSIM2_CLK                       0x400e8128 0x400e836C 0          0x2 0
#define IMXRT_PAD_GPIO_AD_07_GPT3_CAPTURE2                     0x400e8128 0x400e836C 0x400e8594 0x3 1
#define IMXRT_PAD_GPIO_AD_07_VIDEO_MUX_CSI_DATA14              0x400e8128 0x400e836C 0          0x4 0
#define IMXRT_PAD_GPIO_AD_07_GPIO_MUX3_IO06                    0x400e8128 0x400e836C 0          0x5 0
#define IMXRT_PAD_GPIO_AD_07_ENET_1588_EVENT1_OUT              0x400e8128 0x400e836C 0          0x6 0
#define IMXRT_PAD_GPIO_AD_07_FLEXIO2_D07                       0x400e8128 0x400e836C 0          0x8 0
#define IMXRT_PAD_GPIO_AD_07_TMR4_TIMER3                       0x400e8128 0x400e836C 0          0x9 0
#define IMXRT_PAD_GPIO_AD_07_GPIO9_IO06                        0x400e8128 0x400e836C 0          0xA 0
#define IMXRT_PAD_GPIO_AD_07_FLEXPWM1_PWM1_X                   0x400e8128 0x400e836C 0          0xB 0

#define IMXRT_PAD_GPIO_AD_08_USBPHY2_OTG_ID                    0x400e812C 0x400e8370 0x400e86C4 0x0 0
#define IMXRT_PAD_GPIO_AD_08_LPI2C1_SCL                        0x400e812C 0x400e8370 0x400e85AC 0x1 0
#define IMXRT_PAD_GPIO_AD_08_EMVSIM2_RST                       0x400e812C 0x400e8370 0          0x2 0
#define IMXRT_PAD_GPIO_AD_08_GPT3_COMPARE1                     0x400e812C 0x400e8370 0          0x3 0
#define IMXRT_PAD_GPIO_AD_08_VIDEO_MUX_CSI_DATA13              0x400e812C 0x400e8370 0          0x4 0
#define IMXRT_PAD_GPIO_AD_08_GPIO_MUX3_IO07                    0x400e812C 0x400e8370 0          0x5 0
#define IMXRT_PAD_GPIO_AD_08_ENET_1588_EVENT2_IN               0x400e812C 0x400e8370 0          0x6 0
#define IMXRT_PAD_GPIO_AD_08_FLEXIO2_D08                       0x400e812C 0x400e8370 0          0x8 0
#define IMXRT_PAD_GPIO_AD_08_GPIO9_IO07                        0x400e812C 0x400e8370 0          0xA 0
#define IMXRT_PAD_GPIO_AD_08_FLEXPWM1_PWM2_X                   0x400e812C 0x400e8370 0          0xB 0

#define IMXRT_PAD_GPIO_AD_09_USBPHY1_OTG_ID                    0x400e8130 0x400e8374 0x400e86C0 0x0 0
#define IMXRT_PAD_GPIO_AD_09_LPI2C1_SDA                        0x400e8130 0x400e8374 0x400e85B0 0x1 0
#define IMXRT_PAD_GPIO_AD_09_EMVSIM2_SVEN                      0x400e8130 0x400e8374 0          0x2 0
#define IMXRT_PAD_GPIO_AD_09_GPT3_COMPARE2                     0x400e8130 0x400e8374 0          0x3 0
#define IMXRT_PAD_GPIO_AD_09_VIDEO_MUX_CSI_DATA12              0x400e8130 0x400e8374 0          0x4 0
#define IMXRT_PAD_GPIO_AD_09_GPIO_MUX3_IO08                    0x400e8130 0x400e8374 0          0x5 0
#define IMXRT_PAD_GPIO_AD_09_ENET_1588_EVENT2_OUT              0x400e8130 0x400e8374 0          0x6 0
#define IMXRT_PAD_GPIO_AD_09_FLEXIO2_D09                       0x400e8130 0x400e8374 0          0x8 0
#define IMXRT_PAD_GPIO_AD_09_GPIO9_IO08                        0x400e8130 0x400e8374 0          0xA 0
#define IMXRT_PAD_GPIO_AD_09_FLEXPWM1_PWM3_X                   0x400e8130 0x400e8374 0          0xB 0

#define IMXRT_PAD_GPIO_AD_10_USB_OTG1_PWR                      0x400e8134 0x400e8378 0          0x0 0
#define IMXRT_PAD_GPIO_AD_10_LPI2C1_SCLS                       0x400e8134 0x400e8378 0          0x1 0
#define IMXRT_PAD_GPIO_AD_10_EMVSIM2_PD                        0x400e8134 0x400e8378 0x400e86AC 0x2 0
#define IMXRT_PAD_GPIO_AD_10_GPT3_COMPARE3                     0x400e8134 0x400e8378 0          0x3 0
#define IMXRT_PAD_GPIO_AD_10_VIDEO_MUX_CSI_DATA11              0x400e8134 0x400e8378 0          0x4 0
#define IMXRT_PAD_GPIO_AD_10_GPIO_MUX3_IO09                    0x400e8134 0x400e8378 0          0x5 0
#define IMXRT_PAD_GPIO_AD_10_ENET_1588_EVENT3_IN               0x400e8134 0x400e8378 0          0x6 0
#define IMXRT_PAD_GPIO_AD_10_FLEXIO2_D10                       0x400e8134 0x400e8378 0          0x8 0
#define IMXRT_PAD_GPIO_AD_10_GPIO9_IO09                        0x400e8134 0x400e8378 0          0xA 0
#define IMXRT_PAD_GPIO_AD_10_FLEXPWM2_PWM0_X                   0x400e8134 0x400e8378 0          0xB 0

#define IMXRT_PAD_GPIO_AD_11_USB_OTG1_OC                       0x400e8138 0x400e837C 0x400e86BC 0x0 0
#define IMXRT_PAD_GPIO_AD_11_LPI2C1_SDAS                       0x400e8138 0x400e837C 0          0x1 0
#define IMXRT_PAD_GPIO_AD_11_EMVSIM2_POWER_FAIL                0x400e8138 0x400e837C 0x400e86B0 0x2 0
#define IMXRT_PAD_GPIO_AD_11_GPT3_CLK                          0x400e8138 0x400e837C 0x400e8598 0x3 1
#define IMXRT_PAD_GPIO_AD_11_VIDEO_MUX_CSI_DATA10              0x400e8138 0x400e837C 0          0x4 0
#define IMXRT_PAD_GPIO_AD_11_GPIO_MUX3_IO10                    0x400e8138 0x400e837C 0          0x5 0
#define IMXRT_PAD_GPIO_AD_11_ENET_1588_EVENT3_OUT              0x400e8138 0x400e837C 0          0x6 0
#define IMXRT_PAD_GPIO_AD_11_FLEXIO2_D11                       0x400e8138 0x400e837C 0          0x8 0
#define IMXRT_PAD_GPIO_AD_11_GPIO9_IO10                        0x400e8138 0x400e837C 0          0xA 0
#define IMXRT_PAD_GPIO_AD_11_FLEXPWM2_PWM1_X                   0x400e8138 0x400e837C 0          0xB 0

#define IMXRT_PAD_GPIO_AD_12_SPDIF_LOCK                        0x400e813C 0x400e8380 0          0x0 0
#define IMXRT_PAD_GPIO_AD_12_LPI2C1_HREQ                       0x400e813C 0x400e8380 0          0x1 0
#define IMXRT_PAD_GPIO_AD_12_GPT1_CAPTURE1                     0x400e813C 0x400e8380 0          0x2 0
#define IMXRT_PAD_GPIO_AD_12_FLEXSPI1_B_DATA03                 0x400e813C 0x400e8380 0x400e8570 0x3 0
#define IMXRT_PAD_GPIO_AD_12_VIDEO_MUX_CSI_PIXCLK              0x400e813C 0x400e8380 0          0x4 0
#define IMXRT_PAD_GPIO_AD_12_GPIO_MUX3_IO11                    0x400e813C 0x400e8380 0          0x5 0
#define IMXRT_PAD_GPIO_AD_12_ENET_TX_DATA03                    0x400e813C 0x400e8380 0          0x6 0
#define IMXRT_PAD_GPIO_AD_12_FLEXIO2_D12                       0x400e813C 0x400e8380 0          0x8 0
#define IMXRT_PAD_GPIO_AD_12_EWM_OUT_B                         0x400e813C 0x400e8380 0          0x9 0
#define IMXRT_PAD_GPIO_AD_12_GPIO9_IO11                        0x400e813C 0x400e8380 0          0xA 0
#define IMXRT_PAD_GPIO_AD_12_FLEXPWM2_PWM2_X                   0x400e813C 0x400e8380 0          0xB 0

#define IMXRT_PAD_GPIO_AD_13_SPDIF_SR_CLK                      0x400e8140 0x400e8384 0          0x0 0
#define IMXRT_PAD_GPIO_AD_13_PIT1_TRIGGER0                     0x400e8140 0x400e8384 0          0x1 0
#define IMXRT_PAD_GPIO_AD_13_GPT1_CAPTURE2                     0x400e8140 0x400e8384 0          0x2 0
#define IMXRT_PAD_GPIO_AD_13_FLEXSPI1_B_DATA02                 0x400e8140 0x400e8384 0x400e856C 0x3 0
#define IMXRT_PAD_GPIO_AD_13_VIDEO_MUX_CSI_MCLK                0x400e8140 0x400e8384 0          0x4 0
#define IMXRT_PAD_GPIO_AD_13_GPIO_MUX3_IO12                    0x400e8140 0x400e8384 0          0x5 0
#define IMXRT_PAD_GPIO_AD_13_ENET_TX_DATA02                    0x400e8140 0x400e8384 0          0x6 0
#define IMXRT_PAD_GPIO_AD_13_FLEXIO2_D13                       0x400e8140 0x400e8384 0          0x8 0
#define IMXRT_PAD_GPIO_AD_13_REF_CLK_32K                       0x400e8140 0x400e8384 0          0x9 0
#define IMXRT_PAD_GPIO_AD_13_GPIO9_IO12                        0x400e8140 0x400e8384 0          0xA 0
#define IMXRT_PAD_GPIO_AD_13_FLEXPWM2_PWM3_X                   0x400e8140 0x400e8384 0          0xB 0

#define IMXRT_PAD_GPIO_AD_14_SPDIF_EXT_CLK                     0x400e8144 0x400e8388 0          0x0 0
#define IMXRT_PAD_GPIO_AD_14_REF_CLK_24M                       0x400e8144 0x400e8388 0          0x1 0
#define IMXRT_PAD_GPIO_AD_14_GPT1_COMPARE1                     0x400e8144 0x400e8388 0          0x2 0
#define IMXRT_PAD_GPIO_AD_14_FLEXSPI1_B_DATA01                 0x400e8144 0x400e8388 0x400e8568 0x3 0
#define IMXRT_PAD_GPIO_AD_14_VIDEO_MUX_CSI_VSYNC               0x400e8144 0x400e8388 0          0x4 0
#define IMXRT_PAD_GPIO_AD_14_GPIO_MUX3_IO13                    0x400e8144 0x400e8388 0          0x5 0
#define IMXRT_PAD_GPIO_AD_14_ENET_RX_CLK                       0x400e8144 0x400e8388 0          0x6 0
#define IMXRT_PAD_GPIO_AD_14_FLEXIO2_D14                       0x400e8144 0x400e8388 0          0x8 0
#define IMXRT_PAD_GPIO_AD_14_CCM_ENET_REF_CLK_25M              0x400e8144 0x400e8388 0          0x9 0
#define IMXRT_PAD_GPIO_AD_14_GPIO9_IO13                        0x400e8144 0x400e8388 0          0xA 0
#define IMXRT_PAD_GPIO_AD_14_FLEXPWM3_PWM0_X                   0x400e8144 0x400e8388 0          0xB 0

#define IMXRT_PAD_GPIO_AD_15_GPIO9_IO14                        0x400e8148 0x400e838C 0          0xA 0
#define IMXRT_PAD_GPIO_AD_15_FLEXPWM3_PWM1_X                   0x400e8148 0x400e838C 0          0xB 0
#define IMXRT_PAD_GPIO_AD_15_SPDIF_IN                          0x400e8148 0x400e838C 0x400e86B4 0x0 1
#define IMXRT_PAD_GPIO_AD_15_LPUART10_TXD                      0x400e8148 0x400e838C 0x400e8628 0x1 0
#define IMXRT_PAD_GPIO_AD_15_GPT1_COMPARE2                     0x400e8148 0x400e838C 0          0x2 0
#define IMXRT_PAD_GPIO_AD_15_FLEXSPI1_B_DATA00                 0x400e8148 0x400e838C 0x400e8564 0x3 0
#define IMXRT_PAD_GPIO_AD_15_VIDEO_MUX_CSI_HSYNC               0x400e8148 0x400e838C 0          0x4 0
#define IMXRT_PAD_GPIO_AD_15_GPIO_MUX3_IO14                    0x400e8148 0x400e838C 0          0x5 0
#define IMXRT_PAD_GPIO_AD_15_ENET_TX_ER                        0x400e8148 0x400e838C 0          0x6 0
#define IMXRT_PAD_GPIO_AD_15_FLEXIO2_D15                       0x400e8148 0x400e838C 0          0x8 0

#define IMXRT_PAD_GPIO_AD_16_SPDIF_OUT                         0x400e814C 0x400e8390 0          0x0 0
#define IMXRT_PAD_GPIO_AD_16_LPUART10_RXD                      0x400e814C 0x400e8390 0x400e8624 0x1 0
#define IMXRT_PAD_GPIO_AD_16_GPT1_COMPARE3                     0x400e814C 0x400e8390 0          0x2 0
#define IMXRT_PAD_GPIO_AD_16_FLEXSPI1_B_SCLK                   0x400e814C 0x400e8390 0x400e8578 0x3 0
#define IMXRT_PAD_GPIO_AD_16_VIDEO_MUX_CSI_DATA09              0x400e814C 0x400e8390 0          0x4 0
#define IMXRT_PAD_GPIO_AD_16_GPIO_MUX3_IO15                    0x400e814C 0x400e8390 0          0x5 0
#define IMXRT_PAD_GPIO_AD_16_ENET_RX_DATA03                    0x400e814C 0x400e8390 0          0x6 0
#define IMXRT_PAD_GPIO_AD_16_FLEXIO2_D16                       0x400e814C 0x400e8390 0          0x8 0
#define IMXRT_PAD_GPIO_AD_16_ENET_1G_MDC                       0x400e814C 0x400e8390 0          0x9 0
#define IMXRT_PAD_GPIO_AD_16_GPIO9_IO15                        0x400e814C 0x400e8390 0          0xA 0
#define IMXRT_PAD_GPIO_AD_16_FLEXPWM3_PWM2_X                   0x400e814C 0x400e8390 0          0xB 0

#define IMXRT_PAD_GPIO_AD_17_SAI1_MCLK                         0x400e8150 0x400e8394 0x400e866C 0x0 0
#define IMXRT_PAD_GPIO_AD_17_ACMP1_OUT                         0x400e8150 0x400e8394 0          0x1 0
#define IMXRT_PAD_GPIO_AD_17_GPT1_CLK                          0x400e8150 0x400e8394 0          0x2 0
#define IMXRT_PAD_GPIO_AD_17_FLEXSPI1_A_DQS                    0x400e8150 0x400e8394 0x400e8550 0x3 1
#define IMXRT_PAD_GPIO_AD_17_VIDEO_MUX_CSI_DATA08              0x400e8150 0x400e8394 0          0x4 0
#define IMXRT_PAD_GPIO_AD_17_GPIO_MUX3_IO16                    0x400e8150 0x400e8394 0          0x5 0
#define IMXRT_PAD_GPIO_AD_17_ENET_RX_DATA02                    0x400e8150 0x400e8394 0          0x6 0
#define IMXRT_PAD_GPIO_AD_17_FLEXIO2_D17                       0x400e8150 0x400e8394 0          0x8 0
#define IMXRT_PAD_GPIO_AD_17_ENET_1G_MDIO                      0x400e8150 0x400e8394 0x400e84C8 0x9 2
#define IMXRT_PAD_GPIO_AD_17_GPIO9_IO16                        0x400e8150 0x400e8394 0          0xA 0
#define IMXRT_PAD_GPIO_AD_17_FLEXPWM3_PWM3_X                   0x400e8150 0x400e8394 0          0xB 0

#define IMXRT_PAD_GPIO_AD_18_GPIO9_IO17                        0x400e8154 0x400e8398 0          0xA 0
#define IMXRT_PAD_GPIO_AD_18_FLEXPWM4_PWM0_X                   0x400e8154 0x400e8398 0          0xB 0
#define IMXRT_PAD_GPIO_AD_18_SAI1_RX_SYNC                      0x400e8154 0x400e8398 0x400e8678 0x0 0
#define IMXRT_PAD_GPIO_AD_18_ACMP2_OUT                         0x400e8154 0x400e8398 0          0x1 0
#define IMXRT_PAD_GPIO_AD_18_LPSPI1_PCS1                       0x400e8154 0x400e8398 0          0x2 0
#define IMXRT_PAD_GPIO_AD_18_FLEXSPI1_A_SS0_B                  0x400e8154 0x400e8398 0          0x3 0
#define IMXRT_PAD_GPIO_AD_18_VIDEO_MUX_CSI_DATA07              0x400e8154 0x400e8398 0          0x4 0
#define IMXRT_PAD_GPIO_AD_18_GPIO_MUX3_IO17                    0x400e8154 0x400e8398 0          0x5 0
#define IMXRT_PAD_GPIO_AD_18_ENET_CRS                          0x400e8154 0x400e8398 0          0x6 0
#define IMXRT_PAD_GPIO_AD_18_FLEXIO2_D18                       0x400e8154 0x400e8398 0          0x8 0
#define IMXRT_PAD_GPIO_AD_18_LPI2C2_SCL                        0x400e8154 0x400e8398 0x400e85B4 0x9 1

#define IMXRT_PAD_GPIO_AD_19_SAI1_RX_BCLK                      0x400e8158 0x400e839C 0x400e8670 0x0 0
#define IMXRT_PAD_GPIO_AD_19_ACMP3_OUT                         0x400e8158 0x400e839C 0          0x1 0
#define IMXRT_PAD_GPIO_AD_19_LPSPI1_PCS2                       0x400e8158 0x400e839C 0          0x2 0
#define IMXRT_PAD_GPIO_AD_19_FLEXSPI1_A_SCLK                   0x400e8158 0x400e839C 0x400e8574 0x3 0
#define IMXRT_PAD_GPIO_AD_19_VIDEO_MUX_CSI_DATA06              0x400e8158 0x400e839C 0          0x4 0
#define IMXRT_PAD_GPIO_AD_19_GPIO_MUX3_IO18                    0x400e8158 0x400e839C 0          0x5 0
#define IMXRT_PAD_GPIO_AD_19_ENET_COL                          0x400e8158 0x400e839C 0          0x6 0
#define IMXRT_PAD_GPIO_AD_19_FLEXIO2_D19                       0x400e8158 0x400e839C 0          0x8 0
#define IMXRT_PAD_GPIO_AD_19_LPI2C2_SDA                        0x400e8158 0x400e839C 0x400e85B8 0x9 1
#define IMXRT_PAD_GPIO_AD_19_GPIO9_IO18                        0x400e8158 0x400e839C 0          0xA 0
#define IMXRT_PAD_GPIO_AD_19_FLEXPWM4_PWM1_X                   0x400e8158 0x400e839C 0          0xB 0

#define IMXRT_PAD_GPIO_AD_20_SAI1_RX_DATA00                    0x400e815C 0x400e83A0 0x400e8674 0x0 0
#define IMXRT_PAD_GPIO_AD_20_ACMP4_OUT                         0x400e815C 0x400e83A0 0          0x1 0
#define IMXRT_PAD_GPIO_AD_20_LPSPI1_PCS3                       0x400e815C 0x400e83A0 0          0x2 0
#define IMXRT_PAD_GPIO_AD_20_FLEXSPI1_A_DATA00                 0x400e815C 0x400e83A0 0x400e8554 0x3 0
#define IMXRT_PAD_GPIO_AD_20_VIDEO_MUX_CSI_DATA05              0x400e815C 0x400e83A0 0          0x4 0
#define IMXRT_PAD_GPIO_AD_20_GPIO_MUX3_IO19                    0x400e815C 0x400e83A0 0          0x5 0
#define IMXRT_PAD_GPIO_AD_20_KPP_ROW07                         0x400e815C 0x400e83A0 0x400e85A8 0x6 0
#define IMXRT_PAD_GPIO_AD_20_FLEXIO2_D20                       0x400e815C 0x400e83A0 0          0x8 0
#define IMXRT_PAD_GPIO_AD_20_ENET_QOS_1588_EVENT2_OUT          0x400e815C 0x400e83A0 0          0x9 0
#define IMXRT_PAD_GPIO_AD_20_GPIO9_IO19                        0x400e815C 0x400e83A0 0          0xA 0
#define IMXRT_PAD_GPIO_AD_20_FLEXPWM4_PWM2_X                   0x400e815C 0x400e83A0 0          0xB 0

#define IMXRT_PAD_GPIO_AD_21_SAI1_TX_DATA00                    0x400e8160 0x400e83A4 0          0x0 0
#define IMXRT_PAD_GPIO_AD_21_LPSPI2_PCS1                       0x400e8160 0x400e83A4 0x400e85E0 0x2 0
#define IMXRT_PAD_GPIO_AD_21_FLEXSPI1_A_DATA01                 0x400e8160 0x400e83A4 0x400e8558 0x3 0
#define IMXRT_PAD_GPIO_AD_21_VIDEO_MUX_CSI_DATA04              0x400e8160 0x400e83A4 0          0x4 0
#define IMXRT_PAD_GPIO_AD_21_GPIO_MUX3_IO20                    0x400e8160 0x400e83A4 0          0x5 0
#define IMXRT_PAD_GPIO_AD_21_KPP_COL07                         0x400e8160 0x400e83A4 0x400e85A0 0x6 0
#define IMXRT_PAD_GPIO_AD_21_FLEXIO2_D21                       0x400e8160 0x400e83A4 0          0x8 0
#define IMXRT_PAD_GPIO_AD_21_ENET_QOS_1588_EVENT2_IN           0x400e8160 0x400e83A4 0          0x9 0
#define IMXRT_PAD_GPIO_AD_21_GPIO9_IO20                        0x400e8160 0x400e83A4 0          0xA 0
#define IMXRT_PAD_GPIO_AD_21_FLEXPWM4_PWM3_X                   0x400e8160 0x400e83A4 0          0xB 0

#define IMXRT_PAD_GPIO_AD_22_GPIO9_IO21                        0x400e8164 0x400e83A8 0          0xA 0
#define IMXRT_PAD_GPIO_AD_22_SAI1_TX_BCLK                      0x400e8164 0x400e83A8 0x400e867C 0x0 0
#define IMXRT_PAD_GPIO_AD_22_LPSPI2_PCS2                       0x400e8164 0x400e83A8 0          0x2 0
#define IMXRT_PAD_GPIO_AD_22_FLEXSPI1_A_DATA02                 0x400e8164 0x400e83A8 0x400e855C 0x3 0
#define IMXRT_PAD_GPIO_AD_22_VIDEO_MUX_CSI_DATA03              0x400e8164 0x400e83A8 0          0x4 0
#define IMXRT_PAD_GPIO_AD_22_GPIO_MUX3_IO21                    0x400e8164 0x400e83A8 0          0x5 0
#define IMXRT_PAD_GPIO_AD_22_KPP_ROW06                         0x400e8164 0x400e83A8 0x400e85A4 0x6 0
#define IMXRT_PAD_GPIO_AD_22_FLEXIO2_D22                       0x400e8164 0x400e83A8 0          0x8 0
#define IMXRT_PAD_GPIO_AD_22_ENET_QOS_1588_EVENT3_OUT          0x400e8164 0x400e83A8 0          0x9 0

#define IMXRT_PAD_GPIO_AD_23_SAI1_TX_SYNC                      0x400e8168 0x400e83AC 0x400e8680 0x0 0
#define IMXRT_PAD_GPIO_AD_23_LPSPI2_PCS3                       0x400e8168 0x400e83AC 0          0x2 0
#define IMXRT_PAD_GPIO_AD_23_FLEXSPI1_A_DATA03                 0x400e8168 0x400e83AC 0x400e8560 0x3 0
#define IMXRT_PAD_GPIO_AD_23_VIDEO_MUX_CSI_DATA02              0x400e8168 0x400e83AC 0          0x4 0
#define IMXRT_PAD_GPIO_AD_23_GPIO_MUX3_IO22                    0x400e8168 0x400e83AC 0          0x5 0
#define IMXRT_PAD_GPIO_AD_23_KPP_COL06                         0x400e8168 0x400e83AC 0x400e859C 0x6 0
#define IMXRT_PAD_GPIO_AD_23_FLEXIO2_D23                       0x400e8168 0x400e83AC 0          0x8 0
#define IMXRT_PAD_GPIO_AD_23_ENET_QOS_1588_EVENT3_IN           0x400e8168 0x400e83AC 0          0x9 0
#define IMXRT_PAD_GPIO_AD_23_GPIO9_IO22                        0x400e8168 0x400e83AC 0          0xA 0

#define IMXRT_PAD_GPIO_AD_24_LPUART1_TXD                       0x400e816C 0x400e83B0 0x400e8620 0x0 0
#define IMXRT_PAD_GPIO_AD_24_LPSPI2_SCK                        0x400e816C 0x400e83B0 0x400e85E4 0x1 0
#define IMXRT_PAD_GPIO_AD_24_VIDEO_MUX_CSI_DATA00              0x400e816C 0x400e83B0 0          0x2 0
#define IMXRT_PAD_GPIO_AD_24_ENET_RX_EN                        0x400e816C 0x400e83B0 0x400e84B8 0x3 0
#define IMXRT_PAD_GPIO_AD_24_FLEXPWM2_PWM0_A                   0x400e816C 0x400e83B0 0x400e8518 0x4 1
#define IMXRT_PAD_GPIO_AD_24_GPIO_MUX3_IO23                    0x400e816C 0x400e83B0 0          0x5 0
#define IMXRT_PAD_GPIO_AD_24_KPP_ROW05                         0x400e816C 0x400e83B0 0          0x6 0
#define IMXRT_PAD_GPIO_AD_24_FLEXIO2_D24                       0x400e816C 0x400e83B0 0          0x8 0
#define IMXRT_PAD_GPIO_AD_24_LPI2C4_SCL                        0x400e816C 0x400e83B0 0x400e85C4 0x9 0
#define IMXRT_PAD_GPIO_AD_24_GPIO9_IO23                        0x400e816C 0x400e83B0 0          0xA 0

#define IMXRT_PAD_GPIO_AD_25_GPIO9_IO24                        0x400e8170 0x400e83B4 0          0xA 0
#define IMXRT_PAD_GPIO_AD_25_LPUART1_RXD                       0x400e8170 0x400e83B4 0x400e861C 0x0 0
#define IMXRT_PAD_GPIO_AD_25_LPSPI2_PCS0                       0x400e8170 0x400e83B4 0x400e85DC 0x1 0
#define IMXRT_PAD_GPIO_AD_25_VIDEO_MUX_CSI_DATA01              0x400e8170 0x400e83B4 0          0x2 0
#define IMXRT_PAD_GPIO_AD_25_ENET_RX_ER                        0x400e8170 0x400e83B4 0x400e84BC 0x3 0
#define IMXRT_PAD_GPIO_AD_25_FLEXPWM2_PWM0_B                   0x400e8170 0x400e83B4 0x400e8524 0x4 1
#define IMXRT_PAD_GPIO_AD_25_GPIO_MUX3_IO24                    0x400e8170 0x400e83B4 0          0x5 0
#define IMXRT_PAD_GPIO_AD_25_KPP_COL05                         0x400e8170 0x400e83B4 0          0x6 0
#define IMXRT_PAD_GPIO_AD_25_FLEXIO2_D25                       0x400e8170 0x400e83B4 0          0x8 0
#define IMXRT_PAD_GPIO_AD_25_LPI2C4_SDA                        0x400e8170 0x400e83B4 0x400e85C8 0x9 0

#define IMXRT_PAD_GPIO_AD_26_LPUART1_CTS_B                     0x400e8174 0x400e83B8 0          0x0 0
#define IMXRT_PAD_GPIO_AD_26_LPSPI2_SOUT                       0x400e8174 0x400e83B8 0x400e85EC 0x1 0
#define IMXRT_PAD_GPIO_AD_26_SEMC_CSX01                        0x400e8174 0x400e83B8 0          0x2 0
#define IMXRT_PAD_GPIO_AD_26_ENET_RX_DATA00                    0x400e8174 0x400e83B8 0x400e84B0 0x3 0
#define IMXRT_PAD_GPIO_AD_26_FLEXPWM2_PWM1_A                   0x400e8174 0x400e83B8 0x400e851C 0x4 1
#define IMXRT_PAD_GPIO_AD_26_GPIO_MUX3_IO25                    0x400e8174 0x400e83B8 0          0x5 0
#define IMXRT_PAD_GPIO_AD_26_KPP_ROW04                         0x400e8174 0x400e83B8 0          0x6 0
#define IMXRT_PAD_GPIO_AD_26_FLEXIO2_D26                       0x400e8174 0x400e83B8 0          0x8 0
#define IMXRT_PAD_GPIO_AD_26_ENET_QOS_MDC                      0x400e8174 0x400e83B8 0          0x9 0
#define IMXRT_PAD_GPIO_AD_26_GPIO9_IO25                        0x400e8174 0x400e83B8 0          0xA 0
#define IMXRT_PAD_GPIO_AD_26_USDHC2_CD_B                       0x400e8174 0x400e83B8 0x400e86D0 0xB 1

#define IMXRT_PAD_GPIO_AD_27_LPUART1_RTS_B                     0x400e8178 0x400e83BC 0          0x0 0
#define IMXRT_PAD_GPIO_AD_27_LPSPI2_SIN                        0x400e8178 0x400e83BC 0x400e85E8 0x1 0
#define IMXRT_PAD_GPIO_AD_27_SEMC_CSX02                        0x400e8178 0x400e83BC 0          0x2 0
#define IMXRT_PAD_GPIO_AD_27_ENET_RX_DATA01                    0x400e8178 0x400e83BC 0x400e84B4 0x3 0
#define IMXRT_PAD_GPIO_AD_27_FLEXPWM2_PWM1_B                   0x400e8178 0x400e83BC 0x400e8528 0x4 1
#define IMXRT_PAD_GPIO_AD_27_GPIO_MUX3_IO26                    0x400e8178 0x400e83BC 0          0x5 0
#define IMXRT_PAD_GPIO_AD_27_KPP_COL04                         0x400e8178 0x400e83BC 0          0x6 0
#define IMXRT_PAD_GPIO_AD_27_FLEXIO2_D27                       0x400e8178 0x400e83BC 0          0x8 0
#define IMXRT_PAD_GPIO_AD_27_ENET_QOS_MDIO                     0x400e8178 0x400e83BC 0x400e84EC 0x9 1
#define IMXRT_PAD_GPIO_AD_27_GPIO9_IO26                        0x400e8178 0x400e83BC 0          0xA 0
#define IMXRT_PAD_GPIO_AD_27_USDHC2_WP                         0x400e8178 0x400e83BC 0x400e86D4 0xB 1

#define IMXRT_PAD_GPIO_AD_28_GPIO9_IO27                        0x400e817C 0x400e83C0 0          0xA 0
#define IMXRT_PAD_GPIO_AD_28_USDHC2_VSELECT                    0x400e817C 0x400e83C0 0          0xB 0
#define IMXRT_PAD_GPIO_AD_28_LPSPI1_SCK                        0x400e817C 0x400e83C0 0x400e85D0 0x0 1
#define IMXRT_PAD_GPIO_AD_28_LPUART5_TXD                       0x400e817C 0x400e83C0 0          0x1 0
#define IMXRT_PAD_GPIO_AD_28_SEMC_CSX03                        0x400e817C 0x400e83C0 0          0x2 0
#define IMXRT_PAD_GPIO_AD_28_ENET_TX_EN                        0x400e817C 0x400e83C0 0          0x3 0
#define IMXRT_PAD_GPIO_AD_28_FLEXPWM2_PWM2_A                   0x400e817C 0x400e83C0 0x400e8520 0x4 1
#define IMXRT_PAD_GPIO_AD_28_GPIO_MUX3_IO27                    0x400e817C 0x400e83C0 0          0x5 0
#define IMXRT_PAD_GPIO_AD_28_KPP_ROW03                         0x400e817C 0x400e83C0 0          0x6 0
#define IMXRT_PAD_GPIO_AD_28_FLEXIO2_D28                       0x400e817C 0x400e83C0 0          0x8 0
#define IMXRT_PAD_GPIO_AD_28_VIDEO_MUX_EXT_DCIC1               0x400e817C 0x400e83C0 0          0x9 0

#define IMXRT_PAD_GPIO_AD_29_LPSPI1_PCS0                       0x400e8180 0x400e83C4 0x400e85CC 0x0 1
#define IMXRT_PAD_GPIO_AD_29_LPUART5_RXD                       0x400e8180 0x400e83C4 0          0x1 0
#define IMXRT_PAD_GPIO_AD_29_ENET_REF_CLK                      0x400e8180 0x400e83C4 0x400e84A8 0x2 0
#define IMXRT_PAD_GPIO_AD_29_ENET_TX_CLK                       0x400e8180 0x400e83C4 0x400e84C0 0x3 0
#define IMXRT_PAD_GPIO_AD_29_FLEXPWM2_PWM2_B                   0x400e8180 0x400e83C4 0x400e852C 0x4 1
#define IMXRT_PAD_GPIO_AD_29_GPIO_MUX3_IO28                    0x400e8180 0x400e83C4 0          0x5 0
#define IMXRT_PAD_GPIO_AD_29_KPP_COL03                         0x400e8180 0x400e83C4 0          0x6 0
#define IMXRT_PAD_GPIO_AD_29_FLEXIO2_D29                       0x400e8180 0x400e83C4 0          0x8 0
#define IMXRT_PAD_GPIO_AD_29_VIDEO_MUX_EXT_DCIC2               0x400e8180 0x400e83C4 0          0x9 0
#define IMXRT_PAD_GPIO_AD_29_GPIO9_IO28                        0x400e8180 0x400e83C4 0          0xA 0
#define IMXRT_PAD_GPIO_AD_29_USDHC2_RESET_B                    0x400e8180 0x400e83C4 0          0xB 0

#define IMXRT_PAD_GPIO_AD_30_LPSPI1_SOUT                       0x400e8184 0x400e83C8 0x400e85D8 0x0 1
#define IMXRT_PAD_GPIO_AD_30_USB_OTG2_OC                       0x400e8184 0x400e83C8 0x400e86B8 0x1 1
#define IMXRT_PAD_GPIO_AD_30_FLEXCAN2_TX                       0x400e8184 0x400e83C8 0          0x2 0
#define IMXRT_PAD_GPIO_AD_30_ENET_TX_DATA00                    0x400e8184 0x400e83C8 0          0x3 0
#define IMXRT_PAD_GPIO_AD_30_LPUART3_TXD                       0x400e8184 0x400e83C8 0          0x4 0
#define IMXRT_PAD_GPIO_AD_30_GPIO_MUX3_IO29                    0x400e8184 0x400e83C8 0          0x5 0
#define IMXRT_PAD_GPIO_AD_30_KPP_ROW02                         0x400e8184 0x400e83C8 0          0x6 0
#define IMXRT_PAD_GPIO_AD_30_FLEXIO2_D30                       0x400e8184 0x400e83C8 0          0x8 0
#define IMXRT_PAD_GPIO_AD_30_WDOG2_RESET_B_DEB                 0x400e8184 0x400e83C8 0          0x9 0
#define IMXRT_PAD_GPIO_AD_30_GPIO9_IO29                        0x400e8184 0x400e83C8 0          0xA 0

#define IMXRT_PAD_GPIO_AD_31_LPSPI1_SIN                        0x400e8188 0x400e83CC 0x400e85D4 0x0 1
#define IMXRT_PAD_GPIO_AD_31_USB_OTG2_PWR                      0x400e8188 0x400e83CC 0          0x1 0
#define IMXRT_PAD_GPIO_AD_31_FLEXCAN2_RX                       0x400e8188 0x400e83CC 0x400e849C 0x2 1
#define IMXRT_PAD_GPIO_AD_31_ENET_TX_DATA01                    0x400e8188 0x400e83CC 0          0x3 0
#define IMXRT_PAD_GPIO_AD_31_LPUART3_RXD                       0x400e8188 0x400e83CC 0          0x4 0
#define IMXRT_PAD_GPIO_AD_31_GPIO_MUX3_IO30                    0x400e8188 0x400e83CC 0          0x5 0
#define IMXRT_PAD_GPIO_AD_31_KPP_COL02                         0x400e8188 0x400e83CC 0          0x6 0
#define IMXRT_PAD_GPIO_AD_31_FLEXIO2_D31                       0x400e8188 0x400e83CC 0          0x8 0
#define IMXRT_PAD_GPIO_AD_31_WDOG1_RESET_B_DEB                 0x400e8188 0x400e83CC 0          0x9 0
#define IMXRT_PAD_GPIO_AD_31_GPIO9_IO30                        0x400e8188 0x400e83CC 0          0xA 0

#define IMXRT_PAD_GPIO_AD_32_GPIO9_IO31                        0x400e818C 0x400e83D0 0          0xA 0
#define IMXRT_PAD_GPIO_AD_32_LPI2C1_SCL                        0x400e818C 0x400e83D0 0x400e85AC 0x0 1
#define IMXRT_PAD_GPIO_AD_32_USBPHY2_OTG_ID                    0x400e818C 0x400e83D0 0x400e86C4 0x1 1
#define IMXRT_PAD_GPIO_AD_32_PGMC_PMIC_RDY                     0x400e818C 0x400e83D0 0          0x2 0
#define IMXRT_PAD_GPIO_AD_32_ENET_MDC                          0x400e818C 0x400e83D0 0          0x3 0
#define IMXRT_PAD_GPIO_AD_32_USDHC1_CD_B                       0x400e818C 0x400e83D0 0x400e86C8 0x4 0
#define IMXRT_PAD_GPIO_AD_32_GPIO_MUX3_IO31                    0x400e818C 0x400e83D0 0          0x5 0
#define IMXRT_PAD_GPIO_AD_32_KPP_ROW01                         0x400e818C 0x400e83D0 0          0x6 0
#define IMXRT_PAD_GPIO_AD_32_LPUART10_TXD                      0x400e818C 0x400e83D0 0x400e8628 0x8 1
#define IMXRT_PAD_GPIO_AD_32_ENET_1G_MDC                       0x400e818C 0x400e83D0 0          0x9 0

#define IMXRT_PAD_GPIO_AD_33_LPI2C1_SDA                        0x400e8190 0x400e83D4 0x400e85B0 0x0 1
#define IMXRT_PAD_GPIO_AD_33_USBPHY1_OTG_ID                    0x400e8190 0x400e83D4 0x400e86C0 0x1 1
#define IMXRT_PAD_GPIO_AD_33_XBAR1_INOUT17                     0x400e8190 0x400e83D4 0          0x2 0
#define IMXRT_PAD_GPIO_AD_33_ENET_MDIO                         0x400e8190 0x400e83D4 0x400e84AC 0x3 1
#define IMXRT_PAD_GPIO_AD_33_USDHC1_WP                         0x400e8190 0x400e83D4 0x400e86CC 0x4 0
#define IMXRT_PAD_GPIO_AD_33_GPIO_MUX4_IO00                    0x400e8190 0x400e83D4 0          0x5 0
#define IMXRT_PAD_GPIO_AD_33_KPP_COL01                         0x400e8190 0x400e83D4 0          0x6 0
#define IMXRT_PAD_GPIO_AD_33_LPUART10_RXD                      0x400e8190 0x400e83D4 0x400e8624 0x8 1
#define IMXRT_PAD_GPIO_AD_33_ENET_1G_MDIO                      0x400e8190 0x400e83D4 0x400e84C8 0x9 3
#define IMXRT_PAD_GPIO_AD_33_GPIO10_IO00                       0x400e8190 0x400e83D4 0          0xA 0

#define IMXRT_PAD_GPIO_AD_34_ENET_1G_1588_EVENT0_IN            0x400e8194 0x400e83D8 0          0x0 0
#define IMXRT_PAD_GPIO_AD_34_USB_OTG1_PWR                      0x400e8194 0x400e83D8 0          0x1 0
#define IMXRT_PAD_GPIO_AD_34_XBAR1_INOUT18                     0x400e8194 0x400e83D8 0          0x2 0
#define IMXRT_PAD_GPIO_AD_34_ENET_1588_EVENT0_IN               0x400e8194 0x400e83D8 0          0x3 0
#define IMXRT_PAD_GPIO_AD_34_USDHC1_VSELECT                    0x400e8194 0x400e83D8 0          0x4 0
#define IMXRT_PAD_GPIO_AD_34_GPIO_MUX4_IO01                    0x400e8194 0x400e83D8 0          0x5 0
#define IMXRT_PAD_GPIO_AD_34_KPP_ROW00                         0x400e8194 0x400e83D8 0          0x6 0
#define IMXRT_PAD_GPIO_AD_34_LPUART10_CTS_B                    0x400e8194 0x400e83D8 0          0x8 0
#define IMXRT_PAD_GPIO_AD_34_WDOG1_ANY                         0x400e8194 0x400e83D8 0          0x9 0
#define IMXRT_PAD_GPIO_AD_34_GPIO10_IO01                       0x400e8194 0x400e83D8 0          0xA 0

#define IMXRT_PAD_GPIO_AD_35_GPIO10_IO02                       0x400e8198 0x400e83DC 0          0xA 0
#define IMXRT_PAD_GPIO_AD_35_ENET_1G_1588_EVENT0_OUT           0x400e8198 0x400e83DC 0          0x0 0
#define IMXRT_PAD_GPIO_AD_35_USB_OTG1_OC                       0x400e8198 0x400e83DC 0x400e86BC 0x1 1
#define IMXRT_PAD_GPIO_AD_35_XBAR1_INOUT19                     0x400e8198 0x400e83DC 0          0x2 0
#define IMXRT_PAD_GPIO_AD_35_ENET_1588_EVENT0_OUT              0x400e8198 0x400e83DC 0          0x3 0
#define IMXRT_PAD_GPIO_AD_35_USDHC1_RESET_B                    0x400e8198 0x400e83DC 0          0x4 0
#define IMXRT_PAD_GPIO_AD_35_GPIO_MUX4_IO02                    0x400e8198 0x400e83DC 0          0x5 0
#define IMXRT_PAD_GPIO_AD_35_KPP_COL00                         0x400e8198 0x400e83DC 0          0x6 0
#define IMXRT_PAD_GPIO_AD_35_LPUART10_RTS_B                    0x400e8198 0x400e83DC 0          0x8 0
#define IMXRT_PAD_GPIO_AD_35_FLEXSPI1_B_SS1_B                  0x400e8198 0x400e83DC 0          0x9 0

#define IMXRT_PAD_GPIO_SD_B1_00_USDHC1_CMD                     0x400e819C 0x400e83E0 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B1_00_XBAR1_INOUT20                  0x400e819C 0x400e83E0 0x400e86D8 0x2 1
#define IMXRT_PAD_GPIO_SD_B1_00_GPT4_CAPTURE1                  0x400e819C 0x400e83E0 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B1_00_GPIO_MUX4_IO03                 0x400e819C 0x400e83E0 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B1_00_FLEXSPI2_A_SS0_B               0x400e819C 0x400e83E0 0          0x6 0
#define IMXRT_PAD_GPIO_SD_B1_00_KPP_ROW07                      0x400e819C 0x400e83E0 0x400e85A8 0x8 1
#define IMXRT_PAD_GPIO_SD_B1_00_GPIO10_IO03                    0x400e819C 0x400e83E0 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B1_01_USDHC1_CLK                     0x400e81A0 0x400e83E4 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B1_01_XBAR1_INOUT21                  0x400e81A0 0x400e83E4 0x400e86DC 0x2 1
#define IMXRT_PAD_GPIO_SD_B1_01_GPT4_CAPTURE2                  0x400e81A0 0x400e83E4 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B1_01_GPIO_MUX4_IO04                 0x400e81A0 0x400e83E4 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B1_01_FLEXSPI2_A_SCLK                0x400e81A0 0x400e83E4 0x400e858C 0x6 1
#define IMXRT_PAD_GPIO_SD_B1_01_KPP_COL07                      0x400e81A0 0x400e83E4 0x400e85A0 0x8 1
#define IMXRT_PAD_GPIO_SD_B1_01_GPIO10_IO04                    0x400e81A0 0x400e83E4 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B1_02_GPIO10_IO05                    0x400e81A4 0x400e83E8 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B1_02_USDHC1_DATA0                   0x400e81A4 0x400e83E8 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B1_02_XBAR1_INOUT22                  0x400e81A4 0x400e83E8 0x400e86E0 0x2 1
#define IMXRT_PAD_GPIO_SD_B1_02_GPT4_COMPARE1                  0x400e81A4 0x400e83E8 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B1_02_GPIO_MUX4_IO05                 0x400e81A4 0x400e83E8 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B1_02_FLEXSPI2_A_DATA00              0x400e81A4 0x400e83E8 0x400e857C 0x6 1
#define IMXRT_PAD_GPIO_SD_B1_02_KPP_ROW06                      0x400e81A4 0x400e83E8 0x400e85A4 0x8 1
#define IMXRT_PAD_GPIO_SD_B1_02_FLEXSPI1_A_SS1_B               0x400e81A4 0x400e83E8 0          0x9 0

#define IMXRT_PAD_GPIO_SD_B1_03_USDHC1_DATA1                   0x400e81A8 0x400e83EC 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B1_03_XBAR1_INOUT23                  0x400e81A8 0x400e83EC 0x400e86E4 0x2 1
#define IMXRT_PAD_GPIO_SD_B1_03_GPT4_COMPARE2                  0x400e81A8 0x400e83EC 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B1_03_GPIO_MUX4_IO06                 0x400e81A8 0x400e83EC 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B1_03_FLEXSPI2_A_DATA01              0x400e81A8 0x400e83EC 0x400e8580 0x6 1
#define IMXRT_PAD_GPIO_SD_B1_03_KPP_COL06                      0x400e81A8 0x400e83EC 0x400e859C 0x8 1
#define IMXRT_PAD_GPIO_SD_B1_03_FLEXSPI1_B_SS1_B               0x400e81A8 0x400e83EC 0          0x9 0
#define IMXRT_PAD_GPIO_SD_B1_03_GPIO10_IO06                    0x400e81A8 0x400e83EC 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B1_04_USDHC1_DATA2                   0x400e81AC 0x400e83F0 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B1_04_XBAR1_INOUT24                  0x400e81AC 0x400e83F0 0x400e86E8 0x2 1
#define IMXRT_PAD_GPIO_SD_B1_04_GPT4_COMPARE3                  0x400e81AC 0x400e83F0 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B1_04_GPIO_MUX4_IO07                 0x400e81AC 0x400e83F0 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B1_04_FLEXSPI2_A_DATA02              0x400e81AC 0x400e83F0 0x400e8584 0x6 1
#define IMXRT_PAD_GPIO_SD_B1_04_FLEXSPI1_B_SS0_B               0x400e81AC 0x400e83F0 0          0x8 0
#define IMXRT_PAD_GPIO_SD_B1_04_ENET_QOS_1588_EVENT2_AUX_IN    0x400e81AC 0x400e83F0 0          0x9 0
#define IMXRT_PAD_GPIO_SD_B1_04_GPIO10_IO07                    0x400e81AC 0x400e83F0 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B1_05_GPIO10_IO08                    0x400e81B0 0x400e83F4 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B1_05_USDHC1_DATA3                   0x400e81B0 0x400e83F4 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B1_05_XBAR1_INOUT25                  0x400e81B0 0x400e83F4 0x400e86EC 0x2 1
#define IMXRT_PAD_GPIO_SD_B1_05_GPT4_CLK                       0x400e81B0 0x400e83F4 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B1_05_GPIO_MUX4_IO08                 0x400e81B0 0x400e83F4 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B1_05_FLEXSPI2_A_DATA03              0x400e81B0 0x400e83F4 0x400e8588 0x6 1
#define IMXRT_PAD_GPIO_SD_B1_05_FLEXSPI1_B_DQS                 0x400e81B0 0x400e83F4 0          0x8 0
#define IMXRT_PAD_GPIO_SD_B1_05_ENET_QOS_1588_EVENT3_AUX_IN    0x400e81B0 0x400e83F4 0          0x9 0

#define IMXRT_PAD_GPIO_SD_B2_00_GPIO10_IO09                    0x400e81B4 0x400e83F8 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_00_USDHC2_DATA3                   0x400e81B4 0x400e83F8 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_00_FLEXSPI1_B_DATA03              0x400e81B4 0x400e83F8 0x400e8570 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_00_ENET_1G_RX_EN                  0x400e81B4 0x400e83F8 0x400e84E0 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_00_LPUART9_TXD                    0x400e81B4 0x400e83F8 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_00_LPSPI4_SCK                     0x400e81B4 0x400e83F8 0x400e8610 0x4 0
#define IMXRT_PAD_GPIO_SD_B2_00_GPIO_MUX4_IO09                 0x400e81B4 0x400e83F8 0          0x5 0

#define IMXRT_PAD_GPIO_SD_B2_01_USDHC2_DATA2                   0x400e81B8 0x400e83FC 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_01_FLEXSPI1_B_DATA02              0x400e81B8 0x400e83FC 0x400e856C 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_01_ENET_1G_RX_CLK                 0x400e81B8 0x400e83FC 0x400e84CC 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_01_LPUART9_RXD                    0x400e81B8 0x400e83FC 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_01_LPSPI4_PCS0                    0x400e81B8 0x400e83FC 0x400e860C 0x4 0
#define IMXRT_PAD_GPIO_SD_B2_01_GPIO_MUX4_IO10                 0x400e81B8 0x400e83FC 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_01_GPIO10_IO10                    0x400e81B8 0x400e83FC 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B2_02_GPIO10_IO11                    0x400e81BC 0x400e8400 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_02_USDHC2_DATA1                   0x400e81BC 0x400e8400 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_02_FLEXSPI1_B_DATA01              0x400e81BC 0x400e8400 0x400e8568 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_02_ENET_1G_RX_DATA00              0x400e81BC 0x400e8400 0x400e84D0 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_02_LPUART9_CTS_B                  0x400e81BC 0x400e8400 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_02_LPSPI4_SOUT                    0x400e81BC 0x400e8400 0x400e8618 0x4 0
#define IMXRT_PAD_GPIO_SD_B2_02_GPIO_MUX4_IO11                 0x400e81BC 0x400e8400 0          0x5 0

#define IMXRT_PAD_GPIO_SD_B2_03_GPIO10_IO12                    0x400e81C0 0x400e8404 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_03_USDHC2_DATA0                   0x400e81C0 0x400e8404 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_03_FLEXSPI1_B_DATA00              0x400e81C0 0x400e8404 0x400e8564 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_03_ENET_1G_RX_DATA01              0x400e81C0 0x400e8404 0x400e84D4 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_03_LPUART9_RTS_B                  0x400e81C0 0x400e8404 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_03_LPSPI4_SIN                     0x400e81C0 0x400e8404 0x400e8614 0x4 0
#define IMXRT_PAD_GPIO_SD_B2_03_GPIO_MUX4_IO12                 0x400e81C0 0x400e8404 0          0x5 0

#define IMXRT_PAD_GPIO_SD_B2_04_USDHC2_CLK                     0x400e81C4 0x400e8408 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_04_FLEXSPI1_B_SCLK                0x400e81C4 0x400e8408 0x400e8578 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_04_ENET_1G_RX_DATA02              0x400e81C4 0x400e8408 0x400e84D8 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_04_FLEXSPI1_A_SS1_B               0x400e81C4 0x400e8408 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_04_LPSPI4_PCS1                    0x400e81C4 0x400e8408 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_04_GPIO_MUX4_IO13                 0x400e81C4 0x400e8408 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_04_GPIO10_IO13                    0x400e81C4 0x400e8408 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B2_05_GPIO10_IO14                    0x400e81C8 0x400e840C 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_05_USDHC2_CMD                     0x400e81C8 0x400e840C 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_05_FLEXSPI1_A_DQS                 0x400e81C8 0x400e840C 0x400e8550 0x1 2
#define IMXRT_PAD_GPIO_SD_B2_05_ENET_1G_RX_DATA03              0x400e81C8 0x400e840C 0x400e84DC 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_05_FLEXSPI1_B_SS0_B               0x400e81C8 0x400e840C 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_05_LPSPI4_PCS2                    0x400e81C8 0x400e840C 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_05_GPIO_MUX4_IO14                 0x400e81C8 0x400e840C 0          0x5 0

#define IMXRT_PAD_GPIO_SD_B2_06_GPIO10_IO15                    0x400e81CC 0x400e8410 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_06_USDHC2_RESET_B                 0x400e81CC 0x400e8410 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_06_FLEXSPI1_A_SS0_B               0x400e81CC 0x400e8410 0          0x1 0
#define IMXRT_PAD_GPIO_SD_B2_06_ENET_1G_TX_DATA03              0x400e81CC 0x400e8410 0          0x2 0
#define IMXRT_PAD_GPIO_SD_B2_06_LPSPI4_PCS3                    0x400e81CC 0x400e8410 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_06_GPT6_CAPTURE1                  0x400e81CC 0x400e8410 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_06_GPIO_MUX4_IO15                 0x400e81CC 0x400e8410 0          0x5 0

#define IMXRT_PAD_GPIO_SD_B2_07_USDHC2_STROBE                  0x400e81D0 0x400e8414 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_07_FLEXSPI1_A_SCLK                0x400e81D0 0x400e8414 0x400e8574 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_07_ENET_1G_TX_DATA02              0x400e81D0 0x400e8414 0          0x2 0
#define IMXRT_PAD_GPIO_SD_B2_07_LPUART3_CTS_B                  0x400e81D0 0x400e8414 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_07_GPT6_CAPTURE2                  0x400e81D0 0x400e8414 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_07_GPIO_MUX4_IO16                 0x400e81D0 0x400e8414 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_07_LPSPI2_SCK                     0x400e81D0 0x400e8414 0x400e85E4 0x6 1
#define IMXRT_PAD_GPIO_SD_B2_07_ENET_TX_ER                     0x400e81D0 0x400e8414 0          0x8 0
#define IMXRT_PAD_GPIO_SD_B2_07_ENET_QOS_REF_CLK               0x400e81D0 0x400e8414 0x400e84A0 0x9 1
#define IMXRT_PAD_GPIO_SD_B2_07_GPIO10_IO16                    0x400e81D0 0x400e8414 0          0xA 0

#define IMXRT_PAD_GPIO_SD_B2_08_GPIO10_IO17                    0x400e81D4 0x400e8418 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_08_USDHC2_DATA4                   0x400e81D4 0x400e8418 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_08_FLEXSPI1_A_DATA00              0x400e81D4 0x400e8418 0x400e8554 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_08_ENET_1G_TX_DATA01              0x400e81D4 0x400e8418 0          0x2 0
#define IMXRT_PAD_GPIO_SD_B2_08_LPUART3_RTS_B                  0x400e81D4 0x400e8418 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_08_GPT6_COMPARE1                  0x400e81D4 0x400e8418 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_08_GPIO_MUX4_IO17                 0x400e81D4 0x400e8418 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_08_LPSPI2_PCS0                    0x400e81D4 0x400e8418 0x400e85DC 0x6 1

#define IMXRT_PAD_GPIO_SD_B2_09_GPIO10_IO18                    0x400e81D8 0x400e841C 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_09_USDHC2_DATA5                   0x400e81D8 0x400e841C 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_09_FLEXSPI1_A_DATA01              0x400e81D8 0x400e841C 0x400e8558 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_09_ENET_1G_TX_DATA00              0x400e81D8 0x400e841C 0          0x2 0
#define IMXRT_PAD_GPIO_SD_B2_09_LPUART5_CTS_B                  0x400e81D8 0x400e841C 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_09_GPT6_COMPARE2                  0x400e81D8 0x400e841C 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_09_GPIO_MUX4_IO18                 0x400e81D8 0x400e841C 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_09_LPSPI2_SOUT                    0x400e81D8 0x400e841C 0x400e85EC 0x6 1

#define IMXRT_PAD_GPIO_SD_B2_10_GPIO10_IO19                    0x400e81DC 0x400e8420 0          0xA 0
#define IMXRT_PAD_GPIO_SD_B2_10_USDHC2_DATA6                   0x400e81DC 0x400e8420 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_10_FLEXSPI1_A_DATA02              0x400e81DC 0x400e8420 0x400e855C 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_10_ENET_1G_TX_EN                  0x400e81DC 0x400e8420 0          0x2 0
#define IMXRT_PAD_GPIO_SD_B2_10_LPUART5_RTS_B                  0x400e81DC 0x400e8420 0          0x3 0
#define IMXRT_PAD_GPIO_SD_B2_10_GPT6_COMPARE3                  0x400e81DC 0x400e8420 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_10_GPIO_MUX4_IO19                 0x400e81DC 0x400e8420 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_10_LPSPI2_SIN                     0x400e81DC 0x400e8420 0x400e85E8 0x6 1

#define IMXRT_PAD_GPIO_SD_B2_11_USDHC2_DATA7                   0x400e81E0 0x400e8424 0          0x0 0
#define IMXRT_PAD_GPIO_SD_B2_11_FLEXSPI1_A_DATA03              0x400e81E0 0x400e8424 0x400e8560 0x1 1
#define IMXRT_PAD_GPIO_SD_B2_11_ENET_1G_TX_CLK_IO              0x400e81E0 0x400e8424 0x400e84E8 0x2 1
#define IMXRT_PAD_GPIO_SD_B2_11_ENET_1G_REF_CLK                0x400e81E0 0x400e8424 0x400e84C4 0x3 1
#define IMXRT_PAD_GPIO_SD_B2_11_GPT6_CLK                       0x400e81E0 0x400e8424 0          0x4 0
#define IMXRT_PAD_GPIO_SD_B2_11_GPIO_MUX4_IO20                 0x400e81E0 0x400e8424 0          0x5 0
#define IMXRT_PAD_GPIO_SD_B2_11_LPSPI2_PCS1                    0x400e81E0 0x400e8424 0x400e85E0 0x6 1
#define IMXRT_PAD_GPIO_SD_B2_11_GPIO10_IO20                    0x400e81E0 0x400e8424 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_00_VIDEO_MUX_LCDIF_CLK          0x400e81E4 0x400e8428 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_00_ENET_1G_RX_EN                0x400e81E4 0x400e8428 0x400e84E0 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_00_TMR1_TIMER0                  0x400e81E4 0x400e8428 0x400e863C 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_00_XBAR1_INOUT26                0x400e81E4 0x400e8428 0x400e86F0 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_00_GPIO_MUX4_IO21               0x400e81E4 0x400e8428 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_00_ENET_QOS_RX_EN               0x400e81E4 0x400e8428 0x400e84F8 0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_00_GPIO10_IO21                  0x400e81E4 0x400e8428 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_01_VIDEO_MUX_LCDIF_ENABLE       0x400e81E8 0x400e842C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_01_ENET_1G_RX_CLK               0x400e81E8 0x400e842C 0x400e84CC 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_01_ENET_1G_RX_ER                0x400e81E8 0x400e842C 0x400e84E4 0x2 1
#define IMXRT_PAD_GPIO_DISP_B1_01_TMR1_TIMER1                  0x400e81E8 0x400e842C 0x400e8640 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_01_XBAR1_INOUT27                0x400e81E8 0x400e842C 0x400e86F4 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_01_GPIO_MUX4_IO22               0x400e81E8 0x400e842C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_01_ENET_QOS_RX_CLK              0x400e81E8 0x400e842C 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_01_ENET_QOS_RX_ER               0x400e81E8 0x400e842C 0x400e84FC 0x9 0
#define IMXRT_PAD_GPIO_DISP_B1_01_GPIO10_IO22                  0x400e81E8 0x400e842C 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_02_GPIO10_IO23                  0x400e81EC 0x400e8430 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B1_02_VIDEO_MUX_LCDIF_HSYNC        0x400e81EC 0x400e8430 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_02_ENET_1G_RX_DATA00            0x400e81EC 0x400e8430 0x400e84D0 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_02_LPI2C3_SCL                   0x400e81EC 0x400e8430 0x400e85BC 0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_02_TMR1_TIMER2                  0x400e81EC 0x400e8430 0x400e8644 0x3 1
#define IMXRT_PAD_GPIO_DISP_B1_02_XBAR1_INOUT28                0x400e81EC 0x400e8430 0x400e86F8 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_02_GPIO_MUX4_IO23               0x400e81EC 0x400e8430 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_02_ENET_QOS_RX_DATA00           0x400e81EC 0x400e8430 0x400e84F0 0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_02_LPUART1_TXD                  0x400e81EC 0x400e8430 0x400e8620 0x9 1

#define IMXRT_PAD_GPIO_DISP_B1_03_VIDEO_MUX_LCDIF_VSYNC        0x400e81F0 0x400e8434 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_03_ENET_1G_RX_DATA01            0x400e81F0 0x400e8434 0x400e84D4 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_03_LPI2C3_SDA                   0x400e81F0 0x400e8434 0x400e85C0 0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_03_TMR2_TIMER0                  0x400e81F0 0x400e8434 0x400e8648 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_03_XBAR1_INOUT29                0x400e81F0 0x400e8434 0x400e86FC 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_03_GPIO_MUX4_IO24               0x400e81F0 0x400e8434 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_03_ENET_QOS_RX_DATA01           0x400e81F0 0x400e8434 0x400e84F4 0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_03_LPUART1_RXD                  0x400e81F0 0x400e8434 0x400e861C 0x9 1
#define IMXRT_PAD_GPIO_DISP_B1_03_GPIO10_IO24                  0x400e81F0 0x400e8434 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_04_VIDEO_MUX_LCDIF_DATA00       0x400e81F4 0x400e8438 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_04_ENET_1G_RX_DATA02            0x400e81F4 0x400e8438 0x400e84D8 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_04_LPUART4_RXD                  0x400e81F4 0x400e8438 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_04_TMR2_TIMER1                  0x400e81F4 0x400e8438 0x400e864C 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_04_XBAR1_INOUT30                0x400e81F4 0x400e8438 0x400e8700 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_04_GPIO_MUX4_IO25               0x400e81F4 0x400e8438 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_04_ENET_QOS_RX_DATA02           0x400e81F4 0x400e8438 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_04_LPSPI3_SCK                   0x400e81F4 0x400e8438 0x400e8600 0x9 1
#define IMXRT_PAD_GPIO_DISP_B1_04_GPIO10_IO25                  0x400e81F4 0x400e8438 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_05_GPIO10_IO26                  0x400e81F8 0x400e843C 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B1_05_VIDEO_MUX_LCDIF_DATA01       0x400e81F8 0x400e843C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_05_ENET_1G_RX_DATA03            0x400e81F8 0x400e843C 0x400e84DC 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_05_LPUART4_CTS_B                0x400e81F8 0x400e843C 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_05_TMR2_TIMER2                  0x400e81F8 0x400e843C 0x400e8650 0x3 1
#define IMXRT_PAD_GPIO_DISP_B1_05_XBAR1_INOUT31                0x400e81F8 0x400e843C 0x400e8704 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_05_GPIO_MUX4_IO26               0x400e81F8 0x400e843C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_05_ENET_QOS_RX_DATA03           0x400e81F8 0x400e843C 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_05_LPSPI3_SIN                   0x400e81F8 0x400e843C 0x400e8604 0x9 1

#define IMXRT_PAD_GPIO_DISP_B1_06_VIDEO_MUX_LCDIF_DATA02       0x400e81FC 0x400e8440 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_06_ENET_1G_TX_DATA03            0x400e81FC 0x400e8440 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B1_06_LPUART4_TXD                  0x400e81FC 0x400e8440 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_06_TMR3_TIMER0                  0x400e81FC 0x400e8440 0x400e8654 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_06_XBAR1_INOUT32                0x400e81FC 0x400e8440 0x400e8708 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_06_GPIO_MUX4_IO27               0x400e81FC 0x400e8440 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_06_SRC_BT_CFG00                 0x400e81FC 0x400e8440 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B1_06_ENET_QOS_TX_DATA03           0x400e81FC 0x400e8440 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_06_LPSPI3_SOUT                  0x400e81FC 0x400e8440 0x400e8608 0x9 1
#define IMXRT_PAD_GPIO_DISP_B1_06_GPIO10_IO27                  0x400e81FC 0x400e8440 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_07_VIDEO_MUX_LCDIF_DATA03       0x400e8200 0x400e8444 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_07_ENET_1G_TX_DATA02            0x400e8200 0x400e8444 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B1_07_LPUART4_RTS_B                0x400e8200 0x400e8444 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_07_TMR3_TIMER1                  0x400e8200 0x400e8444 0x400e8658 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_07_XBAR1_INOUT33                0x400e8200 0x400e8444 0x400e870C 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_07_GPIO_MUX4_IO28               0x400e8200 0x400e8444 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_07_SRC_BT_CFG01                 0x400e8200 0x400e8444 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B1_07_ENET_QOS_TX_DATA02           0x400e8200 0x400e8444 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_07_LPSPI3_PCS0                  0x400e8200 0x400e8444 0x400e85F0 0x9 1
#define IMXRT_PAD_GPIO_DISP_B1_07_GPIO10_IO28                  0x400e8200 0x400e8444 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_08_GPIO10_IO29                  0x400e8204 0x400e8448 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B1_08_VIDEO_MUX_LCDIF_DATA04       0x400e8204 0x400e8448 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_08_ENET_1G_TX_DATA01            0x400e8204 0x400e8448 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B1_08_USDHC1_CD_B                  0x400e8204 0x400e8448 0x400e86C8 0x2 1
#define IMXRT_PAD_GPIO_DISP_B1_08_TMR3_TIMER2                  0x400e8204 0x400e8448 0x400e865C 0x3 1
#define IMXRT_PAD_GPIO_DISP_B1_08_XBAR1_INOUT34                0x400e8204 0x400e8448 0x400e8710 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_08_GPIO_MUX4_IO29               0x400e8204 0x400e8448 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_08_SRC_BT_CFG02                 0x400e8204 0x400e8448 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B1_08_ENET_QOS_TX_DATA01           0x400e8204 0x400e8448 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_08_LPSPI3_PCS1                  0x400e8204 0x400e8448 0x400e85F4 0x9 1

#define IMXRT_PAD_GPIO_DISP_B1_09_VIDEO_MUX_LCDIF_DATA05       0x400e8208 0x400e844C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_09_ENET_1G_TX_DATA00            0x400e8208 0x400e844C 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B1_09_USDHC1_WP                    0x400e8208 0x400e844C 0x400e86CC 0x2 1
#define IMXRT_PAD_GPIO_DISP_B1_09_TMR4_TIMER0                  0x400e8208 0x400e844C 0x400e8660 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_09_XBAR1_INOUT35                0x400e8208 0x400e844C 0x400e8714 0x4 1
#define IMXRT_PAD_GPIO_DISP_B1_09_GPIO_MUX4_IO30               0x400e8208 0x400e844C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_09_SRC_BT_CFG03                 0x400e8208 0x400e844C 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B1_09_ENET_QOS_TX_DATA00           0x400e8208 0x400e844C 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_09_LPSPI3_PCS2                  0x400e8208 0x400e844C 0x400e85F8 0x9 1
#define IMXRT_PAD_GPIO_DISP_B1_09_GPIO10_IO30                  0x400e8208 0x400e844C 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_10_VIDEO_MUX_LCDIF_DATA06       0x400e820C 0x400e8450 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_10_ENET_1G_TX_EN                0x400e820C 0x400e8450 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B1_10_USDHC1_RESET_B               0x400e820C 0x400e8450 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B1_10_TMR4_TIMER1                  0x400e820C 0x400e8450 0x400e8664 0x3 2
#define IMXRT_PAD_GPIO_DISP_B1_10_XBAR1_INOUT36                0x400e820C 0x400e8450 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B1_10_GPIO_MUX4_IO31               0x400e820C 0x400e8450 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_10_SRC_BT_CFG04                 0x400e820C 0x400e8450 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B1_10_ENET_QOS_TX_EN               0x400e820C 0x400e8450 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_10_LPSPI3_PCS3                  0x400e820C 0x400e8450 0x400e85FC 0x9 1
#define IMXRT_PAD_GPIO_DISP_B1_10_GPIO10_IO31                  0x400e820C 0x400e8450 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B1_11_VIDEO_MUX_LCDIF_DATA07       0x400e8210 0x400e8454 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B1_11_ENET_1G_TX_CLK_IO            0x400e8210 0x400e8454 0x400e84E8 0x1 2
#define IMXRT_PAD_GPIO_DISP_B1_11_ENET_1G_REF_CLK              0x400e8210 0x400e8454 0x400e84C4 0x2 2
#define IMXRT_PAD_GPIO_DISP_B1_11_TMR4_TIMER2                  0x400e8210 0x400e8454 0x400e8668 0x3 1
#define IMXRT_PAD_GPIO_DISP_B1_11_XBAR1_INOUT37                0x400e8210 0x400e8454 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B1_11_GPIO_MUX5_IO00               0x400e8210 0x400e8454 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B1_11_SRC_BT_CFG05                 0x400e8210 0x400e8454 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B1_11_ENET_QOS_TX_CLK              0x400e8210 0x400e8454 0x400e84A4 0x8 0
#define IMXRT_PAD_GPIO_DISP_B1_11_ENET_QOS_REF_CLK             0x400e8210 0x400e8454 0x400e84A0 0x9 2
#define IMXRT_PAD_GPIO_DISP_B1_11_GPIO11_IO00                  0x400e8210 0x400e8454 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B2_00_GPIO11_IO01                  0x400e8214 0x400e8458 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_00_VIDEO_MUX_LCDIF_DATA08       0x400e8214 0x400e8458 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_00_WDOG1_B                      0x400e8214 0x400e8458 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_00_MQS_RIGHT                    0x400e8214 0x400e8458 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_00_ENET_1G_TX_ER                0x400e8214 0x400e8458 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_00_SAI1_TX_DATA03               0x400e8214 0x400e8458 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_00_GPIO_MUX5_IO01               0x400e8214 0x400e8458 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_00_SRC_BT_CFG06                 0x400e8214 0x400e8458 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_00_ENET_QOS_TX_ER               0x400e8214 0x400e8458 0          0x8 0

#define IMXRT_PAD_GPIO_DISP_B2_01_VIDEO_MUX_LCDIF_DATA09       0x400e8218 0x400e845C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_01_USDHC1_VSELECT               0x400e8218 0x400e845C 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_01_MQS_LEFT                     0x400e8218 0x400e845C 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_01_WDOG2_B                      0x400e8218 0x400e845C 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_01_SAI1_TX_DATA02               0x400e8218 0x400e845C 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_01_GPIO_MUX5_IO02               0x400e8218 0x400e845C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_01_SRC_BT_CFG07                 0x400e8218 0x400e845C 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_01_EWM_OUT_B                    0x400e8218 0x400e845C 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_01_CCM_ENET_REF_CLK_25M         0x400e8218 0x400e845C 0          0x9 0
#define IMXRT_PAD_GPIO_DISP_B2_01_GPIO11_IO02                  0x400e8218 0x400e845C 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B2_02_GPIO11_IO03                  0x400e821C 0x400e8460 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_02_VIDEO_MUX_LCDIF_DATA10       0x400e821C 0x400e8460 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_02_ENET_TX_DATA00               0x400e821C 0x400e8460 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_02_PIT1_TRIGGER3                0x400e821C 0x400e8460 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_02_ARM_TRACE00                  0x400e821C 0x400e8460 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_02_SAI1_TX_DATA01               0x400e821C 0x400e8460 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_02_GPIO_MUX5_IO03               0x400e821C 0x400e8460 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_02_SRC_BT_CFG08                 0x400e821C 0x400e8460 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_02_ENET_QOS_TX_DATA00           0x400e821C 0x400e8460 0          0x8 0

#define IMXRT_PAD_GPIO_DISP_B2_03_GPIO11_IO04                  0x400e8220 0x400e8464 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_03_VIDEO_MUX_LCDIF_DATA11       0x400e8220 0x400e8464 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_03_ENET_TX_DATA01               0x400e8220 0x400e8464 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_03_PIT1_TRIGGER2                0x400e8220 0x400e8464 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_03_ARM_TRACE01                  0x400e8220 0x400e8464 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_03_SAI1_MCLK                    0x400e8220 0x400e8464 0x400e866C 0x4 1
#define IMXRT_PAD_GPIO_DISP_B2_03_GPIO_MUX5_IO04               0x400e8220 0x400e8464 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_03_SRC_BT_CFG09                 0x400e8220 0x400e8464 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_03_ENET_QOS_TX_DATA01           0x400e8220 0x400e8464 0          0x8 0

#define IMXRT_PAD_GPIO_DISP_B2_04_VIDEO_MUX_LCDIF_DATA12       0x400e8224 0x400e8468 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_04_ENET_TX_EN                   0x400e8224 0x400e8468 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_04_PIT1_TRIGGER1                0x400e8224 0x400e8468 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_04_ARM_TRACE02                  0x400e8224 0x400e8468 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_04_SAI1_RX_SYNC                 0x400e8224 0x400e8468 0x400e8678 0x4 1
#define IMXRT_PAD_GPIO_DISP_B2_04_GPIO_MUX5_IO05               0x400e8224 0x400e8468 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_04_SRC_BT_CFG10                 0x400e8224 0x400e8468 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_04_ENET_QOS_TX_EN               0x400e8224 0x400e8468 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_04_GPIO11_IO05                  0x400e8224 0x400e8468 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B2_05_GPIO11_IO06                  0x400e8228 0x400e846C 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_05_VIDEO_MUX_LCDIF_DATA13       0x400e8228 0x400e846C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_05_ENET_TX_CLK                  0x400e8228 0x400e846C 0x400e84C0 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_05_ENET_REF_CLK                 0x400e8228 0x400e846C 0x400e84A8 0x2 1
#define IMXRT_PAD_GPIO_DISP_B2_05_ARM_TRACE03                  0x400e8228 0x400e846C 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_05_SAI1_RX_BCLK                 0x400e8228 0x400e846C 0x400e8670 0x4 1
#define IMXRT_PAD_GPIO_DISP_B2_05_GPIO_MUX5_IO06               0x400e8228 0x400e846C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_05_SRC_BT_CFG11                 0x400e8228 0x400e846C 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_05_ENET_QOS_TX_CLK              0x400e8228 0x400e846C 0x400e84A4 0x8 1

#define IMXRT_PAD_GPIO_DISP_B2_06_GPIO11_IO07                  0x400e822C 0x400e8470 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_06_VIDEO_MUX_LCDIF_DATA14       0x400e822C 0x400e8470 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_06_ENET_RX_DATA00               0x400e822C 0x400e8470 0x400e84B0 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_06_LPUART7_TXD                  0x400e822C 0x400e8470 0x400e8630 0x2 1
#define IMXRT_PAD_GPIO_DISP_B2_06_ARM_TRACE_CLK                0x400e822C 0x400e8470 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_06_SAI1_RX_DATA00               0x400e822C 0x400e8470 0x400e8674 0x4 1
#define IMXRT_PAD_GPIO_DISP_B2_06_GPIO_MUX5_IO07               0x400e822C 0x400e8470 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_06_ENET_QOS_RX_DATA00           0x400e822C 0x400e8470 0x400e84F0 0x8 1

#define IMXRT_PAD_GPIO_DISP_B2_07_VIDEO_MUX_LCDIF_DATA15       0x400e8230 0x400e8474 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_07_ENET_RX_DATA01               0x400e8230 0x400e8474 0x400e84B4 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_07_LPUART7_RXD                  0x400e8230 0x400e8474 0x400e862C 0x2 1
#define IMXRT_PAD_GPIO_DISP_B2_07_ARM_TRACE_SWO                0x400e8230 0x400e8474 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_07_SAI1_TX_DATA00               0x400e8230 0x400e8474 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_07_GPIO_MUX5_IO08               0x400e8230 0x400e8474 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_07_ENET_QOS_RX_DATA01           0x400e8230 0x400e8474 0x400e84F4 0x8 1
#define IMXRT_PAD_GPIO_DISP_B2_07_GPIO11_IO08                  0x400e8230 0x400e8474 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B2_08_GPIO11_IO09                  0x400e8234 0x400e8478 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_08_VIDEO_MUX_LCDIF_DATA16       0x400e8234 0x400e8478 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_08_ENET_RX_EN                   0x400e8234 0x400e8478 0x400e84B8 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_08_LPUART8_TXD                  0x400e8234 0x400e8478 0x400e8638 0x2 1
#define IMXRT_PAD_GPIO_DISP_B2_08_ARM_CM7_EVENTO               0x400e8234 0x400e8478 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_08_SAI1_TX_BCLK                 0x400e8234 0x400e8478 0x400e867C 0x4 1
#define IMXRT_PAD_GPIO_DISP_B2_08_GPIO_MUX5_IO09               0x400e8234 0x400e8478 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_08_ENET_QOS_RX_EN               0x400e8234 0x400e8478 0x400e84F8 0x8 1
#define IMXRT_PAD_GPIO_DISP_B2_08_LPUART1_TXD                  0x400e8234 0x400e8478 0x400e8620 0x9 2

#define IMXRT_PAD_GPIO_DISP_B2_09_GPIO11_IO10                  0x400e8238 0x400e847C 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_09_VIDEO_MUX_LCDIF_DATA17       0x400e8238 0x400e847C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_09_ENET_RX_ER                   0x400e8238 0x400e847C 0x400e84BC 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_09_LPUART8_RXD                  0x400e8238 0x400e847C 0x400e8634 0x2 1
#define IMXRT_PAD_GPIO_DISP_B2_09_ARM_CM7_EVENTI               0x400e8238 0x400e847C 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_09_SAI1_TX_SYNC                 0x400e8238 0x400e847C 0x400e8680 0x4 1
#define IMXRT_PAD_GPIO_DISP_B2_09_GPIO_MUX5_IO10               0x400e8238 0x400e847C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_09_ENET_QOS_RX_ER               0x400e8238 0x400e847C 0x400e84FC 0x8 1
#define IMXRT_PAD_GPIO_DISP_B2_09_LPUART1_RXD                  0x400e8238 0x400e847C 0x400e861C 0x9 2

#define IMXRT_PAD_GPIO_DISP_B2_10_GPIO11_IO11                  0x400e823C 0x400e8480 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_10_VIDEO_MUX_LCDIF_DATA18       0x400e823C 0x400e8480 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_10_EMVSIM2_IO                   0x400e823C 0x400e8480 0x400e86A8 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_10_LPUART2_TXD                  0x400e823C 0x400e8480 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_10_WDOG2_RESET_B_DEB            0x400e823C 0x400e8480 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_10_XBAR1_INOUT38                0x400e823C 0x400e8480 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_10_GPIO_MUX5_IO11               0x400e823C 0x400e8480 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_10_LPI2C3_SCL                   0x400e823C 0x400e8480 0x400e85BC 0x6 1
#define IMXRT_PAD_GPIO_DISP_B2_10_ENET_QOS_RX_ER               0x400e823C 0x400e8480 0x400e84FC 0x8 2
#define IMXRT_PAD_GPIO_DISP_B2_10_SPDIF_IN                     0x400e823C 0x400e8480 0x400e86B4 0x9 2

#define IMXRT_PAD_GPIO_DISP_B2_11_VIDEO_MUX_LCDIF_DATA19       0x400e8240 0x400e8484 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_11_EMVSIM2_CLK                  0x400e8240 0x400e8484 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_11_LPUART2_RXD                  0x400e8240 0x400e8484 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_11_WDOG1_RESET_B_DEB            0x400e8240 0x400e8484 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_11_XBAR1_INOUT39                0x400e8240 0x400e8484 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_11_GPIO_MUX5_IO12               0x400e8240 0x400e8484 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_11_LPI2C3_SDA                   0x400e8240 0x400e8484 0x400e85C0 0x6 1
#define IMXRT_PAD_GPIO_DISP_B2_11_ENET_QOS_CRS                 0x400e8240 0x400e8484 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_11_SPDIF_OUT                    0x400e8240 0x400e8484 0          0x9 0
#define IMXRT_PAD_GPIO_DISP_B2_11_GPIO11_IO12                  0x400e8240 0x400e8484 0          0xA 0

#define IMXRT_PAD_GPIO_DISP_B2_12_GPIO11_IO13                  0x400e8244 0x400e8488 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_12_VIDEO_MUX_LCDIF_DATA20       0x400e8244 0x400e8488 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_12_EMVSIM2_RST                  0x400e8244 0x400e8488 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_12_FLEXCAN1_TX                  0x400e8244 0x400e8488 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_12_LPUART2_CTS_B                0x400e8244 0x400e8488 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_12_XBAR1_INOUT40                0x400e8244 0x400e8488 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_12_GPIO_MUX5_IO13               0x400e8244 0x400e8488 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_12_LPI2C4_SCL                   0x400e8244 0x400e8488 0x400e85C4 0x6 1
#define IMXRT_PAD_GPIO_DISP_B2_12_ENET_QOS_COL                 0x400e8244 0x400e8488 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_12_LPSPI4_SCK                   0x400e8244 0x400e8488 0x400e8610 0x9 1

#define IMXRT_PAD_GPIO_DISP_B2_13_GPIO11_IO14                  0x400e8248 0x400e848C 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_13_VIDEO_MUX_LCDIF_DATA21       0x400e8248 0x400e848C 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_13_EMVSIM2_SVEN                 0x400e8248 0x400e848C 0          0x1 0
#define IMXRT_PAD_GPIO_DISP_B2_13_FLEXCAN1_RX                  0x400e8248 0x400e848C 0x400e8498 0x2 1
#define IMXRT_PAD_GPIO_DISP_B2_13_LPUART2_RTS_B                0x400e8248 0x400e848C 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_13_ENET_REF_CLK                 0x400e8248 0x400e848C 0x400e84A8 0x4 2
#define IMXRT_PAD_GPIO_DISP_B2_13_GPIO_MUX5_IO14               0x400e8248 0x400e848C 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_13_LPI2C4_SDA                   0x400e8248 0x400e848C 0x400e85C8 0x6 1
#define IMXRT_PAD_GPIO_DISP_B2_13_ENET_QOS_1588_EVENT0_OUT     0x400e8248 0x400e848C 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_13_LPSPI4_SIN                   0x400e8248 0x400e848C 0x400e8614 0x9 1

#define IMXRT_PAD_GPIO_DISP_B2_14_GPIO_MUX5_IO15               0x400e824C 0x400e8490 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_14_FLEXCAN1_TX                  0x400e824C 0x400e8490 0          0x6 0
#define IMXRT_PAD_GPIO_DISP_B2_14_ENET_QOS_1588_EVENT0_IN      0x400e824C 0x400e8490 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_14_LPSPI4_SOUT                  0x400e824C 0x400e8490 0x400e8618 0x9 1
#define IMXRT_PAD_GPIO_DISP_B2_14_GPIO11_IO15                  0x400e824C 0x400e8490 0          0xA 0
#define IMXRT_PAD_GPIO_DISP_B2_14_VIDEO_MUX_LCDIF_DATA22       0x400e824C 0x400e8490 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_14_EMVSIM2_PD                   0x400e824C 0x400e8490 0x400e86AC 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_14_WDOG2_B                      0x400e824C 0x400e8490 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_14_VIDEO_MUX_EXT_DCIC1          0x400e824C 0x400e8490 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_14_ENET_1G_REF_CLK              0x400e824C 0x400e8490 0x400e84C4 0x4 3

#define IMXRT_PAD_GPIO_DISP_B2_15_VIDEO_MUX_LCDIF_DATA23       0x400e8250 0x400e8494 0          0x0 0
#define IMXRT_PAD_GPIO_DISP_B2_15_EMVSIM2_POWER_FAIL           0x400e8250 0x400e8494 0x400e86B0 0x1 1
#define IMXRT_PAD_GPIO_DISP_B2_15_WDOG1_B                      0x400e8250 0x400e8494 0          0x2 0
#define IMXRT_PAD_GPIO_DISP_B2_15_VIDEO_MUX_EXT_DCIC2          0x400e8250 0x400e8494 0          0x3 0
#define IMXRT_PAD_GPIO_DISP_B2_15_PIT1_TRIGGER0                0x400e8250 0x400e8494 0          0x4 0
#define IMXRT_PAD_GPIO_DISP_B2_15_GPIO_MUX5_IO16               0x400e8250 0x400e8494 0          0x5 0
#define IMXRT_PAD_GPIO_DISP_B2_15_FLEXCAN1_RX                  0x400e8250 0x400e8494 0x400e8498 0x6 2
#define IMXRT_PAD_GPIO_DISP_B2_15_ENET_QOS_1588_EVENT0_AUX_IN  0x400e8250 0x400e8494 0          0x8 0
#define IMXRT_PAD_GPIO_DISP_B2_15_LPSPI4_PCS0                  0x400e8250 0x400e8494 0x400e860C 0x9 1
#define IMXRT_PAD_GPIO_DISP_B2_15_GPIO11_IO16                  0x400e8250 0x400e8494 0          0xA 0

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* LIBBSP_ARM_IMXRT_IMXRT1050_PINFUNC_H */
