Real-Time Executive for Multiprocessing Systems
===============================================

RTEMS is a real-time executive (kernel) which provides a high performance 
environment for embedded applications with the following features:

 * Standards based user interfaces.
 * Multitasking capabilities.
 * Homogeneous and heterogeneous multiprocessor systems.
 * Symmetric Multiprocessing (SMP):
   * Cluster scheduling: Job-level fixed prority scheduler (EDF)
     with support for one-to-one and one-to-all thread to processor
     affinities.
   * Locking protocols with transitive priority inheritance, priority
     ceiling, MRsP and OMIP.
 * Event-driven, priority-based, preemptive scheduling.
 * Scalable timer and timeout support.
 * Optional rate monotonic scheduling.
 * Intertask communication and synchronisation.
 * Priority inheritance.
 * Responsive interrupt management.
 * Dynamic memory allocation.
 * Dynamic code loading using run-time link editing.
 * File systems, IMFS, FAT, RFS, JFFS, NSFv4 (with LibBSD)
 * High level of user configurability.
 * Link-time configurable schedulers.
 * Linker-set based initialization (similar to global C++ constructors).
 * Drivers for I2C, SPI and LibBSD has NIC, USB, SD/MMC and Framebuffer.
 * Open source with a friendly user license.
 
RTEMS Project:

  * https://www.rtems.org/


Project git repositories are located at:

  * https://gitlab.rtems.org/rtems/


Online documentation is available at:

  * https://docs.rtems.org/


RTEMS Doxygen for CPUKit:

  * https://docs.rtems.org/doxygen/main/


RTEMS POSIX 1003.1 Compliance Guide:

  * https://docs.rtems.org/branches/master/posix-compliance/


RTEMS Discourse User forum for questions, answers and examples:

  * https://users.rtems.org/


RTEMS Discord for support:

  *  https://www.rtems.org/discord/


RTEMS Mailing Lists for general purpose use the users list and for developers 
use the devel list.

* https://lists.rtems.org/mailman/listinfo


The version number for this software in releases is located in the `VERSION` file if present.
