/*
 * QEMU model of the EFUSE eFuse
 *
 * Copyright (c) 2015 Xilinx Inc.
 *
 * Written by Edgar E. Iglesias <edgari@xilinx.com>
 * Partially autogenerated by xregqemu.py 2015-01-02.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef XLNX_EFUSE__H
#define XLNX_EFUSE__H

#include "qom/object.h"

#define TYPE_XLNX_EFUSE "xlnx.efuse"
#include "hw/ptimer.h"
#include "sysemu/block-backend.h"
#include "hw/zynqmp_aes_key.h"

#define XLNX_EFUSE(obj) \
     OBJECT_CHECK(XLNXEFuse, (obj), TYPE_XLNX_EFUSE)

#define TYPE_XLNX_EFUSE_SYSMON_DATA_SOURCE \
    "xlnx,efuse-sysmon-data-source-interface"
typedef struct XlnxEFuseSysmonDataSourceClass XlnxEFuseSysmonDataSourceClass;
DECLARE_CLASS_CHECKERS(XlnxEFuseSysmonDataSourceClass,
                       XLNX_EFUSE_SYSMON_DATA_SOURCE,
                       TYPE_XLNX_EFUSE_SYSMON_DATA_SOURCE)

typedef struct XlnxEFusePufData {
    uint32_t puf_dis:1;
    uint16_t pufsyn_len;
    uint8_t  pufsyn[0];
} XlnxEFusePufData;

typedef struct XlnxEFuseSysmonData {
    uint32_t rdata_low;
    uint32_t rdata_high;
    uint32_t glitch_monitor_en:1;
} XlnxEFuseSysmonData;

struct XlnxEFuseSysmonDataSourceClass {
    /*< private >*/
    InterfaceClass parent_class;
    /*< public >*/

    /**
     * get_data:
     * @obj: the object implementing this interface
     * @data: pointer to receive sysmon data
     */
    void (*get_data)(Object *obj, XlnxEFuseSysmonData *data);
};

#define FBIT_UNKNOWN (~0)

typedef struct XLNXEFuse {
    DeviceState parent_obj;
    BlockBackend *blk;
    bool blk_ro;
    uint32_t *fuse32;

    XlnxEFusePufData *(*get_puf)(DeviceState *, uint16_t pufsyn_max);
    bool (*get_sysmon)(DeviceState *, XlnxEFuseSysmonData *);
    uint32_t (*get_u32)(DeviceState *, uint32_t, bool *);
    void (*pgm_done)(DeviceState *dev, bool failed);
    DeviceState *dev;

    ptimer_state *timer_ps;
    ptimer_state *timer_pgm;

    bool init_tbits;
    bool programming;
    uint32_t efuse_idx;

    uint8_t efuse_nr;
    uint32_t efuse_size;

    uint32_t *ro_bits;
    uint32_t ro_bits_cnt;
} XLNXEFuse;

bool efuse_is_pgm(XLNXEFuse *s);
void efuse_sync_u32(XLNXEFuse *s, uint32_t *u32,
                           unsigned int f_start, unsigned int f_end,
                           unsigned int f_written);
void efuse_pgm_start(XLNXEFuse *s, int tpgm, uint64_t val);
void efuse_stop_timer_ps(XLNXEFuse *s);
void efuse_set_timer_ps(XLNXEFuse *s, int tsu_h_ps);
void efuse_pgm_complete(XLNXEFuse *s);
bool efuse_get_bit(XLNXEFuse *s, unsigned int bit);
bool efuse_set_bit(XLNXEFuse *s, unsigned int bit);
bool efuse_k256_check(XLNXEFuse *s, uint32_t crc, unsigned start);
void efuse_k256_sync(XLNXEFuse *s, ZynqMPAESKeySink *sink, unsigned start);
uint32_t efuse_tbits_check(XLNXEFuse *s);

/* Return whole row containing the given bit address */
static inline uint32_t efuse_get_row(XLNXEFuse *s, unsigned int bit)
{
    if (!(s->fuse32)) {
        return 0;
    } else {
        unsigned int row_idx = bit / 32;

        assert(row_idx < (s->efuse_size * s->efuse_nr / 32));
        return s->fuse32[row_idx];
    }
}

/* Return whole row containing bit(s) in the given 'abstract' address */
static inline uint32_t xlnx_efuse_get_u32(XLNXEFuse *s,
                                          uint32_t addr, bool *denied)
{
    if (s && s->fuse32 && s->dev && s->get_u32) {
        return s->get_u32(s->dev, addr, denied);
    }

    if (denied) {
        *denied = true;
    }
    return 0;
}

static inline XlnxEFusePufData *xlnx_efuse_get_puf(XLNXEFuse *s,
                                                   uint16_t pufsyn_max)
{
    if (s && s->fuse32 && s->dev && s->get_puf) {
        return s->get_puf(s->dev, pufsyn_max);
    } else {
        return NULL;
    }
}

static inline bool xlnx_efuse_get_sysmon(XLNXEFuse *s,
                                         XlnxEFuseSysmonData *d)
{
    if (s && s->fuse32 && s->dev && s->get_sysmon && d) {
        return s->get_sysmon(s->dev, d);
    } else {
        return false;
    }
}

#endif
