/*
 * QEMU model of the VDU_NPI Video decoder unit npi
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2022-05-16.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_VDU_NPI_ERR_DEBUG
#define XILINX_VDU_NPI_ERR_DEBUG 0
#endif

#define TYPE_XILINX_VDU_NPI "xlnx.vdu_npi"

#define XILINX_VDU_NPI(obj) \
     OBJECT_CHECK(VDU_NPI, (obj), TYPE_XILINX_VDU_NPI)

REG32(VDU_NPI_PCSR_MASK, 0x0)
    FIELD(VDU_NPI_PCSR_MASK, VDU_IPOR, 26, 1)
    FIELD(VDU_NPI_PCSR_MASK, BISR_TRIGGER, 25, 1)
    FIELD(VDU_NPI_PCSR_MASK, BISR_TEST_CLR, 24, 1)
    FIELD(VDU_NPI_PCSR_MASK, ISO_1_VDU_RAM, 23, 1)
    FIELD(VDU_NPI_PCSR_MASK, ISO_2_VDU_PL, 22, 1)
    FIELD(VDU_NPI_PCSR_MASK, ISO_1_VDU_PL, 21, 1)
    FIELD(VDU_NPI_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(VDU_NPI_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(VDU_NPI_PCSR_MASK, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(VDU_NPI_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(VDU_NPI_PCSR_MASK, PWRDN, 14, 1)
    FIELD(VDU_NPI_PCSR_MASK, DISNPICLK, 13, 1)
    FIELD(VDU_NPI_PCSR_MASK, APBEN, 12, 1)
    FIELD(VDU_NPI_PCSR_MASK, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(VDU_NPI_PCSR_MASK, STARTCAL, 10, 1)
    FIELD(VDU_NPI_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(VDU_NPI_PCSR_MASK, TRISTATE, 8, 1)
    FIELD(VDU_NPI_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(VDU_NPI_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(VDU_NPI_PCSR_MASK, ODISABLE, 2, 4)
    FIELD(VDU_NPI_PCSR_MASK, GATEREG, 1, 1)
    FIELD(VDU_NPI_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(VDU_NPI_PCSR_CONTROL, 0x4)
    FIELD(VDU_NPI_PCSR_CONTROL, VDU_IPOR, 26, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, BISR_TRIGGER, 25, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, BISR_TEST_CLR, 24, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, ISO_1_VDU_RAM, 23, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, ISO_2_VDU_PL, 22, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, ISO_1_VDU_PL, 21, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(VDU_NPI_PCSR_CONTROL, PWRDN, 14, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, DISNPICLK, 13, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, APBEN, 12, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, STARTCAL, 10, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, TRISTATE, 8, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, ODISABLE, 2, 4)
    FIELD(VDU_NPI_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(VDU_NPI_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(VDU_NPI_PCSR_STATUS, 0x8)
    FIELD(VDU_NPI_PCSR_STATUS, VDU_SSC_EFUSE_DISABLE, 19, 1)
    FIELD(VDU_NPI_PCSR_STATUS, VDU_PWR_SUPPLY, 18, 1)
    FIELD(VDU_NPI_PCSR_STATUS, BISR_PASS, 17, 1)
    FIELD(VDU_NPI_PCSR_STATUS, BISR_DONE, 16, 1)
    FIELD(VDU_NPI_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(VDU_NPI_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(VDU_NPI_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(VDU_NPI_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(VDU_NPI_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(VDU_NPI_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(VDU_NPI_PCSR_STATUS, INCAL, 3, 1)
    FIELD(VDU_NPI_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(VDU_NPI_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(VDU_NPI_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(VDU_NPI_PCSR_LOCK, 0xc)
    FIELD(VDU_NPI_PCSR_LOCK, STATE, 0, 1)

#define VDU_NPI_R_MAX (R_VDU_NPI_PCSR_LOCK + 1)

typedef struct VDU_NPI {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[VDU_NPI_R_MAX];
    RegisterInfo regs_info[VDU_NPI_R_MAX];
} VDU_NPI;

static void vdu_pcsr_cntrl_postw(RegisterInfo *reg, uint64_t val)
{
    VDU_NPI *s = XILINX_VDU_NPI(reg->opaque);
    uint32_t val32 = val;

    s->regs[R_VDU_NPI_PCSR_STATUS] |=
        (val32 & R_VDU_NPI_PCSR_CONTROL_SCAN_CLEAR_TRIGGER_MASK ?
                (R_VDU_NPI_PCSR_STATUS_SCAN_CLEAR_DONE_MASK |
                 R_VDU_NPI_PCSR_STATUS_SCAN_CLEAR_PASS_MASK) : 0
        ) | (
         val32 & R_VDU_NPI_PCSR_CONTROL_MEM_CLEAR_TRIGGER_MASK ?
                (R_VDU_NPI_PCSR_STATUS_MEM_CLEAR_DONE_MASK |
                 R_VDU_NPI_PCSR_STATUS_MEM_CLEAR_PASS_MASK) : 0
        ) | (
         val32 & R_VDU_NPI_PCSR_CONTROL_BISR_TRIGGER_MASK ?
                (R_VDU_NPI_PCSR_STATUS_BISR_DONE_MASK |
                 R_VDU_NPI_PCSR_STATUS_BISR_PASS_MASK) : 0);
}

static void vdu_pcsr_lock_postw(RegisterInfo *reg, uint64_t val)
{
    VDU_NPI *s = XILINX_VDU_NPI(reg->opaque);

    s->regs[R_VDU_NPI_PCSR_STATUS] &= ~R_VDU_NPI_PCSR_STATUS_PCSRLOCK_MASK;

    if (val != 0xf9e8d7c6) {
        s->regs[R_VDU_NPI_PCSR_STATUS] |=
                val & R_VDU_NPI_PCSR_STATUS_PCSRLOCK_MASK;
    }
}

static const RegisterAccessInfo vdu_npi_regs_info[] = {
    {   .name = "VDU_NPI_PCSR_MASK",  .addr = A_VDU_NPI_PCSR_MASK,
        .rsvd = 0xf8000000,
    },{ .name = "VDU_NPI_PCSR_CONTROL",  .addr = A_VDU_NPI_PCSR_CONTROL,
        .reset = 0x4e001fe,
        .rsvd = 0xf8000000,
        .post_write = vdu_pcsr_cntrl_postw,
    },{ .name = "VDU_NPI_PCSR_STATUS",  .addr = A_VDU_NPI_PCSR_STATUS,
        .reset = 0x40001 |
                 R_VDU_NPI_PCSR_STATUS_CALDONE_MASK |
                 R_VDU_NPI_PCSR_STATUS_VDU_PWR_SUPPLY_MASK,
        .rsvd = 0xfff0c000,
        .ro = 0xfffff,
    },{ .name = "VDU_NPI_PCSR_LOCK",  .addr = A_VDU_NPI_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .post_write = vdu_pcsr_lock_postw
    }
};

static void vdu_npi_reset_enter(Object *obj, ResetType type)
{
    VDU_NPI *s = XILINX_VDU_NPI(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps vdu_npi_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void vdu_npi_init(Object *obj)
{
    VDU_NPI *s = XILINX_VDU_NPI(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_VDU_NPI, VDU_NPI_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), vdu_npi_regs_info,
                              ARRAY_SIZE(vdu_npi_regs_info),
                              s->regs_info, s->regs,
                              &vdu_npi_ops,
                              XILINX_VDU_NPI_ERR_DEBUG,
                              VDU_NPI_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_vdu_npi = {
    .name = TYPE_XILINX_VDU_NPI,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, VDU_NPI, VDU_NPI_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void vdu_npi_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_vdu_npi;
    rc->phases.enter = vdu_npi_reset_enter;
}

static const TypeInfo vdu_npi_info = {
    .name          = TYPE_XILINX_VDU_NPI,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(VDU_NPI),
    .class_init    = vdu_npi_class_init,
    .instance_init = vdu_npi_init,
};

static void vdu_npi_register_types(void)
{
    type_register_static(&vdu_npi_info);
}

type_init(vdu_npi_register_types)
