/*
 * QEMU model of the PMX_IOU_SLCR Global system level control registers for IOU
 *
 * Copyright (c) 2021 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2021-01-06.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_PMX_IOU_SLCR_ERR_DEBUG
#define XILINX_PMX_IOU_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMX_IOU_SLCR "xlnx,versal-pmx-iou-slcr"

#define XILINX_PMX_IOU_SLCR(obj) \
     OBJECT_CHECK(PMX_IOU_SLCR, (obj), TYPE_XILINX_PMX_IOU_SLCR)

REG32(MIO_PIN_0, 0x0)
    FIELD(MIO_PIN_0, L3_SEL, 7, 3)
    FIELD(MIO_PIN_0, L2_SEL, 5, 2)
    FIELD(MIO_PIN_0, L1_SEL, 3, 2)
    FIELD(MIO_PIN_0, L0_SEL, 1, 2)
REG32(MIO_PIN_1, 0x4)
    FIELD(MIO_PIN_1, L3_SEL, 7, 3)
    FIELD(MIO_PIN_1, L2_SEL, 5, 2)
    FIELD(MIO_PIN_1, L1_SEL, 3, 2)
    FIELD(MIO_PIN_1, L0_SEL, 1, 2)
REG32(MIO_PIN_2, 0x8)
    FIELD(MIO_PIN_2, L3_SEL, 7, 3)
    FIELD(MIO_PIN_2, L2_SEL, 5, 2)
    FIELD(MIO_PIN_2, L1_SEL, 3, 2)
    FIELD(MIO_PIN_2, L0_SEL, 1, 2)
REG32(MIO_PIN_3, 0xc)
    FIELD(MIO_PIN_3, L3_SEL, 7, 3)
    FIELD(MIO_PIN_3, L2_SEL, 5, 2)
    FIELD(MIO_PIN_3, L1_SEL, 3, 2)
    FIELD(MIO_PIN_3, L0_SEL, 1, 2)
REG32(MIO_PIN_4, 0x10)
    FIELD(MIO_PIN_4, L3_SEL, 7, 3)
    FIELD(MIO_PIN_4, L2_SEL, 5, 2)
    FIELD(MIO_PIN_4, L1_SEL, 3, 2)
    FIELD(MIO_PIN_4, L0_SEL, 1, 2)
REG32(MIO_PIN_5, 0x14)
    FIELD(MIO_PIN_5, L3_SEL, 7, 3)
    FIELD(MIO_PIN_5, L2_SEL, 5, 2)
    FIELD(MIO_PIN_5, L1_SEL, 3, 2)
    FIELD(MIO_PIN_5, L0_SEL, 1, 2)
REG32(MIO_PIN_6, 0x18)
    FIELD(MIO_PIN_6, L3_SEL, 7, 3)
    FIELD(MIO_PIN_6, L2_SEL, 5, 2)
    FIELD(MIO_PIN_6, L1_SEL, 3, 2)
    FIELD(MIO_PIN_6, L0_SEL, 1, 2)
REG32(MIO_PIN_7, 0x1c)
    FIELD(MIO_PIN_7, L3_SEL, 7, 3)
    FIELD(MIO_PIN_7, L2_SEL, 5, 2)
    FIELD(MIO_PIN_7, L1_SEL, 3, 2)
    FIELD(MIO_PIN_7, L0_SEL, 1, 2)
REG32(MIO_PIN_8, 0x20)
    FIELD(MIO_PIN_8, L3_SEL, 7, 3)
    FIELD(MIO_PIN_8, L2_SEL, 5, 2)
    FIELD(MIO_PIN_8, L1_SEL, 3, 2)
    FIELD(MIO_PIN_8, L0_SEL, 1, 2)
REG32(MIO_PIN_9, 0x24)
    FIELD(MIO_PIN_9, L3_SEL, 7, 3)
    FIELD(MIO_PIN_9, L2_SEL, 5, 2)
    FIELD(MIO_PIN_9, L1_SEL, 3, 2)
    FIELD(MIO_PIN_9, L0_SEL, 1, 2)
REG32(MIO_PIN_10, 0x28)
    FIELD(MIO_PIN_10, L3_SEL, 7, 3)
    FIELD(MIO_PIN_10, L2_SEL, 5, 2)
    FIELD(MIO_PIN_10, L1_SEL, 3, 2)
    FIELD(MIO_PIN_10, L0_SEL, 1, 2)
REG32(MIO_PIN_11, 0x2c)
    FIELD(MIO_PIN_11, L3_SEL, 7, 3)
    FIELD(MIO_PIN_11, L2_SEL, 5, 2)
    FIELD(MIO_PIN_11, L1_SEL, 3, 2)
    FIELD(MIO_PIN_11, L0_SEL, 1, 2)
REG32(MIO_PIN_12, 0x30)
    FIELD(MIO_PIN_12, L3_SEL, 7, 3)
    FIELD(MIO_PIN_12, L2_SEL, 5, 2)
    FIELD(MIO_PIN_12, L1_SEL, 3, 2)
    FIELD(MIO_PIN_12, L0_SEL, 1, 2)
REG32(MIO_PIN_13, 0x34)
    FIELD(MIO_PIN_13, L3_SEL, 7, 3)
    FIELD(MIO_PIN_13, L2_SEL, 5, 2)
    FIELD(MIO_PIN_13, L1_SEL, 3, 2)
    FIELD(MIO_PIN_13, L0_SEL, 1, 2)
REG32(MIO_PIN_14, 0x38)
    FIELD(MIO_PIN_14, L3_SEL, 7, 3)
    FIELD(MIO_PIN_14, L2_SEL, 5, 2)
    FIELD(MIO_PIN_14, L1_SEL, 3, 2)
    FIELD(MIO_PIN_14, L0_SEL, 1, 2)
REG32(MIO_PIN_15, 0x3c)
    FIELD(MIO_PIN_15, L3_SEL, 7, 3)
    FIELD(MIO_PIN_15, L2_SEL, 5, 2)
    FIELD(MIO_PIN_15, L1_SEL, 3, 2)
    FIELD(MIO_PIN_15, L0_SEL, 1, 2)
REG32(MIO_PIN_16, 0x40)
    FIELD(MIO_PIN_16, L3_SEL, 7, 3)
    FIELD(MIO_PIN_16, L2_SEL, 5, 2)
    FIELD(MIO_PIN_16, L1_SEL, 3, 2)
    FIELD(MIO_PIN_16, L0_SEL, 1, 2)
REG32(MIO_PIN_17, 0x44)
    FIELD(MIO_PIN_17, L3_SEL, 7, 3)
    FIELD(MIO_PIN_17, L2_SEL, 5, 2)
    FIELD(MIO_PIN_17, L1_SEL, 3, 2)
    FIELD(MIO_PIN_17, L0_SEL, 1, 2)
REG32(MIO_PIN_18, 0x48)
    FIELD(MIO_PIN_18, L3_SEL, 7, 3)
    FIELD(MIO_PIN_18, L2_SEL, 5, 2)
    FIELD(MIO_PIN_18, L1_SEL, 3, 2)
    FIELD(MIO_PIN_18, L0_SEL, 1, 2)
REG32(MIO_PIN_19, 0x4c)
    FIELD(MIO_PIN_19, L3_SEL, 7, 3)
    FIELD(MIO_PIN_19, L2_SEL, 5, 2)
    FIELD(MIO_PIN_19, L1_SEL, 3, 2)
    FIELD(MIO_PIN_19, L0_SEL, 1, 2)
REG32(MIO_PIN_20, 0x50)
    FIELD(MIO_PIN_20, L3_SEL, 7, 3)
    FIELD(MIO_PIN_20, L2_SEL, 5, 2)
    FIELD(MIO_PIN_20, L1_SEL, 3, 2)
    FIELD(MIO_PIN_20, L0_SEL, 1, 2)
REG32(MIO_PIN_21, 0x54)
    FIELD(MIO_PIN_21, L3_SEL, 7, 3)
    FIELD(MIO_PIN_21, L2_SEL, 5, 2)
    FIELD(MIO_PIN_21, L1_SEL, 3, 2)
    FIELD(MIO_PIN_21, L0_SEL, 1, 2)
REG32(MIO_PIN_22, 0x58)
    FIELD(MIO_PIN_22, L3_SEL, 7, 3)
    FIELD(MIO_PIN_22, L2_SEL, 5, 2)
    FIELD(MIO_PIN_22, L1_SEL, 3, 2)
    FIELD(MIO_PIN_22, L0_SEL, 1, 2)
REG32(MIO_PIN_23, 0x5c)
    FIELD(MIO_PIN_23, L3_SEL, 7, 3)
    FIELD(MIO_PIN_23, L2_SEL, 5, 2)
    FIELD(MIO_PIN_23, L1_SEL, 3, 2)
    FIELD(MIO_PIN_23, L0_SEL, 1, 2)
REG32(MIO_PIN_24, 0x60)
    FIELD(MIO_PIN_24, L3_SEL, 7, 3)
    FIELD(MIO_PIN_24, L2_SEL, 5, 2)
    FIELD(MIO_PIN_24, L1_SEL, 3, 2)
    FIELD(MIO_PIN_24, L0_SEL, 1, 2)
REG32(MIO_PIN_25, 0x64)
    FIELD(MIO_PIN_25, L3_SEL, 7, 3)
    FIELD(MIO_PIN_25, L2_SEL, 5, 2)
    FIELD(MIO_PIN_25, L1_SEL, 3, 2)
    FIELD(MIO_PIN_25, L0_SEL, 1, 2)
REG32(MIO_PIN_26, 0x68)
    FIELD(MIO_PIN_26, L3_SEL, 7, 3)
    FIELD(MIO_PIN_26, L2_SEL, 5, 2)
    FIELD(MIO_PIN_26, L1_SEL, 3, 2)
    FIELD(MIO_PIN_26, L0_SEL, 1, 2)
REG32(MIO_PIN_27, 0x6c)
    FIELD(MIO_PIN_27, L3_SEL, 7, 3)
    FIELD(MIO_PIN_27, L2_SEL, 5, 2)
    FIELD(MIO_PIN_27, L1_SEL, 3, 2)
    FIELD(MIO_PIN_27, L0_SEL, 1, 2)
REG32(MIO_PIN_28, 0x70)
    FIELD(MIO_PIN_28, L3_SEL, 7, 3)
    FIELD(MIO_PIN_28, L2_SEL, 5, 2)
    FIELD(MIO_PIN_28, L1_SEL, 3, 2)
    FIELD(MIO_PIN_28, L0_SEL, 1, 2)
REG32(MIO_PIN_29, 0x74)
    FIELD(MIO_PIN_29, L3_SEL, 7, 3)
    FIELD(MIO_PIN_29, L2_SEL, 5, 2)
    FIELD(MIO_PIN_29, L1_SEL, 3, 2)
    FIELD(MIO_PIN_29, L0_SEL, 1, 2)
REG32(MIO_PIN_30, 0x78)
    FIELD(MIO_PIN_30, L3_SEL, 7, 3)
    FIELD(MIO_PIN_30, L2_SEL, 5, 2)
    FIELD(MIO_PIN_30, L1_SEL, 3, 2)
    FIELD(MIO_PIN_30, L0_SEL, 1, 2)
REG32(MIO_PIN_31, 0x7c)
    FIELD(MIO_PIN_31, L3_SEL, 7, 3)
    FIELD(MIO_PIN_31, L2_SEL, 5, 2)
    FIELD(MIO_PIN_31, L1_SEL, 3, 2)
    FIELD(MIO_PIN_31, L0_SEL, 1, 2)
REG32(MIO_PIN_32, 0x80)
    FIELD(MIO_PIN_32, L3_SEL, 7, 3)
    FIELD(MIO_PIN_32, L2_SEL, 5, 2)
    FIELD(MIO_PIN_32, L1_SEL, 3, 2)
    FIELD(MIO_PIN_32, L0_SEL, 1, 2)
REG32(MIO_PIN_33, 0x84)
    FIELD(MIO_PIN_33, L3_SEL, 7, 3)
    FIELD(MIO_PIN_33, L2_SEL, 5, 2)
    FIELD(MIO_PIN_33, L1_SEL, 3, 2)
    FIELD(MIO_PIN_33, L0_SEL, 1, 2)
REG32(MIO_PIN_34, 0x88)
    FIELD(MIO_PIN_34, L3_SEL, 7, 3)
    FIELD(MIO_PIN_34, L2_SEL, 5, 2)
    FIELD(MIO_PIN_34, L1_SEL, 3, 2)
    FIELD(MIO_PIN_34, L0_SEL, 1, 2)
REG32(MIO_PIN_35, 0x8c)
    FIELD(MIO_PIN_35, L3_SEL, 7, 3)
    FIELD(MIO_PIN_35, L2_SEL, 5, 2)
    FIELD(MIO_PIN_35, L1_SEL, 3, 2)
    FIELD(MIO_PIN_35, L0_SEL, 1, 2)
REG32(MIO_PIN_36, 0x90)
    FIELD(MIO_PIN_36, L3_SEL, 7, 3)
    FIELD(MIO_PIN_36, L2_SEL, 5, 2)
    FIELD(MIO_PIN_36, L1_SEL, 3, 2)
    FIELD(MIO_PIN_36, L0_SEL, 1, 2)
REG32(MIO_PIN_37, 0x94)
    FIELD(MIO_PIN_37, L3_SEL, 7, 3)
    FIELD(MIO_PIN_37, L2_SEL, 5, 2)
    FIELD(MIO_PIN_37, L1_SEL, 3, 2)
    FIELD(MIO_PIN_37, L0_SEL, 1, 2)
REG32(MIO_PIN_38, 0x98)
    FIELD(MIO_PIN_38, L3_SEL, 7, 3)
    FIELD(MIO_PIN_38, L2_SEL, 5, 2)
    FIELD(MIO_PIN_38, L1_SEL, 3, 2)
    FIELD(MIO_PIN_38, L0_SEL, 1, 2)
REG32(MIO_PIN_39, 0x9c)
    FIELD(MIO_PIN_39, L3_SEL, 7, 3)
    FIELD(MIO_PIN_39, L2_SEL, 5, 2)
    FIELD(MIO_PIN_39, L1_SEL, 3, 2)
    FIELD(MIO_PIN_39, L0_SEL, 1, 2)
REG32(MIO_PIN_40, 0xa0)
    FIELD(MIO_PIN_40, L3_SEL, 7, 3)
    FIELD(MIO_PIN_40, L2_SEL, 5, 2)
    FIELD(MIO_PIN_40, L1_SEL, 3, 2)
    FIELD(MIO_PIN_40, L0_SEL, 1, 2)
REG32(MIO_PIN_41, 0xa4)
    FIELD(MIO_PIN_41, L3_SEL, 7, 3)
    FIELD(MIO_PIN_41, L2_SEL, 5, 2)
    FIELD(MIO_PIN_41, L1_SEL, 3, 2)
    FIELD(MIO_PIN_41, L0_SEL, 1, 2)
REG32(MIO_PIN_42, 0xa8)
    FIELD(MIO_PIN_42, L3_SEL, 7, 3)
    FIELD(MIO_PIN_42, L2_SEL, 5, 2)
    FIELD(MIO_PIN_42, L1_SEL, 3, 2)
    FIELD(MIO_PIN_42, L0_SEL, 1, 2)
REG32(MIO_PIN_43, 0xac)
    FIELD(MIO_PIN_43, L3_SEL, 7, 3)
    FIELD(MIO_PIN_43, L2_SEL, 5, 2)
    FIELD(MIO_PIN_43, L1_SEL, 3, 2)
    FIELD(MIO_PIN_43, L0_SEL, 1, 2)
REG32(MIO_PIN_44, 0xb0)
    FIELD(MIO_PIN_44, L3_SEL, 7, 3)
    FIELD(MIO_PIN_44, L2_SEL, 5, 2)
    FIELD(MIO_PIN_44, L1_SEL, 3, 2)
    FIELD(MIO_PIN_44, L0_SEL, 1, 2)
REG32(MIO_PIN_45, 0xb4)
    FIELD(MIO_PIN_45, L3_SEL, 7, 3)
    FIELD(MIO_PIN_45, L2_SEL, 5, 2)
    FIELD(MIO_PIN_45, L1_SEL, 3, 2)
    FIELD(MIO_PIN_45, L0_SEL, 1, 2)
REG32(MIO_PIN_46, 0xb8)
    FIELD(MIO_PIN_46, L3_SEL, 7, 3)
    FIELD(MIO_PIN_46, L2_SEL, 5, 2)
    FIELD(MIO_PIN_46, L1_SEL, 3, 2)
    FIELD(MIO_PIN_46, L0_SEL, 1, 2)
REG32(MIO_PIN_47, 0xbc)
    FIELD(MIO_PIN_47, L3_SEL, 7, 3)
    FIELD(MIO_PIN_47, L2_SEL, 5, 2)
    FIELD(MIO_PIN_47, L1_SEL, 3, 2)
    FIELD(MIO_PIN_47, L0_SEL, 1, 2)
REG32(MIO_PIN_48, 0xc0)
    FIELD(MIO_PIN_48, L3_SEL, 7, 3)
    FIELD(MIO_PIN_48, L2_SEL, 5, 2)
    FIELD(MIO_PIN_48, L1_SEL, 3, 2)
    FIELD(MIO_PIN_48, L0_SEL, 1, 2)
REG32(MIO_PIN_49, 0xc4)
    FIELD(MIO_PIN_49, L3_SEL, 7, 3)
    FIELD(MIO_PIN_49, L2_SEL, 5, 2)
    FIELD(MIO_PIN_49, L1_SEL, 3, 2)
    FIELD(MIO_PIN_49, L0_SEL, 1, 2)
REG32(MIO_PIN_50, 0xc8)
    FIELD(MIO_PIN_50, L3_SEL, 7, 3)
    FIELD(MIO_PIN_50, L2_SEL, 5, 2)
    FIELD(MIO_PIN_50, L1_SEL, 3, 2)
    FIELD(MIO_PIN_50, L0_SEL, 1, 2)
REG32(MIO_PIN_51, 0xcc)
    FIELD(MIO_PIN_51, L3_SEL, 7, 3)
    FIELD(MIO_PIN_51, L2_SEL, 5, 2)
    FIELD(MIO_PIN_51, L1_SEL, 3, 2)
    FIELD(MIO_PIN_51, L0_SEL, 1, 2)
REG32(BNK0_EN_RX_SCHMITT_HYST, 0x10c)
    FIELD(BNK0_EN_RX_SCHMITT_HYST, BNK0_EN_RX_SCHMITT_HYST, 0, 26)
REG32(BNK0_EN_WK_PD, 0x110)
    FIELD(BNK0_EN_WK_PD, BNK0_EN_WK_PD, 0, 26)
REG32(BNK0_EN_WK_PU, 0x114)
    FIELD(BNK0_EN_WK_PU, BNK0_EN_WK_PU, 0, 26)
REG32(BNK0_SEL_DRV0, 0x118)
REG32(BNK0_SEL_DRV1, 0x11c)
    FIELD(BNK0_SEL_DRV1, BNK0_SEL_DRV, 0, 20)
REG32(BNK0_SEL_SLEW, 0x120)
    FIELD(BNK0_SEL_SLEW, BNK0_SEL_SLEW, 0, 26)
REG32(BNK0_VMODE, 0x15c)
    FIELD(BNK0_VMODE, BNK0_VMODE, 0, 1)
REG32(BNK0_SEL_AUX_IO_RX, 0x160)
    FIELD(BNK0_SEL_AUX_IO_RX, BNK0_SEL_AUX_IO_RX, 0, 26)
REG32(MIO_MST_TRI0, 0x200)
    FIELD(MIO_MST_TRI0, PIN_25_TRI, 25, 1)
    FIELD(MIO_MST_TRI0, PIN_24_TRI, 24, 1)
    FIELD(MIO_MST_TRI0, PIN_23_TRI, 23, 1)
    FIELD(MIO_MST_TRI0, PIN_22_TRI, 22, 1)
    FIELD(MIO_MST_TRI0, PIN_21_TRI, 21, 1)
    FIELD(MIO_MST_TRI0, PIN_20_TRI, 20, 1)
    FIELD(MIO_MST_TRI0, PIN_19_TRI, 19, 1)
    FIELD(MIO_MST_TRI0, PIN_18_TRI, 18, 1)
    FIELD(MIO_MST_TRI0, PIN_17_TRI, 17, 1)
    FIELD(MIO_MST_TRI0, PIN_16_TRI, 16, 1)
    FIELD(MIO_MST_TRI0, PIN_15_TRI, 15, 1)
    FIELD(MIO_MST_TRI0, PIN_14_TRI, 14, 1)
    FIELD(MIO_MST_TRI0, PIN_13_TRI, 13, 1)
    FIELD(MIO_MST_TRI0, PIN_12_TRI, 12, 1)
    FIELD(MIO_MST_TRI0, PIN_11_TRI, 11, 1)
    FIELD(MIO_MST_TRI0, PIN_10_TRI, 10, 1)
    FIELD(MIO_MST_TRI0, PIN_09_TRI, 9, 1)
    FIELD(MIO_MST_TRI0, PIN_08_TRI, 8, 1)
    FIELD(MIO_MST_TRI0, PIN_07_TRI, 7, 1)
    FIELD(MIO_MST_TRI0, PIN_06_TRI, 6, 1)
    FIELD(MIO_MST_TRI0, PIN_05_TRI, 5, 1)
    FIELD(MIO_MST_TRI0, PIN_04_TRI, 4, 1)
    FIELD(MIO_MST_TRI0, PIN_03_TRI, 3, 1)
    FIELD(MIO_MST_TRI0, PIN_02_TRI, 2, 1)
    FIELD(MIO_MST_TRI0, PIN_01_TRI, 1, 1)
    FIELD(MIO_MST_TRI0, PIN_00_TRI, 0, 1)
REG32(MIO_MST_TRI1, 0x204)
    FIELD(MIO_MST_TRI1, PIN_51_TRI, 25, 1)
    FIELD(MIO_MST_TRI1, PIN_50_TRI, 24, 1)
    FIELD(MIO_MST_TRI1, PIN_49_TRI, 23, 1)
    FIELD(MIO_MST_TRI1, PIN_48_TRI, 22, 1)
    FIELD(MIO_MST_TRI1, PIN_47_TRI, 21, 1)
    FIELD(MIO_MST_TRI1, PIN_46_TRI, 20, 1)
    FIELD(MIO_MST_TRI1, PIN_45_TRI, 19, 1)
    FIELD(MIO_MST_TRI1, PIN_44_TRI, 18, 1)
    FIELD(MIO_MST_TRI1, PIN_43_TRI, 17, 1)
    FIELD(MIO_MST_TRI1, PIN_42_TRI, 16, 1)
    FIELD(MIO_MST_TRI1, PIN_41_TRI, 15, 1)
    FIELD(MIO_MST_TRI1, PIN_40_TRI, 14, 1)
    FIELD(MIO_MST_TRI1, PIN_39_TRI, 13, 1)
    FIELD(MIO_MST_TRI1, PIN_38_TRI, 12, 1)
    FIELD(MIO_MST_TRI1, PIN_37_TRI, 11, 1)
    FIELD(MIO_MST_TRI1, PIN_36_TRI, 10, 1)
    FIELD(MIO_MST_TRI1, PIN_35_TRI, 9, 1)
    FIELD(MIO_MST_TRI1, PIN_34_TRI, 8, 1)
    FIELD(MIO_MST_TRI1, PIN_33_TRI, 7, 1)
    FIELD(MIO_MST_TRI1, PIN_32_TRI, 6, 1)
    FIELD(MIO_MST_TRI1, PIN_31_TRI, 5, 1)
    FIELD(MIO_MST_TRI1, PIN_30_TRI, 4, 1)
    FIELD(MIO_MST_TRI1, PIN_29_TRI, 3, 1)
    FIELD(MIO_MST_TRI1, PIN_28_TRI, 2, 1)
    FIELD(MIO_MST_TRI1, PIN_27_TRI, 1, 1)
    FIELD(MIO_MST_TRI1, PIN_26_TRI, 0, 1)
REG32(BNK1_EN_RX_SCHMITT_HYST, 0x30c)
    FIELD(BNK1_EN_RX_SCHMITT_HYST, BNK1_EN_RX_SCHMITT_HYST, 0, 26)
REG32(BNK1_EN_WK_PD, 0x310)
    FIELD(BNK1_EN_WK_PD, BNK1_EN_WK_PD, 0, 26)
REG32(BNK1_EN_WK_PU, 0x314)
    FIELD(BNK1_EN_WK_PU, BNK1_EN_WK_PU, 0, 26)
REG32(BNK1_SEL_DRV0, 0x318)
REG32(BNK1_SEL_DRV1, 0x31c)
    FIELD(BNK1_SEL_DRV1, BNK1_SEL_DRV, 0, 20)
REG32(BNK1_SEL_SLEW, 0x320)
    FIELD(BNK1_SEL_SLEW, BNK1_SEL_SLEW, 0, 26)
REG32(BNK1_VMODE, 0x35c)
    FIELD(BNK1_VMODE, BNK1_VMODE, 0, 1)
REG32(BNK1_SEL_AUX_IO_RX, 0x360)
    FIELD(BNK1_SEL_AUX_IO_RX, BNK1_SEL_AUX_IO_RX, 0, 26)
REG32(EMMC_CLK_CTRL, 0x400)
    FIELD(EMMC_CLK_CTRL, EMMC_FBCLK_SEL, 2, 1)
    FIELD(EMMC_CLK_CTRL, EMMC_RX_SRC_SEL, 0, 2)
REG32(EMMC_CTRL_REG, 0x404)
    FIELD(EMMC_CTRL_REG, SD0_EMMC_SEL, 0, 1)
REG32(EMMC_CONFIG_REG1, 0x410)
    FIELD(EMMC_CONFIG_REG1, EMMC_BASECLK, 7, 8)
    FIELD(EMMC_CONFIG_REG1, EMMC_TUNIGCOUNT, 1, 6)
    FIELD(EMMC_CONFIG_REG1, EMMC_ASYNCWKPENA, 0, 1)
REG32(EMMC_CONFIG_REG2, 0x414)
    FIELD(EMMC_CONFIG_REG2, EMMC_SLOTTYPE, 12, 2)
    FIELD(EMMC_CONFIG_REG2, EMMC_ASYCINTR, 11, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_64BIT, 10, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_1P8V, 9, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_3P0V, 8, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_3P3V, 7, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_SUSPRES, 6, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_SDMA, 5, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_HIGHSPEED, 4, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_ADMA2, 3, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_8BIT, 2, 1)
    FIELD(EMMC_CONFIG_REG2, EMMC_MAXBLK, 0, 2)
REG32(EMMC_CONFIG_REG3, 0x418)
    FIELD(EMMC_CONFIG_REG3, EMMC_TYPE4, 12, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_HS400, 11, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_TUNINGSDR50, 10, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_RETUNETMR, 6, 4)
    FIELD(EMMC_CONFIG_REG3, EMMC_DDRIVER, 5, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_CDRIVER, 4, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_ADRIVER, 3, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_DDR50, 2, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_SDR104, 1, 1)
    FIELD(EMMC_CONFIG_REG3, EMMC_SDR50, 0, 1)
REG32(EMMC_INITPRESET, 0x41c)
    FIELD(EMMC_INITPRESET, EMMC_INITPRESET, 0, 13)
REG32(EMMC_DSPPRESET, 0x420)
    FIELD(EMMC_DSPPRESET, EMMC_DSPPRESET, 0, 13)
REG32(EMMC_HSPDPRESET, 0x424)
    FIELD(EMMC_HSPDPRESET, EMMC_HSPDPRESET, 0, 13)
REG32(EMMC_SDR12PRESET, 0x428)
    FIELD(EMMC_SDR12PRESET, EMMC_SDR12PRESET, 0, 13)
REG32(EMMC_SDR25PRESET, 0x42c)
    FIELD(EMMC_SDR25PRESET, EMMC_SDR25PRESET, 0, 13)
REG32(EMMC_SDR50PRSET, 0x430)
    FIELD(EMMC_SDR50PRSET, EMMC_SDR50PRESET, 0, 13)
REG32(EMMC_SDR104PRST, 0x434)
    FIELD(EMMC_SDR104PRST, EMMC_SDR104PRESET, 0, 13)
REG32(EMMC_DDR50PRESET, 0x438)
    FIELD(EMMC_DDR50PRESET, EMMC_DDR50PRESET, 0, 13)
REG32(EMMC_MAXCUR1P8, 0x43c)
    FIELD(EMMC_MAXCUR1P8, EMMC_MAXCUR1P8, 0, 8)
REG32(EMMC_MAXCUR3P0, 0x440)
    FIELD(EMMC_MAXCUR3P0, EMMC_MAXCUR3P0, 0, 8)
REG32(EMMC_MAXCUR3P3, 0x444)
    FIELD(EMMC_MAXCUR3P3, EMMC_MAXCUR3P3, 0, 8)
REG32(EMMC_CDN_CTRL, 0x44c)
    FIELD(EMMC_CDN_CTRL, EMMC_CDN_CTRL, 0, 1)
REG32(EMMC_IOU_COHERENT_CTRL, 0x460)
    FIELD(EMMC_IOU_COHERENT_CTRL, EMMC_AXI_COH, 0, 4)
REG32(EMMC_IOU_INTERCONNECT_ROUTE, 0x464)
    FIELD(EMMC_IOU_INTERCONNECT_ROUTE, EMMC, 0, 1)
REG32(EMMC_IOU_INTERCONNECT_QOS, 0x46c)
    FIELD(EMMC_IOU_INTERCONNECT_QOS, EMMC_QOS, 0, 4)
REG32(EMMC_HS400PRESET, 0x470)
    FIELD(EMMC_HS400PRESET, EMMC_HS400PRESET, 0, 13)
REG32(EMMC_CQ_FREQ, 0x474)
    FIELD(EMMC_CQ_FREQ, EMMC_CQFMUL, 10, 4)
    FIELD(EMMC_CQ_FREQ, EMMC_CQFVAL, 0, 10)
REG32(SD1_CLK_CTRL, 0x480)
    FIELD(SD1_CLK_CTRL, SDIO1_FBCLK_SEL, 1, 1)
    FIELD(SD1_CLK_CTRL, SDIO1_RX_SRC_SEL, 0, 1)
REG32(SD1_CTRL_REG, 0x484)
    FIELD(SD1_CTRL_REG, SD1_EMMC_SEL, 0, 1)
REG32(SD1_CONFIG_REG1, 0x490)
    FIELD(SD1_CONFIG_REG1, SD1_BASECLK, 7, 8)
    FIELD(SD1_CONFIG_REG1, SD1_TUNIGCOUNT, 1, 6)
    FIELD(SD1_CONFIG_REG1, SD1_ASYNCWKPENA, 0, 1)
REG32(SD1_CONFIG_REG2, 0x494)
    FIELD(SD1_CONFIG_REG2, SD1_SLOTTYPE, 12, 2)
    FIELD(SD1_CONFIG_REG2, SD1_ASYCINTR, 11, 1)
    FIELD(SD1_CONFIG_REG2, SD1_64BIT, 10, 1)
    FIELD(SD1_CONFIG_REG2, SD1_1P8V, 9, 1)
    FIELD(SD1_CONFIG_REG2, SD1_3P0V, 8, 1)
    FIELD(SD1_CONFIG_REG2, SD1_3P3V, 7, 1)
    FIELD(SD1_CONFIG_REG2, SD1_SUSPRES, 6, 1)
    FIELD(SD1_CONFIG_REG2, SD1_SDMA, 5, 1)
    FIELD(SD1_CONFIG_REG2, SD1_HIGHSPEED, 4, 1)
    FIELD(SD1_CONFIG_REG2, SD1_ADMA2, 3, 1)
    FIELD(SD1_CONFIG_REG2, SD1_8BIT, 2, 1)
    FIELD(SD1_CONFIG_REG2, SD1_MAXBLK, 0, 2)
REG32(SD1_CONFIG_REG3, 0x498)
    FIELD(SD1_CONFIG_REG3, SD1_TUNINGSDR50, 10, 1)
    FIELD(SD1_CONFIG_REG3, SD1_RETUNETMR, 6, 4)
    FIELD(SD1_CONFIG_REG3, SD1_DDRIVER, 5, 1)
    FIELD(SD1_CONFIG_REG3, SD1_CDRIVER, 4, 1)
    FIELD(SD1_CONFIG_REG3, SD1_ADRIVER, 3, 1)
    FIELD(SD1_CONFIG_REG3, SD1_DDR50, 2, 1)
    FIELD(SD1_CONFIG_REG3, SD1_SDR104, 1, 1)
    FIELD(SD1_CONFIG_REG3, SD1_SDR50, 0, 1)
REG32(SD1_INITPRESET, 0x49c)
    FIELD(SD1_INITPRESET, SD1_INITPRESET, 0, 13)
REG32(SD1_DSPPRESET, 0x4a0)
    FIELD(SD1_DSPPRESET, SD1_DSPPRESET, 0, 13)
REG32(SD1_HSPDPRESET, 0x4a4)
    FIELD(SD1_HSPDPRESET, SD1_HSPDPRESET, 0, 13)
REG32(SD1_SDR12PRESET, 0x4a8)
    FIELD(SD1_SDR12PRESET, SD1_SDR12PRESET, 0, 13)
REG32(SD1_SDR25PRESET, 0x4ac)
    FIELD(SD1_SDR25PRESET, SD1_SDR25PRESET, 0, 13)
REG32(SD1_SDR50PRSET, 0x4b0)
    FIELD(SD1_SDR50PRSET, SD1_SDR50PRESET, 0, 13)
REG32(SD1_SDR104PRST, 0x4b4)
    FIELD(SD1_SDR104PRST, SD1_SDR104PRESET, 0, 13)
REG32(SD1_DDR50PRESET, 0x4b8)
    FIELD(SD1_DDR50PRESET, SD1_DDR50PRESET, 0, 13)
REG32(SD1_MAXCUR1P8, 0x4bc)
    FIELD(SD1_MAXCUR1P8, SD1_MAXCUR1P8, 0, 8)
REG32(SD1_MAXCUR3P0, 0x4c0)
    FIELD(SD1_MAXCUR3P0, SD1_MAXCUR3P0, 0, 8)
REG32(SD1_MAXCUR3P3, 0x4c4)
    FIELD(SD1_MAXCUR3P3, SD1_MAXCUR3P3, 0, 8)
REG32(SD1_DLL_CTRL, 0x4c8)
    FIELD(SD1_DLL_CTRL, SD1_CLKSTABLE_CFG, 9, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_CFG, 5, 4)
    FIELD(SD1_DLL_CTRL, SD1_DLL_PSDONE, 4, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_OVF, 3, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_RST, 2, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_TESTMODE, 1, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_LOCK, 0, 1)
REG32(SD1_CDN_CTRL, 0x4cc)
    FIELD(SD1_CDN_CTRL, SD1_CDN_CTRL, 0, 1)
REG32(SD1_RX_TUNING_SEL, 0x4d4)
    FIELD(SD1_RX_TUNING_SEL, SD1_RX_SEL, 0, 9)
REG32(SD1_DLL_DIV_MAP0, 0x4d8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_2, 16, 8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_1, 8, 8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_0, 0, 8)
REG32(SD1_IOU_COHERENT_CTRL, 0x4e0)
    FIELD(SD1_IOU_COHERENT_CTRL, SD1_AXI_COH, 0, 4)
REG32(SD1_IOU_INTERCONNECT_ROUTE, 0x4e4)
    FIELD(SD1_IOU_INTERCONNECT_ROUTE, SD1, 0, 1)
REG32(SD1_IOU_INTERCONNECT_QOS, 0x4ec)
    FIELD(SD1_IOU_INTERCONNECT_QOS, SD1_QOS, 0, 4)
REG32(OSPI_QSPI_IOU_AXI_MUX_SEL, 0x504)
    FIELD(OSPI_QSPI_IOU_AXI_MUX_SEL, OSPI_MUX_SEL, 1, 1)
    FIELD(OSPI_QSPI_IOU_AXI_MUX_SEL, QSPI_OSPI_MUX_SEL, 0, 1)
REG32(QSPI_IOU_COHERENT_CTRL, 0x508)
    FIELD(QSPI_IOU_COHERENT_CTRL, QSPI_AXI_COH, 0, 4)
REG32(QSPI_IOU_INTERCONNECT_ROUTE, 0x50c)
    FIELD(QSPI_IOU_INTERCONNECT_ROUTE, QSPI, 0, 1)
REG32(QSPI_IOU_INTERCONNECT_QOS, 0x514)
    FIELD(QSPI_IOU_INTERCONNECT_QOS, QSPI_QOS, 0, 4)
REG32(OSPI_IOU_COHERENT_CTRL, 0x530)
    FIELD(OSPI_IOU_COHERENT_CTRL, OSPI_AXI_COH, 0, 4)
REG32(OSPI_IOU_INTERCONNECT_ROUTE, 0x534)
    FIELD(OSPI_IOU_INTERCONNECT_ROUTE, OSPI, 0, 1)
REG32(OSPI_IOU_INTERCONNECT_QOS, 0x53c)
    FIELD(OSPI_IOU_INTERCONNECT_QOS, OSPI_QOS, 0, 4)
REG32(OSPI_IOU_RESETOUT_SEL, 0x544)
    FIELD(OSPI_IOU_RESETOUT_SEL, OSPI_RESETOUT_SEL, 0, 1)
REG32(I2C_I3C_CTRL, 0x560)
    FIELD(I2C_I3C_CTRL, I2C_I3C_SELECT, 0, 1)
REG32(USB0_CUR_PWR_ST, 0x600)
    FIELD(USB0_CUR_PWR_ST, U2PMU, 0, 2)
REG32(USB0_CONNECT_ST, 0x604)
    FIELD(USB0_CONNECT_ST, U2PMU, 0, 1)
REG32(USB1_CUR_PWR_ST, 0x650)
    FIELD(USB1_CUR_PWR_ST, U2PMU, 0, 2)
REG32(USB1_CONNECT_ST, 0x654)
    FIELD(USB1_CONNECT_ST, U2PMU, 0, 1)
REG32(CTRL, 0x700)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x800)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0x804)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x808)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x80c)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x810)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)
REG32(PARITY_ISR, 0x814)
    FIELD(PARITY_ISR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_ISR, PERR_AXI_EMMC_IOU, 11, 1)
    FIELD(PARITY_ISR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_ISR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_ISR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_ISR, PERR_IOU_EMMC, 7, 1)
    FIELD(PARITY_ISR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_ISR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_ISR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_ISR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_ISR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_ISR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_ISR, PERR_GPIO_APB, 0, 1)
REG32(PARITY_IMR, 0x818)
    FIELD(PARITY_IMR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_IMR, PERR_AXI_EMMC_IOU, 11, 1)
    FIELD(PARITY_IMR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_IMR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_IMR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_IMR, PERR_IOU_EMMC, 7, 1)
    FIELD(PARITY_IMR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_IMR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_IMR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_IMR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_IMR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_IMR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_IMR, PERR_GPIO_APB, 0, 1)
REG32(PARITY_IER, 0x81c)
    FIELD(PARITY_IER, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_IER, PERR_AXI_EMMC_IOU, 11, 1)
    FIELD(PARITY_IER, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_IER, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_IER, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_IER, PERR_IOU_EMMC, 7, 1)
    FIELD(PARITY_IER, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_IER, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_IER, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_IER, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_IER, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_IER, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_IER, PERR_GPIO_APB, 0, 1)
REG32(PARITY_IDR, 0x820)
    FIELD(PARITY_IDR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_IDR, PERR_AXI_EMMC_IOU, 11, 1)
    FIELD(PARITY_IDR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_IDR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_IDR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_IDR, PERR_IOU_EMMC, 7, 1)
    FIELD(PARITY_IDR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_IDR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_IDR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_IDR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_IDR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_IDR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_IDR, PERR_GPIO_APB, 0, 1)
REG32(PARITY_ITR, 0x824)
    FIELD(PARITY_ITR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_ITR, PERR_AXI_EMMC_IOU, 11, 1)
    FIELD(PARITY_ITR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_ITR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_ITR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_ITR, PERR_IOU_EMMC, 7, 1)
    FIELD(PARITY_ITR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_ITR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_ITR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_ITR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_ITR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_ITR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_ITR, PERR_GPIO_APB, 0, 1)
REG32(WPROT0, 0x828)
    FIELD(WPROT0, ACTIVE, 0, 1)
REG32(INTIOU_PMX_SLV_APB_ERR_ISR, 0xa00)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ISR, INTIOU_PMX_IOUSLCR_SECURE_APB_SLV_ERR, 5,\
          1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ISR, INTIOU_PMX_IOUSLCR_APB_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ISR, INTIOU_PMX_I2CI3C_APB_SLV_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ISR, INTIOU_PMX_GPIO_APB_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ISR, INTIOU_PMX_OSPI_APB_SLV_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ISR, INTIOU_PMX_QSPI_APB_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_APB_ERR_IMR, 0xa04)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IMR, INTIOU_PMX_IOUSLCR_SECURE_APB_SLV_ERR, 5,\
          1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IMR, INTIOU_PMX_IOUSLCR_APB_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IMR, INTIOU_PMX_I2CI3C_APB_SLV_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IMR, INTIOU_PMX_GPIO_APB_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IMR, INTIOU_PMX_OSPI_APB_SLV_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IMR, INTIOU_PMX_QSPI_APB_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_APB_ERR_IER, 0xa08)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IER, INTIOU_PMX_IOUSLCR_SECURE_APB_SLV_ERR, 5,\
          1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IER, INTIOU_PMX_IOUSLCR_APB_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IER, INTIOU_PMX_I2CI3C_APB_SLV_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IER, INTIOU_PMX_GPIO_APB_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IER, INTIOU_PMX_OSPI_APB_SLV_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IER, INTIOU_PMX_QSPI_APB_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_APB_ERR_IDR, 0xa0c)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IDR, INTIOU_PMX_IOUSLCR_SECURE_APB_SLV_ERR, 5,\
          1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IDR, INTIOU_PMX_IOUSLCR_APB_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IDR, INTIOU_PMX_I2CI3C_APB_SLV_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IDR, INTIOU_PMX_GPIO_APB_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IDR, INTIOU_PMX_OSPI_APB_SLV_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_IDR, INTIOU_PMX_QSPI_APB_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_APB_ERR_ITR, 0xa10)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ITR, INTIOU_PMX_IOUSLCR_SECURE_APB_SLV_ERR, 5,\
          1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ITR, INTIOU_PMX_IOUSLCR_APB_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ITR, INTIOU_PMX_I2CI3C_APB_SLV_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ITR, INTIOU_PMX_GPIO_APB_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ITR, INTIOU_PMX_OSPI_APB_SLV_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_APB_ERR_ITR, INTIOU_PMX_QSPI_APB_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_AXI_ERR_ISR, 0xa14)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_PMCMAIN_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_PMCMAIN_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD1_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD1_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD0_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD0_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_QSPI_AXI_WR_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_QSPI_AXI_WR_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_PMCMAIN_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_PMCMAIN_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD1_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD1_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD0_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_SD0_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_QSPI_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ISR, INTIOU_PMX_QSPI_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_AXI_ERR_IMR, 0xa18)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_PMCMAIN_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_PMCMAIN_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD1_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD1_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD0_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD0_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_QSPI_AXI_WR_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_QSPI_AXI_WR_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_PMCMAIN_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_PMCMAIN_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD1_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD1_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD0_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_SD0_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_QSPI_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IMR, INTIOU_PMX_QSPI_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_AXI_ERR_IER, 0xa1c)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_PMCMAIN_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_PMCMAIN_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD1_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD1_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD0_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD0_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_QSPI_AXI_WR_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_QSPI_AXI_WR_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_PMCMAIN_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_PMCMAIN_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD1_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD1_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD0_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_SD0_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_QSPI_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IER, INTIOU_PMX_QSPI_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_AXI_ERR_IDR, 0xa20)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_PMCMAIN_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_PMCMAIN_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD1_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD1_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD0_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD0_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_QSPI_AXI_WR_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_QSPI_AXI_WR_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_PMCMAIN_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_PMCMAIN_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD1_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD1_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD0_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_SD0_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_QSPI_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_IDR, INTIOU_PMX_QSPI_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_SLV_AXI_ERR_ITR, 0xa24)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_PMCMAIN_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_PMCMAIN_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD1_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD1_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD0_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD0_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_QSPI_AXI_WR_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_QSPI_AXI_WR_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_PMCMAIN_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_PMCMAIN_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD1_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD1_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD0_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_SD0_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_QSPI_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_SLV_AXI_ERR_ITR, INTIOU_PMX_QSPI_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_MST_AXI_ERR_ISR, 0xa28)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, PMCMAIN_INTIOUPMX_AXI_WR_DEC_ERR, 19, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, PMCMAIN_INTIOUPMX_AXI_WR_SLV_ERR, 18, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD1_INTIOUPMX_AXI_WR_DEC_ERR, 17, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD1_INTIOUPMX_AXI_WR_SLV_ERR, 16, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD0_INTIOUPMX_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD0_INTIOUPMX_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, OSPI_INTIOUPMX_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, OSPI_INTIOUPMX_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, QSPI_INTIOUPMX_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, QSPI_INTIOUPMX_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, PMCMAIN_INTIOUPMX_AXI_RD_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, PMCMAIN_INTIOUPMX_AXI_RD_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD1_INTIOUPMX_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD1_INTIOUPMX_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD0_INTIOUPMX_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, SD0_INTIOUPMX_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, OSPI_INTIOUPMX_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, OSPI_INTIOUPMX_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, QSPI_INTIOUPMX_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ISR, QSPI_INTIOUPMX_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_MST_AXI_ERR_IMR, 0xa2c)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, PMCMAIN_INTIOUPMX_AXI_WR_DEC_ERR, 19, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, PMCMAIN_INTIOUPMX_AXI_WR_SLV_ERR, 18, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD1_INTIOUPMX_AXI_WR_DEC_ERR, 17, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD1_INTIOUPMX_AXI_WR_SLV_ERR, 16, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD0_INTIOUPMX_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD0_INTIOUPMX_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, OSPI_INTIOUPMX_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, OSPI_INTIOUPMX_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, QSPI_INTIOUPMX_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, QSPI_INTIOUPMX_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, PMCMAIN_INTIOUPMX_AXI_RD_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, PMCMAIN_INTIOUPMX_AXI_RD_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD1_INTIOUPMX_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD1_INTIOUPMX_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD0_INTIOUPMX_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, SD0_INTIOUPMX_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, OSPI_INTIOUPMX_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, OSPI_INTIOUPMX_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, QSPI_INTIOUPMX_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IMR, QSPI_INTIOUPMX_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_MST_AXI_ERR_IER, 0xa30)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, PMCMAIN_INTIOUPMX_AXI_WR_DEC_ERR, 19, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, PMCMAIN_INTIOUPMX_AXI_WR_SLV_ERR, 18, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD1_INTIOUPMX_AXI_WR_DEC_ERR, 17, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD1_INTIOUPMX_AXI_WR_SLV_ERR, 16, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD0_INTIOUPMX_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD0_INTIOUPMX_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, OSPI_INTIOUPMX_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, OSPI_INTIOUPMX_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, QSPI_INTIOUPMX_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, QSPI_INTIOUPMX_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, PMCMAIN_INTIOUPMX_AXI_RD_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, PMCMAIN_INTIOUPMX_AXI_RD_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD1_INTIOUPMX_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD1_INTIOUPMX_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD0_INTIOUPMX_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, SD0_INTIOUPMX_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, OSPI_INTIOUPMX_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, OSPI_INTIOUPMX_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, QSPI_INTIOUPMX_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IER, QSPI_INTIOUPMX_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_MST_AXI_ERR_IDR, 0xa34)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, PMCMAIN_INTIOUPMX_AXI_WR_DEC_ERR, 19, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, PMCMAIN_INTIOUPMX_AXI_WR_SLV_ERR, 18, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD1_INTIOUPMX_AXI_WR_DEC_ERR, 17, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD1_INTIOUPMX_AXI_WR_SLV_ERR, 16, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD0_INTIOUPMX_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD0_INTIOUPMX_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, OSPI_INTIOUPMX_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, OSPI_INTIOUPMX_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, QSPI_INTIOUPMX_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, QSPI_INTIOUPMX_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, PMCMAIN_INTIOUPMX_AXI_RD_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, PMCMAIN_INTIOUPMX_AXI_RD_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD1_INTIOUPMX_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD1_INTIOUPMX_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD0_INTIOUPMX_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, SD0_INTIOUPMX_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, OSPI_INTIOUPMX_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, OSPI_INTIOUPMX_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, QSPI_INTIOUPMX_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_IDR, QSPI_INTIOUPMX_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_MST_AXI_ERR_ITR, 0xa38)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, PMCMAIN_INTIOUPMX_AXI_WR_DEC_ERR, 19, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, PMCMAIN_INTIOUPMX_AXI_WR_SLV_ERR, 18, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD1_INTIOUPMX_AXI_WR_DEC_ERR, 17, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD1_INTIOUPMX_AXI_WR_SLV_ERR, 16, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD0_INTIOUPMX_AXI_WR_DEC_ERR, 15, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD0_INTIOUPMX_AXI_WR_SLV_ERR, 14, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, OSPI_INTIOUPMX_AXI_WR_DEC_ERR, 13, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, OSPI_INTIOUPMX_AXI_WR_SLV_ERR, 12, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, QSPI_INTIOUPMX_AXI_WR_DEC_ERR, 11, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, QSPI_INTIOUPMX_AXI_WR_SLV_ERR, 10, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, PMCMAIN_INTIOUPMX_AXI_RD_DEC_ERR, 9, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, PMCMAIN_INTIOUPMX_AXI_RD_SLV_ERR, 8, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD1_INTIOUPMX_AXI_RD_DEC_ERR, 7, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD1_INTIOUPMX_AXI_RD_SLV_ERR, 6, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD0_INTIOUPMX_AXI_RD_DEC_ERR, 5, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, SD0_INTIOUPMX_AXI_RD_SLV_ERR, 4, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, OSPI_INTIOUPMX_AXI_RD_DEC_ERR, 3, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, OSPI_INTIOUPMX_AXI_RD_SLV_ERR, 2, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, QSPI_INTIOUPMX_AXI_RD_DEC_ERR, 1, 1)
    FIELD(INTIOU_PMX_MST_AXI_ERR_ITR, QSPI_INTIOUPMX_AXI_RD_SLV_ERR, 0, 1)
REG32(INTIOU_PMX_APB_SLV_ERR_ENABLE, 0xa3c)
    FIELD(INTIOU_PMX_APB_SLV_ERR_ENABLE, IOUSLCR_SECURE_INTF_ERR_EN, 5, 1)
    FIELD(INTIOU_PMX_APB_SLV_ERR_ENABLE, IOUSLCR_INTF_ERR_EN, 4, 1)
    FIELD(INTIOU_PMX_APB_SLV_ERR_ENABLE, I2CI3C_INTF_ERR_EN, 3, 1)
    FIELD(INTIOU_PMX_APB_SLV_ERR_ENABLE, GPIO_INTF_ERR_EN, 2, 1)
    FIELD(INTIOU_PMX_APB_SLV_ERR_ENABLE, OSPI_INTF_ERR_EN, 1, 1)
    FIELD(INTIOU_PMX_APB_SLV_ERR_ENABLE, QSPI_INTF_ERR_EN, 0, 1)
REG32(INTIOU_PMX_APB_SLV_TEST_ENABLE, 0xa40)
    FIELD(INTIOU_PMX_APB_SLV_TEST_ENABLE, IOUSLCR_SECURE_SLVERR_INJ_EN, 5, 1)
    FIELD(INTIOU_PMX_APB_SLV_TEST_ENABLE, IOUSLCR_SLVERR_INJ_EN, 4, 1)
    FIELD(INTIOU_PMX_APB_SLV_TEST_ENABLE, I2CI3C_SLVERR_INJ_EN, 3, 1)
    FIELD(INTIOU_PMX_APB_SLV_TEST_ENABLE, GPIO_SLVERR_INJ_EN, 2, 1)
    FIELD(INTIOU_PMX_APB_SLV_TEST_ENABLE, OSPI_SLVERR_INJ_EN, 1, 1)
    FIELD(INTIOU_PMX_APB_SLV_TEST_ENABLE, QSPI_SLVERR_INJ_EN, 0, 1)
REG32(INTIOU_PMX_AXI_SLV_ERR_ENABLE, 0xa44)
    FIELD(INTIOU_PMX_AXI_SLV_ERR_ENABLE, PMCMAIN_INTF_ERR_EN, 3, 1)
    FIELD(INTIOU_PMX_AXI_SLV_ERR_ENABLE, SD1_INTF_ERR_EN, 2, 1)
    FIELD(INTIOU_PMX_AXI_SLV_ERR_ENABLE, SD0_INTF_ERR_EN, 1, 1)
    FIELD(INTIOU_PMX_AXI_SLV_ERR_ENABLE, QSPI_INTF_ERR_EN, 0, 1)
REG32(INTIOU_PMX_AXI_SLV_TEST_ENABLE, 0xa48)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, PMCMAIN_RD_INJ_DECERR_EN, 15, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, PMCMAIN_RD_INJ_SLVERR_EN, 14, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, PMCMAIN_WR_INJ_DECERR_EN, 13, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, PMCMAIN_WR_INJ_SLVERR_EN, 12, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD1_RD_INJ_DECERR_EN, 11, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD1_RD_INJ_SLVERR_EN, 10, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD1_WR_INJ_DECERR_EN, 9, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD1_WR_INJ_SLVERR_EN, 8, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD0_RD_INJ_DECERR_EN, 7, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD0_RD_INJ_SLVERR_EN, 6, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD0_WR_INJ_DECERR_EN, 5, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, SD0_WR_INJ_SLVERR_EN, 4, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, QSPI_RD_INJ_DECERR_EN, 3, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, QSPI_RD_INJ_SLVERR_EN, 2, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, QSPI_WR_INJ_DECERR_EN, 1, 1)
    FIELD(INTIOU_PMX_AXI_SLV_TEST_ENABLE, QSPI_WR_INJ_SLVERR_EN, 0, 1)
REG32(INTIOU_PMX_AXI_MST_ERR_ENABLE, 0xa4c)
    FIELD(INTIOU_PMX_AXI_MST_ERR_ENABLE, PMCMAIN_INTF_ERR_EN, 4, 1)
    FIELD(INTIOU_PMX_AXI_MST_ERR_ENABLE, SD1_INTF_ERR_EN, 3, 1)
    FIELD(INTIOU_PMX_AXI_MST_ERR_ENABLE, SD0_INTF_ERR_EN, 2, 1)
    FIELD(INTIOU_PMX_AXI_MST_ERR_ENABLE, OSPI_INTF_ERR_EN, 1, 1)
    FIELD(INTIOU_PMX_AXI_MST_ERR_ENABLE, QSPI_INTF_ERR_EN, 0, 1)
REG32(INTIOU_PMX_AXI_MST_TEST_ENABLE, 0xa50)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, PMCMAIN_RD_INJ_DECERR_EN, 19, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, PMCMAIN_RD_INJ_SLVERR_EN, 18, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, PMCMAIN_WR_INJ_DECERR_EN, 17, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, PMCMAIN_WR_INJ_SLVERR_EN, 16, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD1_RD_INJ_DECERR_EN, 15, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD1_RD_INJ_SLVERR_EN, 14, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD1_WR_INJ_DECERR_EN, 13, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD1_WR_INJ_SLVERR_EN, 12, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD0_RD_INJ_DECERR_EN, 11, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD0_RD_INJ_SLVERR_EN, 10, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD0_WR_INJ_DECERR_EN, 9, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, SD0_WR_INJ_SLVERR_EN, 8, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, OSPI_RD_INJ_DECERR_EN, 7, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, OSPI_RD_INJ_SLVERR_EN, 6, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, OSPI_WR_INJ_DECERR_EN, 5, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, OSPI_WR_INJ_SLVERR_EN, 4, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, QSPI_RD_INJ_DECERR_EN, 3, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, QSPI_RD_INJ_SLVERR_EN, 2, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, QSPI_WR_INJ_DECERR_EN, 1, 1)
    FIELD(INTIOU_PMX_AXI_MST_TEST_ENABLE, QSPI_WR_INJ_SLVERR_EN, 0, 1)

#define R_MAX (R_INTIOU_PMX_AXI_MST_TEST_ENABLE + 1)

typedef struct PMX_IOU_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_parity_imr;
    qemu_irq irq_intiou_pmx_mst_axi_err_imr;
    qemu_irq irq_intiou_pmx_slv_apb_err_imr;
    qemu_irq irq_imr;
    qemu_irq irq_intiou_pmx_slv_axi_err_imr;
    qemu_irq sd_emmc_sel[2];
    qemu_irq qspi_ospi_mux_sel;
    qemu_irq ospi_mux_sel;

    uint32_t regs[R_MAX];
    RegisterInfo regs_info[R_MAX];
} PMX_IOU_SLCR;

static void parity_imr_update_irq(PMX_IOU_SLCR *s)
{
    bool pending = s->regs[R_PARITY_ISR] & ~s->regs[R_PARITY_IMR];
    qemu_set_irq(s->irq_parity_imr, pending);
}

static void parity_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    parity_imr_update_irq(s);
}

static uint64_t parity_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PARITY_IMR] &= ~val;
    parity_imr_update_irq(s);
    return 0;
}

static uint64_t parity_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PARITY_IMR] |= val;
    parity_imr_update_irq(s);
    return 0;
}

static uint64_t parity_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PARITY_ISR] |= val;
    parity_imr_update_irq(s);
    return 0;
}

static void intiou_pmx_mst_axi_err_imr_update_irq(PMX_IOU_SLCR *s)
{
    bool pending = s->regs[R_INTIOU_PMX_MST_AXI_ERR_ISR] &
                   (~s->regs[R_INTIOU_PMX_MST_AXI_ERR_IMR]);
    qemu_set_irq(s->irq_intiou_pmx_mst_axi_err_imr, pending);
}

static void intiou_pmx_mst_axi_err_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    intiou_pmx_mst_axi_err_imr_update_irq(s);
}

static uint64_t intiou_pmx_mst_axi_err_ier_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_MST_AXI_ERR_IMR] &= ~val;
    intiou_pmx_mst_axi_err_imr_update_irq(s);
    return 0;
}

static uint64_t intiou_pmx_mst_axi_err_idr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_MST_AXI_ERR_IMR] |= val;
    intiou_pmx_mst_axi_err_imr_update_irq(s);
    return 0;
}

static uint64_t intiou_pmx_mst_axi_err_itr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_MST_AXI_ERR_ISR] |= val;
    intiou_pmx_mst_axi_err_imr_update_irq(s);
    return 0;
}

static void intiou_pmx_slv_apb_err_imr_update_irq(PMX_IOU_SLCR *s)
{
    bool pending = s->regs[R_INTIOU_PMX_SLV_APB_ERR_ISR] &
                   (~s->regs[R_INTIOU_PMX_SLV_APB_ERR_IMR]);
    qemu_set_irq(s->irq_intiou_pmx_slv_apb_err_imr, pending);
}

static void intiou_pmx_slv_apb_err_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    intiou_pmx_slv_apb_err_imr_update_irq(s);
}

static uint64_t intiou_pmx_slv_apb_err_ier_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_SLV_APB_ERR_IMR] &= ~val;
    intiou_pmx_slv_apb_err_imr_update_irq(s);
    return 0;
}

static uint64_t intiou_pmx_slv_apb_err_idr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_SLV_APB_ERR_IMR] |= val;
    intiou_pmx_slv_apb_err_imr_update_irq(s);
    return 0;
}

static uint64_t intiou_pmx_slv_apb_err_itr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_SLV_APB_ERR_ISR] |= val;
    intiou_pmx_slv_apb_err_imr_update_irq(s);
    return 0;
}

static void imr_update_irq(PMX_IOU_SLCR *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR] |= val;
    imr_update_irq(s);
    return 0;
}

static void intiou_pmx_slv_axi_err_imr_update_irq(PMX_IOU_SLCR *s)
{
    bool pending = s->regs[R_INTIOU_PMX_SLV_AXI_ERR_ISR] &
                   (~s->regs[R_INTIOU_PMX_SLV_AXI_ERR_IMR]);
    qemu_set_irq(s->irq_intiou_pmx_slv_axi_err_imr, pending);
}

static void intiou_pmx_slv_axi_err_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    intiou_pmx_slv_axi_err_imr_update_irq(s);
}

static uint64_t intiou_pmx_slv_axi_err_ier_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_SLV_AXI_ERR_IMR] &= ~val;
    intiou_pmx_slv_axi_err_imr_update_irq(s);
    return 0;
}

static uint64_t intiou_pmx_slv_axi_err_idr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_SLV_AXI_ERR_IMR] |= val;
    intiou_pmx_slv_axi_err_imr_update_irq(s);
    return 0;
}

static uint64_t intiou_pmx_slv_axi_err_itr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_INTIOU_PMX_SLV_AXI_ERR_ISR] |= val;
    intiou_pmx_slv_axi_err_imr_update_irq(s);
    return 0;
}

static uint64_t emmc_ctrl_reg_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t prev = ARRAY_FIELD_EX32(s->regs, EMMC_CTRL_REG, SD0_EMMC_SEL);

    if (prev != (val64 & R_EMMC_CTRL_REG_SD0_EMMC_SEL_MASK)) {
        qemu_set_irq(s->sd_emmc_sel[0], !!val64);
    }

    return val64;
}

static uint64_t sd1_ctrl_reg_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t prev = ARRAY_FIELD_EX32(s->regs, SD1_CTRL_REG, SD1_EMMC_SEL);

    if (prev != (val64 & R_SD1_CTRL_REG_SD1_EMMC_SEL_MASK)) {
        qemu_set_irq(s->sd_emmc_sel[1], !!val64);
    }

    return val64;
}

static uint64_t ospi_qspi_iou_axi_mux_sel_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(reg->opaque);
    uint32_t val32 = (uint32_t) val64;
    uint8_t ospi_mux_sel = FIELD_EX32(val32, OSPI_QSPI_IOU_AXI_MUX_SEL,
                                      OSPI_MUX_SEL);
    uint8_t qspi_ospi_mux_sel = FIELD_EX32(val32, OSPI_QSPI_IOU_AXI_MUX_SEL,
                                      QSPI_OSPI_MUX_SEL);

    if (ospi_mux_sel !=
        ARRAY_FIELD_EX32(s->regs, OSPI_QSPI_IOU_AXI_MUX_SEL, OSPI_MUX_SEL)) {
        qemu_set_irq(s->ospi_mux_sel, !!ospi_mux_sel);
    }

    if (qspi_ospi_mux_sel !=
        ARRAY_FIELD_EX32(s->regs, OSPI_QSPI_IOU_AXI_MUX_SEL,
                         QSPI_OSPI_MUX_SEL)) {
        qemu_set_irq(s->qspi_ospi_mux_sel, !!qspi_ospi_mux_sel);
    }

    return val64;
}

static const RegisterAccessInfo pmx_iou_slcr_regs_info[] = {
    {   .name = "MIO_PIN_0",  .addr = A_MIO_PIN_0,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_1",  .addr = A_MIO_PIN_1,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_2",  .addr = A_MIO_PIN_2,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_3",  .addr = A_MIO_PIN_3,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_4",  .addr = A_MIO_PIN_4,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_5",  .addr = A_MIO_PIN_5,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_6",  .addr = A_MIO_PIN_6,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_7",  .addr = A_MIO_PIN_7,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_8",  .addr = A_MIO_PIN_8,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_9",  .addr = A_MIO_PIN_9,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_10",  .addr = A_MIO_PIN_10,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_11",  .addr = A_MIO_PIN_11,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_12",  .addr = A_MIO_PIN_12,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_13",  .addr = A_MIO_PIN_13,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_14",  .addr = A_MIO_PIN_14,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_15",  .addr = A_MIO_PIN_15,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_16",  .addr = A_MIO_PIN_16,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_17",  .addr = A_MIO_PIN_17,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_18",  .addr = A_MIO_PIN_18,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_19",  .addr = A_MIO_PIN_19,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_20",  .addr = A_MIO_PIN_20,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_21",  .addr = A_MIO_PIN_21,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_22",  .addr = A_MIO_PIN_22,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_23",  .addr = A_MIO_PIN_23,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_24",  .addr = A_MIO_PIN_24,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_25",  .addr = A_MIO_PIN_25,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_26",  .addr = A_MIO_PIN_26,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_27",  .addr = A_MIO_PIN_27,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_28",  .addr = A_MIO_PIN_28,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_29",  .addr = A_MIO_PIN_29,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_30",  .addr = A_MIO_PIN_30,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_31",  .addr = A_MIO_PIN_31,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_32",  .addr = A_MIO_PIN_32,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_33",  .addr = A_MIO_PIN_33,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_34",  .addr = A_MIO_PIN_34,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_35",  .addr = A_MIO_PIN_35,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_36",  .addr = A_MIO_PIN_36,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_37",  .addr = A_MIO_PIN_37,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_38",  .addr = A_MIO_PIN_38,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_39",  .addr = A_MIO_PIN_39,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_40",  .addr = A_MIO_PIN_40,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_41",  .addr = A_MIO_PIN_41,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_42",  .addr = A_MIO_PIN_42,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_43",  .addr = A_MIO_PIN_43,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_44",  .addr = A_MIO_PIN_44,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_45",  .addr = A_MIO_PIN_45,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_46",  .addr = A_MIO_PIN_46,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_47",  .addr = A_MIO_PIN_47,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_48",  .addr = A_MIO_PIN_48,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_49",  .addr = A_MIO_PIN_49,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_50",  .addr = A_MIO_PIN_50,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_51",  .addr = A_MIO_PIN_51,
        .rsvd = 0xfffffc01,
    },{ .name = "BNK0_EN_RX_SCHMITT_HYST",  .addr = A_BNK0_EN_RX_SCHMITT_HYST,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_WK_PD",  .addr = A_BNK0_EN_WK_PD,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_WK_PU",  .addr = A_BNK0_EN_WK_PU,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_SEL_DRV0",  .addr = A_BNK0_SEL_DRV0,
        .reset = 0xaaaaaaaa,
    },{ .name = "BNK0_SEL_DRV1",  .addr = A_BNK0_SEL_DRV1,
        .reset = 0xaaaaa,
        .rsvd = 0xfff00000,
    },{ .name = "BNK0_SEL_SLEW",  .addr = A_BNK0_SEL_SLEW,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_VMODE",  .addr = A_BNK0_VMODE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "BNK0_SEL_AUX_IO_RX",  .addr = A_BNK0_SEL_AUX_IO_RX,
        .rsvd = 0xfc000000,
    },{ .name = "MIO_MST_TRI0",  .addr = A_MIO_MST_TRI0,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "MIO_MST_TRI1",  .addr = A_MIO_MST_TRI1,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_RX_SCHMITT_HYST",  .addr = A_BNK1_EN_RX_SCHMITT_HYST,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_WK_PD",  .addr = A_BNK1_EN_WK_PD,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_WK_PU",  .addr = A_BNK1_EN_WK_PU,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_SEL_DRV0",  .addr = A_BNK1_SEL_DRV0,
        .reset = 0xaaaaaaaa,
    },{ .name = "BNK1_SEL_DRV1",  .addr = A_BNK1_SEL_DRV1,
        .reset = 0xaaaaa,
        .rsvd = 0xfff00000,
    },{ .name = "BNK1_SEL_SLEW",  .addr = A_BNK1_SEL_SLEW,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_VMODE",  .addr = A_BNK1_VMODE,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "BNK1_SEL_AUX_IO_RX",  .addr = A_BNK1_SEL_AUX_IO_RX,
        .rsvd = 0xfc000000,
    },{ .name = "EMMC_CLK_CTRL",  .addr = A_EMMC_CLK_CTRL,
        .rsvd = 0xfffffff8,
    },{ .name = "EMMC_CTRL_REG",  .addr = A_EMMC_CTRL_REG,
        .rsvd = 0xfffffffe,
        .pre_write = emmc_ctrl_reg_prew,
    },{ .name = "EMMC_CONFIG_REG1",  .addr = A_EMMC_CONFIG_REG1,
        .reset = 0x3250,
        .rsvd = 0xffff8000,
    },{ .name = "EMMC_CONFIG_REG2",  .addr = A_EMMC_CONFIG_REG2,
        .reset = 0xffc,
        .rsvd = 0xffffc000,
    },{ .name = "EMMC_CONFIG_REG3",  .addr = A_EMMC_CONFIG_REG3,
        .reset = 0xc07,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_INITPRESET",  .addr = A_EMMC_INITPRESET,
        .reset = 0x100,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_DSPPRESET",  .addr = A_EMMC_DSPPRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_HSPDPRESET",  .addr = A_EMMC_HSPDPRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_SDR12PRESET",  .addr = A_EMMC_SDR12PRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_SDR25PRESET",  .addr = A_EMMC_SDR25PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_SDR50PRSET",  .addr = A_EMMC_SDR50PRSET,
        .reset = 0x1,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_SDR104PRST",  .addr = A_EMMC_SDR104PRST,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_DDR50PRESET",  .addr = A_EMMC_DDR50PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_MAXCUR1P8",  .addr = A_EMMC_MAXCUR1P8,
        .rsvd = 0xffffff00,
    },{ .name = "EMMC_MAXCUR3P0",  .addr = A_EMMC_MAXCUR3P0,
        .rsvd = 0xffffff00,
    },{ .name = "EMMC_MAXCUR3P3",  .addr = A_EMMC_MAXCUR3P3,
        .rsvd = 0xffffff00,
    },{ .name = "EMMC_CDN_CTRL",  .addr = A_EMMC_CDN_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "EMMC_IOU_COHERENT_CTRL",  .addr = A_EMMC_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "EMMC_IOU_INTERCONNECT_ROUTE",
        .addr = A_EMMC_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "EMMC_IOU_INTERCONNECT_QOS",
        .addr = A_EMMC_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "EMMC_HS400PRESET",  .addr = A_EMMC_HS400PRESET,
        .rsvd = 0xffffe000,
    },{ .name = "EMMC_CQ_FREQ",  .addr = A_EMMC_CQ_FREQ,
        .rsvd = 0xffffc000,
    },{ .name = "SD1_CLK_CTRL",  .addr = A_SD1_CLK_CTRL,
        .rsvd = 0xfffffffc,
    },{ .name = "SD1_CTRL_REG",  .addr = A_SD1_CTRL_REG,
        .rsvd = 0xfffffffe,
        .pre_write = sd1_ctrl_reg_prew,
    },{ .name = "SD1_CONFIG_REG1",  .addr = A_SD1_CONFIG_REG1,
        .reset = 0x3250,
        .rsvd = 0xffff8000,
    },{ .name = "SD1_CONFIG_REG2",  .addr = A_SD1_CONFIG_REG2,
        .reset = 0xffc,
        .rsvd = 0xffffc000,
    },{ .name = "SD1_CONFIG_REG3",  .addr = A_SD1_CONFIG_REG3,
        .reset = 0x407,
        .rsvd = 0xfffff800,
    },{ .name = "SD1_INITPRESET",  .addr = A_SD1_INITPRESET,
        .reset = 0x100,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_DSPPRESET",  .addr = A_SD1_DSPPRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_HSPDPRESET",  .addr = A_SD1_HSPDPRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR12PRESET",  .addr = A_SD1_SDR12PRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR25PRESET",  .addr = A_SD1_SDR25PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR50PRSET",  .addr = A_SD1_SDR50PRSET,
        .reset = 0x1,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR104PRST",  .addr = A_SD1_SDR104PRST,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_DDR50PRESET",  .addr = A_SD1_DDR50PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_MAXCUR1P8",  .addr = A_SD1_MAXCUR1P8,
        .rsvd = 0xffffff00,
    },{ .name = "SD1_MAXCUR3P0",  .addr = A_SD1_MAXCUR3P0,
        .rsvd = 0xffffff00,
    },{ .name = "SD1_MAXCUR3P3",  .addr = A_SD1_MAXCUR3P3,
        .rsvd = 0xffffff00,
    },{ .name = "SD1_DLL_CTRL",  .addr = A_SD1_DLL_CTRL,
        .reset = 0x1,
        .rsvd = 0xfffffc00,
        .ro = 0x19,
    },{ .name = "SD1_CDN_CTRL",  .addr = A_SD1_CDN_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "SD1_RX_TUNING_SEL",  .addr = A_SD1_RX_TUNING_SEL,
        .rsvd = 0xfffffe00,
        .ro = 0x1ff,
    },{ .name = "SD1_DLL_DIV_MAP0",  .addr = A_SD1_DLL_DIV_MAP0,
        .reset = 0x50505050,
    },{ .name = "SD1_IOU_COHERENT_CTRL",  .addr = A_SD1_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "SD1_IOU_INTERCONNECT_ROUTE",
        .addr = A_SD1_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "SD1_IOU_INTERCONNECT_QOS",  .addr = A_SD1_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_QSPI_IOU_AXI_MUX_SEL",
        .addr = A_OSPI_QSPI_IOU_AXI_MUX_SEL,
        .reset = 0x1,
        .rsvd = 0xfffffffc,
        .pre_write = ospi_qspi_iou_axi_mux_sel_prew,
    },{ .name = "QSPI_IOU_COHERENT_CTRL",  .addr = A_QSPI_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "QSPI_IOU_INTERCONNECT_ROUTE",
        .addr = A_QSPI_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "QSPI_IOU_INTERCONNECT_QOS",
        .addr = A_QSPI_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_IOU_COHERENT_CTRL",  .addr = A_OSPI_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_IOU_INTERCONNECT_ROUTE",
        .addr = A_OSPI_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "OSPI_IOU_INTERCONNECT_QOS",
        .addr = A_OSPI_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_IOU_RESETOUT_SEL",  .addr = A_OSPI_IOU_RESETOUT_SEL,
        .rsvd = 0xfffffffe,
    },{ .name = "I2C_I3C_CTRL",  .addr = A_I2C_I3C_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "USB0_CUR_PWR_ST",  .addr = A_USB0_CUR_PWR_ST,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "USB0_CONNECT_ST",  .addr = A_USB0_CONNECT_ST,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "USB1_CUR_PWR_ST",  .addr = A_USB1_CUR_PWR_ST,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "USB1_CONNECT_ST",  .addr = A_USB1_CONNECT_ST,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CTRL",  .addr = A_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "IER",  .addr = A_IER,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .pre_write = itr_prew,
    },{ .name = "PARITY_ISR",  .addr = A_PARITY_ISR,
        .w1c = 0x1fff,
        .post_write = parity_isr_postw,
    },{ .name = "PARITY_IMR",  .addr = A_PARITY_IMR,
        .reset = 0x1fff,
        .ro = 0x1fff,
    },{ .name = "PARITY_IER",  .addr = A_PARITY_IER,
        .pre_write = parity_ier_prew,
    },{ .name = "PARITY_IDR",  .addr = A_PARITY_IDR,
        .pre_write = parity_idr_prew,
    },{ .name = "PARITY_ITR",  .addr = A_PARITY_ITR,
        .pre_write = parity_itr_prew,
    },{ .name = "WPROT0",  .addr = A_WPROT0,
        .reset = 0x1,
    },{ .name = "INTIOU_PMX_SLV_APB_ERR_ISR",
        .addr = A_INTIOU_PMX_SLV_APB_ERR_ISR,
        .rsvd = 0xffffffc0,
        .w1c = 0xffffffff,
        .post_write = intiou_pmx_slv_apb_err_isr_postw,
    },{ .name = "INTIOU_PMX_SLV_APB_ERR_IMR",
        .addr = A_INTIOU_PMX_SLV_APB_ERR_IMR,
        .reset = 0x3f,
        .rsvd = 0xffffffc0,
        .ro = 0xffffffff,
    },{ .name = "INTIOU_PMX_SLV_APB_ERR_IER",
        .addr = A_INTIOU_PMX_SLV_APB_ERR_IER,
        .rsvd = 0xffffffc0,
        .pre_write = intiou_pmx_slv_apb_err_ier_prew,
    },{ .name = "INTIOU_PMX_SLV_APB_ERR_IDR",
        .addr = A_INTIOU_PMX_SLV_APB_ERR_IDR,
        .rsvd = 0xffffffc0,
        .pre_write = intiou_pmx_slv_apb_err_idr_prew,
    },{ .name = "INTIOU_PMX_SLV_APB_ERR_ITR",
        .addr = A_INTIOU_PMX_SLV_APB_ERR_ITR,
        .rsvd = 0xffffffc0,
        .pre_write = intiou_pmx_slv_apb_err_itr_prew,
    },{ .name = "INTIOU_PMX_SLV_AXI_ERR_ISR",
        .addr = A_INTIOU_PMX_SLV_AXI_ERR_ISR,
        .rsvd = 0xffff0000,
        .w1c = 0xffffffff,
        .post_write = intiou_pmx_slv_axi_err_isr_postw,
    },{ .name = "INTIOU_PMX_SLV_AXI_ERR_IMR",
        .addr = A_INTIOU_PMX_SLV_AXI_ERR_IMR,
        .reset = 0xffff,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "INTIOU_PMX_SLV_AXI_ERR_IER",
        .addr = A_INTIOU_PMX_SLV_AXI_ERR_IER,
        .rsvd = 0xffff0000,
        .pre_write = intiou_pmx_slv_axi_err_ier_prew,
    },{ .name = "INTIOU_PMX_SLV_AXI_ERR_IDR",
        .addr = A_INTIOU_PMX_SLV_AXI_ERR_IDR,
        .rsvd = 0xffff0000,
        .pre_write = intiou_pmx_slv_axi_err_idr_prew,
    },{ .name = "INTIOU_PMX_SLV_AXI_ERR_ITR",
        .addr = A_INTIOU_PMX_SLV_AXI_ERR_ITR,
        .rsvd = 0xffff0000,
        .pre_write = intiou_pmx_slv_axi_err_itr_prew,
    },{ .name = "INTIOU_PMX_MST_AXI_ERR_ISR",
        .addr = A_INTIOU_PMX_MST_AXI_ERR_ISR,
        .rsvd = 0xfff00000,
        .w1c = 0xffffffff,
        .post_write = intiou_pmx_mst_axi_err_isr_postw,
    },{ .name = "INTIOU_PMX_MST_AXI_ERR_IMR",
        .addr = A_INTIOU_PMX_MST_AXI_ERR_IMR,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "INTIOU_PMX_MST_AXI_ERR_IER",
        .addr = A_INTIOU_PMX_MST_AXI_ERR_IER,
        .rsvd = 0xfff00000,
        .pre_write = intiou_pmx_mst_axi_err_ier_prew,
    },{ .name = "INTIOU_PMX_MST_AXI_ERR_IDR",
        .addr = A_INTIOU_PMX_MST_AXI_ERR_IDR,
        .rsvd = 0xfff00000,
        .pre_write = intiou_pmx_mst_axi_err_idr_prew,
    },{ .name = "INTIOU_PMX_MST_AXI_ERR_ITR",
        .addr = A_INTIOU_PMX_MST_AXI_ERR_ITR,
        .rsvd = 0xfff00000,
        .pre_write = intiou_pmx_mst_axi_err_itr_prew,
    },{ .name = "INTIOU_PMX_APB_SLV_ERR_ENABLE",
        .addr = A_INTIOU_PMX_APB_SLV_ERR_ENABLE,
        .rsvd = 0xffffffc0,
    },{ .name = "INTIOU_PMX_APB_SLV_TEST_ENABLE",
        .addr = A_INTIOU_PMX_APB_SLV_TEST_ENABLE,
        .rsvd = 0xffffffc0,
    },{ .name = "INTIOU_PMX_AXI_SLV_ERR_ENABLE",
        .addr = A_INTIOU_PMX_AXI_SLV_ERR_ENABLE,
        .rsvd = 0xfffffff0,
    },{ .name = "INTIOU_PMX_AXI_SLV_TEST_ENABLE",
        .addr = A_INTIOU_PMX_AXI_SLV_TEST_ENABLE,
        .rsvd = 0xffff0000,
    },{ .name = "INTIOU_PMX_AXI_MST_ERR_ENABLE",
        .addr = A_INTIOU_PMX_AXI_MST_ERR_ENABLE,
        .rsvd = 0xffffffe0,
    },{ .name = "INTIOU_PMX_AXI_MST_TEST_ENABLE",
        .addr = A_INTIOU_PMX_AXI_MST_TEST_ENABLE,
        .rsvd = 0xfff00000,
    }
};

static void pmx_iou_slcr_reset(DeviceState *dev)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    parity_imr_update_irq(s);
    intiou_pmx_mst_axi_err_imr_update_irq(s);
    intiou_pmx_slv_apb_err_imr_update_irq(s);
    imr_update_irq(s);
    intiou_pmx_slv_axi_err_imr_update_irq(s);
    qemu_set_irq(s->ospi_mux_sel, 0);
    qemu_set_irq(s->qspi_ospi_mux_sel, 1);
}

static const MemoryRegionOps pmx_iou_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmx_iou_slcr_realize(DeviceState *dev, Error **errp)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(dev);

    qdev_init_gpio_out(dev, s->sd_emmc_sel, 2);
    qdev_init_gpio_out(dev, &s->qspi_ospi_mux_sel, 1);
    qdev_init_gpio_out(dev, &s->ospi_mux_sel, 1);
}

static void pmx_iou_slcr_init(Object *obj)
{
    PMX_IOU_SLCR *s = XILINX_PMX_IOU_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMX_IOU_SLCR, R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmx_iou_slcr_regs_info,
                              ARRAY_SIZE(pmx_iou_slcr_regs_info),
                              s->regs_info, s->regs,
                              &pmx_iou_slcr_ops,
                              XILINX_PMX_IOU_SLCR_ERR_DEBUG,
                              R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_parity_imr);
    sysbus_init_irq(sbd, &s->irq_intiou_pmx_mst_axi_err_imr);
    sysbus_init_irq(sbd, &s->irq_intiou_pmx_slv_apb_err_imr);
    sysbus_init_irq(sbd, &s->irq_imr);
    sysbus_init_irq(sbd, &s->irq_intiou_pmx_slv_axi_err_imr);
}

static const VMStateDescription vmstate_pmx_iou_slcr = {
    .name = TYPE_XILINX_PMX_IOU_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMX_IOU_SLCR, R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmx_iou_slcr_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pmx_iou_slcr_reset;
    dc->realize = pmx_iou_slcr_realize;
    dc->vmsd = &vmstate_pmx_iou_slcr;
}

static const TypeInfo pmx_iou_slcr_info = {
    .name          = TYPE_XILINX_PMX_IOU_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMX_IOU_SLCR),
    .class_init    = pmx_iou_slcr_class_init,
    .instance_init = pmx_iou_slcr_init,
};

static void pmx_iou_slcr_register_types(void)
{
    type_register_static(&pmx_iou_slcr_info);
}

type_init(pmx_iou_slcr_register_types)
