/*
 * QEMU model of the NOC_NCRB Noc Clock Re-convergent Buffer
 *
 * Copyright (c) 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-06-26.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_NOC_NCRB_ERR_DEBUG
#define XILINX_NOC_NCRB_ERR_DEBUG 0
#endif

#define TYPE_XILINX_NOC_NCRB "xlnx.noc_ncrb"

#define XILINX_NOC_NCRB(obj) \
     OBJECT_CHECK(NOC_NCRB, (obj), TYPE_XILINX_NOC_NCRB)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, STARTCAL, 10, 1)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE, 2, 2)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, STARTCAL, 10, 1)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE, 2, 2)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_ITR, 0x40)
    FIELD(REG_ITR, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_ITR, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_ITR, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_ITR, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_ITR, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_ITR, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_ITR, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_ITR, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_ITR, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_ITR, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_ITR, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_ITR, P1_PARITY_ERR, 1, 1)
    FIELD(REG_ITR, P0_PARITY_ERR, 0, 1)
REG32(REG_ISR, 0x44)
    FIELD(REG_ISR, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_ISR, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_ISR, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_ISR, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_ISR, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_ISR, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_ISR, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_ISR, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_ISR, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_ISR, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_ISR, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_ISR, P1_PARITY_ERR, 1, 1)
    FIELD(REG_ISR, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR0, 0x48)
    FIELD(REG_IMR0, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IMR0, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IMR0, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IMR0, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IMR0, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR0, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR0, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR0, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR0, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR0, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR0, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR0, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR0, P0_PARITY_ERR, 0, 1)
REG32(REG_IER0, 0x4c)
    FIELD(REG_IER0, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IER0, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IER0, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IER0, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IER0, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER0, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER0, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER0, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER0, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER0, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER0, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER0, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER0, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR0, 0x50)
    FIELD(REG_IDR0, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IDR0, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IDR0, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IDR0, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IDR0, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR0, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR0, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR0, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR0, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR0, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR0, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR0, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR0, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR1, 0x54)
    FIELD(REG_IMR1, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IMR1, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IMR1, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IMR1, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IMR1, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR1, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR1, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR1, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR1, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR1, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR1, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR1, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR1, P0_PARITY_ERR, 0, 1)
REG32(REG_IER1, 0x58)
    FIELD(REG_IER1, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IER1, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IER1, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IER1, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IER1, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER1, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER1, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER1, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER1, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER1, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER1, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER1, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER1, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR1, 0x5c)
    FIELD(REG_IDR1, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IDR1, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IDR1, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IDR1, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IDR1, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR1, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR1, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR1, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR1, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR1, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR1, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR1, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR1, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR2, 0x60)
    FIELD(REG_IMR2, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IMR2, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IMR2, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IMR2, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IMR2, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR2, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR2, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR2, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR2, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR2, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR2, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR2, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR2, P0_PARITY_ERR, 0, 1)
REG32(REG_IER2, 0x64)
    FIELD(REG_IER2, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IER2, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IER2, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IER2, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IER2, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER2, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER2, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER2, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER2, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER2, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER2, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER2, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER2, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR2, 0x68)
    FIELD(REG_IDR2, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IDR2, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IDR2, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IDR2, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IDR2, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR2, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR2, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR2, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR2, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR2, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR2, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR2, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR2, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR3, 0x6c)
    FIELD(REG_IMR3, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IMR3, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IMR3, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IMR3, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IMR3, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR3, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR3, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR3, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR3, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR3, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR3, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR3, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR3, P0_PARITY_ERR, 0, 1)
REG32(REG_IER3, 0x70)
    FIELD(REG_IER3, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IER3, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IER3, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IER3, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IER3, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER3, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER3, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER3, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER3, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER3, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER3, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER3, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER3, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR3, 0x74)
    FIELD(REG_IDR3, P1_R2W_EB_CAL_ERR, 28, 1)
    FIELD(REG_IDR3, P1_W2R_EB_CAL_ERR, 27, 1)
    FIELD(REG_IDR3, P0_R2W_EB_CAL_ERR, 26, 1)
    FIELD(REG_IDR3, P0_W2R_EB_CAL_ERR, 25, 1)
    FIELD(REG_IDR3, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR3, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR3, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR3, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR3, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR3, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR3, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR3, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR3, P0_PARITY_ERR, 0, 1)
REG32(REG_IOR, 0x78)
    FIELD(REG_IOR, OFFSET, 0, 5)
REG32(REG_PIPE_MODE, 0x100)
    FIELD(REG_PIPE_MODE, SEL, 0, 1)
REG32(REG_P0_0_VCA_TOKEN, 0x200)
    FIELD(REG_P0_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P0_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P0_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P0_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P0_1_VCA_TOKEN, 0x204)
    FIELD(REG_P0_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P0_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P0_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P0_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P1_0_VCA_TOKEN, 0x208)
    FIELD(REG_P1_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P1_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P1_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P1_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P1_1_VCA_TOKEN, 0x20c)
    FIELD(REG_P1_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P1_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P1_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P1_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P0_W2R_EB_CTRL, 0x210)
    FIELD(REG_P0_W2R_EB_CTRL, CAL_MAX_NUM_MATCH_CYCLES, 11, 10)
    FIELD(REG_P0_W2R_EB_CTRL, CAL_PTR_SEPARATION_END, 8, 3)
    FIELD(REG_P0_W2R_EB_CTRL, CAL_PTR_SEPARATION_START, 5, 3)
    FIELD(REG_P0_W2R_EB_CTRL, IGNORECAL, 4, 1)
    FIELD(REG_P0_W2R_EB_CTRL, DISABLECAL, 3, 1)
    FIELD(REG_P0_W2R_EB_CTRL, PTR_SEPARATION, 0, 3)
REG32(REG_P0_R2W_EB_CTRL, 0x214)
    FIELD(REG_P0_R2W_EB_CTRL, CAL_MAX_NUM_MATCH_CYCLES, 11, 10)
    FIELD(REG_P0_R2W_EB_CTRL, CAL_PTR_SEPARATION_END, 8, 3)
    FIELD(REG_P0_R2W_EB_CTRL, CAL_PTR_SEPARATION_START, 5, 3)
    FIELD(REG_P0_R2W_EB_CTRL, IGNORECAL, 4, 1)
    FIELD(REG_P0_R2W_EB_CTRL, DISABLECAL, 3, 1)
    FIELD(REG_P0_R2W_EB_CTRL, PTR_SEPARATION, 0, 3)
REG32(REG_P1_W2R_EB_CTRL, 0x218)
    FIELD(REG_P1_W2R_EB_CTRL, CAL_MAX_NUM_MATCH_CYCLES, 11, 10)
    FIELD(REG_P1_W2R_EB_CTRL, CAL_PTR_SEPARATION_END, 8, 3)
    FIELD(REG_P1_W2R_EB_CTRL, CAL_PTR_SEPARATION_START, 5, 3)
    FIELD(REG_P1_W2R_EB_CTRL, IGNORECAL, 4, 1)
    FIELD(REG_P1_W2R_EB_CTRL, DISABLECAL, 3, 1)
    FIELD(REG_P1_W2R_EB_CTRL, PTR_SEPARATION, 0, 3)
REG32(REG_P1_R2W_EB_CTRL, 0x21c)
    FIELD(REG_P1_R2W_EB_CTRL, CAL_MAX_NUM_MATCH_CYCLES, 11, 10)
    FIELD(REG_P1_R2W_EB_CTRL, CAL_PTR_SEPARATION_END, 8, 3)
    FIELD(REG_P1_R2W_EB_CTRL, CAL_PTR_SEPARATION_START, 5, 3)
    FIELD(REG_P1_R2W_EB_CTRL, IGNORECAL, 4, 1)
    FIELD(REG_P1_R2W_EB_CTRL, DISABLECAL, 3, 1)
    FIELD(REG_P1_R2W_EB_CTRL, PTR_SEPARATION, 0, 3)
REG32(REG_NOC_CLK_GATE_DIS, 0x220)
    FIELD(REG_NOC_CLK_GATE_DIS, NCRB, 0, 1)
REG32(REG_PORT_STATUS, 0x224)
    FIELD(REG_PORT_STATUS, P1_BUSY, 1, 1)
    FIELD(REG_PORT_STATUS, P0_BUSY, 0, 1)
REG32(REG_EB_CAL_PTR_SEPARATION, 0x228)
    FIELD(REG_EB_CAL_PTR_SEPARATION, P1_R2W, 9, 3)
    FIELD(REG_EB_CAL_PTR_SEPARATION, P1_W2R, 6, 3)
    FIELD(REG_EB_CAL_PTR_SEPARATION, P0_R2W, 3, 3)
    FIELD(REG_EB_CAL_PTR_SEPARATION, P0_W2R, 0, 3)
REG32(REG_W2R_EB_CAL_PATTERN_1, 0x22c)
    FIELD(REG_W2R_EB_CAL_PATTERN_1, VAL3, 24, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_1, VAL2, 16, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_1, VAL1, 8, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_1, VAL0, 0, 5)
REG32(REG_W2R_EB_CAL_PATTERN_2, 0x230)
    FIELD(REG_W2R_EB_CAL_PATTERN_2, VAL7, 24, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_2, VAL6, 16, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_2, VAL5, 8, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_2, VAL4, 0, 5)
REG32(REG_W2R_EB_CAL_PATTERN_3, 0x234)
    FIELD(REG_W2R_EB_CAL_PATTERN_3, VAL11, 24, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_3, VAL10, 16, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_3, VAL9, 8, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_3, VAL8, 0, 5)
REG32(REG_W2R_EB_CAL_PATTERN_4, 0x238)
    FIELD(REG_W2R_EB_CAL_PATTERN_4, VAL15, 24, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_4, VAL14, 16, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_4, VAL13, 8, 5)
    FIELD(REG_W2R_EB_CAL_PATTERN_4, VAL12, 0, 5)
REG32(REG_R2W_EB_CAL_PATTERN_1, 0x23c)
    FIELD(REG_R2W_EB_CAL_PATTERN_1, VAL3, 24, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_1, VAL2, 16, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_1, VAL1, 8, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_1, VAL0, 0, 8)
REG32(REG_R2W_EB_CAL_PATTERN_2, 0x240)
    FIELD(REG_R2W_EB_CAL_PATTERN_2, VAL7, 24, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_2, VAL6, 16, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_2, VAL5, 8, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_2, VAL4, 0, 8)
REG32(REG_R2W_EB_CAL_PATTERN_3, 0x244)
    FIELD(REG_R2W_EB_CAL_PATTERN_3, VAL11, 24, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_3, VAL10, 16, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_3, VAL9, 8, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_3, VAL8, 0, 8)
REG32(REG_R2W_EB_CAL_PATTERN_4, 0x248)
    FIELD(REG_R2W_EB_CAL_PATTERN_4, VAL15, 24, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_4, VAL14, 16, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_4, VAL13, 8, 8)
    FIELD(REG_R2W_EB_CAL_PATTERN_4, VAL12, 0, 8)
REG32(REG_P0_CTL, 0x24c)
    FIELD(REG_P0_CTL, PERF_MON_VC_SEL, 5, 3)
    FIELD(REG_P0_CTL, PERF_MON_MODE, 4, 1)
    FIELD(REG_P0_CTL, EN_PERF_MON, 3, 1)
    FIELD(REG_P0_CTL, TB_SEL, 0, 3)
REG32(REG_P0_0_PERF_MON, 0x250)
REG32(REG_P0_1_PERF_MON, 0x254)
    FIELD(REG_P0_1_PERF_MON, OVF, 31, 1)
    FIELD(REG_P0_1_PERF_MON, COUNT1, 0, 31)
REG32(REG_P1_CTL, 0x258)
    FIELD(REG_P1_CTL, PERF_MON_VC_SEL, 5, 3)
    FIELD(REG_P1_CTL, PERF_MON_MODE, 4, 1)
    FIELD(REG_P1_CTL, EN_PERF_MON, 3, 1)
    FIELD(REG_P1_CTL, TB_SEL, 0, 3)
REG32(REG_P1_0_PERF_MON, 0x25c)
REG32(REG_P1_1_PERF_MON, 0x260)
    FIELD(REG_P1_1_PERF_MON, OVF, 31, 1)
    FIELD(REG_P1_1_PERF_MON, COUNT1, 0, 31)
REG32(REG_ERR_LOG_EN, 0x264)
    FIELD(REG_ERR_LOG_EN, VC_BUF_OVF_ERR, 5, 1)
    FIELD(REG_ERR_LOG_EN, CRDT_OVF_ERR, 3, 1)
    FIELD(REG_ERR_LOG_EN, CRDT_RDY_ERR, 2, 1)
    FIELD(REG_ERR_LOG_EN, PAR_ERR, 0, 1)
REG32(REG_ERR_LOG_P0_1ST_ERR_NUM, 0x268)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, ETYP, 20, 2)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_ERR_LOG_P0_INFO_0, 0x26c)
    FIELD(REG_ERR_LOG_P0_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_P0_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_P0_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_P0_INFO_1, 0x270)
    FIELD(REG_ERR_LOG_P0_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_P0_INFO_1, WRSTB, 8, 16)
    FIELD(REG_ERR_LOG_P0_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_P0_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_P0_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_P0_INFO_1, PACKET_TYPE, 0, 4)
REG32(REG_ERR_LOG_P0_INFO_2, 0x274)
    FIELD(REG_ERR_LOG_P0_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_P0_INFO_2, VC, 0, 8)
REG32(REG_ERR_LOG_P1_1ST_ERR_NUM, 0x278)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, ETYP, 20, 2)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_ERR_LOG_P1_INFO_0, 0x27c)
    FIELD(REG_ERR_LOG_P1_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_P1_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_P1_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_P1_INFO_1, 0x280)
    FIELD(REG_ERR_LOG_P1_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_P1_INFO_1, WRSTB, 8, 16)
    FIELD(REG_ERR_LOG_P1_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_P1_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_P1_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_P1_INFO_1, PACKET_TYPE, 0, 4)
REG32(REG_ERR_LOG_P1_INFO_2, 0x284)
    FIELD(REG_ERR_LOG_P1_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_P1_INFO_2, VC, 0, 8)
REG32(REG_P0_W2R_EB_CAL_DBG_1, 0x288)
    FIELD(REG_P0_W2R_EB_CAL_DBG_1, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_W2R_EB_CAL_DBG_1, ACTUAL, 12, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_1, EXPECTED, 4, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_1, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_W2R_EB_CAL_DBG_1, VALID, 0, 1)
REG32(REG_P0_W2R_EB_CAL_DBG_2, 0x28c)
    FIELD(REG_P0_W2R_EB_CAL_DBG_2, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_W2R_EB_CAL_DBG_2, ACTUAL, 12, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_2, EXPECTED, 4, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_2, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_W2R_EB_CAL_DBG_2, VALID, 0, 1)
REG32(REG_P0_W2R_EB_CAL_DBG_3, 0x290)
    FIELD(REG_P0_W2R_EB_CAL_DBG_3, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_W2R_EB_CAL_DBG_3, ACTUAL, 12, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_3, EXPECTED, 4, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_3, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_W2R_EB_CAL_DBG_3, VALID, 0, 1)
REG32(REG_P0_W2R_EB_CAL_DBG_4, 0x294)
    FIELD(REG_P0_W2R_EB_CAL_DBG_4, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_W2R_EB_CAL_DBG_4, ACTUAL, 12, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_4, EXPECTED, 4, 5)
    FIELD(REG_P0_W2R_EB_CAL_DBG_4, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_W2R_EB_CAL_DBG_4, VALID, 0, 1)
REG32(REG_P0_R2W_EB_CAL_DBG_1, 0x298)
    FIELD(REG_P0_R2W_EB_CAL_DBG_1, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_R2W_EB_CAL_DBG_1, ACTUAL, 12, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_1, EXPECTED, 4, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_1, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_R2W_EB_CAL_DBG_1, VALID, 0, 1)
REG32(REG_P0_R2W_EB_CAL_DBG_2, 0x29c)
    FIELD(REG_P0_R2W_EB_CAL_DBG_2, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_R2W_EB_CAL_DBG_2, ACTUAL, 12, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_2, EXPECTED, 4, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_2, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_R2W_EB_CAL_DBG_2, VALID, 0, 1)
REG32(REG_P0_R2W_EB_CAL_DBG_3, 0x2a0)
    FIELD(REG_P0_R2W_EB_CAL_DBG_3, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_R2W_EB_CAL_DBG_3, ACTUAL, 12, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_3, EXPECTED, 4, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_3, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_R2W_EB_CAL_DBG_3, VALID, 0, 1)
REG32(REG_P0_R2W_EB_CAL_DBG_4, 0x2a4)
    FIELD(REG_P0_R2W_EB_CAL_DBG_4, CYCLE_NUM, 20, 10)
    FIELD(REG_P0_R2W_EB_CAL_DBG_4, ACTUAL, 12, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_4, EXPECTED, 4, 8)
    FIELD(REG_P0_R2W_EB_CAL_DBG_4, PTR_SEPARATION, 1, 3)
    FIELD(REG_P0_R2W_EB_CAL_DBG_4, VALID, 0, 1)
REG32(REG_P1_W2R_EB_CAL_DBG_1, 0x2a8)
    FIELD(REG_P1_W2R_EB_CAL_DBG_1, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_W2R_EB_CAL_DBG_1, ACTUAL, 12, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_1, EXPECTED, 4, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_1, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_W2R_EB_CAL_DBG_1, VALID, 0, 1)
REG32(REG_P1_W2R_EB_CAL_DBG_2, 0x2ac)
    FIELD(REG_P1_W2R_EB_CAL_DBG_2, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_W2R_EB_CAL_DBG_2, ACTUAL, 12, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_2, EXPECTED, 4, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_2, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_W2R_EB_CAL_DBG_2, VALID, 0, 1)
REG32(REG_P1_W2R_EB_CAL_DBG_3, 0x2b0)
    FIELD(REG_P1_W2R_EB_CAL_DBG_3, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_W2R_EB_CAL_DBG_3, ACTUAL, 12, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_3, EXPECTED, 4, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_3, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_W2R_EB_CAL_DBG_3, VALID, 0, 1)
REG32(REG_P1_W2R_EB_CAL_DBG_4, 0x2b4)
    FIELD(REG_P1_W2R_EB_CAL_DBG_4, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_W2R_EB_CAL_DBG_4, ACTUAL, 12, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_4, EXPECTED, 4, 5)
    FIELD(REG_P1_W2R_EB_CAL_DBG_4, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_W2R_EB_CAL_DBG_4, VALID, 0, 1)
REG32(REG_P1_R2W_EB_CAL_DBG_1, 0x2b8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_1, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_R2W_EB_CAL_DBG_1, ACTUAL, 12, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_1, EXPECTED, 4, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_1, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_R2W_EB_CAL_DBG_1, VALID, 0, 1)
REG32(REG_P1_R2W_EB_CAL_DBG_2, 0x2bc)
    FIELD(REG_P1_R2W_EB_CAL_DBG_2, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_R2W_EB_CAL_DBG_2, ACTUAL, 12, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_2, EXPECTED, 4, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_2, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_R2W_EB_CAL_DBG_2, VALID, 0, 1)
REG32(REG_P1_R2W_EB_CAL_DBG_3, 0x2c0)
    FIELD(REG_P1_R2W_EB_CAL_DBG_3, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_R2W_EB_CAL_DBG_3, ACTUAL, 12, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_3, EXPECTED, 4, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_3, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_R2W_EB_CAL_DBG_3, VALID, 0, 1)
REG32(REG_P1_R2W_EB_CAL_DBG_4, 0x2c4)
    FIELD(REG_P1_R2W_EB_CAL_DBG_4, CYCLE_NUM, 20, 10)
    FIELD(REG_P1_R2W_EB_CAL_DBG_4, ACTUAL, 12, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_4, EXPECTED, 4, 8)
    FIELD(REG_P1_R2W_EB_CAL_DBG_4, PTR_SEPARATION, 1, 3)
    FIELD(REG_P1_R2W_EB_CAL_DBG_4, VALID, 0, 1)
REG32(REG_DBG_MUX_CTRL_WCLK, 0x2c8)
    FIELD(REG_DBG_MUX_CTRL_WCLK, DAT_DISC, 8, 1)
    FIELD(REG_DBG_MUX_CTRL_WCLK, POST_TRIG_CNT, 5, 3)
    FIELD(REG_DBG_MUX_CTRL_WCLK, CLK_DIV, 4, 1)
    FIELD(REG_DBG_MUX_CTRL_WCLK, TRIG_EN, 3, 1)
    FIELD(REG_DBG_MUX_CTRL_WCLK, DBG_EN, 2, 1)
    FIELD(REG_DBG_MUX_CTRL_WCLK, IN_SEL, 1, 1)
REG32(REG_DBG_MUX_CTRL_RCLK, 0x2cc)
    FIELD(REG_DBG_MUX_CTRL_RCLK, DAT_DISC, 8, 1)
    FIELD(REG_DBG_MUX_CTRL_RCLK, POST_TRIG_CNT, 5, 3)
    FIELD(REG_DBG_MUX_CTRL_RCLK, CLK_DIV, 4, 1)
    FIELD(REG_DBG_MUX_CTRL_RCLK, TRIG_EN, 3, 1)
    FIELD(REG_DBG_MUX_CTRL_RCLK, DBG_EN, 2, 1)
    FIELD(REG_DBG_MUX_CTRL_RCLK, IN_SEL, 1, 1)
REG32(REG_DBG_MUX_STATUS, 0x2d0)
    FIELD(REG_DBG_MUX_STATUS, RCLK_TRIG_DONE, 1, 1)
    FIELD(REG_DBG_MUX_STATUS, WCLK_TRIG_DONE, 0, 1)
REG32(REG_DBG_WCLK, 0x2d4)
    FIELD(REG_DBG_WCLK, CNTRL_SEL, 13, 2)
    FIELD(REG_DBG_WCLK, FLIT_IN_SEL, 7, 6)
    FIELD(REG_DBG_WCLK, CNTRL_IN_SEL, 6, 1)
    FIELD(REG_DBG_WCLK, R2W_EB_CAL_DATA_SEL, 4, 2)
    FIELD(REG_DBG_WCLK, R2W_EB_DATA_OUT_SEL, 3, 1)
    FIELD(REG_DBG_WCLK, W2R_EB_CAL_ST_SEL, 2, 1)
    FIELD(REG_DBG_WCLK, W2R_EB_DATA_IN_SEL, 1, 1)
    FIELD(REG_DBG_WCLK, PORT_SEL, 0, 1)
REG32(REG_DBG_RCLK, 0x2d8)
    FIELD(REG_DBG_RCLK, FLIT_OUT_SEL, 12, 6)
    FIELD(REG_DBG_RCLK, CNTRL_OUT_SEL, 9, 3)
    FIELD(REG_DBG_RCLK, CNTRL_SEL, 7, 2)
    FIELD(REG_DBG_RCLK, CNTRL_IN_SEL, 6, 1)
    FIELD(REG_DBG_RCLK, W2R_EB_CAL_DATA_SEL, 4, 2)
    FIELD(REG_DBG_RCLK, W2R_EB_DATA_OUT_SEL, 3, 1)
    FIELD(REG_DBG_RCLK, R2W_EB_CAL_ST_SEL, 2, 1)
    FIELD(REG_DBG_RCLK, R2W_EB_DATA_IN_SEL, 1, 1)
    FIELD(REG_DBG_RCLK, PORT_SEL, 0, 1)
REG32(REG_DBG_TRIG_WCLK, 0x2dc)
    FIELD(REG_DBG_TRIG_WCLK, VC_RDEN_WR, 20, 8)
    FIELD(REG_DBG_TRIG_WCLK, BUF_OVF, 12, 8)
    FIELD(REG_DBG_TRIG_WCLK, VC_VLD_IN, 4, 8)
    FIELD(REG_DBG_TRIG_WCLK, W2R_EB_STATE, 0, 4)
REG32(REG_DBG_TRIG_RCLK_0, 0x2e0)
    FIELD(REG_DBG_TRIG_RCLK_0, PAR_ERR, 29, 1)
    FIELD(REG_DBG_TRIG_RCLK_0, BUSY, 28, 1)
    FIELD(REG_DBG_TRIG_RCLK_0, INIT, 20, 8)
    FIELD(REG_DBG_TRIG_RCLK_0, VC_NOT_EMPTY, 12, 8)
    FIELD(REG_DBG_TRIG_RCLK_0, EB_VC_VLD_IN, 4, 8)
    FIELD(REG_DBG_TRIG_RCLK_0, R2W_EB_STATE, 0, 4)
REG32(REG_DBG_TRIG_RCLK_1, 0x2e4)
    FIELD(REG_DBG_TRIG_RCLK_1, CREDIT_ZERO, 24, 8)
    FIELD(REG_DBG_TRIG_RCLK_1, VC_VLD_OUT, 16, 8)
    FIELD(REG_DBG_TRIG_RCLK_1, GRANT, 8, 8)
    FIELD(REG_DBG_TRIG_RCLK_1, VC_WREN_RD, 0, 8)

#define NOC_NCRB_R_MAX (R_REG_DBG_TRIG_RCLK_1 + 1)

typedef struct NOC_NCRB {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[NOC_NCRB_R_MAX];
    RegisterInfo regs_info[NOC_NCRB_R_MAX];
} NOC_NCRB;

static const RegisterAccessInfo noc_ncrb_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xfee47b30,
        .ro = 0xe47b30,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x100000c,
        .rsvd = 0xfee47b30,
        .ro = 0xe47b30,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_PCSRLOCK_MASK |
                 R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK |
                 R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK |
                 R_REG_PCSR_STATUS_CALDONE_MASK,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ITR",  .addr = A_REG_ITR,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_ISR",  .addr = A_REG_ISR,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
        .w1c = 0x1e133303,
    },{ .name = "REG_IMR0",  .addr = A_REG_IMR0,
        .reset = 0x1e033303,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER0",  .addr = A_REG_IER0,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IDR0",  .addr = A_REG_IDR0,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IMR1",  .addr = A_REG_IMR1,
        .reset = 0x1e133303,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER1",  .addr = A_REG_IER1,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IDR1",  .addr = A_REG_IDR1,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IMR2",  .addr = A_REG_IMR2,
        .reset = 0x1e133303,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER2",  .addr = A_REG_IER2,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IDR2",  .addr = A_REG_IDR2,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IMR3",  .addr = A_REG_IMR3,
        .reset = 0x1e133303,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER3",  .addr = A_REG_IER3,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IDR3",  .addr = A_REG_IDR3,
        .rsvd = 0xe1ecccfc,
        .ro = 0x1ecccfc,
    },{ .name = "REG_IOR",  .addr = A_REG_IOR,
        .reset = 0x10,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_PIPE_MODE",  .addr = A_REG_PIPE_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_P0_0_VCA_TOKEN",  .addr = A_REG_P0_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P0_1_VCA_TOKEN",  .addr = A_REG_P0_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P1_0_VCA_TOKEN",  .addr = A_REG_P1_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P1_1_VCA_TOKEN",  .addr = A_REG_P1_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P0_W2R_EB_CTRL",  .addr = A_REG_P0_W2R_EB_CTRL,
        .reset = 0x7fc2c,
        .rsvd = 0xffe00000,
    },{ .name = "REG_P0_R2W_EB_CTRL",  .addr = A_REG_P0_R2W_EB_CTRL,
        .reset = 0x7fc2c,
        .rsvd = 0xffe00000,
    },{ .name = "REG_P1_W2R_EB_CTRL",  .addr = A_REG_P1_W2R_EB_CTRL,
        .reset = 0x7fc2c,
        .rsvd = 0xffe00000,
    },{ .name = "REG_P1_R2W_EB_CTRL",  .addr = A_REG_P1_R2W_EB_CTRL,
        .reset = 0x7fc2c,
        .rsvd = 0xffe00000,
    },{ .name = "REG_NOC_CLK_GATE_DIS",  .addr = A_REG_NOC_CLK_GATE_DIS,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_PORT_STATUS",  .addr = A_REG_PORT_STATUS,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "REG_EB_CAL_PTR_SEPARATION",
        .addr = A_REG_EB_CAL_PTR_SEPARATION,
        .reset = 0x924,
        .rsvd = 0xfffff000,
    },{ .name = "REG_W2R_EB_CAL_PATTERN_1",  .addr = A_REG_W2R_EB_CAL_PATTERN_1,
        .reset = 0x1e031d00,
        .rsvd = 0xe0e0e0e0,
        .ro = 0xe0e0e0,
    },{ .name = "REG_W2R_EB_CAL_PATTERN_2",  .addr = A_REG_W2R_EB_CAL_PATTERN_2,
        .reset = 0x130d1205,
        .rsvd = 0xe0e0e0e0,
        .ro = 0xe0e0e0,
    },{ .name = "REG_W2R_EB_CAL_PATTERN_3",  .addr = A_REG_W2R_EB_CAL_PATTERN_3,
        .reset = 0x9160b04,
        .rsvd = 0xe0e0e0e0,
        .ro = 0xe0e0e0,
    },{ .name = "REG_W2R_EB_CAL_PATTERN_4",  .addr = A_REG_W2R_EB_CAL_PATTERN_4,
        .reset = 0x17180f14,
        .rsvd = 0xe0e0e0e0,
        .ro = 0xe0e0e0,
    },{ .name = "REG_R2W_EB_CAL_PATTERN_1",  .addr = A_REG_R2W_EB_CAL_PATTERN_1,
        .reset = 0x1fc07f00,
    },{ .name = "REG_R2W_EB_CAL_PATTERN_2",  .addr = A_REG_R2W_EB_CAL_PATTERN_2,
        .reset = 0x1fc07f0,
    },{ .name = "REG_R2W_EB_CAL_PATTERN_3",  .addr = A_REG_R2W_EB_CAL_PATTERN_3,
        .reset = 0xe03f80ff,
    },{ .name = "REG_R2W_EB_CAL_PATTERN_4",  .addr = A_REG_R2W_EB_CAL_PATTERN_4,
        .reset = 0xfe03f80f,
    },{ .name = "REG_P0_CTL",  .addr = A_REG_P0_CTL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_P0_0_PERF_MON",  .addr = A_REG_P0_0_PERF_MON,
        .ro = 0xffffffff,
    },{ .name = "REG_P0_1_PERF_MON",  .addr = A_REG_P0_1_PERF_MON,
        .ro = 0xffffffff,
    },{ .name = "REG_P1_CTL",  .addr = A_REG_P1_CTL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_P1_0_PERF_MON",  .addr = A_REG_P1_0_PERF_MON,
        .ro = 0xffffffff,
    },{ .name = "REG_P1_1_PERF_MON",  .addr = A_REG_P1_1_PERF_MON,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_EN",  .addr = A_REG_ERR_LOG_EN,
        .reset = 0x2d,
        .rsvd = 0xffffffd2,
        .ro = 0x12,
    },{ .name = "REG_ERR_LOG_P0_1ST_ERR_NUM",
        .addr = A_REG_ERR_LOG_P0_1ST_ERR_NUM,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_ERR_LOG_P0_INFO_0",  .addr = A_REG_ERR_LOG_P0_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P0_INFO_1",  .addr = A_REG_ERR_LOG_P0_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_P0_INFO_2",  .addr = A_REG_ERR_LOG_P0_INFO_2,
        .rsvd = 0xfffffd00,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P1_1ST_ERR_NUM",
        .addr = A_REG_ERR_LOG_P1_1ST_ERR_NUM,
        .rsvd = 0xffc00000,
        .ro = 0x3fffff,
    },{ .name = "REG_ERR_LOG_P1_INFO_0",  .addr = A_REG_ERR_LOG_P1_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P1_INFO_1",  .addr = A_REG_ERR_LOG_P1_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_P1_INFO_2",  .addr = A_REG_ERR_LOG_P1_INFO_2,
        .rsvd = 0xfffffd00,
        .ro = 0xffffffff,
    },{ .name = "REG_P0_W2R_EB_CAL_DBG_1",  .addr = A_REG_P0_W2R_EB_CAL_DBG_1,
        .reset = 0x2,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P0_W2R_EB_CAL_DBG_2",  .addr = A_REG_P0_W2R_EB_CAL_DBG_2,
        .reset = 0x4,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P0_W2R_EB_CAL_DBG_3",  .addr = A_REG_P0_W2R_EB_CAL_DBG_3,
        .reset = 0x6,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P0_W2R_EB_CAL_DBG_4",  .addr = A_REG_P0_W2R_EB_CAL_DBG_4,
        .reset = 0x8,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P0_R2W_EB_CAL_DBG_1",  .addr = A_REG_P0_R2W_EB_CAL_DBG_1,
        .reset = 0x2,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P0_R2W_EB_CAL_DBG_2",  .addr = A_REG_P0_R2W_EB_CAL_DBG_2,
        .reset = 0x4,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P0_R2W_EB_CAL_DBG_3",  .addr = A_REG_P0_R2W_EB_CAL_DBG_3,
        .reset = 0x6,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P0_R2W_EB_CAL_DBG_4",  .addr = A_REG_P0_R2W_EB_CAL_DBG_4,
        .reset = 0x8,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P1_W2R_EB_CAL_DBG_1",  .addr = A_REG_P1_W2R_EB_CAL_DBG_1,
        .reset = 0x2,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P1_W2R_EB_CAL_DBG_2",  .addr = A_REG_P1_W2R_EB_CAL_DBG_2,
        .reset = 0x4,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P1_W2R_EB_CAL_DBG_3",  .addr = A_REG_P1_W2R_EB_CAL_DBG_3,
        .reset = 0x6,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P1_W2R_EB_CAL_DBG_4",  .addr = A_REG_P1_W2R_EB_CAL_DBG_4,
        .reset = 0x8,
        .rsvd = 0xc00e0e00,
        .ro = 0xe0e00,
    },{ .name = "REG_P1_R2W_EB_CAL_DBG_1",  .addr = A_REG_P1_R2W_EB_CAL_DBG_1,
        .reset = 0x2,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P1_R2W_EB_CAL_DBG_2",  .addr = A_REG_P1_R2W_EB_CAL_DBG_2,
        .reset = 0x4,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P1_R2W_EB_CAL_DBG_3",  .addr = A_REG_P1_R2W_EB_CAL_DBG_3,
        .reset = 0x6,
        .rsvd = 0xc0000000,
    },{ .name = "REG_P1_R2W_EB_CAL_DBG_4",  .addr = A_REG_P1_R2W_EB_CAL_DBG_4,
        .reset = 0x8,
        .rsvd = 0xc0000000,
    },{ .name = "REG_DBG_MUX_CTRL_WCLK",  .addr = A_REG_DBG_MUX_CTRL_WCLK,
        .rsvd = 0xfffffe01,
        .ro = 0x1,
    },{ .name = "REG_DBG_MUX_CTRL_RCLK",  .addr = A_REG_DBG_MUX_CTRL_RCLK,
        .rsvd = 0xfffffe01,
        .ro = 0x1,
    },{ .name = "REG_DBG_MUX_STATUS",  .addr = A_REG_DBG_MUX_STATUS,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "REG_DBG_WCLK",  .addr = A_REG_DBG_WCLK,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DBG_RCLK",  .addr = A_REG_DBG_RCLK,
        .rsvd = 0xfffc0000,
    },{ .name = "REG_DBG_TRIG_WCLK",  .addr = A_REG_DBG_TRIG_WCLK,
        .rsvd = 0xf0000000,
    },{ .name = "REG_DBG_TRIG_RCLK_0",  .addr = A_REG_DBG_TRIG_RCLK_0,
        .rsvd = 0xc0000000,
    },{ .name = "REG_DBG_TRIG_RCLK_1",  .addr = A_REG_DBG_TRIG_RCLK_1,
    }
};

static void noc_ncrb_reset(DeviceState *dev)
{
    NOC_NCRB *s = XILINX_NOC_NCRB(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static const MemoryRegionOps noc_ncrb_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void noc_ncrb_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void noc_ncrb_init(Object *obj)
{
    NOC_NCRB *s = XILINX_NOC_NCRB(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_NOC_NCRB, NOC_NCRB_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), noc_ncrb_regs_info,
                              ARRAY_SIZE(noc_ncrb_regs_info),
                              s->regs_info, s->regs,
                              &noc_ncrb_ops,
                              XILINX_NOC_NCRB_ERR_DEBUG,
                              NOC_NCRB_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_noc_ncrb = {
    .name = TYPE_XILINX_NOC_NCRB,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, NOC_NCRB, NOC_NCRB_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void noc_ncrb_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = noc_ncrb_reset;
    dc->realize = noc_ncrb_realize;
    dc->vmsd = &vmstate_noc_ncrb;
}

static const TypeInfo noc_ncrb_info = {
    .name          = TYPE_XILINX_NOC_NCRB,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(NOC_NCRB),
    .class_init    = noc_ncrb_class_init,
    .instance_init = noc_ncrb_init,
};

static void noc_ncrb_register_types(void)
{
    type_register_static(&noc_ncrb_info);
}

type_init(noc_ncrb_register_types)
