/*
 * QEMU model of the PSMX_GLOBAL_REG This is the database for the PSMX Global
 * Register Definitions.
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2022-01-27.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "hw/fdt_generic_util.h"

#ifndef XILINX_PSMX_GLOBAL_REG_ERR_DEBUG
#define XILINX_PSMX_GLOBAL_REG_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSMX_GLOBAL_REG "xlnx.psmx_global_reg"

#define XILINX_PSMX_GLOBAL_REG(obj) \
     OBJECT_CHECK(PSMX_GLOBAL_REG, (obj), TYPE_XILINX_PSMX_GLOBAL_REG)

REG32(GLOBAL_CNTRL, 0x0)
    FIELD(GLOBAL_CNTRL, MB_DBG_WAKE, 17, 1)
    FIELD(GLOBAL_CNTRL, MB_SLEEP, 16, 1)
    FIELD(GLOBAL_CNTRL, WRITE_QOS, 12, 4)
    FIELD(GLOBAL_CNTRL, READ_QOS, 8, 4)
    FIELD(GLOBAL_CNTRL, FW_IS_PRESENT, 4, 1)
    FIELD(GLOBAL_CNTRL, SLVERR_ENABLE, 1, 1)
REG32(ADDR_ERROR_STATUS, 0x10)
    FIELD(ADDR_ERROR_STATUS, STATUS, 0, 1)
REG32(ADDR_ERROR_INT_MASK, 0x14)
    FIELD(ADDR_ERROR_INT_MASK, MASK, 0, 1)
REG32(ADDR_ERROR_INT_EN, 0x18)
    FIELD(ADDR_ERROR_INT_EN, ENABLE, 0, 1)
REG32(ADDR_ERROR_INT_DIS, 0x1c)
    FIELD(ADDR_ERROR_INT_DIS, DISABLE, 0, 1)
REG32(PS_SW_ERR, 0x20)
    FIELD(PS_SW_ERR, NCR_FLAG, 31, 1)
    FIELD(PS_SW_ERR, CR_FLAG, 30, 1)
    FIELD(PS_SW_ERR, DATA, 0, 30)
REG32(PSM_BOOT_SERV_ERR, 0x24)
    FIELD(PSM_BOOT_SERV_ERR, NCR_FLAG, 31, 1)
    FIELD(PSM_BOOT_SERV_ERR, CR_FLAG, 30, 1)
    FIELD(PSM_BOOT_SERV_ERR, DATA, 0, 30)
REG32(GLOBAL_GEN_STORAGE0, 0x30)
REG32(GLOBAL_GEN_STORAGE1, 0x34)
REG32(GLOBAL_GEN_STORAGE2, 0x38)
REG32(GLOBAL_GEN_STORAGE3, 0x3c)
REG32(GLOBAL_GEN_STORAGE4, 0x40)
REG32(GLOBAL_GEN_STORAGE5, 0x44)
REG32(GLOBAL_GEN_STORAGE6, 0x48)
REG32(GLOBAL_GEN_STORAGE7, 0x4c)
REG32(PERS_GLOB_GEN_STORAGE0, 0x50)
REG32(PERS_GLOB_GEN_STORAGE1, 0x54)
REG32(PERS_GLOB_GEN_STORAGE2, 0x58)
REG32(PERS_GLOB_GEN_STORAGE3, 0x5c)
REG32(PERS_GLOB_GEN_STORAGE4, 0x60)
REG32(PERS_GLOB_GEN_STORAGE5, 0x64)
REG32(PERS_GLOB_GEN_STORAGE6, 0x68)
REG32(PERS_GLOB_GEN_STORAGE7, 0x6c)
REG32(PWR_STATE0, 0x100)
    FIELD(PWR_STATE0, OCM_B1_I3, 31, 1)
    FIELD(PWR_STATE0, OCM_B1_I2, 30, 1)
    FIELD(PWR_STATE0, OCM_B1_I1, 29, 1)
    FIELD(PWR_STATE0, OCM_B1_I0, 28, 1)
    FIELD(PWR_STATE0, OCM_B0_I3, 27, 1)
    FIELD(PWR_STATE0, OCM_B0_I2, 26, 1)
    FIELD(PWR_STATE0, OCM_B0_I1, 25, 1)
    FIELD(PWR_STATE0, OCM_B0_I0, 24, 1)
    FIELD(PWR_STATE0, TCMB1, 23, 1)
    FIELD(PWR_STATE0, TCMB0, 22, 1)
    FIELD(PWR_STATE0, TCMA1, 21, 1)
    FIELD(PWR_STATE0, TCMA0, 20, 1)
    FIELD(PWR_STATE0, RPU_B_CORE1, 19, 1)
    FIELD(PWR_STATE0, RPU_B_CORE0, 18, 1)
    FIELD(PWR_STATE0, RPU_A_CORE1, 17, 1)
    FIELD(PWR_STATE0, RPU_A_CORE0, 16, 1)
    FIELD(PWR_STATE0, APU3_CORE3, 15, 1)
    FIELD(PWR_STATE0, APU3_CORE2, 14, 1)
    FIELD(PWR_STATE0, APU3_CORE1, 13, 1)
    FIELD(PWR_STATE0, APU3_CORE0, 12, 1)
    FIELD(PWR_STATE0, APU2_CORE3, 11, 1)
    FIELD(PWR_STATE0, APU2_CORE2, 10, 1)
    FIELD(PWR_STATE0, APU2_CORE1, 9, 1)
    FIELD(PWR_STATE0, APU2_CORE0, 8, 1)
    FIELD(PWR_STATE0, APU1_CORE3, 7, 1)
    FIELD(PWR_STATE0, APU1_CORE2, 6, 1)
    FIELD(PWR_STATE0, APU1_CORE1, 5, 1)
    FIELD(PWR_STATE0, APU1_CORE0, 4, 1)
    FIELD(PWR_STATE0, APU0_CORE3, 3, 1)
    FIELD(PWR_STATE0, APU0_CORE2, 2, 1)
    FIELD(PWR_STATE0, APU0_CORE1, 1, 1)
    FIELD(PWR_STATE0, APU0_CORE0, 0, 1)
REG32(PWR_STATE1, 0x104)
    FIELD(PWR_STATE1, FP, 2, 1)
    FIELD(PWR_STATE1, GEM1, 1, 1)
    FIELD(PWR_STATE1, GEM0, 0, 1)
REG32(AUX_PWR_STATE, 0x108)
    FIELD(AUX_PWR_STATE, OCM_B1_I3, 31, 1)
    FIELD(AUX_PWR_STATE, OCM_B1_I2, 30, 1)
    FIELD(AUX_PWR_STATE, OCM_B1_I1, 29, 1)
    FIELD(AUX_PWR_STATE, OCM_B1_I0, 28, 1)
    FIELD(AUX_PWR_STATE, OCM_B0_I3, 27, 1)
    FIELD(AUX_PWR_STATE, OCM_B0_I2, 26, 1)
    FIELD(AUX_PWR_STATE, OCM_B0_I1, 25, 1)
    FIELD(AUX_PWR_STATE, OCM_B0_I0, 24, 1)
    FIELD(AUX_PWR_STATE, TCMB1, 23, 1)
    FIELD(AUX_PWR_STATE, TCMB0, 22, 1)
    FIELD(AUX_PWR_STATE, TCMA1, 21, 1)
    FIELD(AUX_PWR_STATE, TCMA0, 20, 1)
    FIELD(AUX_PWR_STATE, RPU_B_CORE1, 19, 1)
    FIELD(AUX_PWR_STATE, RPU_B_CORE0, 18, 1)
    FIELD(AUX_PWR_STATE, RPU_A_CORE1, 17, 1)
    FIELD(AUX_PWR_STATE, RPU_A_CORE0, 16, 1)
    FIELD(AUX_PWR_STATE, APU3_CORE3, 15, 1)
    FIELD(AUX_PWR_STATE, APU3_CORE2, 14, 1)
    FIELD(AUX_PWR_STATE, APU3_CORE1, 13, 1)
    FIELD(AUX_PWR_STATE, APU3_CORE0, 12, 1)
    FIELD(AUX_PWR_STATE, APU2_CORE3, 11, 1)
    FIELD(AUX_PWR_STATE, APU2_CORE2, 10, 1)
    FIELD(AUX_PWR_STATE, APU2_CORE1, 9, 1)
    FIELD(AUX_PWR_STATE, APU2_CORE0, 8, 1)
    FIELD(AUX_PWR_STATE, APU1_CORE3, 7, 1)
    FIELD(AUX_PWR_STATE, APU1_CORE2, 6, 1)
    FIELD(AUX_PWR_STATE, APU1_CORE1, 5, 1)
    FIELD(AUX_PWR_STATE, APU1_CORE0, 4, 1)
    FIELD(AUX_PWR_STATE, APU0_CORE3, 3, 1)
    FIELD(AUX_PWR_STATE, APU0_CORE2, 2, 1)
    FIELD(AUX_PWR_STATE, APU0_CORE1, 1, 1)
    FIELD(AUX_PWR_STATE, APU0_CORE0, 0, 1)
REG32(REQ_PWRUP0_STATUS, 0x110)
    FIELD(REQ_PWRUP0_STATUS, RSVD6, 31, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD5, 30, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD4, 29, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD3, 28, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD2, 27, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD1, 26, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD0, 25, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_STATUS, FP, 20, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_STATUS, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRUP0_STATUS, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRUP0_STATUS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_STATUS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_STATUS, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRUP0_STATUS, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRUP0_STATUS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_STATUS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_STATUS, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRUP0_STATUS, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRUP0_STATUS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_STATUS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_STATUS, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRUP0_STATUS, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRUP0_STATUS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_STATUS, APU0_CORE0, 0, 1)
REG32(REQ_PWRUP0_INT_MASK, 0x114)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD6, 31, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD5, 30, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD4, 29, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD3, 28, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD2, 27, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD1, 26, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD0, 25, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_INT_MASK, FP, 20, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU0_CORE0, 0, 1)
REG32(REQ_PWRUP0_INT_EN, 0x118)
    FIELD(REQ_PWRUP0_INT_EN, RSVD6, 31, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD5, 30, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD4, 29, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD3, 28, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD2, 27, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD1, 26, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD0, 25, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_INT_EN, FP, 20, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU0_CORE0, 0, 1)
REG32(REQ_PWRUP0_INT_DIS, 0x11c)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD6, 31, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD5, 30, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD4, 29, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD3, 28, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD2, 27, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD1, 26, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD0, 25, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_INT_DIS, FP, 20, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU0_CORE0, 0, 1)
REG32(REQ_PWRUP0_TRIG, 0x120)
    FIELD(REQ_PWRUP0_TRIG, RSVD6, 31, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD5, 30, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD4, 29, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD3, 28, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD2, 27, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD1, 26, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD0, 25, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_TRIG, FP, 20, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_TRIG, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRUP0_TRIG, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRUP0_TRIG, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_TRIG, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_TRIG, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRUP0_TRIG, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRUP0_TRIG, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_TRIG, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_TRIG, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRUP0_TRIG, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRUP0_TRIG, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_TRIG, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_TRIG, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRUP0_TRIG, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRUP0_TRIG, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_TRIG, APU0_CORE0, 0, 1)
REG32(REQ_PWRUP1_STATUS, 0x124)
    FIELD(REQ_PWRUP1_STATUS, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_STATUS, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1B, 23, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1A, 22, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0B, 21, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0A, 20, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRUP1_STATUS, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRUP1_INT_MASK, 0x128)
    FIELD(REQ_PWRUP1_INT_MASK, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_INT_MASK, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1B, 23, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1A, 22, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0B, 21, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0A, 20, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRUP1_INT_MASK, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRUP1_INT_EN, 0x12c)
    FIELD(REQ_PWRUP1_INT_EN, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_INT_EN, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1B, 23, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1A, 22, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0B, 21, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0A, 20, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRUP1_INT_EN, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRUP1_INT_DIS, 0x130)
    FIELD(REQ_PWRUP1_INT_DIS, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_INT_DIS, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1B, 23, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1A, 22, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0B, 21, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0A, 20, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRUP1_INT_DIS, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRUP1_TRIG, 0x134)
    FIELD(REQ_PWRUP1_TRIG, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_TRIG, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1B, 23, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1A, 22, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0B, 21, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0A, 20, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRUP1_TRIG, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRDWN0_STATUS, 0x210)
    FIELD(REQ_PWRDWN0_STATUS, RSVD6, 31, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD5, 30, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD4, 29, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD3, 28, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD2, 27, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD1, 26, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD0, 25, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRDWN0_STATUS, FP, 20, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_3Q, 19, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_1H, 18, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_1Q, 17, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_OFF, 16, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU0_CORE0, 0, 1)
REG32(REQ_PWRDWN0_INT_MASK, 0x214)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD6, 31, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD5, 30, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD4, 29, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD3, 28, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD2, 27, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD1, 26, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD0, 25, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, FP, 20, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_MODE3, 19, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_MODE2, 18, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_MODE1, 17, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_MODE0, 16, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU0_CORE0, 0, 1)
REG32(REQ_PWRDWN0_INT_EN, 0x218)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD6, 31, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD5, 30, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD4, 29, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD3, 28, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD2, 27, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD1, 26, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD0, 25, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRDWN0_INT_EN, FP, 20, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_MODE3, 19, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_MODE2, 18, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_MODE1, 17, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_MODE0, 16, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU0_CORE0, 0, 1)
REG32(REQ_PWRDWN0_INT_DIS, 0x21c)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD6, 31, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD5, 30, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD4, 29, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD3, 28, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD2, 27, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD1, 26, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD0, 25, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, FP, 20, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_MODE3, 19, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_MODE2, 18, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_MODE1, 17, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_MODE0, 16, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU0_CORE0, 0, 1)
REG32(REQ_PWRDWN0_TRIG, 0x220)
    FIELD(REQ_PWRDWN0_TRIG, RSVD6, 31, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD5, 30, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD4, 29, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD3, 28, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD2, 27, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD1, 26, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD0, 25, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRDWN0_TRIG, FP, 20, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_MODE3, 19, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_MODE2, 18, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_MODE1, 17, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_MODE0, 16, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU3_CORE3, 15, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU3_CORE2, 14, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU2_CORE3, 11, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU2_CORE2, 10, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU1_CORE3, 7, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU1_CORE2, 6, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU0_CORE3, 3, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU0_CORE2, 2, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU0_CORE0, 0, 1)
REG32(REQ_PWRDWN1_STATUS, 0x224)
    FIELD(REQ_PWRDWN1_STATUS, GEM1, 29, 1)
    FIELD(REQ_PWRDWN1_STATUS, GEM0, 28, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1B_RET, 27, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1A_RET, 26, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0B_RET, 25, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0A_RET, 24, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1B, 23, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1A, 22, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0B, 21, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0A, 20, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND7_RET, 19, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND6_RET, 18, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND5_RET, 17, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND4_RET, 16, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND3_RET, 15, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND2_RET, 14, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND1_RET, 13, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND0_RET, 12, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRDWN1_STATUS, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRDWN1_INT_MASK, 0x228)
    FIELD(REQ_PWRDWN1_INT_MASK, GEM1, 29, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, GEM0, 28, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1B_RET, 27, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1A_RET, 26, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0B_RET, 25, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0A_RET, 24, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1B, 23, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1A, 22, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0B, 21, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0A, 20, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND7_RET, 19, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND6_RET, 18, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND5_RET, 17, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND4_RET, 16, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND3_RET, 15, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND2_RET, 14, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND1_RET, 13, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND0_RET, 12, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRDWN1_INT_EN, 0x22c)
    FIELD(REQ_PWRDWN1_INT_EN, GEM1, 29, 1)
    FIELD(REQ_PWRDWN1_INT_EN, GEM0, 28, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1B_RET, 27, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1A_RET, 26, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0B_RET, 25, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0A_RET, 24, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1B, 23, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1A, 22, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0B, 21, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0A, 20, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND7_RET, 19, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND6_RET, 18, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND5_RET, 17, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND4_RET, 16, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND3_RET, 15, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND2_RET, 14, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND1_RET, 13, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND0_RET, 12, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRDWN1_INT_EN, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRDWN1_INT_DIS, 0x230)
    FIELD(REQ_PWRDWN1_INT_DIS, GEM1, 29, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, GEM0, 28, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1B_RET, 27, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1A_RET, 26, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0B_RET, 25, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0A_RET, 24, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1B, 23, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1A, 22, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0B, 21, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0A, 20, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND7_RET, 19, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND6_RET, 18, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND5_RET, 17, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND4_RET, 16, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND3_RET, 15, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND2_RET, 14, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND1_RET, 13, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND0_RET, 12, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_A_CORE0, 0, 1)
REG32(REQ_PWRDWN1_TRIG, 0x234)
    FIELD(REQ_PWRDWN1_TRIG, GEM1, 29, 1)
    FIELD(REQ_PWRDWN1_TRIG, GEM0, 28, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1B_RET, 27, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1A_RET, 26, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0B_RET, 25, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0A_RET, 24, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1B, 23, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1A, 22, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0B, 21, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0A, 20, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND7_RET, 19, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND6_RET, 18, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND5_RET, 17, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND4_RET, 16, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND3_RET, 15, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND2_RET, 14, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND1_RET, 13, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND0_RET, 12, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND7, 11, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND6, 10, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND5, 9, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND4, 8, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND3, 7, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND2, 6, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND1, 5, 1)
    FIELD(REQ_PWRDWN1_TRIG, OCM_ISLAND0, 4, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_A_CORE0, 0, 1)
REG32(REQ_ISO_STATUS, 0x310)
    FIELD(REQ_ISO_STATUS, FP, 0, 1)
REG32(REQ_ISO_INT_MASK, 0x314)
    FIELD(REQ_ISO_INT_MASK, FP, 0, 1)
REG32(REQ_ISO_INT_EN, 0x318)
    FIELD(REQ_ISO_INT_EN, FP, 0, 1)
REG32(REQ_ISO_INT_DIS, 0x31c)
    FIELD(REQ_ISO_INT_DIS, FP, 0, 1)
REG32(REQ_ISO_TRIG, 0x320)
    FIELD(REQ_ISO_TRIG, FP, 0, 1)
REG32(REQ_SWRST_STATUS, 0x410)
    FIELD(REQ_SWRST_STATUS, RSVD1, 31, 1)
    FIELD(REQ_SWRST_STATUS, RSVD0, 30, 1)
    FIELD(REQ_SWRST_STATUS, FP, 29, 1)
    FIELD(REQ_SWRST_STATUS, LP, 28, 1)
    FIELD(REQ_SWRST_STATUS, RPU, 27, 1)
    FIELD(REQ_SWRST_STATUS, RPU_B_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_STATUS, RPU_A_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_STATUS, RPU_B_CORE1, 24, 1)
    FIELD(REQ_SWRST_STATUS, RPU_B_CORE0, 23, 1)
    FIELD(REQ_SWRST_STATUS, RPU_A_CORE1, 22, 1)
    FIELD(REQ_SWRST_STATUS, RPU_A_CORE0, 21, 1)
    FIELD(REQ_SWRST_STATUS, APU, 20, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CLUSTER, 19, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CLUSTER, 18, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CLUSTER, 17, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CLUSTER, 16, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CORE3, 15, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CORE2, 14, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CORE1, 13, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CORE0, 12, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CORE3, 11, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CORE2, 10, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CORE1, 9, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CORE0, 8, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CORE3, 7, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CORE2, 6, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CORE1, 5, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CORE0, 4, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CORE3, 3, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CORE2, 2, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CORE0, 0, 1)
REG32(REQ_SWRST_INT_MASK, 0x414)
    FIELD(REQ_SWRST_INT_MASK, RSVD1, 31, 1)
    FIELD(REQ_SWRST_INT_MASK, RSVD0, 30, 1)
    FIELD(REQ_SWRST_INT_MASK, FP, 29, 1)
    FIELD(REQ_SWRST_INT_MASK, LP, 28, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU, 27, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_B_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_A_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_B_CORE1, 24, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_B_CORE0, 23, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_A_CORE1, 22, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_A_CORE0, 21, 1)
    FIELD(REQ_SWRST_INT_MASK, APU, 20, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CLUSTER, 19, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CLUSTER, 18, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CLUSTER, 17, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CLUSTER, 16, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CORE3, 15, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CORE2, 14, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CORE1, 13, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CORE0, 12, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CORE3, 11, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CORE2, 10, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CORE1, 9, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CORE0, 8, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CORE3, 7, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CORE2, 6, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CORE1, 5, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CORE0, 4, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CORE3, 3, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CORE2, 2, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CORE0, 0, 1)
REG32(REQ_SWRST_INT_EN, 0x418)
    FIELD(REQ_SWRST_INT_EN, RSVD1, 31, 1)
    FIELD(REQ_SWRST_INT_EN, RSVD0, 30, 1)
    FIELD(REQ_SWRST_INT_EN, FP, 29, 1)
    FIELD(REQ_SWRST_INT_EN, LP, 28, 1)
    FIELD(REQ_SWRST_INT_EN, RPU, 27, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_B_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_A_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_B_CORE1, 24, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_B_CORE0, 23, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_A_CORE1, 22, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_A_CORE0, 21, 1)
    FIELD(REQ_SWRST_INT_EN, APU, 20, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CLUSTER, 19, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CLUSTER, 18, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CLUSTER, 17, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CLUSTER, 16, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CORE3, 15, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CORE2, 14, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CORE1, 13, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CORE0, 12, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CORE3, 11, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CORE2, 10, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CORE1, 9, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CORE0, 8, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CORE3, 7, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CORE2, 6, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CORE1, 5, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CORE0, 4, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CORE3, 3, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CORE2, 2, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CORE0, 0, 1)
REG32(REQ_SWRST_INT_DIS, 0x41c)
    FIELD(REQ_SWRST_INT_DIS, RSVD1, 31, 1)
    FIELD(REQ_SWRST_INT_DIS, RSVD0, 30, 1)
    FIELD(REQ_SWRST_INT_DIS, FP, 29, 1)
    FIELD(REQ_SWRST_INT_DIS, LP, 28, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU, 27, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_B_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_A_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_B_CORE1, 24, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_B_CORE0, 23, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_A_CORE1, 22, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_A_CORE0, 21, 1)
    FIELD(REQ_SWRST_INT_DIS, APU, 20, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CLUSTER, 19, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CLUSTER, 18, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CLUSTER, 17, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CLUSTER, 16, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CORE3, 15, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CORE2, 14, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CORE1, 13, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CORE0, 12, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CORE3, 11, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CORE2, 10, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CORE1, 9, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CORE0, 8, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CORE3, 7, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CORE2, 6, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CORE1, 5, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CORE0, 4, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CORE3, 3, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CORE2, 2, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CORE0, 0, 1)
REG32(REQ_SWRST_TRIG, 0x420)
    FIELD(REQ_SWRST_TRIG, RSVD1, 31, 1)
    FIELD(REQ_SWRST_TRIG, RSVD0, 30, 1)
    FIELD(REQ_SWRST_TRIG, FP, 29, 1)
    FIELD(REQ_SWRST_TRIG, LP, 28, 1)
    FIELD(REQ_SWRST_TRIG, RPU, 27, 1)
    FIELD(REQ_SWRST_TRIG, RPU_B_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_TRIG, RPU_A_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_TRIG, RPU_B_CORE1, 24, 1)
    FIELD(REQ_SWRST_TRIG, RPU_B_CORE0, 23, 1)
    FIELD(REQ_SWRST_TRIG, RPU_A_CORE1, 22, 1)
    FIELD(REQ_SWRST_TRIG, RPU_A_CORE0, 21, 1)
    FIELD(REQ_SWRST_TRIG, APU, 20, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CLUSTER, 19, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CLUSTER, 18, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CLUSTER, 17, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CLUSTER, 16, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CORE3, 15, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CORE2, 14, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CORE1, 13, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CORE0, 12, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CORE3, 11, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CORE2, 10, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CORE1, 9, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CORE0, 8, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CORE3, 7, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CORE2, 6, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CORE1, 5, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CORE0, 4, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CORE3, 3, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CORE2, 2, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CORE0, 0, 1)
REG32(MB_FATAL, 0x52c)
    FIELD(MB_FATAL, CPU3, 2, 1)
    FIELD(MB_FATAL, CPU2, 1, 1)
    FIELD(MB_FATAL, CPU1, 0, 1)
REG32(MB1_FAULT_STATUS, 0x530)
    FIELD(MB1_FAULT_STATUS, CPU3, 14, 1)
    FIELD(MB1_FAULT_STATUS, CPU2, 13, 1)
    FIELD(MB1_FAULT_STATUS, CPU1, 12, 1)
    FIELD(MB1_FAULT_STATUS, FT_STATE, 10, 2)
    FIELD(MB1_FAULT_STATUS, WDT_EXP, 9, 1)
    FIELD(MB1_FAULT_STATUS, UNCORR_ERR, 8, 1)
    FIELD(MB1_FAULT_STATUS, VOTER_ERR, 7, 1)
    FIELD(MB1_FAULT_STATUS, FTL_MISMATCH, 4, 3)
    FIELD(MB1_FAULT_STATUS, LS_RECOVER, 3, 1)
    FIELD(MB1_FAULT_STATUS, LS_MISMATCH, 0, 3)
REG32(MB2_FAULT_STATUS, 0x534)
    FIELD(MB2_FAULT_STATUS, CPU3, 14, 1)
    FIELD(MB2_FAULT_STATUS, CPU2, 13, 1)
    FIELD(MB2_FAULT_STATUS, CPU1, 12, 1)
    FIELD(MB2_FAULT_STATUS, FT_STATE, 10, 2)
    FIELD(MB2_FAULT_STATUS, WDT_EXP, 9, 1)
    FIELD(MB2_FAULT_STATUS, UNCORR_ERR, 8, 1)
    FIELD(MB2_FAULT_STATUS, VOTER_ERR, 7, 1)
    FIELD(MB2_FAULT_STATUS, FTL_MISMATCH, 4, 3)
    FIELD(MB2_FAULT_STATUS, LS_RECOVER, 3, 1)
    FIELD(MB2_FAULT_STATUS, LS_MISMATCH, 0, 3)
REG32(MB3_FAULT_STATUS, 0x538)
    FIELD(MB3_FAULT_STATUS, CPU3, 14, 1)
    FIELD(MB3_FAULT_STATUS, CPU2, 13, 1)
    FIELD(MB3_FAULT_STATUS, CPU1, 12, 1)
    FIELD(MB3_FAULT_STATUS, FT_STATE, 10, 2)
    FIELD(MB3_FAULT_STATUS, WDT_EXP, 9, 1)
    FIELD(MB3_FAULT_STATUS, UNCORR_ERR, 8, 1)
    FIELD(MB3_FAULT_STATUS, VOTER_ERR, 7, 1)
    FIELD(MB3_FAULT_STATUS, FTL_MISMATCH, 4, 3)
    FIELD(MB3_FAULT_STATUS, LS_RECOVER, 3, 1)
    FIELD(MB3_FAULT_STATUS, LS_MISMATCH, 0, 3)
REG32(PSM_DEBUG_CTRL, 0x540)
    FIELD(PSM_DEBUG_CTRL, EN, 0, 1)
REG32(WAKEUP0_IRQ_STATUS, 0x600)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD7, 27, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD6, 26, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD5, 25, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD4, 24, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD3, 23, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD2, 22, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD1, 21, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD0, 20, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CLUSTER, 19, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CLUSTER, 18, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CLUSTER, 17, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CLUSTER, 16, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE3, 15, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE2, 14, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE1, 13, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE0, 12, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE3, 11, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE2, 10, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE1, 9, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE0, 8, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE3, 7, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE2, 6, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE3, 3, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE2, 2, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE0, 0, 1)
REG32(WAKEUP0_IRQ_MASK, 0x604)
    FIELD(WAKEUP0_IRQ_MASK, RSVD7, 27, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD6, 26, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD5, 25, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD4, 24, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD3, 23, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD2, 22, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD1, 21, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD0, 20, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CLUSTER, 19, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CLUSTER, 18, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CLUSTER, 17, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CLUSTER, 16, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE3, 15, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE2, 14, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE1, 13, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE0, 12, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE3, 11, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE2, 10, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE1, 9, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE0, 8, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE3, 7, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE2, 6, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE3, 3, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE2, 2, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE0, 0, 1)
REG32(WAKEUP0_IRQ_EN, 0x608)
    FIELD(WAKEUP0_IRQ_EN, RSVD7, 27, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD6, 26, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD5, 25, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD4, 24, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD3, 23, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD2, 22, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD1, 21, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD0, 20, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CLUSTER, 19, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CLUSTER, 18, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CLUSTER, 17, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CLUSTER, 16, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE3, 15, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE2, 14, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE1, 13, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE0, 12, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE3, 11, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE2, 10, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE1, 9, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE0, 8, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE3, 7, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE2, 6, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE3, 3, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE2, 2, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE0, 0, 1)
REG32(WAKEUP0_IRQ_DIS, 0x60c)
    FIELD(WAKEUP0_IRQ_DIS, RSVD7, 27, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD6, 26, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD5, 25, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD4, 24, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD3, 23, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD2, 22, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD1, 21, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD0, 20, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CLUSTER, 19, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CLUSTER, 18, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CLUSTER, 17, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CLUSTER, 16, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE3, 15, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE2, 14, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE1, 13, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE0, 12, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE3, 11, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE2, 10, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE1, 9, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE0, 8, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE3, 7, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE2, 6, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE3, 3, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE2, 2, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE0, 0, 1)
REG32(WAKEUP0_IRQ_TRIG, 0x610)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD7, 27, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD6, 26, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD5, 25, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD4, 24, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD3, 23, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD2, 22, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD1, 21, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD0, 20, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CLUSTER, 19, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CLUSTER, 18, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CLUSTER, 17, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CLUSTER, 16, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE3, 15, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE2, 14, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE1, 13, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE0, 12, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE3, 11, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE2, 10, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE1, 9, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE0, 8, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE3, 7, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE2, 6, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE3, 3, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE2, 2, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE0, 0, 1)
REG32(WAKEUP1_IRQ_STATUS, 0x614)
    FIELD(WAKEUP1_IRQ_STATUS, FPD_DBG, 30, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE1_CORESIGHT, 29, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE0_CORESIGHT, 28, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE1_CORESIGHT, 27, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE0_CORESIGHT, 26, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU3_DSU_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU2_DSU_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU1_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU0_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU3_CORE3_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU3_CORE2_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU2_CORE3_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU2_CORE2_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU2_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU2_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU1_CORE3_CORESIGHT, 13, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU1_CORE2_CORESIGHT, 12, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU1_CORE1_CORESIGHT, 11, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU1_CORE0_CORESIGHT, 10, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU0_CORE3_CORESIGHT, 9, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU0_CORE2_CORESIGHT, 8, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU0_CORE1_CORESIGHT, 7, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU0_CORE0_CORESIGHT, 6, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU_CLUSTER_DBG, 1, 1)
    FIELD(WAKEUP1_IRQ_STATUS, APU_CORE_DBG, 0, 1)
REG32(WAKEUP1_IRQ_MASK, 0x618)
    FIELD(WAKEUP1_IRQ_MASK, FPD_DBG, 30, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE1_CORESIGHT, 29, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE0_CORESIGHT, 28, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE1_CORESIGHT, 27, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE0_CORESIGHT, 26, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU3_DSU_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU2_DSU_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU1_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU0_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU3_CORE3_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU3_CORE2_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU2_CORE3_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU2_CORE2_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU2_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU2_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU1_CORE3_CORESIGHT, 13, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU1_CORE2_CORESIGHT, 12, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU1_CORE1_CORESIGHT, 11, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU1_CORE0_CORESIGHT, 10, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU0_CORE3_CORESIGHT, 9, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU0_CORE2_CORESIGHT, 8, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU0_CORE1_CORESIGHT, 7, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU0_CORE0_CORESIGHT, 6, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU_CLUSTER_DBG, 1, 1)
    FIELD(WAKEUP1_IRQ_MASK, APU_CORE_DBG, 0, 1)
REG32(WAKEUP1_IRQ_EN, 0x61c)
    FIELD(WAKEUP1_IRQ_EN, FPD_DBG, 30, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE1_CORESIGHT, 29, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE0_CORESIGHT, 28, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE1_CORESIGHT, 27, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE0_CORESIGHT, 26, 1)
    FIELD(WAKEUP1_IRQ_EN, APU3_DSU_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_EN, APU2_DSU_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_EN, APU1_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_EN, APU0_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_EN, APU3_CORE3_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_EN, APU3_CORE2_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_EN, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_EN, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_EN, APU2_CORE3_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_EN, APU2_CORE2_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_EN, APU2_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP1_IRQ_EN, APU2_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP1_IRQ_EN, APU1_CORE3_CORESIGHT, 13, 1)
    FIELD(WAKEUP1_IRQ_EN, APU1_CORE2_CORESIGHT, 12, 1)
    FIELD(WAKEUP1_IRQ_EN, APU1_CORE1_CORESIGHT, 11, 1)
    FIELD(WAKEUP1_IRQ_EN, APU1_CORE0_CORESIGHT, 10, 1)
    FIELD(WAKEUP1_IRQ_EN, APU0_CORE3_CORESIGHT, 9, 1)
    FIELD(WAKEUP1_IRQ_EN, APU0_CORE2_CORESIGHT, 8, 1)
    FIELD(WAKEUP1_IRQ_EN, APU0_CORE1_CORESIGHT, 7, 1)
    FIELD(WAKEUP1_IRQ_EN, APU0_CORE0_CORESIGHT, 6, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_EN, APU_CLUSTER_DBG, 1, 1)
    FIELD(WAKEUP1_IRQ_EN, APU_CORE_DBG, 0, 1)
REG32(WAKEUP1_IRQ_DIS, 0x620)
    FIELD(WAKEUP1_IRQ_DIS, FPD_DBG, 30, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE1_CORESIGHT, 29, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE0_CORESIGHT, 28, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE1_CORESIGHT, 27, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE0_CORESIGHT, 26, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU3_DSU_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU2_DSU_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU1_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU0_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU3_CORE3_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU3_CORE2_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU2_CORE3_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU2_CORE2_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU2_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU2_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU1_CORE3_CORESIGHT, 13, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU1_CORE2_CORESIGHT, 12, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU1_CORE1_CORESIGHT, 11, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU1_CORE0_CORESIGHT, 10, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU0_CORE3_CORESIGHT, 9, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU0_CORE2_CORESIGHT, 8, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU0_CORE1_CORESIGHT, 7, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU0_CORE0_CORESIGHT, 6, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU_CLUSTER_DBG, 1, 1)
    FIELD(WAKEUP1_IRQ_DIS, APU_CORE_DBG, 0, 1)
REG32(WAKEUP1_IRQ_TRIG, 0x624)
    FIELD(WAKEUP1_IRQ_TRIG, FPD_DBG, 30, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE1_CORESIGHT, 29, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE0_CORESIGHT, 28, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE1_CORESIGHT, 27, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE0_CORESIGHT, 26, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU3_DSU_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU2_DSU_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU1_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU0_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU3_CORE3_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU3_CORE2_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU2_CORE3_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU2_CORE2_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU2_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU2_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU1_CORE3_CORESIGHT, 13, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU1_CORE2_CORESIGHT, 12, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU1_CORE1_CORESIGHT, 11, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU1_CORE0_CORESIGHT, 10, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU0_CORE3_CORESIGHT, 9, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU0_CORE2_CORESIGHT, 8, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU0_CORE1_CORESIGHT, 7, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU0_CORE0_CORESIGHT, 6, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU_CLUSTER_DBG, 1, 1)
    FIELD(WAKEUP1_IRQ_TRIG, APU_CORE_DBG, 0, 1)
REG32(PWR_CTRL0_IRQ_STATUS, 0x700)
    FIELD(PWR_CTRL0_IRQ_STATUS, FPD_SUPPLY, 31, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RSVD4, 30, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RSVD3, 29, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RSVD2, 28, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RSVD1, 27, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RSVD0, 26, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_STANDBY, 25, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU_STANDBY, 24, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_B_CORE1_DBG_RST, 23, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_B_CORE0_DBG_RST, 22, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_A_CORE1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_A_CORE0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_B_CORE1_RST, 19, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_B_CORE0_RST, 18, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_A_CORE1_RST, 17, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, RPU_A_CORE0_RST, 16, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU3_CORE3_DBG_RST, 15, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU3_CORE2_DBG_RST, 14, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU3_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU3_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU2_CORE3_DBG_RST, 11, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU2_CORE2_DBG_RST, 10, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU2_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU2_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU1_CORE3_DBG_RST, 7, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU1_CORE2_DBG_RST, 6, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU1_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU1_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU0_CORE3_DBG_RST, 3, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU0_CORE2_DBG_RST, 2, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_CTRL0_IRQ_STATUS, APU0_CORE0_DBG_RST, 0, 1)
REG32(PWR_CTRL0_IRQ_MASK, 0x704)
    FIELD(PWR_CTRL0_IRQ_MASK, FPD_SUPPLY, 31, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RSVD4, 30, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RSVD3, 29, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RSVD2, 28, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RSVD1, 27, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RSVD0, 26, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_STANDBY, 25, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU_STANDBY, 24, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_B_CORE1_DBG_RST, 23, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_B_CORE0_DBG_RST, 22, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_A_CORE1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_A_CORE0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_B_CORE1_RST, 19, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_B_CORE0_RST, 18, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_A_CORE1_RST, 17, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, RPU_A_CORE0_RST, 16, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU3_CORE3_DBG_RST, 15, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU3_CORE2_DBG_RST, 14, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU3_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU3_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU2_CORE3_DBG_RST, 11, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU2_CORE2_DBG_RST, 10, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU2_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU2_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU1_CORE3_DBG_RST, 7, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU1_CORE2_DBG_RST, 6, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU1_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU1_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU0_CORE3_DBG_RST, 3, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU0_CORE2_DBG_RST, 2, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_CTRL0_IRQ_MASK, APU0_CORE0_DBG_RST, 0, 1)
REG32(PWR_CTRL0_IRQ_EN, 0x708)
    FIELD(PWR_CTRL0_IRQ_EN, FPD_SUPPLY, 31, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RSVD4, 30, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RSVD3, 29, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RSVD2, 28, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RSVD1, 27, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RSVD0, 26, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_STANDBY, 25, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU_STANDBY, 24, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_B_CORE1_DBG_RST, 23, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_B_CORE0_DBG_RST, 22, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_A_CORE1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_A_CORE0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_B_CORE1_RST, 19, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_B_CORE0_RST, 18, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_A_CORE1_RST, 17, 1)
    FIELD(PWR_CTRL0_IRQ_EN, RPU_A_CORE0_RST, 16, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU3_CORE3_DBG_RST, 15, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU3_CORE2_DBG_RST, 14, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU3_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU3_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU2_CORE3_DBG_RST, 11, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU2_CORE2_DBG_RST, 10, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU2_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU2_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU1_CORE3_DBG_RST, 7, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU1_CORE2_DBG_RST, 6, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU1_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU1_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU0_CORE3_DBG_RST, 3, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU0_CORE2_DBG_RST, 2, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_CTRL0_IRQ_EN, APU0_CORE0_DBG_RST, 0, 1)
REG32(PWR_CTRL0_IRQ_DIS, 0x70c)
    FIELD(PWR_CTRL0_IRQ_DIS, FPD_SUPPLY, 31, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RSVD4, 30, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RSVD3, 29, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RSVD2, 28, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RSVD1, 27, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RSVD0, 26, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_STANDBY, 25, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU_STANDBY, 24, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_B_CORE1_DBG_RST, 23, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_B_CORE0_DBG_RST, 22, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_A_CORE1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_A_CORE0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_B_CORE1_RST, 19, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_B_CORE0_RST, 18, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_A_CORE1_RST, 17, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, RPU_A_CORE0_RST, 16, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU3_CORE3_DBG_RST, 15, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU3_CORE2_DBG_RST, 14, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU3_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU3_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU2_CORE3_DBG_RST, 11, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU2_CORE2_DBG_RST, 10, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU2_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU2_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU1_CORE3_DBG_RST, 7, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU1_CORE2_DBG_RST, 6, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU1_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU1_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU0_CORE3_DBG_RST, 3, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU0_CORE2_DBG_RST, 2, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_CTRL0_IRQ_DIS, APU0_CORE0_DBG_RST, 0, 1)
REG32(PWR_CTRL0_IRQ_TRIG, 0x710)
    FIELD(PWR_CTRL0_IRQ_TRIG, FPD_SUPPLY, 31, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RSVD4, 30, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RSVD3, 29, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RSVD2, 28, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RSVD1, 27, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RSVD0, 26, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_STANDBY, 25, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU_STANDBY, 24, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_B_CORE1_DBG_RST, 23, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_B_CORE0_DBG_RST, 22, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_A_CORE1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_A_CORE0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_B_CORE1_RST, 19, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_B_CORE0_RST, 18, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_A_CORE1_RST, 17, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, RPU_A_CORE0_RST, 16, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU3_CORE3_DBG_RST, 15, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU3_CORE2_DBG_RST, 14, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU3_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU3_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU2_CORE3_DBG_RST, 11, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU2_CORE2_DBG_RST, 10, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU2_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU2_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU1_CORE3_DBG_RST, 7, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU1_CORE2_DBG_RST, 6, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU1_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU1_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU0_CORE3_DBG_RST, 3, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU0_CORE2_DBG_RST, 2, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_CTRL0_IRQ_TRIG, APU0_CORE0_DBG_RST, 0, 1)
REG32(PWR_CTRL1_IRQ_STATUS, 0x714)
    FIELD(PWR_CTRL1_IRQ_STATUS, RPU_B_CORE1_PWRDWN, 23, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, RPU_B_CORE0_PWRDWN, 22, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, RPU_A_CORE1_PWRDWN, 21, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, RPU_A_CORE0_PWRDWN, 20, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU3_CLUSTER, 19, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU2_CLUSTER, 18, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU1_CLUSTER, 17, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU0_CLUSTER, 16, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU3_CORE3_PWRDWN, 15, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU3_CORE2_PWRDWN, 14, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU3_CORE1_PWRDWN, 13, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU3_CORE0_PWRDWN, 12, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU2_CORE3_PWRDWN, 11, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU2_CORE2_PWRDWN, 10, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU2_CORE1_PWRDWN, 9, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU2_CORE0_PWRDWN, 8, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU1_CORE3_PWRDWN, 7, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU1_CORE2_PWRDWN, 6, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU1_CORE1_PWRDWN, 5, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU1_CORE0_PWRDWN, 4, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU0_CORE3_PWRDWN, 3, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU0_CORE2_PWRDWN, 2, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(PWR_CTRL1_IRQ_STATUS, APU0_CORE0_PWRDWN, 0, 1)
REG32(PWR_CTRL1_IRQ_MASK, 0x718)
    FIELD(PWR_CTRL1_IRQ_MASK, RPU_B_CORE1_PWRDWN, 23, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, RPU_B_CORE0_PWRDWN, 22, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, RPU_A_CORE1_PWRDWN, 21, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, RPU_A_CORE0_PWRDWN, 20, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU3_CLUSTER, 19, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU2_CLUSTER, 18, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU1_CLUSTER, 17, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU0_CLUSTER, 16, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU3_CORE3_PWRDWN, 15, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU3_CORE2_PWRDWN, 14, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU3_CORE1_PWRDWN, 13, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU3_CORE0_PWRDWN, 12, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU2_CORE3_PWRDWN, 11, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU2_CORE2_PWRDWN, 10, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU2_CORE1_PWRDWN, 9, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU2_CORE0_PWRDWN, 8, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU1_CORE3_PWRDWN, 7, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU1_CORE2_PWRDWN, 6, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU1_CORE1_PWRDWN, 5, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU1_CORE0_PWRDWN, 4, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU0_CORE3_PWRDWN, 3, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU0_CORE2_PWRDWN, 2, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(PWR_CTRL1_IRQ_MASK, APU0_CORE0_PWRDWN, 0, 1)
REG32(PWR_CTRL1_IRQ_EN, 0x71c)
    FIELD(PWR_CTRL1_IRQ_EN, RPU_B_CORE1_PWRDWN, 23, 1)
    FIELD(PWR_CTRL1_IRQ_EN, RPU_B_CORE0_PWRDWN, 22, 1)
    FIELD(PWR_CTRL1_IRQ_EN, RPU_A_CORE1_PWRDWN, 21, 1)
    FIELD(PWR_CTRL1_IRQ_EN, RPU_A_CORE0_PWRDWN, 20, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU3_CLUSTER, 19, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU2_CLUSTER, 18, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU1_CLUSTER, 17, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU0_CLUSTER, 16, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU3_CORE3_PWRDWN, 15, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU3_CORE2_PWRDWN, 14, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU3_CORE1_PWRDWN, 13, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU3_CORE0_PWRDWN, 12, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU2_CORE3_PWRDWN, 11, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU2_CORE2_PWRDWN, 10, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU2_CORE1_PWRDWN, 9, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU2_CORE0_PWRDWN, 8, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU1_CORE3_PWRDWN, 7, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU1_CORE2_PWRDWN, 6, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU1_CORE1_PWRDWN, 5, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU1_CORE0_PWRDWN, 4, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU0_CORE3_PWRDWN, 3, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU0_CORE2_PWRDWN, 2, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(PWR_CTRL1_IRQ_EN, APU0_CORE0_PWRDWN, 0, 1)
REG32(PWR_CTRL1_IRQ_DIS, 0x720)
    FIELD(PWR_CTRL1_IRQ_DIS, RPU_B_CORE1_PWRDWN, 23, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, RPU_B_CORE0_PWRDWN, 22, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, RPU_A_CORE1_PWRDWN, 21, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, RPU_A_CORE0_PWRDWN, 20, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU3_CLUSTER, 19, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU2_CLUSTER, 18, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU1_CLUSTER, 17, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU0_CLUSTER, 16, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU3_CORE3_PWRDWN, 15, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU3_CORE2_PWRDWN, 14, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU3_CORE1_PWRDWN, 13, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU3_CORE0_PWRDWN, 12, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU2_CORE3_PWRDWN, 11, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU2_CORE2_PWRDWN, 10, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU2_CORE1_PWRDWN, 9, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU2_CORE0_PWRDWN, 8, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU1_CORE3_PWRDWN, 7, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU1_CORE2_PWRDWN, 6, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU1_CORE1_PWRDWN, 5, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU1_CORE0_PWRDWN, 4, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU0_CORE3_PWRDWN, 3, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU0_CORE2_PWRDWN, 2, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(PWR_CTRL1_IRQ_DIS, APU0_CORE0_PWRDWN, 0, 1)
REG32(PWR_CTRL1_IRQ_TRIG, 0x724)
    FIELD(PWR_CTRL1_IRQ_TRIG, RPU_B_CORE1_PWRDWN, 23, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, RPU_B_CORE0_PWRDWN, 22, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, RPU_A_CORE1_PWRDWN, 21, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, RPU_A_CORE0_PWRDWN, 20, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU3_CLUSTER, 19, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU2_CLUSTER, 18, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU1_CLUSTER, 17, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU0_CLUSTER, 16, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU3_CORE3_PWRDWN, 15, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU3_CORE2_PWRDWN, 14, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU3_CORE1_PWRDWN, 13, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU3_CORE0_PWRDWN, 12, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU2_CORE3_PWRDWN, 11, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU2_CORE2_PWRDWN, 10, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU2_CORE1_PWRDWN, 9, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU2_CORE0_PWRDWN, 8, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU1_CORE3_PWRDWN, 7, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU1_CORE2_PWRDWN, 6, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU1_CORE1_PWRDWN, 5, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU1_CORE0_PWRDWN, 4, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU0_CORE3_PWRDWN, 3, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU0_CORE2_PWRDWN, 2, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(PWR_CTRL1_IRQ_TRIG, APU0_CORE0_PWRDWN, 0, 1)
REG32(GPI_STATUS, 0x728)
    FIELD(GPI_STATUS, GPI_31, 31, 1)
    FIELD(GPI_STATUS, GPI_30, 30, 1)
    FIELD(GPI_STATUS, GPI_29, 29, 1)
    FIELD(GPI_STATUS, GPI_28, 28, 1)
    FIELD(GPI_STATUS, GPI_27, 27, 1)
    FIELD(GPI_STATUS, GPI_26, 26, 1)
    FIELD(GPI_STATUS, GPI_25, 25, 1)
    FIELD(GPI_STATUS, GPI_24, 24, 1)
    FIELD(GPI_STATUS, GPI_23, 23, 1)
    FIELD(GPI_STATUS, GPI_22, 22, 1)
    FIELD(GPI_STATUS, GPI_21, 21, 1)
    FIELD(GPI_STATUS, GPI_20, 20, 1)
    FIELD(GPI_STATUS, GPI_19, 19, 1)
    FIELD(GPI_STATUS, GPI_18, 18, 1)
    FIELD(GPI_STATUS, GPI_17, 17, 1)
    FIELD(GPI_STATUS, GPI_16, 16, 1)
    FIELD(GPI_STATUS, GPI_15, 15, 1)
    FIELD(GPI_STATUS, GPI_14, 14, 1)
    FIELD(GPI_STATUS, GPI_13, 13, 1)
    FIELD(GPI_STATUS, GPI_12, 12, 1)
    FIELD(GPI_STATUS, GPI_11, 11, 1)
    FIELD(GPI_STATUS, GPI_10, 10, 1)
    FIELD(GPI_STATUS, GPI_9, 9, 1)
    FIELD(GPI_STATUS, GPI_8, 8, 1)
    FIELD(GPI_STATUS, GPI_7, 7, 1)
    FIELD(GPI_STATUS, GPI_6, 6, 1)
    FIELD(GPI_STATUS, GPI_5, 5, 1)
    FIELD(GPI_STATUS, GPI_4, 4, 1)
    FIELD(GPI_STATUS, GPI_3, 3, 1)
    FIELD(GPI_STATUS, GPI_2, 2, 1)
    FIELD(GPI_STATUS, GPI_1, 1, 1)
    FIELD(GPI_STATUS, GPI_0, 0, 1)
REG32(GPI_MASK, 0x72c)
    FIELD(GPI_MASK, GPI_31, 31, 1)
    FIELD(GPI_MASK, GPI_30, 30, 1)
    FIELD(GPI_MASK, GPI_29, 29, 1)
    FIELD(GPI_MASK, GPI_28, 28, 1)
    FIELD(GPI_MASK, GPI_27, 27, 1)
    FIELD(GPI_MASK, GPI_26, 26, 1)
    FIELD(GPI_MASK, GPI_25, 25, 1)
    FIELD(GPI_MASK, GPI_24, 24, 1)
    FIELD(GPI_MASK, GPI_23, 23, 1)
    FIELD(GPI_MASK, GPI_22, 22, 1)
    FIELD(GPI_MASK, GPI_21, 21, 1)
    FIELD(GPI_MASK, GPI_20, 20, 1)
    FIELD(GPI_MASK, GPI_19, 19, 1)
    FIELD(GPI_MASK, GPI_18, 18, 1)
    FIELD(GPI_MASK, GPI_17, 17, 1)
    FIELD(GPI_MASK, GPI_16, 16, 1)
    FIELD(GPI_MASK, GPI_15, 15, 1)
    FIELD(GPI_MASK, GPI_14, 14, 1)
    FIELD(GPI_MASK, GPI_13, 13, 1)
    FIELD(GPI_MASK, GPI_12, 12, 1)
    FIELD(GPI_MASK, GPI_11, 11, 1)
    FIELD(GPI_MASK, GPI_10, 10, 1)
    FIELD(GPI_MASK, GPI_9, 9, 1)
    FIELD(GPI_MASK, GPI_8, 8, 1)
    FIELD(GPI_MASK, GPI_7, 7, 1)
    FIELD(GPI_MASK, GPI_6, 6, 1)
    FIELD(GPI_MASK, GPI_5, 5, 1)
    FIELD(GPI_MASK, GPI_4, 4, 1)
    FIELD(GPI_MASK, GPI_3, 3, 1)
    FIELD(GPI_MASK, GPI_2, 2, 1)
    FIELD(GPI_MASK, GPI_1, 1, 1)
    FIELD(GPI_MASK, GPI_0, 0, 1)
REG32(GPI_EN, 0x730)
    FIELD(GPI_EN, GPI_31, 31, 1)
    FIELD(GPI_EN, GPI_30, 30, 1)
    FIELD(GPI_EN, GPI_29, 29, 1)
    FIELD(GPI_EN, GPI_28, 28, 1)
    FIELD(GPI_EN, GPI_27, 27, 1)
    FIELD(GPI_EN, GPI_26, 26, 1)
    FIELD(GPI_EN, GPI_25, 25, 1)
    FIELD(GPI_EN, GPI_24, 24, 1)
    FIELD(GPI_EN, GPI_23, 23, 1)
    FIELD(GPI_EN, GPI_22, 22, 1)
    FIELD(GPI_EN, GPI_21, 21, 1)
    FIELD(GPI_EN, GPI_20, 20, 1)
    FIELD(GPI_EN, GPI_19, 19, 1)
    FIELD(GPI_EN, GPI_18, 18, 1)
    FIELD(GPI_EN, GPI_17, 17, 1)
    FIELD(GPI_EN, GPI_16, 16, 1)
    FIELD(GPI_EN, GPI_15, 15, 1)
    FIELD(GPI_EN, GPI_14, 14, 1)
    FIELD(GPI_EN, GPI_13, 13, 1)
    FIELD(GPI_EN, GPI_12, 12, 1)
    FIELD(GPI_EN, GPI_11, 11, 1)
    FIELD(GPI_EN, GPI_10, 10, 1)
    FIELD(GPI_EN, GPI_9, 9, 1)
    FIELD(GPI_EN, GPI_8, 8, 1)
    FIELD(GPI_EN, GPI_7, 7, 1)
    FIELD(GPI_EN, GPI_6, 6, 1)
    FIELD(GPI_EN, GPI_5, 5, 1)
    FIELD(GPI_EN, GPI_4, 4, 1)
    FIELD(GPI_EN, GPI_3, 3, 1)
    FIELD(GPI_EN, GPI_2, 2, 1)
    FIELD(GPI_EN, GPI_1, 1, 1)
    FIELD(GPI_EN, GPI_0, 0, 1)
REG32(GPI_DIS, 0x734)
    FIELD(GPI_DIS, GPI_31, 31, 1)
    FIELD(GPI_DIS, GPI_30, 30, 1)
    FIELD(GPI_DIS, GPI_29, 29, 1)
    FIELD(GPI_DIS, GPI_28, 28, 1)
    FIELD(GPI_DIS, GPI_27, 27, 1)
    FIELD(GPI_DIS, GPI_26, 26, 1)
    FIELD(GPI_DIS, GPI_25, 25, 1)
    FIELD(GPI_DIS, GPI_24, 24, 1)
    FIELD(GPI_DIS, GPI_23, 23, 1)
    FIELD(GPI_DIS, GPI_22, 22, 1)
    FIELD(GPI_DIS, GPI_21, 21, 1)
    FIELD(GPI_DIS, GPI_20, 20, 1)
    FIELD(GPI_DIS, GPI_19, 19, 1)
    FIELD(GPI_DIS, GPI_18, 18, 1)
    FIELD(GPI_DIS, GPI_17, 17, 1)
    FIELD(GPI_DIS, GPI_16, 16, 1)
    FIELD(GPI_DIS, GPI_15, 15, 1)
    FIELD(GPI_DIS, GPI_14, 14, 1)
    FIELD(GPI_DIS, GPI_13, 13, 1)
    FIELD(GPI_DIS, GPI_12, 12, 1)
    FIELD(GPI_DIS, GPI_11, 11, 1)
    FIELD(GPI_DIS, GPI_10, 10, 1)
    FIELD(GPI_DIS, GPI_9, 9, 1)
    FIELD(GPI_DIS, GPI_8, 8, 1)
    FIELD(GPI_DIS, GPI_7, 7, 1)
    FIELD(GPI_DIS, GPI_6, 6, 1)
    FIELD(GPI_DIS, GPI_5, 5, 1)
    FIELD(GPI_DIS, GPI_4, 4, 1)
    FIELD(GPI_DIS, GPI_3, 3, 1)
    FIELD(GPI_DIS, GPI_2, 2, 1)
    FIELD(GPI_DIS, GPI_1, 1, 1)
    FIELD(GPI_DIS, GPI_0, 0, 1)
REG32(GPI_TRIG, 0x738)
    FIELD(GPI_TRIG, GPI_31, 31, 1)
    FIELD(GPI_TRIG, GPI_30, 30, 1)
    FIELD(GPI_TRIG, GPI_29, 29, 1)
    FIELD(GPI_TRIG, GPI_28, 28, 1)
    FIELD(GPI_TRIG, GPI_27, 27, 1)
    FIELD(GPI_TRIG, GPI_26, 26, 1)
    FIELD(GPI_TRIG, GPI_25, 25, 1)
    FIELD(GPI_TRIG, GPI_24, 24, 1)
    FIELD(GPI_TRIG, GPI_23, 23, 1)
    FIELD(GPI_TRIG, GPI_22, 22, 1)
    FIELD(GPI_TRIG, GPI_21, 21, 1)
    FIELD(GPI_TRIG, GPI_20, 20, 1)
    FIELD(GPI_TRIG, GPI_19, 19, 1)
    FIELD(GPI_TRIG, GPI_18, 18, 1)
    FIELD(GPI_TRIG, GPI_17, 17, 1)
    FIELD(GPI_TRIG, GPI_16, 16, 1)
    FIELD(GPI_TRIG, GPI_15, 15, 1)
    FIELD(GPI_TRIG, GPI_14, 14, 1)
    FIELD(GPI_TRIG, GPI_13, 13, 1)
    FIELD(GPI_TRIG, GPI_12, 12, 1)
    FIELD(GPI_TRIG, GPI_11, 11, 1)
    FIELD(GPI_TRIG, GPI_10, 10, 1)
    FIELD(GPI_TRIG, GPI_9, 9, 1)
    FIELD(GPI_TRIG, GPI_8, 8, 1)
    FIELD(GPI_TRIG, GPI_7, 7, 1)
    FIELD(GPI_TRIG, GPI_6, 6, 1)
    FIELD(GPI_TRIG, GPI_5, 5, 1)
    FIELD(GPI_TRIG, GPI_4, 4, 1)
    FIELD(GPI_TRIG, GPI_3, 3, 1)
    FIELD(GPI_TRIG, GPI_2, 2, 1)
    FIELD(GPI_TRIG, GPI_1, 1, 1)
    FIELD(GPI_TRIG, GPI_0, 0, 1)
REG32(DBG_PWR_ACK, 0x808)
    FIELD(DBG_PWR_ACK, FPD, 25, 1)
    FIELD(DBG_PWR_ACK, RPU_B_CORE1, 24, 1)
    FIELD(DBG_PWR_ACK, RPU_B_CORE0, 23, 1)
    FIELD(DBG_PWR_ACK, RPU_A_CORE1, 22, 1)
    FIELD(DBG_PWR_ACK, RPU_A_CORE0, 21, 1)
    FIELD(DBG_PWR_ACK, APU3_DSU, 20, 1)
    FIELD(DBG_PWR_ACK, APU2_DSU, 19, 1)
    FIELD(DBG_PWR_ACK, APU1_DSU, 17, 1)
    FIELD(DBG_PWR_ACK, APU0_DSU, 16, 1)
    FIELD(DBG_PWR_ACK, APU3_CORE3, 15, 1)
    FIELD(DBG_PWR_ACK, APU3_CORE2, 14, 1)
    FIELD(DBG_PWR_ACK, APU3_CORE1, 13, 1)
    FIELD(DBG_PWR_ACK, APU3_CORE0, 12, 1)
    FIELD(DBG_PWR_ACK, APU2_CORE3, 11, 1)
    FIELD(DBG_PWR_ACK, APU2_CORE2, 10, 1)
    FIELD(DBG_PWR_ACK, APU2_CORE1, 9, 1)
    FIELD(DBG_PWR_ACK, APU2_CORE0, 8, 1)
    FIELD(DBG_PWR_ACK, APU1_CORE3, 7, 1)
    FIELD(DBG_PWR_ACK, APU1_CORE2, 6, 1)
    FIELD(DBG_PWR_ACK, APU1_CORE1, 5, 1)
    FIELD(DBG_PWR_ACK, APU1_CORE0, 4, 1)
    FIELD(DBG_PWR_ACK, APU0_CORE3, 3, 1)
    FIELD(DBG_PWR_ACK, APU0_CORE2, 2, 1)
    FIELD(DBG_PWR_ACK, APU0_CORE1, 1, 1)
    FIELD(DBG_PWR_ACK, APU0_CORE0, 0, 1)
REG32(MEM_CLEAR_TRIGGER, 0x900)
    FIELD(MEM_CLEAR_TRIGGER, FPD, 27, 1)
    FIELD(MEM_CLEAR_TRIGGER, PKI, 26, 1)
    FIELD(MEM_CLEAR_TRIGGER, MMU, 25, 1)
    FIELD(MEM_CLEAR_TRIGGER, CML, 24, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN2, 21, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN1, 20, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CLUSTER, 19, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CLUSTER, 18, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CLUSTER, 17, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CLUSTER, 16, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CORE3, 15, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CORE2, 14, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CORE1, 13, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CORE0, 12, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CORE3, 11, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CORE2, 10, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CORE1, 9, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CORE0, 8, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CORE3, 7, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CORE2, 6, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CORE1, 5, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CORE0, 4, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CORE3, 3, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CORE2, 2, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CORE1, 1, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CORE0, 0, 1)
REG32(MEM_CLEAR_DONE, 0x904)
    FIELD(MEM_CLEAR_DONE, FPD, 27, 1)
    FIELD(MEM_CLEAR_DONE, PKI, 26, 1)
    FIELD(MEM_CLEAR_DONE, MMU, 25, 1)
    FIELD(MEM_CLEAR_DONE, CML, 24, 1)
    FIELD(MEM_CLEAR_DONE, CMN2, 21, 1)
    FIELD(MEM_CLEAR_DONE, CMN1, 20, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CLUSTER, 19, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CLUSTER, 18, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CLUSTER, 17, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CLUSTER, 16, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CORE3, 15, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CORE2, 14, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CORE1, 13, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CORE0, 12, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CORE3, 11, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CORE2, 10, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CORE1, 9, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CORE0, 8, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CORE3, 7, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CORE2, 6, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CORE1, 5, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CORE0, 4, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CORE3, 3, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CORE2, 2, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CORE1, 1, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CORE0, 0, 1)
REG32(MEM_CLEAR_PASS, 0x908)
    FIELD(MEM_CLEAR_PASS, FPD, 27, 1)
    FIELD(MEM_CLEAR_PASS, PKI, 26, 1)
    FIELD(MEM_CLEAR_PASS, MMU, 25, 1)
    FIELD(MEM_CLEAR_PASS, CML, 24, 1)
    FIELD(MEM_CLEAR_PASS, CMN2, 21, 1)
    FIELD(MEM_CLEAR_PASS, CMN1, 20, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CLUSTER, 19, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CLUSTER, 18, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CLUSTER, 17, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CLUSTER, 16, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CORE3, 15, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CORE2, 14, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CORE1, 13, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CORE0, 12, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CORE3, 11, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CORE2, 10, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CORE1, 9, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CORE0, 8, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CORE3, 7, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CORE2, 6, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CORE1, 5, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CORE0, 4, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CORE3, 3, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CORE2, 2, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CORE1, 1, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CORE0, 0, 1)
REG32(SCAN_CLEAR_TRIGGER, 0x920)
    FIELD(SCAN_CLEAR_TRIGGER, FPD, 27, 1)
    FIELD(SCAN_CLEAR_TRIGGER, PKI, 26, 1)
    FIELD(SCAN_CLEAR_TRIGGER, MMU, 25, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CML, 24, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN3_1, 23, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN3_0, 22, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN2, 21, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN1, 20, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CLUSTER, 19, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CLUSTER, 18, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CLUSTER, 17, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CLUSTER, 16, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CORE3, 15, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CORE2, 14, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CORE1, 13, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CORE0, 12, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CORE3, 11, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CORE2, 10, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CORE1, 9, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CORE0, 8, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CORE3, 7, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CORE2, 6, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CORE1, 5, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CORE0, 4, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CORE3, 3, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CORE2, 2, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CORE1, 1, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CORE0, 0, 1)
REG32(SCAN_CLEAR_DONE, 0x924)
    FIELD(SCAN_CLEAR_DONE, FPD, 27, 1)
    FIELD(SCAN_CLEAR_DONE, PKI, 26, 1)
    FIELD(SCAN_CLEAR_DONE, MMU, 25, 1)
    FIELD(SCAN_CLEAR_DONE, CML, 24, 1)
    FIELD(SCAN_CLEAR_DONE, CMN3_1, 23, 1)
    FIELD(SCAN_CLEAR_DONE, CMN3_0, 22, 1)
    FIELD(SCAN_CLEAR_DONE, CMN2, 21, 1)
    FIELD(SCAN_CLEAR_DONE, CMN1, 20, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CLUSTER, 19, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CLUSTER, 18, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CLUSTER, 17, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CLUSTER, 16, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CORE3, 15, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CORE2, 14, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CORE1, 13, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CORE0, 12, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CORE3, 11, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CORE2, 10, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CORE1, 9, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CORE0, 8, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CORE3, 7, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CORE2, 6, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CORE1, 5, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CORE0, 4, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CORE3, 3, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CORE2, 2, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CORE1, 1, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CORE0, 0, 1)
REG32(SCAN_CLEAR_PASS, 0x928)
    FIELD(SCAN_CLEAR_PASS, FPD, 27, 1)
    FIELD(SCAN_CLEAR_PASS, PKI, 26, 1)
    FIELD(SCAN_CLEAR_PASS, MMU, 25, 1)
    FIELD(SCAN_CLEAR_PASS, CML, 24, 1)
    FIELD(SCAN_CLEAR_PASS, CMN3_1, 23, 1)
    FIELD(SCAN_CLEAR_PASS, CMN3_0, 22, 1)
    FIELD(SCAN_CLEAR_PASS, CMN2, 21, 1)
    FIELD(SCAN_CLEAR_PASS, CMN1, 20, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CLUSTER, 19, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CLUSTER, 18, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CLUSTER, 17, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CLUSTER, 16, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CORE3, 15, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CORE2, 14, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CORE1, 13, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CORE0, 12, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CORE3, 11, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CORE2, 10, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CORE1, 9, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CORE0, 8, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CORE3, 7, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CORE2, 6, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CORE1, 5, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CORE0, 4, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CORE3, 3, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CORE2, 2, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CORE1, 1, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CORE0, 0, 1)
REG32(LPX_DFX_ERR, 0x950)
    FIELD(LPX_DFX_ERR, LPX, 4, 1)
    FIELD(LPX_DFX_ERR, RPUB, 3, 1)
    FIELD(LPX_DFX_ERR, RPUA, 2, 1)
    FIELD(LPX_DFX_ERR, IOU, 1, 1)
    FIELD(LPX_DFX_ERR, OCM, 0, 1)
REG32(SAFETY_CHK, 0xa00)

#define PSMX_GLOBAL_REG_R_MAX (R_SAFETY_CHK + 1)

typedef struct PSMX_GLOBAL_REG {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_req_pwrdwn_int;
    qemu_irq irq_gpi;
    qemu_irq irq_req_pwrup_int;
    qemu_irq irq_wakeup_irq;
    qemu_irq irq_req_swrst_int;
    qemu_irq irq_addr_error_int;
    qemu_irq irq_pwr_ctrl_irq;
    qemu_irq irq_req_iso_int;

    uint32_t regs[PSMX_GLOBAL_REG_R_MAX];
    RegisterInfo regs_info[PSMX_GLOBAL_REG_R_MAX];
} PSMX_GLOBAL_REG;

static void req_pwrdwn0_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_PWRDWN0_STATUS] &
                   ~s->regs[R_REQ_PWRDWN0_INT_MASK];
    qemu_set_irq(s->irq_req_pwrdwn_int, pending);
}

static void req_pwrdwn0_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    req_pwrdwn0_int_update_irq(s);
}

static uint64_t req_pwrdwn0_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN0_INT_MASK] &= ~val;
    req_pwrdwn0_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn0_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN0_INT_MASK] |= val;
    req_pwrdwn0_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn0_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN0_STATUS] |= val;
    req_pwrdwn0_int_update_irq(s);
    return 0;
}

static void gpi_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_GPI_STATUS] & ~s->regs[R_GPI_MASK];
    qemu_set_irq(s->irq_gpi, pending);
}

static void gpi_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    gpi_update_irq(s);
}

static uint64_t gpi_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_GPI_MASK] &= ~val;
    gpi_update_irq(s);
    return 0;
}

static uint64_t gpi_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_GPI_MASK] |= val;
    gpi_update_irq(s);
    return 0;
}

static uint64_t gpi_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_GPI_STATUS] |= val;
    gpi_update_irq(s);
    return 0;
}

static void req_pwrup0_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_PWRUP0_STATUS] &
                   ~s->regs[R_REQ_PWRUP0_INT_MASK];
    qemu_set_irq(s->irq_req_pwrup_int, pending);
}

static void req_pwrup0_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    req_pwrup0_int_update_irq(s);
}

static uint64_t req_pwrup0_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP0_INT_MASK] &= ~val;
    req_pwrup0_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup0_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP0_INT_MASK] |= val;
    req_pwrup0_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup0_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP0_STATUS] |= val;
    req_pwrup0_int_update_irq(s);
    return 0;
}

static void wakeup0_irq_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_WAKEUP0_IRQ_STATUS] &
                   ~s->regs[R_WAKEUP0_IRQ_MASK];
    qemu_set_irq(s->irq_wakeup_irq, pending);
}

static void wakeup0_irq_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    wakeup0_irq_update_irq(s);
}

static uint64_t wakeup0_irq_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP0_IRQ_MASK] &= ~val;
    wakeup0_irq_update_irq(s);
    return 0;
}

static uint64_t wakeup0_irq_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP0_IRQ_MASK] |= val;
    wakeup0_irq_update_irq(s);
    return 0;
}

static uint64_t wakeup0_irq_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP0_IRQ_STATUS] |= val;
    wakeup0_irq_update_irq(s);
    return 0;
}

static void req_swrst_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_SWRST_STATUS] &
                   ~s->regs[R_REQ_SWRST_INT_MASK];
    qemu_set_irq(s->irq_req_swrst_int, pending);
}

static void req_swrst_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    req_swrst_int_update_irq(s);
}

static uint64_t req_swrst_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_INT_MASK] &= ~val;
    req_swrst_int_update_irq(s);
    return 0;
}

static uint64_t req_swrst_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_INT_MASK] |= val;
    req_swrst_int_update_irq(s);
    return 0;
}

static uint64_t req_swrst_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_STATUS] |= val;
    req_swrst_int_update_irq(s);
    return 0;
}

static void req_pwrup1_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_PWRUP1_STATUS] &
                   ~s->regs[R_REQ_PWRUP1_INT_MASK];
    qemu_set_irq(s->irq_req_pwrup_int, pending);
}

static void req_pwrup1_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    req_pwrup1_int_update_irq(s);
}

static uint64_t req_pwrup1_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP1_INT_MASK] &= ~val;
    req_pwrup1_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup1_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP1_INT_MASK] |= val;
    req_pwrup1_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup1_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP1_STATUS] |= val;
    req_pwrup1_int_update_irq(s);
    return 0;
}

static void wakeup1_irq_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_WAKEUP1_IRQ_STATUS] &
                   ~s->regs[R_WAKEUP1_IRQ_MASK];
    qemu_set_irq(s->irq_wakeup_irq, pending);
}

static void wakeup1_irq_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    wakeup1_irq_update_irq(s);
}

static uint64_t wakeup1_irq_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP1_IRQ_MASK] &= ~val;
    wakeup1_irq_update_irq(s);
    return 0;
}

static uint64_t wakeup1_irq_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP1_IRQ_MASK] |= val;
    wakeup1_irq_update_irq(s);
    return 0;
}

static uint64_t wakeup1_irq_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP1_IRQ_STATUS] |= val;
    wakeup1_irq_update_irq(s);
    return 0;
}

static void addr_error_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_ADDR_ERROR_STATUS] &
                   ~s->regs[R_ADDR_ERROR_INT_MASK];
    qemu_set_irq(s->irq_addr_error_int, pending);
}

static void addr_error_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    addr_error_int_update_irq(s);
}

static uint64_t addr_error_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] &= ~val;
    addr_error_int_update_irq(s);
    return 0;
}

static uint64_t addr_error_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] |= val;
    addr_error_int_update_irq(s);
    return 0;
}

static void pwr_ctrl0_irq_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_PWR_CTRL0_IRQ_STATUS] &
                   ~s->regs[R_PWR_CTRL0_IRQ_MASK];
    qemu_set_irq(s->irq_pwr_ctrl_irq, pending);
}

static void pwr_ctrl0_irq_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    pwr_ctrl0_irq_update_irq(s);
}

static uint64_t pwr_ctrl0_irq_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL0_IRQ_MASK] &= ~val;
    pwr_ctrl0_irq_update_irq(s);
    return 0;
}

static uint64_t pwr_ctrl0_irq_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL0_IRQ_MASK] |= val;
    pwr_ctrl0_irq_update_irq(s);
    return 0;
}

static uint64_t pwr_ctrl0_irq_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL0_IRQ_STATUS] |= val;
    pwr_ctrl0_irq_update_irq(s);
    return 0;
}

static void req_pwrdwn1_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_PWRDWN1_STATUS] &
                   ~s->regs[R_REQ_PWRDWN1_INT_MASK];
    qemu_set_irq(s->irq_req_pwrdwn_int, pending);
}

static void req_pwrdwn1_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    req_pwrdwn1_int_update_irq(s);
}

static uint64_t req_pwrdwn1_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN1_INT_MASK] &= ~val;
    req_pwrdwn1_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn1_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN1_INT_MASK] |= val;
    req_pwrdwn1_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn1_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN1_STATUS] |= val;
    req_pwrdwn1_int_update_irq(s);
    return 0;
}

static void pwr_ctrl1_irq_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_PWR_CTRL1_IRQ_STATUS] &
                   ~s->regs[R_PWR_CTRL1_IRQ_MASK];
    qemu_set_irq(s->irq_pwr_ctrl_irq, pending);
}

static void pwr_ctrl1_irq_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    pwr_ctrl1_irq_update_irq(s);
}

static uint64_t pwr_ctrl1_irq_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL1_IRQ_MASK] &= ~val;
    pwr_ctrl1_irq_update_irq(s);
    return 0;
}

static uint64_t pwr_ctrl1_irq_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL1_IRQ_MASK] |= val;
    pwr_ctrl1_irq_update_irq(s);
    return 0;
}

static uint64_t pwr_ctrl1_irq_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL1_IRQ_STATUS] |= val;
    pwr_ctrl1_irq_update_irq(s);
    return 0;
}

static void req_iso_int_update_irq(PSMX_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_ISO_STATUS] & ~s->regs[R_REQ_ISO_INT_MASK];
    qemu_set_irq(s->irq_req_iso_int, pending);
}

static void req_iso_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    req_iso_int_update_irq(s);
}

static uint64_t req_iso_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_INT_MASK] &= ~val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t req_iso_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_INT_MASK] |= val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t req_iso_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_STATUS] |= val;
    req_iso_int_update_irq(s);
    return 0;
}

static void psmx_mem_clear_trig_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = (uint32_t)val64;

    s->regs[R_MEM_CLEAR_DONE] |= val;
    s->regs[R_MEM_CLEAR_PASS] |= val;
}

static void psmx_scan_clear_trig_postw(RegisterInfo *reg, uint64_t val64)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(reg->opaque);
    uint32_t val = (uint32_t)val64;

    s->regs[R_SCAN_CLEAR_DONE] |= val;
    s->regs[R_SCAN_CLEAR_PASS] |= val;
}

static const RegisterAccessInfo psmx_global_reg_regs_info[] = {
    {   .name = "GLOBAL_CNTRL",  .addr = A_GLOBAL_CNTRL,
        .reset = 0x8800,
        .rsvd = 0xfffc00ed,
        .ro = 0xffff00ed,
    },{ .name = "ADDR_ERROR_STATUS",  .addr = A_ADDR_ERROR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = addr_error_status_postw,
    },{ .name = "ADDR_ERROR_INT_MASK",  .addr = A_ADDR_ERROR_INT_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "ADDR_ERROR_INT_EN",  .addr = A_ADDR_ERROR_INT_EN,
        .pre_write = addr_error_int_en_prew,
    },{ .name = "ADDR_ERROR_INT_DIS",  .addr = A_ADDR_ERROR_INT_DIS,
        .pre_write = addr_error_int_dis_prew,
    },{ .name = "PS_SW_ERR",  .addr = A_PS_SW_ERR,
    },{ .name = "PSM_BOOT_SERV_ERR",  .addr = A_PSM_BOOT_SERV_ERR,
    },{ .name = "GLOBAL_GEN_STORAGE0",  .addr = A_GLOBAL_GEN_STORAGE0,
    },{ .name = "GLOBAL_GEN_STORAGE1",  .addr = A_GLOBAL_GEN_STORAGE1,
    },{ .name = "GLOBAL_GEN_STORAGE2",  .addr = A_GLOBAL_GEN_STORAGE2,
    },{ .name = "GLOBAL_GEN_STORAGE3",  .addr = A_GLOBAL_GEN_STORAGE3,
    },{ .name = "GLOBAL_GEN_STORAGE4",  .addr = A_GLOBAL_GEN_STORAGE4,
    },{ .name = "GLOBAL_GEN_STORAGE5",  .addr = A_GLOBAL_GEN_STORAGE5,
    },{ .name = "GLOBAL_GEN_STORAGE6",  .addr = A_GLOBAL_GEN_STORAGE6,
    },{ .name = "GLOBAL_GEN_STORAGE7",  .addr = A_GLOBAL_GEN_STORAGE7,
    },{ .name = "PERS_GLOB_GEN_STORAGE0",  .addr = A_PERS_GLOB_GEN_STORAGE0,
    },{ .name = "PERS_GLOB_GEN_STORAGE1",  .addr = A_PERS_GLOB_GEN_STORAGE1,
    },{ .name = "PERS_GLOB_GEN_STORAGE2",  .addr = A_PERS_GLOB_GEN_STORAGE2,
    },{ .name = "PERS_GLOB_GEN_STORAGE3",  .addr = A_PERS_GLOB_GEN_STORAGE3,
    },{ .name = "PERS_GLOB_GEN_STORAGE4",  .addr = A_PERS_GLOB_GEN_STORAGE4,
    },{ .name = "PERS_GLOB_GEN_STORAGE5",  .addr = A_PERS_GLOB_GEN_STORAGE5,
    },{ .name = "PERS_GLOB_GEN_STORAGE6",  .addr = A_PERS_GLOB_GEN_STORAGE6,
    },{ .name = "PERS_GLOB_GEN_STORAGE7",  .addr = A_PERS_GLOB_GEN_STORAGE7,
    },{ .name = "PWR_STATE0",  .addr = A_PWR_STATE0,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PWR_STATE1",  .addr = A_PWR_STATE1,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "AUX_PWR_STATE",  .addr = A_AUX_PWR_STATE,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP0_STATUS",  .addr = A_REQ_PWRUP0_STATUS,
        .w1c = 0xffffffff,
        .post_write = req_pwrup0_status_postw,
    },{ .name = "REQ_PWRUP0_INT_MASK",  .addr = A_REQ_PWRUP0_INT_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP0_INT_EN",  .addr = A_REQ_PWRUP0_INT_EN,
        .pre_write = req_pwrup0_int_en_prew,
    },{ .name = "REQ_PWRUP0_INT_DIS",  .addr = A_REQ_PWRUP0_INT_DIS,
        .pre_write = req_pwrup0_int_dis_prew,
    },{ .name = "REQ_PWRUP0_TRIG",  .addr = A_REQ_PWRUP0_TRIG,
        .pre_write = req_pwrup0_trig_prew,
    },{ .name = "REQ_PWRUP1_STATUS",  .addr = A_REQ_PWRUP1_STATUS,
        .rsvd = 0xcf0ff000,
        .w1c = 0xffffffff,
        .post_write = req_pwrup1_status_postw,
    },{ .name = "REQ_PWRUP1_INT_MASK",  .addr = A_REQ_PWRUP1_INT_MASK,
        .reset = 0x30f00fff,
        .rsvd = 0xcf0ff000,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP1_INT_EN",  .addr = A_REQ_PWRUP1_INT_EN,
        .rsvd = 0xcf0ff000,
        .pre_write = req_pwrup1_int_en_prew,
    },{ .name = "REQ_PWRUP1_INT_DIS",  .addr = A_REQ_PWRUP1_INT_DIS,
        .rsvd = 0xcf0ff000,
        .pre_write = req_pwrup1_int_dis_prew,
    },{ .name = "REQ_PWRUP1_TRIG",  .addr = A_REQ_PWRUP1_TRIG,
        .rsvd = 0xcf0ff000,
        .pre_write = req_pwrup1_trig_prew,
    },{ .name = "REQ_PWRDWN0_STATUS",  .addr = A_REQ_PWRDWN0_STATUS,
        .w1c = 0xffffffff,
        .post_write = req_pwrdwn0_status_postw,
    },{ .name = "REQ_PWRDWN0_INT_MASK",  .addr = A_REQ_PWRDWN0_INT_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRDWN0_INT_EN",  .addr = A_REQ_PWRDWN0_INT_EN,
        .pre_write = req_pwrdwn0_int_en_prew,
    },{ .name = "REQ_PWRDWN0_INT_DIS",  .addr = A_REQ_PWRDWN0_INT_DIS,
        .pre_write = req_pwrdwn0_int_dis_prew,
    },{ .name = "REQ_PWRDWN0_TRIG",  .addr = A_REQ_PWRDWN0_TRIG,
        .pre_write = req_pwrdwn0_trig_prew,
    },{ .name = "REQ_PWRDWN1_STATUS",  .addr = A_REQ_PWRDWN1_STATUS,
        .rsvd = 0xc0000000,
        .w1c = 0xffffffff,
        .post_write = req_pwrdwn1_status_postw,
    },{ .name = "REQ_PWRDWN1_INT_MASK",  .addr = A_REQ_PWRDWN1_INT_MASK,
        .reset = 0x3fffffff,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRDWN1_INT_EN",  .addr = A_REQ_PWRDWN1_INT_EN,
        .rsvd = 0xc0000000,
        .pre_write = req_pwrdwn1_int_en_prew,
    },{ .name = "REQ_PWRDWN1_INT_DIS",  .addr = A_REQ_PWRDWN1_INT_DIS,
        .rsvd = 0xc0000000,
        .pre_write = req_pwrdwn1_int_dis_prew,
    },{ .name = "REQ_PWRDWN1_TRIG",  .addr = A_REQ_PWRDWN1_TRIG,
        .rsvd = 0xc0000000,
        .pre_write = req_pwrdwn1_trig_prew,
    },{ .name = "REQ_ISO_STATUS",  .addr = A_REQ_ISO_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = req_iso_status_postw,
    },{ .name = "REQ_ISO_INT_MASK",  .addr = A_REQ_ISO_INT_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "REQ_ISO_INT_EN",  .addr = A_REQ_ISO_INT_EN,
        .pre_write = req_iso_int_en_prew,
    },{ .name = "REQ_ISO_INT_DIS",  .addr = A_REQ_ISO_INT_DIS,
        .pre_write = req_iso_int_dis_prew,
    },{ .name = "REQ_ISO_TRIG",  .addr = A_REQ_ISO_TRIG,
        .pre_write = req_iso_trig_prew,
    },{ .name = "REQ_SWRST_STATUS",  .addr = A_REQ_SWRST_STATUS,
        .w1c = 0xffffffff,
        .post_write = req_swrst_status_postw,
    },{ .name = "REQ_SWRST_INT_MASK",  .addr = A_REQ_SWRST_INT_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "REQ_SWRST_INT_EN",  .addr = A_REQ_SWRST_INT_EN,
        .pre_write = req_swrst_int_en_prew,
    },{ .name = "REQ_SWRST_INT_DIS",  .addr = A_REQ_SWRST_INT_DIS,
        .pre_write = req_swrst_int_dis_prew,
    },{ .name = "REQ_SWRST_TRIG",  .addr = A_REQ_SWRST_TRIG,
        .pre_write = req_swrst_trig_prew,
    },{ .name = "MB_FATAL",  .addr = A_MB_FATAL,
        .rsvd = 0xfffff8,
        .ro = 0xffffff,
    },{ .name = "MB1_FAULT_STATUS",  .addr = A_MB1_FAULT_STATUS,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "MB2_FAULT_STATUS",  .addr = A_MB2_FAULT_STATUS,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "MB3_FAULT_STATUS",  .addr = A_MB3_FAULT_STATUS,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "PSM_DEBUG_CTRL",  .addr = A_PSM_DEBUG_CTRL,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "WAKEUP0_IRQ_STATUS",  .addr = A_WAKEUP0_IRQ_STATUS,
        .rsvd = 0xf0000000,
        .w1c = 0xffffffff,
        .post_write = wakeup0_irq_status_postw,
    },{ .name = "WAKEUP0_IRQ_MASK",  .addr = A_WAKEUP0_IRQ_MASK,
        .reset = 0xfffffff,
        .rsvd = 0xf0000000,
        .ro = 0xffffffff,
    },{ .name = "WAKEUP0_IRQ_EN",  .addr = A_WAKEUP0_IRQ_EN,
        .rsvd = 0xf0000000,
        .pre_write = wakeup0_irq_en_prew,
    },{ .name = "WAKEUP0_IRQ_DIS",  .addr = A_WAKEUP0_IRQ_DIS,
        .rsvd = 0xf0000000,
        .pre_write = wakeup0_irq_dis_prew,
    },{ .name = "WAKEUP0_IRQ_TRIG",  .addr = A_WAKEUP0_IRQ_TRIG,
        .rsvd = 0xf0000000,
        .pre_write = wakeup0_irq_trig_prew,
    },{ .name = "WAKEUP1_IRQ_STATUS",  .addr = A_WAKEUP1_IRQ_STATUS,
        .rsvd = 0x80000000,
        .w1c = 0xffffffff,
        .post_write = wakeup1_irq_status_postw,
    },{ .name = "WAKEUP1_IRQ_MASK",  .addr = A_WAKEUP1_IRQ_MASK,
        .reset = 0x7fffffff,
        .rsvd = 0x80000000,
        .ro = 0xffffffff,
    },{ .name = "WAKEUP1_IRQ_EN",  .addr = A_WAKEUP1_IRQ_EN,
        .rsvd = 0x80000000,
        .pre_write = wakeup1_irq_en_prew,
    },{ .name = "WAKEUP1_IRQ_DIS",  .addr = A_WAKEUP1_IRQ_DIS,
        .rsvd = 0x80000000,
        .pre_write = wakeup1_irq_dis_prew,
    },{ .name = "WAKEUP1_IRQ_TRIG",  .addr = A_WAKEUP1_IRQ_TRIG,
        .rsvd = 0x80000000,
        .pre_write = wakeup1_irq_trig_prew,
    },{ .name = "PWR_CTRL0_IRQ_STATUS",  .addr = A_PWR_CTRL0_IRQ_STATUS,
        .w1c = 0xffffffff,
        .post_write = pwr_ctrl0_irq_status_postw,
    },{ .name = "PWR_CTRL0_IRQ_MASK",  .addr = A_PWR_CTRL0_IRQ_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PWR_CTRL0_IRQ_EN",  .addr = A_PWR_CTRL0_IRQ_EN,
        .pre_write = pwr_ctrl0_irq_en_prew,
    },{ .name = "PWR_CTRL0_IRQ_DIS",  .addr = A_PWR_CTRL0_IRQ_DIS,
        .pre_write = pwr_ctrl0_irq_dis_prew,
    },{ .name = "PWR_CTRL0_IRQ_TRIG",  .addr = A_PWR_CTRL0_IRQ_TRIG,
        .pre_write = pwr_ctrl0_irq_trig_prew,
    },{ .name = "PWR_CTRL1_IRQ_STATUS",  .addr = A_PWR_CTRL1_IRQ_STATUS,
        .rsvd = 0xff000000,
        .w1c = 0xffffffff,
        .post_write = pwr_ctrl1_irq_status_postw,
    },{ .name = "PWR_CTRL1_IRQ_MASK",  .addr = A_PWR_CTRL1_IRQ_MASK,
        .reset = 0xffffff,
        .rsvd = 0xff000000,
        .ro = 0xffffffff,
    },{ .name = "PWR_CTRL1_IRQ_EN",  .addr = A_PWR_CTRL1_IRQ_EN,
        .rsvd = 0xff000000,
        .pre_write = pwr_ctrl1_irq_en_prew,
    },{ .name = "PWR_CTRL1_IRQ_DIS",  .addr = A_PWR_CTRL1_IRQ_DIS,
        .rsvd = 0xff000000,
        .pre_write = pwr_ctrl1_irq_dis_prew,
    },{ .name = "PWR_CTRL1_IRQ_TRIG",  .addr = A_PWR_CTRL1_IRQ_TRIG,
        .rsvd = 0xff000000,
        .pre_write = pwr_ctrl1_irq_trig_prew,
    },{ .name = "GPI_STATUS",  .addr = A_GPI_STATUS,
        .w1c = 0xffffffff,
        .post_write = gpi_status_postw,
    },{ .name = "GPI_MASK",  .addr = A_GPI_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "GPI_EN",  .addr = A_GPI_EN,
        .pre_write = gpi_en_prew,
    },{ .name = "GPI_DIS",  .addr = A_GPI_DIS,
        .pre_write = gpi_dis_prew,
    },{ .name = "GPI_TRIG",  .addr = A_GPI_TRIG,
        .pre_write = gpi_trig_prew,
    },{ .name = "DBG_PWR_ACK",  .addr = A_DBG_PWR_ACK,
        .rsvd = 0xfc000000,
    },{ .name = "MEM_CLEAR_TRIGGER",  .addr = A_MEM_CLEAR_TRIGGER,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
        .post_write = psmx_mem_clear_trig_postw,
    },{ .name = "MEM_CLEAR_DONE",  .addr = A_MEM_CLEAR_DONE,
        .rsvd = 0xf0000000,
        .ro = 0xffffffff,
    },{ .name = "MEM_CLEAR_PASS",  .addr = A_MEM_CLEAR_PASS,
        .rsvd = 0xf0000000,
        .ro = 0xffffffff,
    },{ .name = "SCAN_CLEAR_TRIGGER",  .addr = A_SCAN_CLEAR_TRIGGER,
        .rsvd = 0xf0000000,
        .ro = 0xf0000000,
        .post_write = psmx_scan_clear_trig_postw,
    },{ .name = "SCAN_CLEAR_DONE",  .addr = A_SCAN_CLEAR_DONE,
        .rsvd = 0xf0000000,
        .ro = 0xffffffff,
    },{ .name = "SCAN_CLEAR_PASS",  .addr = A_SCAN_CLEAR_PASS,
        .rsvd = 0xf0000000,
        .ro = 0xffffffff,
    },{ .name = "LPX_DFX_ERR",  .addr = A_LPX_DFX_ERR,
        .rsvd = 0xffffffe0,
        .w1c = 0xffffffff,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    }
};

static void pwr_state_h(void *opaque, int n, int level)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(opaque);

    if (n < 32) {
        s->regs[R_PWR_STATE0] = deposit32(s->regs[R_PWR_STATE0], n, 1, level);
    } else {
        s->regs[R_PWR_STATE1] = deposit32(s->regs[R_PWR_STATE1], n - 32, 1,
                                          level);
    }
}

static void aux_pwr_state_h(void *opaque, int n, int level)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(opaque);

    s->regs[R_AUX_PWR_STATE] = deposit32(s->regs[R_AUX_PWR_STATE],
                                         n, 1, level);
}

static void apu_standby_h(void *opaque, int n, int level)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(opaque);

    s->regs[R_PWR_CTRL0_IRQ_STATUS] |= level <<
                            R_PWR_CTRL0_IRQ_STATUS_APU_STANDBY_SHIFT;
}

static void rpu_standby_h(void *opaque, int n, int level)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(opaque);

    s->regs[R_PWR_CTRL0_IRQ_STATUS] |= level <<
                            R_PWR_CTRL0_IRQ_STATUS_RPU_STANDBY_SHIFT;
}

static void psmx_global_reg_reset_enter(Object *obj, ResetType type)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void psmx_global_reg_reset_hold(Object *obj)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(obj);

    req_pwrdwn0_int_update_irq(s);
    gpi_update_irq(s);
    req_pwrup0_int_update_irq(s);
    wakeup0_irq_update_irq(s);
    req_swrst_int_update_irq(s);
    req_pwrup1_int_update_irq(s);
    wakeup1_irq_update_irq(s);
    addr_error_int_update_irq(s);
    pwr_ctrl0_irq_update_irq(s);
    req_pwrdwn1_int_update_irq(s);
    pwr_ctrl1_irq_update_irq(s);
    req_iso_int_update_irq(s);
}

static const MemoryRegionOps psmx_global_reg_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void psmx_global_reg_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void psmx_global_reg_init(Object *obj)
{
    PSMX_GLOBAL_REG *s = XILINX_PSMX_GLOBAL_REG(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSMX_GLOBAL_REG,
                       PSMX_GLOBAL_REG_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psmx_global_reg_regs_info,
                              ARRAY_SIZE(psmx_global_reg_regs_info),
                              s->regs_info, s->regs,
                              &psmx_global_reg_ops,
                              XILINX_PSMX_GLOBAL_REG_ERR_DEBUG,
                              PSMX_GLOBAL_REG_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_req_pwrdwn_int);
    sysbus_init_irq(sbd, &s->irq_wakeup_irq);
    sysbus_init_irq(sbd, &s->irq_req_swrst_int);
    sysbus_init_irq(sbd, &s->irq_req_pwrup_int);
    sysbus_init_irq(sbd, &s->irq_pwr_ctrl_irq);
    sysbus_init_irq(sbd, &s->irq_req_iso_int);
    sysbus_init_irq(sbd, &s->irq_addr_error_int);
    sysbus_init_irq(sbd, &s->irq_gpi);

    qdev_init_gpio_in_named(DEVICE(obj), pwr_state_h, "pwr-state0", 35);
    qdev_init_gpio_in_named(DEVICE(obj), aux_pwr_state_h, "aux-pwr-state", 32);
    qdev_init_gpio_in_named(DEVICE(obj), apu_standby_h, "apu-wfi", 16);
    qdev_init_gpio_in_named(DEVICE(obj), rpu_standby_h, "rpu-wfi", 4);
}

static const VMStateDescription vmstate_psmx_global_reg = {
    .name = TYPE_XILINX_PSMX_GLOBAL_REG,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSMX_GLOBAL_REG, PSMX_GLOBAL_REG_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet psmx_local_reg_gpios[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
            { .name = "pwr-state0", .fdt_index = 0, .range = 35 },
            { .name = "aux-pwr-state", .fdt_index = 35, .range = 32 },
            { },
        },
    },
    { },
};

static const FDTGenericGPIOSet psmx_local_controller_gpios[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
            { .name = "apu-wfi", .fdt_index = 67, .range = 16 },
            { .name = "rpu-wfi", .fdt_index = 83, .range = 4 },
            { },
        },
    },
    { },
};

static void psmx_global_reg_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->realize = psmx_global_reg_realize;
    dc->vmsd = &vmstate_psmx_global_reg;
    rc->phases.enter = psmx_global_reg_reset_enter;
    rc->phases.hold = psmx_global_reg_reset_hold;
    fggc->client_gpios = psmx_local_reg_gpios;
    fggc->controller_gpios = psmx_local_controller_gpios;
}

static const TypeInfo psmx_global_reg_info = {
    .name          = TYPE_XILINX_PSMX_GLOBAL_REG,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSMX_GLOBAL_REG),
    .class_init    = psmx_global_reg_class_init,
    .instance_init = psmx_global_reg_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void psmx_global_reg_register_types(void)
{
    type_register_static(&psmx_global_reg_info);
}

type_init(psmx_global_reg_register_types)
