/*
 * QEMU model of the GTYP_NPI_SLAVE 
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2022-05-02.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_GTYP_NPI_SLAVE_ERR_DEBUG
#define XILINX_GTYP_NPI_SLAVE_ERR_DEBUG 0
#endif

#define TYPE_XILINX_GTYP_NPI_SLAVE "xlnx.gtyp_npi_slave"

#define XILINX_GTYP_NPI_SLAVE(obj) \
     OBJECT_CHECK(GTYP_NPI_SLAVE, (obj), TYPE_XILINX_GTYP_NPI_SLAVE)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, BISR_TRIGGER, 29, 1)
    FIELD(REG_PCSR_MASK, BISR_TEST_CLR, 28, 1)
    FIELD(REG_PCSR_MASK, SHUTDOWN, 27, 1)
    FIELD(REG_PCSR_MASK, SELCTRLCFG, 26, 1)
    FIELD(REG_PCSR_MASK, SELNPICLK, 25, 1)
    FIELD(REG_PCSR_MASK, INITCTRL, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, PWRDN, 14, 1)
    FIELD(REG_PCSR_MASK, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_MASK, APBEN, 12, 1)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, TRISTATE, 8, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, BISR_TRIGGER, 29, 1)
    FIELD(REG_PCSR_CONTROL, BISR_TEST_CLR, 28, 1)
    FIELD(REG_PCSR_CONTROL, SHUTDOWN, 27, 1)
    FIELD(REG_PCSR_CONTROL, SELCTRLCFG, 26, 1)
    FIELD(REG_PCSR_CONTROL, SELNPICLK, 25, 1)
    FIELD(REG_PCSR_CONTROL, INITCTRL, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, PWRDN, 14, 1)
    FIELD(REG_PCSR_CONTROL, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_CONTROL, APBEN, 12, 1)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, TRISTATE, 8, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, GTPOWERGOOD, 21, 1)
    FIELD(REG_PCSR_STATUS, BISR_PASS, 20, 1)
    FIELD(REG_PCSR_STATUS, BISR_DONE, 19, 1)
    FIELD(REG_PCSR_STATUS, SHUTDOWN_COMPLETE, 18, 1)
    FIELD(REG_PCSR_STATUS, HOUSECLEAN_DONE, 17, 1)
    FIELD(REG_PCSR_STATUS, RESETERROR, 16, 1)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)

#define GTYP_NPI_SLAVE_R_MAX (R_REG_PCSR_LOCK + 1)

typedef struct GTYP_NPI_SLAVE {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[GTYP_NPI_SLAVE_R_MAX];
    RegisterInfo regs_info[GTYP_NPI_SLAVE_R_MAX];
} GTYP_NPI_SLAVE;

static void reg_pcsr_ctrl_postw(RegisterInfo *reg, uint64_t val)
{
    GTYP_NPI_SLAVE *s = XILINX_GTYP_NPI_SLAVE(reg->opaque);
    uint32_t val32 = val;

    s->regs[R_REG_PCSR_STATUS] |=
        (val32 & R_REG_PCSR_CONTROL_MEM_CLEAR_TRIGGER_MASK ?
                 (R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK |
                 R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK): 0)|
        (val32 & R_REG_PCSR_CONTROL_SHUTDOWN_MASK ?
                 R_REG_PCSR_STATUS_SHUTDOWN_COMPLETE_MASK: 0) |
        (val32 & R_REG_PCSR_CONTROL_BISR_TRIGGER_MASK ?
                 (R_REG_PCSR_STATUS_BISR_DONE_MASK |
                 R_REG_PCSR_STATUS_BISR_PASS_MASK): 0);
}

static void reg_pcsr_lock_postw(RegisterInfo *reg, uint64_t val)
{
    GTYP_NPI_SLAVE *s = XILINX_GTYP_NPI_SLAVE(reg->opaque);

    s->regs[R_REG_PCSR_STATUS] &= ~R_REG_PCSR_STATUS_PCSRLOCK_MASK;

    if (val != 0xf9e8d7c6) {
        s->regs[R_REG_PCSR_STATUS] |= val & R_REG_PCSR_LOCK_STATE_MASK;
    }
}

static const RegisterAccessInfo gtyp_npi_slave_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xc0e00cbc,
        .ro = 0xe00cbc,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1000142,
        .rsvd = 0xc0e00cbc,
        .ro = 0xe00cbc,
        .post_write = reg_pcsr_ctrl_postw,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = 0x1 |
                 R_REG_PCSR_STATUS_CALDONE_MASK |
                 R_REG_PCSR_STATUS_HOUSECLEAN_DONE_MASK |
                 R_REG_PCSR_STATUS_GTPOWERGOOD_MASK,
        .rsvd = 0xffc0c006,
        .ro = 0x3fffff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .post_write = reg_pcsr_lock_postw,
    }
};

static void gtyp_npi_slave_reset_enter(Object *obj, ResetType type)
{
    GTYP_NPI_SLAVE *s = XILINX_GTYP_NPI_SLAVE(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps gtyp_npi_slave_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void gtyp_npi_slave_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void gtyp_npi_slave_init(Object *obj)
{
    GTYP_NPI_SLAVE *s = XILINX_GTYP_NPI_SLAVE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_GTYP_NPI_SLAVE, GTYP_NPI_SLAVE_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), gtyp_npi_slave_regs_info,
                              ARRAY_SIZE(gtyp_npi_slave_regs_info),
                              s->regs_info, s->regs,
                              &gtyp_npi_slave_ops,
                              XILINX_GTYP_NPI_SLAVE_ERR_DEBUG,
                              GTYP_NPI_SLAVE_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_gtyp_npi_slave = {
    .name = TYPE_XILINX_GTYP_NPI_SLAVE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, GTYP_NPI_SLAVE, GTYP_NPI_SLAVE_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void gtyp_npi_slave_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = gtyp_npi_slave_realize;
    dc->vmsd = &vmstate_gtyp_npi_slave;
    rc->phases.enter = gtyp_npi_slave_reset_enter;
}

static const TypeInfo gtyp_npi_slave_info = {
    .name          = TYPE_XILINX_GTYP_NPI_SLAVE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(GTYP_NPI_SLAVE),
    .class_init    = gtyp_npi_slave_class_init,
    .instance_init = gtyp_npi_slave_init,
};

static void gtyp_npi_slave_register_types(void)
{
    type_register_static(&gtyp_npi_slave_info);
}

type_init(gtyp_npi_slave_register_types)
