/*
 * QEMU model of the FPD_SLCR_SECURE Global system level control registers for
 * the full power domain
 *
 * Copyright (c) 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-09-03.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "qemu/log.h"

/* Skeleton model */

#ifndef XILINX_FPD_SLCR_SECURE_ERR_DEBUG
#define XILINX_FPD_SLCR_SECURE_ERR_DEBUG 0
#endif

#define TYPE_XILINX_FPD_SLCR_SECURE "xlnx,versal-fpd-slcr-secure"

#define XILINX_FPD_SLCR_SECURE(obj) \
     OBJECT_CHECK(FPD_SLCR_SECURE, (obj), TYPE_XILINX_FPD_SLCR_SECURE)

REG32(WPROT0, 0x0)
    FIELD(WPROT0, ACTIVE, 0, 1)
REG32(CTRL, 0x4)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x8)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0xc)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x10)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x14)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x18)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)
REG32(FPD_TZ_CTRL_TZ_APU_DUAL, 0x104)
    FIELD(FPD_TZ_CTRL_TZ_APU_DUAL, N, 0, 1)
REG32(FPD_TZ_CTRL_TZ_XMPU, 0x108)
    FIELD(FPD_TZ_CTRL_TZ_XMPU, N, 0, 1)
REG32(FPD_TZ_CTRL_TZ_FPD_SLCR, 0x10c)
    FIELD(FPD_TZ_CTRL_TZ_FPD_SLCR, N, 0, 1)
REG32(FPD_TZ_CTRL_TZ_CRF, 0x110)
    FIELD(FPD_TZ_CTRL_TZ_CRF, N, 0, 1)
REG32(FPD_TZ_CTRL_TZ_AFIFM0, 0x114)
    FIELD(FPD_TZ_CTRL_TZ_AFIFM0, AXI_N, 0, 1)
REG32(FPD_TZ_CTRL_TZ_AFIFM2, 0x118)
    FIELD(FPD_TZ_CTRL_TZ_AFIFM2, AXI_N, 0, 1)
REG32(FPD_TZ_CTRL_CCI, 0x11c)
    FIELD(FPD_TZ_CTRL_CCI, TZ_N, 0, 1)
REG32(FPD_TZ_CTRL_SMMU, 0x120)
    FIELD(FPD_TZ_CTRL_SMMU, TZ_N, 0, 1)
REG32(TZPROT, 0xff8)
    FIELD(TZPROT, ACTIVE, 0, 1)
REG32(ECO, 0xffc)

#define FPD_SLCR_SECURE_R_MAX (R_ECO + 1)

typedef struct FPD_SLCR_SECURE {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr;

    uint32_t regs[FPD_SLCR_SECURE_R_MAX];
    RegisterInfo regs_info[FPD_SLCR_SECURE_R_MAX];
} FPD_SLCR_SECURE;

static void imr_update_irq(FPD_SLCR_SECURE *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR_SECURE *s = XILINX_FPD_SLCR_SECURE(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR_SECURE *s = XILINX_FPD_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR_SECURE *s = XILINX_FPD_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    FPD_SLCR_SECURE *s = XILINX_FPD_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR] |= val;
    imr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo fpd_slcr_secure_regs_info[] = {
    {   .name = "WPROT0",  .addr = A_WPROT0,
    },{ .name = "CTRL",  .addr = A_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "ISR",  .addr = A_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "IER",  .addr = A_IER,
        .rsvd = 0xfffffffe,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .rsvd = 0xfffffffe,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .rsvd = 0xfffffffe,
        .pre_write = itr_prew,
    },{ .name = "FPD_TZ_CTRL_TZ_APU_DUAL",  .addr = A_FPD_TZ_CTRL_TZ_APU_DUAL,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_TZ_XMPU",  .addr = A_FPD_TZ_CTRL_TZ_XMPU,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_TZ_FPD_SLCR",  .addr = A_FPD_TZ_CTRL_TZ_FPD_SLCR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_TZ_CRF",  .addr = A_FPD_TZ_CTRL_TZ_CRF,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_TZ_AFIFM0",  .addr = A_FPD_TZ_CTRL_TZ_AFIFM0,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_TZ_AFIFM2",  .addr = A_FPD_TZ_CTRL_TZ_AFIFM2,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_CCI",  .addr = A_FPD_TZ_CTRL_CCI,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "FPD_TZ_CTRL_SMMU",  .addr = A_FPD_TZ_CTRL_SMMU,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "TZPROT",  .addr = A_TZPROT,
    },{ .name = "ECO",  .addr = A_ECO,
    }
};

static void fpd_slcr_secure_reset(DeviceState *dev)
{
    FPD_SLCR_SECURE *s = XILINX_FPD_SLCR_SECURE(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    imr_update_irq(s);
}

static const MemoryRegionOps fpd_slcr_secure_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void fpd_slcr_secure_init(Object *obj)
{
    FPD_SLCR_SECURE *s = XILINX_FPD_SLCR_SECURE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_FPD_SLCR_SECURE,
                       FPD_SLCR_SECURE_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), fpd_slcr_secure_regs_info,
                              ARRAY_SIZE(fpd_slcr_secure_regs_info),
                              s->regs_info, s->regs,
                              &fpd_slcr_secure_ops,
                              XILINX_FPD_SLCR_SECURE_ERR_DEBUG,
                              FPD_SLCR_SECURE_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr);
}

static const VMStateDescription vmstate_fpd_slcr_secure = {
    .name = TYPE_XILINX_FPD_SLCR_SECURE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, FPD_SLCR_SECURE, FPD_SLCR_SECURE_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void fpd_slcr_secure_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = fpd_slcr_secure_reset;
    dc->vmsd = &vmstate_fpd_slcr_secure;
}

static const TypeInfo fpd_slcr_secure_info = {
    .name          = TYPE_XILINX_FPD_SLCR_SECURE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(FPD_SLCR_SECURE),
    .class_init    = fpd_slcr_secure_class_init,
    .instance_init = fpd_slcr_secure_init,
};

static void fpd_slcr_secure_register_types(void)
{
    type_register_static(&fpd_slcr_secure_info);
}

type_init(fpd_slcr_secure_register_types)
