/*
 * QEMU model of the DDRMC_MAIN MC that supports DDR4 and LPDDR4
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-09-03.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_DDRMC_MAIN_ERR_DEBUG
#define XILINX_DDRMC_MAIN_ERR_DEBUG 0
#endif

#define TYPE_XILINX_DDRMC_MAIN "xlnx.versal-ddrmc-main"

#define XILINX_DDRMC_MAIN(obj) \
     OBJECT_CHECK(DDRMC_MAIN, (obj), TYPE_XILINX_DDRMC_MAIN)

REG32(PCSR_LOCK, 0xc)
    FIELD(PCSR_LOCK, STATE, 0, 1)
REG32(DDRMC_ISR, 0x14)
    FIELD(DDRMC_ISR, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_ISR, USER_1, 30, 1)
    FIELD(DDRMC_ISR, USER_0, 29, 1)
    FIELD(DDRMC_ISR, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_ISR, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_ISR, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_ISR, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_ISR, NA_CMD1, 24, 1)
    FIELD(DDRMC_ISR, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_ISR, NA_CMD0, 22, 1)
    FIELD(DDRMC_ISR, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_ISR, NA_CMD, 20, 1)
    FIELD(DDRMC_ISR, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_ISR, CE1_ECC1, 18, 1)
    FIELD(DDRMC_ISR, CE0_ECC1, 17, 1)
    FIELD(DDRMC_ISR, CE1_ECC0, 16, 1)
    FIELD(DDRMC_ISR, CE0_ECC0, 15, 1)
    FIELD(DDRMC_ISR, UC1_ECC1, 14, 1)
    FIELD(DDRMC_ISR, UC0_ECC1, 13, 1)
    FIELD(DDRMC_ISR, UC1_ECC0, 12, 1)
    FIELD(DDRMC_ISR, UC0_ECC0, 11, 1)
    FIELD(DDRMC_ISR, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_ISR, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_ISR, XMPU, 8, 1)
    FIELD(DDRMC_ISR, NSU_3, 7, 1)
    FIELD(DDRMC_ISR, NSU_2, 6, 1)
    FIELD(DDRMC_ISR, NSU_1, 5, 1)
    FIELD(DDRMC_ISR, NSU_0, 4, 1)
    FIELD(DDRMC_ISR, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_ISR, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_ISR, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_ISR, NSU_FATAL0, 0, 1)
REG32(DDRMC_ITR, 0x18)
    FIELD(DDRMC_ITR, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_ITR, USER_1, 30, 1)
    FIELD(DDRMC_ITR, USER_0, 29, 1)
    FIELD(DDRMC_ITR, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_ITR, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_ITR, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_ITR, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_ITR, NA_CMD1, 24, 1)
    FIELD(DDRMC_ITR, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_ITR, NA_CMD0, 22, 1)
    FIELD(DDRMC_ITR, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_ITR, NA_CMD, 20, 1)
    FIELD(DDRMC_ITR, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_ITR, CE1_ECC1, 18, 1)
    FIELD(DDRMC_ITR, CE0_ECC1, 17, 1)
    FIELD(DDRMC_ITR, CE1_ECC0, 16, 1)
    FIELD(DDRMC_ITR, CE0_ECC0, 15, 1)
    FIELD(DDRMC_ITR, UC1_ECC1, 14, 1)
    FIELD(DDRMC_ITR, UC0_ECC1, 13, 1)
    FIELD(DDRMC_ITR, UC1_ECC0, 12, 1)
    FIELD(DDRMC_ITR, UC0_ECC0, 11, 1)
    FIELD(DDRMC_ITR, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_ITR, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_ITR, XMPU, 8, 1)
    FIELD(DDRMC_ITR, NSU_3, 7, 1)
    FIELD(DDRMC_ITR, NSU_2, 6, 1)
    FIELD(DDRMC_ITR, NSU_1, 5, 1)
    FIELD(DDRMC_ITR, NSU_0, 4, 1)
    FIELD(DDRMC_ITR, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_ITR, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_ITR, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_ITR, NSU_FATAL0, 0, 1)
REG32(DDRMC_IMR0, 0x1c)
    FIELD(DDRMC_IMR0, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_IMR0, USER_1, 30, 1)
    FIELD(DDRMC_IMR0, USER_0, 29, 1)
    FIELD(DDRMC_IMR0, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_IMR0, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_IMR0, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_IMR0, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_IMR0, NA_CMD1, 24, 1)
    FIELD(DDRMC_IMR0, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_IMR0, NA_CMD0, 22, 1)
    FIELD(DDRMC_IMR0, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_IMR0, NA_CMD, 20, 1)
    FIELD(DDRMC_IMR0, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_IMR0, CE1_ECC1, 18, 1)
    FIELD(DDRMC_IMR0, CE0_ECC1, 17, 1)
    FIELD(DDRMC_IMR0, CE1_ECC0, 16, 1)
    FIELD(DDRMC_IMR0, CE0_ECC0, 15, 1)
    FIELD(DDRMC_IMR0, UC1_ECC1, 14, 1)
    FIELD(DDRMC_IMR0, UC0_ECC1, 13, 1)
    FIELD(DDRMC_IMR0, UC1_ECC0, 12, 1)
    FIELD(DDRMC_IMR0, UC0_ECC0, 11, 1)
    FIELD(DDRMC_IMR0, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_IMR0, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_IMR0, XMPU, 8, 1)
    FIELD(DDRMC_IMR0, NSU_3, 7, 1)
    FIELD(DDRMC_IMR0, NSU_2, 6, 1)
    FIELD(DDRMC_IMR0, NSU_1, 5, 1)
    FIELD(DDRMC_IMR0, NSU_0, 4, 1)
    FIELD(DDRMC_IMR0, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_IMR0, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_IMR0, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_IMR0, NSU_FATAL0, 0, 1)
REG32(DDRMC_IER0, 0x20)
    FIELD(DDRMC_IER0, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_IER0, USER_1, 30, 1)
    FIELD(DDRMC_IER0, USER_0, 29, 1)
    FIELD(DDRMC_IER0, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_IER0, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_IER0, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_IER0, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_IER0, NA_CMD1, 24, 1)
    FIELD(DDRMC_IER0, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_IER0, NA_CMD0, 22, 1)
    FIELD(DDRMC_IER0, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_IER0, NA_CMD, 20, 1)
    FIELD(DDRMC_IER0, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_IER0, CE1_ECC1, 18, 1)
    FIELD(DDRMC_IER0, CE0_ECC1, 17, 1)
    FIELD(DDRMC_IER0, CE1_ECC0, 16, 1)
    FIELD(DDRMC_IER0, CE0_ECC0, 15, 1)
    FIELD(DDRMC_IER0, UC1_ECC1, 14, 1)
    FIELD(DDRMC_IER0, UC0_ECC1, 13, 1)
    FIELD(DDRMC_IER0, UC1_ECC0, 12, 1)
    FIELD(DDRMC_IER0, UC0_ECC0, 11, 1)
    FIELD(DDRMC_IER0, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_IER0, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_IER0, XMPU, 8, 1)
    FIELD(DDRMC_IER0, NSU_3, 7, 1)
    FIELD(DDRMC_IER0, NSU_2, 6, 1)
    FIELD(DDRMC_IER0, NSU_1, 5, 1)
    FIELD(DDRMC_IER0, NSU_0, 4, 1)
    FIELD(DDRMC_IER0, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_IER0, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_IER0, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_IER0, NSU_FATAL0, 0, 1)
REG32(DDRMC_IDR0, 0x24)
    FIELD(DDRMC_IDR0, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_IDR0, USER_1, 30, 1)
    FIELD(DDRMC_IDR0, USER_0, 29, 1)
    FIELD(DDRMC_IDR0, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_IDR0, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_IDR0, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_IDR0, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_IDR0, NA_CMD1, 24, 1)
    FIELD(DDRMC_IDR0, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_IDR0, NA_CMD0, 22, 1)
    FIELD(DDRMC_IDR0, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_IDR0, NA_CMD, 20, 1)
    FIELD(DDRMC_IDR0, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_IDR0, CE1_ECC1, 18, 1)
    FIELD(DDRMC_IDR0, CE0_ECC1, 17, 1)
    FIELD(DDRMC_IDR0, CE1_ECC0, 16, 1)
    FIELD(DDRMC_IDR0, CE0_ECC0, 15, 1)
    FIELD(DDRMC_IDR0, UC1_ECC1, 14, 1)
    FIELD(DDRMC_IDR0, UC0_ECC1, 13, 1)
    FIELD(DDRMC_IDR0, UC1_ECC0, 12, 1)
    FIELD(DDRMC_IDR0, UC0_ECC0, 11, 1)
    FIELD(DDRMC_IDR0, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_IDR0, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_IDR0, XMPU, 8, 1)
    FIELD(DDRMC_IDR0, NSU_3, 7, 1)
    FIELD(DDRMC_IDR0, NSU_2, 6, 1)
    FIELD(DDRMC_IDR0, NSU_1, 5, 1)
    FIELD(DDRMC_IDR0, NSU_0, 4, 1)
    FIELD(DDRMC_IDR0, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_IDR0, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_IDR0, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_IDR0, NSU_FATAL0, 0, 1)
REG32(DDRMC_IMR1, 0x28)
    FIELD(DDRMC_IMR1, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_IMR1, USER_1, 30, 1)
    FIELD(DDRMC_IMR1, USER_0, 29, 1)
    FIELD(DDRMC_IMR1, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_IMR1, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_IMR1, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_IMR1, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_IMR1, NA_CMD1, 24, 1)
    FIELD(DDRMC_IMR1, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_IMR1, NA_CMD0, 22, 1)
    FIELD(DDRMC_IMR1, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_IMR1, NA_CMD, 20, 1)
    FIELD(DDRMC_IMR1, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_IMR1, CE1_ECC1, 18, 1)
    FIELD(DDRMC_IMR1, CE0_ECC1, 17, 1)
    FIELD(DDRMC_IMR1, CE1_ECC0, 16, 1)
    FIELD(DDRMC_IMR1, CE0_ECC0, 15, 1)
    FIELD(DDRMC_IMR1, UC1_ECC1, 14, 1)
    FIELD(DDRMC_IMR1, UC0_ECC1, 13, 1)
    FIELD(DDRMC_IMR1, UC1_ECC0, 12, 1)
    FIELD(DDRMC_IMR1, UC0_ECC0, 11, 1)
    FIELD(DDRMC_IMR1, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_IMR1, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_IMR1, XMPU, 8, 1)
    FIELD(DDRMC_IMR1, NSU_3, 7, 1)
    FIELD(DDRMC_IMR1, NSU_2, 6, 1)
    FIELD(DDRMC_IMR1, NSU_1, 5, 1)
    FIELD(DDRMC_IMR1, NSU_0, 4, 1)
    FIELD(DDRMC_IMR1, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_IMR1, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_IMR1, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_IMR1, NSU_FATAL0, 0, 1)
REG32(DDRMC_IER1, 0x2c)
    FIELD(DDRMC_IER1, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_IER1, USER_1, 30, 1)
    FIELD(DDRMC_IER1, USER_0, 29, 1)
    FIELD(DDRMC_IER1, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_IER1, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_IER1, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_IER1, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_IER1, NA_CMD1, 24, 1)
    FIELD(DDRMC_IER1, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_IER1, NA_CMD0, 22, 1)
    FIELD(DDRMC_IER1, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_IER1, NA_CMD, 20, 1)
    FIELD(DDRMC_IER1, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_IER1, CE1_ECC1, 18, 1)
    FIELD(DDRMC_IER1, CE0_ECC1, 17, 1)
    FIELD(DDRMC_IER1, CE1_ECC0, 16, 1)
    FIELD(DDRMC_IER1, CE0_ECC0, 15, 1)
    FIELD(DDRMC_IER1, UC1_ECC1, 14, 1)
    FIELD(DDRMC_IER1, UC0_ECC1, 13, 1)
    FIELD(DDRMC_IER1, UC1_ECC0, 12, 1)
    FIELD(DDRMC_IER1, UC0_ECC0, 11, 1)
    FIELD(DDRMC_IER1, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_IER1, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_IER1, XMPU, 8, 1)
    FIELD(DDRMC_IER1, NSU_3, 7, 1)
    FIELD(DDRMC_IER1, NSU_2, 6, 1)
    FIELD(DDRMC_IER1, NSU_1, 5, 1)
    FIELD(DDRMC_IER1, NSU_0, 4, 1)
    FIELD(DDRMC_IER1, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_IER1, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_IER1, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_IER1, NSU_FATAL0, 0, 1)
REG32(DDRMC_IDR1, 0x30)
    FIELD(DDRMC_IDR1, SCAN_CLEAR_FAIL, 31, 1)
    FIELD(DDRMC_IDR1, USER_1, 30, 1)
    FIELD(DDRMC_IDR1, USER_0, 29, 1)
    FIELD(DDRMC_IDR1, DRAM_PARITY_FATAL_1, 28, 1)
    FIELD(DDRMC_IDR1, DRAM_PARITY_FATAL_0, 27, 1)
    FIELD(DDRMC_IDR1, DRAM_PARITY1, 26, 1)
    FIELD(DDRMC_IDR1, DRAM_PARITY0, 25, 1)
    FIELD(DDRMC_IDR1, NA_CMD1, 24, 1)
    FIELD(DDRMC_IDR1, DC_CMD1_FATAL, 23, 1)
    FIELD(DDRMC_IDR1, NA_CMD0, 22, 1)
    FIELD(DDRMC_IDR1, DC_CMD0_FATAL, 21, 1)
    FIELD(DDRMC_IDR1, NA_CMD, 20, 1)
    FIELD(DDRMC_IDR1, NA_CMD_FATAL, 19, 1)
    FIELD(DDRMC_IDR1, CE1_ECC1, 18, 1)
    FIELD(DDRMC_IDR1, CE0_ECC1, 17, 1)
    FIELD(DDRMC_IDR1, CE1_ECC0, 16, 1)
    FIELD(DDRMC_IDR1, CE0_ECC0, 15, 1)
    FIELD(DDRMC_IDR1, UC1_ECC1, 14, 1)
    FIELD(DDRMC_IDR1, UC0_ECC1, 13, 1)
    FIELD(DDRMC_IDR1, UC1_ECC0, 12, 1)
    FIELD(DDRMC_IDR1, UC0_ECC0, 11, 1)
    FIELD(DDRMC_IDR1, CH1_DATA_PAR, 10, 1)
    FIELD(DDRMC_IDR1, CH0_DATA_PAR, 9, 1)
    FIELD(DDRMC_IDR1, XMPU, 8, 1)
    FIELD(DDRMC_IDR1, NSU_3, 7, 1)
    FIELD(DDRMC_IDR1, NSU_2, 6, 1)
    FIELD(DDRMC_IDR1, NSU_1, 5, 1)
    FIELD(DDRMC_IDR1, NSU_0, 4, 1)
    FIELD(DDRMC_IDR1, NSU_FATAL3, 3, 1)
    FIELD(DDRMC_IDR1, NSU_FATAL2, 2, 1)
    FIELD(DDRMC_IDR1, NSU_FATAL1, 1, 1)
    FIELD(DDRMC_IDR1, NSU_FATAL0, 0, 1)
REG32(DDRMC_IOR, 0x34)
    FIELD(DDRMC_IOR, OFFSET, 0, 5)
REG32(REG_SAFE_CONFIG0, 0x200)
    FIELD(REG_SAFE_CONFIG0, TFAW, 24, 8)
    FIELD(REG_SAFE_CONFIG0, TRRD_L, 19, 5)
    FIELD(REG_SAFE_CONFIG0, TRRD_S, 14, 5)
    FIELD(REG_SAFE_CONFIG0, TCCD_L_SR, 7, 7)
    FIELD(REG_SAFE_CONFIG0, TCCD_S_SR, 0, 7)
REG32(REG_SAFE_CONFIG1, 0x204)
    FIELD(REG_SAFE_CONFIG1, TRRD_DLR, 28, 4)
    FIELD(REG_SAFE_CONFIG1, TCS_W2W_SR_DLR, 21, 7)
    FIELD(REG_SAFE_CONFIG1, TCS_W2W_DR, 14, 7)
    FIELD(REG_SAFE_CONFIG1, TCS_R2R_SR_DLR, 7, 7)
    FIELD(REG_SAFE_CONFIG1, TCS_R2R_DR, 0, 7)
REG32(REG_SAFE_CONFIG2, 0x208)
    FIELD(REG_SAFE_CONFIG2, TFAW_DLR, 26, 6)
    FIELD(REG_SAFE_CONFIG2, TRC, 19, 7)
    FIELD(REG_SAFE_CONFIG2, TRAS, 12, 7)
    FIELD(REG_SAFE_CONFIG2, TRP, 6, 6)
    FIELD(REG_SAFE_CONFIG2, TRCD, 0, 6)
REG32(REG_SAFE_CONFIG3, 0x20c)
    FIELD(REG_SAFE_CONFIG3, TCS_W2R_SR_DLR, 21, 7)
    FIELD(REG_SAFE_CONFIG3, TCS_W2R_DR, 14, 7)
    FIELD(REG_SAFE_CONFIG3, TCS_W2R_S_SR, 7, 7)
    FIELD(REG_SAFE_CONFIG3, TCS_W2R_L_SR, 0, 7)
REG32(REG_SAFE_CONFIG4, 0x210)
    FIELD(REG_SAFE_CONFIG4, TCS_W2P, 24, 7)
    FIELD(REG_SAFE_CONFIG4, TCS_R2W_DR, 12, 7)
    FIELD(REG_SAFE_CONFIG4, TCS_R2W_SR, 5, 7)
    FIELD(REG_SAFE_CONFIG4, TRTP, 0, 5)
REG32(REG_SAFE_CONFIG6, 0x214)
    FIELD(REG_SAFE_CONFIG6, TPBR2PBR, 16, 10)
    FIELD(REG_SAFE_CONFIG6, TREFI, 0, 16)
REG32(REG_SAFE_CONFIG7, 0x218)
    FIELD(REG_SAFE_CONFIG7, TRFC_R2R, 20, 10)
    FIELD(REG_SAFE_CONFIG7, TRFC_DLR_PB, 10, 10)
    FIELD(REG_SAFE_CONFIG7, TRFC_SLR_AB, 0, 10)
REG32(REG_SAFE_CONFIG8, 0x21c)
REG32(REG_RETRY_0, 0x220)
    FIELD(REG_RETRY_0, RMW_FIFO_DEALLOC_PERIOD, 23, 6)
    FIELD(REG_RETRY_0, TPAR_ALERT_RSP, 16, 7)
    FIELD(REG_RETRY_0, TPAR_ALERT_PW, 8, 8)
    FIELD(REG_RETRY_0, TPAR_ALERT_ON, 3, 5)
    FIELD(REG_RETRY_0, TPAR_UNKNOWN, 0, 3)
REG32(REG_RETRY_1, 0x224)
    FIELD(REG_RETRY_1, WR_FIFO_DEALLOC_PERIOD, 24, 6)
    FIELD(REG_RETRY_1, RETRY_FIFO_DEALLOC_PERIOD, 18, 6)
    FIELD(REG_RETRY_1, WAIT_TXNQ_EMPTY_EN, 17, 1)
    FIELD(REG_RETRY_1, REF_WAIT_TIMER, 11, 6)
    FIELD(REG_RETRY_1, REF_WAIT_TIMER_EN, 10, 1)
    FIELD(REG_RETRY_1, REF_EXTRA_NUM, 7, 3)
    FIELD(REG_RETRY_1, RETRY_WAIT_TIMER, 0, 7)
REG32(REG_REF_1, 0x228)
    FIELD(REG_REF_1, TZQ_BLOCK_ITVL, 21, 11)
    FIELD(REG_REF_1, TZQ_START_LATCH_ITVL, 8, 13)
    FIELD(REG_REF_1, TZQLAT, 0, 8)
REG32(REG_REF_3, 0x22c)
    FIELD(REG_REF_3, LPDDR4_REFRESH_TYPE, 15, 1)
    FIELD(REG_REF_3, TZQCS, 5, 10)
    FIELD(REG_REF_3, TACK_WIDTH, 0, 5)
REG32(REG_COM_3, 0x230)
    FIELD(REG_COM_3, T_BLOCK_DRAIN_OUT, 12, 6)
    FIELD(REG_COM_3, TXP, 6, 6)
    FIELD(REG_COM_3, TCKE, 0, 6)
REG32(REG_MRS_0, 0x234)
    FIELD(REG_MRS_0, TOSCI_START_2_READ, 12, 14)
    FIELD(REG_MRS_0, TCS_MRR_2_ANY, 6, 6)
    FIELD(REG_MRS_0, TCS_MRW_2_ANY, 0, 6)
REG32(REG_MRS_1, 0x238)
    FIELD(REG_MRS_1, TCS_MPC_2_ANY, 26, 6)
    FIELD(REG_MRS_1, TOSCI_CMD_ITVL, 0, 26)
REG32(REG_MRS_7, 0x23c)
    FIELD(REG_MRS_7, T_MR_BLOCK_ITVL, 0, 8)
REG32(REG_SCRUB0, 0x240)
    FIELD(REG_SCRUB0, PER_RD_PEND_TIMEOUT, 24, 8)
    FIELD(REG_SCRUB0, NON_PWR_2, 23, 1)
    FIELD(REG_SCRUB0, SCRUB_SCALE, 18, 5)
    FIELD(REG_SCRUB0, ADDR_ORDER, 17, 1)
    FIELD(REG_SCRUB0, RANK_BITS, 15, 2)
    FIELD(REG_SCRUB0, C_BITS, 13, 2)
    FIELD(REG_SCRUB0, GROUP_BITS, 11, 2)
    FIELD(REG_SCRUB0, BANK_BITS, 9, 2)
    FIELD(REG_SCRUB0, COL_BITS, 5, 4)
    FIELD(REG_SCRUB0, ROW_BITS, 0, 5)
REG32(REG_TXN_CONFIG, 0x244)
    FIELD(REG_TXN_CONFIG, TXNQ_RD_PRI_WR_PRI_ARB_ONLY_MODE, 19, 1)
    FIELD(REG_TXN_CONFIG, TXNQ_RD_PRI_AND_STARVED_ARB_ONLY_MODE, 18, 1)
    FIELD(REG_TXN_CONFIG, TXNQ_RD_PRI_ARB_ONLY_MODE, 17, 1)
    FIELD(REG_TXN_CONFIG, TXNQ_ALL_CMD_ARB_MODE, 16, 1)
    FIELD(REG_TXN_CONFIG, TXNQ_RD_STARVED_TIMER, 0, 16)
REG32(REG_WR_CONFIG, 0x248)
    FIELD(REG_WR_CONFIG, TXNQ_WR_TOP_TIMER, 16, 16)
    FIELD(REG_WR_CONFIG, TXNQ_WR_RD_PRI_TIMER, 0, 16)
REG32(REG_RD_CONFIG, 0x24c)
    FIELD(REG_RD_CONFIG, LL_TIMEOUT, 20, 10)
    FIELD(REG_RD_CONFIG, ISO_TIMEOUT, 8, 10)
    FIELD(REG_RD_CONFIG, FULL_THRESHOLD, 0, 5)
REG32(REG_PT_CONFIG, 0x250)
    FIELD(REG_PT_CONFIG, PAGE_TIMER, 4, 16)
    FIELD(REG_PT_CONFIG, PAGE_POLICY, 0, 2)
REG32(REG_DRAM_ARB, 0x254)
    FIELD(REG_DRAM_ARB, WRITE_LEVEL_LO, 8, 5)
    FIELD(REG_DRAM_ARB, WRITE_LEVEL_HI, 0, 5)
REG32(REG_CONFIG0, 0x258)
    FIELD(REG_CONFIG0, DM_EN, 22, 1)
    FIELD(REG_CONFIG0, NUM_LRANKS, 20, 2)
    FIELD(REG_CONFIG0, WIDTH_PER_CH, 18, 2)
    FIELD(REG_CONFIG0, NUM_CH, 17, 1)
    FIELD(REG_CONFIG0, NUM_SLOTS, 16, 1)
    FIELD(REG_CONFIG0, NUM_RANKS, 14, 2)
    FIELD(REG_CONFIG0, DIMM_TYPE, 12, 2)
    FIELD(REG_CONFIG0, DRAM_SIZE, 8, 3)
    FIELD(REG_CONFIG0, DRAM_WIDTH, 4, 2)
    FIELD(REG_CONFIG0, DDR4_2T, 1, 1)
    FIELD(REG_CONFIG0, DRAM_TYPE, 0, 1)
REG32(REG_PINOUT, 0x25c)
    FIELD(REG_PINOUT, SWAP_HVM_NIBBLE8_EN, 9, 1)
    FIELD(REG_PINOUT, SWAP_PO_LEFT2RIGHT_EN, 8, 1)
    FIELD(REG_PINOUT, ECC_IO_ENABLE, 7, 1)
    FIELD(REG_PINOUT, CORRECT_EN, 6, 1)
    FIELD(REG_PINOUT, ECC_ENCODE_EN, 5, 1)
    FIELD(REG_PINOUT, PO_SELECT, 0, 5)
REG32(REG_CONFIG3, 0x260)
    FIELD(REG_CONFIG3, WR_ODT_TABLE, 16, 16)
    FIELD(REG_CONFIG3, RD_ODT_TABLE, 0, 16)
REG32(REG_CONFIG4, 0x264)
    FIELD(REG_CONFIG4, RROB_RETURN_DLY, 20, 3)
    FIELD(REG_CONFIG4, WRITE_ON_TIME, 15, 5)
    FIELD(REG_CONFIG4, READ_ON_TIME, 10, 5)
    FIELD(REG_CONFIG4, WRITE_TO_ODT, 5, 5)
    FIELD(REG_CONFIG4, READ_TO_ODT, 0, 5)
REG32(SEQ_INIT_CMD_VALID, 0x268)
    FIELD(SEQ_INIT_CMD_VALID, CNT, 0, 7)
REG32(SEQ_INIT_CMD0, 0x26c)
    FIELD(SEQ_INIT_CMD0, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD0, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD0, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD1, 0x270)
    FIELD(SEQ_INIT_CMD1, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD1, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD1, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD2, 0x274)
    FIELD(SEQ_INIT_CMD2, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD2, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD2, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD3, 0x278)
    FIELD(SEQ_INIT_CMD3, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD3, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD3, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD4, 0x27c)
    FIELD(SEQ_INIT_CMD4, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD4, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD4, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD5, 0x280)
    FIELD(SEQ_INIT_CMD5, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD5, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD5, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD6, 0x284)
    FIELD(SEQ_INIT_CMD6, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD6, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD6, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD7, 0x288)
    FIELD(SEQ_INIT_CMD7, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD7, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD7, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD8, 0x28c)
    FIELD(SEQ_INIT_CMD8, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD8, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD8, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD9, 0x290)
    FIELD(SEQ_INIT_CMD9, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD9, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD9, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD10, 0x294)
    FIELD(SEQ_INIT_CMD10, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD10, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD10, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD11, 0x298)
    FIELD(SEQ_INIT_CMD11, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD11, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD11, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD12, 0x29c)
    FIELD(SEQ_INIT_CMD12, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD12, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD12, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD13, 0x2a0)
    FIELD(SEQ_INIT_CMD13, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD13, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD13, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD14, 0x2a4)
    FIELD(SEQ_INIT_CMD14, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD14, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD14, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD15, 0x2a8)
    FIELD(SEQ_INIT_CMD15, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD15, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD15, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD16, 0x2ac)
    FIELD(SEQ_INIT_CMD16, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD16, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD16, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD17, 0x2b0)
    FIELD(SEQ_INIT_CMD17, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD17, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD17, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD18, 0x2b4)
    FIELD(SEQ_INIT_CMD18, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD18, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD18, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD19, 0x2b8)
    FIELD(SEQ_INIT_CMD19, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD19, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD19, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD20, 0x2bc)
    FIELD(SEQ_INIT_CMD20, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD20, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD20, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD21, 0x2c0)
    FIELD(SEQ_INIT_CMD21, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD21, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD21, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD22, 0x2c4)
    FIELD(SEQ_INIT_CMD22, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD22, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD22, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD23, 0x2c8)
    FIELD(SEQ_INIT_CMD23, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD23, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD23, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD24, 0x2cc)
    FIELD(SEQ_INIT_CMD24, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD24, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD24, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD25, 0x2d0)
    FIELD(SEQ_INIT_CMD25, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD25, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD25, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD26, 0x2d4)
    FIELD(SEQ_INIT_CMD26, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD26, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD26, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD27, 0x2d8)
    FIELD(SEQ_INIT_CMD27, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD27, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD27, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD28, 0x2dc)
    FIELD(SEQ_INIT_CMD28, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD28, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD28, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD29, 0x2e0)
    FIELD(SEQ_INIT_CMD29, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD29, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD29, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD30, 0x2e4)
    FIELD(SEQ_INIT_CMD30, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD30, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD30, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD31, 0x2e8)
    FIELD(SEQ_INIT_CMD31, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD31, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD31, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD_SET, 0x2ec)
    FIELD(SEQ_INIT_CMD_SET, SLOT, 8, 1)
    FIELD(SEQ_INIT_CMD_SET, TIMING, 7, 1)
    FIELD(SEQ_INIT_CMD_SET, NOP, 0, 7)
REG32(SEQ_INIT_ADDR0, 0x2f0)
    FIELD(SEQ_INIT_ADDR0, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR0, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR0, A, 0, 24)
REG32(SEQ_INIT_ADDR1, 0x2f4)
    FIELD(SEQ_INIT_ADDR1, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR1, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR1, A, 0, 24)
REG32(SEQ_INIT_ADDR2, 0x2f8)
    FIELD(SEQ_INIT_ADDR2, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR2, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR2, A, 0, 24)
REG32(SEQ_INIT_ADDR3, 0x2fc)
    FIELD(SEQ_INIT_ADDR3, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR3, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR3, A, 0, 24)
REG32(SEQ_INIT_ADDR4, 0x300)
    FIELD(SEQ_INIT_ADDR4, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR4, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR4, A, 0, 24)
REG32(SEQ_INIT_ADDR5, 0x304)
    FIELD(SEQ_INIT_ADDR5, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR5, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR5, A, 0, 24)
REG32(SEQ_INIT_ADDR6, 0x308)
    FIELD(SEQ_INIT_ADDR6, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR6, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR6, A, 0, 24)
REG32(SEQ_INIT_ADDR7, 0x30c)
    FIELD(SEQ_INIT_ADDR7, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR7, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR7, A, 0, 24)
REG32(SEQ_INIT_ADDR8, 0x310)
    FIELD(SEQ_INIT_ADDR8, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR8, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR8, A, 0, 24)
REG32(SEQ_INIT_ADDR9, 0x314)
    FIELD(SEQ_INIT_ADDR9, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR9, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR9, A, 0, 24)
REG32(SEQ_INIT_ADDR10, 0x318)
    FIELD(SEQ_INIT_ADDR10, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR10, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR10, A, 0, 24)
REG32(SEQ_INIT_ADDR11, 0x31c)
    FIELD(SEQ_INIT_ADDR11, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR11, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR11, A, 0, 24)
REG32(SEQ_INIT_ADDR12, 0x320)
    FIELD(SEQ_INIT_ADDR12, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR12, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR12, A, 0, 24)
REG32(SEQ_INIT_ADDR13, 0x324)
    FIELD(SEQ_INIT_ADDR13, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR13, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR13, A, 0, 24)
REG32(SEQ_INIT_ADDR14, 0x328)
    FIELD(SEQ_INIT_ADDR14, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR14, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR14, A, 0, 24)
REG32(SEQ_INIT_ADDR15, 0x32c)
    FIELD(SEQ_INIT_ADDR15, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR15, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR15, A, 0, 24)
REG32(SEQ_INIT_ADDR16, 0x330)
    FIELD(SEQ_INIT_ADDR16, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR16, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR16, A, 0, 24)
REG32(SEQ_INIT_ADDR17, 0x334)
    FIELD(SEQ_INIT_ADDR17, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR17, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR17, A, 0, 24)
REG32(SEQ_INIT_ADDR18, 0x338)
    FIELD(SEQ_INIT_ADDR18, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR18, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR18, A, 0, 24)
REG32(SEQ_INIT_ADDR19, 0x33c)
    FIELD(SEQ_INIT_ADDR19, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR19, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR19, A, 0, 24)
REG32(SEQ_INIT_ADDR20, 0x340)
    FIELD(SEQ_INIT_ADDR20, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR20, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR20, A, 0, 24)
REG32(SEQ_INIT_ADDR21, 0x344)
    FIELD(SEQ_INIT_ADDR21, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR21, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR21, A, 0, 24)
REG32(SEQ_INIT_ADDR22, 0x348)
    FIELD(SEQ_INIT_ADDR22, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR22, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR22, A, 0, 24)
REG32(SEQ_INIT_ADDR23, 0x34c)
    FIELD(SEQ_INIT_ADDR23, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR23, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR23, A, 0, 24)
REG32(SEQ_INIT_ADDR24, 0x350)
    FIELD(SEQ_INIT_ADDR24, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR24, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR24, A, 0, 24)
REG32(SEQ_INIT_ADDR25, 0x354)
    FIELD(SEQ_INIT_ADDR25, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR25, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR25, A, 0, 24)
REG32(SEQ_INIT_ADDR26, 0x358)
    FIELD(SEQ_INIT_ADDR26, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR26, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR26, A, 0, 24)
REG32(SEQ_INIT_ADDR27, 0x35c)
    FIELD(SEQ_INIT_ADDR27, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR27, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR27, A, 0, 24)
REG32(SEQ_INIT_ADDR28, 0x360)
    FIELD(SEQ_INIT_ADDR28, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR28, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR28, A, 0, 24)
REG32(SEQ_INIT_ADDR29, 0x364)
    FIELD(SEQ_INIT_ADDR29, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR29, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR29, A, 0, 24)
REG32(SEQ_INIT_ADDR30, 0x368)
    FIELD(SEQ_INIT_ADDR30, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR30, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR30, A, 0, 24)
REG32(SEQ_INIT_ADDR31, 0x36c)
    FIELD(SEQ_INIT_ADDR31, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR31, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR31, A, 0, 24)
REG32(XPI_NIB_CHAN, 0x370)
    FIELD(XPI_NIB_CHAN, SEL, 0, 27)
REG32(XPI_DATA_NIB_CHAN, 0x374)
    FIELD(XPI_DATA_NIB_CHAN, SEL, 0, 18)
REG32(SEQ_INIT_CNTRL0, 0x378)
    FIELD(SEQ_INIT_CNTRL0, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL0, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL0, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL0, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL0, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL0, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL0, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL1, 0x37c)
    FIELD(SEQ_INIT_CNTRL1, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL1, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL1, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL1, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL1, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL1, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL1, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL2, 0x380)
    FIELD(SEQ_INIT_CNTRL2, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL2, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL2, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL2, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL2, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL2, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL2, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL3, 0x384)
    FIELD(SEQ_INIT_CNTRL3, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL3, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL3, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL3, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL3, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL3, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL3, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL4, 0x388)
    FIELD(SEQ_INIT_CNTRL4, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL4, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL4, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL4, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL4, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL4, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL4, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL5, 0x38c)
    FIELD(SEQ_INIT_CNTRL5, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL5, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL5, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL5, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL5, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL5, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL5, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL6, 0x390)
    FIELD(SEQ_INIT_CNTRL6, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL6, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL6, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL6, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL6, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL6, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL6, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL7, 0x394)
    FIELD(SEQ_INIT_CNTRL7, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL7, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL7, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL7, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL7, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL7, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL7, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL8, 0x398)
    FIELD(SEQ_INIT_CNTRL8, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL8, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL8, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL8, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL8, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL8, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL8, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL9, 0x39c)
    FIELD(SEQ_INIT_CNTRL9, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL9, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL9, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL9, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL9, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL9, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL9, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL10, 0x3a0)
    FIELD(SEQ_INIT_CNTRL10, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL10, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL10, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL10, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL10, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL10, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL10, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL11, 0x3a4)
    FIELD(SEQ_INIT_CNTRL11, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL11, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL11, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL11, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL11, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL11, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL11, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL12, 0x3a8)
    FIELD(SEQ_INIT_CNTRL12, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL12, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL12, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL12, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL12, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL12, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL12, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL13, 0x3ac)
    FIELD(SEQ_INIT_CNTRL13, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL13, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL13, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL13, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL13, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL13, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL13, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL14, 0x3b0)
    FIELD(SEQ_INIT_CNTRL14, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL14, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL14, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL14, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL14, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL14, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL14, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL15, 0x3b4)
    FIELD(SEQ_INIT_CNTRL15, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL15, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL15, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL15, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL15, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL15, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL15, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL16, 0x3b8)
    FIELD(SEQ_INIT_CNTRL16, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL16, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL16, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL16, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL16, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL16, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL16, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL17, 0x3bc)
    FIELD(SEQ_INIT_CNTRL17, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL17, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL17, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL17, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL17, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL17, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL17, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL18, 0x3c0)
    FIELD(SEQ_INIT_CNTRL18, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL18, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL18, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL18, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL18, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL18, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL18, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL19, 0x3c4)
    FIELD(SEQ_INIT_CNTRL19, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL19, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL19, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL19, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL19, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL19, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL19, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL20, 0x3c8)
    FIELD(SEQ_INIT_CNTRL20, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL20, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL20, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL20, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL20, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL20, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL20, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL21, 0x3cc)
    FIELD(SEQ_INIT_CNTRL21, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL21, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL21, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL21, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL21, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL21, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL21, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL22, 0x3d0)
    FIELD(SEQ_INIT_CNTRL22, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL22, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL22, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL22, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL22, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL22, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL22, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL23, 0x3d4)
    FIELD(SEQ_INIT_CNTRL23, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL23, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL23, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL23, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL23, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL23, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL23, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL24, 0x3d8)
    FIELD(SEQ_INIT_CNTRL24, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL24, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL24, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL24, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL24, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL24, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL24, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL25, 0x3dc)
    FIELD(SEQ_INIT_CNTRL25, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL25, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL25, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL25, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL25, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL25, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL25, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL26, 0x3e0)
    FIELD(SEQ_INIT_CNTRL26, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL26, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL26, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL26, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL26, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL26, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL26, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL27, 0x3e4)
    FIELD(SEQ_INIT_CNTRL27, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL27, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL27, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL27, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL27, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL27, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL27, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL28, 0x3e8)
    FIELD(SEQ_INIT_CNTRL28, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL28, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL28, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL28, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL28, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL28, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL28, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL29, 0x3ec)
    FIELD(SEQ_INIT_CNTRL29, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL29, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL29, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL29, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL29, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL29, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL29, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL30, 0x3f0)
    FIELD(SEQ_INIT_CNTRL30, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL30, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL30, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL30, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL30, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL30, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL30, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL31, 0x3f4)
    FIELD(SEQ_INIT_CNTRL31, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL31, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL31, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL31, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL31, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL31, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL31, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL32, 0x3f8)
    FIELD(SEQ_INIT_CNTRL32, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL32, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL32, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL32, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL32, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL32, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL32, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL33, 0x3fc)
    FIELD(SEQ_INIT_CNTRL33, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL33, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL33, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL33, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL33, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL33, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL33, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL34, 0x400)
    FIELD(SEQ_INIT_CNTRL34, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL34, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL34, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL34, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL34, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL34, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL34, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL35, 0x404)
    FIELD(SEQ_INIT_CNTRL35, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL35, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL35, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL35, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL35, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL35, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL35, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL36, 0x408)
    FIELD(SEQ_INIT_CNTRL36, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL36, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL36, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL36, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL36, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL36, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL36, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL37, 0x40c)
    FIELD(SEQ_INIT_CNTRL37, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL37, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL37, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL37, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL37, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL37, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL37, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL38, 0x410)
    FIELD(SEQ_INIT_CNTRL38, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL38, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL38, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL38, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL38, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL38, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL38, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL39, 0x414)
    FIELD(SEQ_INIT_CNTRL39, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL39, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL39, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL39, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL39, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL39, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL39, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL40, 0x418)
    FIELD(SEQ_INIT_CNTRL40, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL40, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL40, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL40, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL40, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL40, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL40, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL41, 0x41c)
    FIELD(SEQ_INIT_CNTRL41, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL41, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL41, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL41, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL41, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL41, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL41, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL42, 0x420)
    FIELD(SEQ_INIT_CNTRL42, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL42, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL42, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL42, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL42, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL42, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL42, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL43, 0x424)
    FIELD(SEQ_INIT_CNTRL43, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL43, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL43, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL43, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL43, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL43, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL43, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL44, 0x428)
    FIELD(SEQ_INIT_CNTRL44, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL44, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL44, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL44, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL44, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL44, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL44, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL45, 0x42c)
    FIELD(SEQ_INIT_CNTRL45, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL45, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL45, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL45, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL45, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL45, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL45, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL46, 0x430)
    FIELD(SEQ_INIT_CNTRL46, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL46, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL46, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL46, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL46, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL46, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL46, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL47, 0x434)
    FIELD(SEQ_INIT_CNTRL47, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL47, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL47, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL47, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL47, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL47, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL47, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL48, 0x438)
    FIELD(SEQ_INIT_CNTRL48, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL48, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL48, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL48, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL48, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL48, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL48, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL49, 0x43c)
    FIELD(SEQ_INIT_CNTRL49, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL49, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL49, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL49, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL49, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL49, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL49, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL50, 0x440)
    FIELD(SEQ_INIT_CNTRL50, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL50, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL50, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL50, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL50, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL50, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL50, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL51, 0x444)
    FIELD(SEQ_INIT_CNTRL51, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL51, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL51, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL51, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL51, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL51, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL51, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL52, 0x448)
    FIELD(SEQ_INIT_CNTRL52, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL52, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL52, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL52, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL52, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL52, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL52, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL53, 0x44c)
    FIELD(SEQ_INIT_CNTRL53, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL53, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL53, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL53, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL53, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL53, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL53, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL54, 0x450)
    FIELD(SEQ_INIT_CNTRL54, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL54, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL54, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL54, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL54, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL54, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL54, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL55, 0x454)
    FIELD(SEQ_INIT_CNTRL55, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL55, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL55, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL55, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL55, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL55, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL55, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL56, 0x458)
    FIELD(SEQ_INIT_CNTRL56, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL56, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL56, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL56, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL56, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL56, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL56, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL57, 0x45c)
    FIELD(SEQ_INIT_CNTRL57, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL57, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL57, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL57, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL57, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL57, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL57, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL58, 0x460)
    FIELD(SEQ_INIT_CNTRL58, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL58, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL58, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL58, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL58, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL58, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL58, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL59, 0x464)
    FIELD(SEQ_INIT_CNTRL59, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL59, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL59, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL59, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL59, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL59, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL59, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL60, 0x468)
    FIELD(SEQ_INIT_CNTRL60, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL60, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL60, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL60, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL60, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL60, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL60, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL61, 0x46c)
    FIELD(SEQ_INIT_CNTRL61, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL61, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL61, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL61, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL61, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL61, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL61, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL62, 0x470)
    FIELD(SEQ_INIT_CNTRL62, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL62, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL62, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL62, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL62, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL62, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL62, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL63, 0x474)
    FIELD(SEQ_INIT_CNTRL63, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL63, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL63, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL63, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL63, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL63, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL63, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL64, 0x478)
    FIELD(SEQ_INIT_CNTRL64, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL64, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL64, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL64, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL64, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL64, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL64, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL65, 0x47c)
    FIELD(SEQ_INIT_CNTRL65, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL65, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL65, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL65, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL65, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL65, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL65, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL66, 0x480)
    FIELD(SEQ_INIT_CNTRL66, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL66, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL66, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL66, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL66, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL66, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL66, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL67, 0x484)
    FIELD(SEQ_INIT_CNTRL67, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL67, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL67, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL67, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL67, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL67, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL67, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL68, 0x488)
    FIELD(SEQ_INIT_CNTRL68, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL68, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL68, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL68, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL68, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL68, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL68, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL69, 0x48c)
    FIELD(SEQ_INIT_CNTRL69, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL69, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL69, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL69, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL69, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL69, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL69, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL70, 0x490)
    FIELD(SEQ_INIT_CNTRL70, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL70, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL70, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL70, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL70, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL70, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL70, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL71, 0x494)
    FIELD(SEQ_INIT_CNTRL71, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL71, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL71, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL71, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL71, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL71, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL71, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL72, 0x498)
    FIELD(SEQ_INIT_CNTRL72, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL72, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL72, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL72, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL72, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL72, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL72, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL73, 0x49c)
    FIELD(SEQ_INIT_CNTRL73, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL73, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL73, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL73, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL73, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL73, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL73, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL74, 0x4a0)
    FIELD(SEQ_INIT_CNTRL74, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL74, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL74, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL74, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL74, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL74, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL74, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL75, 0x4a4)
    FIELD(SEQ_INIT_CNTRL75, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL75, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL75, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL75, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL75, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL75, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL75, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL76, 0x4a8)
    FIELD(SEQ_INIT_CNTRL76, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL76, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL76, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL76, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL76, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL76, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL76, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL77, 0x4ac)
    FIELD(SEQ_INIT_CNTRL77, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL77, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL77, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL77, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL77, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL77, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL77, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL78, 0x4b0)
    FIELD(SEQ_INIT_CNTRL78, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL78, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL78, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL78, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL78, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL78, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL78, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL79, 0x4b4)
    FIELD(SEQ_INIT_CNTRL79, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL79, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL79, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL79, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL79, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL79, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL79, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL80, 0x4b8)
    FIELD(SEQ_INIT_CNTRL80, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL80, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL80, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL80, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL80, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL80, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL80, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL81, 0x4bc)
    FIELD(SEQ_INIT_CNTRL81, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL81, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL81, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL81, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL81, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL81, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL81, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL82, 0x4c0)
    FIELD(SEQ_INIT_CNTRL82, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL82, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL82, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL82, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL82, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL82, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL82, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL83, 0x4c4)
    FIELD(SEQ_INIT_CNTRL83, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL83, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL83, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL83, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL83, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL83, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL83, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL84, 0x4c8)
    FIELD(SEQ_INIT_CNTRL84, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL84, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL84, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL84, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL84, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL84, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL84, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL85, 0x4cc)
    FIELD(SEQ_INIT_CNTRL85, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL85, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL85, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL85, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL85, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL85, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL85, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL86, 0x4d0)
    FIELD(SEQ_INIT_CNTRL86, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL86, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL86, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL86, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL86, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL86, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL86, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL87, 0x4d4)
    FIELD(SEQ_INIT_CNTRL87, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL87, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL87, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL87, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL87, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL87, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL87, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL88, 0x4d8)
    FIELD(SEQ_INIT_CNTRL88, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL88, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL88, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL88, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL88, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL88, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL88, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL89, 0x4dc)
    FIELD(SEQ_INIT_CNTRL89, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL89, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL89, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL89, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL89, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL89, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL89, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL90, 0x4e0)
    FIELD(SEQ_INIT_CNTRL90, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL90, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL90, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL90, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL90, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL90, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL90, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL91, 0x4e4)
    FIELD(SEQ_INIT_CNTRL91, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL91, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL91, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL91, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL91, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL91, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL91, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL92, 0x4e8)
    FIELD(SEQ_INIT_CNTRL92, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL92, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL92, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL92, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL92, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL92, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL92, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL93, 0x4ec)
    FIELD(SEQ_INIT_CNTRL93, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL93, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL93, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL93, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL93, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL93, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL93, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL94, 0x4f0)
    FIELD(SEQ_INIT_CNTRL94, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL94, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL94, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL94, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL94, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL94, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL94, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL95, 0x4f4)
    FIELD(SEQ_INIT_CNTRL95, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL95, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL95, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL95, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL95, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL95, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL95, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL96, 0x4f8)
    FIELD(SEQ_INIT_CNTRL96, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL96, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL96, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL96, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL96, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL96, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL96, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL97, 0x4fc)
    FIELD(SEQ_INIT_CNTRL97, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL97, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL97, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL97, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL97, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL97, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL97, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL98, 0x500)
    FIELD(SEQ_INIT_CNTRL98, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL98, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL98, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL98, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL98, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL98, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL98, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CNTRL99, 0x504)
    FIELD(SEQ_INIT_CNTRL99, CKE_EXTEND, 9, 1)
    FIELD(SEQ_INIT_CNTRL99, RST_EXTEND, 8, 1)
    FIELD(SEQ_INIT_CNTRL99, CS_EN, 4, 4)
    FIELD(SEQ_INIT_CNTRL99, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_INIT_CNTRL99, INVERT, 2, 1)
    FIELD(SEQ_INIT_CNTRL99, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_INIT_CNTRL99, OP_EXTEND, 0, 1)
REG32(SEQ_INIT_CMD32, 0x508)
    FIELD(SEQ_INIT_CMD32, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD32, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD32, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD33, 0x50c)
    FIELD(SEQ_INIT_CMD33, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD33, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD33, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD34, 0x510)
    FIELD(SEQ_INIT_CMD34, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD34, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD34, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD35, 0x514)
    FIELD(SEQ_INIT_CMD35, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD35, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD35, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD36, 0x518)
    FIELD(SEQ_INIT_CMD36, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD36, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD36, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD37, 0x51c)
    FIELD(SEQ_INIT_CMD37, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD37, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD37, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD38, 0x520)
    FIELD(SEQ_INIT_CMD38, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD38, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD38, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD39, 0x524)
    FIELD(SEQ_INIT_CMD39, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD39, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD39, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD40, 0x528)
    FIELD(SEQ_INIT_CMD40, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD40, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD40, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD41, 0x52c)
    FIELD(SEQ_INIT_CMD41, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD41, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD41, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD42, 0x530)
    FIELD(SEQ_INIT_CMD42, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD42, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD42, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD43, 0x534)
    FIELD(SEQ_INIT_CMD43, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD43, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD43, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD44, 0x538)
    FIELD(SEQ_INIT_CMD44, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD44, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD44, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD45, 0x53c)
    FIELD(SEQ_INIT_CMD45, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD45, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD45, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD46, 0x540)
    FIELD(SEQ_INIT_CMD46, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD46, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD46, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD47, 0x544)
    FIELD(SEQ_INIT_CMD47, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD47, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD47, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD48, 0x548)
    FIELD(SEQ_INIT_CMD48, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD48, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD48, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD49, 0x54c)
    FIELD(SEQ_INIT_CMD49, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD49, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD49, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD50, 0x550)
    FIELD(SEQ_INIT_CMD50, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD50, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD50, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD51, 0x554)
    FIELD(SEQ_INIT_CMD51, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD51, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD51, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD52, 0x558)
    FIELD(SEQ_INIT_CMD52, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD52, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD52, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD53, 0x55c)
    FIELD(SEQ_INIT_CMD53, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD53, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD53, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD54, 0x560)
    FIELD(SEQ_INIT_CMD54, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD54, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD54, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD55, 0x564)
    FIELD(SEQ_INIT_CMD55, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD55, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD55, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD56, 0x568)
    FIELD(SEQ_INIT_CMD56, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD56, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD56, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD57, 0x56c)
    FIELD(SEQ_INIT_CMD57, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD57, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD57, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD58, 0x570)
    FIELD(SEQ_INIT_CMD58, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD58, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD58, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD59, 0x574)
    FIELD(SEQ_INIT_CMD59, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD59, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD59, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD60, 0x578)
    FIELD(SEQ_INIT_CMD60, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD60, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD60, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD61, 0x57c)
    FIELD(SEQ_INIT_CMD61, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD61, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD61, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD62, 0x580)
    FIELD(SEQ_INIT_CMD62, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD62, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD62, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD63, 0x584)
    FIELD(SEQ_INIT_CMD63, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD63, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD63, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD64, 0x588)
    FIELD(SEQ_INIT_CMD64, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD64, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD64, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD65, 0x58c)
    FIELD(SEQ_INIT_CMD65, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD65, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD65, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD66, 0x590)
    FIELD(SEQ_INIT_CMD66, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD66, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD66, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD67, 0x594)
    FIELD(SEQ_INIT_CMD67, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD67, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD67, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD68, 0x598)
    FIELD(SEQ_INIT_CMD68, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD68, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD68, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD69, 0x59c)
    FIELD(SEQ_INIT_CMD69, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD69, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD69, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD70, 0x5a0)
    FIELD(SEQ_INIT_CMD70, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD70, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD70, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD71, 0x5a4)
    FIELD(SEQ_INIT_CMD71, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD71, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD71, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD72, 0x5a8)
    FIELD(SEQ_INIT_CMD72, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD72, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD72, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD73, 0x5ac)
    FIELD(SEQ_INIT_CMD73, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD73, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD73, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD74, 0x5b0)
    FIELD(SEQ_INIT_CMD74, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD74, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD74, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD75, 0x5b4)
    FIELD(SEQ_INIT_CMD75, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD75, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD75, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD76, 0x5b8)
    FIELD(SEQ_INIT_CMD76, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD76, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD76, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD77, 0x5bc)
    FIELD(SEQ_INIT_CMD77, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD77, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD77, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD78, 0x5c0)
    FIELD(SEQ_INIT_CMD78, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD78, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD78, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD79, 0x5c4)
    FIELD(SEQ_INIT_CMD79, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD79, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD79, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD80, 0x5c8)
    FIELD(SEQ_INIT_CMD80, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD80, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD80, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD81, 0x5cc)
    FIELD(SEQ_INIT_CMD81, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD81, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD81, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD82, 0x5d0)
    FIELD(SEQ_INIT_CMD82, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD82, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD82, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD83, 0x5d4)
    FIELD(SEQ_INIT_CMD83, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD83, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD83, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD84, 0x5d8)
    FIELD(SEQ_INIT_CMD84, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD84, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD84, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD85, 0x5dc)
    FIELD(SEQ_INIT_CMD85, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD85, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD85, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD86, 0x5e0)
    FIELD(SEQ_INIT_CMD86, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD86, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD86, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD87, 0x5e4)
    FIELD(SEQ_INIT_CMD87, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD87, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD87, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD88, 0x5e8)
    FIELD(SEQ_INIT_CMD88, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD88, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD88, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD89, 0x5ec)
    FIELD(SEQ_INIT_CMD89, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD89, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD89, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD90, 0x5f0)
    FIELD(SEQ_INIT_CMD90, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD90, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD90, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD91, 0x5f4)
    FIELD(SEQ_INIT_CMD91, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD91, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD91, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD92, 0x5f8)
    FIELD(SEQ_INIT_CMD92, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD92, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD92, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD93, 0x5fc)
    FIELD(SEQ_INIT_CMD93, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD93, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD93, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD94, 0x600)
    FIELD(SEQ_INIT_CMD94, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD94, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD94, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD95, 0x604)
    FIELD(SEQ_INIT_CMD95, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD95, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD95, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD96, 0x608)
    FIELD(SEQ_INIT_CMD96, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD96, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD96, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD97, 0x60c)
    FIELD(SEQ_INIT_CMD97, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD97, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD97, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD98, 0x610)
    FIELD(SEQ_INIT_CMD98, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD98, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD98, OPCODE, 0, 7)
REG32(SEQ_INIT_CMD99, 0x614)
    FIELD(SEQ_INIT_CMD99, DLY, 9, 23)
    FIELD(SEQ_INIT_CMD99, WR_RD, 7, 2)
    FIELD(SEQ_INIT_CMD99, OPCODE, 0, 7)
REG32(SEQ_INIT_ADDR32, 0x618)
    FIELD(SEQ_INIT_ADDR32, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR32, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR32, A, 0, 24)
REG32(SEQ_INIT_ADDR33, 0x61c)
    FIELD(SEQ_INIT_ADDR33, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR33, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR33, A, 0, 24)
REG32(SEQ_INIT_ADDR34, 0x620)
    FIELD(SEQ_INIT_ADDR34, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR34, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR34, A, 0, 24)
REG32(SEQ_INIT_ADDR35, 0x624)
    FIELD(SEQ_INIT_ADDR35, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR35, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR35, A, 0, 24)
REG32(SEQ_INIT_ADDR36, 0x628)
    FIELD(SEQ_INIT_ADDR36, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR36, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR36, A, 0, 24)
REG32(SEQ_INIT_ADDR37, 0x62c)
    FIELD(SEQ_INIT_ADDR37, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR37, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR37, A, 0, 24)
REG32(SEQ_INIT_ADDR38, 0x630)
    FIELD(SEQ_INIT_ADDR38, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR38, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR38, A, 0, 24)
REG32(SEQ_INIT_ADDR39, 0x634)
    FIELD(SEQ_INIT_ADDR39, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR39, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR39, A, 0, 24)
REG32(SEQ_INIT_ADDR40, 0x638)
    FIELD(SEQ_INIT_ADDR40, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR40, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR40, A, 0, 24)
REG32(SEQ_INIT_ADDR41, 0x63c)
    FIELD(SEQ_INIT_ADDR41, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR41, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR41, A, 0, 24)
REG32(SEQ_INIT_ADDR42, 0x640)
    FIELD(SEQ_INIT_ADDR42, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR42, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR42, A, 0, 24)
REG32(SEQ_INIT_ADDR43, 0x644)
    FIELD(SEQ_INIT_ADDR43, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR43, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR43, A, 0, 24)
REG32(SEQ_INIT_ADDR44, 0x648)
    FIELD(SEQ_INIT_ADDR44, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR44, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR44, A, 0, 24)
REG32(SEQ_INIT_ADDR45, 0x64c)
    FIELD(SEQ_INIT_ADDR45, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR45, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR45, A, 0, 24)
REG32(SEQ_INIT_ADDR46, 0x650)
    FIELD(SEQ_INIT_ADDR46, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR46, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR46, A, 0, 24)
REG32(SEQ_INIT_ADDR47, 0x654)
    FIELD(SEQ_INIT_ADDR47, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR47, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR47, A, 0, 24)
REG32(SEQ_INIT_ADDR48, 0x658)
    FIELD(SEQ_INIT_ADDR48, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR48, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR48, A, 0, 24)
REG32(SEQ_INIT_ADDR49, 0x65c)
    FIELD(SEQ_INIT_ADDR49, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR49, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR49, A, 0, 24)
REG32(SEQ_INIT_ADDR50, 0x660)
    FIELD(SEQ_INIT_ADDR50, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR50, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR50, A, 0, 24)
REG32(SEQ_INIT_ADDR51, 0x664)
    FIELD(SEQ_INIT_ADDR51, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR51, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR51, A, 0, 24)
REG32(SEQ_INIT_ADDR52, 0x668)
    FIELD(SEQ_INIT_ADDR52, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR52, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR52, A, 0, 24)
REG32(SEQ_INIT_ADDR53, 0x66c)
    FIELD(SEQ_INIT_ADDR53, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR53, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR53, A, 0, 24)
REG32(SEQ_INIT_ADDR54, 0x670)
    FIELD(SEQ_INIT_ADDR54, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR54, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR54, A, 0, 24)
REG32(SEQ_INIT_ADDR55, 0x674)
    FIELD(SEQ_INIT_ADDR55, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR55, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR55, A, 0, 24)
REG32(SEQ_INIT_ADDR56, 0x678)
    FIELD(SEQ_INIT_ADDR56, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR56, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR56, A, 0, 24)
REG32(SEQ_INIT_ADDR57, 0x67c)
    FIELD(SEQ_INIT_ADDR57, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR57, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR57, A, 0, 24)
REG32(SEQ_INIT_ADDR58, 0x680)
    FIELD(SEQ_INIT_ADDR58, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR58, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR58, A, 0, 24)
REG32(SEQ_INIT_ADDR59, 0x684)
    FIELD(SEQ_INIT_ADDR59, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR59, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR59, A, 0, 24)
REG32(SEQ_INIT_ADDR60, 0x688)
    FIELD(SEQ_INIT_ADDR60, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR60, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR60, A, 0, 24)
REG32(SEQ_INIT_ADDR61, 0x68c)
    FIELD(SEQ_INIT_ADDR61, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR61, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR61, A, 0, 24)
REG32(SEQ_INIT_ADDR62, 0x690)
    FIELD(SEQ_INIT_ADDR62, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR62, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR62, A, 0, 24)
REG32(SEQ_INIT_ADDR63, 0x694)
    FIELD(SEQ_INIT_ADDR63, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR63, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR63, A, 0, 24)
REG32(SEQ_INIT_ADDR64, 0x698)
    FIELD(SEQ_INIT_ADDR64, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR64, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR64, A, 0, 24)
REG32(SEQ_INIT_ADDR65, 0x69c)
    FIELD(SEQ_INIT_ADDR65, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR65, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR65, A, 0, 24)
REG32(SEQ_INIT_ADDR66, 0x6a0)
    FIELD(SEQ_INIT_ADDR66, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR66, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR66, A, 0, 24)
REG32(SEQ_INIT_ADDR67, 0x6a4)
    FIELD(SEQ_INIT_ADDR67, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR67, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR67, A, 0, 24)
REG32(SEQ_INIT_ADDR68, 0x6a8)
    FIELD(SEQ_INIT_ADDR68, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR68, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR68, A, 0, 24)
REG32(SEQ_INIT_ADDR69, 0x6ac)
    FIELD(SEQ_INIT_ADDR69, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR69, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR69, A, 0, 24)
REG32(SEQ_INIT_ADDR70, 0x6b0)
    FIELD(SEQ_INIT_ADDR70, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR70, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR70, A, 0, 24)
REG32(SEQ_INIT_ADDR71, 0x6b4)
    FIELD(SEQ_INIT_ADDR71, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR71, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR71, A, 0, 24)
REG32(SEQ_INIT_ADDR72, 0x6b8)
    FIELD(SEQ_INIT_ADDR72, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR72, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR72, A, 0, 24)
REG32(SEQ_INIT_ADDR73, 0x6bc)
    FIELD(SEQ_INIT_ADDR73, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR73, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR73, A, 0, 24)
REG32(SEQ_INIT_ADDR74, 0x6c0)
    FIELD(SEQ_INIT_ADDR74, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR74, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR74, A, 0, 24)
REG32(SEQ_INIT_ADDR75, 0x6c4)
    FIELD(SEQ_INIT_ADDR75, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR75, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR75, A, 0, 24)
REG32(SEQ_INIT_ADDR76, 0x6c8)
    FIELD(SEQ_INIT_ADDR76, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR76, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR76, A, 0, 24)
REG32(SEQ_INIT_ADDR77, 0x6cc)
    FIELD(SEQ_INIT_ADDR77, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR77, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR77, A, 0, 24)
REG32(SEQ_INIT_ADDR78, 0x6d0)
    FIELD(SEQ_INIT_ADDR78, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR78, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR78, A, 0, 24)
REG32(SEQ_INIT_ADDR79, 0x6d4)
    FIELD(SEQ_INIT_ADDR79, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR79, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR79, A, 0, 24)
REG32(SEQ_INIT_ADDR80, 0x6d8)
    FIELD(SEQ_INIT_ADDR80, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR80, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR80, A, 0, 24)
REG32(SEQ_INIT_ADDR81, 0x6dc)
    FIELD(SEQ_INIT_ADDR81, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR81, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR81, A, 0, 24)
REG32(SEQ_INIT_ADDR82, 0x6e0)
    FIELD(SEQ_INIT_ADDR82, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR82, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR82, A, 0, 24)
REG32(SEQ_INIT_ADDR83, 0x6e4)
    FIELD(SEQ_INIT_ADDR83, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR83, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR83, A, 0, 24)
REG32(SEQ_INIT_ADDR84, 0x6e8)
    FIELD(SEQ_INIT_ADDR84, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR84, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR84, A, 0, 24)
REG32(SEQ_INIT_ADDR85, 0x6ec)
    FIELD(SEQ_INIT_ADDR85, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR85, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR85, A, 0, 24)
REG32(SEQ_INIT_ADDR86, 0x6f0)
    FIELD(SEQ_INIT_ADDR86, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR86, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR86, A, 0, 24)
REG32(SEQ_INIT_ADDR87, 0x6f4)
    FIELD(SEQ_INIT_ADDR87, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR87, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR87, A, 0, 24)
REG32(SEQ_INIT_ADDR88, 0x6f8)
    FIELD(SEQ_INIT_ADDR88, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR88, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR88, A, 0, 24)
REG32(SEQ_INIT_ADDR89, 0x6fc)
    FIELD(SEQ_INIT_ADDR89, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR89, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR89, A, 0, 24)
REG32(SEQ_INIT_ADDR90, 0x700)
    FIELD(SEQ_INIT_ADDR90, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR90, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR90, A, 0, 24)
REG32(SEQ_INIT_ADDR91, 0x704)
    FIELD(SEQ_INIT_ADDR91, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR91, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR91, A, 0, 24)
REG32(SEQ_INIT_ADDR92, 0x708)
    FIELD(SEQ_INIT_ADDR92, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR92, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR92, A, 0, 24)
REG32(SEQ_INIT_ADDR93, 0x70c)
    FIELD(SEQ_INIT_ADDR93, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR93, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR93, A, 0, 24)
REG32(SEQ_INIT_ADDR94, 0x710)
    FIELD(SEQ_INIT_ADDR94, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR94, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR94, A, 0, 24)
REG32(SEQ_INIT_ADDR95, 0x714)
    FIELD(SEQ_INIT_ADDR95, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR95, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR95, A, 0, 24)
REG32(SEQ_INIT_ADDR96, 0x718)
    FIELD(SEQ_INIT_ADDR96, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR96, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR96, A, 0, 24)
REG32(SEQ_INIT_ADDR97, 0x71c)
    FIELD(SEQ_INIT_ADDR97, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR97, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR97, A, 0, 24)
REG32(SEQ_INIT_ADDR98, 0x720)
    FIELD(SEQ_INIT_ADDR98, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR98, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR98, A, 0, 24)
REG32(SEQ_INIT_ADDR99, 0x724)
    FIELD(SEQ_INIT_ADDR99, BG, 26, 2)
    FIELD(SEQ_INIT_ADDR99, BA, 24, 2)
    FIELD(SEQ_INIT_ADDR99, A, 0, 24)
REG32(RAM_SETTING_RF2PHS, 0x728)
    FIELD(RAM_SETTING_RF2PHS, STOV, 7, 1)
    FIELD(RAM_SETTING_RF2PHS, EMASA, 6, 1)
    FIELD(RAM_SETTING_RF2PHS, EMAB, 3, 3)
    FIELD(RAM_SETTING_RF2PHS, EMAA, 0, 3)
REG32(RAM_SETTING_SRSPHD, 0x72c)
    FIELD(RAM_SETTING_SRSPHD, STOV, 6, 1)
    FIELD(RAM_SETTING_SRSPHD, EMAS, 5, 1)
    FIELD(RAM_SETTING_SRSPHD, EMAW, 3, 2)
    FIELD(RAM_SETTING_SRSPHD, EMA, 0, 3)
REG32(RAM_SETTING_RFSPHD, 0x730)
    FIELD(RAM_SETTING_RFSPHD, STOV, 6, 1)
    FIELD(RAM_SETTING_RFSPHD, EMAS, 5, 1)
    FIELD(RAM_SETTING_RFSPHD, EMAW, 3, 2)
    FIELD(RAM_SETTING_RFSPHD, EMA, 0, 3)
REG32(TXNQ_RD_PRIORITY, 0x734)
    FIELD(TXNQ_RD_PRIORITY, ONLY_READ, 25, 1)
    FIELD(TXNQ_RD_PRIORITY, SKIP_COUNT_EN, 24, 1)
    FIELD(TXNQ_RD_PRIORITY, TH_HIGH, 16, 8)
    FIELD(TXNQ_RD_PRIORITY, TH_MED, 8, 8)
    FIELD(TXNQ_RD_PRIORITY, TH_LOW, 0, 8)
REG32(TXNQ_WR_PRIORITY, 0x738)
    FIELD(TXNQ_WR_PRIORITY, SKIP_COUNT_EN, 24, 1)
    FIELD(TXNQ_WR_PRIORITY, TH_HIGH, 16, 8)
    FIELD(TXNQ_WR_PRIORITY, TH_MED, 8, 8)
    FIELD(TXNQ_WR_PRIORITY, TH_LOW, 0, 8)
REG32(SEQ_INIT_CONFIG, 0x73c)
    FIELD(SEQ_INIT_CONFIG, SLOW_CK_EN, 16, 1)
    FIELD(SEQ_INIT_CONFIG, CK_PATTERN, 0, 16)
REG32(REG_SAFE_CONFIG5, 0x800)
    FIELD(REG_SAFE_CONFIG5, ADD_CMD_DELAY_EN, 31, 1)
    FIELD(REG_SAFE_CONFIG5, ADD_CMD_DELAY, 28, 3)
    FIELD(REG_SAFE_CONFIG5, TCCDMW, 21, 7)
    FIELD(REG_SAFE_CONFIG5, TRP_AB, 15, 6)
    FIELD(REG_SAFE_CONFIG5, CWL, 8, 7)
    FIELD(REG_SAFE_CONFIG5, CAS_LATENCY, 0, 7)
REG32(REG_REF_0, 0x804)
    FIELD(REG_REF_0, REFRESH_SPEED, 0, 2)
REG32(REG_REF_2, 0x808)
    FIELD(REG_REF_2, TRAFFIC_BASED_POWERDOWN_EN, 1, 1)
    FIELD(REG_REF_2, TRAFFIC_BASED_SELFREFRESH_EN, 0, 1)
REG32(REG_COM_1, 0x80c)
    FIELD(REG_COM_1, T_IDLE_ITVL_SELFREFRESH, 0, 27)
REG32(REG_COM_2, 0x810)
    FIELD(REG_COM_2, T_IDLE_ITVL_POWERDOWN, 0, 27)
REG32(REG_MRS_2, 0x814)
    FIELD(REG_MRS_2, MRS_OSCI_EN_RANK1, 2, 1)
    FIELD(REG_MRS_2, MRS_OSCI_EN_LPDDR4_1, 1, 1)
    FIELD(REG_MRS_2, MRS_OSCI_EN_LPDDR4_0, 0, 1)
REG32(REG_SCRUB1, 0x818)
    FIELD(REG_SCRUB1, SCRUB_TIMEOUT, 24, 8)
    FIELD(REG_SCRUB1, SCRUB_INTVL, 0, 24)
REG32(REG_SCRUB8, 0x81c)
    FIELD(REG_SCRUB8, LOOP, 1, 1)
    FIELD(REG_SCRUB8, MODE, 0, 1)
REG32(REG_SCRUB9, 0x820)
    FIELD(REG_SCRUB9, OTF_SCRUB_EN, 0, 1)
REG32(REG_CONFIG1, 0x824)
    FIELD(REG_CONFIG1, REF_EN_1, 2, 1)
    FIELD(REG_CONFIG1, REF_EN_0, 1, 1)
    FIELD(REG_CONFIG1, REF_MODE, 0, 1)
REG32(REG_CONFIG2, 0x828)
    FIELD(REG_CONFIG2, PER_RD_H_THRESH, 21, 10)
    FIELD(REG_CONFIG2, PER_RD_INTERVAL, 1, 20)
    FIELD(REG_CONFIG2, PER_RD_EN, 0, 1)
REG32(CAL_MODE, 0x82c)
    FIELD(CAL_MODE, BYPASS, 0, 1)
REG32(PHY_RDEN0, 0x830)
    FIELD(PHY_RDEN0, DLY, 0, 7)
REG32(PHY_RDEN1, 0x834)
    FIELD(PHY_RDEN1, DLY, 0, 7)
REG32(PHY_RDEN2, 0x838)
    FIELD(PHY_RDEN2, DLY, 0, 7)
REG32(PHY_RDEN3, 0x83c)
    FIELD(PHY_RDEN3, DLY, 0, 7)
REG32(PHY_RDEN4, 0x840)
    FIELD(PHY_RDEN4, DLY, 0, 7)
REG32(PHY_RDEN5, 0x844)
    FIELD(PHY_RDEN5, DLY, 0, 7)
REG32(PHY_RDEN6, 0x848)
    FIELD(PHY_RDEN6, DLY, 0, 7)
REG32(PHY_RDEN7, 0x84c)
    FIELD(PHY_RDEN7, DLY, 0, 7)
REG32(PHY_RDEN8, 0x850)
    FIELD(PHY_RDEN8, DLY, 0, 7)
REG32(PHY_RDEN9, 0x854)
    FIELD(PHY_RDEN9, DLY, 0, 7)
REG32(PHY_RDEN10, 0x858)
    FIELD(PHY_RDEN10, DLY, 0, 7)
REG32(PHY_RDEN11, 0x85c)
    FIELD(PHY_RDEN11, DLY, 0, 7)
REG32(PHY_RDEN12, 0x860)
    FIELD(PHY_RDEN12, DLY, 0, 7)
REG32(PHY_RDEN13, 0x864)
    FIELD(PHY_RDEN13, DLY, 0, 7)
REG32(PHY_RDEN14, 0x868)
    FIELD(PHY_RDEN14, DLY, 0, 7)
REG32(PHY_RDEN15, 0x86c)
    FIELD(PHY_RDEN15, DLY, 0, 7)
REG32(PHY_RDEN16, 0x870)
    FIELD(PHY_RDEN16, DLY, 0, 7)
REG32(PHY_RDEN17, 0x874)
    FIELD(PHY_RDEN17, DLY, 0, 7)
REG32(PHY_RDEN18, 0x878)
    FIELD(PHY_RDEN18, DLY, 0, 7)
REG32(PHY_RDEN19, 0x87c)
    FIELD(PHY_RDEN19, DLY, 0, 7)
REG32(PHY_RDEN20, 0x880)
    FIELD(PHY_RDEN20, DLY, 0, 7)
REG32(PHY_RDEN21, 0x884)
    FIELD(PHY_RDEN21, DLY, 0, 7)
REG32(PHY_RDEN22, 0x888)
    FIELD(PHY_RDEN22, DLY, 0, 7)
REG32(PHY_RDEN23, 0x88c)
    FIELD(PHY_RDEN23, DLY, 0, 7)
REG32(PHY_RDEN24, 0x890)
    FIELD(PHY_RDEN24, DLY, 0, 7)
REG32(PHY_RDEN25, 0x894)
    FIELD(PHY_RDEN25, DLY, 0, 7)
REG32(PHY_RDEN26, 0x898)
    FIELD(PHY_RDEN26, DLY, 0, 7)
REG32(FIFO_RDEN, 0x89c)
    FIELD(FIFO_RDEN, DLY, 0, 7)
REG32(DBG_TRIGGER, 0x8a0)
    FIELD(DBG_TRIGGER, SOURCE, 1, 2)
    FIELD(DBG_TRIGGER, EN, 0, 1)
REG32(CAL_CS_CH, 0x8a4)
    FIELD(CAL_CS_CH, SEL, 1, 1)
    FIELD(CAL_CS_CH, EN, 0, 1)
REG32(PHY_RANK_READ_OVERRIDE, 0x8a8)
    FIELD(PHY_RANK_READ_OVERRIDE, CH1_RANK3, 16, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH1_RANK2, 14, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH1_RANK1, 12, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH1_RANK0, 10, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH0_RANK3, 8, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH0_RANK2, 6, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH0_RANK1, 4, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, CH0_RANK0, 2, 2)
    FIELD(PHY_RANK_READ_OVERRIDE, STATIC_ENABLE, 0, 2)
REG32(SEQ_MODE, 0x8ac)
    FIELD(SEQ_MODE, VAL, 0, 3)
REG32(SEQ_CMD_DEFAULT, 0x8b0)
    FIELD(SEQ_CMD_DEFAULT, OPCODE, 0, 7)
REG32(SEQ_ADDR_DEFAULT, 0x8b4)
    FIELD(SEQ_ADDR_DEFAULT, VAL, 0, 1)
REG32(SEQ_BA_DEFAULT, 0x8b8)
    FIELD(SEQ_BA_DEFAULT, VAL, 0, 1)
REG32(SEQ_BG_DEFAULT, 0x8bc)
    FIELD(SEQ_BG_DEFAULT, VAL, 0, 1)
REG32(SEQ_CBIT_DEFAULT, 0x8c0)
    FIELD(SEQ_CBIT_DEFAULT, VAL, 0, 1)
REG32(SEQ_CMD_POR, 0x8c4)
    FIELD(SEQ_CMD_POR, OPCODE, 0, 7)
REG32(SEQ_DQ_DEFAULT, 0x8c8)
    FIELD(SEQ_DQ_DEFAULT, VAL, 0, 5)
REG32(SEQ_DQS_DEFAULT, 0x8cc)
    FIELD(SEQ_DQS_DEFAULT, VAL, 0, 3)
REG32(SEQ_CK_CAL, 0x8d0)
    FIELD(SEQ_CK_CAL, PATTERN, 0, 16)
REG32(CPLX_CONFIG, 0x8d4)
    FIELD(CPLX_CONFIG, PATTERN_LENGTH, 25, 6)
    FIELD(CPLX_CONFIG, MAX_BURST_ARRAY_INDEX, 20, 5)
    FIELD(CPLX_CONFIG, MAX_BANK_CNT, 18, 2)
    FIELD(CPLX_CONFIG, MAX_ROW_CNT, 15, 3)
    FIELD(CPLX_CONFIG, MAX_LOOPS, 7, 8)
    FIELD(CPLX_CONFIG, DM_EN, 6, 1)
    FIELD(CPLX_CONFIG, RANK_EN, 2, 4)
    FIELD(CPLX_CONFIG, WRITE_CAL, 1, 1)
    FIELD(CPLX_CONFIG, START, 0, 1)
REG32(CPLX_CONFIG2, 0x8d8)
    FIELD(CPLX_CONFIG2, PREA2ACT_TIMER_VAL, 20, 5)
    FIELD(CPLX_CONFIG2, CAS2PRE_TIMER_VAL, 15, 5)
    FIELD(CPLX_CONFIG2, BURST_GAP_TIMER_VAL, 10, 5)
    FIELD(CPLX_CONFIG2, ACT_GAP_TIMER_VAL, 5, 5)
    FIELD(CPLX_CONFIG2, CAS_GAP_TIMER_VAL, 0, 5)
REG32(CPLX_BURST_ARRAY0, 0x8dc)
    FIELD(CPLX_BURST_ARRAY0, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY1, 0x8e0)
    FIELD(CPLX_BURST_ARRAY1, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY2, 0x8e4)
    FIELD(CPLX_BURST_ARRAY2, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY3, 0x8e8)
    FIELD(CPLX_BURST_ARRAY3, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY4, 0x8ec)
    FIELD(CPLX_BURST_ARRAY4, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY5, 0x8f0)
    FIELD(CPLX_BURST_ARRAY5, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY6, 0x8f4)
    FIELD(CPLX_BURST_ARRAY6, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY7, 0x8f8)
    FIELD(CPLX_BURST_ARRAY7, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY8, 0x8fc)
    FIELD(CPLX_BURST_ARRAY8, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY9, 0x900)
    FIELD(CPLX_BURST_ARRAY9, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY10, 0x904)
    FIELD(CPLX_BURST_ARRAY10, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY11, 0x908)
    FIELD(CPLX_BURST_ARRAY11, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY12, 0x90c)
    FIELD(CPLX_BURST_ARRAY12, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY13, 0x910)
    FIELD(CPLX_BURST_ARRAY13, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY14, 0x914)
    FIELD(CPLX_BURST_ARRAY14, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY15, 0x918)
    FIELD(CPLX_BURST_ARRAY15, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY16, 0x91c)
    FIELD(CPLX_BURST_ARRAY16, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY17, 0x920)
    FIELD(CPLX_BURST_ARRAY17, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY18, 0x924)
    FIELD(CPLX_BURST_ARRAY18, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY19, 0x928)
    FIELD(CPLX_BURST_ARRAY19, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY20, 0x92c)
    FIELD(CPLX_BURST_ARRAY20, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY21, 0x930)
    FIELD(CPLX_BURST_ARRAY21, VAL, 0, 5)
REG32(CPLX_BURST_ARRAY22, 0x934)
    FIELD(CPLX_BURST_ARRAY22, VAL, 0, 5)
REG32(PRBS_CONFIG, 0x938)
    FIELD(PRBS_CONFIG, DLY_RANK_SWITCH, 13, 4)
    FIELD(PRBS_CONFIG, RANK_EN, 9, 4)
    FIELD(PRBS_CONFIG, MODE, 7, 2)
    FIELD(PRBS_CONFIG, COL_BITS, 3, 4)
    FIELD(PRBS_CONFIG, FRF_ENABLE, 2, 1)
    FIELD(PRBS_CONFIG, RUN_FOREVER, 1, 1)
    FIELD(PRBS_CONFIG, RD_LOOP, 0, 1)
REG32(PRBS_CONFIG2, 0x93c)
    FIELD(PRBS_CONFIG2, START_ADDR, 0, 18)
REG32(PRBS_CNT, 0x940)
    FIELD(PRBS_CNT, LOOP_END, 16, 16)
    FIELD(PRBS_CNT, SEQ_END, 0, 16)
REG32(XPI_OE_ALL_NIB, 0x944)
    FIELD(XPI_OE_ALL_NIB, DLY_OFFSET, 7, 4)
    FIELD(XPI_OE_ALL_NIB, DLY, 0, 7)
REG32(XPI_WRDATA_ALL_NIB, 0x948)
    FIELD(XPI_WRDATA_ALL_NIB, DLY_OFFSET, 7, 4)
    FIELD(XPI_WRDATA_ALL_NIB, DLY, 0, 7)
REG32(XPI_OE, 0x94c)
    FIELD(XPI_OE, RD_POSTAMBLE_VAL, 12, 4)
    FIELD(XPI_OE, RD_PREAMBLE_VAL, 8, 4)
    FIELD(XPI_OE, POSTAMBLE_VAL, 4, 4)
    FIELD(XPI_OE, PREAMBLE_VAL, 0, 4)
REG32(XPI_PMI_CONFIG, 0x950)
    FIELD(XPI_PMI_CONFIG, PAR_RCD_EN, 8, 1)
    FIELD(XPI_PMI_CONFIG, MIR_BG_EN, 7, 1)
    FIELD(XPI_PMI_CONFIG, PAR_BG1_EN, 6, 1)
    FIELD(XPI_PMI_CONFIG, PAR_A17_EN, 5, 1)
    FIELD(XPI_PMI_CONFIG, MIR_EN, 4, 1)
    FIELD(XPI_PMI_CONFIG, ALERT_EN, 2, 2)
    FIELD(XPI_PMI_CONFIG, PAR_EN, 1, 1)
    FIELD(XPI_PMI_CONFIG, INV_EN, 0, 1)
REG32(XPI_READ_OFFSET, 0x954)
    FIELD(XPI_READ_OFFSET, RDCS_2_DMC_CLK, 13, 1)
    FIELD(XPI_READ_OFFSET, RMW_BP_RETURN_RPTR, 10, 3)
    FIELD(XPI_READ_OFFSET, RAW_RETURN_RPTR, 7, 3)
    FIELD(XPI_READ_OFFSET, RD_RETURN_RPTR, 4, 3)
    FIELD(XPI_READ_OFFSET, PHY_RDEN, 0, 4)
REG32(XPI_WRITE_DM_DBI, 0x958)
    FIELD(XPI_WRITE_DM_DBI, AC_DBI_TRI_STATE, 3, 1)
    FIELD(XPI_WRITE_DM_DBI, CONFIG, 0, 3)
REG32(XPI_READ_DBI, 0x95c)
    FIELD(XPI_READ_DBI, MR_READ_EN, 1, 1)
    FIELD(XPI_READ_DBI, EN, 0, 1)
REG32(DEFAULT_PATTERN, 0x960)
    FIELD(DEFAULT_PATTERN, DQS_T_IDLE, 8, 2)
    FIELD(DEFAULT_PATTERN, CK_N, 4, 4)
    FIELD(DEFAULT_PATTERN, CK_T, 0, 4)
REG32(T_TXBIT, 0x964)
    FIELD(T_TXBIT, OUTPUTS_OFF, 0, 1)
REG32(PRBS_SEED0, 0x968)
    FIELD(PRBS_SEED0, DATA, 0, 23)
REG32(PRBS_SEED1, 0x96c)
    FIELD(PRBS_SEED1, DATA, 0, 23)
REG32(PRBS_SEED2, 0x970)
    FIELD(PRBS_SEED2, DATA, 0, 23)
REG32(PRBS_SEED3, 0x974)
    FIELD(PRBS_SEED3, DATA, 0, 23)
REG32(PRBS_SEED4, 0x978)
    FIELD(PRBS_SEED4, DATA, 0, 23)
REG32(PRBS_SEED5, 0x97c)
    FIELD(PRBS_SEED5, DATA, 0, 23)
REG32(PRBS_SEED6, 0x980)
    FIELD(PRBS_SEED6, DATA, 0, 23)
REG32(PRBS_SEED7, 0x984)
    FIELD(PRBS_SEED7, DATA, 0, 23)
REG32(PRBS_SEED8, 0x988)
    FIELD(PRBS_SEED8, DATA, 0, 23)
REG32(CPLX_PATTERN0, 0x98c)
    FIELD(CPLX_PATTERN0, VAL, 0, 16)
REG32(CPLX_PATTERN1, 0x990)
    FIELD(CPLX_PATTERN1, VAL, 0, 16)
REG32(CPLX_PATTERN2, 0x994)
    FIELD(CPLX_PATTERN2, VAL, 0, 16)
REG32(CPLX_PATTERN3, 0x998)
    FIELD(CPLX_PATTERN3, VAL, 0, 16)
REG32(CPLX_PATTERN4, 0x99c)
    FIELD(CPLX_PATTERN4, VAL, 0, 16)
REG32(CPLX_PATTERN5, 0x9a0)
    FIELD(CPLX_PATTERN5, VAL, 0, 16)
REG32(CPLX_PATTERN6, 0x9a4)
    FIELD(CPLX_PATTERN6, VAL, 0, 16)
REG32(CPLX_PATTERN7, 0x9a8)
    FIELD(CPLX_PATTERN7, VAL, 0, 16)
REG32(CPLX_PATTERN8, 0x9ac)
    FIELD(CPLX_PATTERN8, VAL, 0, 16)
REG32(CPLX_PATTERN9, 0x9b0)
    FIELD(CPLX_PATTERN9, VAL, 0, 16)
REG32(CPLX_PATTERN10, 0x9b4)
    FIELD(CPLX_PATTERN10, VAL, 0, 16)
REG32(CPLX_PATTERN11, 0x9b8)
    FIELD(CPLX_PATTERN11, VAL, 0, 16)
REG32(CPLX_PATTERN12, 0x9bc)
    FIELD(CPLX_PATTERN12, VAL, 0, 16)
REG32(CPLX_PATTERN13, 0x9c0)
    FIELD(CPLX_PATTERN13, VAL, 0, 16)
REG32(CPLX_PATTERN14, 0x9c4)
    FIELD(CPLX_PATTERN14, VAL, 0, 16)
REG32(CPLX_PATTERN15, 0x9c8)
    FIELD(CPLX_PATTERN15, VAL, 0, 16)
REG32(CPLX_PATTERN16, 0x9cc)
    FIELD(CPLX_PATTERN16, VAL, 0, 16)
REG32(CPLX_PATTERN17, 0x9d0)
    FIELD(CPLX_PATTERN17, VAL, 0, 16)
REG32(CPLX_PATTERN18, 0x9d4)
    FIELD(CPLX_PATTERN18, VAL, 0, 16)
REG32(CPLX_PATTERN19, 0x9d8)
    FIELD(CPLX_PATTERN19, VAL, 0, 16)
REG32(CPLX_PATTERN20, 0x9dc)
    FIELD(CPLX_PATTERN20, VAL, 0, 16)
REG32(CPLX_PATTERN21, 0x9e0)
    FIELD(CPLX_PATTERN21, VAL, 0, 16)
REG32(CPLX_PATTERN22, 0x9e4)
    FIELD(CPLX_PATTERN22, VAL, 0, 16)
REG32(CPLX_PATTERN23, 0x9e8)
    FIELD(CPLX_PATTERN23, VAL, 0, 16)
REG32(CPLX_PATTERN24, 0x9ec)
    FIELD(CPLX_PATTERN24, VAL, 0, 16)
REG32(CPLX_PATTERN25, 0x9f0)
    FIELD(CPLX_PATTERN25, VAL, 0, 16)
REG32(CPLX_PATTERN26, 0x9f4)
    FIELD(CPLX_PATTERN26, VAL, 0, 16)
REG32(CPLX_PATTERN27, 0x9f8)
    FIELD(CPLX_PATTERN27, VAL, 0, 16)
REG32(CPLX_PATTERN28, 0x9fc)
    FIELD(CPLX_PATTERN28, VAL, 0, 16)
REG32(CPLX_PATTERN29, 0xa00)
    FIELD(CPLX_PATTERN29, VAL, 0, 16)
REG32(CPLX_PATTERN30, 0xa04)
    FIELD(CPLX_PATTERN30, VAL, 0, 16)
REG32(CPLX_PATTERN31, 0xa08)
    FIELD(CPLX_PATTERN31, VAL, 0, 16)
REG32(CPLX_PATTERN32, 0xa0c)
    FIELD(CPLX_PATTERN32, VAL, 0, 16)
REG32(CPLX_PATTERN33, 0xa10)
    FIELD(CPLX_PATTERN33, VAL, 0, 16)
REG32(CPLX_PATTERN34, 0xa14)
    FIELD(CPLX_PATTERN34, VAL, 0, 16)
REG32(CPLX_PATTERN35, 0xa18)
    FIELD(CPLX_PATTERN35, VAL, 0, 16)
REG32(CPLX_PATTERN36, 0xa1c)
    FIELD(CPLX_PATTERN36, VAL, 0, 16)
REG32(CPLX_PATTERN37, 0xa20)
    FIELD(CPLX_PATTERN37, VAL, 0, 16)
REG32(CPLX_PATTERN38, 0xa24)
    FIELD(CPLX_PATTERN38, VAL, 0, 16)
REG32(CPLX_PATTERN39, 0xa28)
    FIELD(CPLX_PATTERN39, VAL, 0, 16)
REG32(CPLX_PATTERN40, 0xa2c)
    FIELD(CPLX_PATTERN40, VAL, 0, 16)
REG32(CPLX_PATTERN41, 0xa30)
    FIELD(CPLX_PATTERN41, VAL, 0, 16)
REG32(CPLX_PATTERN42, 0xa34)
    FIELD(CPLX_PATTERN42, VAL, 0, 16)
REG32(CPLX_PATTERN43, 0xa38)
    FIELD(CPLX_PATTERN43, VAL, 0, 16)
REG32(CPLX_PATTERN44, 0xa3c)
    FIELD(CPLX_PATTERN44, VAL, 0, 16)
REG32(CPLX_PATTERN45, 0xa40)
    FIELD(CPLX_PATTERN45, VAL, 0, 16)
REG32(CPLX_PATTERN46, 0xa44)
    FIELD(CPLX_PATTERN46, VAL, 0, 16)
REG32(CPLX_PATTERN47, 0xa48)
    FIELD(CPLX_PATTERN47, VAL, 0, 16)
REG32(CPLX_PATTERN48, 0xa4c)
    FIELD(CPLX_PATTERN48, VAL, 0, 16)
REG32(CPLX_PATTERN49, 0xa50)
    FIELD(CPLX_PATTERN49, VAL, 0, 16)
REG32(CPLX_PATTERN50, 0xa54)
    FIELD(CPLX_PATTERN50, VAL, 0, 16)
REG32(CPLX_PATTERN51, 0xa58)
    FIELD(CPLX_PATTERN51, VAL, 0, 16)
REG32(CPLX_PATTERN52, 0xa5c)
    FIELD(CPLX_PATTERN52, VAL, 0, 16)
REG32(CPLX_PATTERN53, 0xa60)
    FIELD(CPLX_PATTERN53, VAL, 0, 16)
REG32(CPLX_PATTERN54, 0xa64)
    FIELD(CPLX_PATTERN54, VAL, 0, 16)
REG32(CPLX_PATTERN55, 0xa68)
    FIELD(CPLX_PATTERN55, VAL, 0, 16)
REG32(CPLX_PATTERN56, 0xa6c)
    FIELD(CPLX_PATTERN56, VAL, 0, 16)
REG32(CPLX_PATTERN57, 0xa70)
    FIELD(CPLX_PATTERN57, VAL, 0, 16)
REG32(CPLX_PATTERN58, 0xa74)
    FIELD(CPLX_PATTERN58, VAL, 0, 16)
REG32(CPLX_PATTERN59, 0xa78)
    FIELD(CPLX_PATTERN59, VAL, 0, 16)
REG32(CPLX_PATTERN60, 0xa7c)
    FIELD(CPLX_PATTERN60, VAL, 0, 16)
REG32(CPLX_PATTERN61, 0xa80)
    FIELD(CPLX_PATTERN61, VAL, 0, 16)
REG32(CPLX_PATTERN62, 0xa84)
    FIELD(CPLX_PATTERN62, VAL, 0, 16)
REG32(CPLX_PATTERN63, 0xa88)
    FIELD(CPLX_PATTERN63, VAL, 0, 16)
REG32(CPLX_PATTERN64, 0xa8c)
    FIELD(CPLX_PATTERN64, VAL, 0, 16)
REG32(CPLX_PATTERN65, 0xa90)
    FIELD(CPLX_PATTERN65, VAL, 0, 16)
REG32(CPLX_PATTERN66, 0xa94)
    FIELD(CPLX_PATTERN66, VAL, 0, 16)
REG32(CPLX_PATTERN67, 0xa98)
    FIELD(CPLX_PATTERN67, VAL, 0, 16)
REG32(CPLX_PATTERN68, 0xa9c)
    FIELD(CPLX_PATTERN68, VAL, 0, 16)
REG32(CPLX_PATTERN69, 0xaa0)
    FIELD(CPLX_PATTERN69, VAL, 0, 16)
REG32(CPLX_PATTERN70, 0xaa4)
    FIELD(CPLX_PATTERN70, VAL, 0, 16)
REG32(CPLX_PATTERN71, 0xaa8)
    FIELD(CPLX_PATTERN71, VAL, 0, 16)
REG32(CPLX_PATTERN72, 0xaac)
    FIELD(CPLX_PATTERN72, VAL, 0, 16)
REG32(CPLX_PATTERN73, 0xab0)
    FIELD(CPLX_PATTERN73, VAL, 0, 16)
REG32(CPLX_PATTERN74, 0xab4)
    FIELD(CPLX_PATTERN74, VAL, 0, 16)
REG32(CPLX_PATTERN75, 0xab8)
    FIELD(CPLX_PATTERN75, VAL, 0, 16)
REG32(CPLX_PATTERN76, 0xabc)
    FIELD(CPLX_PATTERN76, VAL, 0, 16)
REG32(CPLX_PATTERN77, 0xac0)
    FIELD(CPLX_PATTERN77, VAL, 0, 16)
REG32(CPLX_PATTERN78, 0xac4)
    FIELD(CPLX_PATTERN78, VAL, 0, 16)
REG32(CPLX_PATTERN79, 0xac8)
    FIELD(CPLX_PATTERN79, VAL, 0, 16)
REG32(CPLX_PATTERN80, 0xacc)
    FIELD(CPLX_PATTERN80, VAL, 0, 16)
REG32(CPLX_PATTERN81, 0xad0)
    FIELD(CPLX_PATTERN81, VAL, 0, 16)
REG32(CPLX_PATTERN82, 0xad4)
    FIELD(CPLX_PATTERN82, VAL, 0, 16)
REG32(CPLX_PATTERN83, 0xad8)
    FIELD(CPLX_PATTERN83, VAL, 0, 16)
REG32(CPLX_PATTERN84, 0xadc)
    FIELD(CPLX_PATTERN84, VAL, 0, 16)
REG32(CPLX_PATTERN85, 0xae0)
    FIELD(CPLX_PATTERN85, VAL, 0, 16)
REG32(CPLX_PATTERN86, 0xae4)
    FIELD(CPLX_PATTERN86, VAL, 0, 16)
REG32(CPLX_PATTERN87, 0xae8)
    FIELD(CPLX_PATTERN87, VAL, 0, 16)
REG32(CPLX_PATTERN88, 0xaec)
    FIELD(CPLX_PATTERN88, VAL, 0, 16)
REG32(CPLX_PATTERN89, 0xaf0)
    FIELD(CPLX_PATTERN89, VAL, 0, 16)
REG32(CPLX_PATTERN90, 0xaf4)
    FIELD(CPLX_PATTERN90, VAL, 0, 16)
REG32(CPLX_PATTERN91, 0xaf8)
    FIELD(CPLX_PATTERN91, VAL, 0, 16)
REG32(CPLX_PATTERN92, 0xafc)
    FIELD(CPLX_PATTERN92, VAL, 0, 16)
REG32(CPLX_PATTERN93, 0xb00)
    FIELD(CPLX_PATTERN93, VAL, 0, 16)
REG32(CPLX_PATTERN94, 0xb04)
    FIELD(CPLX_PATTERN94, VAL, 0, 16)
REG32(CPLX_PATTERN95, 0xb08)
    FIELD(CPLX_PATTERN95, VAL, 0, 16)
REG32(CPLX_PATTERN96, 0xb0c)
    FIELD(CPLX_PATTERN96, VAL, 0, 16)
REG32(CPLX_PATTERN97, 0xb10)
    FIELD(CPLX_PATTERN97, VAL, 0, 16)
REG32(CPLX_PATTERN98, 0xb14)
    FIELD(CPLX_PATTERN98, VAL, 0, 16)
REG32(CPLX_PATTERN99, 0xb18)
    FIELD(CPLX_PATTERN99, VAL, 0, 16)
REG32(CPLX_PATTERN100, 0xb1c)
    FIELD(CPLX_PATTERN100, VAL, 0, 16)
REG32(CPLX_PATTERN101, 0xb20)
    FIELD(CPLX_PATTERN101, VAL, 0, 16)
REG32(CPLX_PATTERN102, 0xb24)
    FIELD(CPLX_PATTERN102, VAL, 0, 16)
REG32(CPLX_PATTERN103, 0xb28)
    FIELD(CPLX_PATTERN103, VAL, 0, 16)
REG32(CPLX_PATTERN104, 0xb2c)
    FIELD(CPLX_PATTERN104, VAL, 0, 16)
REG32(CPLX_PATTERN105, 0xb30)
    FIELD(CPLX_PATTERN105, VAL, 0, 16)
REG32(CPLX_PATTERN106, 0xb34)
    FIELD(CPLX_PATTERN106, VAL, 0, 16)
REG32(CPLX_PATTERN107, 0xb38)
    FIELD(CPLX_PATTERN107, VAL, 0, 16)
REG32(CPLX_PATTERN108, 0xb3c)
    FIELD(CPLX_PATTERN108, VAL, 0, 16)
REG32(CPLX_PATTERN109, 0xb40)
    FIELD(CPLX_PATTERN109, VAL, 0, 16)
REG32(CPLX_PATTERN110, 0xb44)
    FIELD(CPLX_PATTERN110, VAL, 0, 16)
REG32(CPLX_PATTERN111, 0xb48)
    FIELD(CPLX_PATTERN111, VAL, 0, 16)
REG32(CPLX_PATTERN112, 0xb4c)
    FIELD(CPLX_PATTERN112, VAL, 0, 16)
REG32(CPLX_PATTERN113, 0xb50)
    FIELD(CPLX_PATTERN113, VAL, 0, 16)
REG32(CPLX_PATTERN114, 0xb54)
    FIELD(CPLX_PATTERN114, VAL, 0, 16)
REG32(CPLX_PATTERN115, 0xb58)
    FIELD(CPLX_PATTERN115, VAL, 0, 16)
REG32(CPLX_PATTERN116, 0xb5c)
    FIELD(CPLX_PATTERN116, VAL, 0, 16)
REG32(CPLX_PATTERN117, 0xb60)
    FIELD(CPLX_PATTERN117, VAL, 0, 16)
REG32(CPLX_PATTERN118, 0xb64)
    FIELD(CPLX_PATTERN118, VAL, 0, 16)
REG32(CPLX_PATTERN119, 0xb68)
    FIELD(CPLX_PATTERN119, VAL, 0, 16)
REG32(CPLX_PATTERN120, 0xb6c)
    FIELD(CPLX_PATTERN120, VAL, 0, 16)
REG32(CPLX_PATTERN121, 0xb70)
    FIELD(CPLX_PATTERN121, VAL, 0, 16)
REG32(CPLX_PATTERN122, 0xb74)
    FIELD(CPLX_PATTERN122, VAL, 0, 16)
REG32(CPLX_PATTERN123, 0xb78)
    FIELD(CPLX_PATTERN123, VAL, 0, 16)
REG32(CPLX_PATTERN124, 0xb7c)
    FIELD(CPLX_PATTERN124, VAL, 0, 16)
REG32(CPLX_PATTERN125, 0xb80)
    FIELD(CPLX_PATTERN125, VAL, 0, 16)
REG32(CPLX_PATTERN126, 0xb84)
    FIELD(CPLX_PATTERN126, VAL, 0, 16)
REG32(CPLX_PATTERN127, 0xb88)
    FIELD(CPLX_PATTERN127, VAL, 0, 16)
REG32(CPLX_PATTERN128, 0xb8c)
    FIELD(CPLX_PATTERN128, VAL, 0, 16)
REG32(CPLX_PATTERN129, 0xb90)
    FIELD(CPLX_PATTERN129, VAL, 0, 16)
REG32(CPLX_PATTERN130, 0xb94)
    FIELD(CPLX_PATTERN130, VAL, 0, 16)
REG32(CPLX_PATTERN131, 0xb98)
    FIELD(CPLX_PATTERN131, VAL, 0, 16)
REG32(CPLX_PATTERN132, 0xb9c)
    FIELD(CPLX_PATTERN132, VAL, 0, 16)
REG32(CPLX_PATTERN133, 0xba0)
    FIELD(CPLX_PATTERN133, VAL, 0, 16)
REG32(CPLX_PATTERN134, 0xba4)
    FIELD(CPLX_PATTERN134, VAL, 0, 16)
REG32(CPLX_PATTERN135, 0xba8)
    FIELD(CPLX_PATTERN135, VAL, 0, 16)
REG32(CPLX_PATTERN136, 0xbac)
    FIELD(CPLX_PATTERN136, VAL, 0, 16)
REG32(CPLX_PATTERN137, 0xbb0)
    FIELD(CPLX_PATTERN137, VAL, 0, 16)
REG32(CPLX_PATTERN138, 0xbb4)
    FIELD(CPLX_PATTERN138, VAL, 0, 16)
REG32(CPLX_PATTERN139, 0xbb8)
    FIELD(CPLX_PATTERN139, VAL, 0, 16)
REG32(CPLX_PATTERN140, 0xbbc)
    FIELD(CPLX_PATTERN140, VAL, 0, 16)
REG32(CPLX_PATTERN141, 0xbc0)
    FIELD(CPLX_PATTERN141, VAL, 0, 16)
REG32(CPLX_PATTERN142, 0xbc4)
    FIELD(CPLX_PATTERN142, VAL, 0, 16)
REG32(CPLX_PATTERN143, 0xbc8)
    FIELD(CPLX_PATTERN143, VAL, 0, 16)
REG32(CPLX_PATTERN144, 0xbcc)
    FIELD(CPLX_PATTERN144, VAL, 0, 16)
REG32(CPLX_PATTERN145, 0xbd0)
    FIELD(CPLX_PATTERN145, VAL, 0, 16)
REG32(CPLX_PATTERN146, 0xbd4)
    FIELD(CPLX_PATTERN146, VAL, 0, 16)
REG32(CPLX_PATTERN147, 0xbd8)
    FIELD(CPLX_PATTERN147, VAL, 0, 16)
REG32(CPLX_PATTERN148, 0xbdc)
    FIELD(CPLX_PATTERN148, VAL, 0, 16)
REG32(CPLX_PATTERN149, 0xbe0)
    FIELD(CPLX_PATTERN149, VAL, 0, 16)
REG32(CPLX_PATTERN150, 0xbe4)
    FIELD(CPLX_PATTERN150, VAL, 0, 16)
REG32(CPLX_PATTERN151, 0xbe8)
    FIELD(CPLX_PATTERN151, VAL, 0, 16)
REG32(CPLX_PATTERN152, 0xbec)
    FIELD(CPLX_PATTERN152, VAL, 0, 16)
REG32(CPLX_PATTERN153, 0xbf0)
    FIELD(CPLX_PATTERN153, VAL, 0, 16)
REG32(CPLX_PATTERN154, 0xbf4)
    FIELD(CPLX_PATTERN154, VAL, 0, 16)
REG32(CPLX_PATTERN155, 0xbf8)
    FIELD(CPLX_PATTERN155, VAL, 0, 16)
REG32(CPLX_PATTERN156, 0xbfc)
    FIELD(CPLX_PATTERN156, VAL, 0, 16)
REG32(PHY_RANK_WRITE_OVERRIDE, 0xc00)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH1_RANK3, 16, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH1_RANK2, 14, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH1_RANK1, 12, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH1_RANK0, 10, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH0_RANK3, 8, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH0_RANK2, 6, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH0_RANK1, 4, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, CH0_RANK0, 2, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE, STATIC_ENABLE, 0, 2)
REG32(CPLX_CONFIG3, 0xc04)
    FIELD(CPLX_CONFIG3, COL, 4, 6)
    FIELD(CPLX_CONFIG3, BG, 2, 2)
    FIELD(CPLX_CONFIG3, ROW, 0, 2)
REG32(CLK_GATE, 0xc08)
    FIELD(CLK_GATE, DDRMC_EN, 18, 1)
    FIELD(CLK_GATE, NA_DYN_GATE_DIS, 17, 1)
    FIELD(CLK_GATE, CHAN1_DYN_GATE_DIS, 16, 1)
    FIELD(CLK_GATE, CHAN0_DYN_GATE_DIS, 15, 1)
    FIELD(CLK_GATE, NSU3_EN, 14, 1)
    FIELD(CLK_GATE, NSU2_EN, 13, 1)
    FIELD(CLK_GATE, NSU1_EN, 12, 1)
    FIELD(CLK_GATE, NSU0_EN, 11, 1)
    FIELD(CLK_GATE, CMDQ_BEW_EN, 10, 1)
    FIELD(CLK_GATE, CMDQ_ISOW_EN, 9, 1)
    FIELD(CLK_GATE, CMDQ_BER_EN, 8, 1)
    FIELD(CLK_GATE, CMDQ_ISOR_EN, 7, 1)
    FIELD(CLK_GATE, CMDQ_LLR_EN, 6, 1)
    FIELD(CLK_GATE, DEBUG_EN, 5, 1)
    FIELD(CLK_GATE, CAL_RD_DATA_EN, 4, 1)
    FIELD(CLK_GATE, CHAN1_EN, 3, 1)
    FIELD(CLK_GATE, CHAN1_DATA_EN, 2, 1)
    FIELD(CLK_GATE, CPLX_EN, 1, 1)
    FIELD(CLK_GATE, PRBS_EN, 0, 1)
REG32(XPI_DQS, 0xc0c)
    FIELD(XPI_DQS, PRE_PATTERN, 6, 2)
    FIELD(XPI_DQS, POST_PATTERN, 4, 2)
    FIELD(XPI_DQS, IDLE_VAL, 0, 4)
REG32(ARBITER_CONFIG, 0xc10)
    FIELD(ARBITER_CONFIG, PRIORITY_SETTING, 0, 1)
REG32(REG_COM_0, 0xc14)
    FIELD(REG_COM_0, SELF_REFRESH_EXIT_ERROR, 7, 1)
    FIELD(REG_COM_0, SELF_REFRESH_EXIT_DONE, 6, 1)
    FIELD(REG_COM_0, SELF_REFRESH_EXIT_ACK, 5, 1)
    FIELD(REG_COM_0, SELF_REFRESH_EXIT_REQ, 4, 1)
    FIELD(REG_COM_0, SELF_REFRESH_ENTER_ERROR, 3, 1)
    FIELD(REG_COM_0, SELF_REFRESH_ENTER_DONE, 2, 1)
    FIELD(REG_COM_0, SELF_REFRESH_ENTER_ACK, 1, 1)
    FIELD(REG_COM_0, SELF_REFRESH_ENTER_REQ, 0, 1)
REG32(REG_COM_4, 0xc18)
    FIELD(REG_COM_4, DRAM_MODE_REPORT, 0, 5)
REG32(REG_MRS_3, 0xc1c)
    FIELD(REG_MRS_3, MR_CMD_MA_LPDDR4, 26, 6)
    FIELD(REG_MRS_3, MR_CMD_OPCODE_LPDDR4, 18, 8)
    FIELD(REG_MRS_3, MR_CMD_DDR4, 0, 18)
REG32(REG_MRS_4, 0xc20)
    FIELD(REG_MRS_4, MRS_INVERT, 16, 1)
    FIELD(REG_MRS_4, MRS_MIRROR, 15, 1)
    FIELD(REG_MRS_4, MRS_MPR_LOCATION_DDR4, 13, 2)
    FIELD(REG_MRS_4, MRS_CS, 9, 4)
    FIELD(REG_MRS_4, MRS_ADDR, 3, 6)
    FIELD(REG_MRS_4, MR_CMD_TYPE, 0, 3)
REG32(REG_MRS_5, 0xc24)
    FIELD(REG_MRS_5, MRS_COMMAND_ERROR_0, 3, 1)
    FIELD(REG_MRS_5, MRS_COMMAND_DONE_0, 2, 1)
    FIELD(REG_MRS_5, MRS_COMMAND_BUSY_0, 1, 1)
    FIELD(REG_MRS_5, MRS_COMMAND_START_0, 0, 1)
REG32(REG_MRS_6, 0xc28)
    FIELD(REG_MRS_6, MRS_COMMAND_ERROR_1, 3, 1)
    FIELD(REG_MRS_6, MRS_COMMAND_DONE_1, 2, 1)
    FIELD(REG_MRS_6, MRS_COMMAND_BUSY_1, 1, 1)
    FIELD(REG_MRS_6, MRS_COMMAND_START_1, 0, 1)
REG32(REG_SCRUB2, 0xc2c)
    FIELD(REG_SCRUB2, STOP1, 3, 1)
    FIELD(REG_SCRUB2, START1, 2, 1)
    FIELD(REG_SCRUB2, STOP0, 1, 1)
    FIELD(REG_SCRUB2, START0, 0, 1)
REG32(REG_SCRUB3, 0xc30)
    FIELD(REG_SCRUB3, MEM_FILL_BUSY1, 5, 1)
    FIELD(REG_SCRUB3, MEM_FILL_BUSY0, 4, 1)
    FIELD(REG_SCRUB3, DONE1, 3, 1)
    FIELD(REG_SCRUB3, BUSY1, 2, 1)
    FIELD(REG_SCRUB3, DONE0, 1, 1)
    FIELD(REG_SCRUB3, BUSY0, 0, 1)
REG32(REG_SCRUB4, 0xc34)
    FIELD(REG_SCRUB4, BANK_ADD0, 28, 3)
    FIELD(REG_SCRUB4, COL_ADD0, 18, 10)
    FIELD(REG_SCRUB4, ROW_ADD0, 0, 18)
REG32(REG_SCRUB5, 0xc38)
    FIELD(REG_SCRUB5, NUM_FULL_SCRUB0, 7, 9)
    FIELD(REG_SCRUB5, RANK_ADD0, 5, 2)
    FIELD(REG_SCRUB5, C_ADD0, 2, 3)
    FIELD(REG_SCRUB5, GROUP_ADD0, 0, 2)
REG32(REG_SCRUB6, 0xc3c)
    FIELD(REG_SCRUB6, BANK_ADD1, 28, 3)
    FIELD(REG_SCRUB6, COL_ADD1, 18, 10)
    FIELD(REG_SCRUB6, ROW_ADD1, 0, 18)
REG32(REG_SCRUB7, 0xc40)
    FIELD(REG_SCRUB7, NUM_FULL_SCRUB1, 7, 9)
    FIELD(REG_SCRUB7, RANK_ADD1, 5, 2)
    FIELD(REG_SCRUB7, C_ADD1, 2, 3)
    FIELD(REG_SCRUB7, GROUP_ADD1, 0, 2)
REG32(DC_QUEUE_STATUS, 0xc44)
    FIELD(DC_QUEUE_STATUS, STARVED1_STKY, 25, 1)
    FIELD(DC_QUEUE_STATUS, STARVED1, 24, 1)
    FIELD(DC_QUEUE_STATUS, WR_LT_TH1_STKY, 23, 1)
    FIELD(DC_QUEUE_STATUS, WR_LT_TH1, 22, 1)
    FIELD(DC_QUEUE_STATUS, WR_GT_TH1_STKY, 21, 1)
    FIELD(DC_QUEUE_STATUS, WR_GT_TH1, 20, 1)
    FIELD(DC_QUEUE_STATUS, EMPTY1_STKY, 19, 1)
    FIELD(DC_QUEUE_STATUS, EMPTY1, 18, 1)
    FIELD(DC_QUEUE_STATUS, FULL1_STKY, 17, 1)
    FIELD(DC_QUEUE_STATUS, FULL1, 16, 1)
    FIELD(DC_QUEUE_STATUS, STARVED0_STKY, 9, 1)
    FIELD(DC_QUEUE_STATUS, STARVED0, 8, 1)
    FIELD(DC_QUEUE_STATUS, WR_LT_TH0_STKY, 7, 1)
    FIELD(DC_QUEUE_STATUS, WR_LT_TH0, 6, 1)
    FIELD(DC_QUEUE_STATUS, WR_GT_TH0_STKY, 5, 1)
    FIELD(DC_QUEUE_STATUS, WR_GT_TH0, 4, 1)
    FIELD(DC_QUEUE_STATUS, EMPTY0_STKY, 3, 1)
    FIELD(DC_QUEUE_STATUS, EMPTY0, 2, 1)
    FIELD(DC_QUEUE_STATUS, FULL0_STKY, 1, 1)
    FIELD(DC_QUEUE_STATUS, FULL0, 0, 1)
REG32(T_TXBIT_PWR_SAVE, 0xc48)
    FIELD(T_TXBIT_PWR_SAVE, OUTPUTS_OFF, 0, 1)
REG32(XPI_DYN_RANK, 0xc4c)
    FIELD(XPI_DYN_RANK, CH1_DBG, 8, 2)
    FIELD(XPI_DYN_RANK, CH1_DONE_CNT, 6, 2)
    FIELD(XPI_DYN_RANK, CH1_BUSY, 5, 1)
    FIELD(XPI_DYN_RANK, CH0_DBG, 3, 2)
    FIELD(XPI_DYN_RANK, CH0_DONE_CNT, 1, 2)
    FIELD(XPI_DYN_RANK, CH0_BUSY, 0, 1)
REG32(PHY_OE_NIB0, 0xc50)
    FIELD(PHY_OE_NIB0, DLY, 0, 3)
REG32(PHY_OE_NIB1, 0xc54)
    FIELD(PHY_OE_NIB1, DLY, 0, 3)
REG32(PHY_OE_NIB2, 0xc58)
    FIELD(PHY_OE_NIB2, DLY, 0, 3)
REG32(PHY_OE_NIB3, 0xc5c)
    FIELD(PHY_OE_NIB3, DLY, 0, 3)
REG32(PHY_OE_NIB4, 0xc60)
    FIELD(PHY_OE_NIB4, DLY, 0, 3)
REG32(PHY_OE_NIB5, 0xc64)
    FIELD(PHY_OE_NIB5, DLY, 0, 3)
REG32(PHY_OE_NIB6, 0xc68)
    FIELD(PHY_OE_NIB6, DLY, 0, 3)
REG32(PHY_OE_NIB7, 0xc6c)
    FIELD(PHY_OE_NIB7, DLY, 0, 3)
REG32(PHY_OE_NIB8, 0xc70)
    FIELD(PHY_OE_NIB8, DLY, 0, 3)
REG32(PHY_OE_NIB9, 0xc74)
    FIELD(PHY_OE_NIB9, DLY, 0, 3)
REG32(PHY_OE_NIB10, 0xc78)
    FIELD(PHY_OE_NIB10, DLY, 0, 3)
REG32(PHY_OE_NIB11, 0xc7c)
    FIELD(PHY_OE_NIB11, DLY, 0, 3)
REG32(PHY_OE_NIB12, 0xc80)
    FIELD(PHY_OE_NIB12, DLY, 0, 3)
REG32(PHY_OE_NIB13, 0xc84)
    FIELD(PHY_OE_NIB13, DLY, 0, 3)
REG32(PHY_OE_NIB14, 0xc88)
    FIELD(PHY_OE_NIB14, DLY, 0, 3)
REG32(PHY_OE_NIB15, 0xc8c)
    FIELD(PHY_OE_NIB15, DLY, 0, 3)
REG32(PHY_OE_NIB16, 0xc90)
    FIELD(PHY_OE_NIB16, DLY, 0, 3)
REG32(PHY_OE_NIB17, 0xc94)
    FIELD(PHY_OE_NIB17, DLY, 0, 3)
REG32(PHY_OE_NIB18, 0xc98)
    FIELD(PHY_OE_NIB18, DLY, 0, 3)
REG32(PHY_OE_NIB19, 0xc9c)
    FIELD(PHY_OE_NIB19, DLY, 0, 3)
REG32(PHY_OE_NIB20, 0xca0)
    FIELD(PHY_OE_NIB20, DLY, 0, 3)
REG32(PHY_OE_NIB21, 0xca4)
    FIELD(PHY_OE_NIB21, DLY, 0, 3)
REG32(PHY_OE_NIB22, 0xca8)
    FIELD(PHY_OE_NIB22, DLY, 0, 3)
REG32(PHY_OE_NIB23, 0xcac)
    FIELD(PHY_OE_NIB23, DLY, 0, 3)
REG32(PHY_OE_NIB24, 0xcb0)
    FIELD(PHY_OE_NIB24, DLY, 0, 3)
REG32(PHY_OE_NIB25, 0xcb4)
    FIELD(PHY_OE_NIB25, DLY, 0, 3)
REG32(PHY_OE_NIB26, 0xcb8)
    FIELD(PHY_OE_NIB26, DLY, 0, 3)
REG32(CAL_STATUS, 0xcbc)
    FIELD(CAL_STATUS, CAL_DONE, 1, 1)
    FIELD(CAL_STATUS, INIT_DONE, 0, 1)
REG32(SEQ_TYPE, 0xcc0)
    FIELD(SEQ_TYPE, VAL, 0, 2)
REG32(SEQ_CMD_TIMING, 0xcc4)
    FIELD(SEQ_CMD_TIMING, VAL, 0, 1)
REG32(SEQ_CMD_SLOT, 0xcc8)
    FIELD(SEQ_CMD_SLOT, VAL, 0, 1)
REG32(SEQ_CS_BITS, 0xccc)
    FIELD(SEQ_CS_BITS, VAL, 0, 4)
REG32(SEQ_CKE_BITS, 0xcd0)
    FIELD(SEQ_CKE_BITS, VAL, 0, 4)
REG32(SEQ_CNT, 0xcd4)
    FIELD(SEQ_CNT, RD_VAL, 16, 16)
    FIELD(SEQ_CNT, VAL, 0, 16)
REG32(SEQ_A_A_DLY, 0xcd8)
REG32(SEQ_A_B_DLY, 0xcdc)
REG32(SEQ_B_A_DLY, 0xce0)
REG32(SEQ_B_C_DLY, 0xce4)
REG32(SEQ_C_A_DLY, 0xce8)
REG32(SEQ_CLR, 0xcec)
    FIELD(SEQ_CLR, VAL, 0, 1)
REG32(BL8_NIBBLE0, 0xcf0)
REG32(BL8_NIBBLE1, 0xcf4)
REG32(BL8_NIBBLE2, 0xcf8)
REG32(BL8_NIBBLE3, 0xcfc)
REG32(BL8_NIBBLE4, 0xd00)
REG32(BL8_NIBBLE5, 0xd04)
REG32(BL8_NIBBLE6, 0xd08)
REG32(BL8_NIBBLE7, 0xd0c)
REG32(BL8_NIBBLE8, 0xd10)
REG32(BL8_NIBBLE9, 0xd14)
REG32(BL8_NIBBLE10, 0xd18)
REG32(BL8_NIBBLE11, 0xd1c)
REG32(BL8_NIBBLE12, 0xd20)
REG32(BL8_NIBBLE13, 0xd24)
REG32(BL8_NIBBLE14, 0xd28)
REG32(BL8_NIBBLE15, 0xd2c)
REG32(BL8_NIBBLE16, 0xd30)
REG32(BL8_NIBBLE17, 0xd34)
REG32(SEQ_EXPECTED_PAT, 0xd38)
    FIELD(SEQ_EXPECTED_PAT, BL16, 5, 5)
    FIELD(SEQ_EXPECTED_PAT, BL8, 0, 5)
REG32(SEQ_A_CMD, 0xd3c)
    FIELD(SEQ_A_CMD, WR_RD, 7, 2)
    FIELD(SEQ_A_CMD, OPCODE, 0, 7)
REG32(SEQ_A_CNTRL, 0xd40)
    FIELD(SEQ_A_CNTRL, SLOT, 9, 1)
    FIELD(SEQ_A_CNTRL, DRIVE_CKE_RESET, 8, 1)
    FIELD(SEQ_A_CNTRL, CS_EN, 4, 4)
    FIELD(SEQ_A_CNTRL, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_A_CNTRL, INVERT, 2, 1)
    FIELD(SEQ_A_CNTRL, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_A_CNTRL, OP_EXTEND, 0, 1)
REG32(SEQ_A_EARLY_CNT, 0xd44)
    FIELD(SEQ_A_EARLY_CNT, VAL, 0, 2)
REG32(SEQ_A_LATE_CNT, 0xd48)
    FIELD(SEQ_A_LATE_CNT, VAL, 0, 2)
REG32(SEQ_A_ADDR, 0xd4c)
    FIELD(SEQ_A_ADDR, VAL, 0, 24)
REG32(SEQ_A_BA, 0xd50)
    FIELD(SEQ_A_BA, VAL, 0, 2)
REG32(SEQ_A_BG, 0xd54)
    FIELD(SEQ_A_BG, VAL, 0, 2)
REG32(SEQ_A_CBIT, 0xd58)
    FIELD(SEQ_A_CBIT, VAL, 0, 2)
REG32(SEQ_A_RANK, 0xd5c)
    FIELD(SEQ_A_RANK, VAL, 0, 2)
REG32(SEQ_A_DQ_EARLY, 0xd60)
    FIELD(SEQ_A_DQ_EARLY, VAL, 0, 5)
REG32(SEQ_A_DQ_0, 0xd64)
    FIELD(SEQ_A_DQ_0, VAL, 0, 5)
REG32(SEQ_A_DQ_1, 0xd68)
    FIELD(SEQ_A_DQ_1, VAL, 0, 5)
REG32(SEQ_A_DQ_LATE, 0xd6c)
    FIELD(SEQ_A_DQ_LATE, VAL, 0, 5)
REG32(SEQ_A_DQS_EARLY, 0xd70)
    FIELD(SEQ_A_DQS_EARLY, VAL, 0, 3)
REG32(SEQ_A_DQS_0, 0xd74)
    FIELD(SEQ_A_DQS_0, VAL, 0, 3)
REG32(SEQ_A_DQS_1, 0xd78)
    FIELD(SEQ_A_DQS_1, VAL, 0, 3)
REG32(SEQ_A_DQS_LATE, 0xd7c)
    FIELD(SEQ_A_DQS_LATE, VAL, 0, 3)
REG32(SEQ_A_DM_EARLY, 0xd80)
    FIELD(SEQ_A_DM_EARLY, VAL, 0, 5)
REG32(SEQ_A_DM_0, 0xd84)
    FIELD(SEQ_A_DM_0, VAL, 0, 5)
REG32(SEQ_A_DM_1, 0xd88)
    FIELD(SEQ_A_DM_1, VAL, 0, 5)
REG32(SEQ_A_DM_LATE, 0xd8c)
    FIELD(SEQ_A_DM_LATE, VAL, 0, 5)
REG32(SEQ_B_CMD, 0xd90)
    FIELD(SEQ_B_CMD, WR_RD, 7, 2)
    FIELD(SEQ_B_CMD, OPCODE, 0, 7)
REG32(SEQ_B_CNTRL, 0xd94)
    FIELD(SEQ_B_CNTRL, SLOT, 9, 1)
    FIELD(SEQ_B_CNTRL, DRIVE_CKE_RESET, 8, 1)
    FIELD(SEQ_B_CNTRL, CS_EN, 4, 4)
    FIELD(SEQ_B_CNTRL, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_B_CNTRL, INVERT, 2, 1)
    FIELD(SEQ_B_CNTRL, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_B_CNTRL, OP_EXTEND, 0, 1)
REG32(SEQ_B_EARLY_CNT, 0xd98)
    FIELD(SEQ_B_EARLY_CNT, VAL, 0, 2)
REG32(SEQ_B_LATE_CNT, 0xd9c)
    FIELD(SEQ_B_LATE_CNT, VAL, 0, 2)
REG32(SEQ_B_ADDR, 0xda0)
    FIELD(SEQ_B_ADDR, VAL, 0, 24)
REG32(SEQ_B_BA, 0xda4)
    FIELD(SEQ_B_BA, VAL, 0, 2)
REG32(SEQ_B_BG, 0xda8)
    FIELD(SEQ_B_BG, VAL, 0, 2)
REG32(SEQ_B_CBIT, 0xdac)
    FIELD(SEQ_B_CBIT, VAL, 0, 2)
REG32(SEQ_B_RANK, 0xdb0)
    FIELD(SEQ_B_RANK, VAL, 0, 2)
REG32(SEQ_B_DQ_EARLY, 0xdb4)
    FIELD(SEQ_B_DQ_EARLY, VAL, 0, 5)
REG32(SEQ_B_DQ_0, 0xdb8)
    FIELD(SEQ_B_DQ_0, VAL, 0, 5)
REG32(SEQ_B_DQ_1, 0xdbc)
    FIELD(SEQ_B_DQ_1, VAL, 0, 5)
REG32(SEQ_B_DQ_LATE, 0xdc0)
    FIELD(SEQ_B_DQ_LATE, VAL, 0, 5)
REG32(SEQ_B_DQS_EARLY, 0xdc4)
    FIELD(SEQ_B_DQS_EARLY, VAL, 0, 3)
REG32(SEQ_B_DQS_0, 0xdc8)
    FIELD(SEQ_B_DQS_0, VAL, 0, 3)
REG32(SEQ_B_DQS_1, 0xdcc)
    FIELD(SEQ_B_DQS_1, VAL, 0, 3)
REG32(SEQ_B_DQS_LATE, 0xdd0)
    FIELD(SEQ_B_DQS_LATE, VAL, 0, 3)
REG32(SEQ_B_DM_EARLY, 0xdd4)
    FIELD(SEQ_B_DM_EARLY, VAL, 0, 5)
REG32(SEQ_B_DM_0, 0xdd8)
    FIELD(SEQ_B_DM_0, VAL, 0, 5)
REG32(SEQ_B_DM_1, 0xddc)
    FIELD(SEQ_B_DM_1, VAL, 0, 5)
REG32(SEQ_B_DM_LATE, 0xde0)
    FIELD(SEQ_B_DM_LATE, VAL, 0, 5)
REG32(SEQ_C_CMD, 0xde4)
    FIELD(SEQ_C_CMD, WR_RD, 5, 2)
    FIELD(SEQ_C_CMD, VAL, 0, 5)
REG32(SEQ_C_CNTRL, 0xde8)
    FIELD(SEQ_C_CNTRL, SLOT, 9, 1)
    FIELD(SEQ_C_CNTRL, DRIVE_CKE_RESET, 8, 1)
    FIELD(SEQ_C_CNTRL, CS_EN, 4, 4)
    FIELD(SEQ_C_CNTRL, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_C_CNTRL, INVERT, 2, 1)
    FIELD(SEQ_C_CNTRL, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_C_CNTRL, OP_EXTEND, 0, 1)
REG32(SEQ_C_EARLY_CNT, 0xdec)
    FIELD(SEQ_C_EARLY_CNT, VAL, 0, 2)
REG32(SEQ_C_LATE_CNT, 0xdf0)
    FIELD(SEQ_C_LATE_CNT, VAL, 0, 2)
REG32(SEQ_C_ADDR, 0xdf4)
    FIELD(SEQ_C_ADDR, VAL, 0, 24)
REG32(SEQ_C_BA, 0xdf8)
    FIELD(SEQ_C_BA, VAL, 0, 2)
REG32(SEQ_C_BG, 0xdfc)
    FIELD(SEQ_C_BG, VAL, 0, 2)
REG32(SEQ_C_CBIT, 0xe00)
    FIELD(SEQ_C_CBIT, VAL, 0, 2)
REG32(SEQ_C_RANK, 0xe04)
    FIELD(SEQ_C_RANK, VAL, 0, 2)
REG32(SEQ_C_DQ_EARLY, 0xe08)
    FIELD(SEQ_C_DQ_EARLY, VAL, 0, 5)
REG32(SEQ_C_DQ_0, 0xe0c)
    FIELD(SEQ_C_DQ_0, VAL, 0, 5)
REG32(SEQ_C_DQ_1, 0xe10)
    FIELD(SEQ_C_DQ_1, VAL, 0, 5)
REG32(SEQ_C_DQ_LATE, 0xe14)
    FIELD(SEQ_C_DQ_LATE, VAL, 0, 5)
REG32(SEQ_C_DQS_EARLY, 0xe18)
    FIELD(SEQ_C_DQS_EARLY, VAL, 0, 3)
REG32(SEQ_C_DQS_0, 0xe1c)
    FIELD(SEQ_C_DQS_0, VAL, 0, 3)
REG32(SEQ_C_DQS_1, 0xe20)
    FIELD(SEQ_C_DQS_1, VAL, 0, 3)
REG32(SEQ_C_DQS_LATE, 0xe24)
    FIELD(SEQ_C_DQS_LATE, VAL, 0, 3)
REG32(SEQ_C_DM_EARLY, 0xe28)
    FIELD(SEQ_C_DM_EARLY, VAL, 0, 5)
REG32(SEQ_C_DM_0, 0xe2c)
    FIELD(SEQ_C_DM_0, VAL, 0, 5)
REG32(SEQ_C_DM_1, 0xe30)
    FIELD(SEQ_C_DM_1, VAL, 0, 5)
REG32(SEQ_C_DM_LATE, 0xe34)
    FIELD(SEQ_C_DM_LATE, VAL, 0, 5)
REG32(SEQ_DATA_CAPTURE, 0xe38)
    FIELD(SEQ_DATA_CAPTURE, DELAY_CNT, 1, 6)
    FIELD(SEQ_DATA_CAPTURE, SEL, 0, 1)
REG32(SEQ_INIT_START, 0xe3c)
    FIELD(SEQ_INIT_START, VAL, 0, 1)
REG32(SEQ_INIT_STATUS, 0xe40)
    FIELD(SEQ_INIT_STATUS, BUSY, 1, 1)
    FIELD(SEQ_INIT_STATUS, DONE, 0, 1)
REG32(SEQ_SIDE_CMD0, 0xe44)
    FIELD(SEQ_SIDE_CMD0, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD0, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD0, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD1, 0xe48)
    FIELD(SEQ_SIDE_CMD1, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD1, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD1, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD2, 0xe4c)
    FIELD(SEQ_SIDE_CMD2, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD2, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD2, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD3, 0xe50)
    FIELD(SEQ_SIDE_CMD3, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD3, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD3, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD4, 0xe54)
    FIELD(SEQ_SIDE_CMD4, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD4, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD4, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD5, 0xe58)
    FIELD(SEQ_SIDE_CMD5, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD5, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD5, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD6, 0xe5c)
    FIELD(SEQ_SIDE_CMD6, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD6, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD6, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD7, 0xe60)
    FIELD(SEQ_SIDE_CMD7, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD7, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD7, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD8, 0xe64)
    FIELD(SEQ_SIDE_CMD8, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD8, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD8, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD9, 0xe68)
    FIELD(SEQ_SIDE_CMD9, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD9, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD9, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD10, 0xe6c)
    FIELD(SEQ_SIDE_CMD10, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD10, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD10, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD11, 0xe70)
    FIELD(SEQ_SIDE_CMD11, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD11, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD11, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD12, 0xe74)
    FIELD(SEQ_SIDE_CMD12, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD12, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD12, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD13, 0xe78)
    FIELD(SEQ_SIDE_CMD13, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD13, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD13, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD14, 0xe7c)
    FIELD(SEQ_SIDE_CMD14, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD14, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD14, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD15, 0xe80)
    FIELD(SEQ_SIDE_CMD15, DLY, 9, 23)
    FIELD(SEQ_SIDE_CMD15, WR_RD, 7, 2)
    FIELD(SEQ_SIDE_CMD15, OPCODE, 0, 7)
REG32(SEQ_SIDE_CMD_SET, 0xe84)
    FIELD(SEQ_SIDE_CMD_SET, SLOT, 8, 1)
    FIELD(SEQ_SIDE_CMD_SET, TIMING, 7, 1)
    FIELD(SEQ_SIDE_CMD_SET, NOP, 0, 7)
REG32(SEQ_SIDE_ADDR0, 0xe88)
    FIELD(SEQ_SIDE_ADDR0, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR0, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR0, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR0, A, 0, 24)
REG32(SEQ_SIDE_ADDR1, 0xe8c)
    FIELD(SEQ_SIDE_ADDR1, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR1, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR1, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR1, A, 0, 24)
REG32(SEQ_SIDE_ADDR2, 0xe90)
    FIELD(SEQ_SIDE_ADDR2, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR2, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR2, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR2, A, 0, 24)
REG32(SEQ_SIDE_ADDR3, 0xe94)
    FIELD(SEQ_SIDE_ADDR3, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR3, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR3, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR3, A, 0, 24)
REG32(SEQ_SIDE_ADDR4, 0xe98)
    FIELD(SEQ_SIDE_ADDR4, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR4, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR4, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR4, A, 0, 24)
REG32(SEQ_SIDE_ADDR5, 0xe9c)
    FIELD(SEQ_SIDE_ADDR5, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR5, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR5, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR5, A, 0, 24)
REG32(SEQ_SIDE_ADDR6, 0xea0)
    FIELD(SEQ_SIDE_ADDR6, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR6, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR6, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR6, A, 0, 24)
REG32(SEQ_SIDE_ADDR7, 0xea4)
    FIELD(SEQ_SIDE_ADDR7, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR7, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR7, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR7, A, 0, 24)
REG32(SEQ_SIDE_ADDR8, 0xea8)
    FIELD(SEQ_SIDE_ADDR8, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR8, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR8, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR8, A, 0, 24)
REG32(SEQ_SIDE_ADDR9, 0xeac)
    FIELD(SEQ_SIDE_ADDR9, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR9, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR9, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR9, A, 0, 24)
REG32(SEQ_SIDE_ADDR10, 0xeb0)
    FIELD(SEQ_SIDE_ADDR10, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR10, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR10, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR10, A, 0, 24)
REG32(SEQ_SIDE_ADDR11, 0xeb4)
    FIELD(SEQ_SIDE_ADDR11, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR11, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR11, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR11, A, 0, 24)
REG32(SEQ_SIDE_ADDR12, 0xeb8)
    FIELD(SEQ_SIDE_ADDR12, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR12, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR12, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR12, A, 0, 24)
REG32(SEQ_SIDE_ADDR13, 0xebc)
    FIELD(SEQ_SIDE_ADDR13, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR13, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR13, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR13, A, 0, 24)
REG32(SEQ_SIDE_ADDR14, 0xec0)
    FIELD(SEQ_SIDE_ADDR14, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR14, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR14, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR14, A, 0, 24)
REG32(SEQ_SIDE_ADDR15, 0xec4)
    FIELD(SEQ_SIDE_ADDR15, CBIT, 28, 2)
    FIELD(SEQ_SIDE_ADDR15, BG, 26, 2)
    FIELD(SEQ_SIDE_ADDR15, BA, 24, 2)
    FIELD(SEQ_SIDE_ADDR15, A, 0, 24)
REG32(SEQ_SIDE_CMD_START, 0xec8)
    FIELD(SEQ_SIDE_CMD_START, VAL, 0, 1)
REG32(SEQ_SIDE_CMD_CNT, 0xecc)
    FIELD(SEQ_SIDE_CMD_CNT, VAL, 0, 5)
REG32(SEQ_DQ_NIBBLE0, 0xed0)
REG32(SEQ_DQ_NIBBLE1, 0xed4)
REG32(SEQ_DQ_NIBBLE2, 0xed8)
REG32(SEQ_DQ_NIBBLE3, 0xedc)
REG32(SEQ_DQ_NIBBLE4, 0xee0)
REG32(SEQ_DQ_NIBBLE5, 0xee4)
REG32(SEQ_DQ_NIBBLE6, 0xee8)
REG32(SEQ_DQ_NIBBLE7, 0xeec)
REG32(SEQ_DQ_NIBBLE8, 0xef0)
REG32(SEQ_DQ_NIBBLE9, 0xef4)
REG32(SEQ_DQ_NIBBLE10, 0xef8)
REG32(SEQ_DQ_NIBBLE11, 0xefc)
REG32(SEQ_DQ_NIBBLE12, 0xf00)
REG32(SEQ_DQ_NIBBLE13, 0xf04)
REG32(SEQ_DQ_NIBBLE14, 0xf08)
REG32(SEQ_DQ_NIBBLE15, 0xf0c)
REG32(SEQ_DQ_NIBBLE16, 0xf10)
REG32(SEQ_DQ_NIBBLE17, 0xf14)
REG32(SEQ_DQ_NIBBLE18, 0xf18)
REG32(SEQ_CS_CAL, 0xf1c)
    FIELD(SEQ_CS_CAL, PATTERN, 0, 16)
REG32(SEQ_WE_CAL, 0xf20)
    FIELD(SEQ_WE_CAL, PATTERN, 0, 16)
REG32(SEQ_CAS_CAL, 0xf24)
    FIELD(SEQ_CAS_CAL, PATTERN, 0, 16)
REG32(SEQ_RAS_CAL, 0xf28)
    FIELD(SEQ_RAS_CAL, PATTERN, 0, 16)
REG32(SEQ_ACT_CAL, 0xf2c)
    FIELD(SEQ_ACT_CAL, PATTERN, 0, 16)
REG32(SEQ_CKE_CAL, 0xf30)
    FIELD(SEQ_CKE_CAL, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL0, 0xf34)
    FIELD(SEQ_ADDR_CAL0, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL1, 0xf38)
    FIELD(SEQ_ADDR_CAL1, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL2, 0xf3c)
    FIELD(SEQ_ADDR_CAL2, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL3, 0xf40)
    FIELD(SEQ_ADDR_CAL3, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL4, 0xf44)
    FIELD(SEQ_ADDR_CAL4, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL5, 0xf48)
    FIELD(SEQ_ADDR_CAL5, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL6, 0xf4c)
    FIELD(SEQ_ADDR_CAL6, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL7, 0xf50)
    FIELD(SEQ_ADDR_CAL7, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL8, 0xf54)
    FIELD(SEQ_ADDR_CAL8, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL9, 0xf58)
    FIELD(SEQ_ADDR_CAL9, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL10, 0xf5c)
    FIELD(SEQ_ADDR_CAL10, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL11, 0xf60)
    FIELD(SEQ_ADDR_CAL11, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL12, 0xf64)
    FIELD(SEQ_ADDR_CAL12, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL13, 0xf68)
    FIELD(SEQ_ADDR_CAL13, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL14, 0xf6c)
    FIELD(SEQ_ADDR_CAL14, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL15, 0xf70)
    FIELD(SEQ_ADDR_CAL15, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL16, 0xf74)
    FIELD(SEQ_ADDR_CAL16, PATTERN, 0, 16)
REG32(SEQ_ADDR_CAL17, 0xf78)
    FIELD(SEQ_ADDR_CAL17, PATTERN, 0, 16)
REG32(SEQ_BA_CAL0, 0xf7c)
    FIELD(SEQ_BA_CAL0, PATTERN, 0, 16)
REG32(SEQ_BA_CAL1, 0xf80)
    FIELD(SEQ_BA_CAL1, PATTERN, 0, 16)
REG32(SEQ_BG_CAL0, 0xf84)
    FIELD(SEQ_BG_CAL0, PATTERN, 0, 16)
REG32(SEQ_BG_CAL1, 0xf88)
    FIELD(SEQ_BG_CAL1, PATTERN, 0, 16)
REG32(SEQ_DQ_PATTERN0, 0xf8c)
REG32(SEQ_DQ_PATTERN1, 0xf90)
REG32(SEQ_DQ_PATTERN2, 0xf94)
REG32(SEQ_DQ_PATTERN3, 0xf98)
REG32(SEQ_DQ_PATTERN4, 0xf9c)
REG32(SEQ_DQ_PATTERN5, 0xfa0)
REG32(SEQ_DQ_PATTERN6, 0xfa4)
REG32(SEQ_DQ_PATTERN7, 0xfa8)
REG32(SEQ_DQ_PATTERN8, 0xfac)
REG32(SEQ_DQ_PATTERN9, 0xfb0)
REG32(SEQ_DQS_PATTERN0, 0xfb4)
    FIELD(SEQ_DQS_PATTERN0, VAL, 0, 8)
REG32(SEQ_DQS_PATTERN1, 0xfb8)
    FIELD(SEQ_DQS_PATTERN1, VAL, 0, 8)
REG32(SEQ_DM_PATTERN0, 0xfbc)
    FIELD(SEQ_DM_PATTERN0, VAL, 0, 8)
REG32(SEQ_DM_PATTERN1, 0xfc0)
    FIELD(SEQ_DM_PATTERN1, VAL, 0, 8)
REG32(SEQ_DQ_NIBBLE_SEL, 0xfc4)
    FIELD(SEQ_DQ_NIBBLE_SEL, EN, 0, 1)
REG32(COMPARE_CLEAR, 0xfc8)
    FIELD(COMPARE_CLEAR, VAL, 0, 1)
REG32(COMPARE_CONFIG, 0xfcc)
    FIELD(COMPARE_CONFIG, ERR_EN, 0, 1)
REG32(COMPARE_RISE_ERR_PER, 0xfd0)
    FIELD(COMPARE_RISE_ERR_PER, NIBBLE, 0, 18)
REG32(COMPARE_FALL_ERR_PER, 0xfd4)
    FIELD(COMPARE_FALL_ERR_PER, NIBBLE, 0, 18)
REG32(COMPARE_NIBBLE_ERR, 0xfd8)
    FIELD(COMPARE_NIBBLE_ERR, VAL, 0, 18)
REG32(COMPARE_BYTE_ERR, 0xfdc)
    FIELD(COMPARE_BYTE_ERR, VAL, 0, 9)
REG32(COMPARE_PERBIT_ERR_NIBBLE0, 0xfe0)
REG32(COMPARE_PERBIT_ERR_NIBBLE1, 0xfe4)
REG32(COMPARE_PERBIT_ERR_NIBBLE2, 0xfe8)
REG32(COMPARE_PERBIT_ERR_NIBBLE3, 0xfec)
REG32(COMPARE_PERBIT_ERR_NIBBLE4, 0xff0)
REG32(COMPARE_PERBIT_ERR_NIBBLE5, 0xff4)
REG32(COMPARE_PERBIT_ERR_NIBBLE6, 0xff8)
REG32(COMPARE_PERBIT_ERR_NIBBLE7, 0xffc)
REG32(COMPARE_PERBIT_ERR_NIBBLE8, 0x1000)
REG32(COMPARE_PERBIT_ERR_NIBBLE9, 0x1004)
REG32(COMPARE_PERBIT_ERR_NIBBLE10, 0x1008)
REG32(COMPARE_PERBIT_ERR_NIBBLE11, 0x100c)
REG32(COMPARE_PERBIT_ERR_NIBBLE12, 0x1010)
REG32(COMPARE_PERBIT_ERR_NIBBLE13, 0x1014)
REG32(COMPARE_PERBIT_ERR_NIBBLE14, 0x1018)
REG32(COMPARE_PERBIT_ERR_NIBBLE15, 0x101c)
REG32(COMPARE_PERBIT_ERR_NIBBLE16, 0x1020)
REG32(COMPARE_PERBIT_ERR_NIBBLE17, 0x1024)
REG32(COMPARE_DATA_STABLE_NIBBLE0, 0x1028)
    FIELD(COMPARE_DATA_STABLE_NIBBLE0, VAL, 0, 18)
REG32(COMPARE_DATA_STABLE_NIBBLE1, 0x102c)
    FIELD(COMPARE_DATA_STABLE_NIBBLE1, VAL, 0, 18)
REG32(COMPARE_RISE_ERR_PER_BIT0, 0x1030)
REG32(COMPARE_RISE_ERR_PER_BIT1, 0x1034)
REG32(COMPARE_RISE_ERR_PER_BIT2, 0x1038)
    FIELD(COMPARE_RISE_ERR_PER_BIT2, VAL, 0, 8)
REG32(COMPARE_FALL_ERR_PER_BIT0, 0x103c)
REG32(COMPARE_FALL_ERR_PER_BIT1, 0x1040)
REG32(COMPARE_FALL_ERR_PER_BIT2, 0x1044)
    FIELD(COMPARE_FALL_ERR_PER_BIT2, VAL, 0, 8)
REG32(COMPARE_ERR_PER_BIT0, 0x1048)
REG32(COMPARE_ERR_PER_BIT1, 0x104c)
REG32(COMPARE_ERR_PER_BIT2, 0x1050)
    FIELD(COMPARE_ERR_PER_BIT2, VAL, 0, 8)
REG32(PHY_DATA_NIB0, 0x1054)
    FIELD(PHY_DATA_NIB0, DLY, 0, 3)
REG32(PHY_DATA_NIB1, 0x1058)
    FIELD(PHY_DATA_NIB1, DLY, 0, 3)
REG32(PHY_DATA_NIB2, 0x105c)
    FIELD(PHY_DATA_NIB2, DLY, 0, 3)
REG32(PHY_DATA_NIB3, 0x1060)
    FIELD(PHY_DATA_NIB3, DLY, 0, 3)
REG32(PHY_DATA_NIB4, 0x1064)
    FIELD(PHY_DATA_NIB4, DLY, 0, 3)
REG32(PHY_DATA_NIB5, 0x1068)
    FIELD(PHY_DATA_NIB5, DLY, 0, 3)
REG32(PHY_DATA_NIB6, 0x106c)
    FIELD(PHY_DATA_NIB6, DLY, 0, 3)
REG32(PHY_DATA_NIB7, 0x1070)
    FIELD(PHY_DATA_NIB7, DLY, 0, 3)
REG32(PHY_DATA_NIB8, 0x1074)
    FIELD(PHY_DATA_NIB8, DLY, 0, 3)
REG32(PHY_DATA_NIB9, 0x1078)
    FIELD(PHY_DATA_NIB9, DLY, 0, 3)
REG32(PHY_DATA_NIB10, 0x107c)
    FIELD(PHY_DATA_NIB10, DLY, 0, 3)
REG32(PHY_DATA_NIB11, 0x1080)
    FIELD(PHY_DATA_NIB11, DLY, 0, 3)
REG32(PHY_DATA_NIB12, 0x1084)
    FIELD(PHY_DATA_NIB12, DLY, 0, 3)
REG32(PHY_DATA_NIB13, 0x1088)
    FIELD(PHY_DATA_NIB13, DLY, 0, 3)
REG32(PHY_DATA_NIB14, 0x108c)
    FIELD(PHY_DATA_NIB14, DLY, 0, 3)
REG32(PHY_DATA_NIB15, 0x1090)
    FIELD(PHY_DATA_NIB15, DLY, 0, 3)
REG32(PHY_DATA_NIB16, 0x1094)
    FIELD(PHY_DATA_NIB16, DLY, 0, 3)
REG32(PHY_DATA_NIB17, 0x1098)
    FIELD(PHY_DATA_NIB17, DLY, 0, 3)
REG32(ECCW0_FLIP_CONTROL, 0x109c)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_13, 7, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_12, 6, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_11, 5, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_10, 4, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_03, 3, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_02, 2, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_01, 1, 1)
    FIELD(ECCW0_FLIP_CONTROL, FLIP_ENABLE_00, 0, 1)
REG32(ECCW0_FLIP0, 0x10a0)
REG32(ECCW0_FLIP1, 0x10a4)
REG32(ECCW0_FLIP2, 0x10a8)
    FIELD(ECCW0_FLIP2, FLIP, 0, 8)
REG32(ECCW1_FLIP_CONTROL, 0x10ac)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_13, 7, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_12, 6, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_11, 5, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_10, 4, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_03, 3, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_02, 2, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_01, 1, 1)
    FIELD(ECCW1_FLIP_CONTROL, FLIP_ENABLE_00, 0, 1)
REG32(ECCW1_FLIP0, 0x10b0)
REG32(ECCW1_FLIP1, 0x10b4)
REG32(ECCW1_FLIP2, 0x10b8)
    FIELD(ECCW1_FLIP2, FLIP, 0, 8)
REG32(ECCR0_CORR_ERR_STATUS, 0x10bc)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR13, 7, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR12, 6, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR11, 5, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR10, 4, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR03, 3, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR02, 2, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR01, 1, 1)
    FIELD(ECCR0_CORR_ERR_STATUS, CORR00, 0, 1)
REG32(ECCR0_CORR_ERR_ADD_LO, 0x10c0)
REG32(ECCR0_CORR_ERR_ADD_HI, 0x10c4)
    FIELD(ECCR0_CORR_ERR_ADD_HI, ECC_ERR_ADD_HI, 0, 8)
REG32(ECCR0_CORR_ERR_DATA_LO, 0x10c8)
REG32(ECCR0_CORR_ERR_DATA_HI, 0x10cc)
REG32(ECCR0_CORR_ERR_DATA_PAR, 0x10d0)
    FIELD(ECCR0_CORR_ERR_DATA_PAR, ECC_ERR_DATA_PAR, 0, 8)
REG32(ECCR0_UNCORR_ERR_STATUS, 0x10d4)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR13, 7, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR12, 6, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR11, 5, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR10, 4, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR03, 3, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR02, 2, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR01, 1, 1)
    FIELD(ECCR0_UNCORR_ERR_STATUS, UNCORR00, 0, 1)
REG32(ECCR0_UNCORR_ERR_ADD_LO, 0x10d8)
REG32(ECCR0_UNCORR_ERR_ADD_HI, 0x10dc)
    FIELD(ECCR0_UNCORR_ERR_ADD_HI, ECC_ERR_ADD_HI, 0, 8)
REG32(ECCR0_UNCORR_ERR_DATA_LO, 0x10e0)
REG32(ECCR0_UNCORR_ERR_DATA_HI, 0x10e4)
REG32(ECCR0_UNCORR_ERR_DATA_PAR, 0x10e8)
    FIELD(ECCR0_UNCORR_ERR_DATA_PAR, ECC_ERR_DATA_PAR, 0, 8)
REG32(ECCR0_PARITY_FLIP_2NA, 0x10ec)
REG32(ECCR0_PARITY_FLIP_2ECCR, 0x10f0)
REG32(ECCR1_CORR_ERR_STATUS, 0x10f4)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR13, 7, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR12, 6, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR11, 5, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR10, 4, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR03, 3, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR02, 2, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR01, 1, 1)
    FIELD(ECCR1_CORR_ERR_STATUS, CORR00, 0, 1)
REG32(ECCR1_CORR_ERR_ADD_LO, 0x10f8)
REG32(ECCR1_CORR_ERR_ADD_HI, 0x10fc)
    FIELD(ECCR1_CORR_ERR_ADD_HI, ECC_ERR_ADD_HI, 0, 8)
REG32(ECCR1_CORR_ERR_DATA_LO, 0x1100)
REG32(ECCR1_CORR_ERR_DATA_HI, 0x1104)
REG32(ECCR1_CORR_ERR_DATA_PAR, 0x1108)
    FIELD(ECCR1_CORR_ERR_DATA_PAR, ECC_ERR_DATA_PAR, 0, 8)
REG32(ECCR1_UNCORR_ERR_STATUS, 0x110c)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR13, 7, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR12, 6, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR11, 5, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR10, 4, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR03, 3, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR02, 2, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR01, 1, 1)
    FIELD(ECCR1_UNCORR_ERR_STATUS, UNCORR00, 0, 1)
REG32(ECCR1_UNCORR_ERR_ADD_LO, 0x1110)
REG32(ECCR1_UNCORR_ERR_ADD_HI, 0x1114)
    FIELD(ECCR1_UNCORR_ERR_ADD_HI, ECC_ERR_ADD_HI, 0, 8)
REG32(ECCR1_UNCORR_ERR_DATA_LO, 0x1118)
REG32(ECCR1_UNCORR_ERR_DATA_HI, 0x111c)
REG32(ECCR1_UNCORR_ERR_DATA_PAR, 0x1120)
    FIELD(ECCR1_UNCORR_ERR_DATA_PAR, ECC_ERR_DATA_PAR, 0, 8)
REG32(ECCR1_PARITY_FLIP_2NA, 0x1124)
REG32(ECCR1_PARITY_FLIP_2ECCR, 0x1128)
REG32(CPLX_STATUS, 0x112c)
    FIELD(CPLX_STATUS, ISSUE_RESET, 2, 1)
    FIELD(CPLX_STATUS, DONE, 1, 1)
    FIELD(CPLX_STATUS, BUSY, 0, 1)
REG32(PRBS_STATUS, 0x1130)
    FIELD(PRBS_STATUS, ERROR, 2, 1)
    FIELD(PRBS_STATUS, DONE, 1, 1)
    FIELD(PRBS_STATUS, BUSY, 0, 1)
REG32(PRBS_START, 0x1134)
    FIELD(PRBS_START, FLAG, 0, 1)
REG32(XPI_LP4_CA_CAL_MODE, 0x1138)
    FIELD(XPI_LP4_CA_CAL_MODE, EN, 0, 1)
REG32(XPI_LP4_WRITE_NIB_MASK, 0x113c)
    FIELD(XPI_LP4_WRITE_NIB_MASK, SEL, 0, 27)
REG32(XPI_LP4_READ_NIB_MASK, 0x1140)
    FIELD(XPI_LP4_READ_NIB_MASK, SEL, 0, 27)
REG32(XPI_MAP_BITSLIP, 0x1144)
    FIELD(XPI_MAP_BITSLIP, CS_EN_CH1, 8, 6)
    FIELD(XPI_MAP_BITSLIP, CS_EN_CH0, 2, 6)
    FIELD(XPI_MAP_BITSLIP, ADDR_EN_CH1, 1, 1)
    FIELD(XPI_MAP_BITSLIP, ADDR_EN_CH0, 0, 1)
REG32(SEQ_SIDE_CNTRL0, 0x1148)
    FIELD(SEQ_SIDE_CNTRL0, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL0, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL0, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL0, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL0, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL1, 0x114c)
    FIELD(SEQ_SIDE_CNTRL1, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL1, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL1, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL1, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL1, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL2, 0x1150)
    FIELD(SEQ_SIDE_CNTRL2, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL2, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL2, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL2, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL2, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL3, 0x1154)
    FIELD(SEQ_SIDE_CNTRL3, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL3, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL3, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL3, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL3, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL4, 0x1158)
    FIELD(SEQ_SIDE_CNTRL4, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL4, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL4, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL4, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL4, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL5, 0x115c)
    FIELD(SEQ_SIDE_CNTRL5, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL5, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL5, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL5, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL5, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL6, 0x1160)
    FIELD(SEQ_SIDE_CNTRL6, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL6, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL6, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL6, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL6, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL7, 0x1164)
    FIELD(SEQ_SIDE_CNTRL7, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL7, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL7, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL7, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL7, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL8, 0x1168)
    FIELD(SEQ_SIDE_CNTRL8, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL8, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL8, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL8, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL8, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL9, 0x116c)
    FIELD(SEQ_SIDE_CNTRL9, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL9, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL9, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL9, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL9, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL10, 0x1170)
    FIELD(SEQ_SIDE_CNTRL10, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL10, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL10, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL10, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL10, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL11, 0x1174)
    FIELD(SEQ_SIDE_CNTRL11, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL11, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL11, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL11, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL11, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL12, 0x1178)
    FIELD(SEQ_SIDE_CNTRL12, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL12, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL12, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL12, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL12, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL13, 0x117c)
    FIELD(SEQ_SIDE_CNTRL13, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL13, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL13, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL13, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL13, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL14, 0x1180)
    FIELD(SEQ_SIDE_CNTRL14, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL14, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL14, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL14, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL14, OP_EXTEND, 0, 1)
REG32(SEQ_SIDE_CNTRL15, 0x1184)
    FIELD(SEQ_SIDE_CNTRL15, CS_EN, 4, 4)
    FIELD(SEQ_SIDE_CNTRL15, EXTENDED_WRITE, 3, 1)
    FIELD(SEQ_SIDE_CNTRL15, INVERT, 2, 1)
    FIELD(SEQ_SIDE_CNTRL15, MIRROR_OUTPUT, 1, 1)
    FIELD(SEQ_SIDE_CNTRL15, OP_EXTEND, 0, 1)
REG32(SEQ_STATUS, 0x1188)
    FIELD(SEQ_STATUS, BUSY, 1, 1)
    FIELD(SEQ_STATUS, DONE, 0, 1)
REG32(PAR_ERR_INJ_ECCR, 0x118c)
    FIELD(PAR_ERR_INJ_ECCR, PERSISTENT1, 9, 1)
    FIELD(PAR_ERR_INJ_ECCR, DONE1, 8, 1)
    FIELD(PAR_ERR_INJ_ECCR, EN1, 7, 1)
    FIELD(PAR_ERR_INJ_ECCR, SEL1, 5, 2)
    FIELD(PAR_ERR_INJ_ECCR, PERSISTENT0, 4, 1)
    FIELD(PAR_ERR_INJ_ECCR, DONE0, 3, 1)
    FIELD(PAR_ERR_INJ_ECCR, EN0, 2, 1)
    FIELD(PAR_ERR_INJ_ECCR, SEL0, 0, 2)
REG32(PAR_ERR_INJ_DBUF, 0x1190)
    FIELD(PAR_ERR_INJ_DBUF, RAW_PERSISTENT1, 31, 1)
    FIELD(PAR_ERR_INJ_DBUF, RAW_DONE1, 30, 1)
    FIELD(PAR_ERR_INJ_DBUF, RAW_EN1, 29, 1)
    FIELD(PAR_ERR_INJ_DBUF, RAW_1, 24, 5)
    FIELD(PAR_ERR_INJ_DBUF, PHY_PERSISTENT1, 23, 1)
    FIELD(PAR_ERR_INJ_DBUF, PHY_DONE1, 22, 1)
    FIELD(PAR_ERR_INJ_DBUF, PHY_EN1, 21, 1)
    FIELD(PAR_ERR_INJ_DBUF, PHY_1, 16, 5)
    FIELD(PAR_ERR_INJ_DBUF, RAW_PERSISTENT0, 15, 1)
    FIELD(PAR_ERR_INJ_DBUF, RAW_DONE0, 14, 1)
    FIELD(PAR_ERR_INJ_DBUF, RAW_EN0, 13, 1)
    FIELD(PAR_ERR_INJ_DBUF, RAW_0, 8, 5)
    FIELD(PAR_ERR_INJ_DBUF, PHY_PERSISTENT0, 7, 1)
    FIELD(PAR_ERR_INJ_DBUF, PHY_DONE0, 6, 1)
    FIELD(PAR_ERR_INJ_DBUF, PHY_EN0, 5, 1)
    FIELD(PAR_ERR_INJ_DBUF, PHY_0, 0, 5)
REG32(MRS_CH0_NIBBLE0, 0x1194)
REG32(MRS_CH0_NIBBLE1, 0x1198)
REG32(MRS_CH0_NIBBLE2, 0x119c)
REG32(MRS_CH0_NIBBLE3, 0x11a0)
REG32(MRS_CH0_NIBBLE4, 0x11a4)
REG32(MRS_CH0_NIBBLE5, 0x11a8)
REG32(MRS_CH0_NIBBLE6, 0x11ac)
REG32(MRS_CH0_NIBBLE7, 0x11b0)
REG32(MRS_CH0_NIBBLE8, 0x11b4)
REG32(MRS_CH0_NIBBLE9, 0x11b8)
REG32(MRS_CH0_NIBBLE10, 0x11bc)
REG32(MRS_CH0_NIBBLE11, 0x11c0)
REG32(MRS_CH0_NIBBLE12, 0x11c4)
REG32(MRS_CH0_NIBBLE13, 0x11c8)
REG32(MRS_CH0_NIBBLE14, 0x11cc)
REG32(MRS_CH0_NIBBLE15, 0x11d0)
REG32(MRS_CH0_NIBBLE16, 0x11d4)
REG32(MRS_CH0_NIBBLE17, 0x11d8)
REG32(MRS_CH1_NIBBLE0, 0x11dc)
REG32(MRS_CH1_NIBBLE1, 0x11e0)
REG32(MRS_CH1_NIBBLE2, 0x11e4)
REG32(MRS_CH1_NIBBLE3, 0x11e8)
REG32(MRS_CH1_NIBBLE4, 0x11ec)
REG32(MRS_CH1_NIBBLE5, 0x11f0)
REG32(MRS_CH1_NIBBLE6, 0x11f4)
REG32(MRS_CH1_NIBBLE7, 0x11f8)
REG32(MRS_CH1_NIBBLE8, 0x11fc)
REG32(MRS_CH1_NIBBLE9, 0x1200)
REG32(MRS_CH1_NIBBLE10, 0x1204)
REG32(MRS_CH1_NIBBLE11, 0x1208)
REG32(MRS_CH1_NIBBLE12, 0x120c)
REG32(MRS_CH1_NIBBLE13, 0x1210)
REG32(MRS_CH1_NIBBLE14, 0x1214)
REG32(MRS_CH1_NIBBLE15, 0x1218)
REG32(MRS_CH1_NIBBLE16, 0x121c)
REG32(MRS_CH1_NIBBLE17, 0x1220)
REG32(GT_STATUS, 0x1224)
    FIELD(GT_STATUS, CAPTURE, 0, 27)
REG32(ADD_PAR_ERR_INJ, 0x1228)
    FIELD(ADD_PAR_ERR_INJ, DRAM_RANK1, 20, 2)
    FIELD(ADD_PAR_ERR_INJ, DRAM_CMD1, 17, 3)
    FIELD(ADD_PAR_ERR_INJ, CMD_DONE1, 16, 1)
    FIELD(ADD_PAR_ERR_INJ, CMD_EN1, 15, 1)
    FIELD(ADD_PAR_ERR_INJ, CMD_TYPE1, 13, 2)
    FIELD(ADD_PAR_ERR_INJ, CMD_SLOT1, 12, 1)
    FIELD(ADD_PAR_ERR_INJ, CMD_PERSISTENT1, 11, 1)
    FIELD(ADD_PAR_ERR_INJ, DRAM_RANK0, 9, 2)
    FIELD(ADD_PAR_ERR_INJ, DRAM_CMD0, 6, 3)
    FIELD(ADD_PAR_ERR_INJ, CMD_DONE0, 5, 1)
    FIELD(ADD_PAR_ERR_INJ, CMD_EN0, 4, 1)
    FIELD(ADD_PAR_ERR_INJ, CMD_TYPE0, 2, 2)
    FIELD(ADD_PAR_ERR_INJ, CMD_SLOT0, 1, 1)
    FIELD(ADD_PAR_ERR_INJ, CMD_PERSISTENT0, 0, 1)
REG32(ILA_CONFIG, 0x122c)
    FIELD(ILA_CONFIG, HOLD, 14, 3)
    FIELD(ILA_CONFIG, TRIG_COND, 11, 3)
    FIELD(ILA_CONFIG, WINDOW_MASK, 3, 8)
    FIELD(ILA_CONFIG, TRIG_POS, 0, 3)
REG32(ILA_STATUS, 0x1230)
    FIELD(ILA_STATUS, STATE, 18, 3)
    FIELD(ILA_STATUS, SAMPLE_CNT, 10, 8)
    FIELD(ILA_STATUS, TRIG_SAMPLE, 2, 8)
    FIELD(ILA_STATUS, MATCH, 1, 1)
    FIELD(ILA_STATUS, DONE, 0, 1)
REG32(ILA_CAPTURE_DATA, 0x1234)
    FIELD(ILA_CAPTURE_DATA, SEL_FIFO_EMPTY, 14, 3)
    FIELD(ILA_CAPTURE_DATA, PHY_NIB_SEL, 9, 5)
    FIELD(ILA_CAPTURE_DATA, CHANNEL_SEL, 8, 1)
    FIELD(ILA_CAPTURE_DATA, BYTE_SEL, 4, 4)
    FIELD(ILA_CAPTURE_DATA, SEL, 0, 4)
REG32(ILA_CNTRL, 0x1238)
    FIELD(ILA_CNTRL, CLK_SEL, 2, 1)
    FIELD(ILA_CNTRL, ARM, 1, 1)
    FIELD(ILA_CNTRL, EN, 0, 1)
REG32(ILA_TRIGGER0, 0x123c)
REG32(ILA_TRIGGER1, 0x1240)
REG32(ILA_TRIGGER2, 0x1244)
REG32(ILA_TRIGGER3, 0x1248)
REG32(ILA_TRIGGER4, 0x124c)
REG32(ILA_TRIGGER5, 0x1250)
REG32(ILA_TRIGGER6, 0x1254)
REG32(ILA_TRIGGER7, 0x1258)
REG32(ILA_TRIGGER8, 0x125c)
REG32(ILA_TRIGGER9, 0x1260)
REG32(ILA_TRIGGER10, 0x1264)
REG32(ILA_TRIGGER11, 0x1268)
REG32(ILA_TRIGGER12, 0x126c)
REG32(ILA_TRIGGER13, 0x1270)
REG32(ILA_TRIGGER14, 0x1274)
REG32(ILA_TRIGGER15, 0x1278)
REG32(ILA_TRIGGER16, 0x127c)
REG32(ILA_TRIGGER17, 0x1280)
REG32(ILA_TRIGGER18, 0x1284)
REG32(ILA_TRIGGER19, 0x1288)
REG32(ILA_TRIGGER20, 0x128c)
REG32(ILA_TRIGGER21, 0x1290)
REG32(ILA_TRIGGER22, 0x1294)
REG32(ILA_TRIGGER23, 0x1298)
REG32(ILA_TRIGGER24, 0x129c)
REG32(ILA_TRIGGER25, 0x12a0)
REG32(ILA_TRIGGER26, 0x12a4)
REG32(ILA_TRIGGER27, 0x12a8)
REG32(ILA_TRIGGER28, 0x12ac)
REG32(ILA_TRIGGER29, 0x12b0)
REG32(ILA_TRIGGER30, 0x12b4)
REG32(ILA_TRIGGER31, 0x12b8)
REG32(ILA_TRIGGER32, 0x12bc)
REG32(ILA_TRIGGER33, 0x12c0)
REG32(ILA_TRIGGER34, 0x12c4)
REG32(ILA_TRIGGER35, 0x12c8)
REG32(ILA_TRIGGER36, 0x12cc)
    FIELD(ILA_TRIGGER36, MU, 0, 9)
REG32(ILA_READ_CNTRL, 0x12d0)
    FIELD(ILA_READ_CNTRL, ADDR, 0, 8)
REG32(ILA_READ0, 0x12d4)
REG32(ILA_READ1, 0x12d8)
REG32(ILA_READ2, 0x12dc)
REG32(ILA_READ3, 0x12e0)
REG32(ILA_CROSS_TRIG, 0x12e4)
    FIELD(ILA_CROSS_TRIG, SEL, 0, 1)
REG32(SEQ_START, 0x12e8)
    FIELD(SEQ_START, VAL, 0, 1)
REG32(SEQ_STATUS_CNT, 0x12ec)
    FIELD(SEQ_STATUS_CNT, RD_VAL, 16, 16)
    FIELD(SEQ_STATUS_CNT, VAL, 0, 16)
REG32(WRITE_DATA_BITSLIP, 0x12f0)
    FIELD(WRITE_DATA_BITSLIP, EN, 0, 18)
REG32(FIRST_ERROR_CAPTURE, 0x12f4)
    FIELD(FIRST_ERROR_CAPTURE, FORCE_EN, 19, 1)
    FIELD(FIRST_ERROR_CAPTURE, BUSY, 18, 1)
    FIELD(FIRST_ERROR_CAPTURE, NIBBLE_VALID, 0, 18)
REG32(BL16_CAPTURE, 0x12f8)
    FIELD(BL16_CAPTURE, EN, 0, 1)
REG32(BL16_NIBBLE0, 0x12fc)
REG32(BL16_NIBBLE1, 0x1300)
REG32(BL16_NIBBLE2, 0x1304)
REG32(BL16_NIBBLE3, 0x1308)
REG32(BL16_NIBBLE4, 0x130c)
REG32(BL16_NIBBLE5, 0x1310)
REG32(BL16_NIBBLE6, 0x1314)
REG32(BL16_NIBBLE7, 0x1318)
REG32(BL16_NIBBLE8, 0x131c)
REG32(BL16_NIBBLE9, 0x1320)
REG32(BL16_NIBBLE10, 0x1324)
REG32(BL16_NIBBLE11, 0x1328)
REG32(BL16_NIBBLE12, 0x132c)
REG32(BL16_NIBBLE13, 0x1330)
REG32(BL16_NIBBLE14, 0x1334)
REG32(BL16_NIBBLE15, 0x1338)
REG32(BL16_NIBBLE16, 0x133c)
REG32(BL16_NIBBLE17, 0x1340)
REG32(ERROR_CNT_NIBBLE0, 0x1344)
    FIELD(ERROR_CNT_NIBBLE0, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE1, 0x1348)
    FIELD(ERROR_CNT_NIBBLE1, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE2, 0x134c)
    FIELD(ERROR_CNT_NIBBLE2, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE3, 0x1350)
    FIELD(ERROR_CNT_NIBBLE3, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE4, 0x1354)
    FIELD(ERROR_CNT_NIBBLE4, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE5, 0x1358)
    FIELD(ERROR_CNT_NIBBLE5, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE6, 0x135c)
    FIELD(ERROR_CNT_NIBBLE6, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE7, 0x1360)
    FIELD(ERROR_CNT_NIBBLE7, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE8, 0x1364)
    FIELD(ERROR_CNT_NIBBLE8, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE9, 0x1368)
    FIELD(ERROR_CNT_NIBBLE9, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE10, 0x136c)
    FIELD(ERROR_CNT_NIBBLE10, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE11, 0x1370)
    FIELD(ERROR_CNT_NIBBLE11, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE12, 0x1374)
    FIELD(ERROR_CNT_NIBBLE12, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE13, 0x1378)
    FIELD(ERROR_CNT_NIBBLE13, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE14, 0x137c)
    FIELD(ERROR_CNT_NIBBLE14, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE15, 0x1380)
    FIELD(ERROR_CNT_NIBBLE15, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE16, 0x1384)
    FIELD(ERROR_CNT_NIBBLE16, VAL, 0, 16)
REG32(ERROR_CNT_NIBBLE17, 0x1388)
    FIELD(ERROR_CNT_NIBBLE17, VAL, 0, 16)
REG32(DC_PAR_ERR_EN, 0x138c)
    FIELD(DC_PAR_ERR_EN, FARB_ADDR_PAR_LOG_EN1, 23, 1)
    FIELD(DC_PAR_ERR_EN, FARB_ADDR_PAR_CHK_EN1, 21, 1)
    FIELD(DC_PAR_ERR_EN, FARB_ADDR_PAR_LOG_EN0, 19, 1)
    FIELD(DC_PAR_ERR_EN, FARB_ADDR_PAR_CHK_EN0, 17, 1)
    FIELD(DC_PAR_ERR_EN, ECCR2DBUF_PAR_LOG_EN1, 15, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCR_PAR_LOG_EN1, 14, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCW_PAR_LOG_EN1, 13, 1)
    FIELD(DC_PAR_ERR_EN, WBUF2DBUF_PAR_LOG_EN1, 12, 1)
    FIELD(DC_PAR_ERR_EN, ECCR2DBUF_PAR_CHK_EN1, 11, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCR_PAR_CHK_EN1, 10, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCW_PAR_CHK_EN1, 9, 1)
    FIELD(DC_PAR_ERR_EN, WBUF2DBUF_PAR_CHK_EN1, 8, 1)
    FIELD(DC_PAR_ERR_EN, ECCR2DBUF_PAR_LOG_EN0, 7, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCR_PAR_LOG_EN0, 6, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCW_PAR_LOG_EN0, 5, 1)
    FIELD(DC_PAR_ERR_EN, WBUF2DBUF_PAR_LOG_EN0, 4, 1)
    FIELD(DC_PAR_ERR_EN, ECCR2DBUF_PAR_CHK_EN0, 3, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCR_PAR_CHK_EN0, 2, 1)
    FIELD(DC_PAR_ERR_EN, DBUF2ECCW_PAR_CHK_EN0, 1, 1)
    FIELD(DC_PAR_ERR_EN, WBUF2DBUF_PAR_CHK_EN0, 0, 1)
REG32(DC_ADD_PAR_ERR_LOG0_0, 0x1390)
REG32(DC_ADD_PAR_ERR_LOG1_0, 0x1394)
REG32(DC_ADD_PAR_ERR_LOG0_1, 0x1398)
REG32(DC_ADD_PAR_ERR_LOG1_1, 0x139c)
REG32(DC_DBUF_DATA_PAR_ERR_LOG0_0, 0x13a0)
REG32(DC_DBUF_DATA_PAR_ERR_LOG1_0, 0x13a4)
REG32(DC_DBUF_DATA_PAR_ERR_LOG0_1, 0x13a8)
REG32(DC_DBUF_DATA_PAR_ERR_LOG1_1, 0x13ac)
REG32(DC_ECCW_DATA_PAR_ERR_LOG0_0, 0x13b0)
REG32(DC_ECCW_DATA_PAR_ERR_LOG0_1, 0x13b4)
REG32(DC_ECCR_DATA_PAR_ERR_LOG0_0, 0x13b8)
REG32(DC_ECCR_DATA_PAR_ERR_LOG0_1, 0x13bc)
REG32(DC0_PERF_MON, 0x13c0)
    FIELD(DC0_PERF_MON, SNGL, 17, 1)
    FIELD(DC0_PERF_MON, NUM_RO_OF, 16, 1)
    FIELD(DC0_PERF_MON, NUM_RO, 6, 10)
    FIELD(DC0_PERF_MON, ACCUM_PERIOD, 1, 5)
    FIELD(DC0_PERF_MON, ENABLE, 0, 1)
REG32(DC0_PERF_MON_0, 0x13c4)
    FIELD(DC0_PERF_MON_0, ACT_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_0, ACT_COUNT, 0, 31)
REG32(DC0_PERF_MON_1, 0x13c8)
    FIELD(DC0_PERF_MON_1, RD_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_1, RD_COUNT, 0, 31)
REG32(DC0_PERF_MON_2, 0x13cc)
    FIELD(DC0_PERF_MON_2, WR_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_2, WR_COUNT, 0, 31)
REG32(DC0_PERF_MON_3, 0x13d0)
    FIELD(DC0_PERF_MON_3, PRE_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_3, PRE_COUNT, 0, 31)
REG32(DC0_PERF_MON_4, 0x13d4)
    FIELD(DC0_PERF_MON_4, PREA_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_4, PREA_COUNT, 0, 31)
REG32(DC0_PERF_MON_5, 0x13d8)
    FIELD(DC0_PERF_MON_5, REF_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_5, REF_COUNT, 0, 31)
REG32(DC0_PERF_MON_6, 0x13dc)
    FIELD(DC0_PERF_MON_6, QE_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_6, QE_COUNT, 0, 31)
REG32(DC0_PERF_MON_7, 0x13e0)
    FIELD(DC0_PERF_MON_7, OH_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_7, OH_COUNT, 0, 31)
REG32(DC0_PERF_MON_8, 0x13e4)
    FIELD(DC0_PERF_MON_8, TA_COUNT_OF, 31, 1)
    FIELD(DC0_PERF_MON_8, TA_COUNT, 0, 31)
REG32(DC1_PERF_MON, 0x13e8)
    FIELD(DC1_PERF_MON, SNGL, 17, 1)
    FIELD(DC1_PERF_MON, NUM_RO_OF, 16, 1)
    FIELD(DC1_PERF_MON, NUM_RO, 6, 10)
    FIELD(DC1_PERF_MON, ACCUM_PERIOD, 1, 5)
    FIELD(DC1_PERF_MON, ENABLE, 0, 1)
REG32(DC1_PERF_MON_0, 0x13ec)
    FIELD(DC1_PERF_MON_0, ACT_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_0, ACT_COUNT, 0, 31)
REG32(DC1_PERF_MON_1, 0x13f0)
    FIELD(DC1_PERF_MON_1, RD_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_1, RD_COUNT, 0, 31)
REG32(DC1_PERF_MON_2, 0x13f4)
    FIELD(DC1_PERF_MON_2, WR_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_2, WR_COUNT, 0, 31)
REG32(DC1_PERF_MON_3, 0x13f8)
    FIELD(DC1_PERF_MON_3, PRE_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_3, PRE_COUNT, 0, 31)
REG32(DC1_PERF_MON_4, 0x13fc)
    FIELD(DC1_PERF_MON_4, PREA_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_4, PREA_COUNT, 0, 31)
REG32(DC1_PERF_MON_5, 0x1400)
    FIELD(DC1_PERF_MON_5, REF_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_5, REF_COUNT, 0, 31)
REG32(DC1_PERF_MON_6, 0x1404)
    FIELD(DC1_PERF_MON_6, QE_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_6, QE_COUNT, 0, 31)
REG32(DC1_PERF_MON_7, 0x1408)
    FIELD(DC1_PERF_MON_7, OH_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_7, OH_COUNT, 0, 31)
REG32(DC1_PERF_MON_8, 0x140c)
    FIELD(DC1_PERF_MON_8, TA_COUNT_OF, 31, 1)
    FIELD(DC1_PERF_MON_8, TA_COUNT, 0, 31)
REG32(COMPARE_GT_STATUS0_STABLE, 0x1410)
    FIELD(COMPARE_GT_STATUS0_STABLE, VAL, 0, 26)
REG32(COMPARE_GT_STATUS1_STABLE, 0x1414)
    FIELD(COMPARE_GT_STATUS1_STABLE, VAL, 0, 26)
REG32(FIRST_ERROR_CAPTURE_ADDR, 0x1418)
    FIELD(FIRST_ERROR_CAPTURE_ADDR, CNT, 24, 8)
    FIELD(FIRST_ERROR_CAPTURE_ADDR, RANK, 22, 2)
    FIELD(FIRST_ERROR_CAPTURE_ADDR, BG, 20, 2)
    FIELD(FIRST_ERROR_CAPTURE_ADDR, BA, 18, 2)
    FIELD(FIRST_ERROR_CAPTURE_ADDR, A, 0, 18)
REG32(ILA_MUX_D_0_0, 0x141c)
REG32(ILA_MUX_D_0_1, 0x1420)
REG32(ILA_MUX_D_0_2, 0x1424)
REG32(ILA_MUX_D_0_3, 0x1428)
REG32(ILA_MUX_D_0_4, 0x142c)
REG32(ILA_MUX_D_0_5, 0x1430)
REG32(ILA_MUX_D_0_6, 0x1434)
REG32(ILA_MUX_D_0_7, 0x1438)
REG32(ILA_MUX_D_0_8, 0x143c)
REG32(ILA_MUX_D_0_9, 0x1440)
REG32(ILA_MUX_D_0_10, 0x1444)
REG32(ILA_MUX_D_0_11, 0x1448)
REG32(ILA_MUX_D_0_12, 0x144c)
REG32(ILA_MUX_D_0_13, 0x1450)
REG32(ILA_MUX_D_0_14, 0x1454)
REG32(ILA_MUX_D_0_15, 0x1458)
REG32(ILA_MUX_D_0_16, 0x145c)
REG32(ILA_MUX_D_0_17, 0x1460)
REG32(ILA_MUX_D_1_0, 0x1464)
REG32(ILA_MUX_D_1_1, 0x1468)
REG32(ILA_MUX_D_1_2, 0x146c)
REG32(ILA_MUX_D_1_3, 0x1470)
REG32(ILA_MUX_D_1_4, 0x1474)
REG32(ILA_MUX_D_1_5, 0x1478)
REG32(ILA_MUX_D_1_6, 0x147c)
REG32(ILA_MUX_D_1_7, 0x1480)
REG32(ILA_MUX_D_1_8, 0x1484)
REG32(ILA_MUX_D_1_9, 0x1488)
REG32(ILA_MUX_D_1_10, 0x148c)
REG32(ILA_MUX_D_1_11, 0x1490)
REG32(ILA_MUX_D_1_12, 0x1494)
REG32(ILA_MUX_D_1_13, 0x1498)
REG32(ILA_MUX_D_1_14, 0x149c)
REG32(ILA_MUX_D_1_15, 0x14a0)
REG32(ILA_MUX_D_1_16, 0x14a4)
REG32(ILA_MUX_MISC, 0x14a8)
    FIELD(ILA_MUX_MISC, ECCR_DBG_DATA_SEL1, 1, 1)
    FIELD(ILA_MUX_MISC, ECCR_DBG_DATA_SEL0, 0, 1)
REG32(NOCDBG, 0x14ac)
    FIELD(NOCDBG, DATA_DWORD_SEL, 4, 2)
    FIELD(NOCDBG, CAPTURE_DATA_SEL, 1, 3)
    FIELD(NOCDBG, CLK_SEL, 0, 1)
REG32(DDRMC_CLK_CNT, 0x14b0)
    FIELD(DDRMC_CLK_CNT, START_PULSE, 31, 1)
    FIELD(DDRMC_CLK_CNT, START_CNT, 0, 31)
REG32(DDRMC_CLK_CNT_STATUS, 0x14b4)
    FIELD(DDRMC_CLK_CNT_STATUS, BUSY, 31, 1)
    FIELD(DDRMC_CLK_CNT_STATUS, CURRENT_CNT, 0, 31)
REG32(PHY_RANK_WRITE_OVERRIDE_DYN, 0x14b8)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, WRITE_CNT, 14, 5)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, CH1_RANK_UPDATE, 10, 4)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, CH0_RANK_UPDATE, 6, 4)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, PAUSE_WRITES, 4, 2)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, CH1_UPDATE_PULSE, 3, 1)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, CH0_UPDATE_PULSE, 2, 1)
    FIELD(PHY_RANK_WRITE_OVERRIDE_DYN, ENABLE, 0, 2)
REG32(OSCI_READ_MR18_CH0_RANK0_0, 0x14bc)
REG32(OSCI_READ_MR18_CH0_RANK0_1, 0x14c0)
REG32(OSCI_READ_MR18_CH0_RANK0_2, 0x14c4)
    FIELD(OSCI_READ_MR18_CH0_RANK0_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR18_CH0_RANK1_0, 0x14c8)
REG32(OSCI_READ_MR18_CH0_RANK1_1, 0x14cc)
REG32(OSCI_READ_MR18_CH0_RANK1_2, 0x14d0)
    FIELD(OSCI_READ_MR18_CH0_RANK1_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR18_CH1_RANK0_0, 0x14d4)
REG32(OSCI_READ_MR18_CH1_RANK0_1, 0x14d8)
REG32(OSCI_READ_MR18_CH1_RANK0_2, 0x14dc)
    FIELD(OSCI_READ_MR18_CH1_RANK0_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR18_CH1_RANK1_0, 0x14e0)
REG32(OSCI_READ_MR18_CH1_RANK1_1, 0x14e4)
REG32(OSCI_READ_MR18_CH1_RANK1_2, 0x14e8)
    FIELD(OSCI_READ_MR18_CH1_RANK1_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR19_CH0_RANK0_0, 0x14ec)
REG32(OSCI_READ_MR19_CH0_RANK0_1, 0x14f0)
REG32(OSCI_READ_MR19_CH0_RANK0_2, 0x14f4)
    FIELD(OSCI_READ_MR19_CH0_RANK0_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR19_CH0_RANK1_0, 0x14f8)
REG32(OSCI_READ_MR19_CH0_RANK1_1, 0x14fc)
REG32(OSCI_READ_MR19_CH0_RANK1_2, 0x1500)
    FIELD(OSCI_READ_MR19_CH0_RANK1_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR19_CH1_RANK0_0, 0x1504)
REG32(OSCI_READ_MR19_CH1_RANK0_1, 0x1508)
REG32(OSCI_READ_MR19_CH1_RANK0_2, 0x150c)
    FIELD(OSCI_READ_MR19_CH1_RANK0_2, READ_DATA, 0, 8)
REG32(OSCI_READ_MR19_CH1_RANK1_0, 0x1510)
REG32(OSCI_READ_MR19_CH1_RANK1_1, 0x1514)
REG32(OSCI_READ_MR19_CH1_RANK1_2, 0x1518)
    FIELD(OSCI_READ_MR19_CH1_RANK1_2, READ_DATA, 0, 8)
REG32(SEQ_3DS, 0x151c)
    FIELD(SEQ_3DS, VAL, 0, 1)

#define DDRMC_MAIN_R_MAX (R_SEQ_3DS + 1)

#define LOCK_VAL 0xF9E8D7C6

typedef struct DDRMC_MAIN {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[DDRMC_MAIN_R_MAX];
    RegisterInfo regs_info[DDRMC_MAIN_R_MAX];
} DDRMC_MAIN;

static void ddrmc_main_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    DDRMC_MAIN *s = XILINX_DDRMC_MAIN(reg->opaque);
    uint32_t val = val64;
    bool locked;

    locked = ARRAY_FIELD_EX32(s->regs, PCSR_LOCK, STATE);
    if (locked && val == LOCK_VAL) {
        locked = false;
    } else {
        locked |= FIELD_EX32(val, PCSR_LOCK, STATE);
    }
    ARRAY_FIELD_DP32(s->regs, PCSR_LOCK, STATE, locked);
}

static const RegisterAccessInfo ddrmc_main_regs_info[] = {
    {   .name = "PCSR_LOCK",  .addr = A_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .post_write = ddrmc_main_lock_postw,
    },{ .name = "DDRMC_ISR",  .addr = A_DDRMC_ISR,
        .w1c = 0xffffffff,
    },{ .name = "DDRMC_ITR",  .addr = A_DDRMC_ITR,
    },{ .name = "DDRMC_IMR0",  .addr = A_DDRMC_IMR0,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "DDRMC_IER0",  .addr = A_DDRMC_IER0,
    },{ .name = "DDRMC_IDR0",  .addr = A_DDRMC_IDR0,
    },{ .name = "DDRMC_IMR1",  .addr = A_DDRMC_IMR1,
        .reset = 0x7fffffff,
        .ro = 0xffffffff,
    },{ .name = "DDRMC_IER1",  .addr = A_DDRMC_IER1,
    },{ .name = "DDRMC_IDR1",  .addr = A_DDRMC_IDR1,
    },{ .name = "DDRMC_IOR",  .addr = A_DDRMC_IOR,
        .reset = 0x2,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_SAFE_CONFIG0",  .addr = A_REG_SAFE_CONFIG0,
        .reset = 0xa310304,
    },{ .name = "REG_SAFE_CONFIG1",  .addr = A_REG_SAFE_CONFIG1,
        .reset = 0x40c20308,
    },{ .name = "REG_SAFE_CONFIG2",  .addr = A_REG_SAFE_CONFIG2,
        .reset = 0x4181f3d0,
    },{ .name = "REG_SAFE_CONFIG3",  .addr = A_REG_SAFE_CONFIG3,
        .reset = 0x1018912,
        .rsvd = 0xf0000000,
    },{ .name = "REG_SAFE_CONFIG4",  .addr = A_REG_SAFE_CONFIG4,
        .reset = 0x1a00610f,
        .rsvd = 0x80f80000,
        .ro = 0xf80000,
    },{ .name = "REG_SAFE_CONFIG6",  .addr = A_REG_SAFE_CONFIG6,
        .reset = 0xc80800,
        .rsvd = 0xfc000000,
    },{ .name = "REG_SAFE_CONFIG7",  .addr = A_REG_SAFE_CONFIG7,
        .reset = 0x40200,
        .rsvd = 0xc0000000,
    },{ .name = "REG_SAFE_CONFIG8",  .addr = A_REG_SAFE_CONFIG8,
        .reset = 0x2000,
    },{ .name = "REG_RETRY_0",  .addr = A_REG_RETRY_0,
        .reset = 0xa2b604c,
        .rsvd = 0xe0000000,
    },{ .name = "REG_RETRY_1",  .addr = A_REG_RETRY_1,
        .reset = 0x14528140,
        .rsvd = 0xc0000000,
    },{ .name = "REG_REF_1",  .addr = A_REG_REF_1,
        .reset = 0x5100080,
    },{ .name = "REG_REF_3",  .addr = A_REG_REF_3,
        .reset = 0xc002,
        .rsvd = 0xffff0000,
    },{ .name = "REG_COM_3",  .addr = A_REG_COM_3,
        .reset = 0x14410,
        .rsvd = 0xfffc0000,
    },{ .name = "REG_MRS_0",  .addr = A_REG_MRS_0,
        .reset = 0x200924,
        .rsvd = 0xfc000000,
    },{ .name = "REG_MRS_1",  .addr = A_REG_MRS_1,
        .reset = 0x92000000,
    },{ .name = "REG_MRS_7",  .addr = A_REG_MRS_7,
        .reset = 0x28,
        .rsvd = 0xfc000000,
    },{ .name = "REG_SCRUB0",  .addr = A_REG_SCRUB0,
        .reset = 0xff408281,
    },{ .name = "REG_TXN_CONFIG",  .addr = A_REG_TXN_CONFIG,
        .reset = 0x10500,
        .rsvd = 0xfff00000,
    },{ .name = "REG_WR_CONFIG",  .addr = A_REG_WR_CONFIG,
        .reset = 0x5000500,
    },{ .name = "REG_RD_CONFIG",  .addr = A_REG_RD_CONFIG,
        .reset = 0x10010010,
        .rsvd = 0xc00c00e0,
        .ro = 0xc00e0,
    },{ .name = "REG_PT_CONFIG",  .addr = A_REG_PT_CONFIG,
        .reset = 0x401,
        .rsvd = 0xfff0000c,
        .ro = 0xc,
    },{ .name = "REG_DRAM_ARB",  .addr = A_REG_DRAM_ARB,
        .reset = 0x910,
        .rsvd = 0xffffe0e0,
        .ro = 0xe0,
    },{ .name = "REG_CONFIG0",  .addr = A_REG_CONFIG0,
        .reset = 0x400000,
        .rsvd = 0xff8008cc,
        .ro = 0x8cc,
    },{ .name = "REG_PINOUT",  .addr = A_REG_PINOUT,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_CONFIG3",  .addr = A_REG_CONFIG3,
        .reset = 0xfec9fec6,
    },{ .name = "REG_CONFIG4",  .addr = A_REG_CONFIG4,
        .reset = 0x1318a5,
        .rsvd = 0xff800000,
    },{ .name = "SEQ_INIT_CMD_VALID",  .addr = A_SEQ_INIT_CMD_VALID,
        .rsvd = 0xffffff80,
    },{ .name = "SEQ_INIT_CMD0",  .addr = A_SEQ_INIT_CMD0,
    },{ .name = "SEQ_INIT_CMD1",  .addr = A_SEQ_INIT_CMD1,
    },{ .name = "SEQ_INIT_CMD2",  .addr = A_SEQ_INIT_CMD2,
    },{ .name = "SEQ_INIT_CMD3",  .addr = A_SEQ_INIT_CMD3,
    },{ .name = "SEQ_INIT_CMD4",  .addr = A_SEQ_INIT_CMD4,
    },{ .name = "SEQ_INIT_CMD5",  .addr = A_SEQ_INIT_CMD5,
    },{ .name = "SEQ_INIT_CMD6",  .addr = A_SEQ_INIT_CMD6,
    },{ .name = "SEQ_INIT_CMD7",  .addr = A_SEQ_INIT_CMD7,
    },{ .name = "SEQ_INIT_CMD8",  .addr = A_SEQ_INIT_CMD8,
    },{ .name = "SEQ_INIT_CMD9",  .addr = A_SEQ_INIT_CMD9,
    },{ .name = "SEQ_INIT_CMD10",  .addr = A_SEQ_INIT_CMD10,
    },{ .name = "SEQ_INIT_CMD11",  .addr = A_SEQ_INIT_CMD11,
    },{ .name = "SEQ_INIT_CMD12",  .addr = A_SEQ_INIT_CMD12,
    },{ .name = "SEQ_INIT_CMD13",  .addr = A_SEQ_INIT_CMD13,
    },{ .name = "SEQ_INIT_CMD14",  .addr = A_SEQ_INIT_CMD14,
    },{ .name = "SEQ_INIT_CMD15",  .addr = A_SEQ_INIT_CMD15,
    },{ .name = "SEQ_INIT_CMD16",  .addr = A_SEQ_INIT_CMD16,
    },{ .name = "SEQ_INIT_CMD17",  .addr = A_SEQ_INIT_CMD17,
    },{ .name = "SEQ_INIT_CMD18",  .addr = A_SEQ_INIT_CMD18,
    },{ .name = "SEQ_INIT_CMD19",  .addr = A_SEQ_INIT_CMD19,
    },{ .name = "SEQ_INIT_CMD20",  .addr = A_SEQ_INIT_CMD20,
    },{ .name = "SEQ_INIT_CMD21",  .addr = A_SEQ_INIT_CMD21,
    },{ .name = "SEQ_INIT_CMD22",  .addr = A_SEQ_INIT_CMD22,
    },{ .name = "SEQ_INIT_CMD23",  .addr = A_SEQ_INIT_CMD23,
    },{ .name = "SEQ_INIT_CMD24",  .addr = A_SEQ_INIT_CMD24,
    },{ .name = "SEQ_INIT_CMD25",  .addr = A_SEQ_INIT_CMD25,
    },{ .name = "SEQ_INIT_CMD26",  .addr = A_SEQ_INIT_CMD26,
    },{ .name = "SEQ_INIT_CMD27",  .addr = A_SEQ_INIT_CMD27,
    },{ .name = "SEQ_INIT_CMD28",  .addr = A_SEQ_INIT_CMD28,
    },{ .name = "SEQ_INIT_CMD29",  .addr = A_SEQ_INIT_CMD29,
    },{ .name = "SEQ_INIT_CMD30",  .addr = A_SEQ_INIT_CMD30,
    },{ .name = "SEQ_INIT_CMD31",  .addr = A_SEQ_INIT_CMD31,
    },{ .name = "SEQ_INIT_CMD_SET",  .addr = A_SEQ_INIT_CMD_SET,
        .rsvd = 0xfffffe00,
    },{ .name = "SEQ_INIT_ADDR0",  .addr = A_SEQ_INIT_ADDR0,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR1",  .addr = A_SEQ_INIT_ADDR1,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR2",  .addr = A_SEQ_INIT_ADDR2,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR3",  .addr = A_SEQ_INIT_ADDR3,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR4",  .addr = A_SEQ_INIT_ADDR4,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR5",  .addr = A_SEQ_INIT_ADDR5,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR6",  .addr = A_SEQ_INIT_ADDR6,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR7",  .addr = A_SEQ_INIT_ADDR7,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR8",  .addr = A_SEQ_INIT_ADDR8,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR9",  .addr = A_SEQ_INIT_ADDR9,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR10",  .addr = A_SEQ_INIT_ADDR10,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR11",  .addr = A_SEQ_INIT_ADDR11,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR12",  .addr = A_SEQ_INIT_ADDR12,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR13",  .addr = A_SEQ_INIT_ADDR13,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR14",  .addr = A_SEQ_INIT_ADDR14,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR15",  .addr = A_SEQ_INIT_ADDR15,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR16",  .addr = A_SEQ_INIT_ADDR16,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR17",  .addr = A_SEQ_INIT_ADDR17,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR18",  .addr = A_SEQ_INIT_ADDR18,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR19",  .addr = A_SEQ_INIT_ADDR19,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR20",  .addr = A_SEQ_INIT_ADDR20,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR21",  .addr = A_SEQ_INIT_ADDR21,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR22",  .addr = A_SEQ_INIT_ADDR22,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR23",  .addr = A_SEQ_INIT_ADDR23,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR24",  .addr = A_SEQ_INIT_ADDR24,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR25",  .addr = A_SEQ_INIT_ADDR25,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR26",  .addr = A_SEQ_INIT_ADDR26,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR27",  .addr = A_SEQ_INIT_ADDR27,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR28",  .addr = A_SEQ_INIT_ADDR28,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR29",  .addr = A_SEQ_INIT_ADDR29,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR30",  .addr = A_SEQ_INIT_ADDR30,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR31",  .addr = A_SEQ_INIT_ADDR31,
        .rsvd = 0xf0000000,
    },{ .name = "XPI_NIB_CHAN",  .addr = A_XPI_NIB_CHAN,
        .rsvd = 0xf8000000,
    },{ .name = "XPI_DATA_NIB_CHAN",  .addr = A_XPI_DATA_NIB_CHAN,
        .rsvd = 0xfffc0000,
    },{ .name = "SEQ_INIT_CNTRL0",  .addr = A_SEQ_INIT_CNTRL0,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL1",  .addr = A_SEQ_INIT_CNTRL1,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL2",  .addr = A_SEQ_INIT_CNTRL2,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL3",  .addr = A_SEQ_INIT_CNTRL3,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL4",  .addr = A_SEQ_INIT_CNTRL4,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL5",  .addr = A_SEQ_INIT_CNTRL5,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL6",  .addr = A_SEQ_INIT_CNTRL6,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL7",  .addr = A_SEQ_INIT_CNTRL7,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL8",  .addr = A_SEQ_INIT_CNTRL8,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL9",  .addr = A_SEQ_INIT_CNTRL9,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL10",  .addr = A_SEQ_INIT_CNTRL10,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL11",  .addr = A_SEQ_INIT_CNTRL11,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL12",  .addr = A_SEQ_INIT_CNTRL12,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL13",  .addr = A_SEQ_INIT_CNTRL13,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL14",  .addr = A_SEQ_INIT_CNTRL14,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL15",  .addr = A_SEQ_INIT_CNTRL15,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL16",  .addr = A_SEQ_INIT_CNTRL16,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL17",  .addr = A_SEQ_INIT_CNTRL17,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL18",  .addr = A_SEQ_INIT_CNTRL18,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL19",  .addr = A_SEQ_INIT_CNTRL19,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL20",  .addr = A_SEQ_INIT_CNTRL20,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL21",  .addr = A_SEQ_INIT_CNTRL21,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL22",  .addr = A_SEQ_INIT_CNTRL22,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL23",  .addr = A_SEQ_INIT_CNTRL23,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL24",  .addr = A_SEQ_INIT_CNTRL24,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL25",  .addr = A_SEQ_INIT_CNTRL25,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL26",  .addr = A_SEQ_INIT_CNTRL26,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL27",  .addr = A_SEQ_INIT_CNTRL27,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL28",  .addr = A_SEQ_INIT_CNTRL28,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL29",  .addr = A_SEQ_INIT_CNTRL29,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL30",  .addr = A_SEQ_INIT_CNTRL30,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL31",  .addr = A_SEQ_INIT_CNTRL31,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL32",  .addr = A_SEQ_INIT_CNTRL32,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL33",  .addr = A_SEQ_INIT_CNTRL33,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL34",  .addr = A_SEQ_INIT_CNTRL34,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL35",  .addr = A_SEQ_INIT_CNTRL35,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL36",  .addr = A_SEQ_INIT_CNTRL36,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL37",  .addr = A_SEQ_INIT_CNTRL37,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL38",  .addr = A_SEQ_INIT_CNTRL38,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL39",  .addr = A_SEQ_INIT_CNTRL39,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL40",  .addr = A_SEQ_INIT_CNTRL40,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL41",  .addr = A_SEQ_INIT_CNTRL41,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL42",  .addr = A_SEQ_INIT_CNTRL42,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL43",  .addr = A_SEQ_INIT_CNTRL43,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL44",  .addr = A_SEQ_INIT_CNTRL44,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL45",  .addr = A_SEQ_INIT_CNTRL45,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL46",  .addr = A_SEQ_INIT_CNTRL46,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL47",  .addr = A_SEQ_INIT_CNTRL47,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL48",  .addr = A_SEQ_INIT_CNTRL48,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL49",  .addr = A_SEQ_INIT_CNTRL49,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL50",  .addr = A_SEQ_INIT_CNTRL50,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL51",  .addr = A_SEQ_INIT_CNTRL51,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL52",  .addr = A_SEQ_INIT_CNTRL52,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL53",  .addr = A_SEQ_INIT_CNTRL53,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL54",  .addr = A_SEQ_INIT_CNTRL54,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL55",  .addr = A_SEQ_INIT_CNTRL55,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL56",  .addr = A_SEQ_INIT_CNTRL56,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL57",  .addr = A_SEQ_INIT_CNTRL57,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL58",  .addr = A_SEQ_INIT_CNTRL58,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL59",  .addr = A_SEQ_INIT_CNTRL59,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL60",  .addr = A_SEQ_INIT_CNTRL60,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL61",  .addr = A_SEQ_INIT_CNTRL61,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL62",  .addr = A_SEQ_INIT_CNTRL62,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL63",  .addr = A_SEQ_INIT_CNTRL63,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL64",  .addr = A_SEQ_INIT_CNTRL64,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL65",  .addr = A_SEQ_INIT_CNTRL65,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL66",  .addr = A_SEQ_INIT_CNTRL66,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL67",  .addr = A_SEQ_INIT_CNTRL67,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL68",  .addr = A_SEQ_INIT_CNTRL68,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL69",  .addr = A_SEQ_INIT_CNTRL69,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL70",  .addr = A_SEQ_INIT_CNTRL70,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL71",  .addr = A_SEQ_INIT_CNTRL71,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL72",  .addr = A_SEQ_INIT_CNTRL72,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL73",  .addr = A_SEQ_INIT_CNTRL73,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL74",  .addr = A_SEQ_INIT_CNTRL74,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL75",  .addr = A_SEQ_INIT_CNTRL75,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL76",  .addr = A_SEQ_INIT_CNTRL76,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL77",  .addr = A_SEQ_INIT_CNTRL77,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL78",  .addr = A_SEQ_INIT_CNTRL78,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL79",  .addr = A_SEQ_INIT_CNTRL79,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL80",  .addr = A_SEQ_INIT_CNTRL80,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL81",  .addr = A_SEQ_INIT_CNTRL81,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL82",  .addr = A_SEQ_INIT_CNTRL82,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL83",  .addr = A_SEQ_INIT_CNTRL83,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL84",  .addr = A_SEQ_INIT_CNTRL84,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL85",  .addr = A_SEQ_INIT_CNTRL85,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL86",  .addr = A_SEQ_INIT_CNTRL86,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL87",  .addr = A_SEQ_INIT_CNTRL87,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL88",  .addr = A_SEQ_INIT_CNTRL88,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL89",  .addr = A_SEQ_INIT_CNTRL89,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL90",  .addr = A_SEQ_INIT_CNTRL90,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL91",  .addr = A_SEQ_INIT_CNTRL91,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL92",  .addr = A_SEQ_INIT_CNTRL92,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL93",  .addr = A_SEQ_INIT_CNTRL93,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL94",  .addr = A_SEQ_INIT_CNTRL94,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL95",  .addr = A_SEQ_INIT_CNTRL95,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL96",  .addr = A_SEQ_INIT_CNTRL96,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL97",  .addr = A_SEQ_INIT_CNTRL97,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL98",  .addr = A_SEQ_INIT_CNTRL98,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CNTRL99",  .addr = A_SEQ_INIT_CNTRL99,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_INIT_CMD32",  .addr = A_SEQ_INIT_CMD32,
    },{ .name = "SEQ_INIT_CMD33",  .addr = A_SEQ_INIT_CMD33,
    },{ .name = "SEQ_INIT_CMD34",  .addr = A_SEQ_INIT_CMD34,
    },{ .name = "SEQ_INIT_CMD35",  .addr = A_SEQ_INIT_CMD35,
    },{ .name = "SEQ_INIT_CMD36",  .addr = A_SEQ_INIT_CMD36,
    },{ .name = "SEQ_INIT_CMD37",  .addr = A_SEQ_INIT_CMD37,
    },{ .name = "SEQ_INIT_CMD38",  .addr = A_SEQ_INIT_CMD38,
    },{ .name = "SEQ_INIT_CMD39",  .addr = A_SEQ_INIT_CMD39,
    },{ .name = "SEQ_INIT_CMD40",  .addr = A_SEQ_INIT_CMD40,
    },{ .name = "SEQ_INIT_CMD41",  .addr = A_SEQ_INIT_CMD41,
    },{ .name = "SEQ_INIT_CMD42",  .addr = A_SEQ_INIT_CMD42,
    },{ .name = "SEQ_INIT_CMD43",  .addr = A_SEQ_INIT_CMD43,
    },{ .name = "SEQ_INIT_CMD44",  .addr = A_SEQ_INIT_CMD44,
    },{ .name = "SEQ_INIT_CMD45",  .addr = A_SEQ_INIT_CMD45,
    },{ .name = "SEQ_INIT_CMD46",  .addr = A_SEQ_INIT_CMD46,
    },{ .name = "SEQ_INIT_CMD47",  .addr = A_SEQ_INIT_CMD47,
    },{ .name = "SEQ_INIT_CMD48",  .addr = A_SEQ_INIT_CMD48,
    },{ .name = "SEQ_INIT_CMD49",  .addr = A_SEQ_INIT_CMD49,
    },{ .name = "SEQ_INIT_CMD50",  .addr = A_SEQ_INIT_CMD50,
    },{ .name = "SEQ_INIT_CMD51",  .addr = A_SEQ_INIT_CMD51,
    },{ .name = "SEQ_INIT_CMD52",  .addr = A_SEQ_INIT_CMD52,
    },{ .name = "SEQ_INIT_CMD53",  .addr = A_SEQ_INIT_CMD53,
    },{ .name = "SEQ_INIT_CMD54",  .addr = A_SEQ_INIT_CMD54,
    },{ .name = "SEQ_INIT_CMD55",  .addr = A_SEQ_INIT_CMD55,
    },{ .name = "SEQ_INIT_CMD56",  .addr = A_SEQ_INIT_CMD56,
    },{ .name = "SEQ_INIT_CMD57",  .addr = A_SEQ_INIT_CMD57,
    },{ .name = "SEQ_INIT_CMD58",  .addr = A_SEQ_INIT_CMD58,
    },{ .name = "SEQ_INIT_CMD59",  .addr = A_SEQ_INIT_CMD59,
    },{ .name = "SEQ_INIT_CMD60",  .addr = A_SEQ_INIT_CMD60,
    },{ .name = "SEQ_INIT_CMD61",  .addr = A_SEQ_INIT_CMD61,
    },{ .name = "SEQ_INIT_CMD62",  .addr = A_SEQ_INIT_CMD62,
    },{ .name = "SEQ_INIT_CMD63",  .addr = A_SEQ_INIT_CMD63,
    },{ .name = "SEQ_INIT_CMD64",  .addr = A_SEQ_INIT_CMD64,
    },{ .name = "SEQ_INIT_CMD65",  .addr = A_SEQ_INIT_CMD65,
    },{ .name = "SEQ_INIT_CMD66",  .addr = A_SEQ_INIT_CMD66,
    },{ .name = "SEQ_INIT_CMD67",  .addr = A_SEQ_INIT_CMD67,
    },{ .name = "SEQ_INIT_CMD68",  .addr = A_SEQ_INIT_CMD68,
    },{ .name = "SEQ_INIT_CMD69",  .addr = A_SEQ_INIT_CMD69,
    },{ .name = "SEQ_INIT_CMD70",  .addr = A_SEQ_INIT_CMD70,
    },{ .name = "SEQ_INIT_CMD71",  .addr = A_SEQ_INIT_CMD71,
    },{ .name = "SEQ_INIT_CMD72",  .addr = A_SEQ_INIT_CMD72,
    },{ .name = "SEQ_INIT_CMD73",  .addr = A_SEQ_INIT_CMD73,
    },{ .name = "SEQ_INIT_CMD74",  .addr = A_SEQ_INIT_CMD74,
    },{ .name = "SEQ_INIT_CMD75",  .addr = A_SEQ_INIT_CMD75,
    },{ .name = "SEQ_INIT_CMD76",  .addr = A_SEQ_INIT_CMD76,
    },{ .name = "SEQ_INIT_CMD77",  .addr = A_SEQ_INIT_CMD77,
    },{ .name = "SEQ_INIT_CMD78",  .addr = A_SEQ_INIT_CMD78,
    },{ .name = "SEQ_INIT_CMD79",  .addr = A_SEQ_INIT_CMD79,
    },{ .name = "SEQ_INIT_CMD80",  .addr = A_SEQ_INIT_CMD80,
    },{ .name = "SEQ_INIT_CMD81",  .addr = A_SEQ_INIT_CMD81,
    },{ .name = "SEQ_INIT_CMD82",  .addr = A_SEQ_INIT_CMD82,
    },{ .name = "SEQ_INIT_CMD83",  .addr = A_SEQ_INIT_CMD83,
    },{ .name = "SEQ_INIT_CMD84",  .addr = A_SEQ_INIT_CMD84,
    },{ .name = "SEQ_INIT_CMD85",  .addr = A_SEQ_INIT_CMD85,
    },{ .name = "SEQ_INIT_CMD86",  .addr = A_SEQ_INIT_CMD86,
    },{ .name = "SEQ_INIT_CMD87",  .addr = A_SEQ_INIT_CMD87,
    },{ .name = "SEQ_INIT_CMD88",  .addr = A_SEQ_INIT_CMD88,
    },{ .name = "SEQ_INIT_CMD89",  .addr = A_SEQ_INIT_CMD89,
    },{ .name = "SEQ_INIT_CMD90",  .addr = A_SEQ_INIT_CMD90,
    },{ .name = "SEQ_INIT_CMD91",  .addr = A_SEQ_INIT_CMD91,
    },{ .name = "SEQ_INIT_CMD92",  .addr = A_SEQ_INIT_CMD92,
    },{ .name = "SEQ_INIT_CMD93",  .addr = A_SEQ_INIT_CMD93,
    },{ .name = "SEQ_INIT_CMD94",  .addr = A_SEQ_INIT_CMD94,
    },{ .name = "SEQ_INIT_CMD95",  .addr = A_SEQ_INIT_CMD95,
    },{ .name = "SEQ_INIT_CMD96",  .addr = A_SEQ_INIT_CMD96,
    },{ .name = "SEQ_INIT_CMD97",  .addr = A_SEQ_INIT_CMD97,
    },{ .name = "SEQ_INIT_CMD98",  .addr = A_SEQ_INIT_CMD98,
    },{ .name = "SEQ_INIT_CMD99",  .addr = A_SEQ_INIT_CMD99,
    },{ .name = "SEQ_INIT_ADDR32",  .addr = A_SEQ_INIT_ADDR32,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR33",  .addr = A_SEQ_INIT_ADDR33,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR34",  .addr = A_SEQ_INIT_ADDR34,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR35",  .addr = A_SEQ_INIT_ADDR35,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR36",  .addr = A_SEQ_INIT_ADDR36,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR37",  .addr = A_SEQ_INIT_ADDR37,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR38",  .addr = A_SEQ_INIT_ADDR38,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR39",  .addr = A_SEQ_INIT_ADDR39,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR40",  .addr = A_SEQ_INIT_ADDR40,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR41",  .addr = A_SEQ_INIT_ADDR41,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR42",  .addr = A_SEQ_INIT_ADDR42,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR43",  .addr = A_SEQ_INIT_ADDR43,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR44",  .addr = A_SEQ_INIT_ADDR44,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR45",  .addr = A_SEQ_INIT_ADDR45,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR46",  .addr = A_SEQ_INIT_ADDR46,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR47",  .addr = A_SEQ_INIT_ADDR47,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR48",  .addr = A_SEQ_INIT_ADDR48,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR49",  .addr = A_SEQ_INIT_ADDR49,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR50",  .addr = A_SEQ_INIT_ADDR50,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR51",  .addr = A_SEQ_INIT_ADDR51,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR52",  .addr = A_SEQ_INIT_ADDR52,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR53",  .addr = A_SEQ_INIT_ADDR53,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR54",  .addr = A_SEQ_INIT_ADDR54,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR55",  .addr = A_SEQ_INIT_ADDR55,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR56",  .addr = A_SEQ_INIT_ADDR56,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR57",  .addr = A_SEQ_INIT_ADDR57,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR58",  .addr = A_SEQ_INIT_ADDR58,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR59",  .addr = A_SEQ_INIT_ADDR59,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR60",  .addr = A_SEQ_INIT_ADDR60,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR61",  .addr = A_SEQ_INIT_ADDR61,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR62",  .addr = A_SEQ_INIT_ADDR62,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR63",  .addr = A_SEQ_INIT_ADDR63,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR64",  .addr = A_SEQ_INIT_ADDR64,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR65",  .addr = A_SEQ_INIT_ADDR65,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR66",  .addr = A_SEQ_INIT_ADDR66,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR67",  .addr = A_SEQ_INIT_ADDR67,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR68",  .addr = A_SEQ_INIT_ADDR68,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR69",  .addr = A_SEQ_INIT_ADDR69,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR70",  .addr = A_SEQ_INIT_ADDR70,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR71",  .addr = A_SEQ_INIT_ADDR71,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR72",  .addr = A_SEQ_INIT_ADDR72,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR73",  .addr = A_SEQ_INIT_ADDR73,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR74",  .addr = A_SEQ_INIT_ADDR74,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR75",  .addr = A_SEQ_INIT_ADDR75,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR76",  .addr = A_SEQ_INIT_ADDR76,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR77",  .addr = A_SEQ_INIT_ADDR77,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR78",  .addr = A_SEQ_INIT_ADDR78,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR79",  .addr = A_SEQ_INIT_ADDR79,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR80",  .addr = A_SEQ_INIT_ADDR80,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR81",  .addr = A_SEQ_INIT_ADDR81,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR82",  .addr = A_SEQ_INIT_ADDR82,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR83",  .addr = A_SEQ_INIT_ADDR83,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR84",  .addr = A_SEQ_INIT_ADDR84,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR85",  .addr = A_SEQ_INIT_ADDR85,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR86",  .addr = A_SEQ_INIT_ADDR86,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR87",  .addr = A_SEQ_INIT_ADDR87,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR88",  .addr = A_SEQ_INIT_ADDR88,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR89",  .addr = A_SEQ_INIT_ADDR89,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR90",  .addr = A_SEQ_INIT_ADDR90,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR91",  .addr = A_SEQ_INIT_ADDR91,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR92",  .addr = A_SEQ_INIT_ADDR92,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR93",  .addr = A_SEQ_INIT_ADDR93,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR94",  .addr = A_SEQ_INIT_ADDR94,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR95",  .addr = A_SEQ_INIT_ADDR95,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR96",  .addr = A_SEQ_INIT_ADDR96,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR97",  .addr = A_SEQ_INIT_ADDR97,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR98",  .addr = A_SEQ_INIT_ADDR98,
        .rsvd = 0xf0000000,
    },{ .name = "SEQ_INIT_ADDR99",  .addr = A_SEQ_INIT_ADDR99,
        .rsvd = 0xf0000000,
    },{ .name = "RAM_SETTING_RF2PHS",  .addr = A_RAM_SETTING_RF2PHS,
        .reset = 0x12,
        .rsvd = 0xffffff00,
    },{ .name = "RAM_SETTING_SRSPHD",  .addr = A_RAM_SETTING_SRSPHD,
        .reset = 0xa,
        .rsvd = 0xffffff80,
    },{ .name = "RAM_SETTING_RFSPHD",  .addr = A_RAM_SETTING_RFSPHD,
        .reset = 0xa,
        .rsvd = 0xffffff80,
    },{ .name = "TXNQ_RD_PRIORITY",  .addr = A_TXNQ_RD_PRIORITY,
        .reset = 0x101010,
        .rsvd = 0xfc000000,
    },{ .name = "TXNQ_WR_PRIORITY",  .addr = A_TXNQ_WR_PRIORITY,
        .reset = 0x101010,
        .rsvd = 0xfe000000,
    },{ .name = "SEQ_INIT_CONFIG",  .addr = A_SEQ_INIT_CONFIG,
        .reset = 0xf0f0,
        .rsvd = 0xfffe0000,
    },{ .name = "REG_SAFE_CONFIG5",  .addr = A_REG_SAFE_CONFIG5,
        .reset = 0x4101012,
        .rsvd = 0x80,
        .ro = 0x80,
    },{ .name = "REG_REF_0",  .addr = A_REG_REF_0,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_REF_2",  .addr = A_REG_REF_2,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_COM_1",  .addr = A_REG_COM_1,
        .reset = 0x20000,
        .rsvd = 0xf8000000,
    },{ .name = "REG_COM_2",  .addr = A_REG_COM_2,
        .reset = 0x20000,
        .rsvd = 0xf8000000,
    },{ .name = "REG_MRS_2",  .addr = A_REG_MRS_2,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_SCRUB1",  .addr = A_REG_SCRUB1,
        .reset = 0xff000001,
    },{ .name = "REG_SCRUB8",  .addr = A_REG_SCRUB8,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_SCRUB9",  .addr = A_REG_SCRUB9,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_CONFIG1",  .addr = A_REG_CONFIG1,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_CONFIG2",  .addr = A_REG_CONFIG2,
        .rsvd = 0x80000000,
    },{ .name = "CAL_MODE",  .addr = A_CAL_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "PHY_RDEN0",  .addr = A_PHY_RDEN0,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN1",  .addr = A_PHY_RDEN1,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN2",  .addr = A_PHY_RDEN2,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN3",  .addr = A_PHY_RDEN3,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN4",  .addr = A_PHY_RDEN4,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN5",  .addr = A_PHY_RDEN5,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN6",  .addr = A_PHY_RDEN6,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN7",  .addr = A_PHY_RDEN7,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN8",  .addr = A_PHY_RDEN8,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN9",  .addr = A_PHY_RDEN9,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN10",  .addr = A_PHY_RDEN10,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN11",  .addr = A_PHY_RDEN11,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN12",  .addr = A_PHY_RDEN12,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN13",  .addr = A_PHY_RDEN13,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN14",  .addr = A_PHY_RDEN14,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN15",  .addr = A_PHY_RDEN15,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN16",  .addr = A_PHY_RDEN16,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN17",  .addr = A_PHY_RDEN17,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN18",  .addr = A_PHY_RDEN18,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN19",  .addr = A_PHY_RDEN19,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN20",  .addr = A_PHY_RDEN20,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN21",  .addr = A_PHY_RDEN21,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN22",  .addr = A_PHY_RDEN22,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN23",  .addr = A_PHY_RDEN23,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN24",  .addr = A_PHY_RDEN24,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN25",  .addr = A_PHY_RDEN25,
        .reset = 0x5,
        .rsvd = 0xffffff80,
    },{ .name = "PHY_RDEN26",  .addr = A_PHY_RDEN26,
        .reset = 0x5,
        .rsvd = 0xfffff800,
    },{ .name = "FIFO_RDEN",  .addr = A_FIFO_RDEN,
        .rsvd = 0xffffff80,
    },{ .name = "DBG_TRIGGER",  .addr = A_DBG_TRIGGER,
        .rsvd = 0xfffffff8,
    },{ .name = "CAL_CS_CH",  .addr = A_CAL_CS_CH,
        .rsvd = 0xfffffffc,
    },{ .name = "PHY_RANK_READ_OVERRIDE",  .addr = A_PHY_RANK_READ_OVERRIDE,
        .rsvd = 0xfffc0000,
    },{ .name = "SEQ_MODE",  .addr = A_SEQ_MODE,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_CMD_DEFAULT",  .addr = A_SEQ_CMD_DEFAULT,
        .rsvd = 0xffffff80,
    },{ .name = "SEQ_ADDR_DEFAULT",  .addr = A_SEQ_ADDR_DEFAULT,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_BA_DEFAULT",  .addr = A_SEQ_BA_DEFAULT,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_BG_DEFAULT",  .addr = A_SEQ_BG_DEFAULT,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_CBIT_DEFAULT",  .addr = A_SEQ_CBIT_DEFAULT,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_CMD_POR",  .addr = A_SEQ_CMD_POR,
        .rsvd = 0xffffff80,
    },{ .name = "SEQ_DQ_DEFAULT",  .addr = A_SEQ_DQ_DEFAULT,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_DQS_DEFAULT",  .addr = A_SEQ_DQS_DEFAULT,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_CK_CAL",  .addr = A_SEQ_CK_CAL,
        .reset = 0xf0f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_CONFIG",  .addr = A_CPLX_CONFIG,
        .reset = 0x3b7f8084,
        .rsvd = 0x80000000,
    },{ .name = "CPLX_CONFIG2",  .addr = A_CPLX_CONFIG2,
        .reset = 0x10e0480,
        .rsvd = 0xfe000000,
    },{ .name = "CPLX_BURST_ARRAY0",  .addr = A_CPLX_BURST_ARRAY0,
        .reset = 0x1,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY1",  .addr = A_CPLX_BURST_ARRAY1,
        .reset = 0x2,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY2",  .addr = A_CPLX_BURST_ARRAY2,
        .reset = 0x3,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY3",  .addr = A_CPLX_BURST_ARRAY3,
        .reset = 0x4,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY4",  .addr = A_CPLX_BURST_ARRAY4,
        .reset = 0x5,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY5",  .addr = A_CPLX_BURST_ARRAY5,
        .reset = 0x6,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY6",  .addr = A_CPLX_BURST_ARRAY6,
        .reset = 0x1,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY7",  .addr = A_CPLX_BURST_ARRAY7,
        .reset = 0x2,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY8",  .addr = A_CPLX_BURST_ARRAY8,
        .reset = 0x3,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY9",  .addr = A_CPLX_BURST_ARRAY9,
        .reset = 0x4,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY10",  .addr = A_CPLX_BURST_ARRAY10,
        .reset = 0x5,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY11",  .addr = A_CPLX_BURST_ARRAY11,
        .reset = 0x6,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY12",  .addr = A_CPLX_BURST_ARRAY12,
        .reset = 0x3,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY13",  .addr = A_CPLX_BURST_ARRAY13,
        .reset = 0x4,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY14",  .addr = A_CPLX_BURST_ARRAY14,
        .reset = 0x5,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY15",  .addr = A_CPLX_BURST_ARRAY15,
        .reset = 0x7,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY16",  .addr = A_CPLX_BURST_ARRAY16,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY17",  .addr = A_CPLX_BURST_ARRAY17,
        .reset = 0x9,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY18",  .addr = A_CPLX_BURST_ARRAY18,
        .reset = 0xa,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY19",  .addr = A_CPLX_BURST_ARRAY19,
        .reset = 0xc,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY20",  .addr = A_CPLX_BURST_ARRAY20,
        .reset = 0xd,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY21",  .addr = A_CPLX_BURST_ARRAY21,
        .reset = 0xe,
        .rsvd = 0xffffffe0,
    },{ .name = "CPLX_BURST_ARRAY22",  .addr = A_CPLX_BURST_ARRAY22,
        .reset = 0x1e,
        .rsvd = 0xffffffe0,
    },{ .name = "PRBS_CONFIG",  .addr = A_PRBS_CONFIG,
        .reset = 0x8244,
        .rsvd = 0xfffe0000,
    },{ .name = "PRBS_CONFIG2",  .addr = A_PRBS_CONFIG2,
        .rsvd = 0xfffc0000,
    },{ .name = "PRBS_CNT",  .addr = A_PRBS_CNT,
        .reset = 0x20004,
    },{ .name = "XPI_OE_ALL_NIB",  .addr = A_XPI_OE_ALL_NIB,
        .reset = 0x408,
        .rsvd = 0xfffff800,
    },{ .name = "XPI_WRDATA_ALL_NIB",  .addr = A_XPI_WRDATA_ALL_NIB,
        .reset = 0x408,
        .rsvd = 0xfffff800,
    },{ .name = "XPI_OE",  .addr = A_XPI_OE,
        .rsvd = 0xffff0000,
    },{ .name = "XPI_PMI_CONFIG",  .addr = A_XPI_PMI_CONFIG,
        .reset = 0xc0,
        .rsvd = 0xfffffe00,
    },{ .name = "XPI_READ_OFFSET",  .addr = A_XPI_READ_OFFSET,
        .reset = 0x895,
        .rsvd = 0xffffc000,
    },{ .name = "XPI_WRITE_DM_DBI",  .addr = A_XPI_WRITE_DM_DBI,
        .rsvd = 0xfffffff0,
    },{ .name = "XPI_READ_DBI",  .addr = A_XPI_READ_DBI,
        .rsvd = 0xfffffffc,
    },{ .name = "DEFAULT_PATTERN",  .addr = A_DEFAULT_PATTERN,
        .reset = 0xa5,
        .rsvd = 0xfffffc00,
    },{ .name = "T_TXBIT",  .addr = A_T_TXBIT,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "PRBS_SEED0",  .addr = A_PRBS_SEED0,
        .reset = 0x1,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED1",  .addr = A_PRBS_SEED1,
        .reset = 0x2,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED2",  .addr = A_PRBS_SEED2,
        .reset = 0x4,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED3",  .addr = A_PRBS_SEED3,
        .reset = 0x8,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED4",  .addr = A_PRBS_SEED4,
        .reset = 0x10,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED5",  .addr = A_PRBS_SEED5,
        .reset = 0x20,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED6",  .addr = A_PRBS_SEED6,
        .reset = 0x40,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED7",  .addr = A_PRBS_SEED7,
        .reset = 0x80,
        .rsvd = 0xff800000,
    },{ .name = "PRBS_SEED8",  .addr = A_PRBS_SEED8,
        .reset = 0x100,
        .rsvd = 0xff800000,
    },{ .name = "CPLX_PATTERN0",  .addr = A_CPLX_PATTERN0,
        .reset = 0xaaaa,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN1",  .addr = A_CPLX_PATTERN1,
        .reset = 0xcccc,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN2",  .addr = A_CPLX_PATTERN2,
        .reset = 0xcccc,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN3",  .addr = A_CPLX_PATTERN3,
        .reset = 0xe3e3,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN4",  .addr = A_CPLX_PATTERN4,
        .reset = 0x8e8e,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN5",  .addr = A_CPLX_PATTERN5,
        .reset = 0x3838,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN6",  .addr = A_CPLX_PATTERN6,
        .reset = 0xf0f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN7",  .addr = A_CPLX_PATTERN7,
        .reset = 0xf0f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN8",  .addr = A_CPLX_PATTERN8,
        .reset = 0xf0f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN9",  .addr = A_CPLX_PATTERN9,
        .reset = 0xf0f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN10",  .addr = A_CPLX_PATTERN10,
        .reset = 0xf8f8,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN11",  .addr = A_CPLX_PATTERN11,
        .reset = 0x3e3e,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN12",  .addr = A_CPLX_PATTERN12,
        .reset = 0xf0f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN13",  .addr = A_CPLX_PATTERN13,
        .reset = 0x8383,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN14",  .addr = A_CPLX_PATTERN14,
        .reset = 0xe0e0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN15",  .addr = A_CPLX_PATTERN15,
        .reset = 0xfcfc,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN16",  .addr = A_CPLX_PATTERN16,
        .reset = 0xf0f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN17",  .addr = A_CPLX_PATTERN17,
        .reset = 0xc0c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN18",  .addr = A_CPLX_PATTERN18,
        .reset = 0xfcfc,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN19",  .addr = A_CPLX_PATTERN19,
        .reset = 0xf0f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN20",  .addr = A_CPLX_PATTERN20,
        .reset = 0xc0c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN21",  .addr = A_CPLX_PATTERN21,
        .reset = 0xaa55,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN22",  .addr = A_CPLX_PATTERN22,
        .reset = 0xcc33,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN23",  .addr = A_CPLX_PATTERN23,
        .reset = 0xcc33,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN24",  .addr = A_CPLX_PATTERN24,
        .reset = 0xe31c,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN25",  .addr = A_CPLX_PATTERN25,
        .reset = 0xfe71,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN26",  .addr = A_CPLX_PATTERN26,
        .reset = 0x38c7,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN27",  .addr = A_CPLX_PATTERN27,
        .reset = 0xf00f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN28",  .addr = A_CPLX_PATTERN28,
        .reset = 0xf00f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN29",  .addr = A_CPLX_PATTERN29,
        .reset = 0xf00f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN30",  .addr = A_CPLX_PATTERN30,
        .reset = 0xf00f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN31",  .addr = A_CPLX_PATTERN31,
        .reset = 0xf807,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN32",  .addr = A_CPLX_PATTERN32,
        .reset = 0x3ec1,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN33",  .addr = A_CPLX_PATTERN33,
        .reset = 0xff0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN34",  .addr = A_CPLX_PATTERN34,
        .reset = 0x837c,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN35",  .addr = A_CPLX_PATTERN35,
        .reset = 0xe01f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN36",  .addr = A_CPLX_PATTERN36,
        .reset = 0xfc03,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN37",  .addr = A_CPLX_PATTERN37,
        .reset = 0xff0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN38",  .addr = A_CPLX_PATTERN38,
        .reset = 0xc03f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN39",  .addr = A_CPLX_PATTERN39,
        .reset = 0xfc03,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN40",  .addr = A_CPLX_PATTERN40,
        .reset = 0xff0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN41",  .addr = A_CPLX_PATTERN41,
        .reset = 0xc03f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN42",  .addr = A_CPLX_PATTERN42,
        .reset = 0xb457,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN43",  .addr = A_CPLX_PATTERN43,
        .reset = 0xb46f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN44",  .addr = A_CPLX_PATTERN44,
        .reset = 0xb4c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN45",  .addr = A_CPLX_PATTERN45,
        .reset = 0xa284,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN46",  .addr = A_CPLX_PATTERN46,
        .reset = 0x8a31,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN47",  .addr = A_CPLX_PATTERN47,
        .reset = 0x2847,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN48",  .addr = A_CPLX_PATTERN48,
        .reset = 0xa225,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN49",  .addr = A_CPLX_PATTERN49,
        .reset = 0xaf9a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN50",  .addr = A_CPLX_PATTERN50,
        .reset = 0x507a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN51",  .addr = A_CPLX_PATTERN51,
        .reset = 0xaf95,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN52",  .addr = A_CPLX_PATTERN52,
        .reset = 0x50db,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN53",  .addr = A_CPLX_PATTERN53,
        .reset = 0xaff0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN54",  .addr = A_CPLX_PATTERN54,
        .reset = 0xa821,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN55",  .addr = A_CPLX_PATTERN55,
        .reset = 0x2a8a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN56",  .addr = A_CPLX_PATTERN56,
        .reset = 0xa25,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN57",  .addr = A_CPLX_PATTERN57,
        .reset = 0x829a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN58",  .addr = A_CPLX_PATTERN58,
        .reset = 0xa07a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN59",  .addr = A_CPLX_PATTERN59,
        .reset = 0xa8bf,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN60",  .addr = A_CPLX_PATTERN60,
        .reset = 0x2a57,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN61",  .addr = A_CPLX_PATTERN61,
        .reset = 0xab6f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN62",  .addr = A_CPLX_PATTERN62,
        .reset = 0xf5c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN63",  .addr = A_CPLX_PATTERN63,
        .reset = 0x4084,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN64",  .addr = A_CPLX_PATTERN64,
        .reset = 0xab31,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN65",  .addr = A_CPLX_PATTERN65,
        .reset = 0xf547,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN66",  .addr = A_CPLX_PATTERN66,
        .reset = 0x4025,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN67",  .addr = A_CPLX_PATTERN67,
        .reset = 0xab9a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN68",  .addr = A_CPLX_PATTERN68,
        .reset = 0xf57a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN69",  .addr = A_CPLX_PATTERN69,
        .reset = 0xaa95,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN70",  .addr = A_CPLX_PATTERN70,
        .reset = 0x2db,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN71",  .addr = A_CPLX_PATTERN71,
        .reset = 0xa8f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN72",  .addr = A_CPLX_PATTERN72,
        .reset = 0xa21,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN73",  .addr = A_CPLX_PATTERN73,
        .reset = 0xa08a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN74",  .addr = A_CPLX_PATTERN74,
        .reset = 0x2a25,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN75",  .addr = A_CPLX_PATTERN75,
        .reset = 0x809a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN76",  .addr = A_CPLX_PATTERN76,
        .reset = 0xaa7a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN77",  .addr = A_CPLX_PATTERN77,
        .reset = 0x2bf,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN78",  .addr = A_CPLX_PATTERN78,
        .reset = 0xaa57,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN79",  .addr = A_CPLX_PATTERN79,
        .reset = 0xff6f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN80",  .addr = A_CPLX_PATTERN80,
        .reset = 0x55c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN81",  .addr = A_CPLX_PATTERN81,
        .reset = 0x84,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN82",  .addr = A_CPLX_PATTERN82,
        .reset = 0xaa31,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN83",  .addr = A_CPLX_PATTERN83,
        .reset = 0xff47,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN84",  .addr = A_CPLX_PATTERN84,
        .reset = 0x5525,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN85",  .addr = A_CPLX_PATTERN85,
        .reset = 0x9a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN86",  .addr = A_CPLX_PATTERN86,
        .reset = 0xaa7a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN87",  .addr = A_CPLX_PATTERN87,
        .reset = 0xff95,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN88",  .addr = A_CPLX_PATTERN88,
        .reset = 0xaadb,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN89",  .addr = A_CPLX_PATTERN89,
        .reset = 0x80f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN90",  .addr = A_CPLX_PATTERN90,
        .reset = 0x2a21,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN91",  .addr = A_CPLX_PATTERN91,
        .reset = 0xa08a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN92",  .addr = A_CPLX_PATTERN92,
        .reset = 0xa25,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN93",  .addr = A_CPLX_PATTERN93,
        .reset = 0xa89a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN94",  .addr = A_CPLX_PATTERN94,
        .reset = 0x27a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN95",  .addr = A_CPLX_PATTERN95,
        .reset = 0xaabf,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN96",  .addr = A_CPLX_PATTERN96,
        .reset = 0x57,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN97",  .addr = A_CPLX_PATTERN97,
        .reset = 0xaa6f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN98",  .addr = A_CPLX_PATTERN98,
        .reset = 0x80c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN99",  .addr = A_CPLX_PATTERN99,
        .reset = 0x2a84,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN100",  .addr = A_CPLX_PATTERN100,
        .reset = 0xaa31,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN101",  .addr = A_CPLX_PATTERN101,
        .reset = 0xbf47,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN102",  .addr = A_CPLX_PATTERN102,
        .reset = 0xf525,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN103",  .addr = A_CPLX_PATTERN103,
        .reset = 0x549a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN104",  .addr = A_CPLX_PATTERN104,
        .reset = 0x7a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN105",  .addr = A_CPLX_PATTERN105,
        .reset = 0xaa95,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN106",  .addr = A_CPLX_PATTERN106,
        .reset = 0xbfdb,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN107",  .addr = A_CPLX_PATTERN107,
        .reset = 0xf5f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN108",  .addr = A_CPLX_PATTERN108,
        .reset = 0x5421,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN109",  .addr = A_CPLX_PATTERN109,
        .reset = 0x8a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN110",  .addr = A_CPLX_PATTERN110,
        .reset = 0xaa25,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN111",  .addr = A_CPLX_PATTERN111,
        .reset = 0xbf9a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN112",  .addr = A_CPLX_PATTERN112,
        .reset = 0xf57a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN113",  .addr = A_CPLX_PATTERN113,
        .reset = 0xaabf,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN114",  .addr = A_CPLX_PATTERN114,
        .reset = 0xa057,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN115",  .addr = A_CPLX_PATTERN115,
        .reset = 0x26f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN116",  .addr = A_CPLX_PATTERN116,
        .reset = 0xaac0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN117",  .addr = A_CPLX_PATTERN117,
        .reset = 0x8084,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN118",  .addr = A_CPLX_PATTERN118,
        .reset = 0xa31,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN119",  .addr = A_CPLX_PATTERN119,
        .reset = 0xaa47,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN120",  .addr = A_CPLX_PATTERN120,
        .reset = 0x25,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN121",  .addr = A_CPLX_PATTERN121,
        .reset = 0x2a9a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN122",  .addr = A_CPLX_PATTERN122,
        .reset = 0xa87a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN123",  .addr = A_CPLX_PATTERN123,
        .reset = 0x95,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN124",  .addr = A_CPLX_PATTERN124,
        .reset = 0xaadb,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN125",  .addr = A_CPLX_PATTERN125,
        .reset = 0xa0f0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN126",  .addr = A_CPLX_PATTERN126,
        .reset = 0x221,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN127",  .addr = A_CPLX_PATTERN127,
        .reset = 0x5757,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN128",  .addr = A_CPLX_PATTERN128,
        .reset = 0x6f6f,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN129",  .addr = A_CPLX_PATTERN129,
        .reset = 0xc0c0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN130",  .addr = A_CPLX_PATTERN130,
        .reset = 0x8684,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN131",  .addr = A_CPLX_PATTERN131,
        .reset = 0x2831,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN132",  .addr = A_CPLX_PATTERN132,
        .reset = 0xe447,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN133",  .addr = A_CPLX_PATTERN133,
        .reset = 0xb325,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN134",  .addr = A_CPLX_PATTERN134,
        .reset = 0x4f9b,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN135",  .addr = A_CPLX_PATTERN135,
        .reset = 0xb555,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN136",  .addr = A_CPLX_PATTERN136,
        .reset = 0xb555,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN137",  .addr = A_CPLX_PATTERN137,
        .reset = 0x8798,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN138",  .addr = A_CPLX_PATTERN138,
        .reset = 0xe31c,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN139",  .addr = A_CPLX_PATTERN139,
        .reset = 0xaf5,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN140",  .addr = A_CPLX_PATTERN140,
        .reset = 0xd42b,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN141",  .addr = A_CPLX_PATTERN141,
        .reset = 0x48b7,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN142",  .addr = A_CPLX_PATTERN142,
        .reset = 0x1fe0,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN143",  .addr = A_CPLX_PATTERN143,
        .reset = 0xbc43,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN144",  .addr = A_CPLX_PATTERN144,
        .reset = 0x8f14,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN145",  .addr = A_CPLX_PATTERN145,
        .reset = 0xb44b,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN146",  .addr = A_CPLX_PATTERN146,
        .reset = 0xcb34,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN147",  .addr = A_CPLX_PATTERN147,
        .reset = 0xaf5,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN148",  .addr = A_CPLX_PATTERN148,
        .reset = 0x8000,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN149",  .addr = A_CPLX_PATTERN149,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN150",  .addr = A_CPLX_PATTERN150,
        .reset = 0x5555,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN151",  .addr = A_CPLX_PATTERN151,
        .reset = 0x5555,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN152",  .addr = A_CPLX_PATTERN152,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN153",  .addr = A_CPLX_PATTERN153,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN154",  .addr = A_CPLX_PATTERN154,
        .reset = 0x552a,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN155",  .addr = A_CPLX_PATTERN155,
        .reset = 0x55aa,
        .rsvd = 0xffff0000,
    },{ .name = "CPLX_PATTERN156",  .addr = A_CPLX_PATTERN156,
        .reset = 0x80,
        .rsvd = 0xffff0000,
    },{ .name = "PHY_RANK_WRITE_OVERRIDE",  .addr = A_PHY_RANK_WRITE_OVERRIDE,
        .rsvd = 0xfffc0000,
    },{ .name = "CPLX_CONFIG3",  .addr = A_CPLX_CONFIG3,
        .rsvd = 0xfffffc00,
    },{ .name = "CLK_GATE",  .addr = A_CLK_GATE,
        .reset = 0x7ffff,
        .rsvd = 0xfff80000,
    },{ .name = "XPI_DQS",  .addr = A_XPI_DQS,
        .reset = 0x50,
        .rsvd = 0xffffff00,
    },{ .name = "ARBITER_CONFIG",  .addr = A_ARBITER_CONFIG,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_COM_0",  .addr = A_REG_COM_0,
        .rsvd = 0xffffff00,
        /* Fake that all is done.  */
        .reset = R_REG_COM_0_SELF_REFRESH_EXIT_DONE_MASK
                 | R_REG_COM_0_SELF_REFRESH_ENTER_DONE_MASK,
    },{ .name = "REG_COM_4",  .addr = A_REG_COM_4,
        .reset = 0x1,
        .rsvd = 0xffffffe0,
        .ro = 0x1f,
    },{ .name = "REG_MRS_3",  .addr = A_REG_MRS_3,
    },{ .name = "REG_MRS_4",  .addr = A_REG_MRS_4,
        .rsvd = 0xfffe0000,
    },{ .name = "REG_MRS_5",  .addr = A_REG_MRS_5,
        .rsvd = 0xfffffff0,
        .reset = R_REG_MRS_5_MRS_COMMAND_DONE_0_MASK,
    },{ .name = "REG_MRS_6",  .addr = A_REG_MRS_6,
        .rsvd = 0xfffffff0,
        .reset = R_REG_MRS_6_MRS_COMMAND_DONE_1_MASK,
    },{ .name = "REG_SCRUB2",  .addr = A_REG_SCRUB2,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_SCRUB3",  .addr = A_REG_SCRUB3,
        .rsvd = 0xffffffc0,
        .reset = R_REG_SCRUB3_DONE0_MASK | R_REG_SCRUB3_DONE1_MASK,
    },{ .name = "REG_SCRUB4",  .addr = A_REG_SCRUB4,
        .rsvd = 0x80000000,
    },{ .name = "REG_SCRUB5",  .addr = A_REG_SCRUB5,
        .rsvd = 0xffff0000,
    },{ .name = "REG_SCRUB6",  .addr = A_REG_SCRUB6,
        .rsvd = 0x80000000,
    },{ .name = "REG_SCRUB7",  .addr = A_REG_SCRUB7,
        .rsvd = 0xffff0000,
    },{ .name = "DC_QUEUE_STATUS",  .addr = A_DC_QUEUE_STATUS,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "T_TXBIT_PWR_SAVE",  .addr = A_T_TXBIT_PWR_SAVE,
        .rsvd = 0xfffffffe,
    },{ .name = "XPI_DYN_RANK",  .addr = A_XPI_DYN_RANK,
        .rsvd = 0xfffffc00,
    },{ .name = "PHY_OE_NIB0",  .addr = A_PHY_OE_NIB0,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB1",  .addr = A_PHY_OE_NIB1,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB2",  .addr = A_PHY_OE_NIB2,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB3",  .addr = A_PHY_OE_NIB3,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB4",  .addr = A_PHY_OE_NIB4,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB5",  .addr = A_PHY_OE_NIB5,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB6",  .addr = A_PHY_OE_NIB6,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB7",  .addr = A_PHY_OE_NIB7,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB8",  .addr = A_PHY_OE_NIB8,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB9",  .addr = A_PHY_OE_NIB9,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB10",  .addr = A_PHY_OE_NIB10,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB11",  .addr = A_PHY_OE_NIB11,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB12",  .addr = A_PHY_OE_NIB12,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB13",  .addr = A_PHY_OE_NIB13,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB14",  .addr = A_PHY_OE_NIB14,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB15",  .addr = A_PHY_OE_NIB15,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB16",  .addr = A_PHY_OE_NIB16,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB17",  .addr = A_PHY_OE_NIB17,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB18",  .addr = A_PHY_OE_NIB18,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB19",  .addr = A_PHY_OE_NIB19,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB20",  .addr = A_PHY_OE_NIB20,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB21",  .addr = A_PHY_OE_NIB21,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB22",  .addr = A_PHY_OE_NIB22,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB23",  .addr = A_PHY_OE_NIB23,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB24",  .addr = A_PHY_OE_NIB24,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB25",  .addr = A_PHY_OE_NIB25,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_OE_NIB26",  .addr = A_PHY_OE_NIB26,
        .rsvd = 0xfffffff8,
    },{ .name = "CAL_STATUS",  .addr = A_CAL_STATUS,
        .rsvd = 0xfffffffc,
        .reset = R_CAL_STATUS_INIT_DONE_MASK | R_CAL_STATUS_CAL_DONE_MASK,
    },{ .name = "SEQ_TYPE",  .addr = A_SEQ_TYPE,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_CMD_TIMING",  .addr = A_SEQ_CMD_TIMING,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_CMD_SLOT",  .addr = A_SEQ_CMD_SLOT,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_CS_BITS",  .addr = A_SEQ_CS_BITS,
        .rsvd = 0xfffffff0,
    },{ .name = "SEQ_CKE_BITS",  .addr = A_SEQ_CKE_BITS,
        .rsvd = 0xfffffff0,
    },{ .name = "SEQ_CNT",  .addr = A_SEQ_CNT,
    },{ .name = "SEQ_A_A_DLY",  .addr = A_SEQ_A_A_DLY,
    },{ .name = "SEQ_A_B_DLY",  .addr = A_SEQ_A_B_DLY,
    },{ .name = "SEQ_B_A_DLY",  .addr = A_SEQ_B_A_DLY,
    },{ .name = "SEQ_B_C_DLY",  .addr = A_SEQ_B_C_DLY,
    },{ .name = "SEQ_C_A_DLY",  .addr = A_SEQ_C_A_DLY,
    },{ .name = "SEQ_CLR",  .addr = A_SEQ_CLR,
        .rsvd = 0xfffffffe,
    },{ .name = "BL8_NIBBLE0",  .addr = A_BL8_NIBBLE0,
    },{ .name = "BL8_NIBBLE1",  .addr = A_BL8_NIBBLE1,
    },{ .name = "BL8_NIBBLE2",  .addr = A_BL8_NIBBLE2,
    },{ .name = "BL8_NIBBLE3",  .addr = A_BL8_NIBBLE3,
    },{ .name = "BL8_NIBBLE4",  .addr = A_BL8_NIBBLE4,
    },{ .name = "BL8_NIBBLE5",  .addr = A_BL8_NIBBLE5,
    },{ .name = "BL8_NIBBLE6",  .addr = A_BL8_NIBBLE6,
    },{ .name = "BL8_NIBBLE7",  .addr = A_BL8_NIBBLE7,
    },{ .name = "BL8_NIBBLE8",  .addr = A_BL8_NIBBLE8,
    },{ .name = "BL8_NIBBLE9",  .addr = A_BL8_NIBBLE9,
    },{ .name = "BL8_NIBBLE10",  .addr = A_BL8_NIBBLE10,
    },{ .name = "BL8_NIBBLE11",  .addr = A_BL8_NIBBLE11,
    },{ .name = "BL8_NIBBLE12",  .addr = A_BL8_NIBBLE12,
    },{ .name = "BL8_NIBBLE13",  .addr = A_BL8_NIBBLE13,
    },{ .name = "BL8_NIBBLE14",  .addr = A_BL8_NIBBLE14,
    },{ .name = "BL8_NIBBLE15",  .addr = A_BL8_NIBBLE15,
    },{ .name = "BL8_NIBBLE16",  .addr = A_BL8_NIBBLE16,
    },{ .name = "BL8_NIBBLE17",  .addr = A_BL8_NIBBLE17,
    },{ .name = "SEQ_EXPECTED_PAT",  .addr = A_SEQ_EXPECTED_PAT,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_A_CMD",  .addr = A_SEQ_A_CMD,
        .rsvd = 0xfffffe00,
    },{ .name = "SEQ_A_CNTRL",  .addr = A_SEQ_A_CNTRL,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_A_EARLY_CNT",  .addr = A_SEQ_A_EARLY_CNT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_A_LATE_CNT",  .addr = A_SEQ_A_LATE_CNT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_A_ADDR",  .addr = A_SEQ_A_ADDR,
        .rsvd = 0xff000000,
    },{ .name = "SEQ_A_BA",  .addr = A_SEQ_A_BA,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_A_BG",  .addr = A_SEQ_A_BG,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_A_CBIT",  .addr = A_SEQ_A_CBIT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_A_RANK",  .addr = A_SEQ_A_RANK,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_A_DQ_EARLY",  .addr = A_SEQ_A_DQ_EARLY,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DQ_0",  .addr = A_SEQ_A_DQ_0,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DQ_1",  .addr = A_SEQ_A_DQ_1,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DQ_LATE",  .addr = A_SEQ_A_DQ_LATE,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DQS_EARLY",  .addr = A_SEQ_A_DQS_EARLY,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_A_DQS_0",  .addr = A_SEQ_A_DQS_0,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_A_DQS_1",  .addr = A_SEQ_A_DQS_1,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_A_DQS_LATE",  .addr = A_SEQ_A_DQS_LATE,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_A_DM_EARLY",  .addr = A_SEQ_A_DM_EARLY,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DM_0",  .addr = A_SEQ_A_DM_0,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DM_1",  .addr = A_SEQ_A_DM_1,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_A_DM_LATE",  .addr = A_SEQ_A_DM_LATE,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_CMD",  .addr = A_SEQ_B_CMD,
        .rsvd = 0xfffffe00,
    },{ .name = "SEQ_B_CNTRL",  .addr = A_SEQ_B_CNTRL,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_B_EARLY_CNT",  .addr = A_SEQ_B_EARLY_CNT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_B_LATE_CNT",  .addr = A_SEQ_B_LATE_CNT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_B_ADDR",  .addr = A_SEQ_B_ADDR,
        .rsvd = 0xff000000,
    },{ .name = "SEQ_B_BA",  .addr = A_SEQ_B_BA,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_B_BG",  .addr = A_SEQ_B_BG,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_B_CBIT",  .addr = A_SEQ_B_CBIT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_B_RANK",  .addr = A_SEQ_B_RANK,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_B_DQ_EARLY",  .addr = A_SEQ_B_DQ_EARLY,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DQ_0",  .addr = A_SEQ_B_DQ_0,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DQ_1",  .addr = A_SEQ_B_DQ_1,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DQ_LATE",  .addr = A_SEQ_B_DQ_LATE,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DQS_EARLY",  .addr = A_SEQ_B_DQS_EARLY,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_B_DQS_0",  .addr = A_SEQ_B_DQS_0,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_B_DQS_1",  .addr = A_SEQ_B_DQS_1,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_B_DQS_LATE",  .addr = A_SEQ_B_DQS_LATE,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_B_DM_EARLY",  .addr = A_SEQ_B_DM_EARLY,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DM_0",  .addr = A_SEQ_B_DM_0,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DM_1",  .addr = A_SEQ_B_DM_1,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_B_DM_LATE",  .addr = A_SEQ_B_DM_LATE,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_CMD",  .addr = A_SEQ_C_CMD,
        .rsvd = 0xffffff80,
    },{ .name = "SEQ_C_CNTRL",  .addr = A_SEQ_C_CNTRL,
        .rsvd = 0xfffffc00,
    },{ .name = "SEQ_C_EARLY_CNT",  .addr = A_SEQ_C_EARLY_CNT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_C_LATE_CNT",  .addr = A_SEQ_C_LATE_CNT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_C_ADDR",  .addr = A_SEQ_C_ADDR,
        .rsvd = 0xff000000,
    },{ .name = "SEQ_C_BA",  .addr = A_SEQ_C_BA,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_C_BG",  .addr = A_SEQ_C_BG,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_C_CBIT",  .addr = A_SEQ_C_CBIT,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_C_RANK",  .addr = A_SEQ_C_RANK,
        .rsvd = 0xfffffffc,
    },{ .name = "SEQ_C_DQ_EARLY",  .addr = A_SEQ_C_DQ_EARLY,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DQ_0",  .addr = A_SEQ_C_DQ_0,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DQ_1",  .addr = A_SEQ_C_DQ_1,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DQ_LATE",  .addr = A_SEQ_C_DQ_LATE,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DQS_EARLY",  .addr = A_SEQ_C_DQS_EARLY,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_C_DQS_0",  .addr = A_SEQ_C_DQS_0,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_C_DQS_1",  .addr = A_SEQ_C_DQS_1,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_C_DQS_LATE",  .addr = A_SEQ_C_DQS_LATE,
        .rsvd = 0xfffffff8,
    },{ .name = "SEQ_C_DM_EARLY",  .addr = A_SEQ_C_DM_EARLY,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DM_0",  .addr = A_SEQ_C_DM_0,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DM_1",  .addr = A_SEQ_C_DM_1,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_C_DM_LATE",  .addr = A_SEQ_C_DM_LATE,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_DATA_CAPTURE",  .addr = A_SEQ_DATA_CAPTURE,
        .rsvd = 0xffffff80,
    },{ .name = "SEQ_INIT_START",  .addr = A_SEQ_INIT_START,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_INIT_STATUS",  .addr = A_SEQ_INIT_STATUS,
        .rsvd = 0xfffffffc,
        .reset = R_SEQ_INIT_STATUS_DONE_MASK,
    },{ .name = "SEQ_SIDE_CMD0",  .addr = A_SEQ_SIDE_CMD0,
    },{ .name = "SEQ_SIDE_CMD1",  .addr = A_SEQ_SIDE_CMD1,
    },{ .name = "SEQ_SIDE_CMD2",  .addr = A_SEQ_SIDE_CMD2,
    },{ .name = "SEQ_SIDE_CMD3",  .addr = A_SEQ_SIDE_CMD3,
    },{ .name = "SEQ_SIDE_CMD4",  .addr = A_SEQ_SIDE_CMD4,
    },{ .name = "SEQ_SIDE_CMD5",  .addr = A_SEQ_SIDE_CMD5,
    },{ .name = "SEQ_SIDE_CMD6",  .addr = A_SEQ_SIDE_CMD6,
    },{ .name = "SEQ_SIDE_CMD7",  .addr = A_SEQ_SIDE_CMD7,
    },{ .name = "SEQ_SIDE_CMD8",  .addr = A_SEQ_SIDE_CMD8,
    },{ .name = "SEQ_SIDE_CMD9",  .addr = A_SEQ_SIDE_CMD9,
    },{ .name = "SEQ_SIDE_CMD10",  .addr = A_SEQ_SIDE_CMD10,
    },{ .name = "SEQ_SIDE_CMD11",  .addr = A_SEQ_SIDE_CMD11,
    },{ .name = "SEQ_SIDE_CMD12",  .addr = A_SEQ_SIDE_CMD12,
    },{ .name = "SEQ_SIDE_CMD13",  .addr = A_SEQ_SIDE_CMD13,
    },{ .name = "SEQ_SIDE_CMD14",  .addr = A_SEQ_SIDE_CMD14,
    },{ .name = "SEQ_SIDE_CMD15",  .addr = A_SEQ_SIDE_CMD15,
    },{ .name = "SEQ_SIDE_CMD_SET",  .addr = A_SEQ_SIDE_CMD_SET,
        .rsvd = 0xfffffe00,
    },{ .name = "SEQ_SIDE_ADDR0",  .addr = A_SEQ_SIDE_ADDR0,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR1",  .addr = A_SEQ_SIDE_ADDR1,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR2",  .addr = A_SEQ_SIDE_ADDR2,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR3",  .addr = A_SEQ_SIDE_ADDR3,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR4",  .addr = A_SEQ_SIDE_ADDR4,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR5",  .addr = A_SEQ_SIDE_ADDR5,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR6",  .addr = A_SEQ_SIDE_ADDR6,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR7",  .addr = A_SEQ_SIDE_ADDR7,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR8",  .addr = A_SEQ_SIDE_ADDR8,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR9",  .addr = A_SEQ_SIDE_ADDR9,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR10",  .addr = A_SEQ_SIDE_ADDR10,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR11",  .addr = A_SEQ_SIDE_ADDR11,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR12",  .addr = A_SEQ_SIDE_ADDR12,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR13",  .addr = A_SEQ_SIDE_ADDR13,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR14",  .addr = A_SEQ_SIDE_ADDR14,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_ADDR15",  .addr = A_SEQ_SIDE_ADDR15,
        .rsvd = 0xc0000000,
    },{ .name = "SEQ_SIDE_CMD_START",  .addr = A_SEQ_SIDE_CMD_START,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_SIDE_CMD_CNT",  .addr = A_SEQ_SIDE_CMD_CNT,
        .rsvd = 0xffffffe0,
    },{ .name = "SEQ_DQ_NIBBLE0",  .addr = A_SEQ_DQ_NIBBLE0,
    },{ .name = "SEQ_DQ_NIBBLE1",  .addr = A_SEQ_DQ_NIBBLE1,
    },{ .name = "SEQ_DQ_NIBBLE2",  .addr = A_SEQ_DQ_NIBBLE2,
    },{ .name = "SEQ_DQ_NIBBLE3",  .addr = A_SEQ_DQ_NIBBLE3,
    },{ .name = "SEQ_DQ_NIBBLE4",  .addr = A_SEQ_DQ_NIBBLE4,
    },{ .name = "SEQ_DQ_NIBBLE5",  .addr = A_SEQ_DQ_NIBBLE5,
    },{ .name = "SEQ_DQ_NIBBLE6",  .addr = A_SEQ_DQ_NIBBLE6,
    },{ .name = "SEQ_DQ_NIBBLE7",  .addr = A_SEQ_DQ_NIBBLE7,
    },{ .name = "SEQ_DQ_NIBBLE8",  .addr = A_SEQ_DQ_NIBBLE8,
    },{ .name = "SEQ_DQ_NIBBLE9",  .addr = A_SEQ_DQ_NIBBLE9,
    },{ .name = "SEQ_DQ_NIBBLE10",  .addr = A_SEQ_DQ_NIBBLE10,
    },{ .name = "SEQ_DQ_NIBBLE11",  .addr = A_SEQ_DQ_NIBBLE11,
    },{ .name = "SEQ_DQ_NIBBLE12",  .addr = A_SEQ_DQ_NIBBLE12,
    },{ .name = "SEQ_DQ_NIBBLE13",  .addr = A_SEQ_DQ_NIBBLE13,
    },{ .name = "SEQ_DQ_NIBBLE14",  .addr = A_SEQ_DQ_NIBBLE14,
    },{ .name = "SEQ_DQ_NIBBLE15",  .addr = A_SEQ_DQ_NIBBLE15,
    },{ .name = "SEQ_DQ_NIBBLE16",  .addr = A_SEQ_DQ_NIBBLE16,
    },{ .name = "SEQ_DQ_NIBBLE17",  .addr = A_SEQ_DQ_NIBBLE17,
    },{ .name = "SEQ_DQ_NIBBLE18",  .addr = A_SEQ_DQ_NIBBLE18,
    },{ .name = "SEQ_CS_CAL",  .addr = A_SEQ_CS_CAL,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_WE_CAL",  .addr = A_SEQ_WE_CAL,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_CAS_CAL",  .addr = A_SEQ_CAS_CAL,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_RAS_CAL",  .addr = A_SEQ_RAS_CAL,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ACT_CAL",  .addr = A_SEQ_ACT_CAL,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_CKE_CAL",  .addr = A_SEQ_CKE_CAL,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL0",  .addr = A_SEQ_ADDR_CAL0,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL1",  .addr = A_SEQ_ADDR_CAL1,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL2",  .addr = A_SEQ_ADDR_CAL2,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL3",  .addr = A_SEQ_ADDR_CAL3,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL4",  .addr = A_SEQ_ADDR_CAL4,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL5",  .addr = A_SEQ_ADDR_CAL5,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL6",  .addr = A_SEQ_ADDR_CAL6,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL7",  .addr = A_SEQ_ADDR_CAL7,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL8",  .addr = A_SEQ_ADDR_CAL8,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL9",  .addr = A_SEQ_ADDR_CAL9,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL10",  .addr = A_SEQ_ADDR_CAL10,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL11",  .addr = A_SEQ_ADDR_CAL11,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL12",  .addr = A_SEQ_ADDR_CAL12,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL13",  .addr = A_SEQ_ADDR_CAL13,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL14",  .addr = A_SEQ_ADDR_CAL14,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL15",  .addr = A_SEQ_ADDR_CAL15,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL16",  .addr = A_SEQ_ADDR_CAL16,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_ADDR_CAL17",  .addr = A_SEQ_ADDR_CAL17,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_BA_CAL0",  .addr = A_SEQ_BA_CAL0,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_BA_CAL1",  .addr = A_SEQ_BA_CAL1,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_BG_CAL0",  .addr = A_SEQ_BG_CAL0,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_BG_CAL1",  .addr = A_SEQ_BG_CAL1,
        .rsvd = 0xffff0000,
    },{ .name = "SEQ_DQ_PATTERN0",  .addr = A_SEQ_DQ_PATTERN0,
    },{ .name = "SEQ_DQ_PATTERN1",  .addr = A_SEQ_DQ_PATTERN1,
    },{ .name = "SEQ_DQ_PATTERN2",  .addr = A_SEQ_DQ_PATTERN2,
    },{ .name = "SEQ_DQ_PATTERN3",  .addr = A_SEQ_DQ_PATTERN3,
    },{ .name = "SEQ_DQ_PATTERN4",  .addr = A_SEQ_DQ_PATTERN4,
    },{ .name = "SEQ_DQ_PATTERN5",  .addr = A_SEQ_DQ_PATTERN5,
    },{ .name = "SEQ_DQ_PATTERN6",  .addr = A_SEQ_DQ_PATTERN6,
    },{ .name = "SEQ_DQ_PATTERN7",  .addr = A_SEQ_DQ_PATTERN7,
    },{ .name = "SEQ_DQ_PATTERN8",  .addr = A_SEQ_DQ_PATTERN8,
    },{ .name = "SEQ_DQ_PATTERN9",  .addr = A_SEQ_DQ_PATTERN9,
    },{ .name = "SEQ_DQS_PATTERN0",  .addr = A_SEQ_DQS_PATTERN0,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_DQS_PATTERN1",  .addr = A_SEQ_DQS_PATTERN1,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_DM_PATTERN0",  .addr = A_SEQ_DM_PATTERN0,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_DM_PATTERN1",  .addr = A_SEQ_DM_PATTERN1,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_DQ_NIBBLE_SEL",  .addr = A_SEQ_DQ_NIBBLE_SEL,
        .rsvd = 0xfffffffe,
    },{ .name = "COMPARE_CLEAR",  .addr = A_COMPARE_CLEAR,
        .rsvd = 0xfffffffe,
    },{ .name = "COMPARE_CONFIG",  .addr = A_COMPARE_CONFIG,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "COMPARE_RISE_ERR_PER",  .addr = A_COMPARE_RISE_ERR_PER,
        .rsvd = 0xfffc0000,
    },{ .name = "COMPARE_FALL_ERR_PER",  .addr = A_COMPARE_FALL_ERR_PER,
        .rsvd = 0xfffc0000,
    },{ .name = "COMPARE_NIBBLE_ERR",  .addr = A_COMPARE_NIBBLE_ERR,
        .rsvd = 0xfffc0000,
    },{ .name = "COMPARE_BYTE_ERR",  .addr = A_COMPARE_BYTE_ERR,
        .rsvd = 0xfffffe00,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE0",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE0,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE1",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE1,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE2",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE2,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE3",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE3,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE4",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE4,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE5",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE5,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE6",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE6,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE7",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE7,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE8",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE8,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE9",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE9,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE10",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE10,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE11",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE11,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE12",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE12,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE13",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE13,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE14",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE14,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE15",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE15,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE16",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE16,
    },{ .name = "COMPARE_PERBIT_ERR_NIBBLE17",
        .addr = A_COMPARE_PERBIT_ERR_NIBBLE17,
    },{ .name = "COMPARE_DATA_STABLE_NIBBLE0",
        .addr = A_COMPARE_DATA_STABLE_NIBBLE0,
        .rsvd = 0xfffc0000,
    },{ .name = "COMPARE_DATA_STABLE_NIBBLE1",
        .addr = A_COMPARE_DATA_STABLE_NIBBLE1,
        .rsvd = 0xfffc0000,
    },{ .name = "COMPARE_RISE_ERR_PER_BIT0",
        .addr = A_COMPARE_RISE_ERR_PER_BIT0,
    },{ .name = "COMPARE_RISE_ERR_PER_BIT1",
        .addr = A_COMPARE_RISE_ERR_PER_BIT1,
    },{ .name = "COMPARE_RISE_ERR_PER_BIT2",
        .addr = A_COMPARE_RISE_ERR_PER_BIT2,
        .rsvd = 0xffffff00,
    },{ .name = "COMPARE_FALL_ERR_PER_BIT0",
        .addr = A_COMPARE_FALL_ERR_PER_BIT0,
    },{ .name = "COMPARE_FALL_ERR_PER_BIT1",
        .addr = A_COMPARE_FALL_ERR_PER_BIT1,
    },{ .name = "COMPARE_FALL_ERR_PER_BIT2",
        .addr = A_COMPARE_FALL_ERR_PER_BIT2,
        .rsvd = 0xffffff00,
    },{ .name = "COMPARE_ERR_PER_BIT0",  .addr = A_COMPARE_ERR_PER_BIT0,
    },{ .name = "COMPARE_ERR_PER_BIT1",  .addr = A_COMPARE_ERR_PER_BIT1,
    },{ .name = "COMPARE_ERR_PER_BIT2",  .addr = A_COMPARE_ERR_PER_BIT2,
        .rsvd = 0xffffff00,
    },{ .name = "PHY_DATA_NIB0",  .addr = A_PHY_DATA_NIB0,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB1",  .addr = A_PHY_DATA_NIB1,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB2",  .addr = A_PHY_DATA_NIB2,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB3",  .addr = A_PHY_DATA_NIB3,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB4",  .addr = A_PHY_DATA_NIB4,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB5",  .addr = A_PHY_DATA_NIB5,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB6",  .addr = A_PHY_DATA_NIB6,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB7",  .addr = A_PHY_DATA_NIB7,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB8",  .addr = A_PHY_DATA_NIB8,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB9",  .addr = A_PHY_DATA_NIB9,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB10",  .addr = A_PHY_DATA_NIB10,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB11",  .addr = A_PHY_DATA_NIB11,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB12",  .addr = A_PHY_DATA_NIB12,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB13",  .addr = A_PHY_DATA_NIB13,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB14",  .addr = A_PHY_DATA_NIB14,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB15",  .addr = A_PHY_DATA_NIB15,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB16",  .addr = A_PHY_DATA_NIB16,
        .rsvd = 0xfffffff8,
    },{ .name = "PHY_DATA_NIB17",  .addr = A_PHY_DATA_NIB17,
        .rsvd = 0xfffffff8,
    },{ .name = "ECCW0_FLIP_CONTROL",  .addr = A_ECCW0_FLIP_CONTROL,
        .rsvd = 0xffffff00,
    },{ .name = "ECCW0_FLIP0",  .addr = A_ECCW0_FLIP0,
    },{ .name = "ECCW0_FLIP1",  .addr = A_ECCW0_FLIP1,
    },{ .name = "ECCW0_FLIP2",  .addr = A_ECCW0_FLIP2,
        .rsvd = 0xffffff00,
    },{ .name = "ECCW1_FLIP_CONTROL",  .addr = A_ECCW1_FLIP_CONTROL,
        .rsvd = 0xffffff00,
    },{ .name = "ECCW1_FLIP0",  .addr = A_ECCW1_FLIP0,
    },{ .name = "ECCW1_FLIP1",  .addr = A_ECCW1_FLIP1,
    },{ .name = "ECCW1_FLIP2",  .addr = A_ECCW1_FLIP2,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_CORR_ERR_STATUS",  .addr = A_ECCR0_CORR_ERR_STATUS,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_CORR_ERR_ADD_LO",  .addr = A_ECCR0_CORR_ERR_ADD_LO,
    },{ .name = "ECCR0_CORR_ERR_ADD_HI",  .addr = A_ECCR0_CORR_ERR_ADD_HI,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_CORR_ERR_DATA_LO",  .addr = A_ECCR0_CORR_ERR_DATA_LO,
    },{ .name = "ECCR0_CORR_ERR_DATA_HI",  .addr = A_ECCR0_CORR_ERR_DATA_HI,
    },{ .name = "ECCR0_CORR_ERR_DATA_PAR",  .addr = A_ECCR0_CORR_ERR_DATA_PAR,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_UNCORR_ERR_STATUS",  .addr = A_ECCR0_UNCORR_ERR_STATUS,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_UNCORR_ERR_ADD_LO",  .addr = A_ECCR0_UNCORR_ERR_ADD_LO,
    },{ .name = "ECCR0_UNCORR_ERR_ADD_HI",  .addr = A_ECCR0_UNCORR_ERR_ADD_HI,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_UNCORR_ERR_DATA_LO",  .addr = A_ECCR0_UNCORR_ERR_DATA_LO,
    },{ .name = "ECCR0_UNCORR_ERR_DATA_HI",  .addr = A_ECCR0_UNCORR_ERR_DATA_HI,
    },{ .name = "ECCR0_UNCORR_ERR_DATA_PAR",
        .addr = A_ECCR0_UNCORR_ERR_DATA_PAR,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR0_PARITY_FLIP_2NA",  .addr = A_ECCR0_PARITY_FLIP_2NA,
    },{ .name = "ECCR0_PARITY_FLIP_2ECCR",  .addr = A_ECCR0_PARITY_FLIP_2ECCR,
    },{ .name = "ECCR1_CORR_ERR_STATUS",  .addr = A_ECCR1_CORR_ERR_STATUS,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR1_CORR_ERR_ADD_LO",  .addr = A_ECCR1_CORR_ERR_ADD_LO,
    },{ .name = "ECCR1_CORR_ERR_ADD_HI",  .addr = A_ECCR1_CORR_ERR_ADD_HI,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR1_CORR_ERR_DATA_LO",  .addr = A_ECCR1_CORR_ERR_DATA_LO,
    },{ .name = "ECCR1_CORR_ERR_DATA_HI",  .addr = A_ECCR1_CORR_ERR_DATA_HI,
    },{ .name = "ECCR1_CORR_ERR_DATA_PAR",  .addr = A_ECCR1_CORR_ERR_DATA_PAR,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR1_UNCORR_ERR_STATUS",  .addr = A_ECCR1_UNCORR_ERR_STATUS,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR1_UNCORR_ERR_ADD_LO",  .addr = A_ECCR1_UNCORR_ERR_ADD_LO,
    },{ .name = "ECCR1_UNCORR_ERR_ADD_HI",  .addr = A_ECCR1_UNCORR_ERR_ADD_HI,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR1_UNCORR_ERR_DATA_LO",  .addr = A_ECCR1_UNCORR_ERR_DATA_LO,
    },{ .name = "ECCR1_UNCORR_ERR_DATA_HI",  .addr = A_ECCR1_UNCORR_ERR_DATA_HI,
    },{ .name = "ECCR1_UNCORR_ERR_DATA_PAR",
        .addr = A_ECCR1_UNCORR_ERR_DATA_PAR,
        .rsvd = 0xffffff00,
    },{ .name = "ECCR1_PARITY_FLIP_2NA",  .addr = A_ECCR1_PARITY_FLIP_2NA,
    },{ .name = "ECCR1_PARITY_FLIP_2ECCR",  .addr = A_ECCR1_PARITY_FLIP_2ECCR,
    },{ .name = "CPLX_STATUS",  .addr = A_CPLX_STATUS,
        .rsvd = 0xfffffff8,
        .reset = R_CPLX_STATUS_DONE_MASK,
    },{ .name = "PRBS_STATUS",  .addr = A_PRBS_STATUS,
        .rsvd = 0xfffffff8,
        .reset = R_PRBS_STATUS_DONE_MASK,
    },{ .name = "PRBS_START",  .addr = A_PRBS_START,
        .rsvd = 0xfffffffe,
    },{ .name = "XPI_LP4_CA_CAL_MODE",  .addr = A_XPI_LP4_CA_CAL_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "XPI_LP4_WRITE_NIB_MASK",  .addr = A_XPI_LP4_WRITE_NIB_MASK,
        .rsvd = 0xf8000000,
    },{ .name = "XPI_LP4_READ_NIB_MASK",  .addr = A_XPI_LP4_READ_NIB_MASK,
        .rsvd = 0xf8000000,
    },{ .name = "XPI_MAP_BITSLIP",  .addr = A_XPI_MAP_BITSLIP,
        .rsvd = 0xffffc000,
    },{ .name = "SEQ_SIDE_CNTRL0",  .addr = A_SEQ_SIDE_CNTRL0,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL1",  .addr = A_SEQ_SIDE_CNTRL1,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL2",  .addr = A_SEQ_SIDE_CNTRL2,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL3",  .addr = A_SEQ_SIDE_CNTRL3,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL4",  .addr = A_SEQ_SIDE_CNTRL4,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL5",  .addr = A_SEQ_SIDE_CNTRL5,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL6",  .addr = A_SEQ_SIDE_CNTRL6,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL7",  .addr = A_SEQ_SIDE_CNTRL7,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL8",  .addr = A_SEQ_SIDE_CNTRL8,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL9",  .addr = A_SEQ_SIDE_CNTRL9,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL10",  .addr = A_SEQ_SIDE_CNTRL10,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL11",  .addr = A_SEQ_SIDE_CNTRL11,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL12",  .addr = A_SEQ_SIDE_CNTRL12,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL13",  .addr = A_SEQ_SIDE_CNTRL13,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL14",  .addr = A_SEQ_SIDE_CNTRL14,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_SIDE_CNTRL15",  .addr = A_SEQ_SIDE_CNTRL15,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_STATUS",  .addr = A_SEQ_STATUS,
        .rsvd = 0xfffffffc,
        .reset = R_SEQ_STATUS_DONE_MASK,
    },{ .name = "PAR_ERR_INJ_ECCR",  .addr = A_PAR_ERR_INJ_ECCR,
        .rsvd = 0xfffffc00,
    },{ .name = "PAR_ERR_INJ_DBUF",  .addr = A_PAR_ERR_INJ_DBUF,
    },{ .name = "MRS_CH0_NIBBLE0",  .addr = A_MRS_CH0_NIBBLE0,
    },{ .name = "MRS_CH0_NIBBLE1",  .addr = A_MRS_CH0_NIBBLE1,
    },{ .name = "MRS_CH0_NIBBLE2",  .addr = A_MRS_CH0_NIBBLE2,
    },{ .name = "MRS_CH0_NIBBLE3",  .addr = A_MRS_CH0_NIBBLE3,
    },{ .name = "MRS_CH0_NIBBLE4",  .addr = A_MRS_CH0_NIBBLE4,
    },{ .name = "MRS_CH0_NIBBLE5",  .addr = A_MRS_CH0_NIBBLE5,
    },{ .name = "MRS_CH0_NIBBLE6",  .addr = A_MRS_CH0_NIBBLE6,
    },{ .name = "MRS_CH0_NIBBLE7",  .addr = A_MRS_CH0_NIBBLE7,
    },{ .name = "MRS_CH0_NIBBLE8",  .addr = A_MRS_CH0_NIBBLE8,
    },{ .name = "MRS_CH0_NIBBLE9",  .addr = A_MRS_CH0_NIBBLE9,
    },{ .name = "MRS_CH0_NIBBLE10",  .addr = A_MRS_CH0_NIBBLE10,
    },{ .name = "MRS_CH0_NIBBLE11",  .addr = A_MRS_CH0_NIBBLE11,
    },{ .name = "MRS_CH0_NIBBLE12",  .addr = A_MRS_CH0_NIBBLE12,
    },{ .name = "MRS_CH0_NIBBLE13",  .addr = A_MRS_CH0_NIBBLE13,
    },{ .name = "MRS_CH0_NIBBLE14",  .addr = A_MRS_CH0_NIBBLE14,
    },{ .name = "MRS_CH0_NIBBLE15",  .addr = A_MRS_CH0_NIBBLE15,
    },{ .name = "MRS_CH0_NIBBLE16",  .addr = A_MRS_CH0_NIBBLE16,
    },{ .name = "MRS_CH0_NIBBLE17",  .addr = A_MRS_CH0_NIBBLE17,
    },{ .name = "MRS_CH1_NIBBLE0",  .addr = A_MRS_CH1_NIBBLE0,
    },{ .name = "MRS_CH1_NIBBLE1",  .addr = A_MRS_CH1_NIBBLE1,
    },{ .name = "MRS_CH1_NIBBLE2",  .addr = A_MRS_CH1_NIBBLE2,
    },{ .name = "MRS_CH1_NIBBLE3",  .addr = A_MRS_CH1_NIBBLE3,
    },{ .name = "MRS_CH1_NIBBLE4",  .addr = A_MRS_CH1_NIBBLE4,
    },{ .name = "MRS_CH1_NIBBLE5",  .addr = A_MRS_CH1_NIBBLE5,
    },{ .name = "MRS_CH1_NIBBLE6",  .addr = A_MRS_CH1_NIBBLE6,
    },{ .name = "MRS_CH1_NIBBLE7",  .addr = A_MRS_CH1_NIBBLE7,
    },{ .name = "MRS_CH1_NIBBLE8",  .addr = A_MRS_CH1_NIBBLE8,
    },{ .name = "MRS_CH1_NIBBLE9",  .addr = A_MRS_CH1_NIBBLE9,
    },{ .name = "MRS_CH1_NIBBLE10",  .addr = A_MRS_CH1_NIBBLE10,
    },{ .name = "MRS_CH1_NIBBLE11",  .addr = A_MRS_CH1_NIBBLE11,
    },{ .name = "MRS_CH1_NIBBLE12",  .addr = A_MRS_CH1_NIBBLE12,
    },{ .name = "MRS_CH1_NIBBLE13",  .addr = A_MRS_CH1_NIBBLE13,
    },{ .name = "MRS_CH1_NIBBLE14",  .addr = A_MRS_CH1_NIBBLE14,
    },{ .name = "MRS_CH1_NIBBLE15",  .addr = A_MRS_CH1_NIBBLE15,
    },{ .name = "MRS_CH1_NIBBLE16",  .addr = A_MRS_CH1_NIBBLE16,
    },{ .name = "MRS_CH1_NIBBLE17",  .addr = A_MRS_CH1_NIBBLE17,
    },{ .name = "GT_STATUS",  .addr = A_GT_STATUS,
        .rsvd = 0xf8000000,
    },{ .name = "ADD_PAR_ERR_INJ",  .addr = A_ADD_PAR_ERR_INJ,
        .rsvd = 0xffc00000,
    },{ .name = "ILA_CONFIG",  .addr = A_ILA_CONFIG,
        .reset = 0x7f8,
        .rsvd = 0xfffe0000,
    },{ .name = "ILA_STATUS",  .addr = A_ILA_STATUS,
        .rsvd = 0xffe00000,
        .reset = R_ILA_STATUS_DONE_MASK,
    },{ .name = "ILA_CAPTURE_DATA",  .addr = A_ILA_CAPTURE_DATA,
        .rsvd = 0xfffe0000,
    },{ .name = "ILA_CNTRL",  .addr = A_ILA_CNTRL,
        .rsvd = 0xfffffff8,
    },{ .name = "ILA_TRIGGER0",  .addr = A_ILA_TRIGGER0,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER1",  .addr = A_ILA_TRIGGER1,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER2",  .addr = A_ILA_TRIGGER2,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER3",  .addr = A_ILA_TRIGGER3,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER4",  .addr = A_ILA_TRIGGER4,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER5",  .addr = A_ILA_TRIGGER5,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER6",  .addr = A_ILA_TRIGGER6,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER7",  .addr = A_ILA_TRIGGER7,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER8",  .addr = A_ILA_TRIGGER8,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER9",  .addr = A_ILA_TRIGGER9,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER10",  .addr = A_ILA_TRIGGER10,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER11",  .addr = A_ILA_TRIGGER11,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER12",  .addr = A_ILA_TRIGGER12,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER13",  .addr = A_ILA_TRIGGER13,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER14",  .addr = A_ILA_TRIGGER14,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER15",  .addr = A_ILA_TRIGGER15,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER16",  .addr = A_ILA_TRIGGER16,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER17",  .addr = A_ILA_TRIGGER17,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER18",  .addr = A_ILA_TRIGGER18,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER19",  .addr = A_ILA_TRIGGER19,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER20",  .addr = A_ILA_TRIGGER20,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER21",  .addr = A_ILA_TRIGGER21,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER22",  .addr = A_ILA_TRIGGER22,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER23",  .addr = A_ILA_TRIGGER23,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER24",  .addr = A_ILA_TRIGGER24,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER25",  .addr = A_ILA_TRIGGER25,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER26",  .addr = A_ILA_TRIGGER26,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER27",  .addr = A_ILA_TRIGGER27,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER28",  .addr = A_ILA_TRIGGER28,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER29",  .addr = A_ILA_TRIGGER29,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER30",  .addr = A_ILA_TRIGGER30,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER31",  .addr = A_ILA_TRIGGER31,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER32",  .addr = A_ILA_TRIGGER32,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER33",  .addr = A_ILA_TRIGGER33,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER34",  .addr = A_ILA_TRIGGER34,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER35",  .addr = A_ILA_TRIGGER35,
        .reset = 0xffffffff,
    },{ .name = "ILA_TRIGGER36",  .addr = A_ILA_TRIGGER36,
        .reset = 0xff,
        .rsvd = 0xfffffe00,
    },{ .name = "ILA_READ_CNTRL",  .addr = A_ILA_READ_CNTRL,
        .rsvd = 0xffffff00,
    },{ .name = "ILA_READ0",  .addr = A_ILA_READ0,
    },{ .name = "ILA_READ1",  .addr = A_ILA_READ1,
    },{ .name = "ILA_READ2",  .addr = A_ILA_READ2,
    },{ .name = "ILA_READ3",  .addr = A_ILA_READ3,
    },{ .name = "ILA_CROSS_TRIG",  .addr = A_ILA_CROSS_TRIG,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_START",  .addr = A_SEQ_START,
        .rsvd = 0xfffffffe,
    },{ .name = "SEQ_STATUS_CNT",  .addr = A_SEQ_STATUS_CNT,
    },{ .name = "WRITE_DATA_BITSLIP",  .addr = A_WRITE_DATA_BITSLIP,
        .rsvd = 0xfffc0000,
    },{ .name = "FIRST_ERROR_CAPTURE",  .addr = A_FIRST_ERROR_CAPTURE,
        .reset = 0xffff,
        .rsvd = 0xfff00000,
    },{ .name = "BL16_CAPTURE",  .addr = A_BL16_CAPTURE,
        .rsvd = 0xfffffffe,
    },{ .name = "BL16_NIBBLE0",  .addr = A_BL16_NIBBLE0,
    },{ .name = "BL16_NIBBLE1",  .addr = A_BL16_NIBBLE1,
    },{ .name = "BL16_NIBBLE2",  .addr = A_BL16_NIBBLE2,
    },{ .name = "BL16_NIBBLE3",  .addr = A_BL16_NIBBLE3,
    },{ .name = "BL16_NIBBLE4",  .addr = A_BL16_NIBBLE4,
    },{ .name = "BL16_NIBBLE5",  .addr = A_BL16_NIBBLE5,
    },{ .name = "BL16_NIBBLE6",  .addr = A_BL16_NIBBLE6,
    },{ .name = "BL16_NIBBLE7",  .addr = A_BL16_NIBBLE7,
    },{ .name = "BL16_NIBBLE8",  .addr = A_BL16_NIBBLE8,
    },{ .name = "BL16_NIBBLE9",  .addr = A_BL16_NIBBLE9,
    },{ .name = "BL16_NIBBLE10",  .addr = A_BL16_NIBBLE10,
    },{ .name = "BL16_NIBBLE11",  .addr = A_BL16_NIBBLE11,
    },{ .name = "BL16_NIBBLE12",  .addr = A_BL16_NIBBLE12,
    },{ .name = "BL16_NIBBLE13",  .addr = A_BL16_NIBBLE13,
    },{ .name = "BL16_NIBBLE14",  .addr = A_BL16_NIBBLE14,
    },{ .name = "BL16_NIBBLE15",  .addr = A_BL16_NIBBLE15,
    },{ .name = "BL16_NIBBLE16",  .addr = A_BL16_NIBBLE16,
    },{ .name = "BL16_NIBBLE17",  .addr = A_BL16_NIBBLE17,
    },{ .name = "ERROR_CNT_NIBBLE0",  .addr = A_ERROR_CNT_NIBBLE0,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE1",  .addr = A_ERROR_CNT_NIBBLE1,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE2",  .addr = A_ERROR_CNT_NIBBLE2,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE3",  .addr = A_ERROR_CNT_NIBBLE3,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE4",  .addr = A_ERROR_CNT_NIBBLE4,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE5",  .addr = A_ERROR_CNT_NIBBLE5,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE6",  .addr = A_ERROR_CNT_NIBBLE6,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE7",  .addr = A_ERROR_CNT_NIBBLE7,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE8",  .addr = A_ERROR_CNT_NIBBLE8,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE9",  .addr = A_ERROR_CNT_NIBBLE9,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE10",  .addr = A_ERROR_CNT_NIBBLE10,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE11",  .addr = A_ERROR_CNT_NIBBLE11,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE12",  .addr = A_ERROR_CNT_NIBBLE12,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE13",  .addr = A_ERROR_CNT_NIBBLE13,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE14",  .addr = A_ERROR_CNT_NIBBLE14,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE15",  .addr = A_ERROR_CNT_NIBBLE15,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE16",  .addr = A_ERROR_CNT_NIBBLE16,
        .rsvd = 0xffff0000,
    },{ .name = "ERROR_CNT_NIBBLE17",  .addr = A_ERROR_CNT_NIBBLE17,
        .rsvd = 0xffff0000,
    },{ .name = "DC_PAR_ERR_EN",  .addr = A_DC_PAR_ERR_EN,
        .reset = 0xaaffff,
        .rsvd = 0xff550000,
        .ro = 0x550000,
    },{ .name = "DC_ADD_PAR_ERR_LOG0_0",  .addr = A_DC_ADD_PAR_ERR_LOG0_0,
    },{ .name = "DC_ADD_PAR_ERR_LOG1_0",  .addr = A_DC_ADD_PAR_ERR_LOG1_0,
    },{ .name = "DC_ADD_PAR_ERR_LOG0_1",  .addr = A_DC_ADD_PAR_ERR_LOG0_1,
    },{ .name = "DC_ADD_PAR_ERR_LOG1_1",  .addr = A_DC_ADD_PAR_ERR_LOG1_1,
    },{ .name = "DC_DBUF_DATA_PAR_ERR_LOG0_0",
        .addr = A_DC_DBUF_DATA_PAR_ERR_LOG0_0,
    },{ .name = "DC_DBUF_DATA_PAR_ERR_LOG1_0",
        .addr = A_DC_DBUF_DATA_PAR_ERR_LOG1_0,
    },{ .name = "DC_DBUF_DATA_PAR_ERR_LOG0_1",
        .addr = A_DC_DBUF_DATA_PAR_ERR_LOG0_1,
    },{ .name = "DC_DBUF_DATA_PAR_ERR_LOG1_1",
        .addr = A_DC_DBUF_DATA_PAR_ERR_LOG1_1,
    },{ .name = "DC_ECCW_DATA_PAR_ERR_LOG0_0",
        .addr = A_DC_ECCW_DATA_PAR_ERR_LOG0_0,
    },{ .name = "DC_ECCW_DATA_PAR_ERR_LOG0_1",
        .addr = A_DC_ECCW_DATA_PAR_ERR_LOG0_1,
    },{ .name = "DC_ECCR_DATA_PAR_ERR_LOG0_0",
        .addr = A_DC_ECCR_DATA_PAR_ERR_LOG0_0,
    },{ .name = "DC_ECCR_DATA_PAR_ERR_LOG0_1",
        .addr = A_DC_ECCR_DATA_PAR_ERR_LOG0_1,
    },{ .name = "DC0_PERF_MON",  .addr = A_DC0_PERF_MON,
        .reset = 0x3e,
        .rsvd = 0xfffc0000,
    },{ .name = "DC0_PERF_MON_0",  .addr = A_DC0_PERF_MON_0,
    },{ .name = "DC0_PERF_MON_1",  .addr = A_DC0_PERF_MON_1,
    },{ .name = "DC0_PERF_MON_2",  .addr = A_DC0_PERF_MON_2,
    },{ .name = "DC0_PERF_MON_3",  .addr = A_DC0_PERF_MON_3,
    },{ .name = "DC0_PERF_MON_4",  .addr = A_DC0_PERF_MON_4,
    },{ .name = "DC0_PERF_MON_5",  .addr = A_DC0_PERF_MON_5,
    },{ .name = "DC0_PERF_MON_6",  .addr = A_DC0_PERF_MON_6,
    },{ .name = "DC0_PERF_MON_7",  .addr = A_DC0_PERF_MON_7,
    },{ .name = "DC0_PERF_MON_8",  .addr = A_DC0_PERF_MON_8,
    },{ .name = "DC1_PERF_MON",  .addr = A_DC1_PERF_MON,
        .reset = 0x3e,
        .rsvd = 0xfffc0000,
    },{ .name = "DC1_PERF_MON_0",  .addr = A_DC1_PERF_MON_0,
    },{ .name = "DC1_PERF_MON_1",  .addr = A_DC1_PERF_MON_1,
    },{ .name = "DC1_PERF_MON_2",  .addr = A_DC1_PERF_MON_2,
    },{ .name = "DC1_PERF_MON_3",  .addr = A_DC1_PERF_MON_3,
    },{ .name = "DC1_PERF_MON_4",  .addr = A_DC1_PERF_MON_4,
    },{ .name = "DC1_PERF_MON_5",  .addr = A_DC1_PERF_MON_5,
    },{ .name = "DC1_PERF_MON_6",  .addr = A_DC1_PERF_MON_6,
    },{ .name = "DC1_PERF_MON_7",  .addr = A_DC1_PERF_MON_7,
    },{ .name = "DC1_PERF_MON_8",  .addr = A_DC1_PERF_MON_8,
    },{ .name = "COMPARE_GT_STATUS0_STABLE",
        .addr = A_COMPARE_GT_STATUS0_STABLE,
        .rsvd = 0xfc000000,
    },{ .name = "COMPARE_GT_STATUS1_STABLE",
        .addr = A_COMPARE_GT_STATUS1_STABLE,
        .rsvd = 0xfc000000,
    },{ .name = "FIRST_ERROR_CAPTURE_ADDR",  .addr = A_FIRST_ERROR_CAPTURE_ADDR,
    },{ .name = "ILA_MUX_D_0_0",  .addr = A_ILA_MUX_D_0_0,
    },{ .name = "ILA_MUX_D_0_1",  .addr = A_ILA_MUX_D_0_1,
    },{ .name = "ILA_MUX_D_0_2",  .addr = A_ILA_MUX_D_0_2,
    },{ .name = "ILA_MUX_D_0_3",  .addr = A_ILA_MUX_D_0_3,
    },{ .name = "ILA_MUX_D_0_4",  .addr = A_ILA_MUX_D_0_4,
    },{ .name = "ILA_MUX_D_0_5",  .addr = A_ILA_MUX_D_0_5,
    },{ .name = "ILA_MUX_D_0_6",  .addr = A_ILA_MUX_D_0_6,
    },{ .name = "ILA_MUX_D_0_7",  .addr = A_ILA_MUX_D_0_7,
    },{ .name = "ILA_MUX_D_0_8",  .addr = A_ILA_MUX_D_0_8,
    },{ .name = "ILA_MUX_D_0_9",  .addr = A_ILA_MUX_D_0_9,
    },{ .name = "ILA_MUX_D_0_10",  .addr = A_ILA_MUX_D_0_10,
    },{ .name = "ILA_MUX_D_0_11",  .addr = A_ILA_MUX_D_0_11,
    },{ .name = "ILA_MUX_D_0_12",  .addr = A_ILA_MUX_D_0_12,
    },{ .name = "ILA_MUX_D_0_13",  .addr = A_ILA_MUX_D_0_13,
    },{ .name = "ILA_MUX_D_0_14",  .addr = A_ILA_MUX_D_0_14,
    },{ .name = "ILA_MUX_D_0_15",  .addr = A_ILA_MUX_D_0_15,
    },{ .name = "ILA_MUX_D_0_16",  .addr = A_ILA_MUX_D_0_16,
    },{ .name = "ILA_MUX_D_0_17",  .addr = A_ILA_MUX_D_0_17,
    },{ .name = "ILA_MUX_D_1_0",  .addr = A_ILA_MUX_D_1_0,
    },{ .name = "ILA_MUX_D_1_1",  .addr = A_ILA_MUX_D_1_1,
    },{ .name = "ILA_MUX_D_1_2",  .addr = A_ILA_MUX_D_1_2,
    },{ .name = "ILA_MUX_D_1_3",  .addr = A_ILA_MUX_D_1_3,
    },{ .name = "ILA_MUX_D_1_4",  .addr = A_ILA_MUX_D_1_4,
    },{ .name = "ILA_MUX_D_1_5",  .addr = A_ILA_MUX_D_1_5,
    },{ .name = "ILA_MUX_D_1_6",  .addr = A_ILA_MUX_D_1_6,
    },{ .name = "ILA_MUX_D_1_7",  .addr = A_ILA_MUX_D_1_7,
    },{ .name = "ILA_MUX_D_1_8",  .addr = A_ILA_MUX_D_1_8,
    },{ .name = "ILA_MUX_D_1_9",  .addr = A_ILA_MUX_D_1_9,
    },{ .name = "ILA_MUX_D_1_10",  .addr = A_ILA_MUX_D_1_10,
    },{ .name = "ILA_MUX_D_1_11",  .addr = A_ILA_MUX_D_1_11,
    },{ .name = "ILA_MUX_D_1_12",  .addr = A_ILA_MUX_D_1_12,
    },{ .name = "ILA_MUX_D_1_13",  .addr = A_ILA_MUX_D_1_13,
    },{ .name = "ILA_MUX_D_1_14",  .addr = A_ILA_MUX_D_1_14,
    },{ .name = "ILA_MUX_D_1_15",  .addr = A_ILA_MUX_D_1_15,
    },{ .name = "ILA_MUX_D_1_16",  .addr = A_ILA_MUX_D_1_16,
    },{ .name = "ILA_MUX_MISC",  .addr = A_ILA_MUX_MISC,
        .rsvd = 0xfffffffc,
    },{ .name = "NOCDBG",  .addr = A_NOCDBG,
        .rsvd = 0xffffffc0,
    },{ .name = "DDRMC_CLK_CNT",  .addr = A_DDRMC_CLK_CNT,
    },{ .name = "DDRMC_CLK_CNT_STATUS",  .addr = A_DDRMC_CLK_CNT_STATUS,
    },{ .name = "PHY_RANK_WRITE_OVERRIDE_DYN",
        .addr = A_PHY_RANK_WRITE_OVERRIDE_DYN,
        .reset = 0x14000,
        .rsvd = 0xfff80000,
    },{ .name = "OSCI_READ_MR18_CH0_RANK0_0",
        .addr = A_OSCI_READ_MR18_CH0_RANK0_0,
    },{ .name = "OSCI_READ_MR18_CH0_RANK0_1",
        .addr = A_OSCI_READ_MR18_CH0_RANK0_1,
    },{ .name = "OSCI_READ_MR18_CH0_RANK0_2",
        .addr = A_OSCI_READ_MR18_CH0_RANK0_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR18_CH0_RANK1_0",
        .addr = A_OSCI_READ_MR18_CH0_RANK1_0,
    },{ .name = "OSCI_READ_MR18_CH0_RANK1_1",
        .addr = A_OSCI_READ_MR18_CH0_RANK1_1,
    },{ .name = "OSCI_READ_MR18_CH0_RANK1_2",
        .addr = A_OSCI_READ_MR18_CH0_RANK1_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR18_CH1_RANK0_0",
        .addr = A_OSCI_READ_MR18_CH1_RANK0_0,
    },{ .name = "OSCI_READ_MR18_CH1_RANK0_1",
        .addr = A_OSCI_READ_MR18_CH1_RANK0_1,
    },{ .name = "OSCI_READ_MR18_CH1_RANK0_2",
        .addr = A_OSCI_READ_MR18_CH1_RANK0_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR18_CH1_RANK1_0",
        .addr = A_OSCI_READ_MR18_CH1_RANK1_0,
    },{ .name = "OSCI_READ_MR18_CH1_RANK1_1",
        .addr = A_OSCI_READ_MR18_CH1_RANK1_1,
    },{ .name = "OSCI_READ_MR18_CH1_RANK1_2",
        .addr = A_OSCI_READ_MR18_CH1_RANK1_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR19_CH0_RANK0_0",
        .addr = A_OSCI_READ_MR19_CH0_RANK0_0,
    },{ .name = "OSCI_READ_MR19_CH0_RANK0_1",
        .addr = A_OSCI_READ_MR19_CH0_RANK0_1,
    },{ .name = "OSCI_READ_MR19_CH0_RANK0_2",
        .addr = A_OSCI_READ_MR19_CH0_RANK0_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR19_CH0_RANK1_0",
        .addr = A_OSCI_READ_MR19_CH0_RANK1_0,
    },{ .name = "OSCI_READ_MR19_CH0_RANK1_1",
        .addr = A_OSCI_READ_MR19_CH0_RANK1_1,
    },{ .name = "OSCI_READ_MR19_CH0_RANK1_2",
        .addr = A_OSCI_READ_MR19_CH0_RANK1_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR19_CH1_RANK0_0",
        .addr = A_OSCI_READ_MR19_CH1_RANK0_0,
    },{ .name = "OSCI_READ_MR19_CH1_RANK0_1",
        .addr = A_OSCI_READ_MR19_CH1_RANK0_1,
    },{ .name = "OSCI_READ_MR19_CH1_RANK0_2",
        .addr = A_OSCI_READ_MR19_CH1_RANK0_2,
        .rsvd = 0xffffff00,
    },{ .name = "OSCI_READ_MR19_CH1_RANK1_0",
        .addr = A_OSCI_READ_MR19_CH1_RANK1_0,
    },{ .name = "OSCI_READ_MR19_CH1_RANK1_1",
        .addr = A_OSCI_READ_MR19_CH1_RANK1_1,
    },{ .name = "OSCI_READ_MR19_CH1_RANK1_2",
        .addr = A_OSCI_READ_MR19_CH1_RANK1_2,
        .rsvd = 0xffffff00,
    },{ .name = "SEQ_3DS",  .addr = A_SEQ_3DS,
        .rsvd = 0xfffffffe,
    }
};

static void ddrmc_main_reset(DeviceState *dev)
{
    DDRMC_MAIN *s = XILINX_DDRMC_MAIN(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static MemTxResult reg_write(void *opaque, hwaddr addr,
                             uint64_t data, unsigned size, MemTxAttrs attrs)
{
    RegisterInfoArray *reg_array = opaque;
    DDRMC_MAIN *s = XILINX_DDRMC_MAIN(reg_array->r[0]->opaque);

    /* Is the register set Locked?  */
    if (ARRAY_FIELD_EX32(s->regs, PCSR_LOCK, STATE) && addr != A_PCSR_LOCK) {
        return MEMTX_ERROR;
    }

    register_write_memory(opaque, addr, data, size);
    return MEMTX_OK;
}

static const MemoryRegionOps ddrmc_main_ops = {
    .read = register_read_memory,
    .write_with_attrs = reg_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void ddrmc_main_init(Object *obj)
{
    DDRMC_MAIN *s = XILINX_DDRMC_MAIN(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_DDRMC_MAIN,
                       DDRMC_MAIN_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), ddrmc_main_regs_info,
                              ARRAY_SIZE(ddrmc_main_regs_info),
                              s->regs_info, s->regs,
                              &ddrmc_main_ops,
                              XILINX_DDRMC_MAIN_ERR_DEBUG,
                              DDRMC_MAIN_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_ddrmc_main = {
    .name = TYPE_XILINX_DDRMC_MAIN,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, DDRMC_MAIN, DDRMC_MAIN_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void ddrmc_main_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = ddrmc_main_reset;
    dc->vmsd = &vmstate_ddrmc_main;
}

static const TypeInfo ddrmc_main_info = {
    .name          = TYPE_XILINX_DDRMC_MAIN,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(DDRMC_MAIN),
    .class_init    = ddrmc_main_class_init,
    .instance_init = ddrmc_main_init,
};

static void ddrmc_main_register_types(void)
{
    type_register_static(&ddrmc_main_info);
}

type_init(ddrmc_main_register_types)
