/*
 * QEMU model of the CPM5_SLCR_SECURE This block holds the TrustZone configuration of varlious master and slave devices in CPM5
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2022-05-02.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_CPM5_SLCR_SECURE_ERR_DEBUG
#define XILINX_CPM5_SLCR_SECURE_ERR_DEBUG 0
#endif

#define TYPE_XILINX_CPM5_SLCR_SECURE "xlnx.cpm5_slcr_secure"

#define XILINX_CPM5_SLCR_SECURE(obj) \
     OBJECT_CHECK(CPM5_SLCR_SECURE, (obj), TYPE_XILINX_CPM5_SLCR_SECURE)

REG32(WPROTS, 0x0)
    FIELD(WPROTS, ACTIVE, 0, 1)
REG32(WPROTP, 0x4)
    FIELD(WPROTP, ACTIVE, 0, 1)
REG32(TZPROT, 0x8)
    FIELD(TZPROT, ACTIVE, 0, 1)
REG32(REG_CTRL, 0xc)
    FIELD(REG_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0x10)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x14)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0x18)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x1c)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(TZ_PCIE0, 0x100)
    FIELD(TZ_PCIE0, ATTRIB_PCIE, 1, 1)
    FIELD(TZ_PCIE0, CFG_MGMT_PCIE, 0, 1)
REG32(TZ_PCIE1, 0x104)
    FIELD(TZ_PCIE1, ATTRIB_PCIE, 1, 1)
    FIELD(TZ_PCIE1, CFG_MGMT_PCIE, 0, 1)
REG32(TZ_DMA0_0, 0x108)
    FIELD(TZ_DMA0_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_5, 11, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_4, 10, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_3, 9, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_2, 8, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_1, 7, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_0, 6, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_CH3_SEC, 5, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_CH2_SEC, 4, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_CH1_SEC, 3, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_CH0_SEC, 2, 1)
    FIELD(TZ_DMA0_0, ATTR_DMA_ENABLE_SECURE, 1, 1)
    FIELD(TZ_DMA0_0, ATTRIB_DMA, 0, 1)
REG32(TZ_DMA0_1, 0x10c)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF15, 31, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF14, 30, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF13, 29, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF12, 28, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF11, 27, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF10, 26, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF9, 25, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF8, 24, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF7, 23, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF6, 22, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF5, 21, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF4, 20, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF3, 19, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF2, 18, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF1, 17, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF0, 16, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF15, 15, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF14, 14, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF13, 13, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF12, 12, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF11, 11, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF10, 10, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF9, 9, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF8, 8, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF7, 7, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF6, 6, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF5, 5, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF4, 4, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF3, 3, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF2, 2, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF1, 1, 1)
    FIELD(TZ_DMA0_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF0, 0, 1)
REG32(TZ_DMA0_2, 0x110)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF15, 31, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF14, 30, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF13, 29, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF12, 28, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF11, 27, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF10, 26, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF9, 25, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF8, 24, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF7, 23, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF6, 22, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF5, 21, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF4, 20, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF3, 19, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF2, 18, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF1, 17, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_VF_PF0, 16, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF15, 15, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF14, 14, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF13, 13, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF12, 12, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF11, 11, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF10, 10, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF9, 9, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF8, 8, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF7, 7, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF6, 6, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF5, 5, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF4, 4, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF3, 3, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF2, 2, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF1, 1, 1)
    FIELD(TZ_DMA0_2, ATTR_DMA_SEC_PF0, 0, 1)
REG32(TZ_DMA1_0, 0x114)
    FIELD(TZ_DMA1_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_5, 11, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_4, 10, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_3, 9, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_2, 8, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_1, 7, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_AXIBAR2PCIEBAR_SEC_0, 6, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_CH3_SEC, 5, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_CH2_SEC, 4, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_CH1_SEC, 3, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_CH0_SEC, 2, 1)
    FIELD(TZ_DMA1_0, ATTR_DMA_ENABLE_SECURE, 1, 1)
    FIELD(TZ_DMA1_0, ATTRIB_DMA, 0, 1)
REG32(TZ_DMA1_1, 0x118)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF15, 31, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF14, 30, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF13, 29, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF12, 28, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF11, 27, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF10, 26, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF9, 25, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF8, 24, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF7, 23, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF6, 22, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF5, 21, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF4, 20, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF3, 19, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF2, 18, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF1, 17, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_VF_PF0, 16, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF15, 15, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF14, 14, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF13, 13, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF12, 12, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF11, 11, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF10, 10, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF9, 9, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF8, 8, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF7, 7, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF6, 6, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF5, 5, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF4, 4, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF3, 3, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF2, 2, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF1, 1, 1)
    FIELD(TZ_DMA1_1, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF0, 0, 1)
REG32(TZ_DMA1_2, 0x11c)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF15, 31, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF14, 30, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF13, 29, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF12, 28, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF11, 27, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF10, 26, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF9, 25, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF8, 24, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF7, 23, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF6, 22, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF5, 21, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF4, 20, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF3, 19, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF2, 18, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF1, 17, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_VF_PF0, 16, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF15, 15, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF14, 14, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF13, 13, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF12, 12, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF11, 11, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF10, 10, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF9, 9, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF8, 8, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF7, 7, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF6, 6, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF5, 5, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF4, 4, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF3, 3, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF2, 2, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF1, 1, 1)
    FIELD(TZ_DMA1_2, ATTR_DMA_SEC_PF0, 0, 1)
REG32(TZ_CPI0, 0x120)
    FIELD(TZ_CPI0, PORT_CFG, 1, 1)
    FIELD(TZ_CPI0, PORT_EN, 0, 1)
REG32(TZ_CPI1, 0x124)
    FIELD(TZ_CPI1, PORT_CFG, 1, 1)
    FIELD(TZ_CPI1, PORT_EN, 0, 1)
REG32(TZ_CRX, 0x128)
    FIELD(TZ_CRX, CFG, 0, 1)
REG32(TZ_SLCR, 0x12c)
    FIELD(TZ_SLCR, CFG, 0, 1)
REG32(TZ_ADDRREMAP, 0x130)
    FIELD(TZ_ADDRREMAP, CFG, 0, 1)
REG32(TZ_MCAP0, 0x140)
    FIELD(TZ_MCAP0, OVERRIDE_VAL, 1, 1)
    FIELD(TZ_MCAP0, OVERRIDE_EN, 0, 1)
REG32(TZ_MCAP1, 0x144)
    FIELD(TZ_MCAP1, OVERRIDE_VAL, 1, 1)
    FIELD(TZ_MCAP1, OVERRIDE_EN, 0, 1)
REG32(PCIE0_SMID_EN, 0x200)
    FIELD(PCIE0_SMID_EN, SELECT_ENABLE, 10, 10)
    FIELD(PCIE0_SMID_EN, BASE, 0, 10)
REG32(PCIE0_SMID_CFG0, 0x204)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_7, 28, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_6, 24, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_5, 20, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_4, 16, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_3, 12, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_2, 8, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_1, 4, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_0, 0, 4)
REG32(PCIE0_SMID_CFG1, 0x208)
    FIELD(PCIE0_SMID_CFG1, BDF_BIT_SEL_9, 4, 4)
    FIELD(PCIE0_SMID_CFG1, BDF_BIT_SEL_8, 0, 4)
REG32(PCIE1_SMID_EN, 0x20c)
    FIELD(PCIE1_SMID_EN, SELECT_ENABLE, 10, 10)
    FIELD(PCIE1_SMID_EN, BASE, 0, 10)
REG32(PCIE1_SMID_CFG0, 0x210)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_7, 28, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_6, 24, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_5, 20, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_4, 16, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_3, 12, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_2, 8, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_1, 4, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_0, 0, 4)
REG32(PCIE1_SMID_CFG1, 0x214)
    FIELD(PCIE1_SMID_CFG1, BDF_BIT_SEL_9, 4, 4)
    FIELD(PCIE1_SMID_CFG1, BDF_BIT_SEL_8, 0, 4)
REG32(PCIE0_FUNC_NUM, 0x218)
    FIELD(PCIE0_FUNC_NUM, EN, 24, 1)
    FIELD(PCIE0_FUNC_NUM, DBG, 12, 12)
    FIELD(PCIE0_FUNC_NUM, PS, 0, 12)
REG32(PCIE1_FUNC_NUM, 0x21c)
    FIELD(PCIE1_FUNC_NUM, EN, 24, 1)
    FIELD(PCIE1_FUNC_NUM, DBG, 12, 12)
    FIELD(PCIE1_FUNC_NUM, PS, 0, 12)
REG32(CMN_SMID, 0x220)
    FIELD(CMN_SMID, BASE, 0, 10)
REG32(OD_MBIST_TRIGGER, 0x420)
    FIELD(OD_MBIST_TRIGGER, CPM5_INT_WRAP_BOT, 18, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_CMN_HNF_1, 17, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_CMN_HNF_0, 16, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_CMN_CXRH_1, 15, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_CMN_CXRH_0, 14, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_PCIE_PSB1_1, 13, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_PCIE_PSB1_0, 12, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_PCIE_1, 11, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_PCIE_PSB0_1, 10, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_PCIE_PSB0_0, 9, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_PCIE_0, 8, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_DMA1_2, 7, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_DMA1_1, 6, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_DMA1_0, 5, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_DMA0_2, 4, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_DMA0_1, 3, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_DMA0_0, 2, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_L2_1, 1, 1)
    FIELD(OD_MBIST_TRIGGER, CPM5_L2_0, 0, 1)
REG32(OD_MBIST_DONE, 0x42c)
    FIELD(OD_MBIST_DONE, CPM5_INT_WRAP_BOT, 18, 1)
    FIELD(OD_MBIST_DONE, CPM5_CMN_HNF_1, 17, 1)
    FIELD(OD_MBIST_DONE, CPM5_CMN_HNF_0, 16, 1)
    FIELD(OD_MBIST_DONE, CPM5_CMN_CXRH_1, 15, 1)
    FIELD(OD_MBIST_DONE, CPM5_CMN_CXRH_0, 14, 1)
    FIELD(OD_MBIST_DONE, CPM5_PCIE_PSB1_1, 13, 1)
    FIELD(OD_MBIST_DONE, CPM5_PCIE_PSB1_0, 12, 1)
    FIELD(OD_MBIST_DONE, CPM5_PCIE_1, 11, 1)
    FIELD(OD_MBIST_DONE, CPM5_PCIE_PSB0_1, 10, 1)
    FIELD(OD_MBIST_DONE, CPM5_PCIE_PSB0_0, 9, 1)
    FIELD(OD_MBIST_DONE, CPM5_PCIE_0, 8, 1)
    FIELD(OD_MBIST_DONE, CPM5_DMA1_2, 7, 1)
    FIELD(OD_MBIST_DONE, CPM5_DMA1_1, 6, 1)
    FIELD(OD_MBIST_DONE, CPM5_DMA1_0, 5, 1)
    FIELD(OD_MBIST_DONE, CPM5_DMA0_2, 4, 1)
    FIELD(OD_MBIST_DONE, CPM5_DMA0_1, 3, 1)
    FIELD(OD_MBIST_DONE, CPM5_DMA0_0, 2, 1)
    FIELD(OD_MBIST_DONE, CPM5_L2_1, 1, 1)
    FIELD(OD_MBIST_DONE, CPM5_L2_0, 0, 1)
REG32(OD_MBIST_PASSOUT, 0x430)
    FIELD(OD_MBIST_PASSOUT, CPM5_INT_WRAP_BOT, 18, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_CMN_HNF_1, 17, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_CMN_HNF_0, 16, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_CMN_CXRH_1, 15, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_CMN_CXRH_0, 14, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_PCIE_PSB1_1, 13, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_PCIE_PSB1_0, 12, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_PCIE_1, 11, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_PCIE_PSB0_1, 10, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_PCIE_PSB0_0, 9, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_PCIE_0, 8, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_DMA1_2, 7, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_DMA1_1, 6, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_DMA1_0, 5, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_DMA0_2, 4, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_DMA0_1, 3, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_DMA0_0, 2, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_L2_1, 1, 1)
    FIELD(OD_MBIST_PASSOUT, CPM5_L2_0, 0, 1)

#define CPM5_SLCR_SECURE_R_MAX (R_OD_MBIST_PASSOUT + 1)

typedef struct CPM5_SLCR_SECURE {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir;

    uint32_t regs[CPM5_SLCR_SECURE_R_MAX];
    RegisterInfo regs_info[CPM5_SLCR_SECURE_R_MAX];
} CPM5_SLCR_SECURE;

static void ir_update_irq(CPM5_SLCR_SECURE *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static void od_mbist_trigger_postw(RegisterInfo *reg, uint64_t val64)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_OD_MBIST_DONE] |= val;
    s->regs[R_OD_MBIST_PASSOUT] |= val;
}

static const RegisterAccessInfo cpm5_slcr_secure_regs_info[] = {
    {   .name = "WPROTS",  .addr = A_WPROTS,
        .reset = 0x1,
    },{ .name = "WPROTP",  .addr = A_WPROTP,
        .reset = 0x1,
    },{ .name = "TZPROT",  .addr = A_TZPROT,
    },{ .name = "REG_CTRL",  .addr = A_REG_CTRL,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_disable_prew,
    },{ .name = "TZ_PCIE0",  .addr = A_TZ_PCIE0,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "TZ_PCIE1",  .addr = A_TZ_PCIE1,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "TZ_DMA0_0",  .addr = A_TZ_DMA0_0,
        .reset = 0xfff,
        .rsvd = 0xfffff000,
        .ro = 0xfffff000,
    },{ .name = "TZ_DMA0_1",  .addr = A_TZ_DMA0_1,
        .reset = 0xffffffff,
    },{ .name = "TZ_DMA0_2",  .addr = A_TZ_DMA0_2,
        .reset = 0xffffffff,
    },{ .name = "TZ_DMA1_0",  .addr = A_TZ_DMA1_0,
        .reset = 0xfff,
        .rsvd = 0xfffff000,
        .ro = 0xfffff000,
    },{ .name = "TZ_DMA1_1",  .addr = A_TZ_DMA1_1,
        .reset = 0xffffffff,
    },{ .name = "TZ_DMA1_2",  .addr = A_TZ_DMA1_2,
        .reset = 0xffffffff,
    },{ .name = "TZ_CPI0",  .addr = A_TZ_CPI0,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "TZ_CPI1",  .addr = A_TZ_CPI1,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "TZ_CRX",  .addr = A_TZ_CRX,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TZ_SLCR",  .addr = A_TZ_SLCR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TZ_ADDRREMAP",  .addr = A_TZ_ADDRREMAP,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TZ_MCAP0",  .addr = A_TZ_MCAP0,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "TZ_MCAP1",  .addr = A_TZ_MCAP1,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "PCIE0_SMID_EN",  .addr = A_PCIE0_SMID_EN,
        .reset = 0xffc00,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "PCIE0_SMID_CFG0",  .addr = A_PCIE0_SMID_CFG0,
        .reset = 0x76543210,
    },{ .name = "PCIE0_SMID_CFG1",  .addr = A_PCIE0_SMID_CFG1,
        .reset = 0x98,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "PCIE1_SMID_EN",  .addr = A_PCIE1_SMID_EN,
        .reset = 0xffc00,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "PCIE1_SMID_CFG0",  .addr = A_PCIE1_SMID_CFG0,
        .reset = 0x76543210,
    },{ .name = "PCIE1_SMID_CFG1",  .addr = A_PCIE1_SMID_CFG1,
        .reset = 0x98,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "PCIE0_FUNC_NUM",  .addr = A_PCIE0_FUNC_NUM,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "PCIE1_FUNC_NUM",  .addr = A_PCIE1_FUNC_NUM,
        .rsvd = 0xfe000000,
        .ro = 0xfe000000,
    },{ .name = "CMN_SMID",  .addr = A_CMN_SMID,
    },{ .name = "OD_MBIST_TRIGGER",  .addr = A_OD_MBIST_TRIGGER,
        .rsvd = 0xfff80000,
        .ro = 0xfff80000,
        .post_write = od_mbist_trigger_postw,
    },{ .name = "OD_MBIST_DONE",  .addr = A_OD_MBIST_DONE,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    },{ .name = "OD_MBIST_PASSOUT",  .addr = A_OD_MBIST_PASSOUT,
        .rsvd = 0xfff80000,
        .ro = 0xffffffff,
    }
};

static void cpm5_slcr_secure_reset_enter(Object *obj, ResetType type)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void cpm5_slcr_secure_reset_hold(Object *obj)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(obj);

    ir_update_irq(s);
}

static const MemoryRegionOps cpm5_slcr_secure_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void cpm5_slcr_secure_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void cpm5_slcr_secure_init(Object *obj)
{
    CPM5_SLCR_SECURE *s = XILINX_CPM5_SLCR_SECURE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_CPM5_SLCR_SECURE, CPM5_SLCR_SECURE_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), cpm5_slcr_secure_regs_info,
                              ARRAY_SIZE(cpm5_slcr_secure_regs_info),
                              s->regs_info, s->regs,
                              &cpm5_slcr_secure_ops,
                              XILINX_CPM5_SLCR_SECURE_ERR_DEBUG,
                              CPM5_SLCR_SECURE_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir);
}

static const VMStateDescription vmstate_cpm5_slcr_secure = {
    .name = TYPE_XILINX_CPM5_SLCR_SECURE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, CPM5_SLCR_SECURE, CPM5_SLCR_SECURE_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void cpm5_slcr_secure_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = cpm5_slcr_secure_realize;
    dc->vmsd = &vmstate_cpm5_slcr_secure;
    rc->phases.enter = cpm5_slcr_secure_reset_enter;
    rc->phases.hold = cpm5_slcr_secure_reset_hold;
}

static const TypeInfo cpm5_slcr_secure_info = {
    .name          = TYPE_XILINX_CPM5_SLCR_SECURE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(CPM5_SLCR_SECURE),
    .class_init    = cpm5_slcr_secure_class_init,
    .instance_init = cpm5_slcr_secure_init,
};

static void cpm5_slcr_secure_register_types(void)
{
    type_register_static(&cpm5_slcr_secure_info);
}

type_init(cpm5_slcr_secure_register_types)
