
% SPDX-License-Identifier: CC-BY-SA-4.0

# Software Communications Architecture 4.1 [Full] Appliation Environment Profile


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the Software Communications Architecture 4.1 [Full] Appliation Environment Profile standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  255 |
|    ENOSYS   |   0  |
|Not supported|   0  |

## ``<arpa/inet.h>``

The following methods and variables in ``<arpa/inet.h>``
are supported:

* ``htonl()``
* ``htons()``
* ``ntohl()``
* ``ntohs()``

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``isblank()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<dirent.h>``

The following methods and variables in ``<dirent.h>``
are supported:

* ``closedir()``
* ``opendir()``
* ``readdir()``
* ``readdir_r()``
* ``rewinddir()``

## ``<errno.h>``

The following methods and variables in ``<errno.h>``
are supported:

* ``errno``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``creat()``
* ``open()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``acosh()``
* ``asin()``
* ``asinh()``
* ``atan()``
* ``atan2()``
* ``atanh()``
* ``ceil()``
* ``cos()``
* ``cosh()``
* ``exp()``
* ``exp2()``
* ``fabs()``
* ``floor()``
* ``fmod()``
* ``frexp()``
* ``ldexp()``
* ``log()``
* ``log10()``
* ``log2()``
* ``modf()``
* ``pow()``
* ``round()``
* ``sin()``
* ``sinh()``
* ``sqrt()``
* ``tan()``
* ``tanh()``
* ``trunc()``

## ``<mqueue.h>``

The following methods and variables in ``<mqueue.h>``
are supported:

* ``mq_close()``
* ``mq_getattr()``
* ``mq_notify()``
* ``mq_open()``
* ``mq_receive()``
* ``mq_send()``
* ``mq_setattr()``
* ``mq_unlink()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getdetachstate()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setinheritsched()``
* ``pthread_cancel()``
* ``pthread_cleanup_pop()``
* ``pthread_cleanup_push()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_timedwait()``
* ``pthread_cond_wait()``
* ``pthread_condattr_destroy()``
* ``pthread_condattr_init()``
* ``pthread_create()``
* ``pthread_detach()``
* ``pthread_equal()``
* ``pthread_exit()``
* ``pthread_getschedparam()``
* ``pthread_getspecific()``
* ``pthread_join()``
* ``pthread_key_create()``
* ``pthread_key_delete()``
* ``pthread_mutex_destroy()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_trylock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_getpshared()``
* ``pthread_mutexattr_init()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_settype()``
* ``pthread_once()``
* ``pthread_self()``
* ``pthread_setcancelstate()``
* ``pthread_setcanceltype()``
* ``pthread_setschedparam()``
* ``pthread_setspecific()``
* ``pthread_testcancel()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_close()``
* ``sem_destroy()``
* ``sem_getvalue()``
* ``sem_init()``
* ``sem_open()``
* ``sem_post()``
* ``sem_timedwait()``
* ``sem_trywait()``
* ``sem_unlink()``
* ``sem_wait()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``kill()``
* ``pthread_kill()``
* ``pthread_sigmask()``
* ``raise()``
* ``sigaction()``
* ``sigaddset()``
* ``sigdelset()``
* ``sigemptyset()``
* ``sigfillset()``
* ``sigismember()``
* ``signal()``
* ``sigpending()``
* ``sigprocmask()``
* ``sigsuspend()``
* ``sigwait()``

## ``<stdarg.h>``

The following methods and variables in ``<stdarg.h>``
are supported:

* ``va_arg()``
* ``va_copy()``
* ``va_end()``
* ``va_start()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``fclose()``
* ``fdopen()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgets()``
* ``fileno()``
* ``fopen()``
* ``fprintf()``
* ``fputc()``
* ``fputs()``
* ``fread()``
* ``freopen()``
* ``fscanf()``
* ``fseek()``
* ``fseeko()``
* ``ftell()``
* ``ftello()``
* ``fwrite()``
* ``getc()``
* ``getchar()``
* ``perror()``
* ``printf()``
* ``putc()``
* ``putchar()``
* ``remove()``
* ``rename()``
* ``rewind()``
* ``setbuf()``
* ``setvbuf()``
* ``snprintf()``
* ``sscanf()``
* ``ungetc()``
* ``vsnprintf()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``abort()``
* ``abs()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``bsearch()``
* ``calloc()``
* ``free()``
* ``labs()``
* ``malloc()``
* ``qsort()``
* ``rand()``
* ``rand_r()``
* ``realloc()``
* ``srand()``
* ``strtod()``
* ``strtol()``
* ``strtoul()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strchr()``
* ``strcmp()``
* ``strcoll()``
* ``strcspn()``
* ``strerror()``
* ``strerror_r()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``
* ``strtok_r()``
* ``strxfrm()``

## ``<sys/select.h>``

The following methods and variables in ``<sys/select.h>``
are supported:

* ``select()``

## ``<sys/socket.h>``

The following methods and variables in ``<sys/socket.h>``
are supported:

* ``accept()``
* ``bind()``
* ``connect()``
* ``getsockopt()``
* ``listen()``
* ``recv()``
* ``recvfrom()``
* ``send()``
* ``sendto()``
* ``setsockopt()``
* ``socket()``

## ``<sys/stat.h>``

The following methods and variables in ``<sys/stat.h>``
are supported:

* ``fstat()``
* ``mkdir()``
* ``stat()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime_r()``
* ``clock_getres()``
* ``clock_gettime()``
* ``clock_settime()``
* ``ctime_r()``
* ``gmtime()``
* ``gmtime_r()``
* ``localtime()``
* ``localtime_r()``
* ``nanosleep()``
* ``strftime()``
* ``time()``
* ``timer_create()``
* ``timer_delete()``
* ``timer_getoverrun()``
* ``timer_gettime()``
* ``timer_settime()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``access()``
* ``chdir()``
* ``close()``
* ``fpathconf()``
* ``getcwd()``
* ``link()``
* ``lseek()``
* ``pathconf()``
* ``pause()``
* ``read()``
* ``rmdir()``
* ``unlink()``
* ``write()``
