
% SPDX-License-Identifier: CC-BY-SA-4.0

# Software Communications Architecture 4.1 Lightweight Application Environment Profile


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the Software Communications Architecture 4.1 Lightweight Application Environment Profile standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  110 |
|    ENOSYS   |   0  |
|Not supported|   0  |

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``open()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``acosh()``
* ``asin()``
* ``asinh()``
* ``atan()``
* ``atan2()``
* ``atanh()``
* ``ceil()``
* ``cos()``
* ``cosh()``
* ``exp()``
* ``exp2()``
* ``fabs()``
* ``floor()``
* ``fmod()``
* ``frexp()``
* ``ldexp()``
* ``log()``
* ``log10()``
* ``log2()``
* ``modf()``
* ``pow()``
* ``round()``
* ``sin()``
* ``sinh()``
* ``sqrt()``
* ``tan()``
* ``tanh()``
* ``trunc()``

## ``<mqueue.h>``

The following methods and variables in ``<mqueue.h>``
are supported:

* ``mq_open()``
* ``mq_receive()``
* ``mq_send()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setinheritsched()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_wait()``
* ``pthread_create()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_getpshared()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_settype()``
* ``pthread_self()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_getvalue()``
* ``sem_init()``
* ``sem_post()``
* ``sem_wait()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``sscanf()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``abs()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``bsearch()``
* ``calloc()``
* ``free()``
* ``malloc()``
* ``qsort()``
* ``rand()``
* ``realloc()``
* ``srand()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strchr()``
* ``strcmp()``
* ``strcspn()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``clock_getres()``
* ``clock_gettime()``
* ``gmtime()``
* ``localtime()``
* ``strftime()``
* ``time()``
* ``timer_create()``
* ``timer_gettime()``
* ``timer_settime()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``close()``
* ``read()``
* ``write()``
