
% SPDX-License-Identifier: CC-BY-SA-4.0

# Software Communications Architecture 2.2.2 AEP


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the Software Communications Architecture 2.2.2 AEP standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  243 |
|    ENOSYS   |   0  |
|Not supported|   0  |

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<dirent.h>``

The following methods and variables in ``<dirent.h>``
are supported:

* ``closedir()``
* ``opendir()``
* ``readdir()``
* ``readdir_r()``
* ``rewinddir()``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``creat()``
* ``open()``

## ``<locale.h>``

The following methods and variables in ``<locale.h>``
are supported:

* ``setlocale()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``asin()``
* ``atan()``
* ``atan2()``
* ``ceil()``
* ``cos()``
* ``cosh()``
* ``exp()``
* ``fabs()``
* ``floor()``
* ``fmod()``
* ``frexp()``
* ``ldexp()``
* ``log()``
* ``log10()``
* ``modf()``
* ``pow()``
* ``sin()``
* ``sinh()``
* ``sqrt()``
* ``tan()``
* ``tanh()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getdetachstate()``
* ``pthread_attr_getguardsize()``
* ``pthread_attr_getinheritsched()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getschedpolicy()``
* ``pthread_attr_getscope()``
* ``pthread_attr_getstack()``
* ``pthread_attr_getstackaddr()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setdetachstate()``
* ``pthread_attr_setguardsize()``
* ``pthread_attr_setinheritsched()``
* ``pthread_attr_setschedparam()``
* ``pthread_attr_setschedpolicy()``
* ``pthread_attr_setscope()``
* ``pthread_attr_setstack()``
* ``pthread_attr_setstackaddr()``
* ``pthread_attr_setstacksize()``
* ``pthread_cancel()``
* ``pthread_cleanup_pop()``
* ``pthread_cleanup_push()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_timedwait()``
* ``pthread_cond_wait()``
* ``pthread_condattr_destroy()``
* ``pthread_condattr_getclock()``
* ``pthread_condattr_getpshared()``
* ``pthread_condattr_init()``
* ``pthread_condattr_setclock()``
* ``pthread_condattr_setpshared()``
* ``pthread_create()``
* ``pthread_detach()``
* ``pthread_equal()``
* ``pthread_exit()``
* ``pthread_getschedparam()``
* ``pthread_getspecific()``
* ``pthread_join()``
* ``pthread_key_create()``
* ``pthread_key_delete()``
* ``pthread_mutex_destroy()``
* ``pthread_mutex_getprioceiling()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_setprioceiling()``
* ``pthread_mutex_timedlock()``
* ``pthread_mutex_trylock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_destroy()``
* ``pthread_mutexattr_getprioceiling()``
* ``pthread_mutexattr_getprotocol()``
* ``pthread_mutexattr_getpshared()``
* ``pthread_mutexattr_gettype()``
* ``pthread_mutexattr_init()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_setprotocol()``
* ``pthread_mutexattr_setpshared()``
* ``pthread_mutexattr_settype()``
* ``pthread_once()``
* ``pthread_self()``
* ``pthread_setcancelstate()``
* ``pthread_setcanceltype()``
* ``pthread_setschedparam()``
* ``pthread_setspecific()``
* ``pthread_testcancel()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_close()``
* ``sem_destroy()``
* ``sem_getvalue()``
* ``sem_init()``
* ``sem_open()``
* ``sem_post()``
* ``sem_trywait()``
* ``sem_unlink()``
* ``sem_wait()``

## ``<setjmp.h>``

The following methods and variables in ``<setjmp.h>``
are supported:

* ``longjmp()``
* ``setjmp()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``kill()``
* ``pthread_kill()``
* ``pthread_sigmask()``
* ``raise()``
* ``sigaction()``
* ``sigaddset()``
* ``sigdelset()``
* ``sigemptyset()``
* ``sigfillset()``
* ``sigismember()``
* ``signal()``
* ``sigpending()``
* ``sigprocmask()``
* ``sigsuspend()``
* ``sigwait()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``fclose()``
* ``fdopen()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgets()``
* ``fileno()``
* ``fopen()``
* ``fprintf()``
* ``fputc()``
* ``fputs()``
* ``fread()``
* ``freopen()``
* ``fscanf()``
* ``fseek()``
* ``fseeko()``
* ``ftell()``
* ``ftello()``
* ``fwrite()``
* ``getc()``
* ``getchar()``
* ``gets()``
* ``perror()``
* ``printf()``
* ``putc()``
* ``putchar()``
* ``puts()``
* ``remove()``
* ``rename()``
* ``rewind()``
* ``scanf()``
* ``setbuf()``
* ``setvbuf()``
* ``sprintf()``
* ``sscanf()``
* ``tmpfile()``
* ``tmpnam()``
* ``ungetc()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``abort()``
* ``abs()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``bsearch()``
* ``calloc()``
* ``free()``
* ``malloc()``
* ``qsort()``
* ``rand()``
* ``rand_r()``
* ``realloc()``
* ``srand()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``strcat()``
* ``strchr()``
* ``strcmp()``
* ``strcpy()``
* ``strcspn()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``
* ``strtok_r()``

## ``<sys/stat.h>``

The following methods and variables in ``<sys/stat.h>``
are supported:

* ``fstat()``
* ``mkdir()``
* ``stat()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime()``
* ``asctime_r()``
* ``clock_getres()``
* ``clock_gettime()``
* ``clock_settime()``
* ``ctime()``
* ``ctime_r()``
* ``gmtime()``
* ``gmtime_r()``
* ``localtime()``
* ``localtime_r()``
* ``nanosleep()``
* ``strftime()``
* ``time()``
* ``timer_create()``
* ``timer_delete()``
* ``timer_getoverrun()``
* ``timer_gettime()``
* ``timer_settime()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``access()``
* ``chdir()``
* ``close()``
* ``fpathconf()``
* ``getcwd()``
* ``link()``
* ``lseek()``
* ``pathconf()``
* ``pause()``
* ``read()``
* ``rmdir()``
* ``unlink()``
* ``write()``

## ``<utime.h>``

The following methods and variables in ``<utime.h>``
are supported:

* ``utime()``
