
% SPDX-License-Identifier: CC-BY-SA-4.0

# FACE Technical Standard, Edition 3.0 General Purpose


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the FACE Technical Standard, Edition 3.0 General Purpose standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  704 |
|    ENOSYS   |   4  |
|Not supported|   3  |

## ``<aio.h>``

The following methods and variables in ``<aio.h>``
are supported:

* ``aio_cancel()``
* ``aio_error()``
* ``aio_fsync()``
* ``aio_read()``
* ``aio_return()``
* ``aio_write()``
* ``lio_listio()``

The following methods in ``<aio.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``aio_suspend()``

## ``<arpa/inet.h>``

The following methods and variables in ``<arpa/inet.h>``
are supported:

* ``htonl()``
* ``htons()``
* ``inet_addr()``
* ``inet_ntoa()``
* ``inet_ntop()``
* ``inet_pton()``
* ``ntohl()``
* ``ntohs()``

## ``<complex.h>``

The following methods and variables in ``<complex.h>``
are supported:

* ``cabs()``
* ``cabsf()``
* ``cabsl()``
* ``cacos()``
* ``cacosf()``
* ``cacosh()``
* ``cacoshf()``
* ``cacoshl()``
* ``cacosl()``
* ``carg()``
* ``cargf()``
* ``cargl()``
* ``casin()``
* ``casinf()``
* ``casinh()``
* ``casinhf()``
* ``casinhl()``
* ``casinl()``
* ``catan()``
* ``catanf()``
* ``catanh()``
* ``catanhf()``
* ``catanhl()``
* ``catanl()``
* ``ccos()``
* ``ccosf()``
* ``ccosh()``
* ``ccoshf()``
* ``ccoshl()``
* ``ccosl()``
* ``cexp()``
* ``cexpf()``
* ``cexpl()``
* ``cimag()``
* ``cimagf()``
* ``cimagl()``
* ``clog()``
* ``clogf()``
* ``clogl()``
* ``conj()``
* ``conjf()``
* ``conjl()``
* ``cpow()``
* ``cpowf()``
* ``cpowl()``
* ``cproj()``
* ``cprojf()``
* ``cprojl()``
* ``creal()``
* ``crealf()``
* ``creall()``
* ``csin()``
* ``csinf()``
* ``csinh()``
* ``csinhf()``
* ``csinhl()``
* ``csinl()``
* ``csqrt()``
* ``csqrtf()``
* ``csqrtl()``
* ``ctan()``
* ``ctanf()``
* ``ctanh()``
* ``ctanhf()``
* ``ctanhl()``
* ``ctanl()``

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``isblank()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<devctl.h>``

The following methods and variables in ``<devctl.h>``
are supported:

* ``posix_devctl()``

## ``<dirent.h>``

The following methods and variables in ``<dirent.h>``
are supported:

* ``closedir()``
* ``opendir()``
* ``readdir()``
* ``readdir_r()``
* ``rewinddir()``

## ``<errno.h>``

The following methods and variables in ``<errno.h>``
are supported:

* ``errno``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``creat()``
* ``fcntl()``
* ``open()``

## ``<fenv.h>``

The following methods and variables in ``<fenv.h>``
are supported:

* ``feclearexcept()``
* ``fegetenv()``
* ``fegetexceptflag()``
* ``fegetround()``
* ``feholdexcept()``
* ``feraiseexcept()``
* ``fesetenv()``
* ``fesetexceptflag()``
* ``fesetround()``
* ``fetestexcept()``
* ``feupdateenv()``

## ``<inttypes.h>``

The following methods and variables in ``<inttypes.h>``
are supported:

* ``imaxabs()``
* ``imaxdiv()``
* ``strtoimax()``
* ``strtoumax()``
* ``wcstoimax()``
* ``wcstoumax()``

## ``<locale.h>``

The following methods and variables in ``<locale.h>``
are supported:

* ``localeconv()``
* ``setlocale()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``acosf()``
* ``acosh()``
* ``acoshf()``
* ``acoshl()``
* ``acosl()``
* ``asin()``
* ``asinf()``
* ``asinh()``
* ``asinhf()``
* ``asinhl()``
* ``asinl()``
* ``atan()``
* ``atan2()``
* ``atan2f()``
* ``atan2l()``
* ``atanf()``
* ``atanh()``
* ``atanhf()``
* ``atanhl()``
* ``atanl()``
* ``cbrt()``
* ``cbrtf()``
* ``cbrtl()``
* ``ceil()``
* ``ceilf()``
* ``ceill()``
* ``copysign()``
* ``copysignf()``
* ``copysignl()``
* ``cos()``
* ``cosf()``
* ``cosh()``
* ``coshf()``
* ``coshl()``
* ``cosl()``
* ``erf()``
* ``erfc()``
* ``erfcf()``
* ``erfcl()``
* ``erff()``
* ``erfl()``
* ``exp()``
* ``exp2()``
* ``exp2f()``
* ``exp2l()``
* ``expf()``
* ``expl()``
* ``expm1()``
* ``expm1f()``
* ``expm1l()``
* ``fabs()``
* ``fabsf()``
* ``fabsl()``
* ``fdim()``
* ``fdimf()``
* ``fdiml()``
* ``floor()``
* ``floorf()``
* ``floorl()``
* ``fma()``
* ``fmaf()``
* ``fmal()``
* ``fmax()``
* ``fmaxf()``
* ``fmaxl()``
* ``fmin()``
* ``fminf()``
* ``fminl()``
* ``fmod()``
* ``fmodf()``
* ``fmodl()``
* ``fpclassify()``
* ``frexp()``
* ``frexpf()``
* ``frexpl()``
* ``hypot()``
* ``hypotf()``
* ``hypotl()``
* ``ilogb()``
* ``ilogbf()``
* ``ilogbl()``
* ``isfinite()``
* ``isgreater()``
* ``isgreaterequal()``
* ``isinf()``
* ``isless()``
* ``islessequal()``
* ``islessgreater()``
* ``isnan()``
* ``isnormal()``
* ``isunordered()``
* ``ldexp()``
* ``ldexpf()``
* ``ldexpl()``
* ``lgamma()``
* ``lgammaf()``
* ``lgammal()``
* ``llrint()``
* ``llrintf()``
* ``llrintl()``
* ``llround()``
* ``llroundf()``
* ``llroundl()``
* ``log()``
* ``log10()``
* ``log10f()``
* ``log10l()``
* ``log1p()``
* ``log1pf()``
* ``log1pl()``
* ``log2()``
* ``log2f()``
* ``log2l()``
* ``logb()``
* ``logbf()``
* ``logbl()``
* ``logf()``
* ``logl()``
* ``lrint()``
* ``lrintf()``
* ``lrintl()``
* ``lround()``
* ``lroundf()``
* ``lroundl()``
* ``modf()``
* ``modff()``
* ``modfl()``
* ``nan()``
* ``nanf()``
* ``nanl()``
* ``nearbyint()``
* ``nearbyintf()``
* ``nearbyintl()``
* ``nextafter()``
* ``nextafterf()``
* ``nextafterl()``
* ``nexttoward()``
* ``nexttowardf()``
* ``nexttowardl()``
* ``pow()``
* ``powf()``
* ``powl()``
* ``remainder()``
* ``remainderf()``
* ``remainderl()``
* ``remquo()``
* ``remquof()``
* ``remquol()``
* ``rint()``
* ``rintf()``
* ``rintl()``
* ``round()``
* ``roundf()``
* ``roundl()``
* ``scalbln()``
* ``scalblnf()``
* ``scalblnl()``
* ``scalbn()``
* ``scalbnf()``
* ``scalbnl()``
* ``sin()``
* ``sinf()``
* ``sinh()``
* ``sinhf()``
* ``sinhl()``
* ``sinl()``
* ``sqrt()``
* ``sqrtf()``
* ``sqrtl()``
* ``tan()``
* ``tanf()``
* ``tanh()``
* ``tanhf()``
* ``tanhl()``
* ``tanl()``
* ``tgamma()``
* ``tgammaf()``
* ``tgammal()``
* ``trunc()``
* ``truncf()``
* ``truncl()``

The following methods and variables in ``<math.h>``
are not supported:

* ``signbit()``

## ``<mqueue.h>``

The following methods and variables in ``<mqueue.h>``
are supported:

* ``mq_close()``
* ``mq_getattr()``
* ``mq_notify()``
* ``mq_open()``
* ``mq_receive()``
* ``mq_send()``
* ``mq_setattr()``
* ``mq_timedreceive()``
* ``mq_timedsend()``
* ``mq_unlink()``

## ``<net/if.h>``

The following methods and variables in ``<net/if.h>``
are supported:

* ``if_freenameindex()``
* ``if_indextoname()``
* ``if_nameindex()``
* ``if_nametoindex()``

## ``<netdb.h>``

The following methods and variables in ``<netdb.h>``
are supported:

* ``endhostent()``
* ``endnetent()``
* ``endprotoent()``
* ``endservent()``
* ``freeaddrinfo()``
* ``gai_strerror()``
* ``getaddrinfo()``
* ``gethostent()``
* ``getnameinfo()``
* ``getnetbyaddr()``
* ``getnetbyname()``
* ``getnetent()``
* ``getprotobyname()``
* ``getprotobynumber()``
* ``getprotoent()``
* ``getservbyname()``
* ``getservbyport()``
* ``getservent()``
* ``sethostent()``
* ``setnetent()``
* ``setprotoent()``
* ``setservent()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getdetachstate()``
* ``pthread_attr_getguardsize()``
* ``pthread_attr_getinheritsched()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getschedpolicy()``
* ``pthread_attr_getscope()``
* ``pthread_attr_getstack()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setdetachstate()``
* ``pthread_attr_setguardsize()``
* ``pthread_attr_setinheritsched()``
* ``pthread_attr_setschedparam()``
* ``pthread_attr_setschedpolicy()``
* ``pthread_attr_setscope()``
* ``pthread_attr_setstack()``
* ``pthread_attr_setstacksize()``
* ``pthread_barrier_destroy()``
* ``pthread_barrier_init()``
* ``pthread_barrier_wait()``
* ``pthread_barrierattr_destroy()``
* ``pthread_barrierattr_init()``
* ``pthread_cancel()``
* ``pthread_cleanup_pop()``
* ``pthread_cleanup_push()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_timedwait()``
* ``pthread_cond_wait()``
* ``pthread_condattr_destroy()``
* ``pthread_condattr_getclock()``
* ``pthread_condattr_init()``
* ``pthread_condattr_setclock()``
* ``pthread_create()``
* ``pthread_detach()``
* ``pthread_equal()``
* ``pthread_exit()``
* ``pthread_getschedparam()``
* ``pthread_getspecific()``
* ``pthread_join()``
* ``pthread_key_create()``
* ``pthread_key_delete()``
* ``pthread_mutex_destroy()``
* ``pthread_mutex_getprioceiling()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_setprioceiling()``
* ``pthread_mutex_timedlock()``
* ``pthread_mutex_trylock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_destroy()``
* ``pthread_mutexattr_getprioceiling()``
* ``pthread_mutexattr_getprotocol()``
* ``pthread_mutexattr_gettype()``
* ``pthread_mutexattr_init()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_setprotocol()``
* ``pthread_mutexattr_settype()``
* ``pthread_once()``
* ``pthread_rwlock_destroy()``
* ``pthread_rwlock_init()``
* ``pthread_rwlock_rdlock()``
* ``pthread_rwlock_timedrdlock()``
* ``pthread_rwlock_timedwrlock()``
* ``pthread_rwlock_tryrdlock()``
* ``pthread_rwlock_trywrlock()``
* ``pthread_rwlock_unlock()``
* ``pthread_rwlock_wrlock()``
* ``pthread_rwlockattr_destroy()``
* ``pthread_rwlockattr_init()``
* ``pthread_self()``
* ``pthread_setcancelstate()``
* ``pthread_setcanceltype()``
* ``pthread_setschedparam()``
* ``pthread_setschedprio()``
* ``pthread_setspecific()``
* ``pthread_testcancel()``

The following methods in ``<pthread.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``pthread_atfork()``
* ``pthread_getcpuclockid()``

## ``<sched.h>``

The following methods and variables in ``<sched.h>``
are supported:

* ``sched_get_priority_max()``
* ``sched_get_priority_min()``
* ``sched_rr_get_interval()``
* ``sched_yield()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_close()``
* ``sem_destroy()``
* ``sem_getvalue()``
* ``sem_init()``
* ``sem_open()``
* ``sem_post()``
* ``sem_timedwait()``
* ``sem_trywait()``
* ``sem_unlink()``
* ``sem_wait()``

## ``<setjmp.h>``

The following methods and variables in ``<setjmp.h>``
are supported:

* ``longjmp()``
* ``setjmp()``
* ``siglongjmp()``
* ``sigsetjmp()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``kill()``
* ``pthread_kill()``
* ``pthread_sigmask()``
* ``raise()``
* ``sigaction()``
* ``sigaddset()``
* ``sigdelset()``
* ``sigemptyset()``
* ``sigfillset()``
* ``sigismember()``
* ``signal()``
* ``sigpending()``
* ``sigprocmask()``
* ``sigqueue()``
* ``sigsuspend()``
* ``sigtimedwait()``
* ``sigwait()``
* ``sigwaitinfo()``

## ``<stdarg.h>``

The following methods and variables in ``<stdarg.h>``
are supported:

* ``va_arg()``
* ``va_copy()``
* ``va_end()``
* ``va_start()``

## ``<stddef.h>``

The following methods and variables in ``<stddef.h>``
are supported:

* ``offsetof()``

## ``<stdint.h>``

The following methods and variables in ``<stdint.h>``
are supported:

* ``INTMAX_C()``
* ``INTN_C()``
* ``UINTMAX_C()``
* ``UINTN_C()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``fclose()``
* ``fdopen()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgetpos()``
* ``fgets()``
* ``fileno()``
* ``flockfile()``
* ``fopen()``
* ``fprintf()``
* ``fputc()``
* ``fputs()``
* ``fread()``
* ``freopen()``
* ``fscanf()``
* ``fseek()``
* ``fseeko()``
* ``fsetpos()``
* ``ftell()``
* ``ftello()``
* ``ftrylockfile()``
* ``funlockfile()``
* ``fwrite()``
* ``getc()``
* ``getc_unlocked()``
* ``getchar()``
* ``getchar_unlocked()``
* ``perror()``
* ``printf()``
* ``putc()``
* ``putc_unlocked()``
* ``putchar()``
* ``putchar_unlocked()``
* ``puts()``
* ``remove()``
* ``rename()``
* ``rewind()``
* ``scanf()``
* ``setvbuf()``
* ``snprintf()``
* ``sprintf()``
* ``sscanf()``
* ``stderr``
* ``stdin``
* ``stdout``
* ``tmpfile()``
* ``ungetc()``
* ``vfprintf()``
* ``vfscanf()``
* ``vprintf()``
* ``vscanf()``
* ``vsnprintf()``
* ``vsprintf()``
* ``vsscanf()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``abort()``
* ``abs()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``atoll()``
* ``bsearch()``
* ``calloc()``
* ``div()``
* ``free()``
* ``getenv()``
* ``labs()``
* ``ldiv()``
* ``llabs()``
* ``lldiv()``
* ``malloc()``
* ``mblen()``
* ``mbtowc()``
* ``qsort()``
* ``rand()``
* ``rand_r()``
* ``realloc()``
* ``setenv()``
* ``srand()``
* ``strtod()``
* ``strtof()``
* ``strtol()``
* ``strtold()``
* ``strtoll()``
* ``strtoul()``
* ``strtoull()``
* ``unsetenv()``
* ``wcstombs()``
* ``wctomb()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strcat()``
* ``strchr()``
* ``strcmp()``
* ``strcoll()``
* ``strcpy()``
* ``strcspn()``
* ``strerror()``
* ``strerror_r()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``
* ``strtok_r()``
* ``strxfrm()``

## ``<sys/mman.h>``

The following methods and variables in ``<sys/mman.h>``
are supported:

* ``mlockall()``
* ``mmap()``
* ``mprotect()``
* ``munmap()``
* ``shm_open()``
* ``shm_unlink()``

## ``<sys/select.h>``

The following methods and variables in ``<sys/select.h>``
are supported:

* ``FD_CLR()``
* ``FD_ISSET()``
* ``FD_SET()``
* ``FD_ZERO()``
* ``select()``

The following methods and variables in ``<sys/select.h>``
are not supported:

* ``pselect()``

## ``<sys/socket.h>``

The following methods and variables in ``<sys/socket.h>``
are supported:

* ``accept()``
* ``bind()``
* ``connect()``
* ``getpeername()``
* ``getsockname()``
* ``getsockopt()``
* ``listen()``
* ``recv()``
* ``recvfrom()``
* ``recvmsg()``
* ``send()``
* ``sendmsg()``
* ``sendto()``
* ``setsockopt()``
* ``shutdown()``
* ``socket()``
* ``socketpair()``

The following methods and variables in ``<sys/socket.h>``
are not supported:

* ``sockatmark()``

## ``<sys/stat.h>``

The following methods and variables in ``<sys/stat.h>``
are supported:

* ``chmod()``
* ``fchmod()``
* ``fstat()``
* ``lstat()``
* ``mkdir()``
* ``mkfifo()``
* ``stat()``
* ``umask()``

## ``<sys/utsname.h>``

The following methods and variables in ``<sys/utsname.h>``
are supported:

* ``uname()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime_r()``
* ``clock_getres()``
* ``clock_gettime()``
* ``clock_nanosleep()``
* ``clock_settime()``
* ``ctime_r()``
* ``difftime()``
* ``gmtime()``
* ``gmtime_r()``
* ``localtime()``
* ``localtime_r()``
* ``mktime()``
* ``nanosleep()``
* ``strftime()``
* ``time()``
* ``timer_create()``
* ``timer_delete()``
* ``timer_getoverrun()``
* ``timer_gettime()``
* ``timer_settime()``
* ``tzname``
* ``tzset()``

The following methods in ``<time.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``clock_getcpuclockid()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``access()``
* ``alarm()``
* ``chdir()``
* ``chown()``
* ``close()``
* ``dup()``
* ``dup2()``
* ``fchown()``
* ``fdatasync()``
* ``fpathconf()``
* ``fsync()``
* ``ftruncate()``
* ``getcwd()``
* ``getegid()``
* ``geteuid()``
* ``getgid()``
* ``getgroups()``
* ``gethostname()``
* ``getlogin_r()``
* ``getuid()``
* ``link()``
* ``lseek()``
* ``pathconf()``
* ``pause()``
* ``read()``
* ``rmdir()``
* ``setegid()``
* ``seteuid()``
* ``setgid()``
* ``setuid()``
* ``sysconf()``
* ``unlink()``
* ``write()``

## ``<wchar.h>``

The following methods and variables in ``<wchar.h>``
are supported:

* ``btowc()``
* ``fgetwc()``
* ``fgetws()``
* ``fputwc()``
* ``fputws()``
* ``fwide()``
* ``fwprintf()``
* ``fwscanf()``
* ``getwc()``
* ``getwchar()``
* ``mbrlen()``
* ``mbrtowc()``
* ``mbsinit()``
* ``mbsrtowcs()``

## ``<wctype.h>``

The following methods and variables in ``<wctype.h>``
are supported:

* ``iswalnum()``
* ``iswalpha()``
* ``iswblank()``
* ``iswcntrl()``
* ``iswctype()``
* ``iswdigit()``
* ``iswgraph()``
* ``iswlower()``
* ``iswprint()``
* ``iswpunct()``
* ``iswspace()``
* ``iswupper()``
* ``iswxdigit()``
* ``towctrans()``
* ``towlower()``
* ``towupper()``
