
% SPDX-License-Identifier: CC-BY-SA-4.0

# C99 Standard Library


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the C99 Standard Library standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  488 |
|    ENOSYS   |   1  |
|Not supported|   1  |

## ``<assert.h>``

The following methods and variables in ``<assert.h>``
are supported:

* ``assert()``

## ``<complex.h>``

The following methods and variables in ``<complex.h>``
are supported:

* ``cabs()``
* ``cabsf()``
* ``cabsl()``
* ``cacos()``
* ``cacosf()``
* ``cacosh()``
* ``cacoshf()``
* ``cacoshl()``
* ``cacosl()``
* ``carg()``
* ``cargf()``
* ``cargl()``
* ``casin()``
* ``casinf()``
* ``casinh()``
* ``casinhf()``
* ``casinhl()``
* ``casinl()``
* ``catan()``
* ``catanf()``
* ``catanh()``
* ``catanhf()``
* ``catanhl()``
* ``catanl()``
* ``ccos()``
* ``ccosf()``
* ``ccosh()``
* ``ccoshf()``
* ``ccoshl()``
* ``ccosl()``
* ``cexp()``
* ``cexpf()``
* ``cexpl()``
* ``cimag()``
* ``cimagf()``
* ``cimagl()``
* ``clog()``
* ``clogf()``
* ``clogl()``
* ``conj()``
* ``conjf()``
* ``conjl()``
* ``cpow()``
* ``cpowf()``
* ``cpowl()``
* ``cproj()``
* ``cprojf()``
* ``cprojl()``
* ``creal()``
* ``crealf()``
* ``creall()``
* ``csin()``
* ``csinf()``
* ``csinh()``
* ``csinhf()``
* ``csinhl()``
* ``csinl()``
* ``csqrt()``
* ``csqrtf()``
* ``csqrtl()``
* ``ctan()``
* ``ctanf()``
* ``ctanh()``
* ``ctanhf()``
* ``ctanhl()``
* ``ctanl()``

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``isblank()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<errno.h>``

The following methods and variables in ``<errno.h>``
are supported:

* ``errno``

## ``<fenv.h>``

The following methods and variables in ``<fenv.h>``
are supported:

* ``feclearexcept()``
* ``fegetenv()``
* ``fegetexceptflag()``
* ``fegetround()``
* ``feholdexcept()``
* ``feraiseexcept()``
* ``fesetenv()``
* ``fesetexceptflag()``
* ``fesetround()``
* ``fetestexcept()``
* ``feupdateenv()``

## ``<inttypes.h>``

The following methods and variables in ``<inttypes.h>``
are supported:

* ``imaxabs()``
* ``imaxdiv()``
* ``strtoimax()``
* ``strtoumax()``
* ``wcstoimax()``
* ``wcstoumax()``

## ``<locale.h>``

The following methods and variables in ``<locale.h>``
are supported:

* ``localeconv()``
* ``setlocale()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``acosf()``
* ``acosh()``
* ``acoshf()``
* ``acoshl()``
* ``acosl()``
* ``asin()``
* ``asinf()``
* ``asinh()``
* ``asinhf()``
* ``asinhl()``
* ``asinl()``
* ``atan()``
* ``atan2()``
* ``atan2f()``
* ``atan2l()``
* ``atanf()``
* ``atanh()``
* ``atanhf()``
* ``atanhl()``
* ``atanl()``
* ``cbrt()``
* ``cbrtf()``
* ``cbrtl()``
* ``ceil()``
* ``ceilf()``
* ``ceill()``
* ``copysign()``
* ``copysignf()``
* ``copysignl()``
* ``cos()``
* ``cosf()``
* ``cosh()``
* ``coshf()``
* ``coshl()``
* ``cosl()``
* ``erf()``
* ``erfc()``
* ``erfcf()``
* ``erfcl()``
* ``erff()``
* ``erfl()``
* ``exp()``
* ``exp2()``
* ``exp2f()``
* ``exp2l()``
* ``expf()``
* ``expl()``
* ``expm1()``
* ``expm1f()``
* ``expm1l()``
* ``fabs()``
* ``fabsf()``
* ``fabsl()``
* ``fdim()``
* ``fdimf()``
* ``fdiml()``
* ``floor()``
* ``floorf()``
* ``floorl()``
* ``fma()``
* ``fmaf()``
* ``fmal()``
* ``fmax()``
* ``fmaxf()``
* ``fmaxl()``
* ``fmin()``
* ``fminf()``
* ``fminl()``
* ``fmod()``
* ``fmodf()``
* ``fmodl()``
* ``fpclassify()``
* ``frexp()``
* ``frexpf()``
* ``frexpl()``
* ``hypot()``
* ``hypotf()``
* ``hypotl()``
* ``ilogb()``
* ``ilogbf()``
* ``ilogbl()``
* ``isfinite()``
* ``isgreater()``
* ``isgreaterequal()``
* ``isinf()``
* ``isless()``
* ``islessequal()``
* ``islessgreater()``
* ``isnan()``
* ``isnormal()``
* ``isunordered()``
* ``ldexp()``
* ``ldexpf()``
* ``ldexpl()``
* ``lgamma()``
* ``lgammaf()``
* ``lgammal()``
* ``llrint()``
* ``llrintf()``
* ``llrintl()``
* ``llround()``
* ``llroundf()``
* ``llroundl()``
* ``log()``
* ``log10()``
* ``log10f()``
* ``log10l()``
* ``log1p()``
* ``log1pf()``
* ``log1pl()``
* ``log2()``
* ``log2f()``
* ``log2l()``
* ``logb()``
* ``logbf()``
* ``logbl()``
* ``logf()``
* ``logl()``
* ``lrint()``
* ``lrintf()``
* ``lrintl()``
* ``lround()``
* ``lroundf()``
* ``lroundl()``
* ``modf()``
* ``modff()``
* ``modfl()``
* ``nan()``
* ``nanf()``
* ``nanl()``
* ``nearbyint()``
* ``nearbyintf()``
* ``nearbyintl()``
* ``nextafter()``
* ``nextafterf()``
* ``nextafterl()``
* ``nexttoward()``
* ``nexttowardf()``
* ``nexttowardl()``
* ``pow()``
* ``powf()``
* ``powl()``
* ``remainder()``
* ``remainderf()``
* ``remainderl()``
* ``remquo()``
* ``remquof()``
* ``remquol()``
* ``rint()``
* ``rintf()``
* ``rintl()``
* ``round()``
* ``roundf()``
* ``roundl()``
* ``scalbln()``
* ``scalblnf()``
* ``scalblnl()``
* ``scalbn()``
* ``scalbnf()``
* ``scalbnl()``
* ``sin()``
* ``sinf()``
* ``sinh()``
* ``sinhf()``
* ``sinhl()``
* ``sinl()``
* ``sqrt()``
* ``sqrtf()``
* ``sqrtl()``
* ``tan()``
* ``tanf()``
* ``tanh()``
* ``tanhf()``
* ``tanhl()``
* ``tanl()``
* ``tgamma()``
* ``tgammaf()``
* ``tgammal()``
* ``trunc()``
* ``truncf()``
* ``truncl()``

The following methods and variables in ``<math.h>``
are not supported:

* ``signbit()``

## ``<setjmp.h>``

The following methods and variables in ``<setjmp.h>``
are supported:

* ``longjmp()``
* ``setjmp()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``raise()``
* ``signal()``

## ``<stdarg.h>``

The following methods and variables in ``<stdarg.h>``
are supported:

* ``va_arg()``
* ``va_copy()``
* ``va_end()``
* ``va_start()``

## ``<stddef.h>``

The following methods and variables in ``<stddef.h>``
are supported:

* ``offsetof()``

## ``<stdint.h>``

The following methods and variables in ``<stdint.h>``
are supported:

* ``INTMAX_C()``
* ``INTN_C()``
* ``UINTMAX_C()``
* ``UINTN_C()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``fclose()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgetpos()``
* ``fgets()``
* ``fileno()``
* ``fopen()``
* ``fprintf()``
* ``fputc()``
* ``fputs()``
* ``fread()``
* ``freopen()``
* ``fscanf()``
* ``fseek()``
* ``fsetpos()``
* ``ftell()``
* ``fwrite()``
* ``getc()``
* ``getchar()``
* ``gets()``
* ``perror()``
* ``printf()``
* ``putc()``
* ``putchar()``
* ``puts()``
* ``remove()``
* ``rename()``
* ``rewind()``
* ``scanf()``
* ``setbuf()``
* ``setvbuf()``
* ``snprintf()``
* ``sprintf()``
* ``sscanf()``
* ``stderr``
* ``stdin``
* ``stdout``
* ``tmpfile()``
* ``tmpnam()``
* ``ungetc()``
* ``vfprintf()``
* ``vfscanf()``
* ``vprintf()``
* ``vscanf()``
* ``vsnprintf()``
* ``vsprintf()``
* ``vsscanf()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``_Exit()``
* ``abs()``
* ``atexit()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``atoll()``
* ``bsearch()``
* ``calloc()``
* ``div()``
* ``exit()``
* ``free()``
* ``getenv()``
* ``labs()``
* ``ldiv()``
* ``llabs()``
* ``lldiv()``
* ``malloc()``
* ``mblen()``
* ``mbstowcs()``
* ``mbtowc()``
* ``qsort()``
* ``rand()``
* ``realloc()``
* ``srand()``
* ``strtod()``
* ``strtof()``
* ``strtol()``
* ``strtold()``
* ``strtoll()``
* ``strtoul()``
* ``strtoull()``
* ``wcstombs()``
* ``wctomb()``

The following methods in ``<stdlib.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``system()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strcat()``
* ``strchr()``
* ``strcmp()``
* ``strcoll()``
* ``strcpy()``
* ``strcspn()``
* ``strerror()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``
* ``strxfrm()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime()``
* ``clock()``
* ``ctime()``
* ``difftime()``
* ``gmtime()``
* ``localtime()``
* ``mktime()``
* ``strftime()``
* ``time()``

## ``<wchar.h>``

The following methods and variables in ``<wchar.h>``
are supported:

* ``btowc()``
* ``fgetwc()``
* ``fgetws()``
* ``fputwc()``
* ``fputws()``
* ``fwide()``
* ``fwprintf()``
* ``fwscanf()``
* ``getwc()``
* ``getwchar()``
* ``mbrlen()``
* ``mbrtowc()``
* ``mbsinit()``
* ``mbsrtowcs()``
* ``putwc()``
* ``putwchar()``
* ``swprintf()``
* ``swscanf()``
* ``ungetwc()``
* ``vfwprintf()``
* ``vfwscanf()``
* ``vswprintf()``
* ``vswscanf()``
* ``vwprintf()``
* ``vwscanf()``
* ``wcrtomb()``
* ``wcscat()``
* ``wcschr()``
* ``wcscmp()``
* ``wcscoll()``
* ``wcscpy()``
* ``wcscspn()``
* ``wcsftime()``
* ``wcslen()``
* ``wcsncat()``
* ``wcsncmp()``
* ``wcsncpy()``
* ``wcspbrk()``
* ``wcsrchr()``
* ``wcsrtombs()``
* ``wcsspn()``
* ``wcsstr()``
* ``wcstod()``
* ``wcstof()``
* ``wcstok()``
* ``wcstol()``
* ``wcstold()``
* ``wcstoll()``
* ``wcstoul()``
* ``wcstoull()``
* ``wcsxfrm()``
* ``wctob()``
* ``wmemchr()``
* ``wmemcmp()``
* ``wmemcpy()``
* ``wmemmove()``
* ``wmemset()``
* ``wprintf()``
* ``wscanf()``

## ``<wctype.h>``

The following methods and variables in ``<wctype.h>``
are supported:

* ``iswalnum()``
* ``iswalpha()``
* ``iswblank()``
* ``iswcntrl()``
* ``iswctype()``
* ``iswdigit()``
* ``iswgraph()``
* ``iswlower()``
* ``iswprint()``
* ``iswpunct()``
* ``iswspace()``
* ``iswupper()``
* ``iswxdigit()``
* ``towctrans()``
* ``towlower()``
* ``towupper()``
* ``wctrans()``
* ``wctype()``
