
% SPDX-License-Identifier: CC-BY-SA-4.0

# POSIX-2003 (Issue 6)


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the POSIX-2003 (Issue 6) standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  938 |
|    ENOSYS   |  18  |
|Not supported|  166 |

## ``<aio.h>``

The following methods and variables in ``<aio.h>``
are supported:

* ``aio_cancel()``
* ``aio_error()``
* ``aio_fsync()``
* ``aio_read()``
* ``aio_return()``
* ``aio_write()``
* ``lio_listio()``

The following methods in ``<aio.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``aio_suspend()``

## ``<arpa/inet.h>``

The following methods and variables in ``<arpa/inet.h>``
are supported:

* ``htonl()``
* ``htons()``
* ``inet_addr()``
* ``inet_ntoa()``
* ``inet_ntop()``
* ``inet_pton()``
* ``ntohl()``
* ``ntohs()``

## ``<assert.h>``

The following methods and variables in ``<assert.h>``
are supported:

* ``assert()``

## ``<complex.h>``

The following methods and variables in ``<complex.h>``
are supported:

* ``cabs()``
* ``cabsf()``
* ``cabsl()``
* ``cacos()``
* ``cacosf()``
* ``cacosh()``
* ``cacoshf()``
* ``cacoshl()``
* ``cacosl()``
* ``carg()``
* ``cargf()``
* ``cargl()``
* ``casin()``
* ``casinf()``
* ``casinh()``
* ``casinhf()``
* ``casinhl()``
* ``casinl()``
* ``catan()``
* ``catanf()``
* ``catanh()``
* ``catanhf()``
* ``catanhl()``
* ``catanl()``
* ``ccos()``
* ``ccosf()``
* ``ccosh()``
* ``ccoshf()``
* ``ccoshl()``
* ``ccosl()``
* ``cexp()``
* ``cexpf()``
* ``cexpl()``
* ``cimag()``
* ``cimagf()``
* ``cimagl()``
* ``clog()``
* ``clogf()``
* ``clogl()``
* ``conj()``
* ``conjf()``
* ``conjl()``
* ``cpow()``
* ``cpowf()``
* ``cpowl()``
* ``cproj()``
* ``cprojf()``
* ``cprojl()``
* ``creal()``
* ``crealf()``
* ``creall()``
* ``csin()``
* ``csinf()``
* ``csinh()``
* ``csinhf()``
* ``csinhl()``
* ``csinl()``
* ``csqrt()``
* ``csqrtf()``
* ``csqrtl()``
* ``ctan()``
* ``ctanf()``
* ``ctanh()``
* ``ctanhf()``
* ``ctanhl()``
* ``ctanl()``

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``_tolower()``
* ``_toupper()``
* ``isalnum()``
* ``isalpha()``
* ``isascii()``
* ``isblank()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``islower_l()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``toascii()``
* ``tolower()``
* ``toupper()``

## ``<dirent.h>``

The following methods and variables in ``<dirent.h>``
are supported:

* ``closedir()``
* ``opendir()``
* ``readdir()``
* ``readdir_r()``
* ``rewinddir()``
* ``seekdir()``

## ``<dlfcn.h>``

The following methods and variables in ``<dlfcn.h>``
are supported:

* ``dlclose()``
* ``dlerror()``
* ``dlopen()``
* ``dlsym()``

## ``<errno.h>``

The following methods and variables in ``<errno.h>``
are supported:

* ``errno``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``creat()``
* ``fcntl()``
* ``open()``

The following methods and variables in ``<fcntl.h>``
are not supported:

* ``posix_fadvise()``
* ``posix_fallocate()``
* ``posix_openpt()``

## ``<fenv.h>``

The following methods and variables in ``<fenv.h>``
are supported:

* ``feclearexcept()``
* ``fegetenv()``
* ``fegetexceptflag()``
* ``fegetround()``
* ``feholdexcept()``
* ``feraiseexcept()``
* ``fesetenv()``
* ``fesetexceptflag()``
* ``fesetround()``
* ``fetestexcept()``
* ``feupdateenv()``

## ``<fmtmsg.h>``

The following methods and variables in ``<fmtmsg.h>``
are not supported:

* ``fmtmsg()``

## ``<fnmatch.h>``

The following methods and variables in ``<fnmatch.h>``
are supported:

* ``fnmatch()``

## ``<ftw.h>``

The following methods and variables in ``<ftw.h>``
are supported:

* ``ftw()``
* ``nftw()``

## ``<glob.h>``

The following methods and variables in ``<glob.h>``
are supported:

* ``glob()``
* ``globfree()``

## ``<grp.h>``

The following methods and variables in ``<grp.h>``
are supported:

* ``endgrent()``
* ``getgrent()``
* ``getgrgid()``
* ``getgrgid_r()``
* ``getgrnam()``
* ``getgrnam_r()``
* ``setgrent()``

## ``<iconv.h>``

The following methods and variables in ``<iconv.h>``
are supported:

* ``iconv()``
* ``iconv_close()``
* ``iconv_open()``

## ``<inttypes.h>``

The following methods and variables in ``<inttypes.h>``
are supported:

* ``imaxabs()``
* ``imaxdiv()``
* ``strtoimax()``
* ``strtoumax()``
* ``wcstoimax()``
* ``wcstoumax()``

## ``<langinfo.h>``

The following methods and variables in ``<langinfo.h>``
are supported:

* ``nl_langinfo()``

## ``<libgen.h>``

The following methods and variables in ``<libgen.h>``
are supported:

* ``basename()``
* ``dirname()``

## ``<locale.h>``

The following methods and variables in ``<locale.h>``
are supported:

* ``localeconv()``
* ``setlocale()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``acosf()``
* ``acosh()``
* ``acoshf()``
* ``acoshl()``
* ``acosl()``
* ``asin()``
* ``asinf()``
* ``asinh()``
* ``asinhf()``
* ``asinhl()``
* ``asinl()``
* ``atan()``
* ``atan2()``
* ``atan2f()``
* ``atan2l()``
* ``atanf()``
* ``atanh()``
* ``atanhf()``
* ``atanhl()``
* ``atanl()``
* ``cbrt()``
* ``cbrtf()``
* ``cbrtl()``
* ``ceil()``
* ``ceilf()``
* ``ceill()``
* ``copysign()``
* ``copysignf()``
* ``copysignl()``
* ``cos()``
* ``cosf()``
* ``cosh()``
* ``coshf()``
* ``coshl()``
* ``cosl()``
* ``erf()``
* ``erfc()``
* ``erfcf()``
* ``erfcl()``
* ``erff()``
* ``erfl()``
* ``exp()``
* ``exp2()``
* ``exp2f()``
* ``exp2l()``
* ``expf()``
* ``expl()``
* ``expm1()``
* ``expm1f()``
* ``expm1l()``
* ``fabs()``
* ``fabsf()``
* ``fabsl()``
* ``fdim()``
* ``fdimf()``
* ``fdiml()``
* ``floor()``
* ``floorf()``
* ``floorl()``
* ``fma()``
* ``fmaf()``
* ``fmal()``
* ``fmax()``
* ``fmaxf()``
* ``fmaxl()``
* ``fmin()``
* ``fminf()``
* ``fminl()``
* ``fmod()``
* ``fmodf()``
* ``fmodl()``
* ``fpclassify()``
* ``frexp()``
* ``frexpf()``
* ``frexpl()``
* ``hypot()``
* ``hypotf()``
* ``hypotl()``
* ``ilogb()``
* ``ilogbf()``
* ``ilogbl()``
* ``isfinite()``
* ``isgreater()``
* ``isgreaterequal()``
* ``isinf()``
* ``isless()``
* ``islessequal()``
* ``islessgreater()``
* ``isnan()``
* ``isnormal()``
* ``isunordered()``
* ``ldexp()``
* ``ldexpf()``
* ``ldexpl()``
* ``lgamma()``
* ``lgammaf()``
* ``lgammal()``
* ``llrint()``
* ``llrintf()``
* ``llrintl()``
* ``llround()``
* ``llroundf()``
* ``llroundl()``
* ``log()``
* ``log10()``
* ``log10f()``
* ``log10l()``
* ``log1p()``
* ``log1pf()``
* ``log1pl()``
* ``log2()``
* ``log2f()``
* ``log2l()``
* ``logb()``
* ``logbf()``
* ``logbl()``
* ``logf()``
* ``logl()``
* ``lrint()``
* ``lrintf()``
* ``lrintl()``
* ``lround()``
* ``lroundf()``
* ``lroundl()``
* ``modf()``
* ``modff()``
* ``modfl()``
* ``nan()``
* ``nanf()``
* ``nanl()``
* ``nearbyint()``
* ``nearbyintf()``
* ``nearbyintl()``
* ``nextafter()``
* ``nextafterf()``
* ``nextafterl()``
* ``nexttoward()``
* ``nexttowardf()``
* ``nexttowardl()``
* ``pow()``
* ``powf()``
* ``powl()``
* ``remainder()``
* ``remainderf()``
* ``remainderl()``
* ``remquo()``
* ``remquof()``
* ``remquol()``
* ``rint()``
* ``rintf()``
* ``rintl()``
* ``round()``
* ``roundf()``
* ``roundl()``
* ``scalb()``
* ``scalbln()``
* ``scalblnf()``
* ``scalblnl()``
* ``scalbn()``
* ``scalbnf()``
* ``scalbnl()``
* ``sin()``
* ``sinf()``
* ``sinh()``
* ``sinhf()``
* ``sinhl()``
* ``sinl()``
* ``sqrt()``
* ``sqrtf()``
* ``sqrtl()``
* ``tan()``
* ``tanf()``
* ``tanh()``
* ``tanhf()``
* ``tanhl()``
* ``tanl()``
* ``tgamma()``
* ``tgammaf()``
* ``tgammal()``
* ``trunc()``
* ``truncf()``
* ``truncl()``

The following methods and variables in ``<math.h>``
are not supported:

* ``j0()``
* ``j1()``
* ``jn()``
* ``signbit()``
* ``signgam``
* ``y0()``
* ``y1()``
* ``yn()``

## ``<monetary.h>``

The following methods and variables in ``<monetary.h>``
are not supported:

* ``strfmon()``

## ``<mqueue.h>``

The following methods and variables in ``<mqueue.h>``
are supported:

* ``mq_close()``
* ``mq_getattr()``
* ``mq_notify()``
* ``mq_open()``
* ``mq_receive()``
* ``mq_send()``
* ``mq_setattr()``
* ``mq_timedreceive()``
* ``mq_timedsend()``
* ``mq_unlink()``

## ``<ndbm.h>``

The following methods and variables in ``<ndbm.h>``
are supported:

* ``dbm_clearerr()``
* ``dbm_close()``
* ``dbm_delete()``
* ``dbm_error()``
* ``dbm_fetch()``
* ``dbm_firstkey()``
* ``dbm_nextkey()``
* ``dbm_open()``
* ``dbm_store()``

## ``<net/if.h>``

The following methods and variables in ``<net/if.h>``
are supported:

* ``if_freenameindex()``
* ``if_indextoname()``
* ``if_nameindex()``
* ``if_nametoindex()``

## ``<netdb.h>``

The following methods and variables in ``<netdb.h>``
are supported:

* ``endhostent()``
* ``endnetent()``
* ``endprotoent()``
* ``endservent()``
* ``freeaddrinfo()``
* ``gai_strerror()``
* ``getaddrinfo()``
* ``gethostbyaddr()``
* ``gethostbyname()``
* ``gethostent()``
* ``getnameinfo()``
* ``getnetbyaddr()``
* ``getnetbyname()``
* ``getnetent()``
* ``getprotobyname()``
* ``getprotobynumber()``
* ``getprotoent()``
* ``getservbyname()``
* ``getservbyport()``
* ``getservent()``
* ``h_errno``
* ``sethostent()``
* ``setnetent()``
* ``setprotoent()``
* ``setservent()``

## ``<nl_types.h>``

The following methods and variables in ``<nl_types.h>``
are not supported:

* ``catclose()``
* ``catgets()``
* ``catopen()``

## ``<poll.h>``

The following methods and variables in ``<poll.h>``
are supported:

* ``poll()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getdetachstate()``
* ``pthread_attr_getguardsize()``
* ``pthread_attr_getinheritsched()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getschedpolicy()``
* ``pthread_attr_getscope()``
* ``pthread_attr_getstack()``
* ``pthread_attr_getstackaddr()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setdetachstate()``
* ``pthread_attr_setguardsize()``
* ``pthread_attr_setinheritsched()``
* ``pthread_attr_setschedparam()``
* ``pthread_attr_setschedpolicy()``
* ``pthread_attr_setscope()``
* ``pthread_attr_setstack()``
* ``pthread_attr_setstackaddr()``
* ``pthread_attr_setstacksize()``
* ``pthread_barrier_destroy()``
* ``pthread_barrier_init()``
* ``pthread_barrier_wait()``
* ``pthread_barrierattr_destroy()``
* ``pthread_barrierattr_getpshared()``
* ``pthread_barrierattr_init()``
* ``pthread_barrierattr_setpshared()``
* ``pthread_cancel()``
* ``pthread_cleanup_pop()``
* ``pthread_cleanup_push()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_timedwait()``
* ``pthread_cond_wait()``
* ``pthread_condattr_destroy()``
* ``pthread_condattr_getclock()``
* ``pthread_condattr_getpshared()``
* ``pthread_condattr_init()``
* ``pthread_condattr_setclock()``
* ``pthread_condattr_setpshared()``
* ``pthread_create()``
* ``pthread_detach()``
* ``pthread_equal()``
* ``pthread_exit()``
* ``pthread_getconcurrency()``
* ``pthread_getschedparam()``
* ``pthread_getspecific()``
* ``pthread_join()``
* ``pthread_key_create()``
* ``pthread_key_delete()``
* ``pthread_mutex_destroy()``
* ``pthread_mutex_getprioceiling()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_setprioceiling()``
* ``pthread_mutex_timedlock()``
* ``pthread_mutex_trylock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_destroy()``
* ``pthread_mutexattr_getprioceiling()``
* ``pthread_mutexattr_getprotocol()``
* ``pthread_mutexattr_getpshared()``
* ``pthread_mutexattr_gettype()``
* ``pthread_mutexattr_init()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_setprotocol()``
* ``pthread_mutexattr_setpshared()``
* ``pthread_mutexattr_settype()``
* ``pthread_once()``
* ``pthread_rwlock_destroy()``
* ``pthread_rwlock_init()``
* ``pthread_rwlock_rdlock()``
* ``pthread_rwlock_timedrdlock()``
* ``pthread_rwlock_timedwrlock()``
* ``pthread_rwlock_tryrdlock()``
* ``pthread_rwlock_trywrlock()``
* ``pthread_rwlock_unlock()``
* ``pthread_rwlock_wrlock()``
* ``pthread_rwlockattr_destroy()``
* ``pthread_rwlockattr_getpshared()``
* ``pthread_rwlockattr_init()``
* ``pthread_rwlockattr_setpshared()``
* ``pthread_self()``
* ``pthread_setcancelstate()``
* ``pthread_setcanceltype()``
* ``pthread_setconcurrency()``
* ``pthread_setschedparam()``
* ``pthread_setschedprio()``
* ``pthread_setspecific()``
* ``pthread_spin_destroy()``
* ``pthread_spin_init()``
* ``pthread_spin_lock()``
* ``pthread_spin_trylock()``
* ``pthread_spin_unlock()``
* ``pthread_testcancel()``

The following methods in ``<pthread.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``pthread_atfork()``
* ``pthread_getcpuclockid()``

## ``<pwd.h>``

The following methods and variables in ``<pwd.h>``
are supported:

* ``endpwent()``
* ``getpwent()``
* ``getpwnam()``
* ``getpwnam_r()``
* ``getpwuid()``
* ``getpwuid_r()``
* ``setpwent()``

## ``<regex.h>``

The following methods and variables in ``<regex.h>``
are supported:

* ``regcomp()``
* ``regerror()``
* ``regexec()``
* ``regfree()``

## ``<sched.h>``

The following methods and variables in ``<sched.h>``
are supported:

* ``sched_get_priority_max()``
* ``sched_get_priority_min()``
* ``sched_rr_get_interval()``
* ``sched_yield()``

The following methods in ``<sched.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``sched_getparam()``
* ``sched_getscheduler()``
* ``sched_setparam()``
* ``sched_setscheduler()``

## ``<search.h>``

The following methods and variables in ``<search.h>``
are supported:

* ``hcreate()``
* ``hdestroy()``
* ``hsearch()``
* ``tdelete()``
* ``tfind()``
* ``tsearch()``
* ``twalk()``

The following methods and variables in ``<search.h>``
are not supported:

* ``insque()``
* ``lfind()``
* ``lsearch()``
* ``remque()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_close()``
* ``sem_destroy()``
* ``sem_getvalue()``
* ``sem_init()``
* ``sem_open()``
* ``sem_post()``
* ``sem_timedwait()``
* ``sem_trywait()``
* ``sem_unlink()``
* ``sem_wait()``

## ``<setjmp.h>``

The following methods and variables in ``<setjmp.h>``
are supported:

* ``longjmp()``
* ``setjmp()``
* ``siglongjmp()``
* ``sigsetjmp()``

The following methods and variables in ``<setjmp.h>``
are not supported:

* ``_longjmp()``
* ``_setjmp()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``bsd_signal()``
* ``kill()``
* ``pthread_kill()``
* ``pthread_sigmask()``
* ``raise()``
* ``sigaction()``
* ``sigaddset()``
* ``sigdelset()``
* ``sigemptyset()``
* ``sigfillset()``
* ``sigismember()``
* ``signal()``
* ``sigpending()``
* ``sigprocmask()``
* ``sigqueue()``
* ``sigsuspend()``
* ``sigtimedwait()``
* ``sigwait()``
* ``sigwaitinfo()``

The following methods and variables in ``<signal.h>``
are not supported:

* ``killpg()``
* ``sighold()``
* ``sigignore()``
* ``siginterrupt()``
* ``sigpause()``
* ``sigrelse()``
* ``sigset()``

## ``<spawn.h>``

The following methods and variables in ``<spawn.h>``
are not supported:

* ``posix_spawn()``
* ``posix_spawn_file_actions_addclose()``
* ``posix_spawn_file_actions_adddup2()``
* ``posix_spawn_file_actions_addopen()``
* ``posix_spawn_file_actions_destroy()``
* ``posix_spawn_file_actions_init()``
* ``posix_spawnattr_destroy()``
* ``posix_spawnattr_getflags()``
* ``posix_spawnattr_getpgroup()``
* ``posix_spawnattr_getschedparam()``
* ``posix_spawnattr_getschedpolicy()``
* ``posix_spawnattr_getsigdefault()``
* ``posix_spawnattr_getsigmask()``
* ``posix_spawnattr_init()``
* ``posix_spawnattr_setflags()``
* ``posix_spawnattr_setpgroup()``
* ``posix_spawnattr_setschedparam()``
* ``posix_spawnattr_setschedpolicy()``
* ``posix_spawnattr_setsigdefault()``
* ``posix_spawnattr_setsigmask()``
* ``posix_spawnp()``

## ``<stdarg.h>``

The following methods and variables in ``<stdarg.h>``
are supported:

* ``va_arg()``
* ``va_copy()``
* ``va_end()``
* ``va_start()``

## ``<stddef.h>``

The following methods and variables in ``<stddef.h>``
are supported:

* ``offsetof()``

## ``<stdint.h>``

The following methods and variables in ``<stdint.h>``
are supported:

* ``INTMAX_C()``
* ``INTN_C()``
* ``UINTMAX_C()``
* ``UINTN_C()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``ctermid()``
* ``fclose()``
* ``fdopen()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgetpos()``
* ``fgets()``
* ``fileno()``
* ``flockfile()``
* ``fopen()``
* ``fprintf()``
* ``fputc()``
* ``fputs()``
* ``fread()``
* ``freopen()``
* ``fscanf()``
* ``fseek()``
* ``fseeko()``
* ``fsetpos()``
* ``ftell()``
* ``ftello()``
* ``ftrylockfile()``
* ``funlockfile()``
* ``fwrite()``
* ``getc()``
* ``getc_unlocked()``
* ``getchar()``
* ``getchar_unlocked()``
* ``gets()``
* ``perror()``
* ``printf()``
* ``putc()``
* ``putc_unlocked()``
* ``putchar()``
* ``putchar_unlocked()``
* ``puts()``
* ``remove()``
* ``rename()``
* ``rewind()``
* ``scanf()``
* ``setbuf()``
* ``setvbuf()``
* ``snprintf()``
* ``sprintf()``
* ``sscanf()``
* ``stderr``
* ``stdin``
* ``stdout``
* ``tempnam()``
* ``tmpfile()``
* ``tmpnam()``
* ``ungetc()``
* ``vfprintf()``
* ``vfscanf()``
* ``vprintf()``
* ``vscanf()``
* ``vsnprintf()``
* ``vsprintf()``
* ``vsscanf()``

The following methods and variables in ``<stdio.h>``
are not supported:

* ``pclose()``
* ``popen()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``_Exit()``
* ``a64l()``
* ``abort()``
* ``abs()``
* ``atexit()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``atoll()``
* ``bsearch()``
* ``calloc()``
* ``div()``
* ``drand48()``
* ``ecvt()``
* ``erand48()``
* ``exit()``
* ``fcvt()``
* ``free()``
* ``gcvt()``
* ``getenv()``
* ``getsubopt()``
* ``jrand48()``
* ``l64a()``
* ``labs()``
* ``lcong48()``
* ``ldiv()``
* ``llabs()``
* ``lldiv()``
* ``lrand48()``
* ``malloc()``
* ``mblen()``
* ``mbstowcs()``
* ``mbtowc()``
* ``mkstemp()``
* ``mktemp()``
* ``mrand48()``
* ``nrand48()``
* ``posix_memalign()``
* ``putenv()``
* ``qsort()``
* ``rand()``
* ``rand_r()``
* ``random()``
* ``realloc()``
* ``realpath()``
* ``seed48()``
* ``setenv()``
* ``srand()``
* ``srand48()``
* ``srandom()``
* ``strtod()``
* ``strtof()``
* ``strtol()``
* ``strtold()``
* ``strtoll()``
* ``strtoul()``
* ``strtoull()``
* ``unsetenv()``
* ``wcstombs()``
* ``wctomb()``

The following methods in ``<stdlib.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``system()``

The following methods and variables in ``<stdlib.h>``
are not supported:

* ``grantpt()``
* ``initstate()``
* ``ptsname()``
* ``setkey()``
* ``setstate()``
* ``unlockpt()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memccpy()``
* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strcat()``
* ``strchr()``
* ``strcmp()``
* ``strcoll()``
* ``strcpy()``
* ``strcspn()``
* ``strdup()``
* ``strerror()``
* ``strerror_r()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``
* ``strtok_r()``
* ``strxfrm()``

## ``<strings.h>``

The following methods and variables in ``<strings.h>``
are supported:

* ``bcmp()``
* ``bcopy()``
* ``bzero()``
* ``ffs()``
* ``ftime()``
* ``index()``
* ``rindex()``
* ``strcasecmp()``
* ``strncasecmp()``

## ``<stropts.h>``

The following methods and variables in ``<stropts.h>``
are supported:

* ``ioctl()``

The following methods and variables in ``<stropts.h>``
are not supported:

* ``fattach()``
* ``fdetach()``
* ``getmsg()``
* ``getpmsg()``
* ``isastream()``
* ``putmsg()``
* ``putpmsg()``

## ``<sys/ipc.h>``

The following methods and variables in ``<sys/ipc.h>``
are not supported:

* ``ftok()``

## ``<sys/mman.h>``

The following methods and variables in ``<sys/mman.h>``
are supported:

* ``mlock()``
* ``mlockall()``
* ``mmap()``
* ``mprotect()``
* ``msync()``
* ``munlock()``
* ``munlockall()``
* ``munmap()``
* ``posix_madvise()``
* ``shm_open()``
* ``shm_unlink()``

The following methods and variables in ``<sys/mman.h>``
are not supported:

* ``posix_mem_offset()``
* ``posix_typed_mem_get_info()``
* ``posix_typed_mem_open()``

## ``<sys/msg.h>``

The following methods and variables in ``<sys/msg.h>``
are not supported:

* ``msgctl()``
* ``msgget()``
* ``msgrcv()``
* ``msgsnd()``

## ``<sys/resource.h>``

The following methods and variables in ``<sys/resource.h>``
are supported:

* ``getrusage()``

The following methods and variables in ``<sys/resource.h>``
are not supported:

* ``getpriority()``
* ``getrlimit()``
* ``setpriority()``
* ``setrlimit()``

## ``<sys/select.h>``

The following methods and variables in ``<sys/select.h>``
are supported:

* ``FD_CLR()``
* ``FD_ISSET()``
* ``FD_SET()``
* ``FD_ZERO()``
* ``select()``

The following methods and variables in ``<sys/select.h>``
are not supported:

* ``pselect()``

## ``<sys/sem.h>``

The following methods and variables in ``<sys/sem.h>``
are not supported:

* ``semctl()``
* ``semget()``
* ``semop()``

## ``<sys/shm.h>``

The following methods and variables in ``<sys/shm.h>``
are not supported:

* ``shmat()``
* ``shmctl()``
* ``shmdt()``
* ``shmget()``

## ``<sys/socket.h>``

The following methods and variables in ``<sys/socket.h>``
are supported:

* ``accept()``
* ``bind()``
* ``connect()``
* ``getpeername()``
* ``getsockname()``
* ``getsockopt()``
* ``listen()``
* ``recv()``
* ``recvfrom()``
* ``recvmsg()``
* ``send()``
* ``sendmsg()``
* ``sendto()``
* ``setsockopt()``
* ``shutdown()``
* ``socket()``
* ``socketpair()``

The following methods and variables in ``<sys/socket.h>``
are not supported:

* ``sockatmark()``

## ``<sys/stat.h>``

The following methods and variables in ``<sys/stat.h>``
are supported:

* ``chmod()``
* ``fchmod()``
* ``fstat()``
* ``lstat()``
* ``mkdir()``
* ``mkfifo()``
* ``mknod()``
* ``stat()``
* ``umask()``

## ``<sys/statvfs.h>``

The following methods and variables in ``<sys/statvfs.h>``
are supported:

* ``statvfs()``

The following methods and variables in ``<sys/statvfs.h>``
are not supported:

* ``fstatvfs()``

## ``<sys/time.h>``

The following methods and variables in ``<sys/time.h>``
are supported:

* ``gettimeofday()``
* ``times()``
* ``utimes()``

The following methods in ``<sys/time.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``getitimer()``
* ``setitimer()``

## ``<sys/uio.h>``

The following methods and variables in ``<sys/uio.h>``
are supported:

* ``readv()``
* ``writev()``

## ``<sys/utsname.h>``

The following methods and variables in ``<sys/utsname.h>``
are supported:

* ``uname()``

## ``<sys/wait.h>``

The following methods and variables in ``<sys/wait.h>``
are supported:

* ``wait()``
* ``waitpid()``

The following methods and variables in ``<sys/wait.h>``
are not supported:

* ``waitid()``

## ``<syslog.h>``

The following methods and variables in ``<syslog.h>``
are not supported:

* ``closelog()``
* ``openlog()``
* ``setlogmask()``
* ``syslog()``

## ``<termios.h>``

The following methods and variables in ``<termios.h>``
are supported:

* ``cfgetispeed()``
* ``cfgetospeed()``
* ``cfsetispeed()``
* ``cfsetospeed()``
* ``tcdrain()``
* ``tcflow()``
* ``tcflush()``
* ``tcgetattr()``
* ``tcsendbreak()``
* ``tcsetattr()``

The following methods and variables in ``<termios.h>``
are not supported:

* ``tcgetsid()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime()``
* ``asctime_r()``
* ``clock()``
* ``clock_getres()``
* ``clock_gettime()``
* ``clock_nanosleep()``
* ``clock_settime()``
* ``ctime()``
* ``ctime_r()``
* ``difftime()``
* ``gmtime()``
* ``gmtime_r()``
* ``localtime()``
* ``localtime_r()``
* ``mktime()``
* ``nanosleep()``
* ``strftime()``
* ``strptime()``
* ``time()``
* ``timer_create()``
* ``timer_delete()``
* ``timer_getoverrun()``
* ``timer_gettime()``
* ``timer_settime()``
* ``timezone``
* ``tzname``
* ``tzset()``

The following methods in ``<time.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``clock_getcpuclockid()``

The following methods and variables in ``<time.h>``
are not supported:

* ``daylight``
* ``getdate()``
* ``getdate_err``

## ``<trace.h>``

The following methods and variables in ``<trace.h>``
are not supported:

* ``posix_trace_attr_destroy()``
* ``posix_trace_attr_getclockres()``
* ``posix_trace_attr_getcreatetime()``
* ``posix_trace_attr_getgenversion()``
* ``posix_trace_attr_getinherited()``
* ``posix_trace_attr_getlogfullpolicy()``
* ``posix_trace_attr_getlogsize()``
* ``posix_trace_attr_getmaxdatasize()``
* ``posix_trace_attr_getmaxsystemeventsize()``
* ``posix_trace_attr_getmaxusereventsize()``
* ``posix_trace_attr_getname()``
* ``posix_trace_attr_getstreamfullpolicy()``
* ``posix_trace_attr_getstreamsize()``
* ``posix_trace_attr_init()``
* ``posix_trace_attr_setinherited()``
* ``posix_trace_attr_setlogfullpolicy()``
* ``posix_trace_attr_setlogsize()``
* ``posix_trace_attr_setmaxdatasize()``
* ``posix_trace_attr_setname()``
* ``posix_trace_attr_setstreamfullpolicy()``
* ``posix_trace_attr_setstreamsize()``
* ``posix_trace_clear()``
* ``posix_trace_close()``
* ``posix_trace_create()``
* ``posix_trace_create_withlog()``
* ``posix_trace_event()``
* ``posix_trace_eventid_equal()``
* ``posix_trace_eventid_get_name()``
* ``posix_trace_eventid_open()``
* ``posix_trace_eventset_add()``
* ``posix_trace_eventset_del()``
* ``posix_trace_eventset_empty()``
* ``posix_trace_eventset_fill()``
* ``posix_trace_eventset_ismember()``
* ``posix_trace_eventtypelist_getnext_id()``
* ``posix_trace_eventtypelist_rewind()``
* ``posix_trace_flush()``
* ``posix_trace_get_attr()``
* ``posix_trace_get_filter()``
* ``posix_trace_get_status()``
* ``posix_trace_getnext_event()``
* ``posix_trace_open()``
* ``posix_trace_rewind()``
* ``posix_trace_set_filter()``
* ``posix_trace_shutdown()``
* ``posix_trace_start()``
* ``posix_trace_stop()``
* ``posix_trace_timedgetnext_event()``
* ``posix_trace_trid_eventid_open()``
* ``posix_trace_trygetnext_event()``

## ``<ulimit.h>``

The following methods and variables in ``<ulimit.h>``
are not supported:

* ``ulimit()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``_exit()``
* ``access()``
* ``alarm()``
* ``chdir()``
* ``chown()``
* ``close()``
* ``dup()``
* ``dup2()``
* ``environ``
* ``fchdir()``
* ``fchown()``
* ``fdatasync()``
* ``fpathconf()``
* ``fsync()``
* ``ftruncate()``
* ``getcwd()``
* ``getegid()``
* ``geteuid()``
* ``getgid()``
* ``getgroups()``
* ``gethostname()``
* ``getlogin()``
* ``getlogin_r()``
* ``getopt()``
* ``getpgrp()``
* ``getpid()``
* ``getppid()``
* ``getuid()``
* ``isatty()``
* ``lchown()``
* ``link()``
* ``lseek()``
* ``optarg``
* ``opterr``
* ``optind``
* ``optopt``
* ``pathconf()``
* ``pause()``
* ``pipe()``
* ``pread()``
* ``pwrite()``
* ``read()``
* ``readlink()``
* ``rmdir()``
* ``setegid()``
* ``seteuid()``
* ``setgid()``
* ``setpgid()``
* ``setsid()``
* ``setuid()``
* ``sleep()``
* ``swab()``
* ``symlink()``
* ``sync()``
* ``sysconf()``
* ``tcgetpgrp()``
* ``tcsetpgrp()``
* ``truncate()``
* ``ttyname()``
* ``ttyname_r()``
* ``ualarm()``
* ``unlink()``
* ``usleep()``
* ``write()``

The following methods in ``<unistd.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``execl()``
* ``execle()``
* ``execlp()``
* ``execv()``
* ``execve()``
* ``execvp()``
* ``fork()``

The following methods and variables in ``<unistd.h>``
are not supported:

* ``confstr()``
* ``crypt()``
* ``encrypt()``
* ``gethostid()``
* ``getpgid()``
* ``getsid()``
* ``lockf()``
* ``nice()``
* ``setpgrp()``
* ``setregid()``
* ``setreuid()``

## ``<utime.h>``

The following methods and variables in ``<utime.h>``
are supported:

* ``utime()``

## ``<utmpx.h>``

The following methods and variables in ``<utmpx.h>``
are not supported:

* ``endutxent()``
* ``getutxent()``
* ``getutxid()``
* ``getutxline()``
* ``pututxline()``
* ``setutxent()``

## ``<wchar.h>``

The following methods and variables in ``<wchar.h>``
are supported:

* ``btowc()``
* ``fgetwc()``
* ``fgetws()``
* ``fputwc()``
* ``fputws()``
* ``fwide()``
* ``fwprintf()``
* ``fwscanf()``
* ``getwc()``
* ``getwchar()``
* ``mbrlen()``
* ``mbrtowc()``
* ``mbsinit()``
* ``mbsrtowcs()``
* ``putwc()``
* ``putwchar()``
* ``swprintf()``
* ``swscanf()``
* ``ungetwc()``
* ``vfwprintf()``
* ``vfwscanf()``
* ``vswprintf()``
* ``vswscanf()``
* ``vwprintf()``
* ``vwscanf()``
* ``wcrtomb()``
* ``wcscat()``
* ``wcschr()``
* ``wcscmp()``
* ``wcscoll()``
* ``wcscpy()``
* ``wcscspn()``
* ``wcsftime()``
* ``wcslen()``
* ``wcsncat()``
* ``wcsncmp()``
* ``wcsncpy()``
* ``wcsnlen()``
* ``wcsnrtombs()``
* ``wcspbrk()``
* ``wcsrchr()``
* ``wcsrtombs()``
* ``wcsspn()``
* ``wcsstr()``
* ``wcstod()``
* ``wcstof()``
* ``wcstok()``
* ``wcstol()``
* ``wcstold()``
* ``wcstoll()``
* ``wcstoul()``
* ``wcstoull()``
* ``wcswidth()``
* ``wcsxfrm()``
* ``wctob()``
* ``wcwidth()``
* ``wmemchr()``
* ``wmemcmp()``
* ``wmemcpy()``
* ``wmemmove()``
* ``wmemset()``
* ``wprintf()``
* ``wscanf()``

## ``<wctype.h>``

The following methods and variables in ``<wctype.h>``
are supported:

* ``iswalnum()``
* ``iswalpha()``
* ``iswblank()``
* ``iswcntrl()``
* ``iswctype()``
* ``iswdigit()``
* ``iswgraph()``
* ``iswlower()``
* ``iswprint()``
* ``iswpunct()``
* ``iswspace()``
* ``iswupper()``
* ``iswxdigit()``
* ``towctrans()``
* ``towlower()``
* ``towupper()``
* ``wctrans()``
* ``wctype()``

## ``<wordexp.h>``

The following methods and variables in ``<wordexp.h>``
are not supported:

* ``wordexp()``
* ``wordfree()``
