% SPDX-License-Identifier: CC-BY-SA-4.0

% Copyright (C) 2020 embedded brains GmbH & Co. KG

% Copyright (C) 2015 Chris Johns

% Copyright (C) 1988, 2008 On-Line Applications Research Corporation (OAR)

# RTEMS Project Mission Statement

RTEMS development done under the umbrella of the RTEMS Project aims to provide a
free and open real-time operating system targeted towards deeply embedded
systems which is competitive with proprietary products. The RTEMS Project
encourages the support and use of standard APIs in order to promote application
portability and ease porting other packages to the RTEMS environment.

The RTEMS development effort uses an open development environment in which all
users collaborate to improve RTEMS. The RTEMS cross development tool suite is
based upon the free GNU tools and the open source standard C library newlib.
RTEMS supports many host platforms and target architectures.

## Free Software Project

The free software goals of the project are:

- RTEMS and supporting components are available under various free licenses with
  copyrights being held by individual authors.
- All software which executes on the target will not place undue restrictions on
  embedded applications. See also {ref}`LicensingRequirements`.
- Patches must be legally acceptable for inclusion into the RTEMS Project or the
  specific project being used.

## Design and Development Goals

- Source based development with all users building from source
- Any suitable host should be supported
- Open testing, tests and test results
- Ports to new architectures and CPU models
- Addition of Board Support Packages for available hardware
- Improved runtime libraries
- Faster debug cycle
- Various other infrastructure improvements

## Open Development Environment

- Encourage cooperation and communication between developers
- Work more closely with "consumers"
- Code available to everyone at any time, and everyone is welcome to participate
  in development
- Patches will be considered equally based on their technical merits
- All individuals and companies are welcome to contribute as long as they accept
  the ground rules
- Open mailing lists
- Developer friendly tools and procedures with a focus on keeping them current
- Conflicts of interest exist for many RTEMS developers. The developers
  contributing to the RTEMS Project must put the interests of the RTEMS Project
  first.
