% SPDX-License-Identifier: CC-BY-SA-4.0

% Copyright (C) 2025 Beeram Pranith Reddy <pranithreddy16.beeram@gmail.com>

(rtems-codeql-wrapper)=

# RTEMS CodeQL

```{index} Tools, CodeQL, rtems-codeql, static analysis
```

The `rtems-codeql.py` script is a command-line interface that provides a simplified workflow for running CodeQL static analysis on the RTEMS source code. The tool offers a consistent set of commands to create, analyze, filter, and manage CodeQL databases, tailored specifically for the RTEMS development environment.

Static analysis is a powerful method for finding potential bugs, security vulnerabilities, and maintainability issues by analyzing source code without executing it. Integrating this process into development is critical for ensuring the quality, security, and robustness of the RTEMS project.

Using the `rtems-codeql.py` wrapper makes it easy for developers to perform these checks regularly. It provides a traceable and repeatable process, helping to maintain the high engineering standards expected for the RTEMS real-time operating system.

## Commands Overview

You can list the available commands with the `--help` option:

```none
$ ./rtems-codeql.py --help
usage: rtems-codeql.py [-h] <command> ...

RTEMS CodeQL CLI wrapper

positional arguments:
  <command>
    path_check      Checks if CodeQL is added to path
    create_db       Create a CodeQL database for the RTEMS source.
    analyze_db      Analyze an existing CodeQL database.
    delete_db       Deletes the database generated by codeql
    exclude_path    Filter CSV rows based on glob patterns in specified path column.

options:
  -h, --help        show this help message and exit
```

```{note}
This wrapper is designed to be extensible. We encourage developers to contribute improvements and new features back to the project.
```

(CodeQLPrerequisites)=

## Prerequisites

Before using the wrapper, you must have the [**CodeQL CLI**](https://github.com/github/codeql-action/releases) installed on your host machine and available in your system's `PATH`. You can verify this using the `path_check` command. If the command fails, please follow the official CodeQL installation guide.

```none
$ ./rtems-codeql.py path_check
Starting 'path_check' command checking if CodeQL is in path...
CodeQL is set to path
```

## Example Workflow

This section provides a complete workflow for creating a database, running an analysis, and filtering the results. These commands should be run from the directory containing the `rtems-codeql.py` script.

### Step 1: Create the CodeQL Database

The first step is to build a CodeQL database from a compiled RTEMS source tree. The wrapper instruments the build process to extract detailed information about the code.

#### Usage

```none
$ ./rtems-codeql.py create_db --help
usage: rtems-codeql.py create_db [-h] [--rtems-source <path>] [--rtems-db-name <name>] --rtems-build <path>

Builds a CodeQL database from the RTEMS source code. Requires a source directory and a build command.

options:
  -h, --help            show this help message and exit
  --rtems-source <path>
                        Absolute path to RTEMS source code directory.
  --rtems-db-name <name>
                        Name of the CodeQL database to create default 'rtems-db' name is used.
  --rtems-build <path>  Path containing build.sh file to build the RTEMS source (e.g., './build.sh').
```

#### Example

```none
$ ./rtems-codeql.py create_db \
    --rtems-source /path/to/rtems-source \
    --rtems-build /path/to/rtems-source/build.sh \
    --rtems-db-name rtems-project-db
```

This command will invoke the RTEMS build script and create a database in a new directory named `rtems-project-db`.

### Step 2: Run the Analysis

Once the database is created, you can run queries against it. CodeQL provides various query suites for finding different types of issues. This example uses the `cpp-cert.qls` suite to check for CERT C++ violations.

#### Usage

```none
$ ./rtems-codeql.py analyze_db --help
usage: rtems-codeql.py analyze_db [-h] --rtems-db-path <path> --rtems-report-output <path> --rtems-query <path>
                                [--rtems-db-analyze-ram <MB>] [--rtems-db-analyze-threads <count>]
                                [--csv-format {line-column,line}]

Runs queries against a specified CodeQL database and outputs the results to a CSV file.

options:
  -h, --help                          show this help message and exit
  --rtems-db-path <path>              Path to CodeQL database directory (eg: rtems-db/cpp for cpp and rtems-db/python)
  --rtems-report-output <path>        Output path for the resulting CSV report file.
  --rtems-query <path>                Path to a .ql query file or a .qls query suite, or a directory of queries.
  --rtems-db-analyze-ram <MB>         RAM in MB to allocate to the CodeQL analyzer (default: 8000MB).
  --rtems-db-analyze-threads <count>  Number of threads for the CodeQL analyzer to use (default: 4).
  --csv-format {line-column,line}     Format for location in the CSV output (default: line-column).
```

```{note}
The script does not automatically create output directory. Before running the command, ensure the destination directory (in this example, `reports/`) exists. If it does not, you can create it with `mkdir reports`.
```

#### Example

```none
$ ./rtems-codeql.py analyze_db \
    --rtems-db-path rtems-project-db/cpp \
    --rtems-report-output reports/cert-cpp-full-report.csv \
    --rtems-query queries/cert-cpp.qls
```

The output will be a CSV file containing all the findings. The wrapper automatically adds headers and handles oversized fields to ensure the report is usable.

```none
Analysis complete.Results saved to reports/cert-cpp-full-report.csv
Adding headers to CSV report...
Formatted CSV saved as reports/cert-cpp-full-report_formatted.csv
Original file 'reports/cert-cpp-full-report.csv' has been removed.
Successfully added headers.
```

### Step 3: Filter the Report (Optional)

The full report may contain findings in third-party libraries or test code that you wish to exclude. The `exclude_path` command can filter a CSV report based on glob patterns.

#### Usage

```none
$ ./rtems-codeql.py exclude_path --help
usage: rtems-codeql.py exclude_path [-h] --input-csv <path> --output-csv <path> -e <path> [-c COLUMN]

Excludes paths present under 'exclude_patterns.txt' using glob patterns

options:
  -h, --help            show this help message and exit
  --input-csv <path>    Path to the input CSV file.
  --output-csv <path>   Path to the output CSV file.
  -e <path>, --excluding-file <path>
                        Path to the text file containing exclusion glob patterns (one per line).
  -c COLUMN, --column COLUMN
                        The name of the column in the CSV that contains the paths. (default: Path)
```

#### Example

First, create a file (e.g., `exclude-patterns.txt`) with the patterns of paths to ignore:

```
# Exclude all test suites
*/testsuites/*

# Exclude a specific library
*/cpukit/some-library/*
```

Next, run the filter command:

```none
$ ./rtems-codeql.py exclude_path \
    --input-csv reports/cert-cpp-full-report_formatted.csv \
    --output-csv reports/cert-cpp-filtered-report.csv \
    --excluding-file exclude-patterns.txt
```

This creates a new, shorter report with the unwanted paths removed.

### Step 4: Clean Up the Database

CodeQL databases can be large. Once you are finished with your analysis, you can remove the database to free up disk space.

#### Usage

```none
$ ./rtems-codeql.py delete_db --help
usage: rtems-codeql.py delete_db [-h] --rtems-db-path <path>

Deletes the database generated by codeql

options:
  -h, --help            show this help message and exit
  --rtems-db-path <path>  Path to CodeQL database directory (eg: rtems-db/)
```

#### Example

```none
$ ./rtems-codeql.py delete_db --rtems-db-path rtems-project-db
```

## Command Line Help

Each command has its own set of options. You can review all available options for a specific command by using the `--help` flag after the command name.
