% SPDX-License-Identifier: CC-BY-SA-4.0

% Copyright (C) 2024 On-Line Applications Research Corporation (OAR)

(BSP_arm_zynqmp_rpu_lock_step)=

(BSP_arm_zynqmp_rpu_split_0)=

(BSP_arm_zynqmp_rpu_split_1)=

# Xilinx ZynqMP RPU

This BSP supports the Real-time Processing Unit (RPU) on the Xilinx Zynq
UltraScale+ MPSoC and RFSoC platforms. The RPU has two Cortex-R5 cores which
can operate in lock-step or split mode. Basic hardware initialization is
performed by the Cortex-R5 FSBL and the BSP. This BSP supports the GICv2
interrupt controller available to the RPU subsystem. Since the RPU subsystem
only varies in speed, this BSP should be functional across all chip variants as
well as on Xilinx's QEMU branch. There are three BSP variants available for
customization:

- `zynqmp_rpu_lock_step`
- `zynqmp_rpu_split_0`
- `zynqmp_rpu_split_1`

The `zynqmp_rpu_lock_step` BSP variant is intended to be used for the RPU in
lock-step mode. In this case, the ATCM and BTCM will be used as a combined
memory area for code and data. The `zynqmp_rpu_split_0` and
`zynqmp_rpu_split_1` BSP variants are intended to be used for the RPU in
split mode for core 0 and 1 respectively. The core 0 variant initializes the
GIC distributor. The core 1 variants waits for the GIC distributor
initialization done by core 0 during the system initialization. The DDR RAM is
a shared resource and should be used according to applications-specific
requirements. The default BSP settings for the DDR RAM usage aimed at testing
the BSP variants.

## Clock Driver

The clock driver uses one of the available triple timer counters (TTCs) as the
timer interrupt source.

## Console Driver

The console driver supports the default Qemu emulated ARM PL011 PrimeCell UART
as well as the physical ARM PL011 PrimeCell UART in the ZynqMP hardware.

## Boot on ZynqMP Hardware

On the ZynqMP RPU, RTEMS can be started by Cortes-R5 u-boot, Cortex-A53 u-boot,
via JTAG, or directly as part of BOOT.bin. For quick turnaround during testing,
it is recommended to use Cortex-A53 u-boot to avoid repeated BOOT.bin
generation since the provided Cortex-R5 u-boot is highly limited and has no
network or MMC/SD access.

Note that if the RPU image is started by the Cortex-A53 u-boot, the program
sections located at ZYNQMP_RPU_RAM_INT_0_ORIGIN and ZYNQMP_RPU_RAM_INT_1_ORIGIN
must be manually relocated from DDR to TCM since the TCMs are not directly
available to the Cortex-A53 cores at their Cortex-R5 internal addresses. This
can be accomplished by disabling dcache in u-boot and using u-boot's "cp"
command. Once this is done, the program can be started at 0x0 by using u-boot's
"cpu" command to first disable core 4 and then release it in split mode.

## Hardware Boot Image Generation

When generating BOOT.bin from components, the BIF file should include at least
entries for the Cortex-R5 FSBL ([bootloader,destination_cpu=r5-0]) and the
Cortex-R5 application ([destination_cpu=r5-0]). The Cortex-R5 application should
be either a u-boot or RTEMS ELF binary. The Cortex-R5 u-boot binary can be
obtained by building it from Xilinx's u-boot repository. The Cortex-R5 FSBL can
be obtained setting up an appropriate platform project in Xilinx's current
development system.

## Boot on QEMU

The executable image is booted by Qemu in ELF format.

## Running Executables on QEMU

Xilinx's qemu-devicetrees repository must be used in conjunction with the Xilinx
QEMU available via RSB. Executables generated by this BSP can be run using the
following command:

```shell
qemu-system-aarch64 -no-reboot -nographic -M arm-generic-fdt -serial null \
 -serial mon:stdio -device loader,file=example.exe,cpu-num=4 \
 -device loader,addr=0xff5e023c,data=0x80088fde,data-len=4 \
 -device loader,addr=0xff9a0000,data=0x80000218,data-len=4 \
 -hw-dtb /xlnx-qemu-devtrees-path/LATEST/SINGLE_ARCH/board-zynqmp-zcu102.dtb \
 -m 4096 -display none
```

## Debugging Executables on QEMU

Debugging the RPU cores under QEMU presents unique challenges due to requiring
the AArch64 QEMU to emulate the entire processing subsystem. Debugging requires
a multi-arch GDB which can be created by adding "--enable-targets=all" to the
normal GDB configure line and then building as normal.

To attach to the RPU core once QEMU is started with "-s -S", The following steps
are required:

```shell
aarch64-rtems6-gdb
(gdb) tar ext :1234
(gdb) add-inferior
(gdb) inferior 2
(gdb) file example.exe
(gdb) attach 2
```
