
% SPDX-License-Identifier: CC-BY-SA-4.0

# Software Communications Architecture 4.1 Ultra Lightweight Application Environment Profile


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the Software Communications Architecture 4.1 Ultra Lightweight Application Environment Profile standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  22  |
|    ENOSYS   |   0  |
|Not supported|   0  |

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``exp()``
* ``exp2()``

## ``<mqueue.h>``

The following methods and variables in ``<mqueue.h>``
are supported:

* ``mq_open()``
* ``mq_receive()``
* ``mq_send()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setinheritsched()``
* ``pthread_create()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_settype()``
* ``pthread_self()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_init()``
* ``sem_post()``
* ``sem_wait()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``clock_getres()``
* ``clock_gettime()``
* ``timer_create()``
* ``timer_settime()``
