
% SPDX-License-Identifier: CC-BY-SA-4.0

# FACE Technical Standard, Edition 2.1 Safety Extended


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the FACE Technical Standard, Edition 2.1 Safety Extended standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  316 |
|    ENOSYS   |  11  |
|Not supported|   9  |

## ``<arpa/inet.h>``

The following methods and variables in ``<arpa/inet.h>``
are supported:

* ``htonl()``
* ``htons()``
* ``inet_ntop()``
* ``inet_pton()``
* ``ntohl()``
* ``ntohs()``

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<devctl.h>``

The following methods and variables in ``<devctl.h>``
are supported:

* ``posix_devctl()``

## ``<dirent.h>``

The following methods and variables in ``<dirent.h>``
are supported:

* ``closedir()``
* ``opendir()``
* ``readdir()``
* ``readdir_r()``
* ``rewinddir()``

## ``<errno.h>``

The following methods and variables in ``<errno.h>``
are supported:

* ``errno``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``creat()``
* ``fcntl()``
* ``open()``

## ``<math.h>``

The following methods and variables in ``<math.h>``
are supported:

* ``acos()``
* ``acosh()``
* ``asin()``
* ``asinh()``
* ``atan()``
* ``atan2()``
* ``atanh()``
* ``ceil()``
* ``cos()``
* ``cosh()``
* ``exp()``
* ``fabs()``
* ``floor()``
* ``fmod()``
* ``frexp()``
* ``isinf()``
* ``isnan()``
* ``ldexp()``
* ``log()``
* ``log10()``
* ``modf()``
* ``pow()``
* ``sin()``
* ``sinh()``
* ``sqrt()``
* ``tan()``
* ``tanh()``

## ``<mqueue.h>``

The following methods and variables in ``<mqueue.h>``
are supported:

* ``mq_getattr()``
* ``mq_notify()``
* ``mq_open()``
* ``mq_receive()``
* ``mq_send()``
* ``mq_setattr()``
* ``mq_timedreceive()``
* ``mq_timedsend()``

## ``<netdb.h>``

The following methods and variables in ``<netdb.h>``
are supported:

* ``freeaddrinfo()``
* ``getaddrinfo()``
* ``getnameinfo()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getdetachstate()``
* ``pthread_attr_getguardsize()``
* ``pthread_attr_getinheritsched()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getschedpolicy()``
* ``pthread_attr_getscope()``
* ``pthread_attr_getstack()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setdetachstate()``
* ``pthread_attr_setguardsize()``
* ``pthread_attr_setinheritsched()``
* ``pthread_attr_setschedparam()``
* ``pthread_attr_setschedpolicy()``
* ``pthread_attr_setscope()``
* ``pthread_attr_setstack()``
* ``pthread_attr_setstacksize()``
* ``pthread_cancel()``
* ``pthread_cleanup_pop()``
* ``pthread_cleanup_push()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_timedwait()``
* ``pthread_cond_wait()``
* ``pthread_condattr_destroy()``
* ``pthread_condattr_getclock()``
* ``pthread_condattr_init()``
* ``pthread_condattr_setclock()``
* ``pthread_create()``
* ``pthread_detach()``
* ``pthread_equal()``
* ``pthread_exit()``
* ``pthread_getconcurrency()``
* ``pthread_getschedparam()``
* ``pthread_getspecific()``
* ``pthread_join()``
* ``pthread_key_create()``
* ``pthread_key_delete()``
* ``pthread_mutex_destroy()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_timedlock()``
* ``pthread_mutex_trylock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_destroy()``
* ``pthread_mutexattr_getprioceiling()``
* ``pthread_mutexattr_getprotocol()``
* ``pthread_mutexattr_init()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_setprotocol()``
* ``pthread_once()``
* ``pthread_self()``
* ``pthread_setcancelstate()``
* ``pthread_setcanceltype()``
* ``pthread_setconcurrency()``
* ``pthread_setschedparam()``
* ``pthread_setschedprio()``
* ``pthread_setspecific()``

The following methods in ``<pthread.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``pthread_atfork()``
* ``pthread_getcpuclockid()``

## ``<sched.h>``

The following methods and variables in ``<sched.h>``
are supported:

* ``sched_get_priority_max()``
* ``sched_get_priority_min()``
* ``sched_rr_get_interval()``
* ``sched_yield()``

The following methods in ``<sched.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``sched_getparam()``
* ``sched_getscheduler()``
* ``sched_setparam()``
* ``sched_setscheduler()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_close()``
* ``sem_destroy()``
* ``sem_getvalue()``
* ``sem_init()``
* ``sem_open()``
* ``sem_post()``
* ``sem_timedwait()``
* ``sem_trywait()``
* ``sem_unlink()``
* ``sem_wait()``

## ``<setjmp.h>``

The following methods and variables in ``<setjmp.h>``
are supported:

* ``siglongjmp()``
* ``sigsetjmp()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``kill()``
* ``pthread_kill()``
* ``pthread_sigmask()``
* ``raise()``
* ``sigaction()``
* ``sigaddset()``
* ``sigdelset()``
* ``sigemptyset()``
* ``sigfillset()``
* ``sigismember()``
* ``sigpending()``
* ``sigqueue()``
* ``sigsuspend()``
* ``sigtimedwait()``
* ``sigwait()``
* ``sigwaitinfo()``

## ``<spawn.h>``

The following methods and variables in ``<spawn.h>``
are not supported:

* ``posix_spawn()``
* ``posix_spawnattr_destroy()``
* ``posix_spawnattr_getflags()``
* ``posix_spawnattr_getsigdefault()``
* ``posix_spawnattr_getsigmask()``
* ``posix_spawnattr_init()``
* ``posix_spawnattr_setflags()``
* ``posix_spawnattr_setsigdefault()``
* ``posix_spawnattr_setsigmask()``

## ``<stdarg.h>``

The following methods and variables in ``<stdarg.h>``
are supported:

* ``va_arg()``
* ``va_end()``
* ``va_start()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``fclose()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgets()``
* ``fileno()``
* ``flockfile()``
* ``fopen()``
* ``fprintf()``
* ``fread()``
* ``freopen()``
* ``fseek()``
* ``fseeko()``
* ``ftell()``
* ``ftello()``
* ``ftrylockfile()``
* ``funlockfile()``
* ``fwrite()``
* ``remove()``
* ``rename()``
* ``snprintf()``
* ``sscanf()``
* ``vfprintf()``
* ``vsnprintf()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``_Exit()``
* ``abort()``
* ``abs()``
* ``atexit()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``bsearch()``
* ``calloc()``
* ``div()``
* ``exit()``
* ``free()``
* ``getenv()``
* ``labs()``
* ``ldiv()``
* ``malloc()``
* ``rand_r()``
* ``realloc()``
* ``strtod()``
* ``strtol()``
* ``strtoul()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strcat()``
* ``strchr()``
* ``strcmp()``
* ``strcpy()``
* ``strcspn()``
* ``strerror_r()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok_r()``

## ``<sys/mman.h>``

The following methods and variables in ``<sys/mman.h>``
are supported:

* ``mlockall()``
* ``mmap()``
* ``shm_open()``

## ``<sys/select.h>``

The following methods and variables in ``<sys/select.h>``
are supported:

* ``FD_CLR()``
* ``FD_ISSET()``
* ``FD_SET()``
* ``FD_ZERO()``
* ``select()``

## ``<sys/socket.h>``

The following methods and variables in ``<sys/socket.h>``
are supported:

* ``accept()``
* ``bind()``
* ``connect()``
* ``getpeername()``
* ``getsockname()``
* ``getsockopt()``
* ``listen()``
* ``recv()``
* ``recvfrom()``
* ``send()``
* ``sendto()``
* ``setsockopt()``
* ``shutdown()``
* ``socket()``

## ``<sys/stat.h>``

The following methods and variables in ``<sys/stat.h>``
are supported:

* ``chmod()``
* ``fstat()``
* ``lstat()``
* ``mkdir()``
* ``mkfifo()``
* ``stat()``
* ``umask()``

## ``<sys/time.h>``

The following methods and variables in ``<sys/time.h>``
are supported:

* ``times()``

## ``<sys/utsname.h>``

The following methods and variables in ``<sys/utsname.h>``
are supported:

* ``uname()``

## ``<sys/wait.h>``

The following methods and variables in ``<sys/wait.h>``
are supported:

* ``waitpid()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime_r()``
* ``clock()``
* ``clock_getres()``
* ``clock_gettime()``
* ``clock_settime()``
* ``ctime_r()``
* ``difftime()``
* ``gmtime_r()``
* ``localtime_r()``
* ``mktime()``
* ``nanosleep()``
* ``strftime()``
* ``time()``
* ``timer_create()``
* ``timer_delete()``
* ``timer_getoverrun()``
* ``timer_gettime()``
* ``timer_settime()``
* ``tzname``
* ``tzset()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``_exit()``
* ``access()``
* ``alarm()``
* ``chdir()``
* ``chown()``
* ``close()``
* ``dup2()``
* ``environ``
* ``fsync()``
* ``ftruncate()``
* ``getcwd()``
* ``getegid()``
* ``geteuid()``
* ``getgid()``
* ``getgroups()``
* ``gethostname()``
* ``getpgrp()``
* ``getpid()``
* ``getppid()``
* ``getuid()``
* ``link()``
* ``lseek()``
* ``pause()``
* ``pipe()``
* ``read()``
* ``rmdir()``
* ``setegid()``
* ``seteuid()``
* ``setgid()``
* ``setuid()``
* ``sleep()``
* ``sysconf()``
* ``unlink()``
* ``write()``

The following methods in ``<unistd.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``execl()``
* ``execle()``
* ``execv()``
* ``execve()``
* ``fork()``
