
% SPDX-License-Identifier: CC-BY-SA-4.0

# POSIX PSE51 - Minimal


This chapter has a subsection per header file to detail the methods
provided by RTEMS that are in that header file.

The follow table summarizes alignment with the POSIX PSE51 - Minimal standard:

|   Support   |Amount|
|-------------|------|
|  Supported  |  282 |
|    ENOSYS   |   2  |
|Not supported|   1  |

## ``<ctype.h>``

The following methods and variables in ``<ctype.h>``
are supported:

* ``isalnum()``
* ``isalpha()``
* ``isblank()``
* ``iscntrl()``
* ``isdigit()``
* ``isgraph()``
* ``islower()``
* ``isprint()``
* ``ispunct()``
* ``isspace()``
* ``isupper()``
* ``isxdigit()``
* ``tolower()``
* ``toupper()``

## ``<errno.h>``

The following methods and variables in ``<errno.h>``
are supported:

* ``errno``

## ``<fcntl.h>``

The following methods and variables in ``<fcntl.h>``
are supported:

* ``open()``

## ``<fenv.h>``

The following methods and variables in ``<fenv.h>``
are supported:

* ``feclearexcept()``
* ``fegetenv()``
* ``fegetexceptflag()``
* ``fegetround()``
* ``feholdexcept()``
* ``feraiseexcept()``
* ``fesetenv()``
* ``fesetexceptflag()``
* ``fesetround()``
* ``fetestexcept()``
* ``feupdateenv()``

## ``<inttypes.h>``

The following methods and variables in ``<inttypes.h>``
are supported:

* ``imaxabs()``
* ``imaxdiv()``
* ``strtoimax()``
* ``strtoumax()``

## ``<locale.h>``

The following methods and variables in ``<locale.h>``
are supported:

* ``localeconv()``
* ``setlocale()``

## ``<pthread.h>``

The following methods and variables in ``<pthread.h>``
are supported:

* ``pthread_attr_destroy()``
* ``pthread_attr_getdetachstate()``
* ``pthread_attr_getguardsize()``
* ``pthread_attr_getinheritsched()``
* ``pthread_attr_getschedparam()``
* ``pthread_attr_getschedpolicy()``
* ``pthread_attr_getscope()``
* ``pthread_attr_getstack()``
* ``pthread_attr_getstackaddr()``
* ``pthread_attr_getstacksize()``
* ``pthread_attr_init()``
* ``pthread_attr_setdetachstate()``
* ``pthread_attr_setguardsize()``
* ``pthread_attr_setinheritsched()``
* ``pthread_attr_setschedparam()``
* ``pthread_attr_setschedpolicy()``
* ``pthread_attr_setscope()``
* ``pthread_attr_setstack()``
* ``pthread_attr_setstackaddr()``
* ``pthread_attr_setstacksize()``
* ``pthread_cancel()``
* ``pthread_cleanup_pop()``
* ``pthread_cleanup_push()``
* ``pthread_cond_broadcast()``
* ``pthread_cond_destroy()``
* ``pthread_cond_init()``
* ``pthread_cond_signal()``
* ``pthread_cond_timedwait()``
* ``pthread_cond_wait()``
* ``pthread_condattr_destroy()``
* ``pthread_condattr_getclock()``
* ``pthread_condattr_init()``
* ``pthread_condattr_setclock()``
* ``pthread_create()``
* ``pthread_detach()``
* ``pthread_equal()``
* ``pthread_exit()``
* ``pthread_getconcurrency()``
* ``pthread_getschedparam()``
* ``pthread_getspecific()``
* ``pthread_join()``
* ``pthread_key_create()``
* ``pthread_key_delete()``
* ``pthread_mutex_destroy()``
* ``pthread_mutex_getprioceiling()``
* ``pthread_mutex_init()``
* ``pthread_mutex_lock()``
* ``pthread_mutex_setprioceiling()``
* ``pthread_mutex_trylock()``
* ``pthread_mutex_unlock()``
* ``pthread_mutexattr_destroy()``
* ``pthread_mutexattr_getprioceiling()``
* ``pthread_mutexattr_getprotocol()``
* ``pthread_mutexattr_gettype()``
* ``pthread_mutexattr_init()``
* ``pthread_mutexattr_setprioceiling()``
* ``pthread_mutexattr_setprotocol()``
* ``pthread_mutexattr_settype()``
* ``pthread_once()``
* ``pthread_self()``
* ``pthread_setcancelstate()``
* ``pthread_setcanceltype()``
* ``pthread_setconcurrency()``
* ``pthread_setschedparam()``
* ``pthread_setschedprio()``
* ``pthread_setspecific()``
* ``pthread_testcancel()``

The following methods in ``<pthread.h>`` are implemented as
stubs returning ``-1`` and setting ``errno`` to ``ENOSYS``:

* ``pthread_atfork()``
* ``pthread_getcpuclockid()``

## ``<sched.h>``

The following methods and variables in ``<sched.h>``
are supported:

* ``sched_get_priority_max()``
* ``sched_get_priority_min()``
* ``sched_rr_get_interval()``

## ``<semaphore.h>``

The following methods and variables in ``<semaphore.h>``
are supported:

* ``sem_close()``
* ``sem_destroy()``
* ``sem_getvalue()``
* ``sem_init()``
* ``sem_open()``
* ``sem_post()``
* ``sem_timedwait()``
* ``sem_trywait()``
* ``sem_unlink()``
* ``sem_wait()``

## ``<setjmp.h>``

The following methods and variables in ``<setjmp.h>``
are supported:

* ``longjmp()``
* ``setjmp()``

## ``<signal.h>``

The following methods and variables in ``<signal.h>``
are supported:

* ``kill()``
* ``pthread_kill()``
* ``pthread_sigmask()``
* ``raise()``
* ``sigaction()``
* ``sigaddset()``
* ``sigdelset()``
* ``sigemptyset()``
* ``sigfillset()``
* ``sigismember()``
* ``signal()``
* ``sigpending()``
* ``sigprocmask()``
* ``sigqueue()``
* ``sigsuspend()``
* ``sigtimedwait()``
* ``sigwait()``
* ``sigwaitinfo()``

## ``<stdarg.h>``

The following methods and variables in ``<stdarg.h>``
are supported:

* ``va_arg()``
* ``va_copy()``
* ``va_end()``
* ``va_start()``

## ``<stddef.h>``

The following methods and variables in ``<stddef.h>``
are supported:

* ``offsetof()``

## ``<stdio.h>``

The following methods and variables in ``<stdio.h>``
are supported:

* ``clearerr()``
* ``fclose()``
* ``fdopen()``
* ``feof()``
* ``ferror()``
* ``fflush()``
* ``fgetc()``
* ``fgets()``
* ``fileno()``
* ``flockfile()``
* ``fopen()``
* ``fprintf()``
* ``fputc()``
* ``fputs()``
* ``fread()``
* ``freopen()``
* ``fscanf()``
* ``ftrylockfile()``
* ``funlockfile()``
* ``fwrite()``
* ``getc()``
* ``getc_unlocked()``
* ``getchar()``
* ``getchar_unlocked()``
* ``gets()``
* ``perror()``
* ``printf()``
* ``putc()``
* ``putc_unlocked()``
* ``putchar()``
* ``putchar_unlocked()``
* ``puts()``
* ``scanf()``
* ``setbuf()``
* ``setvbuf()``
* ``snprintf()``
* ``sprintf()``
* ``sscanf()``
* ``stderr``
* ``stdin``
* ``stdout``
* ``ungetc()``
* ``vfprintf()``
* ``vfscanf()``
* ``vprintf()``
* ``vscanf()``
* ``vsnprintf()``
* ``vsprintf()``
* ``vsscanf()``

## ``<stdlib.h>``

The following methods and variables in ``<stdlib.h>``
are supported:

* ``abort()``
* ``abs()``
* ``atof()``
* ``atoi()``
* ``atol()``
* ``atoll()``
* ``bsearch()``
* ``calloc()``
* ``div()``
* ``free()``
* ``getenv()``
* ``labs()``
* ``ldiv()``
* ``llabs()``
* ``lldiv()``
* ``malloc()``
* ``qsort()``
* ``rand()``
* ``rand_r()``
* ``realloc()``
* ``setenv()``
* ``srand()``
* ``strtod()``
* ``strtof()``
* ``strtol()``
* ``strtold()``
* ``strtoll()``
* ``strtoul()``
* ``strtoull()``
* ``unsetenv()``

## ``<string.h>``

The following methods and variables in ``<string.h>``
are supported:

* ``memchr()``
* ``memcmp()``
* ``memcpy()``
* ``memmove()``
* ``memset()``
* ``strcat()``
* ``strchr()``
* ``strcmp()``
* ``strcoll()``
* ``strcpy()``
* ``strcspn()``
* ``strerror()``
* ``strerror_r()``
* ``strlen()``
* ``strncat()``
* ``strncmp()``
* ``strncpy()``
* ``strpbrk()``
* ``strrchr()``
* ``strspn()``
* ``strstr()``
* ``strtok()``
* ``strtok_r()``
* ``strxfrm()``

## ``<sys/mman.h>``

The following methods and variables in ``<sys/mman.h>``
are supported:

* ``mlock()``
* ``mlockall()``
* ``mmap()``
* ``munlock()``
* ``munmap()``
* ``shm_open()``
* ``shm_unlink()``

## ``<sys/utsname.h>``

The following methods and variables in ``<sys/utsname.h>``
are supported:

* ``uname()``

## ``<time.h>``

The following methods and variables in ``<time.h>``
are supported:

* ``asctime()``
* ``asctime_r()``
* ``clock_getres()``
* ``clock_gettime()``
* ``clock_nanosleep()``
* ``clock_settime()``
* ``ctime()``
* ``ctime_r()``
* ``difftime()``
* ``gmtime()``
* ``gmtime_r()``
* ``localtime()``
* ``localtime_r()``
* ``mktime()``
* ``nanosleep()``
* ``strftime()``
* ``time()``
* ``timer_create()``
* ``timer_delete()``
* ``timer_getoverrun()``
* ``timer_gettime()``
* ``timer_settime()``
* ``tzname``
* ``tzset()``

## ``<unistd.h>``

The following methods and variables in ``<unistd.h>``
are supported:

* ``alarm()``
* ``close()``
* ``environ``
* ``fdatasync()``
* ``fsync()``
* ``pause()``
* ``read()``
* ``sysconf()``
* ``write()``

The following methods and variables in ``<unistd.h>``
are not supported:

* ``confstr()``
