% SPDX-License-Identifier: CC-BY-SA-4.0

# RTEMS Classic API Guide ({{ env.config.version }}).

```{topic} Copyrights and License
(c) 2017 Chris Johns

(c) 2017 Kuan-Hsun Chen

(c) 2015, 2020 embedded brains GmbH & Co. KG

(c) 2015, 2020 Sebastian Huber

(c) 2011 Petr Benes

(c) 2010 Gedare Bloom

(c) 1988, 2018 On-Line Applications Research Corporation (OAR)
```

```{include} ../common/license.md
```

```{include} ../common/header.md
```

```{toctree}
---
maxdepth: 5
numbered: 4
---
preface
overview
key_concepts
rtems_data_types
scheduling-concepts/index
initialization/index
task/index
interrupt/index
clock/index
timer/index
rate-monotonic/index
semaphore/index
barrier/index
message/index
event/index
signal/index
partition/index
region/index
dual-ported-memory/index
io/index
kernel-character-io/index
cache/index
fatal-error/index
board_support_packages
user-extensions/index
config/index
self_contained_objects
regulator/index
multiprocessing/index
symmetric_multiprocessing_services
pci_library
stack_bounds_checker
cpu_usage_statistics
object-services/index
chains
red_black_trees
timespec_helpers
constant_bandwidth_server
ada_support
linker_sets
directive_status_codes
example_application
glossary
zreferences
```
