/*
 * Copyright (c) 2007, Ralink Technology Corporation 
 * All rights reserved.
 * 
 * Redistribution.  Redistribution and use in binary form, without 
 * modification, are permitted provided that the following conditions are 
 * met:
 * 
 * * Redistributions must reproduce the above copyright notice and the 
 *   following disclaimer in the documentation and/or other materials 
 *   provided with the distribution. 
 * * Neither the name of Ralink Technology Corporation nor the names of its
 *   suppliers may be used to endorse or promote products derived from this
 *   software without specific prior written permission. 
 * * No reverse engineering, decompilation, or disassembly of this software 
 *   is permitted.
 * 
 * Limited patent license. Ralink Technology Corporation grants a world-wide, 
 * royalty-free, non-exclusive license under patents it now or hereafter 
 * owns or controls to make, have made, use, import, offer to sell and 
 * sell ("Utilize") this software, but solely to the extent that any 
 * such patent is necessary to Utilize the software alone, or in 
 * combination with an operating system licensed under an approved Open 
 * Source license as listed by the Open Source Initiative at 
 * http://opensource.org/licenses.  The patent license shall not apply to 
 * any other combinations which include this software.  No hardware per 
 * se is licensed hereunder.
 * 
 * DISCLAIMER.  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND 
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH 
 * DAMAGE.
 */
#include <machine/rtems-bsd-kernel-space.h>
#include <sys/types.h>
#include <sys/kernel.h>
#include <sys/firmware.h>

static const unsigned char runfw[] = {
	0xff, 0xff, 0xff, 0x02, 0x10, 0x28, 0x02, 0x10, 0x3b, 0x02, 0x10, 0x86, 
	0x02, 0x15, 0x5f, 0x02, 0x15, 0x60, 0x02, 0x16, 0x44, 0x02, 0x16, 0x8d, 
	0x12, 0x16, 0x45, 0x22, 0x02, 0x1b, 0xcf, 0x02, 0x1c, 0xf8, 0x02, 0x18, 
	0x1c, 0x02, 0x17, 0x57, 0x30, 0x05, 0x06, 0x20, 0x0d, 0x03, 0x12, 0x1d, 
	0xdd, 0x30, 0x07, 0x06, 0x20, 0x0f, 0x03, 0x12, 0x1e, 0x32, 0x22, 0x90, 
	0x01, 0x8c, 0xe0, 0x30, 0xe3, 0x20, 0xe5, 0x58, 0x30, 0xe0, 0x10, 0xe5, 
	0x4c, 0x30, 0xe0, 0x04, 0x7f, 0x40, 0x80, 0x02, 0x7f, 0x00, 0x90, 0x10, 
	0x2f, 0xef, 0xf0, 0x90, 0x01, 0x8c, 0x74, 0x08, 0xf0, 0xe4, 0x90, 0x01, 
	0xa7, 0xf0, 0x90, 0x01, 0x8c, 0xe0, 0x30, 0xe0, 0x1c, 0x90, 0x01, 0x80, 
	0xe0, 0xb4, 0x02, 0x15, 0xa3, 0xe0, 0xb4, 0x01, 0x10, 0x90, 0x01, 0x84, 
	0xe0, 0xb4, 0x81, 0x09, 0x90, 0x01, 0x8c, 0x74, 0x01, 0xf0, 0x12, 0x0d, 
	0xc8, 0x22, 0x90, 0x04, 0x14, 0xe0, 0x20, 0xe7, 0x03, 0x02, 0x15, 0x5e, 
	0x90, 0x70, 0x12, 0xe0, 0xf5, 0x56, 0x90, 0x04, 0x04, 0xe0, 0x12, 0x0a, 
	0x9d, 0x10, 0xf3, 0x31, 0x10, 0xd7, 0x36, 0x11, 0x1c, 0x50, 0x11, 0x53, 
	0x51, 0x11, 0x5c, 0x52, 0x11, 0x5c, 0x53, 0x11, 0x5c, 0x54, 0x11, 0x9d, 
	0x55, 0x11, 0xec, 0x56, 0x12, 0xaf, 0x64, 0x12, 0x4a, 0x65, 0x12, 0x75, 
	0x66, 0x12, 0xdb, 0x72, 0x13, 0xa3, 0x73, 0x13, 0xc8, 0x74, 0x14, 0xc4, 
	0x80, 0x14, 0xe7, 0x90, 0x15, 0x1c, 0x91, 0x00, 0x00, 0x15, 0x5e, 0x90, 
	0x70, 0x11, 0xe0, 0xf5, 0x3c, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0x90, 0x04, 
	0x14, 0x74, 0x80, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 
	0x02, 0x15, 0x57, 0x20, 0x02, 0x03, 0x30, 0x03, 0x1d, 0x7d, 0x02, 0xaf, 
	0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 
	0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 
	0x15, 0x57, 0x85, 0x56, 0x41, 0xd2, 0x02, 0x22, 0x90, 0x70, 0x10, 0xe0, 
	0x54, 0x7f, 0xff, 0xbf, 0x0a, 0x0d, 0x90, 0x70, 0x11, 0xe0, 0xb4, 0x08, 
	0x06, 0x75, 0x4e, 0x01, 0x75, 0x4f, 0x84, 0x90, 0x70, 0x10, 0xe0, 0x54, 
	0x7f, 0xff, 0xbf, 0x02, 0x12, 0x90, 0x70, 0x11, 0xe0, 0x64, 0x08, 0x60, 
	0x04, 0xe0, 0xb4, 0x20, 0x06, 0x75, 0x4e, 0x03, 0x75, 0x4f, 0x20, 0xe4, 
	0xf5, 0x3f, 0x22, 0x90, 0x70, 0x11, 0xe0, 0x24, 0xff, 0x92, 0x47, 0x22, 
	0x90, 0x04, 0x04, 0xe0, 0x25, 0xe0, 0x24, 0x5d, 0xf5, 0x57, 0x90, 0x70, 
	0x10, 0xe0, 0xff, 0x74, 0x47, 0x25, 0x57, 0xf8, 0xc6, 0xef, 0xc6, 0x90, 
	0x70, 0x11, 0xe0, 0xff, 0x74, 0x48, 0x25, 0x57, 0xf8, 0xc6, 0xef, 0xc6, 
	0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 
	0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 
	0x15, 0x5e, 0x02, 0x15, 0x57, 0xe5, 0x47, 0x64, 0x07, 0x60, 0x1d, 0xe5, 
	0x47, 0x64, 0x08, 0x60, 0x17, 0xe5, 0x47, 0x64, 0x09, 0x60, 0x11, 0xe5, 
	0x47, 0x64, 0x0a, 0x60, 0x0b, 0xe5, 0x47, 0x64, 0x0b, 0x60, 0x05, 0xe5, 
	0x47, 0xb4, 0x0c, 0x08, 0x90, 0x70, 0x11, 0xe0, 0x54, 0x0f, 0xf5, 0x3a, 
	0xe5, 0x47, 0xb4, 0x09, 0x08, 0xe5, 0x3a, 0xb4, 0x03, 0x03, 0xe4, 0xf5, 
	0x46, 0xe5, 0x47, 0xb4, 0x0a, 0x08, 0xe5, 0x3a, 0xb4, 0x01, 0x03, 0xe4, 
	0xf5, 0x46, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 0x91, 0xd2, 0x04, 0x22, 
	0x90, 0x70, 0x11, 0xe0, 0xf4, 0xff, 0x90, 0x70, 0x10, 0xe0, 0x5f, 0xff, 
	0x90, 0x70, 0x11, 0xe0, 0x55, 0x3f, 0x4f, 0x90, 0x70, 0x18, 0xf0, 0x90, 
	0x70, 0x11, 0xe0, 0x90, 0x70, 0x19, 0xf0, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 
	0x0b, 0x91, 0x30, 0x15, 0x04, 0xd2, 0x14, 0x80, 0x26, 0x90, 0x70, 0x18, 
	0xe0, 0xf5, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0xff, 0x90, 0x70, 0x19, 0xe0, 
	0xfe, 0xef, 0x5e, 0x90, 0x02, 0x29, 0xf0, 0x30, 0x47, 0x04, 0xaf, 0x3f, 
	0x80, 0x04, 0xe5, 0x3f, 0xf4, 0xff, 0x90, 0x02, 0x28, 0xef, 0xf0, 0xe5, 
	0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 0x70, 
	0x10, 0xe0, 0x13, 0x92, 0x1b, 0xc2, 0x1c, 0xad, 0x57, 0xaf, 0x56, 0x12, 
	0x0b, 0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0x30, 0x1b, 0x02, 0xd2, 
	0x07, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 
	0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 0x4c, 0xb1, 0xe0, 0x90, 0x4c, 0xbe, 
	0xf0, 0x90, 0x4c, 0xb8, 0xe0, 0x90, 0x4c, 0xbf, 0xf0, 0xe4, 0x90, 0x4c, 
	0xb1, 0xf0, 0x90, 0x4c, 0xb9, 0xe0, 0x90, 0x4c, 0xb8, 0xf0, 0xad, 0x57, 
	0xaf, 0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 
	0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 
	0x02, 0x15, 0x57, 0x90, 0x70, 0x10, 0xe0, 0xf5, 0x2a, 0x75, 0x3d, 0x03, 
	0x75, 0x3e, 0x1f, 0xe4, 0xf5, 0x2f, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 
	0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 
	0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 
	0x10, 0x00, 0xe0, 0xf5, 0x57, 0xe4, 0xf5, 0x58, 0xf5, 0x59, 0x90, 0x10, 
	0x03, 0xe0, 0xb4, 0x28, 0x05, 0x75, 0x58, 0x01, 0x80, 0x3c, 0x90, 0x10, 
	0x03, 0xe0, 0xb4, 0x30, 0x05, 0x75, 0x58, 0x02, 0x80, 0x30, 0x90, 0x10, 
	0x03, 0xe0, 0xb4, 0x33, 0x05, 0x75, 0x58, 0x04, 0x80, 0x24, 0x90, 0x10, 
	0x03, 0xe0, 0xb4, 0x35, 0x0c, 0x90, 0x10, 0x02, 0xe0, 0xb4, 0x72, 0x05, 
	0x75, 0x58, 0x08, 0x80, 0x11, 0x90, 0x10, 0x03, 0xe0, 0xb4, 0x35, 0x0a, 
	0x90, 0x10, 0x02, 0xe0, 0xb4, 0x93, 0x03, 0x75, 0x58, 0x10, 0xe5, 0x58, 
	0x30, 0xe1, 0x19, 0x90, 0x05, 0x08, 0xe0, 0x44, 0x01, 0xf0, 0xfd, 0x90, 
	0x05, 0x05, 0xe0, 0x54, 0xfb, 0xf0, 0x44, 0x04, 0xf0, 0xed, 0x54, 0xfe, 
	0x90, 0x05, 0x08, 0xf0, 0x75, 0x3b, 0x18, 0xe4, 0xf5, 0x26, 0xf5, 0x27, 
	0xc2, 0x1c, 0xc2, 0x1b, 0xf5, 0x4e, 0xf5, 0x4f, 0x75, 0x3a, 0xff, 0x75, 
	0x3c, 0xff, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 0x91, 0x90, 0x70, 0x36, 
	0x74, 0x37, 0xf0, 0xa3, 0x74, 0x32, 0xf0, 0x90, 0x04, 0x01, 0xe0, 0x44, 
	0x01, 0xf0, 0xc2, 0x16, 0xe4, 0xf5, 0x5c, 0xf5, 0x5a, 0xf5, 0x5b, 0x90, 
	0x70, 0x30, 0xf0, 0xa3, 0xf0, 0xf5, 0x2a, 0xc2, 0x17, 0x90, 0x04, 0x14, 
	0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 
	0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 0x70, 0x10, 0xe0, 0x24, 
	0xff, 0x92, 0x93, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 
	0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 
	0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 0x10, 0x00, 0xe0, 
	0x90, 0x10, 0x2c, 0xf0, 0x90, 0x10, 0x2f, 0x74, 0x40, 0xf0, 0x90, 0x70, 
	0x11, 0xe0, 0x54, 0x7f, 0xf5, 0x57, 0xe0, 0x54, 0x80, 0x90, 0x70, 0x32, 
	0xf0, 0x90, 0x70, 0x10, 0xe0, 0xff, 0xe5, 0x57, 0xd3, 0x9f, 0x40, 0x43, 
	0x90, 0x70, 0x33, 0xe5, 0x57, 0xf0, 0x90, 0x70, 0x10, 0xe0, 0xff, 0x90, 
	0x70, 0x33, 0xe0, 0xc3, 0x9f, 0xd3, 0x94, 0x04, 0x40, 0x73, 0xe0, 0x24, 
	0xfc, 0xf0, 0xe0, 0xff, 0x90, 0x70, 0x32, 0xe0, 0x4f, 0x90, 0x05, 0x00, 
	0xf0, 0xe5, 0x58, 0x54, 0x0f, 0x60, 0x04, 0x7f, 0x17, 0x80, 0x02, 0x7f, 
	0x11, 0x90, 0x05, 0x01, 0xef, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0x74, 0x03, 
	0xf0, 0xff, 0x12, 0x0d, 0x2a, 0x80, 0xc3, 0x90, 0x70, 0x33, 0xe5, 0x57, 
	0xf0, 0x90, 0x70, 0x33, 0xe0, 0xff, 0x90, 0x70, 0x10, 0xe0, 0xc3, 0x9f, 
	0xd3, 0x94, 0x04, 0x40, 0x30, 0x90, 0x70, 0x33, 0xe0, 0x24, 0x04, 0xf0, 
	0xe0, 0xff, 0x90, 0x70, 0x32, 0xe0, 0x4f, 0x90, 0x05, 0x00, 0xf0, 0xe5, 
	0x58, 0x54, 0x0f, 0x60, 0x04, 0x7f, 0x17, 0x80, 0x02, 0x7f, 0x11, 0x90, 
	0x05, 0x01, 0xef, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0x74, 0x03, 0xf0, 0xff, 
	0x12, 0x0d, 0x2a, 0x80, 0xc0, 0x90, 0x70, 0x10, 0xe0, 0xff, 0x90, 0x70, 
	0x32, 0xe0, 0x4f, 0x90, 0x05, 0x00, 0xf0, 0xe5, 0x58, 0x54, 0x0f, 0x60, 
	0x04, 0x7f, 0x17, 0x80, 0x02, 0x7f, 0x11, 0x90, 0x05, 0x01, 0xef, 0xf0, 
	0xa3, 0x74, 0x01, 0xf0, 0x74, 0x03, 0xf0, 0xff, 0x12, 0x0d, 0x2a, 0x90, 
	0x10, 0x00, 0xe0, 0x90, 0x10, 0x2c, 0xf0, 0x90, 0x10, 0x2f, 0x74, 0x7f, 
	0xf0, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 0x14, 0x74, 
	0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0x22, 0x90, 0x70, 0x10, 0xe0, 
	0x24, 0xff, 0x92, 0x4a, 0xd2, 0x05, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 
	0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 
	0xe5, 0x56, 0xf4, 0x60, 0x79, 0x80, 0x70, 0x90, 0x70, 0x10, 0xe0, 0x24, 
	0xff, 0x92, 0x16, 0x90, 0x70, 0x11, 0xe0, 0xf5, 0x5c, 0xad, 0x57, 0xaf, 
	0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0x90, 0x70, 
	0x30, 0xe5, 0x5a, 0xf0, 0xa3, 0xe5, 0x5b, 0xf0, 0xe4, 0xf5, 0x5a, 0xf5, 
	0x5b, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x60, 0x44, 0x80, 0x3b, 
	0x90, 0x70, 0x11, 0xe0, 0x24, 0xff, 0x92, 0x17, 0x90, 0x70, 0x10, 0xe0, 
	0xf5, 0x5d, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 0x91, 0x90, 0x04, 0x14, 
	0x74, 0x80, 0xf0, 0x30, 0x17, 0x13, 0x90, 0x10, 0x00, 0xe0, 0x90, 0x10, 
	0x2c, 0xf0, 0x90, 0x10, 0x2f, 0xe0, 0x54, 0xf0, 0xf5, 0x57, 0x45, 0x5d, 
	0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x60, 0x07, 0x90, 
	0x70, 0x25, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x22, 0xe5, 0x3e, 0x45, 0x3d, 
	0x60, 0x0a, 0xe5, 0x3e, 0x15, 0x3e, 0x70, 0x0a, 0x15, 0x3d, 0x80, 0x06, 
	0x75, 0x3d, 0x03, 0x75, 0x3e, 0x1f, 0xe5, 0x3e, 0x45, 0x3d, 0x60, 0x03, 
	0x02, 0x16, 0x0e, 0xe5, 0x2a, 0x70, 0x03, 0x02, 0x16, 0x0e, 0x74, 0xa0, 
	0x25, 0x2f, 0xf5, 0x82, 0xe4, 0x34, 0x4c, 0xf5, 0x83, 0xe0, 0x60, 0x7a, 
	0x7f, 0x7e, 0x12, 0x17, 0x3e, 0xef, 0x54, 0xfe, 0x44, 0x02, 0xfd, 0x7f, 
	0x7e, 0x12, 0x17, 0x24, 0xe5, 0x2f, 0x7f, 0x00, 0x25, 0xe0, 0xfe, 0xef, 
	0x24, 0x00, 0xf5, 0x82, 0x74, 0x4d, 0x3e, 0xaf, 0x82, 0x90, 0x4c, 0xa8, 
	0xf0, 0xa3, 0xef, 0xf0, 0xe4, 0xf5, 0x56, 0xf5, 0x57, 0x7f, 0x7f, 0x12, 
	0x17, 0x3e, 0x90, 0x4c, 0xa8, 0xe0, 0xfa, 0xa3, 0xe0, 0x25, 0x57, 0xf5, 
	0x82, 0xea, 0x35, 0x56, 0xf5, 0x83, 0xef, 0xf0, 0x05, 0x57, 0xe5, 0x57, 
	0x70, 0x02, 0x05, 0x56, 0xc3, 0x94, 0x80, 0xe5, 0x56, 0x94, 0x01, 0x40, 
	0xd8, 0x7f, 0x7e, 0x12, 0x17, 0x3e, 0xef, 0x44, 0x03, 0xfd, 0x7f, 0x7e, 
	0x12, 0x17, 0x24, 0x74, 0xa0, 0x25, 0x2f, 0xf5, 0x82, 0xe4, 0x34, 0x4c, 
	0xf5, 0x83, 0xe4, 0xf0, 0x05, 0x2f, 0xe5, 0x2f, 0xb4, 0x08, 0x03, 0xe4, 
	0xf5, 0x2f, 0xe5, 0x3b, 0x60, 0x04, 0x15, 0x3b, 0x80, 0x03, 0x75, 0x3b, 
	0xfe, 0xe5, 0x3b, 0x70, 0x08, 0x20, 0x07, 0x05, 0x30, 0x1b, 0x02, 0xd2, 
	0x07, 0xe5, 0x53, 0x70, 0x1a, 0x30, 0x60, 0x09, 0xb2, 0x4d, 0x30, 0x4d, 
	0x04, 0x05, 0x46, 0xc2, 0x04, 0xe5, 0x4f, 0x45, 0x4e, 0x60, 0x08, 0xe5, 
	0x4f, 0x15, 0x4f, 0x70, 0x02, 0x15, 0x4e, 0x22, 0x22, 0xe5, 0x31, 0x24, 
	0xee, 0x60, 0x0f, 0x14, 0x60, 0x10, 0x14, 0x60, 0x12, 0x24, 0x04, 0x70, 
	0x18, 0x12, 0x16, 0x71, 0x80, 0x15, 0xc2, 0x45, 0x80, 0x11, 0xe4, 0xf5, 
	0x21, 0x80, 0x0c, 0xd2, 0x09, 0xd2, 0x0a, 0xd2, 0x0b, 0xd2, 0x0c, 0x80, 
	0x02, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x04, 0x02, 0xe0, 0x44, 0x08, 0xf0, 
	0x85, 0x39, 0x82, 0x85, 0x38, 0x83, 0xe5, 0x33, 0xf0, 0xe5, 0x32, 0xa3, 
	0xf0, 0x90, 0x04, 0x02, 0xe0, 0x54, 0xf7, 0xf0, 0x22, 0x30, 0x14, 0x30, 
	0x90, 0x70, 0x19, 0xe0, 0x55, 0x3f, 0xff, 0x90, 0x70, 0x18, 0xe0, 0x4f, 
	0xf5, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0xff, 0x90, 0x70, 0x19, 0xe0, 0xfe, 
	0xef, 0x5e, 0x90, 0x02, 0x29, 0xf0, 0x30, 0x47, 0x04, 0xaf, 0x3f, 0x80, 
	0x04, 0xe5, 0x3f, 0xf4, 0xff, 0x90, 0x02, 0x28, 0xef, 0xf0, 0xc2, 0x14, 
	0x30, 0x16, 0x60, 0xc2, 0xaf, 0x90, 0x10, 0x04, 0xe0, 0xf5, 0x57, 0x90, 
	0x02, 0x28, 0xe0, 0x54, 0x05, 0xf5, 0x57, 0xe5, 0x5c, 0x64, 0x01, 0x70, 
	0x21, 0xe5, 0x57, 0x90, 0x10, 0x04, 0x30, 0xe0, 0x06, 0xe0, 0x54, 0xfb, 
	0xf0, 0x80, 0x04, 0xe0, 0x44, 0x04, 0xf0, 0xe5, 0x57, 0x30, 0xe2, 0x31, 
	0x05, 0x5b, 0xe5, 0x5b, 0x70, 0x2b, 0x05, 0x5a, 0x80, 0x27, 0xe5, 0x57, 
	0x30, 0xe0, 0x1b, 0xe5, 0x5c, 0x90, 0x10, 0x04, 0x70, 0x06, 0xe0, 0x54, 
	0xfb, 0xf0, 0x80, 0x04, 0xe0, 0x44, 0x04, 0xf0, 0x05, 0x5b, 0xe5, 0x5b, 
	0x70, 0x0b, 0x05, 0x5a, 0x80, 0x07, 0x90, 0x10, 0x04, 0xe0, 0x44, 0x04, 
	0xf0, 0xd2, 0xaf, 0x22, 0x90, 0x10, 0x1c, 0xed, 0xf0, 0xa3, 0xef, 0xf0, 
	0xa3, 0x74, 0x0a, 0xf0, 0x90, 0x10, 0x1c, 0xe0, 0xf5, 0x58, 0x90, 0x10, 
	0x1e, 0xe0, 0x20, 0xe1, 0xf3, 0x22, 0x90, 0x10, 0x1d, 0xef, 0xf0, 0xa3, 
	0x74, 0x0b, 0xf0, 0x90, 0x10, 0x1c, 0xe0, 0xf5, 0x58, 0x90, 0x10, 0x1e, 
	0xe0, 0x20, 0xe1, 0xf3, 0xaf, 0x58, 0x22, 0xc2, 0x4b, 0xc2, 0x4c, 0xe5, 
	0x44, 0x12, 0x0a, 0x9d, 0x17, 0x79, 0x00, 0x18, 0x07, 0x04, 0x18, 0x03, 
	0x08, 0x17, 0xe3, 0x10, 0x17, 0x8d, 0x20, 0x17, 0xad, 0x60, 0x17, 0xbe, 
	0xa0, 0x00, 0x00, 0x18, 0x09, 0x85, 0x48, 0x43, 0x85, 0x4a, 0x42, 0x85, 
	0x4c, 0x5e, 0xe5, 0x47, 0x64, 0x06, 0x60, 0x03, 0x02, 0x18, 0x09, 0x80, 
	0x1b, 0xe5, 0x48, 0xc4, 0x54, 0x0f, 0xf5, 0x43, 0xe5, 0x4a, 0xc4, 0x54, 
	0x0f, 0xf5, 0x42, 0xe5, 0x4c, 0xc4, 0x54, 0x0f, 0xf5, 0x5e, 0xe5, 0x47, 
	0x64, 0x06, 0x70, 0x61, 0x53, 0x43, 0x0f, 0x80, 0x5c, 0x85, 0x49, 0x43, 
	0x85, 0x4b, 0x42, 0x85, 0x4d, 0x5e, 0xe5, 0x47, 0x64, 0x06, 0x70, 0x4d, 
	0x80, 0x1b, 0xe5, 0x49, 0xc4, 0x54, 0x0f, 0xf5, 0x43, 0xe5, 0x4b, 0xc4, 
	0x54, 0x0f, 0xf5, 0x42, 0xe5, 0x4d, 0xc4, 0x54, 0x0f, 0xf5, 0x5e, 0xe5, 
	0x47, 0x64, 0x06, 0x70, 0x30, 0xe5, 0x43, 0x54, 0x0f, 0x44, 0x10, 0xf5, 
	0x43, 0x80, 0x26, 0xe5, 0x47, 0x64, 0x04, 0x60, 0x05, 0xe5, 0x47, 0xb4, 
	0x05, 0x06, 0x43, 0x5e, 0x04, 0x75, 0x42, 0x09, 0xe5, 0x47, 0xb4, 0x06, 
	0x10, 0xe5, 0x43, 0x54, 0x0f, 0x44, 0x30, 0xf5, 0x43, 0x80, 0x06, 0xd2, 
	0x4b, 0x80, 0x02, 0xd2, 0x4c, 0xe4, 0xf5, 0x25, 0xe5, 0x42, 0xc4, 0x54, 
	0xf0, 0xff, 0xe5, 0x43, 0x54, 0x0f, 0x4f, 0xf5, 0x5f, 0xd2, 0x60, 0x22, 
	0xd2, 0x15, 0xe5, 0x47, 0x24, 0xf5, 0x60, 0x0b, 0x24, 0xcb, 0x60, 0x07, 
	0x24, 0x40, 0x70, 0x06, 0xc2, 0x15, 0x22, 0x12, 0x1b, 0x9a, 0x12, 0x18, 
	0x3e, 0xc2, 0x15, 0xc2, 0xaf, 0xc2, 0x04, 0xd2, 0xaf, 0x22, 0xc2, 0xaf, 
	0x90, 0x04, 0x14, 0xe0, 0x54, 0x0e, 0x60, 0x04, 0xd2, 0x18, 0x80, 0x08, 
	0xe5, 0x4e, 0x45, 0x4f, 0x24, 0xff, 0x92, 0x18, 0xd2, 0xaf, 0x90, 0x04, 
	0x14, 0xe0, 0xa2, 0xe4, 0x92, 0x19, 0x74, 0x1e, 0xf0, 0xe5, 0x5f, 0x54, 
	0x0f, 0xf5, 0x2d, 0xe5, 0x25, 0x70, 0x13, 0x30, 0x18, 0x05, 0xe5, 0x5f, 
	0x20, 0xe5, 0x0b, 0x30, 0x19, 0x19, 0xe5, 0x5f, 0x54, 0x30, 0xff, 0xbf, 
	0x30, 0x11, 0xe5, 0x25, 0x70, 0x05, 0x75, 0x25, 0x0c, 0x80, 0x02, 0x15, 
	0x25, 0xd2, 0x6c, 0xd2, 0x6d, 0x80, 0x0f, 0xe5, 0x5f, 0x30, 0xe6, 0x06, 
	0xc2, 0x6c, 0xd2, 0x6d, 0x80, 0x04, 0xd2, 0x6c, 0xc2, 0x6d, 0xe5, 0x47, 
	0x64, 0x03, 0x70, 0x21, 0x30, 0x4b, 0x06, 0xc2, 0x6c, 0xd2, 0x6d, 0x80, 
	0x18, 0xe5, 0x25, 0x70, 0x03, 0x30, 0x4c, 0x11, 0xc2, 0x4c, 0xe5, 0x25, 
	0x70, 0x05, 0x75, 0x25, 0x07, 0x80, 0x02, 0x15, 0x25, 0xd2, 0x6c, 0xd2, 
	0x6d, 0xe5, 0x47, 0xb4, 0x09, 0x14, 0xe5, 0x44, 0x20, 0xe3, 0x0b, 0xe5, 
	0x3a, 0x64, 0x02, 0x60, 0x05, 0xe5, 0x3a, 0xb4, 0x03, 0x04, 0xc2, 0x6c, 
	0xd2, 0x6d, 0xe5, 0x47, 0xb4, 0x0a, 0x13, 0xe5, 0x3a, 0xb4, 0x01, 0x06, 
	0xc2, 0x6c, 0xd2, 0x6d, 0x80, 0x08, 0xe5, 0x3a, 0x70, 0x04, 0xd2, 0x6c, 
	0xc2, 0x6d, 0x20, 0x69, 0x07, 0xe5, 0x5e, 0x20, 0xe0, 0x02, 0xb2, 0x68, 
	0x20, 0x6b, 0x07, 0xe5, 0x5e, 0x20, 0xe1, 0x02, 0xb2, 0x6a, 0x20, 0x6d, 
	0x07, 0xe5, 0x5e, 0x20, 0xe2, 0x02, 0xb2, 0x6c, 0x75, 0x2e, 0x40, 0x20, 
	0x69, 0x04, 0xa2, 0x68, 0x80, 0x26, 0x30, 0x68, 0x06, 0xe5, 0x46, 0xa2, 
	0xe2, 0x80, 0x1d, 0xe5, 0x5e, 0x20, 0xe0, 0x04, 0x7f, 0x01, 0x80, 0x02, 
	0x7f, 0x00, 0xe5, 0x46, 0x54, 0xf0, 0xfe, 0xbe, 0xf0, 0x04, 0x7e, 0x01, 
	0x80, 0x02, 0x7e, 0x00, 0xee, 0x6f, 0x24, 0xff, 0x92, 0x73, 0x92, 0x72, 
	0x20, 0x6b, 0x04, 0xa2, 0x6a, 0x80, 0x26, 0x30, 0x6a, 0x06, 0xe5, 0x46, 
	0xa2, 0xe2, 0x80, 0x1d, 0xe5, 0x5e, 0x20, 0xe1, 0x04, 0x7f, 0x01, 0x80, 
	0x02, 0x7f, 0x00, 0xe5, 0x46, 0x54, 0xf0, 0xfe, 0xbe, 0xf0, 0x04, 0x7e, 
	0x01, 0x80, 0x02, 0x7e, 0x00, 0xee, 0x6f, 0x24, 0xff, 0x92, 0x75, 0x92, 
	0x74, 0x20, 0x6d, 0x04, 0xa2, 0x6c, 0x80, 0x26, 0xe5, 0x47, 0x64, 0x0a, 
	0x70, 0x22, 0x30, 0x6c, 0x06, 0xe5, 0x46, 0xa2, 0xe3, 0x80, 0x17, 0xe5, 
	0x3a, 0xb4, 0x01, 0x06, 0xe5, 0x46, 0xa2, 0xe3, 0x80, 0x34, 0xe5, 0x46, 
	0x20, 0xe4, 0x03, 0x30, 0xe5, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x80, 0x26, 
	0x30, 0x6c, 0x06, 0xe5, 0x46, 0xa2, 0xe2, 0x80, 0x1d, 0xe5, 0x5e, 0x20, 
	0xe2, 0x04, 0x7f, 0x01, 0x80, 0x02, 0x7f, 0x00, 0xe5, 0x46, 0x54, 0xf0, 
	0xfe, 0xbe, 0xf0, 0x04, 0x7e, 0x01, 0x80, 0x02, 0x7e, 0x00, 0xee, 0x6f, 
	0x24, 0xff, 0x92, 0x71, 0x92, 0x70, 0x90, 0x10, 0x00, 0xe0, 0x90, 0x10, 
	0x2c, 0xf0, 0x90, 0x10, 0x03, 0xe0, 0xc3, 0x94, 0x30, 0x40, 0x19, 0xe0, 
	0x64, 0x32, 0x60, 0x14, 0xa2, 0x71, 0x92, 0x77, 0xa2, 0x70, 0x92, 0x76, 
	0xe5, 0x2e, 0x13, 0x13, 0x54, 0x3f, 0xf5, 0x2e, 0xc2, 0x77, 0xd2, 0x76, 
	0x30, 0x17, 0x0d, 0x53, 0x2e, 0xf0, 0xe5, 0x2e, 0x45, 0x5d, 0x90, 0x10, 
	0x2f, 0xf0, 0x80, 0x06, 0x90, 0x10, 0x2f, 0xe5, 0x2e, 0xf0, 0xe5, 0x47, 
	0x64, 0x06, 0x70, 0x47, 0x90, 0x02, 0x28, 0xe0, 0x30, 0x47, 0x03, 0xff, 
	0x80, 0x02, 0xf4, 0xff, 0x8f, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0x54, 0xfe, 
	0xf0, 0xe5, 0x43, 0xc4, 0x54, 0x0f, 0x14, 0x60, 0x0c, 0x24, 0xfe, 0x60, 
	0x0c, 0x24, 0x03, 0x70, 0x13, 0xc2, 0xf8, 0x80, 0x0f, 0xd2, 0xf8, 0x80, 
	0x0b, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0xf8, 
	0x30, 0x47, 0x05, 0xaf, 0x3f, 0x02, 0x1b, 0x94, 0xe5, 0x3f, 0xf4, 0xff, 
	0x02, 0x1b, 0x94, 0xe5, 0x47, 0x64, 0x07, 0x60, 0x0f, 0xe5, 0x47, 0x64, 
	0x08, 0x60, 0x09, 0xe5, 0x47, 0x64, 0x09, 0x60, 0x03, 0x02, 0x1b, 0x02, 
	0x90, 0x02, 0x28, 0xe0, 0x30, 0x47, 0x03, 0xff, 0x80, 0x02, 0xf4, 0xff, 
	0x8f, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0x54, 0xfc, 0xf0, 0xe5, 0x3a, 0x14, 
	0x60, 0x22, 0x14, 0x60, 0x25, 0x14, 0x60, 0x2d, 0x24, 0xfc, 0x60, 0x49, 
	0x24, 0xf9, 0x60, 0x14, 0x24, 0x0e, 0x70, 0x50, 0xe5, 0x46, 0x13, 0x13, 
	0x54, 0x3f, 0x75, 0xf0, 0x03, 0x84, 0xe5, 0xf0, 0x24, 0xff, 0x80, 0x3a, 
	0xd2, 0xf9, 0xc2, 0xf8, 0x80, 0x3e, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 
	0x80, 0x1d, 0xc3, 0x80, 0x1a, 0xe5, 0x46, 0x30, 0xe2, 0x0d, 0x54, 0x38, 
	0xc3, 0x94, 0x30, 0x50, 0x06, 0x7e, 0x00, 0x7f, 0x01, 0x80, 0x04, 0x7e, 
	0x00, 0x7f, 0x00, 0xee, 0x4f, 0x24, 0xff, 0x92, 0xf8, 0xc2, 0xf9, 0x80, 
	0x13, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0xf9, 
	0xc2, 0xf8, 0x80, 0x04, 0xc2, 0xf8, 0xc2, 0xf9, 0x30, 0x47, 0x04, 0xaf, 
	0x3f, 0x80, 0x04, 0xe5, 0x3f, 0xf4, 0xff, 0x02, 0x1b, 0x94, 0xe5, 0x47, 
	0x64, 0x0c, 0x60, 0x09, 0xe5, 0x47, 0x64, 0x0b, 0x60, 0x03, 0x02, 0x1b, 
	0x99, 0x90, 0x02, 0x28, 0xe0, 0x30, 0x47, 0x03, 0xff, 0x80, 0x02, 0xf4, 
	0xff, 0x8f, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0x54, 0xfd, 0xf0, 0xe5, 0x3a, 
	0x14, 0x60, 0x20, 0x14, 0x60, 0x21, 0x14, 0x60, 0x2b, 0x24, 0xfc, 0x60, 
	0x45, 0x24, 0xf9, 0x60, 0x12, 0x24, 0x0e, 0x70, 0x4a, 0xe5, 0x46, 0x13, 
	0x13, 0x54, 0x3f, 0x75, 0xf0, 0x03, 0x84, 0xe5, 0xf0, 0x80, 0x29, 0xd2, 
	0xf9, 0x80, 0x3a, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 0x80, 0x01, 0xc3, 
	0x92, 0xf9, 0x80, 0x2d, 0xe5, 0x46, 0x30, 0xe2, 0x0d, 0x54, 0x38, 0xc3, 
	0x94, 0x30, 0x50, 0x06, 0x7e, 0x00, 0x7f, 0x01, 0x80, 0x04, 0x7e, 0x00, 
	0x7f, 0x00, 0xee, 0x4f, 0x24, 0xff, 0x92, 0xf9, 0x80, 0x0f, 0xe5, 0x46, 
	0x30, 0xe2, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0xf9, 0x80, 0x02, 0xc2, 
	0xf9, 0x30, 0x47, 0x04, 0xaf, 0x3f, 0x80, 0x04, 0xe5, 0x3f, 0xf4, 0xff, 
	0x90, 0x02, 0x28, 0xef, 0xf0, 0x22, 0xe5, 0x47, 0xb4, 0x0b, 0x10, 0x90, 
	0x02, 0x29, 0xe0, 0x54, 0xeb, 0xf0, 0xe5, 0x3f, 0x54, 0xeb, 0x45, 0x45, 
	0xf5, 0x3f, 0x22, 0xe4, 0x90, 0x02, 0x29, 0xf0, 0x30, 0x47, 0x04, 0xaf, 
	0x45, 0x80, 0x04, 0xe5, 0x45, 0xf4, 0xff, 0x90, 0x02, 0x28, 0xef, 0xf0, 
	0x22, 0x8f, 0x50, 0xd2, 0x59, 0x22, 0x8f, 0x54, 0xd2, 0x58, 0x22, 0xe4, 
	0xf5, 0x62, 0xc2, 0xaf, 0xe5, 0x51, 0x14, 0x60, 0x4b, 0x14, 0x60, 0x6c, 
	0x24, 0x02, 0x60, 0x03, 0x02, 0x1c, 0xdc, 0xd2, 0x59, 0x75, 0x55, 0x01, 
	0x90, 0x02, 0xa2, 0xe0, 0x54, 0x7f, 0xf0, 0xa3, 0xe0, 0x20, 0xe7, 0x23, 
	0x90, 0x04, 0x34, 0xe0, 0xb4, 0x02, 0x1c, 0xa3, 0xe0, 0xb4, 0x02, 0x17, 
	0xa3, 0xe0, 0xb4, 0x02, 0x12, 0x7f, 0x20, 0x12, 0x1b, 0xc5, 0x90, 0x10, 
	0x04, 0xe0, 0x54, 0xf3, 0xf0, 0x75, 0x51, 0x01, 0x02, 0x1c, 0xdc, 0xe5, 
	0x50, 0x60, 0x03, 0x02, 0x1c, 0xdc, 0x75, 0x62, 0x03, 0x02, 0x1c, 0xdc, 
	0x90, 0x12, 0x00, 0xe0, 0x54, 0x03, 0x70, 0x12, 0x7f, 0x20, 0x12, 0x1b, 
	0xc5, 0x90, 0x02, 0xa2, 0xe0, 0x54, 0xbf, 0xf0, 0x75, 0x51, 0x02, 0x02, 
	0x1c, 0xdc, 0xe5, 0x50, 0x60, 0x03, 0x02, 0x1c, 0xdc, 0x02, 0x1c, 0xd7, 
	0x90, 0x02, 0xa3, 0xe0, 0x30, 0xe6, 0x03, 0x02, 0x1c, 0xd3, 0x90, 0x04, 
	0x37, 0xe0, 0x64, 0x22, 0x70, 0x79, 0x90, 0x01, 0x8a, 0x74, 0x7e, 0xf0, 
	0x90, 0x01, 0x96, 0xf0, 0x90, 0x12, 0x04, 0x74, 0x0a, 0xf0, 0x90, 0x13, 
	0x28, 0xe0, 0x90, 0x70, 0x1a, 0xf0, 0x90, 0x13, 0x29, 0xe0, 0x90, 0x70, 
	0x1b, 0xf0, 0x90, 0x13, 0x2b, 0xe0, 0x90, 0x70, 0x22, 0xf0, 0x90, 0x13, 
	0x28, 0xe0, 0x54, 0xf0, 0xf0, 0xa3, 0xe0, 0x54, 0xf0, 0xf0, 0x90, 0x13, 
	0x2b, 0xe0, 0x54, 0xcc, 0xf0, 0xe5, 0x58, 0x30, 0xe3, 0x13, 0xe5, 0x3c, 
	0xf4, 0x90, 0x13, 0x2a, 0x60, 0x05, 0xe0, 0x54, 0xf3, 0x80, 0x11, 0xe0, 
	0x54, 0xfb, 0xf0, 0x80, 0x14, 0xe5, 0x3c, 0xf4, 0x90, 0x13, 0x2a, 0x60, 
	0x08, 0xe0, 0x54, 0xf2, 0x45, 0x3c, 0xf0, 0x80, 0x04, 0xe0, 0x54, 0xfa, 
	0xf0, 0x90, 0x04, 0x01, 0xe0, 0x54, 0xfd, 0xf0, 0x75, 0x62, 0x01, 0x75, 
	0x55, 0x02, 0xe4, 0xf5, 0x51, 0x80, 0x09, 0xe5, 0x50, 0x70, 0x05, 0x75, 
	0x62, 0x03, 0xf5, 0x51, 0xe5, 0x62, 0x60, 0x15, 0xc2, 0x01, 0xe4, 0xf5, 
	0x51, 0xc2, 0x59, 0xad, 0x62, 0xaf, 0x40, 0x12, 0x1d, 0xa9, 0xe5, 0x62, 
	0xb4, 0x03, 0x02, 0xd2, 0x03, 0xd2, 0xaf, 0x22, 0xc2, 0xaf, 0x30, 0x01, 
	0x12, 0xe4, 0x90, 0x01, 0x96, 0xf0, 0xf5, 0x51, 0xc2, 0x59, 0xc2, 0x01, 
	0x7d, 0x02, 0xaf, 0x40, 0x12, 0x1d, 0xa9, 0xe5, 0x52, 0x14, 0x60, 0x0c, 
	0x04, 0x60, 0x03, 0x02, 0x1d, 0xa6, 0x75, 0x52, 0x01, 0x75, 0x55, 0x03, 
	0x90, 0x04, 0x01, 0xe0, 0x44, 0x0e, 0xf0, 0xe5, 0x58, 0x54, 0x18, 0x60, 
	0x1e, 0x90, 0x70, 0x1a, 0xe0, 0x90, 0x13, 0x28, 0xf0, 0x90, 0x70, 0x1b, 
	0xe0, 0x90, 0x13, 0x29, 0xf0, 0xa3, 0x74, 0x05, 0xf0, 0x90, 0x70, 0x22, 
	0xe0, 0x90, 0x13, 0x2b, 0xf0, 0x80, 0x11, 0x90, 0x13, 0x28, 0xe0, 0x44, 
	0x0f, 0xf0, 0xa3, 0xe0, 0x44, 0x0f, 0xf0, 0xa3, 0xe0, 0x44, 0x05, 0xf0, 
	0x90, 0x12, 0x04, 0x74, 0x03, 0xf0, 0xe5, 0x58, 0x30, 0xe3, 0x16, 0x90, 
	0x05, 0x00, 0x74, 0x80, 0xf0, 0xa3, 0x74, 0x08, 0xf0, 0xa3, 0x74, 0x01, 
	0xf0, 0x74, 0x03, 0xf0, 0x7f, 0x01, 0x12, 0x0d, 0x2a, 0x90, 0x02, 0xa2, 
	0xe0, 0x44, 0xc0, 0xf0, 0x90, 0x10, 0x04, 0xe0, 0x44, 0x0c, 0xf0, 0xe4, 
	0xf5, 0x52, 0xf5, 0x55, 0x30, 0x02, 0x09, 0xc2, 0x02, 0x7d, 0x01, 0xaf, 
	0x41, 0x12, 0x1d, 0xa9, 0x30, 0x03, 0x02, 0xc2, 0x03, 0xe4, 0x90, 0x01, 
	0x96, 0xf0, 0xd2, 0xaf, 0x22, 0xef, 0xf4, 0x60, 0x2d, 0xe4, 0xfe, 0x74, 
	0x14, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x70, 0xf5, 0x83, 0xe0, 0xb4, 0xff, 
	0x19, 0x74, 0x14, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x70, 0xf5, 0x83, 0xef, 
	0xf0, 0x74, 0x1c, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x70, 0xf5, 0x83, 0xed, 
	0xf0, 0x22, 0x0e, 0xbe, 0x04, 0xd5, 0x22, 0x22, 0x22, 0x90, 0x70, 0x2a, 
	0xe0, 0x30, 0xe1, 0x4d, 0xc2, 0xaf, 0x90, 0x70, 0x28, 0xe0, 0x90, 0x10, 
	0x1c, 0xf0, 0x90, 0x70, 0x29, 0xe0, 0x90, 0x10, 0x1d, 0xf0, 0x90, 0x70, 
	0x2a, 0xe0, 0x90, 0x10, 0x1e, 0xf0, 0x90, 0x10, 0x1c, 0xe0, 0xf5, 0x62, 
	0x90, 0x10, 0x1e, 0xe0, 0x20, 0xe1, 0xf3, 0x90, 0x10, 0x1c, 0xe0, 0x90, 
	0x70, 0x28, 0xf0, 0x90, 0x10, 0x1d, 0xe0, 0x90, 0x70, 0x29, 0xf0, 0x90, 
	0x10, 0x1e, 0xe0, 0x90, 0x70, 0x2a, 0xf0, 0x30, 0x4a, 0x07, 0x90, 0x70, 
	0x24, 0xe0, 0x44, 0x01, 0xf0, 0xc2, 0x05, 0xd2, 0xaf, 0x22, 0x20, 0x1c, 
	0x5a, 0x7d, 0x05, 0x12, 0x1f, 0x73, 0x90, 0x4c, 0xb0, 0x12, 0x1f, 0x64, 
	0x90, 0x4c, 0xbb, 0xef, 0xf0, 0x7d, 0x03, 0x12, 0x1f, 0x73, 0x90, 0x4c, 
	0xbc, 0x12, 0x1f, 0x64, 0x90, 0x4c, 0xbd, 0xef, 0xf0, 0x7d, 0x09, 0x12, 
	0x1f, 0x7e, 0x90, 0x4c, 0xb7, 0xef, 0xf0, 0x7d, 0x08, 0x12, 0x1f, 0x7e, 
	0x90, 0x4c, 0xb6, 0xef, 0xf0, 0x7d, 0x07, 0x12, 0x1f, 0x99, 0x90, 0x4c, 
	0xb5, 0xef, 0xf0, 0x7d, 0x06, 0x12, 0x1f, 0x99, 0x90, 0x4c, 0xb4, 0xef, 
	0xf0, 0xe4, 0x90, 0x4c, 0xb1, 0xf0, 0x90, 0x4c, 0xb9, 0xe0, 0x90, 0x4c, 
	0xb8, 0xf0, 0xd2, 0x1c, 0xc2, 0x07, 0x22, 0x7d, 0x01, 0x7f, 0xb8, 0x12, 
	0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0xef, 0x64, 0x01, 0x60, 0x03, 
	0x02, 0x1f, 0x59, 0xd3, 0x90, 0x4c, 0xb3, 0xe0, 0x95, 0x27, 0x90, 0x4c, 
	0xb2, 0xe0, 0x95, 0x26, 0x40, 0x11, 0x90, 0x4c, 0xb1, 0xe0, 0x04, 0xf0, 
	0x90, 0x4c, 0xb8, 0xe0, 0x60, 0x1a, 0xe0, 0x14, 0xf0, 0x80, 0x15, 0x90, 
	0x4c, 0xb9, 0xe0, 0xff, 0x90, 0x4c, 0xb8, 0xe0, 0xc3, 0x9f, 0x50, 0x08, 
	0x90, 0x4c, 0xb9, 0xe0, 0x90, 0x4c, 0xb8, 0xf0, 0xe4, 0xf5, 0x26, 0xf5, 
	0x27, 0x7d, 0x05, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 0xb0, 0x12, 
	0x1f, 0x89, 0x7d, 0x02, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 0xbb, 
	0x12, 0x1f, 0x89, 0x7d, 0x03, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 
	0xbc, 0x12, 0x1f, 0x91, 0x7d, 0x04, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 
	0x4c, 0xbd, 0x12, 0x1f, 0x91, 0x7d, 0x09, 0x7f, 0xb8, 0x12, 0x17, 0x24, 
	0x90, 0x4c, 0xb7, 0x12, 0x1f, 0xa4, 0x7d, 0x08, 0x7f, 0xb8, 0x12, 0x17, 
	0x24, 0x90, 0x4c, 0xb6, 0x12, 0x1f, 0xa4, 0x7d, 0x07, 0x7f, 0xb8, 0x12, 
	0x17, 0x24, 0x90, 0x4c, 0xb5, 0xe0, 0xfd, 0x7f, 0xb9, 0x12, 0x17, 0x24, 
	0x7d, 0x06, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 0xb4, 0xe0, 0xfd, 
	0x7f, 0xb9, 0x12, 0x17, 0x24, 0x7d, 0x01, 0x12, 0x1f, 0xac, 0xe4, 0xfd, 
	0x12, 0x1f, 0xac, 0x80, 0x08, 0x05, 0x27, 0xe5, 0x27, 0x70, 0x02, 0x05, 
	0x26, 0xc2, 0x07, 0x22, 0xef, 0xf0, 0x7d, 0x02, 0x7f, 0xb8, 0x12, 0x17, 
	0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 0x7f, 0xb8, 0x12, 0x17, 0x24, 
	0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x7f, 
	0xb9, 0x12, 0x17, 0x3e, 0x22, 0xe0, 0xfd, 0x7f, 0xb9, 0x12, 0x17, 0x24, 
	0x22, 0xe0, 0xfd, 0x7f, 0xb9, 0x12, 0x17, 0x24, 0x22, 0x7f, 0xb8, 0x12, 
	0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 0xe0, 0xfd, 0x7f, 0xb9, 
	0x12, 0x17, 0x24, 0x22, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x7d, 0x01, 0x7f, 
	0xb9, 0x12, 0x17, 0x24, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x21, 0x61, 0x80, 0xff, 0xff, 0xff, 0x02, 0x10, 0x28, 0x02, 0x10, 
	0x3b, 0x02, 0x10, 0x86, 0x02, 0x15, 0x5f, 0x02, 0x15, 0x60, 0x02, 0x16, 
	0x44, 0x02, 0x16, 0x8d, 0x12, 0x16, 0x45, 0x22, 0x02, 0x1b, 0xcf, 0x02, 
	0x1c, 0xf8, 0x02, 0x18, 0x1c, 0x02, 0x17, 0x57, 0x30, 0x05, 0x06, 0x20, 
	0x0d, 0x03, 0x12, 0x1d, 0xdd, 0x30, 0x07, 0x06, 0x20, 0x0f, 0x03, 0x12, 
	0x1e, 0x32, 0x22, 0x90, 0x01, 0x8c, 0xe0, 0x30, 0xe3, 0x20, 0xe5, 0x58, 
	0x30, 0xe0, 0x10, 0xe5, 0x4c, 0x30, 0xe0, 0x04, 0x7f, 0x40, 0x80, 0x02, 
	0x7f, 0x00, 0x90, 0x10, 0x2f, 0xef, 0xf0, 0x90, 0x01, 0x8c, 0x74, 0x08, 
	0xf0, 0xe4, 0x90, 0x01, 0xa7, 0xf0, 0x90, 0x01, 0x8c, 0xe0, 0x30, 0xe0, 
	0x1c, 0x90, 0x01, 0x80, 0xe0, 0xb4, 0x02, 0x15, 0xa3, 0xe0, 0xb4, 0x01, 
	0x10, 0x90, 0x01, 0x84, 0xe0, 0xb4, 0x81, 0x09, 0x90, 0x01, 0x8c, 0x74, 
	0x01, 0xf0, 0x12, 0x0d, 0xdd, 0x22, 0x90, 0x04, 0x14, 0xe0, 0x20, 0xe7, 
	0x03, 0x02, 0x15, 0x5e, 0x90, 0x70, 0x12, 0xe0, 0xf5, 0x56, 0x90, 0x04, 
	0x04, 0xe0, 0x12, 0x0a, 0xb6, 0x10, 0xf3, 0x31, 0x10, 0xd7, 0x36, 0x11, 
	0x1c, 0x50, 0x11, 0x53, 0x51, 0x11, 0x5c, 0x52, 0x11, 0x5c, 0x53, 0x11, 
	0x5c, 0x54, 0x11, 0x9d, 0x55, 0x11, 0xec, 0x56, 0x12, 0xaf, 0x64, 0x12, 
	0x4a, 0x65, 0x12, 0x75, 0x66, 0x12, 0xdb, 0x72, 0x13, 0xa3, 0x73, 0x13, 
	0xc8, 0x74, 0x14, 0xc4, 0x80, 0x14, 0xe7, 0x90, 0x15, 0x1c, 0x91, 0x00, 
	0x00, 0x15, 0x5e, 0x90, 0x70, 0x11, 0xe0, 0xf5, 0x3c, 0xe4, 0x90, 0x70, 
	0x13, 0xf0, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 
	0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x20, 0x02, 0x03, 0x30, 0x03, 
	0x1d, 0x7d, 0x02, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 0x04, 0x14, 0x74, 
	0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 
	0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x85, 0x56, 0x41, 0xd2, 0x02, 0x22, 
	0x90, 0x70, 0x10, 0xe0, 0x54, 0x7f, 0xff, 0xbf, 0x0a, 0x0d, 0x90, 0x70, 
	0x11, 0xe0, 0xb4, 0x08, 0x06, 0x75, 0x4e, 0x01, 0x75, 0x4f, 0x84, 0x90, 
	0x70, 0x10, 0xe0, 0x54, 0x7f, 0xff, 0xbf, 0x02, 0x12, 0x90, 0x70, 0x11, 
	0xe0, 0x64, 0x08, 0x60, 0x04, 0xe0, 0xb4, 0x20, 0x06, 0x75, 0x4e, 0x03, 
	0x75, 0x4f, 0x20, 0xe4, 0xf5, 0x3f, 0x22, 0x90, 0x70, 0x11, 0xe0, 0x24, 
	0xff, 0x92, 0x47, 0x22, 0x90, 0x04, 0x04, 0xe0, 0x25, 0xe0, 0x24, 0x5d, 
	0xf5, 0x57, 0x90, 0x70, 0x10, 0xe0, 0xff, 0x74, 0x47, 0x25, 0x57, 0xf8, 
	0xc6, 0xef, 0xc6, 0x90, 0x70, 0x11, 0xe0, 0xff, 0x74, 0x48, 0x25, 0x57, 
	0xf8, 0xc6, 0xef, 0xc6, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 
	0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 
	0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0xe5, 0x47, 0x64, 
	0x07, 0x60, 0x1d, 0xe5, 0x47, 0x64, 0x08, 0x60, 0x17, 0xe5, 0x47, 0x64, 
	0x09, 0x60, 0x11, 0xe5, 0x47, 0x64, 0x0a, 0x60, 0x0b, 0xe5, 0x47, 0x64, 
	0x0b, 0x60, 0x05, 0xe5, 0x47, 0xb4, 0x0c, 0x08, 0x90, 0x70, 0x11, 0xe0, 
	0x54, 0x0f, 0xf5, 0x3a, 0xe5, 0x47, 0xb4, 0x09, 0x08, 0xe5, 0x3a, 0xb4, 
	0x03, 0x03, 0xe4, 0xf5, 0x46, 0xe5, 0x47, 0xb4, 0x0a, 0x08, 0xe5, 0x3a, 
	0xb4, 0x01, 0x03, 0xe4, 0xf5, 0x46, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 
	0xaa, 0xd2, 0x04, 0x22, 0x90, 0x70, 0x11, 0xe0, 0xf4, 0xff, 0x90, 0x70, 
	0x10, 0xe0, 0x5f, 0xff, 0x90, 0x70, 0x11, 0xe0, 0x55, 0x3f, 0x4f, 0x90, 
	0x70, 0x18, 0xf0, 0x90, 0x70, 0x11, 0xe0, 0x90, 0x70, 0x19, 0xf0, 0xe4, 
	0xfd, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x30, 0x15, 0x04, 0xd2, 0x14, 0x80, 
	0x26, 0x90, 0x70, 0x18, 0xe0, 0xf5, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0xff, 
	0x90, 0x70, 0x19, 0xe0, 0xfe, 0xef, 0x5e, 0x90, 0x02, 0x29, 0xf0, 0x30, 
	0x47, 0x04, 0xaf, 0x3f, 0x80, 0x04, 0xe5, 0x3f, 0xf4, 0xff, 0x90, 0x02, 
	0x28, 0xef, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 
	0x15, 0x57, 0x90, 0x70, 0x10, 0xe0, 0x13, 0x92, 0x1b, 0xc2, 0x1c, 0xad, 
	0x57, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 
	0x30, 0x1b, 0x02, 0xd2, 0x07, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 
	0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 0x4c, 0xb1, 
	0xe0, 0x90, 0x4c, 0xbe, 0xf0, 0x90, 0x4c, 0xb8, 0xe0, 0x90, 0x4c, 0xbf, 
	0xf0, 0xe4, 0x90, 0x4c, 0xb1, 0xf0, 0x90, 0x4c, 0xb9, 0xe0, 0x90, 0x4c, 
	0xb8, 0xf0, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 0x04, 0x14, 
	0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 
	0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 0x70, 0x10, 0xe0, 0xf5, 
	0x2a, 0x75, 0x3d, 0x03, 0x75, 0x3e, 0x1f, 0xe4, 0xf5, 0x2f, 0xad, 0x57, 
	0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 
	0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 
	0x02, 0x15, 0x57, 0x90, 0x10, 0x00, 0xe0, 0xf5, 0x57, 0xe4, 0xf5, 0x58, 
	0xf5, 0x59, 0x90, 0x10, 0x03, 0xe0, 0xb4, 0x28, 0x05, 0x75, 0x58, 0x01, 
	0x80, 0x3c, 0x90, 0x10, 0x03, 0xe0, 0xb4, 0x30, 0x05, 0x75, 0x58, 0x02, 
	0x80, 0x30, 0x90, 0x10, 0x03, 0xe0, 0xb4, 0x33, 0x05, 0x75, 0x58, 0x04, 
	0x80, 0x24, 0x90, 0x10, 0x03, 0xe0, 0xb4, 0x35, 0x0c, 0x90, 0x10, 0x02, 
	0xe0, 0xb4, 0x72, 0x05, 0x75, 0x58, 0x08, 0x80, 0x11, 0x90, 0x10, 0x03, 
	0xe0, 0xb4, 0x35, 0x0a, 0x90, 0x10, 0x02, 0xe0, 0xb4, 0x93, 0x03, 0x75, 
	0x58, 0x10, 0xe5, 0x58, 0x30, 0xe1, 0x19, 0x90, 0x05, 0x08, 0xe0, 0x44, 
	0x01, 0xf0, 0xfd, 0x90, 0x05, 0x05, 0xe0, 0x54, 0xfb, 0xf0, 0x44, 0x04, 
	0xf0, 0xed, 0x54, 0xfe, 0x90, 0x05, 0x08, 0xf0, 0x75, 0x3b, 0x18, 0xe4, 
	0xf5, 0x26, 0xf5, 0x27, 0xc2, 0x1c, 0xc2, 0x1b, 0xf5, 0x4e, 0xf5, 0x4f, 
	0x75, 0x3a, 0xff, 0x75, 0x3c, 0xff, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 
	0xaa, 0x90, 0x70, 0x36, 0x74, 0x37, 0xf0, 0xa3, 0x74, 0x32, 0xf0, 0x90, 
	0x04, 0x01, 0xe0, 0x44, 0x01, 0xf0, 0xc2, 0x16, 0xe4, 0xf5, 0x5c, 0xf5, 
	0x5a, 0xf5, 0x5b, 0x90, 0x70, 0x30, 0xf0, 0xa3, 0xf0, 0xf5, 0x2a, 0xc2, 
	0x17, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 
	0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 0x90, 
	0x70, 0x10, 0xe0, 0x24, 0xff, 0x92, 0x93, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 
	0x0b, 0xaa, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 
	0xf0, 0xe5, 0x56, 0xf4, 0x70, 0x03, 0x02, 0x15, 0x5e, 0x02, 0x15, 0x57, 
	0x90, 0x10, 0x00, 0xe0, 0x90, 0x10, 0x2c, 0xf0, 0x90, 0x10, 0x2f, 0x74, 
	0x40, 0xf0, 0x90, 0x70, 0x11, 0xe0, 0x54, 0x7f, 0xf5, 0x57, 0xe0, 0x54, 
	0x80, 0x90, 0x70, 0x32, 0xf0, 0x90, 0x70, 0x10, 0xe0, 0xff, 0xe5, 0x57, 
	0xd3, 0x9f, 0x40, 0x43, 0x90, 0x70, 0x33, 0xe5, 0x57, 0xf0, 0x90, 0x70, 
	0x10, 0xe0, 0xff, 0x90, 0x70, 0x33, 0xe0, 0xc3, 0x9f, 0xd3, 0x94, 0x04, 
	0x40, 0x73, 0xe0, 0x24, 0xfc, 0xf0, 0xe0, 0xff, 0x90, 0x70, 0x32, 0xe0, 
	0x4f, 0x90, 0x05, 0x00, 0xf0, 0xe5, 0x58, 0x54, 0x0f, 0x60, 0x04, 0x7f, 
	0x17, 0x80, 0x02, 0x7f, 0x11, 0x90, 0x05, 0x01, 0xef, 0xf0, 0xa3, 0x74, 
	0x01, 0xf0, 0x74, 0x03, 0xf0, 0xff, 0x12, 0x0d, 0x48, 0x80, 0xc3, 0x90, 
	0x70, 0x33, 0xe5, 0x57, 0xf0, 0x90, 0x70, 0x33, 0xe0, 0xff, 0x90, 0x70, 
	0x10, 0xe0, 0xc3, 0x9f, 0xd3, 0x94, 0x04, 0x40, 0x30, 0x90, 0x70, 0x33, 
	0xe0, 0x24, 0x04, 0xf0, 0xe0, 0xff, 0x90, 0x70, 0x32, 0xe0, 0x4f, 0x90, 
	0x05, 0x00, 0xf0, 0xe5, 0x58, 0x54, 0x0f, 0x60, 0x04, 0x7f, 0x17, 0x80, 
	0x02, 0x7f, 0x11, 0x90, 0x05, 0x01, 0xef, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 
	0x74, 0x03, 0xf0, 0xff, 0x12, 0x0d, 0x48, 0x80, 0xc0, 0x90, 0x70, 0x10, 
	0xe0, 0xff, 0x90, 0x70, 0x32, 0xe0, 0x4f, 0x90, 0x05, 0x00, 0xf0, 0xe5, 
	0x58, 0x54, 0x0f, 0x60, 0x04, 0x7f, 0x17, 0x80, 0x02, 0x7f, 0x11, 0x90, 
	0x05, 0x01, 0xef, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0x74, 0x03, 0xf0, 0xff, 
	0x12, 0x0d, 0x48, 0x90, 0x10, 0x00, 0xe0, 0x90, 0x10, 0x2c, 0xf0, 0x90, 
	0x10, 0x2f, 0x74, 0x7f, 0xf0, 0xe4, 0xfd, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 
	0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0x22, 
	0x90, 0x70, 0x10, 0xe0, 0x24, 0xff, 0x92, 0x4a, 0xd2, 0x05, 0xad, 0x57, 
	0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0xe4, 
	0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 0x60, 0x79, 0x80, 0x70, 0x90, 
	0x70, 0x10, 0xe0, 0x24, 0xff, 0x92, 0x16, 0x90, 0x70, 0x11, 0xe0, 0xf5, 
	0x5c, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 0xaa, 0x90, 0x04, 0x14, 0x74, 
	0x80, 0xf0, 0x90, 0x70, 0x30, 0xe5, 0x5a, 0xf0, 0xa3, 0xe5, 0x5b, 0xf0, 
	0xe4, 0xf5, 0x5a, 0xf5, 0x5b, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 0xf4, 
	0x60, 0x44, 0x80, 0x3b, 0x90, 0x70, 0x11, 0xe0, 0x24, 0xff, 0x92, 0x17, 
	0x90, 0x70, 0x10, 0xe0, 0xf5, 0x5d, 0xad, 0x57, 0xaf, 0x56, 0x12, 0x0b, 
	0xaa, 0x90, 0x04, 0x14, 0x74, 0x80, 0xf0, 0x30, 0x17, 0x13, 0x90, 0x10, 
	0x00, 0xe0, 0x90, 0x10, 0x2c, 0xf0, 0x90, 0x10, 0x2f, 0xe0, 0x54, 0xf0, 
	0xf5, 0x57, 0x45, 0x5d, 0xf0, 0xe4, 0x90, 0x70, 0x13, 0xf0, 0xe5, 0x56, 
	0xf4, 0x60, 0x07, 0x90, 0x70, 0x25, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x22, 
	0xe5, 0x3e, 0x45, 0x3d, 0x60, 0x0a, 0xe5, 0x3e, 0x15, 0x3e, 0x70, 0x0a, 
	0x15, 0x3d, 0x80, 0x06, 0x75, 0x3d, 0x03, 0x75, 0x3e, 0x1f, 0xe5, 0x3e, 
	0x45, 0x3d, 0x60, 0x03, 0x02, 0x16, 0x0e, 0xe5, 0x2a, 0x70, 0x03, 0x02, 
	0x16, 0x0e, 0x74, 0xa0, 0x25, 0x2f, 0xf5, 0x82, 0xe4, 0x34, 0x4c, 0xf5, 
	0x83, 0xe0, 0x60, 0x7a, 0x7f, 0x7e, 0x12, 0x17, 0x3e, 0xef, 0x54, 0xfe, 
	0x44, 0x02, 0xfd, 0x7f, 0x7e, 0x12, 0x17, 0x24, 0xe5, 0x2f, 0x7f, 0x00, 
	0x25, 0xe0, 0xfe, 0xef, 0x24, 0x00, 0xf5, 0x82, 0x74, 0x4d, 0x3e, 0xaf, 
	0x82, 0x90, 0x4c, 0xa8, 0xf0, 0xa3, 0xef, 0xf0, 0xe4, 0xf5, 0x56, 0xf5, 
	0x57, 0x7f, 0x7f, 0x12, 0x17, 0x3e, 0x90, 0x4c, 0xa8, 0xe0, 0xfa, 0xa3, 
	0xe0, 0x25, 0x57, 0xf5, 0x82, 0xea, 0x35, 0x56, 0xf5, 0x83, 0xef, 0xf0, 
	0x05, 0x57, 0xe5, 0x57, 0x70, 0x02, 0x05, 0x56, 0xc3, 0x94, 0x80, 0xe5, 
	0x56, 0x94, 0x01, 0x40, 0xd8, 0x7f, 0x7e, 0x12, 0x17, 0x3e, 0xef, 0x44, 
	0x03, 0xfd, 0x7f, 0x7e, 0x12, 0x17, 0x24, 0x74, 0xa0, 0x25, 0x2f, 0xf5, 
	0x82, 0xe4, 0x34, 0x4c, 0xf5, 0x83, 0xe4, 0xf0, 0x05, 0x2f, 0xe5, 0x2f, 
	0xb4, 0x08, 0x03, 0xe4, 0xf5, 0x2f, 0xe5, 0x3b, 0x60, 0x04, 0x15, 0x3b, 
	0x80, 0x03, 0x75, 0x3b, 0xfe, 0xe5, 0x3b, 0x70, 0x08, 0x20, 0x07, 0x05, 
	0x30, 0x1b, 0x02, 0xd2, 0x07, 0xe5, 0x53, 0x70, 0x1a, 0x30, 0x60, 0x09, 
	0xb2, 0x4d, 0x30, 0x4d, 0x04, 0x05, 0x46, 0xc2, 0x04, 0xe5, 0x4f, 0x45, 
	0x4e, 0x60, 0x08, 0xe5, 0x4f, 0x15, 0x4f, 0x70, 0x02, 0x15, 0x4e, 0x22, 
	0x22, 0xe5, 0x31, 0x24, 0xee, 0x60, 0x0f, 0x14, 0x60, 0x10, 0x14, 0x60, 
	0x12, 0x24, 0x04, 0x70, 0x18, 0x12, 0x16, 0x71, 0x80, 0x15, 0xc2, 0x45, 
	0x80, 0x11, 0xe4, 0xf5, 0x21, 0x80, 0x0c, 0xd2, 0x09, 0xd2, 0x0a, 0xd2, 
	0x0b, 0xd2, 0x0c, 0x80, 0x02, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x04, 0x02, 
	0xe0, 0x44, 0x08, 0xf0, 0x85, 0x39, 0x82, 0x85, 0x38, 0x83, 0xe5, 0x33, 
	0xf0, 0xe5, 0x32, 0xa3, 0xf0, 0x90, 0x04, 0x02, 0xe0, 0x54, 0xf7, 0xf0, 
	0x22, 0x30, 0x14, 0x30, 0x90, 0x70, 0x19, 0xe0, 0x55, 0x3f, 0xff, 0x90, 
	0x70, 0x18, 0xe0, 0x4f, 0xf5, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0xff, 0x90, 
	0x70, 0x19, 0xe0, 0xfe, 0xef, 0x5e, 0x90, 0x02, 0x29, 0xf0, 0x30, 0x47, 
	0x04, 0xaf, 0x3f, 0x80, 0x04, 0xe5, 0x3f, 0xf4, 0xff, 0x90, 0x02, 0x28, 
	0xef, 0xf0, 0xc2, 0x14, 0x30, 0x16, 0x60, 0xc2, 0xaf, 0x90, 0x10, 0x04, 
	0xe0, 0xf5, 0x57, 0x90, 0x02, 0x28, 0xe0, 0x54, 0x05, 0xf5, 0x57, 0xe5, 
	0x5c, 0x64, 0x01, 0x70, 0x21, 0xe5, 0x57, 0x90, 0x10, 0x04, 0x30, 0xe0, 
	0x06, 0xe0, 0x54, 0xfb, 0xf0, 0x80, 0x04, 0xe0, 0x44, 0x04, 0xf0, 0xe5, 
	0x57, 0x30, 0xe2, 0x31, 0x05, 0x5b, 0xe5, 0x5b, 0x70, 0x2b, 0x05, 0x5a, 
	0x80, 0x27, 0xe5, 0x57, 0x30, 0xe0, 0x1b, 0xe5, 0x5c, 0x90, 0x10, 0x04, 
	0x70, 0x06, 0xe0, 0x54, 0xfb, 0xf0, 0x80, 0x04, 0xe0, 0x44, 0x04, 0xf0, 
	0x05, 0x5b, 0xe5, 0x5b, 0x70, 0x0b, 0x05, 0x5a, 0x80, 0x07, 0x90, 0x10, 
	0x04, 0xe0, 0x44, 0x04, 0xf0, 0xd2, 0xaf, 0x22, 0x90, 0x10, 0x1c, 0xed, 
	0xf0, 0xa3, 0xef, 0xf0, 0xa3, 0x74, 0x0a, 0xf0, 0x90, 0x10, 0x1c, 0xe0, 
	0xf5, 0x58, 0x90, 0x10, 0x1e, 0xe0, 0x20, 0xe1, 0xf3, 0x22, 0x90, 0x10, 
	0x1d, 0xef, 0xf0, 0xa3, 0x74, 0x0b, 0xf0, 0x90, 0x10, 0x1c, 0xe0, 0xf5, 
	0x58, 0x90, 0x10, 0x1e, 0xe0, 0x20, 0xe1, 0xf3, 0xaf, 0x58, 0x22, 0xc2, 
	0x4b, 0xc2, 0x4c, 0xe5, 0x44, 0x12, 0x0a, 0xb6, 0x17, 0x79, 0x00, 0x18, 
	0x07, 0x04, 0x18, 0x03, 0x08, 0x17, 0xe3, 0x10, 0x17, 0x8d, 0x20, 0x17, 
	0xad, 0x60, 0x17, 0xbe, 0xa0, 0x00, 0x00, 0x18, 0x09, 0x85, 0x48, 0x43, 
	0x85, 0x4a, 0x42, 0x85, 0x4c, 0x5e, 0xe5, 0x47, 0x64, 0x06, 0x60, 0x03, 
	0x02, 0x18, 0x09, 0x80, 0x1b, 0xe5, 0x48, 0xc4, 0x54, 0x0f, 0xf5, 0x43, 
	0xe5, 0x4a, 0xc4, 0x54, 0x0f, 0xf5, 0x42, 0xe5, 0x4c, 0xc4, 0x54, 0x0f, 
	0xf5, 0x5e, 0xe5, 0x47, 0x64, 0x06, 0x70, 0x61, 0x53, 0x43, 0x0f, 0x80, 
	0x5c, 0x85, 0x49, 0x43, 0x85, 0x4b, 0x42, 0x85, 0x4d, 0x5e, 0xe5, 0x47, 
	0x64, 0x06, 0x70, 0x4d, 0x80, 0x1b, 0xe5, 0x49, 0xc4, 0x54, 0x0f, 0xf5, 
	0x43, 0xe5, 0x4b, 0xc4, 0x54, 0x0f, 0xf5, 0x42, 0xe5, 0x4d, 0xc4, 0x54, 
	0x0f, 0xf5, 0x5e, 0xe5, 0x47, 0x64, 0x06, 0x70, 0x30, 0xe5, 0x43, 0x54, 
	0x0f, 0x44, 0x10, 0xf5, 0x43, 0x80, 0x26, 0xe5, 0x47, 0x64, 0x04, 0x60, 
	0x05, 0xe5, 0x47, 0xb4, 0x05, 0x06, 0x43, 0x5e, 0x04, 0x75, 0x42, 0x09, 
	0xe5, 0x47, 0xb4, 0x06, 0x10, 0xe5, 0x43, 0x54, 0x0f, 0x44, 0x30, 0xf5, 
	0x43, 0x80, 0x06, 0xd2, 0x4b, 0x80, 0x02, 0xd2, 0x4c, 0xe4, 0xf5, 0x25, 
	0xe5, 0x42, 0xc4, 0x54, 0xf0, 0xff, 0xe5, 0x43, 0x54, 0x0f, 0x4f, 0xf5, 
	0x5f, 0xd2, 0x60, 0x22, 0xd2, 0x15, 0xe5, 0x47, 0x24, 0xf5, 0x60, 0x0b, 
	0x24, 0xcb, 0x60, 0x07, 0x24, 0x40, 0x70, 0x06, 0xc2, 0x15, 0x22, 0x12, 
	0x1b, 0x9a, 0x12, 0x18, 0x3e, 0xc2, 0x15, 0xc2, 0xaf, 0xc2, 0x04, 0xd2, 
	0xaf, 0x22, 0xc2, 0xaf, 0x90, 0x04, 0x14, 0xe0, 0x54, 0x0e, 0x60, 0x04, 
	0xd2, 0x18, 0x80, 0x08, 0xe5, 0x4e, 0x45, 0x4f, 0x24, 0xff, 0x92, 0x18, 
	0xd2, 0xaf, 0x90, 0x04, 0x14, 0xe0, 0xa2, 0xe4, 0x92, 0x19, 0x74, 0x1e, 
	0xf0, 0xe5, 0x5f, 0x54, 0x0f, 0xf5, 0x2d, 0xe5, 0x25, 0x70, 0x13, 0x30, 
	0x18, 0x05, 0xe5, 0x5f, 0x20, 0xe5, 0x0b, 0x30, 0x19, 0x19, 0xe5, 0x5f, 
	0x54, 0x30, 0xff, 0xbf, 0x30, 0x11, 0xe5, 0x25, 0x70, 0x05, 0x75, 0x25, 
	0x0c, 0x80, 0x02, 0x15, 0x25, 0xd2, 0x6c, 0xd2, 0x6d, 0x80, 0x0f, 0xe5, 
	0x5f, 0x30, 0xe6, 0x06, 0xc2, 0x6c, 0xd2, 0x6d, 0x80, 0x04, 0xd2, 0x6c, 
	0xc2, 0x6d, 0xe5, 0x47, 0x64, 0x03, 0x70, 0x21, 0x30, 0x4b, 0x06, 0xc2, 
	0x6c, 0xd2, 0x6d, 0x80, 0x18, 0xe5, 0x25, 0x70, 0x03, 0x30, 0x4c, 0x11, 
	0xc2, 0x4c, 0xe5, 0x25, 0x70, 0x05, 0x75, 0x25, 0x07, 0x80, 0x02, 0x15, 
	0x25, 0xd2, 0x6c, 0xd2, 0x6d, 0xe5, 0x47, 0xb4, 0x09, 0x14, 0xe5, 0x44, 
	0x20, 0xe3, 0x0b, 0xe5, 0x3a, 0x64, 0x02, 0x60, 0x05, 0xe5, 0x3a, 0xb4, 
	0x03, 0x04, 0xc2, 0x6c, 0xd2, 0x6d, 0xe5, 0x47, 0xb4, 0x0a, 0x13, 0xe5, 
	0x3a, 0xb4, 0x01, 0x06, 0xc2, 0x6c, 0xd2, 0x6d, 0x80, 0x08, 0xe5, 0x3a, 
	0x70, 0x04, 0xd2, 0x6c, 0xc2, 0x6d, 0x20, 0x69, 0x07, 0xe5, 0x5e, 0x20, 
	0xe0, 0x02, 0xb2, 0x68, 0x20, 0x6b, 0x07, 0xe5, 0x5e, 0x20, 0xe1, 0x02, 
	0xb2, 0x6a, 0x20, 0x6d, 0x07, 0xe5, 0x5e, 0x20, 0xe2, 0x02, 0xb2, 0x6c, 
	0x75, 0x2e, 0x40, 0x20, 0x69, 0x04, 0xa2, 0x68, 0x80, 0x26, 0x30, 0x68, 
	0x06, 0xe5, 0x46, 0xa2, 0xe2, 0x80, 0x1d, 0xe5, 0x5e, 0x20, 0xe0, 0x04, 
	0x7f, 0x01, 0x80, 0x02, 0x7f, 0x00, 0xe5, 0x46, 0x54, 0xf0, 0xfe, 0xbe, 
	0xf0, 0x04, 0x7e, 0x01, 0x80, 0x02, 0x7e, 0x00, 0xee, 0x6f, 0x24, 0xff, 
	0x92, 0x73, 0x92, 0x72, 0x20, 0x6b, 0x04, 0xa2, 0x6a, 0x80, 0x26, 0x30, 
	0x6a, 0x06, 0xe5, 0x46, 0xa2, 0xe2, 0x80, 0x1d, 0xe5, 0x5e, 0x20, 0xe1, 
	0x04, 0x7f, 0x01, 0x80, 0x02, 0x7f, 0x00, 0xe5, 0x46, 0x54, 0xf0, 0xfe, 
	0xbe, 0xf0, 0x04, 0x7e, 0x01, 0x80, 0x02, 0x7e, 0x00, 0xee, 0x6f, 0x24, 
	0xff, 0x92, 0x75, 0x92, 0x74, 0x20, 0x6d, 0x04, 0xa2, 0x6c, 0x80, 0x26, 
	0xe5, 0x47, 0x64, 0x0a, 0x70, 0x22, 0x30, 0x6c, 0x06, 0xe5, 0x46, 0xa2, 
	0xe3, 0x80, 0x17, 0xe5, 0x3a, 0xb4, 0x01, 0x06, 0xe5, 0x46, 0xa2, 0xe3, 
	0x80, 0x34, 0xe5, 0x46, 0x20, 0xe4, 0x03, 0x30, 0xe5, 0x03, 0xd3, 0x80, 
	0x01, 0xc3, 0x80, 0x26, 0x30, 0x6c, 0x06, 0xe5, 0x46, 0xa2, 0xe2, 0x80, 
	0x1d, 0xe5, 0x5e, 0x20, 0xe2, 0x04, 0x7f, 0x01, 0x80, 0x02, 0x7f, 0x00, 
	0xe5, 0x46, 0x54, 0xf0, 0xfe, 0xbe, 0xf0, 0x04, 0x7e, 0x01, 0x80, 0x02, 
	0x7e, 0x00, 0xee, 0x6f, 0x24, 0xff, 0x92, 0x71, 0x92, 0x70, 0x90, 0x10, 
	0x00, 0xe0, 0x90, 0x10, 0x2c, 0xf0, 0x90, 0x10, 0x03, 0xe0, 0xc3, 0x94, 
	0x30, 0x40, 0x19, 0xe0, 0x64, 0x32, 0x60, 0x14, 0xa2, 0x71, 0x92, 0x77, 
	0xa2, 0x70, 0x92, 0x76, 0xe5, 0x2e, 0x13, 0x13, 0x54, 0x3f, 0xf5, 0x2e, 
	0xc2, 0x77, 0xd2, 0x76, 0x30, 0x17, 0x0d, 0x53, 0x2e, 0xf0, 0xe5, 0x2e, 
	0x45, 0x5d, 0x90, 0x10, 0x2f, 0xf0, 0x80, 0x06, 0x90, 0x10, 0x2f, 0xe5, 
	0x2e, 0xf0, 0xe5, 0x47, 0x64, 0x06, 0x70, 0x47, 0x90, 0x02, 0x28, 0xe0, 
	0x30, 0x47, 0x03, 0xff, 0x80, 0x02, 0xf4, 0xff, 0x8f, 0x3f, 0x90, 0x02, 
	0x29, 0xe0, 0x54, 0xfe, 0xf0, 0xe5, 0x43, 0xc4, 0x54, 0x0f, 0x14, 0x60, 
	0x0c, 0x24, 0xfe, 0x60, 0x0c, 0x24, 0x03, 0x70, 0x13, 0xc2, 0xf8, 0x80, 
	0x0f, 0xd2, 0xf8, 0x80, 0x0b, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 0x80, 
	0x01, 0xc3, 0x92, 0xf8, 0x30, 0x47, 0x05, 0xaf, 0x3f, 0x02, 0x1b, 0x94, 
	0xe5, 0x3f, 0xf4, 0xff, 0x02, 0x1b, 0x94, 0xe5, 0x47, 0x64, 0x07, 0x60, 
	0x0f, 0xe5, 0x47, 0x64, 0x08, 0x60, 0x09, 0xe5, 0x47, 0x64, 0x09, 0x60, 
	0x03, 0x02, 0x1b, 0x02, 0x90, 0x02, 0x28, 0xe0, 0x30, 0x47, 0x03, 0xff, 
	0x80, 0x02, 0xf4, 0xff, 0x8f, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0x54, 0xfc, 
	0xf0, 0xe5, 0x3a, 0x14, 0x60, 0x22, 0x14, 0x60, 0x25, 0x14, 0x60, 0x2d, 
	0x24, 0xfc, 0x60, 0x49, 0x24, 0xf9, 0x60, 0x14, 0x24, 0x0e, 0x70, 0x50, 
	0xe5, 0x46, 0x13, 0x13, 0x54, 0x3f, 0x75, 0xf0, 0x03, 0x84, 0xe5, 0xf0, 
	0x24, 0xff, 0x80, 0x3a, 0xd2, 0xf9, 0xc2, 0xf8, 0x80, 0x3e, 0xe5, 0x46, 
	0x30, 0xe2, 0x03, 0xd3, 0x80, 0x1d, 0xc3, 0x80, 0x1a, 0xe5, 0x46, 0x30, 
	0xe2, 0x0d, 0x54, 0x38, 0xc3, 0x94, 0x30, 0x50, 0x06, 0x7e, 0x00, 0x7f, 
	0x01, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0xee, 0x4f, 0x24, 0xff, 0x92, 
	0xf8, 0xc2, 0xf9, 0x80, 0x13, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 0x80, 
	0x01, 0xc3, 0x92, 0xf9, 0xc2, 0xf8, 0x80, 0x04, 0xc2, 0xf8, 0xc2, 0xf9, 
	0x30, 0x47, 0x04, 0xaf, 0x3f, 0x80, 0x04, 0xe5, 0x3f, 0xf4, 0xff, 0x02, 
	0x1b, 0x94, 0xe5, 0x47, 0x64, 0x0c, 0x60, 0x09, 0xe5, 0x47, 0x64, 0x0b, 
	0x60, 0x03, 0x02, 0x1b, 0x99, 0x90, 0x02, 0x28, 0xe0, 0x30, 0x47, 0x03, 
	0xff, 0x80, 0x02, 0xf4, 0xff, 0x8f, 0x3f, 0x90, 0x02, 0x29, 0xe0, 0x54, 
	0xfd, 0xf0, 0xe5, 0x3a, 0x14, 0x60, 0x20, 0x14, 0x60, 0x21, 0x14, 0x60, 
	0x2b, 0x24, 0xfc, 0x60, 0x45, 0x24, 0xf9, 0x60, 0x12, 0x24, 0x0e, 0x70, 
	0x4a, 0xe5, 0x46, 0x13, 0x13, 0x54, 0x3f, 0x75, 0xf0, 0x03, 0x84, 0xe5, 
	0xf0, 0x80, 0x29, 0xd2, 0xf9, 0x80, 0x3a, 0xe5, 0x46, 0x30, 0xe2, 0x03, 
	0xd3, 0x80, 0x01, 0xc3, 0x92, 0xf9, 0x80, 0x2d, 0xe5, 0x46, 0x30, 0xe2, 
	0x0d, 0x54, 0x38, 0xc3, 0x94, 0x30, 0x50, 0x06, 0x7e, 0x00, 0x7f, 0x01, 
	0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0xee, 0x4f, 0x24, 0xff, 0x92, 0xf9, 
	0x80, 0x0f, 0xe5, 0x46, 0x30, 0xe2, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 
	0xf9, 0x80, 0x02, 0xc2, 0xf9, 0x30, 0x47, 0x04, 0xaf, 0x3f, 0x80, 0x04, 
	0xe5, 0x3f, 0xf4, 0xff, 0x90, 0x02, 0x28, 0xef, 0xf0, 0x22, 0xe5, 0x47, 
	0xb4, 0x0b, 0x10, 0x90, 0x02, 0x29, 0xe0, 0x54, 0xeb, 0xf0, 0xe5, 0x3f, 
	0x54, 0xeb, 0x45, 0x45, 0xf5, 0x3f, 0x22, 0xe4, 0x90, 0x02, 0x29, 0xf0, 
	0x30, 0x47, 0x04, 0xaf, 0x45, 0x80, 0x04, 0xe5, 0x45, 0xf4, 0xff, 0x90, 
	0x02, 0x28, 0xef, 0xf0, 0x22, 0x8f, 0x50, 0xd2, 0x59, 0x22, 0x8f, 0x54, 
	0xd2, 0x58, 0x22, 0xe4, 0xf5, 0x62, 0xc2, 0xaf, 0xe5, 0x51, 0x14, 0x60, 
	0x4b, 0x14, 0x60, 0x6c, 0x24, 0x02, 0x60, 0x03, 0x02, 0x1c, 0xdc, 0xd2, 
	0x59, 0x75, 0x55, 0x01, 0x90, 0x02, 0xa2, 0xe0, 0x54, 0x7f, 0xf0, 0xa3, 
	0xe0, 0x20, 0xe7, 0x23, 0x90, 0x04, 0x34, 0xe0, 0xb4, 0x02, 0x1c, 0xa3, 
	0xe0, 0xb4, 0x02, 0x17, 0xa3, 0xe0, 0xb4, 0x02, 0x12, 0x7f, 0x20, 0x12, 
	0x1b, 0xc5, 0x90, 0x10, 0x04, 0xe0, 0x54, 0xf3, 0xf0, 0x75, 0x51, 0x01, 
	0x02, 0x1c, 0xdc, 0xe5, 0x50, 0x60, 0x03, 0x02, 0x1c, 0xdc, 0x75, 0x62, 
	0x03, 0x02, 0x1c, 0xdc, 0x90, 0x12, 0x00, 0xe0, 0x54, 0x03, 0x70, 0x12, 
	0x7f, 0x20, 0x12, 0x1b, 0xc5, 0x90, 0x02, 0xa2, 0xe0, 0x54, 0xbf, 0xf0, 
	0x75, 0x51, 0x02, 0x02, 0x1c, 0xdc, 0xe5, 0x50, 0x60, 0x03, 0x02, 0x1c, 
	0xdc, 0x02, 0x1c, 0xd7, 0x90, 0x02, 0xa3, 0xe0, 0x30, 0xe6, 0x03, 0x02, 
	0x1c, 0xd3, 0x90, 0x04, 0x37, 0xe0, 0x64, 0x22, 0x70, 0x79, 0x90, 0x01, 
	0x8a, 0x74, 0x7e, 0xf0, 0x90, 0x01, 0x96, 0xf0, 0x90, 0x12, 0x04, 0x74, 
	0x0a, 0xf0, 0x90, 0x13, 0x28, 0xe0, 0x90, 0x70, 0x1a, 0xf0, 0x90, 0x13, 
	0x29, 0xe0, 0x90, 0x70, 0x1b, 0xf0, 0x90, 0x13, 0x2b, 0xe0, 0x90, 0x70, 
	0x22, 0xf0, 0x90, 0x13, 0x28, 0xe0, 0x54, 0xf0, 0xf0, 0xa3, 0xe0, 0x54, 
	0xf0, 0xf0, 0x90, 0x13, 0x2b, 0xe0, 0x54, 0xcc, 0xf0, 0xe5, 0x58, 0x30, 
	0xe3, 0x13, 0xe5, 0x3c, 0xf4, 0x90, 0x13, 0x2a, 0x60, 0x05, 0xe0, 0x54, 
	0xf3, 0x80, 0x11, 0xe0, 0x54, 0xfb, 0xf0, 0x80, 0x14, 0xe5, 0x3c, 0xf4, 
	0x90, 0x13, 0x2a, 0x60, 0x08, 0xe0, 0x54, 0xf2, 0x45, 0x3c, 0xf0, 0x80, 
	0x04, 0xe0, 0x54, 0xfa, 0xf0, 0x90, 0x04, 0x01, 0xe0, 0x54, 0xfd, 0xf0, 
	0x75, 0x62, 0x01, 0x75, 0x55, 0x02, 0xe4, 0xf5, 0x51, 0x80, 0x09, 0xe5, 
	0x50, 0x70, 0x05, 0x75, 0x62, 0x03, 0xf5, 0x51, 0xe5, 0x62, 0x60, 0x15, 
	0xc2, 0x01, 0xe4, 0xf5, 0x51, 0xc2, 0x59, 0xad, 0x62, 0xaf, 0x40, 0x12, 
	0x1d, 0xa9, 0xe5, 0x62, 0xb4, 0x03, 0x02, 0xd2, 0x03, 0xd2, 0xaf, 0x22, 
	0xc2, 0xaf, 0x30, 0x01, 0x12, 0xe4, 0x90, 0x01, 0x96, 0xf0, 0xf5, 0x51, 
	0xc2, 0x59, 0xc2, 0x01, 0x7d, 0x02, 0xaf, 0x40, 0x12, 0x1d, 0xa9, 0xe5, 
	0x52, 0x14, 0x60, 0x0c, 0x04, 0x60, 0x03, 0x02, 0x1d, 0xa6, 0x75, 0x52, 
	0x01, 0x75, 0x55, 0x03, 0x90, 0x04, 0x01, 0xe0, 0x44, 0x0e, 0xf0, 0xe5, 
	0x58, 0x54, 0x18, 0x60, 0x1e, 0x90, 0x70, 0x1a, 0xe0, 0x90, 0x13, 0x28, 
	0xf0, 0x90, 0x70, 0x1b, 0xe0, 0x90, 0x13, 0x29, 0xf0, 0xa3, 0x74, 0x05, 
	0xf0, 0x90, 0x70, 0x22, 0xe0, 0x90, 0x13, 0x2b, 0xf0, 0x80, 0x11, 0x90, 
	0x13, 0x28, 0xe0, 0x44, 0x0f, 0xf0, 0xa3, 0xe0, 0x44, 0x0f, 0xf0, 0xa3, 
	0xe0, 0x44, 0x05, 0xf0, 0x90, 0x12, 0x04, 0x74, 0x03, 0xf0, 0xe5, 0x58, 
	0x30, 0xe3, 0x16, 0x90, 0x05, 0x00, 0x74, 0x80, 0xf0, 0xa3, 0x74, 0x08, 
	0xf0, 0xa3, 0x74, 0x01, 0xf0, 0x74, 0x03, 0xf0, 0x7f, 0x01, 0x12, 0x0d, 
	0x48, 0x90, 0x02, 0xa2, 0xe0, 0x44, 0xc0, 0xf0, 0x90, 0x10, 0x04, 0xe0, 
	0x44, 0x0c, 0xf0, 0xe4, 0xf5, 0x52, 0xf5, 0x55, 0x30, 0x02, 0x09, 0xc2, 
	0x02, 0x7d, 0x01, 0xaf, 0x41, 0x12, 0x1d, 0xa9, 0x30, 0x03, 0x02, 0xc2, 
	0x03, 0xe4, 0x90, 0x01, 0x96, 0xf0, 0xd2, 0xaf, 0x22, 0xef, 0xf4, 0x60, 
	0x2d, 0xe4, 0xfe, 0x74, 0x14, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x70, 0xf5, 
	0x83, 0xe0, 0xb4, 0xff, 0x19, 0x74, 0x14, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 
	0x70, 0xf5, 0x83, 0xef, 0xf0, 0x74, 0x1c, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 
	0x70, 0xf5, 0x83, 0xed, 0xf0, 0x22, 0x0e, 0xbe, 0x04, 0xd5, 0x22, 0x22, 
	0x22, 0x90, 0x70, 0x2a, 0xe0, 0x30, 0xe1, 0x4d, 0xc2, 0xaf, 0x90, 0x70, 
	0x28, 0xe0, 0x90, 0x10, 0x1c, 0xf0, 0x90, 0x70, 0x29, 0xe0, 0x90, 0x10, 
	0x1d, 0xf0, 0x90, 0x70, 0x2a, 0xe0, 0x90, 0x10, 0x1e, 0xf0, 0x90, 0x10, 
	0x1c, 0xe0, 0xf5, 0x62, 0x90, 0x10, 0x1e, 0xe0, 0x20, 0xe1, 0xf3, 0x90, 
	0x10, 0x1c, 0xe0, 0x90, 0x70, 0x28, 0xf0, 0x90, 0x10, 0x1d, 0xe0, 0x90, 
	0x70, 0x29, 0xf0, 0x90, 0x10, 0x1e, 0xe0, 0x90, 0x70, 0x2a, 0xf0, 0x30, 
	0x4a, 0x07, 0x90, 0x70, 0x24, 0xe0, 0x44, 0x01, 0xf0, 0xc2, 0x05, 0xd2, 
	0xaf, 0x22, 0x20, 0x1c, 0x5a, 0x7d, 0x05, 0x12, 0x1f, 0x73, 0x90, 0x4c, 
	0xb0, 0x12, 0x1f, 0x64, 0x90, 0x4c, 0xbb, 0xef, 0xf0, 0x7d, 0x03, 0x12, 
	0x1f, 0x73, 0x90, 0x4c, 0xbc, 0x12, 0x1f, 0x64, 0x90, 0x4c, 0xbd, 0xef, 
	0xf0, 0x7d, 0x09, 0x12, 0x1f, 0x7e, 0x90, 0x4c, 0xb7, 0xef, 0xf0, 0x7d, 
	0x08, 0x12, 0x1f, 0x7e, 0x90, 0x4c, 0xb6, 0xef, 0xf0, 0x7d, 0x07, 0x12, 
	0x1f, 0x99, 0x90, 0x4c, 0xb5, 0xef, 0xf0, 0x7d, 0x06, 0x12, 0x1f, 0x99, 
	0x90, 0x4c, 0xb4, 0xef, 0xf0, 0xe4, 0x90, 0x4c, 0xb1, 0xf0, 0x90, 0x4c, 
	0xb9, 0xe0, 0x90, 0x4c, 0xb8, 0xf0, 0xd2, 0x1c, 0xc2, 0x07, 0x22, 0x7d, 
	0x01, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0xef, 
	0x64, 0x01, 0x60, 0x03, 0x02, 0x1f, 0x59, 0xd3, 0x90, 0x4c, 0xb3, 0xe0, 
	0x95, 0x27, 0x90, 0x4c, 0xb2, 0xe0, 0x95, 0x26, 0x40, 0x11, 0x90, 0x4c, 
	0xb1, 0xe0, 0x04, 0xf0, 0x90, 0x4c, 0xb8, 0xe0, 0x60, 0x1a, 0xe0, 0x14, 
	0xf0, 0x80, 0x15, 0x90, 0x4c, 0xb9, 0xe0, 0xff, 0x90, 0x4c, 0xb8, 0xe0, 
	0xc3, 0x9f, 0x50, 0x08, 0x90, 0x4c, 0xb9, 0xe0, 0x90, 0x4c, 0xb8, 0xf0, 
	0xe4, 0xf5, 0x26, 0xf5, 0x27, 0x7d, 0x05, 0x7f, 0xb8, 0x12, 0x17, 0x24, 
	0x90, 0x4c, 0xb0, 0x12, 0x1f, 0x89, 0x7d, 0x02, 0x7f, 0xb8, 0x12, 0x17, 
	0x24, 0x90, 0x4c, 0xbb, 0x12, 0x1f, 0x89, 0x7d, 0x03, 0x7f, 0xb8, 0x12, 
	0x17, 0x24, 0x90, 0x4c, 0xbc, 0x12, 0x1f, 0x91, 0x7d, 0x04, 0x7f, 0xb8, 
	0x12, 0x17, 0x24, 0x90, 0x4c, 0xbd, 0x12, 0x1f, 0x91, 0x7d, 0x09, 0x7f, 
	0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 0xb7, 0x12, 0x1f, 0xa4, 0x7d, 0x08, 
	0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 0xb6, 0x12, 0x1f, 0xa4, 0x7d, 
	0x07, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 0x4c, 0xb5, 0xe0, 0xfd, 0x7f, 
	0xb9, 0x12, 0x17, 0x24, 0x7d, 0x06, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x90, 
	0x4c, 0xb4, 0xe0, 0xfd, 0x7f, 0xb9, 0x12, 0x17, 0x24, 0x7d, 0x01, 0x12, 
	0x1f, 0xac, 0xe4, 0xfd, 0x12, 0x1f, 0xac, 0x80, 0x08, 0x05, 0x27, 0xe5, 
	0x27, 0x70, 0x02, 0x05, 0x26, 0xc2, 0x07, 0x22, 0xef, 0xf0, 0x7d, 0x02, 
	0x7f, 0xb8, 0x12, 0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 0x7f, 
	0xb8, 0x12, 0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 0x7f, 0xb8, 
	0x12, 0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 0xe0, 0xfd, 0x7f, 
	0xb9, 0x12, 0x17, 0x24, 0x22, 0xe0, 0xfd, 0x7f, 0xb9, 0x12, 0x17, 0x24, 
	0x22, 0x7f, 0xb8, 0x12, 0x17, 0x24, 0x7f, 0xb9, 0x12, 0x17, 0x3e, 0x22, 
	0xe0, 0xfd, 0x7f, 0xb9, 0x12, 0x17, 0x24, 0x22, 0x7f, 0xb8, 0x12, 0x17, 
	0x24, 0x7d, 0x01, 0x7f, 0xb9, 0x12, 0x17, 0x24, 0x22, 0x22, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xf7, 0xcd, 
};
static const size_t runfw_size = sizeof(runfw);

static void
runfw_sysinit(void)
{
	const struct firmware *fp;
	fp = firmware_register("runfw",
	    runfw,
	    runfw_size,
	    1, NULL);
	BSD_ASSERT(fp != NULL);
}
SYSINIT(runfw, SI_SUB_DRIVERS, SI_ORDER_ANY,
    runfw_sysinit, NULL);
