/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSTest
 *
 * @brief This source file provides the implementation of rtems_test_run().
 */

/*
 * Copyright (C) 2020, 2023 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems/test-info.h>
#include <rtems/test-printer.h>
#include <rtems/test.h>

#include <stdlib.h>

static char buffer[ 512 ];

static const T_action actions[] = {
  T_report_hash_sha256,
  T_check_task_context,
  T_check_file_descriptors,
  T_check_rtems_barriers,
  T_check_rtems_extensions,
  T_check_rtems_message_queues,
  T_check_rtems_partitions,
  T_check_rtems_periods,
  T_check_rtems_regions,
  T_check_rtems_semaphores,
  T_check_rtems_tasks,
  T_check_rtems_timers,
  T_check_posix_keys
};

static const T_config config = {
  .name = rtems_test_name,
  .buf = buffer,
  .buf_size = sizeof( buffer ),
  .putchar = T_putchar_default,
  .verbosity = T_NORMAL,
  .now = T_now_clock,
  .allocate = malloc,
  .deallocate = free,
  .action_count = T_ARRAY_SIZE( actions ),
  .actions = actions
};

static int printer(void *context, const char *fmt, va_list ap)
{
  (void) context;
  return T_vprintf(fmt, ap);
}

void rtems_test_run(
  rtems_task_argument    arg,
  const RTEMS_TEST_STATE state
)
{
  rtems_print_printer previous_printer;
  int exit_code;

  (void) arg;

  rtems_test_begin( rtems_test_name, state );
  T_register();

  previous_printer = rtems_test_printer.printer;
  rtems_test_printer.printer = printer;

  exit_code = T_main( &config );

  rtems_test_printer.printer = previous_printer;

  if ( exit_code == 0 ) {
    rtems_test_end( rtems_test_name );
  }

  rtems_test_exit( 0 );
}
