/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup BSPCommandLine BSP Command Line Helpers
 *
 * @brief Obtain COPY of the Entire Matching Argument
 */

/*
 *  COPYRIGHT (c) 1989-2009.
 *  On-Line Applications Research Corporation (OAR).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems/bspcmdline.h>

static void copy_string(
  const char *start,
  char       *value,
  size_t      length
)
{
  int         i;
  int         quotes;
  const char *p = start;

  quotes=0;
  for (i=0 ; *p && i<length-1; ) {
    if ( *p == '\"' ) {
      quotes++;
    } else if ( ((quotes % 2) == 0) && *p == ' ' )
      break;
    value[i++] = *p++;
    value[i] = '\0';
  }

}

const char *rtems_bsp_cmdline_get_param(
  const char *name,
  char       *value,
  size_t      length
)
{
  const char *p;

  if ( !name )
    return NULL;

  if ( !value )
    return NULL;

  if ( !length )
    return NULL;

  value[0] = '\0';

  p = rtems_bsp_cmdline_get_param_raw( name );

  if ( !p )
    return NULL;

  copy_string( p, value, length );

  return value;
}
