/* SPDX-License-Identifier: BSD-2-Clause */

/*
 *  COPYRIGHT (c) 2013-2017 Chris Johns <chrisj@rtems.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @file
 *
 * @ingroup rtems_fdt
 *
 * @brief RTEMS Flattened Device Tree Shell Command
 *
 * Support for loading, managing and accessing FDT blobs in RTEMS.
 */

#if !defined (_RTEMS_FDT_SHELL_H_)
#define _RTEMS_FDT_SHELL_H_

#include <rtems/rtems-fdt.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * Add a shell command to access memory and registers associated with the DTF.
 */
void rtems_fdt_add_shell_command (void);

/**
 * Get a pointer to the handle. You can use this to load files or register
 * blobs and have the shell command access them.
 */
rtems_fdt_handle* rtems_fdt_get_shell_handle (void);

/**
 * Write handler call to write from the address property.
 */
typedef void (*rtems_fdt_write_handler)(uintptr_t address, uint32_t value);

/**
 * Read handler call to read from the address property.
 */
typedef uint32_t (*rtems_fdt_read_handler)(uintptr_t address);

/**
 * Set the write handler returning the current handler.
 */
rtems_fdt_write_handler
rtems_fdt_set_shell_write_handler (rtems_fdt_write_handler handler);

/**
 * Set the read handler returning the current handler.
 */
rtems_fdt_read_handler
rtems_fdt_set_shell_read_handler (rtems_fdt_read_handler handler);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
