Lattice Mico32
==============

The Lattice Mico32 port uses the system_config.h generated by the Mico
System Builder to retrieve the properties of the peripherals.

Implemented (in shared/ subdirectory)
Polled console driver (uart)
Clock interrupt with 10 ms tick
Networking using Lattice tri-speed ethernet MAC

TODO
----

Support more peripherals:
  * uart driver using interrupts

jukka.pietarinen@mrf.fi, 3.12.2008
   

```
BSP NAME:           lm32_evr
BOARD:              cRIO-EVR, Micro-Research Finland Oy
BUS:                wishbone
CPU FAMILY:         lm32 (Lattice Mico32)
CPU:                small
COPROCESSORS:       none
MODE:               32 bit mode

DEBUG MONITOR:      none
```

PERIPHERALS
-----------
```
TIMERS:             clock
  RESOLUTION:       10 ms
SERIAL PORTS:       uart
REAL-TIME CLOCK:    none
DMA:                none
VIDEO:              none
SCSI:               none
NETWORKING:         tsmac
```
To on the simulator included in lm32-gdb use these commands:

```shell
tar sim --hw-device lm32cpu \
  --hw-device "lm32uart/reg 0x80006000 0x100" \
  --hw-device "/lm32uart > int int0 /lm32cpu" \
  --hw-device "lm32timer/reg 0x80002000 0x80" \
  --hw-device "/lm32timer > int int1 /lm32cpu" \
  --memory-region 0x08000000,0x4000000
load
```

The simulator is VERY VERY slow when RTEMS is idle.
To speed this up, add SIMULATOR_FAST_IDLE=1 to the
configure command.
