Real-Time Executive for Multiprocessing Systems
===============================================

RTEMS is a real-time executive (kernel) which provides a high performance 
environment for embedded applications with the following features:

 * Standards based user interfaces.
 * Multitasking capabilities.
 * Homogeneous and heterogeneous multiprocessor systems.
 * Event-driven, priority-based, preemptive scheduling.
 * Optional rate monotonic scheduling.
 * Intertask communication and synchronisation.
 * Priority inheritance.
 * Responsive interrupt management.
 * Dynamic memory allocation.
 * High level of user configurability.
 * Open source with a friendly user license.


Project git repositories are located at:

  * https://gitlab.rtems.org/rtems/


Online documentation is available at:

  * https://docs.rtems.org/


RTEMS Doxygen for CPUKit:

  * https://docs.rtems.org/doxygen/branches/master/


RTEMS POSIX 1003.1 Compliance Guide:

  * https://docs.rtems.org/branches/master/posix-compliance/


RTEMS Mailing Lists for general purpose use the users list and for developers 
use the devel list.

  * https://lists.rtems.org/mailman/listinfo


The version number for this software is indicated in the VERSION file.
