/*
 * QEMU model of the XPPU xppu
 *
 * Copyright (c) 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-01-13.
 * Written by Joe Komlodi <komlodi@xilinx.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef XLNX_XPPU_H
#define XLNX_XPPU_H

#include "hw/register.h"

#ifndef XILINX_XPPU_ERR_DEBUG
#define XILINX_XPPU_ERR_DEBUG 0
#endif

/* Registers shared between all XPPUs */
REG32(CTRL, 0x0)
    FIELD(CTRL, APER_PARITY_EN, 2, 1)
    FIELD(CTRL, MID_PARITY_EN, 1, 1)
    FIELD(CTRL, ENABLE, 0, 1)
REG32(ERR_STATUS1, 0x4)
REG32(ERR_STATUS2, 0x8)
    FIELD(ERR_STATUS2, AXI_ID, 0, 10)
REG32(ISR, 0x10)
    FIELD(ISR, APER_PARITY, 7, 1)
    FIELD(ISR, APER_TZ, 6, 1)
    FIELD(ISR, APER_PERM, 5, 1)
    FIELD(ISR, MID_PARITY, 3, 1)
    FIELD(ISR, MID_RO, 2, 1)
    FIELD(ISR, MID_MISS, 1, 1)
    FIELD(ISR, INV_APB, 0, 1)
REG32(IMR, 0x14)
    FIELD(IMR, APER_PARITY, 7, 1)
    FIELD(IMR, APER_TZ, 6, 1)
    FIELD(IMR, APER_PERM, 5, 1)
    FIELD(IMR, MID_PARITY, 3, 1)
    FIELD(IMR, MID_RO, 2, 1)
    FIELD(IMR, MID_MISS, 1, 1)
    FIELD(IMR, INV_APB, 0, 1)
REG32(IEN, 0x18)
    FIELD(IEN, APER_PARITY, 7, 1)
    FIELD(IEN, APER_TZ, 6, 1)
    FIELD(IEN, APER_PERM, 5, 1)
    FIELD(IEN, MID_PARITY, 3, 1)
    FIELD(IEN, MID_RO, 2, 1)
    FIELD(IEN, MID_MISS, 1, 1)
    FIELD(IEN, INV_APB, 0, 1)
REG32(IDS, 0x1c)
    FIELD(IDS, APER_PARITY, 7, 1)
    FIELD(IDS, APER_TZ, 6, 1)
    FIELD(IDS, APER_PERM, 5, 1)
    FIELD(IDS, MID_PARITY, 3, 1)
    FIELD(IDS, MID_RO, 2, 1)
    FIELD(IDS, MID_MISS, 1, 1)
    FIELD(IDS, INV_APB, 0, 1)
REG32(M_MASTER_IDS, 0x3c)
REG32(M_APERTURE_64KB, 0x44)
REG32(M_APERTURE_1MB, 0x48)
REG32(M_APERTURE_512MB, 0x4c)
REG32(BASE_64KB, 0x54)
REG32(BASE_1MB, 0x58)
REG32(BASE_512MB, 0x5c)
REG32(MASTER_ID00, 0x100)
    FIELD(MASTER_ID00, MIDP, 31, 1)
    FIELD(MASTER_ID00, MIDR, 30, 1)
    FIELD(MASTER_ID00, MIDM, 16, 10)
    FIELD(MASTER_ID00, MID, 0, 10)
REG32(MASTER_ID01, 0x104)
    FIELD(MASTER_ID01, MIDP, 31, 1)
    FIELD(MASTER_ID01, MIDR, 30, 1)
    FIELD(MASTER_ID01, MIDM, 16, 10)
    FIELD(MASTER_ID01, MID, 0, 10)
REG32(MASTER_ID02, 0x108)
    FIELD(MASTER_ID02, MIDP, 31, 1)
    FIELD(MASTER_ID02, MIDR, 30, 1)
    FIELD(MASTER_ID02, MIDM, 16, 10)
    FIELD(MASTER_ID02, MID, 0, 10)
REG32(MASTER_ID03, 0x10c)
    FIELD(MASTER_ID03, MIDP, 31, 1)
    FIELD(MASTER_ID03, MIDR, 30, 1)
    FIELD(MASTER_ID03, MIDM, 16, 10)
    FIELD(MASTER_ID03, MID, 0, 10)
REG32(MASTER_ID04, 0x110)
    FIELD(MASTER_ID04, MIDP, 31, 1)
    FIELD(MASTER_ID04, MIDR, 30, 1)
    FIELD(MASTER_ID04, MIDM, 16, 10)
    FIELD(MASTER_ID04, MID, 0, 10)
REG32(MASTER_ID05, 0x114)
    FIELD(MASTER_ID05, MIDP, 31, 1)
    FIELD(MASTER_ID05, MIDR, 30, 1)
    FIELD(MASTER_ID05, MIDM, 16, 10)
    FIELD(MASTER_ID05, MID, 0, 10)
REG32(MASTER_ID06, 0x118)
    FIELD(MASTER_ID06, MIDP, 31, 1)
    FIELD(MASTER_ID06, MIDR, 30, 1)
    FIELD(MASTER_ID06, MIDM, 16, 10)
    FIELD(MASTER_ID06, MID, 0, 10)
REG32(MASTER_ID07, 0x11c)
    FIELD(MASTER_ID07, MIDP, 31, 1)
    FIELD(MASTER_ID07, MIDR, 30, 1)
    FIELD(MASTER_ID07, MIDM, 16, 10)
    FIELD(MASTER_ID07, MID, 0, 10)
REG32(MASTER_ID08, 0x120)
    FIELD(MASTER_ID08, MIDP, 31, 1)
    FIELD(MASTER_ID08, MIDR, 30, 1)
    FIELD(MASTER_ID08, MIDM, 16, 10)
    FIELD(MASTER_ID08, MID, 0, 10)
REG32(MASTER_ID09, 0x124)
    FIELD(MASTER_ID09, MIDP, 31, 1)
    FIELD(MASTER_ID09, MIDR, 30, 1)
    FIELD(MASTER_ID09, MIDM, 16, 10)
    FIELD(MASTER_ID09, MID, 0, 10)
REG32(MASTER_ID10, 0x128)
    FIELD(MASTER_ID10, MIDP, 31, 1)
    FIELD(MASTER_ID10, MIDR, 30, 1)
    FIELD(MASTER_ID10, MIDM, 16, 10)
    FIELD(MASTER_ID10, MID, 0, 10)
REG32(MASTER_ID11, 0x12c)
    FIELD(MASTER_ID11, MIDP, 31, 1)
    FIELD(MASTER_ID11, MIDR, 30, 1)
    FIELD(MASTER_ID11, MIDM, 16, 10)
    FIELD(MASTER_ID11, MID, 0, 10)
REG32(MASTER_ID12, 0x130)
    FIELD(MASTER_ID12, MIDP, 31, 1)
    FIELD(MASTER_ID12, MIDR, 30, 1)
    FIELD(MASTER_ID12, MIDM, 16, 10)
    FIELD(MASTER_ID12, MID, 0, 10)
REG32(MASTER_ID13, 0x134)
    FIELD(MASTER_ID13, MIDP, 31, 1)
    FIELD(MASTER_ID13, MIDR, 30, 1)
    FIELD(MASTER_ID13, MIDM, 16, 10)
    FIELD(MASTER_ID13, MID, 0, 10)
REG32(MASTER_ID14, 0x138)
    FIELD(MASTER_ID14, MIDP, 31, 1)
    FIELD(MASTER_ID14, MIDR, 30, 1)
    FIELD(MASTER_ID14, MIDM, 16, 10)
    FIELD(MASTER_ID14, MID, 0, 10)
REG32(MASTER_ID15, 0x13c)
    FIELD(MASTER_ID15, MIDP, 31, 1)
    FIELD(MASTER_ID15, MIDR, 30, 1)
    FIELD(MASTER_ID15, MIDM, 16, 10)
    FIELD(MASTER_ID15, MID, 0, 10)
REG32(MASTER_ID16, 0x140)
    FIELD(MASTER_ID16, MIDP, 31, 1)
    FIELD(MASTER_ID16, MIDR, 30, 1)
    FIELD(MASTER_ID16, MIDM, 16, 10)
    FIELD(MASTER_ID16, MID, 0, 10)
REG32(MASTER_ID17, 0x144)
    FIELD(MASTER_ID17, MIDP, 31, 1)
    FIELD(MASTER_ID17, MIDR, 30, 1)
    FIELD(MASTER_ID17, MIDM, 16, 10)
    FIELD(MASTER_ID17, MID, 0, 10)
REG32(MASTER_ID18, 0x148)
    FIELD(MASTER_ID18, MIDP, 31, 1)
    FIELD(MASTER_ID18, MIDR, 30, 1)
    FIELD(MASTER_ID18, MIDM, 16, 10)
    FIELD(MASTER_ID18, MID, 0, 10)
REG32(MASTER_ID19, 0x14c)
    FIELD(MASTER_ID19, MIDP, 31, 1)
    FIELD(MASTER_ID19, MIDR, 30, 1)
    FIELD(MASTER_ID19, MIDM, 16, 10)
    FIELD(MASTER_ID19, MID, 0, 10)

#if XILINX_XPPU_ERR_DEBUG
#define DPRINTF(fmt, ...) \
do { printf(fmt, ## __VA_ARGS__); } while (0)
#else
#define DPRINTF(fmt, ...) {} while (0)
#endif

#define XPPU_R_MAX 0x200

#define NR_MID_ENTRIES 20

#define NR_32B_APL_ENTRIES 128
#define NR_64K_APL_ENTRIES 256
#define NR_1M_APL_ENTRIES 16
#define NR_512M_APL_ENTRIES 1

/*
 * Even though Versal does not have a 32B aperture, it allocates space for
 * it as if it was there.
 */
#define NR_APL_ENTRIES (NR_32B_APL_ENTRIES + NR_64K_APL_ENTRIES + \
                        NR_1M_APL_ENTRIES + NR_512M_APL_ENTRIES)

#define PERM_RAM_BASE 0x1000
#define PERM_RAM_MAX (PERM_RAM_BASE + ((NR_APL_ENTRIES + 1) * 4))

typedef enum {
    XPPU_REGION_LPD = 0,
    XPPU_REGION_PMC = 1,
    XPPU_REGION_PMC_NPI = 2
} XPPURegion;

typedef enum {
    GRANULE_32B,
    GRANULE_64K,
    GRANULE_1M,
    GRANULE_512M,
} XPPUGranule;

typedef struct {
    const XPPUGranule *granules;
    const uint64_t *bases;
    const uint64_t *masks;
    const unsigned int *shifts;
    const uint32_t *ram_bases;
} XPPUApertureInfo;

typedef struct XPPU XPPU;

typedef struct XPPUAperture {
    XPPU *parent;
    MemoryRegion iomem;

    XPPUGranule granule;
    /* MR base so we can offset the forwarded access.  */
    uint64_t base;
    /* Mask used to extract parts of the incoming address.  */
    uint64_t extract_mask;
    uint64_t extract_shift;
    /* RAM base. Start of APL tables for this particular Aperture.  */
    uint32_t ram_base;
} XPPUAperture;

struct XPPU {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    MemoryRegion perm_ram_iomem;
    qemu_irq irq_isr;

    MemoryRegion *mr;
    AddressSpace as;

    XPPUAperture *ap;
    uint8_t num_ap;

    uint32_t perm_ram[NR_APL_ENTRIES];

    uint32_t regs[XPPU_R_MAX];
    RegisterInfo regs_info[XPPU_R_MAX];
    uint8_t region;
};

bool parity32(uint32_t v);
bool check_mid_parity(XPPU *s, uint32_t val32);
void check_mid_parities(XPPU *s);
bool check_apl_parity(XPPU *s, uint32_t val32);
void update_mrs(XPPU *s);
bool xppu_ap_check(XPPU *s, MemTxAttrs attr, bool rw, uint32_t apl);
void isr_update_irq(XPPU *s);
MemTxResult xppu_read_common(void *opaque, XPPU *s, hwaddr addr,
                             uint64_t *value, unsigned size, MemTxAttrs attr);
MemTxResult xppu_write_common(void *opaque, XPPU *s, hwaddr addr,
                              uint64_t value, unsigned size, MemTxAttrs attr);
MemTxResult xppu_perm_ram_write_common(XPPU *s, hwaddr addr, uint64_t val,
                                       unsigned size, MemTxAttrs attr);
MemTxResult xppu_perm_ram_read_common(XPPU *s, hwaddr addr, uint64_t *val,
                                      unsigned size, MemTxAttrs attr);
bool xppu_parse_reg_common(XPPU *s, const char *tn, FDTGenericRegPropInfo reg,
                           FDTGenericMMap *obj, const XPPUApertureInfo *ap_info,
                           const MemoryRegionOps *ap_ops, Error **errp);
void xppu_init_common(XPPU *s, Object *obj, const char *tn,
                      const MemoryRegionOps *ops,
                      const MemoryRegionOps *pr_ops,
                      const RegisterAccessInfo *regs_info, size_t regs_info_sz);

#endif
