/*
 * QEMU model of the XRAM_SLCR XRAM SCLR Configuration Registers
 *
 * Copyright (c) 2021 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2021-08-26.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_XRAM_SLCR_ERR_DEBUG
#define XILINX_XRAM_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_XRAM_SLCR "xlnx.xram_slcr"

#define XILINX_XRAM_SLCR(obj) \
     OBJECT_CHECK(XRAM_SLCR, (obj), TYPE_XILINX_XRAM_SLCR)

REG32(PCSR_MASK, 0x0)
    FIELD(PCSR_MASK, MEM_CLEAR_TRIGGER_3_TO_1_WEN, 29, 3)
    FIELD(PCSR_MASK, BISR_CLR_WEN, 28, 1)
    FIELD(PCSR_MASK, BISR_TRIGGER_WEN, 27, 1)
    FIELD(PCSR_MASK, STOP_ADC_WEN, 26, 1)
    FIELD(PCSR_MASK, DEEP_SLEEP_WEN, 25, 1)
    FIELD(PCSR_MASK, SSC_BYPASS_WEN, 24, 1)
    FIELD(PCSR_MASK, TEST_SAFE_WEN, 20, 1)
    FIELD(PCSR_MASK, SLVERREN_WEN, 19, 1)
    FIELD(PCSR_MASK, MEM_CLEAR_TRIGGER_0_WEN, 18, 1)
    FIELD(PCSR_MASK, SYS_RST_MASK_WEN, 15, 3)
    FIELD(PCSR_MASK, PWRDN_WEN, 14, 1)
    FIELD(PCSR_MASK, DISNPICLK_WEN, 13, 1)
    FIELD(PCSR_MASK, APBEN_WEN, 12, 1)
    FIELD(PCSR_MASK, SCAN_CLEAR_TRIGGER_WEN, 11, 1)
    FIELD(PCSR_MASK, STARTCAL_WEN, 10, 1)
    FIELD(PCSR_MASK, FABRICEN_WEN, 9, 1)
    FIELD(PCSR_MASK, TRISTATE_WEN, 8, 1)
    FIELD(PCSR_MASK, HOLDSTATE_WEN, 7, 1)
    FIELD(PCSR_MASK, INITSTATE_WEN, 6, 1)
    FIELD(PCSR_MASK, ODISABLE_WEN, 2, 4)
    FIELD(PCSR_MASK, GATEREG_WEN, 1, 1)
    FIELD(PCSR_MASK, PCOMPLETE_WEN, 0, 1)
REG32(PCSR_PCR, 0x4)
    FIELD(PCSR_PCR, MEM_CLEAR_TRIGGER_3_TO_1, 29, 3)
    FIELD(PCSR_PCR, BISR_CLR, 28, 1)
    FIELD(PCSR_PCR, BISR_TRIGGER, 27, 1)
    FIELD(PCSR_PCR, STOP_ADC, 26, 1)
    FIELD(PCSR_PCR, DEEP_SLEEP, 25, 1)
    FIELD(PCSR_PCR, SSC_BYPASS, 24, 1)
    FIELD(PCSR_PCR, TEST_SAFE, 20, 1)
    FIELD(PCSR_PCR, SLVERREN, 19, 1)
    FIELD(PCSR_PCR, MEM_CLEAR_TRIGGER_0, 18, 1)
    FIELD(PCSR_PCR, SYS_RST_MASK, 15, 3)
    FIELD(PCSR_PCR, PWRDN, 14, 1)
    FIELD(PCSR_PCR, DISNPICLK, 13, 1)
    FIELD(PCSR_PCR, APBEN, 12, 1)
    FIELD(PCSR_PCR, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(PCSR_PCR, STARTCAL, 10, 1)
    FIELD(PCSR_PCR, FABRICEN, 9, 1)
    FIELD(PCSR_PCR, TRISTATE, 8, 1)
    FIELD(PCSR_PCR, HOLDSTATE, 7, 1)
    FIELD(PCSR_PCR, INITSTATE, 6, 1)
    FIELD(PCSR_PCR, ODISABLE, 2, 4)
    FIELD(PCSR_PCR, GATEREG, 1, 1)
    FIELD(PCSR_PCR, PCOMPLETE, 0, 1)
REG32(PCSR_PSR, 0x8)
    FIELD(PCSR_PSR, MEM_CLEAR_PASS_3_TO_1, 20, 3)
    FIELD(PCSR_PSR, MEM_CLEAR_DONE_3_TO_1, 17, 3)
    FIELD(PCSR_PSR, ISO_PL_XRAM_STATUS, 16, 1)
    FIELD(PCSR_PSR, BISR_PASS, 15, 1)
    FIELD(PCSR_PSR, BISR_DONE, 14, 1)
    FIELD(PCSR_PSR, HARD_FAIL_OR, 11, 3)
    FIELD(PCSR_PSR, HARD_FAIL_AND, 8, 3)
    FIELD(PCSR_PSR, MEM_CLEAR_PASS_0, 7, 1)
    FIELD(PCSR_PSR, MEM_CLEAR_DONE_0, 6, 1)
    FIELD(PCSR_PSR, CALERROR, 5, 1)
    FIELD(PCSR_PSR, CALDONE, 4, 1)
    FIELD(PCSR_PSR, INCAL, 3, 1)
    FIELD(PCSR_PSR, SCAN_CLEAR_PASS, 2, 1)
    FIELD(PCSR_PSR, SCAN_CLEAR_DONE, 1, 1)
    FIELD(PCSR_PSR, PCSRLOCK, 0, 1)
REG32(PCSR_LOCK, 0xc)
    FIELD(PCSR_LOCK, STATE, 0, 1)
REG32(MAIN_CLK, 0x1000)
    FIELD(MAIN_CLK, SRC, 0, 1)
REG32(APB_CLK, 0x1004)
    FIELD(APB_CLK, SRC, 0, 1)
REG32(RST, 0x1010)
    FIELD(RST, SRC, 0, 1)
REG32(PWR_UP_BANK0, 0x1100)
    FIELD(PWR_UP_BANK0, I3, 3, 1)
    FIELD(PWR_UP_BANK0, I2, 2, 1)
    FIELD(PWR_UP_BANK0, I1, 1, 1)
    FIELD(PWR_UP_BANK0, I0, 0, 1)
REG32(PWR_DOWN_BANK0, 0x1104)
    FIELD(PWR_DOWN_BANK0, I3, 3, 1)
    FIELD(PWR_DOWN_BANK0, I2, 2, 1)
    FIELD(PWR_DOWN_BANK0, I1, 1, 1)
    FIELD(PWR_DOWN_BANK0, I0, 0, 1)
REG32(PWR_STATUS_BANK0, 0x1108)
    FIELD(PWR_STATUS_BANK0, I3, 3, 1)
    FIELD(PWR_STATUS_BANK0, I2, 2, 1)
    FIELD(PWR_STATUS_BANK0, I1, 1, 1)
    FIELD(PWR_STATUS_BANK0, I0, 0, 1)
REG32(PWR_UP_BANK1, 0x1110)
    FIELD(PWR_UP_BANK1, I3, 3, 1)
    FIELD(PWR_UP_BANK1, I2, 2, 1)
    FIELD(PWR_UP_BANK1, I1, 1, 1)
    FIELD(PWR_UP_BANK1, I0, 0, 1)
REG32(PWR_DOWN_BANK1, 0x1114)
    FIELD(PWR_DOWN_BANK1, I3, 3, 1)
    FIELD(PWR_DOWN_BANK1, I2, 2, 1)
    FIELD(PWR_DOWN_BANK1, I1, 1, 1)
    FIELD(PWR_DOWN_BANK1, I0, 0, 1)
REG32(PWR_STATUS_BANK1, 0x1118)
    FIELD(PWR_STATUS_BANK1, I3, 3, 1)
    FIELD(PWR_STATUS_BANK1, I2, 2, 1)
    FIELD(PWR_STATUS_BANK1, I1, 1, 1)
    FIELD(PWR_STATUS_BANK1, I0, 0, 1)
REG32(PWR_UP_BANK2, 0x1120)
    FIELD(PWR_UP_BANK2, I3, 3, 1)
    FIELD(PWR_UP_BANK2, I2, 2, 1)
    FIELD(PWR_UP_BANK2, I1, 1, 1)
    FIELD(PWR_UP_BANK2, I0, 0, 1)
REG32(PWR_DOWN_BANK2, 0x1124)
    FIELD(PWR_DOWN_BANK2, I3, 3, 1)
    FIELD(PWR_DOWN_BANK2, I2, 2, 1)
    FIELD(PWR_DOWN_BANK2, I1, 1, 1)
    FIELD(PWR_DOWN_BANK2, I0, 0, 1)
REG32(PWR_STATUS_BANK2, 0x1128)
    FIELD(PWR_STATUS_BANK2, I3, 3, 1)
    FIELD(PWR_STATUS_BANK2, I2, 2, 1)
    FIELD(PWR_STATUS_BANK2, I1, 1, 1)
    FIELD(PWR_STATUS_BANK2, I0, 0, 1)
REG32(PWR_UP_BANK3, 0x1130)
    FIELD(PWR_UP_BANK3, I3, 3, 1)
    FIELD(PWR_UP_BANK3, I2, 2, 1)
    FIELD(PWR_UP_BANK3, I1, 1, 1)
    FIELD(PWR_UP_BANK3, I0, 0, 1)
REG32(PWR_DOWN_BANK3, 0x1134)
    FIELD(PWR_DOWN_BANK3, I3, 3, 1)
    FIELD(PWR_DOWN_BANK3, I2, 2, 1)
    FIELD(PWR_DOWN_BANK3, I1, 1, 1)
    FIELD(PWR_DOWN_BANK3, I0, 0, 1)
REG32(PWR_STATUS_BANK3, 0x1138)
    FIELD(PWR_STATUS_BANK3, I3, 3, 1)
    FIELD(PWR_STATUS_BANK3, I2, 2, 1)
    FIELD(PWR_STATUS_BANK3, I1, 1, 1)
    FIELD(PWR_STATUS_BANK3, I0, 0, 1)
REG32(RETENTION_ENTER_BANK0, 0x1800)
    FIELD(RETENTION_ENTER_BANK0, I3, 3, 1)
    FIELD(RETENTION_ENTER_BANK0, I2, 2, 1)
    FIELD(RETENTION_ENTER_BANK0, I1, 1, 1)
    FIELD(RETENTION_ENTER_BANK0, I0, 0, 1)
REG32(RETENTION_STATUS_BANK0, 0x1804)
    FIELD(RETENTION_STATUS_BANK0, I3, 3, 1)
    FIELD(RETENTION_STATUS_BANK0, I2, 2, 1)
    FIELD(RETENTION_STATUS_BANK0, I1, 1, 1)
    FIELD(RETENTION_STATUS_BANK0, I0, 0, 1)
REG32(RETENTION_ENTER_BANK1, 0x1900)
    FIELD(RETENTION_ENTER_BANK1, I3, 3, 1)
    FIELD(RETENTION_ENTER_BANK1, I2, 2, 1)
    FIELD(RETENTION_ENTER_BANK1, I1, 1, 1)
    FIELD(RETENTION_ENTER_BANK1, I0, 0, 1)
REG32(RETENTION_STATUS_BANK1, 0x1904)
    FIELD(RETENTION_STATUS_BANK1, I3, 3, 1)
    FIELD(RETENTION_STATUS_BANK1, I2, 2, 1)
    FIELD(RETENTION_STATUS_BANK1, I1, 1, 1)
    FIELD(RETENTION_STATUS_BANK1, I0, 0, 1)
REG32(RETENTION_ENTER_BANK2, 0x1a00)
    FIELD(RETENTION_ENTER_BANK2, I3, 3, 1)
    FIELD(RETENTION_ENTER_BANK2, I2, 2, 1)
    FIELD(RETENTION_ENTER_BANK2, I1, 1, 1)
    FIELD(RETENTION_ENTER_BANK2, I0, 0, 1)
REG32(RETENTION_STATUS_BANK2, 0x1a04)
    FIELD(RETENTION_STATUS_BANK2, I3, 3, 1)
    FIELD(RETENTION_STATUS_BANK2, I2, 2, 1)
    FIELD(RETENTION_STATUS_BANK2, I1, 1, 1)
    FIELD(RETENTION_STATUS_BANK2, I0, 0, 1)
REG32(RETENTION_ENTER_BANK3, 0x1b00)
    FIELD(RETENTION_ENTER_BANK3, I3, 3, 1)
    FIELD(RETENTION_ENTER_BANK3, I2, 2, 1)
    FIELD(RETENTION_ENTER_BANK3, I1, 1, 1)
    FIELD(RETENTION_ENTER_BANK3, I0, 0, 1)
REG32(RETENTION_STATUS_BANK3, 0x1b04)
    FIELD(RETENTION_STATUS_BANK3, I3, 3, 1)
    FIELD(RETENTION_STATUS_BANK3, I2, 2, 1)
    FIELD(RETENTION_STATUS_BANK3, I1, 1, 1)
    FIELD(RETENTION_STATUS_BANK3, I0, 0, 1)
REG32(SUPPLY_STATUS, 0x2000)
    FIELD(SUPPLY_STATUS, VCCINT_PL, 0, 1)
REG32(XRAM_FM_TZ_CTRL, 0x20fc)
    FIELD(XRAM_FM_TZ_CTRL, AXILITE, 3, 1)
    FIELD(XRAM_FM_TZ_CTRL, AXI2, 2, 1)
    FIELD(XRAM_FM_TZ_CTRL, AXI1, 1, 1)
    FIELD(XRAM_FM_TZ_CTRL, AXI0, 0, 1)
REG32(TZ_CTRL, 0x2100)
    FIELD(TZ_CTRL, SLCR_N, 8, 1)
    FIELD(TZ_CTRL, BANK3_XMPU_N, 7, 1)
    FIELD(TZ_CTRL, BANK2_XMPU_N, 6, 1)
    FIELD(TZ_CTRL, BANK1_XMPU_N, 5, 1)
    FIELD(TZ_CTRL, BANK0_XMPU_N, 4, 1)
    FIELD(TZ_CTRL, BANK3_APB_N, 3, 1)
    FIELD(TZ_CTRL, BANK2_APB_N, 2, 1)
    FIELD(TZ_CTRL, BANK1_APB_N, 1, 1)
    FIELD(TZ_CTRL, BANK0_APB_N, 0, 1)
REG32(TZ_CTRL_LOCK, 0x2104)
    FIELD(TZ_CTRL_LOCK, LOCK, 0, 1)
REG32(MEM_CLR_UNISON, 0x2108)
    FIELD(MEM_CLR_UNISON, EN, 0, 1)
REG32(XMPU_CFG, 0x5000)
    FIELD(XMPU_CFG, XMPU3_ALIGN, 3, 1)
    FIELD(XMPU_CFG, XMPU2_ALIGN, 2, 1)
    FIELD(XMPU_CFG, XMPU1_ALIGN, 1, 1)
    FIELD(XMPU_CFG, XMPU0_ALIGN, 0, 1)
REG32(PL_AXI0_CTRL, 0x5100)
    FIELD(PL_AXI0_CTRL, RAW_RST_N, 2, 1)
    FIELD(PL_AXI0_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(PL_AXI0_CTRL, MAINEXTEN, 0, 1)
REG32(PL_AXI0_STATUS, 0x5104)
    FIELD(PL_AXI0_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(PL_AXI0_STATUS, POWER_IDLE, 0, 1)
REG32(PL_AXI1_CTRL, 0x5110)
    FIELD(PL_AXI1_CTRL, RAW_RST_N, 2, 1)
    FIELD(PL_AXI1_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(PL_AXI1_CTRL, MAINEXTEN, 0, 1)
REG32(PL_AXI1_STATUS, 0x5114)
    FIELD(PL_AXI1_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(PL_AXI1_STATUS, POWER_IDLE, 0, 1)
REG32(PL_AXI2_CTRL, 0x5120)
    FIELD(PL_AXI2_CTRL, RAW_RST_N, 2, 1)
    FIELD(PL_AXI2_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(PL_AXI2_CTRL, MAINEXTEN, 0, 1)
REG32(PL_AXI2_STATUS, 0x5124)
    FIELD(PL_AXI2_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(PL_AXI2_STATUS, POWER_IDLE, 0, 1)
REG32(PL_AXI_LITE_CTRL, 0x5180)
    FIELD(PL_AXI_LITE_CTRL, RAW_RST_N, 2, 1)
    FIELD(PL_AXI_LITE_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(PL_AXI_LITE_CTRL, MAINEXTEN, 0, 1)
REG32(PL_AXI_LITE_STATUS, 0x5184)
    FIELD(PL_AXI_LITE_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(PL_AXI_LITE_STATUS, POWER_IDLE, 0, 1)
REG32(PS_AXI_CTRL, 0x5200)
    FIELD(PS_AXI_CTRL, RAW_RST_N, 2, 1)
    FIELD(PS_AXI_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(PS_AXI_CTRL, MAINEXTEN, 0, 1)
REG32(PS_AXI_STATUS, 0x5204)
    FIELD(PS_AXI_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(PS_AXI_STATUS, POWER_IDLE, 0, 1)
REG32(PS_APB_CTRL, 0x5280)
    FIELD(PS_APB_CTRL, RAW_RST_N, 2, 1)
    FIELD(PS_APB_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(PS_APB_CTRL, MAINEXTEN, 0, 1)
REG32(PS_APB_STATUS, 0x5284)
    FIELD(PS_APB_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(PS_APB_STATUS, POWER_IDLE, 0, 1)
REG32(BANK0_AXI_CTRL, 0x5300)
    FIELD(BANK0_AXI_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK0_AXI_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK0_AXI_CTRL, MAINEXTEN, 0, 1)
REG32(BANK0_AXI_STATUS, 0x5304)
    FIELD(BANK0_AXI_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK0_AXI_STATUS, POWER_IDLE, 0, 1)
REG32(BANK1_AXI_CTRL, 0x5310)
    FIELD(BANK1_AXI_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK1_AXI_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK1_AXI_CTRL, MAINEXTEN, 0, 1)
REG32(BANK1_AXI_STATUS, 0x5314)
    FIELD(BANK1_AXI_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK1_AXI_STATUS, POWER_IDLE, 0, 1)
REG32(BANK2_AXI_CTRL, 0x5320)
    FIELD(BANK2_AXI_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK2_AXI_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK2_AXI_CTRL, MAINEXTEN, 0, 1)
REG32(BANK2_AXI_STATUS, 0x5324)
    FIELD(BANK2_AXI_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK2_AXI_STATUS, POWER_IDLE, 0, 1)
REG32(BANK3_AXI_CTRL, 0x5330)
    FIELD(BANK3_AXI_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK3_AXI_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK3_AXI_CTRL, MAINEXTEN, 0, 1)
REG32(BANK3_AXI_STATUS, 0x5334)
    FIELD(BANK3_AXI_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK3_AXI_STATUS, POWER_IDLE, 0, 1)
REG32(BANK0_APB_CTRL, 0x5380)
    FIELD(BANK0_APB_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK0_APB_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK0_APB_CTRL, MAINEXTEN, 0, 1)
REG32(BANK0_APB_STATUS, 0x5384)
    FIELD(BANK0_APB_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK0_APB_STATUS, POWER_IDLE, 0, 1)
REG32(BANK1_APB_CTRL, 0x5390)
    FIELD(BANK1_APB_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK1_APB_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK1_APB_CTRL, MAINEXTEN, 0, 1)
REG32(BANK1_APB_STATUS, 0x5394)
    FIELD(BANK1_APB_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK1_APB_STATUS, POWER_IDLE, 0, 1)
REG32(BANK2_APB_CTRL, 0x53a0)
    FIELD(BANK2_APB_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK2_APB_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK2_APB_CTRL, MAINEXTEN, 0, 1)
REG32(BANK2_APB_STATUS, 0x53a4)
    FIELD(BANK2_APB_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK2_APB_STATUS, POWER_IDLE, 0, 1)
REG32(BANK3_APB_CTRL, 0x53b0)
    FIELD(BANK3_APB_CTRL, RAW_RST_N, 2, 1)
    FIELD(BANK3_APB_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(BANK3_APB_CTRL, MAINEXTEN, 0, 1)
REG32(BANK3_APB_STATUS, 0x53b4)
    FIELD(BANK3_APB_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(BANK3_APB_STATUS, POWER_IDLE, 0, 1)
REG32(SLCR_APB_CTRL, 0x5400)
    FIELD(SLCR_APB_CTRL, RAW_RST_N, 2, 1)
    FIELD(SLCR_APB_CTRL, POWER_IDLEREQ, 1, 1)
    FIELD(SLCR_APB_CTRL, MAINEXTEN, 0, 1)
REG32(SLCR_APB_STATUS, 0x5404)
    FIELD(SLCR_APB_STATUS, POWER_IDLEACK, 1, 1)
    FIELD(SLCR_APB_STATUS, POWER_IDLE, 0, 1)
REG32(XRAM_FM0_AXI_WIDTH, 0x9000)
    FIELD(XRAM_FM0_AXI_WIDTH, RD, 2, 2)
    FIELD(XRAM_FM0_AXI_WIDTH, WR, 0, 2)
REG32(XRAM_FM0_ISSUING_CAPACITY, 0x9004)
    FIELD(XRAM_FM0_ISSUING_CAPACITY, RD, 4, 4)
    FIELD(XRAM_FM0_ISSUING_CAPACITY, WR, 0, 4)
REG32(XRAM_FM1_AXI_WIDTH, 0x9010)
    FIELD(XRAM_FM1_AXI_WIDTH, RD, 2, 2)
    FIELD(XRAM_FM1_AXI_WIDTH, WR, 0, 2)
REG32(XRAM_FM1_ISSUING_CAPACITY, 0x9014)
    FIELD(XRAM_FM1_ISSUING_CAPACITY, RD, 4, 4)
    FIELD(XRAM_FM1_ISSUING_CAPACITY, WR, 0, 4)
REG32(XRAM_FM2_AXI_WIDTH, 0x9020)
    FIELD(XRAM_FM2_AXI_WIDTH, RD, 2, 2)
    FIELD(XRAM_FM2_AXI_WIDTH, WR, 0, 2)
REG32(XRAM_FM2_ISSUING_CAPACITY, 0x9024)
    FIELD(XRAM_FM2_ISSUING_CAPACITY, RD, 4, 4)
    FIELD(XRAM_FM2_ISSUING_CAPACITY, WR, 0, 4)
REG32(SLVERR_ISR, 0xa000)
    FIELD(SLVERR_ISR, BANK3_SLVERR, 4, 1)
    FIELD(SLVERR_ISR, BANK2_SLVERR, 3, 1)
    FIELD(SLVERR_ISR, BANK1_SLVERR, 2, 1)
    FIELD(SLVERR_ISR, BANK0_SLVERR, 1, 1)
    FIELD(SLVERR_ISR, SLCR_SLVERR, 0, 1)
REG32(SLVERR_ITR, 0xa004)
    FIELD(SLVERR_ITR, BANK3_SLVERR, 4, 1)
    FIELD(SLVERR_ITR, BANK2_SLVERR, 3, 1)
    FIELD(SLVERR_ITR, BANK1_SLVERR, 2, 1)
    FIELD(SLVERR_ITR, BANK0_SLVERR, 1, 1)
    FIELD(SLVERR_ITR, SLCR_SLVERR, 0, 1)
REG32(CE_SLVERR_IMR, 0xa008)
    FIELD(CE_SLVERR_IMR, BANK3_SLVERR, 4, 1)
    FIELD(CE_SLVERR_IMR, BANK2_SLVERR, 3, 1)
    FIELD(CE_SLVERR_IMR, BANK1_SLVERR, 2, 1)
    FIELD(CE_SLVERR_IMR, BANK0_SLVERR, 1, 1)
    FIELD(CE_SLVERR_IMR, SLCR_SLVERR, 0, 1)
REG32(CE_SLVERR_IER, 0xa00c)
    FIELD(CE_SLVERR_IER, BANK3_SLVERR, 4, 1)
    FIELD(CE_SLVERR_IER, BANK2_SLVERR, 3, 1)
    FIELD(CE_SLVERR_IER, BANK1_SLVERR, 2, 1)
    FIELD(CE_SLVERR_IER, BANK0_SLVERR, 1, 1)
    FIELD(CE_SLVERR_IER, SLCR_SLVERR, 0, 1)
REG32(CE_SLVERR_IDR, 0xa010)
    FIELD(CE_SLVERR_IDR, BANK3_SLVERR, 4, 1)
    FIELD(CE_SLVERR_IDR, BANK2_SLVERR, 3, 1)
    FIELD(CE_SLVERR_IDR, BANK1_SLVERR, 2, 1)
    FIELD(CE_SLVERR_IDR, BANK0_SLVERR, 1, 1)
    FIELD(CE_SLVERR_IDR, SLCR_SLVERR, 0, 1)
REG32(UCE_SLVERR_IMR, 0xa014)
    FIELD(UCE_SLVERR_IMR, BANK3_SLVERR, 4, 1)
    FIELD(UCE_SLVERR_IMR, BANK2_SLVERR, 3, 1)
    FIELD(UCE_SLVERR_IMR, BANK1_SLVERR, 2, 1)
    FIELD(UCE_SLVERR_IMR, BANK0_SLVERR, 1, 1)
    FIELD(UCE_SLVERR_IMR, SLCR_SLVERR, 0, 1)
REG32(UCE_SLVERR_IER, 0xa018)
    FIELD(UCE_SLVERR_IER, BANK3_SLVERR, 4, 1)
    FIELD(UCE_SLVERR_IER, BANK2_SLVERR, 3, 1)
    FIELD(UCE_SLVERR_IER, BANK1_SLVERR, 2, 1)
    FIELD(UCE_SLVERR_IER, BANK0_SLVERR, 1, 1)
    FIELD(UCE_SLVERR_IER, SLCR_SLVERR, 0, 1)
REG32(UCE_SLVERR_IDR, 0xa01c)
    FIELD(UCE_SLVERR_IDR, BANK3_SLVERR, 4, 1)
    FIELD(UCE_SLVERR_IDR, BANK2_SLVERR, 3, 1)
    FIELD(UCE_SLVERR_IDR, BANK1_SLVERR, 2, 1)
    FIELD(UCE_SLVERR_IDR, BANK0_SLVERR, 1, 1)
    FIELD(UCE_SLVERR_IDR, SLCR_SLVERR, 0, 1)
REG32(BANK_PWR_ISR, 0xa020)
    FIELD(BANK_PWR_ISR, BANK3_I3_PWRERR, 15, 1)
    FIELD(BANK_PWR_ISR, BANK3_I2_PWRERR, 14, 1)
    FIELD(BANK_PWR_ISR, BANK3_I1_PWRERR, 13, 1)
    FIELD(BANK_PWR_ISR, BANK3_I0_PWRERR, 12, 1)
    FIELD(BANK_PWR_ISR, BANK2_I3_PWRERR, 11, 1)
    FIELD(BANK_PWR_ISR, BANK2_I2_PWRERR, 10, 1)
    FIELD(BANK_PWR_ISR, BANK2_I1_PWRERR, 9, 1)
    FIELD(BANK_PWR_ISR, BANK2_I0_PWRERR, 8, 1)
    FIELD(BANK_PWR_ISR, BANK1_I3_PWRERR, 7, 1)
    FIELD(BANK_PWR_ISR, BANK1_I2_PWRERR, 6, 1)
    FIELD(BANK_PWR_ISR, BANK1_I1_PWRERR, 5, 1)
    FIELD(BANK_PWR_ISR, BANK1_I0_PWRERR, 4, 1)
    FIELD(BANK_PWR_ISR, BANK0_I3_PWRERR, 3, 1)
    FIELD(BANK_PWR_ISR, BANK0_I2_PWRERR, 2, 1)
    FIELD(BANK_PWR_ISR, BANK0_I1_PWRERR, 1, 1)
    FIELD(BANK_PWR_ISR, BANK0_I0_PWRERR, 0, 1)
REG32(BANK_PWR_ITR, 0xa024)
    FIELD(BANK_PWR_ITR, BANK3_I3_PWRERR, 15, 1)
    FIELD(BANK_PWR_ITR, BANK3_I2_PWRERR, 14, 1)
    FIELD(BANK_PWR_ITR, BANK3_I1_PWRERR, 13, 1)
    FIELD(BANK_PWR_ITR, BANK3_I0_PWRERR, 12, 1)
    FIELD(BANK_PWR_ITR, BANK2_I3_PWRERR, 11, 1)
    FIELD(BANK_PWR_ITR, BANK2_I2_PWRERR, 10, 1)
    FIELD(BANK_PWR_ITR, BANK2_I1_PWRERR, 9, 1)
    FIELD(BANK_PWR_ITR, BANK2_I0_PWRERR, 8, 1)
    FIELD(BANK_PWR_ITR, BANK1_I3_PWRERR, 7, 1)
    FIELD(BANK_PWR_ITR, BANK1_I2_PWRERR, 6, 1)
    FIELD(BANK_PWR_ITR, BANK1_I1_PWRERR, 5, 1)
    FIELD(BANK_PWR_ITR, BANK1_I0_PWRERR, 4, 1)
    FIELD(BANK_PWR_ITR, BANK0_I3_PWRERR, 3, 1)
    FIELD(BANK_PWR_ITR, BANK0_I2_PWRERR, 2, 1)
    FIELD(BANK_PWR_ITR, BANK0_I1_PWRERR, 1, 1)
    FIELD(BANK_PWR_ITR, BANK0_I0_PWRERR, 0, 1)
REG32(CE_BANK_PWR_IMR, 0xa028)
    FIELD(CE_BANK_PWR_IMR, BANK3_I3_PWRERR, 15, 1)
    FIELD(CE_BANK_PWR_IMR, BANK3_I2_PWRERR, 14, 1)
    FIELD(CE_BANK_PWR_IMR, BANK3_I1_PWRERR, 13, 1)
    FIELD(CE_BANK_PWR_IMR, BANK3_I0_PWRERR, 12, 1)
    FIELD(CE_BANK_PWR_IMR, BANK2_I3_PWRERR, 11, 1)
    FIELD(CE_BANK_PWR_IMR, BANK2_I2_PWRERR, 10, 1)
    FIELD(CE_BANK_PWR_IMR, BANK2_I1_PWRERR, 9, 1)
    FIELD(CE_BANK_PWR_IMR, BANK2_I0_PWRERR, 8, 1)
    FIELD(CE_BANK_PWR_IMR, BANK1_I3_PWRERR, 7, 1)
    FIELD(CE_BANK_PWR_IMR, BANK1_I2_PWRERR, 6, 1)
    FIELD(CE_BANK_PWR_IMR, BANK1_I1_PWRERR, 5, 1)
    FIELD(CE_BANK_PWR_IMR, BANK1_I0_PWRERR, 4, 1)
    FIELD(CE_BANK_PWR_IMR, BANK0_I3_PWRERR, 3, 1)
    FIELD(CE_BANK_PWR_IMR, BANK0_I2_PWRERR, 2, 1)
    FIELD(CE_BANK_PWR_IMR, BANK0_I1_PWRERR, 1, 1)
    FIELD(CE_BANK_PWR_IMR, BANK0_I0_PWRERR, 0, 1)
REG32(CE_BANK_PWR_IER, 0xa02c)
    FIELD(CE_BANK_PWR_IER, BANK3_I3_PWRERR, 15, 1)
    FIELD(CE_BANK_PWR_IER, BANK3_I2_PWRERR, 14, 1)
    FIELD(CE_BANK_PWR_IER, BANK3_I1_PWRERR, 13, 1)
    FIELD(CE_BANK_PWR_IER, BANK3_I0_PWRERR, 12, 1)
    FIELD(CE_BANK_PWR_IER, BANK2_I3_PWRERR, 11, 1)
    FIELD(CE_BANK_PWR_IER, BANK2_I2_PWRERR, 10, 1)
    FIELD(CE_BANK_PWR_IER, BANK2_I1_PWRERR, 9, 1)
    FIELD(CE_BANK_PWR_IER, BANK2_I0_PWRERR, 8, 1)
    FIELD(CE_BANK_PWR_IER, BANK1_I3_PWRERR, 7, 1)
    FIELD(CE_BANK_PWR_IER, BANK1_I2_PWRERR, 6, 1)
    FIELD(CE_BANK_PWR_IER, BANK1_I1_PWRERR, 5, 1)
    FIELD(CE_BANK_PWR_IER, BANK1_I0_PWRERR, 4, 1)
    FIELD(CE_BANK_PWR_IER, BANK0_I3_PWRERR, 3, 1)
    FIELD(CE_BANK_PWR_IER, BANK0_I2_PWRERR, 2, 1)
    FIELD(CE_BANK_PWR_IER, BANK0_I1_PWRERR, 1, 1)
    FIELD(CE_BANK_PWR_IER, BANK0_I0_PWRERR, 0, 1)
REG32(CE_BANK_PWR_IDR, 0xa030)
    FIELD(CE_BANK_PWR_IDR, BANK3_I3_PWRERR, 15, 1)
    FIELD(CE_BANK_PWR_IDR, BANK3_I2_PWRERR, 14, 1)
    FIELD(CE_BANK_PWR_IDR, BANK3_I1_PWRERR, 13, 1)
    FIELD(CE_BANK_PWR_IDR, BANK3_I0_PWRERR, 12, 1)
    FIELD(CE_BANK_PWR_IDR, BANK2_I3_PWRERR, 11, 1)
    FIELD(CE_BANK_PWR_IDR, BANK2_I2_PWRERR, 10, 1)
    FIELD(CE_BANK_PWR_IDR, BANK2_I1_PWRERR, 9, 1)
    FIELD(CE_BANK_PWR_IDR, BANK2_I0_PWRERR, 8, 1)
    FIELD(CE_BANK_PWR_IDR, BANK1_I3_PWRERR, 7, 1)
    FIELD(CE_BANK_PWR_IDR, BANK1_I2_PWRERR, 6, 1)
    FIELD(CE_BANK_PWR_IDR, BANK1_I1_PWRERR, 5, 1)
    FIELD(CE_BANK_PWR_IDR, BANK1_I0_PWRERR, 4, 1)
    FIELD(CE_BANK_PWR_IDR, BANK0_I3_PWRERR, 3, 1)
    FIELD(CE_BANK_PWR_IDR, BANK0_I2_PWRERR, 2, 1)
    FIELD(CE_BANK_PWR_IDR, BANK0_I1_PWRERR, 1, 1)
    FIELD(CE_BANK_PWR_IDR, BANK0_I0_PWRERR, 0, 1)
REG32(UCE_BANK_PWR_IMR, 0xa034)
    FIELD(UCE_BANK_PWR_IMR, BANK3_I3_PWRERR, 15, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK3_I2_PWRERR, 14, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK3_I1_PWRERR, 13, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK3_I0_PWRERR, 12, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK2_I3_PWRERR, 11, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK2_I2_PWRERR, 10, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK2_I1_PWRERR, 9, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK2_I0_PWRERR, 8, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK1_I3_PWRERR, 7, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK1_I2_PWRERR, 6, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK1_I1_PWRERR, 5, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK1_I0_PWRERR, 4, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK0_I3_PWRERR, 3, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK0_I2_PWRERR, 2, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK0_I1_PWRERR, 1, 1)
    FIELD(UCE_BANK_PWR_IMR, BANK0_I0_PWRERR, 0, 1)
REG32(UCE_BANK_PWR_IER, 0xa038)
    FIELD(UCE_BANK_PWR_IER, BANK3_I3_PWRERR, 15, 1)
    FIELD(UCE_BANK_PWR_IER, BANK3_I2_PWRERR, 14, 1)
    FIELD(UCE_BANK_PWR_IER, BANK3_I1_PWRERR, 13, 1)
    FIELD(UCE_BANK_PWR_IER, BANK3_I0_PWRERR, 12, 1)
    FIELD(UCE_BANK_PWR_IER, BANK2_I3_PWRERR, 11, 1)
    FIELD(UCE_BANK_PWR_IER, BANK2_I2_PWRERR, 10, 1)
    FIELD(UCE_BANK_PWR_IER, BANK2_I1_PWRERR, 9, 1)
    FIELD(UCE_BANK_PWR_IER, BANK2_I0_PWRERR, 8, 1)
    FIELD(UCE_BANK_PWR_IER, BANK1_I3_PWRERR, 7, 1)
    FIELD(UCE_BANK_PWR_IER, BANK1_I2_PWRERR, 6, 1)
    FIELD(UCE_BANK_PWR_IER, BANK1_I1_PWRERR, 5, 1)
    FIELD(UCE_BANK_PWR_IER, BANK1_I0_PWRERR, 4, 1)
    FIELD(UCE_BANK_PWR_IER, BANK0_I3_PWRERR, 3, 1)
    FIELD(UCE_BANK_PWR_IER, BANK0_I2_PWRERR, 2, 1)
    FIELD(UCE_BANK_PWR_IER, BANK0_I1_PWRERR, 1, 1)
    FIELD(UCE_BANK_PWR_IER, BANK0_I0_PWRERR, 0, 1)
REG32(UCE_BANK_PWR_IDR, 0xa03c)
    FIELD(UCE_BANK_PWR_IDR, BANK3_I3_PWRERR, 15, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK3_I2_PWRERR, 14, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK3_I1_PWRERR, 13, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK3_I0_PWRERR, 12, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK2_I3_PWRERR, 11, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK2_I2_PWRERR, 10, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK2_I1_PWRERR, 9, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK2_I0_PWRERR, 8, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK1_I3_PWRERR, 7, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK1_I2_PWRERR, 6, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK1_I1_PWRERR, 5, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK1_I0_PWRERR, 4, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK0_I3_PWRERR, 3, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK0_I2_PWRERR, 2, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK0_I1_PWRERR, 1, 1)
    FIELD(UCE_BANK_PWR_IDR, BANK0_I0_PWRERR, 0, 1)
REG32(BANK_AXI_ISR, 0xa040)
REG32(BANK_AXI_ITR, 0xa044)
REG32(CE_BANK_AXI_IMR, 0xa048)
REG32(CE_BANK_AXI_IER, 0xa04c)
REG32(CE_BANK_AXI_IDR, 0xa050)
REG32(UCE_BANK_AXI_IMR, 0xa054)
REG32(UCE_BANK_AXI_IER, 0xa058)
REG32(UCE_BANK_AXI_IDR, 0xa05c)
REG32(BANK_ECC_CE_ISR, 0xa060)
    FIELD(BANK_ECC_CE_ISR, BANK3, 3, 1)
    FIELD(BANK_ECC_CE_ISR, BANK2, 2, 1)
    FIELD(BANK_ECC_CE_ISR, BANK1, 1, 1)
    FIELD(BANK_ECC_CE_ISR, BANK0, 0, 1)
REG32(BANK_ECC_CE_ITR, 0xa064)
    FIELD(BANK_ECC_CE_ITR, BANK3, 3, 1)
    FIELD(BANK_ECC_CE_ITR, BANK2, 2, 1)
    FIELD(BANK_ECC_CE_ITR, BANK1, 1, 1)
    FIELD(BANK_ECC_CE_ITR, BANK0, 0, 1)
REG32(CE_BANK_ECC_IMR, 0xa068)
    FIELD(CE_BANK_ECC_IMR, BANK3, 3, 1)
    FIELD(CE_BANK_ECC_IMR, BANK2, 2, 1)
    FIELD(CE_BANK_ECC_IMR, BANK1, 1, 1)
    FIELD(CE_BANK_ECC_IMR, BANK0, 0, 1)
REG32(CE_BANK_ECC_IER, 0xa06c)
    FIELD(CE_BANK_ECC_IER, BANK3, 3, 1)
    FIELD(CE_BANK_ECC_IER, BANK2, 2, 1)
    FIELD(CE_BANK_ECC_IER, BANK1, 1, 1)
    FIELD(CE_BANK_ECC_IER, BANK0, 0, 1)
REG32(CE_BANK_ECC_IDR, 0xa070)
    FIELD(CE_BANK_ECC_IDR, BANK3, 3, 1)
    FIELD(CE_BANK_ECC_IDR, BANK2, 2, 1)
    FIELD(CE_BANK_ECC_IDR, BANK1, 1, 1)
    FIELD(CE_BANK_ECC_IDR, BANK0, 0, 1)
REG32(BANK_ECC_UCE_ISR, 0xa080)
    FIELD(BANK_ECC_UCE_ISR, BANK3, 3, 1)
    FIELD(BANK_ECC_UCE_ISR, BANK2, 2, 1)
    FIELD(BANK_ECC_UCE_ISR, BANK1, 1, 1)
    FIELD(BANK_ECC_UCE_ISR, BANK0, 0, 1)
REG32(BANK_ECC_UCE_ITR, 0xa084)
    FIELD(BANK_ECC_UCE_ITR, BANK3, 3, 1)
    FIELD(BANK_ECC_UCE_ITR, BANK2, 2, 1)
    FIELD(BANK_ECC_UCE_ITR, BANK1, 1, 1)
    FIELD(BANK_ECC_UCE_ITR, BANK0, 0, 1)
REG32(UCE_BANK_ECC_IMR, 0xa088)
    FIELD(UCE_BANK_ECC_IMR, BANK3, 3, 1)
    FIELD(UCE_BANK_ECC_IMR, BANK2, 2, 1)
    FIELD(UCE_BANK_ECC_IMR, BANK1, 1, 1)
    FIELD(UCE_BANK_ECC_IMR, BANK0, 0, 1)
REG32(UCE_BANK_ECC_IER, 0xa08c)
    FIELD(UCE_BANK_ECC_IER, BANK3, 3, 1)
    FIELD(UCE_BANK_ECC_IER, BANK2, 2, 1)
    FIELD(UCE_BANK_ECC_IER, BANK1, 1, 1)
    FIELD(UCE_BANK_ECC_IER, BANK0, 0, 1)
REG32(UCE_BANK_ECC_IDR, 0xa090)
    FIELD(UCE_BANK_ECC_IDR, BANK3, 3, 1)
    FIELD(UCE_BANK_ECC_IDR, BANK2, 2, 1)
    FIELD(UCE_BANK_ECC_IDR, BANK1, 1, 1)
    FIELD(UCE_BANK_ECC_IDR, BANK0, 0, 1)
REG32(BANK_RMW_UCE_ISR, 0xa094)
    FIELD(BANK_RMW_UCE_ISR, BANK3, 3, 1)
    FIELD(BANK_RMW_UCE_ISR, BANK2, 2, 1)
    FIELD(BANK_RMW_UCE_ISR, BANK1, 1, 1)
    FIELD(BANK_RMW_UCE_ISR, BANK0, 0, 1)
REG32(BANK_RMW_UCE_ITR, 0xa098)
    FIELD(BANK_RMW_UCE_ITR, BANK3, 3, 1)
    FIELD(BANK_RMW_UCE_ITR, BANK2, 2, 1)
    FIELD(BANK_RMW_UCE_ITR, BANK1, 1, 1)
    FIELD(BANK_RMW_UCE_ITR, BANK0, 0, 1)
REG32(UCE_BANK_RMW_IMR, 0xa09c)
    FIELD(UCE_BANK_RMW_IMR, BANK3, 3, 1)
    FIELD(UCE_BANK_RMW_IMR, BANK2, 2, 1)
    FIELD(UCE_BANK_RMW_IMR, BANK1, 1, 1)
    FIELD(UCE_BANK_RMW_IMR, BANK0, 0, 1)
REG32(UCE_BANK_RMW_IER, 0xa0a0)
    FIELD(UCE_BANK_RMW_IER, BANK3, 3, 1)
    FIELD(UCE_BANK_RMW_IER, BANK2, 2, 1)
    FIELD(UCE_BANK_RMW_IER, BANK1, 1, 1)
    FIELD(UCE_BANK_RMW_IER, BANK0, 0, 1)
REG32(UCE_BANK_RMW_IDR, 0xa0a4)
    FIELD(UCE_BANK_RMW_IDR, BANK3, 3, 1)
    FIELD(UCE_BANK_RMW_IDR, BANK2, 2, 1)
    FIELD(UCE_BANK_RMW_IDR, BANK1, 1, 1)
    FIELD(UCE_BANK_RMW_IDR, BANK0, 0, 1)
REG32(BANK_PWR_FSM_ISR, 0xa0a8)
    FIELD(BANK_PWR_FSM_ISR, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(BANK_PWR_FSM_ISR, BANK0_I0_FSM_ERR, 0, 1)
REG32(BANK_PWR_FSM_ITR, 0xa0ac)
    FIELD(BANK_PWR_FSM_ITR, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(BANK_PWR_FSM_ITR, BANK0_I0_FSM_ERR, 0, 1)
REG32(CE_BANK_PWR_FSM_IMR, 0xa0b0)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(CE_BANK_PWR_FSM_IMR, BANK0_I0_FSM_ERR, 0, 1)
REG32(CE_BANK_PWR_FSM_IER, 0xa0b4)
    FIELD(CE_BANK_PWR_FSM_IER, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(CE_BANK_PWR_FSM_IER, BANK0_I0_FSM_ERR, 0, 1)
REG32(CE_BANK_PWR_FSM_IDR, 0xa0b8)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(CE_BANK_PWR_FSM_IDR, BANK0_I0_FSM_ERR, 0, 1)
REG32(UCE_BANK_PWR_FSM_IMR, 0xa0bc)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(UCE_BANK_PWR_FSM_IMR, BANK0_I0_FSM_ERR, 0, 1)
REG32(UCE_BANK_PWR_FSM_IER, 0xa0c0)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(UCE_BANK_PWR_FSM_IER, BANK0_I0_FSM_ERR, 0, 1)
REG32(UCE_BANK_PWR_FSM_IDR, 0xa0c4)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK3_I3_FSM_ERR, 15, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK3_I2_FSM_ERR, 14, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK3_I1_FSM_ERR, 13, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK3_I0_FSM_ERR, 12, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK2_I3_FSM_ERR, 11, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK2_I2_FSM_ERR, 10, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK2_I1_FSM_ERR, 9, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK2_I0_FSM_ERR, 8, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK1_I3_FSM_ERR, 7, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK1_I2_FSM_ERR, 6, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK1_I1_FSM_ERR, 5, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK1_I0_FSM_ERR, 4, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK0_I3_FSM_ERR, 3, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK0_I2_FSM_ERR, 2, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK0_I1_FSM_ERR, 1, 1)
    FIELD(UCE_BANK_PWR_FSM_IDR, BANK0_I0_FSM_ERR, 0, 1)
REG32(INVALID_RET_REQ_ISR, 0xa0c8)
    FIELD(INVALID_RET_REQ_ISR, BANK3_I3_ERR, 15, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK3_I2_ERR, 14, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK3_I1_ERR, 13, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK3_I0_ERR, 12, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK2_I3_ERR, 11, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK2_I2_ERR, 10, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK2_I1_ERR, 9, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK2_I0_ERR, 8, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK1_I3_ERR, 7, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK1_I2_ERR, 6, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK1_I1_ERR, 5, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK1_I0_ERR, 4, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK0_I3_ERR, 3, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK0_I2_ERR, 2, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK0_I1_ERR, 1, 1)
    FIELD(INVALID_RET_REQ_ISR, BANK0_I0_ERR, 0, 1)
REG32(INVALID_RET_REQ_ITR, 0xa0cc)
    FIELD(INVALID_RET_REQ_ITR, BANK3_I3_ERR, 15, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK3_I2_ERR, 14, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK3_I1_ERR, 13, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK3_I0_ERR, 12, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK2_I3_ERR, 11, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK2_I2_ERR, 10, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK2_I1_ERR, 9, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK2_I0_ERR, 8, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK1_I3_ERR, 7, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK1_I2_ERR, 6, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK1_I1_ERR, 5, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK1_I0_ERR, 4, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK0_I3_ERR, 3, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK0_I2_ERR, 2, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK0_I1_ERR, 1, 1)
    FIELD(INVALID_RET_REQ_ITR, BANK0_I0_ERR, 0, 1)
REG32(CE_INVALID_RET_REQ_IMR, 0xa0d0)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK3_I3_ERR, 15, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK3_I2_ERR, 14, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK3_I1_ERR, 13, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK3_I0_ERR, 12, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK2_I3_ERR, 11, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK2_I2_ERR, 10, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK2_I1_ERR, 9, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK2_I0_ERR, 8, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK1_I3_ERR, 7, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK1_I2_ERR, 6, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK1_I1_ERR, 5, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK1_I0_ERR, 4, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK0_I3_ERR, 3, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK0_I2_ERR, 2, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK0_I1_ERR, 1, 1)
    FIELD(CE_INVALID_RET_REQ_IMR, BANK0_I0_ERR, 0, 1)
REG32(CE_INVALID_RET_REQ_IER, 0xa0d4)
    FIELD(CE_INVALID_RET_REQ_IER, BANK3_I3_ERR, 15, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK3_I2_ERR, 14, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK3_I1_ERR, 13, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK3_I0_ERR, 12, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK2_I3_ERR, 11, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK2_I2_ERR, 10, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK2_I1_ERR, 9, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK2_I0_ERR, 8, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK1_I3_ERR, 7, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK1_I2_ERR, 6, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK1_I1_ERR, 5, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK1_I0_ERR, 4, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK0_I3_ERR, 3, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK0_I2_ERR, 2, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK0_I1_ERR, 1, 1)
    FIELD(CE_INVALID_RET_REQ_IER, BANK0_I0_ERR, 0, 1)
REG32(CE_INVALID_RET_REQ_IDR, 0xa0d8)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK3_I3_ERR, 15, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK3_I2_ERR, 14, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK3_I1_ERR, 13, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK3_I0_ERR, 12, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK2_I3_ERR, 11, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK2_I2_ERR, 10, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK2_I1_ERR, 9, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK2_I0_ERR, 8, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK1_I3_ERR, 7, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK1_I2_ERR, 6, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK1_I1_ERR, 5, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK1_I0_ERR, 4, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK0_I3_ERR, 3, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK0_I2_ERR, 2, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK0_I1_ERR, 1, 1)
    FIELD(CE_INVALID_RET_REQ_IDR, BANK0_I0_ERR, 0, 1)
REG32(UCE_INVALID_RET_REQ_IMR, 0xa0dc)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK3_I3_ERR, 15, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK3_I2_ERR, 14, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK3_I1_ERR, 13, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK3_I0_ERR, 12, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK2_I3_ERR, 11, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK2_I2_ERR, 10, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK2_I1_ERR, 9, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK2_I0_ERR, 8, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK1_I3_ERR, 7, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK1_I2_ERR, 6, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK1_I1_ERR, 5, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK1_I0_ERR, 4, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK0_I3_ERR, 3, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK0_I2_ERR, 2, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK0_I1_ERR, 1, 1)
    FIELD(UCE_INVALID_RET_REQ_IMR, BANK0_I0_ERR, 0, 1)
REG32(UCE_INVALID_RET_REQ_IER, 0xa0e0)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK3_I3_ERR, 15, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK3_I2_ERR, 14, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK3_I1_ERR, 13, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK3_I0_ERR, 12, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK2_I3_ERR, 11, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK2_I2_ERR, 10, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK2_I1_ERR, 9, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK2_I0_ERR, 8, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK1_I3_ERR, 7, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK1_I2_ERR, 6, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK1_I1_ERR, 5, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK1_I0_ERR, 4, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK0_I3_ERR, 3, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK0_I2_ERR, 2, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK0_I1_ERR, 1, 1)
    FIELD(UCE_INVALID_RET_REQ_IER, BANK0_I0_ERR, 0, 1)
REG32(UCE_INVALID_RET_REQ_IDR, 0xa0e4)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK3_I3_ERR, 15, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK3_I2_ERR, 14, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK3_I1_ERR, 13, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK3_I0_ERR, 12, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK2_I3_ERR, 11, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK2_I2_ERR, 10, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK2_I1_ERR, 9, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK2_I0_ERR, 8, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK1_I3_ERR, 7, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK1_I2_ERR, 6, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK1_I1_ERR, 5, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK1_I0_ERR, 4, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK0_I3_ERR, 3, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK0_I2_ERR, 2, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK0_I1_ERR, 1, 1)
    FIELD(UCE_INVALID_RET_REQ_IDR, BANK0_I0_ERR, 0, 1)
REG32(MULTIPLE_PWR_RET_REQ_ISR, 0xa0e8)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK3_I3_ERR, 15, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK3_I2_ERR, 14, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK3_I1_ERR, 13, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK3_I0_ERR, 12, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK2_I3_ERR, 11, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK2_I2_ERR, 10, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK2_I1_ERR, 9, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK2_I0_ERR, 8, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK1_I3_ERR, 7, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK1_I2_ERR, 6, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK1_I1_ERR, 5, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK1_I0_ERR, 4, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK0_I3_ERR, 3, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK0_I2_ERR, 2, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK0_I1_ERR, 1, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ISR, BANK0_I0_ERR, 0, 1)
REG32(MULTIPLE_PWR_RET_REQ_ITR, 0xa0ec)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK3_I3_ERR, 15, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK3_I2_ERR, 14, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK3_I1_ERR, 13, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK3_I0_ERR, 12, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK2_I3_ERR, 11, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK2_I2_ERR, 10, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK2_I1_ERR, 9, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK2_I0_ERR, 8, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK1_I3_ERR, 7, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK1_I2_ERR, 6, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK1_I1_ERR, 5, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK1_I0_ERR, 4, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK0_I3_ERR, 3, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK0_I2_ERR, 2, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK0_I1_ERR, 1, 1)
    FIELD(MULTIPLE_PWR_RET_REQ_ITR, BANK0_I0_ERR, 0, 1)
REG32(CE_MULTIPLE_PWR_RET_REQ_IMR, 0xa0f0)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I3_ERR, 15, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I2_ERR, 14, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I1_ERR, 13, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I0_ERR, 12, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I3_ERR, 11, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I2_ERR, 10, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I1_ERR, 9, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I0_ERR, 8, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I3_ERR, 7, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I2_ERR, 6, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I1_ERR, 5, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I0_ERR, 4, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I3_ERR, 3, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I2_ERR, 2, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I1_ERR, 1, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I0_ERR, 0, 1)
REG32(CE_MULTIPLE_PWR_RET_REQ_IER, 0xa0f4)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I3_ERR, 15, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I2_ERR, 14, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I1_ERR, 13, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I0_ERR, 12, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I3_ERR, 11, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I2_ERR, 10, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I1_ERR, 9, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I0_ERR, 8, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I3_ERR, 7, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I2_ERR, 6, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I1_ERR, 5, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I0_ERR, 4, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I3_ERR, 3, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I2_ERR, 2, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I1_ERR, 1, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I0_ERR, 0, 1)
REG32(CE_MULTIPLE_PWR_RET_REQ_IDR, 0xa0f8)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I3_ERR, 15, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I2_ERR, 14, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I1_ERR, 13, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I0_ERR, 12, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I3_ERR, 11, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I2_ERR, 10, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I1_ERR, 9, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I0_ERR, 8, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I3_ERR, 7, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I2_ERR, 6, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I1_ERR, 5, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I0_ERR, 4, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I3_ERR, 3, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I2_ERR, 2, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I1_ERR, 1, 1)
    FIELD(CE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I0_ERR, 0, 1)
REG32(UCE_MULTIPLE_PWR_RET_REQ_IMR, 0xa0fc)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I3_ERR, 15, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I2_ERR, 14, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I1_ERR, 13, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK3_I0_ERR, 12, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I3_ERR, 11, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I2_ERR, 10, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I1_ERR, 9, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK2_I0_ERR, 8, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I3_ERR, 7, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I2_ERR, 6, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I1_ERR, 5, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK1_I0_ERR, 4, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I3_ERR, 3, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I2_ERR, 2, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I1_ERR, 1, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IMR, BANK0_I0_ERR, 0, 1)
REG32(UCE_MULTIPLE_PWR_RET_REQ_IER, 0xa100)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I3_ERR, 15, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I2_ERR, 14, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I1_ERR, 13, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK3_I0_ERR, 12, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I3_ERR, 11, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I2_ERR, 10, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I1_ERR, 9, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK2_I0_ERR, 8, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I3_ERR, 7, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I2_ERR, 6, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I1_ERR, 5, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK1_I0_ERR, 4, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I3_ERR, 3, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I2_ERR, 2, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I1_ERR, 1, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IER, BANK0_I0_ERR, 0, 1)
REG32(UCE_MULTIPLE_PWR_RET_REQ_IDR, 0xa104)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I3_ERR, 15, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I2_ERR, 14, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I1_ERR, 13, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK3_I0_ERR, 12, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I3_ERR, 11, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I2_ERR, 10, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I1_ERR, 9, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK2_I0_ERR, 8, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I3_ERR, 7, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I2_ERR, 6, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I1_ERR, 5, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK1_I0_ERR, 4, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I3_ERR, 3, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I2_ERR, 2, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I1_ERR, 1, 1)
    FIELD(UCE_MULTIPLE_PWR_RET_REQ_IDR, BANK0_I0_ERR, 0, 1)
REG32(INT_XMPU_ISR, 0xa160)
    FIELD(INT_XMPU_ISR, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(INT_XMPU_ISR, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(INT_XMPU_ISR, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(INT_XMPU_ISR, XMPU_BANK0_FIREWALL, 0, 1)
REG32(INT_XMPU_ITR, 0xa164)
    FIELD(INT_XMPU_ITR, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(INT_XMPU_ITR, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(INT_XMPU_ITR, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(INT_XMPU_ITR, XMPU_BANK0_FIREWALL, 0, 1)
REG32(CE_INT_XMPU_IMR, 0xa168)
    FIELD(CE_INT_XMPU_IMR, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(CE_INT_XMPU_IMR, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(CE_INT_XMPU_IMR, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(CE_INT_XMPU_IMR, XMPU_BANK0_FIREWALL, 0, 1)
REG32(CE_INT_XMPU_IER, 0xa16c)
    FIELD(CE_INT_XMPU_IER, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(CE_INT_XMPU_IER, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(CE_INT_XMPU_IER, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(CE_INT_XMPU_IER, XMPU_BANK0_FIREWALL, 0, 1)
REG32(CE_INT_XMPU_IDR, 0xa170)
    FIELD(CE_INT_XMPU_IDR, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(CE_INT_XMPU_IDR, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(CE_INT_XMPU_IDR, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(CE_INT_XMPU_IDR, XMPU_BANK0_FIREWALL, 0, 1)
REG32(UCE_INT_XMPU_IMR, 0xa174)
    FIELD(UCE_INT_XMPU_IMR, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(UCE_INT_XMPU_IMR, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(UCE_INT_XMPU_IMR, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(UCE_INT_XMPU_IMR, XMPU_BANK0_FIREWALL, 0, 1)
REG32(UCE_INT_XMPU_IER, 0xa178)
    FIELD(UCE_INT_XMPU_IER, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(UCE_INT_XMPU_IER, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(UCE_INT_XMPU_IER, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(UCE_INT_XMPU_IER, XMPU_BANK0_FIREWALL, 0, 1)
REG32(UCE_INT_XMPU_IDR, 0xa17c)
    FIELD(UCE_INT_XMPU_IDR, XMPU_BANK3_FIREWALL, 3, 1)
    FIELD(UCE_INT_XMPU_IDR, XMPU_BANK2_FIREWALL, 2, 1)
    FIELD(UCE_INT_XMPU_IDR, XMPU_BANK1_FIREWALL, 1, 1)
    FIELD(UCE_INT_XMPU_IDR, XMPU_BANK0_FIREWALL, 0, 1)
REG32(INT_TIMEOUT_ISR, 0xa180)
    FIELD(INT_TIMEOUT_ISR, SLCR_APB, 8, 1)
    FIELD(INT_TIMEOUT_ISR, BANK3_APB, 7, 1)
    FIELD(INT_TIMEOUT_ISR, BANK3_AXI, 6, 1)
    FIELD(INT_TIMEOUT_ISR, BANK2_APB, 5, 1)
    FIELD(INT_TIMEOUT_ISR, BANK2_AXI, 4, 1)
    FIELD(INT_TIMEOUT_ISR, BANK1_APB, 3, 1)
    FIELD(INT_TIMEOUT_ISR, BANK1_AXI, 2, 1)
    FIELD(INT_TIMEOUT_ISR, BANK0_APB, 1, 1)
    FIELD(INT_TIMEOUT_ISR, BANK0_AXI, 0, 1)
REG32(INT_TIMEOUT_ITR, 0xa184)
    FIELD(INT_TIMEOUT_ITR, SLCR_APB, 8, 1)
    FIELD(INT_TIMEOUT_ITR, BANK3_APB, 7, 1)
    FIELD(INT_TIMEOUT_ITR, BANK3_AXI, 6, 1)
    FIELD(INT_TIMEOUT_ITR, BANK2_APB, 5, 1)
    FIELD(INT_TIMEOUT_ITR, BANK2_AXI, 4, 1)
    FIELD(INT_TIMEOUT_ITR, BANK1_APB, 3, 1)
    FIELD(INT_TIMEOUT_ITR, BANK1_AXI, 2, 1)
    FIELD(INT_TIMEOUT_ITR, BANK0_APB, 1, 1)
    FIELD(INT_TIMEOUT_ITR, BANK0_AXI, 0, 1)
REG32(CE_INT_TIMEOUT_IMR, 0xa188)
    FIELD(CE_INT_TIMEOUT_IMR, SLCR_APB, 8, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK3_APB, 7, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK3_AXI, 6, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK2_APB, 5, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK2_AXI, 4, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK1_APB, 3, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK1_AXI, 2, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK0_APB, 1, 1)
    FIELD(CE_INT_TIMEOUT_IMR, BANK0_AXI, 0, 1)
REG32(CE_INT_TIMEOUT_IER, 0xa18c)
    FIELD(CE_INT_TIMEOUT_IER, SLCR_APB, 8, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK3_APB, 7, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK3_AXI, 6, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK2_APB, 5, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK2_AXI, 4, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK1_APB, 3, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK1_AXI, 2, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK0_APB, 1, 1)
    FIELD(CE_INT_TIMEOUT_IER, BANK0_AXI, 0, 1)
REG32(CE_INT_TIMEOUT_IDR, 0xa190)
    FIELD(CE_INT_TIMEOUT_IDR, SLCR_APB, 8, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK3_APB, 7, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK3_AXI, 6, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK2_APB, 5, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK2_AXI, 4, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK1_APB, 3, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK1_AXI, 2, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK0_APB, 1, 1)
    FIELD(CE_INT_TIMEOUT_IDR, BANK0_AXI, 0, 1)
REG32(UCE_INT_TIMEOUT_IMR, 0xa194)
    FIELD(UCE_INT_TIMEOUT_IMR, SLCR_APB, 8, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK3_APB, 7, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK2_APB, 5, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK1_APB, 3, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK0_APB, 1, 1)
    FIELD(UCE_INT_TIMEOUT_IMR, BANK0_AXI, 0, 1)
REG32(UCE_INT_TIMEOUT_IER, 0xa198)
    FIELD(UCE_INT_TIMEOUT_IER, SLCR_APB, 8, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK3_APB, 7, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK2_APB, 5, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK1_APB, 3, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK0_APB, 1, 1)
    FIELD(UCE_INT_TIMEOUT_IER, BANK0_AXI, 0, 1)
REG32(UCE_INT_TIMEOUT_IDR, 0xa19c)
    FIELD(UCE_INT_TIMEOUT_IDR, SLCR_APB, 8, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK3_APB, 7, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK2_APB, 5, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK1_APB, 3, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK0_APB, 1, 1)
    FIELD(UCE_INT_TIMEOUT_IDR, BANK0_AXI, 0, 1)
REG32(INT_MISSION_ISR, 0xa1a0)
    FIELD(INT_MISSION_ISR, XRAM_PWR, 15, 1)
    FIELD(INT_MISSION_ISR, SLCR_APB, 14, 1)
    FIELD(INT_MISSION_ISR, PS_APB, 13, 1)
    FIELD(INT_MISSION_ISR, PS_AXI, 12, 1)
    FIELD(INT_MISSION_ISR, PL_AXI_LITE, 11, 1)
    FIELD(INT_MISSION_ISR, PL_AXI2, 10, 1)
    FIELD(INT_MISSION_ISR, PL_AXI1, 9, 1)
    FIELD(INT_MISSION_ISR, PL_AXI0, 8, 1)
    FIELD(INT_MISSION_ISR, BANK3_APB, 7, 1)
    FIELD(INT_MISSION_ISR, BANK3_AXI, 6, 1)
    FIELD(INT_MISSION_ISR, BANK2_APB, 5, 1)
    FIELD(INT_MISSION_ISR, BANK2_AXI, 4, 1)
    FIELD(INT_MISSION_ISR, BANK1_APB, 3, 1)
    FIELD(INT_MISSION_ISR, BANK1_AXI, 2, 1)
    FIELD(INT_MISSION_ISR, BANK0_APB, 1, 1)
    FIELD(INT_MISSION_ISR, BANK0_AXI, 0, 1)
REG32(INT_MISSION_ITR, 0xa1a4)
    FIELD(INT_MISSION_ITR, XRAM_PWR, 15, 1)
    FIELD(INT_MISSION_ITR, SLCR_APB, 14, 1)
    FIELD(INT_MISSION_ITR, PS_APB, 13, 1)
    FIELD(INT_MISSION_ITR, PS_AXI, 12, 1)
    FIELD(INT_MISSION_ITR, PL_AXI_LITE, 11, 1)
    FIELD(INT_MISSION_ITR, PL_AXI2, 10, 1)
    FIELD(INT_MISSION_ITR, PL_AXI1, 9, 1)
    FIELD(INT_MISSION_ITR, PL_AXI0, 8, 1)
    FIELD(INT_MISSION_ITR, BANK3_APB, 7, 1)
    FIELD(INT_MISSION_ITR, BANK3_AXI, 6, 1)
    FIELD(INT_MISSION_ITR, BANK2_APB, 5, 1)
    FIELD(INT_MISSION_ITR, BANK2_AXI, 4, 1)
    FIELD(INT_MISSION_ITR, BANK1_APB, 3, 1)
    FIELD(INT_MISSION_ITR, BANK1_AXI, 2, 1)
    FIELD(INT_MISSION_ITR, BANK0_APB, 1, 1)
    FIELD(INT_MISSION_ITR, BANK0_AXI, 0, 1)
REG32(CE_INT_MISSION_IMR, 0xa1a8)
    FIELD(CE_INT_MISSION_IMR, XRAM_PWR, 15, 1)
    FIELD(CE_INT_MISSION_IMR, SLCR_APB, 14, 1)
    FIELD(CE_INT_MISSION_IMR, PS_APB, 13, 1)
    FIELD(CE_INT_MISSION_IMR, PS_AXI, 12, 1)
    FIELD(CE_INT_MISSION_IMR, PL_AXI_LITE, 11, 1)
    FIELD(CE_INT_MISSION_IMR, PL_AXI2, 10, 1)
    FIELD(CE_INT_MISSION_IMR, PL_AXI1, 9, 1)
    FIELD(CE_INT_MISSION_IMR, PL_AXI0, 8, 1)
    FIELD(CE_INT_MISSION_IMR, BANK3_APB, 7, 1)
    FIELD(CE_INT_MISSION_IMR, BANK3_AXI, 6, 1)
    FIELD(CE_INT_MISSION_IMR, BANK2_APB, 5, 1)
    FIELD(CE_INT_MISSION_IMR, BANK2_AXI, 4, 1)
    FIELD(CE_INT_MISSION_IMR, BANK1_APB, 3, 1)
    FIELD(CE_INT_MISSION_IMR, BANK1_AXI, 2, 1)
    FIELD(CE_INT_MISSION_IMR, BANK0_APB, 1, 1)
    FIELD(CE_INT_MISSION_IMR, BANK0_AXI, 0, 1)
REG32(CE_INT_MISSION_IER, 0xa1ac)
    FIELD(CE_INT_MISSION_IER, XRAM_PWR, 15, 1)
    FIELD(CE_INT_MISSION_IER, SLCR_APB, 14, 1)
    FIELD(CE_INT_MISSION_IER, PS_APB, 13, 1)
    FIELD(CE_INT_MISSION_IER, PS_AXI, 12, 1)
    FIELD(CE_INT_MISSION_IER, PL_AXI_LITE, 11, 1)
    FIELD(CE_INT_MISSION_IER, PL_AXI2, 10, 1)
    FIELD(CE_INT_MISSION_IER, PL_AXI1, 9, 1)
    FIELD(CE_INT_MISSION_IER, PL_AXI0, 8, 1)
    FIELD(CE_INT_MISSION_IER, BANK3_APB, 7, 1)
    FIELD(CE_INT_MISSION_IER, BANK3_AXI, 6, 1)
    FIELD(CE_INT_MISSION_IER, BANK2_APB, 5, 1)
    FIELD(CE_INT_MISSION_IER, BANK2_AXI, 4, 1)
    FIELD(CE_INT_MISSION_IER, BANK1_APB, 3, 1)
    FIELD(CE_INT_MISSION_IER, BANK1_AXI, 2, 1)
    FIELD(CE_INT_MISSION_IER, BANK0_APB, 1, 1)
    FIELD(CE_INT_MISSION_IER, BANK0_AXI, 0, 1)
REG32(CE_INT_MISSION_IDR, 0xa1b0)
    FIELD(CE_INT_MISSION_IDR, XRAM_PWR, 15, 1)
    FIELD(CE_INT_MISSION_IDR, SLCR_APB, 14, 1)
    FIELD(CE_INT_MISSION_IDR, PS_APB, 13, 1)
    FIELD(CE_INT_MISSION_IDR, PS_AXI, 12, 1)
    FIELD(CE_INT_MISSION_IDR, PL_AXI_LITE, 11, 1)
    FIELD(CE_INT_MISSION_IDR, PL_AXI2, 10, 1)
    FIELD(CE_INT_MISSION_IDR, PL_AXI1, 9, 1)
    FIELD(CE_INT_MISSION_IDR, PL_AXI0, 8, 1)
    FIELD(CE_INT_MISSION_IDR, BANK3_APB, 7, 1)
    FIELD(CE_INT_MISSION_IDR, BANK3_AXI, 6, 1)
    FIELD(CE_INT_MISSION_IDR, BANK2_APB, 5, 1)
    FIELD(CE_INT_MISSION_IDR, BANK2_AXI, 4, 1)
    FIELD(CE_INT_MISSION_IDR, BANK1_APB, 3, 1)
    FIELD(CE_INT_MISSION_IDR, BANK1_AXI, 2, 1)
    FIELD(CE_INT_MISSION_IDR, BANK0_APB, 1, 1)
    FIELD(CE_INT_MISSION_IDR, BANK0_AXI, 0, 1)
REG32(UCE_INT_MISSION_IMR, 0xa1b4)
    FIELD(UCE_INT_MISSION_IMR, XRAM_PWR, 15, 1)
    FIELD(UCE_INT_MISSION_IMR, SLCR_APB, 14, 1)
    FIELD(UCE_INT_MISSION_IMR, PS_APB, 13, 1)
    FIELD(UCE_INT_MISSION_IMR, PS_AXI, 12, 1)
    FIELD(UCE_INT_MISSION_IMR, PL_AXI_LITE, 11, 1)
    FIELD(UCE_INT_MISSION_IMR, PL_AXI2, 10, 1)
    FIELD(UCE_INT_MISSION_IMR, PL_AXI1, 9, 1)
    FIELD(UCE_INT_MISSION_IMR, PL_AXI0, 8, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK3_APB, 7, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK2_APB, 5, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK1_APB, 3, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK0_APB, 1, 1)
    FIELD(UCE_INT_MISSION_IMR, BANK0_AXI, 0, 1)
REG32(UCE_INT_MISSION_IER, 0xa1b8)
    FIELD(UCE_INT_MISSION_IER, XRAM_PWR, 15, 1)
    FIELD(UCE_INT_MISSION_IER, SLCR_APB, 14, 1)
    FIELD(UCE_INT_MISSION_IER, PS_APB, 13, 1)
    FIELD(UCE_INT_MISSION_IER, PS_AXI, 12, 1)
    FIELD(UCE_INT_MISSION_IER, PL_AXI_LITE, 11, 1)
    FIELD(UCE_INT_MISSION_IER, PL_AXI2, 10, 1)
    FIELD(UCE_INT_MISSION_IER, PL_AXI1, 9, 1)
    FIELD(UCE_INT_MISSION_IER, PL_AXI0, 8, 1)
    FIELD(UCE_INT_MISSION_IER, BANK3_APB, 7, 1)
    FIELD(UCE_INT_MISSION_IER, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_MISSION_IER, BANK2_APB, 5, 1)
    FIELD(UCE_INT_MISSION_IER, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_MISSION_IER, BANK1_APB, 3, 1)
    FIELD(UCE_INT_MISSION_IER, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_MISSION_IER, BANK0_APB, 1, 1)
    FIELD(UCE_INT_MISSION_IER, BANK0_AXI, 0, 1)
REG32(UCE_INT_MISSION_IDR, 0xa1bc)
    FIELD(UCE_INT_MISSION_IDR, XRAM_PWR, 15, 1)
    FIELD(UCE_INT_MISSION_IDR, SLCR_APB, 14, 1)
    FIELD(UCE_INT_MISSION_IDR, PS_APB, 13, 1)
    FIELD(UCE_INT_MISSION_IDR, PS_AXI, 12, 1)
    FIELD(UCE_INT_MISSION_IDR, PL_AXI_LITE, 11, 1)
    FIELD(UCE_INT_MISSION_IDR, PL_AXI2, 10, 1)
    FIELD(UCE_INT_MISSION_IDR, PL_AXI1, 9, 1)
    FIELD(UCE_INT_MISSION_IDR, PL_AXI0, 8, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK3_APB, 7, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK2_APB, 5, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK1_APB, 3, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK0_APB, 1, 1)
    FIELD(UCE_INT_MISSION_IDR, BANK0_AXI, 0, 1)
REG32(INT_LATENT_ISR, 0xa1c0)
    FIELD(INT_LATENT_ISR, XRAM_PWR, 15, 1)
    FIELD(INT_LATENT_ISR, SLCR_APB, 14, 1)
    FIELD(INT_LATENT_ISR, PS_APB, 13, 1)
    FIELD(INT_LATENT_ISR, PS_AXI, 12, 1)
    FIELD(INT_LATENT_ISR, PL_AXI_LITE, 11, 1)
    FIELD(INT_LATENT_ISR, PL_AXI2, 10, 1)
    FIELD(INT_LATENT_ISR, PL_AXI1, 9, 1)
    FIELD(INT_LATENT_ISR, PL_AXI0, 8, 1)
    FIELD(INT_LATENT_ISR, BANK3_APB, 7, 1)
    FIELD(INT_LATENT_ISR, BANK3_AXI, 6, 1)
    FIELD(INT_LATENT_ISR, BANK2_APB, 5, 1)
    FIELD(INT_LATENT_ISR, BANK2_AXI, 4, 1)
    FIELD(INT_LATENT_ISR, BANK1_APB, 3, 1)
    FIELD(INT_LATENT_ISR, BANK1_AXI, 2, 1)
    FIELD(INT_LATENT_ISR, BANK0_APB, 1, 1)
    FIELD(INT_LATENT_ISR, BANK0_AXI, 0, 1)
REG32(INT_LATENT_ITR, 0xa1c4)
    FIELD(INT_LATENT_ITR, XRAM_PWR, 15, 1)
    FIELD(INT_LATENT_ITR, SLCR_APB, 14, 1)
    FIELD(INT_LATENT_ITR, PS_APB, 13, 1)
    FIELD(INT_LATENT_ITR, PS_AXI, 12, 1)
    FIELD(INT_LATENT_ITR, PL_AXI_LITE, 11, 1)
    FIELD(INT_LATENT_ITR, PL_AXI2, 10, 1)
    FIELD(INT_LATENT_ITR, PL_AXI1, 9, 1)
    FIELD(INT_LATENT_ITR, PL_AXI0, 8, 1)
    FIELD(INT_LATENT_ITR, BANK3_APB, 7, 1)
    FIELD(INT_LATENT_ITR, BANK3_AXI, 6, 1)
    FIELD(INT_LATENT_ITR, BANK2_APB, 5, 1)
    FIELD(INT_LATENT_ITR, BANK2_AXI, 4, 1)
    FIELD(INT_LATENT_ITR, BANK1_APB, 3, 1)
    FIELD(INT_LATENT_ITR, BANK1_AXI, 2, 1)
    FIELD(INT_LATENT_ITR, BANK0_APB, 1, 1)
    FIELD(INT_LATENT_ITR, BANK0_AXI, 0, 1)
REG32(CE_INT_LATENT_IMR, 0xa1c8)
    FIELD(CE_INT_LATENT_IMR, XRAM_PWR, 15, 1)
    FIELD(CE_INT_LATENT_IMR, SLCR_APB, 14, 1)
    FIELD(CE_INT_LATENT_IMR, PS_APB, 13, 1)
    FIELD(CE_INT_LATENT_IMR, PS_AXI, 12, 1)
    FIELD(CE_INT_LATENT_IMR, PL_AXI_LITE, 11, 1)
    FIELD(CE_INT_LATENT_IMR, PL_AXI2, 10, 1)
    FIELD(CE_INT_LATENT_IMR, PL_AXI1, 9, 1)
    FIELD(CE_INT_LATENT_IMR, PL_AXI0, 8, 1)
    FIELD(CE_INT_LATENT_IMR, BANK3_APB, 7, 1)
    FIELD(CE_INT_LATENT_IMR, BANK3_AXI, 6, 1)
    FIELD(CE_INT_LATENT_IMR, BANK2_APB, 5, 1)
    FIELD(CE_INT_LATENT_IMR, BANK2_AXI, 4, 1)
    FIELD(CE_INT_LATENT_IMR, BANK1_APB, 3, 1)
    FIELD(CE_INT_LATENT_IMR, BANK1_AXI, 2, 1)
    FIELD(CE_INT_LATENT_IMR, BANK0_APB, 1, 1)
    FIELD(CE_INT_LATENT_IMR, BANK0_AXI, 0, 1)
REG32(CE_INT_LATENT_IER, 0xa1cc)
    FIELD(CE_INT_LATENT_IER, XRAM_PWR, 15, 1)
    FIELD(CE_INT_LATENT_IER, SLCR_APB, 14, 1)
    FIELD(CE_INT_LATENT_IER, PS_APB, 13, 1)
    FIELD(CE_INT_LATENT_IER, PS_AXI, 12, 1)
    FIELD(CE_INT_LATENT_IER, PL_AXI_LITE, 11, 1)
    FIELD(CE_INT_LATENT_IER, PL_AXI2, 10, 1)
    FIELD(CE_INT_LATENT_IER, PL_AXI1, 9, 1)
    FIELD(CE_INT_LATENT_IER, PL_AXI0, 8, 1)
    FIELD(CE_INT_LATENT_IER, BANK3_APB, 7, 1)
    FIELD(CE_INT_LATENT_IER, BANK3_AXI, 6, 1)
    FIELD(CE_INT_LATENT_IER, BANK2_APB, 5, 1)
    FIELD(CE_INT_LATENT_IER, BANK2_AXI, 4, 1)
    FIELD(CE_INT_LATENT_IER, BANK1_APB, 3, 1)
    FIELD(CE_INT_LATENT_IER, BANK1_AXI, 2, 1)
    FIELD(CE_INT_LATENT_IER, BANK0_APB, 1, 1)
    FIELD(CE_INT_LATENT_IER, BANK0_AXI, 0, 1)
REG32(CE_INT_LATENT_IDR, 0xa1d0)
    FIELD(CE_INT_LATENT_IDR, XRAM_PWR, 15, 1)
    FIELD(CE_INT_LATENT_IDR, SLCR_APB, 14, 1)
    FIELD(CE_INT_LATENT_IDR, PS_APB, 13, 1)
    FIELD(CE_INT_LATENT_IDR, PS_AXI, 12, 1)
    FIELD(CE_INT_LATENT_IDR, PL_AXI_LITE, 11, 1)
    FIELD(CE_INT_LATENT_IDR, PL_AXI2, 10, 1)
    FIELD(CE_INT_LATENT_IDR, PL_AXI1, 9, 1)
    FIELD(CE_INT_LATENT_IDR, PL_AXI0, 8, 1)
    FIELD(CE_INT_LATENT_IDR, BANK3_APB, 7, 1)
    FIELD(CE_INT_LATENT_IDR, BANK3_AXI, 6, 1)
    FIELD(CE_INT_LATENT_IDR, BANK2_APB, 5, 1)
    FIELD(CE_INT_LATENT_IDR, BANK2_AXI, 4, 1)
    FIELD(CE_INT_LATENT_IDR, BANK1_APB, 3, 1)
    FIELD(CE_INT_LATENT_IDR, BANK1_AXI, 2, 1)
    FIELD(CE_INT_LATENT_IDR, BANK0_APB, 1, 1)
    FIELD(CE_INT_LATENT_IDR, BANK0_AXI, 0, 1)
REG32(UCE_INT_LATENT_IMR, 0xa1d4)
    FIELD(UCE_INT_LATENT_IMR, XRAM_PWR, 15, 1)
    FIELD(UCE_INT_LATENT_IMR, SLCR_APB, 14, 1)
    FIELD(UCE_INT_LATENT_IMR, PS_APB, 13, 1)
    FIELD(UCE_INT_LATENT_IMR, PS_AXI, 12, 1)
    FIELD(UCE_INT_LATENT_IMR, PL_AXI_LITE, 11, 1)
    FIELD(UCE_INT_LATENT_IMR, PL_AXI2, 10, 1)
    FIELD(UCE_INT_LATENT_IMR, PL_AXI1, 9, 1)
    FIELD(UCE_INT_LATENT_IMR, PL_AXI0, 8, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK3_APB, 7, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK2_APB, 5, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK1_APB, 3, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK0_APB, 1, 1)
    FIELD(UCE_INT_LATENT_IMR, BANK0_AXI, 0, 1)
REG32(UCE_INT_LATENT_IER, 0xa1d8)
    FIELD(UCE_INT_LATENT_IER, XRAM_PWR, 15, 1)
    FIELD(UCE_INT_LATENT_IER, SLCR_APB, 14, 1)
    FIELD(UCE_INT_LATENT_IER, PS_APB, 13, 1)
    FIELD(UCE_INT_LATENT_IER, PS_AXI, 12, 1)
    FIELD(UCE_INT_LATENT_IER, PL_AXI_LITE, 11, 1)
    FIELD(UCE_INT_LATENT_IER, PL_AXI2, 10, 1)
    FIELD(UCE_INT_LATENT_IER, PL_AXI1, 9, 1)
    FIELD(UCE_INT_LATENT_IER, PL_AXI0, 8, 1)
    FIELD(UCE_INT_LATENT_IER, BANK3_APB, 7, 1)
    FIELD(UCE_INT_LATENT_IER, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_LATENT_IER, BANK2_APB, 5, 1)
    FIELD(UCE_INT_LATENT_IER, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_LATENT_IER, BANK1_APB, 3, 1)
    FIELD(UCE_INT_LATENT_IER, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_LATENT_IER, BANK0_APB, 1, 1)
    FIELD(UCE_INT_LATENT_IER, BANK0_AXI, 0, 1)
REG32(UCE_INT_LATENT_IDR, 0xa1dc)
    FIELD(UCE_INT_LATENT_IDR, XRAM_PWR, 15, 1)
    FIELD(UCE_INT_LATENT_IDR, SLCR_APB, 14, 1)
    FIELD(UCE_INT_LATENT_IDR, PS_APB, 13, 1)
    FIELD(UCE_INT_LATENT_IDR, PS_AXI, 12, 1)
    FIELD(UCE_INT_LATENT_IDR, PL_AXI_LITE, 11, 1)
    FIELD(UCE_INT_LATENT_IDR, PL_AXI2, 10, 1)
    FIELD(UCE_INT_LATENT_IDR, PL_AXI1, 9, 1)
    FIELD(UCE_INT_LATENT_IDR, PL_AXI0, 8, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK3_APB, 7, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK3_AXI, 6, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK2_APB, 5, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK2_AXI, 4, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK1_APB, 3, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK1_AXI, 2, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK0_APB, 1, 1)
    FIELD(UCE_INT_LATENT_IDR, BANK0_AXI, 0, 1)
REG32(INT_PARITY_ISR, 0xa1e0)
    FIELD(INT_PARITY_ISR, SLCR_APB_WDATA, 18, 1)
    FIELD(INT_PARITY_ISR, PS_APB_RDATA, 17, 1)
    FIELD(INT_PARITY_ISR, PS_AXI_RDATA, 16, 1)
    FIELD(INT_PARITY_ISR, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(INT_PARITY_ISR, PL_AXI2_RDATA, 14, 1)
    FIELD(INT_PARITY_ISR, PL_AXI1_RDATA, 13, 1)
    FIELD(INT_PARITY_ISR, PL_AXI0_RDATA, 12, 1)
    FIELD(INT_PARITY_ISR, BANK3_XMPU_WDATA, 11, 1)
    FIELD(INT_PARITY_ISR, BANK3_APB_WDATA, 10, 1)
    FIELD(INT_PARITY_ISR, BANK3_AXI_WDATA, 9, 1)
    FIELD(INT_PARITY_ISR, BANK2_XMPU_WDATA, 8, 1)
    FIELD(INT_PARITY_ISR, BANK2_APB_WDATA, 7, 1)
    FIELD(INT_PARITY_ISR, BANK2_AXI_WDATA, 6, 1)
    FIELD(INT_PARITY_ISR, BANK1_XMPU_WDATA, 5, 1)
    FIELD(INT_PARITY_ISR, BANK1_APB_WDATA, 4, 1)
    FIELD(INT_PARITY_ISR, BANK1_AXI_WDATA, 3, 1)
    FIELD(INT_PARITY_ISR, BANK0_XMPU_WDATA, 2, 1)
    FIELD(INT_PARITY_ISR, BANK0_APB_WDATA, 1, 1)
    FIELD(INT_PARITY_ISR, BANK0_AXI_WDATA, 0, 1)
REG32(INT_PARITY_ITR, 0xa1e4)
    FIELD(INT_PARITY_ITR, SLCR_APB_WDATA, 18, 1)
    FIELD(INT_PARITY_ITR, PS_APB_RDATA, 17, 1)
    FIELD(INT_PARITY_ITR, PS_AXI_RDATA, 16, 1)
    FIELD(INT_PARITY_ITR, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(INT_PARITY_ITR, PL_AXI2_RDATA, 14, 1)
    FIELD(INT_PARITY_ITR, PL_AXI1_RDATA, 13, 1)
    FIELD(INT_PARITY_ITR, PL_AXI0_RDATA, 12, 1)
    FIELD(INT_PARITY_ITR, BANK3_XMPU_WDATA, 11, 1)
    FIELD(INT_PARITY_ITR, BANK3_APB_WDATA, 10, 1)
    FIELD(INT_PARITY_ITR, BANK3_AXI_WDATA, 9, 1)
    FIELD(INT_PARITY_ITR, BANK2_XMPU_WDATA, 8, 1)
    FIELD(INT_PARITY_ITR, BANK2_APB_WDATA, 7, 1)
    FIELD(INT_PARITY_ITR, BANK2_AXI_WDATA, 6, 1)
    FIELD(INT_PARITY_ITR, BANK1_XMPU_WDATA, 5, 1)
    FIELD(INT_PARITY_ITR, BANK1_APB_WDATA, 4, 1)
    FIELD(INT_PARITY_ITR, BANK1_AXI_WDATA, 3, 1)
    FIELD(INT_PARITY_ITR, BANK0_XMPU_WDATA, 2, 1)
    FIELD(INT_PARITY_ITR, BANK0_APB_WDATA, 1, 1)
    FIELD(INT_PARITY_ITR, BANK0_AXI_WDATA, 0, 1)
REG32(CE_INT_PARITY_IMR, 0xa1e8)
    FIELD(CE_INT_PARITY_IMR, SLCR_APB_WDATA, 18, 1)
    FIELD(CE_INT_PARITY_IMR, PS_APB_RDATA, 17, 1)
    FIELD(CE_INT_PARITY_IMR, PS_AXI_RDATA, 16, 1)
    FIELD(CE_INT_PARITY_IMR, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(CE_INT_PARITY_IMR, PL_AXI2_RDATA, 14, 1)
    FIELD(CE_INT_PARITY_IMR, PL_AXI1_RDATA, 13, 1)
    FIELD(CE_INT_PARITY_IMR, PL_AXI0_RDATA, 12, 1)
    FIELD(CE_INT_PARITY_IMR, BANK3_XMPU_WDATA, 11, 1)
    FIELD(CE_INT_PARITY_IMR, BANK3_APB_WDATA, 10, 1)
    FIELD(CE_INT_PARITY_IMR, BANK3_AXI_WDATA, 9, 1)
    FIELD(CE_INT_PARITY_IMR, BANK2_XMPU_WDATA, 8, 1)
    FIELD(CE_INT_PARITY_IMR, BANK2_APB_WDATA, 7, 1)
    FIELD(CE_INT_PARITY_IMR, BANK2_AXI_WDATA, 6, 1)
    FIELD(CE_INT_PARITY_IMR, BANK1_XMPU_WDATA, 5, 1)
    FIELD(CE_INT_PARITY_IMR, BANK1_APB_WDATA, 4, 1)
    FIELD(CE_INT_PARITY_IMR, BANK1_AXI_WDATA, 3, 1)
    FIELD(CE_INT_PARITY_IMR, BANK0_XMPU_WDATA, 2, 1)
    FIELD(CE_INT_PARITY_IMR, BANK0_APB_WDATA, 1, 1)
    FIELD(CE_INT_PARITY_IMR, BANK0_AXI_WDATA, 0, 1)
REG32(CE_INT_PARITY_IER, 0xa1ec)
    FIELD(CE_INT_PARITY_IER, SLCR_APB_WDATA, 18, 1)
    FIELD(CE_INT_PARITY_IER, PS_APB_RDATA, 17, 1)
    FIELD(CE_INT_PARITY_IER, PS_AXI_RDATA, 16, 1)
    FIELD(CE_INT_PARITY_IER, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(CE_INT_PARITY_IER, PL_AXI2_RDATA, 14, 1)
    FIELD(CE_INT_PARITY_IER, PL_AXI1_RDATA, 13, 1)
    FIELD(CE_INT_PARITY_IER, PL_AXI0_RDATA, 12, 1)
    FIELD(CE_INT_PARITY_IER, BANK3_XMPU_WDATA, 11, 1)
    FIELD(CE_INT_PARITY_IER, BANK3_APB_WDATA, 10, 1)
    FIELD(CE_INT_PARITY_IER, BANK3_AXI_WDATA, 9, 1)
    FIELD(CE_INT_PARITY_IER, BANK2_XMPU_WDATA, 8, 1)
    FIELD(CE_INT_PARITY_IER, BANK2_APB_WDATA, 7, 1)
    FIELD(CE_INT_PARITY_IER, BANK2_AXI_WDATA, 6, 1)
    FIELD(CE_INT_PARITY_IER, BANK1_XMPU_WDATA, 5, 1)
    FIELD(CE_INT_PARITY_IER, BANK1_APB_WDATA, 4, 1)
    FIELD(CE_INT_PARITY_IER, BANK1_AXI_WDATA, 3, 1)
    FIELD(CE_INT_PARITY_IER, BANK0_XMPU_WDATA, 2, 1)
    FIELD(CE_INT_PARITY_IER, BANK0_APB_WDATA, 1, 1)
    FIELD(CE_INT_PARITY_IER, BANK0_AXI_WDATA, 0, 1)
REG32(CE_INT_PARITY_IDR, 0xa1f0)
    FIELD(CE_INT_PARITY_IDR, SLCR_APB_WDATA, 18, 1)
    FIELD(CE_INT_PARITY_IDR, PS_APB_RDATA, 17, 1)
    FIELD(CE_INT_PARITY_IDR, PS_AXI_RDATA, 16, 1)
    FIELD(CE_INT_PARITY_IDR, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(CE_INT_PARITY_IDR, PL_AXI2_RDATA, 14, 1)
    FIELD(CE_INT_PARITY_IDR, PL_AXI1_RDATA, 13, 1)
    FIELD(CE_INT_PARITY_IDR, PL_AXI0_RDATA, 12, 1)
    FIELD(CE_INT_PARITY_IDR, BANK3_XMPU_WDATA, 11, 1)
    FIELD(CE_INT_PARITY_IDR, BANK3_APB_WDATA, 10, 1)
    FIELD(CE_INT_PARITY_IDR, BANK3_AXI_WDATA, 9, 1)
    FIELD(CE_INT_PARITY_IDR, BANK2_XMPU_WDATA, 8, 1)
    FIELD(CE_INT_PARITY_IDR, BANK2_APB_WDATA, 7, 1)
    FIELD(CE_INT_PARITY_IDR, BANK2_AXI_WDATA, 6, 1)
    FIELD(CE_INT_PARITY_IDR, BANK1_XMPU_WDATA, 5, 1)
    FIELD(CE_INT_PARITY_IDR, BANK1_APB_WDATA, 4, 1)
    FIELD(CE_INT_PARITY_IDR, BANK1_AXI_WDATA, 3, 1)
    FIELD(CE_INT_PARITY_IDR, BANK0_XMPU_WDATA, 2, 1)
    FIELD(CE_INT_PARITY_IDR, BANK0_APB_WDATA, 1, 1)
    FIELD(CE_INT_PARITY_IDR, BANK0_AXI_WDATA, 0, 1)
REG32(UCE_INT_PARITY_IMR, 0xa1f4)
    FIELD(UCE_INT_PARITY_IMR, SLCR_APB_WDATA, 18, 1)
    FIELD(UCE_INT_PARITY_IMR, PS_APB_RDATA, 17, 1)
    FIELD(UCE_INT_PARITY_IMR, PS_AXI_RDATA, 16, 1)
    FIELD(UCE_INT_PARITY_IMR, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(UCE_INT_PARITY_IMR, PL_AXI2_RDATA, 14, 1)
    FIELD(UCE_INT_PARITY_IMR, PL_AXI1_RDATA, 13, 1)
    FIELD(UCE_INT_PARITY_IMR, PL_AXI0_RDATA, 12, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK3_XMPU_WDATA, 11, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK3_APB_WDATA, 10, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK3_AXI_WDATA, 9, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK2_XMPU_WDATA, 8, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK2_APB_WDATA, 7, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK2_AXI_WDATA, 6, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK1_XMPU_WDATA, 5, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK1_APB_WDATA, 4, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK1_AXI_WDATA, 3, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK0_XMPU_WDATA, 2, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK0_APB_WDATA, 1, 1)
    FIELD(UCE_INT_PARITY_IMR, BANK0_AXI_WDATA, 0, 1)
REG32(UCE_INT_PARITY_IER, 0xa1f8)
    FIELD(UCE_INT_PARITY_IER, SLCR_APB_WDATA, 18, 1)
    FIELD(UCE_INT_PARITY_IER, PS_APB_RDATA, 17, 1)
    FIELD(UCE_INT_PARITY_IER, PS_AXI_RDATA, 16, 1)
    FIELD(UCE_INT_PARITY_IER, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(UCE_INT_PARITY_IER, PL_AXI2_RDATA, 14, 1)
    FIELD(UCE_INT_PARITY_IER, PL_AXI1_RDATA, 13, 1)
    FIELD(UCE_INT_PARITY_IER, PL_AXI0_RDATA, 12, 1)
    FIELD(UCE_INT_PARITY_IER, BANK3_XMPU_WDATA, 11, 1)
    FIELD(UCE_INT_PARITY_IER, BANK3_APB_WDATA, 10, 1)
    FIELD(UCE_INT_PARITY_IER, BANK3_AXI_WDATA, 9, 1)
    FIELD(UCE_INT_PARITY_IER, BANK2_XMPU_WDATA, 8, 1)
    FIELD(UCE_INT_PARITY_IER, BANK2_APB_WDATA, 7, 1)
    FIELD(UCE_INT_PARITY_IER, BANK2_AXI_WDATA, 6, 1)
    FIELD(UCE_INT_PARITY_IER, BANK1_XMPU_WDATA, 5, 1)
    FIELD(UCE_INT_PARITY_IER, BANK1_APB_WDATA, 4, 1)
    FIELD(UCE_INT_PARITY_IER, BANK1_AXI_WDATA, 3, 1)
    FIELD(UCE_INT_PARITY_IER, BANK0_XMPU_WDATA, 2, 1)
    FIELD(UCE_INT_PARITY_IER, BANK0_APB_WDATA, 1, 1)
    FIELD(UCE_INT_PARITY_IER, BANK0_AXI_WDATA, 0, 1)
REG32(UCE_INT_PARITY_IDR, 0xa1fc)
    FIELD(UCE_INT_PARITY_IDR, SLCR_APB_WDATA, 18, 1)
    FIELD(UCE_INT_PARITY_IDR, PS_APB_RDATA, 17, 1)
    FIELD(UCE_INT_PARITY_IDR, PS_AXI_RDATA, 16, 1)
    FIELD(UCE_INT_PARITY_IDR, PL_AXI_LITE_RDATA, 15, 1)
    FIELD(UCE_INT_PARITY_IDR, PL_AXI2_RDATA, 14, 1)
    FIELD(UCE_INT_PARITY_IDR, PL_AXI1_RDATA, 13, 1)
    FIELD(UCE_INT_PARITY_IDR, PL_AXI0_RDATA, 12, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK3_XMPU_WDATA, 11, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK3_APB_WDATA, 10, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK3_AXI_WDATA, 9, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK2_XMPU_WDATA, 8, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK2_APB_WDATA, 7, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK2_AXI_WDATA, 6, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK1_XMPU_WDATA, 5, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK1_APB_WDATA, 4, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK1_AXI_WDATA, 3, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK0_XMPU_WDATA, 2, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK0_APB_WDATA, 1, 1)
    FIELD(UCE_INT_PARITY_IDR, BANK0_AXI_WDATA, 0, 1)

#define XRAM_SLCR_R_MAX (R_UCE_INT_PARITY_IDR + 1)

typedef struct XRAM_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[XRAM_SLCR_R_MAX];
    RegisterInfo regs_info[XRAM_SLCR_R_MAX];
} XRAM_SLCR;

static void pwr_up_bank_x(RegisterInfo *reg, uint64_t val)
{
    XRAM_SLCR *s = XILINX_XRAM_SLCR(reg->opaque);

    switch (reg->access->addr) {
    case A_PWR_UP_BANK0:
        s->regs[R_PWR_STATUS_BANK0] |= val;
        break;
    case A_PWR_UP_BANK1:
        s->regs[R_PWR_STATUS_BANK1] |= val;
        break;
    case A_PWR_UP_BANK2:
        s->regs[R_PWR_STATUS_BANK2] |= val;
        break;
    case A_PWR_UP_BANK3:
        s->regs[R_PWR_STATUS_BANK3] |= val;
        break;
    };
}

static void pwr_down_bank_x(RegisterInfo *reg, uint64_t val)
{
    XRAM_SLCR *s = XILINX_XRAM_SLCR(reg->opaque);

    switch (reg->access->addr) {
    case A_PWR_DOWN_BANK0:
        s->regs[R_PWR_STATUS_BANK0] &= ~val;
        s->regs[R_PWR_STATUS_BANK0] &= 0xF;
        break;
    case A_PWR_DOWN_BANK1:
        s->regs[R_PWR_STATUS_BANK1] &= ~val;
        s->regs[R_PWR_STATUS_BANK1] &= 0xF;
        break;
    case A_PWR_DOWN_BANK2:
        s->regs[R_PWR_STATUS_BANK2] &= ~val;
        s->regs[R_PWR_STATUS_BANK2] &= 0xF;
        break;
    case A_PWR_DOWN_BANK3:
        s->regs[R_PWR_STATUS_BANK3] &= ~val;
        s->regs[R_PWR_STATUS_BANK3] &= 0xF;
        break;
    };
}

static const RegisterAccessInfo xram_slcr_regs_info[] = {
    {   .name = "PCSR_MASK",  .addr = A_PCSR_MASK,
    },{ .name = "PCSR_PCR",  .addr = A_PCSR_PCR,
        .reset = 0x3c,
    },{ .name = "PCSR_PSR",  .addr = A_PCSR_PSR,
        .reset = 0x10001 |
                 R_PCSR_PSR_SCAN_CLEAR_DONE_MASK |
                 R_PCSR_PSR_SCAN_CLEAR_PASS_MASK |
                 R_PCSR_PSR_CALDONE_MASK |
                 R_PCSR_PSR_MEM_CLEAR_DONE_0_MASK |
                 R_PCSR_PSR_MEM_CLEAR_PASS_0_MASK |
                 R_PCSR_PSR_BISR_DONE_MASK |
                 R_PCSR_PSR_BISR_PASS_MASK |
                 R_PCSR_PSR_MEM_CLEAR_DONE_3_TO_1_MASK |
                 R_PCSR_PSR_MEM_CLEAR_PASS_3_TO_1_MASK,
        .rsvd = 0xff800000,
        .ro = 0xffffffff,
    },{ .name = "PCSR_LOCK",  .addr = A_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "MAIN_CLK",  .addr = A_MAIN_CLK,
    },{ .name = "APB_CLK",  .addr = A_APB_CLK,
    },{ .name = "RST",  .addr = A_RST,
    },{ .name = "PWR_UP_BANK0",  .addr = A_PWR_UP_BANK0,
        .post_write = pwr_up_bank_x,
    },{ .name = "PWR_DOWN_BANK0",  .addr = A_PWR_DOWN_BANK0,
        .post_write = pwr_down_bank_x,
    },{ .name = "PWR_STATUS_BANK0",  .addr = A_PWR_STATUS_BANK0,
        .ro = 0xf,
    },{ .name = "PWR_UP_BANK1",  .addr = A_PWR_UP_BANK1,
        .post_write = pwr_up_bank_x,
    },{ .name = "PWR_DOWN_BANK1",  .addr = A_PWR_DOWN_BANK1,
        .post_write = pwr_down_bank_x,
    },{ .name = "PWR_STATUS_BANK1",  .addr = A_PWR_STATUS_BANK1,
        .ro = 0xf,
    },{ .name = "PWR_UP_BANK2",  .addr = A_PWR_UP_BANK2,
        .post_write = pwr_up_bank_x,
    },{ .name = "PWR_DOWN_BANK2",  .addr = A_PWR_DOWN_BANK2,
        .post_write = pwr_down_bank_x,
    },{ .name = "PWR_STATUS_BANK2",  .addr = A_PWR_STATUS_BANK2,
        .ro = 0xf,
    },{ .name = "PWR_UP_BANK3",  .addr = A_PWR_UP_BANK3,
        .post_write = pwr_up_bank_x,
    },{ .name = "PWR_DOWN_BANK3",  .addr = A_PWR_DOWN_BANK3,
        .post_write = pwr_down_bank_x,
    },{ .name = "PWR_STATUS_BANK3",  .addr = A_PWR_STATUS_BANK3,
        .ro = 0xf,
    },{ .name = "RETENTION_ENTER_BANK0",  .addr = A_RETENTION_ENTER_BANK0,
    },{ .name = "RETENTION_STATUS_BANK0",  .addr = A_RETENTION_STATUS_BANK0,
        .ro = 0xf,
    },{ .name = "RETENTION_ENTER_BANK1",  .addr = A_RETENTION_ENTER_BANK1,
    },{ .name = "RETENTION_STATUS_BANK1",  .addr = A_RETENTION_STATUS_BANK1,
        .ro = 0xf,
    },{ .name = "RETENTION_ENTER_BANK2",  .addr = A_RETENTION_ENTER_BANK2,
    },{ .name = "RETENTION_STATUS_BANK2",  .addr = A_RETENTION_STATUS_BANK2,
        .ro = 0xf,
    },{ .name = "RETENTION_ENTER_BANK3",  .addr = A_RETENTION_ENTER_BANK3,
    },{ .name = "RETENTION_STATUS_BANK3",  .addr = A_RETENTION_STATUS_BANK3,
        .ro = 0xf,
    },{ .name = "SUPPLY_STATUS",  .addr = A_SUPPLY_STATUS,
        .ro = 0x1,
    },{ .name = "XRAM_FM_TZ_CTRL",  .addr = A_XRAM_FM_TZ_CTRL,
        .reset = 0xf,
    },{ .name = "TZ_CTRL",  .addr = A_TZ_CTRL,
        .reset = 0x10f,
    },{ .name = "TZ_CTRL_LOCK",  .addr = A_TZ_CTRL_LOCK,
    },{ .name = "MEM_CLR_UNISON",  .addr = A_MEM_CLR_UNISON,
        .reset = 0x1,
    },{ .name = "XMPU_CFG",  .addr = A_XMPU_CFG,
    },{ .name = "PL_AXI0_CTRL",  .addr = A_PL_AXI0_CTRL,
        .reset = 0x4,
    },{ .name = "PL_AXI0_STATUS",  .addr = A_PL_AXI0_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "PL_AXI1_CTRL",  .addr = A_PL_AXI1_CTRL,
        .reset = 0x4,
    },{ .name = "PL_AXI1_STATUS",  .addr = A_PL_AXI1_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "PL_AXI2_CTRL",  .addr = A_PL_AXI2_CTRL,
        .reset = 0x4,
    },{ .name = "PL_AXI2_STATUS",  .addr = A_PL_AXI2_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "PL_AXI_LITE_CTRL",  .addr = A_PL_AXI_LITE_CTRL,
        .reset = 0x4,
    },{ .name = "PL_AXI_LITE_STATUS",  .addr = A_PL_AXI_LITE_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "PS_AXI_CTRL",  .addr = A_PS_AXI_CTRL,
        .reset = 0x4,
    },{ .name = "PS_AXI_STATUS",  .addr = A_PS_AXI_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "PS_APB_CTRL",  .addr = A_PS_APB_CTRL,
        .reset = 0x4,
    },{ .name = "PS_APB_STATUS",  .addr = A_PS_APB_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK0_AXI_CTRL",  .addr = A_BANK0_AXI_CTRL,
        .reset = 0x4,
    },{ .name = "BANK0_AXI_STATUS",  .addr = A_BANK0_AXI_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK1_AXI_CTRL",  .addr = A_BANK1_AXI_CTRL,
        .reset = 0x4,
    },{ .name = "BANK1_AXI_STATUS",  .addr = A_BANK1_AXI_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK2_AXI_CTRL",  .addr = A_BANK2_AXI_CTRL,
        .reset = 0x4,
    },{ .name = "BANK2_AXI_STATUS",  .addr = A_BANK2_AXI_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK3_AXI_CTRL",  .addr = A_BANK3_AXI_CTRL,
        .reset = 0x4,
    },{ .name = "BANK3_AXI_STATUS",  .addr = A_BANK3_AXI_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK0_APB_CTRL",  .addr = A_BANK0_APB_CTRL,
        .reset = 0x4,
    },{ .name = "BANK0_APB_STATUS",  .addr = A_BANK0_APB_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK1_APB_CTRL",  .addr = A_BANK1_APB_CTRL,
        .reset = 0x4,
    },{ .name = "BANK1_APB_STATUS",  .addr = A_BANK1_APB_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK2_APB_CTRL",  .addr = A_BANK2_APB_CTRL,
        .reset = 0x4,
    },{ .name = "BANK2_APB_STATUS",  .addr = A_BANK2_APB_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "BANK3_APB_CTRL",  .addr = A_BANK3_APB_CTRL,
        .reset = 0x4,
    },{ .name = "BANK3_APB_STATUS",  .addr = A_BANK3_APB_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "SLCR_APB_CTRL",  .addr = A_SLCR_APB_CTRL,
        .reset = 0x4,
    },{ .name = "SLCR_APB_STATUS",  .addr = A_SLCR_APB_STATUS,
        .reset = 0x3,
        .ro = 0x3,
    },{ .name = "XRAM_FM0_AXI_WIDTH",  .addr = A_XRAM_FM0_AXI_WIDTH,
    },{ .name = "XRAM_FM0_ISSUING_CAPACITY",
        .addr = A_XRAM_FM0_ISSUING_CAPACITY,
        .reset = 0x88,
    },{ .name = "XRAM_FM1_AXI_WIDTH",  .addr = A_XRAM_FM1_AXI_WIDTH,
    },{ .name = "XRAM_FM1_ISSUING_CAPACITY",
        .addr = A_XRAM_FM1_ISSUING_CAPACITY,
        .reset = 0x88,
    },{ .name = "XRAM_FM2_AXI_WIDTH",  .addr = A_XRAM_FM2_AXI_WIDTH,
    },{ .name = "XRAM_FM2_ISSUING_CAPACITY",
        .addr = A_XRAM_FM2_ISSUING_CAPACITY,
        .reset = 0x88,
    },{ .name = "SLVERR_ISR",  .addr = A_SLVERR_ISR,
        .w1c = 0x1f,
    },{ .name = "SLVERR_ITR",  .addr = A_SLVERR_ITR,
    },{ .name = "CE_SLVERR_IMR",  .addr = A_CE_SLVERR_IMR,
        .reset = 0x1f,
        .ro = 0x1f,
    },{ .name = "CE_SLVERR_IER",  .addr = A_CE_SLVERR_IER,
    },{ .name = "CE_SLVERR_IDR",  .addr = A_CE_SLVERR_IDR,
    },{ .name = "UCE_SLVERR_IMR",  .addr = A_UCE_SLVERR_IMR,
        .reset = 0x1f,
        .ro = 0x1f,
    },{ .name = "UCE_SLVERR_IER",  .addr = A_UCE_SLVERR_IER,
    },{ .name = "UCE_SLVERR_IDR",  .addr = A_UCE_SLVERR_IDR,
    },{ .name = "BANK_PWR_ISR",  .addr = A_BANK_PWR_ISR,
        .w1c = 0xffff,
    },{ .name = "BANK_PWR_ITR",  .addr = A_BANK_PWR_ITR,
    },{ .name = "CE_BANK_PWR_IMR",  .addr = A_CE_BANK_PWR_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_BANK_PWR_IER",  .addr = A_CE_BANK_PWR_IER,
    },{ .name = "CE_BANK_PWR_IDR",  .addr = A_CE_BANK_PWR_IDR,
    },{ .name = "UCE_BANK_PWR_IMR",  .addr = A_UCE_BANK_PWR_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_BANK_PWR_IER",  .addr = A_UCE_BANK_PWR_IER,
    },{ .name = "UCE_BANK_PWR_IDR",  .addr = A_UCE_BANK_PWR_IDR,
    },{ .name = "BANK_AXI_ISR",  .addr = A_BANK_AXI_ISR,
        .w1c = 0xffff,
    },{ .name = "BANK_AXI_ITR",  .addr = A_BANK_AXI_ITR,
    },{ .name = "CE_BANK_AXI_IMR",  .addr = A_CE_BANK_AXI_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_BANK_AXI_IER",  .addr = A_CE_BANK_AXI_IER,
    },{ .name = "CE_BANK_AXI_IDR",  .addr = A_CE_BANK_AXI_IDR,
    },{ .name = "UCE_BANK_AXI_IMR",  .addr = A_UCE_BANK_AXI_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_BANK_AXI_IER",  .addr = A_UCE_BANK_AXI_IER,
    },{ .name = "UCE_BANK_AXI_IDR",  .addr = A_UCE_BANK_AXI_IDR,
    },{ .name = "BANK_ECC_CE_ISR",  .addr = A_BANK_ECC_CE_ISR,
        .w1c = 0xf,
    },{ .name = "BANK_ECC_CE_ITR",  .addr = A_BANK_ECC_CE_ITR,
    },{ .name = "CE_BANK_ECC_IMR",  .addr = A_CE_BANK_ECC_IMR,
        .reset = 0xf,
        .ro = 0xf,
    },{ .name = "CE_BANK_ECC_IER",  .addr = A_CE_BANK_ECC_IER,
    },{ .name = "CE_BANK_ECC_IDR",  .addr = A_CE_BANK_ECC_IDR,
    },{ .name = "BANK_ECC_UCE_ISR",  .addr = A_BANK_ECC_UCE_ISR,
        .w1c = 0xf,
    },{ .name = "BANK_ECC_UCE_ITR",  .addr = A_BANK_ECC_UCE_ITR,
    },{ .name = "UCE_BANK_ECC_IMR",  .addr = A_UCE_BANK_ECC_IMR,
        .reset = 0xf,
        .ro = 0xf,
    },{ .name = "UCE_BANK_ECC_IER",  .addr = A_UCE_BANK_ECC_IER,
    },{ .name = "UCE_BANK_ECC_IDR",  .addr = A_UCE_BANK_ECC_IDR,
    },{ .name = "BANK_RMW_UCE_ISR",  .addr = A_BANK_RMW_UCE_ISR,
        .w1c = 0xf,
    },{ .name = "BANK_RMW_UCE_ITR",  .addr = A_BANK_RMW_UCE_ITR,
    },{ .name = "UCE_BANK_RMW_IMR",  .addr = A_UCE_BANK_RMW_IMR,
        .reset = 0xf,
        .ro = 0xf,
    },{ .name = "UCE_BANK_RMW_IER",  .addr = A_UCE_BANK_RMW_IER,
    },{ .name = "UCE_BANK_RMW_IDR",  .addr = A_UCE_BANK_RMW_IDR,
    },{ .name = "BANK_PWR_FSM_ISR",  .addr = A_BANK_PWR_FSM_ISR,
        .w1c = 0xffff,
    },{ .name = "BANK_PWR_FSM_ITR",  .addr = A_BANK_PWR_FSM_ITR,
    },{ .name = "CE_BANK_PWR_FSM_IMR",  .addr = A_CE_BANK_PWR_FSM_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_BANK_PWR_FSM_IER",  .addr = A_CE_BANK_PWR_FSM_IER,
    },{ .name = "CE_BANK_PWR_FSM_IDR",  .addr = A_CE_BANK_PWR_FSM_IDR,
    },{ .name = "UCE_BANK_PWR_FSM_IMR",  .addr = A_UCE_BANK_PWR_FSM_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_BANK_PWR_FSM_IER",  .addr = A_UCE_BANK_PWR_FSM_IER,
    },{ .name = "UCE_BANK_PWR_FSM_IDR",  .addr = A_UCE_BANK_PWR_FSM_IDR,
    },{ .name = "INVALID_RET_REQ_ISR",  .addr = A_INVALID_RET_REQ_ISR,
        .w1c = 0xffff,
    },{ .name = "INVALID_RET_REQ_ITR",  .addr = A_INVALID_RET_REQ_ITR,
    },{ .name = "CE_INVALID_RET_REQ_IMR",  .addr = A_CE_INVALID_RET_REQ_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_INVALID_RET_REQ_IER",  .addr = A_CE_INVALID_RET_REQ_IER,
    },{ .name = "CE_INVALID_RET_REQ_IDR",  .addr = A_CE_INVALID_RET_REQ_IDR,
    },{ .name = "UCE_INVALID_RET_REQ_IMR",  .addr = A_UCE_INVALID_RET_REQ_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_INVALID_RET_REQ_IER",  .addr = A_UCE_INVALID_RET_REQ_IER,
    },{ .name = "UCE_INVALID_RET_REQ_IDR",  .addr = A_UCE_INVALID_RET_REQ_IDR,
    },{ .name = "MULTIPLE_PWR_RET_REQ_ISR",  .addr = A_MULTIPLE_PWR_RET_REQ_ISR,
        .w1c = 0xffff,
    },{ .name = "MULTIPLE_PWR_RET_REQ_ITR",  .addr = A_MULTIPLE_PWR_RET_REQ_ITR,
    },{ .name = "CE_MULTIPLE_PWR_RET_REQ_IMR",
        .addr = A_CE_MULTIPLE_PWR_RET_REQ_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_MULTIPLE_PWR_RET_REQ_IER",
        .addr = A_CE_MULTIPLE_PWR_RET_REQ_IER,
    },{ .name = "CE_MULTIPLE_PWR_RET_REQ_IDR",
        .addr = A_CE_MULTIPLE_PWR_RET_REQ_IDR,
    },{ .name = "UCE_MULTIPLE_PWR_RET_REQ_IMR",
        .addr = A_UCE_MULTIPLE_PWR_RET_REQ_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_MULTIPLE_PWR_RET_REQ_IER",
        .addr = A_UCE_MULTIPLE_PWR_RET_REQ_IER,
    },{ .name = "UCE_MULTIPLE_PWR_RET_REQ_IDR",
        .addr = A_UCE_MULTIPLE_PWR_RET_REQ_IDR,
    },{ .name = "INT_XMPU_ISR",  .addr = A_INT_XMPU_ISR,
        .w1c = 0xf,
    },{ .name = "INT_XMPU_ITR",  .addr = A_INT_XMPU_ITR,
    },{ .name = "CE_INT_XMPU_IMR",  .addr = A_CE_INT_XMPU_IMR,
        .reset = 0xf,
        .ro = 0xf,
    },{ .name = "CE_INT_XMPU_IER",  .addr = A_CE_INT_XMPU_IER,
    },{ .name = "CE_INT_XMPU_IDR",  .addr = A_CE_INT_XMPU_IDR,
    },{ .name = "UCE_INT_XMPU_IMR",  .addr = A_UCE_INT_XMPU_IMR,
        .reset = 0xf,
        .ro = 0xf,
    },{ .name = "UCE_INT_XMPU_IER",  .addr = A_UCE_INT_XMPU_IER,
    },{ .name = "UCE_INT_XMPU_IDR",  .addr = A_UCE_INT_XMPU_IDR,
    },{ .name = "INT_TIMEOUT_ISR",  .addr = A_INT_TIMEOUT_ISR,
        .w1c = 0x1ff,
    },{ .name = "INT_TIMEOUT_ITR",  .addr = A_INT_TIMEOUT_ITR,
    },{ .name = "CE_INT_TIMEOUT_IMR",  .addr = A_CE_INT_TIMEOUT_IMR,
        .reset = 0x1ff,
        .ro = 0x1ff,
    },{ .name = "CE_INT_TIMEOUT_IER",  .addr = A_CE_INT_TIMEOUT_IER,
    },{ .name = "CE_INT_TIMEOUT_IDR",  .addr = A_CE_INT_TIMEOUT_IDR,
    },{ .name = "UCE_INT_TIMEOUT_IMR",  .addr = A_UCE_INT_TIMEOUT_IMR,
        .reset = 0x1ff,
        .ro = 0x1ff,
    },{ .name = "UCE_INT_TIMEOUT_IER",  .addr = A_UCE_INT_TIMEOUT_IER,
    },{ .name = "UCE_INT_TIMEOUT_IDR",  .addr = A_UCE_INT_TIMEOUT_IDR,
    },{ .name = "INT_MISSION_ISR",  .addr = A_INT_MISSION_ISR,
        .w1c = 0xffff,
    },{ .name = "INT_MISSION_ITR",  .addr = A_INT_MISSION_ITR,
    },{ .name = "CE_INT_MISSION_IMR",  .addr = A_CE_INT_MISSION_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_INT_MISSION_IER",  .addr = A_CE_INT_MISSION_IER,
    },{ .name = "CE_INT_MISSION_IDR",  .addr = A_CE_INT_MISSION_IDR,
    },{ .name = "UCE_INT_MISSION_IMR",  .addr = A_UCE_INT_MISSION_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_INT_MISSION_IER",  .addr = A_UCE_INT_MISSION_IER,
    },{ .name = "UCE_INT_MISSION_IDR",  .addr = A_UCE_INT_MISSION_IDR,
    },{ .name = "INT_LATENT_ISR",  .addr = A_INT_LATENT_ISR,
        .w1c = 0xffff,
    },{ .name = "INT_LATENT_ITR",  .addr = A_INT_LATENT_ITR,
    },{ .name = "CE_INT_LATENT_IMR",  .addr = A_CE_INT_LATENT_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "CE_INT_LATENT_IER",  .addr = A_CE_INT_LATENT_IER,
    },{ .name = "CE_INT_LATENT_IDR",  .addr = A_CE_INT_LATENT_IDR,
    },{ .name = "UCE_INT_LATENT_IMR",  .addr = A_UCE_INT_LATENT_IMR,
        .reset = 0xffff,
        .ro = 0xffff,
    },{ .name = "UCE_INT_LATENT_IER",  .addr = A_UCE_INT_LATENT_IER,
    },{ .name = "UCE_INT_LATENT_IDR",  .addr = A_UCE_INT_LATENT_IDR,
    },{ .name = "INT_PARITY_ISR",  .addr = A_INT_PARITY_ISR,
        .w1c = 0x7ffff,
    },{ .name = "INT_PARITY_ITR",  .addr = A_INT_PARITY_ITR,
    },{ .name = "CE_INT_PARITY_IMR",  .addr = A_CE_INT_PARITY_IMR,
        .reset = 0x7ffff,
        .ro = 0x7ffff,
    },{ .name = "CE_INT_PARITY_IER",  .addr = A_CE_INT_PARITY_IER,
    },{ .name = "CE_INT_PARITY_IDR",  .addr = A_CE_INT_PARITY_IDR,
    },{ .name = "UCE_INT_PARITY_IMR",  .addr = A_UCE_INT_PARITY_IMR,
        .reset = 0x7ffff,
        .ro = 0x7ffff,
    },{ .name = "UCE_INT_PARITY_IER",  .addr = A_UCE_INT_PARITY_IER,
    },{ .name = "UCE_INT_PARITY_IDR",  .addr = A_UCE_INT_PARITY_IDR,
    }
};

static void xram_slcr_reset_enter(Object *obj, ResetType type)
{
    XRAM_SLCR *s = XILINX_XRAM_SLCR(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps xram_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void xram_slcr_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void xram_slcr_init(Object *obj)
{
    XRAM_SLCR *s = XILINX_XRAM_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_XRAM_SLCR,
                       XRAM_SLCR_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), xram_slcr_regs_info,
                              ARRAY_SIZE(xram_slcr_regs_info),
                              s->regs_info, s->regs,
                              &xram_slcr_ops,
                              XILINX_XRAM_SLCR_ERR_DEBUG,
                              XRAM_SLCR_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_xram_slcr = {
    .name = TYPE_XILINX_XRAM_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, XRAM_SLCR, XRAM_SLCR_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void xram_slcr_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = xram_slcr_realize;
    dc->vmsd = &vmstate_xram_slcr;
    rc->phases.enter = xram_slcr_reset_enter;
}

static const TypeInfo xram_slcr_info = {
    .name          = TYPE_XILINX_XRAM_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(XRAM_SLCR),
    .class_init    = xram_slcr_class_init,
    .instance_init = xram_slcr_init,
};

static void xram_slcr_register_types(void)
{
    type_register_static(&xram_slcr_info);
}

type_init(xram_slcr_register_types)
