/* SPDX-License-Identifier: BSD-2-Clause */

/*
 *  COPYRIGHT (c) 2014.
 *  On-Line Applications Research Corporation (OAR).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define CONFIGURE_INIT
#include "system.h"

const char rtems_test_name[] = "SP SIGNAL ERROR 01";

rtems_task Init(
  rtems_task_argument argument
)
{
  rtems_status_code status;

  TEST_BEGIN();
  /* send invalid id */
  status = rtems_signal_send( 100, RTEMS_SIGNAL_1 );
  fatal_directive_status(
    status,
    RTEMS_INVALID_ID,
    "rtems_signal_send with illegal id"
  );
  puts( "TA1 - rtems_signal_send - RTEMS_INVALID_ID" );

  /* no signal in set */
  status = rtems_signal_send( RTEMS_SELF, 0 );
  fatal_directive_status(
    status,
    RTEMS_INVALID_NUMBER,
    "rtems_signal_send with no signals"
  );
  puts( "TA1 - rtems_signal_send - RTEMS_INVALID_NUMBER" );

  /* no signal handler */
  status = rtems_signal_send( RTEMS_SELF, RTEMS_SIGNAL_16 );
  fatal_directive_status(
    status,
    RTEMS_NOT_DEFINED,
    "rtems_signal_send with no handler"
  );
  puts( "TA1 - rtems_signal_send - RTEMS_NOT_DEFINED" );

  TEST_END();
}
