/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSBSPsARMTMS570
 *
 * @brief This header file provides SYS2 interfaces.
 */

/* The header file is generated by make_header.py from SYS2.json */
/* Current script's version can be found at: */
/* https://github.com/AoLaD/rtems-tms570-utils/tree/headers/headers/python */

/*
 * Copyright (c) 2014-2015, Premysl Houdek <kom541000@gmail.com>
 *
 * Czech Technical University in Prague
 * Zikova 1903/4
 * 166 36 Praha 6
 * Czech Republic
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the FreeBSD Project.
*/
#ifndef LIBBSP_ARM_TMS570_SYS2
#define LIBBSP_ARM_TMS570_SYS2

#include <bsp/utility.h>

typedef struct{
  uint32_t PLLCTL3;           /*PLL Control Register 3*/
  uint8_t reserved1 [4];
  uint32_t STCCLKDIV;         /*CPU Logic BIST Clock Divider*/
  uint8_t reserved2 [24];
  uint32_t ECPCNTL;           /*ECP Control Register*/
  uint8_t reserved3 [20];
  uint32_t CLK2CNTRL;         /*Clock 2 Control Register*/
  uint32_t VCLKACON1;         /*Peripheral Asynchronous Clock Configuration 1 Register*/
  uint8_t reserved4 [16];
  uint32_t HCLKCNTL;          /* 0x0054 */
  uint8_t reserved5 [24];
  uint32_t CLKSLIP;           /*Clock Slip Register*/
  uint8_t reserved6 [120];
  uint32_t EFC_CTLREG;        /*EFUSE Controller Control Register*/
  uint32_t DIEDL_REG0;        /*Die Identification Register*/
  uint32_t DIEDH_REG1;        /*Die Identification Register*/
  uint32_t DIEDL_REG2;        /*Die Identification Register*/
  uint32_t DIEDH_REG3;        /*Die Identification Register*/
} tms570_sys2_t;


/*--------------------TMS570_SYS2_PLLCTL3--------------------*/
/* field: ODPLL2 - Internal PLL Output Divider */
#define TMS570_SYS2_PLLCTL3_ODPLL2(val) BSP_FLD32(val,29, 31)
#define TMS570_SYS2_PLLCTL3_ODPLL2_GET(reg) BSP_FLD32GET(reg,29, 31)
#define TMS570_SYS2_PLLCTL3_ODPLL2_SET(reg,val) BSP_FLD32SET(reg, val,29, 31)

/* field: PLLDIV2 - PLL2 Output Clock Divider */
#define TMS570_SYS2_PLLCTL3_PLLDIV2(val) BSP_FLD32(val,24, 28)
#define TMS570_SYS2_PLLCTL3_PLLDIV2_GET(reg) BSP_FLD32GET(reg,24, 28)
#define TMS570_SYS2_PLLCTL3_PLLDIV2_SET(reg,val) BSP_FLD32SET(reg, val,24, 28)

/* field: REFCLKDIV2 - REFCLKDIV2 */
#define TMS570_SYS2_PLLCTL3_REFCLKDIV2(val) BSP_FLD32(val,16, 21)
#define TMS570_SYS2_PLLCTL3_REFCLKDIV2_GET(reg) BSP_FLD32GET(reg,16, 21)
#define TMS570_SYS2_PLLCTL3_REFCLKDIV2_SET(reg,val) BSP_FLD32SET(reg, val,16, 21)

/* field: PLLMUL2 - PLL2 Multiplication Factor */
#define TMS570_SYS2_PLLCTL3_PLLMUL2(val) BSP_FLD32(val,0, 15)
#define TMS570_SYS2_PLLCTL3_PLLMUL2_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_SYS2_PLLCTL3_PLLMUL2_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*-------------------TMS570_SYS2_STCCLKDIV-------------------*/
/* field: CLKDIV - Clock divider/prescaler for CPU clock during logic BIST */
#define TMS570_SYS2_STCCLKDIV_CLKDIV(val) BSP_FLD32(val,24, 26)
#define TMS570_SYS2_STCCLKDIV_CLKDIV_GET(reg) BSP_FLD32GET(reg,24, 26)
#define TMS570_SYS2_STCCLKDIV_CLKDIV_SET(reg,val) BSP_FLD32SET(reg, val,24, 26)


/*--------------------TMS570_SYS2_ECPCNTL--------------------*/
/* field: ECPSSEL - This bit allows the selection between VCLK and OSCIN as the clock source for ECLK. */
#define TMS570_SYS2_ECPCNTL_ECPSSEL BSP_BIT32(24)

/* field: ECPCOS - ECP continue on suspend. */
#define TMS570_SYS2_ECPCNTL_ECPCOS BSP_BIT32(23)

/* field: ECPINSEL - Select ECP input clock source. */
#define TMS570_SYS2_ECPCNTL_ECPINSEL(val) BSP_FLD32(val,6, 17)
#define TMS570_SYS2_ECPCNTL_ECPINSEL_GET(reg) BSP_FLD32GET(reg,6, 17)
#define TMS570_SYS2_ECPCNTL_ECPINSEL_SET(reg,val) BSP_FLD32SET(reg, val,6, 17)

/* field: ECPDIV - ECP divider value. */
#define TMS570_SYS2_ECPCNTL_ECPDIV(val) BSP_FLD32(val,0, 15)
#define TMS570_SYS2_ECPCNTL_ECPDIV_GET(reg) BSP_FLD32GET(reg,0, 15)
#define TMS570_SYS2_ECPCNTL_ECPDIV_SET(reg,val) BSP_FLD32SET(reg, val,0, 15)


/*-------------------TMS570_SYS2_CLK2CNTRL-------------------*/
/* field: VCLK3R - VBUS clock3 ratio. */
#define TMS570_SYS2_CLK2CNTRL_VCLK3R(val) BSP_FLD32(val,0, 3)
#define TMS570_SYS2_CLK2CNTRL_VCLK3R_GET(reg) BSP_FLD32GET(reg,0, 3)
#define TMS570_SYS2_CLK2CNTRL_VCLK3R_SET(reg,val) BSP_FLD32SET(reg, val,0, 3)


/*-------------------TMS570_SYS2_VCLKACON1-------------------*/
/* field: VCLKA4R - Clock divider for the VCLKA4 source. Output will be present on VCLKA4_DIVR. */
#define TMS570_SYS2_VCLKACON1_VCLKA4R(val) BSP_FLD32(val,24, 26)
#define TMS570_SYS2_VCLKACON1_VCLKA4R_GET(reg) BSP_FLD32GET(reg,24, 26)
#define TMS570_SYS2_VCLKACON1_VCLKA4R_SET(reg,val) BSP_FLD32SET(reg, val,24, 26)

/* field: VCLKA4_DIV_CDDIS - Disable the VCLKA4 divider output. */
#define TMS570_SYS2_VCLKACON1_VCLKA4_DIV_CDDIS BSP_BIT32(20)

/* field: VCLKA4S - Peripheral asynchronous clock4 source. */
#define TMS570_SYS2_VCLKACON1_VCLKA4S(val) BSP_FLD32(val,16, 19)
#define TMS570_SYS2_VCLKACON1_VCLKA4S_GET(reg) BSP_FLD32GET(reg,16, 19)
#define TMS570_SYS2_VCLKACON1_VCLKA4S_SET(reg,val) BSP_FLD32SET(reg, val,16, 19)

/* field: VCLKA3R - Clock divider for the VCLKA3 source. Output will be present on VCLKA3_DIVR. */
#define TMS570_SYS2_VCLKACON1_VCLKA3R(val) BSP_FLD32(val,8, 10)
#define TMS570_SYS2_VCLKACON1_VCLKA3R_GET(reg) BSP_FLD32GET(reg,8, 10)
#define TMS570_SYS2_VCLKACON1_VCLKA3R_SET(reg,val) BSP_FLD32SET(reg, val,8, 10)

/* field: VCLKA3_DIV_CDDIS - Disable the VCLKA3 divider output. */
#define TMS570_SYS2_VCLKACON1_VCLKA3_DIV_CDDIS BSP_BIT32(4)

/* field: VCLKA3S - Peripheral asynchronous clock3 source. */
#define TMS570_SYS2_VCLKACON1_VCLKA3S(val) BSP_FLD32(val,0, 3)
#define TMS570_SYS2_VCLKACON1_VCLKA3S_GET(reg) BSP_FLD32GET(reg,0, 3)
#define TMS570_SYS2_VCLKACON1_VCLKA3S_SET(reg,val) BSP_FLD32SET(reg, val,0, 3)


/*--------------------TMS570_SYS2_CLKSLIP--------------------*/
/* field: PLL1_SLIP_FILTER_COUNT - Configure the count for the filtered PLL slip. Count is on 10M clock. */
#define TMS570_SYS2_CLKSLIP_PLL1_SLIP_FILTER_COUNT(val) BSP_FLD32(val,8, 13)
#define TMS570_SYS2_CLKSLIP_PLL1_SLIP_FILTER_COUNT_GET(reg) BSP_FLD32GET(reg,8, 13)
#define TMS570_SYS2_CLKSLIP_PLL1_SLIP_FILTER_COUNT_SET(reg,val) BSP_FLD32SET(reg, val,8, 13)

/* field: PLL1_SLIP_FILTER_KEY - Enable the PLL filtering. */
#define TMS570_SYS2_CLKSLIP_PLL1_SLIP_FILTER_KEY(val) BSP_FLD32(val,0, 3)
#define TMS570_SYS2_CLKSLIP_PLL1_SLIP_FILTER_KEY_GET(reg) BSP_FLD32GET(reg,0, 3)
#define TMS570_SYS2_CLKSLIP_PLL1_SLIP_FILTER_KEY_SET(reg,val) BSP_FLD32SET(reg, val,0, 3)


/*-------------------TMS570_SYS2_EFC_CTLREG-------------------*/
/* field: EFC_INSTR_WEN - Enable user write of 4 EFUSE controller instructions. */
#define TMS570_SYS2_EFC_CTLREG_EFC_INSTR_WEN(val) BSP_FLD32(val,0, 3)
#define TMS570_SYS2_EFC_CTLREG_EFC_INSTR_WEN_GET(reg) BSP_FLD32GET(reg,0, 3)
#define TMS570_SYS2_EFC_CTLREG_EFC_INSTR_WEN_SET(reg,val) BSP_FLD32SET(reg, val,0, 3)


/*-----------------------TMS570_SYS2_x-----------------------*/
/* field: DIE - This read-only register contains the lower/upper word (31:0) of the die ID information. */
/* Whole 32 bits */


#endif /* LIBBSP_ARM_TMS570_SYS2 */
