/**
 * @file
 *
 * @ingroup RTEMSBSPsARMCycVContrib
 */

/*******************************************************************************
*                                                                              *
* Copyright 2013 Altera Corporation. All Rights Reserved.                      *
*                                                                              *
* Redistribution and use in source and binary forms, with or without           *
* modification, are permitted provided that the following conditions are met:  *
*                                                                              *
* 1. Redistributions of source code must retain the above copyright notice,    *
*    this list of conditions and the following disclaimer.                     *
*                                                                              *
* 2. Redistributions in binary form must reproduce the above copyright notice, *
*    this list of conditions and the following disclaimer in the documentation *
*    and/or other materials provided with the distribution.                    *
*                                                                              *
* 3. The name of the author may not be used to endorse or promote products     *
*    derived from this software without specific prior written permission.     *
*                                                                              *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY EXPRESS OR *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED. IN NO  *
* EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       *
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;  *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,     *
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR      *
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF       *
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                   *
*                                                                              *
*******************************************************************************/

/* Altera - ALT_SYSMGR */

#ifndef __ALTERA_ALT_SYSMGR_H__
#define __ALTERA_ALT_SYSMGR_H__

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

/*
 * Component : System Manager Module - ALT_SYSMGR
 * System Manager Module
 * 
 * Registers in the System Manager module
 * 
 */
/*
 * Register : Silicon ID1 Register - siliconid1
 * 
 * Specifies Silicon ID and revision number.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description     
 * :--------|:-------|:------|:-----------------
 *  [15:0]  | R      | 0x1   | Silicon Revision
 *  [31:16] | R      | 0x0   | Silicon ID      
 * 
 */
/*
 * Field : Silicon Revision - rev
 * 
 * Silicon revision number.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                             | Value | Description
 * :---------------------------------|:------|:------------
 *  ALT_SYSMGR_SILICONID1_REV_E_REV1 | 0x1   | Revision 1 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_SILICONID1_REV
 * 
 * Revision 1
 */
#define ALT_SYSMGR_SILICONID1_REV_E_REV1    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SILICONID1_REV register field. */
#define ALT_SYSMGR_SILICONID1_REV_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SILICONID1_REV register field. */
#define ALT_SYSMGR_SILICONID1_REV_MSB        15
/* The width in bits of the ALT_SYSMGR_SILICONID1_REV register field. */
#define ALT_SYSMGR_SILICONID1_REV_WIDTH      16
/* The mask used to set the ALT_SYSMGR_SILICONID1_REV register field value. */
#define ALT_SYSMGR_SILICONID1_REV_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_SYSMGR_SILICONID1_REV register field value. */
#define ALT_SYSMGR_SILICONID1_REV_CLR_MSK    0xffff0000
/* The reset value of the ALT_SYSMGR_SILICONID1_REV register field. */
#define ALT_SYSMGR_SILICONID1_REV_RESET      0x1
/* Extracts the ALT_SYSMGR_SILICONID1_REV field value from a register. */
#define ALT_SYSMGR_SILICONID1_REV_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_SYSMGR_SILICONID1_REV register field value suitable for setting the register. */
#define ALT_SYSMGR_SILICONID1_REV_SET(value) (((value) << 0) & 0x0000ffff)

/*
 * Field : Silicon ID - id
 * 
 * Silicon ID
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                  
 * :-------------------------------------------|:------|:----------------------------------------------
 *  ALT_SYSMGR_SILICONID1_ID_E_CYCLONEV_ARRIAV | 0x0   | HPS in Cyclone V and Arria V SoC FPGA devices
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_SILICONID1_ID
 * 
 * HPS in Cyclone V and Arria V SoC FPGA devices
 */
#define ALT_SYSMGR_SILICONID1_ID_E_CYCLONEV_ARRIAV  0x0

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SILICONID1_ID register field. */
#define ALT_SYSMGR_SILICONID1_ID_LSB        16
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SILICONID1_ID register field. */
#define ALT_SYSMGR_SILICONID1_ID_MSB        31
/* The width in bits of the ALT_SYSMGR_SILICONID1_ID register field. */
#define ALT_SYSMGR_SILICONID1_ID_WIDTH      16
/* The mask used to set the ALT_SYSMGR_SILICONID1_ID register field value. */
#define ALT_SYSMGR_SILICONID1_ID_SET_MSK    0xffff0000
/* The mask used to clear the ALT_SYSMGR_SILICONID1_ID register field value. */
#define ALT_SYSMGR_SILICONID1_ID_CLR_MSK    0x0000ffff
/* The reset value of the ALT_SYSMGR_SILICONID1_ID register field. */
#define ALT_SYSMGR_SILICONID1_ID_RESET      0x0
/* Extracts the ALT_SYSMGR_SILICONID1_ID field value from a register. */
#define ALT_SYSMGR_SILICONID1_ID_GET(value) (((value) & 0xffff0000) >> 16)
/* Produces a ALT_SYSMGR_SILICONID1_ID register field value suitable for setting the register. */
#define ALT_SYSMGR_SILICONID1_ID_SET(value) (((value) << 16) & 0xffff0000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_SILICONID1.
 */
struct ALT_SYSMGR_SILICONID1_s
{
    const uint32_t  rev : 16;  /* Silicon Revision */
    const uint32_t  id  : 16;  /* Silicon ID */
};

/* The typedef declaration for register ALT_SYSMGR_SILICONID1. */
typedef volatile struct ALT_SYSMGR_SILICONID1_s  ALT_SYSMGR_SILICONID1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_SILICONID1 register from the beginning of the component. */
#define ALT_SYSMGR_SILICONID1_OFST        0x0

/*
 * Register : Silicon ID2 Register - siliconid2
 * 
 * Reserved for future use.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [31:0] | R      | 0x0   | Reserved   
 * 
 */
/*
 * Field : Reserved - rsv
 * 
 * Reserved for future use.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SILICONID2_RSV register field. */
#define ALT_SYSMGR_SILICONID2_RSV_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SILICONID2_RSV register field. */
#define ALT_SYSMGR_SILICONID2_RSV_MSB        31
/* The width in bits of the ALT_SYSMGR_SILICONID2_RSV register field. */
#define ALT_SYSMGR_SILICONID2_RSV_WIDTH      32
/* The mask used to set the ALT_SYSMGR_SILICONID2_RSV register field value. */
#define ALT_SYSMGR_SILICONID2_RSV_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_SILICONID2_RSV register field value. */
#define ALT_SYSMGR_SILICONID2_RSV_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_SILICONID2_RSV register field. */
#define ALT_SYSMGR_SILICONID2_RSV_RESET      0x0
/* Extracts the ALT_SYSMGR_SILICONID2_RSV field value from a register. */
#define ALT_SYSMGR_SILICONID2_RSV_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_SILICONID2_RSV register field value suitable for setting the register. */
#define ALT_SYSMGR_SILICONID2_RSV_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_SILICONID2.
 */
struct ALT_SYSMGR_SILICONID2_s
{
    const uint32_t  rsv : 32;  /* Reserved */
};

/* The typedef declaration for register ALT_SYSMGR_SILICONID2. */
typedef volatile struct ALT_SYSMGR_SILICONID2_s  ALT_SYSMGR_SILICONID2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_SILICONID2 register from the beginning of the component. */
#define ALT_SYSMGR_SILICONID2_OFST        0x4

/*
 * Register : L4 Watchdog Debug Register - wddbg
 * 
 * Controls the behavior of the L4 watchdogs when the CPUs are in debug mode. These
 * control registers are used to drive the pause input signal of the L4 watchdogs.
 * Note that the watchdogs built into the MPU automatically are paused when their
 * associated CPU enters debug mode. Only reset by a cold reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [1:0]  | RW     | 0x3   | Debug Mode 
 *  [3:2]  | RW     | 0x3   | Debug Mode 
 *  [31:4] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : Debug Mode - mode_0
 * 
 * Controls behavior of L4 watchdog when CPUs in debug mode. Field array index
 * matches L4 watchdog index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                     
 * :-------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_WDDBG_MOD_0_E_CONTINUE    | 0x0   | Continue normal operation ignoring debug mode of
 * :                                     |       | CPUs                                            
 *  ALT_SYSMGR_WDDBG_MOD_0_E_PAUSECPU0   | 0x1   | Pause normal operation only if CPU0 is in debug 
 * :                                     |       | mode                                            
 *  ALT_SYSMGR_WDDBG_MOD_0_E_PAUSECPU1   | 0x2   | Pause normal operation only if CPU1 is in debug 
 * :                                     |       | mode                                            
 *  ALT_SYSMGR_WDDBG_MOD_0_E_PAUSEEITHER | 0x3   | Pause normal operation if CPU0 or CPU1 is in    
 * :                                     |       | debug mode                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_0
 * 
 * Continue normal operation ignoring debug mode of CPUs
 */
#define ALT_SYSMGR_WDDBG_MOD_0_E_CONTINUE       0x0
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_0
 * 
 * Pause normal operation only if CPU0 is in debug mode
 */
#define ALT_SYSMGR_WDDBG_MOD_0_E_PAUSECPU0      0x1
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_0
 * 
 * Pause normal operation only if CPU1 is in debug mode
 */
#define ALT_SYSMGR_WDDBG_MOD_0_E_PAUSECPU1      0x2
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_0
 * 
 * Pause normal operation if CPU0 or CPU1 is in debug mode
 */
#define ALT_SYSMGR_WDDBG_MOD_0_E_PAUSEEITHER    0x3

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_WDDBG_MOD_0 register field. */
#define ALT_SYSMGR_WDDBG_MOD_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_WDDBG_MOD_0 register field. */
#define ALT_SYSMGR_WDDBG_MOD_0_MSB        1
/* The width in bits of the ALT_SYSMGR_WDDBG_MOD_0 register field. */
#define ALT_SYSMGR_WDDBG_MOD_0_WIDTH      2
/* The mask used to set the ALT_SYSMGR_WDDBG_MOD_0 register field value. */
#define ALT_SYSMGR_WDDBG_MOD_0_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_WDDBG_MOD_0 register field value. */
#define ALT_SYSMGR_WDDBG_MOD_0_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_WDDBG_MOD_0 register field. */
#define ALT_SYSMGR_WDDBG_MOD_0_RESET      0x3
/* Extracts the ALT_SYSMGR_WDDBG_MOD_0 field value from a register. */
#define ALT_SYSMGR_WDDBG_MOD_0_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_WDDBG_MOD_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_WDDBG_MOD_0_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : Debug Mode - mode_1
 * 
 * Controls behavior of L4 watchdog when CPUs in debug mode. Field array index
 * matches L4 watchdog index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                     
 * :-------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_WDDBG_MOD_1_E_CONTINUE    | 0x0   | Continue normal operation ignoring debug mode of
 * :                                     |       | CPUs                                            
 *  ALT_SYSMGR_WDDBG_MOD_1_E_PAUSECPU0   | 0x1   | Pause normal operation only if CPU0 is in debug 
 * :                                     |       | mode                                            
 *  ALT_SYSMGR_WDDBG_MOD_1_E_PAUSECPU1   | 0x2   | Pause normal operation only if CPU1 is in debug 
 * :                                     |       | mode                                            
 *  ALT_SYSMGR_WDDBG_MOD_1_E_PAUSEEITHER | 0x3   | Pause normal operation if CPU0 or CPU1 is in    
 * :                                     |       | debug mode                                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_1
 * 
 * Continue normal operation ignoring debug mode of CPUs
 */
#define ALT_SYSMGR_WDDBG_MOD_1_E_CONTINUE       0x0
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_1
 * 
 * Pause normal operation only if CPU0 is in debug mode
 */
#define ALT_SYSMGR_WDDBG_MOD_1_E_PAUSECPU0      0x1
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_1
 * 
 * Pause normal operation only if CPU1 is in debug mode
 */
#define ALT_SYSMGR_WDDBG_MOD_1_E_PAUSECPU1      0x2
/*
 * Enumerated value for register field ALT_SYSMGR_WDDBG_MOD_1
 * 
 * Pause normal operation if CPU0 or CPU1 is in debug mode
 */
#define ALT_SYSMGR_WDDBG_MOD_1_E_PAUSEEITHER    0x3

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_WDDBG_MOD_1 register field. */
#define ALT_SYSMGR_WDDBG_MOD_1_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_WDDBG_MOD_1 register field. */
#define ALT_SYSMGR_WDDBG_MOD_1_MSB        3
/* The width in bits of the ALT_SYSMGR_WDDBG_MOD_1 register field. */
#define ALT_SYSMGR_WDDBG_MOD_1_WIDTH      2
/* The mask used to set the ALT_SYSMGR_WDDBG_MOD_1 register field value. */
#define ALT_SYSMGR_WDDBG_MOD_1_SET_MSK    0x0000000c
/* The mask used to clear the ALT_SYSMGR_WDDBG_MOD_1 register field value. */
#define ALT_SYSMGR_WDDBG_MOD_1_CLR_MSK    0xfffffff3
/* The reset value of the ALT_SYSMGR_WDDBG_MOD_1 register field. */
#define ALT_SYSMGR_WDDBG_MOD_1_RESET      0x3
/* Extracts the ALT_SYSMGR_WDDBG_MOD_1 field value from a register. */
#define ALT_SYSMGR_WDDBG_MOD_1_GET(value) (((value) & 0x0000000c) >> 2)
/* Produces a ALT_SYSMGR_WDDBG_MOD_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_WDDBG_MOD_1_SET(value) (((value) << 2) & 0x0000000c)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_WDDBG.
 */
struct ALT_SYSMGR_WDDBG_s
{
    uint32_t  mode_0 :  2;  /* Debug Mode */
    uint32_t  mode_1 :  2;  /* Debug Mode */
    uint32_t         : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_WDDBG. */
typedef volatile struct ALT_SYSMGR_WDDBG_s  ALT_SYSMGR_WDDBG_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_WDDBG register from the beginning of the component. */
#define ALT_SYSMGR_WDDBG_OFST        0x10

/*
 * Register : Boot Info Register - bootinfo
 * 
 * Provides access to boot configuration information.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset   | Description         
 * :--------|:-------|:--------|:---------------------
 *  [2:0]   | R      | Unknown | Boot Select         
 *  [4:3]   | R      | Unknown | Clock Select        
 *  [7:5]   | R      | Unknown | HPS Pin Boot Select 
 *  [9:8]   | R      | Unknown | HPS Pin Clock Select
 *  [31:10] | ???    | Unknown | *UNDEFINED*         
 * 
 */
/*
 * Field : Boot Select - bsel
 * 
 * The boot select field specifies the boot source. It is read by the Boot ROM code
 * on a cold or warm reset to determine the boot source.
 * 
 * The HPS BSEL pins value are sampled upon deassertion of cold reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                    | Value | Description                       
 * :--------------------------------------------------------|:------|:-----------------------------------
 *  ALT_SYSMGR_BOOT_BSEL_E_RSVD                             | 0x0   | Reserved                          
 *  ALT_SYSMGR_BOOT_BSEL_E_FPGA                             | 0x1   | FPGA (HPS2FPGA Bridge)            
 *  ALT_SYSMGR_BOOT_BSEL_E_NAND_FLSH_1_8V                   | 0x2   | NAND Flash (1.8v)                 
 *  ALT_SYSMGR_BOOT_BSEL_E_NAND_FLSH_3_0V                   | 0x3   | NAND Flash (3.0v)                 
 *  ALT_SYSMGR_BOOT_BSEL_E_SD_MMC_EXTERNAL_TRANSCEIVER_1_8V | 0x4   | SD/MMC External Transceiver (1.8v)
 *  ALT_SYSMGR_BOOT_BSEL_E_SD_MMC_INTERNAL_TRANSCEIVER_3_0V | 0x5   | SD/MMC Internal Transceiver (3.0v)
 *  ALT_SYSMGR_BOOT_BSEL_E_QSPI_FLSH_1_8V                   | 0x6   | QSPI Flash (1.8v)                 
 *  ALT_SYSMGR_BOOT_BSEL_E_QSPI_FLSH_3_0V                   | 0x7   | QSPI Flash (3.0v)                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * Reserved
 */
#define ALT_SYSMGR_BOOT_BSEL_E_RSVD                             0x0
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * FPGA (HPS2FPGA Bridge)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_FPGA                             0x1
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * NAND Flash (1.8v)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_NAND_FLSH_1_8V                   0x2
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * NAND Flash (3.0v)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_NAND_FLSH_3_0V                   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * SD/MMC External Transceiver (1.8v)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_SD_MMC_EXTERNAL_TRANSCEIVER_1_8V 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * SD/MMC Internal Transceiver (3.0v)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_SD_MMC_INTERNAL_TRANSCEIVER_3_0V 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * QSPI Flash (1.8v)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_QSPI_FLSH_1_8V                   0x6
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_BSEL
 * 
 * QSPI Flash (3.0v)
 */
#define ALT_SYSMGR_BOOT_BSEL_E_QSPI_FLSH_3_0V                   0x7

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_BOOT_BSEL register field. */
#define ALT_SYSMGR_BOOT_BSEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_BOOT_BSEL register field. */
#define ALT_SYSMGR_BOOT_BSEL_MSB        2
/* The width in bits of the ALT_SYSMGR_BOOT_BSEL register field. */
#define ALT_SYSMGR_BOOT_BSEL_WIDTH      3
/* The mask used to set the ALT_SYSMGR_BOOT_BSEL register field value. */
#define ALT_SYSMGR_BOOT_BSEL_SET_MSK    0x00000007
/* The mask used to clear the ALT_SYSMGR_BOOT_BSEL register field value. */
#define ALT_SYSMGR_BOOT_BSEL_CLR_MSK    0xfffffff8
/* The reset value of the ALT_SYSMGR_BOOT_BSEL register field is UNKNOWN. */
#define ALT_SYSMGR_BOOT_BSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_BOOT_BSEL field value from a register. */
#define ALT_SYSMGR_BOOT_BSEL_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_SYSMGR_BOOT_BSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_BOOT_BSEL_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : Clock Select - csel
 * 
 * The clock select field specifies clock information for booting. The clock select
 * encoding is a function of the CSEL value. The clock select field is read by the
 * Boot ROM code on a cold or warm reset when booting from a flash device to get
 * information about how to setup the HPS clocking to boot from the specified clock
 * device.
 * 
 * The encoding of the clock select field is specified by the enum associated with
 * this field.
 * 
 * The HPS CSEL pins value are sampled upon deassertion of cold reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                          | Value | Description                                    
 * :------------------------------|:------|:------------------------------------------------
 *  ALT_SYSMGR_BOOT_CSEL_E_CSEL_0 | 0x0   | QSPI device clock is osc1_clk divided by 4,    
 * :                              |       | SD/MMC device clock is osc1_clk divided by 4,  
 * :                              |       | NAND device operation is osc1_clk divided by 25
 *  ALT_SYSMGR_BOOT_CSEL_E_CSEL_1 | 0x1   | QSPI device clock is osc1_clk divided by 2,    
 * :                              |       | SD/MMC device clock is osc1_clk divided by 1,  
 * :                              |       | NAND device operation is osc1_clk multiplied by
 * :                              |       | 20/25                                          
 *  ALT_SYSMGR_BOOT_CSEL_E_CSEL_2 | 0x2   | QSPI device clock is osc1_clk divided by 1,    
 * :                              |       | SD/MMC device clock is osc1_clk divided by 2,  
 * :                              |       | NAND device operation is osc1_clk multiplied by
 * :                              |       | 10/25                                          
 *  ALT_SYSMGR_BOOT_CSEL_E_CSEL_3 | 0x3   | QSPI device clock is osc1_clk multiplied by 2, 
 * :                              |       | SD/MMC device clock is osc1_clk divided by 4,  
 * :                              |       | NAND device operation is osc1_clk multiplied by
 * :                              |       | 5/25                                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_CSEL
 * 
 * QSPI device clock is osc1_clk divided by 4, SD/MMC device clock is osc1_clk
 * divided by 4, NAND device operation is osc1_clk divided by 25
 */
#define ALT_SYSMGR_BOOT_CSEL_E_CSEL_0   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_CSEL
 * 
 * QSPI device clock is osc1_clk divided by 2, SD/MMC device clock is osc1_clk
 * divided by 1, NAND device operation is osc1_clk multiplied by 20/25
 */
#define ALT_SYSMGR_BOOT_CSEL_E_CSEL_1   0x1
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_CSEL
 * 
 * QSPI device clock is osc1_clk divided by 1, SD/MMC device clock is osc1_clk
 * divided by 2, NAND device operation is osc1_clk multiplied by 10/25
 */
#define ALT_SYSMGR_BOOT_CSEL_E_CSEL_2   0x2
/*
 * Enumerated value for register field ALT_SYSMGR_BOOT_CSEL
 * 
 * QSPI device clock is osc1_clk multiplied by 2, SD/MMC device clock is osc1_clk
 * divided by 4, NAND device operation is osc1_clk multiplied by 5/25
 */
#define ALT_SYSMGR_BOOT_CSEL_E_CSEL_3   0x3

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_BOOT_CSEL register field. */
#define ALT_SYSMGR_BOOT_CSEL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_BOOT_CSEL register field. */
#define ALT_SYSMGR_BOOT_CSEL_MSB        4
/* The width in bits of the ALT_SYSMGR_BOOT_CSEL register field. */
#define ALT_SYSMGR_BOOT_CSEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_BOOT_CSEL register field value. */
#define ALT_SYSMGR_BOOT_CSEL_SET_MSK    0x00000018
/* The mask used to clear the ALT_SYSMGR_BOOT_CSEL register field value. */
#define ALT_SYSMGR_BOOT_CSEL_CLR_MSK    0xffffffe7
/* The reset value of the ALT_SYSMGR_BOOT_CSEL register field is UNKNOWN. */
#define ALT_SYSMGR_BOOT_CSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_BOOT_CSEL field value from a register. */
#define ALT_SYSMGR_BOOT_CSEL_GET(value) (((value) & 0x00000018) >> 3)
/* Produces a ALT_SYSMGR_BOOT_CSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_BOOT_CSEL_SET(value) (((value) << 3) & 0x00000018)

/*
 * Field : HPS Pin Boot Select - pinbsel
 * 
 * Specifies the sampled value of the HPS BSEL pins. The value of HPS BSEL pins are
 * sampled upon deassertion of cold reset.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_BOOT_PINBSEL register field. */
#define ALT_SYSMGR_BOOT_PINBSEL_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_BOOT_PINBSEL register field. */
#define ALT_SYSMGR_BOOT_PINBSEL_MSB        7
/* The width in bits of the ALT_SYSMGR_BOOT_PINBSEL register field. */
#define ALT_SYSMGR_BOOT_PINBSEL_WIDTH      3
/* The mask used to set the ALT_SYSMGR_BOOT_PINBSEL register field value. */
#define ALT_SYSMGR_BOOT_PINBSEL_SET_MSK    0x000000e0
/* The mask used to clear the ALT_SYSMGR_BOOT_PINBSEL register field value. */
#define ALT_SYSMGR_BOOT_PINBSEL_CLR_MSK    0xffffff1f
/* The reset value of the ALT_SYSMGR_BOOT_PINBSEL register field is UNKNOWN. */
#define ALT_SYSMGR_BOOT_PINBSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_BOOT_PINBSEL field value from a register. */
#define ALT_SYSMGR_BOOT_PINBSEL_GET(value) (((value) & 0x000000e0) >> 5)
/* Produces a ALT_SYSMGR_BOOT_PINBSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_BOOT_PINBSEL_SET(value) (((value) << 5) & 0x000000e0)

/*
 * Field : HPS Pin Clock Select - pincsel
 * 
 * Specifies the sampled value of the HPS CSEL pins. The value of HPS CSEL pins are
 * sampled upon deassertion of cold reset.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_BOOT_PINCSEL register field. */
#define ALT_SYSMGR_BOOT_PINCSEL_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_BOOT_PINCSEL register field. */
#define ALT_SYSMGR_BOOT_PINCSEL_MSB        9
/* The width in bits of the ALT_SYSMGR_BOOT_PINCSEL register field. */
#define ALT_SYSMGR_BOOT_PINCSEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_BOOT_PINCSEL register field value. */
#define ALT_SYSMGR_BOOT_PINCSEL_SET_MSK    0x00000300
/* The mask used to clear the ALT_SYSMGR_BOOT_PINCSEL register field value. */
#define ALT_SYSMGR_BOOT_PINCSEL_CLR_MSK    0xfffffcff
/* The reset value of the ALT_SYSMGR_BOOT_PINCSEL register field is UNKNOWN. */
#define ALT_SYSMGR_BOOT_PINCSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_BOOT_PINCSEL field value from a register. */
#define ALT_SYSMGR_BOOT_PINCSEL_GET(value) (((value) & 0x00000300) >> 8)
/* Produces a ALT_SYSMGR_BOOT_PINCSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_BOOT_PINCSEL_SET(value) (((value) << 8) & 0x00000300)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_BOOT.
 */
struct ALT_SYSMGR_BOOT_s
{
    const uint32_t  bsel    :  3;  /* Boot Select */
    const uint32_t  csel    :  2;  /* Clock Select */
    const uint32_t  pinbsel :  3;  /* HPS Pin Boot Select */
    const uint32_t  pincsel :  2;  /* HPS Pin Clock Select */
    uint32_t                : 22;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_BOOT. */
typedef volatile struct ALT_SYSMGR_BOOT_s  ALT_SYSMGR_BOOT_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_BOOT register from the beginning of the component. */
#define ALT_SYSMGR_BOOT_OFST        0x14

/*
 * Register : HPS Info Register - hpsinfo
 * 
 * Provides information about the HPS capabilities.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset   | Description
 * :-------|:-------|:--------|:------------
 *  [0]    | R      | Unknown | Dual Core  
 *  [1]    | R      | Unknown | CAN        
 *  [31:2] | ???    | 0x0     | *UNDEFINED*
 * 
 */
/*
 * Field : Dual Core - dualcore
 * 
 * Indicates if CPU1 is available in MPU or not.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                 
 * :-----------------------------------------|:------|:---------------------------------------------
 *  ALT_SYSMGR_HPSINFO_DUALCORE_E_SINGLECORE | 0x0   | Not dual-core (only CPU0 available).        
 *  ALT_SYSMGR_HPSINFO_DUALCORE_E_DUALCORE   | 0x1   | Is dual-core (CPU0 and CPU1 both available).
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_HPSINFO_DUALCORE
 * 
 * Not dual-core (only CPU0 available).
 */
#define ALT_SYSMGR_HPSINFO_DUALCORE_E_SINGLECORE    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_HPSINFO_DUALCORE
 * 
 * Is dual-core (CPU0 and CPU1 both available).
 */
#define ALT_SYSMGR_HPSINFO_DUALCORE_E_DUALCORE      0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_HPSINFO_DUALCORE register field. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_HPSINFO_DUALCORE register field. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_MSB        0
/* The width in bits of the ALT_SYSMGR_HPSINFO_DUALCORE register field. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_WIDTH      1
/* The mask used to set the ALT_SYSMGR_HPSINFO_DUALCORE register field value. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_HPSINFO_DUALCORE register field value. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_HPSINFO_DUALCORE register field is UNKNOWN. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_RESET      0x0
/* Extracts the ALT_SYSMGR_HPSINFO_DUALCORE field value from a register. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_HPSINFO_DUALCORE register field value suitable for setting the register. */
#define ALT_SYSMGR_HPSINFO_DUALCORE_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : CAN - can
 * 
 * Indicates if CAN0 and CAN1 controllers are available or not.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                     
 * :-----------------------------------------|:------|:---------------------------------
 *  ALT_SYSMGR_HPSINFO_CAN_E_CAN_UNAVAILABLE | 0x0   | CAN0 and CAN1 are not available.
 *  ALT_SYSMGR_HPSINFO_CAN_E_CAN_AVAILABLE   | 0x1   | CAN0 and CAN1 are available.    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_HPSINFO_CAN
 * 
 * CAN0 and CAN1 are not available.
 */
#define ALT_SYSMGR_HPSINFO_CAN_E_CAN_UNAVAILABLE    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_HPSINFO_CAN
 * 
 * CAN0 and CAN1 are available.
 */
#define ALT_SYSMGR_HPSINFO_CAN_E_CAN_AVAILABLE      0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_HPSINFO_CAN register field. */
#define ALT_SYSMGR_HPSINFO_CAN_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_HPSINFO_CAN register field. */
#define ALT_SYSMGR_HPSINFO_CAN_MSB        1
/* The width in bits of the ALT_SYSMGR_HPSINFO_CAN register field. */
#define ALT_SYSMGR_HPSINFO_CAN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_HPSINFO_CAN register field value. */
#define ALT_SYSMGR_HPSINFO_CAN_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_HPSINFO_CAN register field value. */
#define ALT_SYSMGR_HPSINFO_CAN_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_HPSINFO_CAN register field is UNKNOWN. */
#define ALT_SYSMGR_HPSINFO_CAN_RESET      0x0
/* Extracts the ALT_SYSMGR_HPSINFO_CAN field value from a register. */
#define ALT_SYSMGR_HPSINFO_CAN_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_HPSINFO_CAN register field value suitable for setting the register. */
#define ALT_SYSMGR_HPSINFO_CAN_SET(value) (((value) << 1) & 0x00000002)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_HPSINFO.
 */
struct ALT_SYSMGR_HPSINFO_s
{
    const uint32_t  dualcore :  1;  /* Dual Core */
    const uint32_t  can      :  1;  /* CAN */
    uint32_t                 : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_HPSINFO. */
typedef volatile struct ALT_SYSMGR_HPSINFO_s  ALT_SYSMGR_HPSINFO_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_HPSINFO register from the beginning of the component. */
#define ALT_SYSMGR_HPSINFO_OFST        0x18

/*
 * Register : Parity Fail Injection Register - parityinj
 * 
 * Inject parity failures into the parity-protected RAMs in the MPU. Allows
 * software to test the parity failure interrupt handler. The field array index
 * corresponds to the CPU index.
 * 
 * All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                         
 * :--------|:-------|:------|:-----------------------------------------------------
 *  [0]     | RW     | 0x0   | Parity Fail Injection for Data Cache Data RAM       
 *  [1]     | RW     | 0x0   | Parity Fail Injection for Data Cache Data RAM       
 *  [2]     | RW     | 0x0   | Parity Fail Injection for Data Cache Tag RAM        
 *  [3]     | RW     | 0x0   | Parity Fail Injection for Data Cache Tag RAM        
 *  [4]     | RW     | 0x0   | Parity Fail Injection for Data Cache Outer RAM      
 *  [5]     | RW     | 0x0   | Parity Fail Injection for Data Cache Outer RAM      
 *  [6]     | RW     | 0x0   | Parity Fail Injection for Main TLB RAM              
 *  [7]     | RW     | 0x0   | Parity Fail Injection for Main TLB RAM              
 *  [8]     | RW     | 0x0   | Parity Fail Injection for Instruction Cache Data RAM
 *  [9]     | RW     | 0x0   | Parity Fail Injection for Instruction Cache Data RAM
 *  [10]    | RW     | 0x0   | Parity Fail Injection for Instruction Cache Tag RAM 
 *  [11]    | RW     | 0x0   | Parity Fail Injection for Instruction Cache Tag RAM 
 *  [12]    | RW     | 0x0   | Parity Fail Injection for GHB RAM                   
 *  [13]    | RW     | 0x0   | Parity Fail Injection for GHB RAM                   
 *  [14]    | RW     | 0x0   | Parity Fail Injection for BTAC RAM                  
 *  [15]    | RW     | 0x0   | Parity Fail Injection for BTAC RAM                  
 *  [31:16] | ???    | 0x0   | *UNDEFINED*                                         
 * 
 */
/*
 * Field : Parity Fail Injection for Data Cache Data RAM - dcdata_0
 * 
 * If 1, injecting parity error to Data Cache Data RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_DCDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_DCDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_MSB        0
/* The width in bits of the ALT_SYSMGR_PARITYINJ_DCDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_DCDATA_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_DCDATA_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PARITYINJ_DCDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_DCDATA_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PARITYINJ_DCDATA_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Parity Fail Injection for Data Cache Data RAM - dcdata_1
 * 
 * If 1, injecting parity error to Data Cache Data RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_DCDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_DCDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_MSB        1
/* The width in bits of the ALT_SYSMGR_PARITYINJ_DCDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_DCDATA_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_DCDATA_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_PARITYINJ_DCDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_DCDATA_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_PARITYINJ_DCDATA_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_DCDATA_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Parity Fail Injection for Data Cache Tag RAM - dctag_0
 * 
 * If 1, injecting parity error to Data Cache Tag RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_DCTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_DCTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_MSB        2
/* The width in bits of the ALT_SYSMGR_PARITYINJ_DCTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_DCTAG_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_DCTAG_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_PARITYINJ_DCTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_DCTAG_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_PARITYINJ_DCTAG_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_0_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Parity Fail Injection for Data Cache Tag RAM - dctag_1
 * 
 * If 1, injecting parity error to Data Cache Tag RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_DCTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_DCTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_MSB        3
/* The width in bits of the ALT_SYSMGR_PARITYINJ_DCTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_DCTAG_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_DCTAG_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_PARITYINJ_DCTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_DCTAG_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_PARITYINJ_DCTAG_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_DCTAG_1_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Parity Fail Injection for Data Cache Outer RAM - dcouter_0
 * 
 * If 1, injecting parity error to Data Cache Outer RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_MSB        4
/* The width in bits of the ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_DCOUTER_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_PARITYINJ_DCOUTER_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_0_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : Parity Fail Injection for Data Cache Outer RAM - dcouter_1
 * 
 * If 1, injecting parity error to Data Cache Outer RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_MSB        5
/* The width in bits of the ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_DCOUTER_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_PARITYINJ_DCOUTER_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_DCOUTER_1_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : Parity Fail Injection for Main TLB RAM - maintlb_0
 * 
 * If 1, injecting parity error to Main TLB RAM.The field array index corresponds
 * to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_MSB        6
/* The width in bits of the ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_MAINTLB_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_PARITYINJ_MAINTLB_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_0_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Parity Fail Injection for Main TLB RAM - maintlb_1
 * 
 * If 1, injecting parity error to Main TLB RAM.The field array index corresponds
 * to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_MSB        7
/* The width in bits of the ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_MAINTLB_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_PARITYINJ_MAINTLB_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_MAINTLB_1_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : Parity Fail Injection for Instruction Cache Data RAM - icdata_0
 * 
 * If 1, injecting parity error to Instruction Cache Data RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_ICDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_ICDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_MSB        8
/* The width in bits of the ALT_SYSMGR_PARITYINJ_ICDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_ICDATA_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_SET_MSK    0x00000100
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_ICDATA_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_CLR_MSK    0xfffffeff
/* The reset value of the ALT_SYSMGR_PARITYINJ_ICDATA_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_ICDATA_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_SYSMGR_PARITYINJ_ICDATA_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_0_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : Parity Fail Injection for Instruction Cache Data RAM - icdata_1
 * 
 * If 1, injecting parity error to Instruction Cache Data RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_ICDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_ICDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_MSB        9
/* The width in bits of the ALT_SYSMGR_PARITYINJ_ICDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_ICDATA_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_SET_MSK    0x00000200
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_ICDATA_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_CLR_MSK    0xfffffdff
/* The reset value of the ALT_SYSMGR_PARITYINJ_ICDATA_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_ICDATA_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_SYSMGR_PARITYINJ_ICDATA_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_ICDATA_1_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : Parity Fail Injection for Instruction Cache Tag RAM - ictag_0
 * 
 * If 1, injecting parity error to Instruction Cache Tag RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_ICTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_ICTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_MSB        10
/* The width in bits of the ALT_SYSMGR_PARITYINJ_ICTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_ICTAG_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_SET_MSK    0x00000400
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_ICTAG_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_CLR_MSK    0xfffffbff
/* The reset value of the ALT_SYSMGR_PARITYINJ_ICTAG_0 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_ICTAG_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_SYSMGR_PARITYINJ_ICTAG_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_0_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : Parity Fail Injection for Instruction Cache Tag RAM - ictag_1
 * 
 * If 1, injecting parity error to Instruction Cache Tag RAM.The field array index
 * corresponds to the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_ICTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_ICTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_MSB        11
/* The width in bits of the ALT_SYSMGR_PARITYINJ_ICTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_ICTAG_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_SET_MSK    0x00000800
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_ICTAG_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_SYSMGR_PARITYINJ_ICTAG_1 register field. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_ICTAG_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_SYSMGR_PARITYINJ_ICTAG_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_ICTAG_1_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : Parity Fail Injection for GHB RAM - ghb_0
 * 
 * If 1, injecting parity error to GHB RAM.The field array index corresponds to the
 * CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_GHB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_GHB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_MSB        12
/* The width in bits of the ALT_SYSMGR_PARITYINJ_GHB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_GHB_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_SET_MSK    0x00001000
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_GHB_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_CLR_MSK    0xffffefff
/* The reset value of the ALT_SYSMGR_PARITYINJ_GHB_0 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_GHB_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_SYSMGR_PARITYINJ_GHB_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_GHB_0_SET(value) (((value) << 12) & 0x00001000)

/*
 * Field : Parity Fail Injection for GHB RAM - ghb_1
 * 
 * If 1, injecting parity error to GHB RAM.The field array index corresponds to the
 * CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_GHB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_LSB        13
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_GHB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_MSB        13
/* The width in bits of the ALT_SYSMGR_PARITYINJ_GHB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_GHB_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_SET_MSK    0x00002000
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_GHB_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_CLR_MSK    0xffffdfff
/* The reset value of the ALT_SYSMGR_PARITYINJ_GHB_1 register field. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_GHB_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_GET(value) (((value) & 0x00002000) >> 13)
/* Produces a ALT_SYSMGR_PARITYINJ_GHB_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_GHB_1_SET(value) (((value) << 13) & 0x00002000)

/*
 * Field : Parity Fail Injection for BTAC RAM - btac_0
 * 
 * If 1, injecting parity error to BTAC RAM.The field array index corresponds to
 * the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_BTAC_0 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_LSB        14
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_BTAC_0 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_MSB        14
/* The width in bits of the ALT_SYSMGR_PARITYINJ_BTAC_0 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_BTAC_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_SET_MSK    0x00004000
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_BTAC_0 register field value. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_CLR_MSK    0xffffbfff
/* The reset value of the ALT_SYSMGR_PARITYINJ_BTAC_0 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_BTAC_0 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_GET(value) (((value) & 0x00004000) >> 14)
/* Produces a ALT_SYSMGR_PARITYINJ_BTAC_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_BTAC_0_SET(value) (((value) << 14) & 0x00004000)

/*
 * Field : Parity Fail Injection for BTAC RAM - btac_1
 * 
 * If 1, injecting parity error to BTAC RAM.The field array index corresponds to
 * the CPU index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PARITYINJ_BTAC_1 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_LSB        15
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PARITYINJ_BTAC_1 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_MSB        15
/* The width in bits of the ALT_SYSMGR_PARITYINJ_BTAC_1 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PARITYINJ_BTAC_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_SET_MSK    0x00008000
/* The mask used to clear the ALT_SYSMGR_PARITYINJ_BTAC_1 register field value. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_CLR_MSK    0xffff7fff
/* The reset value of the ALT_SYSMGR_PARITYINJ_BTAC_1 register field. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_RESET      0x0
/* Extracts the ALT_SYSMGR_PARITYINJ_BTAC_1 field value from a register. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_GET(value) (((value) & 0x00008000) >> 15)
/* Produces a ALT_SYSMGR_PARITYINJ_BTAC_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_PARITYINJ_BTAC_1_SET(value) (((value) << 15) & 0x00008000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PARITYINJ.
 */
struct ALT_SYSMGR_PARITYINJ_s
{
    uint32_t  dcdata_0  :  1;  /* Parity Fail Injection for Data Cache Data RAM */
    uint32_t  dcdata_1  :  1;  /* Parity Fail Injection for Data Cache Data RAM */
    uint32_t  dctag_0   :  1;  /* Parity Fail Injection for Data Cache Tag RAM */
    uint32_t  dctag_1   :  1;  /* Parity Fail Injection for Data Cache Tag RAM */
    uint32_t  dcouter_0 :  1;  /* Parity Fail Injection for Data Cache Outer RAM */
    uint32_t  dcouter_1 :  1;  /* Parity Fail Injection for Data Cache Outer RAM */
    uint32_t  maintlb_0 :  1;  /* Parity Fail Injection for Main TLB RAM */
    uint32_t  maintlb_1 :  1;  /* Parity Fail Injection for Main TLB RAM */
    uint32_t  icdata_0  :  1;  /* Parity Fail Injection for Instruction Cache Data RAM */
    uint32_t  icdata_1  :  1;  /* Parity Fail Injection for Instruction Cache Data RAM */
    uint32_t  ictag_0   :  1;  /* Parity Fail Injection for Instruction Cache Tag RAM */
    uint32_t  ictag_1   :  1;  /* Parity Fail Injection for Instruction Cache Tag RAM */
    uint32_t  ghb_0     :  1;  /* Parity Fail Injection for GHB RAM */
    uint32_t  ghb_1     :  1;  /* Parity Fail Injection for GHB RAM */
    uint32_t  btac_0    :  1;  /* Parity Fail Injection for BTAC RAM */
    uint32_t  btac_1    :  1;  /* Parity Fail Injection for BTAC RAM */
    uint32_t            : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PARITYINJ. */
typedef volatile struct ALT_SYSMGR_PARITYINJ_s  ALT_SYSMGR_PARITYINJ_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PARITYINJ register from the beginning of the component. */
#define ALT_SYSMGR_PARITYINJ_OFST        0x1c

/*
 * Register Group : FPGA Interface Group - ALT_SYSMGR_FPGAINTF
 * FPGA Interface Group
 * 
 * Registers used to enable/disable interfaces between the FPGA and HPS. Required
 * for either of the following situations:[list][*]Interfaces that cannot be
 * disabled by putting an HPS module associated with the interface into
 * reset.[*]HPS modules that accept signals from the FPGA fabric and those signals
 * might interfere with the normal operation of the module.[/list].
 * 
 * All registers are only reset by a cold reset (ignore warm reset).
 * 
 */
/*
 * Register : Global Disable Register - gbl
 * 
 * Used to disable all interfaces between the FPGA and HPS.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description     
 * :-------|:-------|:------|:-----------------
 *  [0]    | RW     | 0x1   | Global Interface
 *  [31:1] | ???    | 0x0   | *UNDEFINED*     
 * 
 */
/*
 * Field : Global Interface - intf
 * 
 * Used to disable all interfaces between the FPGA and HPS. Software must ensure
 * that all interfaces between the FPGA and HPS are inactive before disabling them.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                     
 * :-----------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_GBL_INTF_E_DIS | 0x0   | All interfaces between FPGA and HPS are         
 * :                                   |       | disabled.                                       
 *  ALT_SYSMGR_FPGAINTF_GBL_INTF_E_EN  | 0x1   | Interfaces between FPGA and HPS are not all     
 * :                                   |       | disabled. Interfaces can be indivdually disabled
 * :                                   |       | by putting the HPS module associated with the   
 * :                                   |       | interface in reset using registers in the Reset 
 * :                                   |       | Manager or by using registers in this register  
 * :                                   |       | group of the System Manager for interfaces      
 * :                                   |       | without an associated module.                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_GBL_INTF
 * 
 * All interfaces between FPGA and HPS are disabled.
 */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_GBL_INTF
 * 
 * Interfaces between FPGA and HPS are not all disabled. Interfaces can be
 * indivdually disabled by putting the HPS module associated with the interface in
 * reset using registers in the Reset Manager or by using registers in this
 * register group of the System Manager for interfaces without an associated
 * module.
 */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_E_EN   0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_GBL_INTF register field. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_GBL_INTF register field. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_MSB        0
/* The width in bits of the ALT_SYSMGR_FPGAINTF_GBL_INTF register field. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_GBL_INTF register field value. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_GBL_INTF register field value. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_FPGAINTF_GBL_INTF register field. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_GBL_INTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_FPGAINTF_GBL_INTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_GBL_INTF_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FPGAINTF_GBL.
 */
struct ALT_SYSMGR_FPGAINTF_GBL_s
{
    uint32_t  intf :  1;  /* Global Interface */
    uint32_t       : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FPGAINTF_GBL. */
typedef volatile struct ALT_SYSMGR_FPGAINTF_GBL_s  ALT_SYSMGR_FPGAINTF_GBL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FPGAINTF_GBL register from the beginning of the component. */
#define ALT_SYSMGR_FPGAINTF_GBL_OFST        0x0

/*
 * Register : Individual Disable Register - indiv
 * 
 * Used to disable individual interfaces between the FPGA and HPS.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [0]    | RW     | 0x1   | Reset Request Interface      
 *  [1]    | RW     | 0x1   | JTAG Enable Interface        
 *  [2]    | RW     | 0x1   | CONFIG_IO Interface          
 *  [3]    | RW     | 0x1   | Boundary-Scan Interface      
 *  [4]    | RW     | 0x1   | Trace Interface              
 *  [5]    | ???    | 0x1   | *UNDEFINED*                  
 *  [6]    | RW     | 0x1   | STM Event Interface          
 *  [7]    | RW     | 0x1   | Cross Trigger Interface (CTI)
 *  [31:8] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : Reset Request Interface - rstreqintf
 * 
 * Used to disable the reset request interface. This interface allows logic in the
 * FPGA fabric to request HPS resets. This field disables the following reset
 * request signals from the FPGA fabric to HPS:[list][*]f2h_cold_rst_req_n -
 * Triggers a cold reset of the HPS[*]f2h_warm_rst_req_n - Triggers a warm reset of
 * the HPS[*]f2h_dbg_rst_req_n - Triggers a debug reset of the HPS[/list]
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                     
 * :-------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_E_DIS | 0x0   | Reset request interface is disabled. Logic in   
 * :                                           |       | the FPGA fabric cannot reset the HPS.           
 *  ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_E_EN  | 0x1   | Reset request interface is enabled. Logic in the
 * :                                           |       | FPGA fabric can reset the HPS.                  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF
 * 
 * Reset request interface is disabled. Logic in the FPGA fabric cannot reset the
 * HPS.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF
 * 
 * Reset request interface is enabled. Logic in the FPGA fabric can reset the HPS.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_E_EN   0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_MSB        0
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_RSTREQINTF_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : JTAG Enable Interface - jtagenintf
 * 
 * Used to disable the JTAG enable interface. This interface allows logic in the
 * FPGA fabric to disable the HPS JTAG operation.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                    
 * :-------------------------------------------|:------|:------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_E_DIS | 0x0   | JTAG enable interface is disabled. Logic in the
 * :                                           |       | FPGA fabric cannot disable the HPS JTAG.       
 *  ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_E_EN  | 0x1   | JTAG enable interface is enabled. Logic in the 
 * :                                           |       | FPGA fabric can disable the HPS JTAG.          
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF
 * 
 * JTAG enable interface is disabled. Logic in the FPGA fabric cannot disable the
 * HPS JTAG.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF
 * 
 * JTAG enable interface is enabled. Logic in the FPGA fabric can disable the HPS
 * JTAG.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_E_EN   0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_MSB        1
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_JTAGENINTF_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : CONFIG_IO Interface - configiointf
 * 
 * Used to disable the CONFIG_IO interface. This interface allows the FPGA JTAG TAP
 * controller to execute the CONFIG_IO instruction and configure all device I/Os
 * (FPGA and HPS). This is typically done before executing boundary-scan
 * instructions. The CONFIG_IO interface must be enabled before attempting to send
 * the CONFIG_IO instruction to the FPGA JTAG TAP controller.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                     
 * :------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_E_DIS | 0x0   | CONFIG_IO interface is disabled. Execution of   
 * :                                          |       | the CONFIG_IO instruction in the FPGA JTAG TAP  
 * :                                          |       | controller is unsupported and produces undefined
 * :                                          |       | results.                                        
 *  ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_E_EN  | 0x1   | CONFIG_IO interface is enabled. Execution of the
 * :                                          |       | CONFIG_IO instruction in the FPGA JTAG TAP      
 * :                                          |       | controller is supported.                        
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF
 * 
 * CONFIG_IO interface is disabled. Execution of the CONFIG_IO instruction in the
 * FPGA JTAG TAP controller is unsupported and produces undefined results.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF
 * 
 * CONFIG_IO interface is enabled. Execution of the CONFIG_IO instruction in the
 * FPGA JTAG TAP controller is supported.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_MSB        2
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CFGIOINTF_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Boundary-Scan Interface - bscanintf
 * 
 * Used to disable the boundary-scan interface. This interface allows the FPGA JTAG
 * TAP controller to execute boundary-scan instructions such as SAMPLE/PRELOAD,
 * EXTEST, and HIGHZ. The boundary-scan interface must be enabled before attempting
 * to send the boundary-scan instructions to the FPGA JTAG TAP controller.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                     
 * :------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_E_DIS | 0x0   | Boundary-scan interface is disabled. Execution  
 * :                                          |       | of boundary-scan instructions in the FPGA JTAG  
 * :                                          |       | TAP controller is unsupported and produces      
 * :                                          |       | undefined results.                              
 *  ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_E_EN  | 0x1   | Boundary-scan interface is enabled. Execution of
 * :                                          |       | the boundary-scan instructions in the FPGA JTAG 
 * :                                          |       | TAP controller is supported.                    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF
 * 
 * Boundary-scan interface is disabled. Execution of boundary-scan instructions in
 * the FPGA JTAG TAP controller is unsupported and produces undefined results.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF
 * 
 * Boundary-scan interface is enabled. Execution of the boundary-scan instructions
 * in the FPGA JTAG TAP controller is supported.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_MSB        3
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_BSCANINTF_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Trace Interface - traceintf
 * 
 * Used to disable the trace interface. This interface allows the HPS debug logic
 * to send trace data to logic in the FPGA fabric.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                   
 * :------------------------------------------|:------|:-----------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_E_DIS | 0x0   | Trace interface is disabled.  HPS debug logic 
 * :                                          |       | cannot send trace data to the FPGA fabric.    
 *  ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_E_EN  | 0x1   | Trace interface is enabled. Other registers in
 * :                                          |       | the HPS debug logic must be programmmed to    
 * :                                          |       | actually send trace data to the FPGA fabric.  
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF
 * 
 * Trace interface is disabled.  HPS debug logic cannot send trace data to the FPGA
 * fabric.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF
 * 
 * Trace interface is enabled. Other registers in the HPS debug logic must be
 * programmmed to actually send trace data to the FPGA fabric.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_MSB        4
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_TRACEINTF_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : STM Event Interface - stmeventintf
 * 
 * Used to disable the STM event interface. This interface allows logic in the FPGA
 * fabric to trigger events to the STM debug module in the HPS.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                                   
 * :---------------------------------------------|:------|:-----------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_E_DIS | 0x0   | STM event interface is disabled.  Logic in the
 * :                                             |       | FPGA fabric cannot trigger STM events.        
 *  ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_E_EN  | 0x1   | STM event interface is enabled.  Logic in the 
 * :                                             |       | FPGA fabric can trigger STM events.           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF
 * 
 * STM event interface is disabled.  Logic in the FPGA fabric cannot trigger STM
 * events.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_E_DIS    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF
 * 
 * STM event interface is enabled.  Logic in the FPGA fabric can trigger STM
 * events.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_E_EN     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_MSB        6
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_STMEVENTINTF_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : Cross Trigger Interface (CTI) - crosstrigintf
 * 
 * Used to disable the FPGA Fabric from sending triggers to HPS debug logic.  Note
 * that this doesn't prevent the HPS debug logic from sending triggers to the FPGA
 * Fabric.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                          | Value | Description                      
 * :----------------------------------------------|:------|:----------------------------------
 *  ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_E_DIS | 0x0   | FPGA Fabric cannot send triggers.
 *  ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_E_EN  | 0x1   | FPGA Fabric can send triggers.   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF
 * 
 * FPGA Fabric cannot send triggers.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF
 * 
 * FPGA Fabric can send triggers.
 */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_MSB        7
/* The width in bits of the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field value. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_RESET      0x1
/* Extracts the ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF field value from a register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_INDIV_CROSSTRIGINTF_SET(value) (((value) << 7) & 0x00000080)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FPGAINTF_INDIV.
 */
struct ALT_SYSMGR_FPGAINTF_INDIV_s
{
    uint32_t  rstreqintf    :  1;  /* Reset Request Interface */
    uint32_t  jtagenintf    :  1;  /* JTAG Enable Interface */
    uint32_t  configiointf  :  1;  /* CONFIG_IO Interface */
    uint32_t  bscanintf     :  1;  /* Boundary-Scan Interface */
    uint32_t  traceintf     :  1;  /* Trace Interface */
    uint32_t                :  1;  /* *UNDEFINED* */
    uint32_t  stmeventintf  :  1;  /* STM Event Interface */
    uint32_t  crosstrigintf :  1;  /* Cross Trigger Interface (CTI) */
    uint32_t                : 24;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FPGAINTF_INDIV. */
typedef volatile struct ALT_SYSMGR_FPGAINTF_INDIV_s  ALT_SYSMGR_FPGAINTF_INDIV_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FPGAINTF_INDIV register from the beginning of the component. */
#define ALT_SYSMGR_FPGAINTF_INDIV_OFST        0x4

/*
 * Register : Module Disable Register - module
 * 
 * Used to disable signals from the FPGA fabric to individual HPS modules.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [1:0]  | ???    | 0x0   | *UNDEFINED*
 *  [2]    | RW     | 0x0   | EMAC Module
 *  [3]    | RW     | 0x0   | EMAC Module
 *  [31:4] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : EMAC Module - emac_0
 * 
 * Used to disable signals from the FPGA fabric to the EMAC modules that could
 * potentially interfere with their normal operation.
 * 
 * The array index corresponds to the EMAC module instance.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                     
 * :----------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_E_DIS | 0x0   | Signals from FPGA fabric cannot affect operation
 * :                                        |       | of the EMAC module.                             
 *  ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_E_EN  | 0x1   | Signals from FPGA fabric can potentially affect 
 * :                                        |       | operation of the EMAC module.                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0
 * 
 * Signals from FPGA fabric cannot affect operation of the EMAC module.
 */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_E_DIS 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0
 * 
 * Signals from FPGA fabric can potentially affect operation of the EMAC module.
 */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_E_EN  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_MSB        2
/* The width in bits of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field value. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field value. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_RESET      0x0
/* Extracts the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 field value from a register. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_0_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : EMAC Module - emac_1
 * 
 * Used to disable signals from the FPGA fabric to the EMAC modules that could
 * potentially interfere with their normal operation.
 * 
 * The array index corresponds to the EMAC module instance.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                     
 * :----------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_E_DIS | 0x0   | Signals from FPGA fabric cannot affect operation
 * :                                        |       | of the EMAC module.                             
 *  ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_E_EN  | 0x1   | Signals from FPGA fabric can potentially affect 
 * :                                        |       | operation of the EMAC module.                   
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1
 * 
 * Signals from FPGA fabric cannot affect operation of the EMAC module.
 */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_E_DIS 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1
 * 
 * Signals from FPGA fabric can potentially affect operation of the EMAC module.
 */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_E_EN  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_MSB        3
/* The width in bits of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field value. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field value. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_RESET      0x0
/* Extracts the ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 field value from a register. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_FPGAINTF_MODULE_EMAC_1_SET(value) (((value) << 3) & 0x00000008)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FPGAINTF_MODULE.
 */
struct ALT_SYSMGR_FPGAINTF_MODULE_s
{
    uint32_t         :  2;  /* *UNDEFINED* */
    uint32_t  emac_0 :  1;  /* EMAC Module */
    uint32_t  emac_1 :  1;  /* EMAC Module */
    uint32_t         : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FPGAINTF_MODULE. */
typedef volatile struct ALT_SYSMGR_FPGAINTF_MODULE_s  ALT_SYSMGR_FPGAINTF_MODULE_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FPGAINTF_MODULE register from the beginning of the component. */
#define ALT_SYSMGR_FPGAINTF_MODULE_OFST        0x8

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_FPGAINTF.
 */
struct ALT_SYSMGR_FPGAINTF_s
{
    volatile ALT_SYSMGR_FPGAINTF_GBL_t     gbl;            /* ALT_SYSMGR_FPGAINTF_GBL */
    volatile ALT_SYSMGR_FPGAINTF_INDIV_t   indiv;          /* ALT_SYSMGR_FPGAINTF_INDIV */
    volatile ALT_SYSMGR_FPGAINTF_MODULE_t  module;         /* ALT_SYSMGR_FPGAINTF_MODULE */
    volatile uint32_t                      _pad_0xc_0x10;  /* *UNDEFINED* */
};

/* The typedef declaration for register group ALT_SYSMGR_FPGAINTF. */
typedef volatile struct ALT_SYSMGR_FPGAINTF_s  ALT_SYSMGR_FPGAINTF_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_FPGAINTF. */
struct ALT_SYSMGR_FPGAINTF_raw_s
{
    volatile uint32_t  gbl;            /* ALT_SYSMGR_FPGAINTF_GBL */
    volatile uint32_t  indiv;          /* ALT_SYSMGR_FPGAINTF_INDIV */
    volatile uint32_t  module;         /* ALT_SYSMGR_FPGAINTF_MODULE */
    volatile uint32_t  _pad_0xc_0x10;  /* *UNDEFINED* */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_FPGAINTF. */
typedef volatile struct ALT_SYSMGR_FPGAINTF_raw_s  ALT_SYSMGR_FPGAINTF_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Scan Manager Group - ALT_SYSMGR_SCANMGR
 * Scan Manager Group
 * 
 * Registers related to the Scan Manager that aren't located inside the Scan
 * Manager itself.
 * 
 */
/*
 * Register : Scan Manager Control Register - ctrl
 * 
 * Controls behaviors of Scan Manager not controlled by registers in the Scan
 * Manager itself.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description     
 * :-------|:-------|:------|:-----------------
 *  [0]    | RW     | 0x0   | FPGA JTAG Enable
 *  [31:1] | ???    | 0x0   | *UNDEFINED*     
 * 
 */
/*
 * Field : FPGA JTAG Enable - fpgajtagen
 * 
 * Controls whether FPGA JTAG pins or Scan Manager drives JTAG signals to the FPGA.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                         | Value | Description                              
 * :---------------------------------------------|:------|:------------------------------------------
 *  ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_E_FPGAPINS | 0x0   | FPGA JTAG pins drive JTAG signals to FPGA
 *  ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_E_SCANMGR  | 0x1   | Scan Manager drives JTAG signals to FPGA 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN
 * 
 * FPGA JTAG pins drive JTAG signals to FPGA
 */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_E_FPGAPINS    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN
 * 
 * Scan Manager drives JTAG signals to FPGA
 */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_E_SCANMGR     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_MSB        0
/* The width in bits of the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field value. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field value. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_RESET      0x0
/* Extracts the ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN field value from a register. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN register field value suitable for setting the register. */
#define ALT_SYSMGR_SCANMGR_CTL_FPGAJTAGEN_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_SCANMGR_CTL.
 */
struct ALT_SYSMGR_SCANMGR_CTL_s
{
    uint32_t  fpgajtagen :  1;  /* FPGA JTAG Enable */
    uint32_t             : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_SCANMGR_CTL. */
typedef volatile struct ALT_SYSMGR_SCANMGR_CTL_s  ALT_SYSMGR_SCANMGR_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_SCANMGR_CTL register from the beginning of the component. */
#define ALT_SYSMGR_SCANMGR_CTL_OFST        0x0

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_SCANMGR.
 */
struct ALT_SYSMGR_SCANMGR_s
{
    volatile ALT_SYSMGR_SCANMGR_CTL_t  ctrl;  /* ALT_SYSMGR_SCANMGR_CTL */
};

/* The typedef declaration for register group ALT_SYSMGR_SCANMGR. */
typedef volatile struct ALT_SYSMGR_SCANMGR_s  ALT_SYSMGR_SCANMGR_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_SCANMGR. */
struct ALT_SYSMGR_SCANMGR_raw_s
{
    volatile uint32_t  ctrl;  /* ALT_SYSMGR_SCANMGR_CTL */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_SCANMGR. */
typedef volatile struct ALT_SYSMGR_SCANMGR_raw_s  ALT_SYSMGR_SCANMGR_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Freeze Control Group - ALT_SYSMGR_FRZCTL
 * Freeze Control Group
 * 
 * Registers used to generate HPS IO freeze signals.
 * 
 * All registers are only reset by a cold reset (ignore warm reset).
 * 
 */
/*
 * Register : VIO Control Register - vioctrl
 * 
 * Used to drive freeze signals to HPS VIO banks.
 * 
 * The register array index corresponds to the freeze channel.
 * 
 * Freeze channel 0 provides freeze signals to VIO bank 0 and 1.
 * 
 * Freeze channel 1 provides freeze signals to VIO bank 2 and 3. Only drives freeze
 * signals when SRC.VIO1 is set to SW.
 * 
 * Freeze channel 2 provides freeze signals to VIO bank 4.
 * 
 * All fields are only reset by a cold reset (ignore warm reset).
 * 
 * The following equation determines when the weak pullup resistor is enabled:
 * 
 * enabled = ~wkpullup | (CFF & cfg & tristate)
 * 
 * where CFF is the value of weak pullup as set by IO configuration
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description     
 * :-------|:-------|:------|:-----------------
 *  [0]    | RW     | 0x0   | IO Configuration
 *  [1]    | RW     | 0x0   | IO Bus Hold     
 *  [2]    | RW     | 0x0   | IO Tri-State    
 *  [3]    | RW     | 0x0   | IO Weak Pullup  
 *  [4]    | RW     | 0x0   | IO Slew-rate    
 *  [31:5] | ???    | 0x0   | *UNDEFINED*     
 * 
 */
/*
 * Field : IO Configuration - cfg
 * 
 * Controls IO configuration
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                   
 * :-----------------------------------|:------|:-----------------------------------------------
 *  ALT_SYSMGR_FRZCTL_VIOCTL_CFG_E_DIS | 0x0   | Disable IO configuration (forced to a safe    
 * :                                   |       | value).                                       
 *  ALT_SYSMGR_FRZCTL_VIOCTL_CFG_E_CFG | 0x1   | Enables IO configuration as previously        
 * :                                   |       | configured by software using the Scan Manager.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_CFG
 * 
 * Disable IO configuration (forced to a safe value).
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_CFG
 * 
 * Enables IO configuration as previously configured by software using the Scan
 * Manager.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_E_CFG  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_MSB        0
/* The width in bits of the ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_VIOCTL_CFG field value from a register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_FRZCTL_VIOCTL_CFG register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_CFG_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : IO Bus Hold - bushold
 * 
 * Controls bus hold circuit
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                     
 * :---------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_E_DIS | 0x0   | Disable bus hold circuit.                       
 *  ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_E_CFG | 0x1   | Bus hold circuit controlled by IO configuration.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD
 * 
 * Disable bus hold circuit.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD
 * 
 * Bus hold circuit controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_E_CFG  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_MSB        1
/* The width in bits of the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD field value from a register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_BUSHOLD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : IO Tri-State - tristate
 * 
 * Controls IO tri-state
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                 
 * :----------------------------------------|:------|:---------------------------------------------
 *  ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_E_EN  | 0x0   | IO tri-state enabled.                       
 *  ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_E_CFG | 0x1   | IO tri-state controlled by IO configuration.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE
 * 
 * IO tri-state enabled.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_E_EN  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE
 * 
 * IO tri-state controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_E_CFG 0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_MSB        2
/* The width in bits of the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE field value from a register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_TRISTATE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : IO Weak Pullup - wkpullup
 * 
 * Controls weak pullup resistor
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                 
 * :----------------------------------------|:------|:---------------------------------------------
 *  ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_E_EN  | 0x0   | Weak pullup resistor enabled.               
 *  ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_E_CFG | 0x1   | Weak pullup resistor enable controlled by IO
 * :                                        |       | configuration.                              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP
 * 
 * Weak pullup resistor enabled.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_E_EN  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP
 * 
 * Weak pullup resistor enable controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_E_CFG 0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_MSB        3
/* The width in bits of the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP field value from a register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_WKPULLUP_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : IO Slew-rate - slew
 * 
 * Controls IO slew-rate
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                              
 * :-------------------------------------|:------|:------------------------------------------
 *  ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_E_SLOW | 0x0   | Slew-rate forced to slow.                
 *  ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_E_CFG  | 0x1   | Slew-rate controlled by IO configuration.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_SLEW
 * 
 * Slew-rate forced to slow.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_E_SLOW    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_VIOCTL_SLEW
 * 
 * Slew-rate controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_E_CFG     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_MSB        4
/* The width in bits of the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field value. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_VIOCTL_SLEW field value from a register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_FRZCTL_VIOCTL_SLEW register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_SLEW_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FRZCTL_VIOCTL.
 */
struct ALT_SYSMGR_FRZCTL_VIOCTL_s
{
    uint32_t  cfg      :  1;  /* IO Configuration */
    uint32_t  bushold  :  1;  /* IO Bus Hold */
    uint32_t  tristate :  1;  /* IO Tri-State */
    uint32_t  wkpullup :  1;  /* IO Weak Pullup */
    uint32_t  slew     :  1;  /* IO Slew-rate */
    uint32_t           : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FRZCTL_VIOCTL. */
typedef volatile struct ALT_SYSMGR_FRZCTL_VIOCTL_s  ALT_SYSMGR_FRZCTL_VIOCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FRZCTL_VIOCTL register from the beginning of the component. */
#define ALT_SYSMGR_FRZCTL_VIOCTL_OFST        0x0

/*
 * Register : HIO Control Register - hioctrl
 * 
 * Used to drive freeze signals to HPS HIO bank (DDR SDRAM).
 * 
 * All fields are only reset by a cold reset (ignore warm reset).
 * 
 * The following equation determines when the weak pullup resistor is enabled:
 * 
 * enabled = ~wkpullup | (CFF & cfg & tristate)
 * 
 * where CFF is the value of weak pullup as set by IO configuration
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                             
 * :-------|:-------|:------|:-----------------------------------------
 *  [0]    | RW     | 0x0   | IO Configuration                        
 *  [1]    | RW     | 0x0   | IO Bus Hold                             
 *  [2]    | RW     | 0x0   | IO Tri-State                            
 *  [3]    | RW     | 0x0   | IO Weak Pullup                          
 *  [4]    | RW     | 0x0   | IO Slew-rate                            
 *  [5]    | RW     | 0x1   | DLL Reset                               
 *  [6]    | RW     | 0x1   | OCT Reset                               
 *  [7]    | RW     | 0x1   | IO and DQS Reset                        
 *  [8]    | RW     | 0x0   | OCT Calibration and Configuration Enable
 *  [31:9] | ???    | 0x0   | *UNDEFINED*                             
 * 
 */
/*
 * Field : IO Configuration - cfg
 * 
 * Controls IO configuration
 * 
 * Field Enumeration Values:
 * 
 *  Enum                               | Value | Description                                   
 * :-----------------------------------|:------|:-----------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_CFG_E_DIS | 0x0   | Disable IO configuration (forced to a safe    
 * :                                   |       | value).                                       
 *  ALT_SYSMGR_FRZCTL_HIOCTL_CFG_E_CFG | 0x1   | Enables IO configuration as previously        
 * :                                   |       | configured by software using the Scan Manager.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_CFG
 * 
 * Disable IO configuration (forced to a safe value).
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_CFG
 * 
 * Enables IO configuration as previously configured by software using the Scan
 * Manager.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_E_CFG  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_MSB        0
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_CFG field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_CFG register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_CFG_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : IO Bus Hold - bushold
 * 
 * Controls bus hold circuit
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                   | Value | Description                                     
 * :---------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_E_DIS | 0x0   | Disable bus hold circuit.                       
 *  ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_E_CFG | 0x1   | Bus hold circuit controlled by IO configuration.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD
 * 
 * Disable bus hold circuit.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_E_DIS  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD
 * 
 * Bus hold circuit controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_E_CFG  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_MSB        1
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_BUSHOLD_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : IO Tri-State - tristate
 * 
 * Controls IO tri-state
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                 
 * :----------------------------------------|:------|:---------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_E_EN  | 0x0   | IO tri-state enabled.                       
 *  ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_E_CFG | 0x1   | IO tri-state controlled by IO configuration.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE
 * 
 * IO tri-state enabled.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_E_EN  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE
 * 
 * IO tri-state controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_E_CFG 0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_MSB        2
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_TRISTATE_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : IO Weak Pullup - wkpullup
 * 
 * Controls weak pullup resistor
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                                 
 * :----------------------------------------|:------|:---------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_E_EN  | 0x0   | Weak pullup resistor enabled.               
 *  ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_E_CFG | 0x1   | Weak pullup resistor enable controlled by IO
 * :                                        |       | configuration.                              
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP
 * 
 * Weak pullup resistor enabled.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_E_EN  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP
 * 
 * Weak pullup resistor enable controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_E_CFG 0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_MSB        3
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_WKPULLUP_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : IO Slew-rate - slew
 * 
 * Controls IO slew-rate
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                              
 * :-------------------------------------|:------|:------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_E_SLOW | 0x0   | Slew-rate forced to slow.                
 *  ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_E_CFG  | 0x1   | Slew-rate controlled by IO configuration.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_SLEW
 * 
 * Slew-rate forced to slow.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_E_SLOW    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_SLEW
 * 
 * Slew-rate controlled by IO configuration.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_E_CFG     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_MSB        4
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_SLEW field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_SLEW register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_SLEW_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : DLL Reset - dllrst
 * 
 * Controls DLL (Delay-Locked Loop) reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                                  
 * :--------------------------------------|:------|:----------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_E_DIS | 0x0   | No reset or clock gating.                    
 *  ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_E_EN  | 0x1   | Resets registers in the DLL and gates off DLL
 * :                                      |       | clock.                                       
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST
 * 
 * No reset or clock gating.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST
 * 
 * Resets registers in the DLL and gates off DLL clock.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_MSB        5
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_RESET      0x1
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_DLLRST_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : OCT Reset - octrst
 * 
 * Controls OCT reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                 
 * :--------------------------------------|:------|:-----------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_E_DIS | 0x0   | No reset.                   
 *  ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_E_EN  | 0x1   | Resets registers in the OCT.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST
 * 
 * No reset.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST
 * 
 * Resets registers in the OCT.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_MSB        6
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_RESET      0x1
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCTRST_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : IO and DQS Reset - regrst
 * 
 * Controls IO and DQS reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                  | Value | Description                               
 * :--------------------------------------|:------|:-------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_E_DIS | 0x0   | No reset.                                 
 *  ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_E_EN  | 0x1   | Resets all IO registers and DQS registers.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_REGRST
 * 
 * No reset.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_REGRST
 * 
 * Resets all IO registers and DQS registers.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_MSB        7
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_RESET      0x1
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_REGRST field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_REGRST register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_REGRST_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : OCT Calibration and Configuration Enable - oct_cfgen_calstart
 * 
 * Controls OCT calibration and OCT IO configuration enable.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description                                     
 * :--------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_E_DIS | 0x0   | Disables IO configuration (forced to a safe     
 * :                                                  |       | value) in OCT calibration block.                
 *  ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_E_EN  | 0x1   | Starts OCT calibration state machine and enables
 * :                                                  |       | IO configuration in OCT calibration block.      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART
 * 
 * Disables IO configuration (forced to a safe value) in OCT calibration block.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_E_DIS   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART
 * 
 * Starts OCT calibration state machine and enables IO configuration in OCT
 * calibration block.
 */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_E_EN    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_MSB        8
/* The width in bits of the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_SET_MSK    0x00000100
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field value. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_CLR_MSK    0xfffffeff
/* The reset value of the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART field value from a register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OCT_CFGEN_CALSTART_SET(value) (((value) << 8) & 0x00000100)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FRZCTL_HIOCTL.
 */
struct ALT_SYSMGR_FRZCTL_HIOCTL_s
{
    uint32_t  cfg                :  1;  /* IO Configuration */
    uint32_t  bushold            :  1;  /* IO Bus Hold */
    uint32_t  tristate           :  1;  /* IO Tri-State */
    uint32_t  wkpullup           :  1;  /* IO Weak Pullup */
    uint32_t  slew               :  1;  /* IO Slew-rate */
    uint32_t  dllrst             :  1;  /* DLL Reset */
    uint32_t  octrst             :  1;  /* OCT Reset */
    uint32_t  regrst             :  1;  /* IO and DQS Reset */
    uint32_t  oct_cfgen_calstart :  1;  /* OCT Calibration and Configuration Enable */
    uint32_t                     : 23;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FRZCTL_HIOCTL. */
typedef volatile struct ALT_SYSMGR_FRZCTL_HIOCTL_s  ALT_SYSMGR_FRZCTL_HIOCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FRZCTL_HIOCTL register from the beginning of the component. */
#define ALT_SYSMGR_FRZCTL_HIOCTL_OFST        0x10

/*
 * Register : Source Register - src
 * 
 * Contains register field to choose between software state machine (vioctrl array
 * index [1] register) or hardware state machine in the Freeze Controller as the
 * freeze signal source for VIO channel 1.
 * 
 * All fields are only reset by a cold reset (ignore warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description              
 * :-------|:-------|:------|:--------------------------
 *  [0]    | RW     | 0x0   | VIO1 Freeze Signal Source
 *  [31:1] | ???    | 0x0   | *UNDEFINED*              
 * 
 */
/*
 * Field : VIO1 Freeze Signal Source - vio1
 * 
 * The freeze signal source for VIO channel 1 (VIO bank 2 and bank 3).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                            | Value | Description                                     
 * :--------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FRZCTL_SRC_VIO1_E_SW | 0x0   | VIO1 freeze signals are driven by software      
 * :                                |       | writing to the VIOCTRL[1] register. The         
 * :                                |       | VIO1-related fields in the hwctrl register are  
 * :                                |       | active but don't effect the VIO1 freeze signals.
 *  ALT_SYSMGR_FRZCTL_SRC_VIO1_E_HW | 0x1   | VIO1 freeze signals are driven by the hardware  
 * :                                |       | state machine in the Freeze Controller. The     
 * :                                |       | VIO1-related fields in the hwctrl register are  
 * :                                |       | active and effect the VIO1 freeze signals.      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_SRC_VIO1
 * 
 * VIO1 freeze signals are driven by software writing to the VIOCTRL[1] register.
 * The VIO1-related fields in the hwctrl register are active but don't effect the
 * VIO1 freeze signals.
 */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_E_SW 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_SRC_VIO1
 * 
 * VIO1 freeze signals are driven by the hardware state machine in the Freeze
 * Controller. The VIO1-related fields in the hwctrl register are active and effect
 * the VIO1 freeze signals.
 */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_E_HW 0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_SRC_VIO1 register field. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_SRC_VIO1 register field. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_MSB        0
/* The width in bits of the ALT_SYSMGR_FRZCTL_SRC_VIO1 register field. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_SRC_VIO1 register field value. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_FRZCTL_SRC_VIO1 register field value. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_FRZCTL_SRC_VIO1 register field. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_RESET      0x0
/* Extracts the ALT_SYSMGR_FRZCTL_SRC_VIO1 field value from a register. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_FRZCTL_SRC_VIO1 register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_SRC_VIO1_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FRZCTL_SRC.
 */
struct ALT_SYSMGR_FRZCTL_SRC_s
{
    uint32_t  vio1 :  1;  /* VIO1 Freeze Signal Source */
    uint32_t       : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FRZCTL_SRC. */
typedef volatile struct ALT_SYSMGR_FRZCTL_SRC_s  ALT_SYSMGR_FRZCTL_SRC_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FRZCTL_SRC register from the beginning of the component. */
#define ALT_SYSMGR_FRZCTL_SRC_OFST        0x14

/*
 * Register : Hardware Control Register - hwctrl
 * 
 * Activate freeze or thaw operations on VIO channel 1 (HPS IO bank 2 and bank 3)
 * and monitor for completeness and the current state.
 * 
 * These fields interact with the hardware state machine in the Freeze Controller.
 * These fields can be accessed independent of the value of SRC1.VIO1 although they
 * only have an effect on the VIO channel 1 freeze signals when SRC1.VIO1 is setup
 * to have the hardware state machine be the freeze signal source.
 * 
 * All fields are only reset by a cold reset (ignore warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                      
 * :-------|:-------|:------|:----------------------------------
 *  [0]    | RW     | 0x1   | VIO channel 1 Freeze/Thaw request
 *  [2:1]  | R      | 0x2   | VIO channel 1 State              
 *  [31:3] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : VIO channel 1 Freeze/Thaw request - vio1req
 * 
 * Requests hardware state machine to generate freeze signal sequence to transition
 * between frozen and thawed states.
 * 
 * If this field is read by software, it contains the value previously written by
 * software (i.e. this field is not written by hardware).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                          
 * :------------------------------------------|:------|:--------------------------------------
 *  ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_E_REQTHAW | 0x0   | Requests a thaw (unfreeze) operation.
 *  ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_E_REQFRZ  | 0x1   | Requests a freeze operation.         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ
 * 
 * Requests a thaw (unfreeze) operation.
 */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_E_REQTHAW   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ
 * 
 * Requests a freeze operation.
 */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_E_REQFRZ    0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_MSB        0
/* The width in bits of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_WIDTH      1
/* The mask used to set the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field value. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field value. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_RESET      0x1
/* Extracts the ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ field value from a register. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1REQ_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : VIO channel 1 State - vio1state
 * 
 * Software reads this field to determine the current frozen/thawed state of the
 * VIO channel 1 or to determine when a freeze/thaw request is made by writing the
 * corresponding *REQ field in this register has completed.
 * 
 * Reset by a cold reset (ignores warm reset).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                              | Value | Description                                     
 * :--------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_THAWED2FROZEN | 0x0   | Transitioning from thawed state to frozen state.
 *  ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_THAWED        | 0x1   | Thawed state. I/Os behave as configured. I/Os   
 * :                                                  |       | must be configured by the Scan Manager before   
 * :                                                  |       | entering this state.                            
 *  ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_FROZEN        | 0x2   | Frozen state. I/O configuration is ignored.     
 * :                                                  |       | Instead, I/Os are in tri-state mode with a weak 
 * :                                                  |       | pull-up. Scan Manager can be used to configure  
 * :                                                  |       | the I/Os while they are frozen.                 
 *  ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_FROZEN2THAWED | 0x3   | Transitioning from frozen state to thawed state.
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE
 * 
 * Transitioning from thawed state to frozen state.
 */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_THAWED2FROZEN   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE
 * 
 * Thawed state. I/Os behave as configured. I/Os must be configured by the Scan
 * Manager before entering this state.
 */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_THAWED          0x1
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE
 * 
 * Frozen state. I/O configuration is ignored. Instead, I/Os are in tri-state mode
 * with a weak pull-up. Scan Manager can be used to configure the I/Os while they
 * are frozen.
 */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_FROZEN          0x2
/*
 * Enumerated value for register field ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE
 * 
 * Transitioning from frozen state to thawed state.
 */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_E_FROZEN2THAWED   0x3

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_MSB        2
/* The width in bits of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_WIDTH      2
/* The mask used to set the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field value. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_SET_MSK    0x00000006
/* The mask used to clear the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field value. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_CLR_MSK    0xfffffff9
/* The reset value of the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_RESET      0x2
/* Extracts the ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE field value from a register. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_GET(value) (((value) & 0x00000006) >> 1)
/* Produces a ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE register field value suitable for setting the register. */
#define ALT_SYSMGR_FRZCTL_HWCTL_VIO1STATE_SET(value) (((value) << 1) & 0x00000006)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_FRZCTL_HWCTL.
 */
struct ALT_SYSMGR_FRZCTL_HWCTL_s
{
    uint32_t        vio1req   :  1;  /* VIO channel 1 Freeze/Thaw request */
    const uint32_t  vio1state :  2;  /* VIO channel 1 State */
    uint32_t                  : 29;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_FRZCTL_HWCTL. */
typedef volatile struct ALT_SYSMGR_FRZCTL_HWCTL_s  ALT_SYSMGR_FRZCTL_HWCTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_FRZCTL_HWCTL register from the beginning of the component. */
#define ALT_SYSMGR_FRZCTL_HWCTL_OFST        0x18

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_FRZCTL.
 */
struct ALT_SYSMGR_FRZCTL_s
{
    volatile ALT_SYSMGR_FRZCTL_VIOCTL_t  vioctrl[3];      /* ALT_SYSMGR_FRZCTL_VIOCTL */
    volatile uint32_t                    _pad_0xc_0xf;    /* *UNDEFINED* */
    volatile ALT_SYSMGR_FRZCTL_HIOCTL_t  hioctrl;         /* ALT_SYSMGR_FRZCTL_HIOCTL */
    volatile ALT_SYSMGR_FRZCTL_SRC_t     src;             /* ALT_SYSMGR_FRZCTL_SRC */
    volatile ALT_SYSMGR_FRZCTL_HWCTL_t   hwctrl;          /* ALT_SYSMGR_FRZCTL_HWCTL */
    volatile uint32_t                    _pad_0x1c_0x20;  /* *UNDEFINED* */
};

/* The typedef declaration for register group ALT_SYSMGR_FRZCTL. */
typedef volatile struct ALT_SYSMGR_FRZCTL_s  ALT_SYSMGR_FRZCTL_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_FRZCTL. */
struct ALT_SYSMGR_FRZCTL_raw_s
{
    volatile uint32_t  vioctrl[3];      /* ALT_SYSMGR_FRZCTL_VIOCTL */
    volatile uint32_t  _pad_0xc_0xf;    /* *UNDEFINED* */
    volatile uint32_t  hioctrl;         /* ALT_SYSMGR_FRZCTL_HIOCTL */
    volatile uint32_t  src;             /* ALT_SYSMGR_FRZCTL_SRC */
    volatile uint32_t  hwctrl;          /* ALT_SYSMGR_FRZCTL_HWCTL */
    volatile uint32_t  _pad_0x1c_0x20;  /* *UNDEFINED* */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_FRZCTL. */
typedef volatile struct ALT_SYSMGR_FRZCTL_raw_s  ALT_SYSMGR_FRZCTL_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : EMAC Group - ALT_SYSMGR_EMAC
 * EMAC Group
 * 
 * External control registers for the EMACs
 * 
 */
/*
 * Register : Control Register - ctrl
 * 
 * Registers used by the EMACs. All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description         
 * :-------|:-------|:------|:---------------------
 *  [1:0]  | RW     | 0x2   | PHY Interface Select
 *  [3:2]  | RW     | 0x2   | PHY Interface Select
 *  [4]    | RW     | 0x0   | PTP Clock Select    
 *  [5]    | RW     | 0x0   | PTP Clock Select    
 *  [31:6] | ???    | 0x0   | *UNDEFINED*         
 * 
 */
/*
 * Field : PHY Interface Select - physel_0
 * 
 * Controls the PHY interface selection of the EMACs. This is sampled by an EMAC
 * module when it exits from reset. The associated enum defines the allowed values.
 * The field array index corresponds to the EMAC index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                  
 * :----------------------------------------|:------|:------------------------------
 *  ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_GMII_MII | 0x0   | Select GMII/MII PHY interface
 *  ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_RGMII    | 0x1   | Select RGMII PHY interface   
 *  ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_RMII     | 0x2   | Select RMII PHY interface    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PHYSEL_0
 * 
 * Select GMII/MII PHY interface
 */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_GMII_MII 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PHYSEL_0
 * 
 * Select RGMII PHY interface
 */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_RGMII    0x1
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PHYSEL_0
 * 
 * Select RMII PHY interface
 */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_E_RMII     0x2

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_MSB        1
/* The width in bits of the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_WIDTH      2
/* The mask used to set the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_RESET      0x2
/* Extracts the ALT_SYSMGR_EMAC_CTL_PHYSEL_0 field value from a register. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_EMAC_CTL_PHYSEL_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_0_SET(value) (((value) << 0) & 0x00000003)

/*
 * Field : PHY Interface Select - physel_1
 * 
 * Controls the PHY interface selection of the EMACs. This is sampled by an EMAC
 * module when it exits from reset. The associated enum defines the allowed values.
 * The field array index corresponds to the EMAC index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                    | Value | Description                  
 * :----------------------------------------|:------|:------------------------------
 *  ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_GMII_MII | 0x0   | Select GMII/MII PHY interface
 *  ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_RGMII    | 0x1   | Select RGMII PHY interface   
 *  ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_RMII     | 0x2   | Select RMII PHY interface    
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PHYSEL_1
 * 
 * Select GMII/MII PHY interface
 */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_GMII_MII 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PHYSEL_1
 * 
 * Select RGMII PHY interface
 */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_RGMII    0x1
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PHYSEL_1
 * 
 * Select RMII PHY interface
 */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_E_RMII     0x2

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_MSB        3
/* The width in bits of the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_WIDTH      2
/* The mask used to set the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_SET_MSK    0x0000000c
/* The mask used to clear the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_CLR_MSK    0xfffffff3
/* The reset value of the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_RESET      0x2
/* Extracts the ALT_SYSMGR_EMAC_CTL_PHYSEL_1 field value from a register. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_GET(value) (((value) & 0x0000000c) >> 2)
/* Produces a ALT_SYSMGR_EMAC_CTL_PHYSEL_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_CTL_PHYSEL_1_SET(value) (((value) << 2) & 0x0000000c)

/*
 * Field : PTP Clock Select - ptpclksel_0
 * 
 * Selects the source of the 1588 PTP reference clock. This is sampled by an EMAC
 * module when it exits from reset. The field array index corresponds to the EMAC
 * index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description             
 * :---------------------------------------------------|:------|:-------------------------
 *  ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_E_OSC1_CLK         | 0x0   | Selects osc1_clk        
 *  ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_E_FPGA_PTP_REF_CLK | 0x1   | Selects fpga_ptp_ref_clk
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0
 * 
 * Selects osc1_clk
 */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_E_OSC1_CLK          0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0
 * 
 * Selects fpga_ptp_ref_clk
 */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_E_FPGA_PTP_REF_CLK  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_MSB        4
/* The width in bits of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_RESET      0x0
/* Extracts the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 field value from a register. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_0_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : PTP Clock Select - ptpclksel_1
 * 
 * Selects the source of the 1588 PTP reference clock. This is sampled by an EMAC
 * module when it exits from reset. The field array index corresponds to the EMAC
 * index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                               | Value | Description             
 * :---------------------------------------------------|:------|:-------------------------
 *  ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_E_OSC1_CLK         | 0x0   | Selects osc1_clk        
 *  ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_E_FPGA_PTP_REF_CLK | 0x1   | Selects fpga_ptp_ref_clk
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1
 * 
 * Selects osc1_clk
 */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_E_OSC1_CLK          0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1
 * 
 * Selects fpga_ptp_ref_clk
 */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_E_FPGA_PTP_REF_CLK  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_MSB        5
/* The width in bits of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field value. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_RESET      0x0
/* Extracts the ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 field value from a register. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_CTL_PTPCLKSEL_1_SET(value) (((value) << 5) & 0x00000020)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_EMAC_CTL.
 */
struct ALT_SYSMGR_EMAC_CTL_s
{
    uint32_t  physel_0    :  2;  /* PHY Interface Select */
    uint32_t  physel_1    :  2;  /* PHY Interface Select */
    uint32_t  ptpclksel_0 :  1;  /* PTP Clock Select */
    uint32_t  ptpclksel_1 :  1;  /* PTP Clock Select */
    uint32_t              : 26;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_EMAC_CTL. */
typedef volatile struct ALT_SYSMGR_EMAC_CTL_s  ALT_SYSMGR_EMAC_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_EMAC_CTL register from the beginning of the component. */
#define ALT_SYSMGR_EMAC_CTL_OFST        0x0

/*
 * Register : EMAC L3 Master AxCACHE Register - l3master
 * 
 * Controls the L3 master ARCACHE and AWCACHE AXI signals.
 * 
 * These register bits should be updated only during system initialization prior to
 * removing the peripheral from reset. They may not be changed dynamically during
 * peripheral operation
 * 
 * All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description 
 * :--------|:-------|:------|:-------------
 *  [3:0]   | RW     | 0x0   | EMAC ARCACHE
 *  [7:4]   | RW     | 0x0   | EMAC ARCACHE
 *  [11:8]  | RW     | 0x0   | EMAC AWCACHE
 *  [15:12] | RW     | 0x0   | EMAC AWCACHE
 *  [31:16] | ???    | 0x0   | *UNDEFINED* 
 * 
 */
/*
 * Field : EMAC ARCACHE - arcache_0
 * 
 * Specifies the values of the 2 EMAC ARCACHE signals.
 * 
 * The field array index corresponds to the EMAC index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                   | Value | Description                                     
 * :-------------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_NONCACHE_NONBUFF     | 0x0   | Noncacheable and nonbufferable.                 
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_BUFF                 | 0x1   | Bufferable only.                                
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_NONALLOC       | 0x2   | Cacheable, but do not allocate.                 
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_BUFF_NONALLOC  | 0x3   | Cacheable and bufferable, but do not allocate.  
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD1                | 0x4   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD2                | 0x5   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRTHRU_RDALLOC | 0x6   | Cacheable write-through, allocate on reads only.
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRBACK_RDALLOC | 0x7   | Cacheable write-back, allocate on reads only.   
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD3                | 0x8   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD4                | 0x9   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRTHRU_WRALLOC | 0xa   | Cacheable write-through, allocate on writes     
 * :                                                       |       | only.                                           
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRBACK_WRALLOC | 0xb   | Cacheable write-back, allocate on writes only.  
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD5                | 0xc   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD6                | 0xd   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRTHRU_ALLOC   | 0xe   | Cacheable write-through, allocate on both reads 
 * :                                                       |       | and writes.                                     
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRBACK_ALLOC   | 0xf   | Cacheable write-back, allocate on both reads and
 * :                                                       |       | writes.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Noncacheable and nonbufferable.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_NONCACHE_NONBUFF      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Bufferable only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_BUFF                  0x1
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_NONALLOC        0x2
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable and bufferable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_BUFF_NONALLOC   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD1                 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD2                 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable write-through, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRTHRU_RDALLOC  0x6
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable write-back, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRBACK_RDALLOC  0x7
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD3                 0x8
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD4                 0x9
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable write-through, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRTHRU_WRALLOC  0xa
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable write-back, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRBACK_WRALLOC  0xb
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD5                 0xc
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_RSVD6                 0xd
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable write-through, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRTHRU_ALLOC    0xe
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_0
 * 
 * Cacheable write-back, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_E_CACHE_WRBACK_ALLOC    0xf

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_MSB        3
/* The width in bits of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_WIDTH      4
/* The mask used to set the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_SET_MSK    0x0000000f
/* The mask used to clear the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_CLR_MSK    0xfffffff0
/* The reset value of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_RESET      0x0
/* Extracts the ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 field value from a register. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_SYSMGR_EMAC_L3MST_ARCACHE_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_0_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : EMAC ARCACHE - arcache_1
 * 
 * Specifies the values of the 2 EMAC ARCACHE signals.
 * 
 * The field array index corresponds to the EMAC index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                   | Value | Description                                     
 * :-------------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_NONCACHE_NONBUFF     | 0x0   | Noncacheable and nonbufferable.                 
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_BUFF                 | 0x1   | Bufferable only.                                
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_NONALLOC       | 0x2   | Cacheable, but do not allocate.                 
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_BUFF_NONALLOC  | 0x3   | Cacheable and bufferable, but do not allocate.  
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD1                | 0x4   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD2                | 0x5   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRTHRU_RDALLOC | 0x6   | Cacheable write-through, allocate on reads only.
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRBACK_RDALLOC | 0x7   | Cacheable write-back, allocate on reads only.   
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD3                | 0x8   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD4                | 0x9   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRTHRU_WRALLOC | 0xa   | Cacheable write-through, allocate on writes     
 * :                                                       |       | only.                                           
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRBACK_WRALLOC | 0xb   | Cacheable write-back, allocate on writes only.  
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD5                | 0xc   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD6                | 0xd   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRTHRU_ALLOC   | 0xe   | Cacheable write-through, allocate on both reads 
 * :                                                       |       | and writes.                                     
 *  ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRBACK_ALLOC   | 0xf   | Cacheable write-back, allocate on both reads and
 * :                                                       |       | writes.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Noncacheable and nonbufferable.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_NONCACHE_NONBUFF      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Bufferable only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_BUFF                  0x1
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_NONALLOC        0x2
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable and bufferable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_BUFF_NONALLOC   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD1                 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD2                 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable write-through, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRTHRU_RDALLOC  0x6
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable write-back, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRBACK_RDALLOC  0x7
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD3                 0x8
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD4                 0x9
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable write-through, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRTHRU_WRALLOC  0xa
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable write-back, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRBACK_WRALLOC  0xb
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD5                 0xc
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_RSVD6                 0xd
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable write-through, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRTHRU_ALLOC    0xe
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_ARCACHE_1
 * 
 * Cacheable write-back, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_E_CACHE_WRBACK_ALLOC    0xf

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_MSB        7
/* The width in bits of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_WIDTH      4
/* The mask used to set the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_SET_MSK    0x000000f0
/* The mask used to clear the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_CLR_MSK    0xffffff0f
/* The reset value of the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_RESET      0x0
/* Extracts the ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 field value from a register. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_GET(value) (((value) & 0x000000f0) >> 4)
/* Produces a ALT_SYSMGR_EMAC_L3MST_ARCACHE_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_L3MST_ARCACHE_1_SET(value) (((value) << 4) & 0x000000f0)

/*
 * Field : EMAC AWCACHE - awcache_0
 * 
 * Specifies the values of the 2 EMAC AWCACHE signals.
 * 
 * The field array index corresponds to the EMAC index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                   | Value | Description                                     
 * :-------------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_NONCACHE_NONBUFF     | 0x0   | Noncacheable and nonbufferable.                 
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_BUFF                 | 0x1   | Bufferable only.                                
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_NONALLOC       | 0x2   | Cacheable, but do not allocate.                 
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_BUFF_NONALLOC  | 0x3   | Cacheable and bufferable, but do not allocate.  
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD1                | 0x4   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD2                | 0x5   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRTHRU_RDALLOC | 0x6   | Cacheable write-through, allocate on reads only.
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRBACK_RDALLOC | 0x7   | Cacheable write-back, allocate on reads only.   
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD3                | 0x8   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD4                | 0x9   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRTHRU_WRALLOC | 0xa   | Cacheable write-through, allocate on writes     
 * :                                                       |       | only.                                           
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRBACK_WRALLOC | 0xb   | Cacheable write-back, allocate on writes only.  
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD5                | 0xc   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD6                | 0xd   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRTHRU_ALLOC   | 0xe   | Cacheable write-through, allocate on both reads 
 * :                                                       |       | and writes.                                     
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRBACK_ALLOC   | 0xf   | Cacheable write-back, allocate on both reads and
 * :                                                       |       | writes.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Noncacheable and nonbufferable.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_NONCACHE_NONBUFF      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Bufferable only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_BUFF                  0x1
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_NONALLOC        0x2
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable and bufferable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_BUFF_NONALLOC   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD1                 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD2                 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable write-through, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRTHRU_RDALLOC  0x6
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable write-back, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRBACK_RDALLOC  0x7
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD3                 0x8
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD4                 0x9
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable write-through, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRTHRU_WRALLOC  0xa
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable write-back, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRBACK_WRALLOC  0xb
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD5                 0xc
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_RSVD6                 0xd
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable write-through, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRTHRU_ALLOC    0xe
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_0
 * 
 * Cacheable write-back, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_E_CACHE_WRBACK_ALLOC    0xf

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_MSB        11
/* The width in bits of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_WIDTH      4
/* The mask used to set the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_SET_MSK    0x00000f00
/* The mask used to clear the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_CLR_MSK    0xfffff0ff
/* The reset value of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_RESET      0x0
/* Extracts the ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 field value from a register. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_GET(value) (((value) & 0x00000f00) >> 8)
/* Produces a ALT_SYSMGR_EMAC_L3MST_AWCACHE_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_0_SET(value) (((value) << 8) & 0x00000f00)

/*
 * Field : EMAC AWCACHE - awcache_1
 * 
 * Specifies the values of the 2 EMAC AWCACHE signals.
 * 
 * The field array index corresponds to the EMAC index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                   | Value | Description                                     
 * :-------------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_NONCACHE_NONBUFF     | 0x0   | Noncacheable and nonbufferable.                 
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_BUFF                 | 0x1   | Bufferable only.                                
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_NONALLOC       | 0x2   | Cacheable, but do not allocate.                 
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_BUFF_NONALLOC  | 0x3   | Cacheable and bufferable, but do not allocate.  
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD1                | 0x4   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD2                | 0x5   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRTHRU_RDALLOC | 0x6   | Cacheable write-through, allocate on reads only.
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRBACK_RDALLOC | 0x7   | Cacheable write-back, allocate on reads only.   
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD3                | 0x8   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD4                | 0x9   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRTHRU_WRALLOC | 0xa   | Cacheable write-through, allocate on writes     
 * :                                                       |       | only.                                           
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRBACK_WRALLOC | 0xb   | Cacheable write-back, allocate on writes only.  
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD5                | 0xc   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD6                | 0xd   | Reserved.                                       
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRTHRU_ALLOC   | 0xe   | Cacheable write-through, allocate on both reads 
 * :                                                       |       | and writes.                                     
 *  ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRBACK_ALLOC   | 0xf   | Cacheable write-back, allocate on both reads and
 * :                                                       |       | writes.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Noncacheable and nonbufferable.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_NONCACHE_NONBUFF      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Bufferable only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_BUFF                  0x1
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_NONALLOC        0x2
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable and bufferable, but do not allocate.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_BUFF_NONALLOC   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD1                 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD2                 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable write-through, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRTHRU_RDALLOC  0x6
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable write-back, allocate on reads only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRBACK_RDALLOC  0x7
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD3                 0x8
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD4                 0x9
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable write-through, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRTHRU_WRALLOC  0xa
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable write-back, allocate on writes only.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRBACK_WRALLOC  0xb
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD5                 0xc
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Reserved.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_RSVD6                 0xd
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable write-through, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRTHRU_ALLOC    0xe
/*
 * Enumerated value for register field ALT_SYSMGR_EMAC_L3MST_AWCACHE_1
 * 
 * Cacheable write-back, allocate on both reads and writes.
 */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_E_CACHE_WRBACK_ALLOC    0xf

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_MSB        15
/* The width in bits of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_WIDTH      4
/* The mask used to set the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_SET_MSK    0x0000f000
/* The mask used to clear the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field value. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_CLR_MSK    0xffff0fff
/* The reset value of the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_RESET      0x0
/* Extracts the ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 field value from a register. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_GET(value) (((value) & 0x0000f000) >> 12)
/* Produces a ALT_SYSMGR_EMAC_L3MST_AWCACHE_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_EMAC_L3MST_AWCACHE_1_SET(value) (((value) << 12) & 0x0000f000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_EMAC_L3MST.
 */
struct ALT_SYSMGR_EMAC_L3MST_s
{
    uint32_t  arcache_0 :  4;  /* EMAC ARCACHE */
    uint32_t  arcache_1 :  4;  /* EMAC ARCACHE */
    uint32_t  awcache_0 :  4;  /* EMAC AWCACHE */
    uint32_t  awcache_1 :  4;  /* EMAC AWCACHE */
    uint32_t            : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_EMAC_L3MST. */
typedef volatile struct ALT_SYSMGR_EMAC_L3MST_s  ALT_SYSMGR_EMAC_L3MST_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_EMAC_L3MST register from the beginning of the component. */
#define ALT_SYSMGR_EMAC_L3MST_OFST        0x4

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_EMAC.
 */
struct ALT_SYSMGR_EMAC_s
{
    volatile ALT_SYSMGR_EMAC_CTL_t    ctrl;              /* ALT_SYSMGR_EMAC_CTL */
    volatile ALT_SYSMGR_EMAC_L3MST_t  l3master;          /* ALT_SYSMGR_EMAC_L3MST */
    volatile uint32_t                 _pad_0x8_0x10[2];  /* *UNDEFINED* */
};

/* The typedef declaration for register group ALT_SYSMGR_EMAC. */
typedef volatile struct ALT_SYSMGR_EMAC_s  ALT_SYSMGR_EMAC_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_EMAC. */
struct ALT_SYSMGR_EMAC_raw_s
{
    volatile uint32_t  ctrl;              /* ALT_SYSMGR_EMAC_CTL */
    volatile uint32_t  l3master;          /* ALT_SYSMGR_EMAC_L3MST */
    volatile uint32_t  _pad_0x8_0x10[2];  /* *UNDEFINED* */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_EMAC. */
typedef volatile struct ALT_SYSMGR_EMAC_raw_s  ALT_SYSMGR_EMAC_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : DMA Controller Group - ALT_SYSMGR_DMA
 * DMA Controller Group
 * 
 * Registers used by the DMA Controller to enable secured system support and select
 * DMA channels.
 * 
 */
/*
 * Register : Control Register - ctrl
 * 
 * Registers used by the DMA Controller. All fields are reset by a cold or warm
 * reset.
 * 
 * These register bits should be updated during system initialization prior to
 * removing the DMA controller from reset. They may not be changed dynamically
 * during DMA operation.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description            
 * :--------|:-------|:------|:------------------------
 *  [0]     | RW     | 0x0   | Channel Select         
 *  [1]     | RW     | 0x0   | Channel Select         
 *  [2]     | RW     | 0x0   | Channel Select         
 *  [3]     | RW     | 0x0   | Channel Select         
 *  [4]     | RW     | 0x0   | Manager Thread Security
 *  [12:5]  | RW     | 0x0   | IRQ Security           
 *  [31:13] | ???    | 0x0   | *UNDEFINED*            
 * 
 */
/*
 * Field : Channel Select - chansel_0
 * 
 * Controls mux that selects whether FPGA or CAN connects to one of the DMA
 * peripheral request interfaces.The peripheral request interface index equals the
 * array index + 4. For example, array index 0 is for peripheral request index 4.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                             
 * :------------------------------------|:------|:-----------------------------------------
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_0_E_FPGA | 0x0   | FPGA drives peripheral request interface
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_0_E_CAN  | 0x1   | CAN drives peripheral request interface 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_0
 * 
 * FPGA drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_E_FPGA 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_0
 * 
 * CAN drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_E_CAN  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_MSB        0
/* The width in bits of the ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_CTL_CHANSEL_0 field value from a register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_DMA_CTL_CHANSEL_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Channel Select - chansel_1
 * 
 * Controls mux that selects whether FPGA or CAN connects to one of the DMA
 * peripheral request interfaces.The peripheral request interface index equals the
 * array index + 4. For example, array index 0 is for peripheral request index 4.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                             
 * :------------------------------------|:------|:-----------------------------------------
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_1_E_FPGA | 0x0   | FPGA drives peripheral request interface
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_1_E_CAN  | 0x1   | CAN drives peripheral request interface 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_1
 * 
 * FPGA drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_E_FPGA 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_1
 * 
 * CAN drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_E_CAN  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_MSB        1
/* The width in bits of the ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_CTL_CHANSEL_1 field value from a register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_DMA_CTL_CHANSEL_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Channel Select - chansel_2
 * 
 * Controls mux that selects whether FPGA or CAN connects to one of the DMA
 * peripheral request interfaces.The peripheral request interface index equals the
 * array index + 4. For example, array index 0 is for peripheral request index 4.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                             
 * :------------------------------------|:------|:-----------------------------------------
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_2_E_FPGA | 0x0   | FPGA drives peripheral request interface
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_2_E_CAN  | 0x1   | CAN drives peripheral request interface 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_2
 * 
 * FPGA drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_E_FPGA 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_2
 * 
 * CAN drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_E_CAN  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_MSB        2
/* The width in bits of the ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_WIDTH      1
/* The mask used to set the ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_CTL_CHANSEL_2 field value from a register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_DMA_CTL_CHANSEL_2 register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_2_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Channel Select - chansel_3
 * 
 * Controls mux that selects whether FPGA or CAN connects to one of the DMA
 * peripheral request interfaces.The peripheral request interface index equals the
 * array index + 4. For example, array index 0 is for peripheral request index 4.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                | Value | Description                             
 * :------------------------------------|:------|:-----------------------------------------
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_3_E_FPGA | 0x0   | FPGA drives peripheral request interface
 *  ALT_SYSMGR_DMA_CTL_CHANSEL_3_E_CAN  | 0x1   | CAN drives peripheral request interface 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_3
 * 
 * FPGA drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_E_FPGA 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_DMA_CTL_CHANSEL_3
 * 
 * CAN drives peripheral request interface
 */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_E_CAN  0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_MSB        3
/* The width in bits of the ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_WIDTH      1
/* The mask used to set the ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field value. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_CTL_CHANSEL_3 field value from a register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_DMA_CTL_CHANSEL_3 register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_CTL_CHANSEL_3_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : Manager Thread Security - mgrnonsecure
 * 
 * Specifies the security state of the DMA manager thread.
 * 
 * 0 = assigns DMA manager to the Secure state.
 * 
 * 1 = assigns DMA manager to the Non-secure state.
 * 
 * Sampled by the DMA controller when it exits from reset.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_MSB        4
/* The width in bits of the ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_WIDTH      1
/* The mask used to set the ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field value. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field value. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_CTL_MGRNONSECURE field value from a register. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_DMA_CTL_MGRNONSECURE register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_CTL_MGRNONSECURE_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : IRQ Security - irqnonsecure
 * 
 * Specifies the security state of an event-interrupt resource.
 * 
 * If bit index [x] is 0, the DMAC assigns event<x> or irq[x] to the Secure state.
 * 
 * If bit index [x] is 1, the DMAC assigns event<x> or irq[x] to the Non-secure
 * state.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_MSB        12
/* The width in bits of the ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_WIDTH      8
/* The mask used to set the ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field value. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_SET_MSK    0x00001fe0
/* The mask used to clear the ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field value. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_CLR_MSK    0xffffe01f
/* The reset value of the ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_CTL_IRQNONSECURE field value from a register. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_GET(value) (((value) & 0x00001fe0) >> 5)
/* Produces a ALT_SYSMGR_DMA_CTL_IRQNONSECURE register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_CTL_IRQNONSECURE_SET(value) (((value) << 5) & 0x00001fe0)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_DMA_CTL.
 */
struct ALT_SYSMGR_DMA_CTL_s
{
    uint32_t  chansel_0    :  1;  /* Channel Select */
    uint32_t  chansel_1    :  1;  /* Channel Select */
    uint32_t  chansel_2    :  1;  /* Channel Select */
    uint32_t  chansel_3    :  1;  /* Channel Select */
    uint32_t  mgrnonsecure :  1;  /* Manager Thread Security */
    uint32_t  irqnonsecure :  8;  /* IRQ Security */
    uint32_t               : 19;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_DMA_CTL. */
typedef volatile struct ALT_SYSMGR_DMA_CTL_s  ALT_SYSMGR_DMA_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_DMA_CTL register from the beginning of the component. */
#define ALT_SYSMGR_DMA_CTL_OFST        0x0

/*
 * Register : Peripheral Security Register - persecurity
 * 
 * Controls the security state of a peripheral request interface. Sampled by the
 * DMA controller when it exits from reset.
 * 
 * These register bits should be updated during system initialization prior to
 * removing the DMA controller from reset. They may not be changed dynamically
 * during DMA operation.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description          
 * :-------|:-------|:------|:----------------------
 *  [31:0] | RW     | 0x0   | Peripheral Non-Secure
 * 
 */
/*
 * Field : Peripheral Non-Secure - nonsecure
 * 
 * If bit index [x] is 0, the DMA controller assigns peripheral request interface x
 * to the Secure state.
 * 
 * If bit index [x] is 1, the DMA controller assigns peripheral request interface x
 * to the Non-secure state.
 * 
 * Reset by a cold or warm reset.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_MSB        31
/* The width in bits of the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_WIDTH      32
/* The mask used to set the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field value. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field value. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_RESET      0x0
/* Extracts the ALT_SYSMGR_DMA_PERSECURITY_NONSECURE field value from a register. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_DMA_PERSECURITY_NONSECURE register field value suitable for setting the register. */
#define ALT_SYSMGR_DMA_PERSECURITY_NONSECURE_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_DMA_PERSECURITY.
 */
struct ALT_SYSMGR_DMA_PERSECURITY_s
{
    uint32_t  nonsecure : 32;  /* Peripheral Non-Secure */
};

/* The typedef declaration for register ALT_SYSMGR_DMA_PERSECURITY. */
typedef volatile struct ALT_SYSMGR_DMA_PERSECURITY_s  ALT_SYSMGR_DMA_PERSECURITY_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_DMA_PERSECURITY register from the beginning of the component. */
#define ALT_SYSMGR_DMA_PERSECURITY_OFST        0x4

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_DMA.
 */
struct ALT_SYSMGR_DMA_s
{
    volatile ALT_SYSMGR_DMA_CTL_t          ctrl;         /* ALT_SYSMGR_DMA_CTL */
    volatile ALT_SYSMGR_DMA_PERSECURITY_t  persecurity;  /* ALT_SYSMGR_DMA_PERSECURITY */
};

/* The typedef declaration for register group ALT_SYSMGR_DMA. */
typedef volatile struct ALT_SYSMGR_DMA_s  ALT_SYSMGR_DMA_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_DMA. */
struct ALT_SYSMGR_DMA_raw_s
{
    volatile uint32_t  ctrl;         /* ALT_SYSMGR_DMA_CTL */
    volatile uint32_t  persecurity;  /* ALT_SYSMGR_DMA_PERSECURITY */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_DMA. */
typedef volatile struct ALT_SYSMGR_DMA_raw_s  ALT_SYSMGR_DMA_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Preloader (initial software) Group - ALT_SYSMGR_ISW
 * Preloader (initial software) Group
 * 
 * Registers used by preloader code and the OS.
 * 
 * All registers are only reset by a cold reset (ignore warm reset).
 * 
 */
/*
 * Register : Preloader to OS Handoff Information - handoff
 * 
 * These registers are used to store handoff infomation between the preloader and
 * the OS. These 8 registers can be used to store any information. The contents of
 * these registers have no impact on the state of the HPS hardware.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [31:0] | RW     | 0x0   | Preloader Handoff Information
 * 
 */
/*
 * Field : Preloader Handoff Information - value
 * 
 * Preloader Handoff Information.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ISW_HANDOFF_VALUE register field. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ISW_HANDOFF_VALUE register field. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_MSB        31
/* The width in bits of the ALT_SYSMGR_ISW_HANDOFF_VALUE register field. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_WIDTH      32
/* The mask used to set the ALT_SYSMGR_ISW_HANDOFF_VALUE register field value. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_ISW_HANDOFF_VALUE register field value. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_ISW_HANDOFF_VALUE register field. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_RESET      0x0
/* Extracts the ALT_SYSMGR_ISW_HANDOFF_VALUE field value from a register. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_ISW_HANDOFF_VALUE register field value suitable for setting the register. */
#define ALT_SYSMGR_ISW_HANDOFF_VALUE_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ISW_HANDOFF.
 */
struct ALT_SYSMGR_ISW_HANDOFF_s
{
    uint32_t  value : 32;  /* Preloader Handoff Information */
};

/* The typedef declaration for register ALT_SYSMGR_ISW_HANDOFF. */
typedef volatile struct ALT_SYSMGR_ISW_HANDOFF_s  ALT_SYSMGR_ISW_HANDOFF_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ISW_HANDOFF register from the beginning of the component. */
#define ALT_SYSMGR_ISW_HANDOFF_OFST        0x0

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_ISW.
 */
struct ALT_SYSMGR_ISW_s
{
    volatile ALT_SYSMGR_ISW_HANDOFF_t  handoff[8];  /* ALT_SYSMGR_ISW_HANDOFF */
};

/* The typedef declaration for register group ALT_SYSMGR_ISW. */
typedef volatile struct ALT_SYSMGR_ISW_s  ALT_SYSMGR_ISW_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_ISW. */
struct ALT_SYSMGR_ISW_raw_s
{
    volatile uint32_t  handoff[8];  /* ALT_SYSMGR_ISW_HANDOFF */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_ISW. */
typedef volatile struct ALT_SYSMGR_ISW_raw_s  ALT_SYSMGR_ISW_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Boot ROM Code Register Group - ALT_SYSMGR_ROMCODE
 * Boot ROM Code Register Group
 * 
 * Registers used by the Boot ROM code. All fields are only reset by a cold reset
 * (ignore warm reset).
 * 
 */
/*
 * Register : Control Register - ctrl
 * 
 * Contains information used to control Boot ROM code.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                               
 * :-------|:-------|:------|:-------------------------------------------
 *  [0]    | RW     | 0x0   | Warm Reset Configure Pin Mux for Boot Pins
 *  [1]    | RW     | 0x0   | Warm Reset Configure IOs for Boot Pins    
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                               
 * 
 */
/*
 * Field : Warm Reset Configure Pin Mux for Boot Pins - warmrstcfgpinmux
 * 
 * Specifies whether the Boot ROM code configures the pin mux for boot pins after a
 * warm reset. Note that the Boot ROM code always configures the pin mux for boot
 * pins after a cold reset. After the Boot ROM code configures the pin mux for boot
 * pins, it always disables this field. It is up to user software to enable this
 * field if it wants a different behavior.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                           | Value | Description                                  
 * :-----------------------------------------------|:------|:----------------------------------------------
 *  ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_E_DISD | 0x0   | Boot ROM code will not configure pin mux for 
 * :                                               |       | boot pins after a warm reset                 
 *  ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_E_END  | 0x1   | Boot ROM code will configure pin mux for boot
 * :                                               |       | pins after a warm reset                      
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX
 * 
 * Boot ROM code will not configure pin mux for boot pins after a warm reset
 */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_E_DISD  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX
 * 
 * Boot ROM code will configure pin mux for boot pins after a warm reset
 */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_MSB        0
/* The width in bits of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field value. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field value. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX field value from a register. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGPINMUX_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Warm Reset Configure IOs for Boot Pins - warmrstcfgio
 * 
 * Specifies whether the Boot ROM code configures the IOs used by boot after a warm
 * reset. Note that the Boot ROM code always configures the IOs used by boot after
 * a cold reset. After the Boot ROM code configures the IOs used by boot, it always
 * disables this field. It is up to user software to enable this field if it wants
 * a different behavior.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value | Description                                  
 * :-------------------------------------------|:------|:----------------------------------------------
 *  ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_E_DISD | 0x0   | Boot ROM code will not configure IOs used by 
 * :                                           |       | boot after a warm reset                      
 *  ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_E_END  | 0x1   | Boot ROM code will configure IOs used by boot
 * :                                           |       | after a warm reset                           
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO
 * 
 * Boot ROM code will not configure IOs used by boot after a warm reset
 */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_E_DISD  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO
 * 
 * Boot ROM code will configure IOs used by boot after a warm reset
 */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_E_END   0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_MSB        1
/* The width in bits of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field value. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field value. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO field value from a register. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_CTL_WARMRSTCFGIO_SET(value) (((value) << 1) & 0x00000002)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_CTL.
 */
struct ALT_SYSMGR_ROMCODE_CTL_s
{
    uint32_t  warmrstcfgpinmux :  1;  /* Warm Reset Configure Pin Mux for Boot Pins */
    uint32_t  warmrstcfgio     :  1;  /* Warm Reset Configure IOs for Boot Pins */
    uint32_t                   : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_CTL. */
typedef volatile struct ALT_SYSMGR_ROMCODE_CTL_s  ALT_SYSMGR_ROMCODE_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_CTL register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_CTL_OFST        0x0

/*
 * Register : CPU1 Start Address Register - cpu1startaddr
 * 
 * When CPU1 is released from reset and the Boot ROM is located at the CPU1 reset
 * exception address (the typical case), the Boot ROM reset handler code reads the
 * address stored in this register and jumps it to hand off execution to user
 * software.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [31:0] | RW     | 0x0   | Address    
 * 
 */
/*
 * Field : Address - value
 * 
 * Address for CPU1 to start executing at after coming out of reset.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_MSB        31
/* The width in bits of the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_WIDTH      32
/* The mask used to set the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field value. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field value. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE field value from a register. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_VALUE_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_CPU1STARTADDR.
 */
struct ALT_SYSMGR_ROMCODE_CPU1STARTADDR_s
{
    uint32_t  value : 32;  /* Address */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_CPU1STARTADDR. */
typedef volatile struct ALT_SYSMGR_ROMCODE_CPU1STARTADDR_s  ALT_SYSMGR_ROMCODE_CPU1STARTADDR_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_CPU1STARTADDR register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_CPU1STARTADDR_OFST        0x4

/*
 * Register : Preloader (initial software) State Register - initswstate
 * 
 * The preloader software (loaded by the Boot ROM) writes the magic value
 * 0x49535756 (ISWV in ASCII) to this register when it has reached a valid state.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [31:0] | RW     | 0x0   | Value      
 * 
 */
/*
 * Field : Value - value
 * 
 * Written with magic value.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                           | Value      | Description
 * :-----------------------------------------------|:-----------|:------------
 *  ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_E_INVALID | 0x0        |            
 *  ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_E_VALID   | 0x49535756 |            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE
 * 
 */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_E_INVALID  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE
 * 
 */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_E_VALID    0x49535756

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_MSB        31
/* The width in bits of the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_WIDTH      32
/* The mask used to set the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field value. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field value. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE field value from a register. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_VALUE_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_INITSWSTATE.
 */
struct ALT_SYSMGR_ROMCODE_INITSWSTATE_s
{
    uint32_t  value : 32;  /* Value */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_INITSWSTATE. */
typedef volatile struct ALT_SYSMGR_ROMCODE_INITSWSTATE_s  ALT_SYSMGR_ROMCODE_INITSWSTATE_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_INITSWSTATE register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_INITSWSTATE_OFST        0x8

/*
 * Register : Preloader (initial software) Last Image Loaded Register - initswlastld
 * 
 * Contains the index of the last preloader software image loaded by the Boot ROM
 * from the boot device.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description
 * :-------|:-------|:------|:------------
 *  [1:0]  | RW     | 0x0   | Index      
 *  [31:2] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : Index - index
 * 
 * Index of last image loaded.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_MSB        1
/* The width in bits of the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_WIDTH      2
/* The mask used to set the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field value. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field value. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX field value from a register. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_INDEX_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_INITSWLASTLD.
 */
struct ALT_SYSMGR_ROMCODE_INITSWLASTLD_s
{
    uint32_t  index :  2;  /* Index */
    uint32_t        : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_INITSWLASTLD. */
typedef volatile struct ALT_SYSMGR_ROMCODE_INITSWLASTLD_s  ALT_SYSMGR_ROMCODE_INITSWLASTLD_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_INITSWLASTLD register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_INITSWLASTLD_OFST        0xc

/*
 * Register : Boot ROM Software State Register - bootromswstate
 * 
 * 32-bits general purpose register used by the Boot ROM code. Actual usage is
 * defined in the Boot ROM source code.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description            
 * :-------|:-------|:------|:------------------------
 *  [31:0] | RW     | 0x0   | Boot ROM Software State
 * 
 */
/*
 * Field : Boot ROM Software State - value
 * 
 * Reserved for Boot ROM use.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_MSB        31
/* The width in bits of the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_WIDTH      32
/* The mask used to set the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field value. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field value. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE field value from a register. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_VALUE_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE.
 */
struct ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_s
{
    uint32_t  value : 32;  /* Boot ROM Software State */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE. */
typedef volatile struct ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_s  ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_OFST        0x10

/*
 * Register Group : Warm Boot from On-Chip RAM Group - ALT_SYSMGR_ROMCODE_WARMRAM
 * Warm Boot from On-Chip RAM Group
 * 
 * Registers used by the Boot ROM code to support booting from the On-chip RAM on a
 * warm reset.  All these registers must be written by user software before a warm
 * reset occurs to make use of this feature.
 * 
 */
/*
 * Register : Enable Register - enable
 * 
 * Enables or disables the warm reset from On-chip RAM feature.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [31:0] | RW     | 0x0   | Warm Reset from On-chip RAM
 * 
 */
/*
 * Field : Warm Reset from On-chip RAM - magic
 * 
 * Controls whether Boot ROM will attempt to boot from the contents of the On-chip
 * RAM on a warm reset. When this feature is enabled, the Boot ROM code will not
 * configure boot IOs, the pin mux, or clocks.
 * 
 * Note that the enable value is a 32-bit magic value (provided by the enum).
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                       | Value      | Description                                    
 * :-------------------------------------------|:-----------|:------------------------------------------------
 *  ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_E_DISD | 0x0        | Boot ROM code will not attempt to boot from On-
 * :                                           |            | chip RAM on a warm reset                       
 *  ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_E_END  | 0xae9efebc | Boot ROM code will attempt to boot from On-chip
 * :                                           |            | RAM on a warm reset                            
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC
 * 
 * Boot ROM code will not attempt to boot from On-chip RAM on a warm reset
 */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_E_DISD  0x0
/*
 * Enumerated value for register field ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC
 * 
 * Boot ROM code will attempt to boot from On-chip RAM on a warm reset
 */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_E_END   0xae9efebc

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_MSB        31
/* The width in bits of the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_WIDTH      32
/* The mask used to set the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC field value from a register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_MAGIC_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_EN.
 */
struct ALT_SYSMGR_ROMCODE_WARMRAM_EN_s
{
    uint32_t  magic : 32;  /* Warm Reset from On-chip RAM */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_EN. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_EN_s  ALT_SYSMGR_ROMCODE_WARMRAM_EN_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_WARMRAM_EN register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_OFST        0x0
/* The address of the ALT_SYSMGR_ROMCODE_WARMRAM_EN register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EN_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_SYSMGR_ROMCODE_WARMRAM_EN_OFST))

/*
 * Register : Data Start Register - datastart
 * 
 * Offset into On-chip RAM of the start of the region for CRC validation
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description      
 * :--------|:-------|:------|:------------------
 *  [15:0]  | RW     | 0x0   | Data Start Offset
 *  [31:16] | ???    | 0x0   | *UNDEFINED*      
 * 
 */
/*
 * Field : Data Start Offset - offset
 * 
 * Contains the byte offset into the On-chip RAM of the start of the On-chip RAM
 * region for the warm boot CRC validation. The offset must be an integer multiple
 * of 4 (i.e. aligned to a word). The Boot ROM code will set the top 16 bits to
 * 0xFFFF and clear the bottom 2 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_MSB        15
/* The width in bits of the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_WIDTH      16
/* The mask used to set the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_CLR_MSK    0xffff0000
/* The reset value of the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET field value from a register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFFSET_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART.
 */
struct ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_s
{
    uint32_t  offset : 16;  /* Data Start Offset */
    uint32_t         : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_s  ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFST        0x4
/* The address of the ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_OFST))

/*
 * Register : Length Register - length
 * 
 * Length of region in On-chip RAM for CRC validation.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description
 * :--------|:-------|:------|:------------
 *  [15:0]  | RW     | 0x0   | Size       
 *  [31:16] | ???    | 0x0   | *UNDEFINED*
 * 
 */
/*
 * Field : Size - size
 * 
 * Contains the length (in bytes) of the region in the On-chip RAM for the warm
 * boot CRC validation.
 * 
 * If the length is 0, the Boot ROM won't perform CRC calculation and CRC check to
 * avoid overhead caused by CRC validation.
 * 
 * If the START + LENGTH exceeds the maximum offset into the On-chip RAM, the Boot
 * ROM won't boot from the On-chip RAM.
 * 
 * The length must be an integer multiple of 4.
 * 
 * The Boot ROM code will clear the top 16 bits and the bottom 2 bits.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_MSB        15
/* The width in bits of the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_WIDTH      16
/* The mask used to set the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_CLR_MSK    0xffff0000
/* The reset value of the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE field value from a register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_SIZE_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_LEN.
 */
struct ALT_SYSMGR_ROMCODE_WARMRAM_LEN_s
{
    uint32_t  size : 16;  /* Size */
    uint32_t       : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_LEN. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_LEN_s  ALT_SYSMGR_ROMCODE_WARMRAM_LEN_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_WARMRAM_LEN register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_OFST        0x8
/* The address of the ALT_SYSMGR_ROMCODE_WARMRAM_LEN register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_LEN_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_SYSMGR_ROMCODE_WARMRAM_LEN_OFST))

/*
 * Register : Execution Register - execution
 * 
 * Offset into On-chip RAM to enter to on a warm boot.
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description     
 * :--------|:-------|:------|:-----------------
 *  [15:0]  | RW     | 0x0   | Execution Offset
 *  [31:16] | ???    | 0x0   | *UNDEFINED*     
 * 
 */
/*
 * Field : Execution Offset - offset
 * 
 * Contains the byte offset into the On-chip RAM that the Boot ROM will jump to if
 * the CRC validation succeeds.
 * 
 * The Boot ROM code will set the top 16 bits to 0xFFFF.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_MSB        15
/* The width in bits of the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_WIDTH      16
/* The mask used to set the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_SET_MSK    0x0000ffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_CLR_MSK    0xffff0000
/* The reset value of the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET field value from a register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_GET(value) (((value) & 0x0000ffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFFSET_SET(value) (((value) << 0) & 0x0000ffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION.
 */
struct ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_s
{
    uint32_t  offset : 16;  /* Execution Offset */
    uint32_t         : 16;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_s  ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFST        0xc
/* The address of the ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_OFST))

/*
 * Register : Expected CRC Register - crc
 * 
 * Length of region in On-chip RAM for CRC validation.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset      | Description 
 * :-------|:-------|:-----------|:-------------
 *  [31:0] | RW     | 0xe763552a | Expected CRC
 * 
 */
/*
 * Field : Expected CRC - expected
 * 
 * Contains the expected CRC of the region in the On-chip RAM.The Boot ROM code
 * calculates the actual CRC for all bytes in the region specified by the DATA
 * START an LENGTH registers. The contents of the EXECUTION register (after it has
 * been read and modified by the Boot ROM code) is also included in the CRC
 * calculation. The contents of the EXECUTION register is added to the CRC
 * accumulator a byte at a time starting with the least significant byte. If the
 * actual CRC doesn't match the expected CRC value in this register, the Boot ROM
 * won't boot from the On-chip RAM.
 * 
 * The CRC is a standard CRC32 with the polynomial:
 * 
 * x^32 + x^26 + x^23 + x^22 + x^16 + x^12 + x^11 + x^10 + x^8 + x^7 + x^5 + x^4 +
 * x^2 + x + 1
 * 
 * There is no reflection of the bits and the initial value of the remainder is
 * 0xFFFFFFFF and the final value is exclusive ORed with 0xFFFFFFFF.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_MSB        31
/* The width in bits of the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_WIDTH      32
/* The mask used to set the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_SET_MSK    0xffffffff
/* The mask used to clear the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field value. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_CLR_MSK    0x00000000
/* The reset value of the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_RESET      0xe763552a
/* Extracts the ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED field value from a register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_GET(value) (((value) & 0xffffffff) >> 0)
/* Produces a ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_EXPECTED_SET(value) (((value) << 0) & 0xffffffff)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_CRC.
 */
struct ALT_SYSMGR_ROMCODE_WARMRAM_CRC_s
{
    uint32_t  expected : 32;  /* Expected CRC */
};

/* The typedef declaration for register ALT_SYSMGR_ROMCODE_WARMRAM_CRC. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_CRC_s  ALT_SYSMGR_ROMCODE_WARMRAM_CRC_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMCODE_WARMRAM_CRC register from the beginning of the component. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_OFST        0x10
/* The address of the ALT_SYSMGR_ROMCODE_WARMRAM_CRC register. */
#define ALT_SYSMGR_ROMCODE_WARMRAM_CRC_ADDR(base)  ALT_CAST(void *, (ALT_CAST(char *, (base)) + ALT_SYSMGR_ROMCODE_WARMRAM_CRC_OFST))

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_ROMCODE_WARMRAM.
 */
struct ALT_SYSMGR_ROMCODE_WARMRAM_s
{
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_EN_t         enable;             /* ALT_SYSMGR_ROMCODE_WARMRAM_EN */
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART_t  datastart;          /* ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART */
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_LEN_t        length;             /* ALT_SYSMGR_ROMCODE_WARMRAM_LEN */
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION_t  execution;          /* ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION */
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_CRC_t        crc;                /* ALT_SYSMGR_ROMCODE_WARMRAM_CRC */
    volatile uint32_t                                _pad_0x14_0x20[3];  /* *UNDEFINED* */
};

/* The typedef declaration for register group ALT_SYSMGR_ROMCODE_WARMRAM. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_s  ALT_SYSMGR_ROMCODE_WARMRAM_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_ROMCODE_WARMRAM. */
struct ALT_SYSMGR_ROMCODE_WARMRAM_raw_s
{
    volatile uint32_t  enable;             /* ALT_SYSMGR_ROMCODE_WARMRAM_EN */
    volatile uint32_t  datastart;          /* ALT_SYSMGR_ROMCODE_WARMRAM_DATASTART */
    volatile uint32_t  length;             /* ALT_SYSMGR_ROMCODE_WARMRAM_LEN */
    volatile uint32_t  execution;          /* ALT_SYSMGR_ROMCODE_WARMRAM_EXECUTION */
    volatile uint32_t  crc;                /* ALT_SYSMGR_ROMCODE_WARMRAM_CRC */
    volatile uint32_t  _pad_0x14_0x20[3];  /* *UNDEFINED* */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_ROMCODE_WARMRAM. */
typedef volatile struct ALT_SYSMGR_ROMCODE_WARMRAM_raw_s  ALT_SYSMGR_ROMCODE_WARMRAM_raw_t;
#endif  /* __ASSEMBLY__ */


#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_ROMCODE.
 */
struct ALT_SYSMGR_ROMCODE_s
{
    volatile ALT_SYSMGR_ROMCODE_CTL_t             ctrl;                   /* ALT_SYSMGR_ROMCODE_CTL */
    volatile ALT_SYSMGR_ROMCODE_CPU1STARTADDR_t   cpu1startaddr;          /* ALT_SYSMGR_ROMCODE_CPU1STARTADDR */
    volatile ALT_SYSMGR_ROMCODE_INITSWSTATE_t     initswstate;            /* ALT_SYSMGR_ROMCODE_INITSWSTATE */
    volatile ALT_SYSMGR_ROMCODE_INITSWLASTLD_t    initswlastld;           /* ALT_SYSMGR_ROMCODE_INITSWLASTLD */
    volatile ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE_t  bootromswstate;         /* ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE */
    volatile uint32_t                             _pad_0x14_0x1f[3];      /* *UNDEFINED* */
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_t         romcodegrp_warmramgrp;  /* ALT_SYSMGR_ROMCODE_WARMRAM */
};

/* The typedef declaration for register group ALT_SYSMGR_ROMCODE. */
typedef volatile struct ALT_SYSMGR_ROMCODE_s  ALT_SYSMGR_ROMCODE_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_ROMCODE. */
struct ALT_SYSMGR_ROMCODE_raw_s
{
    volatile uint32_t                          ctrl;                   /* ALT_SYSMGR_ROMCODE_CTL */
    volatile uint32_t                          cpu1startaddr;          /* ALT_SYSMGR_ROMCODE_CPU1STARTADDR */
    volatile uint32_t                          initswstate;            /* ALT_SYSMGR_ROMCODE_INITSWSTATE */
    volatile uint32_t                          initswlastld;           /* ALT_SYSMGR_ROMCODE_INITSWLASTLD */
    volatile uint32_t                          bootromswstate;         /* ALT_SYSMGR_ROMCODE_BOOTROMSWSTATE */
    volatile uint32_t                          _pad_0x14_0x1f[3];      /* *UNDEFINED* */
    volatile ALT_SYSMGR_ROMCODE_WARMRAM_raw_t  romcodegrp_warmramgrp;  /* ALT_SYSMGR_ROMCODE_WARMRAM */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_ROMCODE. */
typedef volatile struct ALT_SYSMGR_ROMCODE_raw_s  ALT_SYSMGR_ROMCODE_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Boot ROM Hardware Register Group - ALT_SYSMGR_ROMHW
 * Boot ROM Hardware Register Group
 * 
 * Registers used by the Boot ROM hardware, not the code within it.
 * 
 */
/*
 * Register : Boot ROM Hardware Control Register - ctrl
 * 
 * Controls behavior of Boot ROM hardware.
 * 
 * All fields are only reset by a cold reset (ignore warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                       
 * :-------|:-------|:------|:-----------------------------------
 *  [0]    | RW     | 0x0   | Wait State                        
 *  [1]    | RW     | 0x1   | Enable Safe Mode Warm Reset Update
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                       
 * 
 */
/*
 * Field : Wait State - waitstate
 * 
 * Controls the number of wait states applied to the Boot ROM's read operation.
 * 
 * This field is cleared on a cold reset and optionally updated by hardware upon
 * deassertion of warm reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                     
 * :-------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_ROMHW_CTL_WAITSTATE_E_DIS | 0x0   | No wait states are applied to the Boom ROM's    
 * :                                     |       | read operation.                                 
 *  ALT_SYSMGR_ROMHW_CTL_WAITSTATE_E_EN  | 0x1   | A single wait state is applied to the Boot ROM's
 * :                                     |       | read operation.                                 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_ROMHW_CTL_WAITSTATE
 * 
 * No wait states are applied to the Boom ROM's read operation.
 */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_E_DIS    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_ROMHW_CTL_WAITSTATE
 * 
 * A single wait state is applied to the Boot ROM's read operation.
 */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_E_EN     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_MSB        0
/* The width in bits of the ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field value. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field value. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_RESET      0x0
/* Extracts the ALT_SYSMGR_ROMHW_CTL_WAITSTATE field value from a register. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ROMHW_CTL_WAITSTATE register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMHW_CTL_WAITSTATE_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Enable Safe Mode Warm Reset Update - ensfmdwru
 * 
 * Controls whether the wait state bit is updated upon deassertion of warm reset.
 * 
 * This field is set on a cold reset.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                 | Value | Description                                   
 * :-------------------------------------|:------|:-----------------------------------------------
 *  ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_E_DIS | 0x0   | Wait state bit is not updated upon deassertion
 * :                                     |       | of warm reset.                                
 *  ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_E_EN  | 0x1   | Wait state bit is updated upon deassertion of 
 * :                                     |       | warm reset. It's value is updated based on the
 * :                                     |       | control bit from clock manager which specifies
 * :                                     |       | whether clock manager will be in safe mode or 
 * :                                     |       | not after warm reset.                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU
 * 
 * Wait state bit is not updated upon deassertion of warm reset.
 */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_E_DIS    0x0
/*
 * Enumerated value for register field ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU
 * 
 * Wait state bit is updated upon deassertion of warm reset.
 * 
 * It's value is updated based on the control bit from clock manager which
 * specifies whether clock manager will be in safe mode or not after warm reset.
 */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_E_EN     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_MSB        1
/* The width in bits of the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field value. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field value. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_RESET      0x1
/* Extracts the ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU field value from a register. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU register field value suitable for setting the register. */
#define ALT_SYSMGR_ROMHW_CTL_ENSFMDWRU_SET(value) (((value) << 1) & 0x00000002)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ROMHW_CTL.
 */
struct ALT_SYSMGR_ROMHW_CTL_s
{
    uint32_t  waitstate :  1;  /* Wait State */
    uint32_t  ensfmdwru :  1;  /* Enable Safe Mode Warm Reset Update */
    uint32_t            : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ROMHW_CTL. */
typedef volatile struct ALT_SYSMGR_ROMHW_CTL_s  ALT_SYSMGR_ROMHW_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ROMHW_CTL register from the beginning of the component. */
#define ALT_SYSMGR_ROMHW_CTL_OFST        0x0

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_ROMHW.
 */
struct ALT_SYSMGR_ROMHW_s
{
    volatile ALT_SYSMGR_ROMHW_CTL_t  ctrl;  /* ALT_SYSMGR_ROMHW_CTL */
};

/* The typedef declaration for register group ALT_SYSMGR_ROMHW. */
typedef volatile struct ALT_SYSMGR_ROMHW_s  ALT_SYSMGR_ROMHW_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_ROMHW. */
struct ALT_SYSMGR_ROMHW_raw_s
{
    volatile uint32_t  ctrl;  /* ALT_SYSMGR_ROMHW_CTL */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_ROMHW. */
typedef volatile struct ALT_SYSMGR_ROMHW_raw_s  ALT_SYSMGR_ROMHW_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : SDMMC Controller Group - ALT_SYSMGR_SDMMC
 * SDMMC Controller Group
 * 
 * Registers related to SDMMC Controller which aren't located inside the SDMMC
 * itself.
 * 
 */
/*
 * Register : Control Register - ctrl
 * 
 * Registers used by the SDMMC Controller. All fields are reset by a cold or warm
 * reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [2:0]  | RW     | 0x0   | Drive Clock Phase Shift Select 
 *  [5:3]  | RW     | 0x0   | Sample Clock Phase Shift Select
 *  [6]    | RW     | 0x0   | Feedback Clock Select          
 *  [31:7] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : Drive Clock Phase Shift Select - drvsel
 * 
 * Select which phase shift of the clock for cclk_in_drv.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                     | Value | Description                                
 * :-----------------------------------------|:------|:--------------------------------------------
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES0   | 0x0   | 0 degrees phase shifted clock is selected  
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES45  | 0x1   | 45 degrees phase shifted clock is selected 
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES90  | 0x2   | 90 degrees phase shifted clock is selected 
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES135 | 0x3   | 135 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES180 | 0x4   | 180 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES225 | 0x5   | 225 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES270 | 0x6   | 270 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES315 | 0x7   | 315 degrees phase shifted clock is selected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 0 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES0      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 45 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES45     0x1
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 90 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES90     0x2
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 135 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES135    0x3
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 180 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES180    0x4
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 225 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES225    0x5
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 270 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES270    0x6
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_DRVSEL
 * 
 * 315 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_E_DEGREES315    0x7

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_CTL_DRVSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_CTL_DRVSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_MSB        2
/* The width in bits of the ALT_SYSMGR_SDMMC_CTL_DRVSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_WIDTH      3
/* The mask used to set the ALT_SYSMGR_SDMMC_CTL_DRVSEL register field value. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_SET_MSK    0x00000007
/* The mask used to clear the ALT_SYSMGR_SDMMC_CTL_DRVSEL register field value. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_CLR_MSK    0xfffffff8
/* The reset value of the ALT_SYSMGR_SDMMC_CTL_DRVSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_SDMMC_CTL_DRVSEL field value from a register. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_GET(value) (((value) & 0x00000007) >> 0)
/* Produces a ALT_SYSMGR_SDMMC_CTL_DRVSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_CTL_DRVSEL_SET(value) (((value) << 0) & 0x00000007)

/*
 * Field : Sample Clock Phase Shift Select - smplsel
 * 
 * Select which phase shift of the clock for cclk_in_sample.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description                                
 * :------------------------------------------|:------|:--------------------------------------------
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES0   | 0x0   | 0 degrees phase shifted clock is selected  
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES45  | 0x1   | 45 degrees phase shifted clock is selected 
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES90  | 0x2   | 90 degrees phase shifted clock is selected 
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES135 | 0x3   | 135 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES180 | 0x4   | 180 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES225 | 0x5   | 225 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES270 | 0x6   | 270 degrees phase shifted clock is selected
 *  ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES315 | 0x7   | 315 degrees phase shifted clock is selected
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 0 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES0     0x0
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 45 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES45    0x1
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 90 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES90    0x2
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 135 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES135   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 180 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES180   0x4
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 225 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES225   0x5
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 270 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES270   0x6
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_CTL_SMPLSEL
 * 
 * 315 degrees phase shifted clock is selected
 */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_E_DEGREES315   0x7

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_MSB        5
/* The width in bits of the ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_WIDTH      3
/* The mask used to set the ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field value. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_SET_MSK    0x00000038
/* The mask used to clear the ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field value. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_CLR_MSK    0xffffffc7
/* The reset value of the ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_SDMMC_CTL_SMPLSEL field value from a register. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_GET(value) (((value) & 0x00000038) >> 3)
/* Produces a ALT_SYSMGR_SDMMC_CTL_SMPLSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_CTL_SMPLSEL_SET(value) (((value) << 3) & 0x00000038)

/*
 * Field : Feedback Clock Select - fbclksel
 * 
 * Select which fb_clk to be used as cclk_in_sample.
 * 
 * If 0, cclk_in_sample is driven by internal phase shifted cclk_in.
 * 
 * If 1, cclk_in_sample is driven by fb_clk_in. No phase shifting is provided
 * internally on cclk_in_sample.
 * 
 * Note: Using the feedback clock (setting this bit to 1) is not a supported use
 * model.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_MSB        6
/* The width in bits of the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field value. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field value. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_RESET      0x0
/* Extracts the ALT_SYSMGR_SDMMC_CTL_FBCLKSEL field value from a register. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_SDMMC_CTL_FBCLKSEL register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_CTL_FBCLKSEL_SET(value) (((value) << 6) & 0x00000040)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_SDMMC_CTL.
 */
struct ALT_SYSMGR_SDMMC_CTL_s
{
    uint32_t  drvsel   :  3;  /* Drive Clock Phase Shift Select */
    uint32_t  smplsel  :  3;  /* Sample Clock Phase Shift Select */
    uint32_t  fbclksel :  1;  /* Feedback Clock Select */
    uint32_t           : 25;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_SDMMC_CTL. */
typedef volatile struct ALT_SYSMGR_SDMMC_CTL_s  ALT_SYSMGR_SDMMC_CTL_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_SDMMC_CTL register from the beginning of the component. */
#define ALT_SYSMGR_SDMMC_CTL_OFST        0x0

/*
 * Register : SD/MMC L3 Master HPROT Register - l3master
 * 
 * Controls the L3 master HPROT AHB-Lite signal.
 * 
 * These register bits should be updated only during system initialization prior to
 * removing the peripheral from reset. They may not be changed dynamically during
 * peripheral operation
 * 
 * All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description             
 * :-------|:-------|:------|:-------------------------
 *  [0]    | RW     | 0x1   | SD/MMC HPROT Data/Opcode
 *  [1]    | RW     | 0x1   | SD/MMC HPROT Privileged 
 *  [2]    | RW     | 0x0   | SD/MMC HPROT Bufferable 
 *  [3]    | RW     | 0x0   | SD/MMC HPROT Cacheable  
 *  [31:4] | ???    | 0x0   | *UNDEFINED*             
 * 
 */
/*
 * Field : SD/MMC HPROT Data/Opcode - hprotdata_0
 * 
 * Specifies if the L3 master access is for data or opcode for the SD/MMC module.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                        | Value | Description 
 * :--------------------------------------------|:------|:-------------
 *  ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_E_OPCODE | 0x0   | Opcode fetch
 *  ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_E_DATA   | 0x1   | Data access 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0
 * 
 * Opcode fetch
 */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_E_OPCODE 0x0
/*
 * Enumerated value for register field ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0
 * 
 * Data access
 */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_E_DATA   0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_MSB        0
/* The width in bits of the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_RESET      0x1
/* Extracts the ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 field value from a register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTDATA_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : SD/MMC HPROT Privileged - hprotpriv_0
 * 
 * If 1, L3 master accesses for the SD/MMC module are privileged.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_MSB        1
/* The width in bits of the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_RESET      0x1
/* Extracts the ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 field value from a register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTPRIV_0_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : SD/MMC HPROT Bufferable - hprotbuff_0
 * 
 * If 1, L3 master accesses for the SD/MMC module are bufferable.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_MSB        2
/* The width in bits of the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_RESET      0x0
/* Extracts the ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 field value from a register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTBUFF_0_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : SD/MMC HPROT Cacheable - hprotcache_0
 * 
 * If 1, L3 master accesses for the SD/MMC module are cacheable.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_MSB        3
/* The width in bits of the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field value. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_RESET      0x0
/* Extracts the ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 field value from a register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_SDMMC_L3MST_HPROTCACHE_0_SET(value) (((value) << 3) & 0x00000008)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_SDMMC_L3MST.
 */
struct ALT_SYSMGR_SDMMC_L3MST_s
{
    uint32_t  hprotdata_0  :  1;  /* SD/MMC HPROT Data/Opcode */
    uint32_t  hprotpriv_0  :  1;  /* SD/MMC HPROT Privileged */
    uint32_t  hprotbuff_0  :  1;  /* SD/MMC HPROT Bufferable */
    uint32_t  hprotcache_0 :  1;  /* SD/MMC HPROT Cacheable */
    uint32_t               : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_SDMMC_L3MST. */
typedef volatile struct ALT_SYSMGR_SDMMC_L3MST_s  ALT_SYSMGR_SDMMC_L3MST_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_SDMMC_L3MST register from the beginning of the component. */
#define ALT_SYSMGR_SDMMC_L3MST_OFST        0x4

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_SDMMC.
 */
struct ALT_SYSMGR_SDMMC_s
{
    volatile ALT_SYSMGR_SDMMC_CTL_t    ctrl;      /* ALT_SYSMGR_SDMMC_CTL */
    volatile ALT_SYSMGR_SDMMC_L3MST_t  l3master;  /* ALT_SYSMGR_SDMMC_L3MST */
};

/* The typedef declaration for register group ALT_SYSMGR_SDMMC. */
typedef volatile struct ALT_SYSMGR_SDMMC_s  ALT_SYSMGR_SDMMC_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_SDMMC. */
struct ALT_SYSMGR_SDMMC_raw_s
{
    volatile uint32_t  ctrl;      /* ALT_SYSMGR_SDMMC_CTL */
    volatile uint32_t  l3master;  /* ALT_SYSMGR_SDMMC_L3MST */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_SDMMC. */
typedef volatile struct ALT_SYSMGR_SDMMC_raw_s  ALT_SYSMGR_SDMMC_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : NAND Flash Controller Register Group - ALT_SYSMGR_NAND
 * NAND Flash Controller Register Group
 * 
 * Registers related to NAND Flash Controller which aren't located in the NAND
 * Flash Controller itself.
 * 
 */
/*
 * Register : Bootstrap Control Register - bootstrap
 * 
 * Bootstrap fields sampled by NAND Flash Controller when released from reset.
 * 
 * All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                          
 * :-------|:-------|:------|:--------------------------------------
 *  [0]    | RW     | 0x0   | Bootstrap Inhibit Initialization     
 *  [1]    | RW     | 0x0   | Bootstrap 512 Byte Device            
 *  [2]    | RW     | 0x0   | Bootstrap Inhibit Load Block 0 Page 0
 *  [3]    | RW     | 0x0   | Bootstrap Two Row Address Cycles     
 *  [31:4] | ???    | 0x0   | *UNDEFINED*                          
 * 
 */
/*
 * Field : Bootstrap Inhibit Initialization - noinit
 * 
 * If 1, inhibits NAND Flash Controller from performing initialization when coming
 * out of reset. Instead, software must program all registers pertaining to device
 * parameters like page size, width, etc.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_MSB        0
/* The width in bits of the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_WIDTH      1
/* The mask used to set the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_RESET      0x0
/* Extracts the ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT field value from a register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT register field value suitable for setting the register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOINIT_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : Bootstrap 512 Byte Device - page512
 * 
 * If 1, NAND device has a 512 byte page size.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_MSB        1
/* The width in bits of the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_WIDTH      1
/* The mask used to set the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_RESET      0x0
/* Extracts the ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 field value from a register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512 register field value suitable for setting the register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_PAGE512_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : Bootstrap Inhibit Load Block 0 Page 0 - noloadb0p0
 * 
 * If 1, inhibits NAND Flash Controller from loading page 0 of block 0 of the NAND
 * device as part of the initialization procedure.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_MSB        2
/* The width in bits of the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_RESET      0x0
/* Extracts the ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 field value from a register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0 register field value suitable for setting the register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_NOLDB0P0_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : Bootstrap Two Row Address Cycles - tworowaddr
 * 
 * If 1, NAND device requires only 2 row address cycles instead of the normal 3 row
 * address cycles.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_MSB        3
/* The width in bits of the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field value. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_RESET      0x0
/* Extracts the ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR field value from a register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR register field value suitable for setting the register. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_TWOROWADDR_SET(value) (((value) << 3) & 0x00000008)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_NAND_BOOTSTRAP.
 */
struct ALT_SYSMGR_NAND_BOOTSTRAP_s
{
    uint32_t  noinit     :  1;  /* Bootstrap Inhibit Initialization */
    uint32_t  page512    :  1;  /* Bootstrap 512 Byte Device */
    uint32_t  noloadb0p0 :  1;  /* Bootstrap Inhibit Load Block 0 Page 0 */
    uint32_t  tworowaddr :  1;  /* Bootstrap Two Row Address Cycles */
    uint32_t             : 28;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_NAND_BOOTSTRAP. */
typedef volatile struct ALT_SYSMGR_NAND_BOOTSTRAP_s  ALT_SYSMGR_NAND_BOOTSTRAP_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_NAND_BOOTSTRAP register from the beginning of the component. */
#define ALT_SYSMGR_NAND_BOOTSTRAP_OFST        0x0

/*
 * Register : NAND L3 Master AxCACHE Register - l3master
 * 
 * Controls the L3 master ARCACHE and AWCACHE AXI signals.
 * 
 * These register bits should be updated only during system initialization prior to
 * removing the peripheral from reset. They may not be changed dynamically during
 * peripheral operation
 * 
 * All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description 
 * :-------|:-------|:------|:-------------
 *  [3:0]  | RW     | 0x0   | NAND ARCACHE
 *  [7:4]  | RW     | 0x0   | NAND AWCACHE
 *  [31:8] | ???    | 0x0   | *UNDEFINED* 
 * 
 */
/*
 * Field : NAND ARCACHE - arcache_0
 * 
 * Specifies the value of the module ARCACHE signal.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                   | Value | Description                                     
 * :-------------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_NONCACHE_NONBUFF     | 0x0   | Noncacheable and nonbufferable.                 
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_BUFF                 | 0x1   | Bufferable only.                                
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_NONALLOC       | 0x2   | Cacheable, but do not allocate.                 
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_BUFF_NONALLOC  | 0x3   | Cacheable and bufferable, but do not allocate.  
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD1                | 0x4   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD2                | 0x5   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRTHRU_RDALLOC | 0x6   | Cacheable write-through, allocate on reads only.
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRBACK_RDALLOC | 0x7   | Cacheable write-back, allocate on reads only.   
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD3                | 0x8   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD4                | 0x9   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRTHRU_WRALLOC | 0xa   | Cacheable write-through, allocate on writes     
 * :                                                       |       | only.                                           
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRBACK_WRALLOC | 0xb   | Cacheable write-back, allocate on writes only.  
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD5                | 0xc   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD6                | 0xd   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRTHRU_ALLOC   | 0xe   | Cacheable write-through, allocate on both reads 
 * :                                                       |       | and writes.                                     
 *  ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRBACK_ALLOC   | 0xf   | Cacheable write-back, allocate on both reads and
 * :                                                       |       | writes.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Noncacheable and nonbufferable.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_NONCACHE_NONBUFF      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Bufferable only.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_BUFF                  0x1
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable, but do not allocate.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_NONALLOC        0x2
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable and bufferable, but do not allocate.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_BUFF_NONALLOC   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD1                 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD2                 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable write-through, allocate on reads only.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRTHRU_RDALLOC  0x6
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable write-back, allocate on reads only.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRBACK_RDALLOC  0x7
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD3                 0x8
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD4                 0x9
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable write-through, allocate on writes only.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRTHRU_WRALLOC  0xa
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable write-back, allocate on writes only.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRBACK_WRALLOC  0xb
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD5                 0xc
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_RSVD6                 0xd
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable write-through, allocate on both reads and writes.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRTHRU_ALLOC    0xe
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_ARCACHE_0
 * 
 * Cacheable write-back, allocate on both reads and writes.
 */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_E_CACHE_WRBACK_ALLOC    0xf

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_MSB        3
/* The width in bits of the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_WIDTH      4
/* The mask used to set the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field value. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_SET_MSK    0x0000000f
/* The mask used to clear the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field value. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_CLR_MSK    0xfffffff0
/* The reset value of the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_RESET      0x0
/* Extracts the ALT_SYSMGR_NAND_L3MST_ARCACHE_0 field value from a register. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_GET(value) (((value) & 0x0000000f) >> 0)
/* Produces a ALT_SYSMGR_NAND_L3MST_ARCACHE_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_NAND_L3MST_ARCACHE_0_SET(value) (((value) << 0) & 0x0000000f)

/*
 * Field : NAND AWCACHE - awcache_0
 * 
 * Specifies the value of the module AWCACHE signal.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                                   | Value | Description                                     
 * :-------------------------------------------------------|:------|:-------------------------------------------------
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_NONCACHE_NONBUFF     | 0x0   | Noncacheable and nonbufferable.                 
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_BUFF                 | 0x1   | Bufferable only.                                
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_NONALLOC       | 0x2   | Cacheable, but do not allocate.                 
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_BUFF_NONALLOC  | 0x3   | Cacheable and bufferable, but do not allocate.  
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD1                | 0x4   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD2                | 0x5   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRTHRU_RDALLOC | 0x6   | Cacheable write-through, allocate on reads only.
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRBACK_RDALLOC | 0x7   | Cacheable write-back, allocate on reads only.   
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD3                | 0x8   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD4                | 0x9   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRTHRU_WRALLOC | 0xa   | Cacheable write-through, allocate on writes     
 * :                                                       |       | only.                                           
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRBACK_WRALLOC | 0xb   | Cacheable write-back, allocate on writes only.  
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD5                | 0xc   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD6                | 0xd   | Reserved.                                       
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRTHRU_ALLOC   | 0xe   | Cacheable write-through, allocate on both reads 
 * :                                                       |       | and writes.                                     
 *  ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRBACK_ALLOC   | 0xf   | Cacheable write-back, allocate on both reads and
 * :                                                       |       | writes.                                         
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Noncacheable and nonbufferable.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_NONCACHE_NONBUFF      0x0
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Bufferable only.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_BUFF                  0x1
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable, but do not allocate.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_NONALLOC        0x2
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable and bufferable, but do not allocate.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_BUFF_NONALLOC   0x3
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD1                 0x4
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD2                 0x5
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable write-through, allocate on reads only.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRTHRU_RDALLOC  0x6
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable write-back, allocate on reads only.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRBACK_RDALLOC  0x7
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD3                 0x8
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD4                 0x9
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable write-through, allocate on writes only.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRTHRU_WRALLOC  0xa
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable write-back, allocate on writes only.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRBACK_WRALLOC  0xb
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD5                 0xc
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Reserved.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_RSVD6                 0xd
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable write-through, allocate on both reads and writes.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRTHRU_ALLOC    0xe
/*
 * Enumerated value for register field ALT_SYSMGR_NAND_L3MST_AWCACHE_0
 * 
 * Cacheable write-back, allocate on both reads and writes.
 */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_E_CACHE_WRBACK_ALLOC    0xf

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_MSB        7
/* The width in bits of the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_WIDTH      4
/* The mask used to set the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field value. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_SET_MSK    0x000000f0
/* The mask used to clear the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field value. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_CLR_MSK    0xffffff0f
/* The reset value of the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_RESET      0x0
/* Extracts the ALT_SYSMGR_NAND_L3MST_AWCACHE_0 field value from a register. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_GET(value) (((value) & 0x000000f0) >> 4)
/* Produces a ALT_SYSMGR_NAND_L3MST_AWCACHE_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_NAND_L3MST_AWCACHE_0_SET(value) (((value) << 4) & 0x000000f0)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_NAND_L3MST.
 */
struct ALT_SYSMGR_NAND_L3MST_s
{
    uint32_t  arcache_0 :  4;  /* NAND ARCACHE */
    uint32_t  awcache_0 :  4;  /* NAND AWCACHE */
    uint32_t            : 24;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_NAND_L3MST. */
typedef volatile struct ALT_SYSMGR_NAND_L3MST_s  ALT_SYSMGR_NAND_L3MST_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_NAND_L3MST register from the beginning of the component. */
#define ALT_SYSMGR_NAND_L3MST_OFST        0x4

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_NAND.
 */
struct ALT_SYSMGR_NAND_s
{
    volatile ALT_SYSMGR_NAND_BOOTSTRAP_t  bootstrap;  /* ALT_SYSMGR_NAND_BOOTSTRAP */
    volatile ALT_SYSMGR_NAND_L3MST_t      l3master;   /* ALT_SYSMGR_NAND_L3MST */
};

/* The typedef declaration for register group ALT_SYSMGR_NAND. */
typedef volatile struct ALT_SYSMGR_NAND_s  ALT_SYSMGR_NAND_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_NAND. */
struct ALT_SYSMGR_NAND_raw_s
{
    volatile uint32_t  bootstrap;  /* ALT_SYSMGR_NAND_BOOTSTRAP */
    volatile uint32_t  l3master;   /* ALT_SYSMGR_NAND_L3MST */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_NAND. */
typedef volatile struct ALT_SYSMGR_NAND_raw_s  ALT_SYSMGR_NAND_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : USB Controller Group - ALT_SYSMGR_USB
 * USB Controller Group
 * 
 * Registers related to USB Controllers which aren't located inside the USB
 * controllers themselves.
 * 
 */
/*
 * Register : USB L3 Master HPROT Register - l3master
 * 
 * Controls the L3 master HPROT AHB-Lite signal.
 * 
 * These register bits should be updated only during system initialization prior to
 * removing the peripheral from reset. They may not be changed dynamically during
 * peripheral operation
 * 
 * All fields are reset by a cold or warm reset.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description          
 * :-------|:-------|:------|:----------------------
 *  [0]    | RW     | 0x1   | USB HPROT Data/Opcode
 *  [1]    | RW     | 0x1   | USB HPROT Data/Opcode
 *  [2]    | RW     | 0x1   | USB HPROT Privileged 
 *  [3]    | RW     | 0x1   | USB HPROT Privileged 
 *  [4]    | RW     | 0x0   | USB HPROT Bufferable 
 *  [5]    | RW     | 0x0   | USB HPROT Bufferable 
 *  [6]    | RW     | 0x0   | USB HPROT Cacheable  
 *  [7]    | RW     | 0x0   | USB HPROT Cacheable  
 *  [31:8] | ???    | 0x0   | *UNDEFINED*          
 * 
 */
/*
 * Field : USB HPROT Data/Opcode - hprotdata_0
 * 
 * Specifies if the L3 master access is for data or opcode for the USB modules.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description 
 * :------------------------------------------|:------|:-------------
 *  ALT_SYSMGR_USB_L3MST_HPROTDATA_0_E_OPCODE | 0x0   | Opcode fetch
 *  ALT_SYSMGR_USB_L3MST_HPROTDATA_0_E_DATA   | 0x1   | Data access 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_USB_L3MST_HPROTDATA_0
 * 
 * Opcode fetch
 */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_E_OPCODE   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_USB_L3MST_HPROTDATA_0
 * 
 * Data access
 */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_E_DATA     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_MSB        0
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_RESET      0x1
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTDATA_0 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTDATA_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_0_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : USB HPROT Data/Opcode - hprotdata_1
 * 
 * Specifies if the L3 master access is for data or opcode for the USB modules.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Enumeration Values:
 * 
 *  Enum                                      | Value | Description 
 * :------------------------------------------|:------|:-------------
 *  ALT_SYSMGR_USB_L3MST_HPROTDATA_1_E_OPCODE | 0x0   | Opcode fetch
 *  ALT_SYSMGR_USB_L3MST_HPROTDATA_1_E_DATA   | 0x1   | Data access 
 * 
 * Field Access Macros:
 * 
 */
/*
 * Enumerated value for register field ALT_SYSMGR_USB_L3MST_HPROTDATA_1
 * 
 * Opcode fetch
 */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_E_OPCODE   0x0
/*
 * Enumerated value for register field ALT_SYSMGR_USB_L3MST_HPROTDATA_1
 * 
 * Data access
 */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_E_DATA     0x1

/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_MSB        1
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_RESET      0x1
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTDATA_1 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTDATA_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTDATA_1_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : USB HPROT Privileged - hprotpriv_0
 * 
 * If 1, L3 master accesses for the USB modules are privileged.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_MSB        2
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_RESET      0x1
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTPRIV_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_0_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : USB HPROT Privileged - hprotpriv_1
 * 
 * If 1, L3 master accesses for the USB modules are privileged.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_MSB        3
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_RESET      0x1
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTPRIV_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTPRIV_1_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : USB HPROT Bufferable - hprotbuff_0
 * 
 * If 1, L3 master accesses for the USB modules are bufferable.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_MSB        4
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_RESET      0x0
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTBUFF_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_0_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : USB HPROT Bufferable - hprotbuff_1
 * 
 * If 1, L3 master accesses for the USB modules are bufferable.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_MSB        5
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_RESET      0x0
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTBUFF_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTBUFF_1_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : USB HPROT Cacheable - hprotcache_0
 * 
 * If 1, L3 master accesses for the USB modules are cacheable.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_MSB        6
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_RESET      0x0
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTCACHE_0 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_0_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : USB HPROT Cacheable - hprotcache_1
 * 
 * If 1, L3 master accesses for the USB modules are cacheable.
 * 
 * The field array index corresponds to the USB index.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_MSB        7
/* The width in bits of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_WIDTH      1
/* The mask used to set the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field value. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_RESET      0x0
/* Extracts the ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 field value from a register. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_USB_L3MST_HPROTCACHE_1 register field value suitable for setting the register. */
#define ALT_SYSMGR_USB_L3MST_HPROTCACHE_1_SET(value) (((value) << 7) & 0x00000080)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_USB_L3MST.
 */
struct ALT_SYSMGR_USB_L3MST_s
{
    uint32_t  hprotdata_0  :  1;  /* USB HPROT Data/Opcode */
    uint32_t  hprotdata_1  :  1;  /* USB HPROT Data/Opcode */
    uint32_t  hprotpriv_0  :  1;  /* USB HPROT Privileged */
    uint32_t  hprotpriv_1  :  1;  /* USB HPROT Privileged */
    uint32_t  hprotbuff_0  :  1;  /* USB HPROT Bufferable */
    uint32_t  hprotbuff_1  :  1;  /* USB HPROT Bufferable */
    uint32_t  hprotcache_0 :  1;  /* USB HPROT Cacheable */
    uint32_t  hprotcache_1 :  1;  /* USB HPROT Cacheable */
    uint32_t               : 24;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_USB_L3MST. */
typedef volatile struct ALT_SYSMGR_USB_L3MST_s  ALT_SYSMGR_USB_L3MST_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_USB_L3MST register from the beginning of the component. */
#define ALT_SYSMGR_USB_L3MST_OFST        0x0

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_USB.
 */
struct ALT_SYSMGR_USB_s
{
    volatile ALT_SYSMGR_USB_L3MST_t  l3master;  /* ALT_SYSMGR_USB_L3MST */
};

/* The typedef declaration for register group ALT_SYSMGR_USB. */
typedef volatile struct ALT_SYSMGR_USB_s  ALT_SYSMGR_USB_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_USB. */
struct ALT_SYSMGR_USB_raw_s
{
    volatile uint32_t  l3master;  /* ALT_SYSMGR_USB_L3MST */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_USB. */
typedef volatile struct ALT_SYSMGR_USB_raw_s  ALT_SYSMGR_USB_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : ECC Management Register Group - ALT_SYSMGR_ECC
 * ECC Management Register Group
 * 
 * ECC error status and control for all ECC-protected HPS RAM blocks.
 * 
 */
/*
 * Register : L2 Data RAM ECC Enable Register - l2
 * 
 * This register is used to enable ECC on the L2 Data RAM. ECC errors can be
 * injected into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                             
 * :-------|:-------|:------|:---------------------------------------------------------
 *  [0]    | RW     | 0x0   | L2 Data RAM ECC Enable                                  
 *  [1]    | RW     | 0x0   | L2 Data RAM ECC inject single, correctable Error        
 *  [2]    | RW     | 0x0   | L2 Data RAM ECC inject double bit, non-correctable error
 *  [31:3] | ???    | 0x0   | *UNDEFINED*                                             
 * 
 */
/*
 * Field : L2 Data RAM ECC Enable - en
 * 
 * Enable ECC for L2 Data RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_L2_EN register field. */
#define ALT_SYSMGR_ECC_L2_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_L2_EN register field. */
#define ALT_SYSMGR_ECC_L2_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_L2_EN register field. */
#define ALT_SYSMGR_ECC_L2_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_L2_EN register field value. */
#define ALT_SYSMGR_ECC_L2_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_L2_EN register field value. */
#define ALT_SYSMGR_ECC_L2_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_L2_EN register field. */
#define ALT_SYSMGR_ECC_L2_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_L2_EN field value from a register. */
#define ALT_SYSMGR_ECC_L2_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_L2_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_L2_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : L2 Data RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * L2 Data RAM. This only injects one error into the L2 Data RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_L2_INJS register field. */
#define ALT_SYSMGR_ECC_L2_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_L2_INJS register field. */
#define ALT_SYSMGR_ECC_L2_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_L2_INJS register field. */
#define ALT_SYSMGR_ECC_L2_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_L2_INJS register field value. */
#define ALT_SYSMGR_ECC_L2_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_L2_INJS register field value. */
#define ALT_SYSMGR_ECC_L2_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_L2_INJS register field. */
#define ALT_SYSMGR_ECC_L2_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_L2_INJS field value from a register. */
#define ALT_SYSMGR_ECC_L2_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_L2_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_L2_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : L2 Data RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the L2 Data RAM. This only injects one double bit error into the L2 Data RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_L2_INJD register field. */
#define ALT_SYSMGR_ECC_L2_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_L2_INJD register field. */
#define ALT_SYSMGR_ECC_L2_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_L2_INJD register field. */
#define ALT_SYSMGR_ECC_L2_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_L2_INJD register field value. */
#define ALT_SYSMGR_ECC_L2_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_L2_INJD register field value. */
#define ALT_SYSMGR_ECC_L2_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_L2_INJD register field. */
#define ALT_SYSMGR_ECC_L2_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_L2_INJD field value from a register. */
#define ALT_SYSMGR_ECC_L2_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_L2_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_L2_INJD_SET(value) (((value) << 2) & 0x00000004)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_L2.
 */
struct ALT_SYSMGR_ECC_L2_s
{
    uint32_t  en   :  1;  /* L2 Data RAM ECC Enable */
    uint32_t  injs :  1;  /* L2 Data RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* L2 Data RAM ECC inject double bit, non-correctable error */
    uint32_t       : 29;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_L2. */
typedef volatile struct ALT_SYSMGR_ECC_L2_s  ALT_SYSMGR_ECC_L2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_L2 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_L2_OFST        0x0

/*
 * Register : On-chip RAM ECC Enable Register - ocram
 * 
 * This register is used to enable ECC on the On-chip RAM. ECC errors can be
 * injected into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                       
 * :-------|:-------|:------|:-------------------------------------------------------------------
 *  [0]    | RW     | 0x0   | On-chip RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | On-chip RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | On-chip RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | On-chip RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | On-chip RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                       
 * 
 */
/*
 * Field : On-chip RAM ECC Enable - en
 * 
 * Enable ECC for On-chip RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_OCRAM_EN register field. */
#define ALT_SYSMGR_ECC_OCRAM_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_OCRAM_EN register field. */
#define ALT_SYSMGR_ECC_OCRAM_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_OCRAM_EN register field. */
#define ALT_SYSMGR_ECC_OCRAM_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_OCRAM_EN register field value. */
#define ALT_SYSMGR_ECC_OCRAM_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_OCRAM_EN register field value. */
#define ALT_SYSMGR_ECC_OCRAM_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_OCRAM_EN register field. */
#define ALT_SYSMGR_ECC_OCRAM_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_OCRAM_EN field value from a register. */
#define ALT_SYSMGR_ECC_OCRAM_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_OCRAM_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_OCRAM_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : On-chip RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * On-chip RAM. This only injects one error into the On-chip RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_OCRAM_INJS register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_OCRAM_INJS register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_OCRAM_INJS register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_OCRAM_INJS register field value. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_OCRAM_INJS register field value. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_OCRAM_INJS register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_OCRAM_INJS field value from a register. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_OCRAM_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_OCRAM_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : On-chip RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the On-chip RAM. This only injects one double bit error into the On-chip RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_OCRAM_INJD register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_OCRAM_INJD register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_OCRAM_INJD register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_OCRAM_INJD register field value. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_OCRAM_INJD register field value. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_OCRAM_INJD register field. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_OCRAM_INJD field value from a register. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_OCRAM_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_OCRAM_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : On-chip RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for On-chip RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in On-chip
 * RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_OCRAM_SERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_OCRAM_SERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_OCRAM_SERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_OCRAM_SERR register field value. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_OCRAM_SERR register field value. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_OCRAM_SERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_OCRAM_SERR field value from a register. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_OCRAM_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_OCRAM_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : On-chip RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for On-chip RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in On-chip RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_OCRAM_DERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_OCRAM_DERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_OCRAM_DERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_OCRAM_DERR register field value. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_OCRAM_DERR register field value. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_OCRAM_DERR register field. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_OCRAM_DERR field value from a register. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_OCRAM_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_OCRAM_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_OCRAM.
 */
struct ALT_SYSMGR_ECC_OCRAM_s
{
    uint32_t  en   :  1;  /* On-chip RAM ECC Enable */
    uint32_t  injs :  1;  /* On-chip RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* On-chip RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* On-chip RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* On-chip RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_OCRAM. */
typedef volatile struct ALT_SYSMGR_ECC_OCRAM_s  ALT_SYSMGR_ECC_OCRAM_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_OCRAM register from the beginning of the component. */
#define ALT_SYSMGR_ECC_OCRAM_OFST        0x4

/*
 * Register : USB0 RAM ECC Enable Register - usb0
 * 
 * This register is used to enable ECC on the USB0 RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                    
 * :-------|:-------|:------|:----------------------------------------------------------------
 *  [0]    | RW     | 0x0   | USB0 RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | USB0 RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | USB0 RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | USB0 RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | USB0 RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                    
 * 
 */
/*
 * Field : USB0 RAM ECC Enable - en
 * 
 * Enable ECC for USB0 RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB0_EN register field. */
#define ALT_SYSMGR_ECC_USB0_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB0_EN register field. */
#define ALT_SYSMGR_ECC_USB0_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_USB0_EN register field. */
#define ALT_SYSMGR_ECC_USB0_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB0_EN register field value. */
#define ALT_SYSMGR_ECC_USB0_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_USB0_EN register field value. */
#define ALT_SYSMGR_ECC_USB0_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_USB0_EN register field. */
#define ALT_SYSMGR_ECC_USB0_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB0_EN field value from a register. */
#define ALT_SYSMGR_ECC_USB0_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_USB0_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB0_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : USB0 RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * USB0 RAM. This only injects one error into the USB0 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB0_INJS register field. */
#define ALT_SYSMGR_ECC_USB0_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB0_INJS register field. */
#define ALT_SYSMGR_ECC_USB0_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_USB0_INJS register field. */
#define ALT_SYSMGR_ECC_USB0_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB0_INJS register field value. */
#define ALT_SYSMGR_ECC_USB0_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_USB0_INJS register field value. */
#define ALT_SYSMGR_ECC_USB0_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_USB0_INJS register field. */
#define ALT_SYSMGR_ECC_USB0_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB0_INJS field value from a register. */
#define ALT_SYSMGR_ECC_USB0_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_USB0_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB0_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : USB0 RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the USB0 RAM. This only injects one double bit error into the USB0 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB0_INJD register field. */
#define ALT_SYSMGR_ECC_USB0_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB0_INJD register field. */
#define ALT_SYSMGR_ECC_USB0_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_USB0_INJD register field. */
#define ALT_SYSMGR_ECC_USB0_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB0_INJD register field value. */
#define ALT_SYSMGR_ECC_USB0_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_USB0_INJD register field value. */
#define ALT_SYSMGR_ECC_USB0_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_USB0_INJD register field. */
#define ALT_SYSMGR_ECC_USB0_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB0_INJD field value from a register. */
#define ALT_SYSMGR_ECC_USB0_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_USB0_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB0_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : USB0 RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for USB0 RAM ECC single, correctable error.
 * It is set by hardware when single, correctable error occurs in USB0 RAM.
 * Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB0_SERR register field. */
#define ALT_SYSMGR_ECC_USB0_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB0_SERR register field. */
#define ALT_SYSMGR_ECC_USB0_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_USB0_SERR register field. */
#define ALT_SYSMGR_ECC_USB0_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB0_SERR register field value. */
#define ALT_SYSMGR_ECC_USB0_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_USB0_SERR register field value. */
#define ALT_SYSMGR_ECC_USB0_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_USB0_SERR register field. */
#define ALT_SYSMGR_ECC_USB0_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB0_SERR field value from a register. */
#define ALT_SYSMGR_ECC_USB0_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_USB0_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB0_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : USB0 RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for USB0 RAM ECC double bit, non-correctable
 * error. It is set by hardware when double bit, non-correctable error occurs in
 * USB0 RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB0_DERR register field. */
#define ALT_SYSMGR_ECC_USB0_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB0_DERR register field. */
#define ALT_SYSMGR_ECC_USB0_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_USB0_DERR register field. */
#define ALT_SYSMGR_ECC_USB0_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB0_DERR register field value. */
#define ALT_SYSMGR_ECC_USB0_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_USB0_DERR register field value. */
#define ALT_SYSMGR_ECC_USB0_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_USB0_DERR register field. */
#define ALT_SYSMGR_ECC_USB0_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB0_DERR field value from a register. */
#define ALT_SYSMGR_ECC_USB0_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_USB0_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB0_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_USB0.
 */
struct ALT_SYSMGR_ECC_USB0_s
{
    uint32_t  en   :  1;  /* USB0 RAM ECC Enable */
    uint32_t  injs :  1;  /* USB0 RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* USB0 RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* USB0 RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* USB0 RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_USB0. */
typedef volatile struct ALT_SYSMGR_ECC_USB0_s  ALT_SYSMGR_ECC_USB0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_USB0 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_USB0_OFST        0x8

/*
 * Register : USB1 RAM ECC Enable Register - usb1
 * 
 * This register is used to enable ECC on the USB1 RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                    
 * :-------|:-------|:------|:----------------------------------------------------------------
 *  [0]    | RW     | 0x0   | USB1 RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | USB1 RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | USB1 RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | USB1 RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | USB1 RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                    
 * 
 */
/*
 * Field : USB1 RAM ECC Enable - en
 * 
 * Enable ECC for USB1 RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB1_EN register field. */
#define ALT_SYSMGR_ECC_USB1_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB1_EN register field. */
#define ALT_SYSMGR_ECC_USB1_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_USB1_EN register field. */
#define ALT_SYSMGR_ECC_USB1_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB1_EN register field value. */
#define ALT_SYSMGR_ECC_USB1_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_USB1_EN register field value. */
#define ALT_SYSMGR_ECC_USB1_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_USB1_EN register field. */
#define ALT_SYSMGR_ECC_USB1_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB1_EN field value from a register. */
#define ALT_SYSMGR_ECC_USB1_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_USB1_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB1_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : USB1 RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * USB1 RAM. This only injects one error into the USB1 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB1_INJS register field. */
#define ALT_SYSMGR_ECC_USB1_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB1_INJS register field. */
#define ALT_SYSMGR_ECC_USB1_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_USB1_INJS register field. */
#define ALT_SYSMGR_ECC_USB1_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB1_INJS register field value. */
#define ALT_SYSMGR_ECC_USB1_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_USB1_INJS register field value. */
#define ALT_SYSMGR_ECC_USB1_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_USB1_INJS register field. */
#define ALT_SYSMGR_ECC_USB1_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB1_INJS field value from a register. */
#define ALT_SYSMGR_ECC_USB1_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_USB1_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB1_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : USB1 RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the USB1 RAM. This only injects one double bit error into the USB1 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB1_INJD register field. */
#define ALT_SYSMGR_ECC_USB1_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB1_INJD register field. */
#define ALT_SYSMGR_ECC_USB1_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_USB1_INJD register field. */
#define ALT_SYSMGR_ECC_USB1_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB1_INJD register field value. */
#define ALT_SYSMGR_ECC_USB1_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_USB1_INJD register field value. */
#define ALT_SYSMGR_ECC_USB1_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_USB1_INJD register field. */
#define ALT_SYSMGR_ECC_USB1_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB1_INJD field value from a register. */
#define ALT_SYSMGR_ECC_USB1_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_USB1_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB1_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : USB1 RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for USB1 RAM ECC single, correctable error.
 * It is set by hardware when single, correctable error occurs in USB1 RAM.
 * Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB1_SERR register field. */
#define ALT_SYSMGR_ECC_USB1_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB1_SERR register field. */
#define ALT_SYSMGR_ECC_USB1_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_USB1_SERR register field. */
#define ALT_SYSMGR_ECC_USB1_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB1_SERR register field value. */
#define ALT_SYSMGR_ECC_USB1_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_USB1_SERR register field value. */
#define ALT_SYSMGR_ECC_USB1_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_USB1_SERR register field. */
#define ALT_SYSMGR_ECC_USB1_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB1_SERR field value from a register. */
#define ALT_SYSMGR_ECC_USB1_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_USB1_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB1_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : USB1 RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for USB1 RAM ECC double bit, non-correctable
 * error. It is set by hardware when double bit, non-correctable error occurs in
 * USB1 RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_USB1_DERR register field. */
#define ALT_SYSMGR_ECC_USB1_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_USB1_DERR register field. */
#define ALT_SYSMGR_ECC_USB1_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_USB1_DERR register field. */
#define ALT_SYSMGR_ECC_USB1_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_USB1_DERR register field value. */
#define ALT_SYSMGR_ECC_USB1_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_USB1_DERR register field value. */
#define ALT_SYSMGR_ECC_USB1_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_USB1_DERR register field. */
#define ALT_SYSMGR_ECC_USB1_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_USB1_DERR field value from a register. */
#define ALT_SYSMGR_ECC_USB1_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_USB1_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_USB1_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_USB1.
 */
struct ALT_SYSMGR_ECC_USB1_s
{
    uint32_t  en   :  1;  /* USB1 RAM ECC Enable */
    uint32_t  injs :  1;  /* USB1 RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* USB1 RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* USB1 RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* USB1 RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_USB1. */
typedef volatile struct ALT_SYSMGR_ECC_USB1_s  ALT_SYSMGR_ECC_USB1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_USB1 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_USB1_OFST        0xc

/*
 * Register : EMAC0 RAM ECC Enable Register - emac0
 * 
 * This register is used to enable ECC on the EMAC0 RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                            
 * :-------|:-------|:------|:------------------------------------------------------------------------
 *  [0]    | RW     | 0x0   | EMAC0 RAM ECC Enable                                                   
 *  [1]    | RW     | 0x0   | EMAC0 TXFIFO RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | EMAC0 TXFIFO RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | EMAC0 RXFIFO RAM ECC inject single, correctable Error                  
 *  [4]    | RW     | 0x0   | EMAC0 RXFIFO RAM ECC inject double bit, non-correctable error          
 *  [5]    | RW     | 0x0   | EMAC0 TXFIFO RAM ECC single, correctable error interrupt status        
 *  [6]    | RW     | 0x0   | EMAC0 TXFIFO RAM ECC double bit, non-correctable error interrupt status
 *  [7]    | RW     | 0x0   | EMAC0 RXFIFO RAM ECC single, correctable error interrupt status        
 *  [8]    | RW     | 0x0   | EMAC0 RXFIFO RAM ECC double bit, non-correctable error interrupt status
 *  [31:9] | ???    | 0x0   | *UNDEFINED*                                                            
 * 
 */
/*
 * Field : EMAC0 RAM ECC Enable - en
 * 
 * Enable ECC for EMAC0 RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_EN register field. */
#define ALT_SYSMGR_ECC_EMAC0_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_EN register field. */
#define ALT_SYSMGR_ECC_EMAC0_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_EN register field. */
#define ALT_SYSMGR_ECC_EMAC0_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_EN register field value. */
#define ALT_SYSMGR_ECC_EMAC0_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_EN register field value. */
#define ALT_SYSMGR_ECC_EMAC0_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_EN register field. */
#define ALT_SYSMGR_ECC_EMAC0_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_EN field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_EMAC0_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : EMAC0 TXFIFO RAM ECC inject single, correctable Error - txfifoinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * EMAC0 TXFIFO RAM. This only injects one error into the EMAC0 TXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : EMAC0 TXFIFO RAM ECC inject double bit, non-correctable error - txfifoinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the EMAC0 TXFIFO RAM. This only injects one double bit error into the EMAC0
 * TXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOINJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : EMAC0 RXFIFO RAM ECC inject single, correctable Error - rxfifoinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * EMAC0 RXFIFO RAM. This only injects one error into the EMAC0 RXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : EMAC0 RXFIFO RAM ECC inject double bit, non-correctable error - rxfifoinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the EMAC0 RXFIFO RAM. This only injects one double bit error into the EMAC0
 * RXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOINJD_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : EMAC0 TXFIFO RAM ECC single, correctable error interrupt status - txfifoserr
 * 
 * This bit is an interrupt status bit for EMAC0 TXFIFO RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in EMAC0
 * TXFIFO RAM. Software needs to write 1 into this bit to clear the interrupt
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_MSB        5
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFOSERR_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : EMAC0 TXFIFO RAM ECC double bit, non-correctable error interrupt status - txfifoderr
 * 
 * This bit is an interrupt status bit for EMAC0 TXFIFO RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in EMAC0 TXFIFO RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_MSB        6
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_TXFIFODERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_ECC_EMAC0_TXFIFODERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_TXFIFODERR_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : EMAC0 RXFIFO RAM ECC single, correctable error interrupt status - rxfifoserr
 * 
 * This bit is an interrupt status bit for EMAC0 RXFIFO RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in EMAC0
 * RXFIFO RAM. Software needs to write 1 into this bit to clear the interrupt
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_MSB        7
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFOSERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : EMAC0 RXFIFO RAM ECC double bit, non-correctable error interrupt status - rxfifoderr
 * 
 * This bit is an interrupt status bit for EMAC0 RXFIFO RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in EMAC0 RXFIFO RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_MSB        8
/* The width in bits of the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC0_RXFIFODERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_SYSMGR_ECC_EMAC0_RXFIFODERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC0_RXFIFODERR_SET(value) (((value) << 8) & 0x00000100)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_EMAC0.
 */
struct ALT_SYSMGR_ECC_EMAC0_s
{
    uint32_t  en         :  1;  /* EMAC0 RAM ECC Enable */
    uint32_t  txfifoinjs :  1;  /* EMAC0 TXFIFO RAM ECC inject single, correctable Error */
    uint32_t  txfifoinjd :  1;  /* EMAC0 TXFIFO RAM ECC inject double bit, non-correctable error */
    uint32_t  rxfifoinjs :  1;  /* EMAC0 RXFIFO RAM ECC inject single, correctable Error */
    uint32_t  rxfifoinjd :  1;  /* EMAC0 RXFIFO RAM ECC inject double bit, non-correctable error */
    uint32_t  txfifoserr :  1;  /* EMAC0 TXFIFO RAM ECC single, correctable error interrupt status */
    uint32_t  txfifoderr :  1;  /* EMAC0 TXFIFO RAM ECC double bit, non-correctable error interrupt status */
    uint32_t  rxfifoserr :  1;  /* EMAC0 RXFIFO RAM ECC single, correctable error interrupt status */
    uint32_t  rxfifoderr :  1;  /* EMAC0 RXFIFO RAM ECC double bit, non-correctable error interrupt status */
    uint32_t             : 23;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_EMAC0. */
typedef volatile struct ALT_SYSMGR_ECC_EMAC0_s  ALT_SYSMGR_ECC_EMAC0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_EMAC0 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_EMAC0_OFST        0x10

/*
 * Register : EMAC1 RAM ECC Enable Register - emac1
 * 
 * This register is used to enable ECC on the EMAC1 RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                            
 * :-------|:-------|:------|:------------------------------------------------------------------------
 *  [0]    | RW     | 0x0   | EMAC1 RAM ECC Enable                                                   
 *  [1]    | RW     | 0x0   | EMAC1 TXFIFO RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | EMAC1 TXFIFO RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | EMAC1 RXFIFO RAM ECC inject single, correctable Error                  
 *  [4]    | RW     | 0x0   | EMAC1 RXFIFO RAM ECC inject double bit, non-correctable error          
 *  [5]    | RW     | 0x0   | EMAC1 TXFIFO RAM ECC single, correctable error interrupt status        
 *  [6]    | RW     | 0x0   | EMAC1 TXFIFO RAM ECC double bit, non-correctable error interrupt status
 *  [7]    | RW     | 0x0   | EMAC1 RXFIFO RAM ECC single, correctable error interrupt status        
 *  [8]    | RW     | 0x0   | EMAC1 RXFIFO RAM ECC double bit, non-correctable error interrupt status
 *  [31:9] | ???    | 0x0   | *UNDEFINED*                                                            
 * 
 */
/*
 * Field : EMAC1 RAM ECC Enable - en
 * 
 * Enable ECC for EMAC1 RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_EN register field. */
#define ALT_SYSMGR_ECC_EMAC1_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_EN register field. */
#define ALT_SYSMGR_ECC_EMAC1_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_EN register field. */
#define ALT_SYSMGR_ECC_EMAC1_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_EN register field value. */
#define ALT_SYSMGR_ECC_EMAC1_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_EN register field value. */
#define ALT_SYSMGR_ECC_EMAC1_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_EN register field. */
#define ALT_SYSMGR_ECC_EMAC1_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_EN field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_EMAC1_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : EMAC1 TXFIFO RAM ECC inject single, correctable Error - txfifoinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * EMAC1 TXFIFO RAM. This only injects one error into the EMAC1 TXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : EMAC1 TXFIFO RAM ECC inject double bit, non-correctable error - txfifoinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the EMAC1 TXFIFO RAM. This only injects one double bit error into the EMAC1
 * TXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOINJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : EMAC1 RXFIFO RAM ECC inject single, correctable Error - rxfifoinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * EMAC1 RXFIFO RAM. This only injects one error into the EMAC1 RXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : EMAC1 RXFIFO RAM ECC inject double bit, non-correctable error - rxfifoinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the EMAC1 RXFIFO RAM. This only injects one double bit error into the EMAC1
 * RXFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOINJD_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : EMAC1 TXFIFO RAM ECC single, correctable error interrupt status - txfifoserr
 * 
 * This bit is an interrupt status bit for EMAC1 TXFIFO RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in EMAC1
 * TXFIFO RAM. Software needs to write 1 into this bit to clear the interrupt
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_MSB        5
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFOSERR_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : EMAC1 TXFIFO RAM ECC double bit, non-correctable error interrupt status - txfifoderr
 * 
 * This bit is an interrupt status bit for EMAC1 TXFIFO RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in EMAC1 TXFIFO RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_MSB        6
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_TXFIFODERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_ECC_EMAC1_TXFIFODERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_TXFIFODERR_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : EMAC1 RXFIFO RAM ECC single, correctable error interrupt status - rxfifoserr
 * 
 * This bit is an interrupt status bit for EMAC1 RXFIFO RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in EMAC1
 * RXFIFO RAM. Software needs to write 1 into this bit to clear the interrupt
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_MSB        7
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFOSERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : EMAC1 RXFIFO RAM ECC double bit, non-correctable error interrupt status - rxfifoderr
 * 
 * This bit is an interrupt status bit for EMAC1 RXFIFO RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in EMAC1 RXFIFO RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_MSB        8
/* The width in bits of the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field value. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_EMAC1_RXFIFODERR field value from a register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_SYSMGR_ECC_EMAC1_RXFIFODERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_EMAC1_RXFIFODERR_SET(value) (((value) << 8) & 0x00000100)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_EMAC1.
 */
struct ALT_SYSMGR_ECC_EMAC1_s
{
    uint32_t  en         :  1;  /* EMAC1 RAM ECC Enable */
    uint32_t  txfifoinjs :  1;  /* EMAC1 TXFIFO RAM ECC inject single, correctable Error */
    uint32_t  txfifoinjd :  1;  /* EMAC1 TXFIFO RAM ECC inject double bit, non-correctable error */
    uint32_t  rxfifoinjs :  1;  /* EMAC1 RXFIFO RAM ECC inject single, correctable Error */
    uint32_t  rxfifoinjd :  1;  /* EMAC1 RXFIFO RAM ECC inject double bit, non-correctable error */
    uint32_t  txfifoserr :  1;  /* EMAC1 TXFIFO RAM ECC single, correctable error interrupt status */
    uint32_t  txfifoderr :  1;  /* EMAC1 TXFIFO RAM ECC double bit, non-correctable error interrupt status */
    uint32_t  rxfifoserr :  1;  /* EMAC1 RXFIFO RAM ECC single, correctable error interrupt status */
    uint32_t  rxfifoderr :  1;  /* EMAC1 RXFIFO RAM ECC double bit, non-correctable error interrupt status */
    uint32_t             : 23;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_EMAC1. */
typedef volatile struct ALT_SYSMGR_ECC_EMAC1_s  ALT_SYSMGR_ECC_EMAC1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_EMAC1 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_EMAC1_OFST        0x14

/*
 * Register : DMA RAM ECC Enable Register - dma
 * 
 * This register is used to enable ECC on the DMA RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                   
 * :-------|:-------|:------|:---------------------------------------------------------------
 *  [0]    | RW     | 0x0   | DMA RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | DMA RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | DMA RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | DMA RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | DMA RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                   
 * 
 */
/*
 * Field : DMA RAM ECC Enable - en
 * 
 * Enable ECC for DMA RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_DMA_EN register field. */
#define ALT_SYSMGR_ECC_DMA_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_DMA_EN register field. */
#define ALT_SYSMGR_ECC_DMA_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_DMA_EN register field. */
#define ALT_SYSMGR_ECC_DMA_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_DMA_EN register field value. */
#define ALT_SYSMGR_ECC_DMA_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_DMA_EN register field value. */
#define ALT_SYSMGR_ECC_DMA_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_DMA_EN register field. */
#define ALT_SYSMGR_ECC_DMA_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_DMA_EN field value from a register. */
#define ALT_SYSMGR_ECC_DMA_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_DMA_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_DMA_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : DMA RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * DMA RAM. This only injects one error into the DMA RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_DMA_INJS register field. */
#define ALT_SYSMGR_ECC_DMA_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_DMA_INJS register field. */
#define ALT_SYSMGR_ECC_DMA_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_DMA_INJS register field. */
#define ALT_SYSMGR_ECC_DMA_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_DMA_INJS register field value. */
#define ALT_SYSMGR_ECC_DMA_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_DMA_INJS register field value. */
#define ALT_SYSMGR_ECC_DMA_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_DMA_INJS register field. */
#define ALT_SYSMGR_ECC_DMA_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_DMA_INJS field value from a register. */
#define ALT_SYSMGR_ECC_DMA_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_DMA_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_DMA_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : DMA RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the DMA RAM. This only injects one double bit error into the DMA RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_DMA_INJD register field. */
#define ALT_SYSMGR_ECC_DMA_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_DMA_INJD register field. */
#define ALT_SYSMGR_ECC_DMA_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_DMA_INJD register field. */
#define ALT_SYSMGR_ECC_DMA_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_DMA_INJD register field value. */
#define ALT_SYSMGR_ECC_DMA_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_DMA_INJD register field value. */
#define ALT_SYSMGR_ECC_DMA_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_DMA_INJD register field. */
#define ALT_SYSMGR_ECC_DMA_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_DMA_INJD field value from a register. */
#define ALT_SYSMGR_ECC_DMA_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_DMA_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_DMA_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : DMA RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for DMA RAM ECC single, correctable error.
 * It is set by hardware when single, correctable error occurs in DMA RAM. Software
 * needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_DMA_SERR register field. */
#define ALT_SYSMGR_ECC_DMA_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_DMA_SERR register field. */
#define ALT_SYSMGR_ECC_DMA_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_DMA_SERR register field. */
#define ALT_SYSMGR_ECC_DMA_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_DMA_SERR register field value. */
#define ALT_SYSMGR_ECC_DMA_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_DMA_SERR register field value. */
#define ALT_SYSMGR_ECC_DMA_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_DMA_SERR register field. */
#define ALT_SYSMGR_ECC_DMA_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_DMA_SERR field value from a register. */
#define ALT_SYSMGR_ECC_DMA_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_DMA_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_DMA_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : DMA RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for DMA RAM ECC double bit, non-correctable
 * error. It is set by hardware when double bit, non-correctable error occurs in
 * DMA RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_DMA_DERR register field. */
#define ALT_SYSMGR_ECC_DMA_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_DMA_DERR register field. */
#define ALT_SYSMGR_ECC_DMA_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_DMA_DERR register field. */
#define ALT_SYSMGR_ECC_DMA_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_DMA_DERR register field value. */
#define ALT_SYSMGR_ECC_DMA_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_DMA_DERR register field value. */
#define ALT_SYSMGR_ECC_DMA_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_DMA_DERR register field. */
#define ALT_SYSMGR_ECC_DMA_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_DMA_DERR field value from a register. */
#define ALT_SYSMGR_ECC_DMA_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_DMA_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_DMA_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_DMA.
 */
struct ALT_SYSMGR_ECC_DMA_s
{
    uint32_t  en   :  1;  /* DMA RAM ECC Enable */
    uint32_t  injs :  1;  /* DMA RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* DMA RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* DMA RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* DMA RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_DMA. */
typedef volatile struct ALT_SYSMGR_ECC_DMA_s  ALT_SYSMGR_ECC_DMA_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_DMA register from the beginning of the component. */
#define ALT_SYSMGR_ECC_DMA_OFST        0x18

/*
 * Register : CAN0 RAM ECC Enable Register - can0
 * 
 * This register is used to enable ECC on the CAN0 RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                    
 * :-------|:-------|:------|:----------------------------------------------------------------
 *  [0]    | RW     | 0x0   | CAN0 RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | CAN0 RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | CAN0 RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | CAN0 RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | CAN0 RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                    
 * 
 */
/*
 * Field : CAN0 RAM ECC Enable - en
 * 
 * Enable ECC for CAN0 RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN0_EN register field. */
#define ALT_SYSMGR_ECC_CAN0_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN0_EN register field. */
#define ALT_SYSMGR_ECC_CAN0_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_CAN0_EN register field. */
#define ALT_SYSMGR_ECC_CAN0_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN0_EN register field value. */
#define ALT_SYSMGR_ECC_CAN0_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_CAN0_EN register field value. */
#define ALT_SYSMGR_ECC_CAN0_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_CAN0_EN register field. */
#define ALT_SYSMGR_ECC_CAN0_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN0_EN field value from a register. */
#define ALT_SYSMGR_ECC_CAN0_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_CAN0_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN0_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : CAN0 RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * CAN0 RAM. This only injects one error into the CAN0 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN0_INJS register field. */
#define ALT_SYSMGR_ECC_CAN0_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN0_INJS register field. */
#define ALT_SYSMGR_ECC_CAN0_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_CAN0_INJS register field. */
#define ALT_SYSMGR_ECC_CAN0_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN0_INJS register field value. */
#define ALT_SYSMGR_ECC_CAN0_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_CAN0_INJS register field value. */
#define ALT_SYSMGR_ECC_CAN0_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_CAN0_INJS register field. */
#define ALT_SYSMGR_ECC_CAN0_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN0_INJS field value from a register. */
#define ALT_SYSMGR_ECC_CAN0_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_CAN0_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN0_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : CAN0 RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the CAN0 RAM. This only injects one double bit error into the CAN0 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN0_INJD register field. */
#define ALT_SYSMGR_ECC_CAN0_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN0_INJD register field. */
#define ALT_SYSMGR_ECC_CAN0_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_CAN0_INJD register field. */
#define ALT_SYSMGR_ECC_CAN0_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN0_INJD register field value. */
#define ALT_SYSMGR_ECC_CAN0_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_CAN0_INJD register field value. */
#define ALT_SYSMGR_ECC_CAN0_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_CAN0_INJD register field. */
#define ALT_SYSMGR_ECC_CAN0_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN0_INJD field value from a register. */
#define ALT_SYSMGR_ECC_CAN0_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_CAN0_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN0_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : CAN0 RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for CAN0 RAM ECC single, correctable error.
 * It is set by hardware when single, correctable error occurs in CAN0 RAM.
 * Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN0_SERR register field. */
#define ALT_SYSMGR_ECC_CAN0_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN0_SERR register field. */
#define ALT_SYSMGR_ECC_CAN0_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_CAN0_SERR register field. */
#define ALT_SYSMGR_ECC_CAN0_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN0_SERR register field value. */
#define ALT_SYSMGR_ECC_CAN0_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_CAN0_SERR register field value. */
#define ALT_SYSMGR_ECC_CAN0_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_CAN0_SERR register field. */
#define ALT_SYSMGR_ECC_CAN0_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN0_SERR field value from a register. */
#define ALT_SYSMGR_ECC_CAN0_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_CAN0_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN0_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : CAN0 RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for CAN0 RAM ECC double bit, non-correctable
 * error. It is set by hardware when double bit, non-correctable error occurs in
 * CAN0 RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN0_DERR register field. */
#define ALT_SYSMGR_ECC_CAN0_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN0_DERR register field. */
#define ALT_SYSMGR_ECC_CAN0_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_CAN0_DERR register field. */
#define ALT_SYSMGR_ECC_CAN0_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN0_DERR register field value. */
#define ALT_SYSMGR_ECC_CAN0_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_CAN0_DERR register field value. */
#define ALT_SYSMGR_ECC_CAN0_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_CAN0_DERR register field. */
#define ALT_SYSMGR_ECC_CAN0_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN0_DERR field value from a register. */
#define ALT_SYSMGR_ECC_CAN0_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_CAN0_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN0_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_CAN0.
 */
struct ALT_SYSMGR_ECC_CAN0_s
{
    uint32_t  en   :  1;  /* CAN0 RAM ECC Enable */
    uint32_t  injs :  1;  /* CAN0 RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* CAN0 RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* CAN0 RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* CAN0 RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_CAN0. */
typedef volatile struct ALT_SYSMGR_ECC_CAN0_s  ALT_SYSMGR_ECC_CAN0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_CAN0 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_CAN0_OFST        0x1c

/*
 * Register : CAN1 RAM ECC Enable Register - can1
 * 
 * This register is used to enable ECC on the CAN1 RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                    
 * :-------|:-------|:------|:----------------------------------------------------------------
 *  [0]    | RW     | 0x0   | CAN1 RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | CAN1 RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | CAN1 RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | CAN1 RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | CAN1 RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                    
 * 
 */
/*
 * Field : CAN1 RAM ECC Enable - en
 * 
 * Enable ECC for CAN1 RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN1_EN register field. */
#define ALT_SYSMGR_ECC_CAN1_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN1_EN register field. */
#define ALT_SYSMGR_ECC_CAN1_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_CAN1_EN register field. */
#define ALT_SYSMGR_ECC_CAN1_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN1_EN register field value. */
#define ALT_SYSMGR_ECC_CAN1_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_CAN1_EN register field value. */
#define ALT_SYSMGR_ECC_CAN1_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_CAN1_EN register field. */
#define ALT_SYSMGR_ECC_CAN1_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN1_EN field value from a register. */
#define ALT_SYSMGR_ECC_CAN1_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_CAN1_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN1_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : CAN1 RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * CAN1 RAM. This only injects one error into the CAN1 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN1_INJS register field. */
#define ALT_SYSMGR_ECC_CAN1_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN1_INJS register field. */
#define ALT_SYSMGR_ECC_CAN1_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_CAN1_INJS register field. */
#define ALT_SYSMGR_ECC_CAN1_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN1_INJS register field value. */
#define ALT_SYSMGR_ECC_CAN1_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_CAN1_INJS register field value. */
#define ALT_SYSMGR_ECC_CAN1_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_CAN1_INJS register field. */
#define ALT_SYSMGR_ECC_CAN1_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN1_INJS field value from a register. */
#define ALT_SYSMGR_ECC_CAN1_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_CAN1_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN1_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : CAN1 RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the CAN1 RAM. This only injects one double bit error into the CAN1 RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN1_INJD register field. */
#define ALT_SYSMGR_ECC_CAN1_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN1_INJD register field. */
#define ALT_SYSMGR_ECC_CAN1_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_CAN1_INJD register field. */
#define ALT_SYSMGR_ECC_CAN1_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN1_INJD register field value. */
#define ALT_SYSMGR_ECC_CAN1_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_CAN1_INJD register field value. */
#define ALT_SYSMGR_ECC_CAN1_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_CAN1_INJD register field. */
#define ALT_SYSMGR_ECC_CAN1_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN1_INJD field value from a register. */
#define ALT_SYSMGR_ECC_CAN1_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_CAN1_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN1_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : CAN1 RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for CAN1 RAM ECC single, correctable error.
 * It is set by hardware when single, correctable error occurs in CAN1 RAM.
 * Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN1_SERR register field. */
#define ALT_SYSMGR_ECC_CAN1_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN1_SERR register field. */
#define ALT_SYSMGR_ECC_CAN1_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_CAN1_SERR register field. */
#define ALT_SYSMGR_ECC_CAN1_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN1_SERR register field value. */
#define ALT_SYSMGR_ECC_CAN1_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_CAN1_SERR register field value. */
#define ALT_SYSMGR_ECC_CAN1_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_CAN1_SERR register field. */
#define ALT_SYSMGR_ECC_CAN1_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN1_SERR field value from a register. */
#define ALT_SYSMGR_ECC_CAN1_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_CAN1_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN1_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : CAN1 RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for CAN1 RAM ECC double bit, non-correctable
 * error. It is set by hardware when double bit, non-correctable error occurs in
 * CAN1 RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_CAN1_DERR register field. */
#define ALT_SYSMGR_ECC_CAN1_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_CAN1_DERR register field. */
#define ALT_SYSMGR_ECC_CAN1_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_CAN1_DERR register field. */
#define ALT_SYSMGR_ECC_CAN1_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_CAN1_DERR register field value. */
#define ALT_SYSMGR_ECC_CAN1_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_CAN1_DERR register field value. */
#define ALT_SYSMGR_ECC_CAN1_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_CAN1_DERR register field. */
#define ALT_SYSMGR_ECC_CAN1_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_CAN1_DERR field value from a register. */
#define ALT_SYSMGR_ECC_CAN1_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_CAN1_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_CAN1_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_CAN1.
 */
struct ALT_SYSMGR_ECC_CAN1_s
{
    uint32_t  en   :  1;  /* CAN1 RAM ECC Enable */
    uint32_t  injs :  1;  /* CAN1 RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* CAN1 RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* CAN1 RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* CAN1 RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_CAN1. */
typedef volatile struct ALT_SYSMGR_ECC_CAN1_s  ALT_SYSMGR_ECC_CAN1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_CAN1 register from the beginning of the component. */
#define ALT_SYSMGR_ECC_CAN1_OFST        0x20

/*
 * Register : NAND RAM ECC Enable Register - nand
 * 
 * This register is used to enable ECC on the NAND RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits    | Access | Reset | Description                                                              
 * :--------|:-------|:------|:--------------------------------------------------------------------------
 *  [0]     | RW     | 0x0   | NAND RAM ECC Enable                                                      
 *  [1]     | RW     | 0x0   | NAND ECCBUFFER RAM ECC inject single, correctable Error                  
 *  [2]     | RW     | 0x0   | NAND ECCBUFFER RAM ECC inject double bit, non-correctable error          
 *  [3]     | RW     | 0x0   | NAND WRFIFO RAM ECC inject single, correctable Error                     
 *  [4]     | RW     | 0x0   | NAND WRFIFO RAM ECC inject double bit, non-correctable error             
 *  [5]     | RW     | 0x0   | NAND RDFIFO RAM ECC inject single, correctable Error                     
 *  [6]     | RW     | 0x0   | NAND RDFIFO RAM ECC inject double bit, non-correctable error             
 *  [7]     | RW     | 0x0   | NAND ECCBUFFER RAM ECC single, correctable error interrupt status        
 *  [8]     | RW     | 0x0   | NAND ECCBUFFER RAM ECC double bit, non-correctable error interrupt status
 *  [9]     | RW     | 0x0   | NAND WRFIFO RAM ECC single, correctable error interrupt status           
 *  [10]    | RW     | 0x0   | NAND WRFIFO RAM ECC double bit, non-correctable error interrupt status   
 *  [11]    | RW     | 0x0   | NAND RDFIFO RAM ECC single, correctable error interrupt status           
 *  [12]    | RW     | 0x0   | NAND RDFIFO RAM ECC double bit, non-correctable error interrupt status   
 *  [31:13] | ???    | 0x0   | *UNDEFINED*                                                              
 * 
 */
/*
 * Field : NAND RAM ECC Enable - en
 * 
 * Enable ECC for NAND RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_EN register field. */
#define ALT_SYSMGR_ECC_NAND_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_EN register field. */
#define ALT_SYSMGR_ECC_NAND_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_NAND_EN register field. */
#define ALT_SYSMGR_ECC_NAND_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_EN register field value. */
#define ALT_SYSMGR_ECC_NAND_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_EN register field value. */
#define ALT_SYSMGR_ECC_NAND_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_NAND_EN register field. */
#define ALT_SYSMGR_ECC_NAND_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_EN field value from a register. */
#define ALT_SYSMGR_ECC_NAND_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_NAND_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : NAND ECCBUFFER RAM ECC inject single, correctable Error - eccbufinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * NAND ECCBUFFER RAM. This only injects one error into the NAND ECCBUFFER RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_ECCBUFINJS field value from a register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_NAND_ECCBUFINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : NAND ECCBUFFER RAM ECC inject double bit, non-correctable error - eccbufinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the NAND ECCBUFFER RAM. This only injects one double bit error into the NAND
 * ECCBUFFER RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_ECCBUFINJD field value from a register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_NAND_ECCBUFINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFINJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : NAND WRFIFO RAM ECC inject single, correctable Error - wrfifoinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * NAND WRFIFO RAM. This only injects one error into the NAND WRFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_WRFIFOINJS field value from a register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_NAND_WRFIFOINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJS_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : NAND WRFIFO RAM ECC inject double bit, non-correctable error - wrfifoinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the NAND WRFIFO RAM. This only injects one double bit error into the NAND WRFIFO
 * RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_WRFIFOINJD field value from a register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_NAND_WRFIFOINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOINJD_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : NAND RDFIFO RAM ECC inject single, correctable Error - rdfifoinjs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * NAND RDFIFO RAM. This only injects one error into the NAND RDFIFO RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_MSB        5
/* The width in bits of the ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_RDFIFOINJS field value from a register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_ECC_NAND_RDFIFOINJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJS_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : NAND RDFIFO RAM ECC inject double bit, non-correctable error - rdfifoinjd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the NAND RDFIFO RAM. This only injects one double bit error into the NAND RDFIFO
 * RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_MSB        6
/* The width in bits of the ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_RDFIFOINJD field value from a register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_ECC_NAND_RDFIFOINJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOINJD_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : NAND ECCBUFFER RAM ECC single, correctable error interrupt status - eccbufserr
 * 
 * This bit is an interrupt status bit for NAND ECCBUFFER RAM ECC single,
 * correctable error. It is set by hardware when single, correctable error occurs
 * in NAND ECCBUFFER RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_MSB        7
/* The width in bits of the ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_ECCBUFSERR field value from a register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_ECC_NAND_ECCBUFSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFSERR_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : NAND ECCBUFFER RAM ECC double bit, non-correctable error interrupt status - eccbufderr
 * 
 * This bit is an interrupt status bit for NAND ECCBUFFER RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in NAND ECCBUFFER RAM. Software needs to write 1 into this bit to clear
 * the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_MSB        8
/* The width in bits of the ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_SET_MSK    0x00000100
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field value. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_CLR_MSK    0xfffffeff
/* The reset value of the ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_ECCBUFDERR field value from a register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_SYSMGR_ECC_NAND_ECCBUFDERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_ECCBUFDERR_SET(value) (((value) << 8) & 0x00000100)

/*
 * Field : NAND WRFIFO RAM ECC single, correctable error interrupt status - wrfifoserr
 * 
 * This bit is an interrupt status bit for NAND WRFIFO RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in NAND
 * WRFIFO RAM. Software needs to write 1 into this bit to clear the interrupt
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_LSB        9
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_MSB        9
/* The width in bits of the ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_SET_MSK    0x00000200
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_CLR_MSK    0xfffffdff
/* The reset value of the ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_WRFIFOSERR field value from a register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_GET(value) (((value) & 0x00000200) >> 9)
/* Produces a ALT_SYSMGR_ECC_NAND_WRFIFOSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFOSERR_SET(value) (((value) << 9) & 0x00000200)

/*
 * Field : NAND WRFIFO RAM ECC double bit, non-correctable error interrupt status - wrfifoderr
 * 
 * This bit is an interrupt status bit for NAND WRFIFO RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in NAND WRFIFO RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_LSB        10
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_WRFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_MSB        10
/* The width in bits of the ALT_SYSMGR_ECC_NAND_WRFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_WRFIFODERR register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_SET_MSK    0x00000400
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_WRFIFODERR register field value. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_CLR_MSK    0xfffffbff
/* The reset value of the ALT_SYSMGR_ECC_NAND_WRFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_WRFIFODERR field value from a register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_GET(value) (((value) & 0x00000400) >> 10)
/* Produces a ALT_SYSMGR_ECC_NAND_WRFIFODERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_WRFIFODERR_SET(value) (((value) << 10) & 0x00000400)

/*
 * Field : NAND RDFIFO RAM ECC single, correctable error interrupt status - rdfifoserr
 * 
 * This bit is an interrupt status bit for NAND RDFIFO RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in NAND
 * RDFIFO RAM. Software needs to write 1 into this bit to clear the interrupt
 * status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_LSB        11
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_MSB        11
/* The width in bits of the ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_SET_MSK    0x00000800
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_CLR_MSK    0xfffff7ff
/* The reset value of the ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_RDFIFOSERR field value from a register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_GET(value) (((value) & 0x00000800) >> 11)
/* Produces a ALT_SYSMGR_ECC_NAND_RDFIFOSERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFOSERR_SET(value) (((value) << 11) & 0x00000800)

/*
 * Field : NAND RDFIFO RAM ECC double bit, non-correctable error interrupt status - rdfifoderr
 * 
 * This bit is an interrupt status bit for NAND RDFIFO RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in NAND RDFIFO RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_LSB        12
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_NAND_RDFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_MSB        12
/* The width in bits of the ALT_SYSMGR_ECC_NAND_RDFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_NAND_RDFIFODERR register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_SET_MSK    0x00001000
/* The mask used to clear the ALT_SYSMGR_ECC_NAND_RDFIFODERR register field value. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_CLR_MSK    0xffffefff
/* The reset value of the ALT_SYSMGR_ECC_NAND_RDFIFODERR register field. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_NAND_RDFIFODERR field value from a register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_GET(value) (((value) & 0x00001000) >> 12)
/* Produces a ALT_SYSMGR_ECC_NAND_RDFIFODERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_NAND_RDFIFODERR_SET(value) (((value) << 12) & 0x00001000)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_NAND.
 */
struct ALT_SYSMGR_ECC_NAND_s
{
    uint32_t  en         :  1;  /* NAND RAM ECC Enable */
    uint32_t  eccbufinjs :  1;  /* NAND ECCBUFFER RAM ECC inject single, correctable Error */
    uint32_t  eccbufinjd :  1;  /* NAND ECCBUFFER RAM ECC inject double bit, non-correctable error */
    uint32_t  wrfifoinjs :  1;  /* NAND WRFIFO RAM ECC inject single, correctable Error */
    uint32_t  wrfifoinjd :  1;  /* NAND WRFIFO RAM ECC inject double bit, non-correctable error */
    uint32_t  rdfifoinjs :  1;  /* NAND RDFIFO RAM ECC inject single, correctable Error */
    uint32_t  rdfifoinjd :  1;  /* NAND RDFIFO RAM ECC inject double bit, non-correctable error */
    uint32_t  eccbufserr :  1;  /* NAND ECCBUFFER RAM ECC single, correctable error interrupt status */
    uint32_t  eccbufderr :  1;  /* NAND ECCBUFFER RAM ECC double bit, non-correctable error interrupt status */
    uint32_t  wrfifoserr :  1;  /* NAND WRFIFO RAM ECC single, correctable error interrupt status */
    uint32_t  wrfifoderr :  1;  /* NAND WRFIFO RAM ECC double bit, non-correctable error interrupt status */
    uint32_t  rdfifoserr :  1;  /* NAND RDFIFO RAM ECC single, correctable error interrupt status */
    uint32_t  rdfifoderr :  1;  /* NAND RDFIFO RAM ECC double bit, non-correctable error interrupt status */
    uint32_t             : 19;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_NAND. */
typedef volatile struct ALT_SYSMGR_ECC_NAND_s  ALT_SYSMGR_ECC_NAND_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_NAND register from the beginning of the component. */
#define ALT_SYSMGR_ECC_NAND_OFST        0x24

/*
 * Register : QSPI RAM ECC Enable Register - qspi
 * 
 * This register is used to enable ECC on the QSPI RAM. ECC errors can be injected
 * into the write path using bits in this register. This register contains
 * interrupt status of the ECC single/double bit error.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                    
 * :-------|:-------|:------|:----------------------------------------------------------------
 *  [0]    | RW     | 0x0   | QSPI RAM ECC Enable                                            
 *  [1]    | RW     | 0x0   | QSPI RAM ECC inject single, correctable Error                  
 *  [2]    | RW     | 0x0   | QSPI RAM ECC inject double bit, non-correctable error          
 *  [3]    | RW     | 0x0   | QSPI RAM ECC single, correctable error interrupt status        
 *  [4]    | RW     | 0x0   | QSPI RAM ECC double bit, non-correctable error interrupt status
 *  [31:5] | ???    | 0x0   | *UNDEFINED*                                                    
 * 
 */
/*
 * Field : QSPI RAM ECC Enable - en
 * 
 * Enable ECC for QSPI RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_QSPI_EN register field. */
#define ALT_SYSMGR_ECC_QSPI_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_QSPI_EN register field. */
#define ALT_SYSMGR_ECC_QSPI_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_QSPI_EN register field. */
#define ALT_SYSMGR_ECC_QSPI_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_QSPI_EN register field value. */
#define ALT_SYSMGR_ECC_QSPI_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_QSPI_EN register field value. */
#define ALT_SYSMGR_ECC_QSPI_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_QSPI_EN register field. */
#define ALT_SYSMGR_ECC_QSPI_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_QSPI_EN field value from a register. */
#define ALT_SYSMGR_ECC_QSPI_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_QSPI_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_QSPI_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : QSPI RAM ECC inject single, correctable Error - injs
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * QSPI RAM. This only injects one error into the QSPI RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_QSPI_INJS register field. */
#define ALT_SYSMGR_ECC_QSPI_INJS_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_QSPI_INJS register field. */
#define ALT_SYSMGR_ECC_QSPI_INJS_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_QSPI_INJS register field. */
#define ALT_SYSMGR_ECC_QSPI_INJS_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_QSPI_INJS register field value. */
#define ALT_SYSMGR_ECC_QSPI_INJS_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_QSPI_INJS register field value. */
#define ALT_SYSMGR_ECC_QSPI_INJS_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_QSPI_INJS register field. */
#define ALT_SYSMGR_ECC_QSPI_INJS_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_QSPI_INJS field value from a register. */
#define ALT_SYSMGR_ECC_QSPI_INJS_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_QSPI_INJS register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_QSPI_INJS_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : QSPI RAM ECC inject double bit, non-correctable error - injd
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the QSPI RAM. This only injects one double bit error into the QSPI RAM.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_QSPI_INJD register field. */
#define ALT_SYSMGR_ECC_QSPI_INJD_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_QSPI_INJD register field. */
#define ALT_SYSMGR_ECC_QSPI_INJD_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_QSPI_INJD register field. */
#define ALT_SYSMGR_ECC_QSPI_INJD_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_QSPI_INJD register field value. */
#define ALT_SYSMGR_ECC_QSPI_INJD_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_QSPI_INJD register field value. */
#define ALT_SYSMGR_ECC_QSPI_INJD_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_QSPI_INJD register field. */
#define ALT_SYSMGR_ECC_QSPI_INJD_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_QSPI_INJD field value from a register. */
#define ALT_SYSMGR_ECC_QSPI_INJD_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_QSPI_INJD register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_QSPI_INJD_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : QSPI RAM ECC single, correctable error interrupt status - serr
 * 
 * This bit is an interrupt status bit for QSPI RAM ECC single, correctable error.
 * It is set by hardware when single, correctable error occurs in QSPI RAM.
 * Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_QSPI_SERR register field. */
#define ALT_SYSMGR_ECC_QSPI_SERR_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_QSPI_SERR register field. */
#define ALT_SYSMGR_ECC_QSPI_SERR_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_QSPI_SERR register field. */
#define ALT_SYSMGR_ECC_QSPI_SERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_QSPI_SERR register field value. */
#define ALT_SYSMGR_ECC_QSPI_SERR_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_QSPI_SERR register field value. */
#define ALT_SYSMGR_ECC_QSPI_SERR_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_QSPI_SERR register field. */
#define ALT_SYSMGR_ECC_QSPI_SERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_QSPI_SERR field value from a register. */
#define ALT_SYSMGR_ECC_QSPI_SERR_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_QSPI_SERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_QSPI_SERR_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : QSPI RAM ECC double bit, non-correctable error interrupt status - derr
 * 
 * This bit is an interrupt status bit for QSPI RAM ECC double bit, non-correctable
 * error. It is set by hardware when double bit, non-correctable error occurs in
 * QSPI RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_QSPI_DERR register field. */
#define ALT_SYSMGR_ECC_QSPI_DERR_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_QSPI_DERR register field. */
#define ALT_SYSMGR_ECC_QSPI_DERR_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_QSPI_DERR register field. */
#define ALT_SYSMGR_ECC_QSPI_DERR_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_QSPI_DERR register field value. */
#define ALT_SYSMGR_ECC_QSPI_DERR_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_QSPI_DERR register field value. */
#define ALT_SYSMGR_ECC_QSPI_DERR_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_QSPI_DERR register field. */
#define ALT_SYSMGR_ECC_QSPI_DERR_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_QSPI_DERR field value from a register. */
#define ALT_SYSMGR_ECC_QSPI_DERR_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_QSPI_DERR register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_QSPI_DERR_SET(value) (((value) << 4) & 0x00000010)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_QSPI.
 */
struct ALT_SYSMGR_ECC_QSPI_s
{
    uint32_t  en   :  1;  /* QSPI RAM ECC Enable */
    uint32_t  injs :  1;  /* QSPI RAM ECC inject single, correctable Error */
    uint32_t  injd :  1;  /* QSPI RAM ECC inject double bit, non-correctable error */
    uint32_t  serr :  1;  /* QSPI RAM ECC single, correctable error interrupt status */
    uint32_t  derr :  1;  /* QSPI RAM ECC double bit, non-correctable error interrupt status */
    uint32_t       : 27;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_QSPI. */
typedef volatile struct ALT_SYSMGR_ECC_QSPI_s  ALT_SYSMGR_ECC_QSPI_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_QSPI register from the beginning of the component. */
#define ALT_SYSMGR_ECC_QSPI_OFST        0x28

/*
 * Register : SDMMC RAM ECC Enable Register - sdmmc
 * 
 * This register is used to enable ECC on the SDMMC RAM.ECC errors can be injected
 * into the write path using bits in this register.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                                                            
 * :-------|:-------|:------|:------------------------------------------------------------------------
 *  [0]    | RW     | 0x0   | SDMMC RAM ECC Enable                                                   
 *  [1]    | RW     | 0x0   | SDMMC Port A RAM ECC inject single, correctable Error at Port A        
 *  [2]    | RW     | 0x0   | SDMMC Port A RAM ECC inject double bit, non-correctable error at Port A
 *  [3]    | RW     | 0x0   | SDMMC Port B RAM ECC inject single, correctable Error at Port B        
 *  [4]    | RW     | 0x0   | SDMMC Port B RAM ECC inject double bit, non-correctable error at Port B
 *  [5]    | RW     | 0x0   | SDMMC Port A RAM ECC single, correctable error interrupt status        
 *  [6]    | RW     | 0x0   | SDMMC Port A RAM ECC double bit, non-correctable error interrupt status
 *  [7]    | RW     | 0x0   | SDMMC Port B RAM ECC single, correctable error interrupt status        
 *  [8]    | RW     | 0x0   | SDMMC Port B RAM ECC double bit, non-correctable error interrupt status
 *  [31:9] | ???    | 0x0   | *UNDEFINED*                                                            
 * 
 */
/*
 * Field : SDMMC RAM ECC Enable - en
 * 
 * Enable ECC for SDMMC RAM
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_EN register field. */
#define ALT_SYSMGR_ECC_SDMMC_EN_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_EN register field. */
#define ALT_SYSMGR_ECC_SDMMC_EN_MSB        0
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_EN register field. */
#define ALT_SYSMGR_ECC_SDMMC_EN_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_EN register field value. */
#define ALT_SYSMGR_ECC_SDMMC_EN_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_EN register field value. */
#define ALT_SYSMGR_ECC_SDMMC_EN_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_EN register field. */
#define ALT_SYSMGR_ECC_SDMMC_EN_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_EN field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_EN_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_ECC_SDMMC_EN register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_EN_SET(value) (((value) << 0) & 0x00000001)

/*
 * Field : SDMMC Port A RAM ECC inject single, correctable Error at Port A - injsporta
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * SDMMC RAM at Port A. This only injects one error into the SDMMC RAM at Port A.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_LSB        1
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_MSB        1
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_SET_MSK    0x00000002
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_CLR_MSK    0xfffffffd
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_INJSPORTA field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_GET(value) (((value) & 0x00000002) >> 1)
/* Produces a ALT_SYSMGR_ECC_SDMMC_INJSPORTA register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTA_SET(value) (((value) << 1) & 0x00000002)

/*
 * Field : SDMMC Port A RAM ECC inject double bit, non-correctable error at Port A - injdporta
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the SDMMC RAM at Port A. This only injects one double bit error into the SDMMC
 * RAM at Port A.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_LSB        2
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_MSB        2
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_SET_MSK    0x00000004
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_CLR_MSK    0xfffffffb
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_INJDPORTA field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_GET(value) (((value) & 0x00000004) >> 2)
/* Produces a ALT_SYSMGR_ECC_SDMMC_INJDPORTA register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTA_SET(value) (((value) << 2) & 0x00000004)

/*
 * Field : SDMMC Port B RAM ECC inject single, correctable Error at Port B - injsportb
 * 
 * Changing this bit from zero to one injects a single, correctable error into the
 * SDMMC RAM at Port B. This only injects one error into the SDMMC RAM at Port B.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_LSB        3
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_MSB        3
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_SET_MSK    0x00000008
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_CLR_MSK    0xfffffff7
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_INJSPORTB field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_GET(value) (((value) & 0x00000008) >> 3)
/* Produces a ALT_SYSMGR_ECC_SDMMC_INJSPORTB register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_INJSPORTB_SET(value) (((value) << 3) & 0x00000008)

/*
 * Field : SDMMC Port B RAM ECC inject double bit, non-correctable error at Port B - injdportb
 * 
 * Changing this bit from zero to one injects a double, non-correctable error into
 * the SDMMC RAM at Port B. This only injects one double bit error into the SDMMC
 * RAM at Port B.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_LSB        4
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_MSB        4
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_SET_MSK    0x00000010
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_CLR_MSK    0xffffffef
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_INJDPORTB field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_GET(value) (((value) & 0x00000010) >> 4)
/* Produces a ALT_SYSMGR_ECC_SDMMC_INJDPORTB register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_INJDPORTB_SET(value) (((value) << 4) & 0x00000010)

/*
 * Field : SDMMC Port A RAM ECC single, correctable error interrupt status - serrporta
 * 
 * This bit is an interrupt status bit for SDMMC Port A RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in SDMMC Port
 * A RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_LSB        5
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_MSB        5
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_SET_MSK    0x00000020
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_CLR_MSK    0xffffffdf
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_SERRPORTA field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_GET(value) (((value) & 0x00000020) >> 5)
/* Produces a ALT_SYSMGR_ECC_SDMMC_SERRPORTA register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTA_SET(value) (((value) << 5) & 0x00000020)

/*
 * Field : SDMMC Port A RAM ECC double bit, non-correctable error interrupt status - derrporta
 * 
 * This bit is an interrupt status bit for SDMMC Port A RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in SDMMC Port A RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_LSB        6
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_MSB        6
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_SET_MSK    0x00000040
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field value. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_CLR_MSK    0xffffffbf
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_DERRPORTA field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_GET(value) (((value) & 0x00000040) >> 6)
/* Produces a ALT_SYSMGR_ECC_SDMMC_DERRPORTA register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTA_SET(value) (((value) << 6) & 0x00000040)

/*
 * Field : SDMMC Port B RAM ECC single, correctable error interrupt status - serrportb
 * 
 * This bit is an interrupt status bit for SDMMC Port B RAM ECC single, correctable
 * error. It is set by hardware when single, correctable error occurs in SDMMC Port
 * B RAM. Software needs to write 1 into this bit to clear the interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_LSB        7
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_MSB        7
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_SET_MSK    0x00000080
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_CLR_MSK    0xffffff7f
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_SERRPORTB field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_GET(value) (((value) & 0x00000080) >> 7)
/* Produces a ALT_SYSMGR_ECC_SDMMC_SERRPORTB register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_SERRPORTB_SET(value) (((value) << 7) & 0x00000080)

/*
 * Field : SDMMC Port B RAM ECC double bit, non-correctable error interrupt status - derrportb
 * 
 * This bit is an interrupt status bit for SDMMC Port B RAM ECC double bit, non-
 * correctable error. It is set by hardware when double bit, non-correctable error
 * occurs in SDMMC Port B RAM. Software needs to write 1 into this bit to clear the
 * interrupt status.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_LSB        8
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_MSB        8
/* The width in bits of the ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_WIDTH      1
/* The mask used to set the ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_SET_MSK    0x00000100
/* The mask used to clear the ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field value. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_CLR_MSK    0xfffffeff
/* The reset value of the ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_RESET      0x0
/* Extracts the ALT_SYSMGR_ECC_SDMMC_DERRPORTB field value from a register. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_GET(value) (((value) & 0x00000100) >> 8)
/* Produces a ALT_SYSMGR_ECC_SDMMC_DERRPORTB register field value suitable for setting the register. */
#define ALT_SYSMGR_ECC_SDMMC_DERRPORTB_SET(value) (((value) << 8) & 0x00000100)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_ECC_SDMMC.
 */
struct ALT_SYSMGR_ECC_SDMMC_s
{
    uint32_t  en        :  1;  /* SDMMC RAM ECC Enable */
    uint32_t  injsporta :  1;  /* SDMMC Port A RAM ECC inject single, correctable Error at Port A */
    uint32_t  injdporta :  1;  /* SDMMC Port A RAM ECC inject double bit, non-correctable error at Port A */
    uint32_t  injsportb :  1;  /* SDMMC Port B RAM ECC inject single, correctable Error at Port B */
    uint32_t  injdportb :  1;  /* SDMMC Port B RAM ECC inject double bit, non-correctable error at Port B */
    uint32_t  serrporta :  1;  /* SDMMC Port A RAM ECC single, correctable error interrupt status */
    uint32_t  derrporta :  1;  /* SDMMC Port A RAM ECC double bit, non-correctable error interrupt status */
    uint32_t  serrportb :  1;  /* SDMMC Port B RAM ECC single, correctable error interrupt status */
    uint32_t  derrportb :  1;  /* SDMMC Port B RAM ECC double bit, non-correctable error interrupt status */
    uint32_t            : 23;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_ECC_SDMMC. */
typedef volatile struct ALT_SYSMGR_ECC_SDMMC_s  ALT_SYSMGR_ECC_SDMMC_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_ECC_SDMMC register from the beginning of the component. */
#define ALT_SYSMGR_ECC_SDMMC_OFST        0x2c

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register group ALT_SYSMGR_ECC.
 */
struct ALT_SYSMGR_ECC_s
{
    volatile ALT_SYSMGR_ECC_L2_t     l2;                 /* ALT_SYSMGR_ECC_L2 */
    volatile ALT_SYSMGR_ECC_OCRAM_t  ocram;              /* ALT_SYSMGR_ECC_OCRAM */
    volatile ALT_SYSMGR_ECC_USB0_t   usb0;               /* ALT_SYSMGR_ECC_USB0 */
    volatile ALT_SYSMGR_ECC_USB1_t   usb1;               /* ALT_SYSMGR_ECC_USB1 */
    volatile ALT_SYSMGR_ECC_EMAC0_t  emac0;              /* ALT_SYSMGR_ECC_EMAC0 */
    volatile ALT_SYSMGR_ECC_EMAC1_t  emac1;              /* ALT_SYSMGR_ECC_EMAC1 */
    volatile ALT_SYSMGR_ECC_DMA_t    dma;                /* ALT_SYSMGR_ECC_DMA */
    volatile ALT_SYSMGR_ECC_CAN0_t   can0;               /* ALT_SYSMGR_ECC_CAN0 */
    volatile ALT_SYSMGR_ECC_CAN1_t   can1;               /* ALT_SYSMGR_ECC_CAN1 */
    volatile ALT_SYSMGR_ECC_NAND_t   nand;               /* ALT_SYSMGR_ECC_NAND */
    volatile ALT_SYSMGR_ECC_QSPI_t   qspi;               /* ALT_SYSMGR_ECC_QSPI */
    volatile ALT_SYSMGR_ECC_SDMMC_t  sdmmc;              /* ALT_SYSMGR_ECC_SDMMC */
    volatile uint32_t                _pad_0x30_0x40[4];  /* *UNDEFINED* */
};

/* The typedef declaration for register group ALT_SYSMGR_ECC. */
typedef volatile struct ALT_SYSMGR_ECC_s  ALT_SYSMGR_ECC_t;
/* The struct declaration for the raw register contents of register group ALT_SYSMGR_ECC. */
struct ALT_SYSMGR_ECC_raw_s
{
    volatile uint32_t  l2;                 /* ALT_SYSMGR_ECC_L2 */
    volatile uint32_t  ocram;              /* ALT_SYSMGR_ECC_OCRAM */
    volatile uint32_t  usb0;               /* ALT_SYSMGR_ECC_USB0 */
    volatile uint32_t  usb1;               /* ALT_SYSMGR_ECC_USB1 */
    volatile uint32_t  emac0;              /* ALT_SYSMGR_ECC_EMAC0 */
    volatile uint32_t  emac1;              /* ALT_SYSMGR_ECC_EMAC1 */
    volatile uint32_t  dma;                /* ALT_SYSMGR_ECC_DMA */
    volatile uint32_t  can0;               /* ALT_SYSMGR_ECC_CAN0 */
    volatile uint32_t  can1;               /* ALT_SYSMGR_ECC_CAN1 */
    volatile uint32_t  nand;               /* ALT_SYSMGR_ECC_NAND */
    volatile uint32_t  qspi;               /* ALT_SYSMGR_ECC_QSPI */
    volatile uint32_t  sdmmc;              /* ALT_SYSMGR_ECC_SDMMC */
    volatile uint32_t  _pad_0x30_0x40[4];  /* *UNDEFINED* */
};

/* The typedef declaration for the raw register contents of register group ALT_SYSMGR_ECC. */
typedef volatile struct ALT_SYSMGR_ECC_raw_s  ALT_SYSMGR_ECC_raw_t;
#endif  /* __ASSEMBLY__ */


/*
 * Register Group : Pin Mux Control Group - ALT_SYSMGR_PINMUX
 * Pin Mux Control Group
 * 
 * Controls Pin Mux selections
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 */
/*
 * Register : emac0_tx_clk Mux Selection Register - EMACIO0
 * 
 * This register is used to control the peripherals connected to emac0_tx_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_tx_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac0_tx_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_tx_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 0.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.TX_CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO0_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO0_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO0_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO0.
 */
struct ALT_SYSMGR_PINMUX_EMACIO0_s
{
    uint32_t  sel :  2;  /* emac0_tx_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO0. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO0_s  ALT_SYSMGR_PINMUX_EMACIO0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO0 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO0_OFST        0x0

/*
 * Register : emac0_tx_d0 Mux Selection Register - EMACIO1
 * 
 * This register is used to control the peripherals connected to emac0_tx_d0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_tx_d0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_tx_d0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_tx_d0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 1.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D0.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.TXD0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO1_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO1_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO1_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO1.
 */
struct ALT_SYSMGR_PINMUX_EMACIO1_s
{
    uint32_t  sel :  2;  /* emac0_tx_d0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO1. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO1_s  ALT_SYSMGR_PINMUX_EMACIO1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO1 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO1_OFST        0x4

/*
 * Register : emac0_tx_d1 Mux Selection Register - EMACIO2
 * 
 * This register is used to control the peripherals connected to emac0_tx_d1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_tx_d1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_tx_d1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_tx_d1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 2.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D1.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.TXD1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO2_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO2_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO2_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO2.
 */
struct ALT_SYSMGR_PINMUX_EMACIO2_s
{
    uint32_t  sel :  2;  /* emac0_tx_d1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO2. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO2_s  ALT_SYSMGR_PINMUX_EMACIO2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO2 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO2_OFST        0x8

/*
 * Register : emac0_tx_d2 Mux Selection Register - EMACIO3
 * 
 * This register is used to control the peripherals connected to emac0_tx_d2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_tx_d2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_tx_d2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_tx_d2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 3.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D2.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.TXD2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO3_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO3_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO3_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO3.
 */
struct ALT_SYSMGR_PINMUX_EMACIO3_s
{
    uint32_t  sel :  2;  /* emac0_tx_d2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO3. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO3_s  ALT_SYSMGR_PINMUX_EMACIO3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO3 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO3_OFST        0xc

/*
 * Register : emac0_tx_d3 Mux Selection Register - EMACIO4
 * 
 * This register is used to control the peripherals connected to emac0_tx_d3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_tx_d3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_tx_d3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_tx_d3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 4.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D3.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.TXD3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO4_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO4_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO4_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO4.
 */
struct ALT_SYSMGR_PINMUX_EMACIO4_s
{
    uint32_t  sel :  2;  /* emac0_tx_d3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO4. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO4_s  ALT_SYSMGR_PINMUX_EMACIO4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO4 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO4_OFST        0x10

/*
 * Register : emac0_rx_d0 Mux Selection Register - EMACIO5
 * 
 * This register is used to control the peripherals connected to emac0_rx_d0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_rx_d0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_rx_d0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_rx_d0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 5.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D4.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.RXD0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO5_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO5_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO5_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO5.
 */
struct ALT_SYSMGR_PINMUX_EMACIO5_s
{
    uint32_t  sel :  2;  /* emac0_rx_d0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO5. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO5_s  ALT_SYSMGR_PINMUX_EMACIO5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO5 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO5_OFST        0x14

/*
 * Register : emac0_mdio Mux Selection Register - EMACIO6
 * 
 * This register is used to control the peripherals connected to emac0_mdio
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_mdio Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : emac0_mdio Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_mdio.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 6.
 * 
 * 1 : Pin is connected to Peripheral signal I2C2.SDA.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D5.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.MDIO.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO6_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO6_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO6_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO6.
 */
struct ALT_SYSMGR_PINMUX_EMACIO6_s
{
    uint32_t  sel :  2;  /* emac0_mdio Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO6. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO6_s  ALT_SYSMGR_PINMUX_EMACIO6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO6 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO6_OFST        0x18

/*
 * Register : emac0_mdc Mux Selection Register - EMACIO7
 * 
 * This register is used to control the peripherals connected to emac0_mdc
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_mdc Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : emac0_mdc Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_mdc.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 7.
 * 
 * 1 : Pin is connected to Peripheral signal I2C2.SCL.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D6.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.MDC.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO7_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO7_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO7_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO7.
 */
struct ALT_SYSMGR_PINMUX_EMACIO7_s
{
    uint32_t  sel :  2;  /* emac0_mdc Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO7. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO7_s  ALT_SYSMGR_PINMUX_EMACIO7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO7 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO7_OFST        0x1c

/*
 * Register : emac0_rx_ctl Mux Selection Register - EMACIO8
 * 
 * This register is used to control the peripherals connected to emac0_rx_ctl
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_rx_ctl Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac0_rx_ctl Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_rx_ctl.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 8.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.D7.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.RX_CTL.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO8_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO8_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO8_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO8.
 */
struct ALT_SYSMGR_PINMUX_EMACIO8_s
{
    uint32_t  sel :  2;  /* emac0_rx_ctl Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO8. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO8_s  ALT_SYSMGR_PINMUX_EMACIO8_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO8 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO8_OFST        0x20

/*
 * Register : emac0_tx_ctl Mux Selection Register - EMACIO9
 * 
 * This register is used to control the peripherals connected to emac0_tx_ctl
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_tx_ctl Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac0_tx_ctl Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_tx_ctl.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 9.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.TX_CTL.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO9_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO9_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO9_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO9.
 */
struct ALT_SYSMGR_PINMUX_EMACIO9_s
{
    uint32_t  sel :  2;  /* emac0_tx_ctl Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO9. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO9_s  ALT_SYSMGR_PINMUX_EMACIO9_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO9 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO9_OFST        0x24

/*
 * Register : emac0_rx_clk Mux Selection Register - EMACIO10
 * 
 * This register is used to control the peripherals connected to emac0_rx_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_rx_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac0_rx_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_rx_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 10.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.RX_CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO10_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO10_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO10_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO10.
 */
struct ALT_SYSMGR_PINMUX_EMACIO10_s
{
    uint32_t  sel :  2;  /* emac0_rx_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO10. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO10_s  ALT_SYSMGR_PINMUX_EMACIO10_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO10 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO10_OFST        0x28

/*
 * Register : emac0_rx_d1 Mux Selection Register - EMACIO11
 * 
 * This register is used to control the peripherals connected to emac0_rx_d1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_rx_d1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_rx_d1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_rx_d1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 11.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.STP.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.RXD1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO11_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO11_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO11_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO11.
 */
struct ALT_SYSMGR_PINMUX_EMACIO11_s
{
    uint32_t  sel :  2;  /* emac0_rx_d1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO11. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO11_s  ALT_SYSMGR_PINMUX_EMACIO11_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO11 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO11_OFST        0x2c

/*
 * Register : emac0_rx_d2 Mux Selection Register - EMACIO12
 * 
 * This register is used to control the peripherals connected to emac0_rx_d2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_rx_d2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_rx_d2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_rx_d2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 12.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.DIR.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.RXD2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO12_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO12_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO12_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO12.
 */
struct ALT_SYSMGR_PINMUX_EMACIO12_s
{
    uint32_t  sel :  2;  /* emac0_rx_d2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO12. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO12_s  ALT_SYSMGR_PINMUX_EMACIO12_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO12 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO12_OFST        0x30

/*
 * Register : emac0_rx_d3 Mux Selection Register - EMACIO13
 * 
 * This register is used to control the peripherals connected to emac0_rx_d3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac0_rx_d3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac0_rx_d3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac0_rx_d3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 13.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB1.NXT.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII0.RXD3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO13_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO13_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO13_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO13.
 */
struct ALT_SYSMGR_PINMUX_EMACIO13_s
{
    uint32_t  sel :  2;  /* emac0_rx_d3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO13. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO13_s  ALT_SYSMGR_PINMUX_EMACIO13_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO13 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO13_OFST        0x34

/*
 * Register : emac1_tx_clk Mux Selection Register - EMACIO14
 * 
 * This register is used to control the peripherals connected to emac1_tx_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_tx_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac1_tx_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_tx_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 48.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.TX_CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO14_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO14_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO14_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO14.
 */
struct ALT_SYSMGR_PINMUX_EMACIO14_s
{
    uint32_t  sel :  2;  /* emac1_tx_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO14. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO14_s  ALT_SYSMGR_PINMUX_EMACIO14_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO14 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO14_OFST        0x38

/*
 * Register : emac1_tx_d0 Mux Selection Register - EMACIO15
 * 
 * This register is used to control the peripherals connected to emac1_tx_d0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_tx_d0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_tx_d0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_tx_d0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 49.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.TXD0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO15_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO15_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO15_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO15.
 */
struct ALT_SYSMGR_PINMUX_EMACIO15_s
{
    uint32_t  sel :  2;  /* emac1_tx_d0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO15. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO15_s  ALT_SYSMGR_PINMUX_EMACIO15_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO15 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO15_OFST        0x3c

/*
 * Register : emac1_tx_d1 Mux Selection Register - EMACIO16
 * 
 * This register is used to control the peripherals connected to emac1_tx_d1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_tx_d1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_tx_d1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_tx_d1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 50.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.TXD1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO16_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO16_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO16_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO16.
 */
struct ALT_SYSMGR_PINMUX_EMACIO16_s
{
    uint32_t  sel :  2;  /* emac1_tx_d1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO16. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO16_s  ALT_SYSMGR_PINMUX_EMACIO16_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO16 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO16_OFST        0x40

/*
 * Register : emac1_tx_ctl Mux Selection Register - EMACIO17
 * 
 * This register is used to control the peripherals connected to emac1_tx_ctl
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_tx_ctl Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac1_tx_ctl Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_tx_ctl.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 51.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.TX_CTL.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO17_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO17_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO17_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO17.
 */
struct ALT_SYSMGR_PINMUX_EMACIO17_s
{
    uint32_t  sel :  2;  /* emac1_tx_ctl Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO17. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO17_s  ALT_SYSMGR_PINMUX_EMACIO17_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO17 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO17_OFST        0x44

/*
 * Register : emac1_rx_d0 Mux Selection Register - EMACIO18
 * 
 * This register is used to control the peripherals connected to emac1_rx_d0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_rx_d0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_rx_d0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_rx_d0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 52.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.RXD0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO18_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO18_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO18_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO18.
 */
struct ALT_SYSMGR_PINMUX_EMACIO18_s
{
    uint32_t  sel :  2;  /* emac1_rx_d0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO18. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO18_s  ALT_SYSMGR_PINMUX_EMACIO18_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO18 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO18_OFST        0x48

/*
 * Register : emac1_rx_d1 Mux Selection Register - EMACIO19
 * 
 * This register is used to control the peripherals connected to emac1_rx_d1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_rx_d1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_rx_d1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_rx_d1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 53.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.RXD1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_EMACIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_EMACIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_EMACIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_EMACIO19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_EMACIO19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_EMACIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_EMACIO19_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_EMACIO19_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_EMACIO19_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_EMACIO19.
 */
struct ALT_SYSMGR_PINMUX_EMACIO19_s
{
    uint32_t  sel :  2;  /* emac1_rx_d1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_EMACIO19. */
typedef volatile struct ALT_SYSMGR_PINMUX_EMACIO19_s  ALT_SYSMGR_PINMUX_EMACIO19_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_EMACIO19 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_EMACIO19_OFST        0x4c

/*
 * Register : sdmmc_cmd Mux Selection Register - FLASHIO0
 * 
 * This register is used to control the peripherals connected to sdmmc_cmd
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_cmd Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : sdmmc_cmd Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_cmd.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 36.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D0.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.CMD.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO0_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO0_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO0.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO0_s
{
    uint32_t  sel :  2;  /* sdmmc_cmd Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO0. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO0_s  ALT_SYSMGR_PINMUX_FLSHIO0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO0 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO0_OFST        0x50

/*
 * Register : sdmmc_pwren Mux Selection Register - FLASHIO1
 * 
 * This register is used to control the peripherals connected to sdmmc_pwren
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_pwren Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : sdmmc_pwren Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_pwren.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 37.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D1.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.PWREN.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO1_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO1_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO1.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO1_s
{
    uint32_t  sel :  2;  /* sdmmc_pwren Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO1. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO1_s  ALT_SYSMGR_PINMUX_FLSHIO1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO1 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO1_OFST        0x54

/*
 * Register : sdmmc_d0 Mux Selection Register - FLASHIO2
 * 
 * This register is used to control the peripherals connected to sdmmc_d0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 38.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D2.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO2_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO2_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO2.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO2_s
{
    uint32_t  sel :  2;  /* sdmmc_d0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO2. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO2_s  ALT_SYSMGR_PINMUX_FLSHIO2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO2 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO2_OFST        0x58

/*
 * Register : sdmmc_d1 Mux Selection Register - FLASHIO3
 * 
 * This register is used to control the peripherals connected to sdmmc_d1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 39.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D3.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO3_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO3_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO3.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO3_s
{
    uint32_t  sel :  2;  /* sdmmc_d1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO3. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO3_s  ALT_SYSMGR_PINMUX_FLSHIO3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO3 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO3_OFST        0x5c

/*
 * Register : sdmmc_d4 Mux Selection Register - FLASHIO4
 * 
 * This register is used to control the peripherals connected to sdmmc_d4
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d4 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d4 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d4.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 40.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D4.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D4.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO4_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO4_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO4.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO4_s
{
    uint32_t  sel :  2;  /* sdmmc_d4 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO4. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO4_s  ALT_SYSMGR_PINMUX_FLSHIO4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO4 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO4_OFST        0x60

/*
 * Register : sdmmc_d5 Mux Selection Register - FLASHIO5
 * 
 * This register is used to control the peripherals connected to sdmmc_d5
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d5 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d5 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d5.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 41.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D5.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D5.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO5_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO5_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO5.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO5_s
{
    uint32_t  sel :  2;  /* sdmmc_d5 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO5. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO5_s  ALT_SYSMGR_PINMUX_FLSHIO5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO5 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO5_OFST        0x64

/*
 * Register : sdmmc_d6 Mux Selection Register - FLASHIO6
 * 
 * This register is used to control the peripherals connected to sdmmc_d6
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d6 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d6 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d6.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 42.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D6.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D6.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO6_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO6_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO6.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO6_s
{
    uint32_t  sel :  2;  /* sdmmc_d6 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO6. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO6_s  ALT_SYSMGR_PINMUX_FLSHIO6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO6 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO6_OFST        0x68

/*
 * Register : sdmmc_d7 Mux Selection Register - FLASHIO7
 * 
 * This register is used to control the peripherals connected to sdmmc_d7
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d7 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d7 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d7.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 43.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.D7.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D7.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO7_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO7_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO7.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO7_s
{
    uint32_t  sel :  2;  /* sdmmc_d7 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO7. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO7_s  ALT_SYSMGR_PINMUX_FLSHIO7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO7 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO7_OFST        0x6c

/*
 * Register : sdmmc_clk_in Mux Selection Register - FLASHIO8
 * 
 * This register is used to control the peripherals connected to sdmmc_clk_in
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_clk_in Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : sdmmc_clk_in Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_clk_in.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 44.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.CLK_IN.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO8_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO8_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO8.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO8_s
{
    uint32_t  sel :  2;  /* sdmmc_clk_in Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO8. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO8_s  ALT_SYSMGR_PINMUX_FLSHIO8_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO8 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO8_OFST        0x70

/*
 * Register : sdmmc_clk Mux Selection Register - FLASHIO9
 * 
 * This register is used to control the peripherals connected to sdmmc_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : sdmmc_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 45.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.STP.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO9_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO9_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO9.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO9_s
{
    uint32_t  sel :  2;  /* sdmmc_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO9. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO9_s  ALT_SYSMGR_PINMUX_FLSHIO9_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO9 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO9_OFST        0x74

/*
 * Register : sdmmc_d2 Mux Selection Register - FLASHIO10
 * 
 * This register is used to control the peripherals connected to sdmmc_d2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 46.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.DIR.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO10_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO10_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO10.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO10_s
{
    uint32_t  sel :  2;  /* sdmmc_d2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO10. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO10_s  ALT_SYSMGR_PINMUX_FLSHIO10_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO10 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO10_OFST        0x78

/*
 * Register : sdmmc_d3 Mux Selection Register - FLASHIO11
 * 
 * This register is used to control the peripherals connected to sdmmc_d3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | sdmmc_d3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : sdmmc_d3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected sdmmc_d3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 47.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal USB0.NXT.
 * 
 * 3 : Pin is connected to Peripheral signal SDMMC.D3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_FLSHIO11_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_FLSHIO11_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_FLSHIO11.
 */
struct ALT_SYSMGR_PINMUX_FLSHIO11_s
{
    uint32_t  sel :  2;  /* sdmmc_d3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_FLSHIO11. */
typedef volatile struct ALT_SYSMGR_PINMUX_FLSHIO11_s  ALT_SYSMGR_PINMUX_FLSHIO11_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_FLSHIO11 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_FLSHIO11_OFST        0x7c

/*
 * Register : trace_clk Mux Selection Register - GENERALIO0
 * 
 * This register is used to control the peripherals connected to trace_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | trace_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : trace_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 48.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO0_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO0_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO0.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO0_s
{
    uint32_t  sel :  2;  /* trace_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO0. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO0_s  ALT_SYSMGR_PINMUX_GENERALIO0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO0 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO0_OFST        0x80

/*
 * Register : trace_d0 Mux Selection Register - GENERALIO1
 * 
 * This register is used to control the peripherals connected to trace_d0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 49.
 * 
 * 1 : Pin is connected to Peripheral signal UART0.RX.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS0.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO1_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO1_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO1.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO1_s
{
    uint32_t  sel :  2;  /* trace_d0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO1. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO1_s  ALT_SYSMGR_PINMUX_GENERALIO1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO1 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO1_OFST        0x84

/*
 * Register : trace_d1 Mux Selection Register - GENERALIO2
 * 
 * This register is used to control the peripherals connected to trace_d1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 50.
 * 
 * 1 : Pin is connected to Peripheral signal UART0.TX.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS0.MOSI.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO2_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO2_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO2.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO2_s
{
    uint32_t  sel :  2;  /* trace_d1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO2. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO2_s  ALT_SYSMGR_PINMUX_GENERALIO2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO2 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO2_OFST        0x88

/*
 * Register : trace_d2 Mux Selection Register - GENERALIO3
 * 
 * This register is used to control the peripherals connected to trace_d2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 51.
 * 
 * 1 : Pin is connected to Peripheral signal I2C1.SDA.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS0.MISO.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO3_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO3_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO3.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO3_s
{
    uint32_t  sel :  2;  /* trace_d2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO3. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO3_s  ALT_SYSMGR_PINMUX_GENERALIO3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO3 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO3_OFST        0x8c

/*
 * Register : trace_d3 Mux Selection Register - GENERALIO4
 * 
 * This register is used to control the peripherals connected to trace_d3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 52.
 * 
 * 1 : Pin is connected to Peripheral signal I2C1.SCL.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS0.SS0.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO4_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO4_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO4.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO4_s
{
    uint32_t  sel :  2;  /* trace_d3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO4. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO4_s  ALT_SYSMGR_PINMUX_GENERALIO4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO4 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO4_OFST        0x90

/*
 * Register : trace_d4 Mux Selection Register - GENERALIO5
 * 
 * This register is used to control the peripherals connected to trace_d4
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d4 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d4 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d4.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 53.
 * 
 * 1 : Pin is connected to Peripheral signal CAN1.RX.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D4.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO5_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO5_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO5.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO5_s
{
    uint32_t  sel :  2;  /* trace_d4 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO5. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO5_s  ALT_SYSMGR_PINMUX_GENERALIO5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO5 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO5_OFST        0x94

/*
 * Register : trace_d5 Mux Selection Register - GENERALIO6
 * 
 * This register is used to control the peripherals connected to trace_d5
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d5 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d5 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d5.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 54.
 * 
 * 1 : Pin is connected to Peripheral signal CAN1.TX.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.MOSI.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D5.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO6_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO6_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO6.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO6_s
{
    uint32_t  sel :  2;  /* trace_d5 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO6. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO6_s  ALT_SYSMGR_PINMUX_GENERALIO6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO6 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO6_OFST        0x98

/*
 * Register : trace_d6 Mux Selection Register - GENERALIO7
 * 
 * This register is used to control the peripherals connected to trace_d6
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d6 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d6 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d6.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 55.
 * 
 * 1 : Pin is connected to Peripheral signal I2C0.SDA.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.SS0.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D6.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO7_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO7_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO7.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO7_s
{
    uint32_t  sel :  2;  /* trace_d6 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO7. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO7_s  ALT_SYSMGR_PINMUX_GENERALIO7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO7 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO7_OFST        0x9c

/*
 * Register : trace_d7 Mux Selection Register - GENERALIO8
 * 
 * This register is used to control the peripherals connected to trace_d7
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | trace_d7 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : trace_d7 Mux Selection Field - sel
 * 
 * Select peripheral signals connected trace_d7.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 56.
 * 
 * 1 : Pin is connected to Peripheral signal I2C0.SCL.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.MISO.
 * 
 * 3 : Pin is connected to Peripheral signal TRACE.D7.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO8_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO8_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO8.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO8_s
{
    uint32_t  sel :  2;  /* trace_d7 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO8. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO8_s  ALT_SYSMGR_PINMUX_GENERALIO8_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO8 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO8_OFST        0xa0

/*
 * Register : spim0_clk Mux Selection Register - GENERALIO9
 * 
 * This register is used to control the peripherals connected to spim0_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | spim0_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : spim0_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected spim0_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 57.
 * 
 * 1 : Pin is connected to Peripheral signal UART0.CTS.
 * 
 * 2 : Pin is connected to Peripheral signal I2C1.SDA.
 * 
 * 3 : Pin is connected to Peripheral signal SPIM0.CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO9_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO9_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO9.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO9_s
{
    uint32_t  sel :  2;  /* spim0_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO9. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO9_s  ALT_SYSMGR_PINMUX_GENERALIO9_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO9 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO9_OFST        0xa4

/*
 * Register : spim0_mosi Mux Selection Register - GENERALIO10
 * 
 * This register is used to control the peripherals connected to spim0_mosi
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | spim0_mosi Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : spim0_mosi Mux Selection Field - sel
 * 
 * Select peripheral signals connected spim0_mosi.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 58.
 * 
 * 1 : Pin is connected to Peripheral signal UART0.RTS.
 * 
 * 2 : Pin is connected to Peripheral signal I2C1.SCL.
 * 
 * 3 : Pin is connected to Peripheral signal SPIM0.MOSI.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO10_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO10_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO10.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO10_s
{
    uint32_t  sel :  2;  /* spim0_mosi Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO10. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO10_s  ALT_SYSMGR_PINMUX_GENERALIO10_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO10 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO10_OFST        0xa8

/*
 * Register : spim0_miso Mux Selection Register - GENERALIO11
 * 
 * This register is used to control the peripherals connected to spim0_miso
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | spim0_miso Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : spim0_miso Mux Selection Field - sel
 * 
 * Select peripheral signals connected spim0_miso.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 59.
 * 
 * 1 : Pin is connected to Peripheral signal UART1.CTS.
 * 
 * 2 : Pin is connected to Peripheral signal CAN1.RX.
 * 
 * 3 : Pin is connected to Peripheral signal SPIM0.MISO.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO11_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO11_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO11.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO11_s
{
    uint32_t  sel :  2;  /* spim0_miso Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO11. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO11_s  ALT_SYSMGR_PINMUX_GENERALIO11_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO11 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO11_OFST        0xac

/*
 * Register : spim0_ss0 Mux Selection Register - GENERALIO12
 * 
 * This register is used to control the peripherals connected to spim0_ss0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | spim0_ss0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : spim0_ss0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected spim0_ss0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 60.
 * 
 * 1 : Pin is connected to Peripheral signal UART1.RTS.
 * 
 * 2 : Pin is connected to Peripheral signal CAN1.TX.
 * 
 * 3 : Pin is connected to Peripheral signal SPIM0.SS0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO12_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO12_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO12.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO12_s
{
    uint32_t  sel :  2;  /* spim0_ss0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO12. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO12_s  ALT_SYSMGR_PINMUX_GENERALIO12_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO12 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO12_OFST        0xb0

/*
 * Register : uart0_rx Mux Selection Register - GENERALIO13
 * 
 * This register is used to control the peripherals connected to uart0_rx
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | uart0_rx Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : uart0_rx Mux Selection Field - sel
 * 
 * Select peripheral signals connected uart0_rx.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 61.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM0.SS1.
 * 
 * 2 : Pin is connected to Peripheral signal CAN0.RX.
 * 
 * 3 : Pin is connected to Peripheral signal UART0.RX.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO13_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO13_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO13.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO13_s
{
    uint32_t  sel :  2;  /* uart0_rx Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO13. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO13_s  ALT_SYSMGR_PINMUX_GENERALIO13_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO13 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO13_OFST        0xb4

/*
 * Register : uart0_tx Mux Selection Register - GENERALIO14
 * 
 * This register is used to control the peripherals connected to uart0_tx
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | uart0_tx Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : uart0_tx Mux Selection Field - sel
 * 
 * Select peripheral signals connected uart0_tx.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 62.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.SS1.
 * 
 * 2 : Pin is connected to Peripheral signal CAN0.TX.
 * 
 * 3 : Pin is connected to Peripheral signal UART0.TX.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO14_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO14_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO14.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO14_s
{
    uint32_t  sel :  2;  /* uart0_tx Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO14. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO14_s  ALT_SYSMGR_PINMUX_GENERALIO14_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO14 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO14_OFST        0xb8

/*
 * Register : i2c0_sda Mux Selection Register - GENERALIO15
 * 
 * This register is used to control the peripherals connected to i2c0_sda
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | i2c0_sda Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : i2c0_sda Mux Selection Field - sel
 * 
 * Select peripheral signals connected i2c0_sda.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 63.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.CLK.
 * 
 * 2 : Pin is connected to Peripheral signal UART1.RX.
 * 
 * 3 : Pin is connected to Peripheral signal I2C0.SDA.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO15_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO15_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO15.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO15_s
{
    uint32_t  sel :  2;  /* i2c0_sda Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO15. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO15_s  ALT_SYSMGR_PINMUX_GENERALIO15_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO15 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO15_OFST        0xbc

/*
 * Register : i2c0_scl Mux Selection Register - GENERALIO16
 * 
 * This register is used to control the peripherals connected to i2c0_scl
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | i2c0_scl Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : i2c0_scl Mux Selection Field - sel
 * 
 * Select peripheral signals connected i2c0_scl.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 64.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.MOSI.
 * 
 * 2 : Pin is connected to Peripheral signal UART1.TX.
 * 
 * 3 : Pin is connected to Peripheral signal I2C0.SCL.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO16_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO16_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO16.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO16_s
{
    uint32_t  sel :  2;  /* i2c0_scl Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO16. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO16_s  ALT_SYSMGR_PINMUX_GENERALIO16_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO16 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO16_OFST        0xc0

/*
 * Register : can0_rx Mux Selection Register - GENERALIO17
 * 
 * This register is used to control the peripherals connected to can0_rx
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | can0_rx Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : can0_rx Mux Selection Field - sel
 * 
 * Select peripheral signals connected can0_rx.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 65.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.MISO.
 * 
 * 2 : Pin is connected to Peripheral signal UART0.RX.
 * 
 * 3 : Pin is connected to Peripheral signal CAN0.RX.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO17_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO17_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO17.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO17_s
{
    uint32_t  sel :  2;  /* can0_rx Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO17. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO17_s  ALT_SYSMGR_PINMUX_GENERALIO17_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO17 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO17_OFST        0xc4

/*
 * Register : can0_tx Mux Selection Register - GENERALIO18
 * 
 * This register is used to control the peripherals connected to can0_tx
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | can0_tx Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : can0_tx Mux Selection Field - sel
 * 
 * Select peripheral signals connected can0_tx.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 66.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.SS0.
 * 
 * 2 : Pin is connected to Peripheral signal UART0.TX.
 * 
 * 3 : Pin is connected to Peripheral signal CAN0.TX.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO18_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO18_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO18.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO18_s
{
    uint32_t  sel :  2;  /* can0_tx Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO18. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO18_s  ALT_SYSMGR_PINMUX_GENERALIO18_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO18 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO18_OFST        0xc8

/*
 * Register : spis1_clk Mux Selection Register - GENERALIO19
 * 
 * This register is used to control the peripherals connected to spis1_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | spis1_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : spis1_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis1_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 67.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM1.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS1.CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO19_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO19_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO19.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO19_s
{
    uint32_t  sel :  2;  /* spis1_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO19. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO19_s  ALT_SYSMGR_PINMUX_GENERALIO19_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO19 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO19_OFST        0xcc

/*
 * Register : spis1_mosi Mux Selection Register - GENERALIO20
 * 
 * This register is used to control the peripherals connected to spis1_mosi
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | spis1_mosi Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : spis1_mosi Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis1_mosi.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 68.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM1.MOSI.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS1.MOSI.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO20_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO20_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO20.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO20_s
{
    uint32_t  sel :  2;  /* spis1_mosi Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO20. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO20_s  ALT_SYSMGR_PINMUX_GENERALIO20_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO20 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO20_OFST        0xd0

/*
 * Register : spis1_miso Mux Selection Register - GENERALIO21
 * 
 * This register is used to control the peripherals connected to spis1_miso
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | spis1_miso Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : spis1_miso Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis1_miso.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 69.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM1.MISO.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS1.MISO.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO21_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO21_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO21.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO21_s
{
    uint32_t  sel :  2;  /* spis1_miso Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO21. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO21_s  ALT_SYSMGR_PINMUX_GENERALIO21_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO21 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO21_OFST        0xd4

/*
 * Register : spis1_ss0 Mux Selection Register - GENERALIO22
 * 
 * This register is used to control the peripherals connected to spis1_ss0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | spis1_ss0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : spis1_ss0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis1_ss0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 70.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM1.SS0.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS1.SS0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO22_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO22_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO22.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO22_s
{
    uint32_t  sel :  2;  /* spis1_ss0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO22. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO22_s  ALT_SYSMGR_PINMUX_GENERALIO22_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO22 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO22_OFST        0xd8

/*
 * Register : uart1_rx Mux Selection Register - GENERALIO23
 * 
 * This register is used to control the peripherals connected to uart1_rx
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | uart1_rx Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : uart1_rx Mux Selection Field - sel
 * 
 * Select peripheral signals connected uart1_rx.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 62.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM1.SS1.
 * 
 * 3 : Pin is connected to Peripheral signal UART1.RX.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO23_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO23_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO23.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO23_s
{
    uint32_t  sel :  2;  /* uart1_rx Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO23. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO23_s  ALT_SYSMGR_PINMUX_GENERALIO23_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO23 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO23_OFST        0xdc

/*
 * Register : uart1_tx Mux Selection Register - GENERALIO24
 * 
 * This register is used to control the peripherals connected to uart1_tx
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | uart1_tx Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : uart1_tx Mux Selection Field - sel
 * 
 * Select peripheral signals connected uart1_tx.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 63.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal UART1.TX.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO24_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO24_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO24.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO24_s
{
    uint32_t  sel :  2;  /* uart1_tx Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO24. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO24_s  ALT_SYSMGR_PINMUX_GENERALIO24_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO24 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO24_OFST        0xe0

/*
 * Register : i2c1_sda Mux Selection Register - GENERALIO25
 * 
 * This register is used to control the peripherals connected to i2c1_sda
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | i2c1_sda Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : i2c1_sda Mux Selection Field - sel
 * 
 * Select peripheral signals connected i2c1_sda.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 64.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.MOSI.
 * 
 * 3 : Pin is connected to Peripheral signal I2C1.SDA.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO25_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO25_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO25.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO25_s
{
    uint32_t  sel :  2;  /* i2c1_sda Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO25. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO25_s  ALT_SYSMGR_PINMUX_GENERALIO25_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO25 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO25_OFST        0xe4

/*
 * Register : i2c1_scl Mux Selection Register - GENERALIO26
 * 
 * This register is used to control the peripherals connected to i2c1_scl
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | i2c1_scl Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : i2c1_scl Mux Selection Field - sel
 * 
 * Select peripheral signals connected i2c1_scl.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 65.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.MISO.
 * 
 * 3 : Pin is connected to Peripheral signal I2C1.SCL.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO26_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO26_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO26.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO26_s
{
    uint32_t  sel :  2;  /* i2c1_scl Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO26. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO26_s  ALT_SYSMGR_PINMUX_GENERALIO26_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO26 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO26_OFST        0xe8

/*
 * Register : spim0_ss0_alt Mux Selection Register - GENERALIO27
 * 
 * This register is used to control the peripherals connected to spim0_ss0_alt
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                      
 * :-------|:-------|:------|:----------------------------------
 *  [1:0]  | RW     | 0x0   | spim0_ss0_alt Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                      
 * 
 */
/*
 * Field : spim0_ss0_alt Mux Selection Field - sel
 * 
 * Select peripheral signals connected spim0_ss0_alt.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 66.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.SS0.
 * 
 * 3 : Pin is connected to Peripheral signal not applicable.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO27_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO27_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO27.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO27_s
{
    uint32_t  sel :  2;  /* spim0_ss0_alt Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO27. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO27_s  ALT_SYSMGR_PINMUX_GENERALIO27_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO27 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO27_OFST        0xec

/*
 * Register : spis0_clk Mux Selection Register - GENERALIO28
 * 
 * This register is used to control the peripherals connected to spis0_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | spis0_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : spis0_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis0_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 67.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.SS1.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS0.CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO28_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO28_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO28.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO28_s
{
    uint32_t  sel :  2;  /* spis0_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO28. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO28_s  ALT_SYSMGR_PINMUX_GENERALIO28_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO28 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO28_OFST        0xf0

/*
 * Register : spis0_mosi Mux Selection Register - GENERALIO29
 * 
 * This register is used to control the peripherals connected to spis0_mosi
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | spis0_mosi Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : spis0_mosi Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis0_mosi.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 68.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS0.MOSI.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO29_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO29_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO29.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO29_s
{
    uint32_t  sel :  2;  /* spis0_mosi Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO29. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO29_s  ALT_SYSMGR_PINMUX_GENERALIO29_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO29 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO29_OFST        0xf4

/*
 * Register : spis0_miso Mux Selection Register - GENERALIO30
 * 
 * This register is used to control the peripherals connected to spis0_miso
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | spis0_miso Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : spis0_miso Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis0_miso.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 69.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS0.MISO.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO30_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO30_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO30.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO30_s
{
    uint32_t  sel :  2;  /* spis0_miso Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO30. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO30_s  ALT_SYSMGR_PINMUX_GENERALIO30_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO30 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO30_OFST        0xf8

/*
 * Register : spis0_ss0 Mux Selection Register - GENERALIO31
 * 
 * This register is used to control the peripherals connected to spis0_ss0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | spis0_ss0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : spis0_ss0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected spis0_ss0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 70.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal SPIS0.SS0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GENERALIO31_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GENERALIO31_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GENERALIO31.
 */
struct ALT_SYSMGR_PINMUX_GENERALIO31_s
{
    uint32_t  sel :  2;  /* spis0_ss0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GENERALIO31. */
typedef volatile struct ALT_SYSMGR_PINMUX_GENERALIO31_s  ALT_SYSMGR_PINMUX_GENERALIO31_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GENERALIO31 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GENERALIO31_OFST        0xfc

/*
 * Register : nand_ale Mux Selection Register - MIXED1IO0
 * 
 * This register is used to control the peripherals connected to nand_ale
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_ale Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_ale Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_ale.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 14.
 * 
 * 1 : Pin is connected to Peripheral signal QSPI.SS3.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.TX_CLK.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.ale.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO0_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO0_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO0.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO0_s
{
    uint32_t  sel :  2;  /* nand_ale Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO0. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO0_s  ALT_SYSMGR_PINMUX_MIXED1IO0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO0 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO0_OFST        0x100

/*
 * Register : nand_ce Mux Selection Register - MIXED1IO1
 * 
 * This register is used to control the peripherals connected to nand_ce
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | nand_ce Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : nand_ce Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_ce.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 15.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D0.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.TXD0.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.ce.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO1_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO1_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO1.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO1_s
{
    uint32_t  sel :  2;  /* nand_ce Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO1. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO1_s  ALT_SYSMGR_PINMUX_MIXED1IO1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO1 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO1_OFST        0x104

/*
 * Register : nand_cle Mux Selection Register - MIXED1IO2
 * 
 * This register is used to control the peripherals connected to nand_cle
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_cle Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_cle Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_cle.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 16.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D1.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.TXD1.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.cle.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO2_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO2_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO2.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO2_s
{
    uint32_t  sel :  2;  /* nand_cle Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO2. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO2_s  ALT_SYSMGR_PINMUX_MIXED1IO2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO2 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO2_OFST        0x108

/*
 * Register : nand_re Mux Selection Register - MIXED1IO3
 * 
 * This register is used to control the peripherals connected to nand_re
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | nand_re Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : nand_re Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_re.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 17.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D2.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.TXD2.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.re.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO3_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO3_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO3.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO3_s
{
    uint32_t  sel :  2;  /* nand_re Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO3. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO3_s  ALT_SYSMGR_PINMUX_MIXED1IO3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO3 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO3_OFST        0x10c

/*
 * Register : nand_rb Mux Selection Register - MIXED1IO4
 * 
 * This register is used to control the peripherals connected to nand_rb
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | nand_rb Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : nand_rb Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_rb.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 18.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D3.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.TXD3.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.rb.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO4_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO4_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO4.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO4_s
{
    uint32_t  sel :  2;  /* nand_rb Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO4. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO4_s  ALT_SYSMGR_PINMUX_MIXED1IO4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO4 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO4_OFST        0x110

/*
 * Register : nand_dq0 Mux Selection Register - MIXED1IO5
 * 
 * This register is used to control the peripherals connected to nand_dq0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 19.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.RXD0.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO5_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO5_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO5.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO5_s
{
    uint32_t  sel :  2;  /* nand_dq0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO5. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO5_s  ALT_SYSMGR_PINMUX_MIXED1IO5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO5 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO5_OFST        0x114

/*
 * Register : nand_dq1 Mux Selection Register - MIXED1IO6
 * 
 * This register is used to control the peripherals connected to nand_dq1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 20.
 * 
 * 1 : Pin is connected to Peripheral signal I2C3.SDA.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.MDIO.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO6_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO6_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO6.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO6_s
{
    uint32_t  sel :  2;  /* nand_dq1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO6. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO6_s  ALT_SYSMGR_PINMUX_MIXED1IO6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO6 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO6_OFST        0x118

/*
 * Register : nand_dq2 Mux Selection Register - MIXED1IO7
 * 
 * This register is used to control the peripherals connected to nand_dq2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 21.
 * 
 * 1 : Pin is connected to Peripheral signal I2C3.SCL.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.MDC.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO7_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO7_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO7.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO7_s
{
    uint32_t  sel :  2;  /* nand_dq2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO7. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO7_s  ALT_SYSMGR_PINMUX_MIXED1IO7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO7 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO7_OFST        0x11c

/*
 * Register : nand_dq3 Mux Selection Register - MIXED1IO8
 * 
 * This register is used to control the peripherals connected to nand_dq3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 22.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D4.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.RX_CTL.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO8_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO8_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO8.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO8_s
{
    uint32_t  sel :  2;  /* nand_dq3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO8. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO8_s  ALT_SYSMGR_PINMUX_MIXED1IO8_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO8 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO8_OFST        0x120

/*
 * Register : nand_dq4 Mux Selection Register - MIXED1IO9
 * 
 * This register is used to control the peripherals connected to nand_dq4
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq4 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq4 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq4.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 23.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D5.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.TX_CTL.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq4.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO9_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO9_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO9.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO9_s
{
    uint32_t  sel :  2;  /* nand_dq4 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO9. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO9_s  ALT_SYSMGR_PINMUX_MIXED1IO9_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO9 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO9_OFST        0x124

/*
 * Register : nand_dq5 Mux Selection Register - MIXED1IO10
 * 
 * This register is used to control the peripherals connected to nand_dq5
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq5 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq5 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq5.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 24.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D6.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.RX_CLK.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq5.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO10_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO10_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO10.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO10_s
{
    uint32_t  sel :  2;  /* nand_dq5 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO10. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO10_s  ALT_SYSMGR_PINMUX_MIXED1IO10_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO10 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO10_OFST        0x128

/*
 * Register : nand_dq6 Mux Selection Register - MIXED1IO11
 * 
 * This register is used to control the peripherals connected to nand_dq6
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq6 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq6 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq6.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 25.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.D7.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.RXD1.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq6.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO11_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO11_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO11.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO11_s
{
    uint32_t  sel :  2;  /* nand_dq6 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO11. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO11_s  ALT_SYSMGR_PINMUX_MIXED1IO11_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO11 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO11_OFST        0x12c

/*
 * Register : nand_dq7 Mux Selection Register - MIXED1IO12
 * 
 * This register is used to control the peripherals connected to nand_dq7
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | nand_dq7 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : nand_dq7 Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_dq7.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 26.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.RXD2.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.dq7.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO12_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO12_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO12.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO12_s
{
    uint32_t  sel :  2;  /* nand_dq7 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO12. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO12_s  ALT_SYSMGR_PINMUX_MIXED1IO12_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO12 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO12_OFST        0x130

/*
 * Register : nand_wp Mux Selection Register - MIXED1IO13
 * 
 * This register is used to control the peripherals connected to nand_wp
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | nand_wp Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : nand_wp Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_wp.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 27.
 * 
 * 1 : Pin is connected to Peripheral signal QSPI.SS2.
 * 
 * 2 : Pin is connected to Peripheral signal RGMII1.RXD3.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.wp.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO13_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO13_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO13.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO13_s
{
    uint32_t  sel :  2;  /* nand_wp Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO13. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO13_s  ALT_SYSMGR_PINMUX_MIXED1IO13_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO13 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO13_OFST        0x134

/*
 * Register : nand_we Mux Selection Register - MIXED1IO14
 * 
 * This register is used to control the peripherals connected to nand_we
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                
 * :-------|:-------|:------|:----------------------------
 *  [1:0]  | RW     | 0x0   | nand_we Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                
 * 
 */
/*
 * Field : nand_we Mux Selection Field - sel
 * 
 * Select peripheral signals connected nand_we.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 28.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal QSPI.SS1.
 * 
 * 3 : Pin is connected to Peripheral signal NAND.we.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO14_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO14_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO14.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO14_s
{
    uint32_t  sel :  2;  /* nand_we Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO14. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO14_s  ALT_SYSMGR_PINMUX_MIXED1IO14_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO14 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO14_OFST        0x138

/*
 * Register : qspi_io0 Mux Selection Register - MIXED1IO15
 * 
 * This register is used to control the peripherals connected to qspi_io0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qspi_io0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qspi_io0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected qspi_io0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 29.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.CLK.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.IO0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO15_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO15_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO15.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO15_s
{
    uint32_t  sel :  2;  /* qspi_io0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO15. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO15_s  ALT_SYSMGR_PINMUX_MIXED1IO15_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO15 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO15_OFST        0x13c

/*
 * Register : qspi_io1 Mux Selection Register - MIXED1IO16
 * 
 * This register is used to control the peripherals connected to qspi_io1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qspi_io1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qspi_io1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected qspi_io1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 30.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.STP.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.IO1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO16_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO16_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO16.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO16_s
{
    uint32_t  sel :  2;  /* qspi_io1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO16. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO16_s  ALT_SYSMGR_PINMUX_MIXED1IO16_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO16 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO16_OFST        0x140

/*
 * Register : qspi_io2 Mux Selection Register - MIXED1IO17
 * 
 * This register is used to control the peripherals connected to qspi_io2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qspi_io2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qspi_io2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected qspi_io2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 31.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.DIR.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.IO2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO17_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO17_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO17.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO17_s
{
    uint32_t  sel :  2;  /* qspi_io2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO17. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO17_s  ALT_SYSMGR_PINMUX_MIXED1IO17_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO17 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO17_OFST        0x144

/*
 * Register : qspi_io3 Mux Selection Register - MIXED1IO18
 * 
 * This register is used to control the peripherals connected to qspi_io3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qspi_io3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qspi_io3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected qspi_io3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 32.
 * 
 * 1 : Pin is connected to Peripheral signal USB1.NXT.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.IO3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO18_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO18_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO18.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO18_s
{
    uint32_t  sel :  2;  /* qspi_io3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO18. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO18_s  ALT_SYSMGR_PINMUX_MIXED1IO18_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO18 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO18_OFST        0x148

/*
 * Register : qspi_ss0 Mux Selection Register - MIXED1IO19
 * 
 * This register is used to control the peripherals connected to qspi_ss0
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qspi_ss0 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qspi_ss0 Mux Selection Field - sel
 * 
 * Select peripheral signals connected qspi_ss0.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 33.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.SS0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO19_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO19_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO19.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO19_s
{
    uint32_t  sel :  2;  /* qspi_ss0 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO19. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO19_s  ALT_SYSMGR_PINMUX_MIXED1IO19_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO19 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO19_OFST        0x14c

/*
 * Register : qpsi_clk Mux Selection Register - MIXED1IO20
 * 
 * This register is used to control the peripherals connected to qpsi_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qpsi_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qpsi_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected qpsi_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 34.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO20_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO20_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO20.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO20_s
{
    uint32_t  sel :  2;  /* qpsi_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO20. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO20_s  ALT_SYSMGR_PINMUX_MIXED1IO20_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO20 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO20_OFST        0x150

/*
 * Register : qspi_ss1 Mux Selection Register - MIXED1IO21
 * 
 * This register is used to control the peripherals connected to qspi_ss1
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                 
 * :-------|:-------|:------|:-----------------------------
 *  [1:0]  | RW     | 0x0   | qspi_ss1 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                 
 * 
 */
/*
 * Field : qspi_ss1 Mux Selection Field - sel
 * 
 * Select peripheral signals connected qspi_ss1.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 35.
 * 
 * 1 : Pin is connected to Peripheral signal not applicable.
 * 
 * 2 : Pin is connected to Peripheral signal not applicable.
 * 
 * 3 : Pin is connected to Peripheral signal QSPI.SS1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED1IO21_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED1IO21_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED1IO21.
 */
struct ALT_SYSMGR_PINMUX_MIXED1IO21_s
{
    uint32_t  sel :  2;  /* qspi_ss1 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED1IO21. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED1IO21_s  ALT_SYSMGR_PINMUX_MIXED1IO21_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED1IO21 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED1IO21_OFST        0x154

/*
 * Register : emac1_mdio Mux Selection Register - MIXED2IO0
 * 
 * This register is used to control the peripherals connected to emac1_mdio
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                   
 * :-------|:-------|:------|:-------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_mdio Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                   
 * 
 */
/*
 * Field : emac1_mdio Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_mdio.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 54.
 * 
 * 1 : Pin is connected to Peripheral signal SPIS0.CLK.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.MDIO.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO0_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO0_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO0.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO0_s
{
    uint32_t  sel :  2;  /* emac1_mdio Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO0. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO0_s  ALT_SYSMGR_PINMUX_MIXED2IO0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO0 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO0_OFST        0x158

/*
 * Register : emac1_mdc Mux Selection Register - MIXED2IO1
 * 
 * This register is used to control the peripherals connected to emac1_mdc
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                  
 * :-------|:-------|:------|:------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_mdc Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                  
 * 
 */
/*
 * Field : emac1_mdc Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_mdc.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 55.
 * 
 * 1 : Pin is connected to Peripheral signal SPIS0.MOSI.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.MOSI.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.MDC.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO1_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO1_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO1.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO1_s
{
    uint32_t  sel :  2;  /* emac1_mdc Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO1. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO1_s  ALT_SYSMGR_PINMUX_MIXED2IO1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO1 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO1_OFST        0x15c

/*
 * Register : emac1_tx_d2 Mux Selection Register - MIXED2IO2
 * 
 * This register is used to control the peripherals connected to emac1_tx_d2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_tx_d2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_tx_d2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_tx_d2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 56.
 * 
 * 1 : Pin is connected to Peripheral signal SPIS0.MISO.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.MISO.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.TXD2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO2_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO2_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO2.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO2_s
{
    uint32_t  sel :  2;  /* emac1_tx_d2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO2. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO2_s  ALT_SYSMGR_PINMUX_MIXED2IO2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO2 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO2_OFST        0x160

/*
 * Register : emac1_tx_d3 Mux Selection Register - MIXED2IO3
 * 
 * This register is used to control the peripherals connected to emac1_tx_d3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_tx_d3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_tx_d3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_tx_d3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 57.
 * 
 * 1 : Pin is connected to Peripheral signal SPIS0.SS0.
 * 
 * 2 : Pin is connected to Peripheral signal SPIM0.SS0.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.TXD3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO3_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO3_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO3.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO3_s
{
    uint32_t  sel :  2;  /* emac1_tx_d3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO3. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO3_s  ALT_SYSMGR_PINMUX_MIXED2IO3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO3 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO3_OFST        0x164

/*
 * Register : emac1_rx_clk Mux Selection Register - MIXED2IO4
 * 
 * This register is used to control the peripherals connected to emac1_rx_clk
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_rx_clk Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac1_rx_clk Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_rx_clk.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 58.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.CLK.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.CLK.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.RX_CLK.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO4_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO4_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO4.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO4_s
{
    uint32_t  sel :  2;  /* emac1_rx_clk Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO4. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO4_s  ALT_SYSMGR_PINMUX_MIXED2IO4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO4 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO4_OFST        0x168

/*
 * Register : emac1_rx_ctl Mux Selection Register - MIXED2IO5
 * 
 * This register is used to control the peripherals connected to emac1_rx_ctl
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                     
 * :-------|:-------|:------|:---------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_rx_ctl Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                     
 * 
 */
/*
 * Field : emac1_rx_ctl Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_rx_ctl.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 59.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.MOSI.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.MOSI.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.RX_CTL.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO5_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO5_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO5.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO5_s
{
    uint32_t  sel :  2;  /* emac1_rx_ctl Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO5. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO5_s  ALT_SYSMGR_PINMUX_MIXED2IO5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO5 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO5_OFST        0x16c

/*
 * Register : emac1_rx_d2 Mux Selection Register - MIXED2IO6
 * 
 * This register is used to control the peripherals connected to emac1_rx_d2
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_rx_d2 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_rx_d2 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_rx_d2.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 60.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.MISO.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.MISO.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.RXD2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO6_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO6_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO6.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO6_s
{
    uint32_t  sel :  2;  /* emac1_rx_d2 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO6. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO6_s  ALT_SYSMGR_PINMUX_MIXED2IO6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO6 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO6_OFST        0x170

/*
 * Register : emac1_rx_d3 Mux Selection Register - MIXED2IO7
 * 
 * This register is used to control the peripherals connected to emac1_rx_d3
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                    
 * :-------|:-------|:------|:--------------------------------
 *  [1:0]  | RW     | 0x0   | emac1_rx_d3 Mux Selection Field
 *  [31:2] | ???    | 0x0   | *UNDEFINED*                    
 * 
 */
/*
 * Field : emac1_rx_d3 Mux Selection Field - sel
 * 
 * Select peripheral signals connected emac1_rx_d3.
 * 
 * 0 : Pin is connected to GPIO/LoanIO number 61.
 * 
 * 1 : Pin is connected to Peripheral signal SPIM1.SS0.
 * 
 * 2 : Pin is connected to Peripheral signal SPIS1.SS0.
 * 
 * 3 : Pin is connected to Peripheral signal RGMII1.RXD3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_MSB        1
/* The width in bits of the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_WIDTH      2
/* The mask used to set the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_SET_MSK    0x00000003
/* The mask used to clear the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_CLR_MSK    0xfffffffc
/* The reset value of the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_MIXED2IO7_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_GET(value) (((value) & 0x00000003) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_MIXED2IO7_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_SEL_SET(value) (((value) << 0) & 0x00000003)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_MIXED2IO7.
 */
struct ALT_SYSMGR_PINMUX_MIXED2IO7_s
{
    uint32_t  sel :  2;  /* emac1_rx_d3 Mux Selection Field */
    uint32_t      : 30;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_MIXED2IO7. */
typedef volatile struct ALT_SYSMGR_PINMUX_MIXED2IO7_s  ALT_SYSMGR_PINMUX_MIXED2IO7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_MIXED2IO7 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_MIXED2IO7_OFST        0x174

/*
 * Register : GPIO/LoanIO 48 Input Mux Selection Register - GPLINMUX48
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 48.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO48Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO48Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 48.
 * 
 * 0 : Source for GPIO/LoanIO 48 is GENERALIO0.
 * 
 * 1 : Source for GPIO/LoanIO 48 is EMACIO14.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX48_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX48_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX48.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX48_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO48Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX48. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX48_s  ALT_SYSMGR_PINMUX_GPLINMUX48_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX48 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX48_OFST        0x178

/*
 * Register : GPIO/LoanIO 49 Input Mux Selection Register - GPLINMUX49
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 49.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO49Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO49Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 49.
 * 
 * 0 : Source for GPIO/LoanIO 49 is GENERALIO1.
 * 
 * 1 : Source for GPIO/LoanIO 49 is EMACIO15.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX49_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX49_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX49.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX49_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO49Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX49. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX49_s  ALT_SYSMGR_PINMUX_GPLINMUX49_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX49 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX49_OFST        0x17c

/*
 * Register : GPIO/LoanIO 50 Input Mux Selection Register - GPLINMUX50
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 50.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO50Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO50Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 50.
 * 
 * 0 : Source for GPIO/LoanIO 50 is GENERALIO2.
 * 
 * 1 : Source for GPIO/LoanIO 50 is EMACIO16.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX50_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX50_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX50.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX50_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO50Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX50. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX50_s  ALT_SYSMGR_PINMUX_GPLINMUX50_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX50 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX50_OFST        0x180

/*
 * Register : GPIO/LoanIO 51 Input Mux Selection Register - GPLINMUX51
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 51.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO51Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO51Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 51.
 * 
 * 0 : Source for GPIO/LoanIO 51 is GENERALIO3.
 * 
 * 1 : Source for GPIO/LoanIO 51 is EMACIO17.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX51_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX51_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX51.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX51_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO51Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX51. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX51_s  ALT_SYSMGR_PINMUX_GPLINMUX51_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX51 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX51_OFST        0x184

/*
 * Register : GPIO/LoanIO 52 Input Mux Selection Register - GPLINMUX52
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 52.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO52Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO52Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 52.
 * 
 * 0 : Source for GPIO/LoanIO 52 is GENERALIO4.
 * 
 * 1 : Source for GPIO/LoanIO 52 is EMACIO18.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX52_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX52_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX52.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX52_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO52Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX52. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX52_s  ALT_SYSMGR_PINMUX_GPLINMUX52_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX52 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX52_OFST        0x188

/*
 * Register : GPIO/LoanIO 53 Input Mux Selection Register - GPLINMUX53
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 53.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO53Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO53Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 53.
 * 
 * 0 : Source for GPIO/LoanIO 53 is GENERALIO5.
 * 
 * 1 : Source for GPIO/LoanIO 53 is EMACIO19.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX53_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX53_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX53.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX53_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO53Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX53. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX53_s  ALT_SYSMGR_PINMUX_GPLINMUX53_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX53 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX53_OFST        0x18c

/*
 * Register : GPIO/LoanIO 54 Input Mux Selection Register - GPLINMUX54
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 54.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO54Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO54Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 54.
 * 
 * 0 : Source for GPIO/LoanIO 54 is GENERALIO6.
 * 
 * 1 : Source for GPIO/LoanIO 54 is MIXED2IO0.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX54_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX54_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX54.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX54_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO54Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX54. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX54_s  ALT_SYSMGR_PINMUX_GPLINMUX54_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX54 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX54_OFST        0x190

/*
 * Register : GPIO/LoanIO 55 Input Mux Selection Register - GPLINMUX55
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 55.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO55Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO55Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 55.
 * 
 * 0 : Source for GPIO/LoanIO 55 is GENERALIO7.
 * 
 * 1 : Source for GPIO/LoanIO 55 is MIXED2IO1.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX55_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX55_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX55.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX55_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO55Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX55. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX55_s  ALT_SYSMGR_PINMUX_GPLINMUX55_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX55 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX55_OFST        0x194

/*
 * Register : GPIO/LoanIO 56 Input Mux Selection Register - GPLINMUX56
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 56.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO56Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO56Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 56.
 * 
 * 0 : Source for GPIO/LoanIO 56 is GENERALIO8.
 * 
 * 1 : Source for GPIO/LoanIO 56 is MIXED2IO2.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX56_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX56_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX56.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX56_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO56Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX56. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX56_s  ALT_SYSMGR_PINMUX_GPLINMUX56_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX56 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX56_OFST        0x198

/*
 * Register : GPIO/LoanIO 57 Input Mux Selection Register - GPLINMUX57
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 57.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO57Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO57Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 57.
 * 
 * 0 : Source for GPIO/LoanIO 57 is GENERALIO9.
 * 
 * 1 : Source for GPIO/LoanIO 57 is MIXED2IO3.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX57_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX57_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX57.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX57_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO57Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX57. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX57_s  ALT_SYSMGR_PINMUX_GPLINMUX57_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX57 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX57_OFST        0x19c

/*
 * Register : GPIO/LoanIO 58 Input Mux Selection Register - GPLINMUX58
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 58.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO58Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO58Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 58.
 * 
 * 0 : Source for GPIO/LoanIO 58 is GENERALIO10.
 * 
 * 1 : Source for GPIO/LoanIO 58 is MIXED2IO4.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX58_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX58_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX58.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX58_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO58Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX58. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX58_s  ALT_SYSMGR_PINMUX_GPLINMUX58_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX58 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX58_OFST        0x1a0

/*
 * Register : GPIO/LoanIO 59 Input Mux Selection Register - GPLINMUX59
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 59.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO59Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO59Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 59.
 * 
 * 0 : Source for GPIO/LoanIO 59 is GENERALIO11.
 * 
 * 1 : Source for GPIO/LoanIO 59 is MIXED2IO5.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX59_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX59_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX59.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX59_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO59Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX59. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX59_s  ALT_SYSMGR_PINMUX_GPLINMUX59_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX59 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX59_OFST        0x1a4

/*
 * Register : GPIO/LoanIO 60 Input Mux Selection Register - GPLINMUX60
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 60.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO60Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO60Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 60.
 * 
 * 0 : Source for GPIO/LoanIO 60 is GENERALIO12.
 * 
 * 1 : Source for GPIO/LoanIO 60 is MIXED2IO6.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX60_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX60_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX60.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX60_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO60Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX60. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX60_s  ALT_SYSMGR_PINMUX_GPLINMUX60_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX60 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX60_OFST        0x1a8

/*
 * Register : GPIO/LoanIO 61 Input Mux Selection Register - GPLINMUX61
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 61.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO61Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO61Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 61.
 * 
 * 0 : Source for GPIO/LoanIO 61 is GENERALIO13.
 * 
 * 1 : Source for GPIO/LoanIO 61 is MIXED2IO7.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX61_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX61_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX61.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX61_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO61Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX61. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX61_s  ALT_SYSMGR_PINMUX_GPLINMUX61_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX61 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX61_OFST        0x1ac

/*
 * Register : GPIO/LoanIO 62 Input Mux Selection Register - GPLINMUX62
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 62.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO62Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO62Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 62.
 * 
 * 0 : Source for GPIO/LoanIO 62 is GENERALIO14.
 * 
 * 1 : Source for GPIO/LoanIO 62 is GENERALIO23.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX62_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX62_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX62.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX62_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO62Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX62. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX62_s  ALT_SYSMGR_PINMUX_GPLINMUX62_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX62 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX62_OFST        0x1b0

/*
 * Register : GPIO/LoanIO 63 Input Mux Selection Register - GPLINMUX63
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 63.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO63Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO63Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 63.
 * 
 * 0 : Source for GPIO/LoanIO 63 is GENERALIO15.
 * 
 * 1 : Source for GPIO/LoanIO 63 is GENERALIO24.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX63_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX63_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX63.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX63_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO63Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX63. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX63_s  ALT_SYSMGR_PINMUX_GPLINMUX63_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX63 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX63_OFST        0x1b4

/*
 * Register : GPIO/LoanIO 64 Input Mux Selection Register - GPLINMUX64
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 64.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO64Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO64Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 64.
 * 
 * 0 : Source for GPIO/LoanIO 64 is GENERALIO16.
 * 
 * 1 : Source for GPIO/LoanIO 64 is GENERALIO25.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX64_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX64_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX64.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX64_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO64Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX64. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX64_s  ALT_SYSMGR_PINMUX_GPLINMUX64_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX64 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX64_OFST        0x1b8

/*
 * Register : GPIO/LoanIO 65 Input Mux Selection Register - GPLINMUX65
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 65.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO65Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO65Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 65.
 * 
 * 0 : Source for GPIO/LoanIO 65 is GENERALIO17.
 * 
 * 1 : Source for GPIO/LoanIO 65 is GENERALIO26.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX65_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX65_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX65.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX65_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO65Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX65. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX65_s  ALT_SYSMGR_PINMUX_GPLINMUX65_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX65 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX65_OFST        0x1bc

/*
 * Register : GPIO/LoanIO 66 Input Mux Selection Register - GPLINMUX66
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 66.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO66Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO66Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 66.
 * 
 * 0 : Source for GPIO/LoanIO 66 is GENERALIO18.
 * 
 * 1 : Source for GPIO/LoanIO 66 is GENERALIO27.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX66_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX66_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX66.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX66_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO66Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX66. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX66_s  ALT_SYSMGR_PINMUX_GPLINMUX66_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX66 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX66_OFST        0x1c0

/*
 * Register : GPIO/LoanIO 67 Input Mux Selection Register - GPLINMUX67
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 67.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO67Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO67Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 67.
 * 
 * 0 : Source for GPIO/LoanIO 67 is GENERALIO19.
 * 
 * 1 : Source for GPIO/LoanIO 67 is GENERALIO28.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX67_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX67_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX67.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX67_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO67Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX67. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX67_s  ALT_SYSMGR_PINMUX_GPLINMUX67_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX67 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX67_OFST        0x1c4

/*
 * Register : GPIO/LoanIO 68 Input Mux Selection Register - GPLINMUX68
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 68.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO68Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO68Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 68.
 * 
 * 0 : Source for GPIO/LoanIO 68 is GENERALIO20.
 * 
 * 1 : Source for GPIO/LoanIO 68 is GENERALIO29.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX68_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX68_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX68.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX68_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO68Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX68. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX68_s  ALT_SYSMGR_PINMUX_GPLINMUX68_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX68 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX68_OFST        0x1c8

/*
 * Register : GPIO/LoanIO 69 Input Mux Selection Register - GPLINMUX69
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 69.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO69Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO69Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 69.
 * 
 * 0 : Source for GPIO/LoanIO 69 is GENERALIO21.
 * 
 * 1 : Source for GPIO/LoanIO 69 is GENERALIO30.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX69_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX69_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX69.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX69_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO69Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX69. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX69_s  ALT_SYSMGR_PINMUX_GPLINMUX69_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX69 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX69_OFST        0x1cc

/*
 * Register : GPIO/LoanIO 70 Input Mux Selection Register - GPLINMUX70
 * 
 * Some GPIO/LoanIO inputs can be driven by multiple pins. This register selects
 * the input signal for GPIO/LoanIO 70.
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO70Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO70Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 70.
 * 
 * 0 : Source for GPIO/LoanIO 70 is GENERALIO22.
 * 
 * 1 : Source for GPIO/LoanIO 70 is GENERALIO31.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLINMUX70_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLINMUX70_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLINMUX70.
 */
struct ALT_SYSMGR_PINMUX_GPLINMUX70_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO70Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLINMUX70. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLINMUX70_s  ALT_SYSMGR_PINMUX_GPLINMUX70_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLINMUX70 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLINMUX70_OFST        0x1d0

/*
 * Register : GPIO/LoanIO 0 Output/Output Enable Mux Selection Register - GPLMUX0
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO0 and
 * LoanIO0. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO0Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO0Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 0.
 * 
 * 0 : LoanIO 0 controls GPIO/LOANIO[0] output and output enable signals.
 * 
 * 1 : GPIO 0 controls GPIO/LOANI[0] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX0_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX0_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX0.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX0_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO0Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX0. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX0_s  ALT_SYSMGR_PINMUX_GPLMUX0_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX0 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX0_OFST        0x1d4

/*
 * Register : GPIO/LoanIO 1 Output/Output Enable Mux Selection Register - GPLMUX1
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO1 and
 * LoanIO1. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO1Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO1Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 1.
 * 
 * 0 : LoanIO 1 controls GPIO/LOANIO[1] output and output enable signals.
 * 
 * 1 : GPIO 1 controls GPIO/LOANI[1] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX1_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX1_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX1.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX1_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO1Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX1. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX1_s  ALT_SYSMGR_PINMUX_GPLMUX1_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX1 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX1_OFST        0x1d8

/*
 * Register : GPIO/LoanIO 2 Output/Output Enable Mux Selection Register - GPLMUX2
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO2 and
 * LoanIO2. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO2Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO2Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 2.
 * 
 * 0 : LoanIO 2 controls GPIO/LOANIO[2] output and output enable signals.
 * 
 * 1 : GPIO 2 controls GPIO/LOANI[2] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX2_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX2_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX2.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX2_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO2Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX2. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX2_s  ALT_SYSMGR_PINMUX_GPLMUX2_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX2 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX2_OFST        0x1dc

/*
 * Register : GPIO/LoanIO 3 Output/Output Enable Mux Selection Register - GPLMUX3
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO3 and
 * LoanIO3. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO3Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO3Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 3.
 * 
 * 0 : LoanIO 3 controls GPIO/LOANIO[3] output and output enable signals.
 * 
 * 1 : GPIO 3 controls GPIO/LOANI[3] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX3_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX3_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX3.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX3_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO3Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX3. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX3_s  ALT_SYSMGR_PINMUX_GPLMUX3_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX3 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX3_OFST        0x1e0

/*
 * Register : GPIO/LoanIO 4 Output/Output Enable Mux Selection Register - GPLMUX4
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO4 and
 * LoanIO4. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO4Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO4Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 4.
 * 
 * 0 : LoanIO 4 controls GPIO/LOANIO[4] output and output enable signals.
 * 
 * 1 : GPIO 4 controls GPIO/LOANI[4] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX4_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX4_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX4.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX4_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO4Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX4. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX4_s  ALT_SYSMGR_PINMUX_GPLMUX4_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX4 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX4_OFST        0x1e4

/*
 * Register : GPIO/LoanIO 5 Output/Output Enable Mux Selection Register - GPLMUX5
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO5 and
 * LoanIO5. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO5Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO5Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 5.
 * 
 * 0 : LoanIO 5 controls GPIO/LOANIO[5] output and output enable signals.
 * 
 * 1 : GPIO 5 controls GPIO/LOANI[5] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX5_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX5_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX5.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX5_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO5Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX5. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX5_s  ALT_SYSMGR_PINMUX_GPLMUX5_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX5 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX5_OFST        0x1e8

/*
 * Register : GPIO/LoanIO 6 Output/Output Enable Mux Selection Register - GPLMUX6
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO6 and
 * LoanIO6. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO6Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO6Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 6.
 * 
 * 0 : LoanIO 6 controls GPIO/LOANIO[6] output and output enable signals.
 * 
 * 1 : GPIO 6 controls GPIO/LOANI[6] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX6_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX6_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX6.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX6_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO6Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX6. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX6_s  ALT_SYSMGR_PINMUX_GPLMUX6_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX6 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX6_OFST        0x1ec

/*
 * Register : GPIO/LoanIO 7 Output/Output Enable Mux Selection Register - GPLMUX7
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO7 and
 * LoanIO7. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO7Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO7Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 7.
 * 
 * 0 : LoanIO 7 controls GPIO/LOANIO[7] output and output enable signals.
 * 
 * 1 : GPIO 7 controls GPIO/LOANI[7] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX7_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX7_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX7.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX7_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO7Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX7. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX7_s  ALT_SYSMGR_PINMUX_GPLMUX7_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX7 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX7_OFST        0x1f0

/*
 * Register : GPIO/LoanIO 8 Output/Output Enable Mux Selection Register - GPLMUX8
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO8 and
 * LoanIO8. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO8Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO8Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 8.
 * 
 * 0 : LoanIO 8 controls GPIO/LOANIO[8] output and output enable signals.
 * 
 * 1 : GPIO 8 controls GPIO/LOANI[8] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX8_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX8_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX8.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX8_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO8Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX8. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX8_s  ALT_SYSMGR_PINMUX_GPLMUX8_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX8 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX8_OFST        0x1f4

/*
 * Register : GPIO/LoanIO 9 Output/Output Enable Mux Selection Register - GPLMUX9
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO9 and
 * LoanIO9. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                           
 * :-------|:-------|:------|:---------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO9Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                           
 * 
 */
/*
 * Field : GPIO/Loan IO9Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 9.
 * 
 * 0 : LoanIO 9 controls GPIO/LOANIO[9] output and output enable signals.
 * 
 * 1 : GPIO 9 controls GPIO/LOANI[9] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX9_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX9_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX9.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX9_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO9Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX9. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX9_s  ALT_SYSMGR_PINMUX_GPLMUX9_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX9 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX9_OFST        0x1f8

/*
 * Register : GPIO/LoanIO 10 Output/Output Enable Mux Selection Register - GPLMUX10
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO10 and
 * LoanIO10. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO10Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO10Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 10.
 * 
 * 0 : LoanIO 10 controls GPIO/LOANIO[10] output and output enable signals.
 * 
 * 1 : GPIO 10 controls GPIO/LOANI[10] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX10_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX10_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX10.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX10_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO10Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX10. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX10_s  ALT_SYSMGR_PINMUX_GPLMUX10_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX10 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX10_OFST        0x1fc

/*
 * Register : GPIO/LoanIO 11 Output/Output Enable Mux Selection Register - GPLMUX11
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO11 and
 * LoanIO11. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO11Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO11Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 11.
 * 
 * 0 : LoanIO 11 controls GPIO/LOANIO[11] output and output enable signals.
 * 
 * 1 : GPIO 11 controls GPIO/LOANI[11] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX11_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX11_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX11.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX11_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO11Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX11. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX11_s  ALT_SYSMGR_PINMUX_GPLMUX11_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX11 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX11_OFST        0x200

/*
 * Register : GPIO/LoanIO 12 Output/Output Enable Mux Selection Register - GPLMUX12
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO12 and
 * LoanIO12. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO12Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO12Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 12.
 * 
 * 0 : LoanIO 12 controls GPIO/LOANIO[12] output and output enable signals.
 * 
 * 1 : GPIO 12 controls GPIO/LOANI[12] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX12_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX12_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX12.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX12_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO12Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX12. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX12_s  ALT_SYSMGR_PINMUX_GPLMUX12_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX12 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX12_OFST        0x204

/*
 * Register : GPIO/LoanIO 13 Output/Output Enable Mux Selection Register - GPLMUX13
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO13 and
 * LoanIO13. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO13Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO13Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 13.
 * 
 * 0 : LoanIO 13 controls GPIO/LOANIO[13] output and output enable signals.
 * 
 * 1 : GPIO 13 controls GPIO/LOANI[13] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX13_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX13_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX13.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX13_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO13Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX13. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX13_s  ALT_SYSMGR_PINMUX_GPLMUX13_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX13 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX13_OFST        0x208

/*
 * Register : GPIO/LoanIO 14 Output/Output Enable Mux Selection Register - GPLMUX14
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO14 and
 * LoanIO14. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO14Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO14Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 14.
 * 
 * 0 : LoanIO 14 controls GPIO/LOANIO[14] output and output enable signals.
 * 
 * 1 : GPIO 14 controls GPIO/LOANI[14] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX14_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX14_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX14.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX14_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO14Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX14. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX14_s  ALT_SYSMGR_PINMUX_GPLMUX14_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX14 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX14_OFST        0x20c

/*
 * Register : GPIO/LoanIO 15 Output/Output Enable Mux Selection Register - GPLMUX15
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO15 and
 * LoanIO15. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO15Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO15Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 15.
 * 
 * 0 : LoanIO 15 controls GPIO/LOANIO[15] output and output enable signals.
 * 
 * 1 : GPIO 15 controls GPIO/LOANI[15] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX15_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX15_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX15.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX15_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO15Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX15. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX15_s  ALT_SYSMGR_PINMUX_GPLMUX15_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX15 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX15_OFST        0x210

/*
 * Register : GPIO/LoanIO 16 Output/Output Enable Mux Selection Register - GPLMUX16
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO16 and
 * LoanIO16. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO16Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO16Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 16.
 * 
 * 0 : LoanIO 16 controls GPIO/LOANIO[16] output and output enable signals.
 * 
 * 1 : GPIO 16 controls GPIO/LOANI[16] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX16_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX16_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX16.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX16_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO16Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX16. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX16_s  ALT_SYSMGR_PINMUX_GPLMUX16_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX16 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX16_OFST        0x214

/*
 * Register : GPIO/LoanIO 17 Output/Output Enable Mux Selection Register - GPLMUX17
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO17 and
 * LoanIO17. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO17Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO17Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 17.
 * 
 * 0 : LoanIO 17 controls GPIO/LOANIO[17] output and output enable signals.
 * 
 * 1 : GPIO 17 controls GPIO/LOANI[17] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX17_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX17_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX17.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX17_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO17Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX17. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX17_s  ALT_SYSMGR_PINMUX_GPLMUX17_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX17 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX17_OFST        0x218

/*
 * Register : GPIO/LoanIO 18 Output/Output Enable Mux Selection Register - GPLMUX18
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO18 and
 * LoanIO18. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO18Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO18Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 18.
 * 
 * 0 : LoanIO 18 controls GPIO/LOANIO[18] output and output enable signals.
 * 
 * 1 : GPIO 18 controls GPIO/LOANI[18] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX18_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX18_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX18.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX18_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO18Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX18. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX18_s  ALT_SYSMGR_PINMUX_GPLMUX18_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX18 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX18_OFST        0x21c

/*
 * Register : GPIO/LoanIO 19 Output/Output Enable Mux Selection Register - GPLMUX19
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO19 and
 * LoanIO19. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO19Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO19Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 19.
 * 
 * 0 : LoanIO 19 controls GPIO/LOANIO[19] output and output enable signals.
 * 
 * 1 : GPIO 19 controls GPIO/LOANI[19] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX19_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX19_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX19.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX19_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO19Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX19. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX19_s  ALT_SYSMGR_PINMUX_GPLMUX19_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX19 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX19_OFST        0x220

/*
 * Register : GPIO/LoanIO 20 Output/Output Enable Mux Selection Register - GPLMUX20
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO20 and
 * LoanIO20. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO20Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO20Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 20.
 * 
 * 0 : LoanIO 20 controls GPIO/LOANIO[20] output and output enable signals.
 * 
 * 1 : GPIO 20 controls GPIO/LOANI[20] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX20_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX20_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX20.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX20_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO20Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX20. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX20_s  ALT_SYSMGR_PINMUX_GPLMUX20_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX20 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX20_OFST        0x224

/*
 * Register : GPIO/LoanIO 21 Output/Output Enable Mux Selection Register - GPLMUX21
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO21 and
 * LoanIO21. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO21Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO21Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 21.
 * 
 * 0 : LoanIO 21 controls GPIO/LOANIO[21] output and output enable signals.
 * 
 * 1 : GPIO 21 controls GPIO/LOANI[21] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX21_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX21_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX21.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX21_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO21Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX21. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX21_s  ALT_SYSMGR_PINMUX_GPLMUX21_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX21 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX21_OFST        0x228

/*
 * Register : GPIO/LoanIO 22 Output/Output Enable Mux Selection Register - GPLMUX22
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO22 and
 * LoanIO22. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO22Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO22Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 22.
 * 
 * 0 : LoanIO 22 controls GPIO/LOANIO[22] output and output enable signals.
 * 
 * 1 : GPIO 22 controls GPIO/LOANI[22] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX22_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX22_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX22.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX22_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO22Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX22. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX22_s  ALT_SYSMGR_PINMUX_GPLMUX22_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX22 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX22_OFST        0x22c

/*
 * Register : GPIO/LoanIO 23 Output/Output Enable Mux Selection Register - GPLMUX23
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO23 and
 * LoanIO23. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO23Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO23Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 23.
 * 
 * 0 : LoanIO 23 controls GPIO/LOANIO[23] output and output enable signals.
 * 
 * 1 : GPIO 23 controls GPIO/LOANI[23] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX23_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX23_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX23.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX23_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO23Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX23. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX23_s  ALT_SYSMGR_PINMUX_GPLMUX23_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX23 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX23_OFST        0x230

/*
 * Register : GPIO/LoanIO 24 Output/Output Enable Mux Selection Register - GPLMUX24
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO24 and
 * LoanIO24. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO24Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO24Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 24.
 * 
 * 0 : LoanIO 24 controls GPIO/LOANIO[24] output and output enable signals.
 * 
 * 1 : GPIO 24 controls GPIO/LOANI[24] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX24_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX24_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX24.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX24_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO24Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX24. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX24_s  ALT_SYSMGR_PINMUX_GPLMUX24_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX24 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX24_OFST        0x234

/*
 * Register : GPIO/LoanIO 25 Output/Output Enable Mux Selection Register - GPLMUX25
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO25 and
 * LoanIO25. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO25Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO25Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 25.
 * 
 * 0 : LoanIO 25 controls GPIO/LOANIO[25] output and output enable signals.
 * 
 * 1 : GPIO 25 controls GPIO/LOANI[25] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX25_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX25_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX25.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX25_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO25Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX25. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX25_s  ALT_SYSMGR_PINMUX_GPLMUX25_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX25 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX25_OFST        0x238

/*
 * Register : GPIO/LoanIO 26 Output/Output Enable Mux Selection Register - GPLMUX26
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO26 and
 * LoanIO26. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO26Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO26Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 26.
 * 
 * 0 : LoanIO 26 controls GPIO/LOANIO[26] output and output enable signals.
 * 
 * 1 : GPIO 26 controls GPIO/LOANI[26] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX26_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX26_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX26.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX26_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO26Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX26. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX26_s  ALT_SYSMGR_PINMUX_GPLMUX26_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX26 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX26_OFST        0x23c

/*
 * Register : GPIO/LoanIO 27 Output/Output Enable Mux Selection Register - GPLMUX27
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO27 and
 * LoanIO27. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO27Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO27Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 27.
 * 
 * 0 : LoanIO 27 controls GPIO/LOANIO[27] output and output enable signals.
 * 
 * 1 : GPIO 27 controls GPIO/LOANI[27] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX27_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX27_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX27.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX27_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO27Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX27. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX27_s  ALT_SYSMGR_PINMUX_GPLMUX27_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX27 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX27_OFST        0x240

/*
 * Register : GPIO/LoanIO 28 Output/Output Enable Mux Selection Register - GPLMUX28
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO28 and
 * LoanIO28. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO28Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO28Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 28.
 * 
 * 0 : LoanIO 28 controls GPIO/LOANIO[28] output and output enable signals.
 * 
 * 1 : GPIO 28 controls GPIO/LOANI[28] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX28_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX28_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX28.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX28_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO28Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX28. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX28_s  ALT_SYSMGR_PINMUX_GPLMUX28_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX28 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX28_OFST        0x244

/*
 * Register : GPIO/LoanIO 29 Output/Output Enable Mux Selection Register - GPLMUX29
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO29 and
 * LoanIO29. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO29Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO29Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 29.
 * 
 * 0 : LoanIO 29 controls GPIO/LOANIO[29] output and output enable signals.
 * 
 * 1 : GPIO 29 controls GPIO/LOANI[29] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX29_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX29_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX29.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX29_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO29Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX29. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX29_s  ALT_SYSMGR_PINMUX_GPLMUX29_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX29 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX29_OFST        0x248

/*
 * Register : GPIO/LoanIO 30 Output/Output Enable Mux Selection Register - GPLMUX30
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO30 and
 * LoanIO30. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO30Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO30Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 30.
 * 
 * 0 : LoanIO 30 controls GPIO/LOANIO[30] output and output enable signals.
 * 
 * 1 : GPIO 30 controls GPIO/LOANI[30] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX30_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX30_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX30.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX30_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO30Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX30. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX30_s  ALT_SYSMGR_PINMUX_GPLMUX30_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX30 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX30_OFST        0x24c

/*
 * Register : GPIO/LoanIO 31 Output/Output Enable Mux Selection Register - GPLMUX31
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO31 and
 * LoanIO31. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO31Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO31Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 31.
 * 
 * 0 : LoanIO 31 controls GPIO/LOANIO[31] output and output enable signals.
 * 
 * 1 : GPIO 31 controls GPIO/LOANI[31] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX31_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX31_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX31.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX31_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO31Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX31. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX31_s  ALT_SYSMGR_PINMUX_GPLMUX31_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX31 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX31_OFST        0x250

/*
 * Register : GPIO/LoanIO 32 Output/Output Enable Mux Selection Register - GPLMUX32
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO32 and
 * LoanIO32. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO32Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO32Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 32.
 * 
 * 0 : LoanIO 32 controls GPIO/LOANIO[32] output and output enable signals.
 * 
 * 1 : GPIO 32 controls GPIO/LOANI[32] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX32_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX32_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX32.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX32_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO32Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX32. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX32_s  ALT_SYSMGR_PINMUX_GPLMUX32_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX32 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX32_OFST        0x254

/*
 * Register : GPIO/LoanIO 33 Output/Output Enable Mux Selection Register - GPLMUX33
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO33 and
 * LoanIO33. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO33Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO33Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 33.
 * 
 * 0 : LoanIO 33 controls GPIO/LOANIO[33] output and output enable signals.
 * 
 * 1 : GPIO 33 controls GPIO/LOANI[33] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX33_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX33_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX33.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX33_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO33Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX33. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX33_s  ALT_SYSMGR_PINMUX_GPLMUX33_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX33 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX33_OFST        0x258

/*
 * Register : GPIO/LoanIO 34 Output/Output Enable Mux Selection Register - GPLMUX34
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO34 and
 * LoanIO34. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO34Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO34Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 34.
 * 
 * 0 : LoanIO 34 controls GPIO/LOANIO[34] output and output enable signals.
 * 
 * 1 : GPIO 34 controls GPIO/LOANI[34] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX34_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX34_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX34.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX34_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO34Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX34. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX34_s  ALT_SYSMGR_PINMUX_GPLMUX34_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX34 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX34_OFST        0x25c

/*
 * Register : GPIO/LoanIO 35 Output/Output Enable Mux Selection Register - GPLMUX35
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO35 and
 * LoanIO35. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO35Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO35Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 35.
 * 
 * 0 : LoanIO 35 controls GPIO/LOANIO[35] output and output enable signals.
 * 
 * 1 : GPIO 35 controls GPIO/LOANI[35] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX35_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX35_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX35.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX35_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO35Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX35. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX35_s  ALT_SYSMGR_PINMUX_GPLMUX35_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX35 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX35_OFST        0x260

/*
 * Register : GPIO/LoanIO 36 Output/Output Enable Mux Selection Register - GPLMUX36
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO36 and
 * LoanIO36. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO36Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO36Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 36.
 * 
 * 0 : LoanIO 36 controls GPIO/LOANIO[36] output and output enable signals.
 * 
 * 1 : GPIO 36 controls GPIO/LOANI[36] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX36_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX36_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX36.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX36_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO36Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX36. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX36_s  ALT_SYSMGR_PINMUX_GPLMUX36_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX36 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX36_OFST        0x264

/*
 * Register : GPIO/LoanIO 37 Output/Output Enable Mux Selection Register - GPLMUX37
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO37 and
 * LoanIO37. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO37Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO37Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 37.
 * 
 * 0 : LoanIO 37 controls GPIO/LOANIO[37] output and output enable signals.
 * 
 * 1 : GPIO 37 controls GPIO/LOANI[37] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX37_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX37_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX37.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX37_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO37Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX37. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX37_s  ALT_SYSMGR_PINMUX_GPLMUX37_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX37 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX37_OFST        0x268

/*
 * Register : GPIO/LoanIO 38 Output/Output Enable Mux Selection Register - GPLMUX38
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO38 and
 * LoanIO38. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO38Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO38Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 38.
 * 
 * 0 : LoanIO 38 controls GPIO/LOANIO[38] output and output enable signals.
 * 
 * 1 : GPIO 38 controls GPIO/LOANI[38] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX38_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX38_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX38.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX38_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO38Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX38. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX38_s  ALT_SYSMGR_PINMUX_GPLMUX38_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX38 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX38_OFST        0x26c

/*
 * Register : GPIO/LoanIO 39 Output/Output Enable Mux Selection Register - GPLMUX39
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO39 and
 * LoanIO39. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO39Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO39Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 39.
 * 
 * 0 : LoanIO 39 controls GPIO/LOANIO[39] output and output enable signals.
 * 
 * 1 : GPIO 39 controls GPIO/LOANI[39] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX39_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX39_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX39.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX39_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO39Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX39. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX39_s  ALT_SYSMGR_PINMUX_GPLMUX39_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX39 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX39_OFST        0x270

/*
 * Register : GPIO/LoanIO 40 Output/Output Enable Mux Selection Register - GPLMUX40
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO40 and
 * LoanIO40. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO40Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO40Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 40.
 * 
 * 0 : LoanIO 40 controls GPIO/LOANIO[40] output and output enable signals.
 * 
 * 1 : GPIO 40 controls GPIO/LOANI[40] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX40_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX40_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX40.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX40_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO40Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX40. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX40_s  ALT_SYSMGR_PINMUX_GPLMUX40_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX40 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX40_OFST        0x274

/*
 * Register : GPIO/LoanIO 41 Output/Output Enable Mux Selection Register - GPLMUX41
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO41 and
 * LoanIO41. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO41Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO41Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 41.
 * 
 * 0 : LoanIO 41 controls GPIO/LOANIO[41] output and output enable signals.
 * 
 * 1 : GPIO 41 controls GPIO/LOANI[41] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_MSB        0
/* The width in bits of the ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_WIDTH      1
/* The mask used to set the ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_SET_MSK    0x00000001
/* The mask used to clear the ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field value. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_CLR_MSK    0xfffffffe
/* The reset value of the ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_RESET      0x0
/* Extracts the ALT_SYSMGR_PINMUX_GPLMUX41_SEL field value from a register. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_GET(value) (((value) & 0x00000001) >> 0)
/* Produces a ALT_SYSMGR_PINMUX_GPLMUX41_SEL register field value suitable for setting the register. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_SEL_SET(value) (((value) << 0) & 0x00000001)

#ifndef __ASSEMBLY__
/*
 * WARNING: The C register and register group struct declarations are provided for
 * convenience and illustrative purposes. They should, however, be used with
 * caution as the C language standard provides no guarantees about the alignment or
 * atomicity of device memory accesses. The recommended practice for writing
 * hardware drivers is to use the SoCAL access macros and alt_read_word() and
 * alt_write_word() functions.
 * 
 * The struct declaration for register ALT_SYSMGR_PINMUX_GPLMUX41.
 */
struct ALT_SYSMGR_PINMUX_GPLMUX41_s
{
    uint32_t  sel :  1;  /* GPIO/Loan IO41Input Mux Selection Field */
    uint32_t      : 31;  /* *UNDEFINED* */
};

/* The typedef declaration for register ALT_SYSMGR_PINMUX_GPLMUX41. */
typedef volatile struct ALT_SYSMGR_PINMUX_GPLMUX41_s  ALT_SYSMGR_PINMUX_GPLMUX41_t;
#endif  /* __ASSEMBLY__ */

/* The byte offset of the ALT_SYSMGR_PINMUX_GPLMUX41 register from the beginning of the component. */
#define ALT_SYSMGR_PINMUX_GPLMUX41_OFST        0x278

/*
 * Register : GPIO/LoanIO 42 Output/Output Enable Mux Selection Register - GPLMUX42
 * 
 * Selection between GPIO and LoanIO output and output enable for GPIO42 and
 * LoanIO42. These signals drive the Pin Mux. The Pin Mux must be configured to use
 * GPIO/LoanIO in addition to these settings
 * 
 * Only reset by a cold reset (ignores warm reset).
 * 
 * NOTE: These registers should not be modified after IO configuration.There is no
 * support for dynamically changing the Pin Mux selections.
 * 
 * Register Layout
 * 
 *  Bits   | Access | Reset | Description                            
 * :-------|:-------|:------|:----------------------------------------
 *  [0]    | RW     | 0x0   | GPIO/Loan IO42Input Mux Selection Field
 *  [31:1] | ???    | 0x0   | *UNDEFINED*                            
 * 
 */
/*
 * Field : GPIO/Loan IO42Input Mux Selection Field - sel
 * 
 * Select source for GPIO/LoanIO 42.
 * 
 * 0 : LoanIO 42 controls GPIO/LOANIO[42] output and output enable signals.
 * 
 * 1 : GPIO 42 controls GPIO/LOANI[42] output and output enable signals.
 * 
 * Field Access Macros:
 * 
 */
/* The Least Significant Bit (LSB) position of the ALT_SYSMGR_PINMUX_GPLMUX42_SEL register field. */
#define ALT_SYSMGR_PINMUX_GPLMUX42_SEL_LSB        0
/* The Most Significant Bit (MSB) position of the ALT_SYSMGR_PIN