/*
 * QEMU model of the IOU_SLCR Global system level control registers for the iou
 *
 * Copyright (c) 2020 Xilinx Inc.
 * Copyright (c) 2013 Peter Crosthwaite <peter.crosthwaite@xilinx.com>,
 *                    Edgar E. Iglesias <edgar.iglesias@xilinx.com>
 *
 * Partly autogenerated by xregqemu.py 2020-03-20.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#include "hw/qdev-properties.h"
#include "hw/fdt_generic_util.h"

#ifndef XILINX_IOU_SLCR_ERR_DEBUG
#define XILINX_IOU_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_IOU_SLCR "xilinx.zynqmp-iou-slcr"

#define XILINX_IOU_SLCR(obj) \
     OBJECT_CHECK(IOU_SLCR, (obj), TYPE_XILINX_IOU_SLCR)

REG32(MIO_PIN_0, 0x0)
    FIELD(MIO_PIN_0, L3_SEL, 5, 3)
    FIELD(MIO_PIN_0, L2_SEL, 3, 2)
    FIELD(MIO_PIN_0, L1_SEL, 2, 1)
    FIELD(MIO_PIN_0, L0_SEL, 1, 1)
REG32(MIO_PIN_1, 0x4)
    FIELD(MIO_PIN_1, L3_SEL, 5, 3)
    FIELD(MIO_PIN_1, L2_SEL, 3, 2)
    FIELD(MIO_PIN_1, L1_SEL, 2, 1)
    FIELD(MIO_PIN_1, L0_SEL, 1, 1)
REG32(MIO_PIN_2, 0x8)
    FIELD(MIO_PIN_2, L3_SEL, 5, 3)
    FIELD(MIO_PIN_2, L2_SEL, 3, 2)
    FIELD(MIO_PIN_2, L1_SEL, 2, 1)
    FIELD(MIO_PIN_2, L0_SEL, 1, 1)
REG32(MIO_PIN_3, 0xc)
    FIELD(MIO_PIN_3, L3_SEL, 5, 3)
    FIELD(MIO_PIN_3, L2_SEL, 3, 2)
    FIELD(MIO_PIN_3, L1_SEL, 2, 1)
    FIELD(MIO_PIN_3, L0_SEL, 1, 1)
REG32(MIO_PIN_4, 0x10)
    FIELD(MIO_PIN_4, L3_SEL, 5, 3)
    FIELD(MIO_PIN_4, L2_SEL, 3, 2)
    FIELD(MIO_PIN_4, L1_SEL, 2, 1)
    FIELD(MIO_PIN_4, L0_SEL, 1, 1)
REG32(MIO_PIN_5, 0x14)
    FIELD(MIO_PIN_5, L3_SEL, 5, 3)
    FIELD(MIO_PIN_5, L2_SEL, 3, 2)
    FIELD(MIO_PIN_5, L1_SEL, 2, 1)
    FIELD(MIO_PIN_5, L0_SEL, 1, 1)
REG32(MIO_PIN_6, 0x18)
    FIELD(MIO_PIN_6, L3_SEL, 5, 3)
    FIELD(MIO_PIN_6, L2_SEL, 3, 2)
    FIELD(MIO_PIN_6, L1_SEL, 2, 1)
    FIELD(MIO_PIN_6, L0_SEL, 1, 1)
REG32(MIO_PIN_7, 0x1c)
    FIELD(MIO_PIN_7, L3_SEL, 5, 3)
    FIELD(MIO_PIN_7, L2_SEL, 3, 2)
    FIELD(MIO_PIN_7, L1_SEL, 2, 1)
    FIELD(MIO_PIN_7, L0_SEL, 1, 1)
REG32(MIO_PIN_8, 0x20)
    FIELD(MIO_PIN_8, L3_SEL, 5, 3)
    FIELD(MIO_PIN_8, L2_SEL, 3, 2)
    FIELD(MIO_PIN_8, L1_SEL, 2, 1)
    FIELD(MIO_PIN_8, L0_SEL, 1, 1)
REG32(MIO_PIN_9, 0x24)
    FIELD(MIO_PIN_9, L3_SEL, 5, 3)
    FIELD(MIO_PIN_9, L2_SEL, 3, 2)
    FIELD(MIO_PIN_9, L1_SEL, 2, 1)
    FIELD(MIO_PIN_9, L0_SEL, 1, 1)
REG32(MIO_PIN_10, 0x28)
    FIELD(MIO_PIN_10, L3_SEL, 5, 3)
    FIELD(MIO_PIN_10, L2_SEL, 3, 2)
    FIELD(MIO_PIN_10, L1_SEL, 2, 1)
    FIELD(MIO_PIN_10, L0_SEL, 1, 1)
REG32(MIO_PIN_11, 0x2c)
    FIELD(MIO_PIN_11, L3_SEL, 5, 3)
    FIELD(MIO_PIN_11, L2_SEL, 3, 2)
    FIELD(MIO_PIN_11, L1_SEL, 2, 1)
    FIELD(MIO_PIN_11, L0_SEL, 1, 1)
REG32(MIO_PIN_12, 0x30)
    FIELD(MIO_PIN_12, L3_SEL, 5, 3)
    FIELD(MIO_PIN_12, L2_SEL, 3, 2)
    FIELD(MIO_PIN_12, L1_SEL, 2, 1)
    FIELD(MIO_PIN_12, L0_SEL, 1, 1)
REG32(MIO_PIN_13, 0x34)
    FIELD(MIO_PIN_13, L3_SEL, 5, 3)
    FIELD(MIO_PIN_13, L2_SEL, 3, 2)
    FIELD(MIO_PIN_13, L1_SEL, 2, 1)
    FIELD(MIO_PIN_13, L0_SEL, 1, 1)
REG32(MIO_PIN_14, 0x38)
    FIELD(MIO_PIN_14, L3_SEL, 5, 3)
    FIELD(MIO_PIN_14, L2_SEL, 3, 2)
    FIELD(MIO_PIN_14, L1_SEL, 2, 1)
    FIELD(MIO_PIN_14, L0_SEL, 1, 1)
REG32(MIO_PIN_15, 0x3c)
    FIELD(MIO_PIN_15, L3_SEL, 5, 3)
    FIELD(MIO_PIN_15, L2_SEL, 3, 2)
    FIELD(MIO_PIN_15, L1_SEL, 2, 1)
    FIELD(MIO_PIN_15, L0_SEL, 1, 1)
REG32(MIO_PIN_16, 0x40)
    FIELD(MIO_PIN_16, L3_SEL, 5, 3)
    FIELD(MIO_PIN_16, L2_SEL, 3, 2)
    FIELD(MIO_PIN_16, L1_SEL, 2, 1)
    FIELD(MIO_PIN_16, L0_SEL, 1, 1)
REG32(MIO_PIN_17, 0x44)
    FIELD(MIO_PIN_17, L3_SEL, 5, 3)
    FIELD(MIO_PIN_17, L2_SEL, 3, 2)
    FIELD(MIO_PIN_17, L1_SEL, 2, 1)
    FIELD(MIO_PIN_17, L0_SEL, 1, 1)
REG32(MIO_PIN_18, 0x48)
    FIELD(MIO_PIN_18, L3_SEL, 5, 3)
    FIELD(MIO_PIN_18, L2_SEL, 3, 2)
    FIELD(MIO_PIN_18, L1_SEL, 2, 1)
    FIELD(MIO_PIN_18, L0_SEL, 1, 1)
REG32(MIO_PIN_19, 0x4c)
    FIELD(MIO_PIN_19, L3_SEL, 5, 3)
    FIELD(MIO_PIN_19, L2_SEL, 3, 2)
    FIELD(MIO_PIN_19, L1_SEL, 2, 1)
    FIELD(MIO_PIN_19, L0_SEL, 1, 1)
REG32(MIO_PIN_20, 0x50)
    FIELD(MIO_PIN_20, L3_SEL, 5, 3)
    FIELD(MIO_PIN_20, L2_SEL, 3, 2)
    FIELD(MIO_PIN_20, L1_SEL, 2, 1)
    FIELD(MIO_PIN_20, L0_SEL, 1, 1)
REG32(MIO_PIN_21, 0x54)
    FIELD(MIO_PIN_21, L3_SEL, 5, 3)
    FIELD(MIO_PIN_21, L2_SEL, 3, 2)
    FIELD(MIO_PIN_21, L1_SEL, 2, 1)
    FIELD(MIO_PIN_21, L0_SEL, 1, 1)
REG32(MIO_PIN_22, 0x58)
    FIELD(MIO_PIN_22, L3_SEL, 5, 3)
    FIELD(MIO_PIN_22, L2_SEL, 3, 2)
    FIELD(MIO_PIN_22, L1_SEL, 2, 1)
    FIELD(MIO_PIN_22, L0_SEL, 1, 1)
REG32(MIO_PIN_23, 0x5c)
    FIELD(MIO_PIN_23, L3_SEL, 5, 3)
    FIELD(MIO_PIN_23, L2_SEL, 3, 2)
    FIELD(MIO_PIN_23, L1_SEL, 2, 1)
    FIELD(MIO_PIN_23, L0_SEL, 1, 1)
REG32(MIO_PIN_24, 0x60)
    FIELD(MIO_PIN_24, L3_SEL, 5, 3)
    FIELD(MIO_PIN_24, L2_SEL, 3, 2)
    FIELD(MIO_PIN_24, L1_SEL, 2, 1)
    FIELD(MIO_PIN_24, L0_SEL, 1, 1)
REG32(MIO_PIN_25, 0x64)
    FIELD(MIO_PIN_25, L3_SEL, 5, 3)
    FIELD(MIO_PIN_25, L2_SEL, 3, 2)
    FIELD(MIO_PIN_25, L1_SEL, 2, 1)
    FIELD(MIO_PIN_25, L0_SEL, 1, 1)
REG32(MIO_PIN_26, 0x68)
    FIELD(MIO_PIN_26, L3_SEL, 5, 3)
    FIELD(MIO_PIN_26, L2_SEL, 3, 2)
    FIELD(MIO_PIN_26, L1_SEL, 2, 1)
    FIELD(MIO_PIN_26, L0_SEL, 1, 1)
REG32(MIO_PIN_27, 0x6c)
    FIELD(MIO_PIN_27, L3_SEL, 5, 3)
    FIELD(MIO_PIN_27, L2_SEL, 3, 2)
    FIELD(MIO_PIN_27, L1_SEL, 2, 1)
    FIELD(MIO_PIN_27, L0_SEL, 1, 1)
REG32(MIO_PIN_28, 0x70)
    FIELD(MIO_PIN_28, L3_SEL, 5, 3)
    FIELD(MIO_PIN_28, L2_SEL, 3, 2)
    FIELD(MIO_PIN_28, L1_SEL, 2, 1)
    FIELD(MIO_PIN_28, L0_SEL, 1, 1)
REG32(MIO_PIN_29, 0x74)
    FIELD(MIO_PIN_29, L3_SEL, 5, 3)
    FIELD(MIO_PIN_29, L2_SEL, 3, 2)
    FIELD(MIO_PIN_29, L1_SEL, 2, 1)
    FIELD(MIO_PIN_29, L0_SEL, 1, 1)
REG32(MIO_PIN_30, 0x78)
    FIELD(MIO_PIN_30, L3_SEL, 5, 3)
    FIELD(MIO_PIN_30, L2_SEL, 3, 2)
    FIELD(MIO_PIN_30, L1_SEL, 2, 1)
    FIELD(MIO_PIN_30, L0_SEL, 1, 1)
REG32(MIO_PIN_31, 0x7c)
    FIELD(MIO_PIN_31, L3_SEL, 5, 3)
    FIELD(MIO_PIN_31, L2_SEL, 3, 2)
    FIELD(MIO_PIN_31, L1_SEL, 2, 1)
    FIELD(MIO_PIN_31, L0_SEL, 1, 1)
REG32(MIO_PIN_32, 0x80)
    FIELD(MIO_PIN_32, L3_SEL, 5, 3)
    FIELD(MIO_PIN_32, L2_SEL, 3, 2)
    FIELD(MIO_PIN_32, L1_SEL, 2, 1)
    FIELD(MIO_PIN_32, L0_SEL, 1, 1)
REG32(MIO_PIN_33, 0x84)
    FIELD(MIO_PIN_33, L3_SEL, 5, 3)
    FIELD(MIO_PIN_33, L2_SEL, 3, 2)
    FIELD(MIO_PIN_33, L1_SEL, 2, 1)
    FIELD(MIO_PIN_33, L0_SEL, 1, 1)
REG32(MIO_PIN_34, 0x88)
    FIELD(MIO_PIN_34, L3_SEL, 5, 3)
    FIELD(MIO_PIN_34, L2_SEL, 3, 2)
    FIELD(MIO_PIN_34, L1_SEL, 2, 1)
    FIELD(MIO_PIN_34, L0_SEL, 1, 1)
REG32(MIO_PIN_35, 0x8c)
    FIELD(MIO_PIN_35, L3_SEL, 5, 3)
    FIELD(MIO_PIN_35, L2_SEL, 3, 2)
    FIELD(MIO_PIN_35, L1_SEL, 2, 1)
    FIELD(MIO_PIN_35, L0_SEL, 1, 1)
REG32(MIO_PIN_36, 0x90)
    FIELD(MIO_PIN_36, L3_SEL, 5, 3)
    FIELD(MIO_PIN_36, L2_SEL, 3, 2)
    FIELD(MIO_PIN_36, L1_SEL, 2, 1)
    FIELD(MIO_PIN_36, L0_SEL, 1, 1)
REG32(MIO_PIN_37, 0x94)
    FIELD(MIO_PIN_37, L3_SEL, 5, 3)
    FIELD(MIO_PIN_37, L2_SEL, 3, 2)
    FIELD(MIO_PIN_37, L1_SEL, 2, 1)
    FIELD(MIO_PIN_37, L0_SEL, 1, 1)
REG32(MIO_PIN_38, 0x98)
    FIELD(MIO_PIN_38, L3_SEL, 5, 3)
    FIELD(MIO_PIN_38, L2_SEL, 3, 2)
    FIELD(MIO_PIN_38, L1_SEL, 2, 1)
    FIELD(MIO_PIN_38, L0_SEL, 1, 1)
REG32(MIO_PIN_39, 0x9c)
    FIELD(MIO_PIN_39, L3_SEL, 5, 3)
    FIELD(MIO_PIN_39, L2_SEL, 3, 2)
    FIELD(MIO_PIN_39, L1_SEL, 2, 1)
    FIELD(MIO_PIN_39, L0_SEL, 1, 1)
REG32(MIO_PIN_40, 0xa0)
    FIELD(MIO_PIN_40, L3_SEL, 5, 3)
    FIELD(MIO_PIN_40, L2_SEL, 3, 2)
    FIELD(MIO_PIN_40, L1_SEL, 2, 1)
    FIELD(MIO_PIN_40, L0_SEL, 1, 1)
REG32(MIO_PIN_41, 0xa4)
    FIELD(MIO_PIN_41, L3_SEL, 5, 3)
    FIELD(MIO_PIN_41, L2_SEL, 3, 2)
    FIELD(MIO_PIN_41, L1_SEL, 2, 1)
    FIELD(MIO_PIN_41, L0_SEL, 1, 1)
REG32(MIO_PIN_42, 0xa8)
    FIELD(MIO_PIN_42, L3_SEL, 5, 3)
    FIELD(MIO_PIN_42, L2_SEL, 3, 2)
    FIELD(MIO_PIN_42, L1_SEL, 2, 1)
    FIELD(MIO_PIN_42, L0_SEL, 1, 1)
REG32(MIO_PIN_43, 0xac)
    FIELD(MIO_PIN_43, L3_SEL, 5, 3)
    FIELD(MIO_PIN_43, L2_SEL, 3, 2)
    FIELD(MIO_PIN_43, L1_SEL, 2, 1)
    FIELD(MIO_PIN_43, L0_SEL, 1, 1)
REG32(MIO_PIN_44, 0xb0)
    FIELD(MIO_PIN_44, L3_SEL, 5, 3)
    FIELD(MIO_PIN_44, L2_SEL, 3, 2)
    FIELD(MIO_PIN_44, L1_SEL, 2, 1)
    FIELD(MIO_PIN_44, L0_SEL, 1, 1)
REG32(MIO_PIN_45, 0xb4)
    FIELD(MIO_PIN_45, L3_SEL, 5, 3)
    FIELD(MIO_PIN_45, L2_SEL, 3, 2)
    FIELD(MIO_PIN_45, L1_SEL, 2, 1)
    FIELD(MIO_PIN_45, L0_SEL, 1, 1)
REG32(MIO_PIN_46, 0xb8)
    FIELD(MIO_PIN_46, L3_SEL, 5, 3)
    FIELD(MIO_PIN_46, L2_SEL, 3, 2)
    FIELD(MIO_PIN_46, L1_SEL, 2, 1)
    FIELD(MIO_PIN_46, L0_SEL, 1, 1)
REG32(MIO_PIN_47, 0xbc)
    FIELD(MIO_PIN_47, L3_SEL, 5, 3)
    FIELD(MIO_PIN_47, L2_SEL, 3, 2)
    FIELD(MIO_PIN_47, L1_SEL, 2, 1)
    FIELD(MIO_PIN_47, L0_SEL, 1, 1)
REG32(MIO_PIN_48, 0xc0)
    FIELD(MIO_PIN_48, L3_SEL, 5, 3)
    FIELD(MIO_PIN_48, L2_SEL, 3, 2)
    FIELD(MIO_PIN_48, L1_SEL, 2, 1)
    FIELD(MIO_PIN_48, L0_SEL, 1, 1)
REG32(MIO_PIN_49, 0xc4)
    FIELD(MIO_PIN_49, L3_SEL, 5, 3)
    FIELD(MIO_PIN_49, L2_SEL, 3, 2)
    FIELD(MIO_PIN_49, L1_SEL, 2, 1)
    FIELD(MIO_PIN_49, L0_SEL, 1, 1)
REG32(MIO_PIN_50, 0xc8)
    FIELD(MIO_PIN_50, L3_SEL, 5, 3)
    FIELD(MIO_PIN_50, L2_SEL, 3, 2)
    FIELD(MIO_PIN_50, L1_SEL, 2, 1)
    FIELD(MIO_PIN_50, L0_SEL, 1, 1)
REG32(MIO_PIN_51, 0xcc)
    FIELD(MIO_PIN_51, L3_SEL, 5, 3)
    FIELD(MIO_PIN_51, L2_SEL, 3, 2)
    FIELD(MIO_PIN_51, L1_SEL, 2, 1)
    FIELD(MIO_PIN_51, L0_SEL, 1, 1)
REG32(MIO_PIN_52, 0xd0)
    FIELD(MIO_PIN_52, L3_SEL, 5, 3)
    FIELD(MIO_PIN_52, L2_SEL, 3, 2)
    FIELD(MIO_PIN_52, L1_SEL, 2, 1)
    FIELD(MIO_PIN_52, L0_SEL, 1, 1)
REG32(MIO_PIN_53, 0xd4)
    FIELD(MIO_PIN_53, L3_SEL, 5, 3)
    FIELD(MIO_PIN_53, L2_SEL, 3, 2)
    FIELD(MIO_PIN_53, L1_SEL, 2, 1)
    FIELD(MIO_PIN_53, L0_SEL, 1, 1)
REG32(MIO_PIN_54, 0xd8)
    FIELD(MIO_PIN_54, L3_SEL, 5, 3)
    FIELD(MIO_PIN_54, L2_SEL, 3, 2)
    FIELD(MIO_PIN_54, L1_SEL, 2, 1)
    FIELD(MIO_PIN_54, L0_SEL, 1, 1)
REG32(MIO_PIN_55, 0xdc)
    FIELD(MIO_PIN_55, L3_SEL, 5, 3)
    FIELD(MIO_PIN_55, L2_SEL, 3, 2)
    FIELD(MIO_PIN_55, L1_SEL, 2, 1)
    FIELD(MIO_PIN_55, L0_SEL, 1, 1)
REG32(MIO_PIN_56, 0xe0)
    FIELD(MIO_PIN_56, L3_SEL, 5, 3)
    FIELD(MIO_PIN_56, L2_SEL, 3, 2)
    FIELD(MIO_PIN_56, L1_SEL, 2, 1)
    FIELD(MIO_PIN_56, L0_SEL, 1, 1)
REG32(MIO_PIN_57, 0xe4)
    FIELD(MIO_PIN_57, L3_SEL, 5, 3)
    FIELD(MIO_PIN_57, L2_SEL, 3, 2)
    FIELD(MIO_PIN_57, L1_SEL, 2, 1)
    FIELD(MIO_PIN_57, L0_SEL, 1, 1)
REG32(MIO_PIN_58, 0xe8)
    FIELD(MIO_PIN_58, L3_SEL, 5, 3)
    FIELD(MIO_PIN_58, L2_SEL, 3, 2)
    FIELD(MIO_PIN_58, L1_SEL, 2, 1)
    FIELD(MIO_PIN_58, L0_SEL, 1, 1)
REG32(MIO_PIN_59, 0xec)
    FIELD(MIO_PIN_59, L3_SEL, 5, 3)
    FIELD(MIO_PIN_59, L2_SEL, 3, 2)
    FIELD(MIO_PIN_59, L1_SEL, 2, 1)
    FIELD(MIO_PIN_59, L0_SEL, 1, 1)
REG32(MIO_PIN_60, 0xf0)
    FIELD(MIO_PIN_60, L3_SEL, 5, 3)
    FIELD(MIO_PIN_60, L2_SEL, 3, 2)
    FIELD(MIO_PIN_60, L1_SEL, 2, 1)
    FIELD(MIO_PIN_60, L0_SEL, 1, 1)
REG32(MIO_PIN_61, 0xf4)
    FIELD(MIO_PIN_61, L3_SEL, 5, 3)
    FIELD(MIO_PIN_61, L2_SEL, 3, 2)
    FIELD(MIO_PIN_61, L1_SEL, 2, 1)
    FIELD(MIO_PIN_61, L0_SEL, 1, 1)
REG32(MIO_PIN_62, 0xf8)
    FIELD(MIO_PIN_62, L3_SEL, 5, 3)
    FIELD(MIO_PIN_62, L2_SEL, 3, 2)
    FIELD(MIO_PIN_62, L1_SEL, 2, 1)
    FIELD(MIO_PIN_62, L0_SEL, 1, 1)
REG32(MIO_PIN_63, 0xfc)
    FIELD(MIO_PIN_63, L3_SEL, 5, 3)
    FIELD(MIO_PIN_63, L2_SEL, 3, 2)
    FIELD(MIO_PIN_63, L1_SEL, 2, 1)
    FIELD(MIO_PIN_63, L0_SEL, 1, 1)
REG32(MIO_PIN_64, 0x100)
    FIELD(MIO_PIN_64, L3_SEL, 5, 3)
    FIELD(MIO_PIN_64, L2_SEL, 3, 2)
    FIELD(MIO_PIN_64, L1_SEL, 2, 1)
    FIELD(MIO_PIN_64, L0_SEL, 1, 1)
REG32(MIO_PIN_65, 0x104)
    FIELD(MIO_PIN_65, L3_SEL, 5, 3)
    FIELD(MIO_PIN_65, L2_SEL, 3, 2)
    FIELD(MIO_PIN_65, L1_SEL, 2, 1)
    FIELD(MIO_PIN_65, L0_SEL, 1, 1)
REG32(MIO_PIN_66, 0x108)
    FIELD(MIO_PIN_66, L3_SEL, 5, 3)
    FIELD(MIO_PIN_66, L2_SEL, 3, 2)
    FIELD(MIO_PIN_66, L1_SEL, 2, 1)
    FIELD(MIO_PIN_66, L0_SEL, 1, 1)
REG32(MIO_PIN_67, 0x10c)
    FIELD(MIO_PIN_67, L3_SEL, 5, 3)
    FIELD(MIO_PIN_67, L2_SEL, 3, 2)
    FIELD(MIO_PIN_67, L1_SEL, 2, 1)
    FIELD(MIO_PIN_67, L0_SEL, 1, 1)
REG32(MIO_PIN_68, 0x110)
    FIELD(MIO_PIN_68, L3_SEL, 5, 3)
    FIELD(MIO_PIN_68, L2_SEL, 3, 2)
    FIELD(MIO_PIN_68, L1_SEL, 2, 1)
    FIELD(MIO_PIN_68, L0_SEL, 1, 1)
REG32(MIO_PIN_69, 0x114)
    FIELD(MIO_PIN_69, L3_SEL, 5, 3)
    FIELD(MIO_PIN_69, L2_SEL, 3, 2)
    FIELD(MIO_PIN_69, L1_SEL, 2, 1)
    FIELD(MIO_PIN_69, L0_SEL, 1, 1)
REG32(MIO_PIN_70, 0x118)
    FIELD(MIO_PIN_70, L3_SEL, 5, 3)
    FIELD(MIO_PIN_70, L2_SEL, 3, 2)
    FIELD(MIO_PIN_70, L1_SEL, 2, 1)
    FIELD(MIO_PIN_70, L0_SEL, 1, 1)
REG32(MIO_PIN_71, 0x11c)
    FIELD(MIO_PIN_71, L3_SEL, 5, 3)
    FIELD(MIO_PIN_71, L2_SEL, 3, 2)
    FIELD(MIO_PIN_71, L1_SEL, 2, 1)
    FIELD(MIO_PIN_71, L0_SEL, 1, 1)
REG32(MIO_PIN_72, 0x120)
    FIELD(MIO_PIN_72, L3_SEL, 5, 3)
    FIELD(MIO_PIN_72, L2_SEL, 3, 2)
    FIELD(MIO_PIN_72, L1_SEL, 2, 1)
    FIELD(MIO_PIN_72, L0_SEL, 1, 1)
REG32(MIO_PIN_73, 0x124)
    FIELD(MIO_PIN_73, L3_SEL, 5, 3)
    FIELD(MIO_PIN_73, L2_SEL, 3, 2)
    FIELD(MIO_PIN_73, L1_SEL, 2, 1)
    FIELD(MIO_PIN_73, L0_SEL, 1, 1)
REG32(MIO_PIN_74, 0x128)
    FIELD(MIO_PIN_74, L3_SEL, 5, 3)
    FIELD(MIO_PIN_74, L2_SEL, 3, 2)
    FIELD(MIO_PIN_74, L1_SEL, 2, 1)
    FIELD(MIO_PIN_74, L0_SEL, 1, 1)
REG32(MIO_PIN_75, 0x12c)
    FIELD(MIO_PIN_75, L3_SEL, 5, 3)
    FIELD(MIO_PIN_75, L2_SEL, 3, 2)
    FIELD(MIO_PIN_75, L1_SEL, 2, 1)
    FIELD(MIO_PIN_75, L0_SEL, 1, 1)
REG32(MIO_PIN_76, 0x130)
    FIELD(MIO_PIN_76, L3_SEL, 5, 3)
    FIELD(MIO_PIN_76, L2_SEL, 3, 2)
    FIELD(MIO_PIN_76, L1_SEL, 2, 1)
    FIELD(MIO_PIN_76, L0_SEL, 1, 1)
REG32(MIO_PIN_77, 0x134)
    FIELD(MIO_PIN_77, L3_SEL, 5, 3)
    FIELD(MIO_PIN_77, L2_SEL, 3, 2)
    FIELD(MIO_PIN_77, L1_SEL, 2, 1)
    FIELD(MIO_PIN_77, L0_SEL, 1, 1)
REG32(BANK0_CTRL0, 0x138)
    FIELD(BANK0_CTRL0, DRIVE0, 0, 26)
REG32(BANK0_CTRL1, 0x13c)
    FIELD(BANK0_CTRL1, DRIVE1, 0, 26)
REG32(BANK0_CTRL3, 0x140)
    FIELD(BANK0_CTRL3, SCHMITT_CMOS_N, 0, 26)
REG32(BANK0_CTRL4, 0x144)
    FIELD(BANK0_CTRL4, PULL_HIGH_LOW_N, 0, 26)
REG32(BANK0_CTRL5, 0x148)
    FIELD(BANK0_CTRL5, PULL_ENABLE, 0, 26)
REG32(BANK0_CTRL6, 0x14c)
    FIELD(BANK0_CTRL6, SLOW_FAST_SLEW_N, 0, 26)
REG32(BANK0_STATUS, 0x150)
    FIELD(BANK0_STATUS, VOLTAGE_MODE, 0, 1)
REG32(BANK1_CTRL0, 0x154)
    FIELD(BANK1_CTRL0, DRIVE0, 0, 26)
REG32(BANK1_CTRL1, 0x158)
    FIELD(BANK1_CTRL1, DRIVE1, 0, 26)
REG32(BANK1_CTRL3, 0x15c)
    FIELD(BANK1_CTRL3, SCHMITT_CMOS_N, 0, 26)
REG32(BANK1_CTRL4, 0x160)
    FIELD(BANK1_CTRL4, PULL_HIGH_LOW_N, 0, 26)
REG32(BANK1_CTRL5, 0x164)
    FIELD(BANK1_CTRL5, PULL_ENABLE_13_TO_0, 12, 14)
    FIELD(BANK1_CTRL5, PULL_ENABLE_25_TO_14, 0, 12)
REG32(BANK1_CTRL6, 0x168)
    FIELD(BANK1_CTRL6, SLOW_FAST_SLEW_N, 0, 26)
REG32(BANK1_STATUS, 0x16c)
    FIELD(BANK1_STATUS, VOLTAGE_MODE, 0, 1)
REG32(BANK2_CTRL0, 0x170)
    FIELD(BANK2_CTRL0, DRIVE0, 0, 26)
REG32(BANK2_CTRL1, 0x174)
    FIELD(BANK2_CTRL1, DRIVE1, 0, 26)
REG32(BANK2_CTRL3, 0x178)
    FIELD(BANK2_CTRL3, SCHMITT_CMOS_N, 0, 26)
REG32(BANK2_CTRL4, 0x17c)
    FIELD(BANK2_CTRL4, PULL_HIGH_LOW_N, 0, 26)
REG32(BANK2_CTRL5, 0x180)
    FIELD(BANK2_CTRL5, PULL_ENABLE, 0, 26)
REG32(BANK2_CTRL6, 0x184)
    FIELD(BANK2_CTRL6, SLOW_FAST_SLEW_N, 0, 26)
REG32(BANK2_STATUS, 0x188)
    FIELD(BANK2_STATUS, VOLTAGE_MODE, 0, 1)
REG32(MIO_LOOPBACK, 0x200)
    FIELD(MIO_LOOPBACK, I2C0_LOOP_I2C1, 3, 1)
    FIELD(MIO_LOOPBACK, CAN0_LOOP_CAN1, 2, 1)
    FIELD(MIO_LOOPBACK, UA0_LOOP_UA1, 1, 1)
    FIELD(MIO_LOOPBACK, SPI0_LOOP_SPI1, 0, 1)
REG32(MIO_MST_TRI0, 0x204)
    FIELD(MIO_MST_TRI0, PIN_31_TRI, 31, 1)
    FIELD(MIO_MST_TRI0, PIN_30_TRI, 30, 1)
    FIELD(MIO_MST_TRI0, PIN_29_TRI, 29, 1)
    FIELD(MIO_MST_TRI0, PIN_28_TRI, 28, 1)
    FIELD(MIO_MST_TRI0, PIN_27_TRI, 27, 1)
    FIELD(MIO_MST_TRI0, PIN_26_TRI, 26, 1)
    FIELD(MIO_MST_TRI0, PIN_25_TRI, 25, 1)
    FIELD(MIO_MST_TRI0, PIN_24_TRI, 24, 1)
    FIELD(MIO_MST_TRI0, PIN_23_TRI, 23, 1)
    FIELD(MIO_MST_TRI0, PIN_22_TRI, 22, 1)
    FIELD(MIO_MST_TRI0, PIN_21_TRI, 21, 1)
    FIELD(MIO_MST_TRI0, PIN_20_TRI, 20, 1)
    FIELD(MIO_MST_TRI0, PIN_19_TRI, 19, 1)
    FIELD(MIO_MST_TRI0, PIN_18_TRI, 18, 1)
    FIELD(MIO_MST_TRI0, PIN_17_TRI, 17, 1)
    FIELD(MIO_MST_TRI0, PIN_16_TRI, 16, 1)
    FIELD(MIO_MST_TRI0, PIN_15_TRI, 15, 1)
    FIELD(MIO_MST_TRI0, PIN_14_TRI, 14, 1)
    FIELD(MIO_MST_TRI0, PIN_13_TRI, 13, 1)
    FIELD(MIO_MST_TRI0, PIN_12_TRI, 12, 1)
    FIELD(MIO_MST_TRI0, PIN_11_TRI, 11, 1)
    FIELD(MIO_MST_TRI0, PIN_10_TRI, 10, 1)
    FIELD(MIO_MST_TRI0, PIN_09_TRI, 9, 1)
    FIELD(MIO_MST_TRI0, PIN_08_TRI, 8, 1)
    FIELD(MIO_MST_TRI0, PIN_07_TRI, 7, 1)
    FIELD(MIO_MST_TRI0, PIN_06_TRI, 6, 1)
    FIELD(MIO_MST_TRI0, PIN_05_TRI, 5, 1)
    FIELD(MIO_MST_TRI0, PIN_04_TRI, 4, 1)
    FIELD(MIO_MST_TRI0, PIN_03_TRI, 3, 1)
    FIELD(MIO_MST_TRI0, PIN_02_TRI, 2, 1)
    FIELD(MIO_MST_TRI0, PIN_01_TRI, 1, 1)
    FIELD(MIO_MST_TRI0, PIN_00_TRI, 0, 1)
REG32(MIO_MST_TRI1, 0x208)
    FIELD(MIO_MST_TRI1, PIN_63_TRI, 31, 1)
    FIELD(MIO_MST_TRI1, PIN_62_TRI, 30, 1)
    FIELD(MIO_MST_TRI1, PIN_61_TRI, 29, 1)
    FIELD(MIO_MST_TRI1, PIN_60_TRI, 28, 1)
    FIELD(MIO_MST_TRI1, PIN_59_TRI, 27, 1)
    FIELD(MIO_MST_TRI1, PIN_58_TRI, 26, 1)
    FIELD(MIO_MST_TRI1, PIN_57_TRI, 25, 1)
    FIELD(MIO_MST_TRI1, PIN_56_TRI, 24, 1)
    FIELD(MIO_MST_TRI1, PIN_55_TRI, 23, 1)
    FIELD(MIO_MST_TRI1, PIN_54_TRI, 22, 1)
    FIELD(MIO_MST_TRI1, PIN_53_TRI, 21, 1)
    FIELD(MIO_MST_TRI1, PIN_52_TRI, 20, 1)
    FIELD(MIO_MST_TRI1, PIN_51_TRI, 19, 1)
    FIELD(MIO_MST_TRI1, PIN_50_TRI, 18, 1)
    FIELD(MIO_MST_TRI1, PIN_49_TRI, 17, 1)
    FIELD(MIO_MST_TRI1, PIN_48_TRI, 16, 1)
    FIELD(MIO_MST_TRI1, PIN_47_TRI, 15, 1)
    FIELD(MIO_MST_TRI1, PIN_46_TRI, 14, 1)
    FIELD(MIO_MST_TRI1, PIN_45_TRI, 13, 1)
    FIELD(MIO_MST_TRI1, PIN_44_TRI, 12, 1)
    FIELD(MIO_MST_TRI1, PIN_43_TRI, 11, 1)
    FIELD(MIO_MST_TRI1, PIN_42_TRI, 10, 1)
    FIELD(MIO_MST_TRI1, PIN_41_TRI, 9, 1)
    FIELD(MIO_MST_TRI1, PIN_40_TRI, 8, 1)
    FIELD(MIO_MST_TRI1, PIN_39_TRI, 7, 1)
    FIELD(MIO_MST_TRI1, PIN_38_TRI, 6, 1)
    FIELD(MIO_MST_TRI1, PIN_37_TRI, 5, 1)
    FIELD(MIO_MST_TRI1, PIN_36_TRI, 4, 1)
    FIELD(MIO_MST_TRI1, PIN_35_TRI, 3, 1)
    FIELD(MIO_MST_TRI1, PIN_34_TRI, 2, 1)
    FIELD(MIO_MST_TRI1, PIN_33_TRI, 1, 1)
    FIELD(MIO_MST_TRI1, PIN_32_TRI, 0, 1)
REG32(MIO_MST_TRI2, 0x20c)
    FIELD(MIO_MST_TRI2, PIN_77_TRI, 13, 1)
    FIELD(MIO_MST_TRI2, PIN_76_TRI, 12, 1)
    FIELD(MIO_MST_TRI2, PIN_75_TRI, 11, 1)
    FIELD(MIO_MST_TRI2, PIN_74_TRI, 10, 1)
    FIELD(MIO_MST_TRI2, PIN_73_TRI, 9, 1)
    FIELD(MIO_MST_TRI2, PIN_72_TRI, 8, 1)
    FIELD(MIO_MST_TRI2, PIN_71_TRI, 7, 1)
    FIELD(MIO_MST_TRI2, PIN_70_TRI, 6, 1)
    FIELD(MIO_MST_TRI2, PIN_69_TRI, 5, 1)
    FIELD(MIO_MST_TRI2, PIN_68_TRI, 4, 1)
    FIELD(MIO_MST_TRI2, PIN_67_TRI, 3, 1)
    FIELD(MIO_MST_TRI2, PIN_66_TRI, 2, 1)
    FIELD(MIO_MST_TRI2, PIN_65_TRI, 1, 1)
    FIELD(MIO_MST_TRI2, PIN_64_TRI, 0, 1)
REG32(WDT_CLK_SEL, 0x300)
    FIELD(WDT_CLK_SEL, SELECT, 0, 1)
REG32(CAN_MIO_CTRL, 0x304)
    FIELD(CAN_MIO_CTRL, CAN1_RXIN_REG, 23, 1)
    FIELD(CAN_MIO_CTRL, CAN1_REF_SEL, 22, 1)
    FIELD(CAN_MIO_CTRL, CAN1_MUX, 15, 7)
    FIELD(CAN_MIO_CTRL, CAN0_RXIN_REG, 8, 1)
    FIELD(CAN_MIO_CTRL, CAN0_REF_SEL, 7, 1)
    FIELD(CAN_MIO_CTRL, CAN0_MUX, 0, 7)
REG32(GEM_CLK_CTRL, 0x308)
    FIELD(GEM_CLK_CTRL, TSU_CLK_LB_SEL, 22, 1)
    FIELD(GEM_CLK_CTRL, TSU_CLK_SEL, 20, 2)
    FIELD(GEM_CLK_CTRL, GEM3_FIFO_CLK_SEL, 18, 1)
    FIELD(GEM_CLK_CTRL, GEM3_SGMII_MODE, 17, 1)
    FIELD(GEM_CLK_CTRL, GEM3_REF_SRC_SEL, 16, 1)
    FIELD(GEM_CLK_CTRL, GEM3_RX_SRC_SEL, 15, 1)
    FIELD(GEM_CLK_CTRL, GEM2_FIFO_CLK_SEL, 13, 1)
    FIELD(GEM_CLK_CTRL, GEM2_SGMII_MODE, 12, 1)
    FIELD(GEM_CLK_CTRL, GEM2_REF_SRC_SEL, 11, 1)
    FIELD(GEM_CLK_CTRL, GEM2_RX_SRC_SEL, 10, 1)
    FIELD(GEM_CLK_CTRL, GEM1_FIFO_CLK_SEL, 8, 1)
    FIELD(GEM_CLK_CTRL, GEM1_SGMII_MODE, 7, 1)
    FIELD(GEM_CLK_CTRL, GEM1_REF_SRC_SEL, 6, 1)
    FIELD(GEM_CLK_CTRL, GEM1_RX_SRC_SEL, 5, 1)
    FIELD(GEM_CLK_CTRL, GEM0_FIFO_CLK_SEL, 3, 1)
    FIELD(GEM_CLK_CTRL, GEM0_SGMII_MODE, 2, 1)
    FIELD(GEM_CLK_CTRL, GEM0_REF_SRC_SEL, 1, 1)
    FIELD(GEM_CLK_CTRL, GEM0_RX_SRC_SEL, 0, 1)
REG32(SDIO_CLK_CTRL, 0x30c)
    FIELD(SDIO_CLK_CTRL, SDIO1_FBCLK_SEL, 18, 1)
    FIELD(SDIO_CLK_CTRL, SDIO1_RX_SRC_SEL, 17, 1)
    FIELD(SDIO_CLK_CTRL, SDIO0_FBCLK_SEL, 2, 1)
    FIELD(SDIO_CLK_CTRL, SDIO0_RX_SRC_SEL, 0, 2)
REG32(CTRL_REG_SD, 0x310)
    FIELD(CTRL_REG_SD, SD1_EMMC_SEL, 15, 1)
    FIELD(CTRL_REG_SD, SD0_EMMC_SEL, 0, 1)
REG32(SD_ITAPDLY, 0x314)
    FIELD(SD_ITAPDLY, SD1_ITAPCHGWIN, 25, 1)
    FIELD(SD_ITAPDLY, SD1_ITAPDLYENA, 24, 1)
    FIELD(SD_ITAPDLY, SD1_ITAPDLYSEL, 16, 8)
    FIELD(SD_ITAPDLY, SD0_ITAPCHGWIN, 9, 1)
    FIELD(SD_ITAPDLY, SD0_ITAPDLYENA, 8, 1)
    FIELD(SD_ITAPDLY, SD0_ITAPDLYSEL, 0, 8)
REG32(SD_OTAPDLYSEL, 0x318)
    FIELD(SD_OTAPDLYSEL, SD1_OTAPDLYENA, 22, 1)
    FIELD(SD_OTAPDLYSEL, SD1_OTAPDLYSEL, 16, 6)
    FIELD(SD_OTAPDLYSEL, SD0_OTAPDLYENA, 6, 1)
    FIELD(SD_OTAPDLYSEL, SD0_OTAPDLYSEL, 0, 6)
REG32(SD_CONFIG_REG1, 0x31c)
    FIELD(SD_CONFIG_REG1, SD1_BASECLK, 23, 8)
    FIELD(SD_CONFIG_REG1, SD1_TUNIGCOUNT, 17, 6)
    FIELD(SD_CONFIG_REG1, SD1_ASYNCWKPENA, 16, 1)
    FIELD(SD_CONFIG_REG1, SD0_BASECLK, 7, 8)
    FIELD(SD_CONFIG_REG1, SD0_TUNIGCOUNT, 1, 6)
    FIELD(SD_CONFIG_REG1, SD0_ASYNCWKPENA, 0, 1)
REG32(SD_CONFIG_REG2, 0x320)
    FIELD(SD_CONFIG_REG2, SD1_SLOTTYPE, 28, 2)
    FIELD(SD_CONFIG_REG2, SD1_ASYCINTR, 27, 1)
    FIELD(SD_CONFIG_REG2, SD1_64BIT, 26, 1)
    FIELD(SD_CONFIG_REG2, SD1_1P8V, 25, 1)
    FIELD(SD_CONFIG_REG2, SD1_3P0V, 24, 1)
    FIELD(SD_CONFIG_REG2, SD1_3P3V, 23, 1)
    FIELD(SD_CONFIG_REG2, SD1_SUSPRES, 22, 1)
    FIELD(SD_CONFIG_REG2, SD1_SDMA, 21, 1)
    FIELD(SD_CONFIG_REG2, SD1_HIGHSPEED, 20, 1)
    FIELD(SD_CONFIG_REG2, SD1_ADMA2, 19, 1)
    FIELD(SD_CONFIG_REG2, SD1_8BIT, 18, 1)
    FIELD(SD_CONFIG_REG2, SD1_MAXBLK, 16, 2)
    FIELD(SD_CONFIG_REG2, SD0_SLOTTYPE, 12, 2)
    FIELD(SD_CONFIG_REG2, SD0_ASYCINTR, 11, 1)
    FIELD(SD_CONFIG_REG2, SD0_64BIT, 10, 1)
    FIELD(SD_CONFIG_REG2, SD0_1P8V, 9, 1)
    FIELD(SD_CONFIG_REG2, SD0_3P0V, 8, 1)
    FIELD(SD_CONFIG_REG2, SD0_3P3V, 7, 1)
    FIELD(SD_CONFIG_REG2, SD0_SUSPRES, 6, 1)
    FIELD(SD_CONFIG_REG2, SD0_SDMA, 5, 1)
    FIELD(SD_CONFIG_REG2, SD0_HIGHSPEED, 4, 1)
    FIELD(SD_CONFIG_REG2, SD0_ADMA2, 3, 1)
    FIELD(SD_CONFIG_REG2, SD0_8BIT, 2, 1)
    FIELD(SD_CONFIG_REG2, SD0_MAXBLK, 0, 2)
REG32(SD_CONFIG_REG3, 0x324)
    FIELD(SD_CONFIG_REG3, SD1_TUNINGSDR50, 26, 1)
    FIELD(SD_CONFIG_REG3, SD1_RETUNETMR, 22, 4)
    FIELD(SD_CONFIG_REG3, SD1_DDRIVER, 21, 1)
    FIELD(SD_CONFIG_REG3, SD1_CDRIVER, 20, 1)
    FIELD(SD_CONFIG_REG3, SD1_ADRIVER, 19, 1)
    FIELD(SD_CONFIG_REG3, SD1_DDR50, 18, 1)
    FIELD(SD_CONFIG_REG3, SD1_SDR104, 17, 1)
    FIELD(SD_CONFIG_REG3, SD1_SDR50, 16, 1)
    FIELD(SD_CONFIG_REG3, SD0_TUNINGSDR50, 10, 1)
    FIELD(SD_CONFIG_REG3, SD0_RETUNETMR, 6, 4)
    FIELD(SD_CONFIG_REG3, SD0_DDRIVER, 5, 1)
    FIELD(SD_CONFIG_REG3, SD0_CDRIVER, 4, 1)
    FIELD(SD_CONFIG_REG3, SD0_ADRIVER, 3, 1)
    FIELD(SD_CONFIG_REG3, SD0_DDR50, 2, 1)
    FIELD(SD_CONFIG_REG3, SD0_SDR104, 1, 1)
    FIELD(SD_CONFIG_REG3, SD0_SDR50, 0, 1)
REG32(SD_INITPRESET, 0x328)
    FIELD(SD_INITPRESET, SD1_INITPRESET, 16, 13)
    FIELD(SD_INITPRESET, SD0_INITPRESET, 0, 13)
REG32(SD_DSPPRESET, 0x32c)
    FIELD(SD_DSPPRESET, SD1_DSPPRESET, 16, 13)
    FIELD(SD_DSPPRESET, SD0_DSPPRESET, 0, 13)
REG32(SD_HSPDPRESET, 0x330)
    FIELD(SD_HSPDPRESET, SD1_HSPDPRESET, 16, 13)
    FIELD(SD_HSPDPRESET, SD0_HSPDPRESET, 0, 13)
REG32(SD_SDR12PRESET, 0x334)
    FIELD(SD_SDR12PRESET, SD1_SDR12PRESET, 16, 13)
    FIELD(SD_SDR12PRESET, SD0_SDR12PRESET, 0, 13)
REG32(SD_SDR25PRESET, 0x338)
    FIELD(SD_SDR25PRESET, SD1_SDR25PRESET, 16, 13)
    FIELD(SD_SDR25PRESET, SD0_SDR25PRESET, 0, 13)
REG32(SD_SDR50PRSET, 0x33c)
    FIELD(SD_SDR50PRSET, SD1_SDR50PRESET, 16, 13)
    FIELD(SD_SDR50PRSET, SD0_SDR50PRESET, 0, 13)
REG32(SD_SDR104PRST, 0x340)
    FIELD(SD_SDR104PRST, SD1_SDR104PRESET, 16, 13)
    FIELD(SD_SDR104PRST, SD0_SDR104PRESET, 0, 13)
REG32(SD_DDR50PRESET, 0x344)
    FIELD(SD_DDR50PRESET, SD1_DDR50PRESET, 16, 13)
    FIELD(SD_DDR50PRESET, SD0_DDR50PRESET, 0, 13)
REG32(SD_MAXCUR1P8, 0x34c)
    FIELD(SD_MAXCUR1P8, SD1_MAXCUR1P8, 16, 8)
    FIELD(SD_MAXCUR1P8, SD0_MAXCUR1P8, 0, 8)
REG32(SD_MAXCUR3P0, 0x350)
    FIELD(SD_MAXCUR3P0, SD1_MAXCUR3P0, 16, 8)
    FIELD(SD_MAXCUR3P0, SD0_MAXCUR3P0, 0, 8)
REG32(SD_MAXCUR3P3, 0x354)
    FIELD(SD_MAXCUR3P3, SD1_MAXCUR3P3, 16, 8)
    FIELD(SD_MAXCUR3P3, SD0_MAXCUR3P3, 0, 8)
REG32(SD_DLL_CTRL, 0x358)
    FIELD(SD_DLL_CTRL, SD1_DLL_RST, 18, 1)
    FIELD(SD_DLL_CTRL, SD1_DLL_TESTMODE, 17, 1)
    FIELD(SD_DLL_CTRL, SD1_DLL_LOCK, 16, 1)
    FIELD(SD_DLL_CTRL, SD0_DLL_RST, 2, 1)
    FIELD(SD_DLL_CTRL, SD0_DLL_TESTMODE, 1, 1)
    FIELD(SD_DLL_CTRL, SD0_DLL_LOCK, 0, 1)
REG32(SD_CDN_CTRL, 0x35c)
    FIELD(SD_CDN_CTRL, SD1_CDN_CTRL, 16, 1)
    FIELD(SD_CDN_CTRL, SD0_CDN_CTRL, 0, 1)
REG32(GEM_CTRL, 0x360)
    FIELD(GEM_CTRL, GEM3_SGMII_SD, 6, 2)
    FIELD(GEM_CTRL, GEM2_SGMII_SD, 4, 2)
    FIELD(GEM_CTRL, GEM1_SGMII_SD, 2, 2)
    FIELD(GEM_CTRL, GEM0_SGMII_SD, 0, 2)
REG32(IOU_TTC_APB_CLK, 0x380)
    FIELD(IOU_TTC_APB_CLK, TTC3_SEL, 6, 2)
    FIELD(IOU_TTC_APB_CLK, TTC2_SEL, 4, 2)
    FIELD(IOU_TTC_APB_CLK, TTC1_SEL, 2, 2)
    FIELD(IOU_TTC_APB_CLK, TTC0_SEL, 0, 2)
REG32(IOU_TAPDLY_BYPASS, 0x390)
    FIELD(IOU_TAPDLY_BYPASS, LQSPI_RX, 2, 1)
    FIELD(IOU_TAPDLY_BYPASS, NAND_DQS_OUT, 1, 1)
    FIELD(IOU_TAPDLY_BYPASS, NAND_DQS_IN, 0, 1)
REG32(IOU_COHERENT_CTRL, 0x400)
    FIELD(IOU_COHERENT_CTRL, QSPI_AXI_COH, 28, 4)
    FIELD(IOU_COHERENT_CTRL, NAND_AXI_COH, 24, 4)
    FIELD(IOU_COHERENT_CTRL, SD1_AXI_COH, 20, 4)
    FIELD(IOU_COHERENT_CTRL, SD0_AXI_COH, 16, 4)
    FIELD(IOU_COHERENT_CTRL, GEM3_AXI_COH, 12, 4)
    FIELD(IOU_COHERENT_CTRL, GEM2_AXI_COH, 8, 4)
    FIELD(IOU_COHERENT_CTRL, GEM1_AXI_COH, 4, 4)
    FIELD(IOU_COHERENT_CTRL, GEM0_AXI_COH, 0, 4)
REG32(VIDEO_PSS_CLK_SEL, 0x404)
    FIELD(VIDEO_PSS_CLK_SEL, PSS_ALT_CLK, 1, 1)
    FIELD(VIDEO_PSS_CLK_SEL, VIDEO_CLK, 0, 1)
REG32(IOU_INTERCONNECT_ROUTE, 0x408)
    FIELD(IOU_INTERCONNECT_ROUTE, NAND, 7, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, QSPI, 6, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, SD1, 5, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, SD0, 4, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, GEM3, 3, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, GEM2, 2, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, GEM1, 1, 1)
    FIELD(IOU_INTERCONNECT_ROUTE, GEM0, 0, 1)
REG32(IOU_RAM_GEM0, 0x500)
    FIELD(IOU_RAM_GEM0, EMASA1, 14, 1)
    FIELD(IOU_RAM_GEM0, EMAB1, 11, 3)
    FIELD(IOU_RAM_GEM0, EMAA1, 8, 3)
    FIELD(IOU_RAM_GEM0, EMASA0, 6, 1)
    FIELD(IOU_RAM_GEM0, EMAB0, 3, 3)
    FIELD(IOU_RAM_GEM0, EMAA0, 0, 3)
REG32(IOU_RAM_GEM1, 0x504)
    FIELD(IOU_RAM_GEM1, EMASA1, 14, 1)
    FIELD(IOU_RAM_GEM1, EMAB1, 11, 3)
    FIELD(IOU_RAM_GEM1, EMAA1, 8, 3)
    FIELD(IOU_RAM_GEM1, EMASA0, 6, 1)
    FIELD(IOU_RAM_GEM1, EMAB0, 3, 3)
    FIELD(IOU_RAM_GEM1, EMAA0, 0, 3)
REG32(IOU_RAM_GEM2, 0x508)
    FIELD(IOU_RAM_GEM2, EMASA1, 14, 1)
    FIELD(IOU_RAM_GEM2, EMAB1, 11, 3)
    FIELD(IOU_RAM_GEM2, EMAA1, 8, 3)
    FIELD(IOU_RAM_GEM2, EMASA0, 6, 1)
    FIELD(IOU_RAM_GEM2, EMAB0, 3, 3)
    FIELD(IOU_RAM_GEM2, EMAA0, 0, 3)
REG32(IOU_RAM_GEM3, 0x50c)
    FIELD(IOU_RAM_GEM3, EMASA1, 14, 1)
    FIELD(IOU_RAM_GEM3, EMAB1, 11, 3)
    FIELD(IOU_RAM_GEM3, EMAA1, 8, 3)
    FIELD(IOU_RAM_GEM3, EMASA0, 6, 1)
    FIELD(IOU_RAM_GEM3, EMAB0, 3, 3)
    FIELD(IOU_RAM_GEM3, EMAA0, 0, 3)
REG32(IOU_RAM_SD0, 0x510)
    FIELD(IOU_RAM_SD0, EMASA0, 6, 1)
    FIELD(IOU_RAM_SD0, EMAB0, 3, 3)
    FIELD(IOU_RAM_SD0, EMAA0, 0, 3)
REG32(IOU_RAM_SD1, 0x514)
    FIELD(IOU_RAM_SD1, EMASA0, 6, 1)
    FIELD(IOU_RAM_SD1, EMAB0, 3, 3)
    FIELD(IOU_RAM_SD1, EMAA0, 0, 3)
REG32(IOU_RAM_CAN0, 0x518)
    FIELD(IOU_RAM_CAN0, EMASA2, 22, 1)
    FIELD(IOU_RAM_CAN0, EMAB2, 19, 3)
    FIELD(IOU_RAM_CAN0, EMAA2, 16, 3)
    FIELD(IOU_RAM_CAN0, EMASA1, 14, 1)
    FIELD(IOU_RAM_CAN0, EMAB1, 11, 3)
    FIELD(IOU_RAM_CAN0, EMAA1, 8, 3)
    FIELD(IOU_RAM_CAN0, EMASA0, 6, 1)
    FIELD(IOU_RAM_CAN0, EMAB0, 3, 3)
    FIELD(IOU_RAM_CAN0, EMAA0, 0, 3)
REG32(IOU_RAM_CAN1, 0x51c)
    FIELD(IOU_RAM_CAN1, EMASA2, 22, 1)
    FIELD(IOU_RAM_CAN1, EMAB2, 19, 3)
    FIELD(IOU_RAM_CAN1, EMAA2, 16, 3)
    FIELD(IOU_RAM_CAN1, EMASA1, 14, 1)
    FIELD(IOU_RAM_CAN1, EMAB1, 11, 3)
    FIELD(IOU_RAM_CAN1, EMAA1, 8, 3)
    FIELD(IOU_RAM_CAN1, EMASA0, 6, 1)
    FIELD(IOU_RAM_CAN1, EMAB0, 3, 3)
    FIELD(IOU_RAM_CAN1, EMAA0, 0, 3)
REG32(IOU_RAM_LQSPI, 0x520)
    FIELD(IOU_RAM_LQSPI, EMASA1, 13, 1)
    FIELD(IOU_RAM_LQSPI, EMAB1, 10, 3)
    FIELD(IOU_RAM_LQSPI, EMAA1, 7, 3)
    FIELD(IOU_RAM_LQSPI, EMASA0, 6, 1)
    FIELD(IOU_RAM_LQSPI, EMAB0, 3, 3)
    FIELD(IOU_RAM_LQSPI, EMAA0, 0, 3)
REG32(IOU_RAM_NAND, 0x524)
    FIELD(IOU_RAM_NAND, EMASA0, 6, 1)
    FIELD(IOU_RAM_NAND, EMAB0, 3, 3)
    FIELD(IOU_RAM_NAND, EMAA0, 0, 3)
REG32(CTRL, 0x600)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x700)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0x704)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x708)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x70c)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x710)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)

#define IOU_SLCR_R_MAX (R_ITR + 1)

typedef struct IOU_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr;

    qemu_irq sd_slottype[2];

    struct {
        bool mio_bank0v;
        bool mio_bank1v;
        bool mio_bank2v;
    } cfg;

    uint32_t regs[IOU_SLCR_R_MAX];
    RegisterInfo regs_info[IOU_SLCR_R_MAX];
} IOU_SLCR;

#define PROPAGATE_GPIO(s, reg, f, irq) {              \
    int val = ARRAY_FIELD_EX32((s)->regs, reg, f);    \
    qemu_set_irq(irq, val);                           \
}

static void imr_update_irq(IOU_SLCR *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR] |= val;
    imr_update_irq(s);
    return 0;
}

static void sd_slottype_postw(RegisterInfo *reg, uint64_t val64)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(reg->opaque);

    PROPAGATE_GPIO(s, CTRL_REG_SD, SD0_EMMC_SEL, s->sd_slottype[0]);
    PROPAGATE_GPIO(s, CTRL_REG_SD, SD1_EMMC_SEL, s->sd_slottype[1]);
}

static const RegisterAccessInfo iou_slcr_regs_info[] = {
    {   .name = "MIO_PIN_0",  .addr = A_MIO_PIN_0,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_1",  .addr = A_MIO_PIN_1,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_2",  .addr = A_MIO_PIN_2,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_3",  .addr = A_MIO_PIN_3,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_4",  .addr = A_MIO_PIN_4,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_5",  .addr = A_MIO_PIN_5,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_6",  .addr = A_MIO_PIN_6,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_7",  .addr = A_MIO_PIN_7,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_8",  .addr = A_MIO_PIN_8,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_9",  .addr = A_MIO_PIN_9,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_10",  .addr = A_MIO_PIN_10,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_11",  .addr = A_MIO_PIN_11,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_12",  .addr = A_MIO_PIN_12,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_13",  .addr = A_MIO_PIN_13,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_14",  .addr = A_MIO_PIN_14,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_15",  .addr = A_MIO_PIN_15,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_16",  .addr = A_MIO_PIN_16,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_17",  .addr = A_MIO_PIN_17,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_18",  .addr = A_MIO_PIN_18,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_19",  .addr = A_MIO_PIN_19,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_20",  .addr = A_MIO_PIN_20,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_21",  .addr = A_MIO_PIN_21,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_22",  .addr = A_MIO_PIN_22,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_23",  .addr = A_MIO_PIN_23,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_24",  .addr = A_MIO_PIN_24,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_25",  .addr = A_MIO_PIN_25,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_26",  .addr = A_MIO_PIN_26,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_27",  .addr = A_MIO_PIN_27,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_28",  .addr = A_MIO_PIN_28,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_29",  .addr = A_MIO_PIN_29,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_30",  .addr = A_MIO_PIN_30,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_31",  .addr = A_MIO_PIN_31,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_32",  .addr = A_MIO_PIN_32,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_33",  .addr = A_MIO_PIN_33,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_34",  .addr = A_MIO_PIN_34,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_35",  .addr = A_MIO_PIN_35,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_36",  .addr = A_MIO_PIN_36,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_37",  .addr = A_MIO_PIN_37,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_38",  .addr = A_MIO_PIN_38,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_39",  .addr = A_MIO_PIN_39,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_40",  .addr = A_MIO_PIN_40,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_41",  .addr = A_MIO_PIN_41,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_42",  .addr = A_MIO_PIN_42,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_43",  .addr = A_MIO_PIN_43,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_44",  .addr = A_MIO_PIN_44,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_45",  .addr = A_MIO_PIN_45,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_46",  .addr = A_MIO_PIN_46,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_47",  .addr = A_MIO_PIN_47,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_48",  .addr = A_MIO_PIN_48,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_49",  .addr = A_MIO_PIN_49,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_50",  .addr = A_MIO_PIN_50,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_51",  .addr = A_MIO_PIN_51,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_52",  .addr = A_MIO_PIN_52,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_53",  .addr = A_MIO_PIN_53,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_54",  .addr = A_MIO_PIN_54,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_55",  .addr = A_MIO_PIN_55,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_56",  .addr = A_MIO_PIN_56,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_57",  .addr = A_MIO_PIN_57,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_58",  .addr = A_MIO_PIN_58,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_59",  .addr = A_MIO_PIN_59,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_60",  .addr = A_MIO_PIN_60,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_61",  .addr = A_MIO_PIN_61,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_62",  .addr = A_MIO_PIN_62,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_63",  .addr = A_MIO_PIN_63,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_64",  .addr = A_MIO_PIN_64,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_65",  .addr = A_MIO_PIN_65,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_66",  .addr = A_MIO_PIN_66,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_67",  .addr = A_MIO_PIN_67,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_68",  .addr = A_MIO_PIN_68,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_69",  .addr = A_MIO_PIN_69,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_70",  .addr = A_MIO_PIN_70,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_71",  .addr = A_MIO_PIN_71,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_72",  .addr = A_MIO_PIN_72,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_73",  .addr = A_MIO_PIN_73,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_74",  .addr = A_MIO_PIN_74,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_75",  .addr = A_MIO_PIN_75,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_76",  .addr = A_MIO_PIN_76,
        .rsvd = 0xffffff01,
    },{ .name = "MIO_PIN_77",  .addr = A_MIO_PIN_77,
        .rsvd = 0xffffff01,
    },{ .name = "BANK0_CTRL0",  .addr = A_BANK0_CTRL0,
        .reset = 0x3ffffff,
    },{ .name = "BANK0_CTRL1",  .addr = A_BANK0_CTRL1,
    },{ .name = "BANK0_CTRL3",  .addr = A_BANK0_CTRL3,
    },{ .name = "BANK0_CTRL4",  .addr = A_BANK0_CTRL4,
        .reset = 0x3ffffff,
    },{ .name = "BANK0_CTRL5",  .addr = A_BANK0_CTRL5,
        .reset = 0x3ffffff,
    },{ .name = "BANK0_CTRL6",  .addr = A_BANK0_CTRL6,
    },{ .name = "BANK0_STATUS",  .addr = A_BANK0_STATUS,
        .ro = 0x1,
    },{ .name = "BANK1_CTRL0",  .addr = A_BANK1_CTRL0,
        .reset = 0x3ffffff,
    },{ .name = "BANK1_CTRL1",  .addr = A_BANK1_CTRL1,
    },{ .name = "BANK1_CTRL3",  .addr = A_BANK1_CTRL3,
    },{ .name = "BANK1_CTRL4",  .addr = A_BANK1_CTRL4,
        .reset = 0x3ffffff,
    },{ .name = "BANK1_CTRL5",  .addr = A_BANK1_CTRL5,
        .reset = 0x3ffffff,
    },{ .name = "BANK1_CTRL6",  .addr = A_BANK1_CTRL6,
    },{ .name = "BANK1_STATUS",  .addr = A_BANK1_STATUS,
        .ro = 0x1,
    },{ .name = "BANK2_CTRL0",  .addr = A_BANK2_CTRL0,
        .reset = 0x3ffffff,
    },{ .name = "BANK2_CTRL1",  .addr = A_BANK2_CTRL1,
    },{ .name = "BANK2_CTRL3",  .addr = A_BANK2_CTRL3,
    },{ .name = "BANK2_CTRL4",  .addr = A_BANK2_CTRL4,
        .reset = 0x3ffffff,
    },{ .name = "BANK2_CTRL5",  .addr = A_BANK2_CTRL5,
        .reset = 0x3ffffff,
    },{ .name = "BANK2_CTRL6",  .addr = A_BANK2_CTRL6,
    },{ .name = "BANK2_STATUS",  .addr = A_BANK2_STATUS,
        .ro = 0x1,
    },{ .name = "MIO_LOOPBACK",  .addr = A_MIO_LOOPBACK,
        .rsvd = 0xfffffff0,
    },{ .name = "MIO_MST_TRI0",  .addr = A_MIO_MST_TRI0,
        .reset = 0xffffffff,
    },{ .name = "MIO_MST_TRI1",  .addr = A_MIO_MST_TRI1,
        .reset = 0xffffffff,
    },{ .name = "MIO_MST_TRI2",  .addr = A_MIO_MST_TRI2,
        .reset = 0x3fff,
        .rsvd = 0xffffc000,
    },{ .name = "WDT_CLK_SEL",  .addr = A_WDT_CLK_SEL,
        .rsvd = 0xfffffffe,
    },{ .name = "CAN_MIO_CTRL",  .addr = A_CAN_MIO_CTRL,
        .rsvd = 0xff007e00,
    },{ .name = "GEM_CLK_CTRL",  .addr = A_GEM_CLK_CTRL,
        .rsvd = 0xff884210,
    },{ .name = "SDIO_CLK_CTRL",  .addr = A_SDIO_CLK_CTRL,
        .rsvd = 0xfff9fff8,
    },{ .name = "CTRL_REG_SD",  .addr = A_CTRL_REG_SD,
        .rsvd = 0xffff7ffe,
        .post_write = sd_slottype_postw
    },{ .name = "SD_ITAPDLY",  .addr = A_SD_ITAPDLY,
        .rsvd = 0xfc00fc00,
    },{ .name = "SD_OTAPDLYSEL",  .addr = A_SD_OTAPDLYSEL,
        .rsvd = 0xff80ff80,
    },{ .name = "SD_CONFIG_REG1",  .addr = A_SD_CONFIG_REG1,
        .reset = 0x32403240,
        .rsvd = 0x80008000,
    },{ .name = "SD_CONFIG_REG2",  .addr = A_SD_CONFIG_REG2,
        .reset = 0xffc0ffc,
        .rsvd = 0xc000c000,
    },{ .name = "SD_CONFIG_REG3",  .addr = A_SD_CONFIG_REG3,
        .reset = 0x6070607,
        .rsvd = 0xf800f800,
    },{ .name = "SD_INITPRESET",  .addr = A_SD_INITPRESET,
        .reset = 0x1000100,
        .rsvd = 0xe000e000,
    },{ .name = "SD_DSPPRESET",  .addr = A_SD_DSPPRESET,
        .reset = 0x40004,
        .rsvd = 0xe000e000,
    },{ .name = "SD_HSPDPRESET",  .addr = A_SD_HSPDPRESET,
        .reset = 0x20002,
        .rsvd = 0xe000e000,
    },{ .name = "SD_SDR12PRESET",  .addr = A_SD_SDR12PRESET,
        .reset = 0x40004,
        .rsvd = 0xe000e000,
    },{ .name = "SD_SDR25PRESET",  .addr = A_SD_SDR25PRESET,
        .reset = 0x20002,
        .rsvd = 0xe000e000,
    },{ .name = "SD_SDR50PRSET",  .addr = A_SD_SDR50PRSET,
        .reset = 0x10001,
        .rsvd = 0xe000e000,
    },{ .name = "SD_SDR104PRST",  .addr = A_SD_SDR104PRST,
        .rsvd = 0xe000e000,
    },{ .name = "SD_DDR50PRESET",  .addr = A_SD_DDR50PRESET,
        .reset = 0x20002,
        .rsvd = 0xe000e000,
    },{ .name = "SD_MAXCUR1P8",  .addr = A_SD_MAXCUR1P8,
        .rsvd = 0xff00ff00,
    },{ .name = "SD_MAXCUR3P0",  .addr = A_SD_MAXCUR3P0,
        .rsvd = 0xff00ff00,
    },{ .name = "SD_MAXCUR3P3",  .addr = A_SD_MAXCUR3P3,
        .rsvd = 0xff00ff00,
    },{ .name = "SD_DLL_CTRL",  .addr = A_SD_DLL_CTRL,
        .reset = 0x80008,
        .rsvd = 0xfff8fff8,
        .ro = 0x10001,
    },{ .name = "SD_CDN_CTRL",  .addr = A_SD_CDN_CTRL,
        .rsvd = 0xfffefffe,
    },{ .name = "GEM_CTRL",  .addr = A_GEM_CTRL,
        .rsvd = 0xffffff00,
    },{ .name = "IOU_TTC_APB_CLK",  .addr = A_IOU_TTC_APB_CLK,
        .rsvd = 0xffffff00,
    },{ .name = "IOU_TAPDLY_BYPASS",  .addr = A_IOU_TAPDLY_BYPASS,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
    },{ .name = "IOU_COHERENT_CTRL",  .addr = A_IOU_COHERENT_CTRL,
    },{ .name = "VIDEO_PSS_CLK_SEL",  .addr = A_VIDEO_PSS_CLK_SEL,
        .rsvd = 0xfffffffc,
    },{ .name = "IOU_INTERCONNECT_ROUTE",  .addr = A_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xffffff00,
    },{ .name = "IOU_RAM_GEM0",  .addr = A_IOU_RAM_GEM0,
        .reset = 0x5b5b,
        .rsvd = 0xffff8080,
    },{ .name = "IOU_RAM_GEM1",  .addr = A_IOU_RAM_GEM1,
        .reset = 0x5b5b,
        .rsvd = 0xffff8080,
    },{ .name = "IOU_RAM_GEM2",  .addr = A_IOU_RAM_GEM2,
        .reset = 0x5b5b,
        .rsvd = 0xffff8080,
    },{ .name = "IOU_RAM_GEM3",  .addr = A_IOU_RAM_GEM3,
        .reset = 0x5b5b,
        .rsvd = 0xffff8080,
    },{ .name = "IOU_RAM_SD0",  .addr = A_IOU_RAM_SD0,
        .reset = 0x5b,
        .rsvd = 0xffffff80,
    },{ .name = "IOU_RAM_SD1",  .addr = A_IOU_RAM_SD1,
        .reset = 0x5b,
        .rsvd = 0xffffff80,
    },{ .name = "IOU_RAM_CAN0",  .addr = A_IOU_RAM_CAN0,
        .reset = 0x5b5b5b,
        .rsvd = 0xff808080,
    },{ .name = "IOU_RAM_CAN1",  .addr = A_IOU_RAM_CAN1,
        .reset = 0x5b5b5b,
        .rsvd = 0xff808080,
    },{ .name = "IOU_RAM_LQSPI",  .addr = A_IOU_RAM_LQSPI,
        .reset = 0x2ddb,
        .rsvd = 0xffffc000,
    },{ .name = "IOU_RAM_NAND",  .addr = A_IOU_RAM_NAND,
        .reset = 0x5b,
        .rsvd = 0xffffff80,
    },{ .name = "CTRL",  .addr = A_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "IER",  .addr = A_IER,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .pre_write = itr_prew,
    }
};

static void iou_slcr_reset(DeviceState *dev)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    ARRAY_FIELD_DP32(s->regs, BANK0_STATUS, VOLTAGE_MODE, s->cfg.mio_bank0v);
    ARRAY_FIELD_DP32(s->regs, BANK1_STATUS, VOLTAGE_MODE, s->cfg.mio_bank1v);
    ARRAY_FIELD_DP32(s->regs, BANK2_STATUS, VOLTAGE_MODE, s->cfg.mio_bank2v);

    imr_update_irq(s);
}

static const MemoryRegionOps iou_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void iou_slcr_init(Object *obj)
{
    IOU_SLCR *s = XILINX_IOU_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;
    DeviceState *dev = DEVICE(obj);

    memory_region_init(&s->iomem, obj, TYPE_XILINX_IOU_SLCR,
                       IOU_SLCR_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), iou_slcr_regs_info,
                              ARRAY_SIZE(iou_slcr_regs_info),
                              s->regs_info, s->regs,
                              &iou_slcr_ops,
                              XILINX_IOU_SLCR_ERR_DEBUG,
                              IOU_SLCR_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr);

    qdev_init_gpio_out_named(dev, &s->sd_slottype[0], "SD0_SLOTTYPE", 1);
    qdev_init_gpio_out_named(dev, &s->sd_slottype[1], "SD1_SLOTTYPE", 1);
}

static const VMStateDescription vmstate_iou_slcr = {
    .name = TYPE_XILINX_IOU_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, IOU_SLCR, IOU_SLCR_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet zynqmp_iou_slcr_controller_gpios [] = {
    {
        /* FIXME: this could be a much better name */
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection []) {
            { .name = "SD0_SLOTTYPE",   .fdt_index = 0 },
            { .name = "SD1_SLOTTYPE",   .fdt_index = 1 },
            { },
        },
    },
    { },
};

static Property zynqmp_iou_slcr_props[] = {
    DEFINE_PROP_BOOL("mio-bank0-1.8v", IOU_SLCR, cfg.mio_bank0v, false),
    DEFINE_PROP_BOOL("mio-bank1-1.8v", IOU_SLCR, cfg.mio_bank1v, false),
    DEFINE_PROP_BOOL("mio-bank2-1.8v", IOU_SLCR, cfg.mio_bank2v, false),
    DEFINE_PROP_END_OF_LIST(),
};

static void iou_slcr_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->reset = iou_slcr_reset;
    dc->vmsd = &vmstate_iou_slcr;
    device_class_set_props(dc, zynqmp_iou_slcr_props);

    fggc->controller_gpios = zynqmp_iou_slcr_controller_gpios;
}

static const TypeInfo iou_slcr_info = {
    .name          = TYPE_XILINX_IOU_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(IOU_SLCR),
    .class_init    = iou_slcr_class_init,
    .instance_init = iou_slcr_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { },
    }
};

static void iou_slcr_register_types(void)
{
    type_register_static(&iou_slcr_info);
}

type_init(iou_slcr_register_types)
