/*
 * QEMU model of the PSX_RPU_CLUSTER_CORE1 Realtime Processing Unit ; Core1
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2022-03-22.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "cpu.h"
#include "hw/qdev-properties.h"
#include "hw/fdt_generic_util.h"
#include "qapi/error.h"

#ifndef XILINX_PSX_RPU_CLUSTER_CORE1_ERR_DEBUG
#define XILINX_PSX_RPU_CLUSTER_CORE1_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSX_RPU_CLUSTER_CORE1 "xlnx.psx_rpu_cluster_core1"

#define XILINX_PSX_RPU_CLUSTER_CORE1(obj) \
     OBJECT_CHECK(PSX_RPU_CLUSTER_CORE1, (obj), \
                  TYPE_XILINX_PSX_RPU_CLUSTER_CORE1)

REG32(CORE_1_CFG0, 0x0)
    FIELD(CORE_1_CFG0, REMAP_AXIM_ADDR, 5, 1)
    FIELD(CORE_1_CFG0, TCMBOOT, 4, 1)
    FIELD(CORE_1_CFG0, CPUHALT, 0, 1)
REG32(CORE_1_CFG1, 0x4)
    FIELD(CORE_1_CFG1, THUMBEXCEPTIONS, 8, 1)
    FIELD(CORE_1_CFG1, ENDIANESS, 4, 1)
    FIELD(CORE_1_CFG1, L1CACHEINVDIS, 0, 1)
REG32(CORE_1_VECTABLE, 0x10)
    FIELD(CORE_1_VECTABLE, BASE_HI, 8, 24)
    FIELD(CORE_1_VECTABLE, BASE_LO, 5, 3)
REG32(CORE_1_PRIMERRIDX, 0x40)
    FIELD(CORE_1_PRIMERRIDX, IDX, 0, 25)
REG32(CORE_1_PRIMERRMEM, 0x44)
    FIELD(CORE_1_PRIMERRMEM, MEM, 0, 15)
REG32(CORE_1_PRIMERRV, 0x48)
    FIELD(CORE_1_PRIMERRV, VLD, 0, 1)
REG32(CORE_1_SECMERRIDX, 0x50)
    FIELD(CORE_1_SECMERRIDX, IDX, 0, 25)
REG32(CORE_1_SECMERRMEM, 0x54)
    FIELD(CORE_1_SECMERRMEM, MEM, 0, 15)
REG32(CORE_1_SECMERRV, 0x58)
    FIELD(CORE_1_SECMERRV, VLD, 0, 1)
REG32(CORE1_PRIMERRIDX, 0x5c)
    FIELD(CORE1_PRIMERRIDX, CORE1_PRIMEVLD, 25, 1)
    FIELD(CORE1_PRIMERRIDX, IDX, 0, 25)
REG32(CORE1_PRIMERRMEM, 0x60)
    FIELD(CORE1_PRIMERRMEM, MEM, 0, 15)
REG32(CORE1_SECMERRIDX, 0x64)
    FIELD(CORE1_SECMERRIDX, CORE1_SECMVLD, 25, 1)
    FIELD(CORE1_SECMERRIDX, IDX, 0, 25)
REG32(CORE1_SECMERRMEM, 0x68)
    FIELD(CORE1_SECMERRMEM, MEM, 0, 15)
REG32(CORE_1_STATUS, 0x70)
REG32(CORE_1_PWRDWN, 0x80)
    FIELD(CORE_1_PWRDWN, EN, 0, 1)
REG32(ERREVENT_1_FATAL_STATUS, 0x100)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_19, 19, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_17, 17, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_12, 12, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_10, 10, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_6, 6, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_5, 5, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_4, 4, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_3, 3, 1)
    FIELD(ERREVENT_1_FATAL_STATUS, BIT_1, 1, 1)
REG32(ERREVENT_1_FATAL_MASK, 0x104)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_19, 19, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_17, 17, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_12, 12, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_10, 10, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_6, 6, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_5, 5, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_4, 4, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_3, 3, 1)
    FIELD(ERREVENT_1_FATAL_MASK, BIT_1, 1, 1)
REG32(ERREVENT_1_FATAL_EN, 0x108)
    FIELD(ERREVENT_1_FATAL_EN, BIT_19, 19, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_17, 17, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_12, 12, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_10, 10, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_6, 6, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_5, 5, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_4, 4, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_3, 3, 1)
    FIELD(ERREVENT_1_FATAL_EN, BIT_1, 1, 1)
REG32(ERREVENT_1_FATAL_DIS, 0x10c)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_19, 19, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_17, 17, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_12, 12, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_10, 10, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_6, 6, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_5, 5, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_4, 4, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_3, 3, 1)
    FIELD(ERREVENT_1_FATAL_DIS, BIT_1, 1, 1)
REG32(ERREVENT_1_FATAL_TRIGG, 0x120)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_19, 19, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_17, 17, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_12, 12, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_10, 10, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_6, 6, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_5, 5, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_4, 4, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_3, 3, 1)
    FIELD(ERREVENT_1_FATAL_TRIGG, BIT_1, 1, 1)
REG32(ERREVENT_1_CORR_STATUS, 0x124)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_16, 16, 1)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_11, 11, 1)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_9, 9, 1)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_8, 8, 1)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_7, 7, 1)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_2, 2, 1)
    FIELD(ERREVENT_1_CORR_STATUS, BIT_0, 0, 1)
REG32(ERREVENT_1_CORR_MASK, 0x128)
    FIELD(ERREVENT_1_CORR_MASK, BIT_16, 16, 1)
    FIELD(ERREVENT_1_CORR_MASK, BIT_11, 11, 1)
    FIELD(ERREVENT_1_CORR_MASK, BIT_9, 9, 1)
    FIELD(ERREVENT_1_CORR_MASK, BIT_8, 8, 1)
    FIELD(ERREVENT_1_CORR_MASK, BIT_7, 7, 1)
    FIELD(ERREVENT_1_CORR_MASK, BIT_2, 2, 1)
    FIELD(ERREVENT_1_CORR_MASK, BIT_0, 0, 1)
REG32(ERREVENT_1_CORR_EN, 0x12c)
    FIELD(ERREVENT_1_CORR_EN, BIT_16, 16, 1)
    FIELD(ERREVENT_1_CORR_EN, BIT_11, 11, 1)
    FIELD(ERREVENT_1_CORR_EN, BIT_9, 9, 1)
    FIELD(ERREVENT_1_CORR_EN, BIT_8, 8, 1)
    FIELD(ERREVENT_1_CORR_EN, BIT_7, 7, 1)
    FIELD(ERREVENT_1_CORR_EN, BIT_2, 2, 1)
    FIELD(ERREVENT_1_CORR_EN, BIT_0, 0, 1)
REG32(ERREVENT_1_CORR_DIS, 0x130)
    FIELD(ERREVENT_1_CORR_DIS, BIT_16, 16, 1)
    FIELD(ERREVENT_1_CORR_DIS, BIT_11, 11, 1)
    FIELD(ERREVENT_1_CORR_DIS, BIT_9, 9, 1)
    FIELD(ERREVENT_1_CORR_DIS, BIT_8, 8, 1)
    FIELD(ERREVENT_1_CORR_DIS, BIT_7, 7, 1)
    FIELD(ERREVENT_1_CORR_DIS, BIT_2, 2, 1)
    FIELD(ERREVENT_1_CORR_DIS, BIT_0, 0, 1)
REG32(ERREVENT_1_CORR_TRIGG, 0x134)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_16, 16, 1)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_11, 11, 1)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_9, 9, 1)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_8, 8, 1)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_7, 7, 1)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_2, 2, 1)
    FIELD(ERREVENT_1_CORR_TRIGG, BIT_0, 0, 1)
REG32(ERREVENT_1_TIME_OUT_STATUS, 0x138)
    FIELD(ERREVENT_1_TIME_OUT_STATUS, BIT_15, 15, 1)
    FIELD(ERREVENT_1_TIME_OUT_STATUS, BIT_14, 14, 1)
    FIELD(ERREVENT_1_TIME_OUT_STATUS, BIT_13, 13, 1)
REG32(ERREVENT_1_TIME_OUT_MASK, 0x13c)
    FIELD(ERREVENT_1_TIME_OUT_MASK, BIT_15, 15, 1)
    FIELD(ERREVENT_1_TIME_OUT_MASK, BIT_14, 14, 1)
    FIELD(ERREVENT_1_TIME_OUT_MASK, BIT_13, 13, 1)
REG32(ERREVENT_1_TIME_OUT_EN, 0x140)
    FIELD(ERREVENT_1_TIME_OUT_EN, BIT_15, 15, 1)
    FIELD(ERREVENT_1_TIME_OUT_EN, BIT_14, 14, 1)
    FIELD(ERREVENT_1_TIME_OUT_EN, BIT_13, 13, 1)
REG32(ERREVENT_1_TIME_OUT_DIS, 0x144)
    FIELD(ERREVENT_1_TIME_OUT_DIS, BIT_15, 15, 1)
    FIELD(ERREVENT_1_TIME_OUT_DIS, BIT_14, 14, 1)
    FIELD(ERREVENT_1_TIME_OUT_DIS, BIT_13, 13, 1)
REG32(ERREVENT_1_TIME_OUT_TRIGG, 0x148)
    FIELD(ERREVENT_1_TIME_OUT_TRIGG, BIT_15, 15, 1)
    FIELD(ERREVENT_1_TIME_OUT_TRIGG, BIT_14, 14, 1)
    FIELD(ERREVENT_1_TIME_OUT_TRIGG, BIT_13, 13, 1)
REG32(ERREVENT_1_EXCEPTION_STATUS, 0x14c)
    FIELD(ERREVENT_1_EXCEPTION_STATUS, BIT_24, 24, 1)
    FIELD(ERREVENT_1_EXCEPTION_STATUS, BIT_23, 23, 1)
    FIELD(ERREVENT_1_EXCEPTION_STATUS, BIT_22, 22, 1)
    FIELD(ERREVENT_1_EXCEPTION_STATUS, BIT_21, 21, 1)
    FIELD(ERREVENT_1_EXCEPTION_STATUS, BIT_20, 20, 1)
REG32(ERREVENT_1_EXCEPTION_MASK, 0x150)
    FIELD(ERREVENT_1_EXCEPTION_MASK, BIT_24, 24, 1)
    FIELD(ERREVENT_1_EXCEPTION_MASK, BIT_23, 23, 1)
    FIELD(ERREVENT_1_EXCEPTION_MASK, BIT_22, 22, 1)
    FIELD(ERREVENT_1_EXCEPTION_MASK, BIT_21, 21, 1)
    FIELD(ERREVENT_1_EXCEPTION_MASK, BIT_20, 20, 1)
REG32(ERREVENT_1_EXCEPTION_EN, 0x154)
    FIELD(ERREVENT_1_EXCEPTION_EN, BIT_24, 24, 1)
    FIELD(ERREVENT_1_EXCEPTION_EN, BIT_23, 23, 1)
    FIELD(ERREVENT_1_EXCEPTION_EN, BIT_22, 22, 1)
    FIELD(ERREVENT_1_EXCEPTION_EN, BIT_21, 21, 1)
    FIELD(ERREVENT_1_EXCEPTION_EN, BIT_20, 20, 1)
REG32(ERREVENT_1_EXCEPTION_DIS, 0x158)
    FIELD(ERREVENT_1_EXCEPTION_DIS, BIT_24, 24, 1)
    FIELD(ERREVENT_1_EXCEPTION_DIS, BIT_23, 23, 1)
    FIELD(ERREVENT_1_EXCEPTION_DIS, BIT_22, 22, 1)
    FIELD(ERREVENT_1_EXCEPTION_DIS, BIT_21, 21, 1)
    FIELD(ERREVENT_1_EXCEPTION_DIS, BIT_20, 20, 1)
REG32(ERREVENT_1_EXCEPTION_TRIGG, 0x15c)
    FIELD(ERREVENT_1_EXCEPTION_TRIGG, BIT_24, 24, 1)
    FIELD(ERREVENT_1_EXCEPTION_TRIGG, BIT_23, 23, 1)
    FIELD(ERREVENT_1_EXCEPTION_TRIGG, BIT_22, 22, 1)
    FIELD(ERREVENT_1_EXCEPTION_TRIGG, BIT_21, 21, 1)
    FIELD(ERREVENT_1_EXCEPTION_TRIGG, BIT_20, 20, 1)
REG32(ERREVENT_1_IMP_TESTR1_STATUS, 0x160)
    FIELD(ERREVENT_1_IMP_TESTR1_STATUS, BIT_25, 25, 1)
REG32(ERREVENT_1_IMP_TESTR1_MASK, 0x164)
    FIELD(ERREVENT_1_IMP_TESTR1_MASK, BIT_25, 25, 1)
REG32(ERREVENT_1_IMP_TESTR1_EN, 0x168)
    FIELD(ERREVENT_1_IMP_TESTR1_EN, BIT_25, 25, 1)
REG32(ERREVENT_1_IMP_TESTR1_DIS, 0x16c)
    FIELD(ERREVENT_1_IMP_TESTR1_DIS, BIT_25, 25, 1)
REG32(ERREVENT_1_IMP_TESTR1_TRIGG, 0x170)
    FIELD(ERREVENT_1_IMP_TESTR1_TRIGG, BIT_25, 25, 1)
REG32(ERREVENT_1_IMP_INTMONR_STATUS, 0x174)
    FIELD(ERREVENT_1_IMP_INTMONR_STATUS, BIT_18, 18, 1)
REG32(ERREVENT_1_IMP_INTMONR_MASK, 0x178)
    FIELD(ERREVENT_1_IMP_INTMONR_MASK, BIT_18, 18, 1)
REG32(ERREVENT_1_IMP_INTMONR_EN, 0x17c)
    FIELD(ERREVENT_1_IMP_INTMONR_EN, BIT_18, 18, 1)
REG32(ERREVENT_1_IMP_INTMONR_DIS, 0x180)
    FIELD(ERREVENT_1_IMP_INTMONR_DIS, BIT_18, 18, 1)
REG32(ERREVENT_1_IMP_INTMONR_TRIGG, 0x184)
    FIELD(ERREVENT_1_IMP_INTMONR_TRIGG, BIT_18, 18, 1)
REG32(RPU_CORE1_ISR, 0x200)
    FIELD(RPU_CORE1_ISR, CORE1_PWR_ERR, 3, 1)
    FIELD(RPU_CORE1_ISR, CORE1_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE1_ISR, CORE1_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE1_IMR, 0x204)
    FIELD(RPU_CORE1_IMR, CORE1_PWR_ERR, 3, 1)
    FIELD(RPU_CORE1_IMR, CORE_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE1_IMR, CORE_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE1_IEN, 0x208)
    FIELD(RPU_CORE1_IEN, CORE1_PWR_ERR, 3, 1)
    FIELD(RPU_CORE1_IEN, CORE_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE1_IEN, CORE_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE1_IDS, 0x20c)
    FIELD(RPU_CORE1_IDS, CORE1_PWR_ERR, 3, 1)
    FIELD(RPU_CORE1_IDS, CORE_REG_PAR_MON_ERR1, 2, 1)
    FIELD(RPU_CORE1_IDS, CORE_REG_PAR_MON_ERR0, 1, 1)
REG32(RPU_CORE1_PAR_MON, 0x210)
    FIELD(RPU_CORE1_PAR_MON, CORE1_PAR_MON_EN, 0, 1)

#define PSX_RPU_CLUSTER_CORE1_R_MAX (R_RPU_CORE1_PAR_MON + 1)

typedef struct PSX_RPU_CLUSTER_CORE1 {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_errevent_1_imp_intmonr;
    qemu_irq irq_errevent_1_corr;
    qemu_irq irq_errevent_1_time_out;
    qemu_irq irq_errevent_1_fatal;
    qemu_irq irq_errevent_1_exception;
    qemu_irq irq_errevent_1_imp_testr1;
    qemu_irq irq_rpu_core1_imr;

    qemu_irq halt;
    qemu_irq thumb;
    bool cpu_rst;
    ARMCPU *core;
    bool slsplit;

    uint32_t regs[PSX_RPU_CLUSTER_CORE1_R_MAX];
    RegisterInfo regs_info[PSX_RPU_CLUSTER_CORE1_R_MAX];
} PSX_RPU_CLUSTER_CORE1;

static void errevent_1_imp_intmonr_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_ERREVENT_1_IMP_INTMONR_STATUS] &
                   ~s->regs[R_ERREVENT_1_IMP_INTMONR_MASK];
    qemu_set_irq(s->irq_errevent_1_imp_intmonr, pending);
}

static void errevent_1_imp_intmonr_status_postw(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    errevent_1_imp_intmonr_update_irq(s);
}

static uint64_t errevent_1_imp_intmonr_en_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_IMP_INTMONR_MASK] &= ~val;
    errevent_1_imp_intmonr_update_irq(s);
    return 0;
}

static uint64_t errevent_1_imp_intmonr_dis_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_IMP_INTMONR_MASK] |= val;
    errevent_1_imp_intmonr_update_irq(s);
    return 0;
}

static uint64_t errevent_1_imp_intmonr_trigg_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_IMP_INTMONR_STATUS] |= val;
    errevent_1_imp_intmonr_update_irq(s);
    return 0;
}

static void errevent_1_corr_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_ERREVENT_1_CORR_STATUS] &
                   ~s->regs[R_ERREVENT_1_CORR_MASK];
    qemu_set_irq(s->irq_errevent_1_corr, pending);
}

static void errevent_1_corr_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    errevent_1_corr_update_irq(s);
}

static uint64_t errevent_1_corr_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_CORR_MASK] &= ~val;
    errevent_1_corr_update_irq(s);
    return 0;
}

static uint64_t errevent_1_corr_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_CORR_MASK] |= val;
    errevent_1_corr_update_irq(s);
    return 0;
}

static uint64_t errevent_1_corr_trigg_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_CORR_STATUS] |= val;
    errevent_1_corr_update_irq(s);
    return 0;
}

static void errevent_1_time_out_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_ERREVENT_1_TIME_OUT_STATUS] &
                   ~s->regs[R_ERREVENT_1_TIME_OUT_MASK];
    qemu_set_irq(s->irq_errevent_1_time_out, pending);
}

static void errevent_1_time_out_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    errevent_1_time_out_update_irq(s);
}

static uint64_t errevent_1_time_out_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_TIME_OUT_MASK] &= ~val;
    errevent_1_time_out_update_irq(s);
    return 0;
}

static uint64_t errevent_1_time_out_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_TIME_OUT_MASK] |= val;
    errevent_1_time_out_update_irq(s);
    return 0;
}

static uint64_t errevent_1_time_out_trigg_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_TIME_OUT_STATUS] |= val;
    errevent_1_time_out_update_irq(s);
    return 0;
}

static void errevent_1_fatal_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_ERREVENT_1_FATAL_STATUS] &
                   ~s->regs[R_ERREVENT_1_FATAL_MASK];
    qemu_set_irq(s->irq_errevent_1_fatal, pending);
}

static void errevent_1_fatal_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    errevent_1_fatal_update_irq(s);
}

static uint64_t errevent_1_fatal_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_FATAL_MASK] &= ~val;
    errevent_1_fatal_update_irq(s);
    return 0;
}

static uint64_t errevent_1_fatal_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_FATAL_MASK] |= val;
    errevent_1_fatal_update_irq(s);
    return 0;
}

static uint64_t errevent_1_fatal_trigg_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_FATAL_STATUS] |= val;
    errevent_1_fatal_update_irq(s);
    return 0;
}

static void errevent_1_exception_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_ERREVENT_1_EXCEPTION_STATUS] &
                   ~s->regs[R_ERREVENT_1_EXCEPTION_MASK];
    qemu_set_irq(s->irq_errevent_1_exception, pending);
}

static void errevent_1_exception_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    errevent_1_exception_update_irq(s);
}

static uint64_t errevent_1_exception_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_EXCEPTION_MASK] &= ~val;
    errevent_1_exception_update_irq(s);
    return 0;
}

static uint64_t errevent_1_exception_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_EXCEPTION_MASK] |= val;
    errevent_1_exception_update_irq(s);
    return 0;
}

static uint64_t errevent_1_exception_trigg_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_EXCEPTION_STATUS] |= val;
    errevent_1_exception_update_irq(s);
    return 0;
}

static void errevent_1_imp_testr1_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_ERREVENT_1_IMP_TESTR1_STATUS] &
                   ~s->regs[R_ERREVENT_1_IMP_TESTR1_MASK];
    qemu_set_irq(s->irq_errevent_1_imp_testr1, pending);
}

static void errevent_1_imp_testr1_status_postw(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    errevent_1_imp_testr1_update_irq(s);
}

static uint64_t errevent_1_imp_testr1_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_IMP_TESTR1_MASK] &= ~val;
    errevent_1_imp_testr1_update_irq(s);
    return 0;
}

static uint64_t errevent_1_imp_testr1_dis_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_IMP_TESTR1_MASK] |= val;
    errevent_1_imp_testr1_update_irq(s);
    return 0;
}

static uint64_t errevent_1_imp_testr1_trigg_prew(RegisterInfo *reg,
                                                 uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ERREVENT_1_IMP_TESTR1_STATUS] |= val;
    errevent_1_imp_testr1_update_irq(s);
    return 0;
}

static void rpu_core1_imr_update_irq(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool pending = s->regs[R_RPU_CORE1_ISR] & ~s->regs[R_RPU_CORE1_IMR];
    qemu_set_irq(s->irq_rpu_core1_imr, pending);
}

static void rpu_core1_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    rpu_core1_imr_update_irq(s);
}

static uint64_t rpu_core1_ien_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RPU_CORE1_IMR] &= ~val;
    rpu_core1_imr_update_irq(s);
    return 0;
}

static uint64_t rpu_core1_ids_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RPU_CORE1_IMR] |= val;
    rpu_core1_imr_update_irq(s);
    return 0;
}

static void rpu_update_gpios(PSX_RPU_CLUSTER_CORE1 *s)
{
    bool ncpuhalt;
    bool use_thumb;

    ncpuhalt = ARRAY_FIELD_EX32(s->regs, CORE_1_CFG0, CPUHALT);

    use_thumb = ARRAY_FIELD_EX32(s->regs, CORE_1_CFG1, THUMBEXCEPTIONS);

    if (!s->slsplit) {
        ncpuhalt = true;
    }

    qemu_set_irq(s->halt, s->cpu_rst | ncpuhalt);
    qemu_set_irq(s->thumb, use_thumb);
}

static void core_cfg_postw(RegisterInfo *reg, uint64_t val)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);

    rpu_update_gpios(s);
}

static void vectable_base_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(reg->opaque);

    if (s->core) {
        CPUClass *cc = CPU_GET_CLASS(s->core);
        object_property_set_int(OBJECT(s->core), "rvbar",
                                val64, &error_abort);
        if (s->cpu_rst) {
            cc->set_pc(CPU(s->core), val64);
        }
    }
}

static const RegisterAccessInfo psx_rpu_cluster_core1_regs_info[] = {
    {   .name = "CORE_1_CFG0",  .addr = A_CORE_1_CFG0,
        .reset = 0x10,
        .rsvd = 0xffffffce,
        .post_write = core_cfg_postw,
    },{ .name = "CORE_1_CFG1",  .addr = A_CORE_1_CFG1,
        .rsvd = 0xfffffeee,
        .post_write = core_cfg_postw,
    },{ .name = "CORE_1_VECTABLE",  .addr = A_CORE_1_VECTABLE,
        .rsvd = 0x1f,
        .post_write = vectable_base_postw,
    },{ .name = "CORE_1_PRIMERRIDX",  .addr = A_CORE_1_PRIMERRIDX,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "CORE_1_PRIMERRMEM",  .addr = A_CORE_1_PRIMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE_1_PRIMERRV",  .addr = A_CORE_1_PRIMERRV,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE_1_SECMERRIDX",  .addr = A_CORE_1_SECMERRIDX,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "CORE_1_SECMERRMEM",  .addr = A_CORE_1_SECMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE_1_SECMERRV",  .addr = A_CORE_1_SECMERRV,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "CORE1_PRIMERRIDX",  .addr = A_CORE1_PRIMERRIDX,
        .rsvd = 0xfc000000,
        .ro = 0x1ffffff,
        .w1c = 0x2000000,
    },{ .name = "CORE1_PRIMERRMEM",  .addr = A_CORE1_PRIMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE1_SECMERRIDX",  .addr = A_CORE1_SECMERRIDX,
        .rsvd = 0xfc000000,
        .ro = 0x1ffffff,
        .w1c = 0x2000000,
    },{ .name = "CORE1_SECMERRMEM",  .addr = A_CORE1_SECMERRMEM,
        .rsvd = 0xffff8000,
        .ro = 0x7fff,
    },{ .name = "CORE_1_STATUS",  .addr = A_CORE_1_STATUS,
        .rsvd = 0xffffffff,
    },{ .name = "CORE_1_PWRDWN",  .addr = A_CORE_1_PWRDWN,
        .rsvd = 0xfffffffe,
    },{ .name = "ERREVENT_1_FATAL_STATUS",  .addr = A_ERREVENT_1_FATAL_STATUS,
        .rsvd = 0xfff5eb85,
        .w1c = 0xa147a,
        .post_write = errevent_1_fatal_status_postw,
    },{ .name = "ERREVENT_1_FATAL_MASK",  .addr = A_ERREVENT_1_FATAL_MASK,
        .reset = 0xa147a,
        .ro = 0xa147a,
    },{ .name = "ERREVENT_1_FATAL_EN",  .addr = A_ERREVENT_1_FATAL_EN,
        .pre_write = errevent_1_fatal_en_prew,
    },{ .name = "ERREVENT_1_FATAL_DIS",  .addr = A_ERREVENT_1_FATAL_DIS,
        .pre_write = errevent_1_fatal_dis_prew,
    },{ .name = "ERREVENT_1_FATAL_TRIGG",  .addr = A_ERREVENT_1_FATAL_TRIGG,
        .pre_write = errevent_1_fatal_trigg_prew,
    },{ .name = "ERREVENT_1_CORR_STATUS",  .addr = A_ERREVENT_1_CORR_STATUS,
        .rsvd = 0xfffef47a,
        .w1c = 0x10b85,
        .post_write = errevent_1_corr_status_postw,
    },{ .name = "ERREVENT_1_CORR_MASK",  .addr = A_ERREVENT_1_CORR_MASK,
        .reset = 0x10b85,
        .ro = 0x10b85,
    },{ .name = "ERREVENT_1_CORR_EN",  .addr = A_ERREVENT_1_CORR_EN,
        .pre_write = errevent_1_corr_en_prew,
    },{ .name = "ERREVENT_1_CORR_DIS",  .addr = A_ERREVENT_1_CORR_DIS,
        .pre_write = errevent_1_corr_dis_prew,
    },{ .name = "ERREVENT_1_CORR_TRIGG",  .addr = A_ERREVENT_1_CORR_TRIGG,
        .pre_write = errevent_1_corr_trigg_prew,
    },{ .name = "ERREVENT_1_TIME_OUT_STATUS",
        .addr = A_ERREVENT_1_TIME_OUT_STATUS,
        .rsvd = 0xffff1fff,
        .w1c = 0xe000,
        .post_write = errevent_1_time_out_status_postw,
    },{ .name = "ERREVENT_1_TIME_OUT_MASK",  .addr = A_ERREVENT_1_TIME_OUT_MASK,
        .reset = 0xe000,
        .ro = 0xe000,
    },{ .name = "ERREVENT_1_TIME_OUT_EN",  .addr = A_ERREVENT_1_TIME_OUT_EN,
        .pre_write = errevent_1_time_out_en_prew,
    },{ .name = "ERREVENT_1_TIME_OUT_DIS",  .addr = A_ERREVENT_1_TIME_OUT_DIS,
        .pre_write = errevent_1_time_out_dis_prew,
    },{ .name = "ERREVENT_1_TIME_OUT_TRIGG",
        .addr = A_ERREVENT_1_TIME_OUT_TRIGG,
        .pre_write = errevent_1_time_out_trigg_prew,
    },{ .name = "ERREVENT_1_EXCEPTION_STATUS",
        .addr = A_ERREVENT_1_EXCEPTION_STATUS,
        .rsvd = 0xfe0fffff,
        .w1c = 0x1f00000,
        .post_write = errevent_1_exception_status_postw,
    },{ .name = "ERREVENT_1_EXCEPTION_MASK",
        .addr = A_ERREVENT_1_EXCEPTION_MASK,
        .reset = 0x1f00000,
        .ro = 0x1f00000,
    },{ .name = "ERREVENT_1_EXCEPTION_EN",  .addr = A_ERREVENT_1_EXCEPTION_EN,
        .pre_write = errevent_1_exception_en_prew,
    },{ .name = "ERREVENT_1_EXCEPTION_DIS",  .addr = A_ERREVENT_1_EXCEPTION_DIS,
        .pre_write = errevent_1_exception_dis_prew,
    },{ .name = "ERREVENT_1_EXCEPTION_TRIGG",
        .addr = A_ERREVENT_1_EXCEPTION_TRIGG,
        .pre_write = errevent_1_exception_trigg_prew,
    },{ .name = "ERREVENT_1_IMP_TESTR1_STATUS",
        .addr = A_ERREVENT_1_IMP_TESTR1_STATUS,
        .rsvd = 0xfdffffff,
        .w1c = 0x2000000,
        .post_write = errevent_1_imp_testr1_status_postw,
    },{ .name = "ERREVENT_1_IMP_TESTR1_MASK",
        .addr = A_ERREVENT_1_IMP_TESTR1_MASK,
        .reset = 0x2000000,
        .ro = 0x2000000,
    },{ .name = "ERREVENT_1_IMP_TESTR1_EN",  .addr = A_ERREVENT_1_IMP_TESTR1_EN,
        .pre_write = errevent_1_imp_testr1_en_prew,
    },{ .name = "ERREVENT_1_IMP_TESTR1_DIS",
        .addr = A_ERREVENT_1_IMP_TESTR1_DIS,
        .pre_write = errevent_1_imp_testr1_dis_prew,
    },{ .name = "ERREVENT_1_IMP_TESTR1_TRIGG",
        .addr = A_ERREVENT_1_IMP_TESTR1_TRIGG,
        .pre_write = errevent_1_imp_testr1_trigg_prew,
    },{ .name = "ERREVENT_1_IMP_INTMONR_STATUS",
        .addr = A_ERREVENT_1_IMP_INTMONR_STATUS,
        .rsvd = 0xfffbffff,
        .w1c = 0x40000,
        .post_write = errevent_1_imp_intmonr_status_postw,
    },{ .name = "ERREVENT_1_IMP_INTMONR_MASK",
        .addr = A_ERREVENT_1_IMP_INTMONR_MASK,
        .reset = 0x40000,
        .ro = 0x40000,
    },{ .name = "ERREVENT_1_IMP_INTMONR_EN",
        .addr = A_ERREVENT_1_IMP_INTMONR_EN,
        .pre_write = errevent_1_imp_intmonr_en_prew,
    },{ .name = "ERREVENT_1_IMP_INTMONR_DIS",
        .addr = A_ERREVENT_1_IMP_INTMONR_DIS,
        .pre_write = errevent_1_imp_intmonr_dis_prew,
    },{ .name = "ERREVENT_1_IMP_INTMONR_TRIGG",
        .addr = A_ERREVENT_1_IMP_INTMONR_TRIGG,
        .pre_write = errevent_1_imp_intmonr_trigg_prew,
    },{ .name = "RPU_CORE1_ISR",  .addr = A_RPU_CORE1_ISR,
        .rsvd = 0xfffffff1,
        .w1c = 0xe,
        .post_write = rpu_core1_isr_postw,
    },{ .name = "RPU_CORE1_IMR",  .addr = A_RPU_CORE1_IMR,
        .reset = 0xe,
        .rsvd = 0xfffffff1,
        .ro = 0xe,
    },{ .name = "RPU_CORE1_IEN",  .addr = A_RPU_CORE1_IEN,
        .rsvd = 0xfffffff1,
        .pre_write = rpu_core1_ien_prew,
    },{ .name = "RPU_CORE1_IDS",  .addr = A_RPU_CORE1_IDS,
        .rsvd = 0xfffffff1,
        .pre_write = rpu_core1_ids_prew,
    },{ .name = "RPU_CORE1_PAR_MON",  .addr = A_RPU_CORE1_PAR_MON,
        .rsvd = 0xfffffffe,
    }
};

static void r52_tcm_region_set(ARMCPU *cpu)
{
    cpu->env.tcmregion.a &= 0x3;
    cpu->env.tcmregion.a |= (7 << 2);

    cpu->env.tcmregion.b &= 0x3;
    cpu->env.tcmregion.b |= ((0x10000 >> 13) << 13) | (7 << 2);

    cpu->env.tcmregion.c &= 0x3;
    cpu->env.tcmregion.c |= ((0x20000 >> 13) << 13) | (7 << 2);
}

static void psx_rpu_cluster_core1_reset_enter(Object *obj, ResetType type)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void psx_rpu_cluster_core1_reset_hold(Object *obj)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(obj);

    errevent_1_imp_intmonr_update_irq(s);
    errevent_1_corr_update_irq(s);
    errevent_1_time_out_update_irq(s);
    errevent_1_fatal_update_irq(s);
    errevent_1_exception_update_irq(s);
    errevent_1_imp_testr1_update_irq(s);
    rpu_core1_imr_update_irq(s);
    r52_tcm_region_set(s->core);
    rpu_update_gpios(s);
}

static const MemoryRegionOps psx_rpu_cluster_core1_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void slsplit_signal(void *opaque, int irq, int level)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(opaque);

    s->slsplit = level;
}

static void rpu_core_rst_handler(void *opaque, int irq, int level)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(opaque);

    r52_tcm_region_set(s->core);
    s->cpu_rst = level;
    rpu_update_gpios(s);
}

static void psx_rpu_cluster_core1_realize(DeviceState *dev, Error **errp)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(dev);

    qdev_init_gpio_in_named(dev, rpu_core_rst_handler, "core1-rst", 1);
    qdev_init_gpio_out_named(dev, &s->halt, "halt", 1);
    qdev_init_gpio_out_named(dev, &s->thumb, "thumb", 1);
    qdev_init_gpio_in_named(dev, slsplit_signal, "slsplit", 1);
}

static void psx_rpu_cluster_core1_init(Object *obj)
{
    PSX_RPU_CLUSTER_CORE1 *s = XILINX_PSX_RPU_CLUSTER_CORE1(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSX_RPU_CLUSTER_CORE1,
                       PSX_RPU_CLUSTER_CORE1_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psx_rpu_cluster_core1_regs_info,
                              ARRAY_SIZE(psx_rpu_cluster_core1_regs_info),
                              s->regs_info, s->regs,
                              &psx_rpu_cluster_core1_ops,
                              XILINX_PSX_RPU_CLUSTER_CORE1_ERR_DEBUG,
                              PSX_RPU_CLUSTER_CORE1_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_errevent_1_imp_intmonr);
    sysbus_init_irq(sbd, &s->irq_errevent_1_corr);
    sysbus_init_irq(sbd, &s->irq_errevent_1_time_out);
    sysbus_init_irq(sbd, &s->irq_errevent_1_fatal);
    sysbus_init_irq(sbd, &s->irq_errevent_1_exception);
    sysbus_init_irq(sbd, &s->irq_errevent_1_imp_testr1);
    sysbus_init_irq(sbd, &s->irq_rpu_core1_imr);
    object_property_add_link(obj, "core", TYPE_ARM_CPU,
                         (Object **)&s->core,
                         qdev_prop_allow_set_link_before_realize,
                         OBJ_PROP_LINK_STRONG);
}

static const VMStateDescription vmstate_psx_rpu_cluster_core1 = {
    .name = TYPE_XILINX_PSX_RPU_CLUSTER_CORE1,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSX_RPU_CLUSTER_CORE1,
                             PSX_RPU_CLUSTER_CORE1_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet psx_rpu_core0_cntrl_gpio[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
           { .name = "halt", .fdt_index = 0, .range = 1},
           { .name = "thumb", .fdt_index = 1, .range = 1},
           { },
        },
    },
    { },
};

static const FDTGenericGPIOSet psx_rpu_core0_client_gpio[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
           { .name = "core1-rst", .fdt_index = 0, .range = 1},
           { .name = "slsplit", .fdt_index = 1, .range = 1},
           { },
        },
    },
    { },
};

static void psx_rpu_cluster_core1_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->realize = psx_rpu_cluster_core1_realize;
    dc->vmsd = &vmstate_psx_rpu_cluster_core1;
    rc->phases.enter = psx_rpu_cluster_core1_reset_enter;
    rc->phases.hold = psx_rpu_cluster_core1_reset_hold;
    fggc->controller_gpios = psx_rpu_core0_cntrl_gpio;
    fggc->client_gpios = psx_rpu_core0_client_gpio;
}

static const TypeInfo psx_rpu_cluster_core1_info = {
    .name          = TYPE_XILINX_PSX_RPU_CLUSTER_CORE1,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSX_RPU_CLUSTER_CORE1),
    .class_init    = psx_rpu_cluster_core1_class_init,
    .instance_init = psx_rpu_cluster_core1_init,
    .interfaces = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void psx_rpu_cluster_core1_register_types(void)
{
    type_register_static(&psx_rpu_cluster_core1_info);
}

type_init(psx_rpu_cluster_core1_register_types)
