/*
 * Copyright (C) 2022 On-Line Applications Research Corporation (OAR)
 * Written by Kinsey Moore <kinsey.moore@oarcorp.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "xparameters_ps.h"
#include "xemacps.h"

/*
 * The configuration table for devices
 */

XEmacPs_Config XEmacPs_ConfigTable[ XPAR_XEMACPS_NUM_INSTANCES ] = {
  {
    XPAR_PSU_ETHERNET_3_DEVICE_ID,
    XPAR_PSU_ETHERNET_3_BASEADDR,
    XPAR_PSU_ETHERNET_3_IS_CACHE_COHERENT,
    XPAR_PSU_ETHERNET_3_ENET_SLCR_1000MBPS_DIV0,
    XPAR_PSU_ETHERNET_3_ENET_SLCR_1000MBPS_DIV1,
    XPAR_PSU_ETHERNET_3_ENET_SLCR_100MBPS_DIV0,
    XPAR_PSU_ETHERNET_3_ENET_SLCR_100MBPS_DIV1,
    XPAR_PSU_ETHERNET_3_ENET_SLCR_10MBPS_DIV0,
    XPAR_PSU_ETHERNET_3_ENET_SLCR_10MBPS_DIV1
  },
  {
    XPAR_PSU_ETHERNET_2_DEVICE_ID,
    XPAR_PSU_ETHERNET_2_BASEADDR,
    XPAR_PSU_ETHERNET_2_IS_CACHE_COHERENT,
    XPAR_PSU_ETHERNET_2_ENET_SLCR_1000MBPS_DIV0,
    XPAR_PSU_ETHERNET_2_ENET_SLCR_1000MBPS_DIV1,
    XPAR_PSU_ETHERNET_2_ENET_SLCR_100MBPS_DIV0,
    XPAR_PSU_ETHERNET_2_ENET_SLCR_100MBPS_DIV1,
    XPAR_PSU_ETHERNET_2_ENET_SLCR_10MBPS_DIV0,
    XPAR_PSU_ETHERNET_2_ENET_SLCR_10MBPS_DIV1
  },
  {
    XPAR_PSU_ETHERNET_1_DEVICE_ID,
    XPAR_PSU_ETHERNET_1_BASEADDR,
    XPAR_PSU_ETHERNET_1_IS_CACHE_COHERENT,
    XPAR_PSU_ETHERNET_1_ENET_SLCR_1000MBPS_DIV0,
    XPAR_PSU_ETHERNET_1_ENET_SLCR_1000MBPS_DIV1,
    XPAR_PSU_ETHERNET_1_ENET_SLCR_100MBPS_DIV0,
    XPAR_PSU_ETHERNET_1_ENET_SLCR_100MBPS_DIV1,
    XPAR_PSU_ETHERNET_1_ENET_SLCR_10MBPS_DIV0,
    XPAR_PSU_ETHERNET_1_ENET_SLCR_10MBPS_DIV1
  },
  {
    XPAR_PSU_ETHERNET_0_DEVICE_ID,
    XPAR_PSU_ETHERNET_0_BASEADDR,
    XPAR_PSU_ETHERNET_0_IS_CACHE_COHERENT,
    XPAR_PSU_ETHERNET_0_ENET_SLCR_1000MBPS_DIV0,
    XPAR_PSU_ETHERNET_0_ENET_SLCR_1000MBPS_DIV1,
    XPAR_PSU_ETHERNET_0_ENET_SLCR_100MBPS_DIV0,
    XPAR_PSU_ETHERNET_0_ENET_SLCR_100MBPS_DIV1,
    XPAR_PSU_ETHERNET_0_ENET_SLCR_10MBPS_DIV0,
    XPAR_PSU_ETHERNET_0_ENET_SLCR_10MBPS_DIV1
  },
};
