/*
 * QEMU model of the PMC JTAG TAP. This is just a dummy model with the
 *     PLATFORM_VERSION set to QEMU.
 *
 * Copyright (c) 2017 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2017-04-17.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "hw/irq.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "chardev/char.h"
#include "chardev/char-fe.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "hw/qdev-properties-system.h"

#ifndef XILINX_PMC_TAP_ERR_DEBUG
#define XILINX_PMC_TAP_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMC_TAP "xlnx,pmc-tap"

#define XILINX_PMC_TAP(obj) \
     OBJECT_CHECK(PMC_TAP, (obj), TYPE_XILINX_PMC_TAP)
#define PLATFORM_VERSION_QEMU   0x3

#define MAX_SEC_PAYLOAD (4 * 512)

#define DPRINT(args, ...) \
    do { \
        if (XILINX_PMC_TAP_ERR_DEBUG) { \
            qemu_log("%s: " args, __func__, ## __VA_ARGS__); \
        } \
    } while (0)


REG32(IDCODE, 0x0)
    FIELD(IDCODE, IDCODE, 0, 32)
REG32(VERSION, 0x4)
    FIELD(VERSION, PLATFORM_VERSION, 28, 4)
    FIELD(VERSION, PLATFORM, 24, 4)
    FIELD(VERSION, RTL_VERSION, 16, 8)
    FIELD(VERSION, PS_VERSION, 8, 8)
    FIELD(VERSION, PMC_VERSION, 0, 8)
REG32(USERCODE, 0x8)
REG32(PMC_TAP_INT_STATUS, 0xc)
    FIELD(PMC_TAP_INT_STATUS, TAMPER_DETECT, 4, 1)
    FIELD(PMC_TAP_INT_STATUS, ENUM_DETECT, 3, 1)
    FIELD(PMC_TAP_INT_STATUS, JRDBK_ERR, 2, 1)
    FIELD(PMC_TAP_INT_STATUS, JCFG_ERR, 1, 1)
    FIELD(PMC_TAP_INT_STATUS, TOGGLE_DETECT, 0, 1)
REG32(PMC_TAP_INT_MASK, 0x10)
    FIELD(PMC_TAP_INT_MASK, TAMPER_DETECT, 4, 1)
    FIELD(PMC_TAP_INT_MASK, ENUM_DETECT, 3, 1)
    FIELD(PMC_TAP_INT_MASK, JRDBK_ERR, 2, 1)
    FIELD(PMC_TAP_INT_MASK, JCFG_ERR, 1, 1)
    FIELD(PMC_TAP_INT_MASK, TOGGLE_DETECT, 0, 1)
REG32(PMC_TAP_INT_EN, 0x14)
    FIELD(PMC_TAP_INT_EN, TAMPER_DETECT, 4, 1)
    FIELD(PMC_TAP_INT_EN, ENUM_DETECT, 3, 1)
    FIELD(PMC_TAP_INT_EN, JRDBK_ERR, 2, 1)
    FIELD(PMC_TAP_INT_EN, JCFG_ERR, 1, 1)
    FIELD(PMC_TAP_INT_EN, TOGGLE_DETECT, 0, 1)
REG32(PMC_TAP_INT_DIS, 0x18)
    FIELD(PMC_TAP_INT_DIS, TAMPER_DETECT, 4, 1)
    FIELD(PMC_TAP_INT_DIS, ENUM_DETECT, 3, 1)
    FIELD(PMC_TAP_INT_DIS, JRDBK_ERR, 2, 1)
    FIELD(PMC_TAP_INT_DIS, JCFG_ERR, 1, 1)
    FIELD(PMC_TAP_INT_DIS, TOGGLE_DETECT, 0, 1)
REG32(DPC_MUX_SEL, 0x20)
    FIELD(DPC_MUX_SEL, VAL, 0, 2)
REG32(SLR_TYPE, 0x24)
    FIELD(SLR_TYPE, VAL, 0, 3)
REG32(INST_MASK_0, 0x10000)
    FIELD(INST_MASK_0, STATUS, 31, 1)
    FIELD(INST_MASK_0, PMCTP_CTRL, 30, 1)
    FIELD(INST_MASK_0, UNUSED_29, 29, 1)
    FIELD(INST_MASK_0, UNUSED_28, 28, 1)
    FIELD(INST_MASK_0, UNUSED_27, 27, 1)
    FIELD(INST_MASK_0, UNUSED_26, 26, 1)
    FIELD(INST_MASK_0, IPDISABLE, 25, 1)
    FIELD(INST_MASK_0, UNUSED_24, 24, 1)
    FIELD(INST_MASK_0, UNUSED_23, 23, 1)
    FIELD(INST_MASK_0, UNUSED_22, 22, 1)
    FIELD(INST_MASK_0, UNUSED_21, 21, 1)
    FIELD(INST_MASK_0, UNUSED_20, 20, 1)
    FIELD(INST_MASK_0, UNUSED_19, 19, 1)
    FIELD(INST_MASK_0, UNUSED_18, 18, 1)
    FIELD(INST_MASK_0, UNUSED_17, 17, 1)
    FIELD(INST_MASK_0, UNUSED_16, 16, 1)
    FIELD(INST_MASK_0, UNUSED_15, 15, 1)
    FIELD(INST_MASK_0, UNUSED_14, 14, 1)
    FIELD(INST_MASK_0, UNUSED_13, 13, 1)
    FIELD(INST_MASK_0, UNUSED_12, 12, 1)
    FIELD(INST_MASK_0, UNUSED_11, 11, 1)
    FIELD(INST_MASK_0, HIGHZ, 10, 1)
    FIELD(INST_MASK_0, IDCODE, 9, 1)
    FIELD(INST_MASK_0, USERCODE, 8, 1)
    FIELD(INST_MASK_0, UNUSED_7, 7, 1)
    FIELD(INST_MASK_0, UNUSED_6, 6, 1)
    FIELD(INST_MASK_0, JCONFIG, 5, 1)
    FIELD(INST_MASK_0, JRDBK, 4, 1)
    FIELD(INST_MASK_0, USER2, 3, 1)
    FIELD(INST_MASK_0, USER1, 2, 1)
    FIELD(INST_MASK_0, SAMPLE, 1, 1)
    FIELD(INST_MASK_0, UNUSED_0, 0, 1)
REG32(INST_MASK_1, 0x10004)
    FIELD(INST_MASK_1, BYPASS, 31, 1)
    FIELD(INST_MASK_1, ERROR_STATUS, 30, 1)
    FIELD(INST_MASK_1, EXTEST_TRAIN, 29, 1)
    FIELD(INST_MASK_1, EXTEST_PULSE, 28, 1)
    FIELD(INST_MASK_1, SLAVE_BYPASS, 27, 1)
    FIELD(INST_MASK_1, IJTAG, 26, 1)
    FIELD(INST_MASK_1, TEST_XOSC_CTRL, 25, 1)
    FIELD(INST_MASK_1, UNUSED_56, 24, 1)
    FIELD(INST_MASK_1, SYS_RST, 23, 1)
    FIELD(INST_MASK_1, DPC, 22, 1)
    FIELD(INST_MASK_1, SEC_DBG, 21, 1)
    FIELD(INST_MASK_1, UNUSED_52, 20, 1)
    FIELD(INST_MASK_1, UNUSED_51, 19, 1)
    FIELD(INST_MASK_1, READ_DNA, 18, 1)
    FIELD(INST_MASK_1, UNUSED_49, 17, 1)
    FIELD(INST_MASK_1, UNUSED_48, 16, 1)
    FIELD(INST_MASK_1, UNUSED_47, 15, 1)
    FIELD(INST_MASK_1, UNUSED_46, 14, 1)
    FIELD(INST_MASK_1, UNUSED_45, 13, 1)
    FIELD(INST_MASK_1, UNUSED_44, 12, 1)
    FIELD(INST_MASK_1, UNUSED_43, 11, 1)
    FIELD(INST_MASK_1, UNUSED_42, 10, 1)
    FIELD(INST_MASK_1, UNUSED_41, 9, 1)
    FIELD(INST_MASK_1, UNUSED_40, 8, 1)
    FIELD(INST_MASK_1, UNUSED_39, 7, 1)
    FIELD(INST_MASK_1, EXTEST, 6, 1)
    FIELD(INST_MASK_1, SLAVE_IDCODE, 5, 1)
    FIELD(INST_MASK_1, FEEDTHRU, 4, 1)
    FIELD(INST_MASK_1, USER4, 3, 1)
    FIELD(INST_MASK_1, USER3, 2, 1)
    FIELD(INST_MASK_1, TEST_CTRL, 1, 1)
    FIELD(INST_MASK_1, UNUSED_32, 0, 1)
REG32(DAP_CFG, 0x10008)
    FIELD(DAP_CFG, SPNIDEN, 3, 1)
    FIELD(DAP_CFG, SPIDEN, 2, 1)
    FIELD(DAP_CFG, NIDEN, 1, 1)
    FIELD(DAP_CFG, DBGEN, 0, 1)
REG32(DAP_SECURITY, 0x1000c)
REG32(JTAG_CTRL, 0x10010)
    FIELD(JTAG_CTRL, TOGGLE_DET_EN, 0, 1)
REG32(JTAG_TEST, 0x10014)
    FIELD(JTAG_TEST, MJTAG_EN, 0, 1)
REG32(SEC_DBG_INT_STATUS, 0x10018)
    FIELD(SEC_DBG_INT_STATUS, SEC_DBG, 0, 1)
REG32(SEC_DBG_INT_MASK, 0x1001c)
    FIELD(SEC_DBG_INT_MASK, SEC_DBG, 0, 1)
REG32(SEC_DBG_INT_EN, 0x10020)
    FIELD(SEC_DBG_INT_EN, SEC_DBG, 0, 1)
REG32(SEC_DBG_INT_DIS, 0x10024)
    FIELD(SEC_DBG_INT_DIS, SEC_DBG, 0, 1)
REG32(SEC_DBG_DATA_0, 0x10030)
REG32(SEC_DBG_DATA_1, 0x10034)
REG32(SEC_DBG_DATA_2, 0x10038)
REG32(SEC_DBG_DATA_3, 0x1003c)
REG32(SEC_DBG_DATA_4, 0x10040)
REG32(SEC_DBG_DATA_5, 0x10044)
REG32(SEC_DBG_DATA_6, 0x10048)
REG32(SEC_DBG_DATA_7, 0x1004c)
REG32(SEC_DBG_DATA_8, 0x10050)
REG32(SEC_DBG_DATA_9, 0x10054)
REG32(SEC_DBG_DATA_10, 0x10058)
REG32(SEC_DBG_DATA_11, 0x1005c)
REG32(SEC_DBG_DATA_12, 0x10060)
REG32(SEC_DBG_DATA_13, 0x10064)
REG32(SEC_DBG_DATA_14, 0x10068)
REG32(SEC_DBG_DATA_15, 0x1006c)
REG32(SEC_DBG_DATA_16, 0x10070)
REG32(SEC_DBG_DATA_17, 0x10074)
REG32(SEC_DBG_DATA_18, 0x10078)
REG32(SEC_DBG_DATA_19, 0x1007c)
REG32(SEC_DBG_DATA_20, 0x10080)
REG32(SEC_DBG_DATA_21, 0x10084)
REG32(SEC_DBG_DATA_22, 0x10088)
REG32(SEC_DBG_DATA_23, 0x1008c)
REG32(SEC_DBG_DATA_24, 0x10090)
REG32(SEC_DBG_DATA_25, 0x10094)
REG32(SEC_DBG_DATA_26, 0x10098)
REG32(SEC_DBG_DATA_27, 0x1009c)
REG32(SEC_DBG_DATA_28, 0x100a0)
REG32(SEC_DBG_DATA_29, 0x100a4)
REG32(SEC_DBG_DATA_30, 0x100a8)
REG32(SEC_DBG_DATA_31, 0x100ac)
REG32(SEC_DBG_DATA_32, 0x100b0)
REG32(SEC_DBG_DATA_33, 0x100b4)
REG32(SEC_DBG_DATA_34, 0x100b8)
REG32(SEC_DBG_DATA_35, 0x100bc)
REG32(SEC_DBG_DATA_36, 0x100c0)
REG32(SEC_DBG_DATA_37, 0x100c4)
REG32(SEC_DBG_DATA_38, 0x100c8)
REG32(SEC_DBG_DATA_39, 0x100cc)
REG32(SEC_DBG_DATA_40, 0x100d0)
REG32(SEC_DBG_DATA_41, 0x100d4)
REG32(SEC_DBG_DATA_42, 0x100d8)
REG32(SEC_DBG_DATA_43, 0x100dc)
REG32(SEC_DBG_DATA_44, 0x100e0)
REG32(SEC_DBG_DATA_45, 0x100e4)
REG32(SEC_DBG_DATA_46, 0x100e8)
REG32(SEC_DBG_DATA_47, 0x100ec)
REG32(SEC_DBG_DATA_48, 0x100f0)
REG32(SEC_DBG_DATA_49, 0x100f4)
REG32(SEC_DBG_DATA_50, 0x100f8)
REG32(SEC_DBG_DATA_51, 0x100fc)
REG32(SEC_DBG_DATA_52, 0x10100)
REG32(SEC_DBG_DATA_53, 0x10104)
REG32(SEC_DBG_DATA_54, 0x10108)
REG32(SEC_DBG_DATA_55, 0x1010c)
REG32(SEC_DBG_DATA_56, 0x10110)
REG32(SEC_DBG_DATA_57, 0x10114)
REG32(SEC_DBG_DATA_58, 0x10118)
REG32(SEC_DBG_DATA_59, 0x1011c)
REG32(SEC_DBG_DATA_60, 0x10120)
REG32(SEC_DBG_DATA_61, 0x10124)
REG32(SEC_DBG_DATA_62, 0x10128)
REG32(SEC_DBG_DATA_63, 0x1012c)
REG32(SEC_DBG_DATA_64, 0x10130)
REG32(SEC_DBG_DATA_65, 0x10134)
REG32(SEC_DBG_DATA_66, 0x10138)
REG32(SEC_DBG_DATA_67, 0x1013c)
REG32(SEC_DBG_DATA_68, 0x10140)
REG32(SEC_DBG_DATA_69, 0x10144)
REG32(SEC_DBG_DATA_70, 0x10148)
REG32(SEC_DBG_DATA_71, 0x1014c)
REG32(SEC_DBG_DATA_72, 0x10150)
REG32(SEC_DBG_DATA_73, 0x10154)
REG32(SEC_DBG_DATA_74, 0x10158)
REG32(SEC_DBG_DATA_75, 0x1015c)
REG32(SEC_DBG_DATA_76, 0x10160)
REG32(SEC_DBG_DATA_77, 0x10164)
REG32(SEC_DBG_DATA_78, 0x10168)
REG32(SEC_DBG_DATA_79, 0x1016c)
REG32(SEC_DBG_DATA_80, 0x10170)
REG32(SEC_DBG_DATA_81, 0x10174)
REG32(SEC_DBG_DATA_82, 0x10178)
REG32(SEC_DBG_DATA_83, 0x1017c)
REG32(SEC_DBG_DATA_84, 0x10180)
REG32(SEC_DBG_DATA_85, 0x10184)
REG32(SEC_DBG_DATA_86, 0x10188)
REG32(SEC_DBG_DATA_87, 0x1018c)
REG32(SEC_DBG_DATA_88, 0x10190)
REG32(SEC_DBG_DATA_89, 0x10194)
REG32(SEC_DBG_DATA_90, 0x10198)
REG32(SEC_DBG_DATA_91, 0x1019c)
REG32(SEC_DBG_DATA_92, 0x101a0)
REG32(SEC_DBG_DATA_93, 0x101a4)
REG32(SEC_DBG_DATA_94, 0x101a8)
REG32(SEC_DBG_DATA_95, 0x101ac)
REG32(SEC_DBG_DATA_96, 0x101b0)
REG32(SEC_DBG_DATA_97, 0x101b4)
REG32(SEC_DBG_DATA_98, 0x101b8)
REG32(SEC_DBG_DATA_99, 0x101bc)
REG32(SEC_DBG_DATA_100, 0x101c0)
REG32(SEC_DBG_DATA_101, 0x101c4)
REG32(SEC_DBG_DATA_102, 0x101c8)
REG32(SEC_DBG_DATA_103, 0x101cc)
REG32(SEC_DBG_DATA_104, 0x101d0)
REG32(SEC_DBG_DATA_105, 0x101d4)
REG32(SEC_DBG_DATA_106, 0x101d8)
REG32(SEC_DBG_DATA_107, 0x101dc)
REG32(SEC_DBG_DATA_108, 0x101e0)
REG32(SEC_DBG_DATA_109, 0x101e4)
REG32(SEC_DBG_DATA_110, 0x101e8)
REG32(SEC_DBG_DATA_111, 0x101ec)
REG32(SEC_DBG_DATA_112, 0x101f0)
REG32(SEC_DBG_DATA_113, 0x101f4)
REG32(SEC_DBG_DATA_114, 0x101f8)
REG32(SEC_DBG_DATA_115, 0x101fc)
REG32(SEC_DBG_DATA_116, 0x10200)
REG32(SEC_DBG_DATA_117, 0x10204)
REG32(SEC_DBG_DATA_118, 0x10208)
REG32(SEC_DBG_DATA_119, 0x1020c)
REG32(SEC_DBG_DATA_120, 0x10210)
REG32(SEC_DBG_DATA_121, 0x10214)
REG32(SEC_DBG_DATA_122, 0x10218)
REG32(SEC_DBG_DATA_123, 0x1021c)
REG32(SEC_DBG_DATA_124, 0x10220)
REG32(SEC_DBG_DATA_125, 0x10224)
REG32(SEC_DBG_DATA_126, 0x10228)
REG32(SEC_DBG_DATA_127, 0x1022c)
REG32(SEC_DBG_DATA_128, 0x10230)
REG32(SEC_DBG_DATA_129, 0x10234)
REG32(SEC_DBG_DATA_130, 0x10238)
REG32(SEC_DBG_DATA_131, 0x1023c)
REG32(SEC_DBG_DATA_132, 0x10240)
REG32(SEC_DBG_DATA_133, 0x10244)
REG32(SEC_DBG_DATA_134, 0x10248)
REG32(SEC_DBG_DATA_135, 0x1024c)
REG32(SEC_DBG_DATA_136, 0x10250)
REG32(SEC_DBG_DATA_137, 0x10254)
REG32(SEC_DBG_DATA_138, 0x10258)
REG32(SEC_DBG_DATA_139, 0x1025c)
REG32(SEC_DBG_DATA_140, 0x10260)
REG32(SEC_DBG_DATA_141, 0x10264)
REG32(SEC_DBG_DATA_142, 0x10268)
REG32(SEC_DBG_DATA_143, 0x1026c)
REG32(SEC_DBG_DATA_144, 0x10270)
REG32(SEC_DBG_DATA_145, 0x10274)
REG32(SEC_DBG_DATA_146, 0x10278)
REG32(SEC_DBG_DATA_147, 0x1027c)
REG32(SEC_DBG_DATA_148, 0x10280)
REG32(SEC_DBG_DATA_149, 0x10284)
REG32(SEC_DBG_DATA_150, 0x10288)
REG32(SEC_DBG_DATA_151, 0x1028c)
REG32(SEC_DBG_DATA_152, 0x10290)
REG32(SEC_DBG_DATA_153, 0x10294)
REG32(SEC_DBG_DATA_154, 0x10298)
REG32(SEC_DBG_DATA_155, 0x1029c)
REG32(SEC_DBG_DATA_156, 0x102a0)
REG32(SEC_DBG_DATA_157, 0x102a4)
REG32(SEC_DBG_DATA_158, 0x102a8)
REG32(SEC_DBG_DATA_159, 0x102ac)
REG32(SEC_DBG_DATA_160, 0x102b0)
REG32(SEC_DBG_DATA_161, 0x102b4)
REG32(SEC_DBG_DATA_162, 0x102b8)
REG32(SEC_DBG_DATA_163, 0x102bc)
REG32(SEC_DBG_DATA_164, 0x102c0)
REG32(SEC_DBG_DATA_165, 0x102c4)
REG32(SEC_DBG_DATA_166, 0x102c8)
REG32(SEC_DBG_DATA_167, 0x102cc)
REG32(SEC_DBG_DATA_168, 0x102d0)
REG32(SEC_DBG_DATA_169, 0x102d4)
REG32(SEC_DBG_DATA_170, 0x102d8)
REG32(SEC_DBG_DATA_171, 0x102dc)
REG32(SEC_DBG_DATA_172, 0x102e0)
REG32(SEC_DBG_DATA_173, 0x102e4)
REG32(SEC_DBG_DATA_174, 0x102e8)
REG32(SEC_DBG_DATA_175, 0x102ec)
REG32(SEC_DBG_DATA_176, 0x102f0)
REG32(SEC_DBG_DATA_177, 0x102f4)
REG32(SEC_DBG_DATA_178, 0x102f8)
REG32(SEC_DBG_DATA_179, 0x102fc)
REG32(SEC_DBG_DATA_180, 0x10300)
REG32(SEC_DBG_DATA_181, 0x10304)
REG32(SEC_DBG_DATA_182, 0x10308)
REG32(SEC_DBG_DATA_183, 0x1030c)
REG32(SEC_DBG_DATA_184, 0x10310)
REG32(SEC_DBG_DATA_185, 0x10314)
REG32(SEC_DBG_DATA_186, 0x10318)
REG32(SEC_DBG_DATA_187, 0x1031c)
REG32(SEC_DBG_DATA_188, 0x10320)
REG32(SEC_DBG_DATA_189, 0x10324)
REG32(SEC_DBG_DATA_190, 0x10328)
REG32(SEC_DBG_DATA_191, 0x1032c)
REG32(SEC_DBG_DATA_192, 0x10330)
REG32(SEC_DBG_DATA_193, 0x10334)
REG32(SEC_DBG_DATA_194, 0x10338)
REG32(SEC_DBG_DATA_195, 0x1033c)
REG32(SEC_DBG_DATA_196, 0x10340)
REG32(SEC_DBG_DATA_197, 0x10344)
REG32(SEC_DBG_DATA_198, 0x10348)
REG32(SEC_DBG_DATA_199, 0x1034c)
REG32(SEC_DBG_DATA_200, 0x10350)
REG32(SEC_DBG_DATA_201, 0x10354)
REG32(SEC_DBG_DATA_202, 0x10358)
REG32(SEC_DBG_DATA_203, 0x1035c)
REG32(SEC_DBG_DATA_204, 0x10360)
REG32(SEC_DBG_DATA_205, 0x10364)
REG32(SEC_DBG_DATA_206, 0x10368)
REG32(SEC_DBG_DATA_207, 0x1036c)
REG32(SEC_DBG_DATA_208, 0x10370)
REG32(SEC_DBG_DATA_209, 0x10374)
REG32(SEC_DBG_DATA_210, 0x10378)
REG32(SEC_DBG_DATA_211, 0x1037c)
REG32(SEC_DBG_DATA_212, 0x10380)
REG32(SEC_DBG_DATA_213, 0x10384)
REG32(SEC_DBG_DATA_214, 0x10388)
REG32(SEC_DBG_DATA_215, 0x1038c)
REG32(SEC_DBG_DATA_216, 0x10390)
REG32(SEC_DBG_DATA_217, 0x10394)
REG32(SEC_DBG_DATA_218, 0x10398)
REG32(SEC_DBG_DATA_219, 0x1039c)
REG32(SEC_DBG_DATA_220, 0x103a0)
REG32(SEC_DBG_DATA_221, 0x103a4)
REG32(SEC_DBG_DATA_222, 0x103a8)
REG32(SEC_DBG_DATA_223, 0x103ac)
REG32(SEC_DBG_DATA_224, 0x103b0)
REG32(SEC_DBG_DATA_225, 0x103b4)
REG32(SEC_DBG_DATA_226, 0x103b8)
REG32(SEC_DBG_DATA_227, 0x103bc)
REG32(SEC_DBG_DATA_228, 0x103c0)
REG32(SEC_DBG_DATA_229, 0x103c4)
REG32(SEC_DBG_DATA_230, 0x103c8)
REG32(SEC_DBG_DATA_231, 0x103cc)
REG32(SEC_DBG_DATA_232, 0x103d0)
REG32(SEC_DBG_DATA_233, 0x103d4)
REG32(SEC_DBG_DATA_234, 0x103d8)
REG32(SEC_DBG_DATA_235, 0x103dc)
REG32(SEC_DBG_DATA_236, 0x103e0)
REG32(SEC_DBG_DATA_237, 0x103e4)
REG32(SEC_DBG_DATA_238, 0x103e8)
REG32(SEC_DBG_DATA_239, 0x103ec)
REG32(SEC_DBG_DATA_240, 0x103f0)
REG32(SEC_DBG_DATA_241, 0x103f4)
REG32(SEC_DBG_DATA_242, 0x103f8)
REG32(SEC_DBG_DATA_243, 0x103fc)
REG32(SEC_DBG_DATA_244, 0x10400)
REG32(SEC_DBG_DATA_245, 0x10404)
REG32(SEC_DBG_DATA_246, 0x10408)
REG32(SEC_DBG_DATA_247, 0x1040c)
REG32(SEC_DBG_DATA_248, 0x10410)
REG32(SEC_DBG_DATA_249, 0x10414)
REG32(SEC_DBG_DATA_250, 0x10418)
REG32(SEC_DBG_DATA_251, 0x1041c)
REG32(SEC_DBG_DATA_252, 0x10420)
REG32(SEC_DBG_DATA_253, 0x10424)
REG32(SEC_DBG_DATA_254, 0x10428)
REG32(SEC_DBG_DATA_255, 0x1042c)
REG32(SEC_DBG_DATA_256, 0x10430)
REG32(SEC_DBG_DATA_257, 0x10434)
REG32(SEC_DBG_DATA_258, 0x10438)
REG32(SEC_DBG_DATA_259, 0x1043c)
REG32(SEC_DBG_DATA_260, 0x10440)
REG32(SEC_DBG_DATA_261, 0x10444)
REG32(SEC_DBG_DATA_262, 0x10448)
REG32(SEC_DBG_DATA_263, 0x1044c)
REG32(SEC_DBG_DATA_264, 0x10450)
REG32(SEC_DBG_DATA_265, 0x10454)
REG32(SEC_DBG_DATA_266, 0x10458)
REG32(SEC_DBG_DATA_267, 0x1045c)
REG32(SEC_DBG_DATA_268, 0x10460)
REG32(SEC_DBG_DATA_269, 0x10464)
REG32(SEC_DBG_DATA_270, 0x10468)
REG32(SEC_DBG_DATA_271, 0x1046c)
REG32(SEC_DBG_DATA_272, 0x10470)
REG32(SEC_DBG_DATA_273, 0x10474)
REG32(SEC_DBG_DATA_274, 0x10478)
REG32(SEC_DBG_DATA_275, 0x1047c)
REG32(SEC_DBG_DATA_276, 0x10480)
REG32(SEC_DBG_DATA_277, 0x10484)
REG32(SEC_DBG_DATA_278, 0x10488)
REG32(SEC_DBG_DATA_279, 0x1048c)
REG32(SEC_DBG_DATA_280, 0x10490)
REG32(SEC_DBG_DATA_281, 0x10494)
REG32(SEC_DBG_DATA_282, 0x10498)
REG32(SEC_DBG_DATA_283, 0x1049c)
REG32(SEC_DBG_DATA_284, 0x104a0)
REG32(SEC_DBG_DATA_285, 0x104a4)
REG32(SEC_DBG_DATA_286, 0x104a8)
REG32(SEC_DBG_DATA_287, 0x104ac)
REG32(SEC_DBG_DATA_288, 0x104b0)
REG32(SEC_DBG_DATA_289, 0x104b4)
REG32(SEC_DBG_DATA_290, 0x104b8)
REG32(SEC_DBG_DATA_291, 0x104bc)
REG32(SEC_DBG_DATA_292, 0x104c0)
REG32(SEC_DBG_DATA_293, 0x104c4)
REG32(SEC_DBG_DATA_294, 0x104c8)
REG32(SEC_DBG_DATA_295, 0x104cc)
REG32(SEC_DBG_DATA_296, 0x104d0)
REG32(SEC_DBG_DATA_297, 0x104d4)
REG32(SEC_DBG_DATA_298, 0x104d8)
REG32(SEC_DBG_DATA_299, 0x104dc)
REG32(SEC_DBG_DATA_300, 0x104e0)
REG32(SEC_DBG_DATA_301, 0x104e4)
REG32(SEC_DBG_DATA_302, 0x104e8)
REG32(SEC_DBG_DATA_303, 0x104ec)
REG32(SEC_DBG_DATA_304, 0x104f0)
REG32(SEC_DBG_DATA_305, 0x104f4)
REG32(SEC_DBG_DATA_306, 0x104f8)
REG32(SEC_DBG_DATA_307, 0x104fc)
REG32(SEC_DBG_DATA_308, 0x10500)
REG32(SEC_DBG_DATA_309, 0x10504)
REG32(SEC_DBG_DATA_310, 0x10508)
REG32(SEC_DBG_DATA_311, 0x1050c)
REG32(SEC_DBG_DATA_312, 0x10510)
REG32(SEC_DBG_DATA_313, 0x10514)
REG32(SEC_DBG_DATA_314, 0x10518)
REG32(SEC_DBG_DATA_315, 0x1051c)
REG32(SEC_DBG_DATA_316, 0x10520)
REG32(SEC_DBG_DATA_317, 0x10524)
REG32(SEC_DBG_DATA_318, 0x10528)
REG32(SEC_DBG_DATA_319, 0x1052c)
REG32(SEC_DBG_DATA_320, 0x10530)
REG32(SEC_DBG_DATA_321, 0x10534)
REG32(SEC_DBG_DATA_322, 0x10538)
REG32(SEC_DBG_DATA_323, 0x1053c)
REG32(SEC_DBG_DATA_324, 0x10540)
REG32(SEC_DBG_DATA_325, 0x10544)
REG32(SEC_DBG_DATA_326, 0x10548)
REG32(SEC_DBG_DATA_327, 0x1054c)
REG32(SEC_DBG_DATA_328, 0x10550)
REG32(SEC_DBG_DATA_329, 0x10554)
REG32(SEC_DBG_DATA_330, 0x10558)
REG32(SEC_DBG_DATA_331, 0x1055c)
REG32(SEC_DBG_DATA_332, 0x10560)
REG32(SEC_DBG_DATA_333, 0x10564)
REG32(SEC_DBG_DATA_334, 0x10568)
REG32(SEC_DBG_DATA_335, 0x1056c)
REG32(SEC_DBG_DATA_336, 0x10570)
REG32(SEC_DBG_DATA_337, 0x10574)
REG32(SEC_DBG_DATA_338, 0x10578)
REG32(SEC_DBG_DATA_339, 0x1057c)
REG32(SEC_DBG_DATA_340, 0x10580)
REG32(SEC_DBG_DATA_341, 0x10584)
REG32(SEC_DBG_DATA_342, 0x10588)
REG32(SEC_DBG_DATA_343, 0x1058c)
REG32(SEC_DBG_DATA_344, 0x10590)
REG32(SEC_DBG_DATA_345, 0x10594)
REG32(SEC_DBG_DATA_346, 0x10598)
REG32(SEC_DBG_DATA_347, 0x1059c)
REG32(SEC_DBG_DATA_348, 0x105a0)
REG32(SEC_DBG_DATA_349, 0x105a4)
REG32(SEC_DBG_DATA_350, 0x105a8)
REG32(SEC_DBG_DATA_351, 0x105ac)
REG32(SEC_DBG_DATA_352, 0x105b0)
REG32(SEC_DBG_DATA_353, 0x105b4)
REG32(SEC_DBG_DATA_354, 0x105b8)
REG32(SEC_DBG_DATA_355, 0x105bc)
REG32(SEC_DBG_DATA_356, 0x105c0)
REG32(SEC_DBG_DATA_357, 0x105c4)
REG32(SEC_DBG_DATA_358, 0x105c8)
REG32(SEC_DBG_DATA_359, 0x105cc)
REG32(SEC_DBG_DATA_360, 0x105d0)
REG32(SEC_DBG_DATA_361, 0x105d4)
REG32(SEC_DBG_DATA_362, 0x105d8)
REG32(SEC_DBG_DATA_363, 0x105dc)
REG32(SEC_DBG_DATA_364, 0x105e0)
REG32(SEC_DBG_DATA_365, 0x105e4)
REG32(SEC_DBG_DATA_366, 0x105e8)
REG32(SEC_DBG_DATA_367, 0x105ec)
REG32(SEC_DBG_DATA_368, 0x105f0)
REG32(SEC_DBG_DATA_369, 0x105f4)
REG32(SEC_DBG_DATA_370, 0x105f8)
REG32(SEC_DBG_DATA_371, 0x105fc)
REG32(SEC_DBG_DATA_372, 0x10600)
REG32(SEC_DBG_DATA_373, 0x10604)
REG32(SEC_DBG_DATA_374, 0x10608)
REG32(SEC_DBG_DATA_375, 0x1060c)
REG32(SEC_DBG_DATA_376, 0x10610)
REG32(SEC_DBG_DATA_377, 0x10614)
REG32(SEC_DBG_DATA_378, 0x10618)
REG32(SEC_DBG_DATA_379, 0x1061c)
REG32(SEC_DBG_DATA_380, 0x10620)
REG32(SEC_DBG_DATA_381, 0x10624)
REG32(SEC_DBG_DATA_382, 0x10628)
REG32(SEC_DBG_DATA_383, 0x1062c)
REG32(SEC_DBG_DATA_384, 0x10630)
REG32(SEC_DBG_DATA_385, 0x10634)
REG32(SEC_DBG_DATA_386, 0x10638)
REG32(SEC_DBG_DATA_387, 0x1063c)
REG32(SEC_DBG_DATA_388, 0x10640)
REG32(SEC_DBG_DATA_389, 0x10644)
REG32(SEC_DBG_DATA_390, 0x10648)
REG32(SEC_DBG_DATA_391, 0x1064c)
REG32(SEC_DBG_DATA_392, 0x10650)
REG32(SEC_DBG_DATA_393, 0x10654)
REG32(SEC_DBG_DATA_394, 0x10658)
REG32(SEC_DBG_DATA_395, 0x1065c)
REG32(SEC_DBG_DATA_396, 0x10660)
REG32(SEC_DBG_DATA_397, 0x10664)
REG32(SEC_DBG_DATA_398, 0x10668)
REG32(SEC_DBG_DATA_399, 0x1066c)
REG32(SEC_DBG_DATA_400, 0x10670)
REG32(SEC_DBG_DATA_401, 0x10674)
REG32(SEC_DBG_DATA_402, 0x10678)
REG32(SEC_DBG_DATA_403, 0x1067c)
REG32(SEC_DBG_DATA_404, 0x10680)
REG32(SEC_DBG_DATA_405, 0x10684)
REG32(SEC_DBG_DATA_406, 0x10688)
REG32(SEC_DBG_DATA_407, 0x1068c)
REG32(SEC_DBG_DATA_408, 0x10690)
REG32(SEC_DBG_DATA_409, 0x10694)
REG32(SEC_DBG_DATA_410, 0x10698)
REG32(SEC_DBG_DATA_411, 0x1069c)
REG32(SEC_DBG_DATA_412, 0x106a0)
REG32(SEC_DBG_DATA_413, 0x106a4)
REG32(SEC_DBG_DATA_414, 0x106a8)
REG32(SEC_DBG_DATA_415, 0x106ac)
REG32(SEC_DBG_DATA_416, 0x106b0)
REG32(SEC_DBG_DATA_417, 0x106b4)
REG32(SEC_DBG_DATA_418, 0x106b8)
REG32(SEC_DBG_DATA_419, 0x106bc)
REG32(SEC_DBG_DATA_420, 0x106c0)
REG32(SEC_DBG_DATA_421, 0x106c4)
REG32(SEC_DBG_DATA_422, 0x106c8)
REG32(SEC_DBG_DATA_423, 0x106cc)
REG32(SEC_DBG_DATA_424, 0x106d0)
REG32(SEC_DBG_DATA_425, 0x106d4)
REG32(SEC_DBG_DATA_426, 0x106d8)
REG32(SEC_DBG_DATA_427, 0x106dc)
REG32(SEC_DBG_DATA_428, 0x106e0)
REG32(SEC_DBG_DATA_429, 0x106e4)
REG32(SEC_DBG_DATA_430, 0x106e8)
REG32(SEC_DBG_DATA_431, 0x106ec)
REG32(SEC_DBG_DATA_432, 0x106f0)
REG32(SEC_DBG_DATA_433, 0x106f4)
REG32(SEC_DBG_DATA_434, 0x106f8)
REG32(SEC_DBG_DATA_435, 0x106fc)
REG32(SEC_DBG_DATA_436, 0x10700)
REG32(SEC_DBG_DATA_437, 0x10704)
REG32(SEC_DBG_DATA_438, 0x10708)
REG32(SEC_DBG_DATA_439, 0x1070c)
REG32(SEC_DBG_DATA_440, 0x10710)
REG32(SEC_DBG_DATA_441, 0x10714)
REG32(SEC_DBG_DATA_442, 0x10718)
REG32(SEC_DBG_DATA_443, 0x1071c)
REG32(SEC_DBG_DATA_444, 0x10720)
REG32(SEC_DBG_DATA_445, 0x10724)
REG32(SEC_DBG_DATA_446, 0x10728)
REG32(SEC_DBG_DATA_447, 0x1072c)
REG32(SEC_DBG_DATA_448, 0x10730)
REG32(SEC_DBG_DATA_449, 0x10734)
REG32(SEC_DBG_DATA_450, 0x10738)
REG32(SEC_DBG_DATA_451, 0x1073c)
REG32(SEC_DBG_DATA_452, 0x10740)
REG32(SEC_DBG_DATA_453, 0x10744)
REG32(SEC_DBG_DATA_454, 0x10748)
REG32(SEC_DBG_DATA_455, 0x1074c)
REG32(SEC_DBG_DATA_456, 0x10750)
REG32(SEC_DBG_DATA_457, 0x10754)
REG32(SEC_DBG_DATA_458, 0x10758)
REG32(SEC_DBG_DATA_459, 0x1075c)
REG32(SEC_DBG_DATA_460, 0x10760)
REG32(SEC_DBG_DATA_461, 0x10764)
REG32(SEC_DBG_DATA_462, 0x10768)
REG32(SEC_DBG_DATA_463, 0x1076c)
REG32(SEC_DBG_DATA_464, 0x10770)
REG32(SEC_DBG_DATA_465, 0x10774)
REG32(SEC_DBG_DATA_466, 0x10778)
REG32(SEC_DBG_DATA_467, 0x1077c)
REG32(SEC_DBG_DATA_468, 0x10780)
REG32(SEC_DBG_DATA_469, 0x10784)
REG32(SEC_DBG_DATA_470, 0x10788)
REG32(SEC_DBG_DATA_471, 0x1078c)
REG32(SEC_DBG_DATA_472, 0x10790)
REG32(SEC_DBG_DATA_473, 0x10794)
REG32(SEC_DBG_DATA_474, 0x10798)
REG32(SEC_DBG_DATA_475, 0x1079c)
REG32(SEC_DBG_DATA_476, 0x107a0)
REG32(SEC_DBG_DATA_477, 0x107a4)
REG32(SEC_DBG_DATA_478, 0x107a8)
REG32(SEC_DBG_DATA_479, 0x107ac)
REG32(SEC_DBG_DATA_480, 0x107b0)
REG32(SEC_DBG_DATA_481, 0x107b4)
REG32(SEC_DBG_DATA_482, 0x107b8)
REG32(SEC_DBG_DATA_483, 0x107bc)
REG32(SEC_DBG_DATA_484, 0x107c0)
REG32(SEC_DBG_DATA_485, 0x107c4)
REG32(SEC_DBG_DATA_486, 0x107c8)
REG32(SEC_DBG_DATA_487, 0x107cc)
REG32(SEC_DBG_DATA_488, 0x107d0)
REG32(SEC_DBG_DATA_489, 0x107d4)
REG32(SEC_DBG_DATA_490, 0x107d8)
REG32(SEC_DBG_DATA_491, 0x107dc)
REG32(SEC_DBG_DATA_492, 0x107e0)
REG32(SEC_DBG_DATA_493, 0x107e4)
REG32(SEC_DBG_DATA_494, 0x107e8)
REG32(SEC_DBG_DATA_495, 0x107ec)
REG32(SEC_DBG_DATA_496, 0x107f0)
REG32(SEC_DBG_DATA_497, 0x107f4)
REG32(SEC_DBG_DATA_498, 0x107f8)
REG32(SEC_DBG_DATA_499, 0x107fc)
REG32(SEC_DBG_DATA_500, 0x10800)
REG32(SEC_DBG_DATA_501, 0x10804)
REG32(SEC_DBG_DATA_502, 0x10808)
REG32(SEC_DBG_DATA_503, 0x1080c)
REG32(SEC_DBG_DATA_504, 0x10810)
REG32(SEC_DBG_DATA_505, 0x10814)
REG32(SEC_DBG_DATA_506, 0x10818)
REG32(SEC_DBG_DATA_507, 0x1081c)
REG32(SEC_DBG_DATA_508, 0x10820)
REG32(SEC_DBG_DATA_509, 0x10824)
REG32(SEC_DBG_DATA_510, 0x10828)
REG32(SEC_DBG_DATA_511, 0x1082c)

#define R_MAX (R_SEC_DBG_DATA_511 + 1)

#define SEC_DBG_DIS_MASK 0x3
#define SEC_LOCK_DBG_DIS_MASK (0x3 << 2)
#define PMC_TAP_SLR_TYPE_MONO 0x7

typedef struct PMC_TAP {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_sec_dbg_int;
    qemu_irq irq_pmc_tap_int;
    CharBackend chr;

    uint8_t platform;
    uint8_t pver;
    uint8_t sec_dbg_dis;
    uint32_t slr_type;
    uint32_t payload_received;
    uint32_t idcode;
    bool auth_data_load;
    bool first_image_done;
    uint32_t regs[R_MAX];
    RegisterInfo regs_info[R_MAX];
} PMC_TAP;

static void sec_dbg_int_update_irq(PMC_TAP *s)
{
    bool pending = s->regs[R_SEC_DBG_INT_STATUS] & ~s->regs[R_SEC_DBG_INT_MASK];
    qemu_set_irq(s->irq_sec_dbg_int, pending);
}

static void sec_dbg_int_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_TAP *s = XILINX_PMC_TAP(reg->opaque);
    sec_dbg_int_update_irq(s);
}

static uint64_t sec_dbg_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_TAP *s = XILINX_PMC_TAP(reg->opaque);
    uint32_t val = val64;

    s->regs[R_SEC_DBG_INT_MASK] &= ~val;
    sec_dbg_int_update_irq(s);
    return 0;
}

static uint64_t sec_dbg_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_TAP *s = XILINX_PMC_TAP(reg->opaque);
    uint32_t val = val64;

    s->regs[R_SEC_DBG_INT_MASK] |= val;
    sec_dbg_int_update_irq(s);
    return 0;
}

static void pmc_tap_int_update_irq(PMC_TAP *s)
{
    bool pending = s->regs[R_PMC_TAP_INT_STATUS] & ~s->regs[R_PMC_TAP_INT_MASK];
    qemu_set_irq(s->irq_pmc_tap_int, pending);
}

static void pmc_tap_int_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_TAP *s = XILINX_PMC_TAP(reg->opaque);
    pmc_tap_int_update_irq(s);
}

static uint64_t pmc_tap_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_TAP *s = XILINX_PMC_TAP(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PMC_TAP_INT_MASK] &= ~val;
    pmc_tap_int_update_irq(s);
    return 0;
}

static uint64_t pmc_tap_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_TAP *s = XILINX_PMC_TAP(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PMC_TAP_INT_MASK] |= val;
    pmc_tap_int_update_irq(s);
    return 0;
}

static RegisterAccessInfo pmc_tap_regs_info[] = {
    {   .name = "IDCODE",  .addr = A_IDCODE,
        .ro = 0xffffffff,
    },{ .name = "VERSION",  .addr = A_VERSION,
        .ro = 0xffffffff,
    },{ .name = "USERCODE",  .addr = A_USERCODE,
    },{ .name = "PMC_TAP_INT_STATUS",  .addr = A_PMC_TAP_INT_STATUS,
        .w1c = 0x1f,
        .post_write = pmc_tap_int_status_postw,
    },{ .name = "PMC_TAP_INT_MASK",  .addr = A_PMC_TAP_INT_MASK,
        .reset = 0x1f,
        .ro = 0x1f,
    },{ .name = "PMC_TAP_INT_EN",  .addr = A_PMC_TAP_INT_EN,
        .pre_write = pmc_tap_int_en_prew,
    },{ .name = "PMC_TAP_INT_DIS",  .addr = A_PMC_TAP_INT_DIS,
        .pre_write = pmc_tap_int_dis_prew,
    },{ .name = "DPC_MUX_SEL",  .addr = A_DPC_MUX_SEL,
    },{ .name = "SLR_TYPE",  .addr = A_SLR_TYPE,
        .ro = 0x7,
    },{ .name = "INST_MASK_0",  .addr = A_INST_MASK_0,
        .reset = 0x3dfff8fd,
    },{ .name = "INST_MASK_1",  .addr = A_INST_MASK_1,
        .reset = 0x1dbff8f,
    },{ .name = "DAP_CFG",  .addr = A_DAP_CFG,
    },{ .name = "DAP_SECURITY",  .addr = A_DAP_SECURITY,
    },{ .name = "JTAG_CTRL",  .addr = A_JTAG_CTRL,
    },{ .name = "JTAG_TEST",  .addr = A_JTAG_TEST,
    },{ .name = "SEC_DBG_INT_STATUS",  .addr = A_SEC_DBG_INT_STATUS,
        .w1c = 0x1,
        .post_write = sec_dbg_int_status_postw,
    },{ .name = "SEC_DBG_INT_MASK",  .addr = A_SEC_DBG_INT_MASK,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "SEC_DBG_INT_EN",  .addr = A_SEC_DBG_INT_EN,
        .pre_write = sec_dbg_int_en_prew,
    },{ .name = "SEC_DBG_INT_DIS",  .addr = A_SEC_DBG_INT_DIS,
        .pre_write = sec_dbg_int_dis_prew,
    },{ .name = "SEC_DBG_DATA_0",  .addr = A_SEC_DBG_DATA_0,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_1",  .addr = A_SEC_DBG_DATA_1,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_2",  .addr = A_SEC_DBG_DATA_2,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_3",  .addr = A_SEC_DBG_DATA_3,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_4",  .addr = A_SEC_DBG_DATA_4,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_5",  .addr = A_SEC_DBG_DATA_5,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_6",  .addr = A_SEC_DBG_DATA_6,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_7",  .addr = A_SEC_DBG_DATA_7,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_8",  .addr = A_SEC_DBG_DATA_8,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_9",  .addr = A_SEC_DBG_DATA_9,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_10",  .addr = A_SEC_DBG_DATA_10,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_11",  .addr = A_SEC_DBG_DATA_11,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_12",  .addr = A_SEC_DBG_DATA_12,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_13",  .addr = A_SEC_DBG_DATA_13,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_14",  .addr = A_SEC_DBG_DATA_14,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_15",  .addr = A_SEC_DBG_DATA_15,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_16",  .addr = A_SEC_DBG_DATA_16,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_17",  .addr = A_SEC_DBG_DATA_17,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_18",  .addr = A_SEC_DBG_DATA_18,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_19",  .addr = A_SEC_DBG_DATA_19,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_20",  .addr = A_SEC_DBG_DATA_20,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_21",  .addr = A_SEC_DBG_DATA_21,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_22",  .addr = A_SEC_DBG_DATA_22,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_23",  .addr = A_SEC_DBG_DATA_23,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_24",  .addr = A_SEC_DBG_DATA_24,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_25",  .addr = A_SEC_DBG_DATA_25,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_26",  .addr = A_SEC_DBG_DATA_26,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_27",  .addr = A_SEC_DBG_DATA_27,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_28",  .addr = A_SEC_DBG_DATA_28,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_29",  .addr = A_SEC_DBG_DATA_29,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_30",  .addr = A_SEC_DBG_DATA_30,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_31",  .addr = A_SEC_DBG_DATA_31,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_32",  .addr = A_SEC_DBG_DATA_32,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_33",  .addr = A_SEC_DBG_DATA_33,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_34",  .addr = A_SEC_DBG_DATA_34,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_35",  .addr = A_SEC_DBG_DATA_35,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_36",  .addr = A_SEC_DBG_DATA_36,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_37",  .addr = A_SEC_DBG_DATA_37,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_38",  .addr = A_SEC_DBG_DATA_38,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_39",  .addr = A_SEC_DBG_DATA_39,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_40",  .addr = A_SEC_DBG_DATA_40,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_41",  .addr = A_SEC_DBG_DATA_41,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_42",  .addr = A_SEC_DBG_DATA_42,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_43",  .addr = A_SEC_DBG_DATA_43,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_44",  .addr = A_SEC_DBG_DATA_44,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_45",  .addr = A_SEC_DBG_DATA_45,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_46",  .addr = A_SEC_DBG_DATA_46,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_47",  .addr = A_SEC_DBG_DATA_47,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_48",  .addr = A_SEC_DBG_DATA_48,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_49",  .addr = A_SEC_DBG_DATA_49,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_50",  .addr = A_SEC_DBG_DATA_50,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_51",  .addr = A_SEC_DBG_DATA_51,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_52",  .addr = A_SEC_DBG_DATA_52,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_53",  .addr = A_SEC_DBG_DATA_53,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_54",  .addr = A_SEC_DBG_DATA_54,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_55",  .addr = A_SEC_DBG_DATA_55,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_56",  .addr = A_SEC_DBG_DATA_56,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_57",  .addr = A_SEC_DBG_DATA_57,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_58",  .addr = A_SEC_DBG_DATA_58,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_59",  .addr = A_SEC_DBG_DATA_59,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_60",  .addr = A_SEC_DBG_DATA_60,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_61",  .addr = A_SEC_DBG_DATA_61,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_62",  .addr = A_SEC_DBG_DATA_62,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_63",  .addr = A_SEC_DBG_DATA_63,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_64",  .addr = A_SEC_DBG_DATA_64,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_65",  .addr = A_SEC_DBG_DATA_65,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_66",  .addr = A_SEC_DBG_DATA_66,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_67",  .addr = A_SEC_DBG_DATA_67,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_68",  .addr = A_SEC_DBG_DATA_68,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_69",  .addr = A_SEC_DBG_DATA_69,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_70",  .addr = A_SEC_DBG_DATA_70,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_71",  .addr = A_SEC_DBG_DATA_71,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_72",  .addr = A_SEC_DBG_DATA_72,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_73",  .addr = A_SEC_DBG_DATA_73,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_74",  .addr = A_SEC_DBG_DATA_74,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_75",  .addr = A_SEC_DBG_DATA_75,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_76",  .addr = A_SEC_DBG_DATA_76,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_77",  .addr = A_SEC_DBG_DATA_77,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_78",  .addr = A_SEC_DBG_DATA_78,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_79",  .addr = A_SEC_DBG_DATA_79,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_80",  .addr = A_SEC_DBG_DATA_80,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_81",  .addr = A_SEC_DBG_DATA_81,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_82",  .addr = A_SEC_DBG_DATA_82,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_83",  .addr = A_SEC_DBG_DATA_83,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_84",  .addr = A_SEC_DBG_DATA_84,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_85",  .addr = A_SEC_DBG_DATA_85,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_86",  .addr = A_SEC_DBG_DATA_86,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_87",  .addr = A_SEC_DBG_DATA_87,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_88",  .addr = A_SEC_DBG_DATA_88,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_89",  .addr = A_SEC_DBG_DATA_89,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_90",  .addr = A_SEC_DBG_DATA_90,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_91",  .addr = A_SEC_DBG_DATA_91,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_92",  .addr = A_SEC_DBG_DATA_92,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_93",  .addr = A_SEC_DBG_DATA_93,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_94",  .addr = A_SEC_DBG_DATA_94,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_95",  .addr = A_SEC_DBG_DATA_95,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_96",  .addr = A_SEC_DBG_DATA_96,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_97",  .addr = A_SEC_DBG_DATA_97,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_98",  .addr = A_SEC_DBG_DATA_98,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_99",  .addr = A_SEC_DBG_DATA_99,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_100",  .addr = A_SEC_DBG_DATA_100,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_101",  .addr = A_SEC_DBG_DATA_101,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_102",  .addr = A_SEC_DBG_DATA_102,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_103",  .addr = A_SEC_DBG_DATA_103,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_104",  .addr = A_SEC_DBG_DATA_104,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_105",  .addr = A_SEC_DBG_DATA_105,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_106",  .addr = A_SEC_DBG_DATA_106,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_107",  .addr = A_SEC_DBG_DATA_107,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_108",  .addr = A_SEC_DBG_DATA_108,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_109",  .addr = A_SEC_DBG_DATA_109,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_110",  .addr = A_SEC_DBG_DATA_110,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_111",  .addr = A_SEC_DBG_DATA_111,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_112",  .addr = A_SEC_DBG_DATA_112,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_113",  .addr = A_SEC_DBG_DATA_113,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_114",  .addr = A_SEC_DBG_DATA_114,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_115",  .addr = A_SEC_DBG_DATA_115,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_116",  .addr = A_SEC_DBG_DATA_116,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_117",  .addr = A_SEC_DBG_DATA_117,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_118",  .addr = A_SEC_DBG_DATA_118,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_119",  .addr = A_SEC_DBG_DATA_119,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_120",  .addr = A_SEC_DBG_DATA_120,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_121",  .addr = A_SEC_DBG_DATA_121,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_122",  .addr = A_SEC_DBG_DATA_122,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_123",  .addr = A_SEC_DBG_DATA_123,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_124",  .addr = A_SEC_DBG_DATA_124,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_125",  .addr = A_SEC_DBG_DATA_125,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_126",  .addr = A_SEC_DBG_DATA_126,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_127",  .addr = A_SEC_DBG_DATA_127,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_128",  .addr = A_SEC_DBG_DATA_128,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_129",  .addr = A_SEC_DBG_DATA_129,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_130",  .addr = A_SEC_DBG_DATA_130,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_131",  .addr = A_SEC_DBG_DATA_131,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_132",  .addr = A_SEC_DBG_DATA_132,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_133",  .addr = A_SEC_DBG_DATA_133,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_134",  .addr = A_SEC_DBG_DATA_134,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_135",  .addr = A_SEC_DBG_DATA_135,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_136",  .addr = A_SEC_DBG_DATA_136,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_137",  .addr = A_SEC_DBG_DATA_137,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_138",  .addr = A_SEC_DBG_DATA_138,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_139",  .addr = A_SEC_DBG_DATA_139,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_140",  .addr = A_SEC_DBG_DATA_140,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_141",  .addr = A_SEC_DBG_DATA_141,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_142",  .addr = A_SEC_DBG_DATA_142,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_143",  .addr = A_SEC_DBG_DATA_143,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_144",  .addr = A_SEC_DBG_DATA_144,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_145",  .addr = A_SEC_DBG_DATA_145,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_146",  .addr = A_SEC_DBG_DATA_146,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_147",  .addr = A_SEC_DBG_DATA_147,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_148",  .addr = A_SEC_DBG_DATA_148,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_149",  .addr = A_SEC_DBG_DATA_149,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_150",  .addr = A_SEC_DBG_DATA_150,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_151",  .addr = A_SEC_DBG_DATA_151,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_152",  .addr = A_SEC_DBG_DATA_152,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_153",  .addr = A_SEC_DBG_DATA_153,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_154",  .addr = A_SEC_DBG_DATA_154,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_155",  .addr = A_SEC_DBG_DATA_155,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_156",  .addr = A_SEC_DBG_DATA_156,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_157",  .addr = A_SEC_DBG_DATA_157,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_158",  .addr = A_SEC_DBG_DATA_158,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_159",  .addr = A_SEC_DBG_DATA_159,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_160",  .addr = A_SEC_DBG_DATA_160,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_161",  .addr = A_SEC_DBG_DATA_161,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_162",  .addr = A_SEC_DBG_DATA_162,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_163",  .addr = A_SEC_DBG_DATA_163,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_164",  .addr = A_SEC_DBG_DATA_164,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_165",  .addr = A_SEC_DBG_DATA_165,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_166",  .addr = A_SEC_DBG_DATA_166,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_167",  .addr = A_SEC_DBG_DATA_167,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_168",  .addr = A_SEC_DBG_DATA_168,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_169",  .addr = A_SEC_DBG_DATA_169,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_170",  .addr = A_SEC_DBG_DATA_170,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_171",  .addr = A_SEC_DBG_DATA_171,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_172",  .addr = A_SEC_DBG_DATA_172,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_173",  .addr = A_SEC_DBG_DATA_173,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_174",  .addr = A_SEC_DBG_DATA_174,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_175",  .addr = A_SEC_DBG_DATA_175,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_176",  .addr = A_SEC_DBG_DATA_176,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_177",  .addr = A_SEC_DBG_DATA_177,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_178",  .addr = A_SEC_DBG_DATA_178,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_179",  .addr = A_SEC_DBG_DATA_179,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_180",  .addr = A_SEC_DBG_DATA_180,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_181",  .addr = A_SEC_DBG_DATA_181,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_182",  .addr = A_SEC_DBG_DATA_182,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_183",  .addr = A_SEC_DBG_DATA_183,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_184",  .addr = A_SEC_DBG_DATA_184,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_185",  .addr = A_SEC_DBG_DATA_185,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_186",  .addr = A_SEC_DBG_DATA_186,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_187",  .addr = A_SEC_DBG_DATA_187,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_188",  .addr = A_SEC_DBG_DATA_188,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_189",  .addr = A_SEC_DBG_DATA_189,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_190",  .addr = A_SEC_DBG_DATA_190,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_191",  .addr = A_SEC_DBG_DATA_191,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_192",  .addr = A_SEC_DBG_DATA_192,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_193",  .addr = A_SEC_DBG_DATA_193,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_194",  .addr = A_SEC_DBG_DATA_194,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_195",  .addr = A_SEC_DBG_DATA_195,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_196",  .addr = A_SEC_DBG_DATA_196,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_197",  .addr = A_SEC_DBG_DATA_197,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_198",  .addr = A_SEC_DBG_DATA_198,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_199",  .addr = A_SEC_DBG_DATA_199,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_200",  .addr = A_SEC_DBG_DATA_200,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_201",  .addr = A_SEC_DBG_DATA_201,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_202",  .addr = A_SEC_DBG_DATA_202,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_203",  .addr = A_SEC_DBG_DATA_203,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_204",  .addr = A_SEC_DBG_DATA_204,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_205",  .addr = A_SEC_DBG_DATA_205,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_206",  .addr = A_SEC_DBG_DATA_206,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_207",  .addr = A_SEC_DBG_DATA_207,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_208",  .addr = A_SEC_DBG_DATA_208,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_209",  .addr = A_SEC_DBG_DATA_209,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_210",  .addr = A_SEC_DBG_DATA_210,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_211",  .addr = A_SEC_DBG_DATA_211,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_212",  .addr = A_SEC_DBG_DATA_212,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_213",  .addr = A_SEC_DBG_DATA_213,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_214",  .addr = A_SEC_DBG_DATA_214,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_215",  .addr = A_SEC_DBG_DATA_215,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_216",  .addr = A_SEC_DBG_DATA_216,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_217",  .addr = A_SEC_DBG_DATA_217,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_218",  .addr = A_SEC_DBG_DATA_218,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_219",  .addr = A_SEC_DBG_DATA_219,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_220",  .addr = A_SEC_DBG_DATA_220,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_221",  .addr = A_SEC_DBG_DATA_221,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_222",  .addr = A_SEC_DBG_DATA_222,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_223",  .addr = A_SEC_DBG_DATA_223,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_224",  .addr = A_SEC_DBG_DATA_224,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_225",  .addr = A_SEC_DBG_DATA_225,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_226",  .addr = A_SEC_DBG_DATA_226,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_227",  .addr = A_SEC_DBG_DATA_227,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_228",  .addr = A_SEC_DBG_DATA_228,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_229",  .addr = A_SEC_DBG_DATA_229,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_230",  .addr = A_SEC_DBG_DATA_230,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_231",  .addr = A_SEC_DBG_DATA_231,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_232",  .addr = A_SEC_DBG_DATA_232,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_233",  .addr = A_SEC_DBG_DATA_233,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_234",  .addr = A_SEC_DBG_DATA_234,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_235",  .addr = A_SEC_DBG_DATA_235,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_236",  .addr = A_SEC_DBG_DATA_236,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_237",  .addr = A_SEC_DBG_DATA_237,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_238",  .addr = A_SEC_DBG_DATA_238,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_239",  .addr = A_SEC_DBG_DATA_239,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_240",  .addr = A_SEC_DBG_DATA_240,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_241",  .addr = A_SEC_DBG_DATA_241,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_242",  .addr = A_SEC_DBG_DATA_242,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_243",  .addr = A_SEC_DBG_DATA_243,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_244",  .addr = A_SEC_DBG_DATA_244,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_245",  .addr = A_SEC_DBG_DATA_245,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_246",  .addr = A_SEC_DBG_DATA_246,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_247",  .addr = A_SEC_DBG_DATA_247,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_248",  .addr = A_SEC_DBG_DATA_248,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_249",  .addr = A_SEC_DBG_DATA_249,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_250",  .addr = A_SEC_DBG_DATA_250,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_251",  .addr = A_SEC_DBG_DATA_251,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_252",  .addr = A_SEC_DBG_DATA_252,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_253",  .addr = A_SEC_DBG_DATA_253,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_254",  .addr = A_SEC_DBG_DATA_254,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_255",  .addr = A_SEC_DBG_DATA_255,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_256",  .addr = A_SEC_DBG_DATA_256,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_257",  .addr = A_SEC_DBG_DATA_257,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_258",  .addr = A_SEC_DBG_DATA_258,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_259",  .addr = A_SEC_DBG_DATA_259,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_260",  .addr = A_SEC_DBG_DATA_260,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_261",  .addr = A_SEC_DBG_DATA_261,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_262",  .addr = A_SEC_DBG_DATA_262,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_263",  .addr = A_SEC_DBG_DATA_263,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_264",  .addr = A_SEC_DBG_DATA_264,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_265",  .addr = A_SEC_DBG_DATA_265,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_266",  .addr = A_SEC_DBG_DATA_266,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_267",  .addr = A_SEC_DBG_DATA_267,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_268",  .addr = A_SEC_DBG_DATA_268,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_269",  .addr = A_SEC_DBG_DATA_269,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_270",  .addr = A_SEC_DBG_DATA_270,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_271",  .addr = A_SEC_DBG_DATA_271,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_272",  .addr = A_SEC_DBG_DATA_272,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_273",  .addr = A_SEC_DBG_DATA_273,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_274",  .addr = A_SEC_DBG_DATA_274,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_275",  .addr = A_SEC_DBG_DATA_275,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_276",  .addr = A_SEC_DBG_DATA_276,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_277",  .addr = A_SEC_DBG_DATA_277,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_278",  .addr = A_SEC_DBG_DATA_278,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_279",  .addr = A_SEC_DBG_DATA_279,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_280",  .addr = A_SEC_DBG_DATA_280,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_281",  .addr = A_SEC_DBG_DATA_281,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_282",  .addr = A_SEC_DBG_DATA_282,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_283",  .addr = A_SEC_DBG_DATA_283,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_284",  .addr = A_SEC_DBG_DATA_284,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_285",  .addr = A_SEC_DBG_DATA_285,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_286",  .addr = A_SEC_DBG_DATA_286,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_287",  .addr = A_SEC_DBG_DATA_287,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_288",  .addr = A_SEC_DBG_DATA_288,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_289",  .addr = A_SEC_DBG_DATA_289,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_290",  .addr = A_SEC_DBG_DATA_290,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_291",  .addr = A_SEC_DBG_DATA_291,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_292",  .addr = A_SEC_DBG_DATA_292,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_293",  .addr = A_SEC_DBG_DATA_293,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_294",  .addr = A_SEC_DBG_DATA_294,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_295",  .addr = A_SEC_DBG_DATA_295,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_296",  .addr = A_SEC_DBG_DATA_296,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_297",  .addr = A_SEC_DBG_DATA_297,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_298",  .addr = A_SEC_DBG_DATA_298,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_299",  .addr = A_SEC_DBG_DATA_299,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_300",  .addr = A_SEC_DBG_DATA_300,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_301",  .addr = A_SEC_DBG_DATA_301,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_302",  .addr = A_SEC_DBG_DATA_302,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_303",  .addr = A_SEC_DBG_DATA_303,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_304",  .addr = A_SEC_DBG_DATA_304,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_305",  .addr = A_SEC_DBG_DATA_305,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_306",  .addr = A_SEC_DBG_DATA_306,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_307",  .addr = A_SEC_DBG_DATA_307,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_308",  .addr = A_SEC_DBG_DATA_308,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_309",  .addr = A_SEC_DBG_DATA_309,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_310",  .addr = A_SEC_DBG_DATA_310,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_311",  .addr = A_SEC_DBG_DATA_311,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_312",  .addr = A_SEC_DBG_DATA_312,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_313",  .addr = A_SEC_DBG_DATA_313,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_314",  .addr = A_SEC_DBG_DATA_314,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_315",  .addr = A_SEC_DBG_DATA_315,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_316",  .addr = A_SEC_DBG_DATA_316,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_317",  .addr = A_SEC_DBG_DATA_317,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_318",  .addr = A_SEC_DBG_DATA_318,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_319",  .addr = A_SEC_DBG_DATA_319,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_320",  .addr = A_SEC_DBG_DATA_320,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_321",  .addr = A_SEC_DBG_DATA_321,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_322",  .addr = A_SEC_DBG_DATA_322,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_323",  .addr = A_SEC_DBG_DATA_323,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_324",  .addr = A_SEC_DBG_DATA_324,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_325",  .addr = A_SEC_DBG_DATA_325,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_326",  .addr = A_SEC_DBG_DATA_326,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_327",  .addr = A_SEC_DBG_DATA_327,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_328",  .addr = A_SEC_DBG_DATA_328,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_329",  .addr = A_SEC_DBG_DATA_329,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_330",  .addr = A_SEC_DBG_DATA_330,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_331",  .addr = A_SEC_DBG_DATA_331,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_332",  .addr = A_SEC_DBG_DATA_332,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_333",  .addr = A_SEC_DBG_DATA_333,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_334",  .addr = A_SEC_DBG_DATA_334,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_335",  .addr = A_SEC_DBG_DATA_335,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_336",  .addr = A_SEC_DBG_DATA_336,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_337",  .addr = A_SEC_DBG_DATA_337,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_338",  .addr = A_SEC_DBG_DATA_338,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_339",  .addr = A_SEC_DBG_DATA_339,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_340",  .addr = A_SEC_DBG_DATA_340,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_341",  .addr = A_SEC_DBG_DATA_341,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_342",  .addr = A_SEC_DBG_DATA_342,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_343",  .addr = A_SEC_DBG_DATA_343,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_344",  .addr = A_SEC_DBG_DATA_344,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_345",  .addr = A_SEC_DBG_DATA_345,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_346",  .addr = A_SEC_DBG_DATA_346,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_347",  .addr = A_SEC_DBG_DATA_347,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_348",  .addr = A_SEC_DBG_DATA_348,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_349",  .addr = A_SEC_DBG_DATA_349,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_350",  .addr = A_SEC_DBG_DATA_350,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_351",  .addr = A_SEC_DBG_DATA_351,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_352",  .addr = A_SEC_DBG_DATA_352,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_353",  .addr = A_SEC_DBG_DATA_353,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_354",  .addr = A_SEC_DBG_DATA_354,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_355",  .addr = A_SEC_DBG_DATA_355,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_356",  .addr = A_SEC_DBG_DATA_356,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_357",  .addr = A_SEC_DBG_DATA_357,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_358",  .addr = A_SEC_DBG_DATA_358,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_359",  .addr = A_SEC_DBG_DATA_359,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_360",  .addr = A_SEC_DBG_DATA_360,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_361",  .addr = A_SEC_DBG_DATA_361,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_362",  .addr = A_SEC_DBG_DATA_362,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_363",  .addr = A_SEC_DBG_DATA_363,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_364",  .addr = A_SEC_DBG_DATA_364,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_365",  .addr = A_SEC_DBG_DATA_365,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_366",  .addr = A_SEC_DBG_DATA_366,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_367",  .addr = A_SEC_DBG_DATA_367,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_368",  .addr = A_SEC_DBG_DATA_368,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_369",  .addr = A_SEC_DBG_DATA_369,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_370",  .addr = A_SEC_DBG_DATA_370,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_371",  .addr = A_SEC_DBG_DATA_371,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_372",  .addr = A_SEC_DBG_DATA_372,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_373",  .addr = A_SEC_DBG_DATA_373,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_374",  .addr = A_SEC_DBG_DATA_374,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_375",  .addr = A_SEC_DBG_DATA_375,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_376",  .addr = A_SEC_DBG_DATA_376,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_377",  .addr = A_SEC_DBG_DATA_377,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_378",  .addr = A_SEC_DBG_DATA_378,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_379",  .addr = A_SEC_DBG_DATA_379,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_380",  .addr = A_SEC_DBG_DATA_380,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_381",  .addr = A_SEC_DBG_DATA_381,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_382",  .addr = A_SEC_DBG_DATA_382,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_383",  .addr = A_SEC_DBG_DATA_383,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_384",  .addr = A_SEC_DBG_DATA_384,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_385",  .addr = A_SEC_DBG_DATA_385,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_386",  .addr = A_SEC_DBG_DATA_386,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_387",  .addr = A_SEC_DBG_DATA_387,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_388",  .addr = A_SEC_DBG_DATA_388,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_389",  .addr = A_SEC_DBG_DATA_389,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_390",  .addr = A_SEC_DBG_DATA_390,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_391",  .addr = A_SEC_DBG_DATA_391,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_392",  .addr = A_SEC_DBG_DATA_392,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_393",  .addr = A_SEC_DBG_DATA_393,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_394",  .addr = A_SEC_DBG_DATA_394,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_395",  .addr = A_SEC_DBG_DATA_395,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_396",  .addr = A_SEC_DBG_DATA_396,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_397",  .addr = A_SEC_DBG_DATA_397,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_398",  .addr = A_SEC_DBG_DATA_398,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_399",  .addr = A_SEC_DBG_DATA_399,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_400",  .addr = A_SEC_DBG_DATA_400,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_401",  .addr = A_SEC_DBG_DATA_401,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_402",  .addr = A_SEC_DBG_DATA_402,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_403",  .addr = A_SEC_DBG_DATA_403,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_404",  .addr = A_SEC_DBG_DATA_404,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_405",  .addr = A_SEC_DBG_DATA_405,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_406",  .addr = A_SEC_DBG_DATA_406,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_407",  .addr = A_SEC_DBG_DATA_407,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_408",  .addr = A_SEC_DBG_DATA_408,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_409",  .addr = A_SEC_DBG_DATA_409,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_410",  .addr = A_SEC_DBG_DATA_410,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_411",  .addr = A_SEC_DBG_DATA_411,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_412",  .addr = A_SEC_DBG_DATA_412,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_413",  .addr = A_SEC_DBG_DATA_413,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_414",  .addr = A_SEC_DBG_DATA_414,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_415",  .addr = A_SEC_DBG_DATA_415,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_416",  .addr = A_SEC_DBG_DATA_416,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_417",  .addr = A_SEC_DBG_DATA_417,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_418",  .addr = A_SEC_DBG_DATA_418,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_419",  .addr = A_SEC_DBG_DATA_419,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_420",  .addr = A_SEC_DBG_DATA_420,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_421",  .addr = A_SEC_DBG_DATA_421,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_422",  .addr = A_SEC_DBG_DATA_422,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_423",  .addr = A_SEC_DBG_DATA_423,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_424",  .addr = A_SEC_DBG_DATA_424,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_425",  .addr = A_SEC_DBG_DATA_425,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_426",  .addr = A_SEC_DBG_DATA_426,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_427",  .addr = A_SEC_DBG_DATA_427,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_428",  .addr = A_SEC_DBG_DATA_428,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_429",  .addr = A_SEC_DBG_DATA_429,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_430",  .addr = A_SEC_DBG_DATA_430,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_431",  .addr = A_SEC_DBG_DATA_431,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_432",  .addr = A_SEC_DBG_DATA_432,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_433",  .addr = A_SEC_DBG_DATA_433,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_434",  .addr = A_SEC_DBG_DATA_434,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_435",  .addr = A_SEC_DBG_DATA_435,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_436",  .addr = A_SEC_DBG_DATA_436,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_437",  .addr = A_SEC_DBG_DATA_437,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_438",  .addr = A_SEC_DBG_DATA_438,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_439",  .addr = A_SEC_DBG_DATA_439,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_440",  .addr = A_SEC_DBG_DATA_440,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_441",  .addr = A_SEC_DBG_DATA_441,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_442",  .addr = A_SEC_DBG_DATA_442,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_443",  .addr = A_SEC_DBG_DATA_443,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_444",  .addr = A_SEC_DBG_DATA_444,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_445",  .addr = A_SEC_DBG_DATA_445,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_446",  .addr = A_SEC_DBG_DATA_446,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_447",  .addr = A_SEC_DBG_DATA_447,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_448",  .addr = A_SEC_DBG_DATA_448,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_449",  .addr = A_SEC_DBG_DATA_449,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_450",  .addr = A_SEC_DBG_DATA_450,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_451",  .addr = A_SEC_DBG_DATA_451,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_452",  .addr = A_SEC_DBG_DATA_452,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_453",  .addr = A_SEC_DBG_DATA_453,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_454",  .addr = A_SEC_DBG_DATA_454,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_455",  .addr = A_SEC_DBG_DATA_455,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_456",  .addr = A_SEC_DBG_DATA_456,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_457",  .addr = A_SEC_DBG_DATA_457,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_458",  .addr = A_SEC_DBG_DATA_458,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_459",  .addr = A_SEC_DBG_DATA_459,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_460",  .addr = A_SEC_DBG_DATA_460,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_461",  .addr = A_SEC_DBG_DATA_461,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_462",  .addr = A_SEC_DBG_DATA_462,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_463",  .addr = A_SEC_DBG_DATA_463,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_464",  .addr = A_SEC_DBG_DATA_464,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_465",  .addr = A_SEC_DBG_DATA_465,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_466",  .addr = A_SEC_DBG_DATA_466,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_467",  .addr = A_SEC_DBG_DATA_467,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_468",  .addr = A_SEC_DBG_DATA_468,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_469",  .addr = A_SEC_DBG_DATA_469,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_470",  .addr = A_SEC_DBG_DATA_470,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_471",  .addr = A_SEC_DBG_DATA_471,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_472",  .addr = A_SEC_DBG_DATA_472,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_473",  .addr = A_SEC_DBG_DATA_473,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_474",  .addr = A_SEC_DBG_DATA_474,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_475",  .addr = A_SEC_DBG_DATA_475,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_476",  .addr = A_SEC_DBG_DATA_476,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_477",  .addr = A_SEC_DBG_DATA_477,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_478",  .addr = A_SEC_DBG_DATA_478,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_479",  .addr = A_SEC_DBG_DATA_479,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_480",  .addr = A_SEC_DBG_DATA_480,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_481",  .addr = A_SEC_DBG_DATA_481,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_482",  .addr = A_SEC_DBG_DATA_482,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_483",  .addr = A_SEC_DBG_DATA_483,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_484",  .addr = A_SEC_DBG_DATA_484,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_485",  .addr = A_SEC_DBG_DATA_485,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_486",  .addr = A_SEC_DBG_DATA_486,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_487",  .addr = A_SEC_DBG_DATA_487,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_488",  .addr = A_SEC_DBG_DATA_488,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_489",  .addr = A_SEC_DBG_DATA_489,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_490",  .addr = A_SEC_DBG_DATA_490,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_491",  .addr = A_SEC_DBG_DATA_491,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_492",  .addr = A_SEC_DBG_DATA_492,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_493",  .addr = A_SEC_DBG_DATA_493,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_494",  .addr = A_SEC_DBG_DATA_494,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_495",  .addr = A_SEC_DBG_DATA_495,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_496",  .addr = A_SEC_DBG_DATA_496,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_497",  .addr = A_SEC_DBG_DATA_497,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_498",  .addr = A_SEC_DBG_DATA_498,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_499",  .addr = A_SEC_DBG_DATA_499,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_500",  .addr = A_SEC_DBG_DATA_500,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_501",  .addr = A_SEC_DBG_DATA_501,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_502",  .addr = A_SEC_DBG_DATA_502,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_503",  .addr = A_SEC_DBG_DATA_503,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_504",  .addr = A_SEC_DBG_DATA_504,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_505",  .addr = A_SEC_DBG_DATA_505,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_506",  .addr = A_SEC_DBG_DATA_506,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_507",  .addr = A_SEC_DBG_DATA_507,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_508",  .addr = A_SEC_DBG_DATA_508,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_509",  .addr = A_SEC_DBG_DATA_509,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_510",  .addr = A_SEC_DBG_DATA_510,
        .ro = 0xffffffff,
    },{ .name = "SEC_DBG_DATA_511",  .addr = A_SEC_DBG_DATA_511,
        .ro = 0xffffffff,
    }
};

static void pmc_tap_reset(DeviceState *dev)
{
    PMC_TAP *s = XILINX_PMC_TAP(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    s->regs[R_SLR_TYPE] = s->slr_type;
    s->auth_data_load = 0;
    s->payload_received = 0;
    ARRAY_FIELD_DP32(s->regs, VERSION, PLATFORM, s->platform);
    ARRAY_FIELD_DP32(s->regs, VERSION, PLATFORM_VERSION, s->pver);
    ARRAY_FIELD_DP32(s->regs, IDCODE, IDCODE, s->idcode);
    sec_dbg_int_update_irq(s);
    pmc_tap_int_update_irq(s);
}

static int pmc_tap_can_receive(void *opaque)
{
    PMC_TAP *s = XILINX_PMC_TAP(opaque);

    if (s->sec_dbg_dis & SEC_DBG_DIS_MASK) {
        qemu_log_mask(LOG_GUEST_ERROR, "Efuse: Secure Debug disabled as "
                                      "bits are blown");
        return 0;
    } else if ((s->sec_dbg_dis & SEC_LOCK_DBG_DIS_MASK) &
               s->first_image_done) {
        qemu_log_mask(LOG_GUEST_ERROR, "EFUSE: Secure Debug Lock "
                                      "bits are blown, "
                                      "Cannot accept 2nd image");
        return 0;
    }
    return s->auth_data_load ?
            MAX_SEC_PAYLOAD - s->payload_received : 0;
}

static void pmc_tap_receive(void *opaque, const uint8_t *buf, int size)
{
     PMC_TAP *s = XILINX_PMC_TAP(opaque);

     memcpy((uint8_t *)&s->regs[R_SEC_DBG_DATA_0] + s->payload_received,
            buf, size);
     s->payload_received += size;
}

static const MemoryRegionOps pmc_tap_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmc_tap_sec_debug_data_load(void *opaque, int n, int level)
{
    PMC_TAP *s = XILINX_PMC_TAP(opaque);

    if (s->auth_data_load) {
        if(!level) {
            /* Secure payload done */
            ARRAY_FIELD_DP32(s->regs, SEC_DBG_INT_STATUS, SEC_DBG, 1);
            s->first_image_done = true;
            sec_dbg_int_update_irq(s);
        }
    }
    DPRINT("sec-dbg : %s\n", level ? "true": "false");
    s->auth_data_load = level;
}

static void pmc_tap_efuse_sec_dbg_dis(void *opaque, int n, int level)
{
    PMC_TAP *s = XILINX_PMC_TAP(opaque);

    s->sec_dbg_dis = deposit32(s->sec_dbg_dis, n, 1, level);
}

static void pmc_tap_realize(DeviceState *dev, Error **errp)
{
    PMC_TAP *s = XILINX_PMC_TAP(dev);
    Chardev *chr;

    chr = qemu_chr_find("sec-boot");
    qdev_prop_set_chr(dev, "chardev", chr);
    if (!qemu_chr_fe_get_driver(&s->chr)) {
        DPRINT("Seucre Boot interface not connected\n");
    } else {
        qemu_chr_fe_set_handlers(&s->chr, pmc_tap_can_receive, pmc_tap_receive,
                                 NULL, NULL, s, NULL, true);
        qemu_chr_fe_accept_input(&s->chr);
    }
    qdev_init_gpio_in_named(dev, pmc_tap_sec_debug_data_load, "sec-dbg-data", 1);
    qdev_init_gpio_in(dev, pmc_tap_efuse_sec_dbg_dis, 4);
    qdev_init_gpio_out_named(dev, &s->irq_sec_dbg_int, "sec-dbg-int", 1);
    qdev_init_gpio_out_named(dev, &s->irq_pmc_tap_int, "pmc-tap-int", 1);
}

static void pmc_tap_init(Object *obj)
{
    PMC_TAP *s = XILINX_PMC_TAP(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMC_TAP, R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmc_tap_regs_info,
                              ARRAY_SIZE(pmc_tap_regs_info),
                              s->regs_info, s->regs,
                              &pmc_tap_ops,
                              XILINX_PMC_TAP_ERR_DEBUG,
                              R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_pmc_tap = {
    .name = TYPE_XILINX_PMC_TAP,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMC_TAP, R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static Property pmc_tap_props[] = {
        DEFINE_PROP_CHR("chardev", PMC_TAP, chr),
        DEFINE_PROP_UINT32("slr-type", PMC_TAP, slr_type,
                           PMC_TAP_SLR_TYPE_MONO),
        DEFINE_PROP_UINT8("platform", PMC_TAP, platform,
                          PLATFORM_VERSION_QEMU),
        DEFINE_PROP_UINT8("platform-ver", PMC_TAP, pver, 0),
        DEFINE_PROP_UINT32("idcode", PMC_TAP, idcode, 0),
        DEFINE_PROP_END_OF_LIST(),
};

static void pmc_tap_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pmc_tap_reset;
    dc->realize = pmc_tap_realize;
    dc->vmsd = &vmstate_pmc_tap;
    device_class_set_props(dc, pmc_tap_props);
}

static const TypeInfo pmc_tap_info = {
    .name          = TYPE_XILINX_PMC_TAP,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMC_TAP),
    .class_init    = pmc_tap_class_init,
    .instance_init = pmc_tap_init,
};

static void pmc_tap_register_types(void)
{
    type_register_static(&pmc_tap_info);
}

type_init(pmc_tap_register_types)
