/*
 * QEMU model of the NOC_NPS Noc Packet Switch
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-03-20.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_NOC_NPS_ERR_DEBUG
#define XILINX_NOC_NPS_ERR_DEBUG 0
#endif

#define TYPE_XILINX_NOC_NPS "xlnx.noc-nps"

#define XILINX_NOC_NPS(obj) \
     OBJECT_CHECK(NOC_NPS, (obj), TYPE_XILINX_NOC_NPS)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE, 2, 4)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE, 2, 4)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_CLOCK_MUX, 0x10)
REG32(REG_ITR, 0x40)
    FIELD(REG_ITR, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_ITR, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_ITR, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_ITR, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_ITR, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_ITR, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_ITR, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_ITR, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_ITR, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_ITR, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_ITR, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_ITR, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_ITR, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_ITR, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_ITR, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_ITR, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_ITR, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_ITR, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_ITR, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_ITR, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_ITR, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_ITR, P3_PARITY_ERR, 3, 1)
    FIELD(REG_ITR, P2_PARITY_ERR, 2, 1)
    FIELD(REG_ITR, P1_PARITY_ERR, 1, 1)
    FIELD(REG_ITR, P0_PARITY_ERR, 0, 1)
REG32(REG_ISR, 0x44)
    FIELD(REG_ISR, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_ISR, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_ISR, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_ISR, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_ISR, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_ISR, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_ISR, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_ISR, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_ISR, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_ISR, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_ISR, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_ISR, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_ISR, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_ISR, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_ISR, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_ISR, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_ISR, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_ISR, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_ISR, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_ISR, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_ISR, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_ISR, P3_PARITY_ERR, 3, 1)
    FIELD(REG_ISR, P2_PARITY_ERR, 2, 1)
    FIELD(REG_ISR, P1_PARITY_ERR, 1, 1)
    FIELD(REG_ISR, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR0, 0x48)
    FIELD(REG_IMR0, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IMR0, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IMR0, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IMR0, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IMR0, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR0, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IMR0, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IMR0, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR0, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR0, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IMR0, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IMR0, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR0, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR0, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IMR0, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IMR0, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR0, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR0, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IMR0, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IMR0, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IMR0, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IMR0, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IMR0, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IMR0, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR0, P0_PARITY_ERR, 0, 1)
REG32(REG_IER0, 0x4c)
    FIELD(REG_IER0, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IER0, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IER0, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IER0, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IER0, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER0, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IER0, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IER0, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER0, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER0, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IER0, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IER0, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER0, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER0, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IER0, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IER0, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER0, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER0, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IER0, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IER0, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IER0, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IER0, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IER0, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IER0, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER0, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR0, 0x50)
    FIELD(REG_IDR0, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IDR0, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IDR0, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IDR0, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IDR0, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR0, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IDR0, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IDR0, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR0, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR0, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IDR0, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IDR0, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR0, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR0, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IDR0, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IDR0, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR0, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR0, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IDR0, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IDR0, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IDR0, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IDR0, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IDR0, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IDR0, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR0, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR1, 0x54)
    FIELD(REG_IMR1, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IMR1, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IMR1, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IMR1, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IMR1, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR1, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IMR1, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IMR1, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR1, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR1, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IMR1, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IMR1, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR1, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR1, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IMR1, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IMR1, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR1, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR1, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IMR1, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IMR1, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IMR1, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IMR1, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IMR1, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IMR1, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR1, P0_PARITY_ERR, 0, 1)
REG32(REG_IER1, 0x58)
    FIELD(REG_IER1, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IER1, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IER1, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IER1, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IER1, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER1, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IER1, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IER1, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER1, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER1, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IER1, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IER1, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER1, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER1, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IER1, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IER1, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER1, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER1, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IER1, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IER1, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IER1, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IER1, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IER1, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IER1, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER1, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR1, 0x5c)
    FIELD(REG_IDR1, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IDR1, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IDR1, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IDR1, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IDR1, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR1, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IDR1, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IDR1, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR1, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR1, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IDR1, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IDR1, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR1, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR1, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IDR1, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IDR1, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR1, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR1, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IDR1, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IDR1, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IDR1, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IDR1, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IDR1, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IDR1, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR1, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR2, 0x60)
    FIELD(REG_IMR2, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IMR2, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IMR2, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IMR2, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IMR2, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR2, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IMR2, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IMR2, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR2, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR2, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IMR2, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IMR2, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR2, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR2, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IMR2, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IMR2, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR2, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR2, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IMR2, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IMR2, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IMR2, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IMR2, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IMR2, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IMR2, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR2, P0_PARITY_ERR, 0, 1)
REG32(REG_IER2, 0x64)
    FIELD(REG_IER2, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IER2, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IER2, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IER2, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IER2, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER2, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IER2, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IER2, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER2, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER2, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IER2, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IER2, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER2, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER2, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IER2, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IER2, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER2, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER2, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IER2, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IER2, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IER2, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IER2, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IER2, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IER2, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER2, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR2, 0x68)
    FIELD(REG_IDR2, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IDR2, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IDR2, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IDR2, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IDR2, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR2, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IDR2, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IDR2, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR2, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR2, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IDR2, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IDR2, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR2, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR2, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IDR2, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IDR2, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR2, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR2, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IDR2, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IDR2, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IDR2, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IDR2, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IDR2, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IDR2, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR2, P0_PARITY_ERR, 0, 1)
REG32(REG_IMR3, 0x6c)
    FIELD(REG_IMR3, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IMR3, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IMR3, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IMR3, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IMR3, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IMR3, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IMR3, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IMR3, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IMR3, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IMR3, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IMR3, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IMR3, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IMR3, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IMR3, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IMR3, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IMR3, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IMR3, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IMR3, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IMR3, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IMR3, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IMR3, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IMR3, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IMR3, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IMR3, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IMR3, P0_PARITY_ERR, 0, 1)
REG32(REG_IER3, 0x70)
    FIELD(REG_IER3, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IER3, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IER3, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IER3, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IER3, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IER3, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IER3, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IER3, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IER3, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IER3, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IER3, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IER3, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IER3, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IER3, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IER3, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IER3, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IER3, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IER3, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IER3, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IER3, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IER3, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IER3, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IER3, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IER3, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IER3, P0_PARITY_ERR, 0, 1)
REG32(REG_IDR3, 0x74)
    FIELD(REG_IDR3, P3_DBI_PARITY_ERR, 24, 1)
    FIELD(REG_IDR3, P2_DBI_PARITY_ERR, 23, 1)
    FIELD(REG_IDR3, P1_DBI_PARITY_ERR, 22, 1)
    FIELD(REG_IDR3, P0_DBI_PARITY_ERR, 21, 1)
    FIELD(REG_IDR3, SCAN_CLR_ERR, 20, 1)
    FIELD(REG_IDR3, P3_BUF_OVF_ERR, 19, 1)
    FIELD(REG_IDR3, P2_BUF_OVF_ERR, 18, 1)
    FIELD(REG_IDR3, P1_BUF_OVF_ERR, 17, 1)
    FIELD(REG_IDR3, P0_BUF_OVF_ERR, 16, 1)
    FIELD(REG_IDR3, P3_CRDT_OVF_ERR, 15, 1)
    FIELD(REG_IDR3, P2_CRDT_OVF_ERR, 14, 1)
    FIELD(REG_IDR3, P1_CRDT_OVF_ERR, 13, 1)
    FIELD(REG_IDR3, P0_CRDT_OVF_ERR, 12, 1)
    FIELD(REG_IDR3, P3_CRDT_RDY_ERR, 11, 1)
    FIELD(REG_IDR3, P2_CRDT_RDY_ERR, 10, 1)
    FIELD(REG_IDR3, P1_CRDT_RDY_ERR, 9, 1)
    FIELD(REG_IDR3, P0_CRDT_RDY_ERR, 8, 1)
    FIELD(REG_IDR3, P3_ROUTE_ERR, 7, 1)
    FIELD(REG_IDR3, P2_ROUTE_ERR, 6, 1)
    FIELD(REG_IDR3, P1_ROUTE_ERR, 5, 1)
    FIELD(REG_IDR3, P0_ROUTE_ERR, 4, 1)
    FIELD(REG_IDR3, P3_PARITY_ERR, 3, 1)
    FIELD(REG_IDR3, P2_PARITY_ERR, 2, 1)
    FIELD(REG_IDR3, P1_PARITY_ERR, 1, 1)
    FIELD(REG_IDR3, P0_PARITY_ERR, 0, 1)
REG32(REG_IOR, 0x78)
    FIELD(REG_IOR, OFFSET, 0, 5)
REG32(REG_HIGH_ID0_P01, 0x100)
    FIELD(REG_HIGH_ID0_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID0_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID0_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID0_P23, 0x104)
    FIELD(REG_HIGH_ID0_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID0_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID0_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID1_P01, 0x108)
    FIELD(REG_HIGH_ID1_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID1_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID1_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID1_P23, 0x10c)
    FIELD(REG_HIGH_ID1_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID1_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID1_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID2_P01, 0x110)
    FIELD(REG_HIGH_ID2_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID2_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID2_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID2_P23, 0x114)
    FIELD(REG_HIGH_ID2_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID2_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID2_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID3_P01, 0x118)
    FIELD(REG_HIGH_ID3_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID3_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID3_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID3_P23, 0x11c)
    FIELD(REG_HIGH_ID3_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID3_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID3_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID4_P01, 0x120)
    FIELD(REG_HIGH_ID4_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID4_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID4_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID4_P23, 0x124)
    FIELD(REG_HIGH_ID4_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID4_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID4_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID5_P01, 0x128)
    FIELD(REG_HIGH_ID5_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID5_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID5_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID5_P23, 0x12c)
    FIELD(REG_HIGH_ID5_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID5_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID5_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID6_P01, 0x130)
    FIELD(REG_HIGH_ID6_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID6_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID6_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID6_P23, 0x134)
    FIELD(REG_HIGH_ID6_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID6_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID6_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID7_P01, 0x138)
    FIELD(REG_HIGH_ID7_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID7_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID7_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID7_P23, 0x13c)
    FIELD(REG_HIGH_ID7_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID7_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID7_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID8_P01, 0x140)
    FIELD(REG_HIGH_ID8_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID8_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID8_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID8_P23, 0x144)
    FIELD(REG_HIGH_ID8_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID8_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID8_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID9_P01, 0x148)
    FIELD(REG_HIGH_ID9_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID9_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID9_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID9_P23, 0x14c)
    FIELD(REG_HIGH_ID9_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID9_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID9_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID10_P01, 0x150)
    FIELD(REG_HIGH_ID10_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID10_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID10_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID10_P23, 0x154)
    FIELD(REG_HIGH_ID10_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID10_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID10_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID11_P01, 0x158)
    FIELD(REG_HIGH_ID11_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID11_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID11_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID11_P23, 0x15c)
    FIELD(REG_HIGH_ID11_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID11_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID11_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID12_P01, 0x160)
    FIELD(REG_HIGH_ID12_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID12_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID12_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID12_P23, 0x164)
    FIELD(REG_HIGH_ID12_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID12_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID12_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID13_P01, 0x168)
    FIELD(REG_HIGH_ID13_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID13_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID13_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID13_P23, 0x16c)
    FIELD(REG_HIGH_ID13_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID13_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID13_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID14_P01, 0x170)
    FIELD(REG_HIGH_ID14_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID14_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID14_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID14_P23, 0x174)
    FIELD(REG_HIGH_ID14_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID14_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID14_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID15_P01, 0x178)
    FIELD(REG_HIGH_ID15_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID15_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID15_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID15_P23, 0x17c)
    FIELD(REG_HIGH_ID15_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID15_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID15_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID16_P01, 0x180)
    FIELD(REG_HIGH_ID16_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID16_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID16_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID16_P23, 0x184)
    FIELD(REG_HIGH_ID16_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID16_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID16_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID17_P01, 0x188)
    FIELD(REG_HIGH_ID17_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID17_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID17_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID17_P23, 0x18c)
    FIELD(REG_HIGH_ID17_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID17_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID17_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID18_P01, 0x190)
    FIELD(REG_HIGH_ID18_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID18_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID18_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID18_P23, 0x194)
    FIELD(REG_HIGH_ID18_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID18_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID18_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID19_P01, 0x198)
    FIELD(REG_HIGH_ID19_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID19_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID19_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID19_P23, 0x19c)
    FIELD(REG_HIGH_ID19_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID19_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID19_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID20_P01, 0x1a0)
    FIELD(REG_HIGH_ID20_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID20_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID20_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID20_P23, 0x1a4)
    FIELD(REG_HIGH_ID20_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID20_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID20_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID21_P01, 0x1a8)
    FIELD(REG_HIGH_ID21_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID21_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID21_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID21_P23, 0x1ac)
    FIELD(REG_HIGH_ID21_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID21_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID21_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID22_P01, 0x1b0)
    FIELD(REG_HIGH_ID22_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID22_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID22_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID22_P23, 0x1b4)
    FIELD(REG_HIGH_ID22_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID22_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID22_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID23_P01, 0x1b8)
    FIELD(REG_HIGH_ID23_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID23_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID23_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID23_P23, 0x1bc)
    FIELD(REG_HIGH_ID23_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID23_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID23_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID24_P01, 0x1c0)
    FIELD(REG_HIGH_ID24_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID24_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID24_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID24_P23, 0x1c4)
    FIELD(REG_HIGH_ID24_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID24_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID24_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID25_P01, 0x1c8)
    FIELD(REG_HIGH_ID25_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID25_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID25_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID25_P23, 0x1cc)
    FIELD(REG_HIGH_ID25_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID25_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID25_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID26_P01, 0x1d0)
    FIELD(REG_HIGH_ID26_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID26_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID26_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID26_P23, 0x1d4)
    FIELD(REG_HIGH_ID26_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID26_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID26_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID27_P01, 0x1d8)
    FIELD(REG_HIGH_ID27_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID27_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID27_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID27_P23, 0x1dc)
    FIELD(REG_HIGH_ID27_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID27_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID27_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID28_P01, 0x1e0)
    FIELD(REG_HIGH_ID28_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID28_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID28_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID28_P23, 0x1e4)
    FIELD(REG_HIGH_ID28_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID28_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID28_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID29_P01, 0x1e8)
    FIELD(REG_HIGH_ID29_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID29_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID29_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID29_P23, 0x1ec)
    FIELD(REG_HIGH_ID29_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID29_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID29_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID30_P01, 0x1f0)
    FIELD(REG_HIGH_ID30_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID30_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID30_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID30_P23, 0x1f4)
    FIELD(REG_HIGH_ID30_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID30_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID30_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID31_P01, 0x1f8)
    FIELD(REG_HIGH_ID31_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID31_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID31_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID31_P23, 0x1fc)
    FIELD(REG_HIGH_ID31_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID31_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID31_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID32_P01, 0x200)
    FIELD(REG_HIGH_ID32_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID32_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID32_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID32_P23, 0x204)
    FIELD(REG_HIGH_ID32_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID32_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID32_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID33_P01, 0x208)
    FIELD(REG_HIGH_ID33_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID33_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID33_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID33_P23, 0x20c)
    FIELD(REG_HIGH_ID33_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID33_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID33_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID34_P01, 0x210)
    FIELD(REG_HIGH_ID34_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID34_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID34_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID34_P23, 0x214)
    FIELD(REG_HIGH_ID34_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID34_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID34_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID35_P01, 0x218)
    FIELD(REG_HIGH_ID35_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID35_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID35_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID35_P23, 0x21c)
    FIELD(REG_HIGH_ID35_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID35_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID35_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID36_P01, 0x220)
    FIELD(REG_HIGH_ID36_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID36_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID36_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID36_P23, 0x224)
    FIELD(REG_HIGH_ID36_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID36_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID36_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID37_P01, 0x228)
    FIELD(REG_HIGH_ID37_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID37_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID37_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID37_P23, 0x22c)
    FIELD(REG_HIGH_ID37_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID37_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID37_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID38_P01, 0x230)
    FIELD(REG_HIGH_ID38_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID38_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID38_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID38_P23, 0x234)
    FIELD(REG_HIGH_ID38_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID38_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID38_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID39_P01, 0x238)
    FIELD(REG_HIGH_ID39_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID39_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID39_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID39_P23, 0x23c)
    FIELD(REG_HIGH_ID39_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID39_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID39_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID40_P01, 0x240)
    FIELD(REG_HIGH_ID40_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID40_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID40_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID40_P23, 0x244)
    FIELD(REG_HIGH_ID40_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID40_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID40_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID41_P01, 0x248)
    FIELD(REG_HIGH_ID41_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID41_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID41_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID41_P23, 0x24c)
    FIELD(REG_HIGH_ID41_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID41_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID41_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID42_P01, 0x250)
    FIELD(REG_HIGH_ID42_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID42_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID42_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID42_P23, 0x254)
    FIELD(REG_HIGH_ID42_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID42_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID42_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID43_P01, 0x258)
    FIELD(REG_HIGH_ID43_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID43_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID43_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID43_P23, 0x25c)
    FIELD(REG_HIGH_ID43_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID43_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID43_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID44_P01, 0x260)
    FIELD(REG_HIGH_ID44_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID44_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID44_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID44_P23, 0x264)
    FIELD(REG_HIGH_ID44_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID44_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID44_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID45_P01, 0x268)
    FIELD(REG_HIGH_ID45_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID45_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID45_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID45_P23, 0x26c)
    FIELD(REG_HIGH_ID45_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID45_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID45_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID46_P01, 0x270)
    FIELD(REG_HIGH_ID46_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID46_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID46_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID46_P23, 0x274)
    FIELD(REG_HIGH_ID46_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID46_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID46_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID47_P01, 0x278)
    FIELD(REG_HIGH_ID47_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID47_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID47_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID47_P23, 0x27c)
    FIELD(REG_HIGH_ID47_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID47_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID47_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID48_P01, 0x280)
    FIELD(REG_HIGH_ID48_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID48_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID48_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID48_P23, 0x284)
    FIELD(REG_HIGH_ID48_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID48_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID48_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID49_P01, 0x288)
    FIELD(REG_HIGH_ID49_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID49_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID49_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID49_P23, 0x28c)
    FIELD(REG_HIGH_ID49_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID49_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID49_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID50_P01, 0x290)
    FIELD(REG_HIGH_ID50_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID50_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID50_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID50_P23, 0x294)
    FIELD(REG_HIGH_ID50_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID50_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID50_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID51_P01, 0x298)
    FIELD(REG_HIGH_ID51_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID51_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID51_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID51_P23, 0x29c)
    FIELD(REG_HIGH_ID51_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID51_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID51_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID52_P01, 0x2a0)
    FIELD(REG_HIGH_ID52_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID52_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID52_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID52_P23, 0x2a4)
    FIELD(REG_HIGH_ID52_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID52_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID52_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID53_P01, 0x2a8)
    FIELD(REG_HIGH_ID53_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID53_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID53_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID53_P23, 0x2ac)
    FIELD(REG_HIGH_ID53_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID53_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID53_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID54_P01, 0x2b0)
    FIELD(REG_HIGH_ID54_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID54_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID54_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID54_P23, 0x2b4)
    FIELD(REG_HIGH_ID54_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID54_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID54_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID55_P01, 0x2b8)
    FIELD(REG_HIGH_ID55_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID55_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID55_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID55_P23, 0x2bc)
    FIELD(REG_HIGH_ID55_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID55_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID55_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID56_P01, 0x2c0)
    FIELD(REG_HIGH_ID56_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID56_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID56_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID56_P23, 0x2c4)
    FIELD(REG_HIGH_ID56_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID56_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID56_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID57_P01, 0x2c8)
    FIELD(REG_HIGH_ID57_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID57_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID57_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID57_P23, 0x2cc)
    FIELD(REG_HIGH_ID57_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID57_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID57_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID58_P01, 0x2d0)
    FIELD(REG_HIGH_ID58_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID58_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID58_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID58_P23, 0x2d4)
    FIELD(REG_HIGH_ID58_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID58_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID58_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID59_P01, 0x2d8)
    FIELD(REG_HIGH_ID59_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID59_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID59_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID59_P23, 0x2dc)
    FIELD(REG_HIGH_ID59_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID59_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID59_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID60_P01, 0x2e0)
    FIELD(REG_HIGH_ID60_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID60_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID60_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID60_P23, 0x2e4)
    FIELD(REG_HIGH_ID60_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID60_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID60_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID61_P01, 0x2e8)
    FIELD(REG_HIGH_ID61_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID61_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID61_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID61_P23, 0x2ec)
    FIELD(REG_HIGH_ID61_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID61_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID61_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID62_P01, 0x2f0)
    FIELD(REG_HIGH_ID62_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID62_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID62_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID62_P23, 0x2f4)
    FIELD(REG_HIGH_ID62_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID62_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID62_P23, P2_VC0, 0, 2)
REG32(REG_HIGH_ID63_P01, 0x2f8)
    FIELD(REG_HIGH_ID63_P01, P1_VC7, 30, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC6, 28, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC5, 26, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC4, 24, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC3, 22, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC2, 20, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC1, 18, 2)
    FIELD(REG_HIGH_ID63_P01, P1_VC0, 16, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC7, 14, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC6, 12, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC5, 10, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC4, 8, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC3, 6, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC2, 4, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC1, 2, 2)
    FIELD(REG_HIGH_ID63_P01, P0_VC0, 0, 2)
REG32(REG_HIGH_ID63_P23, 0x2fc)
    FIELD(REG_HIGH_ID63_P23, P3_VC7, 30, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC6, 28, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC5, 26, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC4, 24, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC3, 22, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC2, 20, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC1, 18, 2)
    FIELD(REG_HIGH_ID63_P23, P3_VC0, 16, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC7, 14, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC6, 12, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC5, 10, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC4, 8, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC3, 6, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC2, 4, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC1, 2, 2)
    FIELD(REG_HIGH_ID63_P23, P2_VC0, 0, 2)
REG32(REG_MID_ID0_P01, 0x300)
    FIELD(REG_MID_ID0_P01, P1_VC7, 30, 2)
    FIELD(REG_MID_ID0_P01, P1_VC6, 28, 2)
    FIELD(REG_MID_ID0_P01, P1_VC5, 26, 2)
    FIELD(REG_MID_ID0_P01, P1_VC4, 24, 2)
    FIELD(REG_MID_ID0_P01, P1_VC3, 22, 2)
    FIELD(REG_MID_ID0_P01, P1_VC2, 20, 2)
    FIELD(REG_MID_ID0_P01, P1_VC1, 18, 2)
    FIELD(REG_MID_ID0_P01, P1_VC0, 16, 2)
    FIELD(REG_MID_ID0_P01, P0_VC7, 14, 2)
    FIELD(REG_MID_ID0_P01, P0_VC6, 12, 2)
    FIELD(REG_MID_ID0_P01, P0_VC5, 10, 2)
    FIELD(REG_MID_ID0_P01, P0_VC4, 8, 2)
    FIELD(REG_MID_ID0_P01, P0_VC3, 6, 2)
    FIELD(REG_MID_ID0_P01, P0_VC2, 4, 2)
    FIELD(REG_MID_ID0_P01, P0_VC1, 2, 2)
    FIELD(REG_MID_ID0_P01, P0_VC0, 0, 2)
REG32(REG_MID_ID0_P23, 0x304)
    FIELD(REG_MID_ID0_P23, P3_VC7, 30, 2)
    FIELD(REG_MID_ID0_P23, P3_VC6, 28, 2)
    FIELD(REG_MID_ID0_P23, P3_VC5, 26, 2)
    FIELD(REG_MID_ID0_P23, P3_VC4, 24, 2)
    FIELD(REG_MID_ID0_P23, P3_VC3, 22, 2)
    FIELD(REG_MID_ID0_P23, P3_VC2, 20, 2)
    FIELD(REG_MID_ID0_P23, P3_VC1, 18, 2)
    FIELD(REG_MID_ID0_P23, P3_VC0, 16, 2)
    FIELD(REG_MID_ID0_P23, P2_VC7, 14, 2)
    FIELD(REG_MID_ID0_P23, P2_VC6, 12, 2)
    FIELD(REG_MID_ID0_P23, P2_VC5, 10, 2)
    FIELD(REG_MID_ID0_P23, P2_VC4, 8, 2)
    FIELD(REG_MID_ID0_P23, P2_VC3, 6, 2)
    FIELD(REG_MID_ID0_P23, P2_VC2, 4, 2)
    FIELD(REG_MID_ID0_P23, P2_VC1, 2, 2)
    FIELD(REG_MID_ID0_P23, P2_VC0, 0, 2)
REG32(REG_MID_ID1_P01, 0x308)
    FIELD(REG_MID_ID1_P01, P1_VC7, 30, 2)
    FIELD(REG_MID_ID1_P01, P1_VC6, 28, 2)
    FIELD(REG_MID_ID1_P01, P1_VC5, 26, 2)
    FIELD(REG_MID_ID1_P01, P1_VC4, 24, 2)
    FIELD(REG_MID_ID1_P01, P1_VC3, 22, 2)
    FIELD(REG_MID_ID1_P01, P1_VC2, 20, 2)
    FIELD(REG_MID_ID1_P01, P1_VC1, 18, 2)
    FIELD(REG_MID_ID1_P01, P1_VC0, 16, 2)
    FIELD(REG_MID_ID1_P01, P0_VC7, 14, 2)
    FIELD(REG_MID_ID1_P01, P0_VC6, 12, 2)
    FIELD(REG_MID_ID1_P01, P0_VC5, 10, 2)
    FIELD(REG_MID_ID1_P01, P0_VC4, 8, 2)
    FIELD(REG_MID_ID1_P01, P0_VC3, 6, 2)
    FIELD(REG_MID_ID1_P01, P0_VC2, 4, 2)
    FIELD(REG_MID_ID1_P01, P0_VC1, 2, 2)
    FIELD(REG_MID_ID1_P01, P0_VC0, 0, 2)
REG32(REG_MID_ID1_P23, 0x30c)
    FIELD(REG_MID_ID1_P23, P3_VC7, 30, 2)
    FIELD(REG_MID_ID1_P23, P3_VC6, 28, 2)
    FIELD(REG_MID_ID1_P23, P3_VC5, 26, 2)
    FIELD(REG_MID_ID1_P23, P3_VC4, 24, 2)
    FIELD(REG_MID_ID1_P23, P3_VC3, 22, 2)
    FIELD(REG_MID_ID1_P23, P3_VC2, 20, 2)
    FIELD(REG_MID_ID1_P23, P3_VC1, 18, 2)
    FIELD(REG_MID_ID1_P23, P3_VC0, 16, 2)
    FIELD(REG_MID_ID1_P23, P2_VC7, 14, 2)
    FIELD(REG_MID_ID1_P23, P2_VC6, 12, 2)
    FIELD(REG_MID_ID1_P23, P2_VC5, 10, 2)
    FIELD(REG_MID_ID1_P23, P2_VC4, 8, 2)
    FIELD(REG_MID_ID1_P23, P2_VC3, 6, 2)
    FIELD(REG_MID_ID1_P23, P2_VC2, 4, 2)
    FIELD(REG_MID_ID1_P23, P2_VC1, 2, 2)
    FIELD(REG_MID_ID1_P23, P2_VC0, 0, 2)
REG32(REG_MID_ID2_P01, 0x310)
    FIELD(REG_MID_ID2_P01, P1_VC7, 30, 2)
    FIELD(REG_MID_ID2_P01, P1_VC6, 28, 2)
    FIELD(REG_MID_ID2_P01, P1_VC5, 26, 2)
    FIELD(REG_MID_ID2_P01, P1_VC4, 24, 2)
    FIELD(REG_MID_ID2_P01, P1_VC3, 22, 2)
    FIELD(REG_MID_ID2_P01, P1_VC2, 20, 2)
    FIELD(REG_MID_ID2_P01, P1_VC1, 18, 2)
    FIELD(REG_MID_ID2_P01, P1_VC0, 16, 2)
    FIELD(REG_MID_ID2_P01, P0_VC7, 14, 2)
    FIELD(REG_MID_ID2_P01, P0_VC6, 12, 2)
    FIELD(REG_MID_ID2_P01, P0_VC5, 10, 2)
    FIELD(REG_MID_ID2_P01, P0_VC4, 8, 2)
    FIELD(REG_MID_ID2_P01, P0_VC3, 6, 2)
    FIELD(REG_MID_ID2_P01, P0_VC2, 4, 2)
    FIELD(REG_MID_ID2_P01, P0_VC1, 2, 2)
    FIELD(REG_MID_ID2_P01, P0_VC0, 0, 2)
REG32(REG_MID_ID2_P23, 0x314)
    FIELD(REG_MID_ID2_P23, P3_VC7, 30, 2)
    FIELD(REG_MID_ID2_P23, P3_VC6, 28, 2)
    FIELD(REG_MID_ID2_P23, P3_VC5, 26, 2)
    FIELD(REG_MID_ID2_P23, P3_VC4, 24, 2)
    FIELD(REG_MID_ID2_P23, P3_VC3, 22, 2)
    FIELD(REG_MID_ID2_P23, P3_VC2, 20, 2)
    FIELD(REG_MID_ID2_P23, P3_VC1, 18, 2)
    FIELD(REG_MID_ID2_P23, P3_VC0, 16, 2)
    FIELD(REG_MID_ID2_P23, P2_VC7, 14, 2)
    FIELD(REG_MID_ID2_P23, P2_VC6, 12, 2)
    FIELD(REG_MID_ID2_P23, P2_VC5, 10, 2)
    FIELD(REG_MID_ID2_P23, P2_VC4, 8, 2)
    FIELD(REG_MID_ID2_P23, P2_VC3, 6, 2)
    FIELD(REG_MID_ID2_P23, P2_VC2, 4, 2)
    FIELD(REG_MID_ID2_P23, P2_VC1, 2, 2)
    FIELD(REG_MID_ID2_P23, P2_VC0, 0, 2)
REG32(REG_MID_ID3_P01, 0x318)
    FIELD(REG_MID_ID3_P01, P1_VC7, 30, 2)
    FIELD(REG_MID_ID3_P01, P1_VC6, 28, 2)
    FIELD(REG_MID_ID3_P01, P1_VC5, 26, 2)
    FIELD(REG_MID_ID3_P01, P1_VC4, 24, 2)
    FIELD(REG_MID_ID3_P01, P1_VC3, 22, 2)
    FIELD(REG_MID_ID3_P01, P1_VC2, 20, 2)
    FIELD(REG_MID_ID3_P01, P1_VC1, 18, 2)
    FIELD(REG_MID_ID3_P01, P1_VC0, 16, 2)
    FIELD(REG_MID_ID3_P01, P0_VC7, 14, 2)
    FIELD(REG_MID_ID3_P01, P0_VC6, 12, 2)
    FIELD(REG_MID_ID3_P01, P0_VC5, 10, 2)
    FIELD(REG_MID_ID3_P01, P0_VC4, 8, 2)
    FIELD(REG_MID_ID3_P01, P0_VC3, 6, 2)
    FIELD(REG_MID_ID3_P01, P0_VC2, 4, 2)
    FIELD(REG_MID_ID3_P01, P0_VC1, 2, 2)
    FIELD(REG_MID_ID3_P01, P0_VC0, 0, 2)
REG32(REG_MID_ID3_P23, 0x31c)
    FIELD(REG_MID_ID3_P23, P3_VC7, 30, 2)
    FIELD(REG_MID_ID3_P23, P3_VC6, 28, 2)
    FIELD(REG_MID_ID3_P23, P3_VC5, 26, 2)
    FIELD(REG_MID_ID3_P23, P3_VC4, 24, 2)
    FIELD(REG_MID_ID3_P23, P3_VC3, 22, 2)
    FIELD(REG_MID_ID3_P23, P3_VC2, 20, 2)
    FIELD(REG_MID_ID3_P23, P3_VC1, 18, 2)
    FIELD(REG_MID_ID3_P23, P3_VC0, 16, 2)
    FIELD(REG_MID_ID3_P23, P2_VC7, 14, 2)
    FIELD(REG_MID_ID3_P23, P2_VC6, 12, 2)
    FIELD(REG_MID_ID3_P23, P2_VC5, 10, 2)
    FIELD(REG_MID_ID3_P23, P2_VC4, 8, 2)
    FIELD(REG_MID_ID3_P23, P2_VC3, 6, 2)
    FIELD(REG_MID_ID3_P23, P2_VC2, 4, 2)
    FIELD(REG_MID_ID3_P23, P2_VC1, 2, 2)
    FIELD(REG_MID_ID3_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID0_P01, 0x320)
    FIELD(REG_LOW_ID0_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID0_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID0_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID0_P23, 0x324)
    FIELD(REG_LOW_ID0_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID0_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID0_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID1_P01, 0x328)
    FIELD(REG_LOW_ID1_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID1_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID1_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID1_P23, 0x32c)
    FIELD(REG_LOW_ID1_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID1_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID1_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID2_P01, 0x330)
    FIELD(REG_LOW_ID2_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID2_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID2_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID2_P23, 0x334)
    FIELD(REG_LOW_ID2_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID2_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID2_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID3_P01, 0x338)
    FIELD(REG_LOW_ID3_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID3_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID3_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID3_P23, 0x33c)
    FIELD(REG_LOW_ID3_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID3_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID3_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID4_P01, 0x340)
    FIELD(REG_LOW_ID4_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID4_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID4_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID4_P23, 0x344)
    FIELD(REG_LOW_ID4_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID4_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID4_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID5_P01, 0x348)
    FIELD(REG_LOW_ID5_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID5_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID5_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID5_P23, 0x34c)
    FIELD(REG_LOW_ID5_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID5_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID5_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID6_P01, 0x350)
    FIELD(REG_LOW_ID6_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID6_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID6_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID6_P23, 0x354)
    FIELD(REG_LOW_ID6_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID6_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID6_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID7_P01, 0x358)
    FIELD(REG_LOW_ID7_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID7_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID7_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID7_P23, 0x35c)
    FIELD(REG_LOW_ID7_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID7_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID7_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID8_P01, 0x360)
    FIELD(REG_LOW_ID8_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID8_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID8_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID8_P23, 0x364)
    FIELD(REG_LOW_ID8_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID8_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID8_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID9_P01, 0x368)
    FIELD(REG_LOW_ID9_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID9_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID9_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID9_P23, 0x36c)
    FIELD(REG_LOW_ID9_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID9_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID9_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID10_P01, 0x370)
    FIELD(REG_LOW_ID10_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID10_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID10_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID10_P23, 0x374)
    FIELD(REG_LOW_ID10_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID10_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID10_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID11_P01, 0x378)
    FIELD(REG_LOW_ID11_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID11_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID11_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID11_P23, 0x37c)
    FIELD(REG_LOW_ID11_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID11_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID11_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID12_P01, 0x380)
    FIELD(REG_LOW_ID12_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID12_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID12_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID12_P23, 0x384)
    FIELD(REG_LOW_ID12_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID12_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID12_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID13_P01, 0x388)
    FIELD(REG_LOW_ID13_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID13_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID13_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID13_P23, 0x38c)
    FIELD(REG_LOW_ID13_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID13_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID13_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID14_P01, 0x390)
    FIELD(REG_LOW_ID14_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID14_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID14_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID14_P23, 0x394)
    FIELD(REG_LOW_ID14_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID14_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID14_P23, P2_VC0, 0, 2)
REG32(REG_LOW_ID15_P01, 0x398)
    FIELD(REG_LOW_ID15_P01, P1_VC7, 30, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC6, 28, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC5, 26, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC4, 24, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC3, 22, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC2, 20, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC1, 18, 2)
    FIELD(REG_LOW_ID15_P01, P1_VC0, 16, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC7, 14, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC6, 12, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC5, 10, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC4, 8, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC3, 6, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC2, 4, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC1, 2, 2)
    FIELD(REG_LOW_ID15_P01, P0_VC0, 0, 2)
REG32(REG_LOW_ID15_P23, 0x39c)
    FIELD(REG_LOW_ID15_P23, P3_VC7, 30, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC6, 28, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC5, 26, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC4, 24, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC3, 22, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC2, 20, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC1, 18, 2)
    FIELD(REG_LOW_ID15_P23, P3_VC0, 16, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC7, 14, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC6, 12, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC5, 10, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC4, 8, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC3, 6, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC2, 4, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC1, 2, 2)
    FIELD(REG_LOW_ID15_P23, P2_VC0, 0, 2)
REG32(REG_ID, 0x3a0)
    FIELD(REG_ID, HIGH_ID, 4, 6)
    FIELD(REG_ID, MID_ID, 0, 2)
REG32(REG_P00_P1_0_VCA_TOKEN, 0x3a4)
    FIELD(REG_P00_P1_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P00_P1_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P00_P1_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P00_P1_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P00_P1_1_VCA_TOKEN, 0x3a8)
    FIELD(REG_P00_P1_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P00_P1_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P00_P1_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P00_P1_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P01_P2_0_VCA_TOKEN, 0x3ac)
    FIELD(REG_P01_P2_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P01_P2_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P01_P2_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P01_P2_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P01_P2_1_VCA_TOKEN, 0x3b0)
    FIELD(REG_P01_P2_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P01_P2_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P01_P2_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P01_P2_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P02_P3_0_VCA_TOKEN, 0x3b4)
    FIELD(REG_P02_P3_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P02_P3_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P02_P3_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P02_P3_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P02_P3_1_VCA_TOKEN, 0x3b8)
    FIELD(REG_P02_P3_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P02_P3_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P02_P3_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P02_P3_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P10_P2_0_VCA_TOKEN, 0x3bc)
    FIELD(REG_P10_P2_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P10_P2_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P10_P2_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P10_P2_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P10_P2_1_VCA_TOKEN, 0x3c0)
    FIELD(REG_P10_P2_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P10_P2_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P10_P2_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P10_P2_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P11_P3_0_VCA_TOKEN, 0x3c4)
    FIELD(REG_P11_P3_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P11_P3_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P11_P3_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P11_P3_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P11_P3_1_VCA_TOKEN, 0x3c8)
    FIELD(REG_P11_P3_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P11_P3_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P11_P3_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P11_P3_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P12_P0_0_VCA_TOKEN, 0x3cc)
    FIELD(REG_P12_P0_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P12_P0_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P12_P0_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P12_P0_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P12_P0_1_VCA_TOKEN, 0x3d0)
    FIELD(REG_P12_P0_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P12_P0_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P12_P0_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P12_P0_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P20_P3_0_VCA_TOKEN, 0x3d4)
    FIELD(REG_P20_P3_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P20_P3_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P20_P3_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P20_P3_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P20_P3_1_VCA_TOKEN, 0x3d8)
    FIELD(REG_P20_P3_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P20_P3_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P20_P3_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P20_P3_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P21_P0_0_VCA_TOKEN, 0x3dc)
    FIELD(REG_P21_P0_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P21_P0_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P21_P0_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P21_P0_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P21_P0_1_VCA_TOKEN, 0x3e0)
    FIELD(REG_P21_P0_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P21_P0_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P21_P0_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P21_P0_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P22_P1_0_VCA_TOKEN, 0x3e4)
    FIELD(REG_P22_P1_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P22_P1_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P22_P1_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P22_P1_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P22_P1_1_VCA_TOKEN, 0x3e8)
    FIELD(REG_P22_P1_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P22_P1_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P22_P1_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P22_P1_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P30_P0_0_VCA_TOKEN, 0x3ec)
    FIELD(REG_P30_P0_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P30_P0_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P30_P0_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P30_P0_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P30_P0_1_VCA_TOKEN, 0x3f0)
    FIELD(REG_P30_P0_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P30_P0_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P30_P0_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P30_P0_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P31_P1_0_VCA_TOKEN, 0x3f4)
    FIELD(REG_P31_P1_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P31_P1_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P31_P1_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P31_P1_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P31_P1_1_VCA_TOKEN, 0x3f8)
    FIELD(REG_P31_P1_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P31_P1_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P31_P1_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P31_P1_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_P32_P2_0_VCA_TOKEN, 0x3fc)
    FIELD(REG_P32_P2_0_VCA_TOKEN, VC3, 24, 8)
    FIELD(REG_P32_P2_0_VCA_TOKEN, VC2, 16, 8)
    FIELD(REG_P32_P2_0_VCA_TOKEN, VC1, 8, 8)
    FIELD(REG_P32_P2_0_VCA_TOKEN, VC0, 0, 8)
REG32(REG_P32_P2_1_VCA_TOKEN, 0x400)
    FIELD(REG_P32_P2_1_VCA_TOKEN, VC7, 24, 8)
    FIELD(REG_P32_P2_1_VCA_TOKEN, VC6, 16, 8)
    FIELD(REG_P32_P2_1_VCA_TOKEN, VC5, 8, 8)
    FIELD(REG_P32_P2_1_VCA_TOKEN, VC4, 0, 8)
REG32(REG_NOC_CTL, 0x404)
    FIELD(REG_NOC_CTL, EN_VC7_TOKEN, 15, 1)
    FIELD(REG_NOC_CTL, EN_VC6_TOKEN, 14, 1)
    FIELD(REG_NOC_CTL, EN_VC5_TOKEN, 13, 1)
    FIELD(REG_NOC_CTL, EN_VC4_TOKEN, 12, 1)
    FIELD(REG_NOC_CTL, EN_VC3_TOKEN, 11, 1)
    FIELD(REG_NOC_CTL, EN_VC2_TOKEN, 10, 1)
    FIELD(REG_NOC_CTL, EN_VC1_TOKEN, 9, 1)
    FIELD(REG_NOC_CTL, EN_VC0_TOKEN, 8, 1)
    FIELD(REG_NOC_CTL, EN_DBI, 2, 1)
    FIELD(REG_NOC_CTL, CLK_GATE_DIS_NPS, 0, 1)
REG32(REG_P0_CTL, 0x408)
    FIELD(REG_P0_CTL, PERF_MON_VC_SEL, 5, 3)
    FIELD(REG_P0_CTL, PERF_MON_MODE, 4, 1)
    FIELD(REG_P0_CTL, EN_PERF_MON, 3, 1)
    FIELD(REG_P0_CTL, TB_SEL, 0, 3)
REG32(REG_P0_0_PERF_MON, 0x40c)
REG32(REG_P0_1_PERF_MON, 0x410)
    FIELD(REG_P0_1_PERF_MON, OVF, 31, 1)
    FIELD(REG_P0_1_PERF_MON, COUNT1, 0, 31)
REG32(REG_P1_CTL, 0x414)
    FIELD(REG_P1_CTL, PERF_MON_VC_SEL, 5, 3)
    FIELD(REG_P1_CTL, PERF_MON_MODE, 4, 1)
    FIELD(REG_P1_CTL, EN_PERF_MON, 3, 1)
    FIELD(REG_P1_CTL, TB_SEL, 0, 3)
REG32(REG_P1_0_PERF_MON, 0x418)
REG32(REG_P1_1_PERF_MON, 0x41c)
    FIELD(REG_P1_1_PERF_MON, OVF, 31, 1)
    FIELD(REG_P1_1_PERF_MON, COUNT1, 0, 31)
REG32(REG_P2_CTL, 0x420)
    FIELD(REG_P2_CTL, PERF_MON_VC_SEL, 5, 3)
    FIELD(REG_P2_CTL, PERF_MON_MODE, 4, 1)
    FIELD(REG_P2_CTL, EN_PERF_MON, 3, 1)
    FIELD(REG_P2_CTL, TB_SEL, 0, 3)
REG32(REG_P2_0_PERF_MON, 0x424)
REG32(REG_P2_1_PERF_MON, 0x428)
    FIELD(REG_P2_1_PERF_MON, OVF, 31, 1)
    FIELD(REG_P2_1_PERF_MON, COUNT1, 0, 31)
REG32(REG_P3_CTL, 0x42c)
    FIELD(REG_P3_CTL, PERF_MON_VC_SEL, 5, 3)
    FIELD(REG_P3_CTL, PERF_MON_MODE, 4, 1)
    FIELD(REG_P3_CTL, EN_PERF_MON, 3, 1)
    FIELD(REG_P3_CTL, TB_SEL, 0, 3)
REG32(REG_P3_0_PERF_MON, 0x430)
REG32(REG_P3_1_PERF_MON, 0x434)
    FIELD(REG_P3_1_PERF_MON, OVF, 31, 1)
    FIELD(REG_P3_1_PERF_MON, COUNT1, 0, 31)
REG32(REG_PORT_STATUS, 0x438)
    FIELD(REG_PORT_STATUS, P3_BUSY, 3, 1)
    FIELD(REG_PORT_STATUS, P2_BUSY, 2, 1)
    FIELD(REG_PORT_STATUS, P1_BUSY, 1, 1)
    FIELD(REG_PORT_STATUS, P0_BUSY, 0, 1)
REG32(REG_ERR_LOG_EN, 0x43c)
    FIELD(REG_ERR_LOG_EN, VC_BUF_OVF_ERR, 5, 1)
    FIELD(REG_ERR_LOG_EN, DBI_PAR_ERR, 4, 1)
    FIELD(REG_ERR_LOG_EN, CRDT_OVF_ERR, 3, 1)
    FIELD(REG_ERR_LOG_EN, CRDT_RDY_ERR, 2, 1)
    FIELD(REG_ERR_LOG_EN, ROUTE_ERR, 1, 1)
    FIELD(REG_ERR_LOG_EN, PAR_ERR, 0, 1)
REG32(REG_ERR_LOG_P0_1ST_ERR_NUM, 0x440)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, ETYP, 20, 2)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_ERR_LOG_P0_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_ERR_LOG_P0_INFO_0, 0x444)
    FIELD(REG_ERR_LOG_P0_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_P0_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_P0_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_P0_INFO_1, 0x448)
    FIELD(REG_ERR_LOG_P0_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_P0_INFO_1, WRSTB, 8, 16)
    FIELD(REG_ERR_LOG_P0_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_P0_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_P0_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_P0_INFO_1, PACKET_TYPE, 0, 4)
REG32(REG_ERR_LOG_P0_INFO_2, 0x44c)
    FIELD(REG_ERR_LOG_P0_INFO_2, DBI_BUS, 16, 16)
    FIELD(REG_ERR_LOG_P0_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_P0_INFO_2, DBI_PAR, 8, 1)
    FIELD(REG_ERR_LOG_P0_INFO_2, VC, 0, 8)
REG32(REG_ERR_LOG_P1_1ST_ERR_NUM, 0x450)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, ETYP, 20, 2)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_ERR_LOG_P1_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_ERR_LOG_P1_INFO_0, 0x454)
    FIELD(REG_ERR_LOG_P1_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_P1_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_P1_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_P1_INFO_1, 0x458)
    FIELD(REG_ERR_LOG_P1_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_P1_INFO_1, WRSTB, 8, 16)
    FIELD(REG_ERR_LOG_P1_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_P1_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_P1_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_P1_INFO_1, PACKET_TYPE, 0, 4)
REG32(REG_ERR_LOG_P1_INFO_2, 0x45c)
    FIELD(REG_ERR_LOG_P1_INFO_2, DBI_BUS, 16, 16)
    FIELD(REG_ERR_LOG_P1_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_P1_INFO_2, DBI_PAR, 8, 1)
    FIELD(REG_ERR_LOG_P1_INFO_2, VC, 0, 8)
REG32(REG_ERR_LOG_P2_1ST_ERR_NUM, 0x460)
    FIELD(REG_ERR_LOG_P2_1ST_ERR_NUM, ETYP, 20, 2)
    FIELD(REG_ERR_LOG_P2_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_ERR_LOG_P2_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_ERR_LOG_P2_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_ERR_LOG_P2_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_ERR_LOG_P2_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_ERR_LOG_P2_INFO_0, 0x464)
    FIELD(REG_ERR_LOG_P2_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_P2_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_P2_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_P2_INFO_1, 0x468)
    FIELD(REG_ERR_LOG_P2_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_P2_INFO_1, WRSTB, 8, 16)
    FIELD(REG_ERR_LOG_P2_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_P2_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_P2_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_P2_INFO_1, PACKET_TYPE, 0, 4)
REG32(REG_ERR_LOG_P2_INFO_2, 0x46c)
    FIELD(REG_ERR_LOG_P2_INFO_2, DBI_BUS, 16, 16)
    FIELD(REG_ERR_LOG_P2_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_P2_INFO_2, DBI_PAR, 8, 1)
    FIELD(REG_ERR_LOG_P2_INFO_2, VC, 0, 8)
REG32(REG_ERR_LOG_P3_1ST_ERR_NUM, 0x470)
    FIELD(REG_ERR_LOG_P3_1ST_ERR_NUM, ETYP, 20, 2)
    FIELD(REG_ERR_LOG_P3_1ST_ERR_NUM, ENUMB, 16, 4)
    FIELD(REG_ERR_LOG_P3_1ST_ERR_NUM, SUBC1, 12, 4)
    FIELD(REG_ERR_LOG_P3_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_ERR_LOG_P3_1ST_ERR_NUM, COMP, 4, 4)
    FIELD(REG_ERR_LOG_P3_1ST_ERR_NUM, CATEG, 0, 4)
REG32(REG_ERR_LOG_P3_INFO_0, 0x474)
    FIELD(REG_ERR_LOG_P3_INFO_0, DST, 20, 12)
    FIELD(REG_ERR_LOG_P3_INFO_0, SRC, 8, 12)
    FIELD(REG_ERR_LOG_P3_INFO_0, TAG, 0, 8)
REG32(REG_ERR_LOG_P3_INFO_1, 0x478)
    FIELD(REG_ERR_LOG_P3_INFO_1, LAST, 24, 1)
    FIELD(REG_ERR_LOG_P3_INFO_1, WRSTB, 8, 16)
    FIELD(REG_ERR_LOG_P3_INFO_1, PRI, 7, 1)
    FIELD(REG_ERR_LOG_P3_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_ERR_LOG_P3_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_ERR_LOG_P3_INFO_1, PACKET_TYPE, 0, 4)
REG32(REG_ERR_LOG_P3_INFO_2, 0x47c)
    FIELD(REG_ERR_LOG_P3_INFO_2, DBI_BUS, 16, 16)
    FIELD(REG_ERR_LOG_P3_INFO_2, POISON, 9, 1)
    FIELD(REG_ERR_LOG_P3_INFO_2, DBI_PAR, 8, 1)
    FIELD(REG_ERR_LOG_P3_INFO_2, VC, 0, 8)
REG32(REG_DBG_MUX_CTRL, 0x480)
    FIELD(REG_DBG_MUX_CTRL, DAT_DISC, 8, 1)
    FIELD(REG_DBG_MUX_CTRL, POST_TRIG_CNT, 5, 3)
    FIELD(REG_DBG_MUX_CTRL, CLK_DIV, 4, 1)
    FIELD(REG_DBG_MUX_CTRL, TRIG_EN, 3, 1)
    FIELD(REG_DBG_MUX_CTRL, DBG_EN, 2, 1)
    FIELD(REG_DBG_MUX_CTRL, IN_SEL, 1, 1)
    FIELD(REG_DBG_MUX_CTRL, OUT_SEL, 0, 1)
REG32(REG_DBG_MUX_STATUS, 0x484)
    FIELD(REG_DBG_MUX_STATUS, TRIG_DONE, 0, 1)
REG32(REG_DBG, 0x488)
    FIELD(REG_DBG, FLIT_OUT_SEL, 13, 2)
    FIELD(REG_DBG, CNTRL_OUT_SEL, 9, 4)
    FIELD(REG_DBG, CNTRL_SEL, 7, 2)
    FIELD(REG_DBG, FLIT_IN_SEL, 5, 2)
    FIELD(REG_DBG, CNTRL_IN_SEL, 4, 1)
    FIELD(REG_DBG, OUT_PORT_SEL, 2, 2)
    FIELD(REG_DBG, IN_PORT_SEL, 0, 2)
REG32(REG_DBG_TRIG_0, 0x48c)
    FIELD(REG_DBG_TRIG_0, VC_VLD_IN, 24, 8)
    FIELD(REG_DBG_TRIG_0, BUF_OVF, 16, 8)
    FIELD(REG_DBG_TRIG_0, INIT, 8, 8)
    FIELD(REG_DBG_TRIG_0, NOT_EMPTY, 0, 8)
REG32(REG_DBG_TRIG_1, 0x490)
    FIELD(REG_DBG_TRIG_1, GRANT, 2, 24)
    FIELD(REG_DBG_TRIG_1, PAR_ERR, 1, 1)
    FIELD(REG_DBG_TRIG_1, BUSY, 0, 1)
REG32(REG_DBG_TRIG_2, 0x494)
    FIELD(REG_DBG_TRIG_2, VC_VLD_OUT, 24, 8)
    FIELD(REG_DBG_TRIG_2, REQ, 0, 24)
REG32(REG_DBG_TRIG_3, 0x498)
    FIELD(REG_DBG_TRIG_3, SOP, 24, 8)
    FIELD(REG_DBG_TRIG_3, TKN_RDY, 0, 24)
REG32(REG_DBG_TRIG_4, 0x49c)
    FIELD(REG_DBG_TRIG_4, CRDT_ZERO, 0, 8)

#define NOC_NPS_R_MAX (0x1000 / 4)

#define LOCK_VAL 0xF9E8D7C6

typedef struct NOC_NPS {
    SysBusDevice parent_obj;
    RegisterInfoArray *reg_array;

    uint32_t regs[NOC_NPS_R_MAX];
    RegisterInfo regs_info[NOC_NPS_R_MAX];
} NOC_NPS;

static void noc_nps_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    NOC_NPS *s = XILINX_NOC_NPS(reg->opaque);
    bool locked = val64 != LOCK_VAL;

    ARRAY_FIELD_DP32(s->regs, REG_PCSR_STATUS, PCSRLOCK, locked);
}

static const RegisterAccessInfo noc_nps_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xfee47f00,
        .ro = 0xe47f00,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1000000,
        .rsvd = 0xfee47f00,
        .ro = 0xe47f00,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_PCSRLOCK_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_CALDONE_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = noc_nps_lock_postw
    },{ .name = "REG_CLOCK_MUX",  .addr = A_REG_CLOCK_MUX,
    },{ .name = "REG_ITR",  .addr = A_REG_ITR,
        .rsvd = 0xfe000000,
    },{ .name = "REG_ISR",  .addr = A_REG_ISR,
        .rsvd = 0xfe000000,
        .w1c = 0x1ffffff,
    },{ .name = "REG_IMR0",  .addr = A_REG_IMR0,
        .reset = 0x1efffff,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_IER0",  .addr = A_REG_IER0,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IDR0",  .addr = A_REG_IDR0,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IMR1",  .addr = A_REG_IMR1,
        .reset = 0x1ffffff,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_IER1",  .addr = A_REG_IER1,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IDR1",  .addr = A_REG_IDR1,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IMR2",  .addr = A_REG_IMR2,
        .reset = 0x1ffffff,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_IER2",  .addr = A_REG_IER2,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IDR2",  .addr = A_REG_IDR2,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IMR3",  .addr = A_REG_IMR3,
        .reset = 0x1ffffff,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_IER3",  .addr = A_REG_IER3,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IDR3",  .addr = A_REG_IDR3,
        .rsvd = 0xfe000000,
    },{ .name = "REG_IOR",  .addr = A_REG_IOR,
        .reset = 0x10,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_HIGH_ID0_P01",  .addr = A_REG_HIGH_ID0_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID0_P23",  .addr = A_REG_HIGH_ID0_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID1_P01",  .addr = A_REG_HIGH_ID1_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID1_P23",  .addr = A_REG_HIGH_ID1_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID2_P01",  .addr = A_REG_HIGH_ID2_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID2_P23",  .addr = A_REG_HIGH_ID2_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID3_P01",  .addr = A_REG_HIGH_ID3_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID3_P23",  .addr = A_REG_HIGH_ID3_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID4_P01",  .addr = A_REG_HIGH_ID4_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID4_P23",  .addr = A_REG_HIGH_ID4_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID5_P01",  .addr = A_REG_HIGH_ID5_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID5_P23",  .addr = A_REG_HIGH_ID5_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID6_P01",  .addr = A_REG_HIGH_ID6_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID6_P23",  .addr = A_REG_HIGH_ID6_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID7_P01",  .addr = A_REG_HIGH_ID7_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID7_P23",  .addr = A_REG_HIGH_ID7_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID8_P01",  .addr = A_REG_HIGH_ID8_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID8_P23",  .addr = A_REG_HIGH_ID8_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID9_P01",  .addr = A_REG_HIGH_ID9_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID9_P23",  .addr = A_REG_HIGH_ID9_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID10_P01",  .addr = A_REG_HIGH_ID10_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID10_P23",  .addr = A_REG_HIGH_ID10_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID11_P01",  .addr = A_REG_HIGH_ID11_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID11_P23",  .addr = A_REG_HIGH_ID11_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID12_P01",  .addr = A_REG_HIGH_ID12_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID12_P23",  .addr = A_REG_HIGH_ID12_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID13_P01",  .addr = A_REG_HIGH_ID13_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID13_P23",  .addr = A_REG_HIGH_ID13_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID14_P01",  .addr = A_REG_HIGH_ID14_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID14_P23",  .addr = A_REG_HIGH_ID14_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID15_P01",  .addr = A_REG_HIGH_ID15_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID15_P23",  .addr = A_REG_HIGH_ID15_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID16_P01",  .addr = A_REG_HIGH_ID16_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID16_P23",  .addr = A_REG_HIGH_ID16_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID17_P01",  .addr = A_REG_HIGH_ID17_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID17_P23",  .addr = A_REG_HIGH_ID17_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID18_P01",  .addr = A_REG_HIGH_ID18_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID18_P23",  .addr = A_REG_HIGH_ID18_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID19_P01",  .addr = A_REG_HIGH_ID19_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID19_P23",  .addr = A_REG_HIGH_ID19_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID20_P01",  .addr = A_REG_HIGH_ID20_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID20_P23",  .addr = A_REG_HIGH_ID20_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID21_P01",  .addr = A_REG_HIGH_ID21_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID21_P23",  .addr = A_REG_HIGH_ID21_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID22_P01",  .addr = A_REG_HIGH_ID22_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID22_P23",  .addr = A_REG_HIGH_ID22_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID23_P01",  .addr = A_REG_HIGH_ID23_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID23_P23",  .addr = A_REG_HIGH_ID23_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID24_P01",  .addr = A_REG_HIGH_ID24_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID24_P23",  .addr = A_REG_HIGH_ID24_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID25_P01",  .addr = A_REG_HIGH_ID25_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID25_P23",  .addr = A_REG_HIGH_ID25_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID26_P01",  .addr = A_REG_HIGH_ID26_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID26_P23",  .addr = A_REG_HIGH_ID26_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID27_P01",  .addr = A_REG_HIGH_ID27_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID27_P23",  .addr = A_REG_HIGH_ID27_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID28_P01",  .addr = A_REG_HIGH_ID28_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID28_P23",  .addr = A_REG_HIGH_ID28_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID29_P01",  .addr = A_REG_HIGH_ID29_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID29_P23",  .addr = A_REG_HIGH_ID29_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID30_P01",  .addr = A_REG_HIGH_ID30_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID30_P23",  .addr = A_REG_HIGH_ID30_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID31_P01",  .addr = A_REG_HIGH_ID31_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID31_P23",  .addr = A_REG_HIGH_ID31_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID32_P01",  .addr = A_REG_HIGH_ID32_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID32_P23",  .addr = A_REG_HIGH_ID32_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID33_P01",  .addr = A_REG_HIGH_ID33_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID33_P23",  .addr = A_REG_HIGH_ID33_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID34_P01",  .addr = A_REG_HIGH_ID34_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID34_P23",  .addr = A_REG_HIGH_ID34_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID35_P01",  .addr = A_REG_HIGH_ID35_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID35_P23",  .addr = A_REG_HIGH_ID35_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID36_P01",  .addr = A_REG_HIGH_ID36_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID36_P23",  .addr = A_REG_HIGH_ID36_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID37_P01",  .addr = A_REG_HIGH_ID37_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID37_P23",  .addr = A_REG_HIGH_ID37_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID38_P01",  .addr = A_REG_HIGH_ID38_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID38_P23",  .addr = A_REG_HIGH_ID38_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID39_P01",  .addr = A_REG_HIGH_ID39_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID39_P23",  .addr = A_REG_HIGH_ID39_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID40_P01",  .addr = A_REG_HIGH_ID40_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID40_P23",  .addr = A_REG_HIGH_ID40_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID41_P01",  .addr = A_REG_HIGH_ID41_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID41_P23",  .addr = A_REG_HIGH_ID41_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID42_P01",  .addr = A_REG_HIGH_ID42_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID42_P23",  .addr = A_REG_HIGH_ID42_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID43_P01",  .addr = A_REG_HIGH_ID43_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID43_P23",  .addr = A_REG_HIGH_ID43_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID44_P01",  .addr = A_REG_HIGH_ID44_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID44_P23",  .addr = A_REG_HIGH_ID44_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID45_P01",  .addr = A_REG_HIGH_ID45_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID45_P23",  .addr = A_REG_HIGH_ID45_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID46_P01",  .addr = A_REG_HIGH_ID46_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID46_P23",  .addr = A_REG_HIGH_ID46_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID47_P01",  .addr = A_REG_HIGH_ID47_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID47_P23",  .addr = A_REG_HIGH_ID47_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID48_P01",  .addr = A_REG_HIGH_ID48_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID48_P23",  .addr = A_REG_HIGH_ID48_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID49_P01",  .addr = A_REG_HIGH_ID49_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID49_P23",  .addr = A_REG_HIGH_ID49_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID50_P01",  .addr = A_REG_HIGH_ID50_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID50_P23",  .addr = A_REG_HIGH_ID50_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID51_P01",  .addr = A_REG_HIGH_ID51_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID51_P23",  .addr = A_REG_HIGH_ID51_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID52_P01",  .addr = A_REG_HIGH_ID52_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID52_P23",  .addr = A_REG_HIGH_ID52_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID53_P01",  .addr = A_REG_HIGH_ID53_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID53_P23",  .addr = A_REG_HIGH_ID53_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID54_P01",  .addr = A_REG_HIGH_ID54_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID54_P23",  .addr = A_REG_HIGH_ID54_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID55_P01",  .addr = A_REG_HIGH_ID55_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID55_P23",  .addr = A_REG_HIGH_ID55_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID56_P01",  .addr = A_REG_HIGH_ID56_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID56_P23",  .addr = A_REG_HIGH_ID56_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID57_P01",  .addr = A_REG_HIGH_ID57_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID57_P23",  .addr = A_REG_HIGH_ID57_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID58_P01",  .addr = A_REG_HIGH_ID58_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID58_P23",  .addr = A_REG_HIGH_ID58_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID59_P01",  .addr = A_REG_HIGH_ID59_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID59_P23",  .addr = A_REG_HIGH_ID59_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID60_P01",  .addr = A_REG_HIGH_ID60_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID60_P23",  .addr = A_REG_HIGH_ID60_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID61_P01",  .addr = A_REG_HIGH_ID61_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID61_P23",  .addr = A_REG_HIGH_ID61_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID62_P01",  .addr = A_REG_HIGH_ID62_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID62_P23",  .addr = A_REG_HIGH_ID62_P23,
        .reset = 0x55550000,
    },{ .name = "REG_HIGH_ID63_P01",  .addr = A_REG_HIGH_ID63_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_HIGH_ID63_P23",  .addr = A_REG_HIGH_ID63_P23,
        .reset = 0x55550000,
    },{ .name = "REG_MID_ID0_P01",  .addr = A_REG_MID_ID0_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_MID_ID0_P23",  .addr = A_REG_MID_ID0_P23,
        .reset = 0x55550000,
    },{ .name = "REG_MID_ID1_P01",  .addr = A_REG_MID_ID1_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_MID_ID1_P23",  .addr = A_REG_MID_ID1_P23,
        .reset = 0x55550000,
    },{ .name = "REG_MID_ID2_P01",  .addr = A_REG_MID_ID2_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_MID_ID2_P23",  .addr = A_REG_MID_ID2_P23,
        .reset = 0x55550000,
    },{ .name = "REG_MID_ID3_P01",  .addr = A_REG_MID_ID3_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_MID_ID3_P23",  .addr = A_REG_MID_ID3_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID0_P01",  .addr = A_REG_LOW_ID0_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID0_P23",  .addr = A_REG_LOW_ID0_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID1_P01",  .addr = A_REG_LOW_ID1_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID1_P23",  .addr = A_REG_LOW_ID1_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID2_P01",  .addr = A_REG_LOW_ID2_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID2_P23",  .addr = A_REG_LOW_ID2_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID3_P01",  .addr = A_REG_LOW_ID3_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID3_P23",  .addr = A_REG_LOW_ID3_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID4_P01",  .addr = A_REG_LOW_ID4_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID4_P23",  .addr = A_REG_LOW_ID4_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID5_P01",  .addr = A_REG_LOW_ID5_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID5_P23",  .addr = A_REG_LOW_ID5_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID6_P01",  .addr = A_REG_LOW_ID6_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID6_P23",  .addr = A_REG_LOW_ID6_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID7_P01",  .addr = A_REG_LOW_ID7_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID7_P23",  .addr = A_REG_LOW_ID7_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID8_P01",  .addr = A_REG_LOW_ID8_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID8_P23",  .addr = A_REG_LOW_ID8_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID9_P01",  .addr = A_REG_LOW_ID9_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID9_P23",  .addr = A_REG_LOW_ID9_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID10_P01",  .addr = A_REG_LOW_ID10_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID10_P23",  .addr = A_REG_LOW_ID10_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID11_P01",  .addr = A_REG_LOW_ID11_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID11_P23",  .addr = A_REG_LOW_ID11_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID12_P01",  .addr = A_REG_LOW_ID12_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID12_P23",  .addr = A_REG_LOW_ID12_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID13_P01",  .addr = A_REG_LOW_ID13_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID13_P23",  .addr = A_REG_LOW_ID13_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID14_P01",  .addr = A_REG_LOW_ID14_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID14_P23",  .addr = A_REG_LOW_ID14_P23,
        .reset = 0x55550000,
    },{ .name = "REG_LOW_ID15_P01",  .addr = A_REG_LOW_ID15_P01,
        .reset = 0xffffaaaa,
    },{ .name = "REG_LOW_ID15_P23",  .addr = A_REG_LOW_ID15_P23,
        .reset = 0x55550000,
    },{ .name = "REG_ID",  .addr = A_REG_ID,
        .rsvd = 0xfffffc0c,
        .ro = 0xc,
    },{ .name = "REG_P00_P1_0_VCA_TOKEN",  .addr = A_REG_P00_P1_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P00_P1_1_VCA_TOKEN",  .addr = A_REG_P00_P1_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P01_P2_0_VCA_TOKEN",  .addr = A_REG_P01_P2_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P01_P2_1_VCA_TOKEN",  .addr = A_REG_P01_P2_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P02_P3_0_VCA_TOKEN",  .addr = A_REG_P02_P3_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P02_P3_1_VCA_TOKEN",  .addr = A_REG_P02_P3_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P10_P2_0_VCA_TOKEN",  .addr = A_REG_P10_P2_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P10_P2_1_VCA_TOKEN",  .addr = A_REG_P10_P2_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P11_P3_0_VCA_TOKEN",  .addr = A_REG_P11_P3_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P11_P3_1_VCA_TOKEN",  .addr = A_REG_P11_P3_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P12_P0_0_VCA_TOKEN",  .addr = A_REG_P12_P0_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P12_P0_1_VCA_TOKEN",  .addr = A_REG_P12_P0_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P20_P3_0_VCA_TOKEN",  .addr = A_REG_P20_P3_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P20_P3_1_VCA_TOKEN",  .addr = A_REG_P20_P3_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P21_P0_0_VCA_TOKEN",  .addr = A_REG_P21_P0_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P21_P0_1_VCA_TOKEN",  .addr = A_REG_P21_P0_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P22_P1_0_VCA_TOKEN",  .addr = A_REG_P22_P1_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P22_P1_1_VCA_TOKEN",  .addr = A_REG_P22_P1_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P30_P0_0_VCA_TOKEN",  .addr = A_REG_P30_P0_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P30_P0_1_VCA_TOKEN",  .addr = A_REG_P30_P0_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P31_P1_0_VCA_TOKEN",  .addr = A_REG_P31_P1_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P31_P1_1_VCA_TOKEN",  .addr = A_REG_P31_P1_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P32_P2_0_VCA_TOKEN",  .addr = A_REG_P32_P2_0_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_P32_P2_1_VCA_TOKEN",  .addr = A_REG_P32_P2_1_VCA_TOKEN,
        .reset = 0x10101010,
    },{ .name = "REG_NOC_CTL",  .addr = A_REG_NOC_CTL,
        .reset = 0xff00,
        .rsvd = 0xffff00fa,
        .ro = 0xfa,
    },{ .name = "REG_P0_CTL",  .addr = A_REG_P0_CTL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_P0_0_PERF_MON",  .addr = A_REG_P0_0_PERF_MON,
    },{ .name = "REG_P0_1_PERF_MON",  .addr = A_REG_P0_1_PERF_MON,
    },{ .name = "REG_P1_CTL",  .addr = A_REG_P1_CTL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_P1_0_PERF_MON",  .addr = A_REG_P1_0_PERF_MON,
    },{ .name = "REG_P1_1_PERF_MON",  .addr = A_REG_P1_1_PERF_MON,
    },{ .name = "REG_P2_CTL",  .addr = A_REG_P2_CTL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_P2_0_PERF_MON",  .addr = A_REG_P2_0_PERF_MON,
    },{ .name = "REG_P2_1_PERF_MON",  .addr = A_REG_P2_1_PERF_MON,
    },{ .name = "REG_P3_CTL",  .addr = A_REG_P3_CTL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_P3_0_PERF_MON",  .addr = A_REG_P3_0_PERF_MON,
    },{ .name = "REG_P3_1_PERF_MON",  .addr = A_REG_P3_1_PERF_MON,
    },{ .name = "REG_PORT_STATUS",  .addr = A_REG_PORT_STATUS,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "REG_ERR_LOG_EN",  .addr = A_REG_ERR_LOG_EN,
        .reset = 0x3f,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_ERR_LOG_P0_1ST_ERR_NUM",
        .addr = A_REG_ERR_LOG_P0_1ST_ERR_NUM,
        .rsvd = 0xffc00000,
        .ro = 0x3fff0f,
    },{ .name = "REG_ERR_LOG_P0_INFO_0",  .addr = A_REG_ERR_LOG_P0_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P0_INFO_1",  .addr = A_REG_ERR_LOG_P0_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_P0_INFO_2",  .addr = A_REG_ERR_LOG_P0_INFO_2,
        .rsvd = 0xfc00,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P1_1ST_ERR_NUM",
        .addr = A_REG_ERR_LOG_P1_1ST_ERR_NUM,
        .rsvd = 0xffc00000,
        .ro = 0x3fff0f,
    },{ .name = "REG_ERR_LOG_P1_INFO_0",  .addr = A_REG_ERR_LOG_P1_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P1_INFO_1",  .addr = A_REG_ERR_LOG_P1_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_P1_INFO_2",  .addr = A_REG_ERR_LOG_P1_INFO_2,
        .rsvd = 0xfc00,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P2_1ST_ERR_NUM",
        .addr = A_REG_ERR_LOG_P2_1ST_ERR_NUM,
        .rsvd = 0xffc00000,
        .ro = 0x3fff0f,
    },{ .name = "REG_ERR_LOG_P2_INFO_0",  .addr = A_REG_ERR_LOG_P2_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P2_INFO_1",  .addr = A_REG_ERR_LOG_P2_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_P2_INFO_2",  .addr = A_REG_ERR_LOG_P2_INFO_2,
        .rsvd = 0xfc00,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P3_1ST_ERR_NUM",
        .addr = A_REG_ERR_LOG_P3_1ST_ERR_NUM,
        .rsvd = 0xffc00000,
        .ro = 0x3fff0f,
    },{ .name = "REG_ERR_LOG_P3_INFO_0",  .addr = A_REG_ERR_LOG_P3_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_P3_INFO_1",  .addr = A_REG_ERR_LOG_P3_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_ERR_LOG_P3_INFO_2",  .addr = A_REG_ERR_LOG_P3_INFO_2,
        .rsvd = 0xfc00,
        .ro = 0xffffffff,
    },{ .name = "REG_DBG_MUX_CTRL",  .addr = A_REG_DBG_MUX_CTRL,
        .rsvd = 0xfffffe00,
    },{ .name = "REG_DBG_MUX_STATUS",  .addr = A_REG_DBG_MUX_STATUS,
        .rsvd = 0xffffff00,
        .ro = 0x1,
    },{ .name = "REG_DBG",  .addr = A_REG_DBG,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DBG_TRIG_0",  .addr = A_REG_DBG_TRIG_0,
    },{ .name = "REG_DBG_TRIG_1",  .addr = A_REG_DBG_TRIG_1,
        .rsvd = 0xfc000000,
    },{ .name = "REG_DBG_TRIG_2",  .addr = A_REG_DBG_TRIG_2,
    },{ .name = "REG_DBG_TRIG_3",  .addr = A_REG_DBG_TRIG_3,
    },{ .name = "REG_DBG_TRIG_4",  .addr = A_REG_DBG_TRIG_4,
        .rsvd = 0xfc000000,
    }
};

static void noc_nps_reset(DeviceState *dev)
{
    NOC_NPS *s = XILINX_NOC_NPS(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps noc_nps_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void noc_nps_init(Object *obj)
{
    NOC_NPS *s = XILINX_NOC_NPS(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    s->reg_array =
        register_init_block32(DEVICE(obj), noc_nps_regs_info,
                              ARRAY_SIZE(noc_nps_regs_info),
                              s->regs_info, s->regs,
                              &noc_nps_ops,
                              XILINX_NOC_NPS_ERR_DEBUG,
                              NOC_NPS_R_MAX * 4);
    sysbus_init_mmio(sbd, &s->reg_array->mem);
}

static const VMStateDescription vmstate_noc_nps = {
    .name = TYPE_XILINX_NOC_NPS,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, NOC_NPS, NOC_NPS_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void noc_nps_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = noc_nps_reset;
    dc->vmsd = &vmstate_noc_nps;
}

static const TypeInfo noc_nps_info = {
    .name          = TYPE_XILINX_NOC_NPS,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(NOC_NPS),
    .class_init    = noc_nps_class_init,
    .instance_init = noc_nps_init,
};

static void noc_nps_register_types(void)
{
    type_register_static(&noc_nps_info);
}

type_init(noc_nps_register_types)
