/*
 * QEMU model of the PSX_RPU_CLUSTER Realtime Processing Unit
 *
 * Copyright (c) 2022 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2022-03-22.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_PSX_RPU_CLUSTER_ERR_DEBUG
#define XILINX_PSX_RPU_CLUSTER_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSX_RPU_CLUSTER "xlnx.psx_rpu_cluster_2.0"

#define XILINX_PSX_RPU_CLUSTER(obj) \
     OBJECT_CHECK(PSX_RPU_CLUSTER, (obj), TYPE_XILINX_PSX_RPU_CLUSTER)

REG32(CLUSTER_CFG, 0x0)
    FIELD(CLUSTER_CFG, RAMPROTEN, 12, 1)
    FIELD(CLUSTER_CFG, CLUSTERUTID_BIT1, 9, 1)
    FIELD(CLUSTER_CFG, CLUSTERUTID_BIT0, 8, 1)
    FIELD(CLUSTER_CFG, SLSPLIT, 0, 1)
REG32(CLUSTER_AXIS, 0x10)
    FIELD(CLUSTER_AXIS, TCM_BASE, 24, 8)
REG32(CLUSTER_PERIPH, 0x14)
    FIELD(CLUSTER_PERIPH, BASE, 21, 11)
REG32(CLUSTER_LLPP, 0x1c)
    FIELD(CLUSTER_LLPP, BASE, 12, 20)
    FIELD(CLUSTER_LLPP, SIZE, 0, 4)
REG32(CLUSTER_DCLSCOMPIN_LO, 0x30)
    FIELD(CLUSTER_DCLSCOMPIN_LO, COMPIN, 0, 28)
REG32(CLUSTER_DCLSCOMPIN_HI, 0x38)
    FIELD(CLUSTER_DCLSCOMPIN_HI, COMPIN, 4, 6)
REG32(CLUSTER_INTR_0, 0x40)
REG32(CLUSTER_INTR_1, 0x44)
REG32(CLUSTER_INTR_2, 0x48)
REG32(CLUSTER_INTR_3, 0x4c)
REG32(CLUSTER_INTR_4, 0x50)
REG32(CLUSTER_INTR_MASK_0, 0x54)
REG32(CLUSTER_INTR_MASK_1, 0x58)
REG32(CLUSTER_INTR_MASK_2, 0x5c)
REG32(CLUSTER_INTR_MASK_3, 0x60)
REG32(CLUSTER_INTR_MASK_4, 0x64)
REG32(CLUSTER_CCF_VAL, 0x68)
    FIELD(CLUSTER_CCF_VAL, TEST_MBIST_MODE, 7, 1)
    FIELD(CLUSTER_CCF_VAL, TEST_SCAN_MODE_LP, 6, 1)
    FIELD(CLUSTER_CCF_VAL, TEST_SCAN_MODE, 5, 1)
    FIELD(CLUSTER_CCF_VAL, ISO, 4, 1)
    FIELD(CLUSTER_CCF_VAL, PGE, 3, 1)
    FIELD(CLUSTER_CCF_VAL, R50_DBG_RST, 2, 1)
    FIELD(CLUSTER_CCF_VAL, R50_RST, 1, 1)
    FIELD(CLUSTER_CCF_VAL, PGE_RST, 0, 1)
REG32(CLUSTER_CCF_MASK, 0x6c)
    FIELD(CLUSTER_CCF_MASK, TEST_MBIST_MODE, 7, 1)
    FIELD(CLUSTER_CCF_MASK, TEST_SCAN_MODE_LP, 6, 1)
    FIELD(CLUSTER_CCF_MASK, TEST_SCAN_MODE, 5, 1)
    FIELD(CLUSTER_CCF_MASK, ISO, 4, 1)
    FIELD(CLUSTER_CCF_MASK, PGE, 3, 1)
    FIELD(CLUSTER_CCF_MASK, R50_DBG_RST, 2, 1)
    FIELD(CLUSTER_CCF_MASK, R50_RST, 1, 1)
    FIELD(CLUSTER_CCF_MASK, PGE_RST, 0, 1)
REG32(CLUSTER_SAFETY_CHK, 0x70)
REG32(CLUSTER_DCLSCOMPOUT_LO_STATUS, 0x80)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_27, 27, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_26, 26, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_25, 25, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_24, 24, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_23, 23, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_22, 22, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_21, 21, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_20, 20, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_19, 19, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_18, 18, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_17, 17, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_16, 16, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_15, 15, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_14, 14, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_13, 13, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_12, 12, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_11, 11, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_10, 10, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_9, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_8, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_7, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_6, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_5, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_4, 4, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_3, 3, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_2, 2, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_1, 1, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_STATUS, VAL_0, 0, 1)
REG32(CLUSTER_DCLSCOMPOUT_LO_MASK, 0x84)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_27, 27, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_26, 26, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_25, 25, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_24, 24, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_23, 23, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_22, 22, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_21, 21, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_20, 20, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_19, 19, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_18, 18, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_17, 17, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_16, 16, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_15, 15, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_14, 14, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_13, 13, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_12, 12, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_11, 11, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_10, 10, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_9, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_8, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_7, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_6, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_5, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_4, 4, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_3, 3, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_2, 2, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_1, 1, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_MASK, VAL_0, 0, 1)
REG32(CLUSTER_DCLSCOMPOUT_LO_EN, 0x88)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_27, 27, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_26, 26, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_25, 25, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_24, 24, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_23, 23, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_22, 22, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_21, 21, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_20, 20, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_19, 19, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_18, 18, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_17, 17, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_16, 16, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_15, 15, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_14, 14, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_13, 13, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_12, 12, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_11, 11, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_10, 10, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_9, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_8, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_7, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_6, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_5, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_4, 4, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_3, 3, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_2, 2, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_1, 1, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_EN, VAL_0, 0, 1)
REG32(CLUSTER_DCLSCOMPOUT_LO_DIS, 0x8c)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_27, 27, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_26, 26, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_25, 25, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_24, 24, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_23, 23, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_22, 22, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_21, 21, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_20, 20, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_19, 19, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_18, 18, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_17, 17, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_16, 16, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_15, 15, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_14, 14, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_13, 13, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_12, 12, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_11, 11, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_10, 10, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_9, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_8, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_7, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_6, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_5, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_4, 4, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_3, 3, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_2, 2, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_1, 1, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_DIS, VAL_0, 0, 1)
REG32(CLUSTER_DCLSCOMPOUT_LO_TRIGG, 0x90)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_27, 27, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_26, 26, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_25, 25, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_24, 24, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_23, 23, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_22, 22, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_21, 21, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_20, 20, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_19, 19, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_18, 18, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_17, 17, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_16, 16, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_15, 15, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_14, 14, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_13, 13, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_12, 12, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_11, 11, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_10, 10, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_9, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_8, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_7, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_6, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_5, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_4, 4, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_3, 3, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_2, 2, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_1, 1, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_LO_TRIGG, VAL_0, 0, 1)
REG32(CLUSTER_DCLSCOMPOUT_HI_STATUS, 0x94)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_STATUS, VAL_89, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_STATUS, VAL_88, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_STATUS, VAL_87, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_STATUS, VAL_86, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_STATUS, VAL_85, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_STATUS, VAL_84, 4, 1)
REG32(CLUSTER_DCLSCOMPOUT_HI_MASK, 0x98)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_MASK, VAL_89, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_MASK, VAL_88, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_MASK, VAL_87, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_MASK, VAL_86, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_MASK, VAL_85, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_MASK, VAL_84, 4, 1)
REG32(CLUSTER_DCLSCOMPOUT_HI_EN, 0x9c)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_EN, VAL_89, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_EN, VAL_88, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_EN, VAL_87, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_EN, VAL_86, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_EN, VAL_85, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_EN, VAL_84, 4, 1)
REG32(CLUSTER_DCLSCOMPOUT_HI_DIS, 0xa0)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_DIS, VAL_89, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_DIS, VAL_88, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_DIS, VAL_87, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_DIS, VAL_86, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_DIS, VAL_85, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_DIS, VAL_84, 4, 1)
REG32(CLUSTER_DCLSCOMPOUT_HI_TRIGG, 0xa4)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_TRIGG, VAL_89, 9, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_TRIGG, VAL_88, 8, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_TRIGG, VAL_87, 7, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_TRIGG, VAL_86, 6, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_TRIGG, VAL_85, 5, 1)
    FIELD(CLUSTER_DCLSCOMPOUT_HI_TRIGG, VAL_84, 4, 1)
REG32(CLUSTER_MPID, 0xa8)
    FIELD(CLUSTER_MPID, AFF2_MSB, 17, 7)
    FIELD(CLUSTER_MPID, AFF2_BIT0, 16, 1)
    FIELD(CLUSTER_MPID, AFF1_MSB, 9, 7)
    FIELD(CLUSTER_MPID, AFF1_BIT0, 8, 1)
REG32(RPU_CLUSTER_ISR, 0xb0)
    FIELD(RPU_CLUSTER_ISR, CLUSTER_REG_PAR_MON_ERR1, 1, 1)
    FIELD(RPU_CLUSTER_ISR, CLUSTER_REG_PAR_MON_ERR0, 0, 1)
REG32(RPU_CLUSTER_IMR, 0xb4)
    FIELD(RPU_CLUSTER_IMR, CLUSTER_REG_PAR_MON_ERR1, 1, 1)
    FIELD(RPU_CLUSTER_IMR, CLUSTER_REG_PAR_MON_ERR0, 0, 1)
REG32(RPU_CLUSTER_IEN, 0xb8)
    FIELD(RPU_CLUSTER_IEN, CLUSTER_REG_PAR_MON_ERR1, 1, 1)
    FIELD(RPU_CLUSTER_IEN, CLUSTER_REG_PAR_MON_ERR0, 0, 1)
REG32(RPU_CLUSTER_IDS, 0xbc)
    FIELD(RPU_CLUSTER_IDS, CLUSTER_REG_PAR_MON_ERR1, 1, 1)
    FIELD(RPU_CLUSTER_IDS, CLUSTER_REG_PAR_MON_ERR0, 0, 1)
REG32(RPU_CLUSTER_PAR_MON, 0xc0)
    FIELD(RPU_CLUSTER_PAR_MON, CLUSTER_PAR_MON_EN, 0, 1)
REG32(CLUSTER_INTR_5, 0xc4)
REG32(CLUSTER_INTR_6, 0xc8)
REG32(CLUSTER_INTR_7, 0xcc)
REG32(CLUSTER_INTR_MASK_5, 0xd0)
REG32(CLUSTER_INTR_MASK_6, 0xd4)
REG32(CLUSTER_INTR_MASK_7, 0xd8)

#define PSX_RPU_CLUSTER_R_MAX (R_CLUSTER_INTR_MASK_7 + 1)

typedef struct PSX_RPU_CLUSTER {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_cluster_dclscompout_hi;
    qemu_irq irq_cluster_dclscompout_lo;
    qemu_irq irq_rpu_cluster_imr;
    qemu_irq slsplit;
    uint32_t axis_base;
    MemoryRegion *tcm_mr;

    uint32_t regs[PSX_RPU_CLUSTER_R_MAX];
    RegisterInfo regs_info[PSX_RPU_CLUSTER_R_MAX];
} PSX_RPU_CLUSTER;

#define PROPAGATE_GPIO(reg, f, irq) { \
    bool val = ARRAY_FIELD_EX32(s->regs, reg, f); \
    qemu_set_irq(irq, val); \
}

static void cluster_dclscompout_hi_update_irq(PSX_RPU_CLUSTER *s)
{
    bool pending = s->regs[R_CLUSTER_DCLSCOMPOUT_HI_STATUS] &
                   ~s->regs[R_CLUSTER_DCLSCOMPOUT_HI_MASK];
    qemu_set_irq(s->irq_cluster_dclscompout_hi, pending);
}

static void cluster_dclscompout_hi_status_postw(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    cluster_dclscompout_hi_update_irq(s);
}

static uint64_t cluster_dclscompout_hi_en_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DCLSCOMPOUT_HI_MASK] &= ~val;
    cluster_dclscompout_hi_update_irq(s);
    return 0;
}

static uint64_t cluster_dclscompout_hi_dis_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DCLSCOMPOUT_HI_MASK] |= val;
    cluster_dclscompout_hi_update_irq(s);
    return 0;
}

static uint64_t cluster_dclscompout_hi_trigg_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DCLSCOMPOUT_HI_STATUS] |= val;
    cluster_dclscompout_hi_update_irq(s);
    return 0;
}

static void cluster_dclscompout_lo_update_irq(PSX_RPU_CLUSTER *s)
{
    bool pending = s->regs[R_CLUSTER_DCLSCOMPOUT_LO_STATUS] &
                   ~s->regs[R_CLUSTER_DCLSCOMPOUT_LO_MASK];
    qemu_set_irq(s->irq_cluster_dclscompout_lo, pending);
}

static void cluster_dclscompout_lo_status_postw(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    cluster_dclscompout_lo_update_irq(s);
}

static uint64_t cluster_dclscompout_lo_en_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DCLSCOMPOUT_LO_MASK] &= ~val;
    cluster_dclscompout_lo_update_irq(s);
    return 0;
}

static uint64_t cluster_dclscompout_lo_dis_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DCLSCOMPOUT_LO_MASK] |= val;
    cluster_dclscompout_lo_update_irq(s);
    return 0;
}

static uint64_t cluster_dclscompout_lo_trigg_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLUSTER_DCLSCOMPOUT_LO_STATUS] |= val;
    cluster_dclscompout_lo_update_irq(s);
    return 0;
}

static void rpu_cluster_imr_update_irq(PSX_RPU_CLUSTER *s)
{
    bool pending = s->regs[R_RPU_CLUSTER_ISR] & ~s->regs[R_RPU_CLUSTER_IMR];
    qemu_set_irq(s->irq_rpu_cluster_imr, pending);
}

static void rpu_cluster_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    rpu_cluster_imr_update_irq(s);
}

static uint64_t rpu_cluster_ien_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RPU_CLUSTER_IMR] &= ~val;
    rpu_cluster_imr_update_irq(s);
    return 0;
}

static uint64_t rpu_cluster_ids_prew(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RPU_CLUSTER_IMR] |= val;
    rpu_cluster_imr_update_irq(s);
    return 0;
}

static void cluster_cfg_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);

    PROPAGATE_GPIO(CLUSTER_CFG, SLSPLIT, s->slsplit);
}

static void cluster_axis_postw(RegisterInfo *reg, uint64_t val64)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(reg->opaque);
    uint32_t val = val64;
    uint32_t addr;
    MemoryRegionSection section;

    if (!s->tcm_mr) {
        return;
    }

    section = memory_region_find(s->tcm_mr, 0, 0x400000);
    addr = section.offset_within_address_space;
    addr &= 0xFFFFFF;
    addr |= val & R_CLUSTER_AXIS_TCM_BASE_MASK;
    memory_region_set_address(s->tcm_mr, addr);
    memory_region_unref(section.mr);
}

static const RegisterAccessInfo psx_rpu_cluster_regs_info[] = {
    {   .name = "CLUSTER_CFG",  .addr = A_CLUSTER_CFG,
        .rsvd = 0xffffecfe,
        .ro = 0x100,
        .post_write = cluster_cfg_postw,
    },{ .name = "CLUSTER_AXIS",  .addr = A_CLUSTER_AXIS,
        .rsvd = 0xffffff,
        .post_write = cluster_axis_postw,
    },{ .name = "CLUSTER_PERIPH",  .addr = A_CLUSTER_PERIPH,
        .reset = 0xe2000000,
        .rsvd = 0x1fffff,
    },{ .name = "CLUSTER_LLPP",  .addr = A_CLUSTER_LLPP,
        .reset = 0x8000000d,
        .rsvd = 0xff0,
    },{ .name = "CLUSTER_DCLSCOMPIN_LO",  .addr = A_CLUSTER_DCLSCOMPIN_LO,
        .rsvd = 0xf0000000,
    },{ .name = "CLUSTER_DCLSCOMPIN_HI",  .addr = A_CLUSTER_DCLSCOMPIN_HI,
        .rsvd = 0xfffffc0f,
    },{ .name = "CLUSTER_INTR_0",  .addr = A_CLUSTER_INTR_0,
    },{ .name = "CLUSTER_INTR_1",  .addr = A_CLUSTER_INTR_1,
    },{ .name = "CLUSTER_INTR_2",  .addr = A_CLUSTER_INTR_2,
    },{ .name = "CLUSTER_INTR_3",  .addr = A_CLUSTER_INTR_3,
    },{ .name = "CLUSTER_INTR_4",  .addr = A_CLUSTER_INTR_4,
    },{ .name = "CLUSTER_INTR_MASK_0",  .addr = A_CLUSTER_INTR_MASK_0,
    },{ .name = "CLUSTER_INTR_MASK_1",  .addr = A_CLUSTER_INTR_MASK_1,
    },{ .name = "CLUSTER_INTR_MASK_2",  .addr = A_CLUSTER_INTR_MASK_2,
    },{ .name = "CLUSTER_INTR_MASK_3",  .addr = A_CLUSTER_INTR_MASK_3,
    },{ .name = "CLUSTER_INTR_MASK_4",  .addr = A_CLUSTER_INTR_MASK_4,
    },{ .name = "CLUSTER_CCF_VAL",  .addr = A_CLUSTER_CCF_VAL,
        .reset = 0x7,
        .rsvd = 0xffffff00,
    },{ .name = "CLUSTER_CCF_MASK",  .addr = A_CLUSTER_CCF_MASK,
        .rsvd = 0xffffff00,
    },{ .name = "CLUSTER_SAFETY_CHK",  .addr = A_CLUSTER_SAFETY_CHK,
    },{ .name = "CLUSTER_DCLSCOMPOUT_LO_STATUS",
        .addr = A_CLUSTER_DCLSCOMPOUT_LO_STATUS,
        .rsvd = 0xf0000000,
        .w1c = 0xfffffff,
        .post_write = cluster_dclscompout_lo_status_postw,
    },{ .name = "CLUSTER_DCLSCOMPOUT_LO_MASK",
        .addr = A_CLUSTER_DCLSCOMPOUT_LO_MASK,
        .reset = 0xfffffff,
        .rsvd = 0xf0000000,
        .ro = 0xfffffff,
    },{ .name = "CLUSTER_DCLSCOMPOUT_LO_EN",
        .addr = A_CLUSTER_DCLSCOMPOUT_LO_EN,
        .rsvd = 0xf0000000,
        .pre_write = cluster_dclscompout_lo_en_prew,
    },{ .name = "CLUSTER_DCLSCOMPOUT_LO_DIS",
        .addr = A_CLUSTER_DCLSCOMPOUT_LO_DIS,
        .rsvd = 0xf0000000,
        .pre_write = cluster_dclscompout_lo_dis_prew,
    },{ .name = "CLUSTER_DCLSCOMPOUT_LO_TRIGG",
        .addr = A_CLUSTER_DCLSCOMPOUT_LO_TRIGG,
        .rsvd = 0xf0000000,
        .pre_write = cluster_dclscompout_lo_trigg_prew,
    },{ .name = "CLUSTER_DCLSCOMPOUT_HI_STATUS",
        .addr = A_CLUSTER_DCLSCOMPOUT_HI_STATUS,
        .rsvd = 0xfffffc0f,
        .w1c = 0x3f0,
        .post_write = cluster_dclscompout_hi_status_postw,
    },{ .name = "CLUSTER_DCLSCOMPOUT_HI_MASK",
        .addr = A_CLUSTER_DCLSCOMPOUT_HI_MASK,
        .reset = 0x3f0,
        .rsvd = 0xfffffc0f,
        .ro = 0x3f0,
    },{ .name = "CLUSTER_DCLSCOMPOUT_HI_EN",
        .addr = A_CLUSTER_DCLSCOMPOUT_HI_EN,
        .rsvd = 0xfffffc0f,
        .pre_write = cluster_dclscompout_hi_en_prew,
    },{ .name = "CLUSTER_DCLSCOMPOUT_HI_DIS",
        .addr = A_CLUSTER_DCLSCOMPOUT_HI_DIS,
        .rsvd = 0xfffffc0f,
        .pre_write = cluster_dclscompout_hi_dis_prew,
    },{ .name = "CLUSTER_DCLSCOMPOUT_HI_TRIGG",
        .addr = A_CLUSTER_DCLSCOMPOUT_HI_TRIGG,
        .rsvd = 0xfffffc0f,
        .pre_write = cluster_dclscompout_hi_trigg_prew,
    },{ .name = "CLUSTER_MPID",  .addr = A_CLUSTER_MPID,
        .rsvd = 0xff0000ff,
        .ro = 0x10100,
    },{ .name = "RPU_CLUSTER_ISR",  .addr = A_RPU_CLUSTER_ISR,
        .rsvd = 0xfffffffc,
        .w1c = 0x3,
        .post_write = rpu_cluster_isr_postw,
    },{ .name = "RPU_CLUSTER_IMR",  .addr = A_RPU_CLUSTER_IMR,
        .reset = 0x3,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "RPU_CLUSTER_IEN",  .addr = A_RPU_CLUSTER_IEN,
        .rsvd = 0xfffffffc,
        .pre_write = rpu_cluster_ien_prew,
    },{ .name = "RPU_CLUSTER_IDS",  .addr = A_RPU_CLUSTER_IDS,
        .rsvd = 0xfffffffc,
        .pre_write = rpu_cluster_ids_prew,
    },{ .name = "RPU_CLUSTER_PAR_MON",  .addr = A_RPU_CLUSTER_PAR_MON,
        .rsvd = 0xfffffffe,
    },{ .name = "CLUSTER_INTR_5",  .addr = A_CLUSTER_INTR_5,
    },{ .name = "CLUSTER_INTR_6",  .addr = A_CLUSTER_INTR_6,
    },{ .name = "CLUSTER_INTR_7",  .addr = A_CLUSTER_INTR_7,
    },{ .name = "CLUSTER_INTR_MASK_5",  .addr = A_CLUSTER_INTR_MASK_5,
    },{ .name = "CLUSTER_INTR_MASK_6",  .addr = A_CLUSTER_INTR_MASK_6,
    },{ .name = "CLUSTER_INTR_MASK_7",  .addr = A_CLUSTER_INTR_MASK_7,
    }
};

static void psx_rpu_cluster_reset_enter(Object *obj, ResetType type)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        switch (i) {
        case R_CLUSTER_AXIS:
            continue;
        default:
            register_reset(&s->regs_info[i]);
        };
    }
    s->regs[R_CLUSTER_AXIS] = s->axis_base &
                              R_CLUSTER_AXIS_TCM_BASE_MASK;
}

static void psx_rpu_cluster_reset_hold(Object *obj)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(obj);

    cluster_dclscompout_hi_update_irq(s);
    cluster_dclscompout_lo_update_irq(s);
    rpu_cluster_imr_update_irq(s);
}

static const MemoryRegionOps psx_rpu_cluster_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void psx_rpu_cluster_init(Object *obj)
{
    PSX_RPU_CLUSTER *s = XILINX_PSX_RPU_CLUSTER(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSX_RPU_CLUSTER,
                       PSX_RPU_CLUSTER_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psx_rpu_cluster_regs_info,
                              ARRAY_SIZE(psx_rpu_cluster_regs_info),
                              s->regs_info, s->regs,
                              &psx_rpu_cluster_ops,
                              XILINX_PSX_RPU_CLUSTER_ERR_DEBUG,
                              PSX_RPU_CLUSTER_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_cluster_dclscompout_hi);
    sysbus_init_irq(sbd, &s->irq_cluster_dclscompout_lo);
    sysbus_init_irq(sbd, &s->irq_rpu_cluster_imr);
    qdev_init_gpio_out(DEVICE(obj), &s->slsplit, 1);
    object_property_add_link(obj, "tcm-mr", TYPE_MEMORY_REGION,
                             (Object **)&s->tcm_mr,
                             qdev_prop_allow_set_link_before_realize,
                             OBJ_PROP_LINK_STRONG);
}

static const VMStateDescription vmstate_psx_rpu_cluster = {
    .name = TYPE_XILINX_PSX_RPU_CLUSTER,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSX_RPU_CLUSTER, PSX_RPU_CLUSTER_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static Property psx_rpu_cluster_prop[] = {
    DEFINE_PROP_UINT32("axis-base", PSX_RPU_CLUSTER, axis_base,
                       0xFF000000),
    DEFINE_PROP_END_OF_LIST(),
};

static void psx_rpu_cluster_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_psx_rpu_cluster;
    rc->phases.enter = psx_rpu_cluster_reset_enter;
    rc->phases.hold = psx_rpu_cluster_reset_hold;
    device_class_set_props(dc, psx_rpu_cluster_prop);
}

static const TypeInfo psx_rpu_cluster_info = {
    .name          = TYPE_XILINX_PSX_RPU_CLUSTER,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSX_RPU_CLUSTER),
    .class_init    = psx_rpu_cluster_class_init,
    .instance_init = psx_rpu_cluster_init,
};

static void psx_rpu_cluster_register_types(void)
{
    type_register_static(&psx_rpu_cluster_info);
}

type_init(psx_rpu_cluster_register_types)
