/*
 * QEMU model of the EFuse_Cache
 *
 * Copyright (c) 2017 Xilinx Inc.
 *
 * Partially generated by xregqemu.py 2017-06-05.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "xlnx-versal-pmc-efuse.h"

#ifndef XILINX_EFUSE_CACHE_ERR_DEBUG
#define XILINX_EFUSE_CACHE_ERR_DEBUG 0
#endif

#define DPRINT(...) \
    if (XILINX_EFUSE_CACHE_ERR_DEBUG) {  \
        qemu_log(__VA_ARGS__);         \
    }

#define TYPE_XILINX_EFUSE_CACHE "xlnx.pmc-efuse-cache"

#define XILINX_EFUSE_CACHE(obj) \
     OBJECT_CHECK(EFuseCache, (obj), TYPE_XILINX_EFUSE_CACHE)

#define DPRINT_GE(args, ...) \
     qemu_log_mask(LOG_GUEST_ERROR, "%s: " args, __func__, ## __VA_ARGS__);

#define R_MAX 0x1000

typedef struct EFuseCache {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    XLNXEFuse *efuse;
} EFuseCache;

static uint64_t efuse_cache_read(void *opaque, hwaddr addr, unsigned size)
{
    EFuseCache *s = XILINX_EFUSE_CACHE(opaque);
    unsigned int w0 = QEMU_ALIGN_DOWN(addr * 8, 32);
    unsigned int w1 = QEMU_ALIGN_DOWN((addr + size - 1) * 8, 32);

    uint64_t ret;

    assert(w0 == w1 || (w0 + 32) == w1);

    ret = versal_efuse_read_row(s->efuse, w1, NULL);
    if (w0 < w1) {
        ret <<= 32;
        ret |= versal_efuse_read_row(s->efuse, w0, NULL);
    }

    /* If 'addr' unaligned, the guest is always assumed to be little-endian. */
    addr &= 3;
    if (addr) {
        ret >>= 8 * addr;
    }

    return ret;
}

static void efuse_cache_write(void *opaque, hwaddr addr, uint64_t value,
                              unsigned size)
{
    /* No Register Writes allowed */
    DPRINT_GE("Invalid write to efuse cache registers");
}

static const MemoryRegionOps efuse_cache_ops = {
    .read = efuse_cache_read,
    .write = efuse_cache_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 1,
        .max_access_size = 4,
    },
};

static void efuse_cache_init(Object *obj)
{
    EFuseCache *s = XILINX_EFUSE_CACHE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    memory_region_init_io(&s->iomem, obj, &efuse_cache_ops, s,
                          TYPE_XILINX_EFUSE_CACHE, R_MAX);
    sysbus_init_mmio(sbd, &s->iomem);
    object_property_add_link(obj, "efuse", TYPE_XLNX_EFUSE,
                             (Object **)&s->efuse,
                             qdev_prop_allow_set_link_before_realize,
                             OBJ_PROP_LINK_STRONG);
}

static const VMStateDescription vmstate_efuse_cache = {
    .name = TYPE_XILINX_EFUSE_CACHE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_END_OF_LIST(),
    }
};

static void efuse_cache_sysmon_data_source(Object *obj,
                                           XlnxEFuseSysmonData *data)
{
    EFuseCache *s = XILINX_EFUSE_CACHE(obj);

    assert(data);
    memset(data, 0, sizeof(*data));

    if (!s->efuse) {
        return;
    }

    /* Must provide data without access screening */
    data->rdata_low = efuse_get_row(s->efuse, (59 * 32));
    data->rdata_high = efuse_get_row(s->efuse, (60 * 32));
    data->glitch_monitor_en = efuse_get_bit(s->efuse, (40 * 32 + 29));
}

static void efuse_cache_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    XlnxEFuseSysmonDataSourceClass *esdc;

    dc->vmsd = &vmstate_efuse_cache;

    esdc = XLNX_EFUSE_SYSMON_DATA_SOURCE_CLASS(klass);
    esdc->get_data = efuse_cache_sysmon_data_source;
}

static const TypeInfo efuse_cache_info = {
    .name          = TYPE_XILINX_EFUSE_CACHE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(EFuseCache),
    .class_init    = efuse_cache_class_init,
    .instance_init = efuse_cache_init,
    .interfaces = (InterfaceInfo[]) {
        { TYPE_XLNX_EFUSE_SYSMON_DATA_SOURCE },
        { }
    }
};

static void efuse_cache_register_types(void)
{
    type_register_static(&efuse_cache_info);
}

type_init(efuse_cache_register_types)
