/* SPDX-License-Identifier: BSD-2-Clause */

/**
 * @file
 *
 * @ingroup RTEMSBSPsPowerPCMPC55XX
 *
 * @brief System Integration Unit Access (SIU).
 */

/*
 * Copyright (C) 2010, 2013 embedded brains GmbH & Co. KG
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIBCPU_POWERPC_MPC55XX_SIU_H
#define LIBCPU_POWERPC_MPC55XX_SIU_H

#include <rtems.h>

#include <mpc55xx/regs.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum {
  #if MPC55XX_CHIP_FAMILY == 567
    PCR_MDO4_GPIO75 = 75,
    PCR_MDO5_GPIO76 = 76,
    PCR_MDO6_GPIO77 = 77,
    PCR_MDO7_GPIO78 = 78,
    PCR_MDO8_GPIO79 = 79,
    PCR_MDO9_GPIO80 = 80,
    PCR_MDO10_GPIO81 = 81,
    PCR_MDO11_GPIO82 = 82,
    PCR_CNTXA_TXDA_GPIO83 = 83,
    PCR_CNRXA_RXDA_GPIO84 = 84,
    PCR_CNTXB_PCSC3_GPIO85 = 85,
    PCR_CNRXB_PCSC4_GPIO86 = 86,
    PCR_CNTXC_PCSD3_GPIO87 = 87,
    PCR_CNRXC_PCSD4_GPIO88 = 88,
    PCR_TXDA_GPIO89 = 89,
    PCR_RXDA_GPIO90 = 90,
    PCR_TXDB_PCSD1_GPIO91 = 91,
    PCR_RXDB_PCSD5_GPIO92 = 92,
    PCR_SCKA_PCSC1_GPIO93 = 93,
    PCR_SINA_PCSC2_GPIO94 = 94,
    PCR_SOUTA_PCSC5_GPIO95 = 95,
    PCR_PCSA0_PCSD2_GPIO96 = 96,
    PCR_PCSA1_GPIO97 = 97,
    PCR_PCSA2_GPIO98 = 98,
    PCR_PCSA3_GPIO99 = 99,
    PCR_PCSA4_GPIO100 = 100,
    PCR_PCSA5_ETRIG1_GPIO101 = 101,
    PCR_SCKB_GPIO102 = 102,
    PCR_SINB_GPIO103 = 103,
    PCR_SOUTB_GPIO104 = 104,
    PCR_PCSB0_PCSD2_GPIO105 = 105,
    PCR_PCSB1_PCSD0_GPIO106 = 106,
    PCR_PCSB2_SOUTC_GPIO107 = 107,
    PCR_PCSB3_SINC_GPIO108 = 108,
    PCR_PCSB4_SCKC_GPIO109 = 109,
    PCR_PCSB5_PCSC0_GPIO110 = 110,
    PCR_TCRCLKA_IRQ7_GPIO113 = 113,
    PCR_ETPUA0_ETPUA12_GPIO114 = 114,
    PCR_ETPUA1_ETPUA13_GPIO115 = 115,
    PCR_ETPUA2_ETPUA14_GPIO116 = 116,
    PCR_ETPUA3_ETPUA15_GPIO117 = 117,
    PCR_ETPUA4_ETPUA16_GPIO118 = 118,
    PCR_ETPUA5_ETPUA17_GPIO119 = 119,
    PCR_ETPUA6_ETPUA18_GPIO120 = 120,
    PCR_ETPUA7_ETPUA19_GPIO121 = 121,
    PCR_ETPUA8_ETPUA20_GPIO122 = 122,
    PCR_ETPUA9_ETPUA21_GPIO123 = 123,
    PCR_ETPUA10_ETPUA22_GPIO124 = 124,
    PCR_ETPUA11_ETPUA23_GPIO125 = 125,
    PCR_ETPUA12_PCSB1_GPIO126 = 126,
    PCR_ETPUA13_PCSB3_GPIO127 = 127,
    PCR_ETPUA14_PCSB4_GPIO128 = 128,
    PCR_ETPUA15_PCSB5_GPIO129 = 129,
    PCR_ETPUA16_PCSD1_GPIO130 = 130,
    PCR_ETPUA17_PCSD2_GPIO131 = 131,
    PCR_ETPUA18_PCSD3_GPIO132 = 132,
    PCR_ETPUA19_PCSD4_GPIO133 = 133,
    PCR_ETPUA20_IRQ8_GPIO134 = 134,
    PCR_ETPUA21_IRQ9_GPIO135 = 135,
    PCR_ETPUA22_IRQ10_GPIO136 = 136,
    PCR_ETPUA23_IRQ11_GPIO137 = 137,
    PCR_ETPUA24_IRQ12_GPIO138 = 138,
    PCR_ETPUA25_IRQ13_GPIO139 = 139,
    PCR_ETPUA26_IRQ14_GPIO140 = 140,
    PCR_ETPUA27_IRQ15_GPIO141 = 141,
    PCR_ETPUA28_PCSC1_GPIO142 = 142,
    PCR_ETPUA29_PCSC2_GPIO143 = 143,
    PCR_ETPUA30_PCSC3_GPIO144 = 144,
    PCR_ETPUA31_PCSC4_GPIO145 = 145,
    PCR_TCRCLKB_IRQ6_GPIO146 = 146,
    PCR_ETPUB0_ETPUB16_GPIO147 = 147,
    PCR_ETPUB1_ETPUB17_GPIO148 = 148,
    PCR_ETPUB2_ETPUB18_GPIO149 = 149,
    PCR_ETPUB3_ETPUB19_GPIO150 = 150,
    PCR_ETPUB4_ETPUB20_GPIO151 = 151,
    PCR_ETPUB5_ETPUB21_GPIO152 = 152,
    PCR_ETPUB6_ETPUB22_GPIO153 = 153,
    PCR_ETPUB7_ETPUB23_GPIO154 = 154,
    PCR_ETPUB8_ETPUB24_GPIO155 = 155,
    PCR_ETPUB9_ETPUB25_GPIO156 = 156,
    PCR_ETPUB10_ETPUB26_GPIO157 = 157,
    PCR_ETPUB11_ETPUB27_GPIO158 = 158,
    PCR_ETPUB12_ETPUB28_GPIO159 = 159,
    PCR_ETPUB13_ETPUB29_GPIO160 = 160,
    PCR_ETPUB14_ETPUB30_GPIO161 = 161,
    PCR_ETPUB15_ETPUB31_GPIO162 = 162,
    PCR_ETPUB16_PCSA1_GPIO163 = 163,
    PCR_ETPUB17_PCSA2_GPIO164 = 164,
    PCR_ETPUB18_PCSA3_GPIO165 = 165,
    PCR_ETPUB19_PCSA4_GPIO166 = 166,
    PCR_ETPUB20_GPIO167 = 167,
    PCR_ETPUB21_GPIO168 = 168,
    PCR_ETPUB22_GPIO169 = 169,
    PCR_ETPUB23_GPIO170 = 170,
    PCR_ETPUB24_GPIO171 = 171,
    PCR_ETPUB25_GPIO172 = 172,
    PCR_ETPUB26_GPIO173 = 173,
    PCR_ETPUB27_GPIO174 = 174,
    PCR_ETPUB28_GPIO175 = 175,
    PCR_ETPUB29_GPIO176 = 176,
    PCR_ETPUB30_GPIO177 = 177,
    PCR_ETPUB31_GPIO178 = 178,
    PCR_EMIOS0_ETPUA0_GPIO179 = 179,
    PCR_EMIOS1_ETPUA1_GPIO180 = 180,
    PCR_EMIOS2_ETPUA2_GPIO181 = 181,
    PCR_EMIOS3_ETPUA3_GPIO182 = 182,
    PCR_EMIOS4_ETPUA4_GPIO183 = 183,
    PCR_EMIOS5_ETPUA5_GPIO184 = 184,
    PCR_EMIOS6_ETPUA6_GPIO185 = 185,
    PCR_EMIOS7_ETPUA7_GPIO186 = 186,
    PCR_EMIOS8_ETPUA8_GPIO187 = 187,
    PCR_EMIOS9_ETPUA9_GPIO188 = 188,
    PCR_EMIOS10_SCKD_GPIO189 = 189,
    PCR_EMIOS11_SIND_GPIO190 = 190,
    PCR_EMIOS12_SOUTC_GPIO191 = 191,
    PCR_EMIOS13_SOUTD_GPIO192 = 192,
    PCR_EMIOS14_IRQ0_GPIO193 = 193,
    PCR_EMIOS15_IRQ1_GPIO194 = 194,
    PCR_EMIOS16_ETPUB0_GPIO195 = 195,
    PCR_EMIOS17_ETPUB1_GPIO196 = 196,
    PCR_EMIOS18_ETPUB2_GPIO197 = 197,
    PCR_EMIOS19_ETPUB3_GPIO198 = 198,
    PCR_EMIOS20_ETPUB4_GPIO199 = 199,
    PCR_EMIOS21_ETPUB5_GPIO200 = 200,
    PCR_EMIOS22_ETPUB6_GPIO201 = 201,
    PCR_EMIOS23_ETPUB7_GPIO202 = 202,
    PCR_EMIOS24_PCSB0_GPIO203 = 203,
    PCR_EMIOS25_PCSB1_GPIO204 = 204,
    PCR_PLLCFG0_IRQ4_GPIO208 = 208,
    PCR_PLLCFG1_IRQ5_GPIO209 = 209,
    PCR_BOOTCFG0_IRQ2_GPIO211 = 211,
    PCR_BOOTCFG1_IRQ3_GPIO212 = 212,
    PCR_WKPCFG_NMI_GPIO213 = 213,
    PCR_ENGCLK = 214,
    PCR_MCKO = 219,
    PCR_MDO0_GPIO220 = 220,
    PCR_MDO1_GPIO221 = 221,
    PCR_MDO2_GPIO222 = 222,
    PCR_MDO3_GPIO223 = 223,
    PCR_MSEO0 = 224,
    PCR_MSEO1 = 225,
    PCR_RDY = 226,
    PCR_TDO = 228,
    PCR_D_CLKOUT = 229,
    PCR_RSTOUT = 230,
    PCR_MDO12_GPIO231 = 231,
    PCR_MDO13_GPIO232 = 232,
    PCR_MDO14_GPIO233 = 233,
    PCR_MDO15_GPIO234 = 234,
    PCR_SCKC_SCK_C_LVDSP_GPIO235 = 235,
    PCR_SINC_SCK_C_LVDSM_GPIO236 = 236,
    PCR_SOUTC_SOUT_C_LVDSP_GPIO237 = 237,
    PCR_PCSC0_SOUT_C_LVDSM_GPIO238 = 238,
    PCR_PCSC1_GPIO239 = 239,
    PCR_PCSC2_GPIO240 = 240,
    PCR_PCSC3_GPIO241 = 241,
    PCR_PCSC4_GPIO242 = 242,
    PCR_PCSC5_GPIO243 = 243,
    PCR_TXDC_ETRIG0_GPIO244 = 244,
    PCR_RXDC_GPIO245 = 245,
    PCR_CNTXD_GPIO246 = 246,
    PCR_CNRXD_GPIO247 = 247,
    PCR_FR_A_TX_GPIO248 = 248,
    PCR_FR_A_RX_GPIO249 = 249,
    PCR_FR_A_TX_EN_GPIO250 = 250,
    PCR_FR_B_TX_GPIO251 = 251,
    PCR_FR_B_RX_GPIO252 = 252,
    PCR_FR_B_TX_EN_GPIO253 = 253,
    PCR_D_CS0_GPIO256 = 256,
    PCR_D_CS2_D_ADD_DAT31_GPIO257 = 257,
    PCR_D_CS3_D_TEA_GPIO258 = 258,
    PCR_D_ADD12_GPIO259 = 259,
    PCR_D_ADD13_GPIO260 = 260,
    PCR_D_ADD14_GPIO261 = 261,
    PCR_D_ADD15_GPIO262 = 262,
    PCR_D_ADD16_D_ADD_DAT16_GPIO263 = 263,
    PCR_D_ADD17_D_ADD_DAT17_GPIO264 = 264,
    PCR_D_ADD18_D_ADD_DAT18_GPIO265 = 265,
    PCR_D_ADD19_D_ADD_DAT19_GPIO266 = 266,
    PCR_D_ADD20_D_ADD_DAT20_GPIO267 = 267,
    PCR_D_ADD21_D_ADD_DAT21_GPIO268 = 268,
    PCR_D_ADD22_D_ADD_DAT22_GPIO269 = 269,
    PCR_D_ADD23_D_ADD_DAT23_GPIO270 = 270,
    PCR_D_ADD24_D_ADD_DAT24_GPIO271 = 271,
    PCR_D_ADD25_D_ADD_DAT25_GPIO272 = 272,
    PCR_D_ADD26_D_ADD_DAT26_GPIO273 = 273,
    PCR_D_ADD27_D_ADD_DAT27_GPIO274 = 274,
    PCR_D_ADD28_D_ADD_DAT28_GPIO275 = 275,
    PCR_D_ADD29_D_ADD_DAT29_GPIO276 = 276,
    PCR_D_ADD30_D_ADD_DAT30_GPIO277 = 277,
    PCR_D_ADD_DAT0_GPIO278 = 278,
    PCR_D_ADD_DAT1_GPIO279 = 279,
    PCR_D_ADD_DAT2_GPIO280 = 280,
    PCR_D_ADD_DAT3_GPIO281 = 281,
    PCR_D_ADD_DAT4_GPIO282 = 282,
    PCR_D_ADD_DAT5_GPIO283 = 283,
    PCR_D_ADD_DAT6_GPIO284 = 284,
    PCR_D_ADD_DAT7_GPIO285 = 285,
    PCR_D_ADD_DAT8_GPIO286 = 286,
    PCR_D_ADD_DAT9_GPIO287 = 287,
    PCR_D_ADD_DAT10_GPIO288 = 288,
    PCR_D_ADD_DAT11_GPIO289 = 289,
    PCR_D_ADD_DAT12_GPIO290 = 290,
    PCR_D_ADD_DAT13_GPIO291 = 291,
    PCR_D_ADD_DAT14_GPIO292 = 292,
    PCR_D_ADD_DAT15_GPIO293 = 293,
    PCR_D_RD_WR_GPIO294 = 294,
    PCR_D_WE0_GPIO295 = 295,
    PCR_D_WE1_GPIO296 = 296,
    PCR_D_OE_GPIO297 = 297,
    PCR_D_TS_GPIO298 = 298,
    PCR_D_ALE_GPIO299 = 299,
    PCR_D_TA_GPIO300 = 300,
    PCR_D_CS1_GPIO301 = 301,
    PCR_D_BDIP_GPIO302 = 302,
    PCR_D_WE2_GPIO303 = 303,
    PCR_D_WE3_GPIO304 = 304,
    PCR_D_ADD9_GPIO305 = 305,
    PCR_D_ADD10_GPIO306 = 306,
    PCR_D_ADD11_GPIO307 = 307,
    PCR_EMIOS26_PCSB2_GPIO432 = 432,
    PCR_EMIOS27_PCSB3_GPIO433 = 433,
    PCR_EMIOS28_PCSC0_GPIO434 = 434,
    PCR_EMIOS29_PCSC1_GPIO435 = 435,
    PCR_EMIOS30_PCSC2_GPIO436 = 436,
    PCR_EMIOS31_PCSC5_GPIO437 = 437,
    PCR_TCRCLKC_GPIO440 = 440,
    PCR_ETPUC0_GPIO441 = 441,
    PCR_ETPUC1_GPIO442 = 442,
    PCR_ETPUC2_GPIO443 = 443,
    PCR_ETPUC3_GPIO444 = 444,
    PCR_ETPUC4_GPIO445 = 445,
    PCR_ETPUC5_GPIO446 = 446,
    PCR_ETPUC6_GPIO447 = 447,
    PCR_ETPUC7_GPIO448 = 448,
    PCR_ETPUC8_GPIO449 = 449,
    PCR_ETPUC9_IRQ0_GPIO450 = 450,
    PCR_ETPUC10__IRQ1_GPIO451 = 451,
    PCR_ETPUC11_IRQ2_GPIO452 = 452,
    PCR_ETPUC12_IRQ3_GPIO453 = 453,
    PCR_ETPUC13_3_IRQ4_GPIO454 = 454,
    PCR_ETPUC14_4_IRQ5_GPIO455 = 455,
    PCR_ETPUC15__GPIO456 = 456,
    PCR_ETPUC16_FR_A_TX_GPIO457 = 457,
    PCR_ETPUC17_FR_A_RX_GPIO458 = 458,
    PCR_ETPUC18_FR_A_TX_EN_GPIO459 = 459,
    PCR_ETPUC19_TXDA_GPIO460 = 460,
    PCR_ETPUC20_RXDA_GPIO461 = 461,
    PCR_ETPUC21_TXDB_GPIO462 = 462,
    PCR_ETPUC22_RXDB_GPIO463 = 463,
    PCR_ETPUC23_PCSD5_GPIO464 = 464,
    PCR_ETPUC24_PCSD4_GPIO465 = 465,
    PCR_ETPUC25_PCSD3_GPIO466 = 466,
    PCR_ETPUC26_PCSD2_GPIO467 = 467,
    PCR_ETPUC27_PCSD1_GPIO468 = 468,
    PCR_ETPUC28_PCSD0_GPIO469 = 469,
    PCR_ETPUC29_SCKD_GPIO470 = 470,
    PCR_ETPUC30_SOUTD_GPIO471 = 471,
    PCR_ETPUC31_SIND_GPIO472 = 472
  #else
    PCR_TODO
  #endif
} pcr_index;

typedef struct mpc55xx_siu_pcr_entry {
  uint16_t          pcr_idx; /* first PCR index for this entry      */
  uint16_t          pcr_cnt; /* PCR count using this entry          */
  union SIU_PCR_tag pcr_val; /* value to write to the PCR[idx++val] */
} mpc55xx_siu_pcr_entry_t;

rtems_status_code mpc55xx_siu_pcr_init(volatile struct SIU_tag *siu,
				       const mpc55xx_siu_pcr_entry_t *pcr_entry);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* LIBCPU_POWERPC_MPC55XX_SIU_H */
