/**
 * @file
 *
 * @ingroup RTEMSBSPsI386
 *
 * @brief Implementation of interrupt mechanisms for Time Test 27.
 */

/*
 *  tm27.h
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#ifndef _RTEMS_TMTEST27
#error "This is an RTEMS internal file you must not include directly."
#endif

#ifndef __tm27_h
#define __tm27_h

/*
 *  Define the interrupt mechanism for Time Test 27
 */

#define MUST_WAIT_FOR_INTERRUPT 0

#define Install_tm27_vector(handler) (void) handler

#define Cause_tm27_intr() __asm__ volatile("int $0x90" : :);

#define Clear_tm27_intr() /* empty */

#define Lower_tm27_intr() /* empty */

#endif
