/*-
 * Copyright (c) 2014 Ian Lepore <ian@freebsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: head/sys/arm/freescale/imx/imx_iomuxvar.h 321938 2017-08-02 18:28:06Z ian $
 */

#ifndef	IMX_IOMUXVAR_H
#define	IMX_IOMUXVAR_H

/*
 * IOMUX interface functions
 */
void     iomux_set_function(u_int pin, u_int fn);
void     iomux_set_pad(u_int pin, u_int cfg);
u_int    iomux_get_pad_config(u_int pin);

/*
 * The IOMUX Controller device has a small set of "general purpose registers" 
 * which control various aspects of SoC operation that really have nothing to do
 * with IO pin assignments or pad control.  These functions let other soc level
 * code manipulate these values.
 */
uint32_t imx_iomux_gpr_get(u_int regaddr);
void     imx_iomux_gpr_set(u_int regaddr, uint32_t val);
void     imx_iomux_gpr_set_masked(u_int regaddr, uint32_t clrbits, uint32_t setbits);

#endif
